// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/video/stitcher/v1/vod_configs.proto

package stitcherpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of the VOD config.
type VodConfig_State int32

const (
	// State is not specified.
	VodConfig_STATE_UNSPECIFIED VodConfig_State = 0
	// VOD config is being created.
	VodConfig_CREATING VodConfig_State = 1
	// VOD config is ready for use.
	VodConfig_READY VodConfig_State = 2
	// VOD config is queued up for deletion.
	VodConfig_DELETING VodConfig_State = 3
)

// Enum value maps for VodConfig_State.
var (
	VodConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "DELETING",
	}
	VodConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
		"DELETING":          3,
	}
)

func (x VodConfig_State) Enum() *VodConfig_State {
	p := new(VodConfig_State)
	*p = x
	return p
}

func (x VodConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VodConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_stitcher_v1_vod_configs_proto_enumTypes[0].Descriptor()
}

func (VodConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_video_stitcher_v1_vod_configs_proto_enumTypes[0]
}

func (x VodConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VodConfig_State.Descriptor instead.
func (VodConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescGZIP(), []int{0, 0}
}

// Metadata used to register VOD configs.
type VodConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the VOD config, in the form of
	// `projects/{project}/locations/{location}/vodConfigs/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Source URI for the VOD stream manifest.
	SourceUri string `protobuf:"bytes,2,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// Required. The default ad tag associated with this VOD config.
	AdTagUri string `protobuf:"bytes,3,opt,name=ad_tag_uri,json=adTagUri,proto3" json:"ad_tag_uri,omitempty"`
	// Optional. Google Ad Manager (GAM) metadata.
	GamVodConfig *GamVodConfig `protobuf:"bytes,4,opt,name=gam_vod_config,json=gamVodConfig,proto3" json:"gam_vod_config,omitempty"`
	// Output only. State of the VOD config.
	State VodConfig_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.video.stitcher.v1.VodConfig_State" json:"state,omitempty"`
	// Options for fetching source manifests and segments.
	SourceFetchOptions *FetchOptions `protobuf:"bytes,8,opt,name=source_fetch_options,json=sourceFetchOptions,proto3" json:"source_fetch_options,omitempty"`
}

func (x *VodConfig) Reset() {
	*x = VodConfig{}
	mi := &file_google_cloud_video_stitcher_v1_vod_configs_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VodConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VodConfig) ProtoMessage() {}

func (x *VodConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_vod_configs_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VodConfig.ProtoReflect.Descriptor instead.
func (*VodConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescGZIP(), []int{0}
}

func (x *VodConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VodConfig) GetSourceUri() string {
	if x != nil {
		return x.SourceUri
	}
	return ""
}

func (x *VodConfig) GetAdTagUri() string {
	if x != nil {
		return x.AdTagUri
	}
	return ""
}

func (x *VodConfig) GetGamVodConfig() *GamVodConfig {
	if x != nil {
		return x.GamVodConfig
	}
	return nil
}

func (x *VodConfig) GetState() VodConfig_State {
	if x != nil {
		return x.State
	}
	return VodConfig_STATE_UNSPECIFIED
}

func (x *VodConfig) GetSourceFetchOptions() *FetchOptions {
	if x != nil {
		return x.SourceFetchOptions
	}
	return nil
}

// Metadata used for GAM ad decisioning.
type GamVodConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Ad Manager network code to associate with the VOD config.
	NetworkCode string `protobuf:"bytes,1,opt,name=network_code,json=networkCode,proto3" json:"network_code,omitempty"`
}

func (x *GamVodConfig) Reset() {
	*x = GamVodConfig{}
	mi := &file_google_cloud_video_stitcher_v1_vod_configs_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GamVodConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GamVodConfig) ProtoMessage() {}

func (x *GamVodConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_vod_configs_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GamVodConfig.ProtoReflect.Descriptor instead.
func (*GamVodConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescGZIP(), []int{1}
}

func (x *GamVodConfig) GetNetworkCode() string {
	if x != nil {
		return x.NetworkCode
	}
	return ""
}

var File_google_cloud_video_stitcher_v1_vod_configs_proto protoreflect.FileDescriptor

var file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x66,
	0x65, 0x74, 0x63, 0x68, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xa5, 0x04, 0x0a, 0x09, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x21, 0x0a,
	0x0a, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x64, 0x54, 0x61, 0x67, 0x55, 0x72, 0x69,
	0x12, 0x57, 0x0a, 0x0e, 0x67, 0x61, 0x6d, 0x5f, 0x76, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x61, 0x6d, 0x56, 0x6f, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x67, 0x61, 0x6d,
	0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5e, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x45, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x3a, 0x6c, 0xea, 0x41,
	0x69, 0x0a, 0x26, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x76, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x76,
	0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0x36, 0x0a, 0x0c, 0x47, 0x61,
	0x6d, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f,
	0x64, 0x65, 0x42, 0x77, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x56, 0x6f, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x70, 0x62,
	0x3b, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescOnce sync.Once
	file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescData = file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDesc
)

func file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescGZIP() []byte {
	file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescData)
	})
	return file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDescData
}

var file_google_cloud_video_stitcher_v1_vod_configs_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_video_stitcher_v1_vod_configs_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_video_stitcher_v1_vod_configs_proto_goTypes = []any{
	(VodConfig_State)(0), // 0: google.cloud.video.stitcher.v1.VodConfig.State
	(*VodConfig)(nil),    // 1: google.cloud.video.stitcher.v1.VodConfig
	(*GamVodConfig)(nil), // 2: google.cloud.video.stitcher.v1.GamVodConfig
	(*FetchOptions)(nil), // 3: google.cloud.video.stitcher.v1.FetchOptions
}
var file_google_cloud_video_stitcher_v1_vod_configs_proto_depIdxs = []int32{
	2, // 0: google.cloud.video.stitcher.v1.VodConfig.gam_vod_config:type_name -> google.cloud.video.stitcher.v1.GamVodConfig
	0, // 1: google.cloud.video.stitcher.v1.VodConfig.state:type_name -> google.cloud.video.stitcher.v1.VodConfig.State
	3, // 2: google.cloud.video.stitcher.v1.VodConfig.source_fetch_options:type_name -> google.cloud.video.stitcher.v1.FetchOptions
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_video_stitcher_v1_vod_configs_proto_init() }
func file_google_cloud_video_stitcher_v1_vod_configs_proto_init() {
	if File_google_cloud_video_stitcher_v1_vod_configs_proto != nil {
		return
	}
	file_google_cloud_video_stitcher_v1_fetch_options_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_stitcher_v1_vod_configs_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_stitcher_v1_vod_configs_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_stitcher_v1_vod_configs_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_stitcher_v1_vod_configs_proto_msgTypes,
	}.Build()
	File_google_cloud_video_stitcher_v1_vod_configs_proto = out.File
	file_google_cloud_video_stitcher_v1_vod_configs_proto_rawDesc = nil
	file_google_cloud_video_stitcher_v1_vod_configs_proto_goTypes = nil
	file_google_cloud_video_stitcher_v1_vod_configs_proto_depIdxs = nil
}
