// Code generated by smithy-go-codegen DO NOT EDIT.

package autoscaling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/autoscaling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates a warm pool for the specified Auto Scaling group. A warm
// pool is a pool of pre-initialized EC2 instances that sits alongside the Auto
// Scaling group. Whenever your application needs to scale out, the Auto Scaling
// group can draw on the warm pool to meet its new desired capacity.
//
// This operation must be called from the Region in which the Auto Scaling group
// was created.
//
// You can view the instances in the warm pool using the DescribeWarmPool API call. If you are no
// longer using a warm pool, you can delete it by calling the DeleteWarmPoolAPI.
//
// For more information, see [Warm pools for Amazon EC2 Auto Scaling] in the Amazon EC2 Auto Scaling User Guide.
//
// [Warm pools for Amazon EC2 Auto Scaling]: https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html
func (c *Client) PutWarmPool(ctx context.Context, params *PutWarmPoolInput, optFns ...func(*Options)) (*PutWarmPoolOutput, error) {
	if params == nil {
		params = &PutWarmPoolInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutWarmPool", params, optFns, c.addOperationPutWarmPoolMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutWarmPoolOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutWarmPoolInput struct {

	// The name of the Auto Scaling group.
	//
	// This member is required.
	AutoScalingGroupName *string

	// Indicates whether instances in the Auto Scaling group can be returned to the
	// warm pool on scale in. The default is to terminate instances in the Auto Scaling
	// group when the group scales in.
	InstanceReusePolicy *types.InstanceReusePolicy

	// Specifies the maximum number of instances that are allowed to be in the warm
	// pool or in any state except Terminated for the Auto Scaling group. This is an
	// optional property. Specify it only if you do not want the warm pool size to be
	// determined by the difference between the group's maximum capacity and its
	// desired capacity.
	//
	// If a value for MaxGroupPreparedCapacity is not specified, Amazon EC2 Auto
	// Scaling launches and maintains the difference between the group's maximum
	// capacity and its desired capacity. If you specify a value for
	// MaxGroupPreparedCapacity , Amazon EC2 Auto Scaling uses the difference between
	// the MaxGroupPreparedCapacity and the desired capacity instead.
	//
	// The size of the warm pool is dynamic. Only when MaxGroupPreparedCapacity and
	// MinSize are set to the same value does the warm pool have an absolute size.
	//
	// If the desired capacity of the Auto Scaling group is higher than the
	// MaxGroupPreparedCapacity , the capacity of the warm pool is 0, unless you
	// specify a value for MinSize . To remove a value that you previously set, include
	// the property but specify -1 for the value.
	MaxGroupPreparedCapacity *int32

	// Specifies the minimum number of instances to maintain in the warm pool. This
	// helps you to ensure that there is always a certain number of warmed instances
	// available to handle traffic spikes. Defaults to 0 if not specified.
	MinSize *int32

	// Sets the instance state to transition to after the lifecycle actions are
	// complete. Default is Stopped .
	PoolState types.WarmPoolState

	noSmithyDocumentSerde
}

type PutWarmPoolOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutWarmPoolMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpPutWarmPool{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpPutWarmPool{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutWarmPool"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpPutWarmPoolValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutWarmPool(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutWarmPool(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutWarmPool",
	}
}
