---
title: v1.14.0
weight: 998986000
---

## Upgrade K8s versions to use 1.22 (golang/v3)

Note that to ensure the backwards compatibility SDK tool will try to downgrade the versions used if you need to still scaffold the v1beta1 for CRDs and Webhooks to publish your solutions into older cluster versions. However, note that this version is no longer supported in Kubernetes 1.22+, `sigs.k8s.io/controller-runtime v0.10.0` or `controller-gen v0.7.0`.
Following are the changes to be addressed in your `Makefile` and `go.mod` file if you are not using the `v1beta1` K8s APIs which are no longer supported from k8s `1.22` version.
1) Update your `go.mod` file to upgrade the dependencies and run `go mod tidy` to download then
   ```
   k8s.io/api v0.22.1
   k8s.io/apimachinery v0.22.1
   k8s.io/client-go v0.22.1
   sigs.k8s.io/controller-runtime v0.10.0
   ```
2) Update your Makefile by making the following replacements:
   ```diff
   - ENVTEST_K8S_VERSION = 1.21
   + ENVTEST_K8S_VERSION = 1.22
   ```
   ```diff
   - $(CONTROLLER_GEN) $(CRD_OPTIONS) rbac:roleName=manager-role webhook paths="./..." output:crd:artifacts:config=config/crd/bases
   + $(CONTROLLER_GEN) rbac:roleName=manager-role crd webhook paths="./..." output:crd:artifacts:config=config/crd/bases
   ```

3) Remove from the `Makefile` the `CRD_OPTIONS`, see below:
   ```
   # Produce CRDs that work back to Kubernetes 1.11 (no version conversion)
   CRD_OPTIONS ?= "crd:trivialVersions=true,preserveUnknownFields=false"
   ```
4) Replace your `admissionReviewVersions={v1,v1beta1}` markers with `admissionReviewVersions=v1`
5) Run `make manifest` to re-generate your manifests with latest versions.

_See [#5228](https://github.com/operator-framework/operator-sdk/pull/5228) for more details._

## For Ansible-based Operators, update ansible collection `community.kubernetes` to `kubernetes.core`

Add the ``kubernetes.core`` collection (>= 2.2.0) to the requrements.yml file
- name: kubernetes.core
  version: "2.2.0"

_See [#5249](https://github.com/operator-framework/operator-sdk/pull/5249) for more details._
