//
// Copyright (C) 2010 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Update file format: An update file contains all the operations needed
// to update a system to a specific version. It can be a full payload which
// can update from any version, or a delta payload which can only update
// from a specific version.
// The update format is represented by this struct pseudocode:
// struct delta_update_file {
//   char magic[4] = "CrAU";
//   uint64 file_format_version;  // payload major version
//   uint64 manifest_size;  // Size of protobuf DeltaArchiveManifest
//
//   // Only present if format_version >= 2:
//   uint32 metadata_signature_size;
//
//   // The DeltaArchiveManifest protobuf serialized, not compressed.
//   char manifest[manifest_size];
//
//   // The signature of the metadata (from the beginning of the payload up to
//   // this location, not including the signature itself). This is a serialized
//   // Signatures message.
//   char metadata_signature_message[metadata_signature_size];
//
//   // Data blobs for files, no specific format. The specific offset
//   // and length of each data blob is recorded in the DeltaArchiveManifest.
//   struct {
//     char data[];
//   } blobs[];
//
//   // The signature of the entire payload, everything up to this location,
//   // except that metadata_signature_message is skipped to simplify signing
//   // process. These two are not signed:
//   uint64 payload_signatures_message_size;
//   // This is a serialized Signatures message.
//   char payload_signatures_message[payload_signatures_message_size];
//
// };

// The DeltaArchiveManifest protobuf is an ordered list of InstallOperation
// objects. These objects are stored in a linear array in the
// DeltaArchiveManifest. Each operation is applied in order by the client.

// The DeltaArchiveManifest also contains the initial and final
// checksums for the device.

// The client will perform each InstallOperation in order, beginning even
// before the entire delta file is downloaded (but after at least the
// protobuf is downloaded). The types of operations are explained:
// - REPLACE: Replace the dst_extents on the drive with the attached data,
//   zero padding out to block size.
// - REPLACE_BZ: bzip2-uncompress the attached data and write it into
//   dst_extents on the drive, zero padding to block size.
// - MOVE: Copy the data in src_extents to dst_extents. Extents may overlap,
//   so it may be desirable to read all src_extents data into memory before
//   writing it out. (deprecated)
// - SOURCE_COPY: Copy the data in src_extents in the old partition to
//   dst_extents in the new partition. There's no overlapping of data because
//   the extents are in different partitions.
// - BSDIFF: Read src_length bytes from src_extents into memory, perform
//   bspatch with attached data, write new data to dst_extents, zero padding
//   to block size. (deprecated)
// - SOURCE_BSDIFF: Read the data in src_extents in the old partition, perform
//   bspatch with the attached data and write the new data to dst_extents in the
//   new partition.
// - ZERO: Write zeros to the destination dst_extents.
// - DISCARD: Discard the destination dst_extents blocks on the physical medium.
//   the data read from those blocks is undefined.
// - REPLACE_XZ: Replace the dst_extents with the contents of the attached
//   xz file after decompression. The xz file should only use crc32 or no crc at
//   all to be compatible with xz-embedded.
// - PUFFDIFF: Read the data in src_extents in the old partition, perform
//   puffpatch with the attached data and write the new data to dst_extents in
//   the new partition.
//
// The operations allowed in the payload (supported by the client) depend on the
// major and minor version. See InstallOperation.Type below for details.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v3.21.12
// source: update_metadata.proto

package chromeos_update_engine

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type InstallOperation_Type int32

const (
	InstallOperation_REPLACE    InstallOperation_Type = 0 // Replace destination extents w/ attached data.
	InstallOperation_REPLACE_BZ InstallOperation_Type = 1 // Replace destination extents w/ attached bzipped data.
	// Deprecated: Marked as deprecated in update_metadata.proto.
	InstallOperation_MOVE InstallOperation_Type = 2 // Move source extents to target extents.
	// Deprecated: Marked as deprecated in update_metadata.proto.
	InstallOperation_BSDIFF InstallOperation_Type = 3 // The data is a bsdiff binary diff.
	// On minor version 2 or newer, these operations are supported:
	InstallOperation_SOURCE_COPY   InstallOperation_Type = 4 // Copy from source to target partition
	InstallOperation_SOURCE_BSDIFF InstallOperation_Type = 5 // Like BSDIFF, but read from source partition
	// On minor version 3 or newer and on major version 2 or newer, these
	// operations are supported:
	InstallOperation_REPLACE_XZ InstallOperation_Type = 8 // Replace destination extents w/ attached xz data.
	// On minor version 4 or newer, these operations are supported:
	InstallOperation_ZERO          InstallOperation_Type = 6  // Write zeros in the destination.
	InstallOperation_DISCARD       InstallOperation_Type = 7  // Discard the destination blocks, reading as undefined.
	InstallOperation_BROTLI_BSDIFF InstallOperation_Type = 10 // Like SOURCE_BSDIFF, but compressed with brotli.
	// On minor version 5 or newer, these operations are supported:
	InstallOperation_PUFFDIFF InstallOperation_Type = 9 // The data is in puffdiff format.
	// On minor version 8 or newer, these operations are supported:
	InstallOperation_ZUCCHINI InstallOperation_Type = 11
	// On minor version 9 or newer, these operations are supported:
	InstallOperation_LZ4DIFF_BSDIFF   InstallOperation_Type = 12
	InstallOperation_LZ4DIFF_PUFFDIFF InstallOperation_Type = 13
	InstallOperation_ZSTD             InstallOperation_Type = 14
)

// Enum value maps for InstallOperation_Type.
var (
	InstallOperation_Type_name = map[int32]string{
		0:  "REPLACE",
		1:  "REPLACE_BZ",
		2:  "MOVE",
		3:  "BSDIFF",
		4:  "SOURCE_COPY",
		5:  "SOURCE_BSDIFF",
		8:  "REPLACE_XZ",
		6:  "ZERO",
		7:  "DISCARD",
		10: "BROTLI_BSDIFF",
		9:  "PUFFDIFF",
		11: "ZUCCHINI",
		12: "LZ4DIFF_BSDIFF",
		13: "LZ4DIFF_PUFFDIFF",
		14: "ZSTD",
	}
	InstallOperation_Type_value = map[string]int32{
		"REPLACE":          0,
		"REPLACE_BZ":       1,
		"MOVE":             2,
		"BSDIFF":           3,
		"SOURCE_COPY":      4,
		"SOURCE_BSDIFF":    5,
		"REPLACE_XZ":       8,
		"ZERO":             6,
		"DISCARD":          7,
		"BROTLI_BSDIFF":    10,
		"PUFFDIFF":         9,
		"ZUCCHINI":         11,
		"LZ4DIFF_BSDIFF":   12,
		"LZ4DIFF_PUFFDIFF": 13,
		"ZSTD":             14,
	}
)

func (x InstallOperation_Type) Enum() *InstallOperation_Type {
	p := new(InstallOperation_Type)
	*p = x
	return p
}

func (x InstallOperation_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstallOperation_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_update_metadata_proto_enumTypes[0].Descriptor()
}

func (InstallOperation_Type) Type() protoreflect.EnumType {
	return &file_update_metadata_proto_enumTypes[0]
}

func (x InstallOperation_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *InstallOperation_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = InstallOperation_Type(num)
	return nil
}

// Deprecated: Use InstallOperation_Type.Descriptor instead.
func (InstallOperation_Type) EnumDescriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{3, 0}
}

type CowMergeOperation_Type int32

const (
	CowMergeOperation_COW_COPY    CowMergeOperation_Type = 0 // identical blocks
	CowMergeOperation_COW_XOR     CowMergeOperation_Type = 1 // used when src/dst blocks are highly similar
	CowMergeOperation_COW_REPLACE CowMergeOperation_Type = 2 // Raw replace operation
)

// Enum value maps for CowMergeOperation_Type.
var (
	CowMergeOperation_Type_name = map[int32]string{
		0: "COW_COPY",
		1: "COW_XOR",
		2: "COW_REPLACE",
	}
	CowMergeOperation_Type_value = map[string]int32{
		"COW_COPY":    0,
		"COW_XOR":     1,
		"COW_REPLACE": 2,
	}
)

func (x CowMergeOperation_Type) Enum() *CowMergeOperation_Type {
	p := new(CowMergeOperation_Type)
	*p = x
	return p
}

func (x CowMergeOperation_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CowMergeOperation_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_update_metadata_proto_enumTypes[1].Descriptor()
}

func (CowMergeOperation_Type) Type() protoreflect.EnumType {
	return &file_update_metadata_proto_enumTypes[1]
}

func (x CowMergeOperation_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *CowMergeOperation_Type) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = CowMergeOperation_Type(num)
	return nil
}

// Deprecated: Use CowMergeOperation_Type.Descriptor instead.
func (CowMergeOperation_Type) EnumDescriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{4, 0}
}

type Extent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	StartBlock *uint64 `protobuf:"varint,1,opt,name=start_block,json=startBlock" json:"start_block,omitempty"`
	NumBlocks  *uint64 `protobuf:"varint,2,opt,name=num_blocks,json=numBlocks" json:"num_blocks,omitempty"`
}

func (x *Extent) Reset() {
	*x = Extent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Extent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Extent) ProtoMessage() {}

func (x *Extent) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Extent.ProtoReflect.Descriptor instead.
func (*Extent) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *Extent) GetStartBlock() uint64 {
	if x != nil && x.StartBlock != nil {
		return *x.StartBlock
	}
	return 0
}

func (x *Extent) GetNumBlocks() uint64 {
	if x != nil && x.NumBlocks != nil {
		return *x.NumBlocks
	}
	return 0
}

type Signatures struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Signatures []*Signatures_Signature `protobuf:"bytes,1,rep,name=signatures" json:"signatures,omitempty"`
}

func (x *Signatures) Reset() {
	*x = Signatures{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Signatures) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signatures) ProtoMessage() {}

func (x *Signatures) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signatures.ProtoReflect.Descriptor instead.
func (*Signatures) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{1}
}

func (x *Signatures) GetSignatures() []*Signatures_Signature {
	if x != nil {
		return x.Signatures
	}
	return nil
}

type PartitionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Size *uint64 `protobuf:"varint,1,opt,name=size" json:"size,omitempty"`
	Hash []byte  `protobuf:"bytes,2,opt,name=hash" json:"hash,omitempty"`
}

func (x *PartitionInfo) Reset() {
	*x = PartitionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionInfo) ProtoMessage() {}

func (x *PartitionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionInfo.ProtoReflect.Descriptor instead.
func (*PartitionInfo) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{2}
}

func (x *PartitionInfo) GetSize() uint64 {
	if x != nil && x.Size != nil {
		return *x.Size
	}
	return 0
}

func (x *PartitionInfo) GetHash() []byte {
	if x != nil {
		return x.Hash
	}
	return nil
}

type InstallOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type *InstallOperation_Type `protobuf:"varint,1,req,name=type,enum=chromeos_update_engine.InstallOperation_Type" json:"type,omitempty"`
	// Only minor version 6 or newer support 64 bits |data_offset| and
	// |data_length|, older client will read them as uint32.
	// The offset into the delta file (after the protobuf)
	// where the data (if any) is stored
	DataOffset *uint64 `protobuf:"varint,2,opt,name=data_offset,json=dataOffset" json:"data_offset,omitempty"`
	// The length of the data in the delta file
	DataLength *uint64 `protobuf:"varint,3,opt,name=data_length,json=dataLength" json:"data_length,omitempty"`
	// Ordered list of extents that are read from (if any) and written to.
	SrcExtents []*Extent `protobuf:"bytes,4,rep,name=src_extents,json=srcExtents" json:"src_extents,omitempty"`
	// Byte length of src, equal to the number of blocks in src_extents *
	// block_size. It is used for BSDIFF and SOURCE_BSDIFF, because we need to
	// pass that external program the number of bytes to read from the blocks we
	// pass it.  This is not used in any other operation.
	SrcLength  *uint64   `protobuf:"varint,5,opt,name=src_length,json=srcLength" json:"src_length,omitempty"`
	DstExtents []*Extent `protobuf:"bytes,6,rep,name=dst_extents,json=dstExtents" json:"dst_extents,omitempty"`
	// Byte length of dst, equal to the number of blocks in dst_extents *
	// block_size. Used for BSDIFF and SOURCE_BSDIFF, but not in any other
	// operation.
	DstLength *uint64 `protobuf:"varint,7,opt,name=dst_length,json=dstLength" json:"dst_length,omitempty"`
	// Optional SHA 256 hash of the blob associated with this operation.
	// This is used as a primary validation for http-based downloads and
	// as a defense-in-depth validation for https-based downloads. If
	// the operation doesn't refer to any blob, this field will have
	// zero bytes.
	DataSha256Hash []byte `protobuf:"bytes,8,opt,name=data_sha256_hash,json=dataSha256Hash" json:"data_sha256_hash,omitempty"`
	// Indicates the SHA 256 hash of the source data referenced in src_extents at
	// the time of applying the operation. If present, the update_engine daemon
	// MUST read and verify the source data before applying the operation.
	SrcSha256Hash []byte `protobuf:"bytes,9,opt,name=src_sha256_hash,json=srcSha256Hash" json:"src_sha256_hash,omitempty"`
}

func (x *InstallOperation) Reset() {
	*x = InstallOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallOperation) ProtoMessage() {}

func (x *InstallOperation) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallOperation.ProtoReflect.Descriptor instead.
func (*InstallOperation) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{3}
}

func (x *InstallOperation) GetType() InstallOperation_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return InstallOperation_REPLACE
}

func (x *InstallOperation) GetDataOffset() uint64 {
	if x != nil && x.DataOffset != nil {
		return *x.DataOffset
	}
	return 0
}

func (x *InstallOperation) GetDataLength() uint64 {
	if x != nil && x.DataLength != nil {
		return *x.DataLength
	}
	return 0
}

func (x *InstallOperation) GetSrcExtents() []*Extent {
	if x != nil {
		return x.SrcExtents
	}
	return nil
}

func (x *InstallOperation) GetSrcLength() uint64 {
	if x != nil && x.SrcLength != nil {
		return *x.SrcLength
	}
	return 0
}

func (x *InstallOperation) GetDstExtents() []*Extent {
	if x != nil {
		return x.DstExtents
	}
	return nil
}

func (x *InstallOperation) GetDstLength() uint64 {
	if x != nil && x.DstLength != nil {
		return *x.DstLength
	}
	return 0
}

func (x *InstallOperation) GetDataSha256Hash() []byte {
	if x != nil {
		return x.DataSha256Hash
	}
	return nil
}

func (x *InstallOperation) GetSrcSha256Hash() []byte {
	if x != nil {
		return x.SrcSha256Hash
	}
	return nil
}

// Hints to VAB snapshot to skip writing some blocks if these blocks are
// identical to the ones on the source image. The src & dst extents for each
// CowMergeOperation should be contiguous, and they're a subset of an OTA
// InstallOperation.
// During merge time, we need to follow the pre-computed sequence to avoid
// read after write, similar to the inplace update schema.
type CowMergeOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type      *CowMergeOperation_Type `protobuf:"varint,1,opt,name=type,enum=chromeos_update_engine.CowMergeOperation_Type" json:"type,omitempty"`
	SrcExtent *Extent                 `protobuf:"bytes,2,opt,name=src_extent,json=srcExtent" json:"src_extent,omitempty"`
	DstExtent *Extent                 `protobuf:"bytes,3,opt,name=dst_extent,json=dstExtent" json:"dst_extent,omitempty"`
	// For COW_XOR, source location might be unaligned, so this field is in range
	// [0, block_size), representing how much should the src_extent shift toward
	// larger block number. If this field is non-zero, then src_extent will
	// include 1 extra block in the end, as the merge op actually references the
	// first |src_offset| bytes of that extra block. For example, if |dst_extent|
	// is [10, 15], |src_offset| is 500, then src_extent might look like [25, 31].
	// Note that |src_extent| contains 1 extra block than the |dst_extent|.
	SrcOffset *uint32 `protobuf:"varint,4,opt,name=src_offset,json=srcOffset" json:"src_offset,omitempty"`
}

func (x *CowMergeOperation) Reset() {
	*x = CowMergeOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CowMergeOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CowMergeOperation) ProtoMessage() {}

func (x *CowMergeOperation) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CowMergeOperation.ProtoReflect.Descriptor instead.
func (*CowMergeOperation) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{4}
}

func (x *CowMergeOperation) GetType() CowMergeOperation_Type {
	if x != nil && x.Type != nil {
		return *x.Type
	}
	return CowMergeOperation_COW_COPY
}

func (x *CowMergeOperation) GetSrcExtent() *Extent {
	if x != nil {
		return x.SrcExtent
	}
	return nil
}

func (x *CowMergeOperation) GetDstExtent() *Extent {
	if x != nil {
		return x.DstExtent
	}
	return nil
}

func (x *CowMergeOperation) GetSrcOffset() uint32 {
	if x != nil && x.SrcOffset != nil {
		return *x.SrcOffset
	}
	return 0
}

// Describes the update to apply to a single partition.
type PartitionUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A platform-specific name to identify the partition set being updated. For
	// example, in Chrome OS this could be "ROOT" or "KERNEL".
	PartitionName *string `protobuf:"bytes,1,req,name=partition_name,json=partitionName" json:"partition_name,omitempty"`
	// Whether this partition carries a filesystem with post-install program that
	// must be run to finalize the update process. See also |postinstall_path| and
	// |filesystem_type|.
	RunPostinstall *bool `protobuf:"varint,2,opt,name=run_postinstall,json=runPostinstall" json:"run_postinstall,omitempty"`
	// The path of the executable program to run during the post-install step,
	// relative to the root of this filesystem. If not set, the default "postinst"
	// will be used. This setting is only used when |run_postinstall| is set and
	// true.
	PostinstallPath *string `protobuf:"bytes,3,opt,name=postinstall_path,json=postinstallPath" json:"postinstall_path,omitempty"`
	// The filesystem type as passed to the mount(2) syscall when mounting the new
	// filesystem to run the post-install program. If not set, a fixed list of
	// filesystems will be attempted. This setting is only used if
	// |run_postinstall| is set and true.
	FilesystemType *string `protobuf:"bytes,4,opt,name=filesystem_type,json=filesystemType" json:"filesystem_type,omitempty"`
	// If present, a list of signatures of the new_partition_info.hash signed with
	// different keys. If the update_engine daemon requires vendor-signed images
	// and has its public key installed, one of the signatures should be valid
	// for /postinstall to run.
	NewPartitionSignature []*Signatures_Signature `protobuf:"bytes,5,rep,name=new_partition_signature,json=newPartitionSignature" json:"new_partition_signature,omitempty"`
	OldPartitionInfo      *PartitionInfo          `protobuf:"bytes,6,opt,name=old_partition_info,json=oldPartitionInfo" json:"old_partition_info,omitempty"`
	NewPartitionInfo      *PartitionInfo          `protobuf:"bytes,7,opt,name=new_partition_info,json=newPartitionInfo" json:"new_partition_info,omitempty"`
	// The list of operations to be performed to apply this PartitionUpdate. The
	// associated operation blobs (in operations[i].data_offset, data_length)
	// should be stored contiguously and in the same order.
	Operations []*InstallOperation `protobuf:"bytes,8,rep,name=operations" json:"operations,omitempty"`
	// Whether a failure in the postinstall step for this partition should be
	// ignored.
	PostinstallOptional *bool `protobuf:"varint,9,opt,name=postinstall_optional,json=postinstallOptional" json:"postinstall_optional,omitempty"`
	// The extent for data covered by verity hash tree.
	HashTreeDataExtent *Extent `protobuf:"bytes,10,opt,name=hash_tree_data_extent,json=hashTreeDataExtent" json:"hash_tree_data_extent,omitempty"`
	// The extent to store verity hash tree.
	HashTreeExtent *Extent `protobuf:"bytes,11,opt,name=hash_tree_extent,json=hashTreeExtent" json:"hash_tree_extent,omitempty"`
	// The hash algorithm used in verity hash tree.
	HashTreeAlgorithm *string `protobuf:"bytes,12,opt,name=hash_tree_algorithm,json=hashTreeAlgorithm" json:"hash_tree_algorithm,omitempty"`
	// The salt used for verity hash tree.
	HashTreeSalt []byte `protobuf:"bytes,13,opt,name=hash_tree_salt,json=hashTreeSalt" json:"hash_tree_salt,omitempty"`
	// The extent for data covered by FEC.
	FecDataExtent *Extent `protobuf:"bytes,14,opt,name=fec_data_extent,json=fecDataExtent" json:"fec_data_extent,omitempty"`
	// The extent to store FEC.
	FecExtent *Extent `protobuf:"bytes,15,opt,name=fec_extent,json=fecExtent" json:"fec_extent,omitempty"`
	// The number of FEC roots.
	FecRoots *uint32 `protobuf:"varint,16,opt,name=fec_roots,json=fecRoots,def=2" json:"fec_roots,omitempty"`
	// Per-partition version used for downgrade detection, added
	// as an effort to support partial updates. For most partitions,
	// this is the build timestamp.
	Version *string `protobuf:"bytes,17,opt,name=version" json:"version,omitempty"`
	// A sorted list of CowMergeOperation. When writing cow, we can choose to
	// skip writing the raw bytes for these extents. During snapshot merge, the
	// bytes will read from the source partitions instead.
	MergeOperations []*CowMergeOperation `protobuf:"bytes,18,rep,name=merge_operations,json=mergeOperations" json:"merge_operations,omitempty"`
	// Estimated size for COW image. This is used by libsnapshot
	// as a hint. If set to 0, libsnapshot should use alternative
	// methods for estimating size.
	EstimateCowSize *uint64 `protobuf:"varint,19,opt,name=estimate_cow_size,json=estimateCowSize" json:"estimate_cow_size,omitempty"`
	// Information about the cow used by Cow Writer to specify
	// number of cow operations to be written
	EstimateOpCountMax *uint64 `protobuf:"varint,20,opt,name=estimate_op_count_max,json=estimateOpCountMax" json:"estimate_op_count_max,omitempty"`
}

// Default values for PartitionUpdate fields.
const (
	Default_PartitionUpdate_FecRoots = uint32(2)
)

func (x *PartitionUpdate) Reset() {
	*x = PartitionUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionUpdate) ProtoMessage() {}

func (x *PartitionUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionUpdate.ProtoReflect.Descriptor instead.
func (*PartitionUpdate) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{5}
}

func (x *PartitionUpdate) GetPartitionName() string {
	if x != nil && x.PartitionName != nil {
		return *x.PartitionName
	}
	return ""
}

func (x *PartitionUpdate) GetRunPostinstall() bool {
	if x != nil && x.RunPostinstall != nil {
		return *x.RunPostinstall
	}
	return false
}

func (x *PartitionUpdate) GetPostinstallPath() string {
	if x != nil && x.PostinstallPath != nil {
		return *x.PostinstallPath
	}
	return ""
}

func (x *PartitionUpdate) GetFilesystemType() string {
	if x != nil && x.FilesystemType != nil {
		return *x.FilesystemType
	}
	return ""
}

func (x *PartitionUpdate) GetNewPartitionSignature() []*Signatures_Signature {
	if x != nil {
		return x.NewPartitionSignature
	}
	return nil
}

func (x *PartitionUpdate) GetOldPartitionInfo() *PartitionInfo {
	if x != nil {
		return x.OldPartitionInfo
	}
	return nil
}

func (x *PartitionUpdate) GetNewPartitionInfo() *PartitionInfo {
	if x != nil {
		return x.NewPartitionInfo
	}
	return nil
}

func (x *PartitionUpdate) GetOperations() []*InstallOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *PartitionUpdate) GetPostinstallOptional() bool {
	if x != nil && x.PostinstallOptional != nil {
		return *x.PostinstallOptional
	}
	return false
}

func (x *PartitionUpdate) GetHashTreeDataExtent() *Extent {
	if x != nil {
		return x.HashTreeDataExtent
	}
	return nil
}

func (x *PartitionUpdate) GetHashTreeExtent() *Extent {
	if x != nil {
		return x.HashTreeExtent
	}
	return nil
}

func (x *PartitionUpdate) GetHashTreeAlgorithm() string {
	if x != nil && x.HashTreeAlgorithm != nil {
		return *x.HashTreeAlgorithm
	}
	return ""
}

func (x *PartitionUpdate) GetHashTreeSalt() []byte {
	if x != nil {
		return x.HashTreeSalt
	}
	return nil
}

func (x *PartitionUpdate) GetFecDataExtent() *Extent {
	if x != nil {
		return x.FecDataExtent
	}
	return nil
}

func (x *PartitionUpdate) GetFecExtent() *Extent {
	if x != nil {
		return x.FecExtent
	}
	return nil
}

func (x *PartitionUpdate) GetFecRoots() uint32 {
	if x != nil && x.FecRoots != nil {
		return *x.FecRoots
	}
	return Default_PartitionUpdate_FecRoots
}

func (x *PartitionUpdate) GetVersion() string {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return ""
}

func (x *PartitionUpdate) GetMergeOperations() []*CowMergeOperation {
	if x != nil {
		return x.MergeOperations
	}
	return nil
}

func (x *PartitionUpdate) GetEstimateCowSize() uint64 {
	if x != nil && x.EstimateCowSize != nil {
		return *x.EstimateCowSize
	}
	return 0
}

func (x *PartitionUpdate) GetEstimateOpCountMax() uint64 {
	if x != nil && x.EstimateOpCountMax != nil {
		return *x.EstimateOpCountMax
	}
	return 0
}

type DynamicPartitionGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the group.
	Name *string `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	// Maximum size of the group. The sum of sizes of all partitions in the group
	// must not exceed the maximum size of the group.
	Size *uint64 `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
	// A list of partitions that belong to the group.
	PartitionNames []string `protobuf:"bytes,3,rep,name=partition_names,json=partitionNames" json:"partition_names,omitempty"`
}

func (x *DynamicPartitionGroup) Reset() {
	*x = DynamicPartitionGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicPartitionGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicPartitionGroup) ProtoMessage() {}

func (x *DynamicPartitionGroup) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicPartitionGroup.ProtoReflect.Descriptor instead.
func (*DynamicPartitionGroup) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{6}
}

func (x *DynamicPartitionGroup) GetName() string {
	if x != nil && x.Name != nil {
		return *x.Name
	}
	return ""
}

func (x *DynamicPartitionGroup) GetSize() uint64 {
	if x != nil && x.Size != nil {
		return *x.Size
	}
	return 0
}

func (x *DynamicPartitionGroup) GetPartitionNames() []string {
	if x != nil {
		return x.PartitionNames
	}
	return nil
}

type VABCFeatureSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Threaded    *bool `protobuf:"varint,1,opt,name=threaded" json:"threaded,omitempty"`
	BatchWrites *bool `protobuf:"varint,2,opt,name=batch_writes,json=batchWrites" json:"batch_writes,omitempty"`
}

func (x *VABCFeatureSet) Reset() {
	*x = VABCFeatureSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VABCFeatureSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VABCFeatureSet) ProtoMessage() {}

func (x *VABCFeatureSet) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VABCFeatureSet.ProtoReflect.Descriptor instead.
func (*VABCFeatureSet) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{7}
}

func (x *VABCFeatureSet) GetThreaded() bool {
	if x != nil && x.Threaded != nil {
		return *x.Threaded
	}
	return false
}

func (x *VABCFeatureSet) GetBatchWrites() bool {
	if x != nil && x.BatchWrites != nil {
		return *x.BatchWrites
	}
	return false
}

// Metadata related to all dynamic partitions.
type DynamicPartitionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All updatable groups present in |partitions| of this DeltaArchiveManifest.
	//   - If an updatable group is on the device but not in the manifest, it is
	//     not updated. Hence, the group will not be resized, and partitions cannot
	//     be added to or removed from the group.
	//   - If an updatable group is in the manifest but not on the device, the group
	//     is added to the device.
	Groups []*DynamicPartitionGroup `protobuf:"bytes,1,rep,name=groups" json:"groups,omitempty"`
	// Whether dynamic partitions have snapshots during the update. If this is
	// set to true, the update_engine daemon creates snapshots for all dynamic
	// partitions if possible. If this is unset, the update_engine daemon MUST
	// NOT create snapshots for dynamic partitions.
	SnapshotEnabled *bool `protobuf:"varint,2,opt,name=snapshot_enabled,json=snapshotEnabled" json:"snapshot_enabled,omitempty"`
	// If this is set to false, update_engine should not use VABC regardless. If
	// this is set to true, update_engine may choose to use VABC if device
	// supports it, but not guaranteed.
	// VABC stands for Virtual AB Compression
	VabcEnabled *bool `protobuf:"varint,3,opt,name=vabc_enabled,json=vabcEnabled" json:"vabc_enabled,omitempty"`
	// The compression algorithm used by VABC. Available ones are "gz", "brotli".
	// See system/core/fs_mgr/libsnapshot/cow_writer.cpp for available options,
	// as this parameter is ultimated forwarded to libsnapshot's CowWriter
	VabcCompressionParam *string `protobuf:"bytes,4,opt,name=vabc_compression_param,json=vabcCompressionParam" json:"vabc_compression_param,omitempty"`
	// COW version used by VABC. The represents the major version in the COW
	// header
	CowVersion *uint32 `protobuf:"varint,5,opt,name=cow_version,json=cowVersion" json:"cow_version,omitempty"`
	// A collection of knobs to tune Virtual AB Compression
	VabcFeatureSet *VABCFeatureSet `protobuf:"bytes,6,opt,name=vabc_feature_set,json=vabcFeatureSet" json:"vabc_feature_set,omitempty"`
	// Max bytes to be compressed at once during ota. Options: 4k, 8k, 16k, 32k,
	// 64k, 128k
	CompressionFactor *uint64 `protobuf:"varint,7,opt,name=compression_factor,json=compressionFactor" json:"compression_factor,omitempty"`
}

func (x *DynamicPartitionMetadata) Reset() {
	*x = DynamicPartitionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynamicPartitionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicPartitionMetadata) ProtoMessage() {}

func (x *DynamicPartitionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicPartitionMetadata.ProtoReflect.Descriptor instead.
func (*DynamicPartitionMetadata) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{8}
}

func (x *DynamicPartitionMetadata) GetGroups() []*DynamicPartitionGroup {
	if x != nil {
		return x.Groups
	}
	return nil
}

func (x *DynamicPartitionMetadata) GetSnapshotEnabled() bool {
	if x != nil && x.SnapshotEnabled != nil {
		return *x.SnapshotEnabled
	}
	return false
}

func (x *DynamicPartitionMetadata) GetVabcEnabled() bool {
	if x != nil && x.VabcEnabled != nil {
		return *x.VabcEnabled
	}
	return false
}

func (x *DynamicPartitionMetadata) GetVabcCompressionParam() string {
	if x != nil && x.VabcCompressionParam != nil {
		return *x.VabcCompressionParam
	}
	return ""
}

func (x *DynamicPartitionMetadata) GetCowVersion() uint32 {
	if x != nil && x.CowVersion != nil {
		return *x.CowVersion
	}
	return 0
}

func (x *DynamicPartitionMetadata) GetVabcFeatureSet() *VABCFeatureSet {
	if x != nil {
		return x.VabcFeatureSet
	}
	return nil
}

func (x *DynamicPartitionMetadata) GetCompressionFactor() uint64 {
	if x != nil && x.CompressionFactor != nil {
		return *x.CompressionFactor
	}
	return 0
}

// Definition has been duplicated from
// $ANDROID_BUILD_TOP/build/tools/releasetools/ota_metadata.proto. Keep in sync.
type ApexInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PackageName      *string `protobuf:"bytes,1,opt,name=package_name,json=packageName" json:"package_name,omitempty"`
	Version          *int64  `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
	IsCompressed     *bool   `protobuf:"varint,3,opt,name=is_compressed,json=isCompressed" json:"is_compressed,omitempty"`
	DecompressedSize *int64  `protobuf:"varint,4,opt,name=decompressed_size,json=decompressedSize" json:"decompressed_size,omitempty"`
}

func (x *ApexInfo) Reset() {
	*x = ApexInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApexInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApexInfo) ProtoMessage() {}

func (x *ApexInfo) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApexInfo.ProtoReflect.Descriptor instead.
func (*ApexInfo) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{9}
}

func (x *ApexInfo) GetPackageName() string {
	if x != nil && x.PackageName != nil {
		return *x.PackageName
	}
	return ""
}

func (x *ApexInfo) GetVersion() int64 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

func (x *ApexInfo) GetIsCompressed() bool {
	if x != nil && x.IsCompressed != nil {
		return *x.IsCompressed
	}
	return false
}

func (x *ApexInfo) GetDecompressedSize() int64 {
	if x != nil && x.DecompressedSize != nil {
		return *x.DecompressedSize
	}
	return 0
}

// Definition has been duplicated from
// $ANDROID_BUILD_TOP/build/tools/releasetools/ota_metadata.proto. Keep in sync.
type ApexMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApexInfo []*ApexInfo `protobuf:"bytes,1,rep,name=apex_info,json=apexInfo" json:"apex_info,omitempty"`
}

func (x *ApexMetadata) Reset() {
	*x = ApexMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApexMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApexMetadata) ProtoMessage() {}

func (x *ApexMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApexMetadata.ProtoReflect.Descriptor instead.
func (*ApexMetadata) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{10}
}

func (x *ApexMetadata) GetApexInfo() []*ApexInfo {
	if x != nil {
		return x.ApexInfo
	}
	return nil
}

type DeltaArchiveManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (At time of writing) usually 4096
	BlockSize *uint32 `protobuf:"varint,3,opt,name=block_size,json=blockSize,def=4096" json:"block_size,omitempty"`
	// If signatures are present, the offset into the blobs, generally
	// tacked onto the end of the file, and the length. We use an offset
	// rather than a bool to allow for more flexibility in future file formats.
	// If either is absent, it means signatures aren't supported in this
	// file.
	SignaturesOffset *uint64 `protobuf:"varint,4,opt,name=signatures_offset,json=signaturesOffset" json:"signatures_offset,omitempty"`
	SignaturesSize   *uint64 `protobuf:"varint,5,opt,name=signatures_size,json=signaturesSize" json:"signatures_size,omitempty"`
	// The minor version, also referred as "delta version", of the payload.
	// Minor version 0 is full payload, everything else is delta payload.
	MinorVersion *uint32 `protobuf:"varint,12,opt,name=minor_version,json=minorVersion,def=0" json:"minor_version,omitempty"`
	// Only present in major version >= 2. List of partitions that will be
	// updated, in the order they will be updated. This field replaces the
	// |install_operations|, |kernel_install_operations| and the
	// |{old,new}_{kernel,rootfs}_info| fields used in major version = 1. This
	// array can have more than two partitions if needed, and they are identified
	// by the partition name.
	Partitions []*PartitionUpdate `protobuf:"bytes,13,rep,name=partitions" json:"partitions,omitempty"`
	// The maximum timestamp of the OS allowed to apply this payload.
	// Can be used to prevent downgrading the OS.
	MaxTimestamp *int64 `protobuf:"varint,14,opt,name=max_timestamp,json=maxTimestamp" json:"max_timestamp,omitempty"`
	// Metadata related to all dynamic partitions.
	DynamicPartitionMetadata *DynamicPartitionMetadata `protobuf:"bytes,15,opt,name=dynamic_partition_metadata,json=dynamicPartitionMetadata" json:"dynamic_partition_metadata,omitempty"`
	// If the payload only updates a subset of partitions on the device.
	PartialUpdate *bool `protobuf:"varint,16,opt,name=partial_update,json=partialUpdate" json:"partial_update,omitempty"`
	// Information on compressed APEX to figure out how much space is required for
	// their decompression
	ApexInfo []*ApexInfo `protobuf:"bytes,17,rep,name=apex_info,json=apexInfo" json:"apex_info,omitempty"`
	// Security patch level of the device, usually in the format of
	// yyyy-mm-dd
	SecurityPatchLevel *string `protobuf:"bytes,18,opt,name=security_patch_level,json=securityPatchLevel" json:"security_patch_level,omitempty"`
}

// Default values for DeltaArchiveManifest fields.
const (
	Default_DeltaArchiveManifest_BlockSize    = uint32(4096)
	Default_DeltaArchiveManifest_MinorVersion = uint32(0)
)

func (x *DeltaArchiveManifest) Reset() {
	*x = DeltaArchiveManifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeltaArchiveManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeltaArchiveManifest) ProtoMessage() {}

func (x *DeltaArchiveManifest) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeltaArchiveManifest.ProtoReflect.Descriptor instead.
func (*DeltaArchiveManifest) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{11}
}

func (x *DeltaArchiveManifest) GetBlockSize() uint32 {
	if x != nil && x.BlockSize != nil {
		return *x.BlockSize
	}
	return Default_DeltaArchiveManifest_BlockSize
}

func (x *DeltaArchiveManifest) GetSignaturesOffset() uint64 {
	if x != nil && x.SignaturesOffset != nil {
		return *x.SignaturesOffset
	}
	return 0
}

func (x *DeltaArchiveManifest) GetSignaturesSize() uint64 {
	if x != nil && x.SignaturesSize != nil {
		return *x.SignaturesSize
	}
	return 0
}

func (x *DeltaArchiveManifest) GetMinorVersion() uint32 {
	if x != nil && x.MinorVersion != nil {
		return *x.MinorVersion
	}
	return Default_DeltaArchiveManifest_MinorVersion
}

func (x *DeltaArchiveManifest) GetPartitions() []*PartitionUpdate {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *DeltaArchiveManifest) GetMaxTimestamp() int64 {
	if x != nil && x.MaxTimestamp != nil {
		return *x.MaxTimestamp
	}
	return 0
}

func (x *DeltaArchiveManifest) GetDynamicPartitionMetadata() *DynamicPartitionMetadata {
	if x != nil {
		return x.DynamicPartitionMetadata
	}
	return nil
}

func (x *DeltaArchiveManifest) GetPartialUpdate() bool {
	if x != nil && x.PartialUpdate != nil {
		return *x.PartialUpdate
	}
	return false
}

func (x *DeltaArchiveManifest) GetApexInfo() []*ApexInfo {
	if x != nil {
		return x.ApexInfo
	}
	return nil
}

func (x *DeltaArchiveManifest) GetSecurityPatchLevel() string {
	if x != nil && x.SecurityPatchLevel != nil {
		return *x.SecurityPatchLevel
	}
	return ""
}

type Signatures_Signature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deprecated: Marked as deprecated in update_metadata.proto.
	Version *uint32 `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	Data    []byte  `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	// The DER encoded signature size of EC keys is nondeterministic for
	// different input of sha256 hash. However, we need the size of the
	// serialized signatures protobuf string to be fixed before signing;
	// because this size is part of the content to be signed. Therefore, we
	// always pad the signature data to the maximum possible signature size of
	// a given key. And the payload verifier will truncate the signature to
	// its correct size based on the value of |unpadded_signature_size|.
	UnpaddedSignatureSize *uint32 `protobuf:"fixed32,3,opt,name=unpadded_signature_size,json=unpaddedSignatureSize" json:"unpadded_signature_size,omitempty"`
}

func (x *Signatures_Signature) Reset() {
	*x = Signatures_Signature{}
	if protoimpl.UnsafeEnabled {
		mi := &file_update_metadata_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Signatures_Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Signatures_Signature) ProtoMessage() {}

func (x *Signatures_Signature) ProtoReflect() protoreflect.Message {
	mi := &file_update_metadata_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Signatures_Signature.ProtoReflect.Descriptor instead.
func (*Signatures_Signature) Descriptor() ([]byte, []int) {
	return file_update_metadata_proto_rawDescGZIP(), []int{1, 0}
}

// Deprecated: Marked as deprecated in update_metadata.proto.
func (x *Signatures_Signature) GetVersion() uint32 {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return 0
}

func (x *Signatures_Signature) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Signatures_Signature) GetUnpaddedSignatureSize() uint32 {
	if x != nil && x.UnpaddedSignatureSize != nil {
		return *x.UnpaddedSignatureSize
	}
	return 0
}

var File_update_metadata_proto protoreflect.FileDescriptor

var file_update_metadata_proto_rawDesc = []byte{
	0x0a, 0x15, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f,
	0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22,
	0x48, 0x0a, 0x06, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75,
	0x6d, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09,
	0x6e, 0x75, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0xd1, 0x01, 0x0a, 0x0a, 0x53, 0x69,
	0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63,
	0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x1a, 0x75, 0x0a, 0x09, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0d, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x36, 0x0a, 0x17, 0x75, 0x6e, 0x70, 0x61, 0x64, 0x64, 0x65,
	0x64, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x07, 0x52, 0x15, 0x75, 0x6e, 0x70, 0x61, 0x64, 0x64, 0x65, 0x64,
	0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x37, 0x0a,
	0x0d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73, 0x69,
	0x7a, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x04, 0x68, 0x61, 0x73, 0x68, 0x22, 0x9b, 0x05, 0x0a, 0x10, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x3f, 0x0a, 0x0b, 0x73, 0x72, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x73, 0x72, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x72, 0x63, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x73, 0x72, 0x63, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x3f, 0x0a, 0x0b, 0x64, 0x73, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x73, 0x74, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x73, 0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x64, 0x73, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x28, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x5f,
	0x68, 0x61, 0x73, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x48, 0x61, 0x73, 0x68, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x72,
	0x63, 0x5f, 0x73, 0x68, 0x61, 0x32, 0x35, 0x36, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x0d, 0x73, 0x72, 0x63, 0x53, 0x68, 0x61, 0x32, 0x35, 0x36, 0x48, 0x61,
	0x73, 0x68, 0x22, 0xef, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x50, 0x4c,
	0x41, 0x43, 0x45, 0x5f, 0x42, 0x5a, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x04, 0x4d, 0x4f, 0x56, 0x45,
	0x10, 0x02, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0e, 0x0a, 0x06, 0x42, 0x53, 0x44, 0x49, 0x46, 0x46,
	0x10, 0x03, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x42, 0x53, 0x44, 0x49, 0x46, 0x46, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45,
	0x50, 0x4c, 0x41, 0x43, 0x45, 0x5f, 0x58, 0x5a, 0x10, 0x08, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x45,
	0x52, 0x4f, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x49, 0x53, 0x43, 0x41, 0x52, 0x44, 0x10,
	0x07, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x52, 0x4f, 0x54, 0x4c, 0x49, 0x5f, 0x42, 0x53, 0x44, 0x49,
	0x46, 0x46, 0x10, 0x0a, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x55, 0x46, 0x46, 0x44, 0x49, 0x46, 0x46,
	0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08, 0x5a, 0x55, 0x43, 0x43, 0x48, 0x49, 0x4e, 0x49, 0x10, 0x0b,
	0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x5a, 0x34, 0x44, 0x49, 0x46, 0x46, 0x5f, 0x42, 0x53, 0x44, 0x49,
	0x46, 0x46, 0x10, 0x0c, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x5a, 0x34, 0x44, 0x49, 0x46, 0x46, 0x5f,
	0x50, 0x55, 0x46, 0x46, 0x44, 0x49, 0x46, 0x46, 0x10, 0x0d, 0x12, 0x08, 0x0a, 0x04, 0x5a, 0x53,
	0x54, 0x44, 0x10, 0x0e, 0x22, 0xa8, 0x02, 0x0a, 0x11, 0x43, 0x6f, 0x77, 0x4d, 0x65, 0x72, 0x67,
	0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d,
	0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x43, 0x6f, 0x77, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x3d,
	0x0a, 0x0a, 0x73, 0x72, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65,
	0x6e, 0x74, 0x52, 0x09, 0x73, 0x72, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a,
	0x0a, 0x64, 0x73, 0x74, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x09, 0x64, 0x73, 0x74, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x72, 0x63, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x09, 0x73, 0x72, 0x63, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x32, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x57, 0x5f, 0x43, 0x4f, 0x50, 0x59, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x57, 0x5f, 0x58, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x43, 0x4f, 0x57, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x02, 0x22,
	0xab, 0x09, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x02, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x75,
	0x6e, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x50, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70,
	0x6f, 0x73, 0x74, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x27,
	0x0a, 0x0f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x64, 0x0a, 0x17, 0x6e, 0x65, 0x77, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d,
	0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2e, 0x53, 0x69, 0x67,
	0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x15, 0x6e, 0x65, 0x77, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x53, 0x0a,
	0x12, 0x6f, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x68, 0x72, 0x6f,
	0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x10, 0x6f, 0x6c, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x53, 0x0a, 0x12, 0x6e, 0x65, 0x77, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x10, 0x6e, 0x65, 0x77, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x48, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x63, 0x68,
	0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x31, 0x0a, 0x14, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x13, 0x70, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x51, 0x0a, 0x15, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x74, 0x72, 0x65,
	0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x12, 0x68, 0x61, 0x73, 0x68, 0x54, 0x72, 0x65, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x10, 0x68, 0x61, 0x73, 0x68, 0x5f,
	0x74, 0x72, 0x65, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x0e, 0x68, 0x61, 0x73, 0x68, 0x54, 0x72, 0x65, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x2e, 0x0a, 0x13, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x61,
	0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11,
	0x68, 0x61, 0x73, 0x68, 0x54, 0x72, 0x65, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
	0x6d, 0x12, 0x24, 0x0a, 0x0e, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73,
	0x61, 0x6c, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x68, 0x61, 0x73, 0x68, 0x54,
	0x72, 0x65, 0x65, 0x53, 0x61, 0x6c, 0x74, 0x12, 0x46, 0x0a, 0x0f, 0x66, 0x65, 0x63, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x0d, 0x66, 0x65, 0x63, 0x44, 0x61, 0x74, 0x61, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x3d, 0x0a, 0x0a, 0x66, 0x65, 0x63, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x74, 0x52, 0x09, 0x66, 0x65, 0x63, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1e,
	0x0a, 0x09, 0x66, 0x65, 0x63, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0d, 0x3a, 0x01, 0x32, 0x52, 0x08, 0x66, 0x65, 0x63, 0x52, 0x6f, 0x6f, 0x74, 0x73, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x10, 0x6d, 0x65, 0x72, 0x67,
	0x65, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x12, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x6f, 0x77, 0x4d,
	0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6d,
	0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x77, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x65, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x77, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x31, 0x0a, 0x15, 0x65, 0x73,
	0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f,
	0x6d, 0x61, 0x78, 0x18, 0x14, 0x20, 0x01, 0x28, 0x04, 0x52, 0x12, 0x65, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x65, 0x4f, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x61, 0x78, 0x22, 0x68, 0x0a,
	0x15, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x02, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x27,
	0x0a, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x4f, 0x0a, 0x0e, 0x56, 0x41, 0x42, 0x43, 0x46,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x77,
	0x72, 0x69, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x57, 0x72, 0x69, 0x74, 0x65, 0x73, 0x22, 0x87, 0x03, 0x0a, 0x18, 0x44, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x45, 0x0a, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73,
	0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x44,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x29, 0x0a, 0x10,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x76, 0x61, 0x62, 0x63, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x76,
	0x61, 0x62, 0x63, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x34, 0x0a, 0x16, 0x76, 0x61,
	0x62, 0x63, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x76, 0x61, 0x62, 0x63,
	0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x77, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x63, 0x6f, 0x77, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x50, 0x0a, 0x10, 0x76, 0x61, 0x62, 0x63, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x63, 0x68,
	0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x41, 0x42, 0x43, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x53, 0x65, 0x74, 0x52, 0x0e, 0x76, 0x61, 0x62, 0x63, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x53, 0x65, 0x74, 0x12, 0x2d, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x11, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x22, 0x99, 0x01, 0x0a, 0x08, 0x41, 0x70, 0x65, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d,
	0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x12, 0x2b, 0x0a, 0x11, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65,
	0x64, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x64, 0x65,
	0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x4d,
	0x0a, 0x0c, 0x41, 0x70, 0x65, 0x78, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3d,
	0x0a, 0x09, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x41, 0x70, 0x65, 0x78, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x70, 0x65, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xdf, 0x04,
	0x0a, 0x14, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x0a, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x04, 0x34, 0x30, 0x39, 0x36,
	0x52, 0x09, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73,
	0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x10, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x0e, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x26, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0d, 0x3a, 0x01, 0x30, 0x52, 0x0c, 0x6d, 0x69, 0x6e,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x6e, 0x0a, 0x1a, 0x64, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x63, 0x68,
	0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x18, 0x64,
	0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x3d,
	0x0a, 0x09, 0x61, 0x70, 0x65, 0x78, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x11, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x63, 0x68, 0x72, 0x6f, 0x6d, 0x65, 0x6f, 0x73, 0x5f, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x41, 0x70, 0x65, 0x78, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x08, 0x61, 0x70, 0x65, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a,
	0x14, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x4a,
	0x04, 0x08, 0x01, 0x10, 0x02, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x4a, 0x04, 0x08, 0x06, 0x10,
	0x07, 0x4a, 0x04, 0x08, 0x07, 0x10, 0x08, 0x4a, 0x04, 0x08, 0x08, 0x10, 0x09, 0x4a, 0x04, 0x08,
	0x09, 0x10, 0x0a, 0x4a, 0x04, 0x08, 0x0a, 0x10, 0x0b, 0x4a, 0x04, 0x08, 0x0b, 0x10, 0x0c, 0x42,
	0x04, 0x5a, 0x02, 0x2e, 0x2f,
}

var (
	file_update_metadata_proto_rawDescOnce sync.Once
	file_update_metadata_proto_rawDescData = file_update_metadata_proto_rawDesc
)

func file_update_metadata_proto_rawDescGZIP() []byte {
	file_update_metadata_proto_rawDescOnce.Do(func() {
		file_update_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_update_metadata_proto_rawDescData)
	})
	return file_update_metadata_proto_rawDescData
}

var file_update_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_update_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_update_metadata_proto_goTypes = []interface{}{
	(InstallOperation_Type)(0),       // 0: chromeos_update_engine.InstallOperation.Type
	(CowMergeOperation_Type)(0),      // 1: chromeos_update_engine.CowMergeOperation.Type
	(*Extent)(nil),                   // 2: chromeos_update_engine.Extent
	(*Signatures)(nil),               // 3: chromeos_update_engine.Signatures
	(*PartitionInfo)(nil),            // 4: chromeos_update_engine.PartitionInfo
	(*InstallOperation)(nil),         // 5: chromeos_update_engine.InstallOperation
	(*CowMergeOperation)(nil),        // 6: chromeos_update_engine.CowMergeOperation
	(*PartitionUpdate)(nil),          // 7: chromeos_update_engine.PartitionUpdate
	(*DynamicPartitionGroup)(nil),    // 8: chromeos_update_engine.DynamicPartitionGroup
	(*VABCFeatureSet)(nil),           // 9: chromeos_update_engine.VABCFeatureSet
	(*DynamicPartitionMetadata)(nil), // 10: chromeos_update_engine.DynamicPartitionMetadata
	(*ApexInfo)(nil),                 // 11: chromeos_update_engine.ApexInfo
	(*ApexMetadata)(nil),             // 12: chromeos_update_engine.ApexMetadata
	(*DeltaArchiveManifest)(nil),     // 13: chromeos_update_engine.DeltaArchiveManifest
	(*Signatures_Signature)(nil),     // 14: chromeos_update_engine.Signatures.Signature
}
var file_update_metadata_proto_depIdxs = []int32{
	14, // 0: chromeos_update_engine.Signatures.signatures:type_name -> chromeos_update_engine.Signatures.Signature
	0,  // 1: chromeos_update_engine.InstallOperation.type:type_name -> chromeos_update_engine.InstallOperation.Type
	2,  // 2: chromeos_update_engine.InstallOperation.src_extents:type_name -> chromeos_update_engine.Extent
	2,  // 3: chromeos_update_engine.InstallOperation.dst_extents:type_name -> chromeos_update_engine.Extent
	1,  // 4: chromeos_update_engine.CowMergeOperation.type:type_name -> chromeos_update_engine.CowMergeOperation.Type
	2,  // 5: chromeos_update_engine.CowMergeOperation.src_extent:type_name -> chromeos_update_engine.Extent
	2,  // 6: chromeos_update_engine.CowMergeOperation.dst_extent:type_name -> chromeos_update_engine.Extent
	14, // 7: chromeos_update_engine.PartitionUpdate.new_partition_signature:type_name -> chromeos_update_engine.Signatures.Signature
	4,  // 8: chromeos_update_engine.PartitionUpdate.old_partition_info:type_name -> chromeos_update_engine.PartitionInfo
	4,  // 9: chromeos_update_engine.PartitionUpdate.new_partition_info:type_name -> chromeos_update_engine.PartitionInfo
	5,  // 10: chromeos_update_engine.PartitionUpdate.operations:type_name -> chromeos_update_engine.InstallOperation
	2,  // 11: chromeos_update_engine.PartitionUpdate.hash_tree_data_extent:type_name -> chromeos_update_engine.Extent
	2,  // 12: chromeos_update_engine.PartitionUpdate.hash_tree_extent:type_name -> chromeos_update_engine.Extent
	2,  // 13: chromeos_update_engine.PartitionUpdate.fec_data_extent:type_name -> chromeos_update_engine.Extent
	2,  // 14: chromeos_update_engine.PartitionUpdate.fec_extent:type_name -> chromeos_update_engine.Extent
	6,  // 15: chromeos_update_engine.PartitionUpdate.merge_operations:type_name -> chromeos_update_engine.CowMergeOperation
	8,  // 16: chromeos_update_engine.DynamicPartitionMetadata.groups:type_name -> chromeos_update_engine.DynamicPartitionGroup
	9,  // 17: chromeos_update_engine.DynamicPartitionMetadata.vabc_feature_set:type_name -> chromeos_update_engine.VABCFeatureSet
	11, // 18: chromeos_update_engine.ApexMetadata.apex_info:type_name -> chromeos_update_engine.ApexInfo
	7,  // 19: chromeos_update_engine.DeltaArchiveManifest.partitions:type_name -> chromeos_update_engine.PartitionUpdate
	10, // 20: chromeos_update_engine.DeltaArchiveManifest.dynamic_partition_metadata:type_name -> chromeos_update_engine.DynamicPartitionMetadata
	11, // 21: chromeos_update_engine.DeltaArchiveManifest.apex_info:type_name -> chromeos_update_engine.ApexInfo
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_update_metadata_proto_init() }
func file_update_metadata_proto_init() {
	if File_update_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_update_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Extent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Signatures); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CowMergeOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicPartitionGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VABCFeatureSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynamicPartitionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApexInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApexMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeltaArchiveManifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_update_metadata_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Signatures_Signature); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_update_metadata_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_update_metadata_proto_goTypes,
		DependencyIndexes: file_update_metadata_proto_depIdxs,
		EnumInfos:         file_update_metadata_proto_enumTypes,
		MessageInfos:      file_update_metadata_proto_msgTypes,
	}.Build()
	File_update_metadata_proto = out.File
	file_update_metadata_proto_rawDesc = nil
	file_update_metadata_proto_goTypes = nil
	file_update_metadata_proto_depIdxs = nil
}
