"""Generated message classes for looker version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'looker'


class AdminSettings(_messages.Message):
  r"""Looker instance Admin settings fields.

  Fields:
    allowedEmailDomains: Email domain allowlist for the instance.
  """

  allowedEmailDomains = _messages.StringField(1, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class ControlledEgressConfig(_messages.Message):
  r"""Controlled egress configuration.

  Fields:
    egressFqdns: Optional. List of fully qualified domain names to be added to
      the allowlist for outbound traffic.
    marketplaceEnabled: Optional. Whether marketplace is enabled.
  """

  egressFqdns = _messages.StringField(1, repeated=True)
  marketplaceEnabled = _messages.BooleanField(2)


class CustomDomain(_messages.Message):
  r"""Custom domain information.

  Enums:
    StateValueValuesEnum: Domain state.

  Fields:
    domain: Domain name.
    state: Domain state.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Domain state.

    Values:
      CUSTOM_DOMAIN_STATE_UNSPECIFIED: Unspecified state.
      UNVERIFIED: DNS record is not created.
      VERIFIED: DNS record is created.
      MODIFYING: Calling SLM to update.
      AVAILABLE: ManagedCertificate is ready.
      UNAVAILABLE: ManagedCertificate is not ready.
      UNKNOWN: Status is not known.
    """
    CUSTOM_DOMAIN_STATE_UNSPECIFIED = 0
    UNVERIFIED = 1
    VERIFIED = 2
    MODIFYING = 3
    AVAILABLE = 4
    UNAVAILABLE = 5
    UNKNOWN = 6

  domain = _messages.StringField(1)
  state = _messages.EnumField('StateValueValuesEnum', 2)


class Date(_messages.Message):
  r"""Represents a whole or partial calendar date, such as a birthday. The
  time of day and time zone are either specified elsewhere or are
  insignificant. The date is relative to the Gregorian Calendar. This can
  represent one of the following: * A full date, with non-zero year, month,
  and day values. * A month and day, with a zero year (for example, an
  anniversary). * A year on its own, with a zero month and a zero day. * A
  year and month, with a zero day (for example, a credit card expiration
  date). Related types: * google.type.TimeOfDay * google.type.DateTime *
  google.protobuf.Timestamp

  Fields:
    day: Day of a month. Must be from 1 to 31 and valid for the year and
      month, or 0 to specify a year by itself or a year and month where the
      day isn't significant.
    month: Month of a year. Must be from 1 to 12, or 0 to specify a year
      without a month and day.
    year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
      without a year.
  """

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  month = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  year = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class DenyMaintenancePeriod(_messages.Message):
  r"""Specifies the maintenance denial period.

  Fields:
    endDate: Required. End date of the deny maintenance period.
    startDate: Required. Start date of the deny maintenance period.
    time: Required. Time in UTC when the period starts and ends.
  """

  endDate = _messages.MessageField('Date', 1)
  startDate = _messages.MessageField('Date', 2)
  time = _messages.MessageField('TimeOfDay', 3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EncryptionConfig(_messages.Message):
  r"""Encryption configuration (i.e. CMEK).

  Enums:
    KmsKeyStateValueValuesEnum: Output only. Status of the CMEK key.

  Fields:
    kmsKeyName: Name of the CMEK key in KMS (input parameter).
    kmsKeyNameVersion: Output only. Full name and version of the CMEK key
      currently in use to encrypt Looker data. Format: `projects/{project}/loc
      ations/{location}/keyRings/{ring}/cryptoKeys/{key}/cryptoKeyVersions/{ve
      rsion}`. Empty if CMEK is not configured in this instance.
    kmsKeyState: Output only. Status of the CMEK key.
  """

  class KmsKeyStateValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the CMEK key.

    Values:
      KMS_KEY_STATE_UNSPECIFIED: CMEK status not specified.
      VALID: CMEK key is currently valid.
      REVOKED: CMEK key is currently revoked (instance should in restricted
        mode).
    """
    KMS_KEY_STATE_UNSPECIFIED = 0
    VALID = 1
    REVOKED = 2

  kmsKeyName = _messages.StringField(1)
  kmsKeyNameVersion = _messages.StringField(2)
  kmsKeyState = _messages.EnumField('KmsKeyStateValueValuesEnum', 3)


class ExportEncryptionConfig(_messages.Message):
  r"""Configuration for Encryption - e.g. CMEK.

  Fields:
    kmsKeyName: Required. Name of the CMEK key in KMS.
  """

  kmsKeyName = _messages.StringField(1)


class ExportInstanceRequest(_messages.Message):
  r"""Request options for exporting data of an Instance.

  Fields:
    encryptionConfig: Required. Encryption configuration (CMEK). For CMEK
      enabled instances it should be same as looker CMEK.
    gcsUri: The path to the folder in Google Cloud Storage where the export
      will be stored. The URI is in the form `gs://bucketName/folderName`.
  """

  encryptionConfig = _messages.MessageField('ExportEncryptionConfig', 1)
  gcsUri = _messages.StringField(2)


class ExportMetadata(_messages.Message):
  r"""ExportMetadata represents the metadata of the exported artifacts. The
  metadata.json file in export artifact can be parsed as this message

  Enums:
    SourceValueValuesEnum: The source type of the migration.

  Fields:
    exportEncryptionKey: Encryption key that was used to encrypt the export
      artifacts.
    filePaths: List of files created as part of export artifact (excluding the
      metadata). The paths are relative to the folder containing the metadata.
    lookerEncryptionKey: Looker encryption key, encrypted with the provided
      export encryption key. This value will only be populated if the looker
      instance uses Looker managed encryption instead of CMEK.
    lookerInstance: Name of the exported instance. Format:
      projects/{project}/locations/{location}/instances/{instance}
    lookerPlatformEdition: Platform edition of the exported instance.
    lookerVersion: Version of instance when the export was created.
    source: The source type of the migration.
  """

  class SourceValueValuesEnum(_messages.Enum):
    r"""The source type of the migration.

    Values:
      SOURCE_UNSPECIFIED: Source not specified
      LOOKER_CORE: Source of export is Looker Core
      LOOKER_ORIGINAL: Source of export is Looker Original
    """
    SOURCE_UNSPECIFIED = 0
    LOOKER_CORE = 1
    LOOKER_ORIGINAL = 2

  exportEncryptionKey = _messages.MessageField('ExportMetadataEncryptionKey', 1)
  filePaths = _messages.StringField(2, repeated=True)
  lookerEncryptionKey = _messages.StringField(3)
  lookerInstance = _messages.StringField(4)
  lookerPlatformEdition = _messages.StringField(5)
  lookerVersion = _messages.StringField(6)
  source = _messages.EnumField('SourceValueValuesEnum', 7)


class ExportMetadataEncryptionKey(_messages.Message):
  r"""Encryption key details for the exported artifact.

  Fields:
    cmek: Name of the CMEK.
    version: Version of the CMEK.
  """

  cmek = _messages.StringField(1)
  version = _messages.StringField(2)


class ImportInstanceRequest(_messages.Message):
  r"""Requestion options for importing looker data to an Instance

  Fields:
    gcsUri: Path to the import folder in Google Cloud Storage, in the form
      `gs://bucketName/folderName`.
  """

  gcsUri = _messages.StringField(1)


class Instance(_messages.Message):
  r"""A Looker instance.

  Enums:
    ClassTypeValueValuesEnum: Optional. Storage class of the instance.
    PlatformEditionValueValuesEnum: Platform edition.
    StateValueValuesEnum: Output only. The state of the instance.

  Fields:
    adminSettings: Looker Instance Admin settings.
    classType: Optional. Storage class of the instance.
    consumerNetwork: Network name in the consumer project. Format:
      `projects/{project}/global/networks/{network}`. Note that the consumer
      network may be in a different GCP project than the consumer project that
      is hosting the Looker Instance.
    controlledEgressConfig: Optional. Controlled egress configuration.
    controlledEgressEnabled: Optional. Whether controlled egress is enabled on
      the Looker instance.
    createTime: Output only. The time when the Looker instance provisioning
      was first requested.
    customDomain: Custom domain configuration for the instance.
    denyMaintenancePeriod: Maintenance denial period for this instance.
    egressPublicIp: Output only. Public Egress IP (IPv4).
    encryptionConfig: Encryption configuration (CMEK). Only set if CMEK has
      been enabled on the instance.
    fipsEnabled: Optional. Whether FIPS is enabled on the Looker instance.
    geminiEnabled: Optional. Whether Gemini feature is enabled on the Looker
      instance or not.
    ingressPrivateIp: Output only. Private Ingress IP (IPv4).
    ingressPublicIp: Output only. Public Ingress IP (IPv4).
    lastDenyMaintenancePeriod: Output only. Last computed maintenance denial
      period for this instance.
    linkedLspProjectNumber: Optional. Linked Google Cloud Project Number for
      Looker Studio Pro.
    lookerUri: Output only. Looker instance URI which can be used to access
      the Looker Instance UI.
    lookerVersion: Output only. The Looker version that the instance is using.
    maintenanceSchedule: Maintenance schedule for this instance.
    maintenanceWindow: Maintenance window for this instance.
    name: Output only. Format:
      `projects/{project}/locations/{location}/instances/{instance}`.
    oauthConfig: Looker instance OAuth login settings.
    platformEdition: Platform edition.
    privateIpEnabled: Whether private IP is enabled on the Looker instance.
    pscConfig: Optional. PSC configuration. Used when `psc_enabled` is true.
    pscEnabled: Optional. Whether to use Private Service Connect (PSC) for
      private IP connectivity. If true, neither `public_ip_enabled` nor
      `private_ip_enabled` can be true.
    publicIpEnabled: Whether public IP is enabled on the Looker instance.
    reservedRange: Name of a reserved IP address range within the
      Instance.consumer_network, to be used for private services access
      connection. May or may not be specified in a create request.
    satisfiesPzi: Output only. Reserved for future use.
    satisfiesPzs: Output only. Reserved for future use.
    state: Output only. The state of the instance.
    updateTime: Output only. The time when the Looker instance was last
      updated.
    userMetadata: Optional. User metadata.
  """

  class ClassTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Storage class of the instance.

    Values:
      CLASS_TYPE_UNSPECIFIED: Unspecified storage class.
      R1: Filestore.
      P1: PD SSD.
    """
    CLASS_TYPE_UNSPECIFIED = 0
    R1 = 1
    P1 = 2

  class PlatformEditionValueValuesEnum(_messages.Enum):
    r"""Platform edition.

    Values:
      PLATFORM_EDITION_UNSPECIFIED: Platform edition is unspecified.
      LOOKER_CORE_TRIAL: Trial.
      LOOKER_CORE_STANDARD: Standard.
      LOOKER_CORE_STANDARD_ANNUAL: Subscription Standard.
      LOOKER_CORE_ENTERPRISE_ANNUAL: Subscription Enterprise.
      LOOKER_CORE_EMBED_ANNUAL: Subscription Embed.
      LOOKER_CORE_NONPROD_STANDARD_ANNUAL: Nonprod Subscription Standard.
      LOOKER_CORE_NONPROD_ENTERPRISE_ANNUAL: Nonprod Subscription Enterprise.
      LOOKER_CORE_NONPROD_EMBED_ANNUAL: Nonprod Subscription Embed.
      LOOKER_CORE_TRIAL_STANDARD: Trial Standard.
      LOOKER_CORE_TRIAL_ENTERPRISE: Trial Enterprise.
      LOOKER_CORE_TRIAL_EMBED: Trial Embed.
    """
    PLATFORM_EDITION_UNSPECIFIED = 0
    LOOKER_CORE_TRIAL = 1
    LOOKER_CORE_STANDARD = 2
    LOOKER_CORE_STANDARD_ANNUAL = 3
    LOOKER_CORE_ENTERPRISE_ANNUAL = 4
    LOOKER_CORE_EMBED_ANNUAL = 5
    LOOKER_CORE_NONPROD_STANDARD_ANNUAL = 6
    LOOKER_CORE_NONPROD_ENTERPRISE_ANNUAL = 7
    LOOKER_CORE_NONPROD_EMBED_ANNUAL = 8
    LOOKER_CORE_TRIAL_STANDARD = 9
    LOOKER_CORE_TRIAL_ENTERPRISE = 10
    LOOKER_CORE_TRIAL_EMBED = 11

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the instance.

    Values:
      STATE_UNSPECIFIED: State is unspecified.
      ACTIVE: Instance is active and ready for use.
      CREATING: Instance provisioning is in progress.
      FAILED: Instance is in a failed state.
      SUSPENDED: Instance was suspended.
      UPDATING: Instance update is in progress.
      DELETING: Instance delete is in progress.
      EXPORTING: Instance is being exported.
      IMPORTING: Instance is importing data.
    """
    STATE_UNSPECIFIED = 0
    ACTIVE = 1
    CREATING = 2
    FAILED = 3
    SUSPENDED = 4
    UPDATING = 5
    DELETING = 6
    EXPORTING = 7
    IMPORTING = 8

  adminSettings = _messages.MessageField('AdminSettings', 1)
  classType = _messages.EnumField('ClassTypeValueValuesEnum', 2)
  consumerNetwork = _messages.StringField(3)
  controlledEgressConfig = _messages.MessageField('ControlledEgressConfig', 4)
  controlledEgressEnabled = _messages.BooleanField(5)
  createTime = _messages.StringField(6)
  customDomain = _messages.MessageField('CustomDomain', 7)
  denyMaintenancePeriod = _messages.MessageField('DenyMaintenancePeriod', 8)
  egressPublicIp = _messages.StringField(9)
  encryptionConfig = _messages.MessageField('EncryptionConfig', 10)
  fipsEnabled = _messages.BooleanField(11)
  geminiEnabled = _messages.BooleanField(12)
  ingressPrivateIp = _messages.StringField(13)
  ingressPublicIp = _messages.StringField(14)
  lastDenyMaintenancePeriod = _messages.MessageField('DenyMaintenancePeriod', 15)
  linkedLspProjectNumber = _messages.IntegerField(16)
  lookerUri = _messages.StringField(17)
  lookerVersion = _messages.StringField(18)
  maintenanceSchedule = _messages.MessageField('MaintenanceSchedule', 19)
  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 20)
  name = _messages.StringField(21)
  oauthConfig = _messages.MessageField('OAuthConfig', 22)
  platformEdition = _messages.EnumField('PlatformEditionValueValuesEnum', 23)
  privateIpEnabled = _messages.BooleanField(24)
  pscConfig = _messages.MessageField('PscConfig', 25)
  pscEnabled = _messages.BooleanField(26)
  publicIpEnabled = _messages.BooleanField(27)
  reservedRange = _messages.StringField(28)
  satisfiesPzi = _messages.BooleanField(29)
  satisfiesPzs = _messages.BooleanField(30)
  state = _messages.EnumField('StateValueValuesEnum', 31)
  updateTime = _messages.StringField(32)
  userMetadata = _messages.MessageField('UserMetadata', 33)


class InstanceBackup(_messages.Message):
  r"""The details of a backup resource.

  Enums:
    StateValueValuesEnum: Output only. The current state of the backup.

  Fields:
    createTime: Output only. The time when the backup was started.
    encryptionConfig: Output only. Current status of the CMEK encryption
    expireTime: Output only. The time when the backup will be deleted.
    name: Immutable. The relative resource name of the backup, in the
      following form: `projects/{project_number}/locations/{location_id}/insta
      nces/{instance_id}/backups/{backup}`
    state: Output only. The current state of the backup.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the backup.

    Values:
      STATE_UNSPECIFIED: The state of the backup is unknown.
      CREATING: The backup is being created.
      DELETING: The backup is being deleted.
      ACTIVE: The backup is active and ready to use.
      FAILED: The backup failed.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    DELETING = 2
    ACTIVE = 3
    FAILED = 4

  createTime = _messages.StringField(1)
  encryptionConfig = _messages.MessageField('EncryptionConfig', 2)
  expireTime = _messages.StringField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class ListInstanceBackupsResponse(_messages.Message):
  r"""Response from listing Looker instance backups.

  Fields:
    instanceBackups: The list of instances matching the request filters, up to
      the requested `page_size`.
    nextPageToken: If provided, a page token that can look up the next
      `page_size` results. If empty, the results list is exhausted.
    unreachable: Locations that could not be reached.
  """

  instanceBackups = _messages.MessageField('InstanceBackup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListInstancesResponse(_messages.Message):
  r"""Response from ListInstances.

  Fields:
    instances: The list of instances matching the request filters, up to the
      requested ListInstancesRequest.pageSize.
    nextPageToken: If provided, a page token that can look up the next
      ListInstancesRequest.pageSize results. If empty, the results list is
      exhausted.
    unreachable: Locations that could not be reached.
  """

  instances = _messages.MessageField('Instance', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections e.g. when attempting to list all resources across all
      supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LookerProjectsLocationsGetRequest(_messages.Message):
  r"""A LookerProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class LookerProjectsLocationsInstancesBackupsCreateRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesBackupsCreateRequest object.

  Fields:
    instanceBackup: A InstanceBackup resource to be passed as the request
      body.
    parent: Required. Format:
      projects/{project}/locations/{location}/instances/{instance}
  """

  instanceBackup = _messages.MessageField('InstanceBackup', 1)
  parent = _messages.StringField(2, required=True)


class LookerProjectsLocationsInstancesBackupsDeleteRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesBackupsDeleteRequest object.

  Fields:
    name: Required. Format: projects/{project}/locations/{location}/instances/
      {instance}/backups/{backup}
  """

  name = _messages.StringField(1, required=True)


class LookerProjectsLocationsInstancesBackupsGetRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesBackupsGetRequest object.

  Fields:
    name: Required. Format: `projects/{project}/locations/{location}/instances
      /{instance}/backups/{backup}`.
  """

  name = _messages.StringField(1, required=True)


class LookerProjectsLocationsInstancesBackupsListRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesBackupsListRequest object.

  Fields:
    orderBy: Sort results. Default order is "create_time desc". Other
      supported fields are "state" and "expire_time".
      https://google.aip.dev/132#ordering
    pageSize: The maximum number of instances to return.
    pageToken: A page token received from a previous ListInstances request.
    parent: Required. Format:
      projects/{project}/locations/{location}/instances/{instance}.
  """

  orderBy = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class LookerProjectsLocationsInstancesCreateRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: Required. The unique instance identifier. Must contain only
      lowercase letters, numbers, or hyphens, with the first character a
      letter and the last a letter or a number. 63 characters maximum.
    parent: Required. Format: `projects/{project}/locations/{location}`.
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LookerProjectsLocationsInstancesDeleteRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesDeleteRequest object.

  Fields:
    force: Whether to force cascading delete.
    name: Required. Format:
      `projects/{project}/locations/{location}/instances/{instance}`.
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class LookerProjectsLocationsInstancesExportRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesExportRequest object.

  Fields:
    exportInstanceRequest: A ExportInstanceRequest resource to be passed as
      the request body.
    name: Required. Format:
      `projects/{project}/locations/{location}/instances/{instance}`.
  """

  exportInstanceRequest = _messages.MessageField('ExportInstanceRequest', 1)
  name = _messages.StringField(2, required=True)


class LookerProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesGetRequest object.

  Fields:
    name: Required. Format:
      `projects/{project}/locations/{location}/instances/{instance}`.
  """

  name = _messages.StringField(1, required=True)


class LookerProjectsLocationsInstancesImportRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesImportRequest object.

  Fields:
    importInstanceRequest: A ImportInstanceRequest resource to be passed as
      the request body.
    name: Required. Format:
      `projects/{project}/locations/{location}/instances/{instance}`.
  """

  importInstanceRequest = _messages.MessageField('ImportInstanceRequest', 1)
  name = _messages.StringField(2, required=True)


class LookerProjectsLocationsInstancesListRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesListRequest object.

  Fields:
    pageSize: The maximum number of instances to return. If unspecified at
      most 256 will be returned. The maximum possible value is 2048.
    pageToken: A page token received from a previous ListInstancesRequest.
    parent: Required. Format: `projects/{project}/locations/{location}`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class LookerProjectsLocationsInstancesPatchRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesPatchRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    name: Output only. Format:
      `projects/{project}/locations/{location}/instances/{instance}`.
    updateMask: Required. Field mask used to specify the fields to be
      overwritten in the Instance resource by the update. The fields specified
      in the mask are relative to the resource, not the full request. A field
      will be overwritten if it is in the mask.
  """

  instance = _messages.MessageField('Instance', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class LookerProjectsLocationsInstancesRestartRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesRestartRequest object.

  Fields:
    name: Required. Format:
      `projects/{project}/locations/{location}/instances/{instance}`.
    restartInstanceRequest: A RestartInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  restartInstanceRequest = _messages.MessageField('RestartInstanceRequest', 2)


class LookerProjectsLocationsInstancesRestoreRequest(_messages.Message):
  r"""A LookerProjectsLocationsInstancesRestoreRequest object.

  Fields:
    name: Required. Instance being restored Format:
      projects/{project}/locations/{location}/instances/{instance}
    restoreInstanceRequest: A RestoreInstanceRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  restoreInstanceRequest = _messages.MessageField('RestoreInstanceRequest', 2)


class LookerProjectsLocationsListRequest(_messages.Message):
  r"""A LookerProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class LookerProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A LookerProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class LookerProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A LookerProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class LookerProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A LookerProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class LookerProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A LookerProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the [ListOperationsResponse.unreachable] field. This can only be `true`
      when reading across collections e.g. when `parent` is set to
      `"projects/example/locations/-"`. This field is not by default supported
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class MaintenanceSchedule(_messages.Message):
  r"""Published upcoming future maintenance schedule.

  Fields:
    endTime: The scheduled end time for the maintenance.
    startTime: The scheduled start time for the maintenance.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class MaintenanceWindow(_messages.Message):
  r"""Specifies the recurring maintenance window.

  Enums:
    DayOfWeekValueValuesEnum: Required. Day of the week for this
      MaintenanceWindow (in UTC).

  Fields:
    dayOfWeek: Required. Day of the week for this MaintenanceWindow (in UTC).
    startTime: Required. Time in UTC when the period starts. Maintenance will
      be scheduled within 60 minutes.
  """

  class DayOfWeekValueValuesEnum(_messages.Enum):
    r"""Required. Day of the week for this MaintenanceWindow (in UTC).

    Values:
      DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
      MONDAY: Monday
      TUESDAY: Tuesday
      WEDNESDAY: Wednesday
      THURSDAY: Thursday
      FRIDAY: Friday
      SATURDAY: Saturday
      SUNDAY: Sunday
    """
    DAY_OF_WEEK_UNSPECIFIED = 0
    MONDAY = 1
    TUESDAY = 2
    WEDNESDAY = 3
    THURSDAY = 4
    FRIDAY = 5
    SATURDAY = 6
    SUNDAY = 7

  dayOfWeek = _messages.EnumField('DayOfWeekValueValuesEnum', 1)
  startTime = _messages.MessageField('TimeOfDay', 2)


class OAuthConfig(_messages.Message):
  r"""Looker instance OAuth login settings.

  Fields:
    clientId: Input only. Client ID from an external OAuth application. This
      is an input-only field, and thus will not be set in any responses.
    clientSecret: Input only. Client secret from an external OAuth
      application. This is an input-only field, and thus will not be set in
      any responses.
  """

  clientId = _messages.StringField(1)
  clientSecret = _messages.StringField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: API version used to start the operation.
    createTime: The time the operation was created.
    endTime: The time the operation finished running.
    requestedCancellation: Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    statusMessage: Human-readable status of the operation, if any.
    target: Server-defined resource path for the target of the operation.
    verb: Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class PscConfig(_messages.Message):
  r"""Information for Private Service Connect (PSC) setup for a Looker
  instance.

  Fields:
    allowedVpcs: Optional. List of VPCs that are allowed ingress into looker.
      Format: projects/{project}/global/networks/{network}
    lookerServiceAttachmentUri: Output only. URI of the Looker service
      attachment.
    serviceAttachments: Optional. List of egress service attachment
      configurations.
  """

  allowedVpcs = _messages.StringField(1, repeated=True)
  lookerServiceAttachmentUri = _messages.StringField(2)
  serviceAttachments = _messages.MessageField('ServiceAttachment', 3, repeated=True)


class RestartInstanceRequest(_messages.Message):
  r"""Request options for restarting an instance."""


class RestoreInstanceRequest(_messages.Message):
  r"""Request options for restoring an instance

  Fields:
    backup: Required. Backup being used to restore the instance Format: projec
      ts/{project}/locations/{location}/instances/{instance}/backups/{backup}
  """

  backup = _messages.StringField(1)


class ServiceAttachment(_messages.Message):
  r"""Service attachment configuration.

  Enums:
    ConnectionStatusValueValuesEnum: Output only. Connection status.

  Fields:
    connectionStatus: Output only. Connection status.
    failureReason: Output only. Reason the service attachment creation failed.
      This value will only be populated if the service attachment encounters
      an issue during provisioning.
    localFqdn: Optional. Fully qualified domain name that will be used in the
      private DNS record created for the service attachment.
    localFqdns: Optional. List of fully qualified domain names that will be
      used in the private DNS record created for the service attachment.
    targetServiceAttachmentUri: Required. URI of the service attachment to
      connect to. Format: projects/{project}/regions/{region}/serviceAttachmen
      ts/{service_attachment}
  """

  class ConnectionStatusValueValuesEnum(_messages.Enum):
    r"""Output only. Connection status.

    Values:
      UNKNOWN: Connection status is unspecified.
      ACCEPTED: Connection is established and functioning normally.
      PENDING: Connection is not established (Looker tenant project hasn't
        been allowlisted).
      REJECTED: Connection is not established (Looker tenant project is
        explicitly in reject list).
      NEEDS_ATTENTION: Issue with target service attachment, e.g. NAT subnet
        is exhausted.
      CLOSED: Target service attachment does not exist. This status is a
        terminal state.
    """
    UNKNOWN = 0
    ACCEPTED = 1
    PENDING = 2
    REJECTED = 3
    NEEDS_ATTENTION = 4
    CLOSED = 5

  connectionStatus = _messages.EnumField('ConnectionStatusValueValuesEnum', 1)
  failureReason = _messages.StringField(2)
  localFqdn = _messages.StringField(3)
  localFqdns = _messages.StringField(4, repeated=True)
  targetServiceAttachmentUri = _messages.StringField(5)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TimeOfDay(_messages.Message):
  r"""Represents a time of day. The date and time zone are either not
  significant or are specified elsewhere. An API may choose to allow leap
  seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.

  Fields:
    hours: Hours of a day in 24 hour format. Must be greater than or equal to
      0 and typically must be less than or equal to 23. An API may choose to
      allow the value "24:00:00" for scenarios like business closing time.
    minutes: Minutes of an hour. Must be greater than or equal to 0 and less
      than or equal to 59.
    nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
      to 0 and less than or equal to 999,999,999.
    seconds: Seconds of a minute. Must be greater than or equal to 0 and
      typically must be less than or equal to 59. An API may allow the value
      60 if it allows leap-seconds.
  """

  hours = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minutes = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  nanos = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  seconds = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class UserMetadata(_messages.Message):
  r"""Metadata about users for a Looker instance.

  Fields:
    additionalDeveloperUserCount: Optional. The number of additional developer
      users the instance owner has purchased.
    additionalStandardUserCount: Optional. The number of additional standard
      users the instance owner has purchased.
    additionalViewerUserCount: Optional. The number of additional viewer users
      the instance owner has purchased.
  """

  additionalDeveloperUserCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  additionalStandardUserCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  additionalViewerUserCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
