/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing;

import java.io.File;
import org.gradle.api.internal.tasks.testing.TestDefinition;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class DirectoryBasedTestDefinition
implements TestDefinition {
    private final File dir;

    public DirectoryBasedTestDefinition(File dir) {
        this.dir = dir.getAbsoluteFile();
    }

    public File getTestDefinitionsDir() {
        return this.dir;
    }

    @Override
    public String getId() {
        return this.dir.getAbsolutePath();
    }

    public String getDisplayName() {
        return "tests in directory '" + this.dir.getAbsolutePath() + "'";
    }

    @Override
    public boolean matches(TestSelectionMatcher matcher) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectoryBasedTestDefinition that = (DirectoryBasedTestDefinition)o;
        return this.dir.equals(that.dir);
    }

    public int hashCode() {
        return this.dir.hashCode();
    }

    public String toString() {
        return "DirectoryBasedTestDefinition(" + this.getId() + ')';
    }
}

