/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.JavaVersion;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.NoCompatibleVariantsFailure;

public abstract class AbstractJVMVersionTooNewFailureDescriber
extends AbstractResolutionFailureDescriber<NoCompatibleVariantsFailure> {
    protected abstract JavaVersion getJVMVersion(NoCompatibleVariantsFailure var1);

    protected final boolean isDueToJVMVersionTooNew(NoCompatibleVariantsFailure failure) {
        if (this.allLibraryCandidatesIncompatibleDueToJVMVersionTooLow(failure)) {
            JavaVersion minJVMVersionSupported = this.findMinJVMSupported((List<ResolutionCandidateAssessor.AssessedCandidate>)failure.getCandidates()).orElseThrow(IllegalStateException::new);
            return minJVMVersionSupported.compareTo((Enum)this.getJVMVersion(failure)) > 0;
        }
        return false;
    }

    private boolean allLibraryCandidatesIncompatibleDueToJVMVersionTooLow(NoCompatibleVariantsFailure failure) {
        List libraryCandidates = failure.getCandidates().stream().filter(this::isLibraryCandidate).collect(Collectors.toList());
        if (!libraryCandidates.isEmpty()) {
            boolean requestingJDKVersion = failure.getRequestedAttributes().contains(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE);
            boolean allIncompatibleDueToJDKVersion = libraryCandidates.stream().allMatch(this::isJVMVersionAttributeIncompatible);
            return requestingJDKVersion && allIncompatibleDueToJDKVersion;
        }
        return false;
    }

    protected final Optional<JavaVersion> findMinJVMSupported(List<ResolutionCandidateAssessor.AssessedCandidate> candidates) {
        return candidates.stream().filter(this::isLibraryCandidate).map(this::findMinJVMSupported).filter(Optional::isPresent).map(Optional::get).min(Comparator.comparing(JavaVersion::getMajorVersion));
    }

    private Optional<JavaVersion> findMinJVMSupported(ResolutionCandidateAssessor.AssessedCandidate candidate) {
        return candidate.getIncompatibleAttributes().stream().filter(this::isJVMVersionAttribute).map(jvmVersionAttribute -> JavaVersion.toVersion(Objects.requireNonNull(jvmVersionAttribute.getProvided()))).min(Comparator.comparing(JavaVersion::getMajorVersion));
    }

    private boolean isLibraryCandidate(ResolutionCandidateAssessor.AssessedCandidate candidate) {
        AttributeContainer candidateAttributes = candidate.getAllCandidateAttributes().getAttributes();
        for (Attribute attribute : candidateAttributes.keySet()) {
            if (!Objects.equals(attribute.getName(), Category.CATEGORY_ATTRIBUTE.getName())) continue;
            String category = String.valueOf(candidateAttributes.getAttribute(attribute));
            return Objects.equals(category, "library");
        }
        return false;
    }

    private boolean isJVMVersionAttributeIncompatible(ResolutionCandidateAssessor.AssessedCandidate candidate) {
        return candidate.getIncompatibleAttributes().stream().anyMatch(this::isJVMVersionAttribute);
    }

    private boolean isJVMVersionAttribute(ResolutionCandidateAssessor.AssessedAttribute<?> attribute) {
        return attribute.getAttribute().getName().equals(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE.getName());
    }
}

