{-# LANGUAGE CPP #-}
{-# LANGUAGE NoRebindableSyntax #-}
#if __GLASGOW_HASKELL__ >= 810
{-# OPTIONS_GHC -Wno-prepositive-qualified-module #-}
#endif
{-# OPTIONS_GHC -Wno-missing-import-lists #-}
{-# OPTIONS_GHC -w #-}

{-|
Module      : Paths_test
Description : Data file location, and package version and installation
              directories.

WARNING: This module was generated by Cabal. Any modifications will be
overwritten if the module is regenerated.

This module exports a function to locate data files, and values that record
the version of the package and some directories which the package has been
configured to be installed into.

For further information about Cabal's options for its configuration step, and
their default values, see the Cabal User Guide.
-}

module Paths_test (
    version,
    getBinDir, getLibDir, getDynLibDir, getDataDir, getLibexecDir,
    getDataFileName, getSysconfDir
  ) where


import qualified Control.Exception as Exception
import Data.Version (Version(..))
import System.Environment (getEnv)
import Prelude


#if defined(VERSION_base)

#if MIN_VERSION_base(4,0,0)
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#else
catchIO :: IO a -> (Exception.Exception -> IO a) -> IO a
#endif

#else
catchIO :: IO a -> (Exception.IOException -> IO a) -> IO a
#endif
catchIO = Exception.catch

-- |The package version.
version :: Version
version = Version [0,1,0,0] []

-- |If the argument is a filename, the result is the name of a corresponding
-- file on the system on which the program is running, if the file were listed
-- in the @data-files@ field of the package's Cabal package description file.
-- No check is performed that the given filename is listed in that field.
getDataFileName :: FilePath -> IO FilePath
getDataFileName name = do
  dir <- getDataDir
  return (dir `joinFileName` name)

-- |The location of the directory specified by Cabal's @--bindir@ option (where
-- executables that the user might invoke are installed). This can be overridden
-- at runtime using the environment variable test_bindir.
getBinDir :: IO FilePath

-- |The location of the directory specified by Cabal's @--libdir@ option (where
-- object libraries are installed). This can be overridden at runtime using the
-- environment variable test_libdir.
getLibDir :: IO FilePath

-- |The location of the directory specified by Cabal's @--dynlibdir@ option
-- (where dynamic libraries are installed). This can be overridden at runtime
-- using the environment variable test_dynlibdir.
getDynLibDir :: IO FilePath

-- |The location of the directory specified by Cabal's @--datadir@ option (where
-- architecture-independent data files are installed). This can be overridden at
-- runtime using the environment variable test_datadir.
getDataDir :: IO FilePath

-- |The location of the directory specified by Cabal's @--libexedir@ option
-- (where executables that are not expected to be invoked directly by the user
-- are installed). This can be overridden at runtime using the environment
-- variable test_libexedir.
getLibexecDir :: IO FilePath

-- |The location of the directory specified by Cabal's @--sysconfdir@ option
-- (where configuration files are installed). This can be overridden at runtime
-- using the environment variable test_sysconfdir.
getSysconfDir :: IO FilePath




bindir, libdir, dynlibdir, datadir, libexecdir, sysconfdir :: FilePath
bindir     = "/home/hugin/.cabal/bin"
libdir     = "/home/hugin/.cabal/lib/x86_64-linux-ghc-9.10.3-415c/test-0.1.0.0-inplace"
dynlibdir  = "/home/hugin/.cabal/lib/x86_64-linux-ghc-9.10.3-415c"
datadir    = "/home/hugin/.cabal/share/x86_64-linux-ghc-9.10.3-415c/test-0.1.0.0"
libexecdir = "/home/hugin/.cabal/libexec/x86_64-linux-ghc-9.10.3-415c/test-0.1.0.0"
sysconfdir = "/home/hugin/.cabal/etc"

getBinDir     = catchIO (getEnv "test_bindir")     (\_ -> return bindir)
getLibDir     = catchIO (getEnv "test_libdir")     (\_ -> return libdir)
getDynLibDir  = catchIO (getEnv "test_dynlibdir")  (\_ -> return dynlibdir)
getDataDir    = catchIO (getEnv "test_datadir")    (\_ -> return datadir)
getLibexecDir = catchIO (getEnv "test_libexecdir") (\_ -> return libexecdir)
getSysconfDir = catchIO (getEnv "test_sysconfdir") (\_ -> return sysconfdir)



joinFileName :: String -> String -> FilePath
joinFileName ""  fname = fname
joinFileName "." fname = fname
joinFileName dir ""    = dir
joinFileName dir@(c:cs) fname
  | isPathSeparator (lastChar c cs) = dir ++ fname
  | otherwise                       = dir ++ pathSeparator : fname
 where
  -- We do not use Data.List.NonEmpty.last, as that would limit the module to
  -- base >= 4.9.0.0 (GHC >= 8.0.1).
  lastChar x [] = x
  lastChar _ (x:xs) = lastChar x xs

pathSeparator :: Char
pathSeparator = '/'

isPathSeparator :: Char -> Bool
isPathSeparator c = c == '/'
