//
//  iTermSetupCfgParser.h
//  iTerm2SharedARC
//
//  Created by George Nachman on 6/24/18.
//

#import <Foundation/Foundation.h>

// This thing is a hack to avoid running executable code while installing a script. The user has to
// have a chance to inspect what they installed before it has the chance to do any damage.
// It wants a install_requires=[...] all one one line containing a list of strings quoted with '
// or " and delimited by commas. Version numbers aren't supported, but that could be added later.
@interface iTermSetupCfgParser : NSObject

@property (nonatomic, readonly) NSArray<NSString *> *dependencies;

// error in computing dependencies. Check this if dependencies is nil.
@property (nonatomic, readonly) NSError *dependenciesError;

@property (nonatomic, readonly) NSString *content;
@property (nonatomic, readonly) NSString *pythonVersion;
@property (nonatomic, readonly) NSString *name;
@property (nonatomic) NSInteger minimumEnvironmentVersion;

+ (void)writeSetupCfgToFile:(NSString *)file
                       name:(NSString *)name
               dependencies:(NSArray<NSString *> *)dependencies
        ensureiTerm2Present:(BOOL)ensureiTerm2Present
              pythonVersion:(NSString *)pythonVersion
         environmentVersion:(NSInteger)environmentVersion;

- (instancetype)initWithPath:(NSString *)path NS_DESIGNATED_INITIALIZER;
- (instancetype)init NS_UNAVAILABLE;

@end

// Ensures the resulting array has the provided dependency.
// setup.cfg dependencies are arrays of strings like "modulename" or "modulename[expression]"
// where [expression] is an (in)equality operator followed by a version number.
// The operators are:
// <    >    ==
// <=   >=   !=
@interface NSArray(SetupCfg)
- (NSArray<NSString *> *)arrayBySettingPythonDependency:(NSString *)dependency;

// Package is a package name without an operator or version number, like "iterm2".
- (BOOL)containsPythonPackage:(NSString *)package;
@end
