#lang racket/base
;; @generated by Idris 0.8.0-1b5176dc9, Racket backend
(require racket/async-channel)         ; for asynchronous channels
(require racket/future)                ; for parallelism/concurrency
(require racket/math)                  ; for math ops
(require racket/promise)               ; for delay/force in toplevel defs
(require racket/system)                ; for system
(require racket/unsafe/ops)            ; for fast fixnum ops
(require rnrs/bytevectors-6)           ; for buffers
(require rnrs/io/ports-6)              ; for files
(require srfi/19)                      ; for file handling and data
(require ffi/unsafe ffi/unsafe/define) ; for calling C

(require racket/flonum)                ; for float-typed transcendental functions
(require math/flonum)                  ; for flonum constants
(define-ffi-definer define-libidris2_support (ffi-lib "libidris2_support" ))
(define-libidris2_support idris2_putStr (_fun _string/utf-8 -> _void))
(define-ffi-definer define-libc (ffi-lib #f))
(define-libc putchar (_fun _int8 -> _void))
(define-libidris2_support idris2_getString (_fun _pointer -> _string/utf-8))
(define-libidris2_support idris2_getStr (_fun  -> _string/utf-8))
(define-libc getchar (_fun  -> _int8))
(define-libidris2_support idris2_isNull (_fun _pointer -> _int))
(define-libidris2_support idris2_openDir (_fun _string/utf-8 -> _pointer))
(define-libidris2_support idris2_nextDirEntry (_fun _pointer -> _pointer))
(define-libidris2_support idris2_currentDirectory (_fun  -> _pointer))
(define-libidris2_support idris2_createDir (_fun _string/utf-8 -> _int))
(define-libidris2_support idris2_closeDir (_fun _pointer -> _void))
(define-libidris2_support idris2_changeDir (_fun _string/utf-8 -> _int))
(define-libidris2_support idris2_free (_fun _pointer -> _void))
(define-libidris2_support idris2_stdout (_fun  -> _pointer))
(define-libidris2_support idris2_stdin (_fun  -> _pointer))
(define-libidris2_support idris2_stderr (_fun  -> _pointer))
(define-libidris2_support idris2_writeLine (_fun _pointer _string/utf-8 -> _int))
(define-libidris2_support idris2_seekLine (_fun _pointer -> _int))
(define-libidris2_support idris2_removeFile (_fun _string/utf-8 -> _int))
(define-libidris2_support idris2_readLine (_fun _pointer -> _pointer))
(define-libc fgetc (_fun _pointer -> _int))
(define-libidris2_support idris2_eof (_fun _pointer -> _int))
(define-libidris2_support idris2_fileErrno (_fun  -> _int))
(define-libidris2_support idris2_fileError (_fun _pointer -> _int))
(define-libidris2_support idris2_strerror (_fun _int -> _string/utf-8))
(define-libidris2_support idris2_getErrno (_fun  -> _int))
(define-libidris2_support idris2_openFile (_fun _string/utf-8 _string/utf-8 -> _pointer))
(define-libidris2_support idris2_closeFile (_fun _pointer -> _void))
(define-libidris2_support idris2_popen (_fun _string/utf-8 _string/utf-8 -> _pointer))
(define-libidris2_support idris2_pclose (_fun _pointer -> _int))
(define-libc fflush (_fun _pointer -> _int))
(define-libidris2_support idris2_chmod (_fun _string/utf-8 _int -> _int))
(define-libidris2_support idris2_filetimeStatusTimeSec (_fun _pointer -> _int))
(define-libidris2_support idris2_filetimeStatusTimeNsec (_fun _pointer -> _int))
(define-libidris2_support idris2_filetimeModifiedTimeSec (_fun _pointer -> _int))
(define-libidris2_support idris2_filetimeModifiedTimeNsec (_fun _pointer -> _int))
(define-libidris2_support idris2_filetimeAccessTimeSec (_fun _pointer -> _int))
(define-libidris2_support idris2_filetimeAccessTimeNsec (_fun _pointer -> _int))
(define-libidris2_support idris2_fileTime (_fun _pointer -> _pointer))
(define-libidris2_support idris2_fileSize (_fun _pointer -> _int))
(define-libidris2_support idris2_fileIsTTY (_fun _pointer -> _int))
(define-libidris2_support idris2_writeBufferData (_fun _pointer _bytes _int _int -> _int))
(define-libidris2_support idris2_readBufferData (_fun _pointer _bytes _int _int -> _int))
(define-libidris2_support idris2_system (_fun _string/utf-8 -> _int))
(define-libc getenv (_fun _string/utf-8 -> _pointer))
(define-libc exit (_fun _int -> _void))
(define-libidris2_support idris2_setupTerm (_fun  -> _void))
(define-libidris2_support idris2_getTermCols (_fun  -> _int))
(define-libidris2_support idrnet_socket (_fun _int _int _int -> _int))
(define-libidris2_support idrnet_sockaddr_unix (_fun _pointer -> _string/utf-8))
(define-libidris2_support idrnet_sockaddr_port (_fun _int -> _int))
(define-libidris2_support idrnet_sockaddr_ipv4 (_fun _pointer -> _string/utf-8))
(define-libidris2_support idrnet_sockaddr_family (_fun _pointer -> _int))
(define-libidris2_support idrnet_listen (_fun _int _int -> _int))
(define-libidris2_support idrnet_fdopen (_fun _int _string/utf-8 -> _pointer))
(define-libidris2_support idrnet_create_sockaddr (_fun  -> _pointer))
(define-libidris2_support idrnet_bind (_fun _int _int _int _string/utf-8 _int -> _int))
(define-libidris2_support idrnet_accept (_fun _int _pointer -> _int))
(define-libidris2_support idrnet_errno (_fun  -> _int))
(define-libidris2_support idrnet_af_unspec (_fun  -> _int))
(define-libidris2_support idrnet_af_unix (_fun  -> _int))
(define-libidris2_support idrnet_af_inet6 (_fun  -> _int))
(define-libidris2_support idrnet_af_inet (_fun  -> _int))

(let ()
(define (blodwen-os)
  (case (system-type 'os)
    [(unix) "unix"]
    [(macosx) "darwin"]
    [(windows) "windows"]
    [else "unknown"]))

(define blodwen-lazy
  (lambda (f)
    (let ([evaluated #f] [res void])
      (lambda ()
        (if (not evaluated)
            (begin (set! evaluated #t)
                   (set! res (f))
                   (set! f void))
            (void))
        res))))

(define bwp 'bwp)

(define (blodwen-delay-lazy f)
  (mcons (make-weak-box bwp) f))

(define (blodwen-force-lazy e)
  (let ((exval (weak-box-value (mcar e) bwp)))
    (if (eq? exval bwp)
      (let ((val ((mcdr e))))
        (begin (set-mcar! e (make-weak-box val)) val))
      exval)))

(define (blodwen-toSignedInt x bits)
  (if (bitwise-bit-set? x bits)
      (bitwise-ior x (arithmetic-shift (- 1) bits))
      (bitwise-and x (sub1 (arithmetic-shift 1 bits)))))

(define (blodwen-toUnsignedInt x bits)
  (bitwise-and x (sub1 (arithmetic-shift 1 bits))))

(define (blodwen-euclidDiv a b)
  (let ((q (quotient a b))
        (r (remainder a b)))
    (if (< r 0)
      (if (> b 0) (- q 1) (+ q 1))
      q)))

(define (blodwen-euclidMod a b)
  (let ((r (remainder a b)))
    (if (< r 0)
      (if (> b 0) (+ r b) (- r b))
      r)))

; flonum constants

;; /!\ this code is cursed for some reason?...
;;
;; (define (blodwen-flonumEpsilon)
;;   epsilon.0)

(define (blodwen-calcFlonumUnitRoundoff)
;;  (fl/ (blodwen-flonumEpsilon) 2.0))
  (let loop [(uro 1.0)]
    (if (fl= 1.0 (fl+ 1.0 uro))
      uro
      (loop (fl/ uro 2.0)))))

(define (blodwen-calcFlonumEpsilon)
  (fl* (blodwen-calcFlonumUnitRoundoff) 2.0))

(define (blodwen-flonumNaN)
  +nan.0)

(define (blodwen-flonumInf)
  +inf.0)

; Bits

(define bu+ (lambda (x y bits) (blodwen-toUnsignedInt (+ x y) bits)))
(define bu- (lambda (x y bits) (blodwen-toUnsignedInt (- x y) bits)))
(define bu* (lambda (x y bits) (blodwen-toUnsignedInt (* x y) bits)))
(define bu/ (lambda (x y bits) (blodwen-toUnsignedInt (quotient x y) bits)))

(define bs+ (lambda (x y bits) (blodwen-toSignedInt (+ x y) bits)))
(define bs- (lambda (x y bits) (blodwen-toSignedInt (- x y) bits)))
(define bs* (lambda (x y bits) (blodwen-toSignedInt (* x y) bits)))
(define bs/ (lambda (x y bits) (blodwen-toSignedInt (blodwen-euclidDiv x y) bits)))

; To match Chez
(define (fxadd1 x) (unsafe-fx+ x 1))
(define (fxsub1 x) (unsafe-fx- x 1))

(define (integer->bits8 x) (bitwise-and x #xff))
(define (integer->bits16 x) (bitwise-and x #xffff))
(define (integer->bits32 x) (bitwise-and x #xffffffff))
(define (integer->bits64 x) (bitwise-and x #xffffffffffffffff))

(define (bits16->bits8 x) (bitwise-and x #xff))
(define (bits32->bits8 x) (bitwise-and x #xff))
(define (bits64->bits8 x) (bitwise-and x #xff))
(define (bits32->bits16 x) (bitwise-and x #xffff))
(define (bits64->bits16 x) (bitwise-and x #xffff))
(define (bits64->bits32 x) (bitwise-and x #xffffffff))

(define blodwen-bits-shl (lambda (x y bits) (remainder (arithmetic-shift x y) (arithmetic-shift 1 bits))))
(define blodwen-shl (lambda (x y) (arithmetic-shift x y)))
(define blodwen-shr (lambda (x y) (arithmetic-shift x (- y))))
(define blodwen-and (lambda (x y) (bitwise-and x y)))
(define blodwen-or (lambda (x y) (bitwise-ior x y)))
(define blodwen-xor (lambda (x y) (bitwise-xor x y)))

(define exact-floor
  (lambda (x)
    (inexact->exact (floor x))))

(define blodwen-bits-shl-signed
  (lambda (x y bits) (blodwen-toSignedInt (arithmetic-shift x y) bits)))

(define exact-truncate
  (lambda (x)
    (inexact->exact (truncate x))))

(define exact-truncate-boundedInt
  (lambda (x y)
    (blodwen-toSignedInt (exact-truncate x) y)))

(define exact-truncate-boundedUInt
  (lambda (x y)
    (blodwen-toUnsignedInt (exact-truncate x) y)))

(define cast-char-boundedInt
  (lambda (x y)
    (blodwen-toSignedInt (char->integer x) y)))

(define cast-char-boundedUInt
  (lambda (x y)
    (blodwen-toUnsignedInt (char->integer x) y)))

(define cast-string-int
  (lambda (x)
    (exact-truncate (cast-num (string->number (destroy-prefix x))))))

(define cast-string-boundedInt
  (lambda (x y)
    (blodwen-toSignedInt (cast-string-int x) y)))

(define cast-string-boundedUInt
  (lambda (x y)
    (blodwen-toUnsignedInt (cast-string-int x) y)))

(define cast-num
  (lambda (x)
    (if (number? x) x 0)))
(define destroy-prefix
  (lambda (x)
    (cond
      ((equal? x "") "")
      ((equal? (string-ref x 0) #\#) "")
      (else x))))

(define cast-int-char
  (lambda (x)
    (if (or
          (and (>= x 0) (<= x #xd7ff))
          (and (>= x #xe000) (<= x #x10ffff)))
        (integer->char x)
        (integer->char 0))))

(define cast-string-double
  (lambda (x)
    (exact->inexact (cast-num (string->number (destroy-prefix x))))))
(define (string-concat xs) (apply string-append xs))
(define (string-unpack s) (string->list s))
(define (string-pack xs) (list->string xs))
(define string-cons (lambda (x y) (string-append (string x) y)))
(define string-reverse (lambda (x)
  (list->string (reverse (string->list x)))))
(define (string-substr off len s)
    (let* ((l (string-length s))
          (b (max 0 off))
          (x (max 0 len))
          (end (min l (+ b x))))
          (substring s b end)))

(define (blodwen-string-iterator-new s)
  0)

(define (blodwen-string-iterator-to-string _ s ofs f)
  (f (substring s ofs (string-length s))))

(define (blodwen-string-iterator-next s ofs)
  (if (>= ofs (string-length s))
      '() ; EOF
      (cons (string-ref s ofs) (+ ofs 1))))

(define either-left
  (lambda (x)
    (vector 0 x)))

(define either-right
  (lambda (x)
    (vector 1 x)))

(define blodwen-error-quit
  (lambda (msg)
    (display msg)
    (newline)
    (exit 1)))

(define (blodwen-get-line p)
    (if (port? p)
        (let ((str (read-line p)))
            (if (eof-object? str)
                ""
                str))
        (void)))

(define (blodwen-get-char p)
    (if (port? p)
        (let ((chr (read-char p)))
            (if (eof-object? chr)
                #\nul
                chr))
        (void)))

;; Buffers

(define (blodwen-new-buffer size)
  (make-bytevector size 0))

(define (blodwen-buffer-size buf)
  (bytevector-length buf))

(define (blodwen-buffer-setbyte buf loc val)
  (bytevector-u8-set! buf loc val))

(define (blodwen-buffer-getbyte buf loc)
  (bytevector-u8-ref buf loc))

(define (blodwen-buffer-setbits16 buf loc val)
  (bytevector-u16-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getbits16 buf loc)
  (bytevector-u16-ref buf loc (native-endianness)))

(define (blodwen-buffer-setbits32 buf loc val)
  (bytevector-u32-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getbits32 buf loc)
  (bytevector-u32-ref buf loc (native-endianness)))

(define (blodwen-buffer-setbits64 buf loc val)
  (bytevector-u64-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getbits64 buf loc)
  (bytevector-u64-ref buf loc (native-endianness)))

(define (blodwen-buffer-setint32 buf loc val)
  (bytevector-s32-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getint32 buf loc)
  (bytevector-s32-ref buf loc (native-endianness)))

(define (blodwen-buffer-setint buf loc val)
  (bytevector-s64-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getint buf loc)
  (bytevector-s64-ref buf loc (native-endianness)))

(define (blodwen-buffer-setdouble buf loc val)
  (bytevector-ieee-double-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getdouble buf loc)
  (bytevector-ieee-double-ref buf loc (native-endianness)))

(define (blodwen-stringbytelen str)
  (bytevector-length (string->utf8 str)))

(define (blodwen-buffer-setstring buf loc val)
  (let* [(strvec (string->utf8 val))
         (len (bytevector-length strvec))]
    (bytevector-copy! strvec 0 buf loc len)))

(define (blodwen-buffer-getstring buf loc len)
  (let [(newvec (make-bytevector len))]
    (bytevector-copy! buf loc newvec 0 len)
    (utf8->string newvec)))

(define (blodwen-buffer-copydata buf start len dest loc)
  (bytevector-copy! buf start dest loc len))

;; Threads

;; NB: Racket threads are green/virtual threads meaning extra caution is to be
;; taken when using FFI functions in combination with threads. The *entire*
;; Racket runtime blocks on a foreign call, meaning no threads will progress
;; until the foreign call returns.

(define (blodwen-thread proc)
  (thread (lambda () (proc (vector 0)))))

(define (blodwen-thread-wait handle)
  (thread-wait handle))

;; Thread mailboxes

(define blodwen-thread-data (make-thread-cell #f))

(define (blodwen-get-thread-data ty)
  (thread-cell-ref blodwen-thread-data))

(define (blodwen-set-thread-data ty a)
  (thread-cell-set! blodwen-thread-data a))

;; Semaphores

(define (blodwen-make-semaphore init)
  (make-semaphore init))

(define (blodwen-semaphore-post sema)
  (semaphore-post sema))

(define (blodwen-semaphore-wait sema)
  (semaphore-wait sema))

;; Barriers

(struct barrier (count-box num-threads mutex semaphore))

(define (blodwen-make-barrier num-threads)
  (barrier (box 0) num-threads (blodwen-make-mutex) (make-semaphore 0)))

(define (blodwen-barrier-wait barrier)
  (blodwen-mutex-acquire (barrier-mutex barrier))
  (let* [(count-box (barrier-count-box barrier))
         (count-old (unbox count-box))
         (count-new (+ count-old 1))
         (sema (barrier-semaphore barrier))]
    (set-box! count-box count-new)
    (blodwen-mutex-release (barrier-mutex barrier))
    (when (= count-new (barrier-num-threads barrier)) (semaphore-post sema))
    (semaphore-wait sema)
    (semaphore-post sema)
    ))

;; Channels

(define (blodwen-make-channel ty)
  (make-async-channel 1))

(define (blodwen-channel-get ty chan)
  (async-channel-get chan))

(define (blodwen-channel-put ty chan val)
  (async-channel-put chan val))

;; Mutex

(define (blodwen-make-mutex)
  (make-semaphore 1))

(define (blodwen-mutex-acquire sema)
  (semaphore-wait sema))

(define (blodwen-mutex-release sema)
  (if (semaphore-try-wait? sema)
      (blodwen-error-quit "Exception in mutexRelease: thread does not own mutex")
      (semaphore-post sema)))

;; Condition Variables
;; As per p.5 of the MS paper
;; https://www.microsoft.com/en-us/research/wp-content/uploads/2004/12/ImplementingCVs.pdf

; The MS paper has the mutex be part of the CV, but that seems to be contrary to
; most other implementations
(struct cv (countingSem waitersLock waiters handshakeSem) #:mutable)

; CONSTRUCTOR
(define (blodwen-make-cv)
  (let ([s (make-semaphore 0)]
        [x (make-semaphore 1)]
        [h (make-semaphore 0)])
    (cv s x 0 h)))

;; MS paper: sem.V() := sem-post  /* "sem.V() increments sem.count, atomically" */
;;           sem.P() := sem-wait
;; (turns out this is Dijkstra's fault: P and V match up with the Dutch
;;  terminology)

; WAIT
(define (blodwen-cv-wait my-cv m)
    ; atomically increment waiters
    (semaphore-wait (cv-waitersLock my-cv))
    (set-cv-waiters! my-cv (+ (cv-waiters my-cv) 1))
    (semaphore-post (cv-waitersLock my-cv))
    ; release the provided mutex
    (blodwen-mutex-release m)
    ; wait for the counting semaphore to let us through
    (semaphore-wait (cv-countingSem my-cv))
    ; signal to broadcast that we have proceeded past the critical point/have
    ; been woken up successfully
    (semaphore-post (cv-handshakeSem my-cv))
    ; re-acquire the provided mutex
    (blodwen-mutex-acquire m)
    )

; SIGNAL
(define (blodwen-cv-signal my-cv)
    ; lock access to waiters
    (semaphore-wait (cv-waitersLock my-cv))
    (let ([waiters (cv-waiters my-cv)])
      (if (> waiters 0)

        ; if we have waiting threads, signal one of them
        (begin
          (set-cv-waiters! my-cv (- waiters 1))
          ; increment the counting semaphore to wake up a thread
          (semaphore-post (cv-countingSem my-cv))
          ; wait for the thread to tell us it's okay to proceed
          (semaphore-wait (cv-handshakeSem my-cv))
          )

        ; otherwise, do nothing
        (void)
        )
       ; unlock access to waiters
       (semaphore-post (cv-waitersLock my-cv))
       ))

; BROADCAST HELPERS

; for (int i = 0; i < waiters; i++) s.V();
(define (broadcast-for-helper my-cv i)
    (if (= i 0)
      ; if i is zero, we're done
      (void)
      ; otherwise, we signal one waiting thread, decrement i, and keep going
      (begin
        (semaphore-post (cv-countingSem my-cv))

        (broadcast-for-helper my-cv (- i 1))
        )))

; while (waiters > 0) { waiters--; h.P(); }
(define (broadcast-while-helper my-cv waiters)
    (if (= waiters 0)
      ; if waiters is 0, we're done
      (void)
      ; otherwise, wait for "waiters" many threads to tell us they're awake
      (begin
        (semaphore-wait (cv-handshakeSem my-cv))
        (broadcast-while-helper my-cv (- waiters 1))
        )))

; BROADCAST
(define (blodwen-cv-broadcast my-cv)
    ; lock access to waiters
    (semaphore-wait (cv-waitersLock my-cv))
    (let ([waiters (cv-waiters my-cv)])
      ; signal "waiters" many threads; counting *until* 0 in the helper
      ; function, hence "waiters" and NOT "waiters - 1"
      (broadcast-for-helper my-cv waiters)
      ; wait on "waiters" many threads to have been woken
      (broadcast-while-helper my-cv waiters)
      ; unlock access to waiters
      (semaphore-post (cv-waitersLock my-cv))
      ))

; FIXME: Maybe later. Possibly difficult because of the handshake thingy?
;(define (blodwen-cv-wait-timeout my-cv lockM timeout)
;  ;; precondition: calling thread holds lockM
;   (semaphore-wait (cv-waitersLock my-cv))                 ; x.P()
;   (set-cv-waiters! my-cv (+ (cv-waiters my-cv) 1)) ; waiters++
;   (semaphore-post (cv-waitersLock my-cv))                 ; x.V()
;   (blodwen-mutex-release lockM)                    ; m.Release()
;
;   (sync/timeout (/ timeout 1000000) (cv-countingSem my-cv))
;
;   (semaphore-wait (cv-countingSem my-cv))                 ; s.P()
;   (semaphore-post (cv-handshakeSem my-cv))                 ; h.V()
;   (blodwen-mutex-acquire lockM)                    ; m.Acquire()
;   )


(define (blodwen-make-future ty work) (future (lambda () (work '()))))
(define (blodwen-await-future ty future) (touch future))

;; NB: These should *ALWAYS* be used in multi-threaded programs since Racket
;; threads are green/virtual threads and so using an external function will
;; block the *entire* runtime until the function returns. This is fine for most
;; things, but not for `sleep`.
(define (blodwen-sleep s) (sleep s))
(define (blodwen-usleep us) (sleep (* 0.000001 us)))

(define (blodwen-clock-time-utc) (current-time 'time-utc))
(define (blodwen-clock-time-monotonic) (current-time 'time-monotonic))
(define (blodwen-clock-time-duration) (current-time 'time-duration))
(define (blodwen-clock-time-process) (current-time 'time-process))
(define (blodwen-clock-time-thread) (current-time 'time-thread))
(define (blodwen-clock-time-gccpu) 0) ;; unsupported
(define (blodwen-clock-time-gcreal) 0) ;; unsupported
(define (blodwen-is-time? clk) (if (time? clk) 1 0))
(define (blodwen-clock-second time) (time-second time))
(define (blodwen-clock-nanosecond time) (time-nanosecond time))

(define (blodwen-arg-count)
  (+ (vector-length (current-command-line-arguments)) 1))

(define (blodwen-arg n)
  (cond
    ((= n 0) (path->string (find-system-path 'run-file)))
    ((< n (+ (vector-length (current-command-line-arguments)) 1))
        (vector-ref (current-command-line-arguments) (- n 1)))
     (else "")))

;; Randoms
(random-seed (date*-nanosecond (current-date))) ; initialize random seed

(define (blodwen-random-seed s) (random-seed s))
(define blodwen-random
  (case-lambda
    ;; no argument, pick a real value from [0, 1.0)
    [() (random)]
    ;; single argument k, pick an integral value from [0, k)
    [(k) (if (> k 0)
           (random k)
           (raise 'blodwen-random-invalid-range-argument))]))

;; For finalisers

(define (blodwen-register-object obj proc)
   (register-finalizer obj (lambda (ptr) ((proc ptr) 'erased)))
   obj)

;; For creating and reading back scheme objects

(define ns (make-base-namespace))

; read a scheme string and evaluate it, returning 'Just result' on success
; TODO: catch exception!
(define (blodwen-eval-scheme str)
  (with-handlers ([exn:fail? (lambda (x) '())]) ; Nothing on failure
     (box (eval (read (open-input-string str)) ns))) ; box == Just
)

(define (blodwen-eval-okay obj)
  (if (null? obj)
      0
      1))

(define (blodwen-get-eval-result obj)
  (unbox obj))

(define (blodwen-debug-scheme obj)
  (display obj) (newline))

(define (blodwen-is-number obj)
  (if (number? obj) 1 0))

(define (blodwen-is-integer obj)
  (if (and (number? obj) (exact? obj)) 1 0))

(define (blodwen-is-float obj)
  (if (flonum? obj) 1 0))

(define (blodwen-is-char obj)
  (if (char? obj) 1 0))

(define (blodwen-is-string obj)
  (if (string? obj) 1 0))

(define (blodwen-is-procedure obj)
  (if (procedure? obj) 1 0))

(define (blodwen-is-symbol obj)
  (if (symbol? obj) 1 0))

(define (blodwen-is-vector obj)
  (if (vector? obj) 1 0))

(define (blodwen-is-nil obj)
  (if (null? obj) 1 0))

(define (blodwen-is-pair obj)
  (if (pair? obj) 1 0))

(define (blodwen-is-box obj)
  (if (box? obj) 1 0))

(define (blodwen-make-symbol str)
  (string->symbol str))

; The below rely on checking that the objects are the right type first.

(define (blodwen-vector-ref obj i)
  (vector-ref obj i))

(define (blodwen-vector-length obj)
  (vector-length obj))

(define (blodwen-vector-list obj)
  (vector->list obj))

(define (blodwen-unbox obj)
  (unbox obj))

(define (blodwen-apply obj arg)
  (obj arg))

(define (blodwen-force obj)
  (obj))

(define (blodwen-read-symbol sym)
  (symbol->string sym))

(define (blodwen-id x) x)
(define PreludeC-45Types-fastUnpack (lambda (farg-0) (string-unpack farg-0)))
(define PreludeC-45Types-fastPack (lambda (farg-0) (string-pack farg-0)))
(define PreludeC-45Types-fastConcat (lambda (farg-0) (string-concat farg-0)))
(define PreludeC-45IO-prim__putStr (lambda (farg-0 farg-1) (idris2_putStr farg-0) (vector 0 )))
(define PreludeC-45IO-prim__putChar (lambda (farg-0 farg-1) (putchar (char->integer farg-0)) (vector 0 )))
(define PreludeC-45IO-prim__getString (lambda (farg-0) (idris2_getString farg-0)))
(define PreludeC-45IO-prim__getStr (lambda (farg-0) (idris2_getStr )))
(define PreludeC-45IO-prim__getChar (lambda (farg-0) (integer->char (getchar ))))
(define PrimIO-prim__nullAnyPtr (lambda (farg-0) (idris2_isNull farg-0)))
(define SystemC-45Directory-prim__openDir (lambda (farg-0 farg-1) (idris2_openDir farg-0)))
(define SystemC-45Directory-prim__dirEntry (lambda (farg-0 farg-1) (idris2_nextDirEntry farg-0)))
(define SystemC-45Directory-prim__currentDir (lambda (farg-0) (idris2_currentDirectory )))
(define SystemC-45Directory-prim__createDir (lambda (farg-0 farg-1) (idris2_createDir farg-0)))
(define SystemC-45Directory-prim__closeDir (lambda (farg-0 farg-1) (idris2_closeDir farg-0) (vector 0 )))
(define SystemC-45Directory-prim__changeDir (lambda (farg-0 farg-1) (idris2_changeDir farg-0)))
(define SystemC-45FFI-prim__free (lambda (farg-0 farg-1) (idris2_free farg-0) (vector 0 )))
(define SystemC-45FileC-45Virtual-prim__stdout (lambda () (idris2_stdout )))
(define SystemC-45FileC-45Virtual-prim__stdin (lambda () (idris2_stdin )))
(define SystemC-45FileC-45Virtual-prim__stderr (lambda () (idris2_stderr )))
(define SystemC-45FileC-45ReadWrite-prim__writeLine (lambda (farg-0 farg-1 farg-2) (idris2_writeLine farg-0 farg-1)))
(define SystemC-45FileC-45ReadWrite-prim__seekLine (lambda (farg-0 farg-1) (idris2_seekLine farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__removeFile (lambda (farg-0 farg-1) (idris2_removeFile farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__readLine (lambda (farg-0 farg-1) (idris2_readLine farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__readChar (lambda (farg-0 farg-1) (fgetc farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__eof (lambda (farg-0 farg-1) (idris2_eof farg-0)))
(define SystemC-45FileC-45Error-prim__fileErrno (lambda (farg-0) (idris2_fileErrno )))
(define SystemC-45FileC-45Error-prim__error (lambda (farg-0 farg-1) (idris2_fileError farg-0)))
(define SystemC-45Errno-prim__strerror (lambda (farg-0 farg-1) (idris2_strerror farg-0)))
(define SystemC-45Errno-prim__getErrno (lambda (farg-0) (idris2_getErrno )))
(define SystemC-45FileC-45Handle-prim__open (lambda (farg-0 farg-1 farg-2) (idris2_openFile farg-0 farg-1)))
(define SystemC-45FileC-45Handle-prim__close (lambda (farg-0 farg-1) (idris2_closeFile farg-0) (vector 0 )))
(define SystemC-45FileC-45Process-prim__popen (lambda (farg-0 farg-1 farg-2) (idris2_popen farg-0 farg-1)))
(define SystemC-45FileC-45Process-prim__pclose (lambda (farg-0 farg-1) (idris2_pclose farg-0)))
(define SystemC-45FileC-45Process-prim__flush (lambda (farg-0 farg-1) (fflush farg-0)))
(define SystemC-45FileC-45Permissions-prim__chmod (lambda (farg-0 farg-1 farg-2) (idris2_chmod farg-0 farg-1)))
(define SystemC-45FileC-45Meta-prim__filetimeStatusTimeSec (lambda (farg-0 farg-1) (idris2_filetimeStatusTimeSec farg-0)))
(define SystemC-45FileC-45Meta-prim__filetimeStatusTimeNsec (lambda (farg-0 farg-1) (idris2_filetimeStatusTimeNsec farg-0)))
(define SystemC-45FileC-45Meta-prim__filetimeModifiedTimeSec (lambda (farg-0 farg-1) (idris2_filetimeModifiedTimeSec farg-0)))
(define SystemC-45FileC-45Meta-prim__filetimeModifiedTimeNsec (lambda (farg-0 farg-1) (idris2_filetimeModifiedTimeNsec farg-0)))
(define SystemC-45FileC-45Meta-prim__filetimeAccessTimeSec (lambda (farg-0 farg-1) (idris2_filetimeAccessTimeSec farg-0)))
(define SystemC-45FileC-45Meta-prim__filetimeAccessTimeNsec (lambda (farg-0 farg-1) (idris2_filetimeAccessTimeNsec farg-0)))
(define SystemC-45FileC-45Meta-prim__fileTime (lambda (farg-0 farg-1) (idris2_fileTime farg-0)))
(define SystemC-45FileC-45Meta-prim__fileSize (lambda (farg-0 farg-1) (idris2_fileSize farg-0)))
(define SystemC-45FileC-45Meta-prim__fileIsTTY (lambda (farg-0 farg-1) (idris2_fileIsTTY farg-0)))
(define SystemC-45FileC-45Buffer-prim__writeBufferData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4) (idris2_writeBufferData farg-0 farg-1 farg-2 farg-3)))
(define SystemC-45FileC-45Buffer-prim__readBufferData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4) (idris2_readBufferData farg-0 farg-1 farg-2 farg-3)))
(define DataC-45Buffer-stringByteLength (lambda (farg-0) (blodwen-stringbytelen farg-0)))
(define DataC-45Buffer-prim__setString (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setstring farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__setInt (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setint farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__setDouble (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setdouble farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__setBits8 (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setbyte farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__newBuffer (lambda (farg-0 farg-1) (blodwen-new-buffer farg-0)))
(define DataC-45Buffer-prim__getString (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-getstring farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__getInt (lambda (farg-0 farg-1 farg-2) (blodwen-buffer-getint farg-0 farg-1)))
(define DataC-45Buffer-prim__getDouble (lambda (farg-0 farg-1 farg-2) (blodwen-buffer-getdouble farg-0 farg-1)))
(define DataC-45Buffer-prim__getBits8 (lambda (farg-0 farg-1 farg-2) (blodwen-buffer-getbyte farg-0 farg-1)))
(define DataC-45Buffer-prim__copyData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4 farg-5) (blodwen-buffer-copydata farg-0 farg-1 farg-2 farg-3 farg-4)))
(define DataC-45Buffer-prim__bufferSize (lambda (farg-0) (blodwen-buffer-size farg-0)))
(define System-prim__system (lambda (farg-0 farg-1) (idris2_system farg-0)))
(define System-prim__getEnv (lambda (farg-0 farg-1) (getenv farg-0)))
(define System-prim__getArgCount (lambda (farg-0) (blodwen-arg-count )))
(define System-prim__getArg (lambda (farg-0 farg-1) (blodwen-arg farg-0)))
(define System-prim__exit (lambda (farg-0 farg-1) (exit farg-0) (vector 0 )))
(define LibrariesC-45UtilsC-45Scheme-unsafeVectorToList (lambda (farg-0) (blodwen-vector-list farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeVectorRef (lambda (farg-0 farg-1) (blodwen-vector-ref farg-0 farg-1)))
(define LibrariesC-45UtilsC-45Scheme-unsafeVectorLength (lambda (farg-0) (blodwen-vector-length farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeUnbox (lambda (farg-0) (blodwen-unbox farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeSnd (lambda (farg-0) (cdr farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeReadSymbol (lambda (farg-0) (blodwen-read-symbol farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetString (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetInteger (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetFloat (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetChar (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeFst (lambda (farg-0) (car farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeForce (lambda (farg-0) (blodwen-force farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeApply (lambda (farg-0 farg-1) (blodwen-apply farg-0 farg-1)))
(define LibrariesC-45UtilsC-45Scheme-prim_isVector (lambda (farg-0) (blodwen-is-vector farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isSymbol (lambda (farg-0) (blodwen-is-symbol farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isString (lambda (farg-0) (blodwen-is-string farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isProcedure (lambda (farg-0) (blodwen-is-procedure farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isPair (lambda (farg-0) (blodwen-is-pair farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isInteger (lambda (farg-0) (blodwen-is-integer farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isFloat (lambda (farg-0) (blodwen-is-float farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isChar (lambda (farg-0) (blodwen-is-char farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isBox (lambda (farg-0) (blodwen-is-box farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim__evalScheme (lambda (farg-0) (blodwen-eval-scheme farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim__evalResult (lambda (farg-0) (blodwen-get-eval-result farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim__evalOkay (lambda (farg-0) (blodwen-eval-okay farg-0)))
(define SystemC-45Clock-prim__osClockValid (lambda (farg-0 farg-1) (blodwen-is-time? farg-0)))
(define SystemC-45Clock-prim__osClockSecond (lambda (farg-0 farg-1) (blodwen-clock-second farg-0)))
(define SystemC-45Clock-prim__osClockNanosecond (lambda (farg-0 farg-1) (blodwen-clock-nanosecond farg-0)))
(define SystemC-45Clock-prim__clockTimeUtc (lambda (farg-0) (blodwen-clock-time-utc )))
(define SystemC-45Clock-prim__clockTimeThread (lambda (farg-0) (blodwen-clock-time-thread )))
(define SystemC-45Clock-prim__clockTimeProcess (lambda (farg-0) (blodwen-clock-time-process )))
(define SystemC-45Clock-prim__clockTimeMonotonic (lambda (farg-0) (blodwen-clock-time-monotonic )))
(define SystemC-45Clock-prim__clockTimeGcReal (lambda (farg-0) (blodwen-clock-time-gcreal )))
(define SystemC-45Clock-prim__clockTimeGcCpu (lambda (farg-0) (blodwen-clock-time-gccpu )))
(define LibrariesC-45DataC-45StringC-45Iterator-uncons (lambda (farg-0 farg-1) (blodwen-string-iterator-next farg-0 farg-1)))
(define LibrariesC-45DataC-45StringC-45Iterator-fromString (lambda (farg-0) (blodwen-string-iterator-new farg-0)))
(define SystemC-45Term-prim__setupTerm (lambda (farg-0) (idris2_setupTerm ) (vector 0 )))
(define SystemC-45Term-prim__getTermCols (lambda (farg-0) (idris2_getTermCols )))
(define NetworkC-45FFI-prim__idrnet_socket (lambda (farg-0 farg-1 farg-2 farg-3) (idrnet_socket farg-0 farg-1 farg-2)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_unix (lambda (farg-0 farg-1) (idrnet_sockaddr_unix farg-0)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_port (lambda (farg-0 farg-1) (idrnet_sockaddr_port farg-0)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_ipv4 (lambda (farg-0 farg-1) (idrnet_sockaddr_ipv4 farg-0)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_family (lambda (farg-0 farg-1) (idrnet_sockaddr_family farg-0)))
(define NetworkC-45FFI-prim__idrnet_listen (lambda (farg-0 farg-1 farg-2) (idrnet_listen farg-0 farg-1)))
(define NetworkC-45FFI-prim__idrnet_fdopen (lambda (farg-0 farg-1 farg-2) (idrnet_fdopen farg-0 farg-1)))
(define NetworkC-45FFI-prim__idrnet_create_sockaddr (lambda (farg-0) (idrnet_create_sockaddr )))
(define NetworkC-45FFI-prim__idrnet_bind (lambda (farg-0 farg-1 farg-2 farg-3 farg-4 farg-5) (idrnet_bind farg-0 farg-1 farg-2 farg-3 farg-4)))
(define NetworkC-45FFI-prim__idrnet_accept (lambda (farg-0 farg-1 farg-2) (idrnet_accept farg-0 farg-1)))
(define NetworkC-45SocketC-45Data-prim__idrnet_errno (lambda (farg-0) (idrnet_errno )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_unspec (lambda (farg-0) (idrnet_af_unspec )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_unix (lambda (farg-0) (idrnet_af_unix )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_inet6 (lambda (farg-0) (idrnet_af_inet6 )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_inet (lambda (farg-0) (idrnet_af_inet )))
(define PreludeC-45Types-u--foldl_Foldable_List (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (PreludeC-45Types-u--foldl_Foldable_List arg-2 ((arg-2 arg-3) e-2) e-3))))))
(define PreludeC-45Types-u--foldMap_Foldable_List (lambda (arg-2 arg-3 ext-0) (PreludeC-45Types-u--foldl_Foldable_List (lambda (u--acc) (lambda (u--elem) (let ((e-1 (car arg-2))) ((e-1 u--acc) (arg-3 u--elem))))) (let ((e-2 (cdr arg-2))) e-2) ext-0)))
(define PreludeC-45Basics-flip (lambda (arg-3 ext-0 ext-1) ((arg-3 ext-1) ext-0)))
(define PreludeC-45Types-u--foldlM_Foldable_List (lambda (arg-3 arg-4 arg-5 ext-0) (PreludeC-45Types-u--foldl_Foldable_List (lambda (u--ma) (lambda (u--b) (let ((e-2 (vector-ref arg-3 1))) ((((e-2 'erased) 'erased) u--ma) (lambda (eta-0) (PreludeC-45Basics-flip arg-4 u--b eta-0)))))) (let ((e-1 (vector-ref arg-3 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) arg-5))) ext-0)))
(define PreludeC-45Types-u--foldr_Foldable_List (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) ((arg-2 e-2) (PreludeC-45Types-u--foldr_Foldable_List arg-2 arg-3 e-3)))))))
(define PreludeC-45Types-u--null_Foldable_List (lambda (arg-1) (if (null? arg-1) 1 0)))
(define csegen-14(delay (vector (lambda (u--acc) (lambda (u--elem) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldr_Foldable_List u--func u--init u--input)))))) (lambda (u--elem) (lambda (u--acc) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldl_Foldable_List u--func u--init u--input)))))) (lambda (u--elem) (lambda (arg-10947) (PreludeC-45Types-u--null_Foldable_List arg-10947))) (lambda (u--elem) (lambda (u--acc) (lambda (u--m) (lambda (i_con-0) (lambda (u--funcM) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldlM_Foldable_List i_con-0 u--funcM u--init u--input)))))))) (lambda (u--elem) (lambda (arg-10976) arg-10976)) (lambda (u--a) (lambda (u--m) (lambda (i_con-0) (lambda (u--f) (lambda (arg-10990) (PreludeC-45Types-u--foldMap_Foldable_List i_con-0 u--f arg-10990)))))))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Char (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-17 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-722 arg-725)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_String arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-23(delay (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_String arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_String arg-722 arg-725))))))
(define csegen-24 (lambda (arg-0) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-0 #\:)))
(define csegen-27(delay (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (vector 1 'erased))))))
(define AlgebraC-45ZeroOneOmega-rigMult (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) 0)(else (cond ((equal? arg-1 0) 0)(else (cond ((equal? arg-0 1) arg-1)(else (cond ((equal? arg-1 1) arg-0)(else 2))))))))))
(define AlgebraC-45ZeroOneOmega-rigPlus (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) arg-1)(else (cond ((equal? arg-1 0) arg-0)(else 2))))))
(define csegen-30(delay (vector (lambda (arg-818) (lambda (arg-821) (AlgebraC-45ZeroOneOmega-rigPlus arg-818 arg-821))) 0 (lambda (arg-830) (lambda (arg-833) (AlgebraC-45ZeroOneOmega-rigMult arg-830 arg-833))) 1)))
(define AlgebraC-45Semiring-erased (lambda (arg-1) (let ((e-2 (vector-ref arg-1 1))) e-2)))
(define csegen-31(delay (AlgebraC-45Semiring-erased (force csegen-30))))
(define DataC-45List1-reverseOnto (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (DataC-45List1-reverseOnto (cons e-2 arg-1) e-3))))))
(define DataC-45List1-singleton (lambda (arg-1) (cons arg-1 '())))
(define DataC-45List1-reverse (lambda (arg-1) (let ((e-1 (car arg-1))) (let ((e-2 (cdr arg-1))) (DataC-45List1-reverseOnto (DataC-45List1-singleton e-1) e-2)))))
(define DataC-45List-span (lambda (arg-1 arg-2) (if (null? arg-2) (cons '() '()) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((sc1 (arg-1 e-2))) (cond ((equal? sc1 1) (let ((sc2 (DataC-45List-span arg-1 e-3))) (let ((e-5 (car sc2))) (let ((e-4 (cdr sc2))) (cons (cons e-2 e-5) e-4))))) (else (cons '() (cons e-2 e-3))))))))))
(define DataC-45List-break (lambda (arg-1 arg-2) (DataC-45List-span (lambda (eta-0) (let ((sc0 (arg-1 eta-0))) (cond ((equal? sc0 1) 0) (else 1)))) arg-2)))
(define DataC-45List-split (lambda (arg-1 arg-2) (let ((sc0 (DataC-45List-break arg-1 arg-2))) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (if (null? e-3) (DataC-45List1-singleton e-2) (let ((e-7 (cdr e-3))) (cons e-2 (DataC-45List-split arg-1 e-7)))))))))
(define PreludeC-45TypesC-45SnocList-C-60C-62C-62 (lambda (arg-1 arg-2) (if (null? arg-1) arg-2 (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (PreludeC-45TypesC-45SnocList-C-60C-62C-62 e-2 (cons e-3 arg-2)))))))
(define PreludeC-45TypesC-45List-mapAppend (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45TypesC-45SnocList-C-60C-62C-62 arg-2 '()) (let ((e-1 (car arg-4))) (let ((e-2 (cdr arg-4))) (PreludeC-45TypesC-45List-mapAppend (cons arg-2 (arg-3 e-1)) arg-3 e-2))))))
(define DataC-45List1-u--map_Functor_List1 (lambda (arg-2 arg-3) (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (cons (arg-2 e-1) (PreludeC-45TypesC-45List-mapAppend '() arg-2 e-2))))))
(define DataC-45String-split (lambda (arg-0 arg-1) (DataC-45List1-u--map_Functor_List1 (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45List-split arg-0 (PreludeC-45Types-fastUnpack arg-1)))))
(define csegen-545 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 #\.)))
(define CoreC-45NameC-45Namespace-mkNamespacedIdent (lambda (arg-0) (let ((u--nns (DataC-45List1-reverse (DataC-45String-split csegen-545 arg-0)))) (let ((u--name (let ((e-1 (car u--nns))) e-1))) (let ((u--ns (let ((e-2 (cdr u--nns))) e-2))) (if (null? u--ns) (cons '() u--name) (cons (box u--ns) u--name)))))))
(define PreludeC-45Basics-uncurry (lambda (arg-3 arg-4) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) ((arg-3 e-2) e-3)))))
(define CoreC-45NameC-45Namespace-mkNestedNamespace (lambda (arg-0 arg-1) (if (null? arg-0) (cons arg-1 '()) (let ((e-2 (unbox arg-0))) (cons arg-1 e-2)))))
(define csegen-546(delay (lambda (eta-0) (lambda (eta-1) (CoreC-45NameC-45Namespace-mkNestedNamespace eta-0 eta-1)))))
(define CoreC-45NameC-45Namespace-mkNamespace (lambda (arg-0) (cond ((equal? arg-0 "") '())(else (PreludeC-45Basics-uncurry (force csegen-546) (CoreC-45NameC-45Namespace-mkNamespacedIdent arg-0))))))
(define CoreC-45NameC-45Namespace-typesNS (CoreC-45NameC-45Namespace-mkNamespace "Prelude.Types"))
(define csegen-32 (vector 0 CoreC-45NameC-45Namespace-typesNS (vector 1 (vector 0 "prim__integerToNat"))))
(define CoreC-45NameC-45Namespace-eqOrdNS (CoreC-45NameC-45Namespace-mkNamespace "Prelude.EqOrd"))
(define csegen-33 (vector 0 CoreC-45NameC-45Namespace-eqOrdNS (vector 1 (vector 0 "compareInteger"))))
(define CoreC-45Core-coreFail (lambda (arg-1 ext-0) (vector 0 arg-1)))
(define CoreC-45Core-u--throw_Catchable_Core_Error (lambda (ext-1 ext-0) (CoreC-45Core-coreFail ext-1 ext-0)))
(define CoreC-45BinaryC-45Prims-corrupt (lambda (arg-1 ext-0) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 52 (vector 2 arg-1)) ext-0)))
(define LibrariesC-45UtilsC-45Binary-incLoc (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (vector e-0 (+ e-1 arg-0) e-2 e-3)))))))
(define LibrariesC-45UtilsC-45Binary-toRead (lambda (arg-0) (- (let ((e-3 (vector-ref arg-0 3))) e-3) (let ((e-1 (vector-ref arg-0 1))) e-1))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (>= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define CoreC-45BinaryC-45Prims-getTag (lambda (arg-0 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-5) 1))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__getBits8 (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) ext-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc 1 e-5)))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (vector 1 e-6))))))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 52 (vector 1 "Bits8")) ext-0))))))))))
(define PreludeC-45Types-getAt (lambda (arg-1 arg-2) (cond ((equal? arg-1 0) (if (null? arg-2) '() (let ((e-3 (car arg-2))) (box e-3))))(else (let ((e-1 (- arg-1 1))) (if (null? arg-2) '() (let ((e-7 (cdr arg-2))) (PreludeC-45Types-getAt e-1 e-7))))))))
(define DataC-45Vect-reverseOnto (lambda (arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-3 (car arg-4))) (let ((e-4 (cdr arg-4))) (DataC-45Vect-reverseOnto (cons e-3 arg-3) e-4))))))
(define DataC-45Vect-reverse (lambda (ext-0) (DataC-45Vect-reverseOnto '() ext-0)))
(define CoreC-45BinaryC-45Prims-n--11734-8466-u--readElems (lambda (arg-1 arg-2 arg-3 arg-5 arg-6) (cond ((equal? arg-6 0) (lambda (eta-0) (vector 1 (DataC-45Vect-reverse arg-5))))(else (let ((e-0 (- arg-6 1))) (lambda (eta-0) (let ((act-1 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) eta-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((CoreC-45BinaryC-45Prims-n--11734-8466-u--readElems arg-1 arg-2 arg-3 (cons e-5 arg-5) e-0) eta-0)))))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (CoreC-45BinaryC-45Prims-n--11734-8466-u--readElems arg-2 arg-3 arg-1 '() arg-1)))
(define PreludeC-45TypesC-45List-reverseOnto (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (PreludeC-45TypesC-45List-reverseOnto (cons e-2 arg-1) e-3))))))
(define PreludeC-45TypesC-45List-reverse (lambda (ext-0) (PreludeC-45TypesC-45List-reverseOnto '() ext-0)))
(define PreludeC-45TypesC-45List-tailRecAppend (lambda (arg-1 arg-2) (PreludeC-45TypesC-45List-reverseOnto arg-2 (PreludeC-45TypesC-45List-reverse arg-1))))
(define PreludeC-45Types-prim__integerToNat (lambda (arg-0) (let ((sc0 (or (and (<= 0 arg-0) 1) 0))) (cond ((equal? sc0 0) 0)(else arg-0)))))
(define Builtin-fst (lambda (arg-2) (let ((e-2 (car arg-2))) e-2)))
(define Builtin-snd (lambda (arg-2) (let ((e-3 (cdr arg-2))) e-3)))
(define PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (string-append "(" (string-append (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) (e-1 e-2))) (string-append ", " (string-append (let ((sc1 (Builtin-snd arg-2))) (let ((e-1 (car sc1))) (e-1 e-3))) ")"))))))))
(define PreludeC-45Show-firstCharIs (lambda (arg-0 arg-1) (cond ((equal? arg-1 "") 0)(else (arg-0 (string-ref arg-1 0))))))
(define PreludeC-45Show-showParens (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) arg-1) (else (string-append "(" (string-append arg-1 ")"))))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define PreludeC-45Show-precCon (lambda (arg-0) (case (vector-ref arg-0 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) (else 6))))
(define PreludeC-45EqOrd-u--C-60_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45Show-u--compare_Ord_Prec (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((4) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Integer e-0 e-1)))(else (PreludeC-45EqOrd-u--compare_Ord_Integer (PreludeC-45Show-precCon arg-0) (PreludeC-45Show-precCon arg-1))))))(else (PreludeC-45EqOrd-u--compare_Ord_Integer (PreludeC-45Show-precCon arg-0) (PreludeC-45Show-precCon arg-1))))))
(define PreludeC-45Show-u--C-62C-61_Ord_Prec (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45Show-u--compare_Ord_Prec arg-0 arg-1) 0)))
(define csegen-153 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 #\-)))
(define PreludeC-45Show-primNumShow (lambda (arg-1 arg-2 arg-3) (let ((u--str (arg-1 arg-3))) (PreludeC-45Show-showParens (let ((sc0 (PreludeC-45Show-u--C-62C-61_Ord_Prec arg-2 (vector 5 )))) (cond ((equal? sc0 1) (PreludeC-45Show-firstCharIs csegen-153 u--str)) (else 0))) u--str))))
(define PreludeC-45Show-u--showPrec_Show_Integer (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Integer (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Integer (vector 0 ) arg-0)))
(define csegen-1116 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Integer u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Integer u--d u--x)))))
(define csegen-1689 (cons csegen-1116 csegen-1116))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 255) (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((sc3 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-6) 8))) (cond ((equal? sc3 1) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__getInt (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) ext-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc 8 e-6)))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (vector 1 e-7))))))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 52 (vector 1 (string-append "Int " (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1689 (cons (let ((e-1 (vector-ref e-6 1))) e-1) (let ((e-2 (vector-ref e-6 2))) e-2)))))) ext-0)))))))))(else (vector 1 (bs- e-5 (blodwen-toSignedInt 127 63) 63))))))))))
(define CoreC-45BinaryC-45Prims-n--11480-8226-u--readElems (lambda (arg-1 arg-2 arg-3 arg-4) (cond ((equal? arg-4 0) (lambda (eta-0) (vector 1 (PreludeC-45TypesC-45List-reverse arg-3))))(else (let ((e-0 (- arg-4 1))) (lambda (eta-0) (let ((act-1 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) eta-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((CoreC-45BinaryC-45Prims-n--11480-8226-u--readElems arg-1 arg-2 (cons e-5 arg-3) e-0) eta-0)))))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((CoreC-45BinaryC-45Prims-n--11480-8226-u--readElems arg-1 arg-2 '() (PreludeC-45Types-prim__integerToNat e-5)) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 '())) ((equal? e-5 1) (let ((act-2 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) ext-0)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (box e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "Maybe" ext-0)))))))))
(define CoreC-45BinaryC-45Prims-fromLimbs (lambda (arg-0) (if (null? arg-0) 0 (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (+ e-2 (blodwen-shl (CoreC-45BinaryC-45Prims-fromLimbs e-3) 32)))))))
(define LibrariesC-45UtilsC-45Binary-appended (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (vector e-0 (+ e-1 arg-0) e-2 (+ e-3 arg-0))))))))
(define LibrariesC-45UtilsC-45Binary-avail (lambda (arg-0) (- (- (let ((e-2 (vector-ref arg-0 2))) e-2) (let ((e-1 (vector-ref arg-0 1))) e-1)) 1)))
(define DataC-45Buffer-copyData (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (cdr arg-1))) ((e-2 'erased) (lambda (eta-0) (DataC-45Buffer-prim__copyData arg-2 arg-3 arg-4 arg-5 arg-6 eta-0))))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (>= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define DataC-45Buffer-newBuffer (lambda (arg-1 arg-2) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-2 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 1) (let ((e-1 (car arg-1))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (let ((e-6 (cdr arg-1))) ((e-6 'erased) (lambda (eta-0) (DataC-45Buffer-prim__newBuffer arg-2 eta-0))))) (lambda (u--buf) (let ((e-7 (car arg-1))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) (box u--buf)))))))))) (else (let ((e-1 (car arg-1))) (let ((e-5 (vector-ref e-1 0))) (let ((e-7 (vector-ref e-5 1))) ((e-7 'erased) '())))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define DataC-45Buffer-resizeBuffer (lambda (arg-1 arg-2 arg-3) (let ((e-1 (car arg-1))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (DataC-45Buffer-newBuffer arg-1 arg-3)) (lambda (_-0) (if (null? _-0) (let ((e-7 (car arg-1))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) '())))) (let ((e-6 (unbox _-0))) (let ((e-8 (car arg-1))) (let ((e-10 (vector-ref e-8 1))) ((((e-10 'erased) 'erased) (let ((e-13 (car arg-1))) (let ((e-16 (vector-ref e-13 0))) (let ((e-18 (vector-ref e-16 1))) ((e-18 'erased) (DataC-45Buffer-prim__bufferSize arg-2)))))) (lambda (u--oldsize) (let ((u--len (let ((sc3 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-3 u--oldsize))) (cond ((equal? sc3 1) arg-3) (else u--oldsize))))) (let ((e-13 (car arg-1))) (let ((e-15 (vector-ref e-13 1))) ((((e-15 'erased) 'erased) (DataC-45Buffer-copyData arg-1 arg-2 0 u--len e-6 0)) (lambda (_-10685) (let ((e-18 (car arg-1))) (let ((e-21 (vector-ref e-18 0))) (let ((e-23 (vector-ref e-21 1))) ((e-23 'erased) (box e-6))))))))))))))))))))))
(define PreludeC-45IO-u--map_Functor_IO (lambda (arg-2 arg-3 ext-0) (let ((act-2 (arg-3 ext-0))) (arg-2 act-2))))
(define csegen-78(delay (vector (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8920) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO u--func arg-8920 eta-0)))))) (lambda (u--a) (lambda (arg-9959) (lambda (eta-0) arg-9959))) (lambda (u--b) (lambda (u--a) (lambda (arg-9965) (lambda (arg-9972) (lambda (world-4) (let ((act-5 (arg-9965 world-4))) (let ((act-3 (arg-9972 world-4))) (act-5 act-3)))))))))))
(define csegen-84(delay (vector (force csegen-78) (lambda (u--b) (lambda (u--a) (lambda (arg-10444) (lambda (arg-10447) (lambda (world-0) (let ((act-1 (arg-10444 world-0))) ((arg-10447 act-1) world-0))))))) (lambda (u--a) (lambda (arg-10458) (lambda (world-0) (let ((act-1 (arg-10458 world-0))) (act-1 world-0))))))))
(define csegen-85(delay (cons (force csegen-84) (lambda (u--a) (lambda (arg-13076) arg-13076)))))
(define CoreC-45BinaryC-45Prims-extendBinary (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((u--newsize (* e-2 2))) (let ((u--sC-39 (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer (- u--newsize e-1) arg-0))) (cond ((equal? sc0 1) (+ u--newsize arg-0)) (else u--newsize))))) (lambda (eta-0) (let ((act-1 (let ((act-1 ((DataC-45Buffer-resizeBuffer (force csegen-85) e-0 (blodwen-toSignedInt u--sC-39 63)) eta-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (if (null? e-5) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 63 "Buffer expansion failed") eta-0) (let ((e-4 (unbox e-5))) (vector 1 (vector e-4 e-1 u--sC-39 e-3)))))))))))))))))
(define CoreC-45BinaryC-45Prims-tag (lambda (arg-0 arg-1 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-5) 1))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__setBits8 (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) (blodwen-toUnsignedInt arg-1 8) ext-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 1 e-5)))) (vector 1 act-3)))))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-extendBinary 1 e-5) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setBits8 (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) (blodwen-toUnsignedInt arg-1 8) ext-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 1 e-6)))) (vector 1 act-4))))))))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int (lambda (arg-0 arg-1) (lambda (clam-0) (let ((sc0 (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-1 (blodwen-toSignedInt -127 63)))) (cond ((equal? sc1 1) (PreludeC-45EqOrd-u--C-60_Ord_Int arg-1 (blodwen-toSignedInt 128 63))) (else 0))))) (cond ((equal? sc0 1) (CoreC-45BinaryC-45Prims-tag arg-0 (bs+ arg-1 (blodwen-toSignedInt 127 63) 63) clam-0)) (else (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 (blodwen-toSignedInt 255 63) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((sc3 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-6) 8))) (cond ((equal? sc3 1) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setInt (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) arg-1 clam-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-6)))) (vector 1 act-4)))))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-extendBinary 8 e-6) clam-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (let ((act-4 (DataC-45Buffer-prim__setInt (let ((e-0 (vector-ref e-7 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-7 1))) e-1) 63) arg-1 clam-0))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-7)))) (vector 1 act-5)))))))))))))))))))))))))
(define csegen-1643 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int i_con-0 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1643 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (- 0 (CoreC-45BinaryC-45Prims-fromLimbs e-6)))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1643 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (CoreC-45BinaryC-45Prims-fromLimbs e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "Integer" ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (PreludeC-45Types-prim__integerToNat e-5))))))))
(define CoreC-45TTC-u--fromBuf_TTC_ConInfo (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 2 ))) ((equal? e-5 3) (vector 1 (vector 3 ))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-6))))))) ((equal? e-5 5) (vector 1 (vector 5 ))) ((equal? e-5 6) (vector 1 (vector 6 ))) ((equal? e-5 7) (vector 1 (vector 7 ))) ((equal? e-5 8) (vector 1 (vector 8 ))) ((equal? e-5 9) (vector 1 (vector 9 ))) ((equal? e-5 10) (vector 1 (vector 10 )))(else (CoreC-45BinaryC-45Prims-corrupt "ConInfo" ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 ext-0) (let ((act-1 (let ((sc0 (Builtin-fst arg-2))) (let ((e-2 (cdr sc0))) ((e-2 arg-3) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (let ((sc1 (Builtin-snd arg-2))) (let ((e-2 (cdr sc1))) ((e-2 arg-3) ext-0))))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((u--len e-5)) (let ((act-3 (let ((sc2 (PreludeC-45EqOrd-u--C-60_Ord_Integer u--len 0))) (cond ((equal? sc2 1) (CoreC-45BinaryC-45Prims-corrupt "String" ext-0)) (else (vector 1 'erased)))))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((sc3 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-6) u--len))) (cond ((equal? sc3 1) (let ((act-4 (let ((act-4 (DataC-45Buffer-prim__getString (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) e-5 ext-0))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc u--len e-6)))) (vector 1 act-5)))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (vector 1 e-8))))))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 52 (vector 1 (string-append "String length " (string-append (PreludeC-45Show-u--show_Show_Integer u--len) (string-append " at " (PreludeC-45Show-u--show_Show_Integer (let ((e-1 (vector-ref e-6 1))) e-1))))))) ext-0))))))))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_String (lambda (arg-0 arg-1) (let ((u--ireq (DataC-45Buffer-stringByteLength arg-1))) (let ((u--req u--ireq)) (lambda (eta-0) (let ((act-1 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 u--ireq) eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((sc2 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-6) u--req))) (cond ((equal? sc2 1) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setString (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) arg-1 eta-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--req e-6)))) (vector 1 act-4)))))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-extendBinary u--req e-6) eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (let ((act-4 (DataC-45Buffer-prim__setString (let ((e-0 (vector-ref e-7 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-7 1))) e-1) 63) arg-1 eta-0))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--req e-7)))) (vector 1 act-5))))))))))))))))))))))))
(define csegen-1640 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_String i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String i_con-0 eta-0)))))
(define csegen-1684 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 e-5))))))
(define CoreC-45TTC-u--fromBuf_TTC_Namespace (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO csegen-1684 (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 arg-0 eta-0)) ext-0)))
(define csegen-1644 (cons csegen-1643 csegen-1643))
(define CoreC-45TTC-u--fromBuf_TTC_Name (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Namespace arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 0 e-6 e-7))))))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 1 (vector 0 e-6)))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 2 e-6 e-7))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 3 e-6 e-7))))))))))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 4 e-6 e-7))))))))))) ((equal? e-5 5) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 1 (vector 1 e-6)))))))) ((equal? e-5 6) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 5 e-6 e-7))))))))))) ((equal? e-5 7) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 6 e-6 e-7))))))))))) ((equal? e-5 8) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 7 e-6 e-7))))))))))) ((equal? e-5 9) (vector 1 (vector 1 (vector 2 ))))(else (CoreC-45BinaryC-45Prims-corrupt "Name" ext-0)))))))))
(define PreludeC-45Show-u--showPrec_Show_Int (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int (vector 0 ) arg-0)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 ext-0) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((act-1 (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) (((e-1 arg-3) e-2) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((sc2 (Builtin-snd arg-2))) (let ((e-1 (car sc2))) (((e-1 arg-3) e-3) ext-0))))))))))
(define CoreC-45CoreC-45List-traverse_ (lambda (arg-2 arg-3) (if (null? arg-3) (lambda (eta-0) (vector 1 'erased)) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((eff-0 (let ((eff-0 (arg-2 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (force csegen-27) eff-0 eta-0))))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else ((CoreC-45CoreC-45List-traverse_ arg-2 e-3) world-0)))))))))))
(define CoreC-45BinaryC-45Prims-n--11462-8178-u--length_aux (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (if (null? arg-4) arg-5 (let ((e-3 (cdr arg-4))) (CoreC-45BinaryC-45Prims-n--11462-8178-u--length_aux arg-1 arg-2 arg-3 e-3 (bs+ arg-5 1 63))))))
(define CoreC-45BinaryC-45Prims-n--11462-8177-u--TailRec_length (lambda (arg-1 arg-2 arg-3 arg-4) (CoreC-45BinaryC-45Prims-n--11462-8178-u--length_aux arg-1 arg-2 arg-3 arg-4 0)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (let ((act-1 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-2 (CoreC-45BinaryC-45Prims-n--11462-8177-u--TailRec_length arg-1 arg-2 arg-3 arg-3)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45CoreC-45List-traverse_ (let ((e-1 (car arg-1))) (e-1 arg-2)) arg-3) ext-0))))))
(define CoreC-45TTC-u--toBuf_TTC_Namespace (lambda (arg-0 ext-0 ext-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 arg-0 ext-0 ext-1)))
(define CoreC-45TTC-u--toBuf_TTC_Name (lambda (arg-0 arg-1) (lambda (clam-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_Namespace arg-0 e-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-1) clam-0)))))))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (case (vector-ref e-2 0) ((0) (let ((e-16 (vector-ref e-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-16) clam-0)))))) ((1) (let ((e-17 (vector-ref e-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 5 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-17) clam-0)))))) (else (CoreC-45BinaryC-45Prims-tag arg-0 9 clam-0))))) ((2) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-3) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-4) clam-0)))))))))) ((3) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-5) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-6) clam-0)))))))))) ((4) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-7) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-8) clam-0)))))))))) ((5) (let ((e-9 (vector-ref arg-1 1))) (let ((e-10 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 e-9 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-10) clam-0)))))))))) ((6) (let ((e-11 (vector-ref arg-1 1))) (let ((e-12 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 7 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-11) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-12) clam-0)))))))))) ((7) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-13) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-14) clam-0)))))))))) (else (let ((e-15 (vector-ref arg-1 1))) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 63 (string-append "Can't write resolved name " (PreludeC-45Show-u--show_Show_Int e-15))) clam-0)))))))
(define csegen-43 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_Name i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Name i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CConAltC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_ConInfo arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1643 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-8 arg-0) arg-1 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (vector 1 (vector e-5 e-6 e-7 e-8 e-9))))))))))))))))))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits16 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 16)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits32 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 32)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits64 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 64)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits8 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 8)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Char (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (cast-int-char e-5))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Double (lambda (arg-0 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-5) 8))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__getDouble (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) ext-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc 8 e-5)))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (vector 1 e-6))))))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 52 (vector 1 "Double")) ext-0))))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int16 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 15)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int32 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 31)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int64 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 63)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int8 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 7)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45TTC-u--fromBuf_TTC_PrimType (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2)) ((equal? e-5 3) (vector 1 3)) ((equal? e-5 4) (vector 1 4)) ((equal? e-5 5) (vector 1 5)) ((equal? e-5 6) (vector 1 6)) ((equal? e-5 7) (vector 1 7)) ((equal? e-5 8) (vector 1 8)) ((equal? e-5 9) (vector 1 9)) ((equal? e-5 10) (vector 1 10)) ((equal? e-5 11) (vector 1 11)) ((equal? e-5 12) (vector 1 12)) ((equal? e-5 13) (vector 1 13))(else (CoreC-45BinaryC-45Prims-corrupt "PrimType" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_Constant (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 0 e-6))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int8 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 1 e-6))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int16 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-6))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int32 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6))))))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int64 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-6))))))) ((equal? e-5 5) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 5 e-6))))))) ((equal? e-5 6) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits8 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 6 e-6))))))) ((equal? e-5 7) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits16 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 7 e-6))))))) ((equal? e-5 8) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits32 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 8 e-6))))))) ((equal? e-5 9) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits64 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 9 e-6))))))) ((equal? e-5 10) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 10 e-6))))))) ((equal? e-5 11) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Char arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 11 e-6))))))) ((equal? e-5 12) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Double arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 12 e-6))))))) ((equal? e-5 13) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 13 e-6))))))) ((equal? e-5 14) (vector 1 (vector 14 )))(else (CoreC-45BinaryC-45Prims-corrupt "Constant" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CConstAltC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))
(define CoreC-45TTC-n--16527-9399-u--fromBuf1 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 5 e-6))))))) ((equal? e-5 11) (vector 1 (vector 16 ))) ((equal? e-5 12) (vector 1 (vector 17 ))) ((equal? e-5 13) (vector 1 (vector 18 ))) ((equal? e-5 17) (vector 1 (vector 22 ))) ((equal? e-5 19) (vector 1 (vector 24 ))) ((equal? e-5 20) (vector 1 (vector 25 ))) ((equal? e-5 22) (vector 1 (vector 27 ))) ((equal? e-5 23) (vector 1 (vector 28 ))) ((equal? e-5 24) (vector 1 (vector 29 ))) ((equal? e-5 25) (vector 1 (vector 30 ))) ((equal? e-5 26) (vector 1 (vector 31 ))) ((equal? e-5 27) (vector 1 (vector 32 ))) ((equal? e-5 32) (vector 1 (vector 33 ))) ((equal? e-5 33) (vector 1 (vector 34 ))) ((equal? e-5 34) (vector 1 (vector 35 ))) ((equal? e-5 99) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 36 e-6 e-7)))))))))))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn 1" ext-0)))))))))
(define CoreC-45TTC-n--16527-9400-u--fromBuf2 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 0 e-6))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 1 e-6))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-6))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6))))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-6))))))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 11 e-6))))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 12 e-6))))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 13 e-6))))))) ((equal? e-5 9) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 14 e-6))))))) ((equal? e-5 10) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 15 e-6))))))) ((equal? e-5 14) (vector 1 (vector 19 ))) ((equal? e-5 15) (vector 1 (vector 20 ))) ((equal? e-5 16) (vector 1 (vector 21 ))) ((equal? e-5 21) (vector 1 (vector 26 ))) ((equal? e-5 35) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 6 e-6))))))) ((equal? e-5 36) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 7 e-6))))))) ((equal? e-5 37) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 8 e-6))))))) ((equal? e-5 38) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 9 e-6))))))) ((equal? e-5 39) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 10 e-6))))))) ((equal? e-5 101) (vector 1 (vector 38 )))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn 2" ext-0)))))))))
(define CoreC-45TTC-n--16527-9401-u--fromBuf3 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 18) (vector 1 (vector 23 ))) ((equal? e-5 100) (vector 1 (vector 37 )))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn 3" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40PrimFnC-32C-36nC-41 (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-corrupt "PrimFn" eta-0)))(else (let ((e-0 (- arg-0 1))) (cond ((equal? e-0 0) (lambda (eta-0) (CoreC-45TTC-n--16527-9399-u--fromBuf1 arg-1 arg-0 eta-0)))(else (let ((e-1 (- e-0 1))) (cond ((equal? e-1 0) (lambda (eta-0) (CoreC-45TTC-n--16527-9400-u--fromBuf2 arg-1 arg-0 eta-0)))(else (let ((e-2 (- e-1 1))) (lambda (clam-0) (cond ((equal? e-2 0) (CoreC-45TTC-n--16527-9401-u--fromBuf3 arg-1 arg-0 clam-0))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn" clam-0)))))))))))))))
(define csegen-157(delay (lambda (arg-9965) (lambda (arg-9972) (case (vector-ref arg-9965 0) ((0) (let ((e-2 (vector-ref arg-9965 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref arg-9965 1))) (case (vector-ref arg-9972 0) ((1) (let ((e-8 (vector-ref arg-9972 1))) (vector 1 (e-5 e-8)))) (else (let ((e-11 (vector-ref arg-9972 1))) (vector 0 e-11)))))))))))
(define CoreC-45Core-C-60C-42C-62 (lambda (arg-2 arg-3 ext-0) (let ((act-5 (let ((act-5 (force csegen-157))) (let ((act-3 (arg-2 ext-0))) (act-5 act-3))))) (let ((act-3 (arg-3 ext-0))) (act-5 act-3)))))
(define CoreC-45TTC-u--fromBuf_TTC_ModuleIdent (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO csegen-1684 (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 arg-0 eta-0)) ext-0)))
(define CoreC-45TTC-u--fromBuf_TTC_VirtualIdent (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 'erased))(else (CoreC-45BinaryC-45Prims-corrupt "VirtualIdent" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_OriginDesc (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (vector 1 (lambda (eta-1) (vector 0 eta-1)))) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_ModuleIdent arg-0 eta-0)) ext-0)) ((equal? e-5 1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (vector 1 (lambda (eta-1) (vector 1 eta-1)))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 eta-0)) ext-0)) ((equal? e-5 2) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (vector 1 (lambda (eta-1) (vector 2 eta-1)))) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_VirtualIdent arg-0 eta-0)) ext-0))(else (CoreC-45BinaryC-45Prims-corrupt "OriginDesc" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_FC (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_OriginDesc arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 0 e-6 e-7 e-8))))))))))))))) ((equal? e-5 1) (vector 1 (vector 2 ))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_OriginDesc arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 1 e-6 e-7 e-8)))))))))))))))(else (CoreC-45BinaryC-45Prims-corrupt "FC" ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1))(else (CoreC-45BinaryC-45Prims-corrupt "Bool" ext-0)))))))))
(define csegen-1685 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (cond ((equal? e-5 1) 0) (else 1))))))))
(define CoreC-45TTC-u--fromBuf_TTC_InlineOk (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO csegen-1685 (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-0)) ext-0)))
(define CoreC-45TTC-u--fromBuf_TTC_LazyReason (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "LazyReason" ext-0)))))))))
(define CoreC-45BinaryC-45Prims-n--11713-8431-u--writeAll (lambda (arg-1 arg-2 arg-3 arg-4 arg-6 ext-0) (if (null? arg-6) (vector 1 'erased) (let ((e-3 (car arg-6))) (let ((e-4 (cdr arg-6))) (let ((act-1 (let ((e-1 (car arg-2))) (((e-1 arg-3) e-3) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-n--11713-8431-u--writeAll arg-1 arg-2 arg-3 arg-4 e-4 ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 arg-4) (lambda (eta-0) (CoreC-45BinaryC-45Prims-n--11713-8431-u--writeAll arg-1 arg-2 arg-3 arg-4 arg-4 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits16 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-toLimbs (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 0))) (cond ((equal? sc0 1) '()) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 -1))) (cond ((equal? sc1 1) (cons -1 '())) (else (cons (blodwen-toSignedInt (blodwen-and arg-0 4294967295) 63) (CoreC-45BinaryC-45Prims-toLimbs (blodwen-shr arg-0 32)))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer (lambda (arg-0 arg-1 ext-0) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-1 0))) (cond ((equal? sc0 1) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1643 arg-0 (CoreC-45BinaryC-45Prims-toLimbs (- 0 arg-1)) ext-0))))) (else (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1643 arg-0 (CoreC-45BinaryC-45Prims-toLimbs arg-1) ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits32 (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits64 (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits8 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Char (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 (cast-char-boundedInt arg-1 63))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Double (lambda (arg-0 arg-1 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-5) 8))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__setDouble (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) arg-1 ext-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-5)))) (vector 1 act-3)))))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-extendBinary 8 e-5) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setDouble (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) arg-1 ext-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-6)))) (vector 1 act-4))))))))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int16 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int32 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int64 (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int8 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45TTC-u--toBuf_TTC_PrimType (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((equal? arg-1 2) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((equal? arg-1 3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((equal? arg-1 4) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((equal? arg-1 5) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((equal? arg-1 6) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((equal? arg-1 7) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((equal? arg-1 8) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((equal? arg-1 9) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) ((equal? arg-1 10) (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)) ((equal? arg-1 11) (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0)) ((equal? arg-1 12) (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_Constant (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-0) ext-0)))))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int8 arg-0 e-1) ext-0)))))) ((2) (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int16 arg-0 e-2) ext-0)))))) ((3) (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int32 arg-0 e-3) ext-0)))))) ((4) (let ((e-4 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int64 arg-0 e-4) ext-0)))))) ((5) (let ((e-5 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 e-5 ext-0)))))) ((6) (let ((e-6 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits8 arg-0 e-6) ext-0)))))) ((7) (let ((e-7 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits16 arg-0 e-7) ext-0)))))) ((8) (let ((e-8 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits32 arg-0 e-8) ext-0)))))) ((9) (let ((e-9 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits64 arg-0 e-9) ext-0)))))) ((10) (let ((e-10 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-10) ext-0)))))) ((11) (let ((e-11 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Char arg-0 e-11) ext-0)))))) ((12) (let ((e-12 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Double arg-0 e-12 ext-0)))))) ((13) (let ((e-13 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-0 e-13 ext-0)))))) (else (CoreC-45BinaryC-45Prims-tag arg-0 14 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CConstAltC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (let ((e-1 (car arg-2))) (let ((e-2 (cdr arg-2))) (let ((act-1 (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-2 ext-0))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (lambda (clam-0) (if (null? arg-3) (CoreC-45BinaryC-45Prims-tag arg-2 0 clam-0) (let ((e-2 (unbox arg-3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-2 1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-1 (car arg-1))) (((e-1 arg-2) e-2) clam-0))))))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40PrimFnC-32C-36nC-41 (lambda (arg-0 arg-1 arg-2) (cond ((equal? arg-0 0) (blodwen-error-quit "Nat case not covered"))(else (let ((e-0 (- arg-0 1))) (cond ((equal? e-0 0) (lambda (clam-0) (case (vector-ref arg-2 0) ((5) (let ((e-18 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-18 clam-0)))))) ((16) (CoreC-45BinaryC-45Prims-tag arg-1 11 clam-0)) ((17) (CoreC-45BinaryC-45Prims-tag arg-1 12 clam-0)) ((18) (CoreC-45BinaryC-45Prims-tag arg-1 13 clam-0)) ((22) (CoreC-45BinaryC-45Prims-tag arg-1 17 clam-0)) ((24) (CoreC-45BinaryC-45Prims-tag arg-1 19 clam-0)) ((25) (CoreC-45BinaryC-45Prims-tag arg-1 20 clam-0)) ((27) (CoreC-45BinaryC-45Prims-tag arg-1 22 clam-0)) ((28) (CoreC-45BinaryC-45Prims-tag arg-1 23 clam-0)) ((29) (CoreC-45BinaryC-45Prims-tag arg-1 24 clam-0)) ((30) (CoreC-45BinaryC-45Prims-tag arg-1 25 clam-0)) ((31) (CoreC-45BinaryC-45Prims-tag arg-1 26 clam-0)) ((32) (CoreC-45BinaryC-45Prims-tag arg-1 27 clam-0)) ((33) (CoreC-45BinaryC-45Prims-tag arg-1 32 clam-0)) ((34) (CoreC-45BinaryC-45Prims-tag arg-1 33 clam-0)) ((35) (CoreC-45BinaryC-45Prims-tag arg-1 34 clam-0)) (else (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 99 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-19 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-20 clam-0)))))))))))))(else (let ((e-1 (- e-0 1))) (cond ((equal? e-1 0) (lambda (clam-1) (case (vector-ref arg-2 0) ((0) (let ((e-3 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-3 clam-1)))))) ((1) (let ((e-4 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-4 clam-1)))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-5 clam-1)))))) ((3) (let ((e-6 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-6 clam-1)))))) ((4) (let ((e-7 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-7 clam-1)))))) ((6) (let ((e-8 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 35 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-8 clam-1)))))) ((7) (let ((e-9 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 36 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-9 clam-1)))))) ((8) (let ((e-10 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 37 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-10 clam-1)))))) ((9) (let ((e-11 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 38 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-11 clam-1)))))) ((10) (let ((e-12 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 39 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-12 clam-1)))))) ((11) (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 6 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-13 clam-1)))))) ((12) (let ((e-14 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 7 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-14 clam-1)))))) ((13) (let ((e-15 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 8 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-15 clam-1)))))) ((14) (let ((e-16 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 9 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-16 clam-1)))))) ((15) (let ((e-17 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 10 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-17 clam-1)))))) ((19) (CoreC-45BinaryC-45Prims-tag arg-1 14 clam-1)) ((20) (CoreC-45BinaryC-45Prims-tag arg-1 15 clam-1)) ((21) (CoreC-45BinaryC-45Prims-tag arg-1 16 clam-1)) ((26) (CoreC-45BinaryC-45Prims-tag arg-1 21 clam-1)) (else (CoreC-45BinaryC-45Prims-tag arg-1 (blodwen-toSignedInt 101 63) clam-1)))))(else (let ((e-2 (- e-1 1))) (cond ((equal? e-2 0) (lambda (clam-2) (case (vector-ref arg-2 0) ((23) (CoreC-45BinaryC-45Prims-tag arg-1 18 clam-2)) (else (CoreC-45BinaryC-45Prims-tag arg-1 (blodwen-toSignedInt 100 63) clam-2)))))(else (blodwen-error-quit "Nat case not covered"))))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45TTC-u--toBuf_TTC_ConInfo (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((4) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-0) ext-0)))))) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((6) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((7) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((8) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((9) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_ModuleIdent (lambda (arg-0 ext-0 ext-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 arg-0 ext-0 ext-1)))
(define CoreC-45TTC-u--toBuf_TTC_VirtualIdent (lambda (arg-0 arg-1 ext-0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)))
(define CoreC-45TTC-u--toBuf_TTC_OriginDesc (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_ModuleIdent arg-0 e-0 ext-0)))))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-1) ext-0)))))) (else (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_VirtualIdent arg-0 e-2 ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_FC (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_OriginDesc arg-0 e-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((act-3 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 e-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-3 (vector-ref act-3 1))) (vector 0 e-3))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 e-2 ext-0)))))))))))))) ((1) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((e-5 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_OriginDesc arg-0 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 e-4 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 arg-0 e-5 ext-0)))))))))))))) (else (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)))))
(define CoreC-45CompileExpr-u--C-61C-61_Eq_InlineOk (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0)))(else 0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bool (lambda (arg-0 arg-1) (lambda (clam-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 clam-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 1 clam-0))))))
(define CoreC-45TTC-u--toBuf_TTC_InlineOk (lambda (arg-0 ext-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bool arg-0 (CoreC-45CompileExpr-u--C-61C-61_Eq_InlineOk 0 ext-0))))
(define CoreC-45TTC-u--toBuf_TTC_LazyReason (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-2) ext-0)))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-6 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-7) ext-0)))))))))) ((2) (let ((e-9 (vector-ref arg-2 1))) (let ((e-10 (vector-ref arg-2 2))) (let ((e-11 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-9 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-10) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-10 arg-0) arg-1 e-11 ext-0)))))))))))))) ((3) (let ((e-13 (vector-ref arg-2 1))) (let ((e-14 (vector-ref arg-2 2))) (let ((e-15 (vector-ref arg-2 3))) (let ((e-16 (vector-ref arg-2 4))) (let ((e-17 (vector-ref arg-2 5))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-13 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-14) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 ((CoreC-45TTC-u--toBuf_TTC_InlineOk arg-1 e-15) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-16 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-14 arg-0) arg-1 e-17 ext-0)))))))))))))))))))))) ((4) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-19 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-20 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-21 ext-0)))))))))))))) ((5) (let ((e-23 (vector-ref arg-2 1))) (let ((e-24 (vector-ref arg-2 2))) (let ((e-25 (vector-ref arg-2 3))) (let ((e-26 (vector-ref arg-2 4))) (let ((e-27 (vector-ref arg-2 5))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-23 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-24) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (CoreC-45TTC-u--toBuf_TTC_ConInfo arg-1 e-25 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1643 arg-1 e-26) ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-27 ext-0)))))))))))))))))))))) ((6) (let ((e-29 (vector-ref arg-2 1))) (let ((e-30 (vector-ref arg-2 2))) (let ((e-31 (vector-ref arg-2 3))) (let ((e-32 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 6 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-30 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-29) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 ((CoreC-45TTC-u--toBuf_TTC_C-40PrimFnC-32C-36nC-41 e-29 arg-1 e-31) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 e-29 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-32) ext-0)))))))))))))))))) ((7) (let ((e-34 (vector-ref arg-2 1))) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-34 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-35) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-36 ext-0)))))))))))))) ((8) (let ((e-38 (vector-ref arg-2 1))) (let ((e-39 (vector-ref arg-2 2))) (let ((e-40 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-38 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-39 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-40 ext-0)))))))))))))) ((9) (let ((e-42 (vector-ref arg-2 1))) (let ((e-43 (vector-ref arg-2 2))) (let ((e-44 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 9 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-42 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-43 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-44 ext-0)))))))))))))) ((10) (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (let ((e-48 (vector-ref arg-2 3))) (let ((e-49 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 10 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-46 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-47 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-48 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-49) ext-0)))))))))))))))))) ((11) (let ((e-51 (vector-ref arg-2 1))) (let ((e-52 (vector-ref arg-2 2))) (let ((e-53 (vector-ref arg-2 3))) (let ((e-54 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-51 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-52 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-53 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-54) ext-0)))))))))))))))))) ((12) (let ((e-56 (vector-ref arg-2 1))) (let ((e-57 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-56 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-57 ext-0)))))))))) ((13) (let ((e-59 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-59 ext-0)))))) (else (let ((e-61 (vector-ref arg-2 1))) (let ((e-62 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 14 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-61 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-1 e-62) ext-0)))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CConAltC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (let ((e-1 (vector-ref arg-2 0))) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-1) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-6 (vector-ref act-1 1))) (vector 0 e-6))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_ConInfo arg-1 e-2 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-7 (vector-ref act-2 1))) (vector 0 e-7))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1643 arg-1 e-3) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-8 (vector-ref act-3 1))) (vector 0 e-8))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-1 e-4 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-9 (vector-ref act-4 1))) (vector 0 e-9))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-4 arg-0) arg-1 e-5 ext-0))))))))))))))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((sc4 (PreludeC-45Types-getAt e-7 arg-0))) (if (null? sc4) (CoreC-45BinaryC-45Prims-corrupt "CExp" ext-0) (vector 1 (vector 0 e-7 e-6))))))))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 1 e-6 e-7))))))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-7 arg-0) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 2 e-6 e-7 e-8))))))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_InlineOk arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (let ((act-6 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-7 arg-0) arg-1 ext-0))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) (vector 1 (vector 3 e-6 e-7 e-8 e-9 e-10))))))))))))))))))))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 4 e-6 e-7 e-8))))))))))))))) ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_ConInfo arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1643 arg-1 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (let ((act-6 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) (vector 1 (vector 5 e-6 e-7 e-8 e-9 e-10))))))))))))))))))))))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 ((CoreC-45TTC-u--fromBuf_TTC_C-40PrimFnC-32C-36nC-41 e-7 arg-1) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 ((CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 e-7 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1) ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (vector 1 (vector 6 e-7 e-6 e-8 e-9))))))))))))))))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 7 e-6 e-7 e-8))))))))))))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 8 e-6 e-7 e-8))))))))))))))) ((equal? e-5 9) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 9 e-6 e-7 e-8))))))))))))))) ((equal? e-5 10) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (vector 1 (vector 10 e-6 e-7 e-8 e-9))))))))))))))))))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (vector 1 (vector 11 e-6 e-7 e-8 e-9))))))))))))))))))) ((equal? e-5 12) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 12 e-6 e-7))))))))))) ((equal? e-5 13) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 13 e-6))))))) ((equal? e-5 14) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 14 e-6 e-7)))))))))))(else (CoreC-45BinaryC-45Prims-corrupt "CExp" ext-0)))))))))
(define csegen-1675 (lambda () (cons csegen-1640 (csegen-1674))))
(define csegen-1678 (lambda () (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1675) i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1675) i_con-0 eta-0))))))
(define CoreC-45TTC-u--toBuf_TTC_CFType (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((7) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((8) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((9) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((10) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((11) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((12) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((13) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((14) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) ((18) (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)) ((19) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-1 ext-0)))))))))) ((20) (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-2 ext-0)))))) ((21) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-3) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1678) arg-0 e-4 ext-0)))))))))) ((22) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 14 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-5) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1674) arg-0 e-6 ext-0)))))))))) ((15) (CoreC-45BinaryC-45Prims-tag arg-0 15 ext-0)) ((16) (CoreC-45BinaryC-45Prims-tag arg-0 16 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 17 ext-0)) ((4) (CoreC-45BinaryC-45Prims-tag arg-0 18 ext-0)) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 19 ext-0)) ((6) (CoreC-45BinaryC-45Prims-tag arg-0 20 ext-0)) ((17) (CoreC-45BinaryC-45Prims-tag arg-0 21 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 22 ext-0)))))
(define csegen-1674 (lambda () (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_CFType i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_CFType i_con-0 eta-0))))))
(define CoreC-45TTC-u--fromBuf_TTC_CFType (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 7 ))) ((equal? e-5 3) (vector 1 (vector 8 ))) ((equal? e-5 4) (vector 1 (vector 9 ))) ((equal? e-5 5) (vector 1 (vector 10 ))) ((equal? e-5 6) (vector 1 (vector 11 ))) ((equal? e-5 7) (vector 1 (vector 12 ))) ((equal? e-5 8) (vector 1 (vector 13 ))) ((equal? e-5 9) (vector 1 (vector 14 ))) ((equal? e-5 10) (vector 1 (vector 18 ))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 19 e-6 e-7))))))))))) ((equal? e-5 12) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 20 e-6))))))) ((equal? e-5 13) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1678) arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 21 e-6 e-7))))))))))) ((equal? e-5 14) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1674) arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 22 e-6 e-7))))))))))) ((equal? e-5 15) (vector 1 (vector 15 ))) ((equal? e-5 16) (vector 1 (vector 16 ))) ((equal? e-5 17) (vector 1 (vector 3 ))) ((equal? e-5 18) (vector 1 (vector 4 ))) ((equal? e-5 19) (vector 1 (vector 5 ))) ((equal? e-5 20) (vector 1 (vector 6 ))) ((equal? e-5 21) (vector 1 (vector 17 ))) ((equal? e-5 22) (vector 1 (vector 2 )))(else (CoreC-45BinaryC-45Prims-corrupt "CFType" ext-0)))))))))
(define csegen-1616 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_CDef (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 e-6 arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 0 e-6 e-7))))))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1643 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1616 arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 1 e-6 e-7 e-8))))))))))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1674) arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 2 e-6 e-7 e-8))))))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 '() arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "CDef" ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_CDef (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 e-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 e-0 arg-0 e-1 ext-0)))))))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1643 arg-0 e-2) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-3) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1616 arg-0 e-4) ext-0)))))))))))))) ((2) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 arg-0 e-5 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1674) arg-0 e-6 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-7 ext-0)))))))))))))) (else (let ((e-8 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 '() arg-0 e-8 ext-0)))))))))
(define csegen-40 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_CDef i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_CDef i_con-0 eta-0)))))
(define csegen-46 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bool i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool i_con-0 eta-0)))))
(define csegen-47 (cons csegen-43 csegen-46))
(define csegen-50 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-47 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-47 i_con-0 eta-0)))))
(define csegen-53 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-50 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-50 i_con-0 eta-0)))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (<= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define LibrariesC-45DataC-45IntMap-treeLookup (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-2 e-1))) (cond ((equal? sc1 1) (box e-2)) (else '())))))) ((1) (let ((e-5 (vector-ref arg-3 1))) (let ((e-6 (vector-ref arg-3 2))) (let ((e-7 (vector-ref arg-3 3))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-6))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-5)) (else (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-7)))))))) (else (let ((e-10 (vector-ref arg-3 1))) (let ((e-11 (vector-ref arg-3 2))) (let ((e-12 (vector-ref arg-3 3))) (let ((e-13 (vector-ref arg-3 4))) (let ((e-14 (vector-ref arg-3 5))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-11))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-10)) (else (let ((sc2 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-13))) (cond ((equal? sc2 1) (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-12)) (else (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-14))))))))))))))))
(define LibrariesC-45DataC-45IntMap-lookup (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-3 (cdr arg-2))) (LibrariesC-45DataC-45IntMap-treeLookup arg-1 e-3)))))
(define CoreC-45Context-getContent (lambda (ext-0) (let ((e-4 (vector-ref ext-0 4))) e-4)))
(define DataC-45IORef-newIORef (lambda (arg-2 arg-3) (let ((e-1 (car arg-2))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (let ((e-6 (cdr arg-2))) ((e-6 'erased) (lambda (eta-0) (box arg-3))))) (lambda (u--m) (let ((e-7 (car arg-2))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) u--m))))))))))
(define CoreC-45Core-newRef (lambda (arg-3) (let ((eff-0 (lambda (world-0) (let ((act-1 ((DataC-45IORef-newIORef (force csegen-85) arg-3) world-0))) (vector 1 act-1))))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 e-5)))))))))
(define LibrariesC-45DataC-45IOArray-max (lambda (ext-0) (let ((e-1 (car ext-0))) e-1)))
(define LibrariesC-45DataC-45IOArray-writeArray (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (let ((sc1 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-4 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-4 (LibrariesC-45DataC-45IOArray-max arg-3))))))) (cond ((equal? sc0 1) (let ((e-1 (car arg-2))) (let ((e-5 (vector-ref e-1 0))) (let ((e-7 (vector-ref e-5 1))) ((e-7 'erased) 'erased))))) (else (let ((e-2 (cdr arg-2))) ((e-2 'erased) (lambda (eta-0) (vector-set! (let ((e-3 (cdr arg-3))) e-3) arg-4 (box arg-5))))))))))
(define LibrariesC-45DataC-45NameMap-empty '())
(define CoreC-45Name-nameTag (lambda (arg-0) (case (vector-ref arg-0 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 6) ((6) 7) ((7) 8) (else 9))))
(define PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car arg-5))) (let ((e-7 (cdr arg-5))) (let ((sc2 (let ((e-1 (vector-ref arg-2 0))) (let ((e-13 (cdr e-1))) ((e-13 e-2) e-6))))) (cond ((equal? sc2 1) (let ((e-12 (vector-ref arg-2 1))) ((e-12 e-2) e-6))) (else (let ((e-12 (vector-ref arg-3 1))) ((e-12 e-3) e-7)))))))))))
(define PreludeC-45EqOrd-u--compare_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45Types-case--compare-6835 (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (cond ((equal? arg-6 1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 arg-1 arg-3 arg-5))(else arg-6))))
(define PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (if (null? arg-3) 2 (let ((e-10 (car arg-3))) (let ((e-11 (cdr arg-3))) (PreludeC-45Types-case--compare-6835 arg-1 e-2 e-3 e-10 e-11 (let ((e-12 (vector-ref arg-1 1))) ((e-12 e-2) e-10)))))))))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string<=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-60_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string<? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string>=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string>? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_String arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_String arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--max_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_String arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--min_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_String arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-544 (vector (force csegen-23) (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45EqOrd-u--compare_Ord_String arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45EqOrd-u--C-60_Ord_String arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45EqOrd-u--C-62_Ord_String arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45EqOrd-u--C-60C-61_Ord_String arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45EqOrd-u--C-62C-61_Ord_String arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45EqOrd-u--max_Ord_String arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45EqOrd-u--min_Ord_String arg-1658 arg-1661)))))
(define CoreC-45NameC-45Namespace-u--compare_Ord_Namespace (lambda (arg-0 arg-1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 csegen-544 arg-0 arg-1)))
(define CoreC-45Name-usernameTag (lambda (arg-0) (case (vector-ref arg-0 0) ((0) 0) ((1) 2) (else 3))))
(define CoreC-45Name-u--compare_Ord_UserName (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_String e-0 e-2)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1)))))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-3 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_String e-1 e-3)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1)))))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1)))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1))))))
(define PreludeC-45EqOrd-u--C-62_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (> arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--max_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_Int arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--min_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-236(delay (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_Int arg-722 arg-725))))))
(define csegen-244(delay (vector (force csegen-236) (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45EqOrd-u--compare_Ord_Int arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45EqOrd-u--C-60_Ord_Int arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45EqOrd-u--C-62_Ord_Int arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45EqOrd-u--max_Ord_Int arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45EqOrd-u--min_Ord_Int arg-1658 arg-1661))))))
(define CoreC-45Name-u--compare_Ord_Name (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--compare_Ord_Name e-1 e-17))) (cond ((equal? sc2 1) (CoreC-45NameC-45Namespace-u--compare_Ord_Namespace e-0 e-16)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-18 (vector-ref arg-1 1))) (CoreC-45Name-u--compare_Ord_UserName e-2 e-18)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1)))))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-4 e-20))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_String e-3 e-19)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((3) (let ((e-21 (vector-ref arg-1 1))) (let ((e-22 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-6 e-22))) (cond ((equal? sc2 1) (CoreC-45Name-u--compare_Ord_Name e-5 e-21)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((4) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((4) (let ((e-24 (vector-ref arg-1 2))) (CoreC-45Name-u--compare_Ord_Name e-8 e-24)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1)))))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((5) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--compare_Ord_Name e-10 e-26))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) e-9 e-25)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (let ((e-12 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-27 (vector-ref arg-1 1))) (let ((e-28 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-12 e-28))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_String e-11 e-27)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((7) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-14 e-30))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_String e-13 e-29)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((8) (let ((e-15 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-31 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int e-15 e-31)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))
(define CoreC-45Name-u--C-60C-61_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 2)))
(define LibrariesC-45DataC-45NameMap-treeInsertC-39 (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (let ((sc1 (CoreC-45Name-u--compare_Ord_Name arg-2 e-1))) (cond ((equal? sc1 0) (vector 1 (cons (vector 0 arg-2 arg-3) (cons arg-2 (vector 0 e-1 e-2))))) ((equal? sc1 1) (vector 0 (vector 0 arg-2 arg-3))) (else (vector 1 (cons (vector 0 e-1 e-2) (cons e-1 (vector 0 arg-2 arg-3)))))))))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-6))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-5))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-2 e-6 e-7)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-10 e-12 e-13 e-6 e-7))))))))))) (else (let ((sc2 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-7))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-5 e-6 e-2)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-5 e-6 e-10 e-12 e-13))))))))))))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) (let ((e-14 (vector-ref arg-4 5))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-11))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-10))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 2 e-2 e-11 e-12 e-13 e-14)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-8 e-16 e-15) (cons e-11 (vector 1 e-12 e-13 e-14))))))))))))) (else (let ((sc2 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-13))) (cond ((equal? sc2 1) (let ((sc3 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-12))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-2 e-13 e-14)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-8) (cons e-16 (vector 1 e-15 e-13 e-14))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-14))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-12 e-13 e-2)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-12) (cons e-13 (vector 1 e-8 e-16 e-15)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45NameMap-treeInsert (lambda (arg-2 arg-3 arg-4) (let ((sc0 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 arg-4))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref sc0 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (vector 1 e-8 e-12 e-13))))))))))))
(define LibrariesC-45DataC-45NameMap-insert (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (cons 0 (vector 0 arg-1 arg-2)) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((sc1 (LibrariesC-45DataC-45NameMap-treeInsert arg-1 arg-2 e-3))) (case (vector-ref sc1 0) ((0) (let ((e-4 (vector-ref sc1 1))) (cons e-2 e-4))) (else (let ((e-5 (vector-ref sc1 1))) (cons (+ e-2 1) e-5))))))))))
(define csegen-836 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (PreludeC-45Basics-uncurry (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (LibrariesC-45DataC-45NameMap-insert eta-3 eta-4 eta-5)))) eta-2)) eta-0 eta-1))))
(define LibrariesC-45DataC-45NameMap-fromList (lambda (arg-1) (PreludeC-45Types-u--foldl_Foldable_List csegen-836 LibrariesC-45DataC-45NameMap-empty arg-1)))
(define CoreC-45Name-isUserName (lambda (arg-0) (case (vector-ref arg-0 0) ((3) 0) ((2) 0) ((0) (let ((e-5 (vector-ref arg-0 2))) (CoreC-45Name-isUserName e-5))) ((4) (let ((e-7 (vector-ref arg-0 2))) (CoreC-45Name-isUserName e-7)))(else 1))))
(define LibrariesC-45DataC-45WithDefault-specified (lambda (ext-0) (box ext-0)))
(define CoreC-45TT-unchecked (cons (vector 0 ) (vector 0 )))
(define LibrariesC-45DataC-45WithDefault-defaulted '())
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40WithDefaultC-32C-36aC-41C-32C-36defC-41 (lambda (arg-2 arg-3 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 LibrariesC-45DataC-45WithDefault-defaulted)) ((equal? e-5 1) (let ((act-2 (let ((e-2 (cdr arg-2))) ((e-2 arg-3) ext-0)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (LibrariesC-45DataC-45WithDefault-specified e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "WithDefault" ext-0)))))))))
(define CoreC-45TTC-45Term-apply (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) arg-2 (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (CoreC-45TTC-45Term-apply arg-1 (vector 4 arg-1 arg-2 e-2) e-3))))))
(define CoreC-45FC-emptyFC (vector 2 ))
(define PreludeC-45Types-maybe (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (arg-2) (let ((e-2 (unbox arg-4))) ((arg-3) e-2)))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 2 ))) ((equal? e-5 3) (let ((act-2 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) ext-0)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "PiInfo" ext-0)))))))))
(define AlgebraC-45ZeroOneOmega-u--top_Top_ZeroOneOmega 2)
(define csegen-1679 (vector 1 (force csegen-31)))
(define AlgebraC-45Semiring-linear (lambda (arg-1) (let ((e-4 (vector-ref arg-1 3))) e-4)))
(define csegen-1496(delay (AlgebraC-45Semiring-linear (force csegen-30))))
(define csegen-1680 (vector 1 (force csegen-1496)))
(define CoreC-45TTC-u--fromBuf_TTC_RigCount (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) csegen-1679) ((equal? e-5 1) csegen-1680) ((equal? e-5 2) (vector 1 AlgebraC-45ZeroOneOmega-u--top_Top_ZeroOneOmega))(else (CoreC-45BinaryC-45Prims-corrupt "RigCount" ext-0)))))))))
(define CoreC-45TTC-45Term-n--7071-6508-u--getFA (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((4) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (CoreC-45TTC-45Term-n--7071-6508-u--getFA arg-1 (cons e-3 arg-2) e-2))))(else (cons arg-3 arg-2)))))
(define CoreC-45TTC-45Term-getFnArgs (lambda (arg-1) (CoreC-45TTC-45Term-n--7071-6508-u--getFA arg-1 '() arg-1)))
(define PreludeC-45Types-u--C-60_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 0)))
(define CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (case (vector-ref arg-3 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-2 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-2 1 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-2 2 ext-0)) (else (let ((e-4 (vector-ref arg-3 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-2 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-1 (car arg-1))) (((e-1 arg-2) e-4) ext-0))))))))))
(define AlgebraC-45Semiring-elimSemi (lambda (arg-2 arg-3 arg-4 arg-5 arg-6) (let ((sc0 (let ((sc1 (Builtin-snd arg-2))) (let ((e-1 (car sc1))) ((e-1 arg-6) (let ((sc2 (Builtin-fst arg-2))) (let ((e-5 (vector-ref sc2 1))) e-5))))))) (cond ((equal? sc0 1) arg-3) (else (let ((sc1 (let ((sc2 (Builtin-snd arg-2))) (let ((e-1 (car sc2))) ((e-1 arg-6) (let ((sc3 (Builtin-fst arg-2))) (let ((e-4 (vector-ref sc3 3))) e-4))))))) (cond ((equal? sc1 1) arg-4) (else (arg-5 arg-6)))))))))
(define AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define AlgebraC-45ZeroOneOmega-u--C-47C-61_Eq_ZeroOneOmega (lambda (arg-0 arg-1) (let ((sc0 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-977(delay (cons (lambda (arg-712) (lambda (arg-715) (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (AlgebraC-45ZeroOneOmega-u--C-47C-61_Eq_ZeroOneOmega arg-722 arg-725))))))
(define csegen-978(delay (cons (force csegen-30) (force csegen-977))))
(define CoreC-45TTC-u--toBuf_TTC_RigCount (lambda (arg-0 ext-0) (AlgebraC-45Semiring-elimSemi (force csegen-978) (lambda (eta-0) (CoreC-45BinaryC-45Prims-tag arg-0 0 eta-0)) (lambda (eta-0) (CoreC-45BinaryC-45Prims-tag arg-0 1 eta-0)) (lambda (eta-0) (lambda (eta-1) (CoreC-45BinaryC-45Prims-tag arg-0 2 eta-1))) ext-0)))
(define CoreC-45TTC-u--toBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-2) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-3 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-4) ext-0)))))))))))))) ((1) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-7) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-8) ext-0)))))))))) ((2) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-12) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-13 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-14) ext-0)))))))))))))) ((3) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-17) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-18 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-19) ext-0)))))))))))))) ((4) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-22) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-23) ext-0)))))))))) (else (let ((e-27 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-27) ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_NameType (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-0) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-1) ext-0)))))))))) (else (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-2) ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_UseSide (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (lambda (clam-0) (let ((sc1 (PreludeC-45Types-u--C-60_Ord_Nat e-4 243))) (cond ((equal? sc1 1) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 (bs+ (blodwen-toSignedInt e-4 63) 13 63) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-46 arg-1 e-3) clam-0))))) (else (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-46 arg-1 e-3) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-4) clam-0)))))))))))))) ((1) (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_NameType arg-1 e-8 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-9) eta-0))))))))))) ((2) (let ((e-12 (vector-ref arg-2 2))) (let ((e-14 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-12) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-1)))) arg-1 e-14 eta-0))))))))))) ((3) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-17) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 arg-0 arg-1 e-18 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 (cons e-17 arg-0) arg-1 e-19) eta-0))))))))))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (let ((sc1 (CoreC-45TTC-45Term-getFnArgs (vector 4 e-21 e-22 e-23)))) (let ((e-2 (car sc1))) (let ((e-3 (cdr sc1))) (lambda (clam-0) (if (null? e-3) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 12 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-2) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-3 clam-0))))))) (let ((e-1 (car e-3))) (let ((e-4 (cdr e-3))) (if (null? e-4) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-2) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-1) clam-0))))))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 12 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-2) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-3 clam-0))))))))))))))))))) ((5) (let ((e-26 (vector-ref arg-2 2))) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-27) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_UseSide arg-1 e-26 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-28) eta-0))))))))))))))) ((6) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 6 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-31 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-32) eta-0))))))))))) ((7) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 7 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-35 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-36) eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-37) eta-0))))))))))))))) ((8) (let ((e-40 (vector-ref arg-2 2))) (let ((e-41 (vector-ref arg-2 3))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 8 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-40 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-41) eta-0))))))))))) ((9) (let ((e-44 (vector-ref arg-2 2))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 9 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-44 eta-0))))))) ((10) (lambda (eta-0) (CoreC-45BinaryC-45Prims-tag arg-1 10 eta-0))) (else (let ((e-50 (vector-ref arg-2 2))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 11 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-50) eta-0))))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 0 CoreC-45FC-emptyFC e-6 e-7 e-8))))))))))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 1 CoreC-45FC-emptyFC e-6 e-7 (vector 10 CoreC-45FC-emptyFC (vector 0 ))))))))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 2 CoreC-45FC-emptyFC e-6 e-7 e-8))))))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 3 CoreC-45FC-emptyFC e-6 e-7 e-8))))))))))))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 4 CoreC-45FC-emptyFC e-6 e-7 (vector 10 CoreC-45FC-emptyFC (vector 0 ))))))))))))) ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 5 CoreC-45FC-emptyFC e-6 (vector 10 CoreC-45FC-emptyFC (vector 0 )))))))))(else (CoreC-45BinaryC-45Prims-corrupt "Binder" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_NameType (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 2 e-6 e-7))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "NameType" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_UseSide (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1))(else (CoreC-45BinaryC-45Prims-corrupt "UseSide" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-46 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 ((PreludeC-45Types-maybe (lambda () (lambda (eta-0) (CoreC-45BinaryC-45Prims-corrupt "Term" eta-0))) (lambda () (lambda (eta-0) (lambda (eta-1) (vector 1 eta-0)))) (PreludeC-45Types-getAt e-7 arg-0)) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (vector 1 (vector 0 CoreC-45FC-emptyFC e-6 e-7)))))))))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_NameType arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 1 CoreC-45FC-emptyFC e-6 e-7))))))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 2 CoreC-45FC-emptyFC e-6 0 e-7))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 (cons e-6 arg-0) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 3 CoreC-45FC-emptyFC e-6 e-7 e-8))))))))))))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 4 CoreC-45FC-emptyFC e-6 e-7))))))))))) ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_UseSide arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 5 CoreC-45FC-emptyFC e-7 e-6 e-8))))))))))))))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 6 CoreC-45FC-emptyFC e-6 e-7))))))))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 7 CoreC-45FC-emptyFC e-6 e-7 e-8))))))))))))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 8 CoreC-45FC-emptyFC e-6 e-7))))))))))) ((equal? e-5 9) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 9 CoreC-45FC-emptyFC e-6))))))) ((equal? e-5 10) (vector 1 (vector 10 CoreC-45FC-emptyFC (vector 0 )))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 11 CoreC-45FC-emptyFC e-6))))))) ((equal? e-5 12) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (CoreC-45TTC-45Term-apply CoreC-45FC-emptyFC e-6 e-7)))))))))))(else (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-46 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((u--idx (PreludeC-45Types-prim__integerToNat (bs- e-5 13 63)))) (let ((sc2 (PreludeC-45Types-getAt u--idx arg-0))) (if (null? sc2) (CoreC-45BinaryC-45Prims-corrupt "Term" ext-0) (vector 1 (vector 0 CoreC-45FC-emptyFC e-6 u--idx)))))))))))))))))
(define CoreC-45ContextC-45Context-holeInit (lambda (arg-0) (cons arg-0 0)))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CaseAltC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-8 arg-0) arg-1 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (vector 1 (vector 0 e-6 e-7 e-8 e-9))))))))))))))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend (cons e-6 (cons e-7 '())) arg-0) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 1 e-6 e-7 e-8))))))))))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 2 e-6 e-7))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "CaseAlt" ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-2) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-3 (vector-ref act-3 1))) (vector 0 e-3))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 e-5 ext-0)))))))))))))) ((1) (let ((e-8 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-8) ext-0)))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-1 e-10) ext-0)))))) (else (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CaseAltC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-1 e-2) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-1 e-3 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-3 arg-0) arg-1 e-4 ext-0)))))))))))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-6) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-7) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend (cons e-6 (cons e-7 '())) arg-0) arg-1 e-8 ext-0)))))))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-10 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 e-11 ext-0)))))))))) (else (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 e-13 ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 i_con-0 eta-0)))) arg-1 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 0 e-6 e-7 (vector 10 CoreC-45FC-emptyFC (vector 0 )) e-8))))))))))))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 1 0 e-6))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-6))))))) ((equal? e-5 3) (vector 1 (vector 3 )))(else (CoreC-45BinaryC-45Prims-corrupt "CaseTree" ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO csegen-1684 (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 eta-0)) ext-0)))
(define CoreC-45TTC-u--fromBuf_TTC_HoleInfo (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 '())) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (box e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "HoleInfo" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_PMDefInfo (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_HoleInfo arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector e-5 e-6 e-7))))))))))))))))
(define CoreC-45TTC-u--fromBuf_TTC_TypeFlags (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))
(define csegen-1656 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 i_con-0 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 (lambda (arg-2 arg-3 ext-0) (let ((act-1 (let ((sc0 (Builtin-fst arg-2))) (let ((e-2 (cdr sc0))) ((e-2 arg-3) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (let ((sc1 ((Builtin-snd arg-2) e-5))) (let ((e-2 (cdr sc1))) ((e-2 arg-3) ext-0))))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 (lambda (arg-2 arg-3 arg-4 ext-0) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((act-1 (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) (((e-1 arg-3) e-2) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((sc2 ((Builtin-snd arg-2) e-2))) (let ((e-1 (car sc2))) (((e-1 arg-3) e-3) ext-0))))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (if (null? arg-0) (vector 1 '()) (let ((e-3 (cdr arg-0))) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 e-3 arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-3 arg-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2) (if (null? arg-2) (lambda (eta-0) (vector 1 'erased)) (lambda (clam-0) (let ((e-2 (cdr arg-0))) (let ((e-6 (car arg-2))) (let ((e-7 (cdr arg-2))) (let ((act-1 (CoreC-45TTC-u--toBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 e-2 arg-1 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-2 arg-1 e-7) clam-0)))))))))))
(define csegen-1658 (cons csegen-1656 (lambda (u--y) (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (i_con-1) (lambda (arg-5587) (CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y i_con-1 arg-5587))) (lambda (i_con-1) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y i_con-1 eta-1)))) (cons (lambda (i_con-1) (lambda (arg-5587) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (i_con-2) (lambda (arg-5588) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5588))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2)))) (cons (lambda (i_con-2) (lambda (arg-5588) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5588))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2))))) i_con-1 arg-5587 eta-1)))) (lambda (i_con-1) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (i_con-2) (lambda (arg-5587) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5587))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2)))) (cons (lambda (i_con-2) (lambda (arg-5587) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5587))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2))))) i_con-1 eta-1))))) i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (i_con-1) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y i_con-1 arg-5586))) (lambda (i_con-1) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y i_con-1 eta-1)))) (cons (lambda (i_con-1) (lambda (arg-5586) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (i_con-2) (lambda (arg-5587) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5587))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2)))) (cons (lambda (i_con-2) (lambda (arg-5587) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5587))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2))))) i_con-1 arg-5586 eta-1)))) (lambda (i_con-1) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (i_con-2) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5586))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2)))) (cons (lambda (i_con-2) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 arg-5586))) (lambda (i_con-2) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y i_con-2 eta-2))))) i_con-1 eta-1))))) i_con-0 eta-0)))))))
(define csegen-1661 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 csegen-1658 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 csegen-1658 i_con-0 eta-0)))))
(define csegen-1662 (cons csegen-46 csegen-1616))
(define csegen-1665 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1662 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1662 i_con-0 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_NatSet (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define csegen-1668 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_NatSet i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_Def (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PMDefInfo arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 e-7 arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1661 arg-0 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (vector 1 (vector 1 e-6 e-7 e-8 (vector 2 "") e-9))))))))))))))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-6))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 3 e-6 e-7))))))))))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1665 arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 5 e-6 e-7 e-8))))))))))))))) ((equal? e-5 5) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_TypeFlags arg-0 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (let ((act-6 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 ext-0))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) (let ((act-7 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1656 arg-0 ext-0))) (case (vector-ref act-7 0) ((0) (let ((e-2 (vector-ref act-7 1))) (vector 0 e-2))) (else (let ((e-11 (vector-ref act-7 1))) (let ((act-8 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1668 arg-0 ext-0))) (case (vector-ref act-8 0) ((0) (let ((e-2 (vector-ref act-8 1))) (vector 0 e-2))) (else (let ((e-12 (vector-ref act-8 1))) (vector 1 (vector 6 e-6 e-7 e-8 e-9 e-10 e-11 e-12))))))))))))))))))))))))))))))) ((equal? e-5 6) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 7 e-6 (CoreC-45ContextC-45Context-holeInit e-7)))))))))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 8 e-6 e-7 e-8))))))))))))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 '() arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1643 arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector 9 e-6 e-7 e-8))))))))))))))) ((equal? e-5 9) (vector 1 (vector 10 ))) ((equal? e-5 10) (vector 1 (vector 12 ))) ((equal? e-5 11) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 11 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "Def" ext-0)))))))))
(define csegen-1671 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 '() i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 '() i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_Covering (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1671 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 1 e-6))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "Covering" ext-0)))))))))
(define csegen-1633 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_FC i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_FC i_con-0 eta-0)))))
(define csegen-1634 (cons csegen-1633 csegen-43))
(define csegen-1637 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1634 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1634 i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_PartialReason (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 1 e-6))))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1637 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 2 e-6 e-7))))))))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1637 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "PartialReason" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_Terminating (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PartialReason arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-6)))))))(else (CoreC-45BinaryC-45Prims-corrupt "Terminating" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_Totality (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Terminating arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Covering arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))
(define PreludeC-45Types-u--map_Functor_Maybe (lambda (arg-2 arg-3) (if (null? arg-3) '() (let ((e-1 (unbox arg-3))) (box (arg-2 e-1))))))
(define CoreC-45TTC-u--fromBuf_TTC_Visibility (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "Visibility" ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_Visibility (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define csegen-1647 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_Visibility i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Visibility i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_TotalReq (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "TotalReq" ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_DefFlag (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 2) (vector 1 (vector 0 ))) ((equal? e-5 3) (vector 1 (vector 3 ))) ((equal? e-5 4) (vector 1 (vector 4 ))) ((equal? e-5 5) (vector 1 (vector 5 ))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_TotalReq arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 6 e-6))))))) ((equal? e-5 7) (vector 1 (vector 7 ))) ((equal? e-5 8) (vector 1 (vector 8 ))) ((equal? e-5 9) (vector 1 (vector 9 '()))) ((equal? e-5 10) (vector 1 (vector 10 ))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_ConInfo arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 11 e-6))))))) ((equal? e-5 12) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 12 e-6))))))) ((equal? e-5 13) (vector 1 (vector 1 ))) ((equal? e-5 15) (vector 1 (vector 2 )))(else (CoreC-45BinaryC-45Prims-corrupt "DefFlag" ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_TotalReq (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_DefFlag (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-0 15 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((4) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((6) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_TotalReq arg-0 e-0 ext-0)))))) ((7) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((8) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((9) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) ((10) (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)) ((11) (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_ConInfo arg-0 e-2 ext-0)))))) (else (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-3) ext-0)))))))))
(define csegen-1650 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_DefFlag i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_DefFlag i_con-0 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 arg-1 arg-2 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (let ((act-1 (let ((e-1 (car arg-1))) (((e-1 arg-2) (let ((e-4 (car arg-3))) e-4)) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 arg-1 arg-2 (let ((e-2 (cdr arg-3))) e-2) ext-0))))))
(define CoreC-45TTC-u--fromBuf_TTC_SizeChange (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "SizeChange" ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_SizeChange (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define csegen-1620 (cons csegen-1616 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_SizeChange i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_SizeChange i_con-0 eta-0))))))
(define csegen-1623 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1620 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1620 i_con-0 eta-0)))))
(define csegen-1627 (cons csegen-1616 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40List1C-32C-36aC-41 csegen-1623 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40List1C-32C-36aC-41 csegen-1623 i_con-0 eta-0))))))
(define csegen-1630 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1627 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1627 i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_SCCall (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1630 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_FC arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector e-5 e-6 e-7))))))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_SCCall (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-0 (vector-ref arg-1 0))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1630 arg-0 (let ((e-1 (vector-ref arg-1 1))) e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_FC arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2) ext-0)))))))))
(define csegen-1653 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_SCCall i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_SCCall i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_GlobalDef (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-40 arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-53 arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((u--refsR (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (LibrariesC-45DataC-45NameMap-fromList eta-0)) e-6))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_FC arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (let ((act-6 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-53 arg-0 ext-0))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) (let ((u--refs (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (LibrariesC-45DataC-45NameMap-fromList eta-0)) e-10))) (let ((act-7 (CoreC-45TTC-u--fromBuf_TTC_Def arg-0 ext-0))) (case (vector-ref act-7 0) ((0) (let ((e-2 (vector-ref act-7 1))) (vector 0 e-2))) (else (let ((e-11 (vector-ref act-7 1))) (let ((sc7 (CoreC-45Name-isUserName e-9))) (cond ((equal? sc7 1) (let ((act-8 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 '() arg-0 ext-0))) (case (vector-ref act-8 0) ((0) (let ((e-2 (vector-ref act-8 1))) (vector 0 e-2))) (else (let ((e-12 (vector-ref act-8 1))) (let ((act-9 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet arg-0 ext-0))) (case (vector-ref act-9 0) ((0) (let ((e-2 (vector-ref act-9 1))) (vector 0 e-2))) (else (let ((e-13 (vector-ref act-9 1))) (let ((act-10 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet arg-0 ext-0))) (case (vector-ref act-10 0) ((0) (let ((e-2 (vector-ref act-10 1))) (vector 0 e-2))) (else (let ((e-14 (vector-ref act-10 1))) (let ((act-11 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet arg-0 ext-0))) (case (vector-ref act-11 0) ((0) (let ((e-2 (vector-ref act-11 1))) (vector 0 e-2))) (else (let ((e-15 (vector-ref act-11 1))) (let ((act-12 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_NatSet arg-0 ext-0))) (case (vector-ref act-12 0) ((0) (let ((e-2 (vector-ref act-12 1))) (vector 0 e-2))) (else (let ((e-16 (vector-ref act-12 1))) (let ((act-13 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 ext-0))) (case (vector-ref act-13 0) ((0) (let ((e-2 (vector-ref act-13 1))) (vector 0 e-2))) (else (let ((e-17 (vector-ref act-13 1))) (let ((act-14 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40WithDefaultC-32C-36aC-41C-32C-36defC-41 csegen-1647 arg-0 ext-0))) (case (vector-ref act-14 0) ((0) (let ((e-2 (vector-ref act-14 1))) (vector 0 e-2))) (else (let ((e-18 (vector-ref act-14 1))) (let ((act-15 (CoreC-45TTC-u--fromBuf_TTC_Totality arg-0 ext-0))) (case (vector-ref act-15 0) ((0) (let ((e-2 (vector-ref act-15 1))) (vector 0 e-2))) (else (let ((e-19 (vector-ref act-15 1))) (let ((act-16 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-16 0) ((0) (let ((e-2 (vector-ref act-16 1))) (vector 0 e-2))) (else (let ((e-20 (vector-ref act-16 1))) (let ((act-17 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1650 arg-0 ext-0))) (case (vector-ref act-17 0) ((0) (let ((e-2 (vector-ref act-17 1))) (vector 0 e-2))) (else (let ((e-21 (vector-ref act-17 1))) (let ((act-18 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-18 0) ((0) (let ((e-2 (vector-ref act-18 1))) (vector 0 e-2))) (else (let ((e-22 (vector-ref act-18 1))) (let ((act-19 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-19 0) ((0) (let ((e-2 (vector-ref act-19 1))) (vector 0 e-2))) (else (let ((e-23 (vector-ref act-19 1))) (let ((act-20 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1653 arg-0 ext-0))) (case (vector-ref act-20 0) ((0) (let ((e-2 (vector-ref act-20 1))) (vector 0 e-2))) (else (let ((e-24 (vector-ref act-20 1))) (vector 1 (vector e-7 e-9 e-12 e-13 e-14 e-15 e-16 e-8 e-17 e-18 e-19 e-20 e-21 u--refs u--refsR e-22 e-23 1 e-11 e-5 '() e-24 '()))))))))))))))))))))))))))))))))))))))))))))))))))))))) (else (vector 1 (vector e-7 e-9 (vector 10 e-7 (vector 0 )) 0 0 0 0 e-8 '() (LibrariesC-45DataC-45WithDefault-specified 2) CoreC-45TT-unchecked 0 '() u--refs u--refsR 0 0 1 e-11 e-5 '() '() '())))))))))))))))))))))))))))))))))))))
(define CoreC-45Core-traverseC-39 (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) (lambda (eta-0) (vector 1 (PreludeC-45TypesC-45List-reverse arg-4))) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((eff-0 (arg-2 e-2))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((CoreC-45Core-traverseC-39 arg-2 e-3 (cons e-5 arg-4)) world-0))))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (if (null? arg-3) (vector 1 '()) (let ((e-2 (unbox arg-3))) (let ((act-1 (let ((e-3 (cdr arg-1))) (((e-3 arg-2) e-2) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (box e-5))))))))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car arg-5))) (let ((e-7 (cdr arg-5))) (let ((sc2 (let ((e-1 (car arg-2))) ((e-1 e-2) e-6)))) (cond ((equal? sc2 1) (let ((e-1 (car arg-3))) ((e-1 e-3) e-7))) (else 0)))))))))
(define PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (if (null? arg-3) 0 (let ((e-6 (car arg-3))) (let ((e-7 (cdr arg-3))) (let ((sc2 (let ((e-1 (car arg-1))) ((e-1 e-2) e-6)))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 arg-1 e-3 e-7)) (else 0)))))))))))
(define CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace (lambda (arg-0 arg-1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-23) arg-0 arg-1)))
(define CoreC-45Name-u--C-61C-61_Eq_UserName (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-2)))(else 0)))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-3 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 e-3)))(else 0)))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0)))(else 0))))
(define CoreC-45Name-u--C-61C-61_Eq_Name (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--C-61C-61_Eq_Name e-1 e-17))) (cond ((equal? sc2 1) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace e-0 e-16)) (else 0))))))(else 0))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-18 (vector-ref arg-1 1))) (CoreC-45Name-u--C-61C-61_Eq_UserName e-2 e-18)))(else 0)))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-4 e-20))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-3 e-19)) (else 0))))))(else 0))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((3) (let ((e-21 (vector-ref arg-1 1))) (let ((e-22 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--C-61C-61_Eq_Name e-5 e-21))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-6 e-22)) (else 0))))))(else 0))))) ((4) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((4) (let ((e-24 (vector-ref arg-1 2))) (CoreC-45Name-u--C-61C-61_Eq_Name e-8 e-24)))(else 0)))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((5) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-236) (force csegen-236) e-9 e-25))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-10 e-26)) (else 0))))))(else 0))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (let ((e-12 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-27 (vector-ref arg-1 1))) (let ((e-28 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-12 e-28))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-11 e-27)) (else 0))))))(else 0))))) ((7) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-14 e-30))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-13 e-29)) (else 0))))))(else 0))))) ((8) (let ((e-15 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-31 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-15 e-31)))(else 0))))(else 0))))
(define LibrariesC-45DataC-45NameMap-treeLookup (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((sc1 (CoreC-45Name-u--C-61C-61_Eq_Name arg-2 e-1))) (cond ((equal? sc1 1) (box e-2)) (else '())))))) ((1) (let ((e-5 (vector-ref arg-3 1))) (let ((e-6 (vector-ref arg-3 2))) (let ((e-7 (vector-ref arg-3 3))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-6))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-5)) (else (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-7)))))))) (else (let ((e-10 (vector-ref arg-3 1))) (let ((e-11 (vector-ref arg-3 2))) (let ((e-12 (vector-ref arg-3 3))) (let ((e-13 (vector-ref arg-3 4))) (let ((e-14 (vector-ref arg-3 5))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-11))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-10)) (else (let ((sc2 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-13))) (cond ((equal? sc2 1) (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-12)) (else (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-14))))))))))))))))
(define LibrariesC-45DataC-45NameMap-lookup (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-3 (cdr arg-2))) (LibrariesC-45DataC-45NameMap-treeLookup arg-1 e-3)))))
(define CoreC-45Context-getNameID (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((8) (let ((e-0 (vector-ref arg-0 1))) (box e-0)))(else (LibrariesC-45DataC-45NameMap-lookup arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2))))))
(define CoreC-45CoreC-45PiInfo-traverse (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((1) (lambda (eta-0) (vector 1 (vector 1 )))) ((0) (lambda (eta-0) (vector 1 (vector 0 )))) ((2) (lambda (eta-0) (vector 1 (vector 2 )))) (else (let ((e-4 (vector-ref arg-3 1))) (let ((eff-0 (arg-2 e-4))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 3 e-5)))))))))))))
(define CoreC-45CoreC-45Binder-traverse (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (let ((eff-0 (CoreC-45CoreC-45PiInfo-traverse arg-2 e-3))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (arg-2 e-4))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 0 e-1 e-2 e-5 e-6)))))))) world-0)))))))))))) ((1) (let ((e-6 (vector-ref arg-3 1))) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (let ((eff-0 (arg-2 e-8))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (arg-2 e-9))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-2 1))) (vector 1 (vector 1 e-6 e-7 e-5 e-10)))))))) world-0)))))))))))) ((2) (let ((e-11 (vector-ref arg-3 1))) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (let ((eff-0 (CoreC-45CoreC-45PiInfo-traverse arg-2 e-13))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (arg-2 e-14))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-11 e-12 e-5 e-6)))))))) world-0)))))))))))) ((3) (let ((e-16 (vector-ref arg-3 1))) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (let ((eff-0 (CoreC-45CoreC-45PiInfo-traverse arg-2 e-18))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (arg-2 e-19))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-16 e-17 e-5 e-6)))))))) world-0)))))))))))) ((4) (let ((e-21 (vector-ref arg-3 1))) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (let ((eff-0 (arg-2 e-23))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (arg-2 e-24))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-21 e-22 e-5 e-6)))))))) world-0)))))))))))) (else (let ((e-26 (vector-ref arg-3 1))) (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (let ((eff-0 (arg-2 e-28))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 5 e-26 e-27 e-5)))))))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (lambda (clam-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((sc1 (CoreC-45Context-getNameID e-3 arg-1))) (if (null? sc1) (vector 1 (vector 1 e-1 e-2 e-3)) (let ((e-4 (unbox sc1))) (vector 1 (vector 1 e-1 e-2 (vector 8 e-4)))))))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-7789)) e-8 '()) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-1 1))) (let ((sc2 (CoreC-45Context-getNameID e-6 arg-1))) (if (null? sc2) (vector 1 (vector 2 e-5 e-6 e-7 e-9)) (let ((e-1 (unbox sc2))) (vector 1 (vector 2 e-5 e-6 e-1 e-9)))))))))))))) ((3) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-7789)) e-12) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-13) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-10 e-11 e-5 e-6))))))))))))))) ((4) (let ((e-15 (vector-ref arg-2 1))) (let ((e-16 (vector-ref arg-2 2))) (let ((e-17 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-16) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-17) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-15 e-5 e-6)))))))))))))) ((5) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((e-22 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-21) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-22) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 5 e-19 e-20 e-5 e-6))))))))))))))) ((6) (let ((e-24 (vector-ref arg-2 1))) (let ((e-25 (vector-ref arg-2 2))) (let ((e-26 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-26) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 6 e-24 e-25 e-5)))))))))) ((7) (let ((e-28 (vector-ref arg-2 1))) (let ((e-29 (vector-ref arg-2 2))) (let ((e-30 (vector-ref arg-2 3))) (let ((e-31 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-30) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-31) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 7 e-28 e-29 e-5 e-6))))))))))))))) ((8) (let ((e-33 (vector-ref arg-2 1))) (let ((e-34 (vector-ref arg-2 2))) (let ((e-35 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-35) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 8 e-33 e-34 e-5)))))))))) ((11) (let ((e-37 (vector-ref arg-2 1))) (let ((e-38 (vector-ref arg-2 2))) (let ((sc1 (CoreC-45Context-getNameID e-38 arg-1))) (if (null? sc1) (vector 1 (vector 11 e-37 e-38)) (let ((e-1 (unbox sc1))) (vector 1 (vector 11 e-37 (vector 8 e-1))))))))) ((10) (let ((e-40 (vector-ref arg-2 1))) (let ((e-41 (vector-ref arg-2 2))) (case (vector-ref e-41 0) ((2) (let ((e-43 (vector-ref e-41 1))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-43) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 10 e-40 (vector 2 e-5)))))))))(else (vector 1 arg-2))))))(else (vector 1 arg-2))))))
(define CoreC-45Context-u--resolved_HasNames_C-40CaseAltC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) (let ((sc2 (CoreC-45Context-getNameID e-1 arg-1))) (if (null? sc2) (vector 1 (vector 0 e-1 e-2 e-3 e-5)) (let ((e-6 (unbox sc2))) (vector 1 (vector 0 (vector 8 e-6) e-2 e-3 e-5)))))))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-6 e-7 e-5)))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-10 e-5))))))))) (else (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 3 e-5)))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (arg-7789) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_C-40CaseAltC-32C-36varsC-41 arg-1 arg-7789 eta-0))) e-5 '()) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-7 (vector-ref act-2 1))) (vector 1 (vector 0 e-1 e-2 e-6 e-7))))))))))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-8) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-7 e-5)))))))))(else (vector 1 arg-2)))))
(define CoreC-45Context-u--resolved_HasNames_Name (lambda (arg-0 arg-1) (lambda (clam-0) (case (vector-ref arg-1 0) ((8) (let ((e-0 (vector-ref arg-1 1))) (vector 1 (vector 8 e-0))))(else (let ((sc0 (CoreC-45Context-getNameID arg-1 arg-0))) (if (null? sc0) (vector 1 arg-1) (let ((e-1 (unbox sc0))) (vector 1 (vector 8 e-1))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (if (null? arg-2) (vector 1 '()) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-7789)) e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-1 e-5 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) (vector 1 (cons e-6 e-7)))))))))))))))
(define CoreC-45Context-n--14777-9942-u--resolvedNamesPat (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (car arg-6))) (let ((e-3 (cdr arg-6))) (lambda (clam-0) (let ((e-6 (car e-3))) (let ((e-7 (cdr e-3))) (let ((e-10 (car e-7))) (let ((e-11 (cdr e-7))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-5 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-10) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-8 (vector-ref act-2 1))) (let ((act-3 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-11) clam-0))) (case (vector-ref act-3 0) ((0) (let ((e-4 (vector-ref act-3 1))) (vector 0 e-4))) (else (let ((e-9 (vector-ref act-3 1))) (vector 1 (cons e-2 (cons e-5 (cons e-8 e-9)))))))))))))))))))))))))
(define csegen-1062 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (box e-5)))))))
(define CoreC-45Context-u--resolved_HasNames_Def (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((e-3 (vector-ref arg-1 4))) (let ((e-4 (vector-ref arg-1 5))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-n--14777-9942-u--resolvedNamesPat e-4 e-1 e-3 e-2 e-0 arg-0 eta-0)) e-4 '()) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 1 e-0 e-1 e-5 e-6 e-7)))))))))))))))))))) ((6) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((e-8 (vector-ref arg-1 4))) (let ((e-9 (vector-ref arg-1 5))) (let ((e-10 (vector-ref arg-1 6))) (let ((e-11 (vector-ref arg-1 7))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-9 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-12 (vector-ref act-1 1))) (let ((act-2 (if (null? e-10) (vector 1 '()) (let ((e-2 (unbox e-10))) ((let ((eff-0 (CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-2 '()))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))) ext-0))))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-13 (vector-ref act-2 1))) (vector 1 (vector 6 e-5 e-6 e-7 e-8 e-12 e-13 e-11)))))))))))))))))) ((8) (let ((e-12 (vector-ref arg-1 1))) (let ((e-13 (vector-ref arg-1 2))) (let ((e-14 (vector-ref arg-1 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-14) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 8 e-12 e-13 e-5)))))))))) ((9) (let ((e-15 (vector-ref arg-1 1))) (let ((e-16 (vector-ref arg-1 2))) (let ((e-17 (vector-ref arg-1 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-15) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 9 e-5 e-16 e-17))))))))))(else (vector 1 arg-1)))))
(define CoreC-45Context-u--resolved_HasNames_SCCall (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 (let ((e-0 (vector-ref arg-1 0))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (vector e-5 e-1 e-2))))))))))
(define CoreC-45Context-u--resolved_HasNames_Covering (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 arg-7789)) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-5)))))))) (else (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-5)))))))))))
(define CoreC-45Core-traversePair (lambda (arg-3 arg-4) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((eff-0 (arg-3 e-3))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-4 (vector-ref eta-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (cons e-2 e-5)))))) eff-0 eta-0)))))))
(define CoreC-45Context-u--resolved_HasNames_PartialReason (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-5)))))))) ((2) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) eta-0)) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-5 e-6))))))))))))) (else (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) eta-0)) e-3 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 3 e-5)))))))))))
(define CoreC-45Context-u--resolved_HasNames_Terminating (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_PartialReason arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-5))))))))(else (vector 1 arg-1)))))
(define CoreC-45Context-u--resolved_HasNames_Totality (lambda (arg-0 arg-1 ext-0) (let ((e-0 (car arg-1))) (let ((e-1 (cdr arg-1))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_Terminating arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_Covering arg-0 e-1 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))))
(define LibrariesC-45DataC-45NameMap-n--5793-11826-u--treeToListC-39 (lambda (arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (cons (cons e-1 e-2) arg-3)))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 3))) (LibrariesC-45DataC-45NameMap-n--5793-11826-u--treeToListC-39 (LibrariesC-45DataC-45NameMap-n--5793-11826-u--treeToListC-39 arg-3 e-7) e-5)))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-14 (vector-ref arg-4 5))) (LibrariesC-45DataC-45NameMap-n--5793-11826-u--treeToListC-39 (LibrariesC-45DataC-45NameMap-n--5793-11826-u--treeToListC-39 (LibrariesC-45DataC-45NameMap-n--5793-11826-u--treeToListC-39 arg-3 e-14) e-12) e-10))))))))
(define LibrariesC-45DataC-45NameMap-treeToList (lambda (ext-0) (LibrariesC-45DataC-45NameMap-n--5793-11826-u--treeToListC-39 '() ext-0)))
(define LibrariesC-45DataC-45NameMap-toList (lambda (arg-1) (if (null? arg-1) '() (let ((e-3 (cdr arg-1))) (LibrariesC-45DataC-45NameMap-treeToList e-3)))))
(define CoreC-45Context-n--15425-10405-u--insertAll (lambda (arg-1 arg-2 arg-3 arg-4) (lambda (clam-0) (if (null? arg-4) (vector 1 arg-3) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car e-2))) (let ((e-7 (cdr e-2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-2 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((CoreC-45Context-n--15425-10405-u--insertAll arg-1 arg-2 (LibrariesC-45DataC-45NameMap-insert e-5 e-7 arg-3) e-3) clam-0)))))))))))))
(define CoreC-45Context-u--full_HasNames_C-40NameMapC-32C-36aC-41 (lambda (arg-1 arg-2) (CoreC-45Context-n--15425-10405-u--insertAll arg-2 arg-1 LibrariesC-45DataC-45NameMap-empty (LibrariesC-45DataC-45NameMap-toList arg-2))))
(define CoreC-45Context-n--15437-10445-u--insertAll (lambda (arg-1 arg-2 arg-3 arg-4) (lambda (clam-0) (if (null? arg-4) (vector 1 arg-3) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car e-2))) (let ((e-7 (cdr e-2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-2 e-6) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((CoreC-45Context-n--15437-10445-u--insertAll arg-1 arg-2 (LibrariesC-45DataC-45NameMap-insert e-5 e-7 arg-3) e-3) clam-0)))))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40NameMapC-32C-36aC-41 (lambda (arg-1 arg-2) (CoreC-45Context-n--15437-10445-u--insertAll arg-2 arg-1 LibrariesC-45DataC-45NameMap-empty (LibrariesC-45DataC-45NameMap-toList arg-2))))
(define csegen-1355 (lambda () (cons (lambda (arg-7776) (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_C-40NameMapC-32C-36aC-41 arg-7776 arg-7779))) (lambda (arg-7786) (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_C-40NameMapC-32C-36aC-41 arg-7786 arg-7789))))))
(define CoreC-45Context-u--resolved_HasNames_GlobalDef (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_Def arg-0 (let ((e-18 (vector-ref arg-1 18))) e-18) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45Context-u--resolved_HasNames_Totality arg-0 (let ((e-10 (vector-ref arg-1 10))) e-10) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45Context-u--resolved_HasNames_C-40MaybeC-32C-36aC-41 (csegen-1355) arg-0 (let ((e-13 (vector-ref arg-1 13))) e-13) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45Context-u--resolved_HasNames_C-40MaybeC-32C-36aC-41 (csegen-1355) arg-0 (let ((e-14 (vector-ref arg-1 14))) e-14) ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (let ((act-6 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_SCCall arg-0 eta-0 eta-1))) (let ((e-21 (vector-ref arg-1 21))) e-21) '()) ext-0))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) (vector 1 (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-28 (vector-ref arg-1 5))) (let ((e-27 (vector-ref arg-1 6))) (let ((e-26 (vector-ref arg-1 7))) (let ((e-25 (vector-ref arg-1 8))) (let ((e-24 (vector-ref arg-1 9))) (let ((e-11 (vector-ref arg-1 11))) (let ((e-12 (vector-ref arg-1 12))) (let ((e-15 (vector-ref arg-1 15))) (let ((e-16 (vector-ref arg-1 16))) (let ((e-17 (vector-ref arg-1 17))) (let ((e-19 (vector-ref arg-1 19))) (let ((e-20 (vector-ref arg-1 20))) (let ((e-22 (vector-ref arg-1 22))) (vector e-0 e-1 e-5 e-3 e-4 e-28 e-27 e-26 e-25 e-24 e-7 e-11 e-12 e-8 e-9 e-15 e-16 e-17 e-6 e-19 e-20 e-10 e-22)))))))))))))))))))))))))))))))))))))))))))))
(define CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (vector 0 e-1 e-2 e-3 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (vector 1 e-6 e-7 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-8)))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (vector 2 e-10 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-11))))) (else (let ((e-13 (vector-ref arg-2 1))) (vector 3 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-13)))))))
(define CoreC-45TTC-45Binder-u--map_Functor_PiInfo (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((1) (vector 1 )) ((0) (vector 0 )) ((2) (vector 2 )) (else (let ((e-4 (vector-ref arg-3 1))) (vector 3 (arg-2 e-4)))))))
(define CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (vector 0 e-1 e-2 (CoreC-45TTC-45Binder-u--map_Functor_PiInfo arg-2 e-3) (arg-2 e-4))))))) ((1) (let ((e-6 (vector-ref arg-3 1))) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (vector 1 e-6 e-7 (arg-2 e-8) (arg-2 e-9))))))) ((2) (let ((e-11 (vector-ref arg-3 1))) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (vector 2 e-11 e-12 (CoreC-45TTC-45Binder-u--map_Functor_PiInfo arg-2 e-13) (arg-2 e-14))))))) ((3) (let ((e-16 (vector-ref arg-3 1))) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (vector 3 e-16 e-17 (CoreC-45TTC-45Binder-u--map_Functor_PiInfo arg-2 e-18) (arg-2 e-19))))))) ((4) (let ((e-21 (vector-ref arg-3 1))) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (vector 4 e-21 e-22 (arg-2 e-23) (arg-2 e-24))))))) (else (let ((e-26 (vector-ref arg-3 1))) (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (vector 5 e-26 e-27 (arg-2 e-28)))))))))
(define DataC-45List-isNil (lambda (arg-1) (if (null? arg-1) 1 0)))
(define CoreC-45TTC-45Term-u--restoreNS_StripNamespace_Name (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((u--nm (vector 0 e-0 e-1))) (let ((sc1 (DataC-45List-isNil e-0))) (cond ((equal? sc1 1) (vector 0 arg-0 e-1)) (else u--nm)))))))(else arg-1))))
(define CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (vector 1 e-1 e-2 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_Name arg-1 e-3)))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (vector 2 e-5 e-6 e-7 (PreludeC-45TypesC-45List-mapAppend '() (lambda (arg-6585) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 arg-6585)) e-8))))))) ((3) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (vector 3 e-10 e-11 (CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (arg-6585) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 arg-6585)) e-12) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-13))))))) ((4) (let ((e-15 (vector-ref arg-2 1))) (let ((e-16 (vector-ref arg-2 2))) (let ((e-17 (vector-ref arg-2 3))) (vector 4 e-15 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-16) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-17)))))) ((5) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((e-22 (vector-ref arg-2 4))) (vector 5 e-19 e-20 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-21) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-22))))))) ((6) (let ((e-24 (vector-ref arg-2 1))) (let ((e-25 (vector-ref arg-2 2))) (let ((e-26 (vector-ref arg-2 3))) (vector 6 e-24 e-25 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-26)))))) ((7) (let ((e-28 (vector-ref arg-2 1))) (let ((e-29 (vector-ref arg-2 2))) (let ((e-30 (vector-ref arg-2 3))) (let ((e-31 (vector-ref arg-2 4))) (vector 7 e-28 e-29 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-30) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-31))))))) ((8) (let ((e-33 (vector-ref arg-2 1))) (let ((e-34 (vector-ref arg-2 2))) (let ((e-35 (vector-ref arg-2 3))) (vector 8 e-33 e-34 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-35))))))(else arg-2))))
(define CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (vector 0 e-1 e-2 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-4) (PreludeC-45TypesC-45List-mapAppend '() (lambda (arg-6585) (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseAltC-32C-36varsC-41 arg-1 arg-6585)) e-5))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (vector 1 e-7 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-8)))))(else arg-2))))
(define CoreC-45Context-n--15162-10199-u--restoreNSpat (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (car arg-6))) (let ((e-3 (cdr arg-6))) (let ((e-6 (car e-3))) (let ((e-7 (cdr e-3))) (let ((e-10 (car e-7))) (let ((e-11 (cdr e-7))) (cons e-2 (cons e-6 (cons (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-5 e-10) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-5 e-11))))))))))))
(define CoreC-45Context-u--restoreNS_StripNamespace_Def (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((e-3 (vector-ref arg-1 4))) (let ((e-4 (vector-ref arg-1 5))) (vector 1 e-0 e-1 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-0 e-2) e-3 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Context-n--15162-10199-u--restoreNSpat e-4 e-1 e-3 e-2 e-0 arg-0 eta-0)) e-4))))))))(else arg-1))))
(define CoreC-45Context-u--restoreNS_StripNamespace_GlobalDef (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-5 (vector-ref arg-1 5))) (let ((e-6 (vector-ref arg-1 6))) (let ((e-7 (vector-ref arg-1 7))) (let ((e-8 (vector-ref arg-1 8))) (let ((e-9 (vector-ref arg-1 9))) (let ((e-10 (vector-ref arg-1 10))) (let ((e-11 (vector-ref arg-1 11))) (let ((e-12 (vector-ref arg-1 12))) (let ((e-13 (vector-ref arg-1 13))) (let ((e-14 (vector-ref arg-1 14))) (let ((e-15 (vector-ref arg-1 15))) (let ((e-16 (vector-ref arg-1 16))) (let ((e-17 (vector-ref arg-1 17))) (let ((e-18 (vector-ref arg-1 18))) (let ((e-19 (vector-ref arg-1 19))) (let ((e-20 (vector-ref arg-1 20))) (let ((e-21 (vector-ref arg-1 21))) (let ((e-22 (vector-ref arg-1 22))) (vector e-0 e-1 e-2 e-3 e-4 e-5 e-6 e-7 e-8 e-9 e-10 e-11 e-12 e-13 e-14 e-15 e-16 e-17 (CoreC-45Context-u--restoreNS_StripNamespace_Def arg-0 e-18) e-19 e-20 e-21 e-22))))))))))))))))))))))))))
(define CoreC-45Context-decode (lambda (ext-4 ext-1 ext-2 ext-3 ext-0) (case (vector-ref ext-3 0) ((0) (let ((e-0 (vector-ref ext-3 1))) (let ((e-1 (vector-ref ext-3 2))) (let ((act-1 ((CoreC-45Core-newRef e-1) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_GlobalDef e-5 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((u--a (CoreC-45Context-getContent ext-4))) (let ((act-3 (let ((act-3 (unbox u--a))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45Context-u--resolved_HasNames_GlobalDef ext-4 (CoreC-45Context-u--restoreNS_StripNamespace_GlobalDef e-0 e-6) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (cond ((equal? ext-2 1) (let ((act-5 ((LibrariesC-45DataC-45IOArray-writeArray (force csegen-85) e-7 ext-1 (vector 1 e-8)) ext-0))) (vector 1 act-5))) (else (vector 1 'erased))))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (vector 1 e-8)))))))))))))))))))))))) (else (let ((e-2 (vector-ref ext-3 1))) (vector 1 e-2))))))
(define LibrariesC-45DataC-45IOArray-readArray (lambda (arg-2 arg-3 arg-4) (let ((sc0 (let ((sc1 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-4 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-4 (LibrariesC-45DataC-45IOArray-max arg-3))))))) (cond ((equal? sc0 1) (let ((e-1 (car arg-2))) (let ((e-5 (vector-ref e-1 0))) (let ((e-7 (vector-ref e-5 1))) ((e-7 'erased) '()))))) (else (let ((e-2 (cdr arg-2))) ((e-2 'erased) (lambda (eta-0) (vector-ref (let ((e-3 (cdr arg-3))) e-3) arg-4)))))))))
(define CoreC-45Context-case--returnDef-6359 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((1) (let ((e-0 (vector-ref arg-2 1))) (let ((sc1 (let ((e-6 (vector-ref e-0 1))) e-6))) (cond ((equal? sc1 1) (box (cons arg-1 arg-0))) (else '())))))(else '()))))
(define CoreC-45Context-returnDef (lambda (arg-0 arg-1 arg-2) (cond ((equal? arg-0 0) (box (cons arg-1 arg-2))) (else (CoreC-45Context-case--returnDef-6359 arg-2 arg-1 (let ((e-18 (vector-ref arg-2 18))) e-18))))))
(define CoreC-45Context-lookupCtxtExactI (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((8) (let ((e-0 (vector-ref arg-0 1))) (lambda (clam-0) (let ((sc1 (LibrariesC-45DataC-45IntMap-lookup e-0 (let ((e-6 (vector-ref arg-1 6))) e-6)))) (if (null? sc1) (let ((act-1 (let ((act-1 (unbox (let ((e-4 (vector-ref arg-1 4))) e-4)))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (let ((act-2 ((LibrariesC-45DataC-45IOArray-readArray (force csegen-85) e-5 e-0) clam-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (if (null? e-6) (vector 1 '()) (let ((e-1 (unbox e-6))) (let ((act-3 (CoreC-45Context-decode arg-1 e-0 1 e-1 clam-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) e-0 e-7)))))))))))))))) (let ((e-1 (unbox sc1))) (let ((act-1 (CoreC-45Context-decode arg-1 e-0 1 e-1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) e-0 e-5))))))))))))(else (let ((sc0 (LibrariesC-45DataC-45NameMap-lookup arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2)))) (if (null? sc0) (lambda (eta-0) (vector 1 '())) (let ((e-1 (unbox sc0))) (CoreC-45Context-lookupCtxtExactI (vector 8 e-1) arg-1))))))))
(define csegen-1337 (lambda (lamc-0) (let ((e-3 (cdr lamc-0))) e-3)))
(define CoreC-45Context-case--lookupCtxtExact-6557 (lambda (arg-0 arg-1 arg-2 ext-0) (if (null? arg-2) (let ((act-1 (let ((act-1 (unbox (let ((e-4 (vector-ref arg-1 4))) e-4)))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (let ((act-2 ((LibrariesC-45DataC-45IOArray-readArray (force csegen-85) e-5 arg-0) ext-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (if (null? e-6) (vector 1 '()) (let ((e-1 (unbox e-6))) (let ((act-3 (CoreC-45Context-decode arg-1 arg-0 1 e-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (PreludeC-45Types-u--map_Functor_Maybe csegen-1337 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) arg-0 e-7))))))))))))))))) (let ((e-1 (unbox arg-2))) (let ((act-1 (CoreC-45Context-decode arg-1 arg-0 1 e-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (PreludeC-45Types-u--map_Functor_Maybe csegen-1337 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) arg-0 e-5)))))))))))
(define CoreC-45Context-lookupCtxtExact (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((8) (let ((e-0 (vector-ref arg-0 1))) (lambda (eta-0) (CoreC-45Context-case--lookupCtxtExact-6557 e-0 arg-1 (LibrariesC-45DataC-45IntMap-lookup e-0 (let ((e-6 (vector-ref arg-1 6))) e-6)) eta-0))))(else (lambda (eta-0) (let ((act-1 ((CoreC-45Context-lookupCtxtExactI arg-0 arg-1) eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (if (null? e-5) (vector 1 '()) (let ((e-1 (unbox e-5))) (let ((e-6 (cdr e-1))) (vector 1 (box e-6))))))))))))))
(define CoreC-45Context-u--full_HasNames_Name (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((8) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Context-lookupCtxtExact (vector 8 e-0) arg-0) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (if (null? e-5) (vector 1 (vector 8 e-0)) (let ((e-1 (unbox e-5))) (vector 1 (let ((e-24 (vector-ref e-1 1))) e-24))))))))))(else (vector 1 arg-1)))))
(define csegen-56(delay (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_Name arg-7786 arg-7789))))))
(define PreludeC-45TypesC-45List-mapMaybeAppend (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45TypesC-45SnocList-C-60C-62C-62 arg-2 '()) (let ((e-1 (car arg-4))) (let ((e-2 (cdr arg-4))) (let ((sc1 (arg-3 e-1))) (if (null? sc1) (PreludeC-45TypesC-45List-mapMaybeAppend arg-2 arg-3 e-2) (let ((e-3 (unbox sc1))) (PreludeC-45TypesC-45List-mapMaybeAppend (cons arg-2 e-3) arg-3 e-2)))))))))
(define DataC-45List-catMaybes (lambda (ext-0) (PreludeC-45TypesC-45List-mapMaybeAppend '() (lambda (eta-0) eta-0) ext-0)))
(define csegen-57 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (DataC-45List-catMaybes e-5)))))))
(define csegen-59(delay (cons (lambda (arg-8505) (lambda (arg-8508) (PreludeC-45TypesC-45List-tailRecAppend arg-8505 arg-8508))) '())))
(define CompilerC-45ANF-nextVar (lambda (arg-0 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (let ((act-2 (set-box! arg-0 (bs+ e-5 1 63)))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (vector 1 e-5))))))))))
(define CompilerC-45ANF-bindArgs (lambda (arg-0 arg-1) (lambda (clam-0) (if (null? arg-1) (vector 1 '()) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (case (vector-ref e-2 0) ((0) (let ((e-5 (vector-ref e-2 2))) (let ((act-1 ((CompilerC-45ANF-bindArgs arg-0 e-3) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-6 (vector-ref act-1 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-1 1))) (vector 1 (cons (cons e-5 '()) e-6)))))))) ((11) (let ((act-1 ((CompilerC-45ANF-bindArgs arg-0 e-3) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (cons (cons '() '()) e-5)))))))(else (let ((act-1 (CompilerC-45ANF-nextVar arg-0 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CompilerC-45ANF-bindArgs arg-0 e-3) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons (cons (box e-5) (box e-2)) e-6))))))))))))))))))
(define CompilerC-45ANF-n--10773-2494-u--doBind (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (if (null? arg-5) (arg-0 (PreludeC-45TypesC-45List-reverse arg-4)) (let ((e-2 (car arg-5))) (let ((e-3 (cdr arg-5))) (let ((e-6 (car e-2))) (let ((e-7 (cdr e-2))) (if (null? e-6) (CompilerC-45ANF-n--10773-2494-u--doBind arg-0 arg-1 arg-2 arg-3 (cons e-6 arg-4) e-3) (let ((e-8 (unbox e-6))) (if (null? e-7) (CompilerC-45ANF-n--10773-2494-u--doBind arg-0 arg-1 arg-2 arg-3 (cons e-6 arg-4) e-3) (let ((e-10 (unbox e-7))) (vector 4 arg-2 e-8 e-10 (CompilerC-45ANF-n--10773-2494-u--doBind arg-0 arg-1 arg-2 arg-3 (cons (box e-8) arg-4) e-3)))))))))))))
(define CompilerC-45ANF-letBind (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (let ((act-1 ((CompilerC-45ANF-bindArgs arg-0 arg-2) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (CompilerC-45ANF-n--10773-2494-u--doBind arg-3 arg-2 arg-1 arg-0 '() e-5))))))))
(define CompilerC-45ANF-anfArgs (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CompilerC-45ANF-anf arg-1 arg-3 eta-0)) arg-4 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (CompilerC-45ANF-letBind arg-1 arg-2 e-5 arg-5 ext-0)))))))
(define CompilerC-45ANF-n--10922-2978-u--bindArgs (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7 arg-9 arg-10 ext-0) (if (null? arg-9) (vector 1 (cons '() arg-10)) (let ((e-3 (cdr arg-9))) (let ((act-1 (CompilerC-45ANF-nextVar arg-7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CompilerC-45ANF-n--10922-2978-u--bindArgs arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7 e-3 arg-10 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) (let ((e-7 (car e-6))) (let ((e-4 (cdr e-6))) (vector 1 (cons (cons e-5 e-7) (cons e-5 e-4)))))))))))))))))
(define CompilerC-45ANF-anfConAlt (lambda (arg-1 arg-2 arg-3 ext-0) (let ((e-1 (vector-ref arg-3 0))) (let ((e-2 (vector-ref arg-3 1))) (let ((e-3 (vector-ref arg-3 2))) (let ((e-4 (vector-ref arg-3 3))) (let ((e-5 (vector-ref arg-3 4))) (let ((act-1 (CompilerC-45ANF-n--10922-2978-u--bindArgs e-4 e-5 e-3 e-2 e-1 arg-2 arg-1 e-4 arg-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-6 (vector-ref act-1 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-1 1))) (let ((e-8 (car e-6))) (let ((e-7 (cdr e-6))) (let ((act-2 ((CompilerC-45ANF-anf arg-1 e-7 e-5) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-9 (vector-ref act-2 1))) (vector 0 e-9))) (else (let ((e-9 (vector-ref act-2 1))) (vector 1 (vector e-1 e-2 e-3 e-8 e-9)))))))))))))))))))
(define CompilerC-45ANF-anfConstAlt (lambda (arg-1 arg-2 arg-3 ext-0) (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (let ((act-1 ((CompilerC-45ANF-anf arg-1 arg-2 e-2) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (cons e-1 e-5))))))))))
(define CompilerC-45ANF-lookup (lambda (arg-2 arg-4) (cond ((equal? arg-2 0) (let ((e-5 (car arg-4))) e-5))(else (let ((e-0 (- arg-2 1))) (let ((e-12 (cdr arg-4))) (CompilerC-45ANF-lookup e-0 e-12)))))))
(define CompilerC-45ANF-mlet (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 2))) (vector 1 (arg-3 e-1))))(else (let ((act-1 (CompilerC-45ANF-nextVar arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 4 arg-1 e-5 arg-2 (arg-3 (box e-5))))))))))))
(define PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (lambda (arg-2 arg-3) (if (null? arg-2) '() (let ((e-2 (unbox arg-2))) (arg-3 e-2)))))
(define DataC-45Vect-toVect (lambda (arg-1 arg-2) (cond ((equal? arg-1 0) (if (null? arg-2) (box '()) '()))(else (let ((e-0 (- arg-1 1))) (if (null? arg-2) '() (let ((e-3 (car arg-2))) (let ((e-4 (cdr arg-2))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (DataC-45Vect-toVect e-0 e-4) (lambda (u--xsC-39) (box (cons e-3 u--xsC-39))))))))))))
(define DataC-45Vect-foldrImpl (lambda (arg-3 arg-4 arg-5 arg-6) (if (null? arg-6) (arg-5 arg-4) (let ((e-3 (car arg-6))) (let ((e-4 (cdr arg-6))) (DataC-45Vect-foldrImpl arg-3 arg-4 (lambda (eta-0) (arg-5 ((arg-3 e-3) eta-0))) e-4))))))
(define DataC-45Vect-u--foldr_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4 arg-5) (DataC-45Vect-foldrImpl arg-3 arg-4 (lambda (eta-0) eta-0) arg-5)))
(define csegen-108(delay (lambda (eta-0) (lambda (eta-1) (cons eta-0 eta-1)))))
(define DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 (lambda (ext-0) (DataC-45Vect-u--foldr_Foldable_C-40VectC-32C-36nC-41 (force csegen-108) '() ext-0)))
(define CompilerC-45ANF-anf (lambda (arg-1 arg-2 arg-3) (lambda (clam-0) (case (vector-ref arg-3 0) ((0) (let ((e-2 (vector-ref arg-3 1))) (let ((e-3 (vector-ref arg-3 2))) (vector 1 (vector 0 e-3 (box (CompilerC-45ANF-lookup e-2 arg-2))))))) ((1) (let ((e-6 (vector-ref arg-3 1))) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (CompilerC-45ANF-anfArgs arg-1 e-6 arg-2 e-9 (lambda (eta-0) (vector 1 e-6 e-7 e-8 eta-0)) clam-0)))))) ((2) (let ((e-11 (vector-ref arg-3 1))) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (CompilerC-45ANF-anfArgs arg-1 e-11 arg-2 e-14 (lambda (eta-0) (vector 2 e-11 e-12 e-13 eta-0)) clam-0)))))) ((3) (let ((e-16 (vector-ref arg-3 1))) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (CompilerC-45ANF-anfArgs arg-1 e-16 arg-2 (cons e-18 (cons e-19 '())) (lambda (lcase-0) (if (null? lcase-0) (vector 12 e-16 "Can't happen (AApp)") (let ((e-1 (car lcase-0))) (let ((e-2 (cdr lcase-0))) (if (null? e-2) (vector 12 e-16 "Can't happen (AApp)") (let ((e-4 (car e-2))) (let ((e-5 (cdr e-2))) (if (null? e-5) (vector 3 e-16 e-17 e-1 e-4) (vector 12 e-16 "Can't happen (AApp)"))))))))) clam-0)))))) ((4) (let ((e-21 (vector-ref arg-3 1))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (let ((act-1 (CompilerC-45ANF-nextVar arg-1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((u--vsC-39 (cons e-5 arg-2))) (let ((act-2 ((CompilerC-45ANF-anf arg-1 arg-2 e-23) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 ((CompilerC-45ANF-anf arg-1 u--vsC-39 e-24) clam-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 4 e-21 e-5 e-6 e-7))))))))))))))))))) ((5) (let ((e-26 (vector-ref arg-3 1))) (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (let ((e-29 (vector-ref arg-3 4))) (let ((e-30 (vector-ref arg-3 5))) (CompilerC-45ANF-anfArgs arg-1 e-26 arg-2 e-30 (lambda (eta-0) (vector 5 e-26 e-27 e-28 e-29 eta-0)) clam-0))))))) ((6) (let ((e-32 (vector-ref arg-3 1))) (let ((e-33 (vector-ref arg-3 2))) (let ((e-34 (vector-ref arg-3 3))) (let ((e-35 (vector-ref arg-3 4))) (let ((e-36 (vector-ref arg-3 5))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CompilerC-45ANF-anf arg-1 arg-2 eta-0)) (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 e-36) '()) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (CompilerC-45ANF-letBind arg-1 e-33 e-5 (lambda (u--args) (let ((sc2 (DataC-45Vect-toVect e-32 u--args))) (if (null? sc2) (vector 12 e-33 "Can't happen (AOp)") (let ((e-2 (unbox sc2))) (vector 6 e-33 e-34 e-35 e-2))))) clam-0))))))))))) ((7) (let ((e-38 (vector-ref arg-3 1))) (let ((e-39 (vector-ref arg-3 2))) (let ((e-40 (vector-ref arg-3 3))) (let ((e-41 (vector-ref arg-3 4))) (CompilerC-45ANF-anfArgs arg-1 e-38 arg-2 e-41 (lambda (eta-0) (vector 7 e-38 e-39 e-40 eta-0)) clam-0)))))) ((8) (let ((e-43 (vector-ref arg-3 1))) (let ((e-44 (vector-ref arg-3 2))) (let ((e-45 (vector-ref arg-3 3))) (let ((e-46 (vector-ref arg-3 4))) (let ((act-1 ((CompilerC-45ANF-anf arg-1 arg-2 e-44) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CompilerC-45ANF-anfConAlt arg-1 arg-2 eta-0 eta-1))) e-45 '()) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (if (null? e-46) (vector 1 '()) (let ((e-2 (unbox e-46))) ((let ((eff-0 (CompilerC-45ANF-anf arg-1 arg-2 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))) clam-0))))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (CompilerC-45ANF-mlet arg-1 e-43 e-5 (lambda (u--x) (vector 8 e-43 u--x e-6 e-7)) clam-0)))))))))))))))))) ((9) (let ((e-48 (vector-ref arg-3 1))) (let ((e-49 (vector-ref arg-3 2))) (let ((e-50 (vector-ref arg-3 3))) (let ((e-51 (vector-ref arg-3 4))) (let ((act-1 ((CompilerC-45ANF-anf arg-1 arg-2 e-49) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CompilerC-45ANF-anfConstAlt arg-1 arg-2 eta-0 eta-1))) e-50 '()) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (if (null? e-51) (vector 1 '()) (let ((e-2 (unbox e-51))) ((let ((eff-0 (CompilerC-45ANF-anf arg-1 arg-2 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))) clam-0))))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (CompilerC-45ANF-mlet arg-1 e-48 e-5 (lambda (u--x) (vector 9 e-48 u--x e-6 e-7)) clam-0)))))))))))))))))) ((10) (let ((e-53 (vector-ref arg-3 1))) (let ((e-54 (vector-ref arg-3 2))) (vector 1 (vector 10 e-53 e-54))))) ((11) (let ((e-56 (vector-ref arg-3 1))) (vector 1 (vector 11 e-56)))) (else (let ((e-58 (vector-ref arg-3 1))) (let ((e-59 (vector-ref arg-3 2))) (vector 1 (vector 12 e-58 e-59)))))))))
(define CompilerC-45ANF-n--11498-3129-u--bindArgs (lambda (arg-0 arg-1 arg-2 arg-4 arg-5 arg-6 ext-0) (if (null? arg-5) (vector 1 (cons '() arg-6)) (let ((e-3 (cdr arg-5))) (let ((act-1 (CompilerC-45ANF-nextVar arg-4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CompilerC-45ANF-n--11498-3129-u--bindArgs arg-0 arg-1 arg-2 arg-4 e-3 arg-6 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) (let ((e-7 (car e-6))) (let ((e-4 (cdr e-6))) (vector 1 (cons (cons e-5 e-7) (cons e-5 e-4)))))))))))))))))
(define CompilerC-45ANF-toANF (lambda (arg-0 ext-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (let ((act-1 ((CoreC-45Core-newRef 0) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CompilerC-45ANF-n--11498-3129-u--bindArgs e-1 e-0 e-2 e-5 e-0 '() ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-2 1))) (let ((e-4 (car e-6))) (let ((e-3 (cdr e-6))) (let ((act-3 (CompilerC-45ANF-n--11498-3129-u--bindArgs e-1 e-0 e-2 e-5 e-1 e-3 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) (let ((e-9 (car e-7))) (let ((e-8 (cdr e-7))) (let ((act-4 ((CompilerC-45ANF-anf e-5 e-8 e-2) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-10 (vector-ref act-4 1))) (vector 0 e-10))) (else (let ((e-10 (vector-ref act-4 1))) (vector 1 (vector 0 (PreludeC-45TypesC-45List-tailRecAppend e-4 (PreludeC-45TypesC-45List-reverse e-9)) e-10)))))))))))))))))))))))))) ((1) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (vector 1 (vector 1 e-3 e-4 e-5)))))) ((2) (let ((e-6 (vector-ref arg-0 1))) (let ((e-7 (vector-ref arg-0 2))) (let ((e-8 (vector-ref arg-0 3))) (vector 1 (vector 2 e-6 e-7 e-8)))))) (else (let ((e-9 (vector-ref arg-0 1))) (let ((act-1 ((CoreC-45Core-newRef 0) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CompilerC-45ANF-anf e-5 '() e-9) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-6)))))))))))))))
(define csegen-60 (lambda (lamc-0) (lambda (clam-0) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (let ((act-1 (CompilerC-45ANF-toANF e-3 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (cons e-2 e-5)))))))))))
(define csegen-62(delay (cons (lambda (arg-8505) (lambda (arg-8508) (string-append arg-8505 arg-8508))) "")))
(define csegen-66 (lambda (eta-0) (lambda (eta-1) (CoreC-45CoreC-45List-traverse_ eta-0 eta-1))))
(define PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AnyBool (lambda (arg-0 arg-1) (cond ((equal? arg-0 1) 1) (else arg-1))))
(define csegen-112 (cons (lambda (arg-8505) (lambda (arg-8508) (PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AnyBool arg-8505 arg-8508))) 0))
(define PreludeC-45Types-elemBy (lambda (arg-2 arg-3 arg-4) (let ((e-6 (vector-ref arg-2 5))) ((((e-6 'erased) 'erased) csegen-112) (arg-3 arg-4)))))
(define PreludeC-45Types-elem (lambda (arg-2 arg-3 ext-0) (PreludeC-45Types-elemBy arg-2 (let ((e-1 (car arg-3))) e-1) ext-0)))
(define CoreC-45Name-isOpChar (lambda (arg-0) ((PreludeC-45Types-elem (force csegen-14) csegen-17 arg-0) (PreludeC-45Types-fastUnpack ":!#$%&*+./<=>?@\\^|-~"))))
(define PreludeC-45TypesC-45String-length (lambda (arg-0) (PreludeC-45Types-prim__integerToNat (string-length arg-0))))
(define PreludeC-45Types-substr (lambda (arg-0 arg-1 arg-2) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-0 (PreludeC-45TypesC-45String-length arg-2)))) (cond ((equal? sc0 1) (string-substr (blodwen-toSignedInt arg-0 63) (blodwen-toSignedInt arg-1 63) arg-2)) (else "")))))
(define LibrariesC-45DataC-45StringC-45Extra-drop (lambda (arg-0 arg-1) (PreludeC-45Types-substr arg-0 (PreludeC-45TypesC-45String-length arg-1) arg-1)))
(define LibrariesC-45DataC-45StringC-45Extra-join (lambda (arg-1 arg-2 arg-3) (LibrariesC-45DataC-45StringC-45Extra-drop (PreludeC-45TypesC-45String-length arg-1) (let ((e-2 (vector-ref arg-2 1))) (((((e-2 'erased) 'erased) (lambda (u--acc) (lambda (u--x) (string-append u--acc (string-append arg-1 u--x))))) "") arg-3)))))
(define CoreC-45NameC-45Namespace-showSep (lambda (arg-0 ext-0) (LibrariesC-45DataC-45StringC-45Extra-join arg-0 (force csegen-14) ext-0)))
(define CoreC-45NameC-45Namespace-showNSWithSep (lambda (arg-0 arg-1) (CoreC-45NameC-45Namespace-showSep arg-0 (PreludeC-45TypesC-45List-reverse arg-1))))
(define CoreC-45NameC-45Namespace-u--show_Show_Namespace (lambda (ext-0) (CoreC-45NameC-45Namespace-showNSWithSep "." ext-0)))
(define CoreC-45Name-u--show_Show_UserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) e-0)) ((1) (let ((e-1 (vector-ref arg-0 1))) (string-append "." e-1))) (else "_"))))
(define CoreC-45Name-u--show_Show_Name (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref e-1 0) ((1) (let ((e-16 (vector-ref e-1 1))) (case (vector-ref e-16 0) ((1) (string-append (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (string-append ".(" (string-append (CoreC-45Name-u--show_Show_Name e-1) ")")))) ((0) (let ((e-18 (vector-ref e-16 1))) (let ((sc3 (PreludeC-45Types-u--foldMap_Foldable_List csegen-112 (lambda (eta-0) (CoreC-45Name-isOpChar eta-0)) (PreludeC-45Types-fastUnpack e-18)))) (cond ((equal? sc3 1) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons ".(" (cons e-18 (cons ")" '())))))) (else (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons "." (cons e-18 '())))))))))(else (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons "." (cons (CoreC-45Name-u--show_Show_Name e-1) '()))))))))(else (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons "." (cons (CoreC-45Name-u--show_Show_Name e-1) '()))))))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (CoreC-45Name-u--show_Show_UserName e-2))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (string-append "{" (string-append e-3 (string-append ":" (string-append (PreludeC-45Show-u--show_Show_Int e-4) "}"))))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (string-append "{P:" (string-append (CoreC-45Name-u--show_Show_Name e-5) (string-append ":" (string-append (PreludeC-45Show-u--show_Show_Int e-6) "}"))))))) ((4) (let ((e-7 (vector-ref arg-0 1))) e-7)) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (let ((e-21 (car e-9))) (let ((e-22 (cdr e-9))) (string-append (PreludeC-45Show-u--show_Show_Int e-21) (string-append ":" (string-append (PreludeC-45Show-u--show_Show_Int e-22) (string-append ":" (CoreC-45Name-u--show_Show_Name e-10)))))))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (string-append "case block in " e-11))) ((7) (let ((e-13 (vector-ref arg-0 1))) (string-append "with block in " e-13))) (else (let ((e-15 (vector-ref arg-0 1))) (string-append "$resolved" (PreludeC-45Show-u--show_Show_Int e-15)))))))
(define CoreC-45Name-u--showPrec_Show_Name (lambda (arg-0 arg-1) (CoreC-45Name-u--show_Show_Name arg-1)))
(define csegen-68(delay (cons (lambda (u--x) (CoreC-45Name-u--show_Show_Name u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Name-u--showPrec_Show_Name u--d u--x))))))
(define CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (lambda (clam-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (case (vector-ref e-3 0) ((8) (let ((e-42 (vector-ref e-3 1))) (let ((act-1 ((CoreC-45Context-lookupCtxtExact (vector 8 e-42) arg-1) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (if (null? e-5) (vector 1 (vector 1 e-1 e-2 (vector 8 e-42))) (let ((e-4 (unbox e-5))) (vector 1 (vector 1 e-1 e-2 (let ((e-27 (vector-ref e-4 1))) e-27)))))))))))(else (vector 1 arg-2))))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-7779)) e-8 '()) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-lookupCtxtExact (vector 8 e-7) arg-1) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-2 1))) (vector 1 (if (null? e-10) (vector 2 e-5 e-6 e-7 e-9) (let ((e-2 (unbox e-10))) (vector 2 e-5 (let ((e-1 (vector-ref e-2 1))) e-1) e-7 e-9))))))))))))))))) ((3) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-7779)) e-12) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-13) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 3 e-10 e-11 e-5 e-6))))))))))))))) ((4) (let ((e-15 (vector-ref arg-2 1))) (let ((e-16 (vector-ref arg-2 2))) (let ((e-17 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-16) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-17) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-15 e-5 e-6)))))))))))))) ((5) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((e-22 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-21) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-22) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 5 e-19 e-20 e-5 e-6))))))))))))))) ((6) (let ((e-24 (vector-ref arg-2 1))) (let ((e-25 (vector-ref arg-2 2))) (let ((e-26 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-26) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 6 e-24 e-25 e-5)))))))))) ((7) (let ((e-28 (vector-ref arg-2 1))) (let ((e-29 (vector-ref arg-2 2))) (let ((e-30 (vector-ref arg-2 3))) (let ((e-31 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-30) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-31) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 7 e-28 e-29 e-5 e-6))))))))))))))) ((8) (let ((e-33 (vector-ref arg-2 1))) (let ((e-34 (vector-ref arg-2 2))) (let ((e-35 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-35) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 8 e-33 e-34 e-5)))))))))) ((11) (let ((e-37 (vector-ref arg-2 1))) (let ((e-38 (vector-ref arg-2 2))) (case (vector-ref e-38 0) ((8) (let ((e-43 (vector-ref e-38 1))) (let ((act-1 ((CoreC-45Context-lookupCtxtExact (vector 8 e-43) arg-1) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (if (null? e-5) (vector 1 (vector 11 e-37 (vector 8 e-43))) (let ((e-1 (unbox e-5))) (vector 1 (vector 11 e-37 (let ((e-24 (vector-ref e-1 1))) e-24)))))))))))(else (vector 1 arg-2)))))) ((10) (let ((e-40 (vector-ref arg-2 1))) (let ((e-41 (vector-ref arg-2 2))) (case (vector-ref e-41 0) ((2) (let ((e-45 (vector-ref e-41 1))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-45) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 10 e-40 (vector 2 e-5)))))))))(else (vector 1 arg-2))))))(else (vector 1 arg-2))))))
(define csegen-71(delay (cons (lambda (arg-7776) (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-7776 arg-7779))) (lambda (arg-7786) (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-7786 arg-7789))))))
(define csegen-87(delay (cons (force csegen-68) (force csegen-68))))
(define csegen-88(delay (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-87) u--x))))
(define SystemC-45Info-os (blodwen-os))
(define csegen-101(delay ((PreludeC-45Types-elem (force csegen-14) (force csegen-23) SystemC-45Info-os) (cons "windows" (cons "mingw32" (cons "cygwin32" '()))))))
(define csegen-110 (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (eta-0 (eta-1 eta-2))))))
(define csegen-113 (lambda (arg-5927) (lambda (arg-5930) (+ arg-5927 arg-5930))))
(define csegen-114 (lambda (arg-5937) (lambda (arg-5940) (* arg-5937 arg-5940))))
(define csegen-115 (vector csegen-113 csegen-114 (lambda (arg-5947) (PreludeC-45Types-prim__integerToNat arg-5947))))
(define csegen-156(delay (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8920) (case (vector-ref arg-8920 0) ((0) (let ((e-2 (vector-ref arg-8920 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref arg-8920 1))) (vector 1 (u--func e-5)))))))))))
(define csegen-160(delay (vector (force csegen-156) (lambda (u--a) (lambda (arg-9959) (vector 1 arg-9959))) (lambda (u--b) (lambda (u--a) (force csegen-157))))))
(define PreludeC-45Types-u--C-62C-62C-61_Monad_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-2 (vector-ref arg-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref arg-3 1))) (arg-4 e-5))))))
(define PreludeC-45Types-u--join_Monad_C-40EitherC-32C-36eC-41 (lambda (arg-2) (PreludeC-45Types-u--C-62C-62C-61_Monad_C-40EitherC-32C-36eC-41 arg-2 (lambda (eta-0) eta-0))))
(define csegen-165 (vector (force csegen-160) (lambda (u--b) (lambda (u--a) (lambda (arg-10444) (lambda (arg-10447) (PreludeC-45Types-u--C-62C-62C-61_Monad_C-40EitherC-32C-36eC-41 arg-10444 arg-10447))))) (lambda (u--a) (lambda (arg-10458) (PreludeC-45Types-u--join_Monad_C-40EitherC-32C-36eC-41 arg-10458)))))
(define PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) arg-4) (else (let ((e-5 (vector-ref arg-5 1))) ((arg-3 e-5) arg-4))))))
(define PreludeC-45Types-u--foldMap_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4 ext-0) (PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 (lambda (eta-0) (let ((e-1 (car arg-3))) (e-1 (arg-4 eta-0)))) (let ((e-2 (cdr arg-3))) e-2) ext-0)))
(define PreludeC-45Types-u--foldl_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4 arg-5) ((PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip csegen-110 (lambda (eta-2) (PreludeC-45Basics-flip arg-3 eta-0 eta-2)) eta-1))) (lambda (eta-0) eta-0) arg-5) arg-4)))
(define PreludeC-45Types-u--foldlM_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-4 arg-5 arg-6 ext-0) (PreludeC-45Types-u--foldl_Foldable_C-40EitherC-32C-36eC-41 (lambda (u--ma) (lambda (u--b) (let ((e-2 (vector-ref arg-4 1))) ((((e-2 'erased) 'erased) u--ma) (lambda (eta-0) (PreludeC-45Basics-flip arg-5 u--b eta-0)))))) (let ((e-1 (vector-ref arg-4 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) arg-6))) ext-0)))
(define PreludeC-45Types-u--null_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-2) (case (vector-ref arg-2 0) ((0) 1) (else 0))))
(define PreludeC-45Types-u--toList_Foldable_C-40EitherC-32C-36eC-41 (lambda (ext-0) (PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 (force csegen-108) '() ext-0)))
(define PreludeC-45Types-u--traverse_Traversable_C-40EitherC-32C-36eC-41 (lambda (arg-4 arg-5 arg-6) (case (vector-ref arg-6 0) ((0) (let ((e-2 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-4 1))) ((e-4 'erased) (vector 0 e-2))))) (else (let ((e-5 (vector-ref arg-6 1))) (let ((e-1 (vector-ref arg-4 0))) ((((e-1 'erased) 'erased) (lambda (eta-0) (vector 1 eta-0))) (arg-5 e-5))))))))
(define csegen-186 (vector (force csegen-156) (vector (lambda (u--acc) (lambda (u--elem) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (u--acc) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldl_Foldable_C-40EitherC-32C-36eC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (arg-10947) (PreludeC-45Types-u--null_Foldable_C-40EitherC-32C-36eC-41 arg-10947))) (lambda (u--elem) (lambda (u--acc) (lambda (u--m) (lambda (i_con-0) (lambda (u--funcM) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldlM_Foldable_C-40EitherC-32C-36eC-41 i_con-0 u--funcM u--init u--input)))))))) (lambda (u--elem) (lambda (arg-10976) (PreludeC-45Types-u--toList_Foldable_C-40EitherC-32C-36eC-41 arg-10976))) (lambda (u--a) (lambda (u--m) (lambda (i_con-0) (lambda (u--f) (lambda (arg-10990) (PreludeC-45Types-u--foldMap_Foldable_C-40EitherC-32C-36eC-41 i_con-0 u--f arg-10990))))))) (lambda (u--b) (lambda (u--a) (lambda (u--f) (lambda (i_con-0) (lambda (arg-14099) (lambda (arg-14106) (PreludeC-45Types-u--traverse_Traversable_C-40EitherC-32C-36eC-41 i_con-0 arg-14099 arg-14106)))))))))
(define csegen-196 (lambda (__leftTupleSection-0) (lambda (__infixTupleSection-0) (cons __leftTupleSection-0 __infixTupleSection-0))))
(define csegen-199(delay (lambda (arg-5927) (lambda (arg-5930) (bs+ arg-5927 arg-5930 63)))))
(define csegen-201(delay (vector (force csegen-199) (lambda (arg-5937) (lambda (arg-5940) (bs* arg-5937 arg-5940 63))) (lambda (arg-5947) (blodwen-toSignedInt arg-5947 63)))))
(define PreludeC-45Num-u--div_Integral_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-1 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 0) (bs/ arg-0 arg-1 63))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in div at Prelude.Num:128:3--130:40")))))))
(define PreludeC-45Num-u--mod_Integral_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-1 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 0) (blodwen-euclidMod arg-0 arg-1))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in mod at Prelude.Num:131:3--133:40")))))))
(define csegen-248(delay (cons (vector (force csegen-201) (lambda (arg-6342) (lambda (arg-6345) (PreludeC-45Num-u--div_Integral_Int arg-6342 arg-6345))) (lambda (arg-6352) (lambda (arg-6355) (PreludeC-45Num-u--mod_Integral_Int arg-6352 arg-6355)))) (cons (force csegen-244) (vector (force csegen-201) (lambda (arg-6042) (bs- 0 arg-6042 63)) (lambda (arg-6048) (lambda (arg-6051) (bs- arg-6048 arg-6051 63))))))))
(define csegen-249 (lambda (eta-0) (CoreC-45Name-u--show_Show_Name (let ((e-3 (cdr eta-0))) e-3))))
(define csegen-250 (vector (vector 2 ) 1 0 3 10))
(define PreludeC-45Types-u--C-60C-42C-62_Applicative_Maybe (lambda (arg-2 arg-3) (if (null? arg-2) '() (let ((e-1 (unbox arg-2))) (if (null? arg-3) '() (let ((e-3 (unbox arg-3))) (box (e-1 e-3))))))))
(define csegen-267(delay (vector (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8920) (PreludeC-45Types-u--map_Functor_Maybe u--func arg-8920))))) (lambda (u--a) (lambda (arg-9959) (box arg-9959))) (lambda (u--b) (lambda (u--a) (lambda (arg-9965) (lambda (arg-9972) (PreludeC-45Types-u--C-60C-42C-62_Applicative_Maybe arg-9965 arg-9972))))))))
(define PreludeC-45Types-u--C-60C-124C-62_Alternative_Maybe (lambda (arg-1 arg-2) (if (null? arg-1) (arg-2) (let ((e-1 (unbox arg-1))) (box e-1)))))
(define csegen-270(delay (vector (force csegen-267) (lambda (u--a) '()) (lambda (u--a) (lambda (arg-10343) (lambda (arg-10346) (PreludeC-45Types-u--C-60C-124C-62_Alternative_Maybe arg-10343 arg-10346)))))))
(define csegen-271 (lambda (eta-0) (let ((e-2 (vector-ref eta-0 2))) e-2)))
(define IdrisC-45Syntax-u--full_HasNames_IFaceInfo (lambda (arg-0 arg-1 ext-0) (vector 1 arg-1)))
(define IdrisC-45Syntax-u--resolved_HasNames_IFaceInfo (lambda (arg-0 arg-1 ext-0) (vector 1 arg-1)))
(define csegen-274 (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (IdrisC-45Syntax-u--full_HasNames_IFaceInfo arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (IdrisC-45Syntax-u--resolved_HasNames_IFaceInfo arg-7786 arg-7789 eta-0))))))
(define csegen-275(delay (lambda (arg-712) (lambda (arg-715) (let ((sc0 (or (and (char=? arg-712 arg-715) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))))
(define LibrariesC-45DataC-45StringC-45Extra-dropLast (lambda (arg-0 arg-1) (string-reverse (LibrariesC-45DataC-45StringC-45Extra-drop arg-0 (string-reverse arg-1)))))
(define DataC-45List-isPrefixOfBy (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) 1 (if (null? arg-4) 0 (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (let ((e-4 (car arg-4))) (let ((e-5 (cdr arg-4))) (let ((sc4 ((arg-2 e-1) e-4))) (cond ((equal? sc4 1) (DataC-45List-isPrefixOfBy arg-2 e-2 e-5)) (else 0)))))))))))
(define DataC-45String-strM (lambda (arg-0) (cond ((equal? arg-0 "") '())(else (cons (string-ref arg-0 0) (substring arg-0 1 (string-length arg-0)))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-case--unsafeTextWithoutNewLines-10917 (lambda (arg-1 arg-2) (cond ((equal? arg-1 "") (if (null? arg-2) (vector 0 ) (let ((e-0 (car arg-2))) (let ((e-1 (cdr arg-2))) (let ((u--str (string-cons e-0 e-1))) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 ""))) (cond ((equal? sc3 1) (vector 1 e-0)) (else (vector 2 (blodwen-toSignedInt (PreludeC-45TypesC-45String-length u--str) 63) u--str)))))))))(else (let ((e-0 (car arg-2))) (let ((e-1 (cdr arg-2))) (let ((u--str (string-cons e-0 e-1))) (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 ""))) (cond ((equal? sc1 1) (vector 1 e-0)) (else (vector 2 (blodwen-toSignedInt (PreludeC-45TypesC-45String-length u--str) 63) u--str)))))))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines (lambda (arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-case--unsafeTextWithoutNewLines-10917 arg-1 (DataC-45String-strM arg-1))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--neutral_Monoid_C-40DocC-32C-36annC-41 (vector 0 ))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith (lambda (arg-1 arg-2) (if (null? arg-2) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--neutral_Monoid_C-40DocC-32C-36annC-41 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (PreludeC-45Types-u--foldl_Foldable_List arg-1 e-2 e-3))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-line (vector 4 (lambda () (vector 3 )) (lambda () (vector 1 #\ ))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (lambda (ext-0 ext-1) (vector 5 ext-0 ext-1)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith (lambda (u--x) (lambda (u--y) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 u--x LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-line) u--y))) ext-0)))
(define PreludeC-45Types-n--10177-9486-u--go (lambda (arg-0 arg-1 arg-2) (cond ((equal? arg-2 0) arg-1)(else (let ((e-0 (- arg-2 1))) (let ((u--ix (blodwen-toSignedInt e-0 63))) (PreludeC-45Types-n--10177-9486-u--go arg-0 (cons (string-ref arg-0 u--ix) arg-1) e-0)))))))
(define DataC-45String-n--3989-9562-u--linesHelp (lambda (arg-0 arg-1 arg-2) (if (null? arg-1) (if (null? arg-2) '() (if (null? arg-2) (cons (PreludeC-45TypesC-45List-reverse arg-1) '()) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cond ((equal? e-2 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-3))) ((equal? e-2 (integer->char 13)) (if (null? e-3) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-3)) (let ((e-5 (car e-3))) (let ((e-6 (cdr e-3))) (cond ((equal? e-5 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-6)))(else (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-3))))))))(else (DataC-45String-n--3989-9562-u--linesHelp arg-0 (cons e-2 arg-1) e-3))))))) (if (null? arg-2) (cons (PreludeC-45TypesC-45List-reverse arg-1) '()) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cond ((equal? e-2 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-3))) ((equal? e-2 (integer->char 13)) (if (null? e-3) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-3)) (let ((e-5 (car e-3))) (let ((e-6 (cdr e-3))) (cond ((equal? e-5 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-6)))(else (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() e-3))))))))(else (DataC-45String-n--3989-9562-u--linesHelp arg-0 (cons e-2 arg-1) e-3)))))))))
(define csegen-279(delay (cons (lambda (arg-11249) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines eta-0)) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45String-n--3989-9562-u--linesHelp (PreludeC-45Types-n--10177-9486-u--go (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11249 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11249))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11249)) (else arg-11249))) '() (PreludeC-45Types-prim__integerToNat (string-length (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11249 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11249))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11249)) (else arg-11249)))))) '() (PreludeC-45Types-n--10177-9486-u--go (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11249 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11249))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11249)) (else arg-11249))) '() (PreludeC-45Types-prim__integerToNat (string-length (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11249 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11249))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11249)) (else arg-11249))))))))))) (lambda (arg-11255) (lambda (arg-11258) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines eta-0)) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45String-n--3989-9562-u--linesHelp (PreludeC-45Types-n--10177-9486-u--go (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11258 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11258))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11258)) (else arg-11258))) '() (PreludeC-45Types-prim__integerToNat (string-length (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11258 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11258))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11258)) (else arg-11258)))))) '() (PreludeC-45Types-n--10177-9486-u--go (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11258 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11258))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11258)) (else arg-11258))) '() (PreludeC-45Types-prim__integerToNat (string-length (let ((sc0 (DataC-45List-isPrefixOfBy (force csegen-275) (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (PreludeC-45Types-n--10177-9486-u--go arg-11258 '() (PreludeC-45Types-prim__integerToNat (string-length arg-11258))))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11258)) (else arg-11258)))))))))))))))
(define CoreC-45FC-showPos (lambda (arg-0) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (string-append (PreludeC-45Show-u--show_Show_Int (bs+ e-2 1 63)) (string-append ":" (PreludeC-45Show-u--show_Show_Int (bs+ e-3 1 63))))))))
(define CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent (lambda (ext-0) (CoreC-45NameC-45Namespace-showNSWithSep "." ext-0)))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char<=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char>=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45Types-isDigit (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Char arg-0 #\0))) (cond ((equal? sc0 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\9)) (else 0)))))
(define PreludeC-45Show-protectEsc (lambda (arg-0 arg-1 arg-2) (string-append arg-1 (string-append (let ((sc0 (PreludeC-45Show-firstCharIs arg-0 arg-2))) (cond ((equal? sc0 1) "\\&") (else ""))) arg-2))))
(define PreludeC-45EqOrd-u--C-62_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char>? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45Show-n--2434-11912-u--asciiTab (lambda (arg-0) (cons "NUL" (cons "SOH" (cons "STX" (cons "ETX" (cons "EOT" (cons "ENQ" (cons "ACK" (cons "BEL" (cons "BS" (cons "HT" (cons "LF" (cons "VT" (cons "FF" (cons "CR" (cons "SO" (cons "SI" (cons "DLE" (cons "DC1" (cons "DC2" (cons "DC3" (cons "DC4" (cons "NAK" (cons "SYN" (cons "ETB" (cons "CAN" (cons "EM" (cons "SUB" (cons "ESC" (cons "FS" (cons "GS" (cons "RS" (cons "US" '()))))))))))))))))))))))))))))))))))
(define PreludeC-45Show-showLitChar (lambda (arg-0) (cond ((equal? arg-0 (integer->char 7)) (lambda (arg-1) (string-append "\\a" arg-1))) ((equal? arg-0 (integer->char 8)) (lambda (arg-1) (string-append "\\b" arg-1))) ((equal? arg-0 (integer->char 12)) (lambda (arg-1) (string-append "\\f" arg-1))) ((equal? arg-0 (integer->char 10)) (lambda (arg-1) (string-append "\\n" arg-1))) ((equal? arg-0 (integer->char 13)) (lambda (arg-1) (string-append "\\r" arg-1))) ((equal? arg-0 (integer->char 9)) (lambda (arg-1) (string-append "\\t" arg-1))) ((equal? arg-0 (integer->char 11)) (lambda (arg-1) (string-append "\\v" arg-1))) ((equal? arg-0 (integer->char 14)) (lambda (eta-0) (PreludeC-45Show-protectEsc (lambda (arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-1 #\H)) "\\SO" eta-0))) ((equal? arg-0 (integer->char 127)) (lambda (arg-1) (string-append "\\DEL" arg-1))) ((equal? arg-0 #\\) (lambda (arg-1) (string-append "\\\\" arg-1)))(else (lambda (clam-0) (let ((sc0 (PreludeC-45Types-getAt (PreludeC-45Types-prim__integerToNat (char->integer arg-0)) (PreludeC-45Show-n--2434-11912-u--asciiTab arg-0)))) (if (null? sc0) (let ((sc1 (PreludeC-45EqOrd-u--C-62_Ord_Char arg-0 (integer->char 127)))) (cond ((equal? sc1 1) (string-cons #\\ (PreludeC-45Show-protectEsc (lambda (eta-0) (PreludeC-45Types-isDigit eta-0)) (PreludeC-45Show-u--show_Show_Int (cast-char-boundedInt arg-0 63)) clam-0))) (else (string-cons arg-0 clam-0)))) (let ((e-1 (unbox sc0))) (string-cons #\\ (string-append e-1 clam-0))))))))))
(define PreludeC-45Show-showLitString (lambda (arg-0) (lambda (clam-0) (if (null? arg-0) clam-0 (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cond ((equal? e-2 #\") (string-append "\\\"" ((PreludeC-45Show-showLitString e-3) clam-0)))(else ((PreludeC-45Show-showLitChar e-2) ((PreludeC-45Show-showLitString e-3) clam-0))))))))))
(define PreludeC-45Show-u--show_Show_String (lambda (arg-0) (string-cons #\" ((PreludeC-45Show-showLitString (PreludeC-45Types-fastUnpack arg-0)) "\""))))
(define CoreC-45FC-u--show_Show_VirtualIdent (lambda (arg-0) "(Interactive)"))
(define CoreC-45FC-u--show_Show_OriginDesc (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_String e-1))) (else (let ((e-2 (vector-ref arg-0 1))) (CoreC-45FC-u--show_Show_VirtualIdent e-2))))))
(define CoreC-45FC-u--show_Show_FC (lambda (arg-0) (case (vector-ref arg-0 0) ((2) "EmptyFC") ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_OriginDesc e-0) (string-append ":" (string-append (CoreC-45FC-showPos e-1) (string-append "--" (CoreC-45FC-showPos e-2))))))))) (else (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_OriginDesc e-3) (string-append ":" (string-append (CoreC-45FC-showPos e-4) (string-append "--" (CoreC-45FC-showPos e-5))))))))))))
(define CoreC-45FC-u--showPrec_Show_FC (lambda (arg-0 arg-1) (CoreC-45FC-u--show_Show_FC arg-1)))
(define csegen-287(delay (cons (lambda (u--x) (CoreC-45FC-u--show_Show_FC u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45FC-u--showPrec_Show_FC u--d u--x))))))
(define csegen-288(delay (cons (force csegen-287) (force csegen-68))))
(define csegen-289 (lambda (u--n) (string-append "." (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-288) u--n))))
(define csegen-290(delay (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-288) u--x))))
(define PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-4)))
(define csegen-292(delay (cons (force csegen-290) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-288) u--d u--x))))))
(define CoreC-45Name-u--C-47C-61_Eq_Name (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Name-u--C-61C-61_Eq_Name arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-298(delay (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45Name-u--C-61C-61_Eq_Name arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45Name-u--C-47C-61_Eq_Name arg-722 arg-725))))))
(define CoreC-45TT-u--C-61C-61_Eq_Fixity (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0)))(else 0))))
(define csegen-300 (lambda (eta-0) (CoreC-45TT-u--C-61C-61_Eq_Fixity (let ((sc0 (Builtin-snd eta-0))) (let ((e-3 (vector-ref sc0 3))) e-3)) 3)))
(define CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-23) arg-0 arg-1)))
(define CoreC-45NameC-45Namespace-u--C-47C-61_Eq_ModuleIdent (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-303 (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45NameC-45Namespace-u--C-47C-61_Eq_ModuleIdent arg-722 arg-725)))))
(define CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 csegen-544 arg-0 arg-1)))
(define CoreC-45NameC-45Namespace-u--C-60C-61_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 2)))
(define CoreC-45NameC-45Namespace-u--C-60_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 0)))
(define CoreC-45NameC-45Namespace-u--C-62C-61_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 0)))
(define CoreC-45NameC-45Namespace-u--C-62_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 2)))
(define CoreC-45NameC-45Namespace-u--max_Ord_ModuleIdent (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-62_Ord_ModuleIdent arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define CoreC-45NameC-45Namespace-u--min_Ord_ModuleIdent (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-60_Ord_ModuleIdent arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-311 (vector csegen-303 (lambda (arg-1598) (lambda (arg-1601) (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (CoreC-45NameC-45Namespace-u--C-60_Ord_ModuleIdent arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (CoreC-45NameC-45Namespace-u--C-62_Ord_ModuleIdent arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (CoreC-45NameC-45Namespace-u--C-60C-61_Ord_ModuleIdent arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (CoreC-45NameC-45Namespace-u--C-62C-61_Ord_ModuleIdent arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (CoreC-45NameC-45Namespace-u--max_Ord_ModuleIdent arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (CoreC-45NameC-45Namespace-u--min_Ord_ModuleIdent arg-1658 arg-1661)))))
(define LibrariesC-45DataC-45SortedMap-empty (lambda (arg-2) (vector 0 arg-2)))
(define csegen-312 (LibrariesC-45DataC-45SortedMap-empty csegen-311))
(define csegen-317(delay (lambda (eta-0) (let ((e-3 (cdr eta-0))) e-3))))
(define LibrariesC-45TextC-45LexerC-45Core-pred (lambda (ext-0) (vector 4 ext-0)))
(define LibrariesC-45TextC-45Lexer-is (lambda (arg-0) (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-1 arg-0)))))
(define LibrariesC-45TextC-45LexerC-45Core-C-60C-124C-62 (lambda (ext-0 ext-1) (vector 8 ext-0 ext-1)))
(define LibrariesC-45TextC-45LexerC-45Core-empty (vector 0 ))
(define LibrariesC-45TextC-45Lexer-opt (lambda (arg-0) (LibrariesC-45TextC-45LexerC-45Core-C-60C-124C-62 arg-0 LibrariesC-45TextC-45LexerC-45Core-empty)))
(define LibrariesC-45TextC-45Lexer-some (lambda (arg-0) (vector 5 arg-0 (lambda () (LibrariesC-45TextC-45Lexer-many arg-0)))))
(define LibrariesC-45TextC-45Lexer-many (lambda (arg-0) (LibrariesC-45TextC-45Lexer-opt (LibrariesC-45TextC-45Lexer-some arg-0))))
(define csegen-326 (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45Lexer-is #\#)))
(define PreludeC-45Types-isLower (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Char arg-0 #\a))) (cond ((equal? sc0 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\z)) (else 0)))))
(define PreludeC-45Types-isUpper (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Char arg-0 #\A))) (cond ((equal? sc0 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\Z)) (else 0)))))
(define PreludeC-45Types-isAlpha (lambda (arg-0) (let ((sc0 (PreludeC-45Types-isUpper arg-0))) (cond ((equal? sc0 1) 1) (else (PreludeC-45Types-isLower arg-0))))))
(define ParserC-45LexerC-45Common-isIdentStart (lambda (arg-0 arg-1) (cond ((equal? arg-1 #\_) 1)(else (cond ((equal? arg-0 1) (let ((sc1 (PreludeC-45Types-isUpper arg-1))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63)))))))(else (let ((sc0 (PreludeC-45Types-isAlpha arg-1))) (cond ((equal? sc0 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63))))))))))))
(define PreludeC-45Types-isAlphaNum (lambda (arg-0) (let ((sc0 (PreludeC-45Types-isDigit arg-0))) (cond ((equal? sc0 1) 1) (else (PreludeC-45Types-isAlpha arg-0))))))
(define ParserC-45LexerC-45Common-isIdentTrailing (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 #\-) 1)(else (cond ((equal? arg-1 #\') 1) ((equal? arg-1 #\_) 1)(else (let ((sc1 (PreludeC-45Types-isAlphaNum arg-1))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63)))))))))))(else (cond ((equal? arg-1 #\') 1) ((equal? arg-1 #\_) 1)(else (let ((sc0 (PreludeC-45Types-isAlphaNum arg-1))) (cond ((equal? sc0 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63))))))))))))
(define csegen-806(delay (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentTrailing 2 eta-0))))
(define ParserC-45LexerC-45Common-identNormal (vector 5 (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentStart 2 eta-0))) (lambda () (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45LexerC-45Core-pred (force csegen-806))))))
(define csegen-459 (vector 5 (LibrariesC-45TextC-45Lexer-is #\?) (lambda () ParserC-45LexerC-45Common-identNormal)))
(define csegen-482(delay (vector 5 (LibrariesC-45TextC-45Lexer-is #\.) (lambda () ParserC-45LexerC-45Common-identNormal))))
(define LibrariesC-45TextC-45Lexer-isNot (lambda (arg-0) (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-1 arg-0)))))
(define csegen-485(delay (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45Lexer-isNot (integer->char 10)))))
(define csegen-492(delay (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (PreludeC-45Types-isAlphaNum eta-0)))))
(define CoreC-45NameC-45Namespace-u--showPrec_Show_Namespace (lambda (arg-0 arg-1) (CoreC-45NameC-45Namespace-u--show_Show_Namespace arg-1)))
(define csegen-506(delay (cons (lambda (u--x) (CoreC-45NameC-45Namespace-u--show_Show_Namespace u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45NameC-45Namespace-u--showPrec_Show_Namespace u--d u--x))))))
(define PreludeC-45Show-showArg (lambda (arg-1 arg-2) (string-append " " (let ((e-2 (cdr arg-1))) ((e-2 (vector 6 )) arg-2)))))
(define PreludeC-45Show-showCon (lambda (arg-0 arg-1 arg-2) (PreludeC-45Show-showParens (PreludeC-45Show-u--C-62C-61_Ord_Prec arg-0 (vector 6 )) (string-append arg-1 arg-2))))
(define CoreC-45Name-u--showPrec_Show_RawUNUserName (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "Basic " e-0))) ((1) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "Field " e-1))) (else "Underscore"))))
(define CoreC-45Name-u--show_Show_RawUNUserName (lambda (arg-0) (CoreC-45Name-u--showPrec_Show_RawUNUserName (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_String (lambda (arg-0 arg-1) (PreludeC-45Show-u--show_Show_String arg-1)))
(define csegen-512(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_String u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_String u--d u--x))))))
(define csegen-514(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Int u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Int u--d u--x))))))
(define csegen-515(delay (cons (force csegen-514) (force csegen-514))))
(define csegen-518(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-515) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-515) u--d u--x))))))
(define CoreC-45Name-u--showPrec_Show_RawName (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "NS" (string-append (PreludeC-45Show-showArg (force csegen-506) e-0) (PreludeC-45Show-showArg (csegen-508) e-1)))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "UN" (PreludeC-45Show-showArg (cons (lambda (u--x) (CoreC-45Name-u--show_Show_RawUNUserName u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Name-u--showPrec_Show_RawUNUserName u--d u--x)))) e-2)))) ((2) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "MN" (string-append (PreludeC-45Show-showArg (force csegen-512) e-3) (PreludeC-45Show-showArg (force csegen-514) e-4)))))) ((3) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "PV" (string-append (PreludeC-45Show-showArg (csegen-508) e-5) (PreludeC-45Show-showArg (force csegen-514) e-6)))))) ((4) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "DN" (string-append (PreludeC-45Show-showArg (force csegen-512) e-7) (PreludeC-45Show-showArg (csegen-508) e-8)))))) ((5) (let ((e-9 (vector-ref arg-1 1))) (let ((e-10 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "Nested" (string-append (PreludeC-45Show-showArg (force csegen-518) e-9) (PreludeC-45Show-showArg (csegen-508) e-10)))))) ((6) (let ((e-11 (vector-ref arg-1 1))) (let ((e-12 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "CaseBlock" (string-append (PreludeC-45Show-showArg (force csegen-512) e-11) (PreludeC-45Show-showArg (force csegen-514) e-12)))))) ((7) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "WithBlock" (string-append (PreludeC-45Show-showArg (force csegen-512) e-13) (PreludeC-45Show-showArg (force csegen-514) e-14)))))) (else (let ((e-15 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "Resolved" (PreludeC-45Show-showArg (force csegen-514) e-15)))))))
(define CoreC-45Name-u--show_Show_RawName (lambda (arg-0) (CoreC-45Name-u--showPrec_Show_RawName (vector 0 ) arg-0)))
(define csegen-508 (lambda () (cons (lambda (u--x) (CoreC-45Name-u--show_Show_RawName u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Name-u--showPrec_Show_RawName u--d u--x))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (lambda (arg-2 arg-3) (let ((e-2 (car arg-2))) (e-2 arg-3))))
(define csegen-519(delay (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "_")))
(define DecidableC-45Equality-u--decEq_DecEq_FromEqC-36a (lambda (arg-1 arg-2 arg-3) (let ((sc0 (let ((e-1 (car arg-1))) ((e-1 arg-2) arg-3)))) (cond ((equal? sc0 1) (vector 0 'erased)) (else (vector 1 (lambda (eta-0) 'erased)))))))
(define DecidableC-45Equality-u--decEq_DecEq_Int (lambda (ext-0 ext-1) (DecidableC-45Equality-u--decEq_DecEq_FromEqC-36a (force csegen-236) ext-0 ext-1)))
(define csegen-521 (lambda (eta-0) (lambda (eta-1) (DecidableC-45Equality-u--decEq_DecEq_Int eta-0 eta-1))))
(define csegen-524 (lambda (arg-10444) (lambda (arg-10447) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe arg-10444 arg-10447))))
(define PreludeC-45Types-u--join_Monad_Maybe (lambda (arg-1) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe arg-1 (lambda (eta-0) eta-0))))
(define csegen-528 (vector (force csegen-267) (lambda (u--b) (lambda (u--a) csegen-524)) (lambda (u--a) (lambda (arg-10458) (PreludeC-45Types-u--join_Monad_Maybe arg-10458)))))
(define PreludeC-45InterfacesC-45NumC-45Semigroup-u--C-60C-43C-62_Semigroup_AdditiveC-36a (lambda (arg-1) (let ((e-1 (vector-ref arg-1 0))) e-1)))
(define PreludeC-45InterfacesC-45NumC-45Monoid-u--neutral_Monoid_AdditiveC-36a (lambda (arg-1) (let ((e-3 (vector-ref arg-1 2))) (e-3 0))))
(define PreludeC-45Interfaces-sum (lambda (arg-2 arg-3) (let ((e-6 (vector-ref arg-3 5))) ((((e-6 'erased) 'erased) (cons (lambda (arg-8505) (lambda (arg-8508) (((PreludeC-45InterfacesC-45NumC-45Semigroup-u--C-60C-43C-62_Semigroup_AdditiveC-36a arg-2) arg-8505) arg-8508))) (PreludeC-45InterfacesC-45NumC-45Monoid-u--neutral_Monoid_AdditiveC-36a arg-2))) (lambda (eta-0) eta-0)))))
(define csegen-533 (PreludeC-45Interfaces-sum csegen-115 (force csegen-14)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char (lambda (arg-0) (cond ((equal? arg-0 (integer->char 10)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-line)(else (vector 1 arg-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_Char (lambda (arg-0 arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char arg-1)))
(define csegen-706 (cons (lambda (arg-11249) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char arg-11249)) (lambda (arg-11255) (lambda (arg-11258) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_Char arg-11255 arg-11258)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-dot (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\.))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround (lambda (arg-1 arg-2 arg-3) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 arg-2 arg-1) arg-3)))
(define csegen-535 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-dot eta-0 eta-1))))
(define DecidableC-45Equality-u--decEq_DecEq_String (lambda (ext-0 ext-1) (DecidableC-45Equality-u--decEq_DecEq_FromEqC-36a (force csegen-23) ext-0 ext-1)))
(define csegen-536 (lambda (eta-0) (lambda (eta-1) (DecidableC-45Equality-u--decEq_DecEq_String eta-0 eta-1))))
(define LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Volume (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-3))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-3 e-4)) (else 0))))))(else 0)))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-5 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char e-2 e-5)))(else 0))))(else 0))))
(define LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Volume (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Volume arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-549 (cons (lambda (arg-712) (lambda (arg-715) (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Volume arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Volume arg-722 arg-725)))))
(define LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Body (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-1)))(else 0))))(else 0))))
(define LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Body (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Body arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-552 (cons (lambda (arg-712) (lambda (arg-715) (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Body arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Body arg-722 arg-725)))))
(define LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_PathTokenKind (lambda (arg-0 arg-1) (if (null? arg-0) (if (null? arg-1) 1 0) (let ((e-0 (unbox arg-0))) (if (null? arg-1) 0 (let ((e-1 (unbox arg-1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char e-0 e-1)))))))
(define LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_PathTokenKind (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_PathTokenKind arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define LibrariesC-45UtilsC-45Path-u--TokType_TokenKind_PathTokenKind (lambda (arg-0) (if (null? arg-0) (vector "String" ) (vector "Builtin.Unit" ))))
(define LibrariesC-45UtilsC-45Path-u--tokValue_TokenKind_PathTokenKind (lambda (arg-0 arg-1) (if (null? arg-0) arg-1 'erased)))
(define csegen-558(delay (cons (cons (lambda (arg-712) (lambda (arg-715) (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_PathTokenKind arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_PathTokenKind arg-722 arg-725)))) (cons (lambda (arg-818) (LibrariesC-45UtilsC-45Path-u--TokType_TokenKind_PathTokenKind arg-818)) (lambda (u--kind) (lambda (arg-827) (LibrariesC-45UtilsC-45Path-u--tokValue_TokenKind_PathTokenKind u--kind arg-827)))))))
(define LibrariesC-45TextC-45Parser-match (lambda (arg-2 arg-3) (vector 1 "Unrecognised input" (lambda (u--t) (let ((sc0 (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) ((e-1 (let ((e-4 (car u--t))) e-4)) arg-3))))) (cond ((equal? sc0 1) (box (let ((sc1 (Builtin-snd arg-2))) (let ((e-2 (cdr sc1))) ((e-2 arg-3) (let ((e-3 (cdr u--t))) e-3)))))) (else '())))))))
(define csegen-559(delay (LibrariesC-45TextC-45Parser-match (force csegen-558) '())))
(define csegen-567(delay (LibrariesC-45TextC-45Parser-match (force csegen-558) (box #\\))))
(define LibrariesC-45UtilsC-45Path-bodySeparator (vector 13 1 1 (force csegen-567) (lambda () (LibrariesC-45TextC-45Parser-match (force csegen-558) (box #\/)))))
(define csegen-561(delay (vector 9 1 (force csegen-559) (lambda () (lambda (u--server) (vector 11 1 LibrariesC-45UtilsC-45Path-bodySeparator (lambda () (vector 9 0 (force csegen-559) (lambda () (lambda (u--share) (vector 0 (vector 0 u--server u--share))))))))))))
(define LibrariesC-45TextC-45Quantity-exactly (lambda (arg-0) (cons arg-0 (box arg-0))))
(define DataC-45Nat-isSucc (lambda (arg-0) (cond ((equal? arg-0 0) 0)(else 1))))
(define csegen-566 (DataC-45Nat-isSucc (let ((sc0 (LibrariesC-45TextC-45Quantity-exactly 2))) (let ((e-0 (car sc0))) e-0))))
(define LibrariesC-45TextC-45Quantity-atLeast (lambda (arg-0) (cons arg-0 '())))
(define LibrariesC-45TextC-45Quantity-atMost (lambda (arg-0) (cons 0 (box arg-0))))
(define LibrariesC-45TextC-45Quantity-between (lambda (arg-0 arg-1) (cons arg-0 (box arg-1))))
(define LibrariesC-45TextC-45Parser-count1 (lambda (arg-3 arg-4) (vector 9 (let ((sc0 (DataC-45Nat-isSucc (let ((e-0 (car arg-3))) e-0)))) (cond ((equal? sc0 1) 1) (else 0))) arg-4 (lambda () (lambda (u--x) (vector 10 (DataC-45Nat-isSucc (let ((e-0 (car arg-3))) e-0)) 0 (LibrariesC-45TextC-45Parser-count arg-3 arg-4) (lambda (u--xs) (vector 0 (cons u--x u--xs)))))))))
(define LibrariesC-45TextC-45Parser-option (lambda (arg-3 arg-4 arg-5) (cond ((equal? arg-3 0) (vector 13 0 0 arg-5 (lambda () (vector 0 arg-4)))) (else (vector 13 1 0 arg-5 (lambda () (vector 0 arg-4)))))))
(define LibrariesC-45TextC-45Parser-some (lambda (arg-3) (vector 9 0 arg-3 (lambda () (lambda (bind-0) (vector 10 0 0 (LibrariesC-45TextC-45Parser-many arg-3) (lambda (bind-1) (vector 0 (cons bind-0 bind-1)))))))))
(define LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 (lambda (arg-4 arg-5 arg-6) (cond ((equal? arg-4 0) (case (vector-ref arg-6 0) ((0) (let ((e-65 (vector-ref arg-6 1))) (vector 0 (arg-5 e-65))))(else (case (vector-ref arg-6 0) ((4) (let ((e-49 (vector-ref arg-6 1))) (let ((e-50 (vector-ref arg-6 2))) (let ((e-51 (vector-ref arg-6 3))) (vector 4 e-49 e-50 e-51))))) ((6) (let ((e-56 (vector-ref arg-6 1))) (vector 6 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-56)))) ((8) (let ((e-61 (vector-ref arg-6 1))) (vector 8 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-61))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((1) (let ((e-43 (vector-ref arg-6 1))) (let ((e-44 (vector-ref arg-6 2))) (vector 1 e-43 (lambda (eta-0) (PreludeC-45Types-u--map_Functor_Maybe arg-5 (e-44 eta-0)))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))))))))))(else (case (vector-ref arg-6 0) ((4) (let ((e-49 (vector-ref arg-6 1))) (let ((e-50 (vector-ref arg-6 2))) (let ((e-51 (vector-ref arg-6 3))) (vector 4 e-49 e-50 e-51))))) ((6) (let ((e-56 (vector-ref arg-6 1))) (vector 6 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-56)))) ((8) (let ((e-61 (vector-ref arg-6 1))) (vector 8 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-61))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((1) (let ((e-43 (vector-ref arg-6 1))) (let ((e-44 (vector-ref arg-6 2))) (vector 1 e-43 (lambda (eta-0) (PreludeC-45Types-u--map_Functor_Maybe arg-5 (e-44 eta-0)))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0))))))))))))))))))))))))
(define LibrariesC-45TextC-45Parser-many (lambda (arg-3) (LibrariesC-45TextC-45Parser-option 1 '() (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 1 (lambda (eta-0) eta-0) (LibrariesC-45TextC-45Parser-some arg-3)))))
(define LibrariesC-45TextC-45Parser-count (lambda (arg-3 arg-4) (let ((e-0 (car arg-3))) (let ((e-1 (cdr arg-3))) (cond ((equal? e-0 0) (if (null? e-1) (LibrariesC-45TextC-45Parser-many arg-4) (let ((e-5 (unbox e-1))) (cond ((equal? e-5 0) (vector 0 '()))(else (let ((e-6 (- e-5 1))) (LibrariesC-45TextC-45Parser-option 1 '() (LibrariesC-45TextC-45Parser-count1 (LibrariesC-45TextC-45Quantity-atMost e-6) arg-4))))))))(else (let ((e-2 (- e-0 1))) (if (null? e-1) (LibrariesC-45TextC-45Parser-count1 (LibrariesC-45TextC-45Quantity-atLeast e-2) arg-4) (let ((e-9 (unbox e-1))) (cond ((equal? e-9 0) (vector 4 '() 0 "Quantity out of order"))(else (let ((e-10 (- e-9 1))) (LibrariesC-45TextC-45Parser-count1 (LibrariesC-45TextC-45Quantity-between (+ e-2 1) e-10) arg-4)))))))))))))
(define csegen-569 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 csegen-566 (lambda (eta-0) 'erased) (LibrariesC-45TextC-45Parser-count (LibrariesC-45TextC-45Quantity-exactly 2) (force csegen-567))))
(define csegen-572(delay (vector 11 1 (LibrariesC-45TextC-45Parser-match (force csegen-558) (box #\?)) (lambda () (vector 11 0 (force csegen-567) (lambda () (vector 0 'erased)))))))
(define SystemC-45Info-isWindows (force csegen-101))
(define LibrariesC-45UtilsC-45Path-pathSeparator (let ((sc0 SystemC-45Info-isWindows)) (cond ((equal? sc0 1) #\;) (else #\:))))
(define csegen-599 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 LibrariesC-45UtilsC-45Path-pathSeparator)))
(define LibrariesC-45TextC-45Parser-optional (lambda (arg-3 arg-4) (LibrariesC-45TextC-45Parser-option arg-3 '() (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-3 (lambda (eta-0) (box eta-0)) arg-4))))
(define csegen-604 (LibrariesC-45TextC-45Parser-optional 1 (LibrariesC-45TextC-45Parser-some LibrariesC-45UtilsC-45Path-bodySeparator)))
(define csegen-612 (lambda (arg-0) (PreludeC-45EqOrd-u--C-47C-61_Eq_String arg-0 "")))
(define PreludeC-45Types-isSpace (lambda (arg-0) (cond ((equal? arg-0 #\ ) 1) ((equal? arg-0 (integer->char 9)) 1) ((equal? arg-0 (integer->char 13)) 1) ((equal? arg-0 (integer->char 10)) 1) ((equal? arg-0 (integer->char 12)) 1) ((equal? arg-0 (integer->char 11)) 1) ((equal? arg-0 (integer->char 160)) 1)(else 0))))
(define csegen-622 (lambda (u--char) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Char u--char #\.))) (cond ((equal? sc0 1) 1) (else (PreludeC-45Types-isSpace u--char))))))
(define csegen-623(delay (vector 0 (force csegen-108))))
(define csegen-627 (cons (cons "End of input" '()) '()))
(define LibrariesC-45TextC-45Lexer-any (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) 1)))
(define LibrariesC-45TextC-45Lexer-escape (lambda (arg-0 arg-1) (vector 5 arg-0 (lambda () arg-1))))
(define csegen-672 (LibrariesC-45TextC-45LexerC-45Core-C-60C-124C-62 (LibrariesC-45TextC-45Lexer-escape (LibrariesC-45TextC-45Lexer-is #\\) LibrariesC-45TextC-45Lexer-any) LibrariesC-45TextC-45Lexer-any))
(define csegen-674(delay (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (PreludeC-45Types-isSpace eta-0)))))
(define csegen-703 (lambda (arg-0) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-0 (integer->char 10))))
(define csegen-704 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 (integer->char 10))))
(define DataC-45List-isSuffixOfBy (lambda (arg-2 arg-3 arg-4) (DataC-45List-isPrefixOfBy arg-2 (PreludeC-45TypesC-45List-reverse arg-3) (PreludeC-45TypesC-45List-reverse arg-4))))
(define DataC-45List-isSuffixOf (lambda (arg-1 ext-0 ext-1) (DataC-45List-isSuffixOfBy (let ((e-1 (car arg-1))) e-1) ext-0 ext-1)))
(define DataC-45String-isSuffixOf (lambda (arg-0 arg-1) (DataC-45List-isSuffixOf csegen-17 (PreludeC-45Types-fastUnpack arg-0) (PreludeC-45Types-fastUnpack arg-1))))
(define DataC-45String-linesC-39 (lambda (arg-0) (DataC-45String-n--3989-9562-u--linesHelp arg-0 '() arg-0)))
(define DataC-45String-lines (lambda (arg-0) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45String-linesC-39 (PreludeC-45Types-fastUnpack arg-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String (lambda (arg-0) (let ((u--strC-39 (let ((sc0 (DataC-45String-isSuffixOf "\u000a" arg-0))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-0)) (else arg-0))))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines eta-0)) (DataC-45String-lines u--strC-39))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_String (lambda (arg-0 arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String arg-1)))
(define csegen-727(delay (cons (lambda (arg-11249) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String arg-11249)) (lambda (arg-11255) (lambda (arg-11258) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_String arg-11255 arg-11258))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (lambda (arg-1 arg-2) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 arg-1 (vector 1 #\ )) arg-2)))
(define csegen-741 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 eta-0 eta-1))))
(define csegen-744 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 eta-0 eta-1))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-750 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_Integer arg-722 arg-725)))))
(define csegen-775(delay (lambda (eta-0) (PreludeC-45Types-prim__integerToNat eta-0))))
(define csegen-779(delay (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-727) eta-0))))
(define csegen-789(delay (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45Lexer-is #\-))))
(define csegen-798(delay (vector 5 (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentStart 1 eta-0))) (lambda () (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentTrailing 1 eta-0))))))))
(define PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AllBool (lambda (arg-0 arg-1) (cond ((equal? arg-0 1) arg-1) (else 0))))
(define csegen-805 (cons (lambda (arg-8505) (lambda (arg-8508) (PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AllBool arg-8505 arg-8508))) 1))
(define csegen-814(delay (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentTrailing 0 eta-0))))
(define LibrariesC-45DataC-45SortedMap-treeInsertC-39 (lambda (arg-4 arg-5 arg-6 arg-7) (case (vector-ref arg-7 0) ((0) (let ((e-3 (vector-ref arg-7 1))) (let ((e-4 (vector-ref arg-7 2))) (let ((sc1 (let ((e-2 (vector-ref arg-4 1))) ((e-2 arg-5) e-3)))) (cond ((equal? sc1 0) (vector 1 (cons (vector 0 arg-5 arg-6) (cons arg-5 (vector 0 e-3 e-4))))) ((equal? sc1 1) (vector 0 (vector 0 arg-5 arg-6))) (else (vector 1 (cons (vector 0 e-3 e-4) (cons e-3 (vector 0 arg-5 arg-6)))))))))) ((1) (let ((e-9 (vector-ref arg-7 1))) (let ((e-10 (vector-ref arg-7 2))) (let ((e-11 (vector-ref arg-7 3))) (let ((sc1 (let ((e-5 (vector-ref arg-4 4))) ((e-5 arg-5) e-10)))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-9))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-2 e-10 e-11)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-12 (cdr e-5))) (let ((e-14 (car e-12))) (let ((e-13 (cdr e-12))) (vector 0 (vector 2 e-8 e-14 e-13 e-10 e-11))))))))))) (else (let ((sc2 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-11))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-9 e-10 e-2)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-12 (cdr e-5))) (let ((e-14 (car e-12))) (let ((e-13 (cdr e-12))) (vector 0 (vector 2 e-9 e-10 e-8 e-14 e-13))))))))))))))))) (else (let ((e-16 (vector-ref arg-7 1))) (let ((e-17 (vector-ref arg-7 2))) (let ((e-18 (vector-ref arg-7 3))) (let ((e-19 (vector-ref arg-7 4))) (let ((e-20 (vector-ref arg-7 5))) (let ((sc1 (let ((e-5 (vector-ref arg-4 4))) ((e-5 arg-5) e-17)))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-16))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 2 e-2 e-17 e-18 e-19 e-20)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (cons (vector 1 e-8 e-12 e-13) (cons e-17 (vector 1 e-18 e-19 e-20))))))))))))) (else (let ((sc2 (let ((e-5 (vector-ref arg-4 4))) ((e-5 arg-5) e-19)))) (cond ((equal? sc2 1) (let ((sc3 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-18))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-16 e-17 e-2 e-19 e-20)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (cons (vector 1 e-16 e-17 e-8) (cons e-12 (vector 1 e-13 e-19 e-20))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-20))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-16 e-17 e-18 e-19 e-2)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (cons (vector 1 e-16 e-17 e-18) (cons e-19 (vector 1 e-8 e-12 e-13)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45SortedMap-treeInsert (lambda (arg-4 arg-5 arg-6 arg-7) (let ((sc0 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 arg-7))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref sc0 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (vector 1 e-8 e-12 e-13))))))))))))
(define LibrariesC-45DataC-45SortedMap-insert (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-2 (vector-ref arg-4 1))) (vector 1 e-2 0 (vector 0 arg-2 arg-3)))) (else (let ((e-5 (vector-ref arg-4 1))) (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((sc1 (LibrariesC-45DataC-45SortedMap-treeInsert e-5 arg-2 arg-3 e-7))) (case (vector-ref sc1 0) ((0) (let ((e-2 (vector-ref sc1 1))) (vector 1 e-5 e-6 e-2))) (else (let ((e-8 (vector-ref sc1 1))) (vector 1 e-5 (+ e-6 1) e-8))))))))))))
(define csegen-833 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (PreludeC-45Basics-uncurry (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (LibrariesC-45DataC-45SortedMap-insert eta-3 eta-4 eta-5)))) eta-2)) eta-0 eta-1))))
(define csegen-873 (cons 0 (cons 1 '())))
(define IdrisC-45SyntaxC-45Pragmas-allLangExts csegen-873)
(define IdrisC-45SyntaxC-45Pragmas-u--show_Show_LangExt (lambda (arg-0) (cond ((equal? arg-0 0) "ElabReflection") (else "Borrowing"))))
(define csegen-843 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (IdrisC-45SyntaxC-45Pragmas-u--show_Show_LangExt eta-0)) IdrisC-45SyntaxC-45Pragmas-allLangExts))
(define Algebra-showCount (lambda (ext-0) (AlgebraC-45Semiring-elimSemi (force csegen-978) "0 " "1 " (lambda (eta-0) "") ext-0)))
(define PreludeC-45Show-n--3216-12633-u--showC-39 (lambda (arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (if (null? e-3) (string-append arg-3 (let ((e-1 (car arg-1))) (e-1 e-2))) (PreludeC-45Show-n--3216-12633-u--showC-39 arg-1 arg-2 (string-append arg-3 (string-append (let ((e-1 (car arg-1))) (e-1 e-2)) ", ")) e-3)))))))
(define PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2) (string-append "[" (string-append (PreludeC-45Show-n--3216-12633-u--showC-39 arg-1 arg-2 "" arg-2) "]"))))
(define csegen-890(delay (lambda (lamc-0) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (string-append " proof " (string-append (Algebra-showCount e-2) (CoreC-45Name-u--show_Show_Name e-3))))))))
(define TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-2) (string-append " = " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-3)))))) ((1) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (let ((e-9 (vector-ref arg-2 5))) (let ((e-11 (vector-ref arg-2 7))) (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-6) (string-append " with " (string-append (Algebra-showCount e-7) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-8) (string-append ")" (string-append (PreludeC-45Types-maybe (lambda () "") (lambda () (force csegen-890)) e-9) (string-append "\u000a\u0009" (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-11))))))))))))))) (else (let ((e-14 (vector-ref arg-2 2))) (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-14) " impossible"))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 arg-3)))
(define DataC-45List-mergeReplicate (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cons arg-1 (cons e-2 (DataC-45List-mergeReplicate arg-1 e-3))))))))
(define DataC-45List-intersperse (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cons e-2 (DataC-45List-mergeReplicate arg-1 e-3)))))))
(define PreludeC-45Show-u--show_Show_Bool (lambda (arg-0) (cond ((equal? arg-0 1) "True") (else "False"))))
(define TTImpC-45TTImp-u--show_Show_C-40FnOptC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) "%unsafe") ((1) "%inline") ((2) "%noinline") ((3) "%deprecate") ((4) "%tcinline") ((5) (let ((e-6 (vector-ref arg-2 1))) (string-append "%hint " (PreludeC-45Show-u--show_Show_Bool e-6)))) ((6) (let ((e-8 (vector-ref arg-2 1))) (string-append "%globalhint " (PreludeC-45Show-u--show_Show_Bool e-8)))) ((7) "%extern") ((8) (let ((e-11 (vector-ref arg-2 1))) (string-append "%foreign " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--x)) e-11))))) ((9) (let ((e-13 (vector-ref arg-2 1))) (string-append "%export " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--x)) e-13))))) ((10) "%invertible") ((11) (let ((e-16 (vector-ref arg-2 1))) (cond ((equal? e-16 0) "total") ((equal? e-16 1) "covering") (else "partial")))) ((12) "%macro") (else (let ((e-19 (vector-ref arg-2 1))) (string-append "%spec " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) e-19))))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40FnOptC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40FnOptC-39C-32C-36nmC-41 arg-1 arg-3)))
(define PreludeC-45Uninhabited-void (lambda () (blodwen-error-quit "No clauses in Prelude.Uninhabited.void")))
(define LibrariesC-45DataC-45Record-absurd0 (lambda (arg-3) (PreludeC-45Uninhabited-void)))
(define PreludeC-45Types-u--uninhabited_Uninhabited_C-40C-124C-40C-40C-61C-61C-61C-32NothingC-41C-32C-40JustC-32C-36xC-41C-41C-44C-40C-40C-126C-61C-126C-32NothingC-41C-32C-40JustC-32C-36xC-41C-41C-124C-41 (lambda (arg-0) (blodwen-error-quit "No clauses in Prelude.Types.uninhabited")))
(define csegen-1065 (lambda () (LibrariesC-45DataC-45Record-absurd0 (lambda (eta-0) (PreludeC-45Types-u--uninhabited_Uninhabited_C-40C-124C-40C-40C-61C-61C-61C-32NothingC-41C-32C-40JustC-32C-36xC-41C-41C-44C-40C-40C-126C-61C-126C-32NothingC-41C-32C-40JustC-32C-36xC-41C-41C-124C-41 eta-0)))))
(define LibrariesC-45DataC-45Record-index (lambda (arg-2 arg-3) (if (null? arg-2) (cond ((equal? arg-3 0) (csegen-1065))(else (csegen-1065))) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (cond ((equal? arg-3 0) e-4)(else (cond ((equal? arg-3 0) (blodwen-error-quit "Nat case not covered"))(else (let ((e-8 (- arg-3 1))) (LibrariesC-45DataC-45Record-index e-5 e-8)))))))))))
(define LibrariesC-45DataC-45Record-get (lambda (arg-3 arg-4) (LibrariesC-45DataC-45Record-index arg-3 arg-4)))
(define LibrariesC-45DataC-45WithData-get (lambda (arg-4 arg-6) (LibrariesC-45DataC-45Record-get (let ((e-2 (car arg-6))) e-2) arg-4)))
(define CoreC-45WithData-rf--name (lambda (arg-2 arg-3 ext-0) (LibrariesC-45DataC-45WithData-get arg-2 ext-0)))
(define CoreC-45WithData-rf--rig (lambda (arg-2 arg-3 ext-0) (LibrariesC-45DataC-45WithData-get arg-2 ext-0)))
(define AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega (lambda (arg-0) (cond ((equal? arg-0 0) "Rig0") ((equal? arg-0 1) "Rig1") (else "RigW"))))
(define TTImpC-45TTImp-u--show_Show_C-40ImpParameterC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (cons (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega (CoreC-45WithData-rf--rig 0 'erased arg-2)) (cons (CoreC-45Name-u--show_Show_Name (let ((sc0 (CoreC-45WithData-rf--name 1 'erased arg-2))) (let ((e-3 (cdr sc0))) e-3))) (cons " " (cons (let ((e-1 (car arg-1))) (e-1 (let ((e-3 (cdr arg-2))) (let ((e-5 (cdr e-3))) e-5)))) '())))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40ImpParameterC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40ImpParameterC-39C-32C-36nmC-41 arg-1 arg-3)))
(define TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 arg-3)))
(define CoreC-45WithData-rf--tyName (lambda (arg-2 arg-3 ext-0) (LibrariesC-45DataC-45WithData-get arg-2 ext-0)))
(define TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (string-append "(%claim " (string-append (CoreC-45Name-u--show_Show_Name (let ((sc0 (CoreC-45WithData-rf--tyName 1 'erased arg-2))) (let ((e-3 (cdr sc0))) e-3))) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 (let ((e-3 (cdr arg-2))) e-3)) ")"))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40ImpTyC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 arg-3)))
(define TTImpC-45TTImp-u--show_Show_C-40ImpDataC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 5))) (if (null? e-3) (string-append "(%data " (string-append (CoreC-45Name-u--show_Show_Name e-2) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-5) ")")))) (let ((e-11 (unbox e-3))) (string-append "(%data " (string-append (CoreC-45Name-u--show_Show_Name e-2) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-11) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-5) ")")))))))))))) (else (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (string-append "(%datadecl " (string-append (CoreC-45Name-u--show_Show_Name e-8) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-9) ")"))))))))))
(define TTImpC-45TTImp-u--show_Show_C-40IFieldC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (let ((e-3 (cdr arg-2))) (if (null? e-3) (string-append "{" (string-append (CoreC-45Name-u--show_Show_Name (let ((sc2 (CoreC-45WithData-rf--name 2 'erased arg-2))) (let ((e-4 (cdr sc2))) e-4))) (string-append " : " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 (let ((e-4 (cdr e-3))) e-4)) "}")))) (let ((e-5 (car e-3))) (let ((e-6 (cdr e-3))) (case (vector-ref e-5 0) ((1) (string-append (CoreC-45Name-u--show_Show_Name (let ((sc3 (CoreC-45WithData-rf--name 2 'erased arg-2))) (let ((e-4 (cdr sc3))) e-4))) (string-append " : " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-6))))(else (string-append "{" (string-append (CoreC-45Name-u--show_Show_Name (let ((sc2 (CoreC-45WithData-rf--name 2 'erased arg-2))) (let ((e-4 (cdr sc2))) e-4))) (string-append " : " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 (let ((e-4 (cdr e-3))) e-4)) "}"))))))))))))
(define TTImpC-45TTImp-u--show_Show_C-40ImpRecordDataC-32C-36nmC-41 (lambda (arg-1 arg-2) (let ((e-1 (car arg-2))) (let ((e-2 (cdr arg-2))) (string-append "record " (string-append (CoreC-45Name-u--show_Show_Name (let ((sc1 (CoreC-45WithData-rf--name 0 'erased e-1))) (let ((e-3 (cdr sc1))) e-3))) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpParameterC-39C-32C-36nmC-41 (cons (lambda (x-0) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-0)) (lambda (u--d) (lambda (x-0) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d x-0)))) u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpParameterC-39C-32C-36nmC-41 (cons (lambda (x-0) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-0)) (lambda (d-0) (lambda (x-0) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-0)))) u--d u--x)))) (let ((e-3 (cdr e-1))) e-3)) (string-append " " (string-append (CoreC-45Name-u--show_Show_Name (let ((sc1 (CoreC-45WithData-rf--name 0 'erased e-2))) (let ((e-3 (cdr sc1))) e-3))) (string-append "\u000a\u0009" (string-append (CoreC-45NameC-45Namespace-showSep "\u000a\u0009" (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40IFieldC-39C-32C-36nmC-41 arg-1 u--x)) (let ((e-3 (cdr e-2))) e-3))) "\u000a"))))))))))))
(define DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 (lambda (arg-1 ext-0) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 arg-1 ext-0)))
(define CoreC-45Context-u--show_Show_BuiltinType (lambda (arg-0) (cond ((equal? arg-0 0) "Natural") ((equal? arg-0 1) "NaturalToInteger") (else "IntegerToNatural"))))
(define PreludeC-45Show-u--show_Show_Nat (lambda (arg-0) (PreludeC-45Show-u--show_Show_Integer arg-0)))
(define TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-50 (cdr e-1))) (let ((e-52 (vector-ref e-50 0))) (let ((e-54 (vector-ref e-50 2))) (let ((e-55 (vector-ref e-50 3))) (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40FnOptC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40FnOptC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-54) (string-append " " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-52) (string-append " " (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 e-55))))))))))) ((1) (let ((e-6 (vector-ref arg-2 4))) (TTImpC-45TTImp-u--show_Show_C-40ImpDataC-39C-32C-36nmC-41 arg-1 e-6))) ((2) (let ((e-9 (vector-ref arg-2 2))) (let ((e-10 (vector-ref arg-2 3))) (string-append "(%def " (string-append (CoreC-45Name-u--show_Show_Name e-9) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-10) ")"))))))) ((3) (let ((e-13 (vector-ref arg-2 2))) (let ((e-14 (vector-ref arg-2 3))) (string-append "parameters " (string-append (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpParameterC-39C-32C-36nmC-41 (cons (lambda (x-0) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-0)) (lambda (u--d) (lambda (x-0) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d x-0)))) u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpParameterC-39C-32C-36nmC-41 (cons (lambda (x-0) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-0)) (lambda (d-0) (lambda (x-0) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-0)))) u--d u--x)))) e-13) (string-append "\u000a\u0009" (CoreC-45NameC-45Namespace-showSep "\u000a\u0009" (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--x)) e-14)))))))) ((4) (let ((e-20 (vector-ref arg-2 5))) (TTImpC-45TTImp-u--show_Show_C-40ImpRecordDataC-32C-36nmC-41 arg-1 (let ((e-3 (cdr e-20))) e-3)))) ((5) (let ((e-23 (vector-ref arg-2 2))) (let ((e-24 (vector-ref arg-2 3))) (string-append "fail" (string-append (PreludeC-45Types-maybe (lambda () "") (lambda () (lambda (eta-0) (string-append " " (PreludeC-45Show-u--show_Show_String eta-0)))) e-23) (string-append "\u000a" (CoreC-45NameC-45Namespace-showSep "\u000a" (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (string-append "  " (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 eta-0))) e-24)))))))) ((6) (let ((e-27 (vector-ref arg-2 2))) (let ((e-28 (vector-ref arg-2 3))) (string-append "namespace " (string-append (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-27) (CoreC-45NameC-45Namespace-showSep "\u000a" (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--x)) e-28))))))) ((7) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (let ((e-33 (vector-ref arg-2 4))) (string-append "%transform " (string-append (CoreC-45Name-u--show_Show_Name e-31) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-32) (string-append " ==> " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-33)))))))))) ((8) (let ((e-36 (vector-ref arg-2 2))) (string-append "%runElab " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-36)))) ((9) "[externally defined pragma]") ((10) (let ((e-42 (vector-ref arg-2 1))) (if (null? e-42) "%logging off" (let ((e-58 (unbox e-42))) (let ((e-61 (car e-58))) (let ((e-62 (cdr e-58))) (string-append "%logging " (if (null? e-61) (PreludeC-45Show-u--show_Show_Nat e-62) (string-append (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (DataC-45List-intersperse "." e-61)) (string-append " " (PreludeC-45Show-u--show_Show_Nat e-62))))))))))) (else (let ((e-45 (vector-ref arg-2 2))) (let ((e-46 (vector-ref arg-2 3))) (string-append "%builtin " (string-append (CoreC-45Context-u--show_Show_BuiltinType e-45) (string-append " " (CoreC-45Name-u--show_Show_Name e-46))))))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40ImpDeclC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 arg-3)))
(define PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) "Nothing" (let ((e-2 (unbox arg-3))) (PreludeC-45Show-showCon arg-2 "Just" (PreludeC-45Show-showArg arg-1 e-2))))))
(define TTImpC-45TTImp-u--show_Show_C-40IFieldUpdateC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (string-append (CoreC-45NameC-45Namespace-showSep "->" e-1) (string-append " = " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-2)))))) (else (let ((e-4 (vector-ref arg-2 1))) (let ((e-5 (vector-ref arg-2 2))) (string-append (CoreC-45NameC-45Namespace-showSep "->" e-4) (string-append " $= " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-5)))))))))
(define CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) "Implicit") ((1) "Explicit") ((2) "AutoImplicit") (else (let ((e-4 (vector-ref arg-2 1))) (string-append "DefImplicit " (let ((e-1 (car arg-1))) (e-1 e-4))))))))
(define PreludeC-45Show-u--showPrec_Show_Bits16 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits16 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits16 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Bits32 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits32 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits32 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Bits64 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits64 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits64 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Bits8 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits8 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits8 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--show_Show_Char (lambda (arg-0) (cond ((equal? arg-0 #\') "'\\''")(else (string-cons #\' ((PreludeC-45Show-showLitChar arg-0) "'"))))))
(define PreludeC-45Show-u--showPrec_Show_Double (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Double (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Double (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int16 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int16 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int16 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int32 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int32 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int32 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int64 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int64 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int64 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int8 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int8 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int8 (vector 0 ) arg-0)))
(define CoreC-45TTC-45Primitive-u--show_Show_PrimType (lambda (arg-0) (cond ((equal? arg-0 0) "Int") ((equal? arg-0 1) "Int8") ((equal? arg-0 2) "Int16") ((equal? arg-0 3) "Int32") ((equal? arg-0 4) "Int64") ((equal? arg-0 5) "Integer") ((equal? arg-0 6) "Bits8") ((equal? arg-0 7) "Bits16") ((equal? arg-0 8) "Bits32") ((equal? arg-0 9) "Bits64") ((equal? arg-0 10) "String") ((equal? arg-0 11) "Char") ((equal? arg-0 12) "Double") (else "%World"))))
(define CoreC-45TTC-45Primitive-u--show_Show_Constant (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int8 e-1))) ((2) (let ((e-2 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int16 e-2))) ((3) (let ((e-3 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int32 e-3))) ((4) (let ((e-4 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int64 e-4))) ((5) (let ((e-5 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Integer e-5))) ((6) (let ((e-6 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits8 e-6))) ((7) (let ((e-7 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits16 e-7))) ((8) (let ((e-8 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits32 e-8))) ((9) (let ((e-9 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits64 e-9))) ((10) (let ((e-10 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_String e-10))) ((11) (let ((e-11 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Char e-11))) ((12) (let ((e-12 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Double e-12))) ((13) (let ((e-13 (vector-ref arg-0 1))) (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-13))) (else "%MkWorld"))))
(define CoreC-45OptionsC-45Log-u--show_Show_LogLevel (lambda (arg-0) (let ((e-0 (car arg-0))) (let ((e-1 (cdr arg-0))) (if (null? e-0) (PreludeC-45Show-u--show_Show_Nat e-1) (string-append (PreludeC-45Types-fastConcat (DataC-45List-intersperse "." e-0)) (string-append ":" (PreludeC-45Show-u--show_Show_Nat e-1))))))))
(define TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (car arg-1))) (e-4 e-2)))) ((1) (let ((e-5 (vector-ref arg-2 2))) (let ((e-6 (vector-ref arg-2 3))) (let ((e-7 (vector-ref arg-2 4))) (let ((e-8 (vector-ref arg-2 5))) (let ((e-9 (vector-ref arg-2 6))) (string-append "(%pi " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-5) (string-append " " (string-append (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-6) (string-append " " (string-append (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 (force csegen-68) (vector 6 ) e-7) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-8) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-9) ")")))))))))))))))) ((2) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (let ((e-15 (vector-ref arg-2 5))) (let ((e-16 (vector-ref arg-2 6))) (string-append "(%lam " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-12) (string-append " " (string-append (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-13) (string-append " " (string-append (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 (force csegen-68) (vector 6 ) e-14) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-15) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-16) ")")))))))))))))))) ((3) (let ((e-20 (vector-ref arg-2 3))) (let ((e-21 (vector-ref arg-2 4))) (let ((e-22 (vector-ref arg-2 5))) (let ((e-23 (vector-ref arg-2 6))) (let ((e-24 (vector-ref arg-2 7))) (string-append "(%let " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-20) (string-append " " (string-append " " (string-append (CoreC-45Name-u--show_Show_Name e-21) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-22) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-23) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-24) ")"))))))))))))))))) ((4) (let ((e-28 (vector-ref arg-2 3))) (let ((e-29 (vector-ref arg-2 4))) (let ((e-30 (vector-ref arg-2 5))) (string-append "(%case (" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-28) (string-append " : " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-29) (string-append ") " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-30) ")")))))))))) ((5) (let ((e-33 (vector-ref arg-2 2))) (let ((e-34 (vector-ref arg-2 3))) (string-append "(%local (" (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-33) (string-append ") " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-34) ")"))))))) ((6) (let ((e-37 (vector-ref arg-2 2))) (let ((e-38 (vector-ref arg-2 3))) (let ((e-39 (vector-ref arg-2 4))) (let ((e-40 (vector-ref arg-2 5))) (string-append "(%caselocal (" (string-append (CoreC-45Name-u--show_Show_Name e-37) (string-append " " (string-append (CoreC-45Name-u--show_Show_Name e-38) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) e-39) (string-append ") " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-40) ")"))))))))))))) ((7) (let ((e-43 (vector-ref arg-2 2))) (let ((e-44 (vector-ref arg-2 3))) (string-append "(%record " (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40IFieldUpdateC-39C-32C-36nmC-41 arg-1 u--x)) e-43)) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-44) ")"))))))) ((8) (let ((e-47 (vector-ref arg-2 2))) (let ((e-48 (vector-ref arg-2 3))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-47) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-48) ")"))))))) ((10) (let ((e-51 (vector-ref arg-2 2))) (let ((e-52 (vector-ref arg-2 3))) (let ((e-53 (vector-ref arg-2 4))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-51) (string-append " [" (string-append (CoreC-45Name-u--show_Show_Name e-52) (string-append " = " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-53) "])")))))))))) ((9) (let ((e-56 (vector-ref arg-2 2))) (let ((e-57 (vector-ref arg-2 3))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-56) (string-append " [" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-57) "])"))))))) ((11) (let ((e-60 (vector-ref arg-2 2))) (let ((e-61 (vector-ref arg-2 3))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-60) (string-append " | " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-61) ")"))))))) ((12) "%search") ((13) (let ((e-68 (vector-ref arg-2 3))) (string-append "(|" (string-append (CoreC-45NameC-45Namespace-showSep "," (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--x)) e-68)) "|)")))) ((14) (let ((e-71 (vector-ref arg-2 2))) (let ((e-72 (vector-ref arg-2 3))) (string-append "(%rewrite (" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-71) (string-append ") (" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-72) "))"))))))) ((15) (let ((e-75 (vector-ref arg-2 2))) (string-append "(%coerced " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-75) ")")))) ((16) (let ((e-79 (vector-ref arg-2 3))) (string-append "(%bindhere " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-79) ")")))) ((17) (let ((e-82 (vector-ref arg-2 2))) (string-append "$" (CoreC-45Name-u--show_Show_Name e-82)))) ((18) (let ((e-87 (vector-ref arg-2 4))) (let ((e-88 (vector-ref arg-2 5))) (string-append (CoreC-45Name-u--show_Show_Name e-87) (string-append "@(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-88) ")")))))) ((19) (let ((e-92 (vector-ref arg-2 3))) (string-append ".(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-92) ")")))) ((20) (let ((e-96 (vector-ref arg-2 3))) (string-append "(%delayed " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-96) ")")))) ((21) (let ((e-99 (vector-ref arg-2 2))) (string-append "(%delay " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-99) ")")))) ((22) (let ((e-102 (vector-ref arg-2 2))) (string-append "(%force " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-102) ")")))) ((23) (let ((e-105 (vector-ref arg-2 2))) (string-append "(%quote " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-105) ")")))) ((24) (let ((e-108 (vector-ref arg-2 2))) (string-append "(%quotename " (string-append (CoreC-45Name-u--show_Show_Name e-108) ")")))) ((25) (let ((e-111 (vector-ref arg-2 2))) (string-append "(%quotedecl " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-111) ")")))) ((26) (let ((e-114 (vector-ref arg-2 2))) (string-append "(%unquote " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-114) ")")))) ((27) (let ((e-118 (vector-ref arg-2 3))) (string-append "(%runelab " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-118) ")")))) ((28) (let ((e-121 (vector-ref arg-2 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-121))) ((30) (let ((e-124 (vector-ref arg-2 2))) (string-append "?" e-124))) ((31) (let ((e-127 (vector-ref arg-2 2))) (let ((e-128 (vector-ref arg-2 3))) (string-append "(%logging " (string-append (CoreC-45OptionsC-45Log-u--show_Show_LogLevel e-127) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-128) ")"))))))) ((29) "%type") ((32) (let ((e-133 (vector-ref arg-2 2))) (cond ((equal? e-133 1) "_") (else "?")))) (else (let ((e-136 (vector-ref arg-2 2))) (let ((e-137 (vector-ref arg-2 3))) (string-append "(%with " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-292) e-136) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-137) ")"))))))))))
(define csegen-874(delay (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 (force csegen-68) u--x))))
(define csegen-876(delay (cons (force csegen-874) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 (force csegen-68) u--d u--x))))))
(define CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 arg-3) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 arg-1 arg-3)))
(define csegen-879(delay (cons (lambda (u--x) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (force csegen-876) u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (force csegen-876) u--d u--x))))))
(define csegen-880(delay (cons (force csegen-68) (force csegen-879))))
(define PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (unbox arg-2))) (if (null? arg-3) 0 (let ((e-8 (unbox arg-3))) (let ((e-1 (car arg-1))) ((e-1 e-2) e-8))))))))
(define PreludeC-45Types-u--C-47C-61_Eq_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-886 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-298) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45Types-u--C-47C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-298) arg-722 arg-725)))))
(define LibrariesC-45DataC-45SortedSet-insert (lambda (arg-1 arg-2) (LibrariesC-45DataC-45SortedMap-insert arg-1 'erased arg-2)))
(define csegen-887 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45DataC-45SortedSet-insert eta-0 eta-1))))
(define csegen-888 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip csegen-887 eta-0 eta-1))))
(define CoreC-45WithData-FCC-39 (cons "fc" (vector "Core.FC.FC" )))
(define CoreC-45WithData-WithFC (lambda (ext-0) (vector "Libraries.Data.WithData.WithData" (cons CoreC-45WithData-FCC-39 '()) ext-0)))
(define CoreC-45WithData-NameC-39 (cons "name" (CoreC-45WithData-WithFC (vector "Core.Name.Name" ))))
(define CoreC-45WithData-RigC-39 (cons "rig" (vector "Algebra.ZeroOneOmega.ZeroOneOmega" )))
(define csegen-891(delay (cons CoreC-45WithData-RigC-39 (cons CoreC-45WithData-NameC-39 '()))))
(define CoreC-45Name-u--C-60_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 0)))
(define CoreC-45Name-u--C-62C-61_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 0)))
(define CoreC-45Name-u--C-62_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 2)))
(define CoreC-45Name-u--max_Ord_Name (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Name-u--C-62_Ord_Name arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define CoreC-45Name-u--min_Ord_Name (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Name-u--C-60_Ord_Name arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-902(delay (vector (force csegen-298) (lambda (arg-1598) (lambda (arg-1601) (CoreC-45Name-u--compare_Ord_Name arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (CoreC-45Name-u--C-60_Ord_Name arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (CoreC-45Name-u--C-62_Ord_Name arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (CoreC-45Name-u--C-60C-61_Ord_Name arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (CoreC-45Name-u--C-62C-61_Ord_Name arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (CoreC-45Name-u--max_Ord_Name arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (CoreC-45Name-u--min_Ord_Name arg-1658 arg-1661))))))
(define LibrariesC-45DataC-45SortedSet-empty (lambda (arg-1) (LibrariesC-45DataC-45SortedMap-empty arg-1)))
(define csegen-903 (LibrariesC-45DataC-45SortedSet-empty (force csegen-902)))
(define CoreC-45Value-u--show_Show_C-40ClosureC-32C-36freeC-41 (lambda (arg-1) "[closure]"))
(define CoreC-45Value-u--showPrec_Show_C-40ClosureC-32C-36freeC-41 (lambda (arg-1 arg-2) (CoreC-45Value-u--show_Show_C-40ClosureC-32C-36freeC-41 arg-2)))
(define csegen-908 (cons (lambda (u--x) (CoreC-45Value-u--show_Show_C-40ClosureC-32C-36freeC-41 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Value-u--showPrec_Show_C-40ClosureC-32C-36freeC-41 u--d u--x)))))
(define PreludeC-45Show-u--showPrec_Show_Nat (lambda (arg-0 arg-1) (PreludeC-45Show-u--show_Show_Nat arg-1)))
(define csegen-939(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Nat u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Nat u--d u--x))))))
(define CoreC-45TTC-45Term-u--showPrec_Show_NameType (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) "Bound") ((1) "Func") ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "DataCon" (string-append (PreludeC-45Show-showArg (force csegen-514) e-0) (PreludeC-45Show-showArg (force csegen-939) e-1)))))) (else (let ((e-2 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "TyCon" (PreludeC-45Show-showArg (force csegen-939) e-2)))))))
(define CoreC-45TTC-45Term-u--show_Show_NameType (lambda (arg-0) (CoreC-45TTC-45Term-u--showPrec_Show_NameType (vector 0 ) arg-0)))
(define csegen-916 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_NameType u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_NameType u--d u--x)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-comma (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\,))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\ ))
(define csegen-922 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-comma LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space) eta-0 eta-1))))
(define csegen-923 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String " -> ") eta-0 eta-1))))
(define csegen-937 (lambda (arg-3732) (lambda (arg-3735) (PreludeC-45EqOrd-u--C-47C-61_Eq_Integer (blodwen-and arg-3732 (blodwen-shl 1 arg-3735)) 0))))
(define CoreC-45TTC-45Binder-n--2804-4578-u--go (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (case (vector-ref arg-4 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-4 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-4 0) ((2) 1)(else 0))) ((3) (let ((e-4 (vector-ref arg-3 1))) (case (vector-ref arg-4 0) ((3) (let ((e-9 (vector-ref arg-4 1))) ((arg-2 e-4) e-9)))(else 0))))(else 0))))
(define CoreC-45TTC-45Binder-eqPiInfoBy (lambda (arg-2 ext-0 ext-1) (CoreC-45TTC-45Binder-n--2804-4578-u--go arg-2 ext-0 ext-1)))
(define CoreC-45TTC-45Binder-n--5561-7427-u--go (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((0) (let ((e-31 (vector-ref arg-4 2))) (let ((e-32 (vector-ref arg-4 3))) (let ((e-33 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-2 e-31))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TTC-45Binder-eqPiInfoBy arg-2 e-3 e-32))) (cond ((equal? sc3 1) ((arg-2 e-4) e-33)) (else 0)))) (else 0)))))))(else 0)))))) ((1) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((1) (let ((e-36 (vector-ref arg-4 2))) (let ((e-37 (vector-ref arg-4 3))) (let ((e-38 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-7 e-36))) (cond ((equal? sc2 1) (let ((sc3 ((arg-2 e-8) e-37))) (cond ((equal? sc3 1) ((arg-2 e-9) e-38)) (else 0)))) (else 0)))))))(else 0)))))) ((2) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((2) (let ((e-41 (vector-ref arg-4 2))) (let ((e-42 (vector-ref arg-4 3))) (let ((e-43 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-12 e-41))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TTC-45Binder-eqPiInfoBy arg-2 e-13 e-42))) (cond ((equal? sc3 1) ((arg-2 e-14) e-43)) (else 0)))) (else 0)))))))(else 0)))))) ((3) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((3) (let ((e-46 (vector-ref arg-4 2))) (let ((e-47 (vector-ref arg-4 3))) (let ((e-48 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-17 e-46))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TTC-45Binder-eqPiInfoBy arg-2 e-18 e-47))) (cond ((equal? sc3 1) ((arg-2 e-19) e-48)) (else 0)))) (else 0)))))))(else 0)))))) ((4) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((4) (let ((e-51 (vector-ref arg-4 2))) (let ((e-52 (vector-ref arg-4 3))) (let ((e-53 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-22 e-51))) (cond ((equal? sc2 1) (let ((sc3 ((arg-2 e-23) e-52))) (cond ((equal? sc3 1) ((arg-2 e-24) e-53)) (else 0)))) (else 0)))))))(else 0)))))) ((5) (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((5) (let ((e-56 (vector-ref arg-4 2))) (let ((e-57 (vector-ref arg-4 3))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-27 e-56))) (cond ((equal? sc2 1) ((arg-2 e-28) e-57)) (else 0))))))(else 0)))))(else 0))))
(define CoreC-45TTC-45Binder-eqBinderBy (lambda (arg-2 ext-0 ext-1) (CoreC-45TTC-45Binder-n--5561-7427-u--go arg-2 ext-0 ext-1)))
(define CoreC-45TTC-45Term-eqWhyErasedBy (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((1) (case (vector-ref arg-4 0) ((1) 1)(else 0))) ((0) (case (vector-ref arg-4 0) ((0) 1)(else 0))) ((2) (let ((e-3 (vector-ref arg-3 1))) (case (vector-ref arg-4 0) ((2) (let ((e-7 (vector-ref arg-4 1))) ((arg-2 e-3) e-7)))(else 0))))(else 0))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Double (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0))) ((equal? arg-0 4) (cond ((equal? arg-1 4) 1)(else 0))) ((equal? arg-0 5) (cond ((equal? arg-1 5) 1)(else 0))) ((equal? arg-0 6) (cond ((equal? arg-1 6) 1)(else 0))) ((equal? arg-0 7) (cond ((equal? arg-1 7) 1)(else 0))) ((equal? arg-0 8) (cond ((equal? arg-1 8) 1)(else 0))) ((equal? arg-0 9) (cond ((equal? arg-1 9) 1)(else 0))) ((equal? arg-0 10) (cond ((equal? arg-1 10) 1)(else 0))) ((equal? arg-0 11) (cond ((equal? arg-1 11) 1)(else 0))) ((equal? arg-0 12) (cond ((equal? arg-1 12) 1)(else 0))) ((equal? arg-0 13) (cond ((equal? arg-1 13) 1)(else 0)))(else 0))))
(define CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-14 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-0 e-14)))(else 0)))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-15 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int8 e-1 e-15)))(else 0)))) ((2) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-16 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int16 e-2 e-16)))(else 0)))) ((3) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-17 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int32 e-3 e-17)))(else 0)))) ((4) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-18 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int64 e-4 e-18)))(else 0)))) ((5) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-19 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer e-5 e-19)))(else 0)))) ((6) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-20 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits8 e-6 e-20)))(else 0)))) ((7) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-21 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits16 e-7 e-21)))(else 0)))) ((8) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-22 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits32 e-8 e-22)))(else 0)))) ((9) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-23 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits64 e-9 e-23)))(else 0)))) ((10) (let ((e-10 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((10) (let ((e-24 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-10 e-24)))(else 0)))) ((11) (let ((e-11 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((11) (let ((e-25 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char e-11 e-25)))(else 0)))) ((12) (let ((e-12 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((12) (let ((e-26 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Double e-12 e-26)))(else 0)))) ((13) (let ((e-13 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((13) (let ((e-27 (vector-ref arg-1 1))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-13 e-27)))(else 0)))) ((14) (case (vector-ref arg-1 0) ((14) 1)(else 0)))(else 0))))
(define DataC-45List-u--zipWith_Zippable_List (lambda (arg-3 arg-4 arg-5) (if (null? arg-4) '() (if (null? arg-5) '() (let ((e-1 (car arg-4))) (let ((e-2 (cdr arg-4))) (let ((e-4 (car arg-5))) (let ((e-5 (cdr arg-5))) (cons ((arg-3 e-1) e-4) (DataC-45List-u--zipWith_Zippable_List arg-3 e-2 e-5))))))))))
(define DataC-45List-u--zip_Zippable_List (lambda (ext-0 ext-1) (DataC-45List-u--zipWith_Zippable_List csegen-196 ext-0 ext-1)))
(define CoreC-45TTC-45Term-eqTerm (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-4 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((0) (let ((e-55 (vector-ref arg-3 3))) (or (and (= e-4 e-55) 1) 0)))(else 0)))) ((1) (let ((e-9 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((1) (let ((e-60 (vector-ref arg-3 3))) (CoreC-45Name-u--C-61C-61_Eq_Name e-9 e-60)))(else 0)))) ((2) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((2) (let ((e-64 (vector-ref arg-3 3))) (let ((e-65 (vector-ref arg-3 4))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-13 e-64))) (cond ((equal? sc2 1) (PreludeC-45Types-u--foldMap_Foldable_List csegen-805 (lambda (eta-0) (PreludeC-45Basics-uncurry (csegen-943) eta-0)) (DataC-45List-u--zip_Zippable_List e-14 e-65))) (else 0))))))(else 0))))) ((3) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((3) (let ((e-69 (vector-ref arg-3 3))) (let ((e-70 (vector-ref arg-3 4))) (let ((sc2 (CoreC-45TTC-45Binder-eqBinderBy (csegen-943) e-18 e-69))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-19 e-70)) (else 0))))))(else 0))))) ((4) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((4) (let ((e-73 (vector-ref arg-3 2))) (let ((e-74 (vector-ref arg-3 3))) (let ((sc2 (CoreC-45TTC-45Term-eqTerm e-22 e-73))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-23 e-74)) (else 0))))))(else 0))))) ((5) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((5) (let ((e-78 (vector-ref arg-3 3))) (let ((e-79 (vector-ref arg-3 4))) (let ((sc2 (CoreC-45TTC-45Term-eqTerm e-27 e-78))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-28 e-79)) (else 0))))))(else 0))))) ((6) (let ((e-32 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((6) (let ((e-83 (vector-ref arg-3 3))) (CoreC-45TTC-45Term-eqTerm e-32 e-83)))(else 0)))) ((7) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((7) (let ((e-87 (vector-ref arg-3 3))) (let ((e-88 (vector-ref arg-3 4))) (let ((sc2 (CoreC-45TTC-45Term-eqTerm e-36 e-87))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-37 e-88)) (else 0))))))(else 0))))) ((8) (let ((e-41 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((8) (let ((e-92 (vector-ref arg-3 3))) (CoreC-45TTC-45Term-eqTerm e-41 e-92)))(else 0)))) ((9) (let ((e-44 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((9) (let ((e-95 (vector-ref arg-3 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-44 e-95)))(else 0)))) ((10) (let ((e-47 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((10) (let ((e-98 (vector-ref arg-3 2))) (CoreC-45TTC-45Term-eqWhyErasedBy (csegen-943) e-47 e-98)))(else 0)))) ((11) (case (vector-ref arg-3 0) ((11) 1)(else 0)))(else 0))))
(define csegen-943 (lambda () (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-eqTerm eta-0 eta-1)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (lambda (ext-0 ext-1) (vector 11 ext-0 ext-1)))
(define IdrisC-45PrettyC-45Annotations-keyword (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (vector 5 ) ext-0)))
(define csegen-968 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) ";")))
(define csegen-974 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "}")))
(define csegen-981 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\0)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space))
(define csegen-984 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\1)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space))
(define csegen-990 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "{")))
(define csegen-991 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "in"))
(define csegen-1009 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "->")))
(define CoreC-45FC-u--showPrec_Show_OriginDesc (lambda (arg-0 arg-1) (CoreC-45FC-u--show_Show_OriginDesc arg-1)))
(define csegen-1011(delay (cons (lambda (u--x) (CoreC-45FC-u--show_Show_OriginDesc u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45FC-u--showPrec_Show_OriginDesc u--d u--x))))))
(define csegen-1021 (lambda (eta-0) (lambda (eta-1) (lambda (world-0) (let ((act-1 (eta-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((eta-1 e-5) world-0)))))))))
(define CoreC-45TTC-45Var-nameAt (lambda (arg-2 arg-3) (let ((e-1 (car arg-2))) (let ((e-2 (cdr arg-2))) (cond ((equal? arg-3 0) e-1)(else (let ((e-3 (- arg-3 1))) (CoreC-45TTC-45Var-nameAt e-2 e-3))))))))
(define CoreC-45TTC-45Term-withPiInfo (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((1) (string-append "(" (string-append arg-3 ")"))) ((0) (string-append "{" (string-append arg-3 "}"))) ((2) (string-append "{auto " (string-append arg-3 "}"))) (else (let ((e-4 (vector-ref arg-2 1))) (string-append "{default " (string-append (let ((e-1 (car arg-1))) (e-1 e-4)) (string-append " " (string-append arg-3 "}")))))))))
(define CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-0 arg-2)))
(define CoreC-45TTC-45Term-n--8496-7869-u--showApp (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-5 (vector-ref arg-3 3))) (if (null? arg-4) (string-append (CoreC-45Name-u--show_Show_Name (CoreC-45TTC-45Var-nameAt arg-2 e-5)) (string-append "[" (string-append (PreludeC-45Show-u--show_Show_Nat e-5) "]"))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))) ((1) (let ((e-10 (vector-ref arg-3 3))) (if (null? arg-4) (CoreC-45Name-u--show_Show_Name e-10) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))) ((2) (let ((e-13 (vector-ref arg-3 2))) (let ((e-15 (vector-ref arg-3 4))) (if (null? arg-4) (string-append "?" (string-append (CoreC-45Name-u--show_Show_Name e-13) (string-append "_" (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-15)))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")"))))))))) ((3) (let ((e-18 (vector-ref arg-3 2))) (let ((e-19 (vector-ref arg-3 3))) (let ((e-20 (vector-ref arg-3 4))) (case (vector-ref e-19 0) ((0) (let ((e-57 (vector-ref e-19 2))) (let ((e-58 (vector-ref e-19 3))) (let ((e-59 (vector-ref e-19 4))) (if (null? arg-4) (string-append "\\" (string-append (CoreC-45TTC-45Term-withPiInfo (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-58 (string-append (Algebra-showCount e-57) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-59))))) (string-append " => " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20)))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))) ((1) (let ((e-62 (vector-ref e-19 2))) (let ((e-63 (vector-ref e-19 3))) (let ((e-64 (vector-ref e-19 4))) (if (null? arg-4) (string-append "let " (string-append (Algebra-showCount e-62) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-64) (string-append " = " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-63) (string-append " in " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))))))))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))) ((2) (let ((e-67 (vector-ref e-19 2))) (let ((e-68 (vector-ref e-19 3))) (let ((e-69 (vector-ref e-19 4))) (if (null? arg-4) (string-append (CoreC-45TTC-45Term-withPiInfo (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-68 (string-append (Algebra-showCount e-67) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-69))))) (string-append " -> " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))) ((3) (let ((e-72 (vector-ref e-19 2))) (let ((e-73 (vector-ref e-19 3))) (let ((e-74 (vector-ref e-19 4))) (if (null? arg-4) (string-append (CoreC-45TTC-45Term-withPiInfo (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-73 (string-append "pat " (string-append (Algebra-showCount e-72) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-74)))))) (string-append " => " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))) ((4) (let ((e-77 (vector-ref e-19 2))) (let ((e-78 (vector-ref e-19 3))) (let ((e-79 (vector-ref e-19 4))) (if (null? arg-4) (string-append "plet " (string-append (Algebra-showCount e-77) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-79) (string-append " = " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-78) (string-append " in " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))))))))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))) ((5) (let ((e-82 (vector-ref e-19 2))) (let ((e-83 (vector-ref e-19 3))) (if (null? arg-4) (string-append "pty " (string-append (Algebra-showCount e-82) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-83) (string-append " => " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))))))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))(else (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")"))))))))))) ((4) (if (null? arg-4) "[can't happen]" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")"))))))) ((5) (let ((e-28 (vector-ref arg-3 3))) (let ((e-29 (vector-ref arg-3 4))) (if (null? arg-4) (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-28) (string-append "@" (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-29))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")"))))))))) ((6) (let ((e-33 (vector-ref arg-3 3))) (if (null? arg-4) (string-append "%Delayed " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-33)) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))) ((7) (let ((e-38 (vector-ref arg-3 4))) (if (null? arg-4) (string-append "%Delay " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-38)) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))) ((8) (let ((e-42 (vector-ref arg-3 3))) (if (null? arg-4) (string-append "%Force " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-42)) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))) ((9) (let ((e-45 (vector-ref arg-3 2))) (if (null? arg-4) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-45) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))) ((10) (let ((e-48 (vector-ref arg-3 2))) (case (vector-ref e-48 0) ((2) (let ((e-98 (vector-ref e-48 1))) (if (null? arg-4) (string-append ".(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-98) ")")) (if (null? arg-4) "[__]" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))(else (if (null? arg-4) "[__]" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))) ((11) (if (null? arg-4) "Type" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))(else (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) arg-4)) ")")))))))))
(define CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TTC-45Term-getFnArgs arg-1))) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (CoreC-45TTC-45Term-n--8496-7869-u--showApp arg-0 arg-1 arg-0 e-2 e-3))))))
(define csegen-1023(delay (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 '() u--x))))
(define PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2) (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 arg-1 (vector 0 ) arg-2)))
(define csegen-1026(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (force csegen-68) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 (force csegen-68) u--d u--x))))))
(define CoreC-45Name-displayUserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) e-0)) ((1) (let ((e-1 (vector-ref arg-0 1))) e-1)) (else "_"))))
(define CoreC-45Name-nameRoot (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (CoreC-45Name-nameRoot e-1))) ((1) (let ((e-2 (vector-ref arg-0 1))) (CoreC-45Name-displayUserName e-2))) ((2) (let ((e-3 (vector-ref arg-0 1))) e-3)) ((3) (let ((e-5 (vector-ref arg-0 1))) (CoreC-45Name-nameRoot e-5))) ((4) (let ((e-8 (vector-ref arg-0 2))) (CoreC-45Name-nameRoot e-8))) ((5) (let ((e-10 (vector-ref arg-0 2))) (CoreC-45Name-nameRoot e-10))) ((6) (let ((e-11 (vector-ref arg-0 1))) (string-append "$" (PreludeC-45Show-u--show_Show_String e-11)))) ((7) (let ((e-13 (vector-ref arg-0 1))) (string-append "$" (PreludeC-45Show-u--show_Show_String e-13)))) (else (let ((e-15 (vector-ref arg-0 1))) (string-append "$" (PreludeC-45Show-u--show_Show_Int e-15)))))))
(define CoreC-45WithData-rf--fc (lambda (arg-2 arg-3 ext-0) (LibrariesC-45DataC-45WithData-get arg-2 ext-0)))
(define PreludeC-45Show-u--showPrec_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-2 (vector-ref arg-4 1))) (PreludeC-45Show-showCon arg-3 "Left" (PreludeC-45Show-showArg (Builtin-fst arg-2) e-2)))) (else (let ((e-5 (vector-ref arg-4 1))) (PreludeC-45Show-showCon arg-3 "Right" (PreludeC-45Show-showArg (Builtin-snd arg-2) e-5)))))))
(define PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 (lambda (arg-2 arg-3) (PreludeC-45Show-u--showPrec_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 arg-2 (vector 0 ) arg-3)))
(define CoreC-45TT-u--show_Show_C-40OperatorLHSInfoC-32C-36tmC-41 (lambda (arg-2) (case (vector-ref arg-2 0) ((0) "regular") ((1) "type-binding (typebind)") ((2) "automatically-binding (autobind)") (else "automatically-binding (autobind)"))))
(define CoreC-45Core-u--show_Show_DotReason (lambda (arg-0) (cond ((equal? arg-0 0) "Non linear pattern variable") ((equal? arg-0 1) "Variable applied to arguments") ((equal? arg-0 2) "Not a constructor application or primitive") ((equal? arg-0 3) "Erased argument") ((equal? arg-0 4) "User dotted") ((equal? arg-0 5) "Unknown reason") (else "Under-applied constructor"))))
(define PrimIO-unsafeCreateWorld (lambda (arg-1) (arg-1 #f)))
(define PrimIO-unsafePerformIO (lambda (arg-1) (PrimIO-unsafeCreateWorld (lambda (u--w) (arg-1 u--w)))))
(define SystemC-45Errno-strerror (lambda (arg-0) (PrimIO-unsafePerformIO (lambda (eta-0) (SystemC-45Errno-prim__strerror arg-0 eta-0)))))
(define SystemC-45FileC-45Error-u--show_Show_FileError (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (SystemC-45Errno-strerror e-0))) ((1) "File Read Error") ((2) "File Write Error") ((3) "File Not Found") ((4) "Permission Denied") (else "File Exists"))))
(define CoreC-45TT-u--show_Show_BindingModifier (lambda (arg-0) (cond ((equal? arg-0 0) "regular") ((equal? arg-0 2) "typebind") (else "autobind"))))
(define CoreC-45TT-u--show_Show_Fixity (lambda (arg-0) (cond ((equal? arg-0 0) "infixl") ((equal? arg-0 1) "infixr") ((equal? arg-0 2) "infix") (else "prefix"))))
(define CoreC-45TT-u--show_Show_Visibility (lambda (arg-0) (cond ((equal? arg-0 0) "private") ((equal? arg-0 1) "export") (else "public export"))))
(define CoreC-45TT-u--show_Show_FixityInfo (lambda (arg-0) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (cons "fc: " (cons (CoreC-45FC-u--show_Show_FC (let ((e-0 (vector-ref arg-0 0))) e-0)) (cons ", visibility: " (cons (CoreC-45TT-u--show_Show_Visibility (let ((e-1 (vector-ref arg-0 1))) e-1)) (cons ", binding: " (cons (CoreC-45TT-u--show_Show_BindingModifier (let ((e-2 (vector-ref arg-0 2))) e-2)) (cons ", fixity: " (cons (CoreC-45TT-u--show_Show_Fixity (let ((e-3 (vector-ref arg-0 3))) e-3)) (cons ", precedence: " (cons (PreludeC-45Show-u--show_Show_Nat (let ((e-4 (vector-ref arg-0 4))) e-4)) '())))))))))))))
(define CoreC-45Core-u--show_Show_TTCErrorMsg (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (let ((u--age (let ((sc1 (PreludeC-45EqOrd-u--C-60_Ord_Int e-1 e-2))) (cond ((equal? sc1 1) "older") (else "newer"))))) (string-append "TTC data is in an " (string-append u--age (string-append " format, file: " (string-append e-0 (string-append ", expected version: " (string-append (PreludeC-45Show-u--show_Show_Int e-2) (string-append ", actual version: " (PreludeC-45Show-u--show_Show_Int e-1))))))))))))) ((1) (let ((e-3 (vector-ref arg-0 1))) (string-append "End of buffer when reading " e-3))) (else (let ((e-4 (vector-ref arg-0 1))) (string-append "Corrupt TTC data for " e-4))))))
(define CoreC-45Core-u--show_Show_Warning (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-0) e-1)))) ((1) (let ((e-3 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-3) ":Unreachable clause"))) ((2) (let ((e-6 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-6) ":Shadowing names"))) ((3) (let ((e-8 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-8) ":Incompatible Visibility"))) ((4) (let ((e-12 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-12) ":Shadowing names"))) ((5) (let ((e-14 (vector-ref arg-0 1))) (let ((e-15 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-14) (string-append ":Deprecated " e-15))))) (else (let ((e-17 (vector-ref arg-0 1))) (let ((e-18 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-17) e-18)))))))
(define CoreC-45Core-n--9797-7506-u--showRel (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (AlgebraC-45Semiring-elimSemi (force csegen-978) "irrelevant" "relevant" (lambda (eta-0) "non-linear") ext-0)))
(define CoreC-45Core-n--9797-7507-u--showRig (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (AlgebraC-45Semiring-elimSemi (force csegen-978) "irrelevant" "linear" (lambda (eta-0) "unrestricted") ext-0)))
(define csegen-1029 (lambda () (cons (force csegen-1026) (force csegen-1028))))
(define PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 arg-1 arg-3)))
(define csegen-1035 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-512) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 (force csegen-512) u--d u--x)))))
(define csegen-1036 (cons (force csegen-287) (force csegen-512)))
(define CoreC-45Core-u--show_Show_Error (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (CoreC-45Core-u--show_Show_Error e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 5))) (let ((e-6 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-2) (string-append ":Type mismatch: " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-1 e-5) (string-append " and " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-1 e-6)))))))))) ((2) (let ((e-7 (vector-ref arg-0 1))) (let ((e-8 (vector-ref arg-0 2))) (let ((e-11 (vector-ref arg-0 5))) (let ((e-12 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-8) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-7 e-11) (string-append " and " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-7 e-12) " are not equal")))))))))) ((3) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (let ((e-17 (vector-ref arg-0 5))) (let ((e-18 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-14) (string-append ":Pattern variable " (string-append (CoreC-45Name-u--show_Show_Name e-17) (string-append " unifies with " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-13 e-18)))))))))) ((4) (let ((e-19 (vector-ref arg-0 1))) (let ((e-20 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 4))) (let ((e-23 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-20) (string-append ":Cycle detected in metavariable solution " (string-append (CoreC-45Name-u--show_Show_Name e-22) (string-append " = " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-19 e-23)))))))))) ((5) (let ((e-24 (vector-ref arg-0 1))) (let ((e-25 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 5))) (let ((e-29 (vector-ref arg-0 6))) (let ((e-30 (vector-ref arg-0 7))) (string-append (CoreC-45FC-u--show_Show_FC e-25) (string-append ":When unifying: " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-24 e-28) (string-append " and " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-24 e-29) (string-append "\u000a\u0009" (CoreC-45Core-u--show_Show_Error e-30))))))))))))) ((6) (let ((e-31 (vector-ref arg-0 1))) (let ((e-32 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-32) (string-append ":" (case (vector-ref e-34 0) ((0) (let ((e-2 (vector-ref e-34 1))) (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-31 e-2) " is not a valid impossible pattern because it typechecks"))) (else (let ((e-5 (vector-ref e-34 1))) (string-append "Not a valid impossible pattern:\u000a\u0009" (CoreC-45Core-u--show_Show_Error e-5))))))))))) ((7) (let ((e-35 (vector-ref arg-0 1))) (let ((e-36 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-35) (string-append ":Undefined name " (CoreC-45Name-u--show_Show_Name e-36)))))) ((8) (let ((e-37 (vector-ref arg-0 1))) (let ((e-38 (vector-ref arg-0 2))) (let ((e-39 (vector-ref arg-0 3))) (if (null? e-39) (string-append (CoreC-45FC-u--show_Show_FC e-37) (string-append ":Name " (string-append (CoreC-45Name-u--show_Show_Name e-38) " is private"))) (let ((e-232 (unbox e-39))) (string-append (CoreC-45FC-u--show_Show_FC e-37) (string-append ":Name " (string-append (CoreC-45Name-u--show_Show_Name e-38) (string-append " is inaccessible since " (string-append (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-232) " is not explicitly imported"))))))))))) ((9) (let ((e-40 (vector-ref arg-0 1))) (let ((e-41 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-40) (string-append ":Return type of " (string-append (CoreC-45Name-u--show_Show_Name e-41) " must be Type")))))) ((10) (let ((e-42 (vector-ref arg-0 1))) (let ((e-43 (vector-ref arg-0 2))) (let ((e-44 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-42) (string-append ":Return type of " (string-append (CoreC-45Name-u--show_Show_Name e-43) (string-append " must be in " (CoreC-45Name-u--show_Show_Name e-44))))))))) ((11) (let ((e-45 (vector-ref arg-0 1))) (let ((e-46 (vector-ref arg-0 2))) (let ((e-47 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-45) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-46) (string-append " is not covering:\u000a\u0009" (case (vector-ref e-47 0) ((0) "Oh yes it is (Internal error!)") ((1) (let ((e-0 (vector-ref e-47 1))) (string-append "Missing cases:\u000a\u0009" (CoreC-45NameC-45Namespace-showSep "\u000a\u0009" (PreludeC-45TypesC-45List-mapAppend '() (force csegen-1023) e-0))))) (else (let ((e-1 (vector-ref e-47 1))) (string-append "Calls non covering function" (if (null? e-1) (string-append "s: " (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) e-1))) (let ((e-3 (car e-1))) (let ((e-2 (cdr e-1))) (if (null? e-2) (string-append " " (CoreC-45Name-u--show_Show_Name e-3)) (string-append "s: " (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) e-1))))))))))))))))))) ((12) (let ((e-48 (vector-ref arg-0 1))) (let ((e-49 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-48) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-49) " is not total")))))) ((13) (let ((e-51 (vector-ref arg-0 1))) (let ((e-52 (vector-ref arg-0 2))) (let ((e-53 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-51) (string-append ":There are " (string-append (PreludeC-45Show-u--show_Show_Nat e-52) (string-append " uses of linear name " (CoreC-45Name-u--show_Show_Name e-53))))))))) ((14) (let ((e-54 (vector-ref arg-0 1))) (let ((e-55 (vector-ref arg-0 2))) (let ((e-56 (vector-ref arg-0 3))) (let ((e-57 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-54) (string-append ":Trying to use " (string-append (CoreC-45Core-n--9797-7507-u--showRig e-57 e-56 e-55 e-54 e-56) (string-append " name " (string-append (CoreC-45Name-u--show_Show_Name e-55) (string-append " in " (string-append (CoreC-45Core-n--9797-7506-u--showRel e-57 e-56 e-55 e-54 e-57) " context")))))))))))) ((15) (let ((e-58 (vector-ref arg-0 1))) (let ((e-59 (vector-ref arg-0 2))) (let ((e-61 (vector-ref arg-0 4))) (let ((e-62 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-59) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-58 e-61) (string-append " borrows argument " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-58 e-62) " so must be fully applied")))))))))) ((16) (let ((e-63 (vector-ref arg-0 1))) (let ((e-64 (vector-ref arg-0 2))) (let ((e-66 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-64) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-63 e-66) " borrows, so must return a concrete type"))))))) ((17) (let ((e-67 (vector-ref arg-0 1))) (let ((e-68 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-67) (string-append ":Ambiguous name " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) e-68)))))) ((18) (let ((e-69 (vector-ref arg-0 1))) (let ((e-70 (vector-ref arg-0 2))) (let ((e-72 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-70) (string-append ":Ambiguous elaboration " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-69 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 e-69 u--d u--x)))) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (Builtin-snd eta-0)) e-72)))))))) ((19) (let ((e-73 (vector-ref arg-0 1))) (let ((e-74 (vector-ref arg-0 2))) (let ((e-77 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-74) (string-append ":Ambiguous search " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-73 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 e-73 u--d u--x)))) e-77))))))) ((20) (let ((e-78 (vector-ref arg-0 1))) (let ((e-79 (vector-ref arg-0 2))) (let ((e-80 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-78) (string-append ":Ambiguity too deep in " (string-append (CoreC-45Name-u--show_Show_Name e-79) (string-append " " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) e-80))))))))) ((21) (let ((e-81 (vector-ref arg-0 1))) (string-append "No successful elaboration: " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1029) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1029) u--d u--x)))) e-81)))) ((22) (let ((e-83 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-83) ":Can't infer type of record to update"))) ((23) (let ((e-85 (vector-ref arg-0 1))) (let ((e-86 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-85) (string-append ":Duplicated record update paths: " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-1035 e-86)))))) ((24) (let ((e-87 (vector-ref arg-0 1))) (let ((e-88 (vector-ref arg-0 2))) (let ((e-89 (vector-ref arg-0 3))) (if (null? e-89) (string-append (CoreC-45FC-u--show_Show_FC e-87) (string-append ":" (string-append e-88 " is not part of a record type"))) (let ((e-235 (unbox e-89))) (string-append (CoreC-45FC-u--show_Show_FC e-87) (string-append ":Record type " (string-append (CoreC-45Name-u--show_Show_Name e-235) (string-append " has no field " e-88)))))))))) ((25) (let ((e-90 (vector-ref arg-0 1))) (let ((e-91 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-90) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-91) " is not a record type")))))) ((26) (let ((e-92 (vector-ref arg-0 1))) (let ((e-93 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-92) (string-append ":Field update " (string-append (CoreC-45NameC-45Namespace-showSep "->" e-93) " not compatible with other updates")))))) ((27) (let ((e-94 (vector-ref arg-0 1))) (let ((e-95 (vector-ref arg-0 2))) (let ((e-97 (vector-ref arg-0 4))) (let ((e-98 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-95) (string-append ":" (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) e-97) (string-append " are not valid arguments in " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-94 e-98)))))))))) ((28) (let ((e-99 (vector-ref arg-0 1))) (let ((e-100 (vector-ref arg-0 2))) (let ((e-102 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-100) (string-append ":Need to bind implicits " (string-append (CoreC-45NameC-45Namespace-showSep "," (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (string-append (CoreC-45Name-u--show_Show_Name (Builtin-fst u--x)) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-99 (Builtin-snd u--x))))) e-102)) "\u000a(The front end should probably have done this for you. Please report!)"))))))) ((29) (let ((e-103 (vector-ref arg-0 1))) (let ((e-104 (vector-ref arg-0 2))) (let ((e-106 (vector-ref arg-0 4))) (let ((e-107 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-104) (string-append ":Can't bind name " (string-append (CoreC-45Name-nameRoot e-106) (string-append " with type " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-103 e-107)))))))))) ((30) (let ((e-108 (vector-ref arg-0 1))) (let ((e-109 (vector-ref arg-0 2))) (let ((e-112 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-109) (string-append ":Can't solve goal " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-108 e-112))))))) ((31) (let ((e-114 (vector-ref arg-0 1))) (let ((e-115 (vector-ref arg-0 2))) (let ((e-116 (vector-ref arg-0 3))) (let ((e-119 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-115) (string-append ":Can't solve goal " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-114 e-119) (string-append " since argument " (string-append (CoreC-45Name-u--show_Show_Name e-116) " can't be inferred")))))))))) ((32) (let ((e-120 (vector-ref arg-0 1))) (string-append "Unsolved holes " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-292) e-120)))) ((33) (let ((e-121 (vector-ref arg-0 1))) (let ((e-122 (vector-ref arg-0 2))) (let ((e-124 (vector-ref arg-0 4))) (let ((e-125 (vector-ref arg-0 5))) (let ((e-126 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-122) (string-append ":Can't infer type for " (string-append (CoreC-45Name-u--show_Show_Name e-124) (string-append " (got " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-121 e-126) (string-append " with hole " (string-append (CoreC-45Name-u--show_Show_Name e-125) ")"))))))))))))) ((34) (let ((e-128 (vector-ref arg-0 2))) (let ((e-130 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-128) (string-append ":Named hole " (string-append (CoreC-45Name-u--show_Show_Name e-130) " is solved by unification")))))) ((35) (let ((e-132 (vector-ref arg-0 1))) (let ((e-133 (vector-ref arg-0 2))) (let ((e-134 (vector-ref arg-0 3))) (let ((e-135 (vector-ref arg-0 4))) (let ((e-136 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-132) (string-append ":" (string-append (CoreC-45TT-u--show_Show_Visibility e-133) (string-append " " (string-append (CoreC-45Name-u--show_Show_Name e-134) (string-append " cannot refer to " (string-append (CoreC-45TT-u--show_Show_Visibility e-135) (string-append " " (CoreC-45Name-u--show_Show_Name e-136))))))))))))))) ((36) (let ((e-137 (vector-ref arg-0 1))) (let ((e-138 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-137) (string-append ":Non linear pattern variable " (CoreC-45Name-u--show_Show_Name e-138)))))) ((37) (let ((e-139 (vector-ref arg-0 1))) (let ((e-140 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-139) (string-append ":Pattern not allowed here: " (CoreC-45Name-u--show_Show_Name e-140)))))) ((38) (let ((e-141 (vector-ref arg-0 1))) (let ((e-142 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-141) (string-append ":No type declaration for " (CoreC-45Name-u--show_Show_Name e-142)))))) ((39) (let ((e-143 (vector-ref arg-0 1))) (let ((e-144 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-143) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-144) " is already defined")))))) ((40) (let ((e-145 (vector-ref arg-0 1))) (let ((e-146 (vector-ref arg-0 2))) (let ((e-148 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-146) (string-append ":Not a function type: " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-145 e-148))))))) ((41) (let ((e-149 (vector-ref arg-0 1))) (let ((e-150 (vector-ref arg-0 2))) (let ((e-152 (vector-ref arg-0 4))) (let ((e-153 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-150) (string-append ":Rewriting by " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-149 e-152) (string-append " did not change type " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-149 e-153)))))))))) ((42) (let ((e-154 (vector-ref arg-0 1))) (let ((e-155 (vector-ref arg-0 2))) (let ((e-157 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-155) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-154 e-157) " is not a rewrite rule type"))))))) ((43) (let ((e-158 (vector-ref arg-0 1))) (let ((e-159 (vector-ref arg-0 2))) (let ((e-160 (vector-ref arg-0 3))) (case (vector-ref e-160 0) ((0) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Patterns for " (string-append (CoreC-45Name-u--show_Show_Name e-159) " have different numbers of arguments")))) ((1) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Patterns for " (string-append (CoreC-45Name-u--show_Show_Name e-159) " require matching on different types")))) ((4) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Can't infer type to match in " (CoreC-45Name-u--show_Show_Name e-159)))) ((2) (let ((e-236 (vector-ref e-160 1))) (let ((e-240 (car e-236))) (let ((e-241 (cdr e-236))) (let ((e-245 (cdr e-241))) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Attempt to match on erased argument " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-240 e-245) (string-append " in " (CoreC-45Name-u--show_Show_Name e-159)))))))))) (else (let ((e-237 (vector-ref e-160 1))) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Constructor " (string-append (CoreC-45Name-u--show_Show_Name e-237) " is not fully applied")))))))))) ((44) (let ((e-161 (vector-ref arg-0 1))) (let ((e-162 (vector-ref arg-0 2))) (let ((e-164 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-162) (string-append ":Can't match on " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-161 e-164) " as it is has a polymorphic type"))))))) ((45) (let ((e-165 (vector-ref arg-0 1))) (let ((e-166 (vector-ref arg-0 2))) (let ((e-168 (vector-ref arg-0 4))) (let ((e-169 (vector-ref arg-0 5))) (let ((e-170 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-166) (string-append ":Can't match on " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-165 e-169) (string-append " (" (string-append (CoreC-45Core-u--show_Show_DotReason e-168) (string-append ")" (string-append " - it elaborates to " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-165 e-170)))))))))))))) ((46) (let ((e-171 (vector-ref arg-0 1))) (let ((e-172 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-171) (string-append ":" (string-append e-172 " can't be bound here")))))) ((47) (let ((e-173 (vector-ref arg-0 1))) (let ((e-174 (vector-ref arg-0 2))) (let ((e-176 (vector-ref arg-0 4))) (let ((e-177 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-174) (string-append ":Bad elaborator script " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-173 e-176) (string-append " (" (string-append e-177 ")")))))))))) ((48) (let ((e-178 (vector-ref arg-0 1))) (string-append "Error during reflection: " (CoreC-45Core-u--show_Show_Error e-178)))) ((49) (let ((e-179 (vector-ref arg-0 1))) (let ((e-180 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-179) (string-append ":" e-180))))) ((50) (let ((e-181 (vector-ref arg-0 1))) (let ((e-182 (vector-ref arg-0 2))) (let ((e-183 (vector-ref arg-0 3))) (let ((e-184 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-181) (string-append ":" (string-append e-182 (string-append (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (cons " " (cons e-183 (cons ": " '())))) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-512) e-184)))))))))) ((52) (let ((e-185 (vector-ref arg-0 1))) (string-append "Error in TTC file: " (CoreC-45Core-u--show_Show_TTCErrorMsg e-185)))) ((53) (let ((e-186 (vector-ref arg-0 1))) (let ((e-187 (vector-ref arg-0 2))) (string-append "File error (" (string-append e-186 (string-append "): " (SystemC-45FileC-45Error-u--show_Show_FileError e-187))))))) ((54) (let ((e-188 (vector-ref arg-0 1))) (string-append "Can't find package " e-188))) ((55) "Implicit lazy functions are not yet supported") ((56) "Defining lazy functions via pattern matching is not yet supported") ((57) (let ((e-191 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-191) ":Can't parse literate"))) ((58) (let ((e-192 (vector-ref arg-0 1))) (let ((e-193 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-192) (string-append ":Lexer error (" (string-append (PreludeC-45Show-u--show_Show_String e-193) ")")))))) ((59) (let ((e-194 (vector-ref arg-0 1))) (string-append "Parse errors (" (string-append (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1036 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1036 u--d u--x)))) e-194) ")")))) ((60) (let ((e-195 (vector-ref arg-0 1))) (let ((e-196 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-195) (string-append ":" (string-append (CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent e-196) " not found")))))) ((61) (let ((e-197 (vector-ref arg-0 1))) (string-append "Module imports form a cycle: " (CoreC-45NameC-45Namespace-showSep " -> " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent eta-0)) e-197))))) ((62) "Internal error when resolving implicit laziness") ((63) (let ((e-198 (vector-ref arg-0 1))) (string-append "INTERNAL ERROR: " e-198))) ((64) (let ((e-199 (vector-ref arg-0 1))) (string-append "Error: " e-199))) ((65) (let ((e-200 (vector-ref arg-0 1))) (let ((e-201 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-200) (string-append ":The given specifier " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-512) e-201) " was not accepted by any available backend.")))))) ((66) (let ((e-203 (vector-ref arg-0 2))) (string-append "Invalid multiline string: " e-203))) ((67) (let ((e-204 (vector-ref arg-0 1))) (string-append "Timeout in " e-204))) ((68) "Failing block did not fail") ((69) (let ((e-206 (vector-ref arg-0 1))) (let ((e-207 (vector-ref arg-0 2))) (let ((e-208 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-206) (string-append ":Failing block failed with the wrong error:\u000a" (string-append "Expected: " (string-append e-207 (string-append "\u000a" (string-append "but got: " (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 (force csegen-1028) e-208))))))))))) ((70) (let ((e-209 (vector-ref arg-0 1))) (let ((e-210 (vector-ref arg-0 2))) (let ((e-211 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-209) (string-append ":When elaborating type of " (string-append (CoreC-45Name-u--show_Show_Name e-210) (string-append ":\u000a" (CoreC-45Core-u--show_Show_Error e-211))))))))) ((71) (let ((e-212 (vector-ref arg-0 1))) (let ((e-213 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC (CoreC-45WithData-rf--fc 0 'erased e-212)) (string-append ":When elaborating type of constructor " (string-append (CoreC-45Name-u--show_Show_Name (let ((e-3 (cdr e-212))) e-3)) (string-append ":\u000a" (CoreC-45Core-u--show_Show_Error e-213)))))))) ((72) (let ((e-214 (vector-ref arg-0 1))) (let ((e-215 (vector-ref arg-0 2))) (let ((e-216 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-214) (string-append ":When elaborating left hand side of " (string-append (CoreC-45Name-u--show_Show_Name e-215) (string-append ":\u000a" (CoreC-45Core-u--show_Show_Error e-216))))))))) ((73) (let ((e-217 (vector-ref arg-0 1))) (let ((e-218 (vector-ref arg-0 2))) (let ((e-219 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-217) (string-append ":When elaborating right hand side of " (string-append (CoreC-45Name-u--show_Show_Name e-218) (string-append ":\u000a" (CoreC-45Core-u--show_Show_Error e-219))))))))) ((74) (let ((e-220 (vector-ref arg-0 1))) (let ((e-221 (vector-ref arg-0 2))) (string-append (CoreC-45Core-u--show_Show_Error e-220) (string-append "\u000aDid you mean" (if (null? e-221) (string-append " any of: " (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Show-u--show_Show_String eta-0)) e-221)) "?")) (let ((e-1 (car e-221))) (let ((e-2 (cdr e-221))) (if (null? e-2) (string-append ": " (string-append e-1 "?")) (string-append " any of: " (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Show-u--show_Show_String eta-0)) e-221)) "?"))))))))))) ((75) (let ((e-222 (vector-ref arg-0 1))) (CoreC-45Core-u--show_Show_Warning e-222))) (else (let ((e-225 (vector-ref arg-0 3))) (let ((e-226 (vector-ref arg-0 4))) (let ((e-227 (vector-ref arg-0 5))) (let ((e-228 (vector-ref arg-0 6))) (if (null? e-226) (string-append (CoreC-45FC-u--show_Show_FC e-225) (string-append ": Operator " (string-append (PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 (force csegen-87) e-228) (string-append " has no declared fixity" (string-append " but used as a " (string-append (CoreC-45TT-u--show_Show_C-40OperatorLHSInfoC-32C-36tmC-41 e-227) " operator")))))) (let ((e-246 (unbox e-226))) (string-append (CoreC-45FC-u--show_Show_FC e-225) (string-append ": Operator " (string-append (PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 (force csegen-87) e-228) (string-append " is " (string-append (CoreC-45TT-u--show_Show_FixityInfo e-246) (string-append " but used as a " (string-append (CoreC-45TT-u--show_Show_C-40OperatorLHSInfoC-32C-36tmC-41 e-227) " operator")))))))))))))))))
(define CoreC-45Core-u--showPrec_Show_Error (lambda (arg-0 arg-1) (CoreC-45Core-u--show_Show_Error arg-1)))
(define csegen-1028(delay (cons (lambda (u--x) (CoreC-45Core-u--show_Show_Error u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Core-u--showPrec_Show_Error u--d u--x))))))
(define csegen-1041 (lambda (eta-0) (vector 1 (force csegen-108))))
(define CoreC-45CoreC-45Functor-u--map_Functor_CORECore (lambda (ext-2 ext-1 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (ext-2 e-5)))))) ext-1 ext-0)))
(define csegen-1044 (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8920) (lambda (eta-0) (CoreC-45CoreC-45Functor-u--map_Functor_CORECore u--func arg-8920 eta-0)))))))
(define CoreC-45CoreC-45Applicative-u--C-60C-42C-62_Applicative_CORECore (lambda (ext-2 ext-1 ext-0) (CoreC-45Core-C-60C-42C-62 ext-2 ext-1 ext-0)))
(define CoreC-45CoreC-45Applicative-u--pure_Applicative_CORECore (lambda (ext-0 ext-1) (vector 1 ext-0)))
(define csegen-1050 (vector csegen-1044 (lambda (u--a) (lambda (arg-9959) (lambda (eta-0) (CoreC-45CoreC-45Applicative-u--pure_Applicative_CORECore arg-9959 eta-0)))) (lambda (u--b) (lambda (u--a) (lambda (arg-9965) (lambda (arg-9972) (lambda (eta-0) (CoreC-45CoreC-45Applicative-u--C-60C-42C-62_Applicative_CORECore arg-9965 arg-9972 eta-0))))))))
(define CoreC-45CoreC-45Monad-u--C-62C-62C-61_Monad_CORECore (lambda (ext-2 ext-1 ext-0) (let ((act-1 (ext-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((ext-1 e-5) ext-0)))))))
(define CoreC-45CoreC-45Monad-u--join_Monad_CORECore (lambda (arg-1 ext-0) (let ((act-1 (arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (e-5 ext-0)))))))
(define csegen-1056 (vector csegen-1050 (lambda (u--b) (lambda (u--a) (lambda (arg-10444) (lambda (arg-10447) (lambda (eta-0) (CoreC-45CoreC-45Monad-u--C-62C-62C-61_Monad_CORECore arg-10444 arg-10447 eta-0)))))) (lambda (u--a) (lambda (arg-10458) (lambda (eta-0) (CoreC-45CoreC-45Monad-u--join_Monad_CORECore arg-10458 eta-0))))))
(define csegen-1057 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (lambda (eta-1) (cons e-5 eta-1))))))))
(define csegen-1060 (lambda (eta-0) (cons CoreC-45FC-emptyFC (Builtin-snd eta-0))))
(define AlgebraC-45SizeChange-u--show_Show_SizeChange (lambda (arg-0) (cond ((equal? arg-0 0) "Smaller") ((equal? arg-0 1) "Same") (else "Unknown"))))
(define AlgebraC-45SizeChange-u--showPrec_Show_SizeChange (lambda (arg-0 arg-1) (AlgebraC-45SizeChange-u--show_Show_SizeChange arg-1)))
(define csegen-1072 (cons (force csegen-939) (cons (lambda (u--x) (AlgebraC-45SizeChange-u--show_Show_SizeChange u--x)) (lambda (u--d) (lambda (u--x) (AlgebraC-45SizeChange-u--showPrec_Show_SizeChange u--d u--x))))))
(define csegen-1075 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1072 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1072 u--d u--x)))))
(define DataC-45List1-u--showPrec_Show_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 arg-1 arg-3)))
(define csegen-1079 (cons (force csegen-939) (cons (lambda (u--x) (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 csegen-1075 u--x)) (lambda (u--d) (lambda (u--x) (DataC-45List1-u--showPrec_Show_C-40List1C-32C-36aC-41 csegen-1075 u--d u--x))))))
(define PreludeC-45Show-u--showPrec_Show_Bool (lambda (arg-0 arg-1) (PreludeC-45Show-u--show_Show_Bool arg-1)))
(define csegen-1084(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Bool u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Bool u--d u--x))))))
(define csegen-1085(delay (cons (force csegen-1084) (force csegen-939))))
(define LibrariesC-45DataC-45NatSet-n--5096-1422-u--go (lambda (arg-0 arg-1) (cond ((equal? arg-1 0) '())(else (let ((u--is (LibrariesC-45DataC-45NatSet-n--5096-1422-u--go (+ arg-0 1) (blodwen-shr arg-1 1)))) (let ((sc0 (PreludeC-45Basics-flip csegen-937 0 arg-1))) (cond ((equal? sc0 1) (cons arg-0 u--is)) (else u--is))))))))
(define LibrariesC-45DataC-45NatSet-toList (lambda (ext-0) (LibrariesC-45DataC-45NatSet-n--5096-1422-u--go 0 ext-0)))
(define LibrariesC-45DataC-45NatSet-u--show_Show_NatSet (lambda (arg-0) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-939) (LibrariesC-45DataC-45NatSet-toList arg-0))))
(define LibrariesC-45DataC-45NatSet-u--showPrec_Show_NatSet (lambda (arg-0 arg-1) (LibrariesC-45DataC-45NatSet-u--show_Show_NatSet arg-1)))
(define csegen-1091(delay (cons (lambda (u--x) (LibrariesC-45DataC-45NatSet-u--show_Show_NatSet u--x)) (lambda (u--d) (lambda (u--x) (LibrariesC-45DataC-45NatSet-u--showPrec_Show_NatSet u--d u--x))))))
(define PreludeC-45Types-u--C-47C-61_Eq_Nat (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1094 (cons (lambda (arg-712) (lambda (arg-715) (or (and (= arg-712 arg-715) 1) 0))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45Types-u--C-47C-61_Eq_Nat arg-722 arg-725)))))
(define AlgebraC-45SizeChange-u--C-61C-61_Eq_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define AlgebraC-45SizeChange-u--C-47C-61_Eq_SizeChange (lambda (arg-0 arg-1) (let ((sc0 (AlgebraC-45SizeChange-u--C-61C-61_Eq_SizeChange arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1097 (cons (lambda (arg-712) (lambda (arg-715) (AlgebraC-45SizeChange-u--C-61C-61_Eq_SizeChange arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (AlgebraC-45SizeChange-u--C-47C-61_Eq_SizeChange arg-722 arg-725)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1100 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1094 csegen-1097 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1094 csegen-1097 arg-722 arg-725)))))
(define DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((e-1 (car arg-2))) (let ((e-2 (cdr arg-2))) (let ((e-4 (car arg-3))) (let ((e-5 (cdr arg-3))) (let ((sc2 (let ((e-6 (car arg-1))) ((e-6 e-1) e-4)))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 arg-1 e-2 e-5)) (else 0)))))))))
(define DataC-45List1-u--C-47C-61_Eq_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1103 (cons (lambda (arg-712) (lambda (arg-715) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 csegen-1100 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (DataC-45List1-u--C-47C-61_Eq_C-40List1C-32C-36aC-41 csegen-1100 arg-722 arg-725)))))
(define csegen-1106 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1094 csegen-1103 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1094 csegen-1103 arg-722 arg-725)))))
(define csegen-1110(delay (lambda (eta-0) (PreludeC-45TypesC-45String-length (PreludeC-45Show-u--show_Show_Nat eta-0)))))
(define PreludeC-45Types-u--C-62_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 2)))
(define PreludeC-45Types-u--max_Ord_Nat (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45Types-u--C-62_Ord_Nat arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-1111 (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45Types-u--max_Ord_Nat arg-1648 arg-1651))))
(define csegen-1117 (vector csegen-113 csegen-114 (lambda (arg-5947) arg-5947)))
(define csegen-1121 (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45EqOrd-u--compare_Ord_Integer arg-1598 arg-1601))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (<= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (> arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--max_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_Integer arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--min_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-1128 (vector csegen-750 csegen-1121 (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45EqOrd-u--C-62_Ord_Integer arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45EqOrd-u--C-60C-61_Ord_Integer arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45EqOrd-u--max_Ord_Integer arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45EqOrd-u--min_Ord_Integer arg-1658 arg-1661)))))
(define csegen-1130 (vector csegen-1117 (lambda (arg-6042) (- 0 arg-6042)) (lambda (arg-6048) (lambda (arg-6051) (- arg-6048 arg-6051)))))
(define PreludeC-45Num-u--div_Integral_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-1 0))) (cond ((equal? sc0 0) (blodwen-euclidDiv arg-0 arg-1))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in div at Prelude.Num:91:3--93:44")))))))
(define PreludeC-45Num-u--mod_Integral_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-1 0))) (cond ((equal? sc0 0) (blodwen-euclidMod arg-0 arg-1))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in mod at Prelude.Num:94:3--96:44")))))))
(define csegen-1132 (cons (vector csegen-1117 (lambda (arg-6342) (lambda (arg-6345) (PreludeC-45Num-u--div_Integral_Integer arg-6342 arg-6345))) (lambda (arg-6352) (lambda (arg-6355) (PreludeC-45Num-u--mod_Integral_Integer arg-6352 arg-6355)))) (cons csegen-1128 csegen-1130)))
(define csegen-1141 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 #\:)))
(define csegen-1304(delay (lambda (u--n) (string-append " (newtype by " (string-append (PreludeC-45Show-u--show_Show_Nat u--n) ")")))))
(define CoreC-45CompileExpr-u--show_Show_CFType (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "Unit") ((1) "Int") ((2) "Integer") ((3) "Int_8") ((4) "Int_16") ((5) "Int_32") ((6) "Int_64") ((7) "Bits_8") ((8) "Bits_16") ((9) "Bits_32") ((10) "Bits_64") ((11) "String") ((12) "Double") ((13) "Char") ((14) "Ptr") ((15) "GCPtr") ((16) "Buffer") ((17) "ForeignObj") ((18) "%World") ((19) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (string-append (CoreC-45CompileExpr-u--show_Show_CFType e-0) (string-append " -> " (CoreC-45CompileExpr-u--show_Show_CFType e-1)))))) ((20) (let ((e-2 (vector-ref arg-0 1))) (string-append "IORes " (CoreC-45CompileExpr-u--show_Show_CFType e-2)))) ((21) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (string-append "struct " (string-append (PreludeC-45Show-u--show_Show_String e-3) (string-append " " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (force csegen-512) (csegen-1306)) u--x)) e-4)))))))) (else (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (string-append (CoreC-45Name-u--show_Show_Name e-5) (string-append " " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_CFType u--x)) e-6))))))))))
(define CoreC-45CompileExpr-u--showPrec_Show_CFType (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_CFType arg-1)))
(define csegen-1306 (lambda () (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_CFType u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_CFType u--d u--x))))))
(define CoreC-45CompileExpr-u--show_Show_ConInfo (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "[datacon]") ((1) "[tycon]") ((2) "[nil]") ((3) "[cons]") ((4) (let ((e-0 (vector-ref arg-0 1))) (string-append "[enum " (string-append (PreludeC-45Show-u--show_Show_Nat e-0) "]")))) ((5) "[nothing]") ((6) "[just]") ((7) "[record]") ((8) "[zero]") ((9) "[succ]") (else "[unit]"))))
(define CoreC-45CompileExpr-n--7763-2324-u--showFlag (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) "")(else (string-append (CoreC-45CompileExpr-u--show_Show_ConInfo arg-5) " ")))))
(define CoreC-45CompileExpr-u--show_Show_NamedConAlt (lambda (arg-0) (let ((e-0 (vector-ref arg-0 0))) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (let ((e-3 (vector-ref arg-0 3))) (let ((e-4 (vector-ref arg-0 4))) (string-append "(%concase " (string-append (CoreC-45CompileExpr-n--7763-2324-u--showFlag e-4 e-3 e-2 e-1 e-0 e-1) (string-append (CoreC-45Name-u--show_Show_Name e-0) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (force csegen-514) e-2) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) e-3) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-4) ")"))))))))))))))))
(define CoreC-45CompileExpr-u--showPrec_Show_NamedConAlt (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_NamedConAlt arg-1)))
(define CoreC-45CompileExpr-u--show_Show_NamedConstAlt (lambda (arg-0) (let ((e-0 (car arg-0))) (let ((e-1 (cdr arg-0))) (string-append "(%constcase " (string-append (CoreC-45TTC-45Primitive-u--show_Show_Constant e-0) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-1) ")"))))))))
(define CoreC-45CompileExpr-u--showPrec_Show_NamedConstAlt (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_NamedConstAlt arg-1)))
(define DataC-45Vect-u--show_Show_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (lambda (arg-2 ext-0) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 arg-2 (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 ext-0))))
(define CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 (lambda (arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (string-append "+" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-0)))) ((1) (let ((e-1 (vector-ref arg-1 1))) (string-append "-" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-1)))) ((2) (let ((e-2 (vector-ref arg-1 1))) (string-append "*" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-2)))) ((3) (let ((e-3 (vector-ref arg-1 1))) (string-append "/" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-3)))) ((4) (let ((e-4 (vector-ref arg-1 1))) (string-append "%" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-4)))) ((5) (let ((e-5 (vector-ref arg-1 1))) (string-append "neg " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-5)))) ((6) (let ((e-6 (vector-ref arg-1 1))) (string-append "shl " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-6)))) ((7) (let ((e-7 (vector-ref arg-1 1))) (string-append "shr " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-7)))) ((8) (let ((e-8 (vector-ref arg-1 1))) (string-append "and " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-8)))) ((9) (let ((e-9 (vector-ref arg-1 1))) (string-append "or " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-9)))) ((10) (let ((e-10 (vector-ref arg-1 1))) (string-append "xor " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-10)))) ((11) (let ((e-11 (vector-ref arg-1 1))) (string-append "<" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-11)))) ((12) (let ((e-12 (vector-ref arg-1 1))) (string-append "<=" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-12)))) ((13) (let ((e-13 (vector-ref arg-1 1))) (string-append "==" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-13)))) ((14) (let ((e-14 (vector-ref arg-1 1))) (string-append ">=" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-14)))) ((15) (let ((e-15 (vector-ref arg-1 1))) (string-append ">" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-15)))) ((16) "op_strlen") ((17) "op_strhead") ((18) "op_strtail") ((19) "op_strindex") ((20) "op_strcons") ((21) "++") ((22) "op_strrev") ((23) "op_strsubstr") ((24) "op_doubleExp") ((25) "op_doubleLog") ((26) "op_doublePow") ((27) "op_doubleSin") ((28) "op_doubleCos") ((29) "op_doubleTan") ((30) "op_doubleASin") ((31) "op_doubleACos") ((32) "op_doubleATan") ((33) "op_doubleSqrt") ((34) "op_doubleFloor") ((35) "op_doubleCeiling") ((36) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (string-append "cast-" (string-append (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-16) (string-append "-" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-17))))))) ((37) "believe_me") (else "crash"))))
(define CoreC-45TTC-45Term-u--show_Show_LazyReason (lambda (arg-0) (cond ((equal? arg-0 0) "Inf") ((equal? arg-0 1) "Lazy") (else "Unkown"))))
(define CoreC-45CompileExpr-n--7435-2090-u--showFlag (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) "")(else (string-append (CoreC-45CompileExpr-u--show_Show_ConInfo arg-5) " ")))))
(define CoreC-45CompileExpr-u--show_Show_NamedCExp (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (string-append "!" (CoreC-45Name-u--show_Show_Name e-1)))) ((1) (let ((e-3 (vector-ref arg-0 2))) (CoreC-45Name-u--show_Show_Name e-3))) ((2) (let ((e-5 (vector-ref arg-0 2))) (let ((e-6 (vector-ref arg-0 3))) (string-append "(%lam " (string-append (CoreC-45Name-u--show_Show_Name e-5) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-6) ")"))))))) ((3) (let ((e-8 (vector-ref arg-0 2))) (let ((e-9 (vector-ref arg-0 3))) (let ((e-10 (vector-ref arg-0 4))) (string-append "(%let " (string-append (CoreC-45Name-u--show_Show_Name e-8) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-9) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-10) ")")))))))))) ((4) (let ((e-12 (vector-ref arg-0 2))) (let ((e-13 (vector-ref arg-0 3))) (string-append "(" (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-12) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1308) e-13) ")"))))))) ((5) (let ((e-14 (vector-ref arg-0 1))) (let ((e-15 (vector-ref arg-0 2))) (let ((e-16 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 4))) (let ((e-18 (vector-ref arg-0 5))) (string-append "(%con " (string-append (CoreC-45CompileExpr-n--7435-2090-u--showFlag e-14 e-18 e-17 e-16 e-15 e-16) (string-append (CoreC-45Name-u--show_Show_Name e-15) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (force csegen-514) e-17) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1308) e-18) ")"))))))))))))) ((6) (let ((e-21 (vector-ref arg-0 3))) (let ((e-22 (vector-ref arg-0 4))) (string-append "(" (string-append (CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 e-21) (string-append " " (string-append (DataC-45Vect-u--show_Show_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (csegen-1308) e-22) ")"))))))) ((7) (let ((e-24 (vector-ref arg-0 2))) (let ((e-25 (vector-ref arg-0 3))) (string-append "(%extern " (string-append (CoreC-45Name-u--show_Show_Name e-24) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1308) e-25) ")"))))))) ((8) (let ((e-27 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 3))) (string-append "(%force " (string-append (CoreC-45TTC-45Term-u--show_Show_LazyReason e-27) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-28) ")"))))))) ((9) (let ((e-30 (vector-ref arg-0 2))) (let ((e-31 (vector-ref arg-0 3))) (string-append "(%delay " (string-append (CoreC-45TTC-45Term-u--show_Show_LazyReason e-30) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-31) ")"))))))) ((10) (let ((e-33 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 3))) (let ((e-35 (vector-ref arg-0 4))) (string-append "(%case " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-33) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_NamedConAlt u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_NamedConAlt u--d u--x)))) e-34) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1308) e-35) ")")))))))))) ((11) (let ((e-37 (vector-ref arg-0 2))) (let ((e-38 (vector-ref arg-0 3))) (let ((e-39 (vector-ref arg-0 4))) (string-append "(%case " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-37) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_NamedConstAlt u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_NamedConstAlt u--d u--x)))) e-38) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1308) e-39) ")")))))))))) ((12) (let ((e-41 (vector-ref arg-0 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-41))) ((13) "___") (else (let ((e-44 (vector-ref arg-0 2))) (string-append "(CRASH " (string-append (PreludeC-45Show-u--show_Show_String e-44) ")")))))))
(define CoreC-45CompileExpr-u--showPrec_Show_NamedCExp (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_NamedCExp arg-1)))
(define csegen-1308 (lambda () (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_NamedCExp u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_NamedCExp u--d u--x))))))
(define CoreC-45CaseC-45CaseTree-u--show_Show_Pat (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (string-append (CoreC-45Name-u--show_Show_Name e-1) (string-append "@(" (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-2) ")")))))) ((1) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (let ((e-7 (vector-ref arg-0 5))) (string-append (CoreC-45Name-u--show_Show_Name e-4) (string-append " " (string-append (PreludeC-45Show-u--show_Show_Int e-5) (string-append " " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-1322) e-7))))))))) ((2) (let ((e-9 (vector-ref arg-0 2))) (let ((e-11 (vector-ref arg-0 4))) (string-append "<TyCon>" (string-append (CoreC-45Name-u--show_Show_Name e-9) (string-append " " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-1322) e-11))))))) ((3) (let ((e-13 (vector-ref arg-0 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-13))) ((4) (let ((e-16 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 4))) (string-append "(" (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-16) (string-append " -> " (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-17) ")"))))))) ((5) (let ((e-21 (vector-ref arg-0 4))) (string-append "(Delay " (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-21) ")")))) ((6) (let ((e-23 (vector-ref arg-0 2))) (CoreC-45Name-u--show_Show_Name e-23))) (else (let ((e-25 (vector-ref arg-0 2))) (string-append ".(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 '() e-25) ")")))))))
(define CoreC-45CaseC-45CaseTree-u--showPrec_Show_Pat (lambda (arg-0 arg-1) (CoreC-45CaseC-45CaseTree-u--show_Show_Pat arg-1)))
(define csegen-1322(delay (cons (lambda (u--x) (CoreC-45CaseC-45CaseTree-u--show_Show_Pat u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CaseC-45CaseTree-u--showPrec_Show_Pat u--d u--x))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-enclose (lambda (arg-1 arg-2 arg-3) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 arg-1 arg-3) arg-2)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lbrace (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\{))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rbrace (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\}))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-braces (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-enclose LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lbrace LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rbrace ext-0)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow (lambda (arg-2 ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-727) (let ((e-1 (car arg-2))) (e-1 ext-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\:))
(define DataC-45Maybe-fromMaybe (lambda (arg-1 arg-2) (if (null? arg-2) (arg-1) (let ((e-2 (unbox arg-2))) e-2))))
(define PreludeC-45Interfaces-guard (lambda (arg-1 arg-2) (cond ((equal? arg-2 1) (let ((e-1 (vector-ref arg-1 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) 'erased)))) (else (let ((e-2 (vector-ref arg-1 1))) (e-2 'erased))))))
(define PreludeC-45Types-strUncons (lambda (arg-0) (cond ((equal? arg-0 "") '())(else (box (cons (string-ref arg-0 0) (substring arg-0 1 (string-length arg-0))))))))
(define CoreC-45Name-isOpUserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (DataC-45Maybe-fromMaybe (lambda () 0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (Builtin-fst eta-0)) (PreludeC-45Types-strUncons e-0)) (lambda (u--c) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (PreludeC-45Interfaces-guard (force csegen-270) (CoreC-45Name-isOpChar u--c)) (lambda (_-10685) (box 1)))))))) ((1) 0) (else 0))))
(define CoreC-45Name-isPrettyOp (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (case (vector-ref e-0 0) ((1) arg-0) ((0) (CoreC-45Name-isOpUserName e-0))(else 0)))) ((4) (let ((e-1 (vector-ref arg-1 1))) (CoreC-45Name-isOpUserName (vector 0 e-1))))(else 0))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lparen (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\())
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rparen (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-706 #\)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-enclose LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lparen LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rparen ext-0)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (lambda (arg-1 ext-0) (cond ((equal? arg-1 1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens ext-0)) (else ext-0))))
(define CoreC-45Name-prettyOp (lambda (arg-0 arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (CoreC-45Name-isPrettyOp arg-0 arg-1) (CoreC-45Name-u--pretty_Pretty_Void_Name arg-1))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-softline (vector 7 (lambda () (vector 1 #\ )) (lambda () (vector 3 ))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-fillSep (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith (lambda (u--x) (lambda (u--y) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 u--x LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-softline) u--y))) ext-0)))
(define DataC-45List-dropWhile (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((sc1 (arg-1 e-2))) (cond ((equal? sc1 1) (DataC-45List-dropWhile arg-1 e-3)) (else (cons e-2 e-3)))))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-case--wordsC-44helper-5183 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) '() (let ((sc1 (DataC-45List-break (lambda (eta-0) (PreludeC-45Types-isSpace eta-0)) arg-3))) (let ((e-2 (car sc1))) (let ((e-3 (cdr sc1))) (cons e-2 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-n--3793-5171-u--helper arg-1 e-3))))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-n--3793-5171-u--helper (lambda (arg-1 arg-2) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-case--wordsC-44helper-5183 arg-1 arg-2 (DataC-45List-dropWhile (lambda (eta-0) (PreludeC-45Types-isSpace eta-0)) arg-2))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-words (lambda (arg-1) (PreludeC-45TypesC-45List-mapAppend '() (force csegen-779) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-n--3793-5171-u--helper arg-1 (PreludeC-45Types-fastUnpack arg-1))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-reflow (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-fillSep (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-words ext-0))))
(define CoreC-45NameC-45Namespace-u--pretty_Pretty_Void_Namespace (lambda (arg-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith csegen-535 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String eta-0)) (PreludeC-45TypesC-45List-reverse arg-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--fromString_FromString_C-40DocC-32C-36annC-41 (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-727) ext-0)))
(define CoreC-45Name-u--pretty_Pretty_Void_UserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--fromString_FromString_C-40DocC-32C-36annC-41 ".") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-1)))) (else (force csegen-519)))))
(define CoreC-45Name-u--pretty_Pretty_Void_Name (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (CoreC-45NameC-45Namespace-u--pretty_Pretty_Void_Namespace e-0) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-dot) (CoreC-45Name-prettyOp 1 e-1))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (CoreC-45Name-u--pretty_Pretty_Void_UserName e-2))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-braces (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-3) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow (force csegen-514) e-4)))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-braces (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char #\P) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (CoreC-45Name-u--pretty_Pretty_Void_Name e-5)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow (force csegen-514) e-6)))))) ((4) (let ((e-7 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-7))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (let ((e-18 (car e-9))) (let ((e-19 (cdr e-9))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow (force csegen-514) e-18) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow (force csegen-514) e-19)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (CoreC-45Name-u--pretty_Pretty_Void_Name e-10))))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-reflow "case block in") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-11)))) ((7) (let ((e-13 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-reflow "with block in") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-13)))) (else (let ((e-15 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String "$resolved") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String (PreludeC-45Show-u--show_Show_Int e-15))))))))
(define CoreC-45Name-u--prettyPrec_Pretty_Void_Name (lambda (arg-0 arg-1) (CoreC-45Name-u--pretty_Pretty_Void_Name arg-1)))
(define csegen-1324 (cons (lambda (arg-11249) (CoreC-45Name-u--pretty_Pretty_Void_Name arg-11249)) (lambda (arg-11255) (lambda (arg-11258) (CoreC-45Name-u--prettyPrec_Pretty_Void_Name arg-11255 arg-11258)))))
(define csegen-1325 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "@"))
(define IdrisC-45PrettyC-45Annotations-arrow csegen-1009)
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-hsep (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith csegen-741 ext-0)))
(define PreludeC-45Show-u--C-62_Ord_Prec (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45Show-u--compare_Ord_Prec arg-0 arg-1) 2)))
(define CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_PrimType (lambda (arg-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (vector 1 '()) (cond ((equal? arg-0 0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Int")) ((equal? arg-0 1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Int8")) ((equal? arg-0 2) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Int16")) ((equal? arg-0 3) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Int32")) ((equal? arg-0 4) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Int64")) ((equal? arg-0 5) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Integer")) ((equal? arg-0 6) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Bits8")) ((equal? arg-0 7) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Bits16")) ((equal? arg-0 8) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Bits32")) ((equal? arg-0 9) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Bits64")) ((equal? arg-0 10) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "String")) ((equal? arg-0 11) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Char")) ((equal? arg-0 12) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "Double")) (else (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) "%World"))))))
(define CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_Constant (lambda (arg-0) (case (vector-ref arg-0 0) ((13) (let ((e-0 (vector-ref arg-0 1))) (CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_PrimType e-0)))(else (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (vector 2 '()) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-727) (CoreC-45TTC-45Primitive-u--show_Show_Constant arg-0)))))))
(define CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat (lambda (arg-0) (CoreC-45CaseC-45CaseTree-u--prettyPrec_Pretty_IdrisSyntax_Pat (vector 0 ) arg-0)))
(define csegen-1331(delay (cons (force csegen-1023) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 '() u--d u--x))))))
(define CoreC-45CaseC-45CaseTree-u--prettyPrec_Pretty_IdrisSyntax_Pat (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1324 e-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword csegen-1325) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-2))))))) ((1) (let ((e-4 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 5))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (PreludeC-45Show-u--C-62_Ord_Prec arg-0 (vector 0 )) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-hsep (cons (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1324 e-4) (PreludeC-45TypesC-45List-mapAppend '() (csegen-1327) e-7))))))) ((2) (let ((e-9 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 4))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (PreludeC-45Show-u--C-62_Ord_Prec arg-0 (vector 0 )) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-hsep (cons (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1324 e-9) (PreludeC-45TypesC-45List-mapAppend '() (csegen-1327) e-11))))))) ((3) (let ((e-13 (vector-ref arg-1 2))) (CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_Constant e-13))) ((4) (let ((e-16 (vector-ref arg-1 3))) (let ((e-17 (vector-ref arg-1 4))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (PreludeC-45Show-u--C-62_Ord_Prec arg-0 (vector 0 )) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-16) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 IdrisC-45PrettyC-45Annotations-arrow (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-17))))))) ((5) (let ((e-21 (vector-ref arg-1 4))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--fromString_FromString_C-40DocC-32C-36annC-41 "Delay") (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-21))))) ((6) (let ((e-23 (vector-ref arg-1 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1324 e-23))) (else (let ((e-25 (vector-ref arg-1 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (force csegen-279) ".")) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow (force csegen-1331) e-25))))))))
(define csegen-1327 (lambda () (lambda (arg-11258) (CoreC-45CaseC-45CaseTree-u--prettyPrec_Pretty_IdrisSyntax_Pat (vector 6 ) arg-11258))))
(define CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (if (null? arg-2) (vector 1 '()) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-7779)) e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-1 e-5 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) (vector 1 (cons e-6 e-7)))))))))))))))
(define CoreC-45Context-u--full_HasNames_Transform (lambda (arg-0 arg-1 ext-0) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-0 e-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-2 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-4) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector e-0 e-5 e-6 e-7 e-8)))))))))))))))))))))))))
(define CoreC-45Context-u--resolved_HasNames_Transform (lambda (arg-0 arg-1 ext-0) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-1) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-2 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-4) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else (let ((e-8 (vector-ref act-4 1))) (vector 1 (vector e-0 e-5 e-6 e-7 e-8)))))))))))))))))))))))))
(define csegen-1336 (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Transform arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Transform arg-7786 arg-7789 eta-0))))))
(define csegen-1340 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (vector 0 eta-1 eta-2 eta-3)))))))
(define csegen-1343 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (vector 1 eta-1 eta-2 eta-3 eta-4 eta-5)))))))))
(define csegen-1346 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (vector 2 eta-1 eta-2 eta-3 eta-4))))))))
(define csegen-1349 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (vector 4 eta-1 eta-2 eta-3 eta-4))))))))
(define csegen-1352 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (vector 5 eta-1 eta-2 eta-3 eta-4))))))))
(define csegen-1356 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 0 e-5)))))))
(define csegen-1357(delay (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 0 e-5))))))))
(define csegen-1358(delay (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 1 e-5))))))))
(define csegen-1360 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 21 e-5)))))))
(define csegen-1361(delay (lambda (eta-0) (lambda (eta-1) (CoreC-45Core-traverseC-39 eta-0 eta-1 '())))))
(define csegen-1362 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (lambda (__infixTupleSection-0) (cons e-5 __infixTupleSection-0))))))))
(define csegen-1363 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 32 e-5)))))))
(define csegen-1364 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 48 e-5)))))))
(define csegen-1365 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (lambda (eta-1) (vector 71 e-5 eta-1))))))))
(define csegen-1366 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (lambda (eta-1) (vector 74 e-5 eta-1))))))))
(define csegen-1367 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 75 e-5)))))))
(define csegen-1368 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 3 e-5)))))))
(define SystemC-45FFI-free (lambda (arg-1 arg-2) (let ((e-2 (cdr arg-1))) ((e-2 'erased) (lambda (eta-0) (SystemC-45FFI-prim__free arg-2 eta-0))))))
(define SystemC-45Directory-currentDir (lambda (arg-1) (let ((e-1 (car arg-1))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (let ((e-6 (cdr arg-1))) ((e-6 'erased) (lambda (eta-0) (SystemC-45Directory-prim__currentDir eta-0))))) (lambda (u--res) (let ((sc1 (PreludeC-45EqOrd-u--C-47C-61_Eq_Int (PrimIO-prim__nullAnyPtr u--res) (blodwen-toSignedInt 0 63)))) (cond ((equal? sc1 1) (let ((e-7 (car arg-1))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) '()))))) (else (let ((u--s (PreludeC-45IO-prim__getString u--res))) (let ((e-7 (car arg-1))) (let ((e-9 (vector-ref e-7 1))) ((((e-9 'erased) 'erased) (SystemC-45FFI-free arg-1 u--res)) (lambda (_-10685) (let ((e-12 (car arg-1))) (let ((e-15 (vector-ref e-12 0))) (let ((e-17 (vector-ref e-15 1))) ((e-17 'erased) (box u--s)))))))))))))))))))
(define csegen-1374(delay (SystemC-45Directory-currentDir (force csegen-85))))
(define csegen-1375 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (let ((e-2 (vector-ref e-5 2))) e-2)))))))
(define csegen-1376 (lambda (eta-0) (let ((e-2 (vector-ref eta-0 2))) e-2)))
(define csegen-1377 (lambda (u--g) (cons (let ((e-18 (vector-ref u--g 18))) e-18) (let ((e-2 (vector-ref u--g 2))) e-2))))
(define csegen-1378 (lambda (eta-0) (let ((e-18 (vector-ref eta-0 18))) e-18)))
(define CoreC-45CompileExpr-u--C-61C-61_Eq_ConInfo (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-1 (vector-ref arg-1 1))) (or (and (= e-0 e-1) 1) 0)))(else 0)))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0))) ((6) (case (vector-ref arg-1 0) ((6) 1)(else 0))) ((7) (case (vector-ref arg-1 0) ((7) 1)(else 0))) ((8) (case (vector-ref arg-1 0) ((8) 1)(else 0))) ((9) (case (vector-ref arg-1 0) ((9) 1)(else 0))) ((10) (case (vector-ref arg-1 0) ((10) 1)(else 0)))(else 0))))
(define CoreC-45TT-u--C-61C-61_Eq_TotalReq (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define CoreC-45ContextC-45Context-u--C-61C-61_Eq_DefFlag (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (case (vector-ref arg-1 0) ((4) 1)(else 0))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0))) ((6) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-4 (vector-ref arg-1 1))) (CoreC-45TT-u--C-61C-61_Eq_TotalReq e-0 e-4)))(else 0)))) ((7) (case (vector-ref arg-1 0) ((7) 1)(else 0))) ((8) (case (vector-ref arg-1 0) ((8) 1)(else 0))) ((9) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-5 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-298) csegen-1094 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-298) csegen-1094 arg-722 arg-725)))) e-1 e-5)))(else 0)))) ((10) (case (vector-ref arg-1 0) ((10) 1)(else 0))) ((11) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((11) (let ((e-6 (vector-ref arg-1 1))) (CoreC-45CompileExpr-u--C-61C-61_Eq_ConInfo e-2 e-6)))(else 0)))) ((12) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((12) (let ((e-7 (vector-ref arg-1 1))) (or (and (= e-3 e-7) 1) 0)))(else 0))))(else 0))))
(define CoreC-45ContextC-45Context-u--C-47C-61_Eq_DefFlag (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45ContextC-45Context-u--C-61C-61_Eq_DefFlag arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1382 (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45ContextC-45Context-u--C-61C-61_Eq_DefFlag arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45ContextC-45Context-u--C-47C-61_Eq_DefFlag arg-722 arg-725)))))
(define csegen-1388 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (lambda (eta-7) (vector eta-1 eta-2 eta-3 eta-4 eta-5 eta-6 eta-7)))))))))))
(define CoreC-45Options-u--C-61C-61_Eq_CG (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (case (vector-ref arg-1 0) ((4) 1)(else 0))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0))) ((6) (case (vector-ref arg-1 0) ((6) 1)(else 0))) ((7) (case (vector-ref arg-1 0) ((7) 1)(else 0))) ((8) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-1)))(else 0))))(else 0))))
(define CoreC-45Options-u--C-47C-61_Eq_CG (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Options-u--C-61C-61_Eq_CG arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1394(delay (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45Options-u--C-61C-61_Eq_CG arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45Options-u--C-47C-61_Eq_CG arg-722 arg-725))))))
(define csegen-1401 (vector '() '() '() '() '() '() '()))
(define LibrariesC-45DataC-45StringC-45Iterator-withString (lambda (arg-1 arg-2) (arg-2 (LibrariesC-45DataC-45StringC-45Iterator-fromString arg-1))))
(define LibrariesC-45DataC-45StringC-45Iterator-n--3019-6695-u--loop (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (let ((sc0 (LibrariesC-45DataC-45StringC-45Iterator-uncons arg-1 arg-5))) (if (null? sc0) arg-4 (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (LibrariesC-45DataC-45StringC-45Iterator-n--3019-6695-u--loop arg-1 arg-2 arg-3 ((arg-3 arg-4) e-2) e-3)))))))
(define LibrariesC-45DataC-45StringC-45Iterator-foldl (lambda (arg-1 arg-2 arg-3) (LibrariesC-45DataC-45StringC-45Iterator-withString arg-3 (lambda (eta-0) (LibrariesC-45DataC-45StringC-45Iterator-n--3019-6695-u--loop arg-3 arg-2 arg-1 arg-2 eta-0)))))
(define CoreC-45Hash-u--hash_Hashable_Char (lambda (ext-0) (cast-char-boundedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Char (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Char arg-1) 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_String (lambda (arg-0 ext-0) (LibrariesC-45DataC-45StringC-45Iterator-foldl (lambda (eta-0) (lambda (eta-1) (CoreC-45Hash-u--hashWithSalt_Hashable_Char eta-0 eta-1))) arg-0 ext-0)))
(define CoreC-45Hash-u--hash_Hashable_String (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_String (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1418 (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_String arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_String arg-4654 arg-4657)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) arg-1 63)))
(define PreludeC-45Num-u--abs_Abs_Int (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-0 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 1) (bs- 0 arg-0 63)) (else arg-0)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (PreludeC-45Num-u--abs_Abs_Int arg-2) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 arg-1 (bs+ (bs* arg-2 33 63) (let ((e-1 (car arg-1))) (e-1 e-2)) 63) e-3))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Namespace (lambda (arg-0 arg-1) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 csegen-1418 arg-0 arg-1)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Name (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((2) (let ((e-0 (vector-ref arg-1 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_String arg-0 e-0))) ((4) (let ((e-3 (vector-ref arg-1 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name arg-0 e-3))) ((0) (let ((e-4 (vector-ref arg-1 1))) (let ((e-5 (vector-ref arg-1 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Namespace arg-0 e-4) e-5)))) ((8) (let ((e-6 (vector-ref arg-1 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int arg-0 e-6)))(else (CoreC-45Hash-u--hashWithSalt_Hashable_String arg-0 (CoreC-45Name-u--show_Show_Name arg-1))))))
(define CoreC-45Hash-u--hash_Hashable_Name (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1420 (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_Name arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_Name arg-4654 arg-4657)))))
(define CoreC-45Hash-u--hash_Hashable_Nat (lambda (ext-0) (blodwen-toSignedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Nat (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Nat arg-1) 63)))
(define csegen-1422 (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_Nat arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_Nat arg-4654 arg-4657)))))
(define csegen-1424 (cons (lambda (arg-4648) arg-4648) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_Int arg-4654 arg-4657)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((e-2 (car arg-5))) (let ((e-3 (cdr arg-5))) (let ((e-4 (cdr arg-3))) ((e-4 (let ((e-5 (cdr arg-2))) ((e-5 arg-4) e-2))) e-3))))))
(define CoreC-45Hash-u--hash_Hashable_Integer (lambda (ext-0) (blodwen-toSignedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Integer (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Integer arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 (blodwen-toSignedInt 5381 63) ext-0)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_CFType (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0)) ((1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) ((7) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ((8) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3)) ((9) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4)) ((10) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5)) ((11) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6)) ((12) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7)) ((13) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8)) ((14) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9)) ((15) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10)) ((16) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11)) ((18) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12)) ((19) (let ((e-0 (vector-ref ext-0 1))) (let ((e-1 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13) e-0) e-1)))) ((20) (let ((e-2 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14) e-2))) ((21) (let ((e-3 (vector-ref ext-0 1))) (let ((e-4 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1418 (csegen-1426) arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1418 (csegen-1426) arg-4654 arg-4657)))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 15) e-3) e-4)))) ((22) (let ((e-5 (vector-ref ext-0 1))) (let ((e-6 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1426) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 16) e-5) e-6)))) ((3) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 17)) ((4) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 18)) ((5) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 19)) ((6) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 20)) ((17) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 21)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 22)))))
(define CoreC-45Hash-u--hash_Hashable_CFType (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1426 (lambda () (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_CFType arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType arg-4654 arg-4657))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45Num-u--abs_Abs_Int arg-3) (let ((e-3 (car arg-4))) (let ((e-4 (cdr arg-4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 arg-2 (bs+ (bs* arg-3 33 63) (let ((e-1 (car arg-2))) (e-1 e-3)) 63) e-4))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (PreludeC-45Num-u--abs_Abs_Int arg-2) (let ((e-2 (unbox arg-3))) (let ((e-3 (cdr arg-1))) ((e-3 arg-2) e-2))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (lambda (arg-0 ext-0) (cond ((equal? ext-0 0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) ((equal? ext-0 1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ((equal? ext-0 2) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3)) ((equal? ext-0 3) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4)) ((equal? ext-0 4) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5)) ((equal? ext-0 5) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6)) ((equal? ext-0 6) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7)) ((equal? ext-0 7) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8)) ((equal? ext-0 8) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9)) ((equal? ext-0 9) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10)) ((equal? ext-0 10) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11)) ((equal? ext-0 11) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12)) ((equal? ext-0 12) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40PrimFnC-32C-36arityC-41 (lambda (arg-1 ext-0) (case (vector-ref ext-0 0) ((0) (let ((e-0 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 0) e-0))) ((1) (let ((e-1 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 1) e-1))) ((2) (let ((e-2 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 2) e-2))) ((3) (let ((e-3 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 3) e-3))) ((4) (let ((e-4 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 4) e-4))) ((5) (let ((e-5 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 5) e-5))) ((6) (let ((e-6 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 6) e-6))) ((7) (let ((e-7 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 7) e-7))) ((8) (let ((e-8 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 8) e-8))) ((9) (let ((e-9 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 9) e-9))) ((10) (let ((e-10 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 10) e-10))) ((11) (let ((e-11 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 11) e-11))) ((12) (let ((e-12 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 12) e-12))) ((13) (let ((e-13 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 13) e-13))) ((14) (let ((e-14 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 14) e-14))) ((15) (let ((e-15 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 15) e-15))) ((16) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 16)) ((17) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 17)) ((18) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 18)) ((19) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 19)) ((20) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 20)) ((21) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 21)) ((22) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 22)) ((23) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 23)) ((24) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 24)) ((25) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 25)) ((27) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 26)) ((28) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 27)) ((29) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 28)) ((30) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 29)) ((31) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 30)) ((32) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 31)) ((33) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 32)) ((34) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 33)) ((35) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 34)) ((36) (let ((e-16 (vector-ref ext-0 1))) (let ((e-17 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 35) e-16) e-17)))) ((37) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 36)) ((38) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 37)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 38)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_ConInfo (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0)) ((1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) ((2) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ((3) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3)) ((4) (let ((e-0 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Nat (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4) e-0))) ((5) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5)) ((6) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6)) ((7) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7)) ((8) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8)) ((9) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10)))))
(define CoreC-45Hash-u--hash_Hashable_Bits16 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits16 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits16 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Bits32 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits32 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits32 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Bits64 (lambda (ext-0) (blodwen-toSignedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits64 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits64 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Bits8 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits8 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits8 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Double (lambda (ext-0) (CoreC-45Hash-u--hash_Hashable_String (PreludeC-45Show-u--show_Show_Double ext-0))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Double (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Double arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int16 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int16 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int16 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int32 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int32 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int32 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int64 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int64 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int64 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int8 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int8 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int8 arg-1) 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Constant (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (let ((e-0 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0) e-0))) ((1) (let ((e-1 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int8 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1) e-1))) ((2) (let ((e-2 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int16 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2) e-2))) ((3) (let ((e-3 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int32 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3) e-3))) ((4) (let ((e-4 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int64 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4) e-4))) ((5) (let ((e-5 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5) e-5))) ((6) (let ((e-6 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits8 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6) e-6))) ((7) (let ((e-7 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits16 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7) e-7))) ((8) (let ((e-8 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits32 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8) e-8))) ((9) (let ((e-9 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits64 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9) e-9))) ((10) (let ((e-10 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10) e-10))) ((11) (let ((e-11 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Char (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11) e-11))) ((12) (let ((e-12 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Double (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12) e-12))) ((13) (let ((e-13 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13) e-13))) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_LazyReason (lambda (arg-0 ext-0) (cond ((equal? ext-0 0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0)) ((equal? ext-0 1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_NamedConAlt (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 csegen-1420 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 csegen-1424 (CoreC-45Hash-u--hashWithSalt_Hashable_ConInfo (CoreC-45Hash-u--hashWithSalt_Hashable_Name arg-0 e-0) e-1) e-2) e-3) e-4))))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_NamedConstAlt (lambda (arg-0 arg-1) (let ((e-0 (car arg-1))) (let ((e-1 (cdr arg-1))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Constant arg-0 e-0) e-1)))))
(define CoreC-45Hash-u--hash_Hashable_NamedConAlt (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConAlt (blodwen-toSignedInt 5381 63) ext-0)))
(define CoreC-45Hash-u--hash_Hashable_NamedConstAlt (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConstAlt (blodwen-toSignedInt 5381 63) ext-0)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (let ((e-1 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0) e-1))) ((1) (let ((e-3 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1) e-3))) ((2) (let ((e-5 (vector-ref ext-0 2))) (let ((e-6 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2) e-5) e-6)))) ((3) (let ((e-8 (vector-ref ext-0 2))) (let ((e-9 (vector-ref ext-0 3))) (let ((e-10 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3) e-8) e-9) e-10))))) ((4) (let ((e-12 (vector-ref ext-0 2))) (let ((e-13 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1428) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4) e-12) e-13)))) ((5) (let ((e-15 (vector-ref ext-0 2))) (let ((e-16 (vector-ref ext-0 3))) (let ((e-17 (vector-ref ext-0 4))) (let ((e-18 (vector-ref ext-0 5))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1428) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 csegen-1424 (CoreC-45Hash-u--hashWithSalt_Hashable_ConInfo (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5) e-15) e-16) e-17) e-18)))))) ((6) (let ((e-21 (vector-ref ext-0 3))) (let ((e-22 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (csegen-1428) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PrimFnC-32C-36arityC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6) e-21) e-22)))) ((7) (let ((e-24 (vector-ref ext-0 2))) (let ((e-25 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1428) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7) e-24) e-25)))) ((8) (let ((e-27 (vector-ref ext-0 2))) (let ((e-28 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_LazyReason (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8) e-27) e-28)))) ((9) (let ((e-30 (vector-ref ext-0 2))) (let ((e-31 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_LazyReason (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9) e-30) e-31)))) ((10) (let ((e-33 (vector-ref ext-0 2))) (let ((e-34 (vector-ref ext-0 3))) (let ((e-35 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 (csegen-1428) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_NamedConAlt arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConAlt arg-4654 arg-4657)))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10) e-33) e-34) e-35))))) ((11) (let ((e-37 (vector-ref ext-0 2))) (let ((e-38 (vector-ref ext-0 3))) (let ((e-39 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 (csegen-1428) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_NamedConstAlt arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConstAlt arg-4654 arg-4657)))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11) e-37) e-38) e-39))))) ((12) (let ((e-41 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Constant (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12) e-41))) ((13) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13)) (else (let ((e-44 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14) e-44))))))
(define CoreC-45Hash-u--hash_Hashable_NamedCExp (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1428 (lambda () (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_NamedCExp arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp arg-4654 arg-4657))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 0)) ((1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 1)) ((2) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 2)) (else (let ((e-4 (vector-ref arg-3 1))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 3)) e-4)))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (lambda (arg-0 ext-0) (AlgebraC-45Semiring-elimSemi (force csegen-978) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1) (lambda (eta-0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ext-0)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40BinderC-32C-36tyC-41 (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (let ((e-5 (cdr arg-1))) ((e-5 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 arg-1 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 0) e-2) e-3)) e-4)))))) ((1) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (let ((e-3 (cdr arg-1))) ((e-3 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 1) e-7)) e-8))) e-9)))))) ((2) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 arg-1 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 2) e-12) e-13)) e-14)))))) ((3) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 arg-1 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 3) e-17) e-18)) e-19)))))) ((4) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (let ((e-3 (cdr arg-1))) ((e-3 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 4) e-22)) e-23))) e-24)))))) (else (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 5) e-27)) e-28))))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-4 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_Nat (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 0) e-4))) ((1) (let ((e-9 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 1) e-9))) ((2) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1437) (CoreC-45Hash-u--hashWithSalt_Hashable_Int (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 2) e-13) e-14)))) ((3) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40BinderC-32C-36tyC-41 (csegen-1437) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 3) e-18) e-19)))) ((4) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 4) e-22) e-23)))) ((5) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 5) e-27) e-28)))) ((6) (let ((e-32 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 6) e-32))) ((7) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 7) e-36) e-37)))) ((8) (let ((e-41 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 8) e-41))) ((9) (let ((e-44 (vector-ref arg-2 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 9) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-44)))) ((10) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 10)) (else (let ((e-50 (vector-ref arg-2 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 11) e-50))))))
(define CoreC-45Hash-u--hash_Hashable_C-40TermC-32C-36varsC-41 (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1437 (lambda () (cons (lambda (arg-4648) (CoreC-45Hash-u--hash_Hashable_C-40TermC-32C-36varsC-41 arg-4648)) (lambda (arg-4654) (lambda (arg-4657) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 arg-4654 arg-4657))))))
(define csegen-1438 (lambda (_-0) (box (+ _-0 1))))
(define CoreC-45Value-u--full_HasNames_C-40NHeadC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-3 (vector-ref eta-0 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 1 e-1 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-1 e-2 eta-0)) ext-0))))(else (vector 1 arg-2)))))
(define CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (vector 1 (vector 0 e-1 e-2 e-3 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NHeadC-32C-36freeC-41 arg-1 e-7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-6 e-5 e-8)))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((e-14 (vector-ref arg-2 5))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-10 e-5 e-12 e-13 e-14)))))))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-17 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 3 e-16 e-5 e-18 e-19))))))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (let ((e-24 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-23 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-24 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-21 e-22 e-5 e-6))))))))))))))) ((5) (let ((e-26 (vector-ref arg-2 1))) (let ((e-27 (vector-ref arg-2 2))) (let ((e-28 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-28 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 5 e-26 e-27 e-5)))))))))) ((6) (let ((e-30 (vector-ref arg-2 1))) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (let ((e-33 (vector-ref arg-2 4))) (vector 1 (vector 6 e-30 e-31 e-32 e-33))))))) ((7) (let ((e-35 (vector-ref arg-2 1))) (let ((e-36 (vector-ref arg-2 2))) (let ((e-37 (vector-ref arg-2 3))) (let ((e-38 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-37 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 7 e-35 e-36 e-5 e-38))))))))))) ((8) (let ((e-40 (vector-ref arg-2 1))) (let ((e-41 (vector-ref arg-2 2))) (vector 1 (vector 8 e-40 e-41))))) ((9) (let ((e-43 (vector-ref arg-2 1))) (let ((e-44 (vector-ref arg-2 2))) (vector 1 (vector 9 e-43 e-44))))) (else (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-47 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 10 e-46 e-5))))))))))))
(define CoreC-45Value-u--resolved_HasNames_C-40NHeadC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-3 (vector-ref eta-0 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 1 e-1 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-1 e-2) ext-0))))(else (vector 1 arg-2)))))
(define CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (vector 1 (vector 0 e-1 e-2 e-3 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NHeadC-32C-36freeC-41 arg-1 e-7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-6 e-5 e-8)))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((e-14 (vector-ref arg-2 5))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-11) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-10 e-5 e-12 e-13 e-14)))))))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-17) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 3 e-16 e-5 e-18 e-19))))))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (let ((e-24 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-23 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-24 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 4 e-21 e-22 e-5 e-6))))))))))))))) ((5) (let ((e-26 (vector-ref arg-2 1))) (let ((e-27 (vector-ref arg-2 2))) (let ((e-28 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-28 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 5 e-26 e-27 e-5)))))))))) ((6) (let ((e-30 (vector-ref arg-2 1))) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (let ((e-33 (vector-ref arg-2 4))) (vector 1 (vector 6 e-30 e-31 e-32 e-33))))))) ((7) (let ((e-35 (vector-ref arg-2 1))) (let ((e-36 (vector-ref arg-2 2))) (let ((e-37 (vector-ref arg-2 3))) (let ((e-38 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-37 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 7 e-35 e-36 e-5 e-38))))))))))) ((8) (let ((e-40 (vector-ref arg-2 1))) (let ((e-41 (vector-ref arg-2 2))) (vector 1 (vector 8 e-40 e-41))))) ((9) (let ((e-43 (vector-ref arg-2 1))) (let ((e-44 (vector-ref arg-2 2))) (vector 1 (vector 9 e-43 e-44))))) (else (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-47) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 10 e-46 e-5))))))))))))
(define csegen-1441 (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-7786 arg-7789 eta-0))))))
(define LibrariesC-45DataC-45ListC-45SizeOf-suc (lambda (arg-3) (+ arg-3 1)))
(define CoreC-45NameC-45Scoped-GenWeakenWeakens (lambda (arg-1) (cons (lambda (nm-3218) (lambda (vars-3219) (((((arg-1 'erased) 'erased) 'erased) 0) (LibrariesC-45DataC-45ListC-45SizeOf-suc 0)))) (lambda (vars-3238) (lambda (ns-3239) ((((arg-1 'erased) 'erased) 'erased) 0))))))
(define LibrariesC-45DataC-45ListC-45SizeOf-C-43 (lambda (arg-3 arg-4) (+ arg-3 arg-4)))
(define DataC-45So-choose (lambda (arg-0) (cond ((equal? arg-0 1) (vector 0 'erased)) (else (vector 1 'erased)))))
(define CoreC-45TTC-45Var-locateIsVar (lambda (arg-4 arg-5) (let ((sc0 (DataC-45So-choose (PreludeC-45Types-u--C-60_Ord_Nat arg-4 arg-5)))) (case (vector-ref sc0 0) ((0) (vector 0 'erased)) (else (vector 1 'erased))))))
(define CoreC-45TTC-45Var-locateNVar (lambda (arg-4 arg-5) (let ((sc0 (CoreC-45TTC-45Var-locateIsVar arg-5 arg-4))) (case (vector-ref sc0 0) ((0) (vector 0 arg-5)) (else (vector 1 (PreludeC-45Types-prim__integerToNat (- arg-5 arg-4))))))))
(define CoreC-45TTC-45Var-weakenNVar (lambda (arg-4 arg-5) (+ arg-4 arg-5)))
(define CoreC-45TTC-45Var-insertNVarNames (lambda (arg-4 arg-5 arg-6) (let ((sc0 (CoreC-45TTC-45Var-locateNVar arg-4 arg-6))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) e-2)) (else (let ((e-5 (vector-ref sc0 1))) (CoreC-45TTC-45Var-weakenNVar (LibrariesC-45DataC-45ListC-45SizeOf-C-43 arg-4 arg-5) e-5)))))))
(define CoreC-45TTC-45Term-insertNames (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-2 (vector-ref arg-5 1))) (let ((e-3 (vector-ref arg-5 2))) (let ((e-4 (vector-ref arg-5 3))) (let ((eff-0 (CoreC-45TTC-45Var-insertNVarNames arg-3 arg-4 e-4))) (vector 0 e-2 e-3 eff-0)))))) ((1) (let ((e-7 (vector-ref arg-5 1))) (let ((e-8 (vector-ref arg-5 2))) (let ((e-9 (vector-ref arg-5 3))) (vector 1 e-7 e-8 e-9))))) ((2) (let ((e-11 (vector-ref arg-5 1))) (let ((e-12 (vector-ref arg-5 2))) (let ((e-13 (vector-ref arg-5 3))) (let ((e-14 (vector-ref arg-5 4))) (vector 2 e-11 e-12 e-13 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 eta-0)) e-14))))))) ((3) (let ((e-16 (vector-ref arg-5 1))) (let ((e-17 (vector-ref arg-5 2))) (let ((e-18 (vector-ref arg-5 3))) (let ((e-19 (vector-ref arg-5 4))) (vector 3 e-16 e-17 (CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (eta-0) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 eta-0)) e-18) (CoreC-45TTC-45Term-insertNames (LibrariesC-45DataC-45ListC-45SizeOf-suc arg-3) arg-4 e-19))))))) ((4) (let ((e-21 (vector-ref arg-5 1))) (let ((e-22 (vector-ref arg-5 2))) (let ((e-23 (vector-ref arg-5 3))) (vector 4 e-21 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-22) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-23)))))) ((5) (let ((e-25 (vector-ref arg-5 1))) (let ((e-26 (vector-ref arg-5 2))) (let ((e-27 (vector-ref arg-5 3))) (let ((e-28 (vector-ref arg-5 4))) (vector 5 e-25 e-26 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-27) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-28))))))) ((6) (let ((e-30 (vector-ref arg-5 1))) (let ((e-31 (vector-ref arg-5 2))) (let ((e-32 (vector-ref arg-5 3))) (vector 6 e-30 e-31 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-32)))))) ((7) (let ((e-34 (vector-ref arg-5 1))) (let ((e-35 (vector-ref arg-5 2))) (let ((e-36 (vector-ref arg-5 3))) (let ((e-37 (vector-ref arg-5 4))) (vector 7 e-34 e-35 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-36) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-37))))))) ((8) (let ((e-39 (vector-ref arg-5 1))) (let ((e-40 (vector-ref arg-5 2))) (let ((e-41 (vector-ref arg-5 3))) (vector 8 e-39 e-40 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-41)))))) ((9) (let ((e-43 (vector-ref arg-5 1))) (let ((e-44 (vector-ref arg-5 2))) (vector 9 e-43 e-44)))) ((10) (let ((e-46 (vector-ref arg-5 1))) (let ((e-47 (vector-ref arg-5 2))) (case (vector-ref e-47 0) ((1) (vector 10 e-46 (vector 1 ))) ((0) (vector 10 e-46 (vector 0 ))) (else (let ((e-54 (vector-ref e-47 1))) (vector 10 e-46 (vector 2 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-54))))))))) (else (let ((e-49 (vector-ref arg-5 1))) (let ((e-50 (vector-ref arg-5 2))) (vector 11 e-49 e-50)))))))
(define CoreC-45TTC-45Term-u--genWeakenNs_GenWeaken_Term (lambda (ext-0 ext-1 ext-2) (CoreC-45TTC-45Term-insertNames ext-0 ext-1 ext-2)))
(define CoreC-45TTC-45Term-WeakenTerm (CoreC-45NameC-45Scoped-GenWeakenWeakens (lambda (outer-6179) (lambda (ns-6180) (lambda (local-6181) (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (CoreC-45TTC-45Term-u--genWeakenNs_GenWeaken_Term eta-0 eta-1 eta-2)))))))))
(define CoreC-45TTC-45Term-fnType (lambda (arg-1 arg-2 arg-3) (vector 3 CoreC-45FC-emptyFC (vector 2 "_" 0) (vector 2 arg-1 AlgebraC-45ZeroOneOmega-u--top_Top_ZeroOneOmega (vector 1 ) arg-2) (let ((sc0 CoreC-45TTC-45Term-WeakenTerm)) (let ((e-1 (car sc0))) (((e-1 'erased) 'erased) arg-3))))))
(define csegen-1449 (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-fnType CoreC-45FC-emptyFC eta-0 eta-1))))
(define csegen-1491 (vector 11 CoreC-45FC-emptyFC (vector 2 "top" 0)))
(define csegen-1493 (vector 0 CoreC-45FC-emptyFC '() 1))
(define csegen-1581 (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8920) (PreludeC-45TypesC-45List-mapAppend '() u--func arg-8920))))))
(define PreludeC-45Types-listBindOnto (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45TypesC-45List-reverse arg-3) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (PreludeC-45Types-listBindOnto arg-2 (PreludeC-45TypesC-45List-reverseOnto arg-3 (arg-2 e-2)) e-3))))))
(define PreludeC-45Types-listBind (lambda (arg-2 arg-3) (PreludeC-45Types-listBindOnto arg-3 '() arg-2)))
(define PreludeC-45Types-u--C-60C-42C-62_Applicative_List (lambda (arg-2 arg-3) (PreludeC-45Types-listBind arg-2 (lambda (u--f) (PreludeC-45TypesC-45List-mapAppend '() u--f arg-3)))))
(define PreludeC-45Types-u--pure_Applicative_List (lambda (arg-1) (cons arg-1 '())))
(define csegen-1589 (vector (vector csegen-1581 (lambda (u--a) (lambda (arg-9959) (PreludeC-45Types-u--pure_Applicative_List arg-9959))) (lambda (u--b) (lambda (u--a) (lambda (arg-9965) (lambda (arg-9972) (PreludeC-45Types-u--C-60C-42C-62_Applicative_List arg-9965 arg-9972)))))) (lambda (u--a) '()) (lambda (u--a) (lambda (arg-10343) (lambda (arg-10346) (PreludeC-45TypesC-45List-tailRecAppend arg-10343 (arg-10346)))))))
(define CoreC-45TTC-45Primitive-u--C-47C-61_Eq_PrimType (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1592 (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45TTC-45Primitive-u--C-47C-61_Eq_PrimType arg-722 arg-725)))))
(define csegen-1701 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-236) (force csegen-236) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-236) (force csegen-236) arg-722 arg-725)))))
(define csegen-1702 (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-1598 arg-1601))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 2)))
(define PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 0)))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 0)))
(define PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 2)))
(define PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5))) (cond ((equal? sc0 1) arg-4) (else arg-5)))))
(define PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5))) (cond ((equal? sc0 1) arg-4) (else arg-5)))))
(define csegen-1709 (vector csegen-1701 csegen-1702 (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-1658 arg-1661)))))
(define csegen-1710 (lambda (eta-0) (lambda (eta-1) (PreludeC-45TypesC-45List-mapMaybeAppend '() eta-0 eta-1))))
(define LibrariesC-45DataC-45Version-n--4352-3059-u--showTag (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (if (null? arg-3) "" (let ((e-2 (unbox arg-3))) (string-append "-" e-2)))))
(define LibrariesC-45DataC-45Version-showVersion (lambda (arg-0 arg-1) (let ((e-0 (car arg-1))) (let ((e-1 (cdr arg-1))) (let ((e-4 (car e-0))) (let ((e-5 (cdr e-0))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (string-append (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-62) (lambda (eta-0) eta-0) (DataC-45List-intersperse "." (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Show-u--show_Show_Nat eta-0)) (cons e-4 (cons e-8 (cons e-9 '())))))) (cond ((equal? arg-0 1) (LibrariesC-45DataC-45Version-n--4352-3059-u--showTag e-4 e-8 e-9 e-1 arg-0)) (else "")))))))))))
(define IdrisPaths-idrisVersion (cons (cons 0 (cons 8 0)) "1b5176dc9"))
(define IdrisC-45Version-with--version-3790 (lambda (arg-0) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cond ((equal? e-3 "") (cons e-2 '()))(else (cons e-2 (box e-3))))))))
(define IdrisC-45Version-version (IdrisC-45Version-with--version-3790 IdrisPaths-idrisVersion))
(define csegen-1713 (LibrariesC-45DataC-45Version-showVersion 0 IdrisC-45Version-version))
(define PreludeC-45Types-u--C-60C-61_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 2)))
(define PreludeC-45Types-u--C-62C-61_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 0)))
(define PreludeC-45Types-u--min_Ord_Nat (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45Types-u--C-60_Ord_Nat arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-1724 (vector csegen-1094 csegen-1121 (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45Types-u--C-60_Ord_Nat arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45Types-u--C-62_Ord_Nat arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45Types-u--C-60C-61_Ord_Nat arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45Types-u--C-62C-61_Ord_Nat arg-1638 arg-1641))) csegen-1111 (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45Types-u--min_Ord_Nat arg-1658 arg-1661)))))
(define LibrariesC-45DataC-45Version-u--C-61C-61_Eq_VersionTokenKind (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0)))(else 0))))
(define LibrariesC-45DataC-45Version-u--C-47C-61_Eq_VersionTokenKind (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45DataC-45Version-u--C-61C-61_Eq_VersionTokenKind arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define LibrariesC-45DataC-45Version-u--TokType_TokenKind_VersionTokenKind (lambda (arg-0) (cond ((equal? arg-0 0) (vector "String" )) ((equal? arg-0 2) (vector "Builtin.Unit" )) ((equal? arg-0 3) (vector "Builtin.Unit" )) (else (vector "Prelude.Types.Nat" )))))
(define DataC-45String-stringToNatOrZ (lambda (ext-0) (PreludeC-45Types-prim__integerToNat (cast-string-int ext-0))))
(define LibrariesC-45DataC-45Version-u--tokValue_TokenKind_VersionTokenKind (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) arg-1) ((equal? arg-0 2) 'erased) ((equal? arg-0 3) 'erased) (else (DataC-45String-stringToNatOrZ arg-1)))))
(define csegen-1749(delay (cons (cons (lambda (arg-712) (lambda (arg-715) (LibrariesC-45DataC-45Version-u--C-61C-61_Eq_VersionTokenKind arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (LibrariesC-45DataC-45Version-u--C-47C-61_Eq_VersionTokenKind arg-722 arg-725)))) (cons (lambda (arg-818) (LibrariesC-45DataC-45Version-u--TokType_TokenKind_VersionTokenKind arg-818)) (lambda (u--kind) (lambda (arg-827) (LibrariesC-45DataC-45Version-u--tokValue_TokenKind_VersionTokenKind u--kind arg-827)))))))
(define csegen-1750(delay (LibrariesC-45TextC-45Parser-match (force csegen-1749) 1)))
(define csegen-1751(delay (LibrariesC-45TextC-45Parser-match (force csegen-1749) 2)))
(define PreludeC-45Interfaces-u--C-60C-43C-62_Semigroup_SemigroupAlternativeC-40C-36fC-32C-36aC-41 (lambda (arg-2 arg-3 arg-4) (let ((e-3 (vector-ref arg-2 2))) (((e-3 'erased) arg-3) (lambda () arg-4)))))
(define PreludeC-45Interfaces-u--neutral_Monoid_MonoidAlternativeC-40C-36fC-32C-36aC-41 (lambda (arg-2) (let ((e-2 (vector-ref arg-2 1))) (e-2 'erased))))
(define csegen-1763 (cons (lambda (arg-8505) (lambda (arg-8508) (PreludeC-45Interfaces-u--C-60C-43C-62_Semigroup_SemigroupAlternativeC-40C-36fC-32C-36aC-41 (force csegen-270) arg-8505 arg-8508))) (PreludeC-45Interfaces-u--neutral_Monoid_MonoidAlternativeC-40C-36fC-32C-36aC-41 (force csegen-270))))
(define csegen-1795(delay (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char #\. arg-0))))
(define CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 (lambda (arg-1 arg-2 ext-0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (cons e-5 e-3))))))))))
(define CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 (lambda (arg-1 arg-2 ext-0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-2) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (cons e-5 e-3))))))))))
(define csegen-1810 (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 arg-7786 arg-7789 eta-0))))))
(define CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 (lambda (arg-0 arg-1 ext-0) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--full_HasNames_Transform arg-0 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))))
(define CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 (lambda (arg-0 arg-1 ext-0) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_Transform arg-0 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))))
(define csegen-1813 (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 arg-7786 arg-7789 eta-0))))))
(define csegen-1816 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_Namespace i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Namespace i_con-0 eta-0)))))
(define csegen-1817 (cons csegen-1816 csegen-1643))
(define csegen-1820 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1817 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1817 i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_CG (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 2 ))) ((equal? e-5 3) (vector 1 (vector 3 ))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 8 e-6))))))) ((equal? e-5 5) (vector 1 (vector 4 ))) ((equal? e-5 6) (vector 1 (vector 5 ))) ((equal? e-5 7) (vector 1 (vector 6 ))) ((equal? e-5 8) (vector 1 (vector 7 )))(else (CoreC-45BinaryC-45Prims-corrupt "CG" ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_CG (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((8) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-0) ext-0)))))) ((4) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((6) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)))))
(define csegen-1823 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_CG i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_CG i_con-0 eta-0)))))
(define csegen-1826 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1640 i_con-0 eta-0)))))
(define csegen-1827 (cons csegen-1640 csegen-1826))
(define csegen-1831 (cons csegen-1823 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1827 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1827 i_con-0 eta-0))))))
(define csegen-1834 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1831 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1831 i_con-0 eta-0)))))
(define csegen-1837 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_ModuleIdent i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_ModuleIdent i_con-0 eta-0)))))
(define csegen-1838 (cons csegen-46 csegen-1816))
(define csegen-1842 (cons csegen-1837 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1838 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1838 i_con-0 eta-0))))))
(define csegen-1845 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1842 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1842 i_con-0 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Binary (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((u--len e-5)) (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((sc2 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-6) u--len))) (cond ((equal? sc2 1) (let ((act-3 (let ((act-3 ((DataC-45Buffer-newBuffer (force csegen-85) e-5) ext-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (if (null? e-7) (CoreC-45BinaryC-45Prims-corrupt "Binary" ext-0) (let ((e-1 (unbox e-7))) (let ((act-4 (let ((act-4 ((DataC-45Buffer-copyData (force csegen-85) (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-4 (vector-ref e-6 1))) e-4) 63) e-5 e-1 0) ext-0))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc u--len e-6)))) (vector 1 act-5)))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (vector 1 (vector e-1 0 u--len u--len))))))))))))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 52 (vector 1 "Binary")) ext-0)))))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Binary (lambda (arg-0 arg-1) (let ((u--len (let ((e-3 (vector-ref arg-1 3))) e-3))) (let ((u--ilen (blodwen-toSignedInt u--len 63))) (lambda (eta-0) (let ((act-1 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 u--ilen) eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((sc2 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-6) u--len))) (cond ((equal? sc2 1) (let ((act-3 (let ((act-3 ((DataC-45Buffer-copyData (force csegen-85) (let ((e-0 (vector-ref arg-1 0))) e-0) 0 u--ilen (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63)) eta-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--len e-6)))) (vector 1 act-4)))))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-extendBinary u--len e-6) eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (let ((act-4 ((DataC-45Buffer-copyData (force csegen-85) (let ((e-0 (vector-ref arg-1 0))) e-0) 0 u--ilen (let ((e-0 (vector-ref e-7 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-7 1))) e-1) 63)) eta-0))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--len e-7)))) (vector 1 act-5))))))))))))))))))))))))
(define csegen-1849 (cons csegen-43 (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Binary i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Binary i_con-0 eta-0))))))
(define csegen-1852 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1849 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1849 i_con-0 eta-0)))))
(define csegen-1853 (cons csegen-43 csegen-50))
(define csegen-1856 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1853 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1853 i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_PairNames (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector e-5 e-6 e-7))))))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_PairNames (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-0 (vector-ref arg-1 0))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-1 (vector-ref arg-1 1))) e-1)) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2)) ext-0)))))))))
(define csegen-1859 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_PairNames i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_PairNames i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_RewriteNames (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_RewriteNames (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-0 (car arg-1))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-1 (cdr arg-1))) e-1)) ext-0))))))
(define csegen-1862 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_RewriteNames i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_RewriteNames i_con-0 eta-0)))))
(define csegen-1863 (cons csegen-43 csegen-1640))
(define csegen-1866 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1863 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1863 i_con-0 eta-0)))))
(define csegen-1867 (cons csegen-43 csegen-1826))
(define csegen-1870 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1867 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1867 i_con-0 eta-0)))))
(define csegen-1871 (cons csegen-1823 csegen-1640))
(define csegen-1874 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1871 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1871 i_con-0 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_Transform (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-5 arg-0 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 e-5 arg-0 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 e-5 arg-0 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) (vector 1 (vector e-5 e-6 e-7 e-8 e-9))))))))))))))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_Transform (lambda (arg-0 arg-1 ext-0) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-43 arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-0 arg-0 e-2) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((act-4 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 e-0 arg-0 e-3) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 e-0 arg-0 e-4) ext-0))))))))))))))))))))
(define csegen-1878 (cons csegen-43 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_Transform i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Transform i_con-0 eta-0))))))
(define csegen-1881 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1878 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1878 i_con-0 eta-0)))))
(define csegen-1882 (cons csegen-1640 csegen-1640))
(define csegen-1885 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1882 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1882 i_con-0 eta-0)))))
(define csegen-1889 (cons csegen-43 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1885 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1885 i_con-0 eta-0))))))
(define csegen-1892 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1889 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1889 i_con-0 eta-0)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bool (lambda (arg-0 arg-1) (cond ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0)))(else 0))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Bool (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bool arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1900 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bool arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_Bool arg-722 arg-725)))))
(define CoreC-45NameC-45Namespace-u--C-47C-61_Eq_Namespace (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1903(delay (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45NameC-45Namespace-u--C-47C-61_Eq_Namespace arg-722 arg-725))))))
(define csegen-1906 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1900 (force csegen-1903) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1900 (force csegen-1903) arg-722 arg-725)))))
(define csegen-1909 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-303 csegen-1906 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-303 csegen-1906 arg-722 arg-725)))))
(define PreludeC-45Types-either (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-2 (vector-ref arg-5 1))) ((arg-3) e-2))) (else (let ((e-5 (vector-ref arg-5 1))) ((arg-4) e-5))))))
(define CoreC-45Core-traverseList1 (lambda (arg-2 arg-3) (let ((u--x (let ((e-1 (car arg-3))) e-1))) (let ((u--xs (let ((e-2 (cdr arg-3))) e-2))) (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 csegen-1041 (arg-2 u--x) eta-1)) (CoreC-45Core-traverseC-39 arg-2 u--xs '()) eta-0))))))
(define CoreC-45Context-u--full_HasNames_CaseError (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (lambda (eta-0) (vector 1 (vector 0 )))) ((1) (lambda (eta-0) (vector 1 (vector 1 )))) ((2) (let ((e-0 (vector-ref arg-1 1))) (lambda (clam-0) (let ((e-4 (car e-0))) (let ((e-5 (cdr e-0))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-9) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) (vector 1 (vector 2 (cons e-4 (cons e-6 e-7))))))))))))))))))) ((3) (let ((e-1 (vector-ref arg-1 1))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1368 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-1 eta-1)) eta-0)))) (else (lambda (eta-0) (vector 1 (vector 4 )))))))
(define CoreC-45Context-u--full_HasNames_Covering (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 arg-7779)) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-5)))))))) (else (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-5)))))))))))
(define CoreC-45Context-u--full_HasNames_PartialReason (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-5)))))))) ((2) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) eta-0)) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (vector 2 e-5 e-6))))))))))))) (else (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) eta-0)) e-3 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 3 e-5)))))))))))
(define CoreC-45Context-u--full_HasNames_Warning (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (vector 1 (vector 0 e-0 e-1))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-6 (vector-ref eta-1 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 1 e-2 e-3 e-6 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-4 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-5) ext-0)))))) ((2) (let ((e-6 (vector-ref arg-1 1))) (let ((e-7 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 2 e-6 e-5)))))) (CoreC-45Core-traverseList1 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Core-traverseList1 (lambda (eta-2) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-2 eta-3))) eta-1)) eta-0)) e-7) ext-0)))) ((3) (let ((e-8 (vector-ref arg-1 1))) (let ((e-9 (vector-ref arg-1 2))) (let ((e-10 (vector-ref arg-1 3))) (let ((e-11 (vector-ref arg-1 4))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 3 e-8 e-9 e-10 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-11 eta-0)) ext-0)))))) ((4) (vector 1 arg-1)) ((5) (let ((e-14 (vector-ref arg-1 1))) (let ((e-15 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 5 e-14 e-15 e-5)))))) (if (null? e-16) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-16))) (let ((eff-0 (CoreC-45Core-traversePair (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))))) ext-0))))) (else (let ((e-17 (vector-ref arg-1 1))) (let ((e-18 (vector-ref arg-1 2))) (vector 1 (vector 6 e-17 e-18))))))))
(define CoreC-45Context-u--full_HasNames_Error (lambda (arg-0 arg-1) (lambda (clam-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1356 (CoreC-45Context-u--full_HasNames_Error arg-0 e-0) clam-0))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-5 (vector-ref arg-1 5))) (let ((e-6 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-7 (vector-ref eta-2 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 1 e-1 e-2 e-3 e-7 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-3 e-4 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-3 e-5) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-3 e-6) clam-0)))))))) ((2) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (let ((e-9 (vector-ref arg-1 3))) (let ((e-10 (vector-ref arg-1 4))) (let ((e-11 (vector-ref arg-1 5))) (let ((e-12 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 2 e-7 e-8 e-9 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-9 e-10 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-9 e-11) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-9 e-12) clam-0)))))))) ((3) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((e-15 (vector-ref arg-1 3))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (let ((e-18 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 3 e-13 e-14 e-15 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-16 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-17 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-18) clam-0)))))))) ((4) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (let ((e-22 (vector-ref arg-1 4))) (let ((e-23 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 4 e-19 e-20 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-21 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-22 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-23) clam-0))))))) ((5) (let ((e-24 (vector-ref arg-1 1))) (let ((e-25 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 3))) (let ((e-27 (vector-ref arg-1 4))) (let ((e-28 (vector-ref arg-1 5))) (let ((e-29 (vector-ref arg-1 6))) (let ((e-30 (vector-ref arg-1 7))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 5 e-24 e-25 e-26 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-26 e-27 eta-3)) eta-2)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-26 e-28) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-26 e-29) eta-0)) (CoreC-45Context-u--full_HasNames_Error e-26 e-30) clam-0))))))))) ((6) (let ((e-31 (vector-ref arg-1 1))) (let ((e-32 (vector-ref arg-1 2))) (let ((e-33 (vector-ref arg-1 3))) (let ((e-34 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 6 e-31 e-32 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-33 eta-1)) eta-0)) (PreludeC-45Types-either (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (force csegen-1357) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0) eta-1)))) (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (force csegen-1358) (CoreC-45Context-u--full_HasNames_Error arg-0 eta-0) eta-1)))) e-34) clam-0)))))) ((7) (let ((e-35 (vector-ref arg-1 1))) (let ((e-36 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 7 e-35 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-36 eta-0)) clam-0)))) ((8) (let ((e-37 (vector-ref arg-1 1))) (let ((e-38 (vector-ref arg-1 2))) (let ((e-39 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 8 e-37 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-38 eta-1)) eta-0)) (lambda (eta-0) (vector 1 e-39)) clam-0))))) ((9) (let ((e-40 (vector-ref arg-1 1))) (let ((e-41 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 9 e-40 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-41 eta-0)) clam-0)))) ((10) (let ((e-42 (vector-ref arg-1 1))) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 10 e-42 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-43 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-44 eta-0)) clam-0))))) ((11) (let ((e-45 (vector-ref arg-1 1))) (let ((e-46 (vector-ref arg-1 2))) (let ((e-47 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 11 e-45 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-46 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Covering arg-0 e-47 eta-0)) clam-0))))) ((12) (let ((e-48 (vector-ref arg-1 1))) (let ((e-49 (vector-ref arg-1 2))) (let ((e-50 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 12 e-48 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-49 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_PartialReason arg-0 e-50 eta-0)) clam-0))))) ((13) (let ((e-51 (vector-ref arg-1 1))) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 13 e-51 e-52 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-53 eta-0)) clam-0))))) ((14) (let ((e-54 (vector-ref arg-1 1))) (let ((e-55 (vector-ref arg-1 2))) (let ((e-56 (vector-ref arg-1 3))) (let ((e-57 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 14 e-54 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 e-55 eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-56)) eta-0)) (lambda (eta-0) (vector 1 e-57)) clam-0)))))) ((15) (let ((e-58 (vector-ref arg-1 1))) (let ((e-59 (vector-ref arg-1 2))) (let ((e-60 (vector-ref arg-1 3))) (let ((e-61 (vector-ref arg-1 4))) (let ((e-62 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 15 e-58 e-59 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-60 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-61) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-62) clam-0))))))) ((16) (let ((e-63 (vector-ref arg-1 1))) (let ((e-64 (vector-ref arg-1 2))) (let ((e-65 (vector-ref arg-1 3))) (let ((e-66 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 16 e-63 e-64 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-65 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-66) clam-0)))))) ((17) (let ((e-67 (vector-ref arg-1 1))) (let ((e-68 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 17 e-67 e-5)))))) (CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-68 '()) clam-0)))) ((18) (let ((e-69 (vector-ref arg-1 1))) (let ((e-70 (vector-ref arg-1 2))) (let ((e-71 (vector-ref arg-1 3))) (let ((e-72 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 18 e-69 e-70 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-71 eta-1)) eta-0)) (CoreC-45Core-traverseC-39 (lambda (lamc-0) (lambda (clam-1) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-4 (vector-ref eta-0 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (cons e-2 e-5)))))) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-2 e-3) clam-1))))) e-72 '()) clam-0)))))) ((19) (let ((e-73 (vector-ref arg-1 1))) (let ((e-74 (vector-ref arg-1 2))) (let ((e-75 (vector-ref arg-1 3))) (let ((e-76 (vector-ref arg-1 4))) (let ((e-77 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 19 e-73 e-74 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-75 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-76) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0)) e-77 '()) clam-0))))))) ((20) (let ((e-78 (vector-ref arg-1 1))) (let ((e-79 (vector-ref arg-1 2))) (let ((e-80 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 20 e-78 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-79 eta-1)) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-80 '()) clam-0))))) ((21) (let ((e-81 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1360 (PreludeC-45Basics-flip (force csegen-1361) e-81 (lambda (lamc-0) (lambda (clam-1) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1362 (if (null? e-2) (lambda (eta-1) (vector 1 '())) (let ((e-4 (unbox e-2))) (let ((eff-0 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-4 eta-1)))) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-1))))) eta-0)) (CoreC-45Context-u--full_HasNames_Error arg-0 e-3) clam-1)))))) clam-0))) ((22) (let ((e-82 (vector-ref arg-1 1))) (let ((e-83 (vector-ref arg-1 2))) (let ((e-84 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 22 e-82 e-83 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-84 eta-0)) clam-0))))) ((23) (let ((e-85 (vector-ref arg-1 1))) (let ((e-86 (vector-ref arg-1 2))) (vector 1 (vector 23 e-85 e-86))))) ((24) (let ((e-87 (vector-ref arg-1 1))) (let ((e-88 (vector-ref arg-1 2))) (let ((e-89 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 24 e-87 e-88 e-5)))))) (if (null? e-89) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-89))) (let ((eff-0 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 eta-0)))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))))) clam-0))))) ((25) (let ((e-90 (vector-ref arg-1 1))) (let ((e-91 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 25 e-90 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-91 eta-0)) clam-0)))) ((26) (let ((e-92 (vector-ref arg-1 1))) (let ((e-93 (vector-ref arg-1 2))) (vector 1 (vector 26 e-92 e-93))))) ((27) (let ((e-94 (vector-ref arg-1 1))) (let ((e-95 (vector-ref arg-1 2))) (let ((e-96 (vector-ref arg-1 3))) (let ((e-97 (vector-ref arg-1 4))) (let ((e-98 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 27 e-94 e-95 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-96 eta-2)) eta-1)) (CoreC-45Core-traverseC-39 (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) e-97 '()) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-98) clam-0))))))) ((28) (let ((e-99 (vector-ref arg-1 1))) (let ((e-100 (vector-ref arg-1 2))) (let ((e-101 (vector-ref arg-1 3))) (let ((e-102 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 28 e-99 e-100 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-101 eta-1)) eta-0)) (PreludeC-45Basics-flip (force csegen-1361) e-102 (lambda (lamc-0) (lambda (clam-2) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1362 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) clam-2)))))) clam-0)))))) ((29) (let ((e-103 (vector-ref arg-1 1))) (let ((e-104 (vector-ref arg-1 2))) (let ((e-105 (vector-ref arg-1 3))) (let ((e-106 (vector-ref arg-1 4))) (let ((e-107 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 29 e-103 e-104 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-105 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-106 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-107) clam-0))))))) ((30) (let ((e-108 (vector-ref arg-1 1))) (let ((e-109 (vector-ref arg-1 2))) (let ((e-110 (vector-ref arg-1 3))) (let ((e-111 (vector-ref arg-1 4))) (let ((e-112 (vector-ref arg-1 5))) (let ((e-113 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 30 e-108 e-109 e-110 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-110 e-111 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-110 e-112) eta-0)) (if (null? e-113) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-113))) (let ((eff-0 (CoreC-45Context-u--full_HasNames_Error e-110 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))))) clam-0)))))))) ((31) (let ((e-114 (vector-ref arg-1 1))) (let ((e-115 (vector-ref arg-1 2))) (let ((e-116 (vector-ref arg-1 3))) (let ((e-117 (vector-ref arg-1 4))) (let ((e-118 (vector-ref arg-1 5))) (let ((e-119 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 31 e-114 e-115 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_Name arg-0 e-116 eta-3)) eta-2)) (lambda (eta-2) (vector 1 e-117)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-118 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-119) clam-0)))))))) ((32) (let ((e-120 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1363 (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) eta-0)) e-120 '()) clam-0))) ((33) (let ((e-121 (vector-ref arg-1 1))) (let ((e-122 (vector-ref arg-1 2))) (let ((e-123 (vector-ref arg-1 3))) (let ((e-124 (vector-ref arg-1 4))) (let ((e-125 (vector-ref arg-1 5))) (let ((e-126 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 33 e-121 e-122 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-123 eta-3)) eta-2)) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 e-124 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-125 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-126) clam-0)))))))) ((34) (let ((e-127 (vector-ref arg-1 1))) (let ((e-128 (vector-ref arg-1 2))) (let ((e-129 (vector-ref arg-1 3))) (let ((e-130 (vector-ref arg-1 4))) (let ((e-131 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 34 e-127 e-128 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-129 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-130 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-131) clam-0))))))) ((35) (let ((e-132 (vector-ref arg-1 1))) (let ((e-133 (vector-ref arg-1 2))) (let ((e-134 (vector-ref arg-1 3))) (let ((e-135 (vector-ref arg-1 4))) (let ((e-136 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 35 e-132 e-133 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 e-134 eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-135)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-136 eta-0)) clam-0))))))) ((36) (let ((e-137 (vector-ref arg-1 1))) (let ((e-138 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 36 e-137 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-138 eta-0)) clam-0)))) ((37) (let ((e-139 (vector-ref arg-1 1))) (let ((e-140 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 37 e-139 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-140 eta-0)) clam-0)))) ((38) (let ((e-141 (vector-ref arg-1 1))) (let ((e-142 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 38 e-141 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-142 eta-0)) clam-0)))) ((39) (let ((e-143 (vector-ref arg-1 1))) (let ((e-144 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 39 e-143 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-144 eta-0)) clam-0)))) ((40) (let ((e-145 (vector-ref arg-1 1))) (let ((e-146 (vector-ref arg-1 2))) (let ((e-147 (vector-ref arg-1 3))) (let ((e-148 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 40 e-145 e-146 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-147 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-148) clam-0)))))) ((41) (let ((e-149 (vector-ref arg-1 1))) (let ((e-150 (vector-ref arg-1 2))) (let ((e-151 (vector-ref arg-1 3))) (let ((e-152 (vector-ref arg-1 4))) (let ((e-153 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 41 e-149 e-150 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-151 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-152) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-153) clam-0))))))) ((42) (let ((e-154 (vector-ref arg-1 1))) (let ((e-155 (vector-ref arg-1 2))) (let ((e-156 (vector-ref arg-1 3))) (let ((e-157 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 42 e-154 e-155 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-156 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-157) clam-0)))))) ((43) (let ((e-158 (vector-ref arg-1 1))) (let ((e-159 (vector-ref arg-1 2))) (let ((e-160 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 43 e-158 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-159 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_CaseError arg-0 e-160) clam-0))))) ((44) (let ((e-161 (vector-ref arg-1 1))) (let ((e-162 (vector-ref arg-1 2))) (let ((e-163 (vector-ref arg-1 3))) (let ((e-164 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 44 e-161 e-162 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-163 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-164) clam-0)))))) ((45) (let ((e-165 (vector-ref arg-1 1))) (let ((e-166 (vector-ref arg-1 2))) (let ((e-167 (vector-ref arg-1 3))) (let ((e-168 (vector-ref arg-1 4))) (let ((e-169 (vector-ref arg-1 5))) (let ((e-170 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 45 e-165 e-166 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-167 eta-3)) eta-2)) (lambda (eta-2) (vector 1 e-168)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-169) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-170) clam-0)))))))) ((46) (let ((e-171 (vector-ref arg-1 1))) (let ((e-172 (vector-ref arg-1 2))) (vector 1 (vector 46 e-171 e-172))))) ((47) (let ((e-173 (vector-ref arg-1 1))) (let ((e-174 (vector-ref arg-1 2))) (let ((e-175 (vector-ref arg-1 3))) (let ((e-176 (vector-ref arg-1 4))) (let ((e-177 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 47 e-173 e-174 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-175 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-176) eta-0)) (lambda (eta-0) (vector 1 e-177)) clam-0))))))) ((48) (let ((e-178 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1364 (CoreC-45Context-u--full_HasNames_Error arg-0 e-178) clam-0))) ((49) (let ((e-179 (vector-ref arg-1 1))) (let ((e-180 (vector-ref arg-1 2))) (vector 1 (vector 49 e-179 e-180))))) ((50) (let ((e-181 (vector-ref arg-1 1))) (let ((e-182 (vector-ref arg-1 2))) (let ((e-183 (vector-ref arg-1 3))) (let ((e-184 (vector-ref arg-1 4))) (vector 1 (vector 50 e-181 e-182 e-183 e-184))))))) ((52) (let ((e-185 (vector-ref arg-1 1))) (vector 1 (vector 52 e-185)))) ((53) (let ((e-186 (vector-ref arg-1 1))) (let ((e-187 (vector-ref arg-1 2))) (vector 1 (vector 53 e-186 e-187))))) ((54) (let ((e-188 (vector-ref arg-1 1))) (vector 1 (vector 54 e-188)))) ((55) (let ((e-189 (vector-ref arg-1 1))) (vector 1 (vector 55 e-189)))) ((56) (let ((e-190 (vector-ref arg-1 1))) (vector 1 (vector 56 e-190)))) ((57) (let ((e-191 (vector-ref arg-1 1))) (vector 1 (vector 57 e-191)))) ((58) (let ((e-192 (vector-ref arg-1 1))) (let ((e-193 (vector-ref arg-1 2))) (vector 1 (vector 58 e-192 e-193))))) ((59) (let ((e-194 (vector-ref arg-1 1))) (vector 1 (vector 59 e-194)))) ((60) (let ((e-195 (vector-ref arg-1 1))) (let ((e-196 (vector-ref arg-1 2))) (vector 1 (vector 60 e-195 e-196))))) ((61) (let ((e-197 (vector-ref arg-1 1))) (vector 1 (vector 61 e-197)))) ((62) (vector 1 (vector 62 ))) ((63) (let ((e-198 (vector-ref arg-1 1))) (vector 1 (vector 63 e-198)))) ((64) (let ((e-199 (vector-ref arg-1 1))) (vector 1 (vector 64 e-199)))) ((65) (let ((e-200 (vector-ref arg-1 1))) (let ((e-201 (vector-ref arg-1 2))) (vector 1 (vector 65 e-200 e-201))))) ((66) (let ((e-202 (vector-ref arg-1 1))) (let ((e-203 (vector-ref arg-1 2))) (vector 1 (vector 66 e-202 e-203))))) ((67) (let ((e-204 (vector-ref arg-1 1))) (vector 1 (vector 67 e-204)))) ((68) (let ((e-205 (vector-ref arg-1 1))) (vector 1 (vector 68 e-205)))) ((69) (let ((e-206 (vector-ref arg-1 1))) (let ((e-207 (vector-ref arg-1 2))) (let ((e-208 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 69 e-206 e-207 e-5)))))) (CoreC-45Core-traverseList1 (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_Error arg-0 arg-7779)) e-208) clam-0))))) ((70) (let ((e-209 (vector-ref arg-1 1))) (let ((e-210 (vector-ref arg-1 2))) (let ((e-211 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 70 e-209 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-210 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_Error arg-0 e-211) clam-0))))) ((71) (let ((e-212 (vector-ref arg-1 1))) (let ((e-213 (vector-ref arg-1 2))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1365 (let ((e-2 (car e-212))) (let ((e-3 (cdr e-212))) (let ((eff-0 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-3 eta-1)))) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-4 (vector-ref eta-2 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (cons e-2 e-5)))))) eff-0 eta-1))))) eta-0)) (CoreC-45Context-u--full_HasNames_Error arg-0 e-213) clam-0)))) ((72) (let ((e-214 (vector-ref arg-1 1))) (let ((e-215 (vector-ref arg-1 2))) (let ((e-216 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 72 e-214 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-215 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_Error arg-0 e-216) clam-0))))) ((73) (let ((e-217 (vector-ref arg-1 1))) (let ((e-218 (vector-ref arg-1 2))) (let ((e-219 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 73 e-217 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-218 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_Error arg-0 e-219) clam-0))))) ((74) (let ((e-220 (vector-ref arg-1 1))) (let ((e-221 (vector-ref arg-1 2))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1366 (CoreC-45Context-u--full_HasNames_Error arg-0 e-220) eta-0)) (lambda (eta-0) (vector 1 e-221)) clam-0)))) ((75) (let ((e-222 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1367 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Warning arg-0 e-222 eta-0)) clam-0))) (else (let ((e-223 (vector-ref arg-1 1))) (let ((e-224 (vector-ref arg-1 2))) (let ((e-225 (vector-ref arg-1 3))) (let ((e-226 (vector-ref arg-1 4))) (let ((e-227 (vector-ref arg-1 5))) (let ((e-228 (vector-ref arg-1 6))) (let ((e-229 (vector-ref arg-1 7))) (let ((e-230 (vector-ref arg-1 8))) (case (vector-ref e-228 0) ((0) (let ((e-233 (vector-ref e-228 1))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 51 e-223 e-224 e-225 e-226 e-227 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (force csegen-1357) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_Name arg-0 e-233 eta-3)) eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-229)) eta-0)) (lambda (eta-0) (vector 1 e-230)) clam-0))) (else (let ((e-236 (vector-ref e-228 1))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 51 e-223 e-224 e-225 e-226 e-227 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (force csegen-1358) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_Name arg-0 e-236 eta-3)) eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-229)) eta-0)) (lambda (eta-0) (vector 1 e-230)) clam-0)))))))))))))))))
(define CoreC-45Context-u--resolved_HasNames_CaseError (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (lambda (eta-0) (vector 1 (vector 0 )))) ((1) (lambda (eta-0) (vector 1 (vector 1 )))) ((2) (let ((e-0 (vector-ref arg-1 1))) (lambda (clam-0) (let ((e-4 (car e-0))) (let ((e-5 (cdr e-0))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-9) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) (vector 1 (vector 2 (cons e-4 (cons e-6 e-7))))))))))))))))))) ((3) (let ((e-1 (vector-ref arg-1 1))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1368 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-1) eta-0)))) (else (lambda (eta-0) (vector 1 (vector 4 )))))))
(define CoreC-45Context-u--resolved_HasNames_Warning (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (vector 1 (vector 0 e-0 e-1))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-6 (vector-ref eta-1 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 1 e-2 e-3 e-6 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-4 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-5) ext-0)))))) ((2) (let ((e-6 (vector-ref arg-1 1))) (let ((e-7 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 2 e-6 e-5)))))) (CoreC-45Core-traverseList1 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Core-traverseList1 (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-2)) eta-1)) eta-0)) e-7) ext-0)))) ((3) (let ((e-8 (vector-ref arg-1 1))) (let ((e-9 (vector-ref arg-1 2))) (let ((e-10 (vector-ref arg-1 3))) (let ((e-11 (vector-ref arg-1 4))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 3 e-8 e-9 e-10 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-11) ext-0)))))) ((4) (vector 1 arg-1)) ((5) (let ((e-14 (vector-ref arg-1 1))) (let ((e-15 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 5 e-14 e-15 e-5)))))) (if (null? e-16) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-16))) (let ((eff-0 (CoreC-45Core-traversePair (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))))) ext-0))))) (else (let ((e-17 (vector-ref arg-1 1))) (let ((e-18 (vector-ref arg-1 2))) (vector 1 (vector 6 e-17 e-18))))))))
(define CoreC-45Context-u--resolved_HasNames_Error (lambda (arg-0 arg-1) (lambda (clam-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1356 (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-0) clam-0))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-5 (vector-ref arg-1 5))) (let ((e-6 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-7 (vector-ref eta-2 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 1 e-1 e-2 e-3 e-7 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-3 e-4 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-3 e-5) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-3 e-6) clam-0)))))))) ((2) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (let ((e-9 (vector-ref arg-1 3))) (let ((e-10 (vector-ref arg-1 4))) (let ((e-11 (vector-ref arg-1 5))) (let ((e-12 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 2 e-7 e-8 e-9 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-9 e-10 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-9 e-11) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-9 e-12) clam-0)))))))) ((3) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((e-15 (vector-ref arg-1 3))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (let ((e-18 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 3 e-13 e-14 e-15 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-16 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-17) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-18) clam-0)))))))) ((4) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (let ((e-22 (vector-ref arg-1 4))) (let ((e-23 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 4 e-19 e-20 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-21 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-22) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-23) clam-0))))))) ((5) (let ((e-24 (vector-ref arg-1 1))) (let ((e-25 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 3))) (let ((e-27 (vector-ref arg-1 4))) (let ((e-28 (vector-ref arg-1 5))) (let ((e-29 (vector-ref arg-1 6))) (let ((e-30 (vector-ref arg-1 7))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 5 e-24 e-25 e-26 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-26 e-27 eta-3)) eta-2)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-26 e-28) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-26 e-29) eta-0)) (CoreC-45Context-u--resolved_HasNames_Error e-26 e-30) clam-0))))))))) ((6) (let ((e-31 (vector-ref arg-1 1))) (let ((e-32 (vector-ref arg-1 2))) (let ((e-33 (vector-ref arg-1 3))) (let ((e-34 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 6 e-31 e-32 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-33 eta-1)) eta-0)) (PreludeC-45Types-either (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (force csegen-1357) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0) eta-1)))) (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (force csegen-1358) (CoreC-45Context-u--resolved_HasNames_Error arg-0 eta-0) eta-1)))) e-34) clam-0)))))) ((7) (let ((e-35 (vector-ref arg-1 1))) (let ((e-36 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 7 e-35 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-36) clam-0)))) ((8) (let ((e-37 (vector-ref arg-1 1))) (let ((e-38 (vector-ref arg-1 2))) (let ((e-39 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 8 e-37 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-38) eta-0)) (lambda (eta-0) (vector 1 e-39)) clam-0))))) ((9) (let ((e-40 (vector-ref arg-1 1))) (let ((e-41 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 9 e-40 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-41) clam-0)))) ((10) (let ((e-42 (vector-ref arg-1 1))) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 10 e-42 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-43) eta-0)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-44) clam-0))))) ((11) (let ((e-45 (vector-ref arg-1 1))) (let ((e-46 (vector-ref arg-1 2))) (let ((e-47 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 11 e-45 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-46) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Covering arg-0 e-47 eta-0)) clam-0))))) ((12) (let ((e-48 (vector-ref arg-1 1))) (let ((e-49 (vector-ref arg-1 2))) (let ((e-50 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 12 e-48 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-49) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_PartialReason arg-0 e-50 eta-0)) clam-0))))) ((13) (let ((e-51 (vector-ref arg-1 1))) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 13 e-51 e-52 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-53) clam-0))))) ((14) (let ((e-54 (vector-ref arg-1 1))) (let ((e-55 (vector-ref arg-1 2))) (let ((e-56 (vector-ref arg-1 3))) (let ((e-57 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 14 e-54 e-5 eta-3 eta-4)))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-55) eta-1)) (lambda (eta-1) (vector 1 e-56)) eta-0)) (lambda (eta-0) (vector 1 e-57)) clam-0)))))) ((15) (let ((e-58 (vector-ref arg-1 1))) (let ((e-59 (vector-ref arg-1 2))) (let ((e-60 (vector-ref arg-1 3))) (let ((e-61 (vector-ref arg-1 4))) (let ((e-62 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 15 e-58 e-59 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-60 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-61) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-62) clam-0))))))) ((16) (let ((e-63 (vector-ref arg-1 1))) (let ((e-64 (vector-ref arg-1 2))) (let ((e-65 (vector-ref arg-1 3))) (let ((e-66 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 16 e-63 e-64 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-65 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-66) clam-0)))))) ((17) (let ((e-67 (vector-ref arg-1 1))) (let ((e-68 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 17 e-67 e-5)))))) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-68 '()) clam-0)))) ((18) (let ((e-69 (vector-ref arg-1 1))) (let ((e-70 (vector-ref arg-1 2))) (let ((e-71 (vector-ref arg-1 3))) (let ((e-72 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 18 e-69 e-70 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-71 eta-1)) eta-0)) (CoreC-45Core-traverseC-39 (lambda (lamc-0) (lambda (clam-1) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-4 (vector-ref eta-0 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (cons e-2 e-5)))))) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-2 e-3) clam-1))))) e-72 '()) clam-0)))))) ((19) (let ((e-73 (vector-ref arg-1 1))) (let ((e-74 (vector-ref arg-1 2))) (let ((e-75 (vector-ref arg-1 3))) (let ((e-76 (vector-ref arg-1 4))) (let ((e-77 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 19 e-73 e-74 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-75 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-76) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0)) e-77 '()) clam-0))))))) ((20) (let ((e-78 (vector-ref arg-1 1))) (let ((e-79 (vector-ref arg-1 2))) (let ((e-80 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 20 e-78 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-79) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-80 '()) clam-0))))) ((21) (let ((e-81 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1360 (PreludeC-45Basics-flip (force csegen-1361) e-81 (lambda (lamc-0) (lambda (clam-1) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1362 (if (null? e-2) (lambda (eta-1) (vector 1 '())) (let ((e-4 (unbox e-2))) (let ((eff-0 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-4))) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-1))))) eta-0)) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-3) clam-1)))))) clam-0))) ((22) (let ((e-82 (vector-ref arg-1 1))) (let ((e-83 (vector-ref arg-1 2))) (let ((e-84 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 22 e-82 e-83 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-84 eta-0)) clam-0))))) ((23) (let ((e-85 (vector-ref arg-1 1))) (let ((e-86 (vector-ref arg-1 2))) (vector 1 (vector 23 e-85 e-86))))) ((24) (let ((e-87 (vector-ref arg-1 1))) (let ((e-88 (vector-ref arg-1 2))) (let ((e-89 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 24 e-87 e-88 e-5)))))) (if (null? e-89) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-89))) (let ((eff-0 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))))) clam-0))))) ((25) (let ((e-90 (vector-ref arg-1 1))) (let ((e-91 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 25 e-90 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-91) clam-0)))) ((26) (let ((e-92 (vector-ref arg-1 1))) (let ((e-93 (vector-ref arg-1 2))) (vector 1 (vector 26 e-92 e-93))))) ((27) (let ((e-94 (vector-ref arg-1 1))) (let ((e-95 (vector-ref arg-1 2))) (let ((e-96 (vector-ref arg-1 3))) (let ((e-97 (vector-ref arg-1 4))) (let ((e-98 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 27 e-94 e-95 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-96 eta-2)) eta-1)) (CoreC-45Core-traverseC-39 (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) e-97 '()) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-98) clam-0))))))) ((28) (let ((e-99 (vector-ref arg-1 1))) (let ((e-100 (vector-ref arg-1 2))) (let ((e-101 (vector-ref arg-1 3))) (let ((e-102 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 28 e-99 e-100 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-101 eta-1)) eta-0)) (PreludeC-45Basics-flip (force csegen-1361) e-102 (lambda (lamc-0) (lambda (clam-2) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1362 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) clam-2)))))) clam-0)))))) ((29) (let ((e-103 (vector-ref arg-1 1))) (let ((e-104 (vector-ref arg-1 2))) (let ((e-105 (vector-ref arg-1 3))) (let ((e-106 (vector-ref arg-1 4))) (let ((e-107 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 29 e-103 e-104 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-105 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-106) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-107) clam-0))))))) ((30) (let ((e-108 (vector-ref arg-1 1))) (let ((e-109 (vector-ref arg-1 2))) (let ((e-110 (vector-ref arg-1 3))) (let ((e-111 (vector-ref arg-1 4))) (let ((e-112 (vector-ref arg-1 5))) (let ((e-113 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 30 e-108 e-109 e-110 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-110 e-111 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-110 e-112) eta-0)) (if (null? e-113) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-113))) (let ((eff-0 (CoreC-45Context-u--resolved_HasNames_Error e-110 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))))) clam-0)))))))) ((31) (let ((e-114 (vector-ref arg-1 1))) (let ((e-115 (vector-ref arg-1 2))) (let ((e-116 (vector-ref arg-1 3))) (let ((e-117 (vector-ref arg-1 4))) (let ((e-118 (vector-ref arg-1 5))) (let ((e-119 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 31 e-114 e-115 e-5 eta-4 eta-5 eta-6))))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-116) eta-2)) (lambda (eta-2) (vector 1 e-117)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-118 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-119) clam-0)))))))) ((32) (let ((e-120 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1363 (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) eta-0)) e-120 '()) clam-0))) ((33) (let ((e-121 (vector-ref arg-1 1))) (let ((e-122 (vector-ref arg-1 2))) (let ((e-123 (vector-ref arg-1 3))) (let ((e-124 (vector-ref arg-1 4))) (let ((e-125 (vector-ref arg-1 5))) (let ((e-126 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 33 e-121 e-122 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-123 eta-3)) eta-2)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-124) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-125) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-126) clam-0)))))))) ((34) (let ((e-127 (vector-ref arg-1 1))) (let ((e-128 (vector-ref arg-1 2))) (let ((e-129 (vector-ref arg-1 3))) (let ((e-130 (vector-ref arg-1 4))) (let ((e-131 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 34 e-127 e-128 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-129 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-130) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-131) clam-0))))))) ((35) (let ((e-132 (vector-ref arg-1 1))) (let ((e-133 (vector-ref arg-1 2))) (let ((e-134 (vector-ref arg-1 3))) (let ((e-135 (vector-ref arg-1 4))) (let ((e-136 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 35 e-132 e-133 e-5 eta-3 eta-4)))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-134) eta-1)) (lambda (eta-1) (vector 1 e-135)) eta-0)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-136) clam-0))))))) ((36) (let ((e-137 (vector-ref arg-1 1))) (let ((e-138 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 36 e-137 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-138) clam-0)))) ((37) (let ((e-139 (vector-ref arg-1 1))) (let ((e-140 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 37 e-139 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-140) clam-0)))) ((38) (let ((e-141 (vector-ref arg-1 1))) (let ((e-142 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 38 e-141 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-142) clam-0)))) ((39) (let ((e-143 (vector-ref arg-1 1))) (let ((e-144 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 39 e-143 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-144) clam-0)))) ((40) (let ((e-145 (vector-ref arg-1 1))) (let ((e-146 (vector-ref arg-1 2))) (let ((e-147 (vector-ref arg-1 3))) (let ((e-148 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 40 e-145 e-146 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-147 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-148) clam-0)))))) ((41) (let ((e-149 (vector-ref arg-1 1))) (let ((e-150 (vector-ref arg-1 2))) (let ((e-151 (vector-ref arg-1 3))) (let ((e-152 (vector-ref arg-1 4))) (let ((e-153 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 41 e-149 e-150 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-151 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-152) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-153) clam-0))))))) ((42) (let ((e-154 (vector-ref arg-1 1))) (let ((e-155 (vector-ref arg-1 2))) (let ((e-156 (vector-ref arg-1 3))) (let ((e-157 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 42 e-154 e-155 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-156 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-157) clam-0)))))) ((43) (let ((e-158 (vector-ref arg-1 1))) (let ((e-159 (vector-ref arg-1 2))) (let ((e-160 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 43 e-158 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-159) eta-0)) (CoreC-45Context-u--resolved_HasNames_CaseError arg-0 e-160) clam-0))))) ((44) (let ((e-161 (vector-ref arg-1 1))) (let ((e-162 (vector-ref arg-1 2))) (let ((e-163 (vector-ref arg-1 3))) (let ((e-164 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 44 e-161 e-162 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-163 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-164) clam-0)))))) ((45) (let ((e-165 (vector-ref arg-1 1))) (let ((e-166 (vector-ref arg-1 2))) (let ((e-167 (vector-ref arg-1 3))) (let ((e-168 (vector-ref arg-1 4))) (let ((e-169 (vector-ref arg-1 5))) (let ((e-170 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 45 e-165 e-166 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-167 eta-3)) eta-2)) (lambda (eta-2) (vector 1 e-168)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-169) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-170) clam-0)))))))) ((46) (let ((e-171 (vector-ref arg-1 1))) (let ((e-172 (vector-ref arg-1 2))) (vector 1 (vector 46 e-171 e-172))))) ((47) (let ((e-173 (vector-ref arg-1 1))) (let ((e-174 (vector-ref arg-1 2))) (let ((e-175 (vector-ref arg-1 3))) (let ((e-176 (vector-ref arg-1 4))) (let ((e-177 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 47 e-173 e-174 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-175 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-176) eta-0)) (lambda (eta-0) (vector 1 e-177)) clam-0))))))) ((48) (let ((e-178 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1364 (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-178) clam-0))) ((49) (let ((e-179 (vector-ref arg-1 1))) (let ((e-180 (vector-ref arg-1 2))) (vector 1 (vector 49 e-179 e-180))))) ((50) (let ((e-181 (vector-ref arg-1 1))) (let ((e-182 (vector-ref arg-1 2))) (let ((e-183 (vector-ref arg-1 3))) (let ((e-184 (vector-ref arg-1 4))) (vector 1 (vector 50 e-181 e-182 e-183 e-184))))))) ((52) (let ((e-185 (vector-ref arg-1 1))) (vector 1 (vector 52 e-185)))) ((53) (let ((e-186 (vector-ref arg-1 1))) (let ((e-187 (vector-ref arg-1 2))) (vector 1 (vector 53 e-186 e-187))))) ((54) (let ((e-188 (vector-ref arg-1 1))) (vector 1 (vector 54 e-188)))) ((55) (let ((e-189 (vector-ref arg-1 1))) (vector 1 (vector 55 e-189)))) ((56) (let ((e-190 (vector-ref arg-1 1))) (vector 1 (vector 56 e-190)))) ((57) (let ((e-191 (vector-ref arg-1 1))) (vector 1 (vector 57 e-191)))) ((58) (let ((e-192 (vector-ref arg-1 1))) (let ((e-193 (vector-ref arg-1 2))) (vector 1 (vector 58 e-192 e-193))))) ((59) (let ((e-194 (vector-ref arg-1 1))) (vector 1 (vector 59 e-194)))) ((60) (let ((e-195 (vector-ref arg-1 1))) (let ((e-196 (vector-ref arg-1 2))) (vector 1 (vector 60 e-195 e-196))))) ((61) (let ((e-197 (vector-ref arg-1 1))) (vector 1 (vector 61 e-197)))) ((62) (vector 1 (vector 62 ))) ((63) (let ((e-198 (vector-ref arg-1 1))) (vector 1 (vector 63 e-198)))) ((64) (let ((e-199 (vector-ref arg-1 1))) (vector 1 (vector 64 e-199)))) ((65) (let ((e-200 (vector-ref arg-1 1))) (let ((e-201 (vector-ref arg-1 2))) (vector 1 (vector 65 e-200 e-201))))) ((66) (let ((e-202 (vector-ref arg-1 1))) (let ((e-203 (vector-ref arg-1 2))) (vector 1 (vector 66 e-202 e-203))))) ((67) (let ((e-204 (vector-ref arg-1 1))) (vector 1 (vector 67 e-204)))) ((68) (let ((e-205 (vector-ref arg-1 1))) (vector 1 (vector 68 e-205)))) ((69) (let ((e-206 (vector-ref arg-1 1))) (let ((e-207 (vector-ref arg-1 2))) (let ((e-208 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 69 e-206 e-207 e-5)))))) (CoreC-45Core-traverseList1 (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_Error arg-0 arg-7789)) e-208) clam-0))))) ((70) (let ((e-209 (vector-ref arg-1 1))) (let ((e-210 (vector-ref arg-1 2))) (let ((e-211 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 70 e-209 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-210) eta-0)) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-211) clam-0))))) ((71) (let ((e-212 (vector-ref arg-1 1))) (let ((e-213 (vector-ref arg-1 2))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1365 (let ((e-2 (car e-212))) (let ((e-3 (cdr e-212))) (let ((eff-0 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-3))) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-4 (vector-ref eta-2 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (cons e-2 e-5)))))) eff-0 eta-1))))) eta-0)) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-213) clam-0)))) ((72) (let ((e-214 (vector-ref arg-1 1))) (let ((e-215 (vector-ref arg-1 2))) (let ((e-216 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 72 e-214 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-215) eta-0)) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-216) clam-0))))) ((73) (let ((e-217 (vector-ref arg-1 1))) (let ((e-218 (vector-ref arg-1 2))) (let ((e-219 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 73 e-217 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-218) eta-0)) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-219) clam-0))))) ((74) (let ((e-220 (vector-ref arg-1 1))) (let ((e-221 (vector-ref arg-1 2))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1366 (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-220) eta-0)) (lambda (eta-0) (vector 1 e-221)) clam-0)))) ((75) (let ((e-222 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1367 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Warning arg-0 e-222 eta-0)) clam-0))) (else (let ((e-223 (vector-ref arg-1 1))) (let ((e-224 (vector-ref arg-1 2))) (let ((e-225 (vector-ref arg-1 3))) (let ((e-226 (vector-ref arg-1 4))) (let ((e-227 (vector-ref arg-1 5))) (let ((e-228 (vector-ref arg-1 6))) (let ((e-229 (vector-ref arg-1 7))) (let ((e-230 (vector-ref arg-1 8))) (case (vector-ref e-228 0) ((0) (let ((e-233 (vector-ref e-228 1))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 51 e-223 e-224 e-225 e-226 e-227 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (force csegen-1357) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-233) eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-229)) eta-0)) (lambda (eta-0) (vector 1 e-230)) clam-0))) (else (let ((e-236 (vector-ref e-228 1))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 51 e-223 e-224 e-225 e-226 e-227 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (force csegen-1358) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-236) eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-229)) eta-0)) (lambda (eta-0) (vector 1 e-230)) clam-0)))))))))))))))))
(define csegen-1913 (cons (lambda (arg-7776) (lambda (arg-7779) (CoreC-45Context-u--full_HasNames_Error arg-7776 arg-7779))) (lambda (arg-7786) (lambda (arg-7789) (CoreC-45Context-u--resolved_HasNames_Error arg-7786 arg-7789)))))
(define AlgebraC-45ZeroOneOmega-u--showPrec_Show_ZeroOneOmega (lambda (arg-0 arg-1) (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega arg-1)))
(define csegen-1915(delay (cons (lambda (u--x) (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega u--x)) (lambda (u--d) (lambda (u--x) (AlgebraC-45ZeroOneOmega-u--showPrec_Show_ZeroOneOmega u--d u--x))))))
(define csegen-1916(delay (cons (force csegen-287) (force csegen-1915))))
(define csegen-1920(delay (cons (force csegen-68) (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-1916) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-1916) u--d u--x)))))))
(define csegen-1921(delay (cons (force csegen-68) (force csegen-514))))
(define csegen-1926(delay (cons (force csegen-514) (force csegen-292))))
(define csegen-1930(delay (lambda (eta-0) (Builtin-snd (Builtin-snd eta-0)))))
(define LibrariesC-45DataC-45IntMap-treeInsertC-39 (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (let ((sc1 (PreludeC-45EqOrd-u--compare_Ord_Int arg-2 e-1))) (cond ((equal? sc1 0) (vector 1 (cons (vector 0 arg-2 arg-3) (cons arg-2 (vector 0 e-1 e-2))))) ((equal? sc1 1) (vector 0 (vector 0 arg-2 arg-3))) (else (vector 1 (cons (vector 0 e-1 e-2) (cons e-1 (vector 0 arg-2 arg-3)))))))))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-6))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-5))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-2 e-6 e-7)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-10 e-12 e-13 e-6 e-7))))))))))) (else (let ((sc2 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-7))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-5 e-6 e-2)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-5 e-6 e-10 e-12 e-13))))))))))))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) (let ((e-14 (vector-ref arg-4 5))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-11))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-10))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 2 e-2 e-11 e-12 e-13 e-14)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-8 e-16 e-15) (cons e-11 (vector 1 e-12 e-13 e-14))))))))))))) (else (let ((sc2 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-13))) (cond ((equal? sc2 1) (let ((sc3 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-12))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-2 e-13 e-14)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-8) (cons e-16 (vector 1 e-15 e-13 e-14))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-14))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-12 e-13 e-2)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-12) (cons e-13 (vector 1 e-8 e-16 e-15)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45IntMap-treeInsert (lambda (arg-2 arg-3 arg-4) (let ((sc0 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 arg-4))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref sc0 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (vector 1 e-8 e-12 e-13))))))))))))
(define LibrariesC-45DataC-45IntMap-insert (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (cons 0 (vector 0 arg-1 arg-2)) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((sc1 (LibrariesC-45DataC-45IntMap-treeInsert arg-1 arg-2 e-3))) (case (vector-ref sc1 0) ((0) (let ((e-4 (vector-ref sc1 1))) (cons e-2 e-4))) (else (let ((e-5 (vector-ref sc1 1))) (cons (+ e-2 1) e-5))))))))))
(define LibrariesC-45DataC-45IntMap-insertFrom (lambda (ext-0 ext-1) (PreludeC-45Basics-flip (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldl_Foldable_List (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (PreludeC-45Basics-uncurry (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (LibrariesC-45DataC-45IntMap-insert eta-3 eta-4 eta-5)))) eta-2)) eta-0 eta-1))) u--init u--input))) ext-0 ext-1)))
(define LibrariesC-45DataC-45IntMap-n--5340-3205-u--treeToListC-39 (lambda (arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (cons (cons e-1 e-2) arg-3)))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 3))) (LibrariesC-45DataC-45IntMap-n--5340-3205-u--treeToListC-39 (LibrariesC-45DataC-45IntMap-n--5340-3205-u--treeToListC-39 arg-3 e-7) e-5)))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-14 (vector-ref arg-4 5))) (LibrariesC-45DataC-45IntMap-n--5340-3205-u--treeToListC-39 (LibrariesC-45DataC-45IntMap-n--5340-3205-u--treeToListC-39 (LibrariesC-45DataC-45IntMap-n--5340-3205-u--treeToListC-39 arg-3 e-14) e-12) e-10))))))))
(define LibrariesC-45DataC-45IntMap-treeToList (lambda (ext-0) (LibrariesC-45DataC-45IntMap-n--5340-3205-u--treeToListC-39 '() ext-0)))
(define LibrariesC-45DataC-45IntMap-toList (lambda (arg-1) (if (null? arg-1) '() (let ((e-3 (cdr arg-1))) (LibrariesC-45DataC-45IntMap-treeToList e-3)))))
(define LibrariesC-45DataC-45IntMap-n--5893-3762-u--inserted (lambda (arg-1 arg-2 arg-3) (PreludeC-45Types-listBind (LibrariesC-45DataC-45IntMap-toList arg-1) (lambda (_-0) (let ((e-2 (car _-0))) (let ((e-3 (cdr _-0))) (let ((u--vC-39 ((PreludeC-45Types-maybe (lambda () (lambda (eta-0) eta-0)) (lambda () arg-3) (LibrariesC-45DataC-45IntMap-lookup e-2 arg-2)) e-3))) (PreludeC-45Types-u--pure_Applicative_List (cons e-2 u--vC-39)))))))))
(define LibrariesC-45DataC-45IntMap-mergeWith (lambda (arg-1 arg-2 arg-3) (LibrariesC-45DataC-45IntMap-insertFrom (LibrariesC-45DataC-45IntMap-n--5893-3762-u--inserted arg-3 arg-2 arg-1) arg-2)))
(define LibrariesC-45DataC-45IntMap-merge (lambda (arg-1 ext-0 ext-1) (LibrariesC-45DataC-45IntMap-mergeWith arg-1 ext-0 ext-1)))
(define LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (arg-1 ext-0 ext-1) (LibrariesC-45DataC-45IntMap-merge arg-1 ext-0 ext-1)))
(define LibrariesC-45DataC-45IntMap-empty '())
(define LibrariesC-45DataC-45IntMap-u--neutral_Monoid_C-40IntMapC-32C-36vC-41 (lambda (arg-1) LibrariesC-45DataC-45IntMap-empty))
(define csegen-1933(delay (cons (lambda (arg-8505) (lambda (arg-8508) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) 'erased)) arg-8505 arg-8508))) (LibrariesC-45DataC-45IntMap-u--neutral_Monoid_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) 'erased))))))
(define csegen-1934 (cons (force csegen-514) (force csegen-68)))
(define CompilerC-45VMCode-u--show_Show_Reg (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "RVAL") ((1) (let ((e-0 (vector-ref arg-0 1))) (string-append "v" (PreludeC-45Show-u--show_Show_Int e-0)))) (else "DISCARD"))))
(define csegen-1942 (lambda () (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1939) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 (csegen-1939) u--d u--x))))))
(define csegen-1943 (lambda () (cons (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 csegen-1934 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 csegen-1934 u--d u--x)))) (csegen-1942))))
(define CoreC-45TTC-45Primitive-u--showPrec_Show_Constant (lambda (arg-0 arg-1) (CoreC-45TTC-45Primitive-u--show_Show_Constant arg-1)))
(define csegen-1948(delay (cons (lambda (u--x) (CoreC-45TTC-45Primitive-u--show_Show_Constant u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Primitive-u--showPrec_Show_Constant u--d u--x))))))
(define csegen-1949 (lambda () (cons (force csegen-1948) (csegen-1942))))
(define CompilerC-45VMCode-u--show_Show_VMInst (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (string-append "DECLARE " (CompilerC-45VMCode-u--show_Show_Reg e-0)))) ((1) "START") ((2) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-1) (string-append " := " (CompilerC-45VMCode-u--show_Show_Reg e-2)))))) ((3) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-3) (string-append " := MKCON " (string-append (PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 csegen-1934 e-4) (string-append " (" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-5)) ")"))))))))) ((4) (let ((e-6 (vector-ref arg-0 1))) (let ((e-7 (vector-ref arg-0 2))) (let ((e-8 (vector-ref arg-0 3))) (let ((e-9 (vector-ref arg-0 4))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-6) (string-append " := MKCLOSURE " (string-append (CoreC-45Name-u--show_Show_Name e-7) (string-append " " (string-append (PreludeC-45Show-u--show_Show_Nat e-8) (string-append " (" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-9)) ")")))))))))))) ((5) (let ((e-10 (vector-ref arg-0 1))) (let ((e-11 (vector-ref arg-0 2))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-10) (string-append " := MKCONSTANT " (CoreC-45TTC-45Primitive-u--show_Show_Constant e-11)))))) ((6) (let ((e-12 (vector-ref arg-0 1))) (let ((e-13 (vector-ref arg-0 2))) (let ((e-14 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-12) (string-append " := " (string-append (CompilerC-45VMCode-u--show_Show_Reg e-13) (string-append " @ " (CompilerC-45VMCode-u--show_Show_Reg e-14))))))))) ((7) (let ((e-15 (vector-ref arg-0 1))) (let ((e-16 (vector-ref arg-0 2))) (let ((e-17 (vector-ref arg-0 3))) (let ((e-18 (vector-ref arg-0 4))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-15) (string-append " := " (string-append (cond ((equal? e-16 1) "TAILCALL ") (else "CALL ")) (string-append (CoreC-45Name-u--show_Show_Name e-17) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-18)) ")"))))))))))) ((8) (let ((e-20 (vector-ref arg-0 1))) (let ((e-21 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-20) (string-append " := " (string-append "OP " (string-append (CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 e-21) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 e-22))) ")")))))))))) ((9) (let ((e-23 (vector-ref arg-0 1))) (let ((e-24 (vector-ref arg-0 2))) (let ((e-25 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-23) (string-append " := " (string-append "EXTPRIM " (string-append (CoreC-45Name-u--show_Show_Name e-24) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-25)) ")")))))))))) ((10) (let ((e-26 (vector-ref arg-0 1))) (let ((e-27 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 3))) (string-append "CASE " (string-append (CompilerC-45VMCode-u--show_Show_Reg e-26) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1943) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1943) u--d u--x)))) e-27) (string-append " {default: " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1942) e-28) "}")))))))))) ((11) (let ((e-29 (vector-ref arg-0 1))) (let ((e-30 (vector-ref arg-0 2))) (let ((e-31 (vector-ref arg-0 3))) (string-append "CASE " (string-append (CompilerC-45VMCode-u--show_Show_Reg e-29) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1949) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1949) u--d u--x)))) e-30) (string-append " {default: " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1942) e-31) "}")))))))))) ((12) (let ((e-32 (vector-ref arg-0 1))) (let ((e-33 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-32) (string-append " := PROJECT(" (string-append (CompilerC-45VMCode-u--show_Show_Reg e-33) (string-append ", " (string-append (PreludeC-45Show-u--show_Show_Int e-34) ")"))))))))) ((13) (let ((e-35 (vector-ref arg-0 1))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-35) " := NULL"))) (else (let ((e-36 (vector-ref arg-0 1))) (string-append "ERROR " (PreludeC-45Show-u--show_Show_String e-36)))))))
(define CompilerC-45VMCode-u--showPrec_Show_VMInst (lambda (arg-0 arg-1) (CompilerC-45VMCode-u--show_Show_VMInst arg-1)))
(define csegen-1939 (lambda () (cons (lambda (u--x) (CompilerC-45VMCode-u--show_Show_VMInst u--x)) (lambda (u--d) (lambda (u--x) (CompilerC-45VMCode-u--showPrec_Show_VMInst u--d u--x))))))
(define CompilerC-45VMCode-n--10274-3881-u--findConstVarAlt (lambda (arg-0 arg-1 arg-2 arg-3) (let ((e-3 (cdr arg-3))) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-59) (lambda (eta-0) (CompilerC-45VMCode-findVars eta-0)) e-3))))
(define CompilerC-45VMCode-n--10274-3835-u--findVarAlt (lambda (arg-0 arg-1 arg-2 arg-3) (let ((e-3 (cdr arg-3))) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-59) (lambda (eta-0) (CompilerC-45VMCode-findVars eta-0)) e-3))))
(define CompilerC-45VMCode-findVars (lambda (arg-0) (case (vector-ref arg-0 0) ((2) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref e-0 0) ((1) (let ((e-34 (vector-ref e-0 1))) (cons e-34 '())))(else '())))) ((3) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref e-2 0) ((1) (let ((e-35 (vector-ref e-2 1))) (cons e-35 '())))(else '())))) ((4) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref e-5 0) ((1) (let ((e-36 (vector-ref e-5 1))) (cons e-36 '())))(else '())))) ((5) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref e-9 0) ((1) (let ((e-37 (vector-ref e-9 1))) (cons e-37 '())))(else '())))) ((6) (let ((e-11 (vector-ref arg-0 1))) (case (vector-ref e-11 0) ((1) (let ((e-38 (vector-ref e-11 1))) (cons e-38 '())))(else '())))) ((7) (let ((e-14 (vector-ref arg-0 1))) (case (vector-ref e-14 0) ((1) (let ((e-39 (vector-ref e-14 1))) (cons e-39 '())))(else '())))) ((8) (let ((e-19 (vector-ref arg-0 1))) (case (vector-ref e-19 0) ((1) (let ((e-40 (vector-ref e-19 1))) (cons e-40 '())))(else '())))) ((9) (let ((e-22 (vector-ref arg-0 1))) (case (vector-ref e-22 0) ((1) (let ((e-41 (vector-ref e-22 1))) (cons e-41 '())))(else '())))) ((10) (let ((e-25 (vector-ref arg-0 1))) (let ((e-26 (vector-ref arg-0 2))) (let ((e-27 (vector-ref arg-0 3))) (PreludeC-45TypesC-45List-tailRecAppend (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-59) (lambda (eta-0) (CompilerC-45VMCode-n--10274-3835-u--findVarAlt e-25 e-27 e-26 eta-0)) e-26) (DataC-45Maybe-fromMaybe (lambda () '()) (PreludeC-45Types-u--map_Functor_Maybe (csegen-1953) e-27))))))) ((11) (let ((e-28 (vector-ref arg-0 1))) (let ((e-29 (vector-ref arg-0 2))) (let ((e-30 (vector-ref arg-0 3))) (PreludeC-45TypesC-45List-tailRecAppend (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-59) (lambda (eta-0) (CompilerC-45VMCode-n--10274-3881-u--findConstVarAlt e-28 e-30 e-29 eta-0)) e-29) (DataC-45Maybe-fromMaybe (lambda () '()) (PreludeC-45Types-u--map_Functor_Maybe (csegen-1953) e-30))))))) ((12) (let ((e-31 (vector-ref arg-0 1))) (case (vector-ref e-31 0) ((1) (let ((e-42 (vector-ref e-31 1))) (cons e-42 '())))(else '()))))(else '()))))
(define csegen-1953 (lambda () (lambda (arg-10990) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-59) (lambda (eta-0) (CompilerC-45VMCode-findVars eta-0)) arg-10990))))
(define LibrariesC-45DataC-45IntMap-singleton (lambda (arg-1 arg-2) (LibrariesC-45DataC-45IntMap-insert arg-1 arg-2 LibrariesC-45DataC-45IntMap-empty)))
(define CompilerC-45VMCode-collectReg (lambda (arg-0) (case (vector-ref arg-0 0) ((1) (let ((e-0 (vector-ref arg-0 1))) (LibrariesC-45DataC-45IntMap-singleton e-0 'erased)))(else LibrariesC-45DataC-45IntMap-empty))))
(define DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4 arg-5) (if (null? arg-5) arg-4 (let ((e-3 (car arg-5))) (let ((e-4 (cdr arg-5))) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 arg-3 ((arg-3 arg-4) e-3) e-4))))))
(define DataC-45Vect-u--foldMap_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4 ext-0) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 (lambda (u--acc) (lambda (u--elem) (let ((e-1 (car arg-3))) ((e-1 u--acc) (arg-4 u--elem))))) (let ((e-2 (cdr arg-3))) e-2) ext-0)))
(define csegen-1955(delay (lambda (arg-10990) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (lambda (eta-0) (CompilerC-45VMCode-collectUsed eta-0)) arg-10990))))
(define CompilerC-45VMCode-collectUsed (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (CompilerC-45VMCode-collectReg e-0))) ((1) LibrariesC-45DataC-45IntMap-empty) ((2) (let ((e-2 (vector-ref arg-0 2))) (CompilerC-45VMCode-collectReg e-2))) ((3) (let ((e-5 (vector-ref arg-0 3))) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-5))) ((4) (let ((e-9 (vector-ref arg-0 4))) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-9))) ((5) LibrariesC-45DataC-45IntMap-empty) ((6) (let ((e-13 (vector-ref arg-0 2))) (let ((e-14 (vector-ref arg-0 3))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) 'erased)) (CompilerC-45VMCode-collectReg e-13) (CompilerC-45VMCode-collectReg e-14))))) ((7) (let ((e-18 (vector-ref arg-0 4))) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-18))) ((8) (let ((e-22 (vector-ref arg-0 3))) (DataC-45Vect-u--foldMap_Foldable_C-40VectC-32C-36nC-41 (force csegen-1933) (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-22))) ((9) (let ((e-25 (vector-ref arg-0 3))) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-25))) ((10) (let ((e-26 (vector-ref arg-0 1))) (let ((e-27 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 3))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) 'erased)) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) 'erased)) (CompilerC-45VMCode-collectReg e-26) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (csegen-1954) e-27)) (PreludeC-45Types-maybe (lambda () LibrariesC-45DataC-45IntMap-empty) (lambda () (force csegen-1955)) e-28)))))) ((11) (let ((e-29 (vector-ref arg-0 1))) (let ((e-30 (vector-ref arg-0 2))) (let ((e-31 (vector-ref arg-0 3))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) 'erased)) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) 'erased)) (CompilerC-45VMCode-collectReg e-29) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (csegen-1954) e-30)) (PreludeC-45Types-maybe (lambda () LibrariesC-45DataC-45IntMap-empty) (lambda () (force csegen-1955)) e-31)))))) ((12) (let ((e-33 (vector-ref arg-0 2))) (CompilerC-45VMCode-collectReg e-33))) ((13) LibrariesC-45DataC-45IntMap-empty) (else LibrariesC-45DataC-45IntMap-empty))))
(define csegen-1954 (lambda () (lambda (eta-0) (PreludeC-45Types-u--foldMap_Foldable_List (force csegen-1933) (lambda (eta-1) (CompilerC-45VMCode-collectUsed eta-1)) (Builtin-snd eta-0)))))
(define csegen-1964(delay (lambda (eta-0) (string-append " " (CoreC-45TTC-45Term-u--show_Show_LazyReason eta-0)))))
(define CompilerC-45ANF-showLazy (lambda (ext-0) (PreludeC-45Types-maybe (lambda () "") (lambda () (force csegen-1964)) ext-0)))
(define DataC-45Vect-u--map_Functor_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4) (if (null? arg-4) '() (let ((e-3 (car arg-4))) (let ((e-4 (cdr arg-4))) (cons (arg-3 e-3) (DataC-45Vect-u--map_Functor_C-40VectC-32C-36nC-41 arg-3 e-4)))))))
(define CompilerC-45ANF-n--10349-2106-u--showArg (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (string-append "v" (PreludeC-45Show-u--show_Show_Int arg-5))))
(define CompilerC-45ANF-u--show_Show_AConAlt (lambda (arg-0) (let ((e-0 (vector-ref arg-0 0))) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (let ((e-3 (vector-ref arg-0 3))) (let ((e-4 (vector-ref arg-0 4))) (string-append "%conalt " (string-append (CoreC-45Name-u--show_Show_Name e-0) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-n--10349-2106-u--showArg e-1 e-4 e-3 e-2 e-0 eta-0)) e-3)) (string-append ") => " (CompilerC-45ANF-u--show_Show_ANF e-4)))))))))))))
(define CompilerC-45ANF-u--show_Show_AConstAlt (lambda (arg-0) (let ((e-0 (car arg-0))) (let ((e-1 (cdr arg-0))) (string-append "%constalt(" (string-append (CoreC-45TTC-45Primitive-u--show_Show_Constant e-0) (string-append ") => " (CompilerC-45ANF-u--show_Show_ANF e-1))))))))
(define CompilerC-45ANF-u--show_Show_AVar (lambda (arg-0) (if (null? arg-0) "[__]" (let ((e-0 (unbox arg-0))) (string-append "v" (PreludeC-45Show-u--show_Show_Int e-0))))))
(define CompilerC-45ANF-u--show_Show_ANF (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (CompilerC-45ANF-u--show_Show_AVar e-1))) ((1) (let ((e-3 (vector-ref arg-0 2))) (let ((e-4 (vector-ref arg-0 3))) (let ((e-5 (vector-ref arg-0 4))) (string-append (CoreC-45Name-u--show_Show_Name e-4) (string-append (CompilerC-45ANF-showLazy e-3) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-5)) ")")))))))) ((2) (let ((e-7 (vector-ref arg-0 2))) (let ((e-8 (vector-ref arg-0 3))) (let ((e-9 (vector-ref arg-0 4))) (string-append "<" (string-append (CoreC-45Name-u--show_Show_Name e-7) (string-append " underapp " (string-append (PreludeC-45Show-u--show_Show_Nat e-8) (string-append ">(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-9)) ")")))))))))) ((3) (let ((e-11 (vector-ref arg-0 2))) (let ((e-12 (vector-ref arg-0 3))) (let ((e-13 (vector-ref arg-0 4))) (string-append (CompilerC-45ANF-u--show_Show_AVar e-12) (string-append (CompilerC-45ANF-showLazy e-11) (string-append " @ (" (string-append (CompilerC-45ANF-u--show_Show_AVar e-13) ")")))))))) ((4) (let ((e-15 (vector-ref arg-0 2))) (let ((e-16 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 4))) (string-append "%let v" (string-append (PreludeC-45Show-u--show_Show_Int e-15) (string-append " = (" (string-append (CompilerC-45ANF-u--show_Show_ANF e-16) (string-append ") in (" (string-append (CompilerC-45ANF-u--show_Show_ANF e-17) ")")))))))))) ((5) (let ((e-19 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 5))) (string-append "%con " (string-append (CoreC-45Name-u--show_Show_Name e-19) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-22)) ")"))))))) ((6) (let ((e-25 (vector-ref arg-0 2))) (let ((e-26 (vector-ref arg-0 3))) (let ((e-27 (vector-ref arg-0 4))) (string-append "%op " (string-append (CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 e-26) (string-append (CompilerC-45ANF-showLazy e-25) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 (DataC-45Vect-u--map_Functor_C-40VectC-32C-36nC-41 (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-27))) ")"))))))))) ((7) (let ((e-29 (vector-ref arg-0 2))) (let ((e-30 (vector-ref arg-0 3))) (let ((e-31 (vector-ref arg-0 4))) (string-append "%extprim " (string-append (CoreC-45Name-u--show_Show_Name e-30) (string-append (CompilerC-45ANF-showLazy e-29) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-31)) ")"))))))))) ((8) (let ((e-33 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 3))) (let ((e-35 (vector-ref arg-0 4))) (string-append "%case " (string-append (CompilerC-45ANF-u--show_Show_AVar e-33) (string-append " of { " (string-append (CoreC-45NameC-45Namespace-showSep "| " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CompilerC-45ANF-u--show_Show_AConAlt u--x)) e-34)) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1958) e-35) " }")))))))))) ((9) (let ((e-37 (vector-ref arg-0 2))) (let ((e-38 (vector-ref arg-0 3))) (let ((e-39 (vector-ref arg-0 4))) (string-append "%case " (string-append (CompilerC-45ANF-u--show_Show_AVar e-37) (string-append " of { " (string-append (CoreC-45NameC-45Namespace-showSep "| " (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (CompilerC-45ANF-u--show_Show_AConstAlt u--x)) e-38)) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1958) e-39) " }")))))))))) ((10) (let ((e-41 (vector-ref arg-0 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-41))) ((11) "___") (else (let ((e-44 (vector-ref arg-0 2))) (string-append "%CRASH(" (string-append (PreludeC-45Show-u--show_Show_String e-44) ")")))))))
(define CompilerC-45ANF-u--showPrec_Show_ANF (lambda (arg-0 arg-1) (CompilerC-45ANF-u--show_Show_ANF arg-1)))
(define csegen-1958 (lambda () (cons (lambda (u--x) (CompilerC-45ANF-u--show_Show_ANF u--x)) (lambda (u--d) (lambda (u--x) (CompilerC-45ANF-u--showPrec_Show_ANF u--d u--x))))))
(define LibrariesC-45DataC-45SortedMap-n--6586-4343-u--treeToListC-39 (lambda (arg-5 arg-6) (case (vector-ref arg-6 0) ((0) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (arg-5 (cons e-3 e-4))))) ((1) (let ((e-9 (vector-ref arg-6 1))) (let ((e-11 (vector-ref arg-6 3))) (LibrariesC-45DataC-45SortedMap-n--6586-4343-u--treeToListC-39 (lambda (arg-0) (cons arg-0 (LibrariesC-45DataC-45SortedMap-n--6586-4343-u--treeToListC-39 arg-5 e-11))) e-9)))) (else (let ((e-16 (vector-ref arg-6 1))) (let ((e-18 (vector-ref arg-6 3))) (let ((e-20 (vector-ref arg-6 5))) (LibrariesC-45DataC-45SortedMap-n--6586-4343-u--treeToListC-39 (lambda (arg-0) (cons arg-0 (LibrariesC-45DataC-45SortedMap-n--6586-4343-u--treeToListC-39 (lambda (arg-1) (cons arg-1 (LibrariesC-45DataC-45SortedMap-n--6586-4343-u--treeToListC-39 arg-5 e-20))) e-18))) e-16))))))))
(define LibrariesC-45DataC-45SortedMap-treeToList (lambda (ext-0) (LibrariesC-45DataC-45SortedMap-n--6586-4343-u--treeToListC-39 (lambda (arg-0) (cons arg-0 '())) ext-0)))
(define LibrariesC-45DataC-45SortedMap-toList (lambda (arg-2) (case (vector-ref arg-2 0) ((0) '()) (else (let ((e-7 (vector-ref arg-2 3))) (LibrariesC-45DataC-45SortedMap-treeToList e-7))))))
(define LibrariesC-45DataC-45SortedMap-keys (lambda (ext-0) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (Builtin-fst eta-0)) (LibrariesC-45DataC-45SortedMap-toList ext-0))))
(define LibrariesC-45DataC-45SortedSet-u--toList_Foldable_SortedSet (lambda (arg-1) (LibrariesC-45DataC-45SortedMap-keys arg-1)))
(define LibrariesC-45DataC-45SortedSet-u--foldr_Foldable_SortedSet (lambda (arg-2 arg-3 ext-0) (PreludeC-45Types-u--foldr_Foldable_List arg-2 arg-3 (LibrariesC-45DataC-45SortedSet-u--toList_Foldable_SortedSet ext-0))))
(define LibrariesC-45DataC-45SortedSet-union (lambda (arg-1 arg-2) (LibrariesC-45DataC-45SortedSet-u--foldr_Foldable_SortedSet csegen-887 arg-1 arg-2)))
(define LibrariesC-45DataC-45SortedSet-u--C-60C-43C-62_Semigroup_C-40SortedSetC-32C-36kC-41 (lambda (arg-1 ext-0 ext-1) (LibrariesC-45DataC-45SortedSet-union ext-0 ext-1)))
(define LibrariesC-45DataC-45SortedSet-u--neutral_Monoid_C-40SortedSetC-32C-36kC-41 (lambda (arg-1) (LibrariesC-45DataC-45SortedSet-empty arg-1)))
(define csegen-1962 (cons (lambda (arg-8505) (lambda (arg-8508) (LibrariesC-45DataC-45SortedSet-u--C-60C-43C-62_Semigroup_C-40SortedSetC-32C-36kC-41 (force csegen-902) arg-8505 arg-8508))) (LibrariesC-45DataC-45SortedSet-u--neutral_Monoid_C-40SortedSetC-32C-36kC-41 (force csegen-902))))
(define csegen-1963 (lambda (lamc-0) (let ((e-1 (cdr lamc-0))) e-1)))
(define CompilerC-45ANF-u--C-61C-61_Eq_AVar (lambda (arg-0 arg-1) (if (null? arg-0) (if (null? arg-1) 1 0) (let ((e-0 (unbox arg-0))) (if (null? arg-1) 0 (let ((e-1 (unbox arg-1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-0 e-1)))))))
(define CompilerC-45ANF-u--C-47C-61_Eq_AVar (lambda (arg-0 arg-1) (let ((sc0 (CompilerC-45ANF-u--C-61C-61_Eq_AVar arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define CompilerC-45ANF-u--compare_Ord_AVar (lambda (arg-0 arg-1) (if (null? arg-0) (if (null? arg-1) 1 0) (let ((e-0 (unbox arg-0))) (if (null? arg-1) 2 (let ((e-1 (unbox arg-1))) (PreludeC-45EqOrd-u--compare_Ord_Int e-0 e-1)))))))
(define CompilerC-45ANF-u--C-60C-61_Ord_AVar (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CompilerC-45ANF-u--compare_Ord_AVar arg-0 arg-1) 2)))
(define CompilerC-45ANF-u--C-60_Ord_AVar (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CompilerC-45ANF-u--compare_Ord_AVar arg-0 arg-1) 0)))
(define CompilerC-45ANF-u--C-62C-61_Ord_AVar (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CompilerC-45ANF-u--compare_Ord_AVar arg-0 arg-1) 0)))
(define CompilerC-45ANF-u--C-62_Ord_AVar (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CompilerC-45ANF-u--compare_Ord_AVar arg-0 arg-1) 2)))
(define CompilerC-45ANF-u--max_Ord_AVar (lambda (arg-0 arg-1) (let ((sc0 (CompilerC-45ANF-u--C-62_Ord_AVar arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define CompilerC-45ANF-u--min_Ord_AVar (lambda (arg-0 arg-1) (let ((sc0 (CompilerC-45ANF-u--C-60_Ord_AVar arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-1975 (vector (cons (lambda (arg-712) (lambda (arg-715) (CompilerC-45ANF-u--C-61C-61_Eq_AVar arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CompilerC-45ANF-u--C-47C-61_Eq_AVar arg-722 arg-725)))) (lambda (arg-1598) (lambda (arg-1601) (CompilerC-45ANF-u--compare_Ord_AVar arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (CompilerC-45ANF-u--C-60_Ord_AVar arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (CompilerC-45ANF-u--C-62_Ord_AVar arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (CompilerC-45ANF-u--C-60C-61_Ord_AVar arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (CompilerC-45ANF-u--C-62C-61_Ord_AVar arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (CompilerC-45ANF-u--max_Ord_AVar arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (CompilerC-45ANF-u--min_Ord_AVar arg-1658 arg-1661)))))
(define csegen-1979 (cons (lambda (arg-8505) (lambda (arg-8508) (LibrariesC-45DataC-45SortedSet-u--C-60C-43C-62_Semigroup_C-40SortedSetC-32C-36kC-41 csegen-1975 arg-8505 arg-8508))) (LibrariesC-45DataC-45SortedSet-u--neutral_Monoid_C-40SortedSetC-32C-36kC-41 csegen-1975)))
(define csegen-1980 (LibrariesC-45DataC-45SortedSet-empty csegen-1975))
(define CoreC-45Name-with--userNameEq-11521 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (box 'erased)) (else '()))))
(define CoreC-45Name-with--userNameEq-11546 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (box 'erased)) (else '()))))
(define CoreC-45Name-userNameEq (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (CoreC-45Name-with--userNameEq-11521 e-0 e-2 (DecidableC-45Equality-u--decEq_DecEq_String e-0 e-2))))(else '())))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-3 (vector-ref arg-1 1))) (CoreC-45Name-with--userNameEq-11546 e-1 e-3 (DecidableC-45Equality-u--decEq_DecEq_String e-1 e-3))))(else '())))) ((2) (case (vector-ref arg-1 0) ((2) (box 'erased))(else '())))(else '()))))
(define PreludeC-45Basics-irrelevantEq 'erased)
(define ControlC-45Function-biinj (cons PreludeC-45Basics-irrelevantEq PreludeC-45Basics-irrelevantEq))
(define DecidableC-45EqualityC-45Core-decEqCong (lambda (arg-6) (case (vector-ref arg-6 0) ((0) (vector 0 'erased)) (else (let ((e-3 (vector-ref arg-6 1))) (vector 1 (lambda (u--c) (e-3 PreludeC-45Basics-irrelevantEq))))))))
(define DecidableC-45EqualityC-45Core-decEqCong2 (lambda (arg-9 arg-10) (case (vector-ref arg-9 0) ((0) (DecidableC-45EqualityC-45Core-decEqCong (arg-10))) (else (let ((e-3 (vector-ref arg-9 1))) (vector 1 (lambda (u--c) (let ((sc1 ControlC-45Function-biinj)) (e-3 'erased)))))))))
(define DecidableC-45Equality-u--decEq_DecEq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((e-6 (car arg-4))) (let ((e-7 (cdr arg-4))) (DecidableC-45EqualityC-45Core-decEqCong2 (((Builtin-fst arg-2) e-2) e-6) (lambda () (((Builtin-snd arg-2) e-3) e-7)))))))))
(define DecidableC-45Equality-u--decEq_DecEq_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) (vector 0 'erased) (vector 1 (lambda (eta-0) (PreludeC-45Uninhabited-void)))) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (if (null? arg-3) (vector 1 (lambda (eta-0) (PreludeC-45Uninhabited-void))) (let ((e-10 (car arg-3))) (let ((e-11 (cdr arg-3))) (DecidableC-45EqualityC-45Core-decEqCong2 ((arg-1 e-2) e-10) (lambda () (DecidableC-45Equality-u--decEq_DecEq_C-40ListC-32C-36aC-41 arg-1 e-3 e-11)))))))))))
(define CoreC-45NameC-45Namespace-mkNSInjective (lambda (arg-2) 'erased))
(define CoreC-45NameC-45Namespace-with--decEq-8986 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (vector 1 (lambda (eta-0) (e-1 (CoreC-45NameC-45Namespace-mkNSInjective eta-0)))))) (else (vector 0 'erased)))))
(define CoreC-45NameC-45Namespace-u--decEq_DecEq_Namespace (lambda (arg-0 arg-1) (CoreC-45NameC-45Namespace-with--decEq-8986 arg-0 arg-1 (DecidableC-45Equality-u--decEq_DecEq_C-40ListC-32C-36aC-41 csegen-536 arg-0 arg-1))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11604 (lambda (arg-0 arg-1 arg-2 arg-3) (if (null? arg-2) '() (box 'erased))))
(define CoreC-45Name-with--nameEq-11593 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((0) (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11604 arg-4 arg-3 (CoreC-45Name-nameEq arg-3 arg-4) arg-0)) (else '()))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11658 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (box 'erased)) (else '()))))
(define CoreC-45Name-with--nameEq-11643 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((0) (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11658 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0)) (else '()))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11694 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (box 'erased)) (else '()))))
(define CoreC-45Name-with--nameEq-11683 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (if (null? arg-2) '() (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11694 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11733 (lambda (arg-0 arg-1 arg-2 arg-3) (if (null? arg-2) '() (box 'erased))))
(define CoreC-45Name-with--nameEq-11722 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((0) (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11733 arg-4 arg-3 (CoreC-45Name-nameEq arg-3 arg-4) arg-0)) (else '()))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11786 (lambda (arg-0 arg-1 arg-2 arg-3) (if (null? arg-2) '() (box 'erased))))
(define CoreC-45Name-with--nameEq-11764 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((1) '()) (else (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11786 arg-4 arg-3 (CoreC-45Name-nameEq arg-3 arg-4) arg-0)))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11825 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((1) '()) (else (box 'erased)))))
(define CoreC-45Name-with--nameEq-11806 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((1) '()) (else (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11825 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0)))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11869 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((1) '()) (else (box 'erased)))))
(define CoreC-45Name-with--nameEq-11850 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((1) '()) (else (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11869 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0)))))
(define CoreC-45Name-with--nameEq-11894 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (box 'erased)) (else '()))))
(define CoreC-45Name-nameEq (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11593 e-0 e-16 (CoreC-45NameC-45Namespace-u--decEq_DecEq_Namespace e-0 e-16) e-1 e-17))))(else '()))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-18 (vector-ref arg-1 1))) (PreludeC-45Types-u--map_Functor_Maybe (lambda (u--xy) 'erased) (CoreC-45Name-userNameEq e-2 e-18))))(else '())))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11643 e-3 e-19 (DecidableC-45Equality-u--decEq_DecEq_String e-3 e-19) e-4 e-20))))(else '()))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((3) (let ((e-21 (vector-ref arg-1 1))) (let ((e-22 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11683 e-5 e-21 (CoreC-45Name-nameEq e-5 e-21) e-6 e-22))))(else '()))))) ((4) (let ((e-7 (vector-ref arg-0 1))) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((4) (let ((e-23 (vector-ref arg-1 1))) (let ((e-24 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11722 e-7 e-23 (DecidableC-45Equality-u--decEq_DecEq_String e-7 e-23) e-8 e-24))))(else '()))))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((5) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11764 e-9 e-25 (DecidableC-45Equality-u--decEq_DecEq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-521 csegen-521) e-9 e-25) e-10 e-26))))(else '()))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (let ((e-12 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-27 (vector-ref arg-1 1))) (let ((e-28 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11806 e-11 e-27 (DecidableC-45Equality-u--decEq_DecEq_String e-11 e-27) e-12 e-28))))(else '()))))) ((7) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11850 e-13 e-29 (DecidableC-45Equality-u--decEq_DecEq_String e-13 e-29) e-14 e-30))))(else '()))))) ((8) (let ((e-15 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-31 (vector-ref arg-1 1))) (CoreC-45Name-with--nameEq-11894 e-15 e-31 (DecidableC-45Equality-u--decEq_DecEq_Int e-15 e-31))))(else '()))))(else '()))))
(define CoreC-45TTC-45Primitive-primFnEq (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-0 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((0) (let ((e-18 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-0 e-18))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((1) (let ((e-1 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((1) (let ((e-19 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-1 e-19))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((2) (let ((e-2 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((2) (let ((e-20 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-2 e-20))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((3) (let ((e-3 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((3) (let ((e-21 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-3 e-21))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((4) (let ((e-4 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((4) (let ((e-22 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-4 e-22))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((5) (let ((e-5 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((5) (let ((e-23 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-5 e-23))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((6) (let ((e-6 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((6) (let ((e-24 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-6 e-24))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((7) (let ((e-7 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((7) (let ((e-25 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-7 e-25))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((8) (let ((e-8 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((8) (let ((e-26 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-8 e-26))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((9) (let ((e-9 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((9) (let ((e-27 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-9 e-27))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((10) (let ((e-10 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((10) (let ((e-28 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-10 e-28))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((11) (let ((e-11 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((11) (let ((e-29 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-11 e-29))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((12) (let ((e-12 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((12) (let ((e-30 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-12 e-30))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((13) (let ((e-13 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((13) (let ((e-31 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-13 e-31))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((14) (let ((e-14 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((14) (let ((e-32 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-14 e-32))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((15) (let ((e-15 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((15) (let ((e-33 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-15 e-33))) (cond ((equal? sc2 1) (box 'erased)) (else '())))))(else '())))) ((16) (case (vector-ref arg-3 0) ((16) (box 'erased))(else '()))) ((17) (case (vector-ref arg-3 0) ((17) (box 'erased))(else '()))) ((18) (case (vector-ref arg-3 0) ((18) (box 'erased))(else '()))) ((19) (case (vector-ref arg-3 0) ((19) (box 'erased))(else '()))) ((20) (case (vector-ref arg-3 0) ((20) (box 'erased))(else '()))) ((21) (case (vector-ref arg-3 0) ((21) (box 'erased))(else '()))) ((22) (case (vector-ref arg-3 0) ((22) (box 'erased))(else '()))) ((23) (case (vector-ref arg-3 0) ((23) (box 'erased))(else '()))) ((24) (case (vector-ref arg-3 0) ((24) (box 'erased))(else '()))) ((25) (case (vector-ref arg-3 0) ((25) (box 'erased))(else '()))) ((26) (case (vector-ref arg-3 0) ((26) (box 'erased))(else '()))) ((27) (case (vector-ref arg-3 0) ((27) (box 'erased))(else '()))) ((28) (case (vector-ref arg-3 0) ((28) (box 'erased))(else '()))) ((29) (case (vector-ref arg-3 0) ((29) (box 'erased))(else '()))) ((30) (case (vector-ref arg-3 0) ((30) (box 'erased))(else '()))) ((31) (case (vector-ref arg-3 0) ((31) (box 'erased))(else '()))) ((32) (case (vector-ref arg-3 0) ((32) (box 'erased))(else '()))) ((33) (case (vector-ref arg-3 0) ((33) (box 'erased))(else '()))) ((34) (case (vector-ref arg-3 0) ((34) (box 'erased))(else '()))) ((35) (case (vector-ref arg-3 0) ((35) (box 'erased))(else '()))) ((36) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((36) (let ((e-34 (vector-ref arg-3 1))) (let ((e-35 (vector-ref arg-3 2))) (let ((sc2 (let ((sc3 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-16 e-34))) (cond ((equal? sc3 1) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-17 e-35)) (else 0))))) (cond ((equal? sc2 1) (box 'erased)) (else '()))))))(else '()))))) ((37) (case (vector-ref arg-3 0) ((37) (box 'erased))(else '()))) ((38) (case (vector-ref arg-3 0) ((38) (box 'erased))(else '())))(else '()))))
(define DataC-45Vect-u--C-61C-61_Eq_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) 1 (let ((e-3 (car arg-3))) (let ((e-4 (cdr arg-3))) (let ((e-8 (car arg-4))) (let ((e-9 (cdr arg-4))) (let ((sc2 (let ((e-1 (car arg-2))) ((e-1 e-3) e-8)))) (cond ((equal? sc2 1) (DataC-45Vect-u--C-61C-61_Eq_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 arg-2 e-4 e-9)) (else 0))))))))))
(define CoreC-45TTC-45Term-u--C-61C-61_Eq_LazyReason (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define CoreC-45Name-namesEq (lambda (arg-0 arg-1) (if (null? arg-0) (if (null? arg-1) (box 'erased) '()) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (if (null? arg-1) '() (let ((e-6 (car arg-1))) (let ((e-7 (cdr arg-1))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45Name-nameEq e-2 e-6) (lambda (u--p) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45Name-namesEq e-3 e-7) (lambda (u--ps) (box 'erased)))))))))))))
(define CoreC-45Ord-u--C-61C-61_Eq_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (vector-ref arg-1 0))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (let ((e-7 (vector-ref arg-2 0))) (let ((e-9 (vector-ref arg-2 2))) (let ((e-10 (vector-ref arg-2 3))) (let ((e-11 (vector-ref arg-2 4))) (let ((sc0 (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-236) e-3 e-9))) (cond ((equal? sc0 1) (let ((sc1 (CoreC-45Name-u--C-61C-61_Eq_Name e-1 e-7))) (cond ((equal? sc1 1) ((let ((sc2 (CoreC-45Name-namesEq e-4 e-10))) (if (null? sc2) (lambda () 0) (lambda () (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-5 e-11)))))) (else 0)))) (else 0)))))))))))))
(define CoreC-45Ord-u--C-47C-61_Eq_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CConAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2034(delay (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45Ord-u--C-61C-61_Eq_C-40CConAltC-32C-36varsC-41 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45Ord-u--C-47C-61_Eq_C-40CConAltC-32C-36varsC-41 arg-722 arg-725))))))
(define CoreC-45Ord-u--C-61C-61_Eq_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (car arg-1))) (let ((e-2 (cdr arg-1))) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-1 e-4))) (cond ((equal? sc2 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-2 e-5)) (else 0)))))))))
(define CoreC-45Ord-u--C-47C-61_Eq_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2045(delay (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45Ord-u--C-61C-61_Eq_C-40CConstAltC-32C-36varsC-41 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45Ord-u--C-47C-61_Eq_C-40CConstAltC-32C-36varsC-41 arg-722 arg-725))))))
(define CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (case (vector-ref arg-2 0) ((0) (let ((e-65 (vector-ref arg-2 1))) (or (and (= e-2 e-65) 1) 0)))(else 0)))) ((1) (let ((e-7 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((1) (let ((e-70 (vector-ref arg-2 2))) (CoreC-45Name-u--C-61C-61_Eq_Name e-7 e-70)))(else 0)))) ((2) (let ((e-10 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((2) (let ((e-73 (vector-ref arg-2 2))) (let ((e-74 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Name-nameEq e-10 e-73))) (if (null? sc2) 0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-11 e-74))))))(else 0))))) ((3) (let ((e-14 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((3) (let ((e-77 (vector-ref arg-2 2))) (let ((e-79 (vector-ref arg-2 4))) (let ((e-80 (vector-ref arg-2 5))) (let ((sc2 (CoreC-45Name-nameEq e-14 e-77))) (if (null? sc2) 0 (let ((sc3 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-16 e-79))) (cond ((equal? sc3 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-17 e-80)) (else 0)))))))))(else 0)))))) ((4) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((4) (let ((e-83 (vector-ref arg-2 2))) (let ((e-84 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-20 e-83))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-1985) e-21 e-84)) (else 0))))))(else 0))))) ((5) (let ((e-24 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 4))) (let ((e-27 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((5) (let ((e-87 (vector-ref arg-2 2))) (let ((e-89 (vector-ref arg-2 4))) (let ((e-90 (vector-ref arg-2 5))) (let ((sc2 (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-236) e-26 e-89))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-24 e-87))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-1985) e-27 e-90)) (else 0)))) (else 0)))))))(else 0)))))) ((6) (let ((e-31 (vector-ref arg-1 3))) (let ((e-32 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((6) (let ((e-94 (vector-ref arg-2 3))) (let ((e-95 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45TTC-45Primitive-primFnEq e-31 e-94))) (if (null? sc2) 0 (DataC-45Vect-u--C-61C-61_Eq_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (force csegen-1985) e-32 e-95))))))(else 0))))) ((7) (let ((e-35 (vector-ref arg-1 2))) (let ((e-36 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((7) (let ((e-98 (vector-ref arg-2 2))) (let ((e-99 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Name-u--C-61C-61_Eq_Name e-35 e-98))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-1985) e-36 e-99)) (else 0))))))(else 0))))) ((8) (let ((e-39 (vector-ref arg-1 2))) (let ((e-40 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((8) (let ((e-102 (vector-ref arg-2 2))) (let ((e-103 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45TTC-45Term-u--C-61C-61_Eq_LazyReason e-39 e-102))) (cond ((equal? sc2 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-40 e-103)) (else 0))))))(else 0))))) ((9) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((9) (let ((e-106 (vector-ref arg-2 2))) (let ((e-107 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45TTC-45Term-u--C-61C-61_Eq_LazyReason e-43 e-106))) (cond ((equal? sc2 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-44 e-107)) (else 0))))))(else 0))))) ((10) (let ((e-47 (vector-ref arg-1 2))) (let ((e-48 (vector-ref arg-1 3))) (let ((e-49 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((10) (let ((e-110 (vector-ref arg-2 2))) (let ((e-111 (vector-ref arg-2 3))) (let ((e-112 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-47 e-110))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-2034) e-48 e-111))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-1985) e-49 e-112)) (else 0)))) (else 0)))))))(else 0)))))) ((11) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (let ((e-54 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((11) (let ((e-115 (vector-ref arg-2 2))) (let ((e-116 (vector-ref arg-2 3))) (let ((e-117 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-52 e-115))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-2045) e-53 e-116))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-1985) e-54 e-117)) (else 0)))) (else 0)))))))(else 0)))))) ((12) (let ((e-57 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((12) (let ((e-120 (vector-ref arg-2 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-57 e-120)))(else 0)))) ((13) (case (vector-ref arg-2 0) ((13) 1)(else 0))) ((14) (let ((e-62 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((14) (let ((e-125 (vector-ref arg-2 2))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-62 e-125)))(else 0))))(else 0))))
(define CoreC-45Ord-u--C-47C-61_Eq_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1985(delay (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45Ord-u--C-47C-61_Eq_C-40CExpC-32C-36varsC-41 arg-722 arg-725))))))
(define LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) 0) ((equal? arg-0 1) (arg-1)) (else 2))))
(define PreludeC-45Basics-on (lambda (arg-3 arg-4 ext-0 ext-1) ((arg-3 (arg-4 ext-0)) (arg-4 ext-1))))
(define CoreC-45TTC-45Primitive-n--7143-6384-u--tag (lambda (arg-0) (cond ((equal? arg-0 0) 1) ((equal? arg-0 1) 2) ((equal? arg-0 2) 3) ((equal? arg-0 3) 4) ((equal? arg-0 4) 5) ((equal? arg-0 5) 6) ((equal? arg-0 6) 7) ((equal? arg-0 7) 8) ((equal? arg-0 8) 9) ((equal? arg-0 9) 10) ((equal? arg-0 10) 11) ((equal? arg-0 11) 12) ((equal? arg-0 12) 13) (else 14))))
(define CoreC-45TTC-45Primitive-u--compare_Ord_PrimType (lambda (ext-0 ext-1) (PreludeC-45Basics-on (lambda (eta-0) (lambda (eta-1) (PreludeC-45EqOrd-u--compare_Ord_Int eta-0 eta-1))) (lambda (eta-0) (CoreC-45TTC-45Primitive-n--7143-6384-u--tag eta-0)) ext-0 ext-1)))
(define CoreC-45TTC-45Primitive-n--10435-9542-u--tag (lambda (arg-2 arg-3 arg-5) (case (vector-ref arg-5 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) ((6) 6) ((7) 7) ((8) 8) ((9) 9) ((10) 10) ((11) 11) ((12) 12) ((13) 13) ((14) 14) ((15) 15) ((16) 16) ((17) 17) ((18) 18) ((19) 19) ((20) 20) ((21) 21) ((22) 22) ((23) 23) ((24) 24) ((25) 25) ((26) 26) ((27) 27) ((28) 28) ((29) 29) ((30) 30) ((31) 31) ((32) 32) ((33) 33) ((34) 34) ((35) 35) ((36) 36) ((37) 37) (else 38))))
(define CoreC-45TTC-45Primitive-primFnCmp (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-0 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((0) (let ((e-18 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-0 e-18)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((1) (let ((e-1 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((1) (let ((e-19 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-1 e-19)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((2) (let ((e-2 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((2) (let ((e-20 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-2 e-20)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((3) (let ((e-3 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((3) (let ((e-21 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-3 e-21)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((4) (let ((e-4 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((4) (let ((e-22 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-4 e-22)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((5) (let ((e-5 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((5) (let ((e-23 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-5 e-23)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((6) (let ((e-6 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((6) (let ((e-24 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-6 e-24)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((7) (let ((e-7 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((7) (let ((e-25 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-7 e-25)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((8) (let ((e-8 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((8) (let ((e-26 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-8 e-26)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((9) (let ((e-9 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((9) (let ((e-27 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-9 e-27)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((10) (let ((e-10 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((10) (let ((e-28 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-10 e-28)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((11) (let ((e-11 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((11) (let ((e-29 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-11 e-29)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((12) (let ((e-12 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((12) (let ((e-30 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-12 e-30)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((13) (let ((e-13 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((13) (let ((e-31 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-13 e-31)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((14) (let ((e-14 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((14) (let ((e-32 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-14 e-32)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((15) (let ((e-15 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((15) (let ((e-33 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-15 e-33)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))) ((36) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((36) (let ((e-34 (vector-ref arg-3 1))) (let ((e-35 (vector-ref arg-3 2))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-16 e-34) (lambda () (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-17 e-35))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10435-9542-u--tag arg-3 arg-2 arg-3))))))
(define PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (unbox arg-2))) (if (null? arg-3) 2 (let ((e-8 (unbox arg-3))) (let ((e-10 (vector-ref arg-1 1))) ((e-10 e-2) e-8))))))))
(define CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (vector-ref arg-1 0))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (let ((e-7 (vector-ref arg-2 0))) (let ((e-9 (vector-ref arg-2 2))) (let ((e-10 (vector-ref arg-2 3))) (let ((e-11 (vector-ref arg-2 4))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (force csegen-244) e-3 e-9) (lambda () (CoreC-45Name-u--compare_Ord_Name e-1 e-7))) (let ((sc0 (CoreC-45Name-namesEq e-4 e-10))) (if (null? sc0) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (force csegen-902) e-4 e-10)) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-5 e-11)))))))))))))))
(define CoreC-45Ord-u--C-60C-61_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits16 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits16 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits16 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits32 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits32 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits32 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits64 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits64 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits64 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits8 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits8 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits8 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char<? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Char arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Double (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Double (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Double arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Double arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int16 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int16 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int16 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int32 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int32 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int32 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int64 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int64 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int64 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int8 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int8 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int8 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define CoreC-45TTC-45Primitive-n--7375-6697-u--tag (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) ((6) 6) ((7) 7) ((8) 8) ((9) 9) ((10) 10) ((11) 11) ((12) 12) ((13) 13) (else 14))))
(define CoreC-45TTC-45Primitive-u--compare_Ord_Constant (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-14 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int e-0 e-14)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-15 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int8 e-1 e-15)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((2) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-16 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int16 e-2 e-16)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((3) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-17 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int32 e-3 e-17)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((4) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-18 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int64 e-4 e-18)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((5) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-19 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Integer e-5 e-19)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((6) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-20 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits8 e-6 e-20)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((7) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-21 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits16 e-7 e-21)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((8) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-22 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits32 e-8 e-22)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((9) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-23 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits64 e-9 e-23)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((10) (let ((e-10 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((10) (let ((e-24 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_String e-10 e-24)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((11) (let ((e-11 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((11) (let ((e-25 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Char e-11 e-25)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((12) (let ((e-12 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((12) (let ((e-26 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Double e-12 e-26)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1)))))) ((13) (let ((e-13 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((13) (let ((e-27 (vector-ref arg-1 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-13 e-27)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7375-6697-u--tag arg-1 arg-0 arg-1))))))
(define CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (car arg-1))) (let ((e-2 (cdr arg-1))) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45TTC-45Primitive-u--compare_Ord_Constant e-1 e-4) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-2 e-5)))))))))
(define CoreC-45Ord-u--C-60C-61_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--C-60_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-60_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62C-61_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62C-61_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--C-62_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define DataC-45Vect-case--compare-3015 (lambda (arg-1 arg-3 arg-4 arg-5 arg-6 arg-8) (cond ((equal? arg-8 1) (DataC-45Vect-u--compare_Ord_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 arg-1 arg-4 arg-6))(else arg-8))))
(define DataC-45Vect-u--compare_Ord_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) 1 (let ((e-3 (car arg-3))) (let ((e-4 (cdr arg-3))) (let ((e-8 (car arg-4))) (let ((e-9 (cdr arg-4))) (DataC-45Vect-case--compare-3015 arg-2 e-3 e-4 e-8 e-9 (let ((e-2 (vector-ref arg-2 1))) ((e-2 e-3) e-8))))))))))
(define CoreC-45Ord-lrTag (lambda (arg-0) (cond ((equal? arg-0 0) 0) ((equal? arg-0 1) 1) (else 2))))
(define CoreC-45Ord-u--compare_Ord_LazyReason (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-lrTag arg-0) (CoreC-45Ord-lrTag arg-1))))
(define CoreC-45Ord-u--max_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-62_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--max_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-62_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--min_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-60_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--min_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-60_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-n--7570-2395-u--tag (lambda (arg-1 arg-2 arg-4) (case (vector-ref arg-4 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) ((6) 6) ((7) 7) ((8) 8) ((9) 9) ((10) 10) ((11) 11) ((12) 12) ((13) 13) (else 14))))
(define CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (case (vector-ref arg-2 0) ((0) (let ((e-65 (vector-ref arg-2 1))) (PreludeC-45EqOrd-u--compare_Ord_Integer e-2 e-65)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2)))))) ((1) (let ((e-7 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((1) (let ((e-70 (vector-ref arg-2 2))) (CoreC-45Name-u--compare_Ord_Name e-7 e-70)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2)))))) ((2) (let ((e-10 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((2) (let ((e-73 (vector-ref arg-2 2))) (let ((e-74 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Name-nameEq e-10 e-73))) (if (null? sc2) (CoreC-45Name-u--compare_Ord_Name e-10 e-73) (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-11 e-74))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))) ((3) (let ((e-14 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((3) (let ((e-77 (vector-ref arg-2 2))) (let ((e-79 (vector-ref arg-2 4))) (let ((e-80 (vector-ref arg-2 5))) (let ((sc2 (CoreC-45Name-nameEq e-14 e-77))) (if (null? sc2) (CoreC-45Name-u--compare_Ord_Name e-14 e-77) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-16 e-79) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-17 e-80)))))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2)))))))) ((4) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((4) (let ((e-83 (vector-ref arg-2 2))) (let ((e-84 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-20 e-83) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (force csegen-1996) e-21 e-84))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))) ((5) (let ((e-24 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 4))) (let ((e-27 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((5) (let ((e-87 (vector-ref arg-2 2))) (let ((e-89 (vector-ref arg-2 4))) (let ((e-90 (vector-ref arg-2 5))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (force csegen-244) e-26 e-89) (lambda () (CoreC-45Name-u--compare_Ord_Name e-24 e-87))) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (force csegen-1996) e-27 e-90)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2)))))))) ((6) (let ((e-31 (vector-ref arg-1 3))) (let ((e-32 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((6) (let ((e-94 (vector-ref arg-2 3))) (let ((e-95 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45TTC-45Primitive-primFnEq e-31 e-94))) (if (null? sc2) (CoreC-45TTC-45Primitive-primFnCmp e-31 e-94) (DataC-45Vect-u--compare_Ord_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (force csegen-1996) e-32 e-95))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))) ((7) (let ((e-35 (vector-ref arg-1 2))) (let ((e-36 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((7) (let ((e-98 (vector-ref arg-2 2))) (let ((e-99 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Name-u--compare_Ord_Name e-35 e-98) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (force csegen-1996) e-36 e-99))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))) ((8) (let ((e-39 (vector-ref arg-1 2))) (let ((e-40 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((8) (let ((e-102 (vector-ref arg-2 2))) (let ((e-103 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_LazyReason e-39 e-102) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-40 e-103))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))) ((9) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((9) (let ((e-106 (vector-ref arg-2 2))) (let ((e-107 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_LazyReason e-43 e-106) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-44 e-107))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))) ((10) (let ((e-47 (vector-ref arg-1 2))) (let ((e-48 (vector-ref arg-1 3))) (let ((e-49 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((10) (let ((e-110 (vector-ref arg-2 2))) (let ((e-111 (vector-ref arg-2 3))) (let ((e-112 (vector-ref arg-2 4))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-47 e-110) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (vector (force csegen-2034) (lambda (arg-1598) (lambda (arg-1601) (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (CoreC-45Ord-u--C-60_Ord_C-40CConAltC-32C-36varsC-41 arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (CoreC-45Ord-u--C-62_Ord_C-40CConAltC-32C-36varsC-41 arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (CoreC-45Ord-u--C-60C-61_Ord_C-40CConAltC-32C-36varsC-41 arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (CoreC-45Ord-u--C-62C-61_Ord_C-40CConAltC-32C-36varsC-41 arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (CoreC-45Ord-u--max_Ord_C-40CConAltC-32C-36varsC-41 arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (CoreC-45Ord-u--min_Ord_C-40CConAltC-32C-36varsC-41 arg-1658 arg-1661)))) e-48 e-111))) (lambda () (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (force csegen-1996) e-49 e-112)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2)))))))) ((11) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (let ((e-54 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((11) (let ((e-115 (vector-ref arg-2 2))) (let ((e-116 (vector-ref arg-2 3))) (let ((e-117 (vector-ref arg-2 4))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-52 e-115) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (vector (force csegen-2045) (lambda (arg-1598) (lambda (arg-1601) (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (CoreC-45Ord-u--C-60_Ord_C-40CConstAltC-32C-36varsC-41 arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (CoreC-45Ord-u--C-62_Ord_C-40CConstAltC-32C-36varsC-41 arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (CoreC-45Ord-u--C-60C-61_Ord_C-40CConstAltC-32C-36varsC-41 arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (CoreC-45Ord-u--C-62C-61_Ord_C-40CConstAltC-32C-36varsC-41 arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (CoreC-45Ord-u--max_Ord_C-40CConstAltC-32C-36varsC-41 arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (CoreC-45Ord-u--min_Ord_C-40CConstAltC-32C-36varsC-41 arg-1658 arg-1661)))) e-53 e-116))) (lambda () (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (force csegen-1996) e-54 e-117)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2)))))))) ((12) (let ((e-57 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((12) (let ((e-120 (vector-ref arg-2 2))) (CoreC-45TTC-45Primitive-u--compare_Ord_Constant e-57 e-120)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2)))))) ((13) (case (vector-ref arg-2 0) ((13) 1)(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))) ((14) (let ((e-62 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((14) (let ((e-125 (vector-ref arg-2 2))) (PreludeC-45EqOrd-u--compare_Ord_String e-62 e-125)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7570-2395-u--tag arg-2 arg-1 arg-2))))))
(define CoreC-45Ord-u--C-60C-61_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--C-60_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62C-61_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--max_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-62_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--min_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-60_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define csegen-1996(delay (vector (force csegen-1985) (lambda (arg-1598) (lambda (arg-1601) (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (CoreC-45Ord-u--C-60_Ord_C-40CExpC-32C-36varsC-41 arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (CoreC-45Ord-u--C-62_Ord_C-40CExpC-32C-36varsC-41 arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (CoreC-45Ord-u--C-60C-61_Ord_C-40CExpC-32C-36varsC-41 arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (CoreC-45Ord-u--C-62C-61_Ord_C-40CExpC-32C-36varsC-41 arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (CoreC-45Ord-u--max_Ord_C-40CExpC-32C-36varsC-41 arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (CoreC-45Ord-u--min_Ord_C-40CExpC-32C-36varsC-41 arg-1658 arg-1661))))))
(define DataC-45Vect-u--foldlM_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-4 arg-5 arg-6 ext-0) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 (lambda (u--ma) (lambda (u--b) (let ((e-2 (vector-ref arg-4 1))) ((((e-2 'erased) 'erased) u--ma) (lambda (eta-0) (PreludeC-45Basics-flip arg-5 u--b eta-0)))))) (let ((e-1 (vector-ref arg-4 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) arg-6))) ext-0)))
(define DataC-45Vect-u--null_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-2) (if (null? arg-2) 1 0)))
(define csegen-2028 (vector (lambda (u--acc) (lambda (u--elem) (lambda (u--func) (lambda (u--init) (lambda (u--input) (DataC-45Vect-u--foldr_Foldable_C-40VectC-32C-36nC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (u--acc) (lambda (u--func) (lambda (u--init) (lambda (u--input) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (arg-10947) (DataC-45Vect-u--null_Foldable_C-40VectC-32C-36nC-41 arg-10947))) (lambda (u--elem) (lambda (u--acc) (lambda (u--m) (lambda (i_con-0) (lambda (u--funcM) (lambda (u--init) (lambda (u--input) (DataC-45Vect-u--foldlM_Foldable_C-40VectC-32C-36nC-41 i_con-0 u--funcM u--init u--input)))))))) (lambda (u--elem) (lambda (arg-10976) (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 arg-10976))) (lambda (u--a) (lambda (u--m) (lambda (i_con-0) (lambda (u--f) (lambda (arg-10990) (DataC-45Vect-u--foldMap_Foldable_C-40VectC-32C-36nC-41 i_con-0 u--f arg-10990))))))))
(define DataC-45List-u--unzipWith_Zippable_List (lambda (arg-3 arg-4) (if (null? arg-4) (cons '() '()) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((sc1 (arg-3 e-2))) (let ((e-5 (car sc1))) (let ((e-4 (cdr sc1))) (let ((sc2 (DataC-45List-u--unzipWith_Zippable_List arg-3 e-3))) (let ((e-7 (car sc2))) (let ((e-6 (cdr sc2))) (cons (cons e-5 e-7) (cons e-4 e-6)))))))))))))
(define DataC-45List-u--unzip_Zippable_List (lambda (ext-0) (DataC-45List-u--unzipWith_Zippable_List (lambda (eta-0) eta-0) ext-0)))
(define csegen-2030 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (DataC-45List-u--unzip_Zippable_List e-5)))))))
(define csegen-2031 (PreludeC-45Interfaces-sum csegen-1117 (force csegen-14)))
(define csegen-2106 (PreludeC-45Types-elem (force csegen-14) csegen-1382 (vector 0 )))
(define csegen-2107 (PreludeC-45Types-elem (force csegen-14) csegen-1382 (vector 1 )))
(define csegen-2108 (lambda (eta-0) (lambda (eta-1) (bs+ eta-0 eta-1 63))))
(define CoreC-45NameC-45Namespace-primIONS (CoreC-45NameC-45Namespace-mkNamespace "PrimIO"))
(define csegen-2109 (vector 0 CoreC-45NameC-45Namespace-primIONS (vector 1 (vector 0 "io_bind"))))
(define DataC-45String-n--3856-9432-u--unlinesC-39 (lambda (arg-0) (if (null? arg-0) '() (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cons e-2 (cons "\u000a" (DataC-45String-n--3856-9432-u--unlinesC-39 e-3))))))))
(define DataC-45String-fastUnlines (lambda (ext-0) (PreludeC-45Types-fastConcat (DataC-45String-n--3856-9432-u--unlinesC-39 ext-0))))
(define CoreC-45CaseC-45CaseTree-showCA (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) (cons e-1 e-3))) (string-append " => " (CoreC-45CaseC-45CaseTree-showCT (PreludeC-45TypesC-45List-tailRecAppend e-3 arg-0) arg-1 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (string-append "Delay " (string-append (CoreC-45Name-u--show_Show_Name e-7) (string-append " => " (CoreC-45CaseC-45CaseTree-showCT (PreludeC-45TypesC-45List-tailRecAppend (cons e-6 (cons e-7 '())) arg-0) arg-1 e-8)))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (string-append "Constant " (string-append (CoreC-45TTC-45Primitive-u--show_Show_Constant e-10) (string-append " => " (CoreC-45CaseC-45CaseTree-showCT arg-0 arg-1 e-11))))))) (else (let ((e-13 (vector-ref arg-2 1))) (string-append "_ => " (CoreC-45CaseC-45CaseTree-showCT arg-0 arg-1 e-13)))))))
(define CoreC-45CaseC-45CaseTree-showCT (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (string-append "case " (string-append (CoreC-45Name-u--show_Show_Name e-1) (string-append "[" (string-append (PreludeC-45Show-u--show_Show_Nat e-2) (string-append "] : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-0 e-4) (string-append " of" (string-append "\u000a" (string-append arg-1 (string-append " { " (string-append (CoreC-45NameC-45Namespace-showSep (string-append "\u000a" (string-append arg-1 " | ")) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45CaseC-45CaseTree-showCA arg-0 (string-append "  " arg-1) eta-0)) e-5)) (string-append "\u000a" (string-append arg-1 " }")))))))))))))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (string-append "[" (string-append (PreludeC-45Show-u--show_Show_Int e-7) (string-append "] " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-0 e-8))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (string-append "Error: " (PreludeC-45Show-u--show_Show_String e-10)))) (else "Impossible"))))
(define CoreC-45CaseC-45CaseTree-u--show_Show_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-0 ext-0) (CoreC-45CaseC-45CaseTree-showCT arg-0 "" ext-0)))
(define CoreC-45ContextC-45Context-u--show_Show_Def (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "undefined") ((1) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (let ((e-3 (vector-ref arg-0 4))) (DataC-45String-fastUnlines (cons (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) e-1) ";") (cons (string-append "Compile time tree: " (CoreC-45CaseC-45CaseTree-u--show_Show_C-40CaseTreeC-32C-36varsC-41 e-1 e-2)) (cons (string-append "Run time tree: " (CoreC-45CaseC-45CaseTree-u--show_Show_C-40CaseTreeC-32C-36varsC-41 e-1 e-3)) '())))))))) ((5) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (let ((e-7 (vector-ref arg-0 3))) (string-append "DataCon " (string-append (PreludeC-45Show-u--show_Show_Int e-5) (string-append " " (string-append (PreludeC-45Show-u--show_Show_Nat e-6) (PreludeC-45Types-maybe (lambda () "") (lambda () (lambda (u--n) (string-append " (newtype by " (string-append (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-1085) u--n) ")")))) e-7))))))))) ((6) (let ((e-8 (vector-ref arg-0 1))) (let ((e-9 (vector-ref arg-0 2))) (let ((e-12 (vector-ref arg-0 5))) (let ((e-13 (vector-ref arg-0 6))) (let ((e-14 (vector-ref arg-0 7))) (string-append "TyCon " (string-append (PreludeC-45Show-u--show_Show_Nat e-8) (string-append " params: " (string-append (LibrariesC-45DataC-45NatSet-u--show_Show_NatSet e-9) (string-append " constructors: " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 (force csegen-68) u--d u--x)))) e-13) (string-append " mutual with: " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-68) e-12) (string-append " detaggable by: " (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (force csegen-1091) e-14)))))))))))))))) ((2) (let ((e-15 (vector-ref arg-0 1))) (string-append "<external def with arity " (string-append (PreludeC-45Show-u--show_Show_Nat e-15) ">")))) ((3) (let ((e-16 (vector-ref arg-0 1))) (let ((e-17 (vector-ref arg-0 2))) (string-append "<foreign def with arity " (string-append (PreludeC-45Show-u--show_Show_Nat e-16) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-512) e-17) ">"))))))) ((4) (let ((e-18 (vector-ref arg-0 1))) (string-append "<builtin with arith " (string-append (PreludeC-45Show-u--show_Show_Nat e-18) ">")))) ((7) (let ((e-21 (vector-ref arg-0 2))) (string-append "Hole" (let ((sc1 (let ((e-0 (car e-21))) e-0))) (cond ((equal? sc1 1) " [impl]") (else "")))))) ((8) (let ((e-24 (vector-ref arg-0 3))) (string-append "Search in " (CoreC-45Name-u--show_Show_Name e-24)))) ((9) (let ((e-25 (vector-ref arg-0 1))) (let ((e-27 (vector-ref arg-0 3))) (string-append "Guess " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 '() e-25) (string-append " when " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (force csegen-514) e-27))))))) ((11) (let ((e-28 (vector-ref arg-0 1))) (string-append "Universe level #" (PreludeC-45Show-u--show_Show_Integer e-28)))) ((10) "Bound name") (else "Delayed"))))
(define CoreC-45ContextC-45Context-u--showPrec_Show_Def (lambda (arg-0 arg-1) (CoreC-45ContextC-45Context-u--show_Show_Def arg-1)))
(define csegen-2116 (cons (lambda (u--x) (CoreC-45ContextC-45Context-u--show_Show_Def u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45ContextC-45Context-u--showPrec_Show_Def u--d u--x)))))
(define CoreC-45Context-u--full_HasNames_C-40CaseAltC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-lookupCtxtExact e-1 arg-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) (if (null? e-6) (vector 1 (vector 0 e-1 e-2 e-3 e-5)) (let ((e-7 (unbox e-6))) (vector 1 (vector 0 (let ((e-29 (vector-ref e-7 1))) e-29) e-2 e-3 e-5))))))))))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-6 e-7 e-5)))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-10 e-5))))))))) (else (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 3 e-5)))))))))))
(define CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (arg-7779) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_C-40CaseAltC-32C-36varsC-41 arg-1 arg-7779 eta-0))) e-5 '()) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-7 (vector-ref act-2 1))) (vector 1 (vector 0 e-1 e-2 e-6 e-7))))))))))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-8) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 1 e-7 e-5)))))))))(else (vector 1 arg-2)))))
(define CoreC-45Context-n--14769-9780-u--fullNamesPat (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (car arg-6))) (let ((e-3 (cdr arg-6))) (lambda (clam-0) (let ((e-6 (car e-3))) (let ((e-7 (cdr e-3))) (let ((e-10 (car e-7))) (let ((e-11 (cdr e-7))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-5 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-10) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-8 (vector-ref act-2 1))) (let ((act-3 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-11) clam-0))) (case (vector-ref act-3 0) ((0) (let ((e-4 (vector-ref act-3 1))) (vector 0 e-4))) (else (let ((e-9 (vector-ref act-3 1))) (vector 1 (cons e-2 (cons e-5 (cons e-8 e-9)))))))))))))))))))))))))
(define CoreC-45Context-u--full_HasNames_Def (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((e-3 (vector-ref arg-1 4))) (let ((e-4 (vector-ref arg-1 5))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) (let ((act-3 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-n--14769-9780-u--fullNamesPat e-4 e-1 e-3 e-2 e-0 arg-0 eta-0)) e-4 '()) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) (vector 1 (vector 1 e-0 e-1 e-5 e-6 e-7)))))))))))))))))))) ((6) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((e-8 (vector-ref arg-1 4))) (let ((e-9 (vector-ref arg-1 5))) (let ((e-10 (vector-ref arg-1 6))) (let ((e-11 (vector-ref arg-1 7))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-9 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-12 (vector-ref act-1 1))) (let ((act-2 (if (null? e-10) (vector 1 '()) (let ((e-2 (unbox e-10))) ((let ((eff-0 (CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-2 '()))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1062 eff-0 eta-0))) ext-0))))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-13 (vector-ref act-2 1))) (vector 1 (vector 6 e-5 e-6 e-7 e-8 e-12 e-13 e-11)))))))))))))))))) ((8) (let ((e-12 (vector-ref arg-1 1))) (let ((e-13 (vector-ref arg-1 2))) (let ((e-14 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-0 e-14 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 8 e-12 e-13 e-5)))))))))) ((9) (let ((e-15 (vector-ref arg-1 1))) (let ((e-16 (vector-ref arg-1 2))) (let ((e-17 (vector-ref arg-1 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-15) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 9 e-5 e-16 e-17))))))))))(else (vector 1 arg-1)))))
(define csegen-2128 (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Def arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Def arg-7786 arg-7789 eta-0))))))
(define CoreC-45TTC-45Var-insertVarNames (lambda (arg-3 arg-4 arg-5) (CoreC-45TTC-45Var-insertNVarNames arg-3 arg-4 arg-5)))
(define CoreC-45TTC-45Var-u--genWeakenNs_GenWeaken_C-40VarC-32C-91aC-32C-61C-32NameC-93C-41 (lambda (ext-0 ext-1 ext-2) (CoreC-45TTC-45Var-insertVarNames ext-0 ext-1 ext-2)))
(define CoreC-45TTC-45Var-WeakenVar (CoreC-45NameC-45Scoped-GenWeakenWeakens (lambda (outer-4842) (lambda (ns-4843) (lambda (local-4844) (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (CoreC-45TTC-45Var-u--genWeakenNs_GenWeaken_C-40VarC-32C-91aC-32C-61C-32NameC-93C-41 eta-0 eta-1 eta-2)))))))))
(define csegen-2131 (let ((sc0 CoreC-45TTC-45Var-WeakenVar)) (let ((e-1 (car sc0))) ((e-1 'erased) 'erased))))
(define System-u--cast_Cast_ExitCode_Int (lambda (arg-0) (if (null? arg-0) 0 (let ((e-0 (car arg-0))) e-0))))
(define System-exitWith (lambda (arg-2 ext-0) (let ((e-2 (cdr arg-2))) ((e-2 'erased) (lambda (eta-1) (System-prim__exit (System-u--cast_Cast_ExitCode_Int ext-0) eta-1))))))
(define csegen-2133(delay (System-exitWith (force csegen-85) (cons 1 'erased))))
(define SystemC-45FileC-45Virtual-stdin (SystemC-45FileC-45Virtual-prim__stdin))
(define SystemC-45FileC-45Virtual-stdout (SystemC-45FileC-45Virtual-prim__stdout))
(define csegen-2147 (vector 0 0 SystemC-45FileC-45Virtual-stdin SystemC-45FileC-45Virtual-stdout))
(define CoreC-45Core-u--catch_Catchable_Core_Error (lambda (arg-1 arg-2 ext-0) (let ((act-1 (arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) ((arg-2 e-2) ext-0))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 e-5)))))))
(define csegen-2148 (lambda (arg-10451) (lambda (arg-10454) (lambda (eta-0) (CoreC-45Core-u--catch_Catchable_Core_Error arg-10451 arg-10454 eta-0)))))
(define csegen-2157 (LibrariesC-45DataC-45Version-showVersion 1 IdrisC-45Version-version))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 ext-0) (vector 1 'erased)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 ext-0) (vector 1 'erased)))
(define csegen-2165 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 i_con-0 eta-0)))))
(define csegen-2169 (let ((eff-0 (lambda (world-0) (let ((act-1 (PreludeC-45IO-prim__putStr "Processing as TTImp\u000a" world-0))) (vector 1 act-1))))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (force csegen-27) eff-0 eta-0))))
(define YaffleC-45Main-u--full_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 ext-0) (vector 1 'erased)))
(define YaffleC-45Main-u--resolved_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 ext-0) (vector 1 'erased)))
(define csegen-2173 (cons (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (YaffleC-45Main-u--full_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (YaffleC-45Main-u--resolved_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 arg-7786 arg-7789 eta-0))))) csegen-2165))
(define csegen-2175 (let ((eff-0 (lambda (world-0) (let ((act-1 (PreludeC-45IO-prim__putStr "Written TTC\u000a" world-0))) (vector 1 act-1))))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (force csegen-27) eff-0 eta-0))))
(define YaffleC-45Main-usage "Usage: yaffle <input file> [--timing]")
(define csegen-2176 (lambda (eta-0) (PreludeC-45IO-prim__putStr (string-append YaffleC-45Main-usage "\u000a") eta-0)))
(define CoreC-45TT-u--show_Show_KindedName (lambda (ext-0) (CoreC-45Name-u--show_Show_Name (let ((e-2 (vector-ref ext-0 2))) e-2))))
(define CoreC-45TT-u--showPrec_Show_KindedName (lambda (arg-0 arg-1) (CoreC-45TT-u--show_Show_KindedName arg-1)))
(define csegen-2179(delay (cons (lambda (u--x) (CoreC-45TT-u--show_Show_KindedName u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TT-u--showPrec_Show_KindedName u--d u--x))))))
(define csegen-2188(delay (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 (force csegen-68) u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 (force csegen-68) u--d u--x))))))
(define csegen-2190 (let ((eff-0 (lambda (world-0) (let ((act-1 (PreludeC-45IO-prim__putStr "Failed\u000a" world-0))) (vector 1 act-1))))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (force csegen-27) eff-0 eta-0))))
(define csegen-2202(delay (cons (force csegen-518) (force csegen-518))))
(define csegen-2206(delay (cons (force csegen-1011) (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2202) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2202) u--d u--x)))))))
(define csegen-2209(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2206) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2206) u--d u--x))))))
(define ProtocolC-45IDEC-45Decoration-u--show_Show_Decoration (lambda (arg-0) (cond ((equal? arg-0 0) "comment") ((equal? arg-0 1) "type") ((equal? arg-0 2) "function") ((equal? arg-0 3) "data") ((equal? arg-0 4) "keyword") ((equal? arg-0 5) "bound") ((equal? arg-0 6) "namespace") ((equal? arg-0 7) "postulate") (else "module"))))
(define csegen-2212(delay (cons (cons (lambda (u--x) (ProtocolC-45IDEC-45Decoration-u--show_Show_Decoration u--x)) (lambda (u--d) (lambda (u--x) (ProtocolC-45IDEC-45Decoration-u--show_Show_Decoration u--x)))) (force csegen-1026))))
(define csegen-2216(delay (cons (force csegen-2209) (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2212) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2212) u--d u--x)))))))
(define csegen-2219(delay (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2216) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-2216) u--d u--x))))))
(define csegen-2225 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1644 i_con-0 eta-0)))))
(define csegen-2226 (cons csegen-2225 csegen-2225))
(define csegen-2230 (cons (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_OriginDesc i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_OriginDesc i_con-0 eta-0)))) (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2226 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2226 i_con-0 eta-0))))))
(define csegen-2233 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2230 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2230 i_con-0 eta-0)))))
(define csegen-2234 (cons csegen-1616 csegen-1671))
(define csegen-2237 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2234 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2234 i_con-0 eta-0)))))
(define csegen-2238 (cons csegen-2233 csegen-2237))
(define csegen-2241 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2238 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2238 i_con-0 eta-0)))))
(define csegen-2242 (cons csegen-43 csegen-2237))
(define csegen-2246 (cons csegen-2233 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2242 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2242 i_con-0 eta-0))))))
(define csegen-2249 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2246 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2246 i_con-0 eta-0)))))
(define csegen-2250 (cons csegen-43 csegen-1671))
(define csegen-2253 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2250 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2250 i_con-0 eta-0)))))
(define csegen-2254 (cons csegen-2233 csegen-43))
(define LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 (lambda (ext-0) (Builtin-snd (Builtin-fst ext-0))))
(define csegen-2258 (cons (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2254 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2254 i_con-0 eta-0)))) (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-0))))
(define CoreC-45Metadata-u--fromBuf_TTC_Decoration (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (cond ((equal? e-5 0) (vector 1 1)) ((equal? e-5 1) (vector 1 2)) ((equal? e-5 2) (vector 1 3)) ((equal? e-5 3) (vector 1 4)) ((equal? e-5 4) (vector 1 5)) ((equal? e-5 5) (vector 1 6)) ((equal? e-5 6) (vector 1 7)) ((equal? e-5 7) (vector 1 8)) ((equal? e-5 8) (vector 1 0))(else (CoreC-45BinaryC-45Prims-corrupt "Decoration" ext-0)))))))))
(define CoreC-45Metadata-u--toBuf_TTC_Decoration (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 2) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((equal? arg-1 3) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((equal? arg-1 4) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((equal? arg-1 5) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((equal? arg-1 6) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((equal? arg-1 7) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((equal? arg-1 8) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)))))
(define csegen-2265 (cons (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45Metadata-u--toBuf_TTC_Decoration i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45Metadata-u--fromBuf_TTC_Decoration i_con-0 eta-0)))) (cons (lambda (i_con-0) (lambda (arg-5586) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-43 i_con-0 arg-5586))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-43 i_con-0 eta-0))))))
(define csegen-2269 (cons csegen-2233 (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2265 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2265 i_con-0 eta-0))))))
(define csegen-2273 (cons (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2269 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2269 i_con-0 eta-0)))) (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-0))))
(define csegen-2274 (cons csegen-2233 csegen-2233))
(define csegen-2278 (cons (cons (lambda (i_con-0) (lambda (arg-5586) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2274 i_con-0 arg-5586 eta-0)))) (lambda (i_con-0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2274 i_con-0 eta-0)))) (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-0))))
(define csegen-2279 (cons (force csegen-939) (force csegen-1331)))
(define csegen-2282 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2279 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2279 u--d u--x)))))
(define csegen-2283 (cons (force csegen-2209) csegen-2282))
(define csegen-2287 (cons (force csegen-68) csegen-2282))
(define csegen-2291 (cons (force csegen-2209) (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2287 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2287 u--d u--x))))))
(define csegen-2294 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2291 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2291 u--d u--x)))))
(define csegen-2295 (cons (force csegen-68) (force csegen-1331)))
(define csegen-2299 (cons (force csegen-2209) (force csegen-68)))
(define csegen-2303 (cons (force csegen-2209) (force csegen-2209)))
(define CoreC-45Name-dropNS (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) e-1))(else arg-0))))
(define csegen-2307 (lambda (u--x) (lambda (u--y) (CoreC-45Name-u--C-61C-61_Eq_Name (CoreC-45Name-dropNS u--x) (CoreC-45Name-dropNS u--y)))))
(define LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Digit (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) ((arg-2 e-1) arg-3))) ((1) (let ((e-3 (vector-ref arg-4 1))) (let ((e-4 (vector-ref arg-4 2))) ((arg-2 e-3) ((arg-2 e-4) arg-3))))) ((2) (let ((e-6 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 2))) (let ((e-8 (vector-ref arg-4 3))) ((arg-2 e-6) ((arg-2 e-7) ((arg-2 e-8) arg-3))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) ((arg-2 e-10) ((arg-2 e-11) ((arg-2 e-12) ((arg-2 e-13) arg-3))))))))))))
(define LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Node (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-2 (vector-ref arg-4 2))) (let ((e-3 (vector-ref arg-4 3))) ((arg-2 e-2) ((arg-2 e-3) arg-3))))) (else (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((e-8 (vector-ref arg-4 4))) ((arg-2 e-6) ((arg-2 e-7) ((arg-2 e-8) arg-3))))))))))
(define LibrariesC-45DataC-45PosMap-u--foldr_Foldable_PosMap (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) arg-3) ((1) (let ((e-2 (vector-ref arg-4 1))) ((arg-2 e-2) arg-3))) (else (let ((e-5 (vector-ref arg-4 2))) (let ((e-6 (vector-ref arg-4 3))) (let ((e-7 (vector-ref arg-4 4))) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Digit arg-2 (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_PosMap (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (lambda (eta-3) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Node arg-2 eta-2 eta-3))) eta-0 eta-1))) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Digit arg-2 arg-3 e-7) e-6) e-5))))))))
(define LibrariesC-45DataC-45PosMap-u--foldMap_Foldable_PosMap (lambda (arg-2 arg-3 ext-0) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_PosMap (lambda (eta-0) (let ((e-1 (car arg-2))) (e-1 (arg-3 eta-0)))) (let ((e-2 (cdr arg-2))) e-2) ext-0)))
(define csegen-2308 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45DataC-45PosMap-u--foldMap_Foldable_PosMap (force csegen-59) eta-0 eta-1))))
(define LibrariesC-45DataC-45PosMap-u--cast_Cast_FileRange_RMFileRange (lambda (arg-0) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cons (cons e-2 e-3) e-3)))))
(define LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-36a (lambda (arg-1 ext-0) (LibrariesC-45DataC-45PosMap-u--cast_Cast_FileRange_RMFileRange (arg-1 ext-0))))
(define csegen-2309 (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-36a (lambda (eta-1) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-1)) eta-0)))
(define LibrariesC-45DataC-45PosMap-greater (lambda (arg-0 arg-1) (if (null? arg-1) 0 (let ((e-0 (unbox arg-1))) (let ((e-1 (car e-0))) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) (Builtin-fst e-1) arg-0))))))
(define LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (lambda (ext-0) (box ext-0)))
(define LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval '())
(define LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval) ((1) (let ((e-2 (vector-ref arg-2 1))) (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-2)))) (else (let ((e-4 (vector-ref arg-2 1))) (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval e-4))))))
(define LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (lambda (arg-0 arg-1) (let ((e-1 (cdr arg-0))) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (cons e-2 (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) e-1 e-3)))))))
(define LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (arg-1 e-1))) ((1) (let ((e-3 (vector-ref arg-2 1))) (let ((e-4 (vector-ref arg-2 2))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 e-3) (arg-1 e-4))))) ((2) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 e-6) (arg-1 e-7)) (arg-1 e-8)))))) (else (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 e-10) (arg-1 e-11)) (arg-1 e-12)) (arg-1 e-13))))))))))
(define LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 (lambda (arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-1 (vector-ref arg-1 1))) e-1)) (else (let ((e-5 (vector-ref arg-1 1))) e-5)))))
(define LibrariesC-45DataC-45PosMap-n--5635-4859-u--value (lambda (arg-1 arg-2 arg-3 arg-4) (let ((sc0 (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) arg-3))) (if (null? sc0) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-4) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2)) (let ((e-0 (unbox sc0))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-4) e-0) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2)))))))
(define LibrariesC-45DataC-45PosMap-deep (lambda (arg-1 arg-2 arg-3 arg-4) (vector 2 (LibrariesC-45DataC-45PosMap-n--5635-4859-u--value arg-1 arg-4 arg-3 arg-2) arg-2 arg-3 arg-4)))
(define LibrariesC-45DataC-45PosMap-node3 (lambda (arg-1 arg-2 arg-3 arg-4) (vector 1 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 arg-2) (arg-1 arg-3)) (arg-1 arg-4)) arg-2 arg-3 arg-4)))
(define LibrariesC-45DataC-45PosMap-C-60C-124 (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (vector 1 arg-2)) ((1) (let ((e-2 (vector-ref arg-3 1))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 0 arg-2) (vector 0 ) (vector 0 e-2)))) (else (let ((e-5 (vector-ref arg-3 2))) (let ((e-6 (vector-ref arg-3 3))) (let ((e-7 (vector-ref arg-3 4))) (case (vector-ref e-5 0) ((0) (let ((e-9 (vector-ref e-5 1))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 arg-2 e-9) e-6 e-7))) ((1) (let ((e-11 (vector-ref e-5 1))) (let ((e-12 (vector-ref e-5 2))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 2 arg-2 e-11 e-12) e-6 e-7)))) ((2) (let ((e-14 (vector-ref e-5 1))) (let ((e-15 (vector-ref e-5 2))) (let ((e-16 (vector-ref e-5 3))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 3 arg-2 e-14 e-15 e-16) e-6 e-7))))) (else (let ((e-18 (vector-ref e-5 1))) (let ((e-19 (vector-ref e-5 2))) (let ((e-20 (vector-ref e-5 3))) (let ((e-21 (vector-ref e-5 4))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 arg-2 e-18) (LibrariesC-45DataC-45PosMap-C-60C-124 (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) (LibrariesC-45DataC-45PosMap-node3 arg-1 e-19 e-20 e-21) e-6) e-7))))))))))))))
(define LibrariesC-45DataC-45PosMap-digitToTree (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (vector 1 e-1))) ((1) (let ((e-3 (vector-ref arg-2 1))) (let ((e-4 (vector-ref arg-2 2))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 0 e-3) (vector 0 ) (vector 0 e-4))))) ((2) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 e-6 e-7) (vector 0 ) (vector 0 e-8)))))) (else (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 e-10 e-11) (vector 0 ) (vector 1 e-12 e-13))))))))))
(define LibrariesC-45DataC-45PosMap-nodeToDigit (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (vector 1 e-2 e-3)))) (else (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (vector 2 e-6 e-7 e-8))))))))
(define LibrariesC-45DataC-45PosMap-viewl (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) '()) ((1) (let ((e-2 (vector-ref arg-2 1))) (cons e-2 (vector 0 )))) (else (let ((e-5 (vector-ref arg-2 2))) (let ((e-6 (vector-ref arg-2 3))) (let ((e-7 (vector-ref arg-2 4))) (case (vector-ref e-5 0) ((0) (let ((e-9 (vector-ref e-5 1))) (cons e-9 (LibrariesC-45DataC-45PosMap-rotl arg-1 e-6 e-7)))) ((1) (let ((e-11 (vector-ref e-5 1))) (let ((e-12 (vector-ref e-5 2))) (cons e-11 (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 0 e-12) e-6 e-7))))) ((2) (let ((e-14 (vector-ref e-5 1))) (let ((e-15 (vector-ref e-5 2))) (let ((e-16 (vector-ref e-5 3))) (cons e-14 (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 e-15 e-16) e-6 e-7)))))) (else (let ((e-18 (vector-ref e-5 1))) (let ((e-19 (vector-ref e-5 2))) (let ((e-20 (vector-ref e-5 3))) (let ((e-21 (vector-ref e-5 4))) (cons e-18 (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 2 e-19 e-20 e-21) e-6 e-7)))))))))))))))
(define LibrariesC-45DataC-45PosMap-rotl (lambda (arg-1 arg-2 arg-3) (let ((sc0 (LibrariesC-45DataC-45PosMap-viewl (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) arg-2))) (if (null? sc0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 arg-3) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (let ((sc1 (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) arg-2))) (if (null? sc1) (vector 2 (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-3) (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-2) e-3 arg-3) (let ((e-0 (unbox sc1))) (vector 2 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange e-0 (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-3)) (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-2) e-3 arg-3))))))))))
(define LibrariesC-45DataC-45PosMap-deepl (lambda (arg-1 arg-2 arg-3 arg-4) (if (null? arg-2) (LibrariesC-45DataC-45PosMap-rotl arg-1 arg-3 arg-4) (let ((e-2 (unbox arg-2))) (LibrariesC-45DataC-45PosMap-deep arg-1 e-2 arg-3 arg-4)))))
(define LibrariesC-45DataC-45PosMap-viewr (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) '()) ((1) (let ((e-2 (vector-ref arg-2 1))) (cons (vector 0 ) e-2))) (else (let ((e-5 (vector-ref arg-2 2))) (let ((e-6 (vector-ref arg-2 3))) (let ((e-7 (vector-ref arg-2 4))) (case (vector-ref e-7 0) ((0) (let ((e-9 (vector-ref e-7 1))) (cons (LibrariesC-45DataC-45PosMap-rotr arg-1 e-5 e-6) e-9))) ((1) (let ((e-11 (vector-ref e-7 1))) (let ((e-12 (vector-ref e-7 2))) (cons (LibrariesC-45DataC-45PosMap-deep arg-1 e-5 e-6 (vector 0 e-11)) e-12)))) ((2) (let ((e-14 (vector-ref e-7 1))) (let ((e-15 (vector-ref e-7 2))) (let ((e-16 (vector-ref e-7 3))) (cons (LibrariesC-45DataC-45PosMap-deep arg-1 e-5 e-6 (vector 1 e-14 e-15)) e-16))))) (else (let ((e-18 (vector-ref e-7 1))) (let ((e-19 (vector-ref e-7 2))) (let ((e-20 (vector-ref e-7 3))) (let ((e-21 (vector-ref e-7 4))) (cons (LibrariesC-45DataC-45PosMap-deep arg-1 e-5 e-6 (vector 2 e-18 e-19 e-20)) e-21))))))))))))))
(define LibrariesC-45DataC-45PosMap-rotr (lambda (arg-1 arg-2 arg-3) (let ((sc0 (LibrariesC-45DataC-45PosMap-viewr (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) arg-3))) (if (null? sc0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 arg-2) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (let ((sc1 (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) arg-3))) (if (null? sc1) (vector 2 (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2) arg-2 e-2 (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-3)) (let ((e-0 (unbox sc1))) (vector 2 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2) e-0) arg-2 e-2 (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-3)))))))))))
(define LibrariesC-45DataC-45PosMap-deepr (lambda (arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) (LibrariesC-45DataC-45PosMap-rotr arg-1 arg-2 arg-3) (let ((e-2 (unbox arg-4))) (LibrariesC-45DataC-45PosMap-deep arg-1 arg-2 arg-3 e-2)))))
(define LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (lambda (arg-0 arg-1) (if (null? arg-0) arg-1 (if (null? arg-1) arg-0 (let ((e-0 (unbox arg-0))) (let ((e-1 (unbox arg-1))) (box (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange e-0 e-1))))))))
(define LibrariesC-45DataC-45PosMap-searchDigit (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (cons '() (cons e-1 '())))) ((1) (let ((e-3 (vector-ref arg-4 1))) (let ((e-4 (vector-ref arg-4 2))) (let ((u--va (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-3))))) (let ((u--vb (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-4)) arg-5))) (let ((sc1 ((arg-2 u--va) u--vb))) (cond ((equal? sc1 1) (cons '() (cons e-3 (box (vector 0 e-4))))) (else (cons (box (vector 0 e-3)) (cons e-4 '())))))))))) ((2) (let ((e-6 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 2))) (let ((e-8 (vector-ref arg-4 3))) (let ((u--va (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-6))))) (let ((u--vab (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--va (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-7))))) (let ((u--vc (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-8)) arg-5))) (let ((u--vbc (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-7)) u--vc))) (let ((sc1 ((arg-2 u--va) u--vbc))) (cond ((equal? sc1 1) (cons '() (cons e-6 (box (vector 1 e-7 e-8))))) (else (let ((sc2 ((arg-2 u--vab) u--vc))) (cond ((equal? sc2 1) (cons (box (vector 0 e-6)) (cons e-7 (box (vector 0 e-8))))) (else (cons (box (vector 1 e-6 e-7)) (cons e-8 '())))))))))))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) (let ((u--va (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-10))))) (let ((u--vab (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--va (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-11))))) (let ((u--vabc (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vab (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-12))))) (let ((u--vd (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-13)) arg-5))) (let ((u--vcd (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-12)) u--vd))) (let ((u--vbcd (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-11)) u--vcd))) (let ((sc1 ((arg-2 u--va) u--vbcd))) (cond ((equal? sc1 1) (cons '() (cons e-10 (box (vector 2 e-11 e-12 e-13))))) (else (let ((sc2 ((arg-2 u--vab) u--vcd))) (cond ((equal? sc2 1) (cons (box (vector 0 e-10)) (cons e-11 (box (vector 1 e-12 e-13))))) (else (let ((sc3 ((arg-2 u--vabc) u--vd))) (cond ((equal? sc3 1) (cons (box (vector 1 e-10 e-11)) (cons e-12 (box (vector 0 e-13))))) (else (cons (box (vector 2 e-10 e-11 e-12)) (cons e-13 '())))))))))))))))))))))))))
(define LibrariesC-45DataC-45PosMap-searchNode (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (LibrariesC-45DataC-45PosMap-searchDigit arg-1 arg-2 arg-3 (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 arg-4) arg-5)))
(define LibrariesC-45DataC-45PosMap-searchTree (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-4 0) ((0) '()) ((1) (let ((e-2 (vector-ref arg-4 1))) (box (cons (vector 0 ) (cons e-2 (vector 0 )))))) (else (let ((e-5 (vector-ref arg-4 2))) (let ((e-6 (vector-ref arg-4 3))) (let ((e-7 (vector-ref arg-4 4))) (let ((u--vm (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) e-6))) (let ((u--vsr (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 e-7)) arg-5))) (let ((u--vmsr (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vm u--vsr))) (let ((u--vlp (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 e-5))))) (let ((u--vlpm (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vlp u--vm))) (let ((sc1 ((arg-2 u--vlp) u--vmsr))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45PosMap-searchDigit arg-1 arg-2 arg-3 e-5 u--vmsr))) (let ((e-2 (car sc2))) (let ((e-3 (cdr sc2))) (let ((e-9 (car e-3))) (let ((e-8 (cdr e-3))) (box (cons (PreludeC-45Types-maybe (lambda () (vector 0 )) (lambda () (lambda (eta-0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 eta-0))) e-2) (cons e-9 (LibrariesC-45DataC-45PosMap-deepl arg-1 e-8 e-6 e-7)))))))))) (else (let ((sc2 ((arg-2 u--vlpm) u--vsr))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (LibrariesC-45DataC-45PosMap-searchTree (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) arg-2 u--vlp e-6 u--vsr) (lambda (_-0) (let ((e-2 (car _-0))) (let ((e-3 (cdr _-0))) (let ((e-9 (car e-3))) (let ((e-8 (cdr e-3))) (let ((sc5 (LibrariesC-45DataC-45PosMap-searchNode arg-1 arg-2 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vlp (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) e-2)) e-9 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2916) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2916)) e-8) u--vsr)))) (let ((e-11 (car sc5))) (let ((e-10 (cdr sc5))) (let ((e-13 (car e-10))) (let ((e-12 (cdr e-10))) (box (cons (LibrariesC-45DataC-45PosMap-deepr arg-1 e-5 e-2 e-11) (cons e-13 (LibrariesC-45DataC-45PosMap-deepl arg-1 e-12 e-8 e-7)))))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45PosMap-searchDigit arg-1 arg-2 u--vlpm e-7 arg-5))) (let ((e-2 (car sc3))) (let ((e-3 (cdr sc3))) (let ((e-9 (car e-3))) (let ((e-8 (cdr e-3))) (box (cons (LibrariesC-45DataC-45PosMap-deepr arg-1 e-5 e-6 e-2) (cons e-9 (PreludeC-45Types-maybe (lambda () (vector 0 )) (lambda () (lambda (eta-0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 eta-0))) e-8)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45PosMap-split (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (cons (vector 0 ) (vector 0 )))(else (let ((sc0 (LibrariesC-45DataC-45PosMap-searchTree arg-1 (lambda (u--a) (lambda (_-10845) (arg-2 u--a))) LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval arg-3 LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval))) (if (null? sc0) (cons arg-3 (vector 0 )) (let ((e-1 (unbox sc0))) (let ((e-5 (car e-1))) (let ((e-6 (cdr e-1))) (let ((e-9 (car e-6))) (let ((e-10 (cdr e-6))) (let ((sc3 (arg-2 (LibrariesC-45DataC-45PosMap-measureTree arg-1 arg-3)))) (cond ((equal? sc3 1) (cons e-5 (LibrariesC-45DataC-45PosMap-C-60C-124 arg-1 e-9 e-10))) (else (cons arg-3 (vector 0 ))))))))))))))))
(define LibrariesC-45DataC-45PosMap-takeUntil (lambda (arg-1 arg-2 ext-0) (Builtin-fst (LibrariesC-45DataC-45PosMap-split arg-1 arg-2 ext-0))))
(define LibrariesC-45DataC-45PosMap-atleast (lambda (arg-0 arg-1) (if (null? arg-1) 0 (let ((e-0 (unbox arg-1))) (let ((e-2 (cdr e-0))) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-244) (force csegen-244) arg-0 e-2))))))
(define LibrariesC-45DataC-45PosMap-dropUntil (lambda (arg-1 arg-2 ext-0) (Builtin-snd (LibrariesC-45DataC-45PosMap-split arg-1 arg-2 ext-0))))
(define LibrariesC-45DataC-45PosMap-n--12747-11718-u--matches (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (let ((sc0 (LibrariesC-45DataC-45PosMap-viewl arg-1 (LibrariesC-45DataC-45PosMap-dropUntil arg-1 (lambda (eta-0) (LibrariesC-45DataC-45PosMap-atleast arg-4 eta-0)) arg-5)))) (if (null? sc0) '() (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (cons e-2 (LibrariesC-45DataC-45PosMap-n--12747-11718-u--matches arg-1 arg-2 arg-3 arg-4 e-3))))))))
(define LibrariesC-45DataC-45PosMap-inRange (lambda (arg-1 arg-2 arg-3 arg-4) (LibrariesC-45DataC-45PosMap-n--12747-11718-u--matches arg-1 arg-4 arg-3 arg-2 (LibrariesC-45DataC-45PosMap-takeUntil arg-1 (lambda (eta-0) (LibrariesC-45DataC-45PosMap-greater arg-3 eta-0)) arg-4))))
(define LibrariesC-45DataC-45PosMap-exactRange (lambda (arg-1 arg-2 arg-3 arg-4) (PreludeC-45Basics-flip csegen-1710 (LibrariesC-45DataC-45PosMap-inRange arg-1 arg-2 arg-3 arg-4) (lambda (u--a) (let ((sc0 (arg-1 u--a))) (let ((e-0 (car sc0))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (PreludeC-45Interfaces-guard (force csegen-270) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1701 csegen-1701 e-0 (cons arg-2 arg-3))) (lambda (_-10685) (box u--a)))))))))
(define csegen-2310 (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (LibrariesC-45DataC-45PosMap-exactRange csegen-2309 eta-0 eta-1 eta-2)))))
(define csegen-2329 (lambda (u--f) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 0 u--f (vector 7 ))))
(define DataC-45List-replicateTR (lambda (arg-1 arg-2 arg-3) (cond ((equal? arg-2 0) arg-1)(else (let ((e-0 (- arg-2 1))) (DataC-45List-replicateTR (cons arg-3 arg-1) e-0 arg-3))))))
(define DataC-45List-drop (lambda (arg-1 arg-2) (cond ((equal? arg-1 0) arg-2)(else (let ((e-0 (- arg-1 1))) (if (null? arg-2) '() (let ((e-4 (cdr arg-2))) (DataC-45List-drop e-0 e-4))))))))
(define DataC-45List-isPrefixOf (lambda (arg-1 ext-0 ext-1) (DataC-45List-isPrefixOfBy (let ((e-1 (car arg-1))) e-1) ext-0 ext-1)))
(define PreludeC-45TypesC-45List-lengthPlus (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-3 (cdr arg-2))) (PreludeC-45TypesC-45List-lengthPlus (+ arg-1 1) e-3)))))
(define PreludeC-45TypesC-45List-lengthTR (lambda (ext-0) (PreludeC-45TypesC-45List-lengthPlus 0 ext-0)))
(define PreludeC-45Types-isHexDigit (lambda (arg-0) (let ((sc0 (PreludeC-45Types-isDigit arg-0))) (cond ((equal? sc0 1) 1) (else (let ((sc1 (let ((sc2 (PreludeC-45EqOrd-u--C-60C-61_Ord_Char #\a arg-0))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\f)) (else 0))))) (cond ((equal? sc1 1) 1) (else (let ((sc2 (PreludeC-45EqOrd-u--C-60C-61_Ord_Char #\A arg-0))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\F)) (else 0)))))))))))
(define PreludeC-45Types-isOctDigit (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Char arg-0 #\0))) (cond ((equal? sc0 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\7)) (else 0)))))
(define ParserC-45SupportC-45Escaping-hex (lambda (arg-0) (cond ((equal? arg-0 #\0) (box 0)) ((equal? arg-0 #\1) (box 1)) ((equal? arg-0 #\2) (box 2)) ((equal? arg-0 #\3) (box 3)) ((equal? arg-0 #\4) (box 4)) ((equal? arg-0 #\5) (box 5)) ((equal? arg-0 #\6) (box 6)) ((equal? arg-0 #\7) (box 7)) ((equal? arg-0 #\8) (box 8)) ((equal? arg-0 #\9) (box 9)) ((equal? arg-0 #\a) (box 10)) ((equal? arg-0 #\b) (box 11)) ((equal? arg-0 #\c) (box 12)) ((equal? arg-0 #\d) (box 13)) ((equal? arg-0 #\e) (box 14)) ((equal? arg-0 #\f) (box 15))(else '()))))
(define PreludeC-45Types-toLower (lambda (arg-0) (let ((sc0 (PreludeC-45Types-isUpper arg-0))) (cond ((equal? sc0 1) (cast-int-char (bs+ (cast-char-boundedInt arg-0 63) 32 63))) (else arg-0)))))
(define ParserC-45SupportC-45Escaping-n--3759-3047-u--toHex (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) (box 0) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-hex (PreludeC-45Types-toLower e-2)) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-n--3759-3047-u--toHex arg-0 arg-1 arg-2 (bs* arg-3 16 63) e-3) (lambda (bind-1) (box (bs+ (bs* bind-0 arg-3 63) bind-1 63)))))))))))
(define ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32caseC-32blockC-32inC-32unescapeC-39-3478 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (if (null? e-2) (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-3) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-n--3759-3047-u--toHex arg-0 arg-1 arg-2 1 (PreludeC-45TypesC-45List-reverse e-2)) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-3) (lambda (bind-1) (box (cons (cast-int-char bind-0) bind-1)))))))))))
(define ParserC-45SupportC-45Escaping-oct (lambda (arg-0) (cond ((equal? arg-0 #\0) (box 0)) ((equal? arg-0 #\1) (box 1)) ((equal? arg-0 #\2) (box 2)) ((equal? arg-0 #\3) (box 3)) ((equal? arg-0 #\4) (box 4)) ((equal? arg-0 #\5) (box 5)) ((equal? arg-0 #\6) (box 6)) ((equal? arg-0 #\7) (box 7))(else '()))))
(define ParserC-45SupportC-45Escaping-n--3759-3048-u--toOct (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) (box 0) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-oct (PreludeC-45Types-toLower e-2)) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-n--3759-3048-u--toOct arg-0 arg-1 arg-2 (bs* arg-3 8 63) e-3) (lambda (bind-1) (box (bs+ (bs* bind-0 arg-3 63) bind-1 63)))))))))))
(define ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32caseC-32blockC-32inC-32unescapeC-39-3550 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (if (null? e-2) (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-3) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-n--3759-3048-u--toOct arg-0 arg-1 arg-2 1 (PreludeC-45TypesC-45List-reverse e-2)) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-3) (lambda (bind-1) (box (cons (cast-int-char bind-0) bind-1)))))))))))
(define ParserC-45SupportC-45Escaping-getEsc (lambda (arg-0) (cond ((equal? arg-0 "NUL") (box (integer->char 0))) ((equal? arg-0 "SOH") (box (integer->char 1))) ((equal? arg-0 "STX") (box (integer->char 2))) ((equal? arg-0 "ETX") (box (integer->char 3))) ((equal? arg-0 "EOT") (box (integer->char 4))) ((equal? arg-0 "ENQ") (box (integer->char 5))) ((equal? arg-0 "ACK") (box (integer->char 6))) ((equal? arg-0 "BEL") (box (integer->char 7))) ((equal? arg-0 "BS") (box (integer->char 8))) ((equal? arg-0 "HT") (box (integer->char 9))) ((equal? arg-0 "LF") (box (integer->char 10))) ((equal? arg-0 "VT") (box (integer->char 11))) ((equal? arg-0 "FF") (box (integer->char 12))) ((equal? arg-0 "CR") (box (integer->char 13))) ((equal? arg-0 "SO") (box (integer->char 14))) ((equal? arg-0 "SI") (box (integer->char 15))) ((equal? arg-0 "DLE") (box (integer->char 16))) ((equal? arg-0 "DC1") (box (integer->char 17))) ((equal? arg-0 "DC2") (box (integer->char 18))) ((equal? arg-0 "DC3") (box (integer->char 19))) ((equal? arg-0 "DC4") (box (integer->char 20))) ((equal? arg-0 "NAK") (box (integer->char 21))) ((equal? arg-0 "SYN") (box (integer->char 22))) ((equal? arg-0 "ETB") (box (integer->char 23))) ((equal? arg-0 "CAN") (box (integer->char 24))) ((equal? arg-0 "EM") (box (integer->char 25))) ((equal? arg-0 "SUB") (box (integer->char 26))) ((equal? arg-0 "ESC") (box (integer->char 27))) ((equal? arg-0 "FS") (box (integer->char 28))) ((equal? arg-0 "GS") (box (integer->char 29))) ((equal? arg-0 "RS") (box (integer->char 30))) ((equal? arg-0 "US") (box (integer->char 31))) ((equal? arg-0 "SP") (box #\ )) ((equal? arg-0 "DEL") (box (integer->char 127)))(else '()))))
(define ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32caseC-32blockC-32inC-32unescapeC-39-3617 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (if (null? e-2) (if (null? e-3) (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-3) (let ((e-6 (car e-3))) (let ((e-7 (cdr e-3))) (if (null? e-7) (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-3) (let ((e-9 (car e-7))) (let ((e-10 (cdr e-7))) (if (null? e-10) (let ((sc5 (ParserC-45SupportC-45Escaping-getEsc (PreludeC-45Types-fastPack (cons e-6 (cons e-9 '())))))) (if (null? sc5) (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 arg-3) (let ((e-1 (unbox sc5))) (box (cons e-1 '()))))) (let ((e-12 (car e-10))) (let ((e-13 (cdr e-10))) (let ((sc5 (ParserC-45SupportC-45Escaping-getEsc (PreludeC-45Types-fastPack (cons e-6 (cons e-9 (cons e-12 '()))))))) (if (null? sc5) (let ((sc6 (ParserC-45SupportC-45Escaping-getEsc (PreludeC-45Types-fastPack (cons e-6 (cons e-9 '())))))) (if (null? sc6) (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 arg-3) (let ((e-1 (unbox sc6))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 (cons e-12 e-13)) (lambda (bind-0) (box (cons e-1 bind-0))))))) (let ((e-1 (unbox sc5))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-13) (lambda (bind-0) (box (cons e-1 bind-0)))))))))))))))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-3) (lambda (bind-0) (box (cons (cast-int-char (cast-string-boundedInt (PreludeC-45Types-fastPack e-2) 63)) bind-0)))))))))
(define ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32unescapeC-39-3167 (lambda (arg-0 arg-1 arg-2 arg-3) (if (null? arg-3) (ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32caseC-32blockC-32inC-32unescapeC-39-3617 arg-0 arg-1 arg-2 arg-3 (DataC-45List-span (lambda (eta-0) (PreludeC-45Types-isDigit eta-0)) arg-3)) (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (cond ((equal? e-1 #\\) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons #\\ bind-0))))) ((equal? e-1 (integer->char 10)) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box bind-0)))) ((equal? e-1 #\&) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box bind-0)))) ((equal? e-1 #\a) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons (integer->char 7) bind-0))))) ((equal? e-1 #\b) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons (integer->char 8) bind-0))))) ((equal? e-1 #\f) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons (integer->char 12) bind-0))))) ((equal? e-1 #\n) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons (integer->char 10) bind-0))))) ((equal? e-1 #\r) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons (integer->char 13) bind-0))))) ((equal? e-1 #\t) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons (integer->char 9) bind-0))))) ((equal? e-1 #\v) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons (integer->char 11) bind-0))))) ((equal? e-1 #\') (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons #\' bind-0))))) ((equal? e-1 #\") (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-2 e-2) (lambda (bind-0) (box (cons #\" bind-0))))) ((equal? e-1 #\x) (ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32caseC-32blockC-32inC-32unescapeC-39-3478 arg-0 arg-1 arg-2 e-2 (DataC-45List-span (lambda (eta-0) (PreludeC-45Types-isHexDigit eta-0)) e-2))) ((equal? e-1 #\o) (ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32caseC-32blockC-32inC-32unescapeC-39-3550 arg-0 arg-1 arg-2 e-2 (DataC-45List-span (lambda (eta-0) (PreludeC-45Types-isOctDigit eta-0)) e-2)))(else (ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32caseC-32blockC-32inC-32unescapeC-39-3617 arg-0 arg-1 arg-2 arg-3 (DataC-45List-span (lambda (eta-0) (PreludeC-45Types-isDigit eta-0)) arg-3)))))))))
(define ParserC-45SupportC-45Escaping-unescapeC-39 (lambda (arg-0 arg-1) (if (null? arg-1) (box '()) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (let ((sc1 (DataC-45List-isPrefixOf csegen-17 arg-0 (cons e-2 e-3)))) (cond ((equal? sc1 1) (ParserC-45SupportC-45Escaping-case--caseC-32blockC-32inC-32unescapeC-39-3167 e-2 e-3 arg-0 (DataC-45List-drop (PreludeC-45TypesC-45List-lengthTR arg-0) (cons e-2 e-3)))) (else (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (ParserC-45SupportC-45Escaping-unescapeC-39 arg-0 e-3) (lambda (bind-0) (box (cons e-2 bind-0))))))))))))
(define ParserC-45SupportC-45Escaping-unescape (lambda (arg-0 arg-1) (let ((u--escapeChars (cons #\\ (DataC-45List-replicateTR '() arg-0 #\#)))) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (ParserC-45SupportC-45Escaping-unescapeC-39 u--escapeChars (PreludeC-45Types-fastUnpack arg-1))))))
(define ParserC-45RuleC-45Source-simpleStrLit (vector 1 "Expected string literal" (lambda (lcase-0) (case (vector-ref lcase-0 0) ((7) (let ((e-0 (vector-ref lcase-0 1))) (ParserC-45SupportC-45Escaping-unescape 0 e-0)))(else '())))))
(define csegen-2333 (lambda (u--f) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 0 u--f (LibrariesC-45TextC-45Parser-option 1 "" ParserC-45RuleC-45Source-simpleStrLit))))
(define ParserC-45RuleC-45Source-strEnd (vector 1 "Expected string end" (lambda (lcase-0) (case (vector-ref lcase-0 0) ((4) (box 'erased))(else '())))))
(define csegen-2336 (lambda (u--f) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 1 u--f ParserC-45RuleC-45Source-strEnd)))
(define ParserC-45RuleC-45Source-symbol (lambda (arg-0) (vector 1 (string-append "Expected '" (string-append arg-0 "'")) (lambda (lcase-0) (case (vector-ref lcase-0 0) ((12) (let ((e-0 (vector-ref lcase-0 1))) (PreludeC-45Interfaces-guard (force csegen-270) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 arg-0))))(else '()))))))
(define csegen-2414(delay (lambda (u--ps) (vector 11 0 (ParserC-45RuleC-45Source-symbol "}") (lambda () (vector 0 u--ps))))))
(define CoreC-45NameC-45Scoped-compat (lambda (arg-4) (let ((e-2 (vector-ref arg-4 1))) (((e-2 'erased) 'erased) 1))))
(define CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) (vector 0 )))) ((1) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) (vector 1 )))) ((2) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) (vector 2 )))) (else (let ((e-4 (vector-ref arg-5 1))) (let ((e-1 (vector-ref arg-3 0))) ((((e-1 'erased) 'erased) (lambda (eta-0) (vector 3 eta-0))) (arg-4 e-4))))))))
(define CoreC-45TTC-45Binder-u--traverse_Traversable_Binder (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-1 (vector-ref arg-5 1))) (let ((e-2 (vector-ref arg-5 2))) (let ((e-3 (vector-ref arg-5 3))) (let ((e-4 (vector-ref arg-5 4))) (let ((e-5 (vector-ref arg-3 2))) ((((e-5 'erased) 'erased) (let ((e-10 (vector-ref arg-3 0))) ((((e-10 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 0 e-1 e-2 eta-0 eta-1)))) (CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo arg-3 arg-4 e-3)))) (arg-4 e-4)))))))) ((1) (let ((e-6 (vector-ref arg-5 1))) (let ((e-7 (vector-ref arg-5 2))) (let ((e-8 (vector-ref arg-5 3))) (let ((e-9 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-10 (vector-ref arg-3 0))) ((((e-10 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 1 e-6 e-7 eta-0 eta-1)))) (arg-4 e-8)))) (arg-4 e-9)))))))) ((2) (let ((e-11 (vector-ref arg-5 1))) (let ((e-12 (vector-ref arg-5 2))) (let ((e-13 (vector-ref arg-5 3))) (let ((e-14 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-6 (vector-ref arg-3 0))) ((((e-6 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 2 e-11 e-12 eta-0 eta-1)))) (CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo arg-3 arg-4 e-13)))) (arg-4 e-14)))))))) ((3) (let ((e-16 (vector-ref arg-5 1))) (let ((e-17 (vector-ref arg-5 2))) (let ((e-18 (vector-ref arg-5 3))) (let ((e-19 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-6 (vector-ref arg-3 0))) ((((e-6 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 3 e-16 e-17 eta-0 eta-1)))) (CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo arg-3 arg-4 e-18)))) (arg-4 e-19)))))))) ((4) (let ((e-21 (vector-ref arg-5 1))) (let ((e-22 (vector-ref arg-5 2))) (let ((e-23 (vector-ref arg-5 3))) (let ((e-24 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-6 (vector-ref arg-3 0))) ((((e-6 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 4 e-21 e-22 eta-0 eta-1)))) (arg-4 e-23)))) (arg-4 e-24)))))))) (else (let ((e-26 (vector-ref arg-5 1))) (let ((e-27 (vector-ref arg-5 2))) (let ((e-28 (vector-ref arg-5 3))) (let ((e-1 (vector-ref arg-3 0))) ((((e-1 'erased) 'erased) (lambda (eta-0) (vector 5 e-26 e-27 eta-0))) (arg-4 e-28))))))))))
(define CoreC-45TTC-45Term-shrinkBinder (lambda (arg-2 arg-3) (CoreC-45TTC-45Binder-u--traverse_Traversable_Binder (force csegen-267) (lambda (u--t) (CoreC-45TTC-45Term-shrinkTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45VarC-45Var-first 0)
(define CoreC-45TTC-45VarC-45Var-later (lambda (arg-3) (+ arg-3 1)))
(define CoreC-45TTC-45Var-shrinkIsVar (lambda (arg-4 arg-6) (case (vector-ref arg-6 0) ((0) (box arg-4))(else (cond ((equal? arg-4 0) (case (vector-ref arg-6 0) ((1) '()) (else (box CoreC-45TTC-45VarC-45Var-first))))(else (let ((e-0 (- arg-4 1))) (case (vector-ref arg-6 0) ((1) (let ((e-15 (vector-ref arg-6 1))) (CoreC-45TTC-45Var-shrinkIsVar e-0 e-15))) (else (let ((e-20 (vector-ref arg-6 1))) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (CoreC-45TTC-45VarC-45Var-later eta-0)) (CoreC-45TTC-45Var-shrinkIsVar e-0 e-20))))))))))))
(define PreludeC-45Types-u--traverse_Traversable_List (lambda (arg-3 arg-4 arg-5) (if (null? arg-5) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) '())) (let ((e-2 (car arg-5))) (let ((e-3 (cdr arg-5))) (let ((e-4 (vector-ref arg-3 2))) ((((e-4 'erased) 'erased) (let ((e-6 (vector-ref arg-3 2))) ((((e-6 'erased) 'erased) (let ((e-10 (vector-ref arg-3 1))) ((e-10 'erased) (force csegen-108)))) (arg-4 e-2)))) (PreludeC-45Types-u--traverse_Traversable_List arg-3 arg-4 e-3))))))))
(define CoreC-45TTC-45Term-shrinkTerms (lambda (arg-2 arg-3) (PreludeC-45Types-u--traverse_Traversable_List (force csegen-267) (lambda (u--t) (CoreC-45TTC-45Term-shrinkTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45Term-shrinkTerm (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Var-shrinkIsVar e-4 arg-3) (lambda (_-0) (box (vector 0 e-2 e-3 _-0)))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (box (vector 1 e-7 e-8 e-9)))))) ((2) (let ((e-11 (vector-ref arg-2 1))) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerms e-14 arg-3) (lambda (bind-0) (box (vector 2 e-11 e-12 e-13 bind-0))))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkBinder e-18 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-19 (vector 2 arg-3)) (lambda (bind-1) (box (vector 3 e-16 e-17 bind-0 bind-1))))))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-22 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-23 arg-3) (lambda (bind-1) (box (vector 4 e-21 bind-0 bind-1)))))))))) ((5) (let ((e-25 (vector-ref arg-2 1))) (let ((e-26 (vector-ref arg-2 2))) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-27 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-28 arg-3) (lambda (bind-1) (box (vector 5 e-25 e-26 bind-0 bind-1))))))))))) ((6) (let ((e-30 (vector-ref arg-2 1))) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-32 arg-3) (lambda (bind-0) (box (vector 6 e-30 e-31 bind-0)))))))) ((7) (let ((e-34 (vector-ref arg-2 1))) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-36 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-37 arg-3) (lambda (bind-1) (box (vector 7 e-34 e-35 bind-0 bind-1))))))))))) ((8) (let ((e-39 (vector-ref arg-2 1))) (let ((e-40 (vector-ref arg-2 2))) (let ((e-41 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-41 arg-3) (lambda (bind-0) (box (vector 8 e-39 e-40 bind-0)))))))) ((9) (let ((e-43 (vector-ref arg-2 1))) (let ((e-44 (vector-ref arg-2 2))) (box (vector 9 e-43 e-44))))) ((10) (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (case (vector-ref e-47 0) ((0) (box (vector 10 e-46 (vector 0 )))) ((1) (box (vector 10 e-46 (vector 1 )))) (else (let ((e-54 (vector-ref e-47 1))) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (vector 10 e-46 (vector 2 eta-0))) (CoreC-45TTC-45Term-shrinkTerm e-54 arg-3)))))))) (else (let ((e-49 (vector-ref arg-2 1))) (let ((e-50 (vector-ref arg-2 2))) (box (vector 11 e-49 e-50))))))))
(define CoreC-45TTC-45Term-u--shrink_IsScoped_Term (lambda (ext-0 ext-1) (CoreC-45TTC-45Term-shrinkTerm ext-0 ext-1)))
(define CoreC-45TTC-45Term-thinBinder (lambda (arg-2 arg-3) (CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (u--t) (CoreC-45TTC-45Term-thinTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45Var-thinIsVar (lambda (arg-4 arg-6) (case (vector-ref arg-6 0) ((0) arg-4) ((1) (let ((e-17 (vector-ref arg-6 1))) (CoreC-45TTC-45VarC-45Var-later (CoreC-45TTC-45Var-thinIsVar arg-4 e-17))))(else (cond ((equal? arg-4 0) CoreC-45TTC-45VarC-45Var-first)(else (let ((e-0 (- arg-4 1))) (let ((e-10 (vector-ref arg-6 1))) (CoreC-45TTC-45VarC-45Var-later (CoreC-45TTC-45Var-thinIsVar e-0 e-10))))))))))
(define CoreC-45TTC-45Term-thinTerms (lambda (arg-2 arg-3) (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--t) (CoreC-45TTC-45Term-thinTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45Term-thinTerm (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((eff-0 (CoreC-45TTC-45Var-thinIsVar e-4 arg-3))) (vector 0 e-2 e-3 eff-0)))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (vector 1 e-7 e-8 e-9))))) ((2) (let ((e-11 (vector-ref arg-2 1))) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (vector 2 e-11 e-12 e-13 (CoreC-45TTC-45Term-thinTerms e-14 arg-3))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (vector 3 e-16 e-17 (CoreC-45TTC-45Term-thinBinder e-18 arg-3) (CoreC-45TTC-45Term-thinTerm e-19 (vector 2 arg-3)))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (vector 4 e-21 (CoreC-45TTC-45Term-thinTerm e-22 arg-3) (CoreC-45TTC-45Term-thinTerm e-23 arg-3)))))) ((5) (let ((e-25 (vector-ref arg-2 1))) (let ((e-26 (vector-ref arg-2 2))) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (vector 5 e-25 e-26 (CoreC-45TTC-45Term-thinTerm e-27 arg-3) (CoreC-45TTC-45Term-thinTerm e-28 arg-3))))))) ((6) (let ((e-30 (vector-ref arg-2 1))) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (vector 6 e-30 e-31 (CoreC-45TTC-45Term-thinTerm e-32 arg-3)))))) ((7) (let ((e-34 (vector-ref arg-2 1))) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (vector 7 e-34 e-35 (CoreC-45TTC-45Term-thinTerm e-36 arg-3) (CoreC-45TTC-45Term-thinTerm e-37 arg-3))))))) ((8) (let ((e-39 (vector-ref arg-2 1))) (let ((e-40 (vector-ref arg-2 2))) (let ((e-41 (vector-ref arg-2 3))) (vector 8 e-39 e-40 (CoreC-45TTC-45Term-thinTerm e-41 arg-3)))))) ((9) (let ((e-43 (vector-ref arg-2 1))) (let ((e-44 (vector-ref arg-2 2))) (vector 9 e-43 e-44)))) ((10) (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (case (vector-ref e-47 0) ((1) (vector 10 e-46 (vector 1 ))) ((0) (vector 10 e-46 (vector 0 ))) (else (let ((e-54 (vector-ref e-47 1))) (vector 10 e-46 (vector 2 (CoreC-45TTC-45Term-thinTerm e-54 arg-3))))))))) (else (let ((e-49 (vector-ref arg-2 1))) (let ((e-50 (vector-ref arg-2 2))) (vector 11 e-49 e-50)))))))
(define CoreC-45TTC-45Term-u--thin_IsScoped_Term (lambda (ext-0 ext-1) (CoreC-45TTC-45Term-thinTerm ext-0 ext-1)))
(define csegen-2452 (CoreC-45NameC-45Scoped-compat (vector CoreC-45TTC-45Term-WeakenTerm (lambda (u--ys) (lambda (u--xs) (lambda (arg-3446) (lambda (arg-3450) arg-3450)))) (lambda (xs-6282) (lambda (ys-6283) (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-u--thin_IsScoped_Term eta-0 eta-1))))) (lambda (xs-6294) (lambda (ys-6295) (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-u--shrink_IsScoped_Term eta-0 eta-1))))))))
(define LibrariesC-45DataC-45WithData-u--C-61C-61_Eq_C-40RecordC-32C-36fsC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 (let ((e-4 (car arg-1))) (let ((e-5 (cdr arg-1))) (let ((e-10 (car arg-2))) (let ((e-11 (cdr arg-2))) (let ((e-16 (car arg-3))) (let ((e-17 (cdr arg-3))) (let ((sc5 (let ((e-1 (car e-4))) ((e-1 e-10) e-16)))) (cond ((equal? sc5 1) (LibrariesC-45DataC-45WithData-u--C-61C-61_Eq_C-40RecordC-32C-36fsC-41 e-5 e-11 e-17)) (else 0)))))))))) (let ((e-4 (car arg-1))) (let ((e-5 (cdr arg-1))) (let ((e-10 (car arg-2))) (let ((e-11 (cdr arg-2))) (let ((e-16 (car arg-3))) (let ((e-17 (cdr arg-3))) (let ((sc4 (let ((e-1 (car e-4))) ((e-1 e-10) e-16)))) (cond ((equal? sc4 1) (LibrariesC-45DataC-45WithData-u--C-61C-61_Eq_C-40RecordC-32C-36fsC-41 e-5 e-11 e-17)) (else 0))))))))))))
(define LibrariesC-45DataC-45WithData-u--C-61C-61_Eq_C-40C-40WithDataC-32C-36fsC-41C-32C-36aC-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (let ((e-1 (car arg-3))) ((e-1 (let ((e-3 (cdr arg-4))) e-3)) (let ((e-3 (cdr arg-5))) e-3))))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45WithData-u--C-61C-61_Eq_C-40RecordC-32C-36fsC-41 arg-2 (let ((e-2 (car arg-4))) e-2) (let ((e-2 (car arg-5))) e-2))) (else 0)))))
(define CoreC-45FC-u--C-61C-61_Eq_OriginDesc (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-3 (vector-ref arg-1 1))) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent e-0 e-3)))(else 0)))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-4 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 e-4)))(else 0)))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0)))(else 0))))
(define CoreC-45FC-u--C-61C-61_Eq_FC (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((0) (let ((e-6 (vector-ref arg-1 1))) (let ((e-7 (vector-ref arg-1 2))) (let ((e-8 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_OriginDesc e-0 e-6))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-236) (force csegen-236) e-1 e-7))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-236) (force csegen-236) e-2 e-8)) (else 0)))) (else 0)))))))(else 0)))))) ((1) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((1) (let ((e-9 (vector-ref arg-1 1))) (let ((e-10 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_OriginDesc e-3 e-9))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-236) (force csegen-236) e-4 e-10))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-236) (force csegen-236) e-5 e-11)) (else 0)))) (else 0)))))))(else 0)))))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0)))(else 0))))
(define IdrisC-45Error-u--C-61C-61_Eq_FileError (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-0 e-1)))(else 0)))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (case (vector-ref arg-1 0) ((4) 1)(else 0))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0)))(else 0))))
(define IdrisC-45Error-u--C-61C-61_Eq_TTCErrorMsg (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((0) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-5))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-1 e-6))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-2 e-7)) (else 0)))) (else 0)))))))(else 0)))))) ((1) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-8 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-3 e-8)))(else 0)))) ((2) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-9 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-4 e-9)))(else 0))))(else 0))))
(define CoreC-45TT-u--C-61C-61_Eq_Visibility (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define csegen-3304 (cons (lambda (arg-712) (lambda (arg-715) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (force csegen-298) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (DataC-45List1-u--C-47C-61_Eq_C-40List1C-32C-36aC-41 (force csegen-298) arg-722 arg-725)))))
(define CoreC-45FC-u--C-47C-61_Eq_FC (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45FC-u--C-61C-61_Eq_FC arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-3289 (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45FC-u--C-61C-61_Eq_FC arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45FC-u--C-47C-61_Eq_FC arg-722 arg-725)))))
(define csegen-3310 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3289 (force csegen-298) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3289 (force csegen-298) arg-722 arg-725)))))
(define IdrisC-45Error-u--C-61C-61_Eq_Warning (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-17 (vector-ref arg-1 1))) (let ((e-18 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-0 e-17))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 e-18)) (else 0))))))(else 0))))) ((1) (let ((e-3 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((1) (let ((e-20 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-3 e-20)))(else 0)))) ((2) (let ((e-6 (vector-ref arg-0 1))) (let ((e-7 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-23 (vector-ref arg-1 1))) (let ((e-24 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-6 e-23))) (cond ((equal? sc2 1) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-298) csegen-3304 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-298) csegen-3304 arg-722 arg-725)))) e-7 e-24)) (else 0))))))(else 0))))) ((3) (let ((e-8 (vector-ref arg-0 1))) (let ((e-9 (vector-ref arg-0 2))) (let ((e-10 (vector-ref arg-0 3))) (let ((e-11 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((3) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (let ((e-27 (vector-ref arg-1 3))) (let ((e-28 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-8 e-25))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-9 e-26))) (cond ((equal? sc3 1) (let ((sc4 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-10 e-27))) (cond ((equal? sc4 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-11 e-28)) (else 0)))) (else 0)))) (else 0))))))))(else 0))))))) ((5) (let ((e-12 (vector-ref arg-0 1))) (let ((e-13 (vector-ref arg-0 2))) (let ((e-14 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((5) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (let ((e-31 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-12 e-29))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-13 e-30))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-3310 e-14 e-31)) (else 0)))) (else 0)))))))(else 0)))))) ((6) (let ((e-15 (vector-ref arg-0 1))) (let ((e-16 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-32 (vector-ref arg-1 1))) (let ((e-33 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-15 e-32))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-16 e-33)) (else 0))))))(else 0)))))(else 0))))
(define PreludeC-45Types-u--C-47C-61_Eq_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2875 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-23) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45Types-u--C-47C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-23) arg-722 arg-725)))))
(define csegen-3292 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3289 (force csegen-23) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3289 (force csegen-23) arg-722 arg-725)))))
(define IdrisC-45Error-u--C-61C-61_Eq_Error (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-221 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_Error e-0 e-221)))(else 0)))) ((1) (let ((e-2 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((1) (let ((e-223 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-2 e-223)))(else 0)))) ((2) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-229 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-8 e-229)))(else 0)))) ((3) (let ((e-14 (vector-ref arg-0 2))) (let ((e-15 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((3) (let ((e-235 (vector-ref arg-1 2))) (let ((e-236 (vector-ref arg-1 3))) (let ((e-238 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-14 e-235))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45FC-u--C-61C-61_Eq_FC e-15 e-236))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-17 e-238)) (else 0)))) (else 0)))))))(else 0)))))) ((4) (let ((e-20 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((4) (let ((e-241 (vector-ref arg-1 2))) (let ((e-243 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-20 e-241))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-22 e-243)) (else 0))))))(else 0))))) ((5) (let ((e-25 (vector-ref arg-0 2))) (let ((e-30 (vector-ref arg-0 7))) (case (vector-ref arg-1 0) ((5) (let ((e-246 (vector-ref arg-1 2))) (let ((e-251 (vector-ref arg-1 7))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-25 e-246))) (cond ((equal? sc2 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-30 e-251)) (else 0))))))(else 0))))) ((6) (let ((e-32 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-253 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-32 e-253)))(else 0)))) ((7) (let ((e-35 (vector-ref arg-0 1))) (let ((e-36 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-256 (vector-ref arg-1 1))) (let ((e-257 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-35 e-256))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-36 e-257)) (else 0))))))(else 0))))) ((8) (let ((e-37 (vector-ref arg-0 1))) (let ((e-38 (vector-ref arg-0 2))) (let ((e-39 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((8) (let ((e-258 (vector-ref arg-1 1))) (let ((e-259 (vector-ref arg-1 2))) (let ((e-260 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-37 e-258))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-38 e-259))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-1903) e-39 e-260)) (else 0)))) (else 0)))))))(else 0)))))) ((9) (let ((e-40 (vector-ref arg-0 1))) (let ((e-41 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((9) (let ((e-261 (vector-ref arg-1 1))) (let ((e-262 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-40 e-261))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-41 e-262)) (else 0))))))(else 0))))) ((10) (let ((e-42 (vector-ref arg-0 1))) (let ((e-43 (vector-ref arg-0 2))) (let ((e-44 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((10) (let ((e-263 (vector-ref arg-1 1))) (let ((e-264 (vector-ref arg-1 2))) (let ((e-265 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-42 e-263))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-43 e-264))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-44 e-265)) (else 0)))) (else 0)))))))(else 0)))))) ((11) (let ((e-45 (vector-ref arg-0 1))) (let ((e-46 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((11) (let ((e-266 (vector-ref arg-1 1))) (let ((e-267 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-45 e-266))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-46 e-267)) (else 0))))))(else 0))))) ((12) (let ((e-48 (vector-ref arg-0 1))) (let ((e-49 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((12) (let ((e-269 (vector-ref arg-1 1))) (let ((e-270 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-48 e-269))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-49 e-270)) (else 0))))))(else 0))))) ((13) (let ((e-51 (vector-ref arg-0 1))) (let ((e-52 (vector-ref arg-0 2))) (let ((e-53 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((13) (let ((e-272 (vector-ref arg-1 1))) (let ((e-273 (vector-ref arg-1 2))) (let ((e-274 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-51 e-272))) (cond ((equal? sc2 1) (let ((sc3 (or (and (= e-52 e-273) 1) 0))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-53 e-274)) (else 0)))) (else 0)))))))(else 0)))))) ((14) (let ((e-54 (vector-ref arg-0 1))) (let ((e-55 (vector-ref arg-0 2))) (let ((e-56 (vector-ref arg-0 3))) (let ((e-57 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((14) (let ((e-275 (vector-ref arg-1 1))) (let ((e-276 (vector-ref arg-1 2))) (let ((e-277 (vector-ref arg-1 3))) (let ((e-278 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-54 e-275))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-55 e-276))) (cond ((equal? sc3 1) (let ((sc4 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-56 e-277))) (cond ((equal? sc4 1) (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-57 e-278)) (else 0)))) (else 0)))) (else 0))))))))(else 0))))))) ((15) (let ((e-59 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((15) (let ((e-280 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-59 e-280)))(else 0)))) ((16) (let ((e-64 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((16) (let ((e-285 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-64 e-285)))(else 0)))) ((17) (let ((e-67 (vector-ref arg-0 1))) (let ((e-68 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((17) (let ((e-288 (vector-ref arg-1 1))) (let ((e-289 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-67 e-288))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-298) e-68 e-289)) (else 0))))))(else 0))))) ((18) (let ((e-70 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((18) (let ((e-291 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-70 e-291)))(else 0)))) ((19) (let ((e-74 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((19) (let ((e-295 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-74 e-295)))(else 0)))) ((20) (let ((e-78 (vector-ref arg-0 1))) (let ((e-79 (vector-ref arg-0 2))) (let ((e-80 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((20) (let ((e-299 (vector-ref arg-1 1))) (let ((e-300 (vector-ref arg-1 2))) (let ((e-301 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-78 e-299))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-79 e-300))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-298) e-80 e-301)) (else 0)))) (else 0)))))))(else 0)))))) ((21) (let ((e-81 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((21) (let ((e-302 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-886 (csegen-2457) arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-886 (csegen-2457) arg-722 arg-725)))) e-81 e-302)))(else 0)))) ((22) (let ((e-83 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((22) (let ((e-304 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-83 e-304)))(else 0)))) ((23) (let ((e-85 (vector-ref arg-0 1))) (let ((e-86 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((23) (let ((e-306 (vector-ref arg-1 1))) (let ((e-307 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-85 e-306))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-2875 e-86 e-307)) (else 0))))))(else 0))))) ((24) (let ((e-87 (vector-ref arg-0 1))) (let ((e-88 (vector-ref arg-0 2))) (let ((e-89 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((24) (let ((e-308 (vector-ref arg-1 1))) (let ((e-309 (vector-ref arg-1 2))) (let ((e-310 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-87 e-308))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-88 e-309))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (force csegen-298) e-89 e-310)) (else 0)))) (else 0)))))))(else 0)))))) ((25) (let ((e-90 (vector-ref arg-0 1))) (let ((e-91 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((25) (let ((e-311 (vector-ref arg-1 1))) (let ((e-312 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-90 e-311))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-91 e-312)) (else 0))))))(else 0))))) ((26) (let ((e-92 (vector-ref arg-0 1))) (let ((e-93 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((26) (let ((e-313 (vector-ref arg-1 1))) (let ((e-314 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-92 e-313))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-23) e-93 e-314)) (else 0))))))(else 0))))) ((27) (let ((e-95 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((27) (let ((e-316 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-95 e-316)))(else 0)))) ((28) (let ((e-100 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((28) (let ((e-321 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-100 e-321)))(else 0)))) ((29) (let ((e-104 (vector-ref arg-0 2))) (let ((e-106 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((29) (let ((e-325 (vector-ref arg-1 2))) (let ((e-327 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-104 e-325))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-106 e-327)) (else 0))))))(else 0))))) ((30) (let ((e-109 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((30) (let ((e-330 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-109 e-330)))(else 0)))) ((31) (let ((e-115 (vector-ref arg-0 2))) (let ((e-116 (vector-ref arg-0 3))) (let ((e-117 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((31) (let ((e-336 (vector-ref arg-1 2))) (let ((e-337 (vector-ref arg-1 3))) (let ((e-338 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-115 e-336))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-116 e-337))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-117 e-338)) (else 0)))) (else 0)))))))(else 0)))))) ((32) (let ((e-120 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((32) (let ((e-341 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-3310 e-120 e-341)))(else 0)))) ((33) (let ((e-122 (vector-ref arg-0 2))) (let ((e-124 (vector-ref arg-0 4))) (let ((e-125 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((33) (let ((e-343 (vector-ref arg-1 2))) (let ((e-345 (vector-ref arg-1 4))) (let ((e-346 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-122 e-343))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-124 e-345))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-125 e-346)) (else 0)))) (else 0)))))))(else 0)))))) ((34) (let ((e-128 (vector-ref arg-0 2))) (let ((e-130 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((34) (let ((e-349 (vector-ref arg-1 2))) (let ((e-351 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-128 e-349))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-130 e-351)) (else 0))))))(else 0))))) ((35) (let ((e-132 (vector-ref arg-0 1))) (let ((e-133 (vector-ref arg-0 2))) (let ((e-134 (vector-ref arg-0 3))) (let ((e-135 (vector-ref arg-0 4))) (let ((e-136 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((35) (let ((e-353 (vector-ref arg-1 1))) (let ((e-354 (vector-ref arg-1 2))) (let ((e-355 (vector-ref arg-1 3))) (let ((e-356 (vector-ref arg-1 4))) (let ((e-357 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-132 e-353))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-133 e-354))) (cond ((equal? sc3 1) (let ((sc4 (CoreC-45Name-u--C-61C-61_Eq_Name e-134 e-355))) (cond ((equal? sc4 1) (let ((sc5 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-135 e-356))) (cond ((equal? sc5 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-136 e-357)) (else 0)))) (else 0)))) (else 0)))) (else 0)))))))))(else 0)))))))) ((36) (let ((e-137 (vector-ref arg-0 1))) (let ((e-138 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((36) (let ((e-358 (vector-ref arg-1 1))) (let ((e-359 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-137 e-358))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-138 e-359)) (else 0))))))(else 0))))) ((37) (let ((e-139 (vector-ref arg-0 1))) (let ((e-140 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((37) (let ((e-360 (vector-ref arg-1 1))) (let ((e-361 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-139 e-360))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-140 e-361)) (else 0))))))(else 0))))) ((38) (let ((e-141 (vector-ref arg-0 1))) (let ((e-142 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((38) (let ((e-362 (vector-ref arg-1 1))) (let ((e-363 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-141 e-362))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-142 e-363)) (else 0))))))(else 0))))) ((39) (let ((e-143 (vector-ref arg-0 1))) (let ((e-144 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((39) (let ((e-364 (vector-ref arg-1 1))) (let ((e-365 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-143 e-364))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-144 e-365)) (else 0))))))(else 0))))) ((40) (let ((e-146 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((40) (let ((e-367 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-146 e-367)))(else 0)))) ((41) (let ((e-150 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((41) (let ((e-371 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-150 e-371)))(else 0)))) ((42) (let ((e-155 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((42) (let ((e-376 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-155 e-376)))(else 0)))) ((43) (let ((e-158 (vector-ref arg-0 1))) (let ((e-159 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((43) (let ((e-379 (vector-ref arg-1 1))) (let ((e-380 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-158 e-379))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-159 e-380)) (else 0))))))(else 0))))) ((44) (let ((e-162 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((44) (let ((e-383 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-162 e-383)))(else 0)))) ((45) (let ((e-166 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((45) (let ((e-387 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-166 e-387)))(else 0)))) ((46) (let ((e-171 (vector-ref arg-0 1))) (let ((e-172 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((46) (let ((e-392 (vector-ref arg-1 1))) (let ((e-393 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-171 e-392))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-172 e-393)) (else 0))))))(else 0))))) ((47) (let ((e-174 (vector-ref arg-0 2))) (let ((e-177 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((47) (let ((e-395 (vector-ref arg-1 2))) (let ((e-398 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-174 e-395))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-177 e-398)) (else 0))))))(else 0))))) ((48) (let ((e-178 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((48) (let ((e-399 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_Error e-178 e-399)))(else 0)))) ((49) (let ((e-179 (vector-ref arg-0 1))) (let ((e-180 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((49) (let ((e-400 (vector-ref arg-1 1))) (let ((e-401 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-179 e-400))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-180 e-401)) (else 0))))))(else 0))))) ((50) (let ((e-181 (vector-ref arg-0 1))) (let ((e-182 (vector-ref arg-0 2))) (let ((e-183 (vector-ref arg-0 3))) (let ((e-184 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((50) (let ((e-402 (vector-ref arg-1 1))) (let ((e-403 (vector-ref arg-1 2))) (let ((e-404 (vector-ref arg-1 3))) (let ((e-405 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-181 e-402))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-182 e-403))) (cond ((equal? sc3 1) (let ((sc4 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-183 e-404))) (cond ((equal? sc4 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-23) e-184 e-405)) (else 0)))) (else 0)))) (else 0))))))))(else 0))))))) ((52) (let ((e-185 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((52) (let ((e-406 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_TTCErrorMsg e-185 e-406)))(else 0)))) ((53) (let ((e-186 (vector-ref arg-0 1))) (let ((e-187 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((53) (let ((e-407 (vector-ref arg-1 1))) (let ((e-408 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-186 e-407))) (cond ((equal? sc2 1) (IdrisC-45Error-u--C-61C-61_Eq_FileError e-187 e-408)) (else 0))))))(else 0))))) ((54) (let ((e-188 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((54) (let ((e-409 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-188 e-409)))(else 0)))) ((57) (let ((e-189 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((57) (let ((e-410 (vector-ref arg-1 1))) (CoreC-45FC-u--C-61C-61_Eq_FC e-189 e-410)))(else 0)))) ((58) (let ((e-190 (vector-ref arg-0 1))) (let ((e-191 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((58) (let ((e-411 (vector-ref arg-1 1))) (let ((e-412 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-190 e-411))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-191 e-412)) (else 0))))))(else 0))))) ((59) (let ((e-192 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((59) (let ((e-413 (vector-ref arg-1 1))) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 csegen-3292 e-192 e-413)))(else 0)))) ((60) (let ((e-193 (vector-ref arg-0 1))) (let ((e-194 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((60) (let ((e-414 (vector-ref arg-1 1))) (let ((e-415 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-193 e-414))) (cond ((equal? sc2 1) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent e-194 e-415)) (else 0))))))(else 0))))) ((61) (let ((e-195 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((61) (let ((e-416 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-303 e-195 e-416)))(else 0)))) ((62) (case (vector-ref arg-1 0) ((62) 1)(else 0))) ((63) (let ((e-196 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((63) (let ((e-417 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-196 e-417)))(else 0)))) ((64) (let ((e-197 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((64) (let ((e-418 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-197 e-418)))(else 0)))) ((65) (let ((e-198 (vector-ref arg-0 1))) (let ((e-199 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((65) (let ((e-419 (vector-ref arg-1 1))) (let ((e-420 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-198 e-419))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (force csegen-23) e-199 e-420)) (else 0))))))(else 0))))) ((66) (let ((e-200 (vector-ref arg-0 1))) (let ((e-201 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((66) (let ((e-421 (vector-ref arg-1 1))) (let ((e-422 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-200 e-421))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-201 e-422)) (else 0))))))(else 0))))) ((67) (let ((e-202 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((67) (let ((e-423 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-202 e-423)))(else 0)))) ((68) (let ((e-203 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((68) (let ((e-424 (vector-ref arg-1 1))) (CoreC-45FC-u--C-61C-61_Eq_FC e-203 e-424)))(else 0)))) ((69) (let ((e-204 (vector-ref arg-0 1))) (let ((e-205 (vector-ref arg-0 2))) (let ((e-206 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((69) (let ((e-425 (vector-ref arg-1 1))) (let ((e-426 (vector-ref arg-1 2))) (let ((e-427 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-204 e-425))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-205 e-426))) (cond ((equal? sc3 1) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (csegen-2457) e-206 e-427)) (else 0)))) (else 0)))))))(else 0)))))) ((70) (let ((e-207 (vector-ref arg-0 1))) (let ((e-208 (vector-ref arg-0 2))) (let ((e-209 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((70) (let ((e-428 (vector-ref arg-1 1))) (let ((e-429 (vector-ref arg-1 2))) (let ((e-430 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-207 e-428))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-208 e-429))) (cond ((equal? sc3 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-209 e-430)) (else 0)))) (else 0)))))))(else 0)))))) ((71) (let ((e-210 (vector-ref arg-0 1))) (let ((e-211 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((71) (let ((e-431 (vector-ref arg-1 1))) (let ((e-432 (vector-ref arg-1 2))) (let ((sc2 (LibrariesC-45DataC-45WithData-u--C-61C-61_Eq_C-40C-40WithDataC-32C-36fsC-41C-32C-36aC-41 (cons csegen-3289 '()) (force csegen-298) e-210 e-431))) (cond ((equal? sc2 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-211 e-432)) (else 0))))))(else 0))))) ((72) (let ((e-212 (vector-ref arg-0 1))) (let ((e-213 (vector-ref arg-0 2))) (let ((e-214 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((72) (let ((e-433 (vector-ref arg-1 1))) (let ((e-434 (vector-ref arg-1 2))) (let ((e-435 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-212 e-433))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-213 e-434))) (cond ((equal? sc3 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-214 e-435)) (else 0)))) (else 0)))))))(else 0)))))) ((73) (let ((e-215 (vector-ref arg-0 1))) (let ((e-216 (vector-ref arg-0 2))) (let ((e-217 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((73) (let ((e-436 (vector-ref arg-1 1))) (let ((e-437 (vector-ref arg-1 2))) (let ((e-438 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-215 e-436))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-216 e-437))) (cond ((equal? sc3 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-217 e-438)) (else 0)))) (else 0)))))))(else 0)))))) ((74) (let ((e-218 (vector-ref arg-0 1))) (let ((e-219 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((74) (let ((e-439 (vector-ref arg-1 1))) (let ((e-440 (vector-ref arg-1 2))) (let ((sc2 (IdrisC-45Error-u--C-61C-61_Eq_Error e-218 e-439))) (cond ((equal? sc2 1) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (force csegen-23) e-219 e-440)) (else 0))))))(else 0))))) ((75) (let ((e-220 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((75) (let ((e-441 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_Warning e-220 e-441)))(else 0))))(else 0))))
(define IdrisC-45Error-u--C-47C-61_Eq_Error (lambda (arg-0 arg-1) (let ((sc0 (IdrisC-45Error-u--C-61C-61_Eq_Error arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2457 (lambda () (cons (lambda (arg-712) (lambda (arg-715) (IdrisC-45Error-u--C-61C-61_Eq_Error arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (IdrisC-45Error-u--C-47C-61_Eq_Error arg-722 arg-725))))))
(define csegen-2461 (lambda (eta-0) (let ((e-13 (vector-ref eta-0 13))) e-13)))
(define csegen-2462 (PreludeC-45Types-elem (force csegen-14) csegen-1382 (vector 10 )))
(define CoreC-45TerminationC-45SizeChange-u--C-61C-61_Eq_Graph (lambda (arg-0 arg-1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-1106 (let ((e-0 (car arg-0))) e-0) (let ((e-0 (car arg-1))) e-0))))
(define CoreC-45TerminationC-45SizeChange-u--C-47C-61_Eq_Graph (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TerminationC-45SizeChange-u--C-61C-61_Eq_Graph arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2466 (cons (lambda (arg-712) (lambda (arg-715) (CoreC-45TerminationC-45SizeChange-u--C-61C-61_Eq_Graph arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (CoreC-45TerminationC-45SizeChange-u--C-47C-61_Eq_Graph arg-722 arg-725)))))
(define DataC-45List1-u--C-60C-61_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 arg-1 arg-2 arg-3) 2)))
(define DataC-45List1-u--C-60_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 arg-1 arg-2 arg-3) 0)))
(define DataC-45List1-u--C-62C-61_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 arg-1 arg-2 arg-3) 0)))
(define DataC-45List1-u--C-62_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 arg-1 arg-2 arg-3) 2)))
(define DataC-45List1-u--max_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (DataC-45List1-u--C-62_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) arg-2) (else arg-3)))))
(define DataC-45List1-u--min_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (DataC-45List1-u--C-60_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) arg-2) (else arg-3)))))
(define AlgebraC-45SizeChange-u--compare_Ord_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else (cond ((equal? arg-1 2) 2)(else (cond ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0)))(else (cond ((equal? arg-1 1) 2)(else (cond (else (cond (else 1))))))))))))))
(define AlgebraC-45SizeChange-u--C-60C-61_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 2)))
(define AlgebraC-45SizeChange-u--C-60_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 0)))
(define AlgebraC-45SizeChange-u--C-62C-61_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 0)))
(define AlgebraC-45SizeChange-u--C-62_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 2)))
(define AlgebraC-45SizeChange-u--max_Ord_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 2) arg-1) ((equal? arg-0 1) (cond ((equal? arg-1 2) 1)(else arg-1))) (else 0))))
(define AlgebraC-45SizeChange-u--min_Ord_SizeChange (lambda (arg-0 arg-1) (let ((sc0 (AlgebraC-45SizeChange-u--C-60_Ord_SizeChange arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-2482 (vector csegen-1097 (lambda (arg-1598) (lambda (arg-1601) (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (AlgebraC-45SizeChange-u--C-60_Ord_SizeChange arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (AlgebraC-45SizeChange-u--C-62_Ord_SizeChange arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (AlgebraC-45SizeChange-u--C-60C-61_Ord_SizeChange arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (AlgebraC-45SizeChange-u--C-62C-61_Ord_SizeChange arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (AlgebraC-45SizeChange-u--max_Ord_SizeChange arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (AlgebraC-45SizeChange-u--min_Ord_SizeChange arg-1658 arg-1661)))))
(define csegen-2490 (vector csegen-1100 (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2482 arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2482 arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2482 arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2482 arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2482 arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2482 arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2482 arg-1658 arg-1661)))))
(define csegen-2498 (vector csegen-1103 (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 csegen-2490 arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (DataC-45List1-u--C-60_Ord_C-40List1C-32C-36aC-41 csegen-2490 arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (DataC-45List1-u--C-62_Ord_C-40List1C-32C-36aC-41 csegen-2490 arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (DataC-45List1-u--C-60C-61_Ord_C-40List1C-32C-36aC-41 csegen-2490 arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (DataC-45List1-u--C-62C-61_Ord_C-40List1C-32C-36aC-41 csegen-2490 arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (DataC-45List1-u--max_Ord_C-40List1C-32C-36aC-41 csegen-2490 arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (DataC-45List1-u--min_Ord_C-40List1C-32C-36aC-41 csegen-2490 arg-1658 arg-1661)))))
(define CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (vector csegen-1106 (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2498 arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2498 arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2498 arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2498 arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2498 arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2498 arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1724 csegen-2498 arg-1658 arg-1661)))) (let ((e-0 (car arg-0))) e-0) (let ((e-0 (car arg-1))) e-0))))
(define CoreC-45TerminationC-45SizeChange-u--C-60C-61_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 2)))
(define CoreC-45TerminationC-45SizeChange-u--C-60_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 0)))
(define CoreC-45TerminationC-45SizeChange-u--C-62C-61_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 0)))
(define CoreC-45TerminationC-45SizeChange-u--C-62_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 2)))
(define CoreC-45TerminationC-45SizeChange-u--max_Ord_Graph (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TerminationC-45SizeChange-u--C-62_Ord_Graph arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define CoreC-45TerminationC-45SizeChange-u--min_Ord_Graph (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TerminationC-45SizeChange-u--C-60_Ord_Graph arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-2474 (vector csegen-2466 (lambda (arg-1598) (lambda (arg-1601) (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (CoreC-45TerminationC-45SizeChange-u--C-60_Ord_Graph arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (CoreC-45TerminationC-45SizeChange-u--C-62_Ord_Graph arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (CoreC-45TerminationC-45SizeChange-u--C-60C-61_Ord_Graph arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (CoreC-45TerminationC-45SizeChange-u--C-62C-61_Ord_Graph arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (CoreC-45TerminationC-45SizeChange-u--max_Ord_Graph arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (CoreC-45TerminationC-45SizeChange-u--min_Ord_Graph arg-1658 arg-1661)))))
(define csegen-2509 (cons (lambda (arg-712) (lambda (arg-715) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-298) csegen-2466 arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-298) csegen-2466 arg-722 arg-725)))))
(define csegen-2520 (vector csegen-2509 (lambda (arg-1598) (lambda (arg-1601) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-902) csegen-2474 arg-1598 arg-1601))) (lambda (arg-1608) (lambda (arg-1611) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-902) csegen-2474 arg-1608 arg-1611))) (lambda (arg-1618) (lambda (arg-1621) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-902) csegen-2474 arg-1618 arg-1621))) (lambda (arg-1628) (lambda (arg-1631) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-902) csegen-2474 arg-1628 arg-1631))) (lambda (arg-1638) (lambda (arg-1641) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-902) csegen-2474 arg-1638 arg-1641))) (lambda (arg-1648) (lambda (arg-1651) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-902) csegen-2474 arg-1648 arg-1651))) (lambda (arg-1658) (lambda (arg-1661) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (force csegen-902) csegen-2474 arg-1658 arg-1661)))))
(define AlgebraC-45SizeChange-u--plusNeutral_Semiring_SizeChange 2)
(define AlgebraC-45SizeChange-u--neutral_Monoid_SizeChange 1)
(define AlgebraC-45SizeChange-u--timesNeutral_Semiring_SizeChange AlgebraC-45SizeChange-u--neutral_Monoid_SizeChange)
(define AlgebraC-45SizeChange-u--C-60C-43C-62_Semigroup_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 2) 2) ((equal? arg-0 1) arg-1)(else (cond ((equal? arg-1 2) 2)(else (cond (else 0))))))))
(define AlgebraC-45SizeChange-u--C-124C-42C-124_Semiring_SizeChange (lambda (ext-0 ext-1) (AlgebraC-45SizeChange-u--C-60C-43C-62_Semigroup_SizeChange ext-0 ext-1)))
(define AlgebraC-45SizeChange-u--C-124C-43C-124_Semiring_SizeChange (lambda (ext-0 ext-1) (AlgebraC-45SizeChange-u--max_Ord_SizeChange ext-0 ext-1)))
(define csegen-2537 (cons csegen-1097 (vector (lambda (arg-818) (lambda (arg-821) (AlgebraC-45SizeChange-u--C-124C-43C-124_Semiring_SizeChange arg-818 arg-821))) AlgebraC-45SizeChange-u--plusNeutral_Semiring_SizeChange (lambda (arg-830) (lambda (arg-833) (AlgebraC-45SizeChange-u--C-124C-42C-124_Semiring_SizeChange arg-830 arg-833))) AlgebraC-45SizeChange-u--timesNeutral_Semiring_SizeChange)))
(define CoreC-45Context-u--full_HasNames_Terminating (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45Context-u--full_HasNames_PartialReason arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (vector 2 e-5))))))))(else (vector 1 arg-1)))))
(define csegen-2540 (cons (lambda (arg-7776) (lambda (arg-7779) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Terminating arg-7776 arg-7779 eta-0)))) (lambda (arg-7786) (lambda (arg-7789) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Terminating arg-7786 arg-7789 eta-0))))))
(define CoreC-45NameC-45Namespace-builtinNS (CoreC-45NameC-45Namespace-mkNamespace "Builtin"))
(define csegen-2541 (vector 0 CoreC-45NameC-45Namespace-builtinNS (vector 1 (vector 0 "assert_total"))))
(define CoreC-45TerminationC-45CallGraph-sizeEq (lambda (arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-52 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((0) (let ((e-81 (vector-ref arg-4 3))) (or (and (= e-52 e-81) 1) 0)))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))))))) ((1) (let ((e-57 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((1) (let ((e-86 (vector-ref arg-4 3))) (CoreC-45Name-u--C-61C-61_Eq_Name e-57 e-86)))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))))))) ((2) (let ((e-61 (vector-ref arg-3 3))) (let ((e-62 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((2) (let ((e-90 (vector-ref arg-4 3))) (let ((e-91 (vector-ref arg-4 4))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-61 e-90))) (cond ((equal? sc2 1) (PreludeC-45Types-u--foldMap_Foldable_List csegen-805 (lambda (eta-0) (PreludeC-45Basics-uncurry (csegen-2544) eta-0)) (DataC-45List-u--zip_Zippable_List e-62 e-91))) (else 0))))))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))) ((3) (let ((e-66 (vector-ref arg-3 3))) (let ((e-67 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((3) (let ((e-95 (vector-ref arg-4 3))) (let ((e-96 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TTC-45Binder-eqBinderBy (csegen-2544) e-66 e-95))) (cond ((equal? sc2 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-67 e-96)) (else 0))))))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))) ((4) (let ((e-70 (vector-ref arg-3 2))) (let ((e-71 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((4) (let ((e-99 (vector-ref arg-4 2))) (let ((e-100 (vector-ref arg-4 3))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq e-70 e-99))) (cond ((equal? sc2 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-71 e-100)) (else 0))))))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))) ((5) (let ((e-76 (vector-ref arg-3 4))) (CoreC-45TerminationC-45CallGraph-sizeEq e-76 arg-4)))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc1 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc1 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc2 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))
(define csegen-2544 (lambda () (lambda (eta-0) (lambda (eta-1) (CoreC-45TerminationC-45CallGraph-sizeEq eta-0 eta-1)))))
(define csegen-2551 (let ((sc0 CoreC-45TTC-45Term-WeakenTerm)) (let ((e-1 (car sc0))) ((e-1 'erased) 'erased))))
(define csegen-2552 (vector 0 (force csegen-31)))
(define TTImpC-45ElabC-45Check-u--C-61C-61_Eq_ElabOpt (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0)))(else 0))))
(define TTImpC-45ElabC-45Check-u--C-47C-61_Eq_ElabOpt (lambda (arg-0 arg-1) (let ((sc0 (TTImpC-45ElabC-45Check-u--C-61C-61_Eq_ElabOpt arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2555 (cons (lambda (arg-712) (lambda (arg-715) (TTImpC-45ElabC-45Check-u--C-61C-61_Eq_ElabOpt arg-712 arg-715))) (lambda (arg-722) (lambda (arg-725) (TTImpC-45ElabC-45Check-u--C-47C-61_Eq_ElabOpt arg-722 arg-725)))))
(define csegen-2556 (PreludeC-45Types-elem (force csegen-14) csegen-2555 1))
(define AlgebraC-45ZeroOneOmega-u--C-60C-61_Preorder_ZeroOneOmega (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) 1) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else (cond ((equal? arg-1 2) 1)(else 0)))))(else (cond ((equal? arg-1 2) 1)(else 0))))))
(define AlgebraC-45ZeroOneOmega-u--preorderRefl_Preorder_ZeroOneOmega (lambda (arg-0) (cond ((equal? arg-0 0) 'erased) ((equal? arg-0 1) 'erased) (else 'erased))))
(define AlgebraC-45ZeroOneOmega-u--preorderTrans_Preorder_ZeroOneOmega (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (cond ((equal? arg-0 0) 'erased) ((equal? arg-0 1) (cond ((equal? arg-1 1) arg-4) (else (cond ((equal? arg-2 1) 'erased) (else 'erased))))) (else (cond (else arg-4))))))
(define csegen-2562 (vector (lambda (arg-818) (lambda (arg-821) (AlgebraC-45ZeroOneOmega-u--C-60C-61_Preorder_ZeroOneOmega arg-818 arg-821))) (lambda (u--x) (AlgebraC-45ZeroOneOmega-u--preorderRefl_Preorder_ZeroOneOmega u--x)) (lambda (u--x) (lambda (u--y) (lambda (u--z) (lambda (arg-842) (lambda (arg-848) (AlgebraC-45ZeroOneOmega-u--preorderTrans_Preorder_ZeroOneOmega u--x u--y u--z arg-842 arg-848))))))))
(define CoreC-45Reflect-builtin (lambda (arg-0) (vector 0 CoreC-45NameC-45Namespace-builtinNS (vector 1 (vector 0 arg-0)))))
(define CoreC-45Context-lookupExactBy (lambda (arg-1 arg-2 arg-3 ext-0) (let ((act-1 ((CoreC-45Context-lookupCtxtExact arg-2 arg-3) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (if (null? e-5) (vector 1 '()) (let ((e-1 (unbox e-5))) (vector 1 (box (arg-1 e-1)))))))))))
(define CoreC-45Context-lookupDefExact (lambda (ext-2 ext-1 ext-0) (CoreC-45Context-lookupExactBy csegen-1378 ext-2 ext-1 ext-0)))
(define CoreC-45Reflect-getCon (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (let ((act-1 (CoreC-45Context-lookupDefExact arg-3 (let ((e-0 (vector-ref arg-2 0))) e-0) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (if (null? e-5) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 7 arg-1 arg-3) ext-0) (let ((e-1 (unbox e-5))) (case (vector-ref e-1 0) ((5) (let ((e-2 (vector-ref e-1 1))) (let ((e-3 (vector-ref e-1 2))) ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (let ((e-0 (vector-ref arg-2 0))) e-0) (vector 1 arg-1 (vector 2 e-2 e-3) arg-3)) ext-0)))) ((6) (let ((e-12 (vector-ref e-1 1))) ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (let ((e-0 (vector-ref arg-2 0))) e-0) (vector 1 arg-1 (vector 3 e-12) arg-3)) ext-0)))(else ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (let ((e-0 (vector-ref arg-2 0))) e-0) (vector 1 arg-1 (vector 1 ) arg-3)) ext-0)))))))))))
(define CoreC-45Reflect-u--reflect_Reflect_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-builtin "MkUnit") ext-0)))
(define csegen-2566 (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (CoreC-45Reflect-u--reflect_Reflect_C-40C-124UnitC-44MkUnitC-124C-41 eta-0 eta-1 eta-2 eta-3 eta-4 eta-5 eta-6)))))))))
(define CoreC-45Value-getLoc (lambda (arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-1 (vector-ref arg-1 1))) e-1)) ((1) (let ((e-6 (vector-ref arg-1 1))) e-6)) ((2) (let ((e-10 (vector-ref arg-1 1))) e-10)) ((3) (let ((e-16 (vector-ref arg-1 1))) e-16)) ((4) (let ((e-21 (vector-ref arg-1 1))) e-21)) ((5) (let ((e-26 (vector-ref arg-1 1))) e-26)) ((6) (let ((e-30 (vector-ref arg-1 1))) e-30)) ((7) (let ((e-35 (vector-ref arg-1 1))) e-35)) ((8) (let ((e-40 (vector-ref arg-1 1))) e-40)) ((9) (let ((e-43 (vector-ref arg-1 1))) e-43)) (else (let ((e-46 (vector-ref arg-1 1))) e-46)))))
(define CoreC-45Context-toFullNames (lambda (arg-1 arg-2 arg-3 ext-0) (let ((act-1 (let ((act-1 (unbox arg-1))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((e-1 (car arg-2))) (((e-1 (let ((e-0 (vector-ref e-5 0))) e-0)) arg-3) ext-0))))))))
(define CoreC-45Context-getSession (lambda (arg-0 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (let ((e-4 (vector-ref e-5 4))) (let ((e-41 (vector-ref e-4 2))) e-41)))))))))
(define DataC-45These-fromThis (lambda (arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 1))) (box e-2))) ((1) '()) (else (let ((e-8 (vector-ref arg-2 1))) (box e-8))))))
(define CoreC-45OptionsC-45Log-n--6878-7457-u--here (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (let ((sc0 (DataC-45These-fromThis arg-3))) (if (null? sc0) 0 (let ((e-2 (unbox sc0))) (PreludeC-45Types-u--C-60C-61_Ord_Nat arg-0 e-2))))))
(define DataC-45These-fromThat (lambda (arg-2) (case (vector-ref arg-2 0) ((0) '()) ((1) (let ((e-5 (vector-ref arg-2 1))) (box e-5))) (else (let ((e-9 (vector-ref arg-2 2))) (box e-9))))))
(define LibrariesC-45DataC-45StringMap-treeLookup (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_String arg-2 e-1))) (cond ((equal? sc1 1) (box e-2)) (else '())))))) ((1) (let ((e-5 (vector-ref arg-3 1))) (let ((e-6 (vector-ref arg-3 2))) (let ((e-7 (vector-ref arg-3 3))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_String arg-2 e-6))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringMap-treeLookup arg-2 e-5)) (else (LibrariesC-45DataC-45StringMap-treeLookup arg-2 e-7)))))))) (else (let ((e-10 (vector-ref arg-3 1))) (let ((e-11 (vector-ref arg-3 2))) (let ((e-12 (vector-ref arg-3 3))) (let ((e-13 (vector-ref arg-3 4))) (let ((e-14 (vector-ref arg-3 5))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_String arg-2 e-11))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringMap-treeLookup arg-2 e-10)) (else (let ((sc2 (PreludeC-45EqOrd-u--C-60C-61_Ord_String arg-2 e-13))) (cond ((equal? sc2 1) (LibrariesC-45DataC-45StringMap-treeLookup arg-2 e-12)) (else (LibrariesC-45DataC-45StringMap-treeLookup arg-2 e-14))))))))))))))))
(define LibrariesC-45DataC-45StringMap-lookup (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-3 (cdr arg-2))) (LibrariesC-45DataC-45StringMap-treeLookup arg-1 e-3)))))
(define CoreC-45OptionsC-45Log-n--6878-7458-u--there (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) 0 (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (DataC-45Maybe-fromMaybe (lambda () 0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (DataC-45These-fromThat arg-3) (lambda (u--assoc) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (LibrariesC-45DataC-45StringMap-lookup e-2 u--assoc) (lambda (u--next) (box (CoreC-45OptionsC-45Log-n--6860-7445-u--go arg-0 arg-1 arg-2 e-3 u--next))))))))))))
(define CoreC-45OptionsC-45Log-n--6860-7445-u--go (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (let ((sc0 (CoreC-45OptionsC-45Log-n--6878-7457-u--here arg-0 arg-1 arg-2 arg-4 arg-3))) (cond ((equal? sc0 1) 1) (else (CoreC-45OptionsC-45Log-n--6878-7458-u--there arg-0 arg-1 arg-2 arg-4 arg-3))))))
(define CoreC-45OptionsC-45Log-keepLog (lambda (arg-0 arg-1) (let ((e-0 (car arg-0))) (let ((e-1 (cdr arg-0))) (cond ((equal? e-1 0) 1)(else (CoreC-45OptionsC-45Log-n--6860-7445-u--go e-1 e-0 arg-1 e-0 arg-1)))))))
(define CoreC-45OptionsC-45Log-mkLogLevelC-39 (lambda (arg-0 arg-1) (cons (PreludeC-45Types-maybe (lambda () '()) (lambda () (lambda (eta-0) eta-0)) arg-0) arg-1)))
(define CoreC-45OptionsC-45Log-mkUnverifiedLogLevel (lambda (arg-0 ext-0) (cond ((equal? arg-0 "") (CoreC-45OptionsC-45Log-mkLogLevelC-39 '() ext-0))(else (CoreC-45OptionsC-45Log-mkLogLevelC-39 (box (DataC-45String-split csegen-545 arg-0)) ext-0)))))
(define CoreC-45ContextC-45Log-unverifiedLogging (lambda (arg-0 arg-1 arg-2 ext-0) (cond ((equal? arg-2 0) (vector 1 1))(else (let ((act-1 (CoreC-45Context-getSession arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (let ((sc1 (let ((e-8 (vector-ref e-5 8))) e-8))) (cond ((equal? sc1 1) (CoreC-45OptionsC-45Log-keepLog (CoreC-45OptionsC-45Log-mkUnverifiedLogLevel arg-1 arg-2) (let ((e-9 (vector-ref e-5 9))) e-9))) (else 0))))))))))))
(define CoreC-45TTC-45Term-applyStackWithFC (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((e-6 (car e-2))) (let ((e-7 (cdr e-2))) (CoreC-45TTC-45Term-applyStackWithFC (vector 4 e-6 arg-1 e-7) e-3))))))))
(define CoreC-45Context-clearDefs (lambda (arg-0 ext-0) (vector 1 (let ((e-0 (vector-ref arg-0 0))) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (let ((e-3 (vector-ref arg-0 3))) (let ((e-4 (vector-ref arg-0 4))) (let ((e-5 (vector-ref arg-0 5))) (let ((e-6 (vector-ref arg-0 6))) (let ((e-7 (vector-ref arg-0 7))) (let ((e-8 (vector-ref arg-0 8))) (let ((e-9 (vector-ref arg-0 9))) (let ((e-10 (vector-ref arg-0 10))) (let ((e-11 (vector-ref arg-0 11))) (let ((e-12 (vector-ref arg-0 12))) (let ((e-13 (vector-ref arg-0 13))) (let ((e-14 (vector-ref arg-0 14))) (let ((e-15 (vector-ref arg-0 15))) (let ((e-16 (vector-ref arg-0 16))) (let ((e-17 (vector-ref arg-0 17))) (let ((e-18 (vector-ref arg-0 18))) (let ((e-19 (vector-ref arg-0 19))) (let ((e-20 (vector-ref arg-0 20))) (let ((e-21 (vector-ref arg-0 21))) (let ((e-22 (vector-ref arg-0 22))) (let ((e-23 (vector-ref arg-0 23))) (let ((e-24 (vector-ref arg-0 24))) (let ((e-25 (vector-ref arg-0 25))) (let ((e-26 (vector-ref arg-0 26))) (let ((e-27 (vector-ref arg-0 27))) (let ((e-28 (vector-ref arg-0 28))) (let ((e-29 (vector-ref arg-0 29))) (let ((e-30 (vector-ref arg-0 30))) (let ((e-31 (vector-ref arg-0 31))) (let ((e-32 (vector-ref e-0 0))) (let ((e-33 (vector-ref e-0 1))) (let ((e-34 (vector-ref e-0 2))) (let ((e-35 (vector-ref e-0 3))) (let ((e-36 (vector-ref e-0 4))) (let ((e-37 (vector-ref e-0 5))) (let ((e-38 (vector-ref e-0 6))) (let ((e-39 (vector-ref e-0 7))) (let ((e-40 (vector-ref e-0 8))) (let ((e-42 (vector-ref e-0 10))) (let ((e-43 (vector-ref e-0 11))) (vector (vector e-32 e-33 e-34 e-35 e-36 e-37 e-38 e-39 e-40 1 e-42 e-43) e-1 e-2 e-3 e-4 e-5 e-6 e-7 e-8 e-9 e-10 e-11 e-12 e-13 e-14 e-15 e-16 e-17 e-18 e-19 e-20 e-21 e-22 e-23 e-24 e-25 e-26 e-27 e-28 e-29 e-30 e-31)))))))))))))))))))))))))))))))))))))))))))))))
(define CoreC-45Value-defaultOpts (vector 0 0 1 0 0 '() '() 1))
(define CoreC-45NormaliseC-45Eval-evalWithOpts (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 ext-0 ext-1 ext-2 ext-3) (CoreC-45NormaliseC-45Eval-eval arg-3 arg-4 arg-0 arg-1 arg-2 ext-0 ext-1 ext-2 ext-3)))
(define CoreC-45NormaliseC-45Eval-evalLocClosure (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7 arg-8) (case (vector-ref arg-8 0) ((0) (let ((e-1 (vector-ref arg-8 1))) (let ((e-2 (vector-ref arg-8 2))) (let ((e-3 (vector-ref arg-8 3))) (let ((e-4 (vector-ref arg-8 4))) (let ((e-5 (vector-ref arg-8 5))) (CoreC-45NormaliseC-45Eval-evalWithOpts arg-2 arg-3 e-1 arg-0 e-2 e-4 e-3 e-5 arg-7))))))) (else (let ((e-8 (vector-ref arg-8 2))) (let ((e-9 (vector-ref arg-8 3))) (CoreC-45NormaliseC-45Eval-applyToStack arg-0 arg-1 arg-2 arg-3 e-8 e-9 arg-7)))))))
(define LibrariesC-45DataC-45ListC-45SizeOf-mkSizeOf (lambda (arg-1) (PreludeC-45TypesC-45List-lengthTR arg-1)))
(define CoreC-45Env-getBinderUnder (lambda (arg-2 arg-3 arg-4 arg-5 arg-7) (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (cond ((equal? arg-4 0) (let ((e-7 (car arg-7))) (CoreC-45TTC-45Binder-u--map_Functor_Binder (let ((e-3 (cdr arg-2))) (((e-3 'erased) 'erased) (LibrariesC-45DataC-45ListC-45SizeOf-mkSizeOf (cons e-1 arg-5)))) e-7)))(else (let ((e-3 (- arg-4 1))) (let ((e-13 (cdr arg-7))) (CoreC-45Env-getBinderUnder arg-2 e-2 e-3 (cons e-1 arg-5) e-13)))))))))
(define CoreC-45Env-getBinder (lambda (arg-2 arg-3 arg-4 arg-6) (CoreC-45Env-getBinderUnder arg-2 arg-3 arg-4 '() arg-6)))
(define CoreC-45NormaliseC-45Eval-evalLocal (lambda (arg-0 arg-1 arg-4 arg-5 arg-6 arg-7 arg-8 arg-9 arg-11 arg-12) (if (null? arg-12) (let ((sc1 (let ((sc2 (let ((sc3 (let ((e-0 (vector-ref arg-1 0))) e-0))) (cond ((equal? sc3 1) 1) (else (let ((e-1 (vector-ref arg-1 1))) e-1)))))) (cond ((equal? sc2 1) 0) (else (DataC-45Maybe-fromMaybe (lambda () 1) arg-8)))))) (cond ((equal? sc1 1) (let ((sc2 (CoreC-45Env-getBinder CoreC-45TTC-45Term-WeakenTerm arg-5 arg-9 arg-6))) (case (vector-ref sc2 0) ((1) (let ((e-3 (vector-ref sc2 3))) (CoreC-45NormaliseC-45Eval-eval arg-0 arg-1 arg-4 arg-5 '() arg-6 '() e-3 arg-11)))(else (lambda (eta-0) (vector 1 (vector 1 arg-7 (vector 0 arg-8 arg-9) arg-11))))))) (else (lambda (eta-0) (vector 1 (vector 1 arg-7 (vector 0 arg-8 arg-9) arg-11)))))) (cond ((equal? arg-9 0) (let ((e-5 (car arg-12))) (CoreC-45NormaliseC-45Eval-evalLocClosure arg-0 arg-1 arg-4 arg-5 arg-6 arg-7 arg-8 arg-11 e-5)))(else (let ((e-0 (- arg-9 1))) (let ((e-12 (cdr arg-12))) (CoreC-45NormaliseC-45Eval-evalLocal arg-0 arg-1 arg-4 arg-5 arg-6 arg-7 arg-8 e-0 arg-11 e-12))))))))
(define SystemC-45Clock-isClockMandatory (lambda (arg-0) (cond ((equal? arg-0 5) 1) ((equal? arg-0 6) 1)(else 0))))
(define SystemC-45Clock-clockTimeGcCpu (lambda (ext-0) (SystemC-45Clock-prim__clockTimeGcCpu ext-0)))
(define SystemC-45Clock-clockTimeGcReal (lambda (ext-0) (SystemC-45Clock-prim__clockTimeGcReal ext-0)))
(define SystemC-45Clock-clockTimeMonotonic (lambda (ext-0) (SystemC-45Clock-prim__clockTimeMonotonic ext-0)))
(define SystemC-45Clock-clockTimeProcess (lambda (ext-0) (SystemC-45Clock-prim__clockTimeProcess ext-0)))
(define SystemC-45Clock-clockTimeThread (lambda (ext-0) (SystemC-45Clock-prim__clockTimeThread ext-0)))
(define SystemC-45Clock-clockTimeUtc (lambda (ext-0) (SystemC-45Clock-prim__clockTimeUtc ext-0)))
(define SystemC-45Clock-fetchOSClock (lambda (arg-0 ext-0) (cond ((equal? arg-0 0) (SystemC-45Clock-clockTimeUtc ext-0)) ((equal? arg-0 1) (SystemC-45Clock-clockTimeMonotonic ext-0)) ((equal? arg-0 3) (SystemC-45Clock-clockTimeProcess ext-0)) ((equal? arg-0 4) (SystemC-45Clock-clockTimeThread ext-0)) ((equal? arg-0 5) (SystemC-45Clock-clockTimeGcCpu ext-0)) ((equal? arg-0 6) (SystemC-45Clock-clockTimeGcReal ext-0)) (else (SystemC-45Clock-clockTimeMonotonic ext-0)))))
(define SystemC-45Clock-osClockNanosecond (lambda (arg-0 ext-0) (SystemC-45Clock-prim__osClockNanosecond arg-0 ext-0)))
(define SystemC-45Clock-osClockSecond (lambda (arg-0 ext-0) (SystemC-45Clock-prim__osClockSecond arg-0 ext-0)))
(define SystemC-45Clock-fromOSClock (lambda (arg-0 arg-1 ext-0) (let ((act-1 (SystemC-45Clock-osClockSecond arg-1 ext-0))) (let ((act-2 (SystemC-45Clock-osClockNanosecond arg-1 ext-0))) (vector arg-0 act-1 act-2)))))
(define SystemC-45Clock-osClockValid (lambda (arg-0 ext-0) (SystemC-45Clock-prim__osClockValid arg-0 ext-0)))
(define SystemC-45Clock-with--clockTime-4458 (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (let ((act-1 (SystemC-45Clock-fetchOSClock arg-0 ext-0))) (SystemC-45Clock-fromOSClock arg-0 act-1 ext-0))) (else (let ((act-1 (SystemC-45Clock-fetchOSClock arg-0 ext-0))) (let ((act-2 (PreludeC-45IO-u--map_Functor_IO (lambda (arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-2 (blodwen-toSignedInt 1 63))) (lambda (eta-0) (SystemC-45Clock-osClockValid act-1 eta-0)) ext-0))) (cond ((equal? act-2 1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (box eta-0)) (lambda (eta-0) (SystemC-45Clock-fromOSClock arg-0 act-1 eta-0)) ext-0)) (else '()))))))))
(define SystemC-45Clock-clockTime (lambda (arg-0 ext-0) (SystemC-45Clock-with--clockTime-4458 arg-0 (SystemC-45Clock-isClockMandatory arg-0) ext-0)))
(define SystemC-45Clock-nanoseconds (lambda (arg-1) (let ((e-2 (vector-ref arg-1 2))) e-2)))
(define SystemC-45Clock-seconds (lambda (arg-1) (let ((e-1 (vector-ref arg-1 1))) e-1)))
(define CoreC-45Context-n--36437-30460-u--nano 1000000000)
(define CoreC-45Context-getTime (lambda (ext-0) (let ((act-1 (let ((act-1 (SystemC-45Clock-clockTime 1 ext-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (vector 1 (+ (* (SystemC-45Clock-seconds e-5) CoreC-45Context-n--36437-30460-u--nano) (SystemC-45Clock-nanoseconds e-5)))))))))
(define CoreC-45Context-case--checkTimer-30644 (lambda (arg-0 arg-1 arg-2) (lambda (clam-0) (if (null? arg-2) (vector 1 'erased) (let ((e-1 (unbox arg-2))) (let ((e-5 (car e-1))) (let ((e-6 (cdr e-1))) (let ((act-1 (CoreC-45Context-getTime clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-1 1))) (let ((sc3 (PreludeC-45EqOrd-u--C-62_Ord_Integer e-7 e-5))) (cond ((equal? sc3 1) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 67 e-6) clam-0)) (else (vector 1 'erased)))))))))))))))
(define CoreC-45Context-checkTimer (lambda (arg-0 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((CoreC-45Context-case--checkTimer-30644 arg-0 e-5 (let ((e-27 (vector-ref e-5 27))) e-27)) ext-0)))))))
(define LibrariesC-45DataC-45WithDefault-collapseDefault (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-4 (unbox arg-2))) e-4))))
(define CoreC-45NormaliseC-45Eval-argsFromStack (lambda (arg-0 arg-1 arg-3 arg-4) (if (null? arg-3) (box (cons '() arg-4)) (let ((e-3 (cdr arg-3))) (if (null? arg-4) '() (let ((e-6 (car arg-4))) (let ((e-7 (cdr arg-4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45NormaliseC-45Eval-argsFromStack arg-0 arg-1 e-3 e-7) (lambda (_-0) (let ((e-5 (car _-0))) (let ((e-4 (cdr _-0))) (box (cons (cons (Builtin-snd e-6) e-5) e-4)))))))))))))
(define CoreC-45NormaliseC-45Eval-n--9976-5628-u--takeStk (lambda (arg-0 arg-1 arg-3 arg-4 arg-6 arg-7 arg-8) (cond ((equal? arg-6 0) (box (cons (DataC-45Vect-reverse arg-8) arg-7)))(else (let ((e-0 (- arg-6 1))) (if (null? arg-7) '() (let ((e-3 (car arg-7))) (let ((e-4 (cdr arg-7))) (CoreC-45NormaliseC-45Eval-n--9976-5628-u--takeStk arg-0 arg-1 arg-3 arg-4 e-0 e-4 (cons (Builtin-snd e-3) arg-8))))))))))
(define CoreC-45NormaliseC-45Eval-takeFromStack (lambda (arg-0 arg-1 arg-3 arg-4) (CoreC-45NormaliseC-45Eval-n--9976-5628-u--takeStk arg-0 arg-1 arg-4 arg-3 arg-3 arg-4 '())))
(define CoreC-45NormaliseC-45Eval-n--9971-5772-u--evalAll (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7 arg-9 ext-0) (if (null? arg-9) (vector 1 '()) (let ((e-3 (car arg-9))) (let ((e-4 (cdr arg-9))) (let ((act-1 ((CoreC-45NormaliseC-45Eval-evalClosure arg-7 arg-2 arg-0 e-3) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (let ((act-2 (CoreC-45NormaliseC-45Eval-n--9971-5772-u--evalAll arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7 e-4 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) (vector 1 (cons e-5 e-6)))))))))))))))
(define CoreC-45NormaliseC-45Eval-case--evalOp-5813 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7 arg-8) (if (null? arg-8) (lambda (eta-0) (vector 1 (arg-3))) (let ((e-1 (unbox arg-8))) (lambda (clam-0) (if (null? e-1) (vector 1 (arg-3)) (let ((e-4 (car e-1))) (let ((e-5 (cdr e-1))) (if (null? e-5) (let ((act-1 (CoreC-45NormaliseC-45Eval-n--9971-5772-u--evalAll arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7 e-4 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) (vector 1 (let ((sc4 (arg-6 e-6))) (if (null? sc4) (arg-3) (let ((e-2 (unbox sc4))) e-2)))))))) (vector 1 (arg-3)))))))))))
(define CoreC-45NormaliseC-45Eval-evalOp (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7) (CoreC-45NormaliseC-45Eval-case--evalOp-5813 arg-0 arg-1 arg-4 arg-7 arg-6 arg-3 arg-5 arg-2 (CoreC-45NormaliseC-45Eval-takeFromStack arg-0 arg-1 arg-3 arg-6))))
(define CoreC-45Primitives-add (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((5) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-12 (vector-ref arg-1 1))) (box (vector 5 (+ e-0 e-12)))))(else '())))) ((0) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-13 (vector-ref arg-1 1))) (box (vector 0 (bs+ e-1 e-13 63)))))(else '())))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-14 (vector-ref arg-1 1))) (box (vector 1 (bs+ e-2 e-14 7)))))(else '())))) ((2) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-15 (vector-ref arg-1 1))) (box (vector 2 (bs+ e-3 e-15 15)))))(else '())))) ((3) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-16 (vector-ref arg-1 1))) (box (vector 3 (bs+ e-4 e-16 31)))))(else '())))) ((4) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-17 (vector-ref arg-1 1))) (box (vector 4 (bs+ e-5 e-17 63)))))(else '())))) ((6) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-18 (vector-ref arg-1 1))) (box (vector 6 (bu+ e-6 e-18 8)))))(else '())))) ((7) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-19 (vector-ref arg-1 1))) (box (vector 7 (bu+ e-7 e-19 16)))))(else '())))) ((8) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-20 (vector-ref arg-1 1))) (box (vector 8 (bu+ e-8 e-20 32)))))(else '())))) ((9) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-21 (vector-ref arg-1 1))) (box (vector 9 (bu+ e-9 e-21 64)))))(else '())))) ((11) (let ((e-10 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((11) (let ((e-22 (vector-ref arg-1 1))) (box (vector 11 (cast-int-char (bs+ (cast-char-boundedInt e-10 63) (cast-char-boundedInt e-22 63) 63))))))(else '())))) ((12) (let ((e-11 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((12) (let ((e-23 (vector-ref arg-1 1))) (box (vector 12 (+ e-11 e-23)))))(else '()))))(else '()))))
(define CoreC-45Primitives-band (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-10 (vector-ref arg-1 1))) (box (vector 0 (blodwen-and e-0 e-10)))))(else '())))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-11 (vector-ref arg-1 1))) (box (vector 1 (blodwen-and e-1 e-11)))))(else '())))) ((2) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-12 (vector-ref arg-1 1))) (box (vector 2 (blodwen-and e-2 e-12)))))(else '())))) ((3) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-13 (vector-ref arg-1 1))) (box (vector 3 (blodwen-and e-3 e-13)))))(else '())))) ((4) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-14 (vector-ref arg-1 1))) (box (vector 4 (blodwen-and e-4 e-14)))))(else '())))) ((5) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-15 (vector-ref arg-1 1))) (box (vector 5 (blodwen-and e-5 e-15)))))(else '())))) ((6) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-16 (vector-ref arg-1 1))) (box (vector 6 (blodwen-and e-6 e-16)))))(else '())))) ((7) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-17 (vector-ref arg-1 1))) (box (vector 7 (blodwen-and e-7 e-17)))))(else '())))) ((8) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-18 (vector-ref arg-1 1))) (box (vector 8 (blodwen-and e-8 e-18)))))(else '())))) ((9) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-19 (vector-ref arg-1 1))) (box (vector 9 (blodwen-and e-9 e-19)))))(else '()))))(else '()))))
(define CoreC-45Primitives-believeMe (lambda (arg-1) (let ((e-3 (cdr arg-1))) (let ((e-7 (cdr e-3))) (let ((e-10 (car e-7))) (let ((e-11 (cdr e-7))) (case (vector-ref e-10 0) ((2) (if (null? e-11) (box e-10) '())) ((3) (if (null? e-11) (box e-10) '())) ((8) (if (null? e-11) (box e-10) '())) ((10) (let ((e-28 (vector-ref e-10 1))) (let ((e-29 (vector-ref e-10 2))) (if (null? e-11) (box (vector 10 e-28 e-29)) '()))))(else '()))))))))
(define CoreC-45Primitives-binOp (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (case (vector-ref e-2 0) ((8) (let ((e-5 (vector-ref e-2 1))) (let ((e-6 (vector-ref e-2 2))) (if (null? e-3) '() (let ((e-9 (car e-3))) (let ((e-10 (cdr e-3))) (case (vector-ref e-9 0) ((8) (let ((e-13 (vector-ref e-9 2))) (if (null? e-10) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (vector 8 e-5 eta-0)) ((arg-1 e-6) e-13)) '())))(else '()))))))))(else '())))))))
(define CoreC-45Primitives-bor (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-10 (vector-ref arg-1 1))) (box (vector 0 (blodwen-or e-0 e-10)))))(else '())))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-11 (vector-ref arg-1 1))) (box (vector 1 (blodwen-or e-1 e-11)))))(else '())))) ((2) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-12 (vector-ref arg-1 1))) (box (vector 2 (blodwen-or e-2 e-12)))))(else '())))) ((3) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-13 (vector-ref arg-1 1))) (box (vector 3 (blodwen-or e-3 e-13)))))(else '())))) ((4) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-14 (vector-ref arg-1 1))) (box (vector 4 (blodwen-or e-4 e-14)))))(else '())))) ((5) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-15 (vector-ref arg-1 1))) (box (vector 5 (blodwen-or e-5 e-15)))))(else '())))) ((6) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-16 (vector-ref arg-1 1))) (box (vector 6 (blodwen-or e-6 e-16)))))(else '())))) ((7) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-17 (vector-ref arg-1 1))) (box (vector 7 (blodwen-or e-7 e-17)))))(else '())))) ((8) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-18 (vector-ref arg-1 1))) (box (vector 8 (blodwen-or e-8 e-18)))))(else '())))) ((9) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-19 (vector-ref arg-1 1))) (box (vector 9 (blodwen-or e-9 e-19)))))(else '()))))(else '()))))
(define CoreC-45Primitives-bxor (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-10 (vector-ref arg-1 1))) (box (vector 0 (blodwen-xor e-0 e-10)))))(else '())))) ((6) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-11 (vector-ref arg-1 1))) (box (vector 6 (blodwen-xor e-1 e-11)))))(else '())))) ((7) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-12 (vector-ref arg-1 1))) (box (vector 7 (blodwen-xor e-2 e-12)))))(else '())))) ((8) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-13 (vector-ref arg-1 1))) (box (vector 8 (blodwen-xor e-3 e-13)))))(else '())))) ((9) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-14 (vector-ref arg-1 1))) (box (vector 9 (blodwen-xor e-4 e-14)))))(else '())))) ((1) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-15 (vector-ref arg-1 1))) (box (vector 1 (blodwen-xor e-5 e-15)))))(else '())))) ((2) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-16 (vector-ref arg-1 1))) (box (vector 2 (blodwen-xor e-6 e-16)))))(else '())))) ((3) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-17 (vector-ref arg-1 1))) (box (vector 3 (blodwen-xor e-7 e-17)))))(else '())))) ((4) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-18 (vector-ref arg-1 1))) (box (vector 4 (blodwen-xor e-8 e-18)))))(else '())))) ((5) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-19 (vector-ref arg-1 1))) (box (vector 5 (blodwen-xor e-9 e-19)))))(else '()))))(else '()))))
(define CoreC-45Primitives-constantIntegerValue (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (box e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (box e-1))) ((2) (let ((e-2 (vector-ref arg-0 1))) (box e-2))) ((3) (let ((e-3 (vector-ref arg-0 1))) (box e-3))) ((4) (let ((e-4 (vector-ref arg-0 1))) (box e-4))) ((5) (let ((e-5 (vector-ref arg-0 1))) (box e-5))) ((6) (let ((e-6 (vector-ref arg-0 1))) (box e-6))) ((7) (let ((e-7 (vector-ref arg-0 1))) (box e-7))) ((8) (let ((e-8 (vector-ref arg-0 1))) (box e-8))) ((9) (let ((e-9 (vector-ref arg-0 1))) (box e-9)))(else '()))))
(define CoreC-45Primitives-castBits16 (lambda (arg-1) (if (null? arg-1) '() (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (case (vector-ref e-2 0) ((8) (let ((e-5 (vector-ref e-2 1))) (let ((e-6 (vector-ref e-2 2))) (if (null? e-3) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (vector 8 e-5 (vector 7 (blodwen-toUnsignedInt eta-0 16)))) (CoreC-45Primitives-constantIntegerValue e-6)) '()))))(else '())))))))
(define CoreC-45Primitives-castBits32 (lambda (arg-1) (if (null? arg-1) '() (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (case (vector-ref e-2 0) ((8) (let ((e-5 (vector-ref e-2 1))) (let ((e-6 (vector-ref e-2 2))) (if (null? e-3) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (vector 8 e-5 (vector 8 (blodwen-toUnsignedInt eta-0 32)))) (CoreC-45Primitives-constantIntegerValue e-6)) '()))))(else '())))))))
(define CoreC-45Primitives-castBits64 (lambda (arg-1) (if (null? arg-1) '() (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (case (vector-ref e-2 0) ((8) (let ((e-5 (vector-ref e-2 1))) (let ((e-6 (vector-ref e-2 2))) (if (null? e-3) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (vector 8 e-5 (vector 9 (blodwen-toUnsignedInt eta-0 64)))) (CoreC-45Primitives-constantIntegerValue e-6)) '()))))(else '())))))))
(define CoreC-45Primitives-castBits8 (lambda (arg-1) (if (null? arg-1) '() (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (case (vector-ref e-2 0) ((8) (let ((e-5 (vector-ref e-2 1))) (let ((e-6 (vector-ref e-2 2))) (if (null? e-3) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (vector 8 e-5 (vector 6 (blodwen-toUnsignedInt eta-0 8)))) (CoreC-45Primitives-constantIntegerValue e-6)) '()))))(else '())))))))
(define CoreC-45Primitives-castChar (lambda (arg-1) (if (null? arg-1) '() (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (case (vector-ref e-2 0) ((8) (let ((e-5 (vector-ref e-2 1))) (let ((e-6 (vector-ref e-2 2))) (case (vector-ref e-6 0) ((0) (let ((e-7 (vector-ref e-6 1))) (if (null? e-3) (box (vector 8