//===--- macro_use_expanded_decl.cc - test input file for iwyu ------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#include "macro_use_expanded_decl-class.h"

void test() {
  Class c;    // Class with a method decl generated by a macro
  Class2 c2;  // Class generated by a macro with a method decl generated by
              // nested macro

  // Called directly, already including *-class.h

  c.gen_method();
  c2.gen_method();

  // Called through a macro, need to include *-macro.h

  // IWYU: CALL_METHOD is...*-macro.h
  CALL_METHOD(c)
  // IWYU: CALL_METHOD is...*-macro.h
  CALL_METHOD(c2)
}

// Note: gen_method() is not reported as a use for either class because
// of rule B4 (the parent class lives in the same file) This must be true
// no matter if the decl is spelled directly (Class) or through a macro
// defined in a different file (Class2)

/**** IWYU_SUMMARY

tests/cxx/macro_use_expanded_decl.cc should add these lines:
#include "macro_use_expanded_decl-macro.h"

tests/cxx/macro_use_expanded_decl.cc should remove these lines:

The full include-list for tests/cxx/macro_use_expanded_decl.cc:
#include "macro_use_expanded_decl-class.h"  // for Class, Class2
#include "macro_use_expanded_decl-macro.h"  // for CALL_METHOD

***** IWYU_SUMMARY */
