/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import feign.Request;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class RestAPIException
extends RuntimeException {
    private final Request request;
    private final int status;
    private final String reason;
    private final Map<String, Collection<String>> headers;

    public RestAPIException(int status, String reason) {
        this(null, status, reason, Collections.emptyMap());
    }

    public RestAPIException(Request request, int status, String reason, Map<String, Collection<String>> headers) {
        this.request = request;
        this.status = status;
        this.reason = reason;
        this.headers = headers;
    }

    public Request getRequest() {
        return this.request;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    public boolean isNotFound() {
        return 404 == this.status;
    }

    public boolean isForbidden() {
        return 403 == this.status;
    }
}

