/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.internal.announce.Announcer;
import org.jreleaser.model.internal.common.AbstractActivatable;

public abstract class AbstractAnnouncer<S extends AbstractAnnouncer<S, A>, A extends org.jreleaser.model.api.announce.Announcer>
extends AbstractActivatable<S>
implements Announcer<A> {
    private static final long serialVersionUID = 9045634651862485708L;
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    @JsonIgnore
    private String name;
    private Integer connectTimeout;
    private Integer readTimeout;

    protected AbstractAnnouncer(String name) {
        this.name = name;
    }

    @Override
    public void merge(S source) {
        super.merge(source);
        this.connectTimeout = this.merge(this.connectTimeout, ((AbstractAnnouncer)source).getConnectTimeout());
        this.readTimeout = this.merge(this.readTimeout, ((AbstractAnnouncer)source).getReadTimeout());
        this.setExtraProperties(this.merge(this.extraProperties, ((AbstractAnnouncer)source).getExtraProperties()));
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected boolean isSet() {
        return super.isSet() || null != this.connectTimeout || null != this.readTimeout || !this.extraProperties.isEmpty();
    }

    @Override
    public String prefix() {
        return this.getName();
    }

    @Override
    public boolean isSnapshotSupported() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("enabled", this.isEnabled());
        props.put("active", this.getActive());
        props.put("connectTimeout", this.connectTimeout);
        props.put("readTimeout", this.readTimeout);
        this.asMap(full, props);
        props.put("extraProperties", this.getExtraProperties());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(this.getName(), props);
        return map;
    }

    protected abstract void asMap(boolean var1, Map<String, Object> var2);
}

