/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.opencollective;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.util.Map;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.opencollective.OpenCollectiveException;
import org.jreleaser.sdk.opencollective.api.Envelope;
import org.jreleaser.sdk.opencollective.api.Mutation;
import org.jreleaser.sdk.opencollective.api.OpenCollectiveAPI;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

public class OpenCollectiveSdk {
    private static final String MUTATION_CREATE_UPDATE = "mutation (\n  $update: UpdateCreateInput!\n) {\n  createUpdate(update: $update) {\n    id\n  }\n}";
    private static final String MUTATION_PUBLISH_UPDATE = "mutation (\n  $id: String!\n  $audience: UpdateAudience\n) {\n  publishUpdate(id: $id, notificationAudience: $audience) {\n    id\n  }\n}";
    private final JReleaserContext context;
    private final OpenCollectiveAPI api;
    private final boolean dryrun;

    private OpenCollectiveSdk(JReleaserContext context, String host, String token, int connectTimeout, int readTimeout, boolean dryrun) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.context = context;
        this.dryrun = dryrun;
        this.api = (OpenCollectiveAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new JacksonEncoder(objectMapper)).decoder((Decoder)new JacksonDecoder(objectMapper)).requestInterceptor(template -> {
            template.header("User-Agent", new String[]{"JReleaser/" + JReleaserVersion.getPlainVersion()});
            template.header("Personal-Token", new String[]{token});
        }).errorDecoder((methodKey, response) -> new RestAPIException(response.request(), response.status(), response.reason(), response.headers())).target(OpenCollectiveAPI.class, host);
        this.context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void postUpdate(String slug, String title, String body) throws OpenCollectiveException {
        this.wrap(() -> {
            Mutation mutation = new Mutation();
            mutation.setQuery(MUTATION_CREATE_UPDATE);
            mutation.setVariables((Map<Object, Object>)CollectionUtils.map().e((Object)"update", (Object)CollectionUtils.map().e((Object)"title", (Object)title).e((Object)"html", (Object)body).e((Object)"account", (Object)CollectionUtils.map().e((Object)"slug", (Object)slug))));
            Envelope envelope = this.api.createUpdate(mutation);
            mutation.setQuery(MUTATION_PUBLISH_UPDATE);
            mutation.setVariables((Map<Object, Object>)CollectionUtils.map().e((Object)"id", (Object)envelope.getData().getCreateUpdate().getId()).e((Object)"audience", (Object)"ALL"));
            this.api.publishUpdate(mutation);
        });
    }

    private void wrap(OpenCollectiveOperation op) throws OpenCollectiveException {
        try {
            if (!this.dryrun) {
                op.run();
            }
        }
        catch (RestAPIException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new OpenCollectiveException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"openCollective"}), e);
        }
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    @FunctionalInterface
    public static interface OpenCollectiveOperation {
        public void run() throws OpenCollectiveException;
    }

    public static class Builder {
        private final JReleaserContext context;
        private boolean dryrun;
        private String token;
        private String host;
        private int connectTimeout = 20;
        private int readTimeout = 60;

        private Builder(JReleaserContext context) {
            this.context = Objects.requireNonNull(context, "'context' must not be null");
        }

        public Builder dryrun(boolean dryrun) {
            this.dryrun = dryrun;
            return this;
        }

        public Builder token(String token) {
            this.token = StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank").trim();
            return this;
        }

        public Builder host(String host) {
            this.host = StringUtils.requireNonBlank((String)host, (String)"'host' must not be blank").trim();
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        private void validate() {
            StringUtils.requireNonBlank((String)this.host, (String)"'host' must not be blank");
            StringUtils.requireNonBlank((String)this.token, (String)"'token' must not be blank");
        }

        public OpenCollectiveSdk build() {
            this.validate();
            return new OpenCollectiveSdk(this.context, this.host, this.token, this.connectTimeout, this.readTimeout, this.dryrun);
        }
    }
}

