/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.announce.RedditAnnouncer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class RedditAnnouncer
extends AbstractAnnouncer<RedditAnnouncer, org.jreleaser.model.api.announce.RedditAnnouncer> {
    private static final long serialVersionUID = 4379635430074452143L;
    private String clientId;
    private String clientSecret;
    private String username;
    private String password;
    private String subreddit;
    private String title;
    private String text;
    private String textTemplate;
    private String url;
    private RedditAnnouncer.SubmissionType submissionType = RedditAnnouncer.SubmissionType.SELF;
    @JsonIgnore
    private final org.jreleaser.model.api.announce.RedditAnnouncer immutable = new org.jreleaser.model.api.announce.RedditAnnouncer(){
        private static final long serialVersionUID = -1316280067796370506L;

        public String getType() {
            return "reddit";
        }

        public String getClientId() {
            return RedditAnnouncer.this.clientId;
        }

        public String getClientSecret() {
            return RedditAnnouncer.this.clientSecret;
        }

        public String getUsername() {
            return RedditAnnouncer.this.username;
        }

        public String getPassword() {
            return RedditAnnouncer.this.password;
        }

        public String getSubreddit() {
            return RedditAnnouncer.this.subreddit;
        }

        public String getTitle() {
            return RedditAnnouncer.this.title;
        }

        public String getText() {
            return RedditAnnouncer.this.text;
        }

        public String getTextTemplate() {
            return RedditAnnouncer.this.textTemplate;
        }

        public String getUrl() {
            return RedditAnnouncer.this.url;
        }

        public RedditAnnouncer.SubmissionType getSubmissionType() {
            return RedditAnnouncer.this.submissionType;
        }

        public String getName() {
            return RedditAnnouncer.this.getName();
        }

        public boolean isSnapshotSupported() {
            return RedditAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return RedditAnnouncer.this.getActive();
        }

        public boolean isEnabled() {
            return RedditAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(RedditAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return RedditAnnouncer.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(RedditAnnouncer.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return RedditAnnouncer.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return RedditAnnouncer.this.getReadTimeout();
        }
    };

    public RedditAnnouncer() {
        super("reddit");
    }

    @Override
    public org.jreleaser.model.api.announce.RedditAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(RedditAnnouncer source) {
        super.merge(source);
        this.clientId = this.merge(this.clientId, source.clientId);
        this.clientSecret = this.merge(this.clientSecret, source.clientSecret);
        this.username = this.merge(this.username, source.username);
        this.password = this.merge(this.password, source.password);
        this.subreddit = this.merge(this.subreddit, source.subreddit);
        this.title = this.merge(this.title, source.title);
        this.text = this.merge(this.text, source.text);
        this.textTemplate = this.merge(this.textTemplate, source.textTemplate);
        this.url = this.merge(this.url, source.url);
        this.submissionType = this.merge(this.submissionType, source.submissionType);
    }

    public String getResolvedTitle(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.title, (TemplateContext)props);
    }

    public String getResolvedText(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.text, (TemplateContext)props);
    }

    public String getResolvedTextTemplate(JReleaserContext context, TemplateContext extraProps) {
        TemplateContext props = context.fullProps();
        context.getChangelog().apply(props);
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, this.resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context));
        props.setAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.textTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((JReleaserLogger)context.getLogger(), (Reader)reader, (TemplateContext)props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedUrl(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.url, (TemplateContext)props);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("clientId", StringUtils.isNotBlank((String)this.getClientId()) ? "************" : "**unset**");
        props.put("clientSecret", StringUtils.isNotBlank((String)this.getClientSecret()) ? "************" : "**unset**");
        props.put("username", StringUtils.isNotBlank((String)this.getUsername()) ? "************" : "**unset**");
        props.put("password", StringUtils.isNotBlank((String)this.getPassword()) ? "************" : "**unset**");
        props.put("subreddit", this.subreddit);
        props.put("submissionType", this.submissionType);
        props.put("title", this.title);
        props.put("text", this.text);
        props.put("textTemplate", this.textTemplate);
        props.put("url", this.url);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSubreddit() {
        return this.subreddit;
    }

    public void setSubreddit(String subreddit) {
        this.subreddit = subreddit;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getTextTemplate() {
        return this.textTemplate;
    }

    public void setTextTemplate(String textTemplate) {
        this.textTemplate = textTemplate;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public RedditAnnouncer.SubmissionType getSubmissionType() {
        return this.submissionType;
    }

    public void setSubmissionType(RedditAnnouncer.SubmissionType submissionType) {
        this.submissionType = submissionType;
    }
}

