/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class S3Uploader
extends AbstractUploader<org.jreleaser.model.api.upload.S3Uploader, S3Uploader> {
    private static final long serialVersionUID = -747298261100208723L;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private String region;
    private String bucket;
    private String path;
    private String downloadUrl;
    private String endpoint;
    private String accessKeyId;
    private String secretKey;
    private String sessionToken;
    @JsonIgnore
    private final org.jreleaser.model.api.upload.S3Uploader immutable = new org.jreleaser.model.api.upload.S3Uploader(){
        private static final long serialVersionUID = -3263159021072324345L;

        public String getRegion() {
            return S3Uploader.this.region;
        }

        public String getBucket() {
            return S3Uploader.this.bucket;
        }

        public String getAccessKeyId() {
            return S3Uploader.this.accessKeyId;
        }

        public String getSecretKey() {
            return S3Uploader.this.secretKey;
        }

        public String getSessionToken() {
            return S3Uploader.this.sessionToken;
        }

        public String getPath() {
            return S3Uploader.this.path;
        }

        public String getDownloadUrl() {
            return S3Uploader.this.downloadUrl;
        }

        public String getEndpoint() {
            return S3Uploader.this.endpoint;
        }

        public Map<String, String> getHeaders() {
            return Collections.unmodifiableMap(S3Uploader.this.headers);
        }

        public String getType() {
            return S3Uploader.this.getType();
        }

        public String getName() {
            return S3Uploader.this.getName();
        }

        public boolean isSnapshotSupported() {
            return S3Uploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return S3Uploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return S3Uploader.this.isFiles();
        }

        public boolean isSignatures() {
            return S3Uploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return S3Uploader.this.isChecksums();
        }

        public boolean isCatalogs() {
            return S3Uploader.this.isCatalogs();
        }

        public Active getActive() {
            return S3Uploader.this.getActive();
        }

        public boolean isEnabled() {
            return S3Uploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(S3Uploader.this.asMap(full));
        }

        public String getPrefix() {
            return S3Uploader.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(S3Uploader.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return S3Uploader.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return S3Uploader.this.getReadTimeout();
        }
    };

    public S3Uploader() {
        super("s3");
    }

    @Override
    public org.jreleaser.model.api.upload.S3Uploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(S3Uploader source) {
        super.merge(source);
        this.region = this.merge(this.region, source.region);
        this.bucket = this.merge(this.bucket, source.bucket);
        this.path = this.merge(this.path, source.path);
        this.downloadUrl = this.merge(this.downloadUrl, source.downloadUrl);
        this.endpoint = this.merge(this.endpoint, source.endpoint);
        this.accessKeyId = this.merge(this.accessKeyId, source.accessKeyId);
        this.secretKey = this.merge(this.secretKey, source.secretKey);
        this.sessionToken = this.merge(this.sessionToken, source.sessionToken);
        this.setHeaders(this.merge(this.headers, source.headers));
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context, context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, TemplateContext props, Artifact artifact) {
        if (StringUtils.isNotBlank((String)this.getDownloadUrl())) {
            TemplateContext p = new TemplateContext(this.artifactProps(props, artifact));
            p.setAll(this.resolvedExtraProperties());
            p.set("bucket", (Object)this.bucket);
            p.set("region", (Object)this.region);
            return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.getDownloadUrl(), (TemplateContext)p);
        }
        if (StringUtils.isBlank((String)this.getEndpoint())) {
            String url = "https://{{bucket}}.s3.{{region}}.amazonaws.com/" + this.path;
            TemplateContext p = new TemplateContext(this.artifactProps(props, artifact));
            p.setAll(this.resolvedExtraProperties());
            p.set("bucket", (Object)this.bucket);
            p.set("region", (Object)this.region);
            return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)url, (TemplateContext)p);
        }
        return "";
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("region", this.region);
        props.put("bucket", this.bucket);
        props.put("accessKeyId", StringUtils.isNotBlank((String)this.accessKeyId) ? "************" : "**unset**");
        props.put("secretKey", StringUtils.isNotBlank((String)this.secretKey) ? "************" : "**unset**");
        props.put("sessionToken", StringUtils.isNotBlank((String)this.sessionToken) ? "************" : "**unset**");
        props.put("path", this.path);
        props.put("downloadUrl", this.downloadUrl);
        props.put("endpoint", this.endpoint);
        props.put("headers", this.headers);
    }

    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        String artifactPath = this.path;
        String customPathKey = "s3" + StringUtils.capitalize((String)this.getName()) + "Path";
        if (artifact.getExtraProperties().containsKey(customPathKey)) {
            artifactPath = artifact.getExtraProperty(customPathKey);
        }
        TemplateContext p = new TemplateContext(this.artifactProps(context, artifact));
        p.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)artifactPath, (TemplateContext)p);
    }
}

