/*
 * Copyright (C) 2014, 2016 Karl Wette
 * Copyright (C) 2009-2013 Adam Mercer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * LALSimulationVCSInfo.h - LALSimulation VCS Information Header
 */

/** \cond DONT_DOXYGEN */

#ifndef _LALSIMULATIONVCSINFOHEADER_H
#define _LALSIMULATIONVCSINFOHEADER_H

#include <lal/LALVCSInfoType.h>
#include <lal/LALSimulationVCSInfo.h>
#include <lal/LALSimulationConfig.h>

#ifdef __cplusplus
extern "C" {
#endif

/* VCS information */
#define LALSIMULATION_VCS_ID "b8b77c10d4b7fb9302e74797de9701c4096fb3bf"
#define LALSIMULATION_VCS_DATE "2019-01-23 21:24:16 +0000"
#define LALSIMULATION_VCS_BRANCH "None"
#define LALSIMULATION_VCS_TAG "lalsimulation-v1.8.1"
#define LALSIMULATION_VCS_AUTHOR "Adam Mercer <adam.mercer@ligo.org>"
#define LALSIMULATION_VCS_COMMITTER "Adam Mercer <adam.mercer@ligo.org>"
#define LALSIMULATION_VCS_CLEAN "CLEAN"
#define LALSIMULATION_VCS_STATUS "CLEAN: All modifications committed"

#if LALSIMULATION_VERSION_DEVEL != 0
/* VCS header/library mismatch link check function */
#define LALSIMULATION_VCS_LINK_CHECK LALSIMULATION_CLEAN_b8b77c10d4b7fb9302e74797de9701c4096fb3bf_VCS_HEADER_LIBRARY_MISMATCH
void LALSIMULATION_VCS_LINK_CHECK(void);
#endif

#ifdef __cplusplus
}
#endif

#endif /* _LALSIMULATIONVCSINFOHEADER_H */

/** \endcond */
