/*
 * Decompiled with CFR 0.152.
 */
package it.cnr.imaa.essi.lablib.gui.checkboxtree.examples;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public class RadioButtonTreeCellRenderer
extends JPanel
implements CheckboxTreeCellRenderer {
    protected JRadioButton button = new JRadioButton();
    protected JLabel label = new JLabel();

    public static void main(String[] args) {
        CheckboxTree tree = new CheckboxTree();
        tree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.SINGLE);
        tree.setCellRenderer(new RadioButtonTreeCellRenderer());
        JFrame frame = new JFrame("RadioButton tree");
        frame.add(tree);
        tree.expandAll();
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public RadioButtonTreeCellRenderer() {
        this.label.setFocusable(true);
        this.label.setOpaque(true);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.button);
        this.add(this.label);
        this.button.setBackground(UIManager.getColor("Tree.textBackground"));
        this.setBackground(UIManager.getColor("Tree.textBackground"));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.label.setText(value.toString());
        if (selected) {
            this.label.setBackground(UIManager.getColor("Tree.selectionBackground"));
        } else {
            this.label.setBackground(UIManager.getColor("Tree.textBackground"));
        }
        TreeCheckingModel checkingModel = ((CheckboxTree)tree).getCheckingModel();
        TreePath path = tree.getPathForRow(row);
        boolean enabled = checkingModel.isPathEnabled(path);
        boolean checked = checkingModel.isPathChecked(path);
        this.button.setEnabled(enabled);
        this.label.setForeground(Color.black);
        this.button.setSelected(checked);
        return this;
    }

    public boolean isOnHotspot(int x, int y) {
        return this.button.getBounds().contains(x, y);
    }
}

