/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.internal.impl.filter.FilteringRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.PipelineRepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;

@Singleton
@Named(value="rrf")
public final class FilteringPipelineRepositoryConnectorFactory
implements PipelineRepositoryConnectorFactory {
    public static final String NAME = "rrf";
    private final RemoteRepositoryFilterManager remoteRepositoryFilterManager;
    private float priority = 10000.0f;

    @Inject
    public FilteringPipelineRepositoryConnectorFactory(RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        this.remoteRepositoryFilterManager = Objects.requireNonNull(remoteRepositoryFilterManager);
    }

    public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository, RepositoryConnector delegate) {
        RemoteRepositoryFilter filter = this.remoteRepositoryFilterManager.getRemoteRepositoryFilter(session);
        if (filter != null) {
            return new FilteringRepositoryConnector(repository, delegate, filter);
        }
        return delegate;
    }

    public float getPriority() {
        return this.priority;
    }

    public FilteringPipelineRepositoryConnectorFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

