// Code generated by metricgen; DO NOT EDIT.
// source: contexts.yaml

package contexts

import (
	"github.com/netdata/netdata/go/plugins/plugin/go.d/agent/module"
	"github.com/netdata/netdata/go/plugins/plugin/ibm.d/framework"
	"strings"
)

// cleanLabelValue cleans a label value for use in instance/dimension IDs
func cleanLabelValue(value string) string {
	// Replace problematic characters
	r := strings.NewReplacer(
		" ", "_",
		".", "_",
		"-", "_",
		"/", "_",
		":", "_",
		"=", "_",
		",", "_",
		"(", "_",
		")", "_",
	)
	return strings.ToLower(r.Replace(value))
}

// EmptyLabels is used for contexts without labels
type EmptyLabels struct{}

// InstanceID for empty labels just returns the context name
func (EmptyLabels) InstanceID(contextName string) string {
	return contextName
}

// --- AlarmManager ---

// AlarmManagerEventsValues defines the type-safe values for AlarmManager.Events context
type AlarmManagerEventsValues struct {
	Created   int64
	Cancelled int64
	Fired     int64
}

// AlarmManagerEventsContext provides type-safe operations for AlarmManager.Events context
type AlarmManagerEventsContext struct {
	framework.Context[AlarmManagerLabels]
}

// Set provides type-safe dimension setting for AlarmManager.Events context
func (c AlarmManagerEventsContext) Set(state *framework.CollectorState, labels AlarmManagerLabels, values AlarmManagerEventsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"created":   values.Created,
		"cancelled": values.Cancelled,
		"fired":     values.Fired,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c AlarmManagerEventsContext) SetUpdateEvery(state *framework.CollectorState, labels AlarmManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// AlarmManagerLabels defines the required labels for AlarmManager contexts
type AlarmManagerLabels struct {
	Node    string
	Server  string
	Manager string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l AlarmManagerLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, manager
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Manager)
}

// AlarmManager contains all metric contexts for AlarmManager
var AlarmManager = struct {
	Events AlarmManagerEventsContext
}{
	Events: AlarmManagerEventsContext{
		Context: framework.Context[AlarmManagerLabels]{
			Name:        "websphere_pmi.alarm_manager_events",
			Family:      "workloads/alarms",
			Title:       "Alarm Manager Events",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    610,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "created",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "cancelled",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "fired",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"manager",
			},
		},
	},
}

// --- DynamicCache ---

// DynamicCacheInMemoryValues defines the type-safe values for DynamicCache.InMemory context
type DynamicCacheInMemoryValues struct {
	Entries int64
}

// DynamicCacheInMemoryContext provides type-safe operations for DynamicCache.InMemory context
type DynamicCacheInMemoryContext struct {
	framework.Context[DynamicCacheLabels]
}

// Set provides type-safe dimension setting for DynamicCache.InMemory context
func (c DynamicCacheInMemoryContext) Set(state *framework.CollectorState, labels DynamicCacheLabels, values DynamicCacheInMemoryValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"entries": values.Entries,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DynamicCacheInMemoryContext) SetUpdateEvery(state *framework.CollectorState, labels DynamicCacheLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DynamicCacheCapacityValues defines the type-safe values for DynamicCache.Capacity context
type DynamicCacheCapacityValues struct {
	Max_entries int64
}

// DynamicCacheCapacityContext provides type-safe operations for DynamicCache.Capacity context
type DynamicCacheCapacityContext struct {
	framework.Context[DynamicCacheLabels]
}

// Set provides type-safe dimension setting for DynamicCache.Capacity context
func (c DynamicCacheCapacityContext) Set(state *framework.CollectorState, labels DynamicCacheLabels, values DynamicCacheCapacityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"max_entries": values.Max_entries,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DynamicCacheCapacityContext) SetUpdateEvery(state *framework.CollectorState, labels DynamicCacheLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DynamicCacheLabels defines the required labels for DynamicCache contexts
type DynamicCacheLabels struct {
	Node   string
	Server string
	Cache  string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l DynamicCacheLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, cache
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Cache)
}

// DynamicCache contains all metric contexts for DynamicCache
var DynamicCache = struct {
	InMemory DynamicCacheInMemoryContext
	Capacity DynamicCacheCapacityContext
}{
	InMemory: DynamicCacheInMemoryContext{
		Context: framework.Context[DynamicCacheLabels]{
			Name:        "websphere_pmi.dynamic_cache_in_memory",
			Family:      "workloads/cache",
			Title:       "Dynamic Cache Entries",
			Units:       "entries",
			Type:        module.Line,
			Priority:    540,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "entries",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"cache",
			},
		},
	},
	Capacity: DynamicCacheCapacityContext{
		Context: framework.Context[DynamicCacheLabels]{
			Name:        "websphere_pmi.dynamic_cache_capacity",
			Family:      "workloads/cache",
			Title:       "Dynamic Cache Capacity",
			Units:       "entries",
			Type:        module.Line,
			Priority:    541,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "max_entries",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"cache",
			},
		},
	},
}

// --- EnterpriseBeans ---

// EnterpriseBeansOperationsValues defines the type-safe values for EnterpriseBeans.Operations context
type EnterpriseBeansOperationsValues struct {
	Create      int64
	Remove      int64
	Activate    int64
	Passivate   int64
	Instantiate int64
	Store       int64
	Load        int64
}

// EnterpriseBeansOperationsContext provides type-safe operations for EnterpriseBeans.Operations context
type EnterpriseBeansOperationsContext struct {
	framework.Context[EnterpriseBeansLabels]
}

// Set provides type-safe dimension setting for EnterpriseBeans.Operations context
func (c EnterpriseBeansOperationsContext) Set(state *framework.CollectorState, labels EnterpriseBeansLabels, values EnterpriseBeansOperationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"create":      values.Create,
		"remove":      values.Remove,
		"activate":    values.Activate,
		"passivate":   values.Passivate,
		"instantiate": values.Instantiate,
		"store":       values.Store,
		"load":        values.Load,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c EnterpriseBeansOperationsContext) SetUpdateEvery(state *framework.CollectorState, labels EnterpriseBeansLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// EnterpriseBeansMessagesValues defines the type-safe values for EnterpriseBeans.Messages context
type EnterpriseBeansMessagesValues struct {
	Received int64
	Backout  int64
}

// EnterpriseBeansMessagesContext provides type-safe operations for EnterpriseBeans.Messages context
type EnterpriseBeansMessagesContext struct {
	framework.Context[EnterpriseBeansLabels]
}

// Set provides type-safe dimension setting for EnterpriseBeans.Messages context
func (c EnterpriseBeansMessagesContext) Set(state *framework.CollectorState, labels EnterpriseBeansLabels, values EnterpriseBeansMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"received": values.Received,
		"backout":  values.Backout,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c EnterpriseBeansMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels EnterpriseBeansLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// EnterpriseBeansPoolValues defines the type-safe values for EnterpriseBeans.Pool context
type EnterpriseBeansPoolValues struct {
	Ready               int64
	Live                int64
	Pooled              int64
	Active_method       int64
	Passive             int64
	Server_session_pool int64
	Method_ready        int64
	Async_queue         int64
}

// EnterpriseBeansPoolContext provides type-safe operations for EnterpriseBeans.Pool context
type EnterpriseBeansPoolContext struct {
	framework.Context[EnterpriseBeansLabels]
}

// Set provides type-safe dimension setting for EnterpriseBeans.Pool context
func (c EnterpriseBeansPoolContext) Set(state *framework.CollectorState, labels EnterpriseBeansLabels, values EnterpriseBeansPoolValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"ready":               values.Ready,
		"live":                values.Live,
		"pooled":              values.Pooled,
		"active_method":       values.Active_method,
		"passive":             values.Passive,
		"server_session_pool": values.Server_session_pool,
		"method_ready":        values.Method_ready,
		"async_queue":         values.Async_queue,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c EnterpriseBeansPoolContext) SetUpdateEvery(state *framework.CollectorState, labels EnterpriseBeansLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// EnterpriseBeansTimeValues defines the type-safe values for EnterpriseBeans.Time context
type EnterpriseBeansTimeValues struct {
	Activation      int64
	Passivation     int64
	Create          int64
	Remove          int64
	Load            int64
	Store           int64
	Method_response int64
	Wait            int64
	Async_wait      int64
	Read_lock       int64
	Write_lock      int64
}

// EnterpriseBeansTimeContext provides type-safe operations for EnterpriseBeans.Time context
type EnterpriseBeansTimeContext struct {
	framework.Context[EnterpriseBeansLabels]
}

// Set provides type-safe dimension setting for EnterpriseBeans.Time context
func (c EnterpriseBeansTimeContext) Set(state *framework.CollectorState, labels EnterpriseBeansLabels, values EnterpriseBeansTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"activation":      values.Activation,
		"passivation":     values.Passivation,
		"create":          values.Create,
		"remove":          values.Remove,
		"load":            values.Load,
		"store":           values.Store,
		"method_response": values.Method_response,
		"wait":            values.Wait,
		"async_wait":      values.Async_wait,
		"read_lock":       values.Read_lock,
		"write_lock":      values.Write_lock,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c EnterpriseBeansTimeContext) SetUpdateEvery(state *framework.CollectorState, labels EnterpriseBeansLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// EnterpriseBeansLabels defines the required labels for EnterpriseBeans contexts
type EnterpriseBeansLabels struct {
	Node   string
	Server string
	Bean   string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l EnterpriseBeansLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, bean
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Bean)
}

// EnterpriseBeans contains all metric contexts for EnterpriseBeans
var EnterpriseBeans = struct {
	Operations EnterpriseBeansOperationsContext
	Messages   EnterpriseBeansMessagesContext
	Pool       EnterpriseBeansPoolContext
	Time       EnterpriseBeansTimeContext
}{
	Operations: EnterpriseBeansOperationsContext{
		Context: framework.Context[EnterpriseBeansLabels]{
			Name:        "websphere_pmi.ejb_operations",
			Family:      "workloads/ejb",
			Title:       "EJB Operations",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    640,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "create",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "remove",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "activate",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "passivate",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "instantiate",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "store",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "load",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"bean",
			},
		},
	},
	Messages: EnterpriseBeansMessagesContext{
		Context: framework.Context[EnterpriseBeansLabels]{
			Name:        "websphere_pmi.ejb_messages",
			Family:      "workloads/ejb",
			Title:       "EJB Message Activity",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    641,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "received",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "backout",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"bean",
			},
		},
	},
	Pool: EnterpriseBeansPoolContext{
		Context: framework.Context[EnterpriseBeansLabels]{
			Name:        "websphere_pmi.ejb_pool",
			Family:      "workloads/ejb",
			Title:       "EJB Pool Usage",
			Units:       "beans",
			Type:        module.Line,
			Priority:    642,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "ready",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "live",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "pooled",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "active_method",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "passive",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "server_session_pool",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "method_ready",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "async_queue",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"bean",
			},
		},
	},
	Time: EnterpriseBeansTimeContext{
		Context: framework.Context[EnterpriseBeansLabels]{
			Name:        "websphere_pmi.ejb_time",
			Family:      "workloads/ejb",
			Title:       "EJB Operation Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    643,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "activation",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "passivation",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "create",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "remove",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "load",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "store",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "method_response",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "wait",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "async_wait",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "read_lock",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "write_lock",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"bean",
			},
		},
	},
}

// --- ExtensionRegistry ---

// ExtensionRegistryRequestsValues defines the type-safe values for ExtensionRegistry.Requests context
type ExtensionRegistryRequestsValues struct {
	Requests      int64
	Hits          int64
	Displacements int64
}

// ExtensionRegistryRequestsContext provides type-safe operations for ExtensionRegistry.Requests context
type ExtensionRegistryRequestsContext struct {
	framework.Context[ExtensionRegistryLabels]
}

// Set provides type-safe dimension setting for ExtensionRegistry.Requests context
func (c ExtensionRegistryRequestsContext) Set(state *framework.CollectorState, labels ExtensionRegistryLabels, values ExtensionRegistryRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"requests":      values.Requests,
		"hits":          values.Hits,
		"displacements": values.Displacements,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ExtensionRegistryRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels ExtensionRegistryLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ExtensionRegistryHitRateValues defines the type-safe values for ExtensionRegistry.HitRate context
type ExtensionRegistryHitRateValues struct {
	Hit_rate int64
}

// ExtensionRegistryHitRateContext provides type-safe operations for ExtensionRegistry.HitRate context
type ExtensionRegistryHitRateContext struct {
	framework.Context[ExtensionRegistryLabels]
}

// Set provides type-safe dimension setting for ExtensionRegistry.HitRate context
func (c ExtensionRegistryHitRateContext) Set(state *framework.CollectorState, labels ExtensionRegistryLabels, values ExtensionRegistryHitRateValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"hit_rate": values.Hit_rate,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ExtensionRegistryHitRateContext) SetUpdateEvery(state *framework.CollectorState, labels ExtensionRegistryLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ExtensionRegistryLabels defines the required labels for ExtensionRegistry contexts
type ExtensionRegistryLabels struct {
	Node   string
	Server string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ExtensionRegistryLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server)
}

// ExtensionRegistry contains all metric contexts for ExtensionRegistry
var ExtensionRegistry = struct {
	Requests ExtensionRegistryRequestsContext
	HitRate  ExtensionRegistryHitRateContext
}{
	Requests: ExtensionRegistryRequestsContext{
		Context: framework.Context[ExtensionRegistryLabels]{
			Name:        "websphere_pmi.extension_registry_requests",
			Family:      "platform/extensions",
			Title:       "Extension Registry Requests",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    660,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "requests",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "hits",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "displacements",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
	HitRate: ExtensionRegistryHitRateContext{
		Context: framework.Context[ExtensionRegistryLabels]{
			Name:        "websphere_pmi.extension_registry_hit_rate",
			Family:      "platform/extensions",
			Title:       "Extension Registry Hit Rate",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    661,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "hit_rate",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
}

// --- HAManager ---

// HAManagerGroupsValues defines the type-safe values for HAManager.Groups context
type HAManagerGroupsValues struct {
	Local int64
}

// HAManagerGroupsContext provides type-safe operations for HAManager.Groups context
type HAManagerGroupsContext struct {
	framework.Context[HAManagerLabels]
}

// Set provides type-safe dimension setting for HAManager.Groups context
func (c HAManagerGroupsContext) Set(state *framework.CollectorState, labels HAManagerLabels, values HAManagerGroupsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"local": values.Local,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c HAManagerGroupsContext) SetUpdateEvery(state *framework.CollectorState, labels HAManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// HAManagerBulletinBoardValues defines the type-safe values for HAManager.BulletinBoard context
type HAManagerBulletinBoardValues struct {
	Subjects            int64
	Subscriptions       int64
	Local_subjects      int64
	Local_subscriptions int64
}

// HAManagerBulletinBoardContext provides type-safe operations for HAManager.BulletinBoard context
type HAManagerBulletinBoardContext struct {
	framework.Context[HAManagerLabels]
}

// Set provides type-safe dimension setting for HAManager.BulletinBoard context
func (c HAManagerBulletinBoardContext) Set(state *framework.CollectorState, labels HAManagerLabels, values HAManagerBulletinBoardValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"subjects":            values.Subjects,
		"subscriptions":       values.Subscriptions,
		"local_subjects":      values.Local_subjects,
		"local_subscriptions": values.Local_subscriptions,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c HAManagerBulletinBoardContext) SetUpdateEvery(state *framework.CollectorState, labels HAManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// HAManagerRebuildTimeValues defines the type-safe values for HAManager.RebuildTime context
type HAManagerRebuildTimeValues struct {
	Group_state    int64
	Bulletin_board int64
}

// HAManagerRebuildTimeContext provides type-safe operations for HAManager.RebuildTime context
type HAManagerRebuildTimeContext struct {
	framework.Context[HAManagerLabels]
}

// Set provides type-safe dimension setting for HAManager.RebuildTime context
func (c HAManagerRebuildTimeContext) Set(state *framework.CollectorState, labels HAManagerLabels, values HAManagerRebuildTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"group_state":    values.Group_state,
		"bulletin_board": values.Bulletin_board,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c HAManagerRebuildTimeContext) SetUpdateEvery(state *framework.CollectorState, labels HAManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// HAManagerLabels defines the required labels for HAManager contexts
type HAManagerLabels struct {
	Node   string
	Server string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l HAManagerLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server)
}

// HAManager contains all metric contexts for HAManager
var HAManager = struct {
	Groups        HAManagerGroupsContext
	BulletinBoard HAManagerBulletinBoardContext
	RebuildTime   HAManagerRebuildTimeContext
}{
	Groups: HAManagerGroupsContext{
		Context: framework.Context[HAManagerLabels]{
			Name:        "websphere_pmi.ha_manager_groups",
			Family:      "reliability/ha",
			Title:       "HA Manager Groups",
			Units:       "groups",
			Type:        module.Line,
			Priority:    600,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "local",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
	BulletinBoard: HAManagerBulletinBoardContext{
		Context: framework.Context[HAManagerLabels]{
			Name:        "websphere_pmi.ha_manager_bulletin_board",
			Family:      "reliability/ha",
			Title:       "HA Manager Bulletin Board",
			Units:       "items",
			Type:        module.Line,
			Priority:    601,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "subjects",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "subscriptions",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_subjects",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_subscriptions",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
	RebuildTime: HAManagerRebuildTimeContext{
		Context: framework.Context[HAManagerLabels]{
			Name:        "websphere_pmi.ha_manager_rebuild_time",
			Family:      "reliability/ha",
			Title:       "HA Manager Rebuild Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    602,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "group_state",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "bulletin_board",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
}

// --- JCAPool ---

// JCAPoolOperationsValues defines the type-safe values for JCAPool.Operations context
type JCAPoolOperationsValues struct {
	Create   int64
	Close    int64
	Allocate int64
	Freed    int64
	Faults   int64
}

// JCAPoolOperationsContext provides type-safe operations for JCAPool.Operations context
type JCAPoolOperationsContext struct {
	framework.Context[JCAPoolLabels]
}

// Set provides type-safe dimension setting for JCAPool.Operations context
func (c JCAPoolOperationsContext) Set(state *framework.CollectorState, labels JCAPoolLabels, values JCAPoolOperationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"create":   values.Create,
		"close":    values.Close,
		"allocate": values.Allocate,
		"freed":    values.Freed,
		"faults":   values.Faults,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAPoolOperationsContext) SetUpdateEvery(state *framework.CollectorState, labels JCAPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAPoolManagedValues defines the type-safe values for JCAPool.Managed context
type JCAPoolManagedValues struct {
	Managed_connections int64
	Connection_handles  int64
}

// JCAPoolManagedContext provides type-safe operations for JCAPool.Managed context
type JCAPoolManagedContext struct {
	framework.Context[JCAPoolLabels]
}

// Set provides type-safe dimension setting for JCAPool.Managed context
func (c JCAPoolManagedContext) Set(state *framework.CollectorState, labels JCAPoolLabels, values JCAPoolManagedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"managed_connections": values.Managed_connections,
		"connection_handles":  values.Connection_handles,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAPoolManagedContext) SetUpdateEvery(state *framework.CollectorState, labels JCAPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAPoolUtilizationValues defines the type-safe values for JCAPool.Utilization context
type JCAPoolUtilizationValues struct {
	Percent_used  int64
	Percent_maxed int64
}

// JCAPoolUtilizationContext provides type-safe operations for JCAPool.Utilization context
type JCAPoolUtilizationContext struct {
	framework.Context[JCAPoolLabels]
}

// Set provides type-safe dimension setting for JCAPool.Utilization context
func (c JCAPoolUtilizationContext) Set(state *framework.CollectorState, labels JCAPoolLabels, values JCAPoolUtilizationValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"percent_used":  values.Percent_used,
		"percent_maxed": values.Percent_maxed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAPoolUtilizationContext) SetUpdateEvery(state *framework.CollectorState, labels JCAPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAPoolWaitingValues defines the type-safe values for JCAPool.Waiting context
type JCAPoolWaitingValues struct {
	Waiting_threads int64
}

// JCAPoolWaitingContext provides type-safe operations for JCAPool.Waiting context
type JCAPoolWaitingContext struct {
	framework.Context[JCAPoolLabels]
}

// Set provides type-safe dimension setting for JCAPool.Waiting context
func (c JCAPoolWaitingContext) Set(state *framework.CollectorState, labels JCAPoolLabels, values JCAPoolWaitingValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"waiting_threads": values.Waiting_threads,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAPoolWaitingContext) SetUpdateEvery(state *framework.CollectorState, labels JCAPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAPoolLabels defines the required labels for JCAPool contexts
type JCAPoolLabels struct {
	Node     string
	Server   string
	Provider string
	Pool     string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JCAPoolLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, provider, pool
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Provider) + "_" + cleanLabelValue(l.Pool)
}

// JCAPool contains all metric contexts for JCAPool
var JCAPool = struct {
	Operations  JCAPoolOperationsContext
	Managed     JCAPoolManagedContext
	Utilization JCAPoolUtilizationContext
	Waiting     JCAPoolWaitingContext
}{
	Operations: JCAPoolOperationsContext{
		Context: framework.Context[JCAPoolLabels]{
			Name:        "websphere_pmi.jca_pool_operations",
			Family:      "connectivity/jca",
			Title:       "JCA Pool Operations",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    580,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "create",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "close",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "allocate",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "freed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "faults",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"provider",
				"pool",
			},
		},
	},
	Managed: JCAPoolManagedContext{
		Context: framework.Context[JCAPoolLabels]{
			Name:        "websphere_pmi.jca_pool_managed",
			Family:      "connectivity/jca",
			Title:       "JCA Pool Managed Resources",
			Units:       "resources",
			Type:        module.Line,
			Priority:    581,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "managed_connections",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "connection_handles",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"provider",
				"pool",
			},
		},
	},
	Utilization: JCAPoolUtilizationContext{
		Context: framework.Context[JCAPoolLabels]{
			Name:        "websphere_pmi.jca_pool_utilization",
			Family:      "connectivity/jca",
			Title:       "JCA Pool Utilization",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    582,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "percent_used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "percent_maxed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"provider",
				"pool",
			},
		},
	},
	Waiting: JCAPoolWaitingContext{
		Context: framework.Context[JCAPoolLabels]{
			Name:        "websphere_pmi.jca_pool_waiting",
			Family:      "connectivity/jca",
			Title:       "JCA Pool Waiting Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    583,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "waiting_threads",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"provider",
				"pool",
			},
		},
	},
}

// --- JDBCPool ---

// JDBCPoolUsageValues defines the type-safe values for JDBCPool.Usage context
type JDBCPoolUsageValues struct {
	Percent_used  int64
	Percent_maxed int64
}

// JDBCPoolUsageContext provides type-safe operations for JDBCPool.Usage context
type JDBCPoolUsageContext struct {
	framework.Context[JDBCPoolLabels]
}

// Set provides type-safe dimension setting for JDBCPool.Usage context
func (c JDBCPoolUsageContext) Set(state *framework.CollectorState, labels JDBCPoolLabels, values JDBCPoolUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"percent_used":  values.Percent_used,
		"percent_maxed": values.Percent_maxed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCPoolUsageContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCPoolWaitingValues defines the type-safe values for JDBCPool.Waiting context
type JDBCPoolWaitingValues struct {
	Waiting_threads int64
}

// JDBCPoolWaitingContext provides type-safe operations for JDBCPool.Waiting context
type JDBCPoolWaitingContext struct {
	framework.Context[JDBCPoolLabels]
}

// Set provides type-safe dimension setting for JDBCPool.Waiting context
func (c JDBCPoolWaitingContext) Set(state *framework.CollectorState, labels JDBCPoolLabels, values JDBCPoolWaitingValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"waiting_threads": values.Waiting_threads,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCPoolWaitingContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCPoolConnectionsValues defines the type-safe values for JDBCPool.Connections context
type JDBCPoolConnectionsValues struct {
	Managed int64
	Handles int64
}

// JDBCPoolConnectionsContext provides type-safe operations for JDBCPool.Connections context
type JDBCPoolConnectionsContext struct {
	framework.Context[JDBCPoolLabels]
}

// Set provides type-safe dimension setting for JDBCPool.Connections context
func (c JDBCPoolConnectionsContext) Set(state *framework.CollectorState, labels JDBCPoolLabels, values JDBCPoolConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"managed": values.Managed,
		"handles": values.Handles,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCPoolConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCPoolOperationsValues defines the type-safe values for JDBCPool.Operations context
type JDBCPoolOperationsValues struct {
	Created                 int64
	Closed                  int64
	Allocated               int64
	Returned                int64
	Faults                  int64
	Prep_stmt_cache_discard int64
}

// JDBCPoolOperationsContext provides type-safe operations for JDBCPool.Operations context
type JDBCPoolOperationsContext struct {
	framework.Context[JDBCPoolLabels]
}

// Set provides type-safe dimension setting for JDBCPool.Operations context
func (c JDBCPoolOperationsContext) Set(state *framework.CollectorState, labels JDBCPoolLabels, values JDBCPoolOperationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"created":                 values.Created,
		"closed":                  values.Closed,
		"allocated":               values.Allocated,
		"returned":                values.Returned,
		"faults":                  values.Faults,
		"prep_stmt_cache_discard": values.Prep_stmt_cache_discard,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCPoolOperationsContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCPoolTimeValues defines the type-safe values for JDBCPool.Time context
type JDBCPoolTimeValues struct {
	Use  int64
	Wait int64
	Jdbc int64
}

// JDBCPoolTimeContext provides type-safe operations for JDBCPool.Time context
type JDBCPoolTimeContext struct {
	framework.Context[JDBCPoolLabels]
}

// Set provides type-safe dimension setting for JDBCPool.Time context
func (c JDBCPoolTimeContext) Set(state *framework.CollectorState, labels JDBCPoolLabels, values JDBCPoolTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"use":  values.Use,
		"wait": values.Wait,
		"jdbc": values.Jdbc,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCPoolTimeContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCPoolLabels defines the required labels for JDBCPool contexts
type JDBCPoolLabels struct {
	Node   string
	Server string
	Pool   string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JDBCPoolLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, pool
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Pool)
}

// JDBCPool contains all metric contexts for JDBCPool
var JDBCPool = struct {
	Usage       JDBCPoolUsageContext
	Waiting     JDBCPoolWaitingContext
	Connections JDBCPoolConnectionsContext
	Operations  JDBCPoolOperationsContext
	Time        JDBCPoolTimeContext
}{
	Usage: JDBCPoolUsageContext{
		Context: framework.Context[JDBCPoolLabels]{
			Name:        "websphere_pmi.jdbc_pool_usage",
			Family:      "workloads/jdbc/usage",
			Title:       "JDBC Pool Utilization",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    501,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "percent_used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "percent_maxed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"pool",
			},
		},
	},
	Waiting: JDBCPoolWaitingContext{
		Context: framework.Context[JDBCPoolLabels]{
			Name:        "websphere_pmi.jdbc_pool_waiting",
			Family:      "workloads/jdbc/wait",
			Title:       "JDBC Pool Waiting Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    502,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "waiting_threads",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"pool",
			},
		},
	},
	Connections: JDBCPoolConnectionsContext{
		Context: framework.Context[JDBCPoolLabels]{
			Name:        "websphere_pmi.jdbc_pool_connections",
			Family:      "workloads/jdbc/connections",
			Title:       "JDBC Pool Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    503,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "managed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "handles",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"pool",
			},
		},
	},
	Operations: JDBCPoolOperationsContext{
		Context: framework.Context[JDBCPoolLabels]{
			Name:        "websphere_pmi.jdbc_pool_operations",
			Family:      "workloads/jdbc/operations",
			Title:       "JDBC Pool Operations",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    504,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "created",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "closed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "allocated",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "returned",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "faults",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "prep_stmt_cache_discard",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"pool",
			},
		},
	},
	Time: JDBCPoolTimeContext{
		Context: framework.Context[JDBCPoolLabels]{
			Name:        "websphere_pmi.jdbc_pool_time",
			Family:      "workloads/jdbc/time",
			Title:       "JDBC Pool Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    505,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "use",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "wait",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "jdbc",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"pool",
			},
		},
	},
}

// --- JMSQueue ---

// JMSQueueMessagesProducedValues defines the type-safe values for JMSQueue.MessagesProduced context
type JMSQueueMessagesProducedValues struct {
	Total                  int64
	Best_effort            int64
	Express                int64
	Reliable_nonpersistent int64
	Reliable_persistent    int64
	Assured_persistent     int64
}

// JMSQueueMessagesProducedContext provides type-safe operations for JMSQueue.MessagesProduced context
type JMSQueueMessagesProducedContext struct {
	framework.Context[JMSQueueLabels]
}

// Set provides type-safe dimension setting for JMSQueue.MessagesProduced context
func (c JMSQueueMessagesProducedContext) Set(state *framework.CollectorState, labels JMSQueueLabels, values JMSQueueMessagesProducedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"total":                  values.Total,
		"best_effort":            values.Best_effort,
		"express":                values.Express,
		"reliable_nonpersistent": values.Reliable_nonpersistent,
		"reliable_persistent":    values.Reliable_persistent,
		"assured_persistent":     values.Assured_persistent,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSQueueMessagesProducedContext) SetUpdateEvery(state *framework.CollectorState, labels JMSQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSQueueMessagesConsumedValues defines the type-safe values for JMSQueue.MessagesConsumed context
type JMSQueueMessagesConsumedValues struct {
	Total                  int64
	Best_effort            int64
	Express                int64
	Reliable_nonpersistent int64
	Reliable_persistent    int64
	Assured_persistent     int64
	Expired                int64
}

// JMSQueueMessagesConsumedContext provides type-safe operations for JMSQueue.MessagesConsumed context
type JMSQueueMessagesConsumedContext struct {
	framework.Context[JMSQueueLabels]
}

// Set provides type-safe dimension setting for JMSQueue.MessagesConsumed context
func (c JMSQueueMessagesConsumedContext) Set(state *framework.CollectorState, labels JMSQueueLabels, values JMSQueueMessagesConsumedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"total":                  values.Total,
		"best_effort":            values.Best_effort,
		"express":                values.Express,
		"reliable_nonpersistent": values.Reliable_nonpersistent,
		"reliable_persistent":    values.Reliable_persistent,
		"assured_persistent":     values.Assured_persistent,
		"expired":                values.Expired,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSQueueMessagesConsumedContext) SetUpdateEvery(state *framework.CollectorState, labels JMSQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSQueueClientsValues defines the type-safe values for JMSQueue.Clients context
type JMSQueueClientsValues struct {
	Local_producers         int64
	Local_producer_attaches int64
	Local_consumers         int64
	Local_consumer_attaches int64
}

// JMSQueueClientsContext provides type-safe operations for JMSQueue.Clients context
type JMSQueueClientsContext struct {
	framework.Context[JMSQueueLabels]
}

// Set provides type-safe dimension setting for JMSQueue.Clients context
func (c JMSQueueClientsContext) Set(state *framework.CollectorState, labels JMSQueueLabels, values JMSQueueClientsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"local_producers":         values.Local_producers,
		"local_producer_attaches": values.Local_producer_attaches,
		"local_consumers":         values.Local_consumers,
		"local_consumer_attaches": values.Local_consumer_attaches,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSQueueClientsContext) SetUpdateEvery(state *framework.CollectorState, labels JMSQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSQueueStorageValues defines the type-safe values for JMSQueue.Storage context
type JMSQueueStorageValues struct {
	Available   int64
	Unavailable int64
	Oldest_age  int64
}

// JMSQueueStorageContext provides type-safe operations for JMSQueue.Storage context
type JMSQueueStorageContext struct {
	framework.Context[JMSQueueLabels]
}

// Set provides type-safe dimension setting for JMSQueue.Storage context
func (c JMSQueueStorageContext) Set(state *framework.CollectorState, labels JMSQueueLabels, values JMSQueueStorageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"available":   values.Available,
		"unavailable": values.Unavailable,
		"oldest_age":  values.Oldest_age,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSQueueStorageContext) SetUpdateEvery(state *framework.CollectorState, labels JMSQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSQueueWaitTimeValues defines the type-safe values for JMSQueue.WaitTime context
type JMSQueueWaitTimeValues struct {
	Aggregate int64
	Local     int64
}

// JMSQueueWaitTimeContext provides type-safe operations for JMSQueue.WaitTime context
type JMSQueueWaitTimeContext struct {
	framework.Context[JMSQueueLabels]
}

// Set provides type-safe dimension setting for JMSQueue.WaitTime context
func (c JMSQueueWaitTimeContext) Set(state *framework.CollectorState, labels JMSQueueLabels, values JMSQueueWaitTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"aggregate": values.Aggregate,
		"local":     values.Local,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSQueueWaitTimeContext) SetUpdateEvery(state *framework.CollectorState, labels JMSQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSQueueLabels defines the required labels for JMSQueue contexts
type JMSQueueLabels struct {
	Node        string
	Server      string
	Engine      string
	Destination string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JMSQueueLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, engine, destination
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Engine) + "_" + cleanLabelValue(l.Destination)
}

// JMSQueue contains all metric contexts for JMSQueue
var JMSQueue = struct {
	MessagesProduced JMSQueueMessagesProducedContext
	MessagesConsumed JMSQueueMessagesConsumedContext
	Clients          JMSQueueClientsContext
	Storage          JMSQueueStorageContext
	WaitTime         JMSQueueWaitTimeContext
}{
	MessagesProduced: JMSQueueMessagesProducedContext{
		Context: framework.Context[JMSQueueLabels]{
			Name:        "websphere_pmi.jms_queue_messages_produced",
			Family:      "messaging/jms/queues",
			Title:       "JMS Queue Messages Produced",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    700,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "best_effort",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "express",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "reliable_nonpersistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "reliable_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "assured_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	MessagesConsumed: JMSQueueMessagesConsumedContext{
		Context: framework.Context[JMSQueueLabels]{
			Name:        "websphere_pmi.jms_queue_messages_consumed",
			Family:      "messaging/jms/queues",
			Title:       "JMS Queue Messages Consumed",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    701,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "best_effort",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "express",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "reliable_nonpersistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "reliable_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "assured_persistent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "expired",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	Clients: JMSQueueClientsContext{
		Context: framework.Context[JMSQueueLabels]{
			Name:        "websphere_pmi.jms_queue_clients",
			Family:      "messaging/jms/queues",
			Title:       "JMS Queue Clients",
			Units:       "clients",
			Type:        module.Line,
			Priority:    702,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "local_producers",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_producer_attaches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_consumers",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_consumer_attaches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	Storage: JMSQueueStorageContext{
		Context: framework.Context[JMSQueueLabels]{
			Name:        "websphere_pmi.jms_queue_storage",
			Family:      "messaging/jms/queues",
			Title:       "JMS Queue Storage",
			Units:       "messages",
			Type:        module.Line,
			Priority:    703,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "available",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "unavailable",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "oldest_age",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	WaitTime: JMSQueueWaitTimeContext{
		Context: framework.Context[JMSQueueLabels]{
			Name:        "websphere_pmi.jms_queue_wait_time",
			Family:      "messaging/jms/queues",
			Title:       "JMS Queue Wait Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    704,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "aggregate",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
}

// --- JMSStore ---

// JMSStoreCacheValues defines the type-safe values for JMSStore.Cache context
type JMSStoreCacheValues struct {
	Add_stored         int64
	Add_not_stored     int64
	Stored_current     int64
	Stored_bytes       int64
	Not_stored_current int64
	Not_stored_bytes   int64
	Discard_count      int64
	Discard_bytes      int64
}

// JMSStoreCacheContext provides type-safe operations for JMSStore.Cache context
type JMSStoreCacheContext struct {
	framework.Context[JMSStoreLabels]
}

// Set provides type-safe dimension setting for JMSStore.Cache context
func (c JMSStoreCacheContext) Set(state *framework.CollectorState, labels JMSStoreLabels, values JMSStoreCacheValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"add_stored":         values.Add_stored,
		"add_not_stored":     values.Add_not_stored,
		"stored_current":     values.Stored_current,
		"stored_bytes":       values.Stored_bytes,
		"not_stored_current": values.Not_stored_current,
		"not_stored_bytes":   values.Not_stored_bytes,
		"discard_count":      values.Discard_count,
		"discard_bytes":      values.Discard_bytes,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSStoreCacheContext) SetUpdateEvery(state *framework.CollectorState, labels JMSStoreLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSStoreDatastoreValues defines the type-safe values for JMSStore.Datastore context
type JMSStoreDatastoreValues struct {
	Insert_batches int64
	Update_batches int64
	Delete_batches int64
	Insert_count   int64
	Update_count   int64
	Delete_count   int64
	Open_count     int64
	Abort_count    int64
	Transaction_ms int64
}

// JMSStoreDatastoreContext provides type-safe operations for JMSStore.Datastore context
type JMSStoreDatastoreContext struct {
	framework.Context[JMSStoreLabels]
}

// Set provides type-safe dimension setting for JMSStore.Datastore context
func (c JMSStoreDatastoreContext) Set(state *framework.CollectorState, labels JMSStoreLabels, values JMSStoreDatastoreValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"insert_batches": values.Insert_batches,
		"update_batches": values.Update_batches,
		"delete_batches": values.Delete_batches,
		"insert_count":   values.Insert_count,
		"update_count":   values.Update_count,
		"delete_count":   values.Delete_count,
		"open_count":     values.Open_count,
		"abort_count":    values.Abort_count,
		"transaction_ms": values.Transaction_ms,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSStoreDatastoreContext) SetUpdateEvery(state *framework.CollectorState, labels JMSStoreLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSStoreTransactionsValues defines the type-safe values for JMSStore.Transactions context
type JMSStoreTransactionsValues struct {
	Global_start   int64
	Global_commit  int64
	Global_abort   int64
	Global_indoubt int64
	Local_start    int64
	Local_commit   int64
	Local_abort    int64
}

// JMSStoreTransactionsContext provides type-safe operations for JMSStore.Transactions context
type JMSStoreTransactionsContext struct {
	framework.Context[JMSStoreLabels]
}

// Set provides type-safe dimension setting for JMSStore.Transactions context
func (c JMSStoreTransactionsContext) Set(state *framework.CollectorState, labels JMSStoreLabels, values JMSStoreTransactionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"global_start":   values.Global_start,
		"global_commit":  values.Global_commit,
		"global_abort":   values.Global_abort,
		"global_indoubt": values.Global_indoubt,
		"local_start":    values.Local_start,
		"local_commit":   values.Local_commit,
		"local_abort":    values.Local_abort,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSStoreTransactionsContext) SetUpdateEvery(state *framework.CollectorState, labels JMSStoreLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSStoreExpiryValues defines the type-safe values for JMSStore.Expiry context
type JMSStoreExpiryValues struct {
	Index_items int64
}

// JMSStoreExpiryContext provides type-safe operations for JMSStore.Expiry context
type JMSStoreExpiryContext struct {
	framework.Context[JMSStoreLabels]
}

// Set provides type-safe dimension setting for JMSStore.Expiry context
func (c JMSStoreExpiryContext) Set(state *framework.CollectorState, labels JMSStoreLabels, values JMSStoreExpiryValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"index_items": values.Index_items,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSStoreExpiryContext) SetUpdateEvery(state *framework.CollectorState, labels JMSStoreLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSStoreLabels defines the required labels for JMSStore contexts
type JMSStoreLabels struct {
	Node    string
	Server  string
	Engine  string
	Section string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JMSStoreLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, engine, section
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Engine) + "_" + cleanLabelValue(l.Section)
}

// JMSStore contains all metric contexts for JMSStore
var JMSStore = struct {
	Cache        JMSStoreCacheContext
	Datastore    JMSStoreDatastoreContext
	Transactions JMSStoreTransactionsContext
	Expiry       JMSStoreExpiryContext
}{
	Cache: JMSStoreCacheContext{
		Context: framework.Context[JMSStoreLabels]{
			Name:        "websphere_pmi.jms_store_cache",
			Family:      "messaging/jms/store",
			Title:       "JMS Store Cache",
			Units:       "events",
			Type:        module.Line,
			Priority:    740,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "add_stored",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "add_not_stored",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "stored_current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "stored_bytes",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "not_stored_current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "not_stored_bytes",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "discard_count",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "discard_bytes",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"section",
			},
		},
	},
	Datastore: JMSStoreDatastoreContext{
		Context: framework.Context[JMSStoreLabels]{
			Name:        "websphere_pmi.jms_store_datastore",
			Family:      "messaging/jms/store",
			Title:       "JMS Store Datastore Operations",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    741,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "insert_batches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "update_batches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "delete_batches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "insert_count",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "update_count",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "delete_count",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "open_count",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "abort_count",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "transaction_ms",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"section",
			},
		},
	},
	Transactions: JMSStoreTransactionsContext{
		Context: framework.Context[JMSStoreLabels]{
			Name:        "websphere_pmi.jms_store_transactions",
			Family:      "messaging/jms/store",
			Title:       "JMS Store Transactions",
			Units:       "transactions/s",
			Type:        module.Line,
			Priority:    742,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "global_start",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_commit",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_abort",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_indoubt",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_start",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_commit",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_abort",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"section",
			},
		},
	},
	Expiry: JMSStoreExpiryContext{
		Context: framework.Context[JMSStoreLabels]{
			Name:        "websphere_pmi.jms_store_expiry",
			Family:      "messaging/jms/store",
			Title:       "JMS Store Expiry Index",
			Units:       "items",
			Type:        module.Line,
			Priority:    743,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "index_items",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"section",
			},
		},
	},
}

// --- JMSTopic ---

// JMSTopicPublicationsValues defines the type-safe values for JMSTopic.Publications context
type JMSTopicPublicationsValues struct {
	Assured     int64
	Best_effort int64
	Express     int64
}

// JMSTopicPublicationsContext provides type-safe operations for JMSTopic.Publications context
type JMSTopicPublicationsContext struct {
	framework.Context[JMSTopicLabels]
}

// Set provides type-safe dimension setting for JMSTopic.Publications context
func (c JMSTopicPublicationsContext) Set(state *framework.CollectorState, labels JMSTopicLabels, values JMSTopicPublicationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"assured":     values.Assured,
		"best_effort": values.Best_effort,
		"express":     values.Express,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSTopicPublicationsContext) SetUpdateEvery(state *framework.CollectorState, labels JMSTopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSTopicSubscriptionHitsValues defines the type-safe values for JMSTopic.SubscriptionHits context
type JMSTopicSubscriptionHitsValues struct {
	Assured     int64
	Best_effort int64
	Express     int64
}

// JMSTopicSubscriptionHitsContext provides type-safe operations for JMSTopic.SubscriptionHits context
type JMSTopicSubscriptionHitsContext struct {
	framework.Context[JMSTopicLabels]
}

// Set provides type-safe dimension setting for JMSTopic.SubscriptionHits context
func (c JMSTopicSubscriptionHitsContext) Set(state *framework.CollectorState, labels JMSTopicLabels, values JMSTopicSubscriptionHitsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"assured":     values.Assured,
		"best_effort": values.Best_effort,
		"express":     values.Express,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSTopicSubscriptionHitsContext) SetUpdateEvery(state *framework.CollectorState, labels JMSTopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSTopicSubscriptionsValues defines the type-safe values for JMSTopic.Subscriptions context
type JMSTopicSubscriptionsValues struct {
	Durable_local int64
}

// JMSTopicSubscriptionsContext provides type-safe operations for JMSTopic.Subscriptions context
type JMSTopicSubscriptionsContext struct {
	framework.Context[JMSTopicLabels]
}

// Set provides type-safe dimension setting for JMSTopic.Subscriptions context
func (c JMSTopicSubscriptionsContext) Set(state *framework.CollectorState, labels JMSTopicLabels, values JMSTopicSubscriptionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"durable_local": values.Durable_local,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSTopicSubscriptionsContext) SetUpdateEvery(state *framework.CollectorState, labels JMSTopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSTopicEventsValues defines the type-safe values for JMSTopic.Events context
type JMSTopicEventsValues struct {
	Incomplete_publications int64
	Publisher_attaches      int64
	Subscriber_attaches     int64
}

// JMSTopicEventsContext provides type-safe operations for JMSTopic.Events context
type JMSTopicEventsContext struct {
	framework.Context[JMSTopicLabels]
}

// Set provides type-safe dimension setting for JMSTopic.Events context
func (c JMSTopicEventsContext) Set(state *framework.CollectorState, labels JMSTopicLabels, values JMSTopicEventsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"incomplete_publications": values.Incomplete_publications,
		"publisher_attaches":      values.Publisher_attaches,
		"subscriber_attaches":     values.Subscriber_attaches,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSTopicEventsContext) SetUpdateEvery(state *framework.CollectorState, labels JMSTopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSTopicAgeValues defines the type-safe values for JMSTopic.Age context
type JMSTopicAgeValues struct {
	Local_oldest int64
}

// JMSTopicAgeContext provides type-safe operations for JMSTopic.Age context
type JMSTopicAgeContext struct {
	framework.Context[JMSTopicLabels]
}

// Set provides type-safe dimension setting for JMSTopic.Age context
func (c JMSTopicAgeContext) Set(state *framework.CollectorState, labels JMSTopicLabels, values JMSTopicAgeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"local_oldest": values.Local_oldest,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSTopicAgeContext) SetUpdateEvery(state *framework.CollectorState, labels JMSTopicLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSTopicLabels defines the required labels for JMSTopic contexts
type JMSTopicLabels struct {
	Node        string
	Server      string
	Engine      string
	Destination string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JMSTopicLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, engine, destination
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Engine) + "_" + cleanLabelValue(l.Destination)
}

// JMSTopic contains all metric contexts for JMSTopic
var JMSTopic = struct {
	Publications     JMSTopicPublicationsContext
	SubscriptionHits JMSTopicSubscriptionHitsContext
	Subscriptions    JMSTopicSubscriptionsContext
	Events           JMSTopicEventsContext
	Age              JMSTopicAgeContext
}{
	Publications: JMSTopicPublicationsContext{
		Context: framework.Context[JMSTopicLabels]{
			Name:        "websphere_pmi.jms_topic_publications",
			Family:      "messaging/jms/topics",
			Title:       "JMS Topic Publications",
			Units:       "messages/s",
			Type:        module.Line,
			Priority:    720,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "assured",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "best_effort",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "express",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	SubscriptionHits: JMSTopicSubscriptionHitsContext{
		Context: framework.Context[JMSTopicLabels]{
			Name:        "websphere_pmi.jms_topic_subscription_hits",
			Family:      "messaging/jms/topics",
			Title:       "JMS Topic Subscription Hits",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    721,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "assured",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "best_effort",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "express",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	Subscriptions: JMSTopicSubscriptionsContext{
		Context: framework.Context[JMSTopicLabels]{
			Name:        "websphere_pmi.jms_topic_subscriptions",
			Family:      "messaging/jms/topics",
			Title:       "JMS Topic Subscriptions",
			Units:       "subscriptions",
			Type:        module.Line,
			Priority:    722,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "durable_local",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	Events: JMSTopicEventsContext{
		Context: framework.Context[JMSTopicLabels]{
			Name:        "websphere_pmi.jms_topic_events",
			Family:      "messaging/jms/topics",
			Title:       "JMS Topic Events",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    723,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "incomplete_publications",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "publisher_attaches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "subscriber_attaches",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
	Age: JMSTopicAgeContext{
		Context: framework.Context[JMSTopicLabels]{
			Name:        "websphere_pmi.jms_topic_age",
			Family:      "messaging/jms/topics",
			Title:       "JMS Topic Oldest Publication Age",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    724,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "local_oldest",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"engine",
				"destination",
			},
		},
	},
}

// --- JVM ---

// JVMHeapUsageValues defines the type-safe values for JVM.HeapUsage context
type JVMHeapUsageValues struct {
	Used int64
	Free int64
}

// JVMHeapUsageContext provides type-safe operations for JVM.HeapUsage context
type JVMHeapUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapUsage context
func (c JVMHeapUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"used": values.Used,
		"free": values.Free,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMHeapCommittedValues defines the type-safe values for JVM.HeapCommitted context
type JVMHeapCommittedValues struct {
	Committed int64
}

// JVMHeapCommittedContext provides type-safe operations for JVM.HeapCommitted context
type JVMHeapCommittedContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapCommitted context
func (c JVMHeapCommittedContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapCommittedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"committed": values.Committed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapCommittedContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMHeapMaxValues defines the type-safe values for JVM.HeapMax context
type JVMHeapMaxValues struct {
	Limit int64
}

// JVMHeapMaxContext provides type-safe operations for JVM.HeapMax context
type JVMHeapMaxContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapMax context
func (c JVMHeapMaxContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapMaxValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"limit": values.Limit,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapMaxContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMUptimeValues defines the type-safe values for JVM.Uptime context
type JVMUptimeValues struct {
	Uptime int64
}

// JVMUptimeContext provides type-safe operations for JVM.Uptime context
type JVMUptimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.Uptime context
func (c JVMUptimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMUptimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"uptime": values.Uptime,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMUptimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMCPUValues defines the type-safe values for JVM.CPU context
type JVMCPUValues struct {
	Usage int64
}

// JVMCPUContext provides type-safe operations for JVM.CPU context
type JVMCPUContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.CPU context
func (c JVMCPUContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMCPUValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"usage": values.Usage,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMCPUContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMGCCollectionsValues defines the type-safe values for JVM.GCCollections context
type JVMGCCollectionsValues struct {
	Collections int64
}

// JVMGCCollectionsContext provides type-safe operations for JVM.GCCollections context
type JVMGCCollectionsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.GCCollections context
func (c JVMGCCollectionsContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMGCCollectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"collections": values.Collections,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMGCCollectionsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMGCTimeValues defines the type-safe values for JVM.GCTime context
type JVMGCTimeValues struct {
	Total int64
}

// JVMGCTimeContext provides type-safe operations for JVM.GCTime context
type JVMGCTimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.GCTime context
func (c JVMGCTimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMGCTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMGCTimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMThreadsValues defines the type-safe values for JVM.Threads context
type JVMThreadsValues struct {
	Daemon int64
	Other  int64
}

// JVMThreadsContext provides type-safe operations for JVM.Threads context
type JVMThreadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.Threads context
func (c JVMThreadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"daemon": values.Daemon,
		"other":  values.Other,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMThreadPeakValues defines the type-safe values for JVM.ThreadPeak context
type JVMThreadPeakValues struct {
	Peak int64
}

// JVMThreadPeakContext provides type-safe operations for JVM.ThreadPeak context
type JVMThreadPeakContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.ThreadPeak context
func (c JVMThreadPeakContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMThreadPeakValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"peak": values.Peak,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMThreadPeakContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVM contains all metric contexts for JVM
var JVM = struct {
	HeapUsage     JVMHeapUsageContext
	HeapCommitted JVMHeapCommittedContext
	HeapMax       JVMHeapMaxContext
	Uptime        JVMUptimeContext
	CPU           JVMCPUContext
	GCCollections JVMGCCollectionsContext
	GCTime        JVMGCTimeContext
	Threads       JVMThreadsContext
	ThreadPeak    JVMThreadPeakContext
}{
	HeapUsage: JVMHeapUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_heap_usage",
			Family:      "memory/heap",
			Title:       "JVM Heap Memory Usage",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    201,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "free",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	HeapCommitted: JVMHeapCommittedContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_heap_committed",
			Family:      "memory/heap",
			Title:       "JVM Heap Committed",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    202,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "committed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	HeapMax: JVMHeapMaxContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_heap_max",
			Family:      "memory/heap",
			Title:       "JVM Heap Maximum",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    203,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "limit",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Uptime: JVMUptimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_uptime",
			Family:      "compute/runtime",
			Title:       "JVM Uptime",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    210,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "uptime",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	CPU: JVMCPUContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_cpu",
			Family:      "compute/cpu",
			Title:       "JVM CPU Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    211,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "usage",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	GCCollections: JVMGCCollectionsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_gc_collections",
			Family:      "compute/gc",
			Title:       "JVM GC Collections",
			Units:       "collections/s",
			Type:        module.Line,
			Priority:    220,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "collections",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	GCTime: JVMGCTimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_gc_time",
			Family:      "compute/gc",
			Title:       "JVM GC Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    221,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Threads: JVMThreadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_threads",
			Family:      "compute/threads",
			Title:       "JVM Threads",
			Units:       "threads",
			Type:        module.Stacked,
			Priority:    230,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "daemon",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "other",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ThreadPeak: JVMThreadPeakContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.jvm_threads_peak",
			Family:      "compute/threads",
			Title:       "JVM Peak Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    231,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "peak",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- ORB ---

// ORBConcurrentValues defines the type-safe values for ORB.Concurrent context
type ORBConcurrentValues struct {
	Concurrent_requests int64
}

// ORBConcurrentContext provides type-safe operations for ORB.Concurrent context
type ORBConcurrentContext struct {
	framework.Context[ORBLabels]
}

// Set provides type-safe dimension setting for ORB.Concurrent context
func (c ORBConcurrentContext) Set(state *framework.CollectorState, labels ORBLabels, values ORBConcurrentValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"concurrent_requests": values.Concurrent_requests,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ORBConcurrentContext) SetUpdateEvery(state *framework.CollectorState, labels ORBLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ORBRequestsValues defines the type-safe values for ORB.Requests context
type ORBRequestsValues struct {
	Requests int64
}

// ORBRequestsContext provides type-safe operations for ORB.Requests context
type ORBRequestsContext struct {
	framework.Context[ORBLabels]
}

// Set provides type-safe dimension setting for ORB.Requests context
func (c ORBRequestsContext) Set(state *framework.CollectorState, labels ORBLabels, values ORBRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"requests": values.Requests,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ORBRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels ORBLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ORBLabels defines the required labels for ORB contexts
type ORBLabels struct {
	Node   string
	Server string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ORBLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server)
}

// ORB contains all metric contexts for ORB
var ORB = struct {
	Concurrent ORBConcurrentContext
	Requests   ORBRequestsContext
}{
	Concurrent: ORBConcurrentContext{
		Context: framework.Context[ORBLabels]{
			Name:        "websphere_pmi.orb_concurrent",
			Family:      "workloads/orb",
			Title:       "ORB Concurrent Requests",
			Units:       "requests",
			Type:        module.Line,
			Priority:    570,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "concurrent_requests",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
	Requests: ORBRequestsContext{
		Context: framework.Context[ORBLabels]{
			Name:        "websphere_pmi.orb_requests",
			Family:      "workloads/orb",
			Title:       "ORB Requests",
			Units:       "requests/s",
			Type:        module.Line,
			Priority:    571,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "requests",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
}

// --- ObjectPool ---

// ObjectPoolOperationsValues defines the type-safe values for ObjectPool.Operations context
type ObjectPoolOperationsValues struct {
	Created int64
}

// ObjectPoolOperationsContext provides type-safe operations for ObjectPool.Operations context
type ObjectPoolOperationsContext struct {
	framework.Context[ObjectPoolLabels]
}

// Set provides type-safe dimension setting for ObjectPool.Operations context
func (c ObjectPoolOperationsContext) Set(state *framework.CollectorState, labels ObjectPoolLabels, values ObjectPoolOperationsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"created": values.Created,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ObjectPoolOperationsContext) SetUpdateEvery(state *framework.CollectorState, labels ObjectPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ObjectPoolSizeValues defines the type-safe values for ObjectPool.Size context
type ObjectPoolSizeValues struct {
	Allocated int64
	Returned  int64
	Idle      int64
}

// ObjectPoolSizeContext provides type-safe operations for ObjectPool.Size context
type ObjectPoolSizeContext struct {
	framework.Context[ObjectPoolLabels]
}

// Set provides type-safe dimension setting for ObjectPool.Size context
func (c ObjectPoolSizeContext) Set(state *framework.CollectorState, labels ObjectPoolLabels, values ObjectPoolSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"allocated": values.Allocated,
		"returned":  values.Returned,
		"idle":      values.Idle,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ObjectPoolSizeContext) SetUpdateEvery(state *framework.CollectorState, labels ObjectPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ObjectPoolLabels defines the required labels for ObjectPool contexts
type ObjectPoolLabels struct {
	Node   string
	Server string
	Pool   string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ObjectPoolLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, pool
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Pool)
}

// ObjectPool contains all metric contexts for ObjectPool
var ObjectPool = struct {
	Operations ObjectPoolOperationsContext
	Size       ObjectPoolSizeContext
}{
	Operations: ObjectPoolOperationsContext{
		Context: framework.Context[ObjectPoolLabels]{
			Name:        "websphere_pmi.object_pool_operations",
			Family:      "workloads/object_pool",
			Title:       "Object Pool Operations",
			Units:       "operations/s",
			Type:        module.Line,
			Priority:    630,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "created",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"pool",
			},
		},
	},
	Size: ObjectPoolSizeContext{
		Context: framework.Context[ObjectPoolLabels]{
			Name:        "websphere_pmi.object_pool_size",
			Family:      "workloads/object_pool",
			Title:       "Object Pool Size",
			Units:       "objects",
			Type:        module.Line,
			Priority:    631,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "allocated",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "returned",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "idle",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"pool",
			},
		},
	},
}

// --- PMIWebServiceModule ---

// PMIWebServiceModuleServicesValues defines the type-safe values for PMIWebServiceModule.Services context
type PMIWebServiceModuleServicesValues struct {
	Loaded int64
}

// PMIWebServiceModuleServicesContext provides type-safe operations for PMIWebServiceModule.Services context
type PMIWebServiceModuleServicesContext struct {
	framework.Context[PMIWebServiceModuleLabels]
}

// Set provides type-safe dimension setting for PMIWebServiceModule.Services context
func (c PMIWebServiceModuleServicesContext) Set(state *framework.CollectorState, labels PMIWebServiceModuleLabels, values PMIWebServiceModuleServicesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"loaded": values.Loaded,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PMIWebServiceModuleServicesContext) SetUpdateEvery(state *framework.CollectorState, labels PMIWebServiceModuleLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PMIWebServiceModuleLabels defines the required labels for PMIWebServiceModule contexts
type PMIWebServiceModuleLabels struct {
	Node   string
	Server string
	Module string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l PMIWebServiceModuleLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, module
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Module)
}

// PMIWebServiceModule contains all metric contexts for PMIWebServiceModule
var PMIWebServiceModule = struct {
	Services PMIWebServiceModuleServicesContext
}{
	Services: PMIWebServiceModuleServicesContext{
		Context: framework.Context[PMIWebServiceModuleLabels]{
			Name:        "websphere_pmi.pmi_web_service_module_services",
			Family:      "integration/web_services",
			Title:       "PMI Web Service Module Services",
			Units:       "services",
			Type:        module.Line,
			Priority:    652,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "loaded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"module",
			},
		},
	},
}

// --- Portlet ---

// PortletRequestsValues defines the type-safe values for Portlet.Requests context
type PortletRequestsValues struct {
	Requests int64
}

// PortletRequestsContext provides type-safe operations for Portlet.Requests context
type PortletRequestsContext struct {
	framework.Context[PortletLabels]
}

// Set provides type-safe dimension setting for Portlet.Requests context
func (c PortletRequestsContext) Set(state *framework.CollectorState, labels PortletLabels, values PortletRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"requests": values.Requests,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PortletRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels PortletLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PortletConcurrentValues defines the type-safe values for Portlet.Concurrent context
type PortletConcurrentValues struct {
	Concurrent int64
}

// PortletConcurrentContext provides type-safe operations for Portlet.Concurrent context
type PortletConcurrentContext struct {
	framework.Context[PortletLabels]
}

// Set provides type-safe dimension setting for Portlet.Concurrent context
func (c PortletConcurrentContext) Set(state *framework.CollectorState, labels PortletLabels, values PortletConcurrentValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"concurrent": values.Concurrent,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PortletConcurrentContext) SetUpdateEvery(state *framework.CollectorState, labels PortletLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PortletErrorsValues defines the type-safe values for Portlet.Errors context
type PortletErrorsValues struct {
	Errors int64
}

// PortletErrorsContext provides type-safe operations for Portlet.Errors context
type PortletErrorsContext struct {
	framework.Context[PortletLabels]
}

// Set provides type-safe dimension setting for Portlet.Errors context
func (c PortletErrorsContext) Set(state *framework.CollectorState, labels PortletLabels, values PortletErrorsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"errors": values.Errors,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PortletErrorsContext) SetUpdateEvery(state *framework.CollectorState, labels PortletLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PortletResponseTimeValues defines the type-safe values for Portlet.ResponseTime context
type PortletResponseTimeValues struct {
	Render         int64
	Action         int64
	Process_event  int64
	Serve_resource int64
}

// PortletResponseTimeContext provides type-safe operations for Portlet.ResponseTime context
type PortletResponseTimeContext struct {
	framework.Context[PortletLabels]
}

// Set provides type-safe dimension setting for Portlet.ResponseTime context
func (c PortletResponseTimeContext) Set(state *framework.CollectorState, labels PortletLabels, values PortletResponseTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"render":         values.Render,
		"action":         values.Action,
		"process_event":  values.Process_event,
		"serve_resource": values.Serve_resource,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PortletResponseTimeContext) SetUpdateEvery(state *framework.CollectorState, labels PortletLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PortletLabels defines the required labels for Portlet contexts
type PortletLabels struct {
	Node    string
	Server  string
	Portlet string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l PortletLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, portlet
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Portlet)
}

// Portlet contains all metric contexts for Portlet
var Portlet = struct {
	Requests     PortletRequestsContext
	Concurrent   PortletConcurrentContext
	Errors       PortletErrorsContext
	ResponseTime PortletResponseTimeContext
}{
	Requests: PortletRequestsContext{
		Context: framework.Context[PortletLabels]{
			Name:        "websphere_pmi.portlet_requests",
			Family:      "platform/portlets",
			Title:       "Portlet Requests",
			Units:       "requests/s",
			Type:        module.Line,
			Priority:    801,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "requests",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"portlet",
			},
		},
	},
	Concurrent: PortletConcurrentContext{
		Context: framework.Context[PortletLabels]{
			Name:        "websphere_pmi.portlet_concurrent",
			Family:      "platform/portlets",
			Title:       "Portlet Concurrent Requests",
			Units:       "requests",
			Type:        module.Line,
			Priority:    802,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "concurrent",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"portlet",
			},
		},
	},
	Errors: PortletErrorsContext{
		Context: framework.Context[PortletLabels]{
			Name:        "websphere_pmi.portlet_errors",
			Family:      "platform/portlets",
			Title:       "Portlet Errors",
			Units:       "errors/s",
			Type:        module.Line,
			Priority:    803,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "errors",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"portlet",
			},
		},
	},
	ResponseTime: PortletResponseTimeContext{
		Context: framework.Context[PortletLabels]{
			Name:        "websphere_pmi.portlet_response_time",
			Family:      "platform/portlets",
			Title:       "Portlet Response Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    804,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "render",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "action",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "process_event",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "serve_resource",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"portlet",
			},
		},
	},
}

// --- PortletApplication ---

// PortletApplicationLoadedValues defines the type-safe values for PortletApplication.Loaded context
type PortletApplicationLoadedValues struct {
	Loaded int64
}

// PortletApplicationLoadedContext provides type-safe operations for PortletApplication.Loaded context
type PortletApplicationLoadedContext struct {
	framework.Context[PortletApplicationLabels]
}

// Set provides type-safe dimension setting for PortletApplication.Loaded context
func (c PortletApplicationLoadedContext) Set(state *framework.CollectorState, labels PortletApplicationLabels, values PortletApplicationLoadedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"loaded": values.Loaded,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PortletApplicationLoadedContext) SetUpdateEvery(state *framework.CollectorState, labels PortletApplicationLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PortletApplicationLabels defines the required labels for PortletApplication contexts
type PortletApplicationLabels struct {
	Node   string
	Server string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l PortletApplicationLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server)
}

// PortletApplication contains all metric contexts for PortletApplication
var PortletApplication = struct {
	Loaded PortletApplicationLoadedContext
}{
	Loaded: PortletApplicationLoadedContext{
		Context: framework.Context[PortletApplicationLabels]{
			Name:        "websphere_pmi.portlet_application_loaded",
			Family:      "platform/portlets",
			Title:       "Loaded Portlets",
			Units:       "portlets",
			Type:        module.Line,
			Priority:    800,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "loaded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
}

// --- Schedulers ---

// SchedulersActivityValues defines the type-safe values for Schedulers.Activity context
type SchedulersActivityValues struct {
	Finished int64
	Failures int64
	Polls    int64
}

// SchedulersActivityContext provides type-safe operations for Schedulers.Activity context
type SchedulersActivityContext struct {
	framework.Context[SchedulersLabels]
}

// Set provides type-safe dimension setting for Schedulers.Activity context
func (c SchedulersActivityContext) Set(state *framework.CollectorState, labels SchedulersLabels, values SchedulersActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"finished": values.Finished,
		"failures": values.Failures,
		"polls":    values.Polls,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SchedulersActivityContext) SetUpdateEvery(state *framework.CollectorState, labels SchedulersLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SchedulersLabels defines the required labels for Schedulers contexts
type SchedulersLabels struct {
	Node      string
	Server    string
	Scheduler string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l SchedulersLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, scheduler
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Scheduler)
}

// Schedulers contains all metric contexts for Schedulers
var Schedulers = struct {
	Activity SchedulersActivityContext
}{
	Activity: SchedulersActivityContext{
		Context: framework.Context[SchedulersLabels]{
			Name:        "websphere_pmi.scheduler_activity",
			Family:      "workloads/schedulers",
			Title:       "Scheduler Activity",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    620,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "finished",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "failures",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "polls",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"scheduler",
			},
		},
	},
}

// --- SecurityAuth ---

// SecurityAuthCountsValues defines the type-safe values for SecurityAuth.Counts context
type SecurityAuthCountsValues struct {
	Web           int64
	Tai           int64
	Identity      int64
	Basic         int64
	Token         int64
	Jaas_identity int64
	Jaas_basic    int64
	Jaas_token    int64
	Rmi           int64
}

// SecurityAuthCountsContext provides type-safe operations for SecurityAuth.Counts context
type SecurityAuthCountsContext struct {
	framework.Context[SecurityAuthLabels]
}

// Set provides type-safe dimension setting for SecurityAuth.Counts context
func (c SecurityAuthCountsContext) Set(state *framework.CollectorState, labels SecurityAuthLabels, values SecurityAuthCountsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"web":           values.Web,
		"tai":           values.Tai,
		"identity":      values.Identity,
		"basic":         values.Basic,
		"token":         values.Token,
		"jaas_identity": values.Jaas_identity,
		"jaas_basic":    values.Jaas_basic,
		"jaas_token":    values.Jaas_token,
		"rmi":           values.Rmi,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SecurityAuthCountsContext) SetUpdateEvery(state *framework.CollectorState, labels SecurityAuthLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SecurityAuthLabels defines the required labels for SecurityAuth contexts
type SecurityAuthLabels struct {
	Node   string
	Server string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l SecurityAuthLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server)
}

// SecurityAuth contains all metric contexts for SecurityAuth
var SecurityAuth = struct {
	Counts SecurityAuthCountsContext
}{
	Counts: SecurityAuthCountsContext{
		Context: framework.Context[SecurityAuthLabels]{
			Name:        "websphere_pmi.security_auth_counts",
			Family:      "security/authentication",
			Title:       "Security Authentication Counts",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    560,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "web",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "tai",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "identity",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "basic",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "token",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "jaas_identity",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "jaas_basic",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "jaas_token",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "rmi",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
}

// --- SecurityAuthz ---

// SecurityAuthzTimeValues defines the type-safe values for SecurityAuthz.Time context
type SecurityAuthzTimeValues struct {
	Web   int64
	Ejb   int64
	Admin int64
	Cwwja int64
}

// SecurityAuthzTimeContext provides type-safe operations for SecurityAuthz.Time context
type SecurityAuthzTimeContext struct {
	framework.Context[SecurityAuthzLabels]
}

// Set provides type-safe dimension setting for SecurityAuthz.Time context
func (c SecurityAuthzTimeContext) Set(state *framework.CollectorState, labels SecurityAuthzLabels, values SecurityAuthzTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"web":   values.Web,
		"ejb":   values.Ejb,
		"admin": values.Admin,
		"cwwja": values.Cwwja,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SecurityAuthzTimeContext) SetUpdateEvery(state *framework.CollectorState, labels SecurityAuthzLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SecurityAuthzLabels defines the required labels for SecurityAuthz contexts
type SecurityAuthzLabels struct {
	Node   string
	Server string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l SecurityAuthzLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server)
}

// SecurityAuthz contains all metric contexts for SecurityAuthz
var SecurityAuthz = struct {
	Time SecurityAuthzTimeContext
}{
	Time: SecurityAuthzTimeContext{
		Context: framework.Context[SecurityAuthzLabels]{
			Name:        "websphere_pmi.security_authz_time",
			Family:      "security/authorization",
			Title:       "Security Authorization Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    561,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "web",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "ejb",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "admin",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "cwwja",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
}

// --- SessionManager ---

// SessionManagerActiveValues defines the type-safe values for SessionManager.Active context
type SessionManagerActiveValues struct {
	Active int64
	Live   int64
}

// SessionManagerActiveContext provides type-safe operations for SessionManager.Active context
type SessionManagerActiveContext struct {
	framework.Context[SessionManagerLabels]
}

// Set provides type-safe dimension setting for SessionManager.Active context
func (c SessionManagerActiveContext) Set(state *framework.CollectorState, labels SessionManagerLabels, values SessionManagerActiveValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
		"live":   values.Live,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SessionManagerActiveContext) SetUpdateEvery(state *framework.CollectorState, labels SessionManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SessionManagerEventsValues defines the type-safe values for SessionManager.Events context
type SessionManagerEventsValues struct {
	Created               int64
	Invalidated           int64
	Timeout_invalidations int64
	Affinity_breaks       int64
	Cache_discards        int64
	No_room               int64
	Activate_non_exist    int64
}

// SessionManagerEventsContext provides type-safe operations for SessionManager.Events context
type SessionManagerEventsContext struct {
	framework.Context[SessionManagerLabels]
}

// Set provides type-safe dimension setting for SessionManager.Events context
func (c SessionManagerEventsContext) Set(state *framework.CollectorState, labels SessionManagerLabels, values SessionManagerEventsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"created":               values.Created,
		"invalidated":           values.Invalidated,
		"timeout_invalidations": values.Timeout_invalidations,
		"affinity_breaks":       values.Affinity_breaks,
		"cache_discards":        values.Cache_discards,
		"no_room":               values.No_room,
		"activate_non_exist":    values.Activate_non_exist,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SessionManagerEventsContext) SetUpdateEvery(state *framework.CollectorState, labels SessionManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SessionManagerLabels defines the required labels for SessionManager contexts
type SessionManagerLabels struct {
	Node   string
	Server string
	App    string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l SessionManagerLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, app
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.App)
}

// SessionManager contains all metric contexts for SessionManager
var SessionManager = struct {
	Active SessionManagerActiveContext
	Events SessionManagerEventsContext
}{
	Active: SessionManagerActiveContext{
		Context: framework.Context[SessionManagerLabels]{
			Name:        "websphere_pmi.session_manager_active",
			Family:      "workloads/sessions",
			Title:       "Session Manager Active Sessions",
			Units:       "sessions",
			Type:        module.Line,
			Priority:    530,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "live",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"app",
			},
		},
	},
	Events: SessionManagerEventsContext{
		Context: framework.Context[SessionManagerLabels]{
			Name:        "websphere_pmi.session_manager_events",
			Family:      "workloads/sessions",
			Title:       "Session Manager Events",
			Units:       "events/s",
			Type:        module.Line,
			Priority:    531,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "created",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "invalidated",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "timeout_invalidations",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "affinity_breaks",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "cache_discards",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "no_room",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "activate_non_exist",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"app",
			},
		},
	},
}

// --- System ---

// SystemCPUValues defines the type-safe values for System.CPU context
type SystemCPUValues struct {
	Utilization int64
}

// SystemCPUContext provides type-safe operations for System.CPU context
type SystemCPUContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.CPU context
func (c SystemCPUContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemCPUValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"utilization": values.Utilization,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemCPUContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// System contains all metric contexts for System
var System = struct {
	CPU SystemCPUContext
}{
	CPU: SystemCPUContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.cpu_utilization",
			Family:      "compute/cpu",
			Title:       "CPU Utilization",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    101,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "utilization",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- SystemData ---

// SystemDataUsageValues defines the type-safe values for SystemData.Usage context
type SystemDataUsageValues struct {
	Cpu_since_last int64
	Free_memory    int64
}

// SystemDataUsageContext provides type-safe operations for SystemData.Usage context
type SystemDataUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for SystemData.Usage context
func (c SystemDataUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemDataUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"cpu_since_last": values.Cpu_since_last,
		"free_memory":    values.Free_memory,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemDataUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemData contains all metric contexts for SystemData
var SystemData = struct {
	Usage SystemDataUsageContext
}{
	Usage: SystemDataUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_pmi.system_data_usage",
			Family:      "system/overview",
			Title:       "System Data Snapshot",
			Units:       "value",
			Type:        module.Line,
			Priority:    100,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "cpu_since_last",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "free_memory",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- ThreadPool ---

// ThreadPoolUsageValues defines the type-safe values for ThreadPool.Usage context
type ThreadPoolUsageValues struct {
	Active int64
	Size   int64
}

// ThreadPoolUsageContext provides type-safe operations for ThreadPool.Usage context
type ThreadPoolUsageContext struct {
	framework.Context[ThreadPoolLabels]
}

// Set provides type-safe dimension setting for ThreadPool.Usage context
func (c ThreadPoolUsageContext) Set(state *framework.CollectorState, labels ThreadPoolLabels, values ThreadPoolUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
		"size":   values.Size,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ThreadPoolUsageContext) SetUpdateEvery(state *framework.CollectorState, labels ThreadPoolLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ThreadPoolLabels defines the required labels for ThreadPool contexts
type ThreadPoolLabels struct {
	Name string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ThreadPoolLabels) InstanceID(contextName string) string {
	// Label order from YAML: name
	return contextName + "." + cleanLabelValue(l.Name)
}

// ThreadPool contains all metric contexts for ThreadPool
var ThreadPool = struct {
	Usage ThreadPoolUsageContext
}{
	Usage: ThreadPoolUsageContext{
		Context: framework.Context[ThreadPoolLabels]{
			Name:        "websphere_pmi.threadpool_usage",
			Family:      "workloads/threadpools",
			Title:       "Thread Pool Usage",
			Units:       "threads",
			Type:        module.Stacked,
			Priority:    301,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"name",
			},
		},
	},
}

// --- TransactionManager ---

// TransactionManagerCountsValues defines the type-safe values for TransactionManager.Counts context
type TransactionManagerCountsValues struct {
	Global_begun       int64
	Global_committed   int64
	Global_rolled_back int64
	Global_timeout     int64
	Global_involved    int64
	Optimizations      int64
	Local_begun        int64
	Local_committed    int64
	Local_rolled_back  int64
	Local_timeout      int64
}

// TransactionManagerCountsContext provides type-safe operations for TransactionManager.Counts context
type TransactionManagerCountsContext struct {
	framework.Context[TransactionManagerLabels]
}

// Set provides type-safe dimension setting for TransactionManager.Counts context
func (c TransactionManagerCountsContext) Set(state *framework.CollectorState, labels TransactionManagerLabels, values TransactionManagerCountsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"global_begun":       values.Global_begun,
		"global_committed":   values.Global_committed,
		"global_rolled_back": values.Global_rolled_back,
		"global_timeout":     values.Global_timeout,
		"global_involved":    values.Global_involved,
		"optimizations":      values.Optimizations,
		"local_begun":        values.Local_begun,
		"local_committed":    values.Local_committed,
		"local_rolled_back":  values.Local_rolled_back,
		"local_timeout":      values.Local_timeout,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TransactionManagerCountsContext) SetUpdateEvery(state *framework.CollectorState, labels TransactionManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TransactionManagerActiveValues defines the type-safe values for TransactionManager.Active context
type TransactionManagerActiveValues struct {
	Global int64
	Local  int64
}

// TransactionManagerActiveContext provides type-safe operations for TransactionManager.Active context
type TransactionManagerActiveContext struct {
	framework.Context[TransactionManagerLabels]
}

// Set provides type-safe dimension setting for TransactionManager.Active context
func (c TransactionManagerActiveContext) Set(state *framework.CollectorState, labels TransactionManagerLabels, values TransactionManagerActiveValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"global": values.Global,
		"local":  values.Local,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TransactionManagerActiveContext) SetUpdateEvery(state *framework.CollectorState, labels TransactionManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TransactionManagerTimeValues defines the type-safe values for TransactionManager.Time context
type TransactionManagerTimeValues struct {
	Global_total             int64
	Global_prepare           int64
	Global_commit            int64
	Global_before_completion int64
	Local_total              int64
	Local_commit             int64
	Local_before_completion  int64
}

// TransactionManagerTimeContext provides type-safe operations for TransactionManager.Time context
type TransactionManagerTimeContext struct {
	framework.Context[TransactionManagerLabels]
}

// Set provides type-safe dimension setting for TransactionManager.Time context
func (c TransactionManagerTimeContext) Set(state *framework.CollectorState, labels TransactionManagerLabels, values TransactionManagerTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"global_total":             values.Global_total,
		"global_prepare":           values.Global_prepare,
		"global_commit":            values.Global_commit,
		"global_before_completion": values.Global_before_completion,
		"local_total":              values.Local_total,
		"local_commit":             values.Local_commit,
		"local_before_completion":  values.Local_before_completion,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TransactionManagerTimeContext) SetUpdateEvery(state *framework.CollectorState, labels TransactionManagerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TransactionManagerLabels defines the required labels for TransactionManager contexts
type TransactionManagerLabels struct {
	Node   string
	Server string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TransactionManagerLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server)
}

// TransactionManager contains all metric contexts for TransactionManager
var TransactionManager = struct {
	Counts TransactionManagerCountsContext
	Active TransactionManagerActiveContext
	Time   TransactionManagerTimeContext
}{
	Counts: TransactionManagerCountsContext{
		Context: framework.Context[TransactionManagerLabels]{
			Name:        "websphere_pmi.transaction_counts",
			Family:      "workloads/transactions",
			Title:       "Transaction Counts",
			Units:       "transactions/s",
			Type:        module.Line,
			Priority:    401,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "global_begun",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_committed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_rolled_back",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_timeout",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_involved",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "optimizations",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_begun",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_committed",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_rolled_back",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_timeout",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
	Active: TransactionManagerActiveContext{
		Context: framework.Context[TransactionManagerLabels]{
			Name:        "websphere_pmi.transaction_active",
			Family:      "workloads/transactions",
			Title:       "Active Transactions",
			Units:       "transactions",
			Type:        module.Line,
			Priority:    402,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "global",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
	Time: TransactionManagerTimeContext{
		Context: framework.Context[TransactionManagerLabels]{
			Name:        "websphere_pmi.transaction_time",
			Family:      "workloads/transactions",
			Title:       "Transaction Durations",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    403,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "global_total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_prepare",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_commit",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "global_before_completion",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_commit",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "local_before_completion",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
			},
		},
	},
}

// --- URL ---

// URLRequestsValues defines the type-safe values for URL.Requests context
type URLRequestsValues struct {
	Requests int64
}

// URLRequestsContext provides type-safe operations for URL.Requests context
type URLRequestsContext struct {
	framework.Context[URLLabels]
}

// Set provides type-safe dimension setting for URL.Requests context
func (c URLRequestsContext) Set(state *framework.CollectorState, labels URLLabels, values URLRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"requests": values.Requests,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c URLRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels URLLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// URLTimeValues defines the type-safe values for URL.Time context
type URLTimeValues struct {
	Service int64
	Async   int64
}

// URLTimeContext provides type-safe operations for URL.Time context
type URLTimeContext struct {
	framework.Context[URLLabels]
}

// Set provides type-safe dimension setting for URL.Time context
func (c URLTimeContext) Set(state *framework.CollectorState, labels URLLabels, values URLTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"service": values.Service,
		"async":   values.Async,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c URLTimeContext) SetUpdateEvery(state *framework.CollectorState, labels URLLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// URLLabels defines the required labels for URL contexts
type URLLabels struct {
	Node   string
	Server string
	Url    string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l URLLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, url
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Url)
}

// URL contains all metric contexts for URL
var URL = struct {
	Requests URLRequestsContext
	Time     URLTimeContext
}{
	Requests: URLRequestsContext{
		Context: framework.Context[URLLabels]{
			Name:        "websphere_pmi.url_requests",
			Family:      "workloads/urls",
			Title:       "URL Requests",
			Units:       "requests/s",
			Type:        module.Line,
			Priority:    550,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "requests",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"url",
			},
		},
	},
	Time: URLTimeContext{
		Context: framework.Context[URLLabels]{
			Name:        "websphere_pmi.url_time",
			Family:      "workloads/urls",
			Title:       "URL Service Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    551,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "service",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "async",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"url",
			},
		},
	},
}

// --- WebApp ---

// WebAppLoadValues defines the type-safe values for WebApp.Load context
type WebAppLoadValues struct {
	Loaded_servlets int64
	Reloads         int64
}

// WebAppLoadContext provides type-safe operations for WebApp.Load context
type WebAppLoadContext struct {
	framework.Context[WebAppLabels]
}

// Set provides type-safe dimension setting for WebApp.Load context
func (c WebAppLoadContext) Set(state *framework.CollectorState, labels WebAppLabels, values WebAppLoadValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"loaded_servlets": values.Loaded_servlets,
		"reloads":         values.Reloads,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c WebAppLoadContext) SetUpdateEvery(state *framework.CollectorState, labels WebAppLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// WebAppLabels defines the required labels for WebApp contexts
type WebAppLabels struct {
	Node   string
	Server string
	App    string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l WebAppLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, app
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.App)
}

// WebApp contains all metric contexts for WebApp
var WebApp = struct {
	Load WebAppLoadContext
}{
	Load: WebAppLoadContext{
		Context: framework.Context[WebAppLabels]{
			Name:        "websphere_pmi.webapp_load",
			Family:      "workloads/webapps",
			Title:       "Web Application Load",
			Units:       "events",
			Type:        module.Line,
			Priority:    520,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "loaded_servlets",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "reloads",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"app",
			},
		},
	},
}

// --- WebServices ---

// WebServicesLoadedValues defines the type-safe values for WebServices.Loaded context
type WebServicesLoadedValues struct {
	Loaded int64
}

// WebServicesLoadedContext provides type-safe operations for WebServices.Loaded context
type WebServicesLoadedContext struct {
	framework.Context[WebServicesLabels]
}

// Set provides type-safe dimension setting for WebServices.Loaded context
func (c WebServicesLoadedContext) Set(state *framework.CollectorState, labels WebServicesLabels, values WebServicesLoadedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"loaded": values.Loaded,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c WebServicesLoadedContext) SetUpdateEvery(state *framework.CollectorState, labels WebServicesLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// WebServicesLabels defines the required labels for WebServices contexts
type WebServicesLabels struct {
	Node    string
	Server  string
	Service string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l WebServicesLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, service
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Service)
}

// WebServices contains all metric contexts for WebServices
var WebServices = struct {
	Loaded WebServicesLoadedContext
}{
	Loaded: WebServicesLoadedContext{
		Context: framework.Context[WebServicesLabels]{
			Name:        "websphere_pmi.web_services_loaded",
			Family:      "integration/web_services",
			Title:       "Web Services Loaded",
			Units:       "services",
			Type:        module.Line,
			Priority:    650,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "loaded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"service",
			},
		},
	},
}

// --- WebServicesGateway ---

// WebServicesGatewayRequestsValues defines the type-safe values for WebServicesGateway.Requests context
type WebServicesGatewayRequestsValues struct {
	Synchronous            int64
	Synchronous_responses  int64
	Asynchronous           int64
	Asynchronous_responses int64
}

// WebServicesGatewayRequestsContext provides type-safe operations for WebServicesGateway.Requests context
type WebServicesGatewayRequestsContext struct {
	framework.Context[WebServicesGatewayLabels]
}

// Set provides type-safe dimension setting for WebServicesGateway.Requests context
func (c WebServicesGatewayRequestsContext) Set(state *framework.CollectorState, labels WebServicesGatewayLabels, values WebServicesGatewayRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"synchronous":            values.Synchronous,
		"synchronous_responses":  values.Synchronous_responses,
		"asynchronous":           values.Asynchronous,
		"asynchronous_responses": values.Asynchronous_responses,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c WebServicesGatewayRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels WebServicesGatewayLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// WebServicesGatewayLabels defines the required labels for WebServicesGateway contexts
type WebServicesGatewayLabels struct {
	Node    string
	Server  string
	Gateway string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l WebServicesGatewayLabels) InstanceID(contextName string) string {
	// Label order from YAML: node, server, gateway
	return contextName + "." + cleanLabelValue(l.Node) + "_" + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Gateway)
}

// WebServicesGateway contains all metric contexts for WebServicesGateway
var WebServicesGateway = struct {
	Requests WebServicesGatewayRequestsContext
}{
	Requests: WebServicesGatewayRequestsContext{
		Context: framework.Context[WebServicesGatewayLabels]{
			Name:        "websphere_pmi.web_services_gateway_requests",
			Family:      "integration/web_services_gateway",
			Title:       "Web Services Gateway Requests",
			Units:       "requests/s",
			Type:        module.Line,
			Priority:    651,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "synchronous",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "synchronous_responses",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "asynchronous",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "asynchronous_responses",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"node",
				"server",
				"gateway",
			},
		},
	},
}

// GetAllContexts returns all contexts for framework registration
func GetAllContexts() []interface{} {
	return []interface{}{
		&AlarmManager.Events.Context,
		&DynamicCache.InMemory.Context,
		&DynamicCache.Capacity.Context,
		&EnterpriseBeans.Operations.Context,
		&EnterpriseBeans.Messages.Context,
		&EnterpriseBeans.Pool.Context,
		&EnterpriseBeans.Time.Context,
		&ExtensionRegistry.Requests.Context,
		&ExtensionRegistry.HitRate.Context,
		&HAManager.Groups.Context,
		&HAManager.BulletinBoard.Context,
		&HAManager.RebuildTime.Context,
		&JCAPool.Operations.Context,
		&JCAPool.Managed.Context,
		&JCAPool.Utilization.Context,
		&JCAPool.Waiting.Context,
		&JDBCPool.Usage.Context,
		&JDBCPool.Waiting.Context,
		&JDBCPool.Connections.Context,
		&JDBCPool.Operations.Context,
		&JDBCPool.Time.Context,
		&JMSQueue.MessagesProduced.Context,
		&JMSQueue.MessagesConsumed.Context,
		&JMSQueue.Clients.Context,
		&JMSQueue.Storage.Context,
		&JMSQueue.WaitTime.Context,
		&JMSStore.Cache.Context,
		&JMSStore.Datastore.Context,
		&JMSStore.Transactions.Context,
		&JMSStore.Expiry.Context,
		&JMSTopic.Publications.Context,
		&JMSTopic.SubscriptionHits.Context,
		&JMSTopic.Subscriptions.Context,
		&JMSTopic.Events.Context,
		&JMSTopic.Age.Context,
		&JVM.HeapUsage.Context,
		&JVM.HeapCommitted.Context,
		&JVM.HeapMax.Context,
		&JVM.Uptime.Context,
		&JVM.CPU.Context,
		&JVM.GCCollections.Context,
		&JVM.GCTime.Context,
		&JVM.Threads.Context,
		&JVM.ThreadPeak.Context,
		&ORB.Concurrent.Context,
		&ORB.Requests.Context,
		&ObjectPool.Operations.Context,
		&ObjectPool.Size.Context,
		&PMIWebServiceModule.Services.Context,
		&Portlet.Requests.Context,
		&Portlet.Concurrent.Context,
		&Portlet.Errors.Context,
		&Portlet.ResponseTime.Context,
		&PortletApplication.Loaded.Context,
		&Schedulers.Activity.Context,
		&SecurityAuth.Counts.Context,
		&SecurityAuthz.Time.Context,
		&SessionManager.Active.Context,
		&SessionManager.Events.Context,
		&System.CPU.Context,
		&SystemData.Usage.Context,
		&ThreadPool.Usage.Context,
		&TransactionManager.Counts.Context,
		&TransactionManager.Active.Context,
		&TransactionManager.Time.Context,
		&URL.Requests.Context,
		&URL.Time.Context,
		&WebApp.Load.Context,
		&WebServices.Loaded.Context,
		&WebServicesGateway.Requests.Context,
	}
}
