/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl;

import java.util.Arrays;
import org.openjsse.legacy8ujsse.sun.security.ssl.ProtocolVersion;

class Authenticator {
    private final byte[] block;
    private static final int BLOCK_SIZE_SSL = 11;
    private static final int BLOCK_SIZE_TLS = 13;

    Authenticator() {
        this.block = new byte[0];
    }

    Authenticator(ProtocolVersion protocolVersion) {
        if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
            this.block = new byte[13];
            this.block[9] = protocolVersion.major;
            this.block[10] = protocolVersion.minor;
        } else {
            this.block = new byte[11];
        }
    }

    final boolean seqNumOverflow() {
        return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1 && this.block[2] == -1 && this.block[3] == -1 && this.block[4] == -1 && this.block[5] == -1 && this.block[6] == -1;
    }

    final boolean seqNumIsHuge() {
        return this.block.length != 0 && this.block[0] == -1 && this.block[1] == -1;
    }

    final byte[] sequenceNumber() {
        return Arrays.copyOf(this.block, 8);
    }

    final byte[] acquireAuthenticationBytes(byte type, int length) {
        byte[] copy = (byte[])this.block.clone();
        if (this.block.length != 0) {
            copy[8] = type;
            copy[copy.length - 2] = (byte)(length >> 8);
            copy[copy.length - 1] = (byte)length;
            int k = 7;
            while (k >= 0) {
                int n = k--;
                this.block[n] = (byte)(this.block[n] + 1);
                if (this.block[n] == 0) continue;
            }
        }
        return copy;
    }
}

