/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.shared;

import java.util.Arrays;
import java.util.UUID;

public class Utils {
    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static String uuid(String value) {
        return UUID.nameUUIDFromBytes(value.getBytes()).toString();
    }

    public static String uuid(Object ... values) {
        return Utils.uuid(Arrays.toString(values));
    }

    public static String lower(String s) {
        return s != null ? s.toLowerCase() : null;
    }

    public static long currentTimeCount() {
        return System.nanoTime();
    }

    public static long nextTimeCount(long timeoutMillis) {
        return System.nanoTime() + timeoutMillis * 1000000L;
    }

    public static String elapsedTimeString(long startTimeStamp) {
        return String.format(" (%,d ms)", Utils.elapsedTimeMillis(startTimeStamp));
    }

    public static long elapsedTimeMillis(long startTimeCount) {
        return (System.nanoTime() - startTimeCount + 500000L) / 1000000L;
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

