import "pkl:xml"

class Person {
  name: String
  age: Int
}

res1 = "string"
res2 = true
res3 = 42
res4 = 1.23
res5 = 3.s
res6 = 4.mb
res8 = List("string", true, 42)
res9 = Set("string", true, 42)
res10 = Map("one", true, "two", 1.23)
res11 = new Listing { "string"; true; 42 }
res12 = new Mapping { ["name"] = "pigeon"; ["age"] = 30 }
res13 = new Dynamic { name = "pigeon"; age = 30 }
res14 = new Person { name = "pigeon" }
res15 = null

output {
  renderer = new xml.Renderer {
    indent = "    "
    converters {
      [String] = (it) -> it.reverse()
      [Boolean] = (it) -> !it
      [Int] = (it) -> it + 1
      [Float] = (it) -> it + 1.1
      [Duration] = (it) -> "\(it.value) \(it.unit)"
      [DataSize] = (it) -> "\(it.value) \(it.unit)"
      [List] = (it) -> it.reverse()
      [Set] = (it) -> it + List(4)
      [Map] = (it) -> it + Map("three", 3.s)
      [Listing] = (it) -> (it) { 4 }
      [Mapping] = (it) -> (it) { ["three"] = 3.s }
      [Dynamic] = (it) -> (it) { other = "other" }
      [Person] = (it) -> (it) { age = 40 } // fill in missing property
      [Null] = (it) -> "String"
    }
  }
}
