import "pkl:test"

class Numbers {
  xs: Map<String, Int>
  ys: Map<String(!isEmpty), Int(this < 0)>
  zs: Map<String(!isEmpty), Int(this < 0)>(length >= 5)
}

class Numbers2 {
  // type constraint but no type parameters
  ys: Map(every((key, value) -> key is String(!isEmpty) && value is Int(this < 0)))
}

res1 = new Numbers {
  xs = Map("one", 1, "two", 2, "three", 3)
  ys = Map("-one", -1, "-two", -2, "-three", -3)
  zs = Map("-one", -1, "-two", -2, "-three", -3, "-four", -4, "-five", -5)
}

res1b = new Numbers2 {
  ys = Map("-one", -1, "-two", -2, "-three", -3)
}

res2 = test.catch(() ->
  new Numbers {
    xs = "numbers"
  }.xs
)

res3 = test.catch(() ->
  new Numbers {
    xs = Map("one", "one")
  }.xs
)

res4 = test.catch(() ->
  new Numbers {
    xs = Map(1, 1)
  }.xs
)

res5 = test.catch(() ->
  new Numbers {
    ys = Map("one", 1, "two", 2, "three", 3)
  }.ys
)

res5b = test.catch(() ->
  new Numbers2 {
    ys = Map("one", 1, "two", 2, "three", 3)
  }.ys
)

res6 = test.catch(() ->
  new Numbers {
    ys = Map("", -1, "-two", -2, "-three", -3)
  }.ys
)

res6b = test.catch(() ->
  new Numbers2 {
    ys = Map("", -1, "-two", -2, "-three", -3)
  }.ys
)

res7 = test.catch(() ->
  new Numbers {
    zs = Map("-one", -1, "-two", -2, "-three", -3)
  }.zs
)
