/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;

public class ColorWithFallback
extends ColorWithAlternatives {
    private static final long serialVersionUID = 7913922854959637136L;
    private final Color fallback;

    public ColorWithFallback(ColorSpace cspace, float[] components, float alpha, Color[] alternativeColors, Color fallback) {
        super(cspace, components, alpha, alternativeColors);
        this.fallback = fallback;
    }

    public ColorWithFallback(Color color, Color fallback) {
        this(color.getColorSpace(), color.getColorComponents(null), ColorWithFallback.getAlphaFloat(color), ColorWithFallback.getAlternativeColors(color), fallback);
    }

    private static float getAlphaFloat(Color color) {
        float[] comps = color.getComponents(null);
        return comps[comps.length - 1];
    }

    private static Color[] getAlternativeColors(Color color) {
        ColorWithAlternatives cwa;
        if (color instanceof ColorWithAlternatives && (cwa = (ColorWithAlternatives)color).hasAlternativeColors()) {
            return cwa.getAlternativeColors();
        }
        return null;
    }

    public Color getFallbackColor() {
        return this.fallback;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.fallback.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof ColorWithFallback) {
            ColorWithFallback other = (ColorWithFallback)obj;
            return other.fallback.equals(this.fallback);
        }
        return false;
    }
}

