// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
export var DiagnosticSeverity;
(function (DiagnosticSeverity) {
    DiagnosticSeverity[DiagnosticSeverity["Error"] = 1] = "Error";
    DiagnosticSeverity[DiagnosticSeverity["Warning"] = 2] = "Warning";
    DiagnosticSeverity[DiagnosticSeverity["Information"] = 3] = "Information";
    DiagnosticSeverity[DiagnosticSeverity["Hint"] = 4] = "Hint";
})(DiagnosticSeverity || (DiagnosticSeverity = {}));
export var DiagnosticTag;
(function (DiagnosticTag) {
    DiagnosticTag[DiagnosticTag["Unnecessary"] = 1] = "Unnecessary";
    DiagnosticTag[DiagnosticTag["Deprecated"] = 2] = "Deprecated";
})(DiagnosticTag || (DiagnosticTag = {}));
export var CompletionItemTag;
(function (CompletionItemTag) {
    CompletionItemTag[CompletionItemTag["Deprecated"] = 1] = "Deprecated";
})(CompletionItemTag || (CompletionItemTag = {}));
export var CompletionItemKind;
(function (CompletionItemKind) {
    CompletionItemKind[CompletionItemKind["Text"] = 1] = "Text";
    CompletionItemKind[CompletionItemKind["Method"] = 2] = "Method";
    CompletionItemKind[CompletionItemKind["Function"] = 3] = "Function";
    CompletionItemKind[CompletionItemKind["Constructor"] = 4] = "Constructor";
    CompletionItemKind[CompletionItemKind["Field"] = 5] = "Field";
    CompletionItemKind[CompletionItemKind["Variable"] = 6] = "Variable";
    CompletionItemKind[CompletionItemKind["Class"] = 7] = "Class";
    CompletionItemKind[CompletionItemKind["Interface"] = 8] = "Interface";
    CompletionItemKind[CompletionItemKind["Module"] = 9] = "Module";
    CompletionItemKind[CompletionItemKind["Property"] = 10] = "Property";
    CompletionItemKind[CompletionItemKind["Unit"] = 11] = "Unit";
    CompletionItemKind[CompletionItemKind["Value"] = 12] = "Value";
    CompletionItemKind[CompletionItemKind["Enum"] = 13] = "Enum";
    CompletionItemKind[CompletionItemKind["Keyword"] = 14] = "Keyword";
    CompletionItemKind[CompletionItemKind["Snippet"] = 15] = "Snippet";
    CompletionItemKind[CompletionItemKind["Color"] = 16] = "Color";
    CompletionItemKind[CompletionItemKind["File"] = 17] = "File";
    CompletionItemKind[CompletionItemKind["Reference"] = 18] = "Reference";
    CompletionItemKind[CompletionItemKind["Folder"] = 19] = "Folder";
    CompletionItemKind[CompletionItemKind["EnumMember"] = 20] = "EnumMember";
    CompletionItemKind[CompletionItemKind["Constant"] = 21] = "Constant";
    CompletionItemKind[CompletionItemKind["Struct"] = 22] = "Struct";
    CompletionItemKind[CompletionItemKind["Event"] = 23] = "Event";
    CompletionItemKind[CompletionItemKind["Operator"] = 24] = "Operator";
    CompletionItemKind[CompletionItemKind["TypeParameter"] = 25] = "TypeParameter";
})(CompletionItemKind || (CompletionItemKind = {}));
export var DocumentHighlightKind;
(function (DocumentHighlightKind) {
    DocumentHighlightKind[DocumentHighlightKind["Text"] = 1] = "Text";
    DocumentHighlightKind[DocumentHighlightKind["Read"] = 2] = "Read";
    DocumentHighlightKind[DocumentHighlightKind["Write"] = 3] = "Write";
})(DocumentHighlightKind || (DocumentHighlightKind = {}));
export var CompletionTriggerKind;
(function (CompletionTriggerKind) {
    CompletionTriggerKind[CompletionTriggerKind["Invoked"] = 1] = "Invoked";
    CompletionTriggerKind[CompletionTriggerKind["TriggerCharacter"] = 2] = "TriggerCharacter";
    CompletionTriggerKind[CompletionTriggerKind["TriggerForIncompleteCompletions"] = 3] = "TriggerForIncompleteCompletions";
})(CompletionTriggerKind || (CompletionTriggerKind = {}));
export var AdditionalCompletionTriggerKinds;
(function (AdditionalCompletionTriggerKinds) {
    AdditionalCompletionTriggerKinds[AdditionalCompletionTriggerKinds["AutoInvoked"] = 9999] = "AutoInvoked";
})(AdditionalCompletionTriggerKinds || (AdditionalCompletionTriggerKinds = {}));
/**
 * The language identifier for LSP, with the preferred identifier as defined in the documentation
 * see the table in https://microsoft.github.io/language-server-protocol/specification#textDocumentItem
 */
export var Languages;
(function (Languages) {
    Languages["abap"] = "ABAP";
    Languages["bat"] = "Windows Bat";
    Languages["bibtex"] = "BibTeX";
    Languages["clojure"] = "Clojure";
    Languages["coffeescript"] = "Coffeescript";
    Languages["c"] = "C";
    Languages["cpp"] = "C++";
    Languages["csharp"] = "C#";
    Languages["css"] = "CSS";
    Languages["diff"] = "Diff";
    Languages["dart"] = "Dart";
    Languages["dockerfile"] = "Dockerfile";
    Languages["elixir"] = "Elixir";
    Languages["erlang"] = "Erlang";
    Languages["fsharp"] = "F#";
    Languages["git-commit"] = "Git (commit)";
    Languages["git-rebase"] = "Git (rebase)";
    Languages["go"] = "Go";
    Languages["groovy"] = "Groovy";
    Languages["handlebars"] = "Handlebars";
    Languages["html"] = "HTML";
    Languages["ini"] = "Ini";
    Languages["java"] = "Java";
    Languages["javascript"] = "JavaScript";
    Languages["javascriptreact"] = "JavaScript React";
    Languages["json"] = "JSON";
    Languages["latex"] = "LaTeX";
    Languages["less"] = "Less";
    Languages["lua"] = "Lua";
    Languages["makefile"] = "Makefile";
    Languages["markdown"] = "Markdown";
    Languages["objective-c"] = "Objective-C";
    Languages["objective-cpp"] = "Objective-C++";
    Languages["perl"] = "Perl";
    Languages["perl6"] = "Perl 6";
    Languages["php"] = "PHP";
    Languages["powershell"] = "Powershell";
    Languages["jade"] = "Pug";
    Languages["python"] = "Python";
    Languages["r"] = "R";
    Languages["razor"] = "Razor (cshtml)";
    Languages["ruby"] = "Ruby";
    Languages["rust"] = "Rust";
    Languages["scss"] = "SCSS (syntax using curly brackets)";
    Languages["sass"] = "SCSS (indented syntax)";
    Languages["scala"] = "Scala";
    Languages["shaderlab"] = "ShaderLab";
    Languages["shellscript"] = "Shell Script (Bash)";
    Languages["sql"] = "SQL";
    Languages["swift"] = "Swift";
    Languages["typescript"] = "TypeScript";
    Languages["typescriptreact"] = "TypeScript React";
    Languages["tex"] = "TeX";
    Languages["vb"] = "Visual Basic";
    Languages["xml"] = "XML";
    Languages["xsl"] = "XSL";
    Languages["yaml"] = "YAML";
})(Languages || (Languages = {}));
//# sourceMappingURL=lsp.js.map