# Installation
> `npm install --save @types/react-addons-linked-state-mixin`

# Summary
This package contains type definitions for react-addons-linked-state-mixin (http://facebook.github.io/react/).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-addons-linked-state-mixin.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-addons-linked-state-mixin/index.d.ts)
````ts
import { Mixin } from "create-react-class";

declare var LinkedStateMixin: LinkedStateMixin.LinkedStateMixin;
type LinkedStateMixin = LinkedStateMixin.LinkedStateMixin;
export = LinkedStateMixin;

declare namespace LinkedStateMixin {
    export interface ReactLink<T> {
        value: T;
        requestChange(newValue: T): void;
    }

    export interface LinkedStateMixin extends Mixin<any, any> {
        linkState<T>(key: string): ReactLink<T>;
    }
}

declare module "react" {
    interface HTMLAttributes<T> {
        checkedLink?: LinkedStateMixin.ReactLink<boolean> | undefined;
        valueLink?: LinkedStateMixin.ReactLink<boolean | string | number> | undefined;
    }
}

````

### Additional Details
 * Last updated: Tue, 09 Jan 2024 15:07:15 GMT
 * Dependencies: [@types/create-react-class](https://npmjs.com/package/@types/create-react-class), [@types/react](https://npmjs.com/package/@types/react)

# Credits
These definitions were written by [Asana](https://asana.com), [AssureSign](http://www.assuresign.com), and [Microsoft](https://microsoft.com).
