'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" ? (version != null ? Bokeh[version] : Bokeh) : null;
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh" + (version != null ? " " + version : "") + ". You have to load it prior to loading plugins.");
    }
  })
({
"4e90918c0a": function _(e,s,t,b,o){b();const i=e("tslib").__importStar(e("2fe1822b2b"));t.Panel=i;(0,e("@bokehjs/base").register_models)(i)},
"2fe1822b2b": function _(e,t,a,o,c){o(),a.VizzuChart=a.VideoStream=a.Video=a.VegaPlot=a.TrendIndicator=a.TooltipIcon=a.ToggleIcon=void 0;const d=e("tslib");c("AcePlot",e("6227c89639").AcePlot),c("AnyWidgetComponent",e("1f663ffe94").AnyWidgetComponent),c("Audio",e("fd59c985b3").Audio),c("BrowserInfo",e("5a16cc23e6").BrowserInfo),c("Button",e("1db93211cd").Button),c("ButtonIcon",e("1738ddeb3a").ButtonIcon),c("ClickableIcon",e("6c7fbea0ef").ClickableIcon),c("Card",e("d7035097d8").Card),c("CheckboxButtonGroup",e("51fbe9e2d0").CheckboxButtonGroup),c("ChatAreaInput",e("27a077673d").ChatAreaInput),c("Column",e("b273e5b2fb").Column),c("CommManager",e("1bec1b1fcc").CommManager),c("CustomSelect",e("92bbd30bd1").CustomSelect),c("CustomMultiSelect",e("27b5580835").CustomMultiSelect),c("DataTabulator",e("53b5147b3d").DataTabulator),c("DatetimePicker",e("100965d6f3").DatetimePicker),c("DatetimeSlider",e("c97cc0eade").DatetimeSlider),c("DeckGLPlot",e("01df2ec63b").DeckGLPlot),c("DiscretePlayer",e("0dca2cd4f6").DiscretePlayer),c("ECharts",e("1da56f3c52").ECharts),c("Feed",e("4cfe0841a5").Feed),c("FileDownload",e("84a13dddfb").FileDownload),c("FileDropper",e("e8b7476f90").FileDropper),c("HTML",e("4c04683fdc").HTML),c("IPyWidget",e("8a8089cbf3").IPyWidget),c("JSON",e("245cd3cfde").JSON),c("JSONEditor",e("a123a88e31").JSONEditor),c("KaTeX",e("f672d71a9f").KaTeX),c("Location",e("bd8e0fe48b").Location),c("MathJax",e("d889a68424").MathJax),c("Modal",e("8c62aa80d9").Modal),c("PDF",e("f87ad1873c").PDF),c("Perspective",e("29a0b0da9a").Perspective),c("Player",e("96e805ccb5").Player),c("PlotlyPlot",e("7d9124b744").PlotlyPlot),c("Progress",e("b1f4d68596").Progress),c("QuillInput",e("f6d86c7342").QuillInput),c("RadioButtonGroup",e("25e2d7c208").RadioButtonGroup),c("ReactComponent",e("ace9331ee1").ReactComponent),c("ReactiveHTML",e("d5752cda5a").ReactiveHTML),c("ReactiveESM",e("50fda3c782").ReactiveESM),c("SingleSelect",e("4155401209").SingleSelect),c("SpeechToText",e("5ac2cab0ab").SpeechToText),c("State",e("92822cb73a").State),c("Tabs",e("2231cdc549").Tabs),c("Terminal",e("a961b5ae5e").Terminal),c("TextAreaInput",e("b7d595d74a").TextAreaInput),c("TextInput",e("8be416b160").TextInput),c("TextToSpeech",e("a04eb51988").TextToSpeech),c("TimePicker",e("1afcab4e45").TimePicker),c("ToggleIcon",e("ad985f285e").ToggleIcon),c("TooltipIcon",e("ae3a172647").TooltipIcon),c("TrendIndicator",e("29d55a28a9").TrendIndicator),c("VegaPlot",e("119dc23765").VegaPlot),c("Video",e("79dc37b888").Video),c("VideoStream",e("f8afc4e661").VideoStream),c("VizzuChart",e("1f7bc1f95b").VizzuChart),d.__exportStar(e("c51f25e2a7"),a)},
"6227c89639": function _(e,t,i,o,s){var n;o();const a=e("@bokehjs/core/dom"),d=e("9b11ce01a3"),_=e("a3669a897a");class h extends d.HTMLBoxView{connect_signals(){super.connect_signals();const{code:e,theme:t,language:i,filename:o,print_margin:s,annotations:n,soft_tabs:a,indent:d,readonly:_}=this.model.properties;this.on_change(e,(()=>this._update_code_from_model())),this.on_change(t,(()=>this._update_theme())),this.on_change(i,(()=>this._update_language())),this.on_change(o,(()=>this._update_filename())),this.on_change(s,(()=>this._update_print_margin())),this.on_change(n,(()=>this._add_annotations())),this.on_change(d,(()=>this._editor.setOptions({tabSize:this.model.indent}))),this.on_change(a,(()=>this._editor.setOptions({useSoftTabs:this.model.soft_tabs}))),this.on_change(_,(()=>{this._editor.setReadOnly(this.model.readonly)}))}render(){super.render(),this._container=(0,a.div)({id:(0,_.ID)(),style:{width:"100%",height:"100%",zIndex:"0"}}),this.shadow_el.append(this._container),this._container.textContent=this.model.code,this._editor=ace.edit(this._container),this._editor.renderer.attachToShadowRoot(),this._langTools=ace.require("ace/ext/language_tools"),this._modelist=ace.require("ace/ext/modelist"),this._editor.setOptions({enableBasicAutocompletion:!0,tabSize:this.model.indent,useSoftTabs:this.model.soft_tabs,enableSnippets:!0,fontFamily:"monospace"}),this._update_theme(),this._update_filename(),this._update_language(),this._editor.setReadOnly(this.model.readonly),this._editor.setShowPrintMargin(this.model.print_margin),this.model.on_keyup?this._editor.on("change",(()=>this._update_code_from_editor())):(this._editor.on("blur",(()=>this._update_code_from_editor())),this._editor.commands.addCommand({name:"updateCodeFromEditor",bindKey:{win:"Ctrl-Enter",mac:"Command-Enter"},exec:()=>{this._update_code_from_editor()}})),this._editor.on("change",(()=>this._update_code_input_from_editor()))}_update_code_from_model(){this._editor&&this._editor.getValue()!=this.model.code&&this._editor.setValue(this.model.code)}_update_print_margin(){this._editor.setShowPrintMargin(this.model.print_margin)}_update_code_from_editor(){this._editor.getValue()!=this.model.code&&(this.model.code=this._editor.getValue())}_update_code_input_from_editor(){this._editor.getValue()!=this.model.code_input&&(this.model.code_input=this._editor.getValue())}_update_theme(){this._editor.setTheme(`ace/theme/${this.model.theme}`)}_update_filename(){if(this.model.filename){const e=this._modelist.getModeForPath(this.model.filename).mode;this.model.language=e.slice(9)}}_update_language(){null!=this.model.language&&this._editor.session.setMode(`ace/mode/${this.model.language}`)}_add_annotations(){this._editor.session.setAnnotations(this.model.annotations)}after_layout(){super.after_layout(),void 0!==this._editor&&this._editor.resize()}}i.AcePlotView=h,h.__name__="AcePlotView";class r extends d.HTMLBox{constructor(e){super(e)}}i.AcePlot=r,n=r,r.__name__="AcePlot",r.__module__="panel.models.ace",n.prototype.default_view=h,n.define((({Any:e,Bool:t,Int:i,List:o,Str:s,Nullable:n})=>({annotations:[o(e),[]],code:[s,""],code_input:[s,""],filename:[n(s),null],indent:[i,4],language:[s,""],on_keyup:[t,!0],print_margin:[t,!1],theme:[s,"github_light_default"],readonly:[t,!1],soft_tabs:[t,!1]}))),n.override({height:300,width:300})},
"9b11ce01a3": function _(e,t,i,s,h){s(),i.set_size=o;const n=e("@bokehjs/core/dom"),l=e("@bokehjs/core/util/types"),a=e("@bokehjs/core/util/assert"),r=e("@bokehjs/models/widgets/widget"),d=e("@bokehjs/models/layouts/layout_dom");class _ extends r.WidgetView{connect_signals(){super.connect_signals();const{width:e,height:t,min_height:i,max_height:s,margin:h,sizing_mode:n}=this.model.properties;this.on_change([e,t,i,s,h,n],(()=>{o(this.el,this.model),o(this.container,this.model,!1)}))}async lazy_initialize(){await super.lazy_initialize(),"not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((()=>{this.contains_tex_string(this.model.text)&&this.render()}))}watch_stylesheets(){this._initialized_stylesheets=new Map;for(const e of this._applied_stylesheets){const t=e.el;t instanceof HTMLLinkElement&&(this._initialized_stylesheets.set(t.href,!1),t.addEventListener("load",(()=>{this._initialized_stylesheets.set(t.href,!0),[...this._initialized_stylesheets.values()].every((e=>e))&&requestAnimationFrame((()=>this.style_redraw()))})))}0==this._initialized_stylesheets.size&&this.style_redraw()}rerender_(e=null){(e=e??this).rerender?e.rerender():(e.render(),e.r_after_render())}style_redraw(){}has_math_disabled(){return this.model.disable_math||!this.contains_tex_string(this.model.text)}render(){super.render(),o(this.el,this.model),this.container=(0,n.div)(),o(this.container,this.model,!1),this.shadow_el.appendChild(this.container),"failed"!=this.provider.status&&"loaded"!=this.provider.status||(this._has_finished=!0)}}function o(e,t,i=!0){let s=null!=t.width?"fixed":"fit",h=null!=t.height?"fixed":"fit";const{sizing_mode:r,margin:d}=t;if(null!=r)if("fixed"==r)s=h="fixed";else if("stretch_both"==r)s=h="max";else if("stretch_width"==r)s="max";else if("stretch_height"==r)h="max";else switch(r){case"scale_width":s="max",h="min";break;case"scale_height":s="min",h="max";break;case"scale_both":s="max",h="max";break;default:(0,a.unreachable)()}let _,o;i?(0,l.isArray)(d)?4===d.length?(o=d[0]+d[2],_=d[1]+d[3]):(o=2*d[0],_=2*d[1]):null==d?o=_=0:_=o=2*d:o=_=0,"fixed"==s&&null!=t.width?e.style.width=(0,n.px)(t.width):"max"==s&&(e.style.width=0!=_?`calc(100% - ${(0,n.px)(_)})`:"100%"),null!=t.min_width&&(e.style.minWidth=(0,n.px)(t.min_width)),null!=t.max_width&&(e.style.maxWidth=(0,n.px)(t.max_width)),"fixed"==h&&null!=t.height?e.style.height=(0,n.px)(t.height):"max"==h&&(e.style.height=0!=o?`calc(100% - ${(0,n.px)(o)})`:"100%"),null!=t.min_height&&(e.style.minHeight=(0,n.px)(t.min_height)),null!=t.max_height&&(e.style.maxHeight=(0,n.px)(t.max_height))}i.PanelMarkupView=_,_.__name__="PanelMarkupView";class m extends d.LayoutDOMView{connect_signals(){super.connect_signals();const{width:e,height:t,min_height:i,max_height:s,margin:h,sizing_mode:n}=this.model.properties;this.on_change([e,t,i,s,h,n],(()=>{o(this.el,this.model)}))}render(){super.render(),o(this.el,this.model)}rerender_(e=null){(e=e??this).rerender?e.rerender():(e.render(),e.r_after_render())}watch_stylesheets(){this._initialized_stylesheets=new Map;for(const e of this._applied_stylesheets){const t=e.el;t instanceof HTMLLinkElement&&(this._initialized_stylesheets.set(t.href,!1),t.addEventListener("load",(()=>{this._initialized_stylesheets.set(t.href,!0),[...this._initialized_stylesheets.values()].every((e=>e))&&this.style_redraw()})))}0===Object.keys(this._initialized_stylesheets).length&&requestAnimationFrame((()=>this.style_redraw()))}style_redraw(){}get child_models(){return[]}}i.HTMLBoxView=m,m.__name__="HTMLBoxView";class c extends d.LayoutDOM{constructor(e){super(e)}}i.HTMLBox=c,c.__name__="HTMLBox"},
"a3669a897a": function _(t,e,n,r,o){r(),n.throttle=function(t,e){let n=0,r=null;return function(...o){const c=this,s=Date.now();r&&clearTimeout(r),s-n>=e?(t.apply(c,o),n=Date.now()):r=setTimeout((function(){t.apply(c,o),n=Date.now(),r=null}),e-(s-n))}},n.deepCopy=function t(e){let n;if(null==e||"object"!=typeof e)return e;if(e instanceof Array){n=[];for(let r=0,o=e.length;r<o;r++)n[r]=t(e[r]);return n}if(e instanceof Object){const n={};for(const r in e){const o=r;e.hasOwnProperty(o)&&(n[o]=t(e[o]))}return n}throw new Error("Unable to copy obj! Its type isn't supported.")},n.reshape=function(t,e){let n=0;if(!e||!t)return[];return function r(o){let s=[];if(o===e.length-1)s=(0,c.concat)(t.slice(n,n+e[o])),n+=e[o];else for(let t=0;t<e[o];t++)s.push(r(o+1));return s}(0)},n.loadScript=async function(t,e){const n=document.createElement("script");return n.type=t,n.src=e,n.defer=!0,document.head.appendChild(n),new Promise(((t,e)=>{n.onload=()=>{t()},n.onerror=()=>{e()}}))},n.ID=function(){return`_${Math.random().toString(36).substring(2,11)}`},n.convertUndefined=function t(e){if((0,s.isArray)(e))return e.map(t);(0,s.isPlainObject)(e)&&Object.entries(e).forEach((([n,r])=>{(0,s.isPlainObject)(r)||(0,s.isArray)(r)?t(r):void 0===r&&(e[n]=null)}));return e},n.formatError=function(t,e){let n=`<span class="msg">${t}</span>`;const r=n.match(/\((\d+):(\d+)\)/);if(!r)return n;const o=parseInt(r[1]),c=parseInt(r[2]),s=Math.max(0,o-5),i=o-s,u=e.replace(">","&lt;").replace("<","&gt;").split(/\r?\n/).slice(s,o+5);n+="<br><br>";for(let t=0;t<i;t++){n+=`<pre${t==i-1?' class="highlight"':""}>${u[t]}</pre>`}const l=" ".repeat(c-1);n+=`<pre class="highlight">${l}^</pre>`;for(let t=i;t<u.length;t++)n+=`<pre>${u[t]}</pre>`;return n},n.find_attributes=function(t,e,n){const r=RegExp(`\\b${e}\\.([a-zA-Z_][a-zA-Z0-9_]*)\\b`,"g"),o=[];let s,i;for(;null!==(s=r.exec(t))&&null!==(i=s[0].slice(e.length+1))&&!n.includes(i);)o.push(i);return(0,c.uniq)(o)},n.schedule_when=function(t,e,n=10){const r=()=>{e()?t():setTimeout(r,n)};r()},n.compileToFunction=l,n.transformJsPlaceholders=function(t,e){return function t(n){if("string"==typeof n){const t=n.match(i);return t?l(t[1],e):n}if(Array.isArray(n))return n.map(t);if(n&&"object"==typeof n&&Object.getPrototypeOf(n)===Object.prototype){const e={};for(const[r,o]of Object.entries(n))e[r]=t(o);return e}return n}(t)};const c=t("@bokehjs/core/util/array"),s=t("@bokehjs/core/util/types");n.get=(t,e,n=void 0)=>{const r=n=>String.prototype.split.call(e,n).filter(Boolean).reduce(((t,e)=>null!=t?t[e]:t),t),o=r(/[,[\]]+?/)||r(/[,[\].]+?/);return void 0===o||o===t?n:o},n.MARK="--x_x--0_0--";const i=new RegExp(`^${n.MARK}([\\s\\S]*?)${n.MARK}$`),u={mode:"expression",args:[]};function l(t,e=u){const{mode:n,args:r}={...u,...e};return new Function(...r,"expression"===n?`"use strict";\nreturn (${t});`:`"use strict";\n${t}`)()}},
"1f663ffe94": function _(e,t,i,n,s){var r;n();const o=e("50fda3c782");class a{constructor(e){this.view=null,this.model=e,this.model_changes={},this.data_changes={}}get(e){let t;const i=e.split(".");let n=this.model.data;for(let e=0;e<i.length-1;e++){if(!(n&&n.attributes&&i[e]in n.attributes)){n=null;break}n=n.attributes[i[e]]}return t=n&&n.attributes&&i[i.length-1]in n.attributes?n.attributes[i[i.length-1]]:this.model.attributes[e],t instanceof ArrayBuffer&&(t=new DataView(t)),t}set(e,t){e.split(".")[0]in this.model.data.attributes?this.data_changes={...this.data_changes,[e]:t}:e in this.model.attributes&&(this.model_changes={...this.model_changes,[e]:t})}save_changes(){this.model.setv(this.model_changes),this.model_changes={};for(const e in this.data_changes){const t=e.split(".");let i=this.model.data;for(let n=0;n<t.length-1;n++){if(!(i&&i.attributes&&t[n]in i.attributes)){console.warn(`Skipping '${e}': '${t[n]}' does not exist.`),i=null;break}i=i.attributes[t[n]]}i&&i.attributes&&t[t.length-1]in i.attributes?i.setv({[t[t.length-1]]:this.data_changes[e]}):console.warn(`Skipping '${e}': Final property '${t[t.length-1]}' not found.`)}this.data_changes={}}on(e,t){e.startsWith("change:")?this.model.watch(this.view,e.slice(7),t):"msg:custom"===e&&this.view?this.view.on_event(t):console.error(`Event of type '${e}' not recognized.`)}off(e,t){e.startsWith("change:")?this.model.unwatch(this.view,e.slice(7),t):"msg:custom"===e&&this.view?this.view.remove_on_event(t):console.error(`Event of type '${e}' not recognized.`)}}a.__name__="AnyWidgetModelAdapter";class d extends a{constructor(e){super(e.model),this.view=e}get_child(e){const t=this.model.data[e];if(Array.isArray(t)){const e=[];for(const i of t){const t=this.view.get_child_view(i);t&&e.push(t.el)}return e}return this.view.get_child_view(t)?.el}}d.__name__="AnyWidgetAdapter";class h extends o.ReactiveESMView{initialize(){super.initialize(),this.adapter=new d(this)}remove(){super.remove(),this.destroyer&&this.destroyer.then((e=>e({model:this.adapter,el:this.container})))}after_rendered(){this.render_children(),this._rendered=!0}}i.AnyWidgetComponentView=h,h.__name__="AnyWidgetComponentView";class l extends o.ReactiveESM{constructor(e){super(e),this.sucrase_transforms=["typescript","jsx"]}_render_code(){return"\nfunction render(id) {\n  const view = Bokeh.index.find_one_by_id(id)\n  if (!view) { return }\n\n  const out = Promise.resolve(view.render_fn({\n    view, model: view.adapter, data: view.model.data, el: view.container\n  }) || null)\n  view.destroyer = out\n  out.then(() => view.after_rendered())\n}\n\nexport default {render}"}_run_initializer(e){e({model:new a(this)})}}i.AnyWidgetComponent=l,r=l,l.__name__="AnyWidgetComponent",l.__module__="panel.models.esm",r.prototype.default_view=h},
"50fda3c782": function _(e,t,s,i,n){var r,l,o;i(),s.model_getter=x,s.model_setter=M;const a=e("tslib");var c,h=this&&this.__decorate||function(e,t,s,i){var n,r=arguments.length,l=r<3?t:null===i?i=Object.getOwnPropertyDescriptor(t,s):i;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)l=Reflect.decorate(e,t,s,i);else for(var o=e.length-1;o>=0;o--)(n=e[o])&&(l=(r<3?n(l):r>3?n(t,s,l):n(t,s))||l);return r>3&&l&&Object.defineProperty(t,s,l),l};const d=e("48024289a4"),_=e("@bokehjs/core/bokeh_events"),u=e("@bokehjs/core/dom"),m=e("@bokehjs/core/dom"),p=e("@bokehjs/models/layouts/layout_dom"),f=e("@bokehjs/core/util/types"),y=e("a572dba9cd"),v=e("4c04683fdc"),g=e("9b11ce01a3"),w=e("a3669a897a"),b=a.__importDefault(e("727a14f76b")),k=new Map;class R extends _.ModelEvent{constructor(e){super(),this.data=e}get event_values(){return{model:this.origin,data:this.data}}}s.DataEvent=R,r=R,R.__name__="DataEvent",r.prototype.event_name="data_event";let z=(l=class extends R{static from_values(e){const{model:t,data:s}=e,i=new c(s);return i.origin=t,i}},c=l,l.__name__="ESMEvent",l);function x(e,t){const s=e.model;return"get_child"===t?t=>{e.accessed_children.includes(t)||e.accessed_children.push(t);const i=s.data[t];if((0,f.isArray)(i)){const t=[];for(const s of i)t.push(e.get_child_view(s)?.el);return t}return null!=s?e.get_child_view(i)?.el:null}:"send_msg"===t?e=>{s.trigger_event(new R(e))}:"send_event"===t?(e,t)=>{const i=(0,w.convertUndefined)((0,y.serializeEvent)(t));s.trigger_event(new v.DOMEvent(e,i))}:"off"===t?(t,i)=>{const n=(0,f.isArray)(t)?t:[t];for(let t of n)if(t.startsWith("change:")&&(t=t.slice(7)),t in s.attributes||t.split(".")[0]in s.data.attributes)s.unwatch(e,t,i);else if("msg:custom"!==t)if(t.startsWith("lifecycle:")&&(t=t.slice(10)),e._lifecycle_handlers.has(t)){const s=e._lifecycle_handlers.get(t);s&&s.includes(i)&&e._lifecycle_handlers.set(t,s.filter((e=>e!==i)))}else console.warn(`Could not unregister callback for event type '${t}'`);else e.remove_on_event(i)}:"on"===t?(t,i,n=!1)=>{const r=(0,f.isArray)(t)?t:[t];for(let t of r)t.startsWith("change:")&&(t=t.slice(7)),t in s.attributes||t.split(".")[0]in s.data.attributes?s.watch(e,t,i,n):"msg:custom"!==t?(t.startsWith("lifecycle:")&&(t=t.slice(10)),e._lifecycle_handlers.has(t)?(e._lifecycle_handlers.get(t)||[]).push(i):console.warn(`Could not register callback for event type '${t}'`)):e.on_event(i)}:Reflect.has(s.data,t)?(t in s.data.attributes&&!e.accessed_properties.includes(t)&&e.accessed_properties.push(t),Reflect.get(s.data,t)):Reflect.has(s,t)?Reflect.get(s,t):void 0}function M(e,t,s){const i=e.model;return Reflect.has(i.data,t)?Reflect.set(i.data,t,s):!!Reflect.has(i,t)&&Reflect.set(i,t,s)}function E(e,t){return Reflect.has(e.data,t)?Reflect.get(e.data,t):Reflect.has(e,t)?Reflect.get(e,t):void 0}function S(e,t,s){return Reflect.has(e.data,t)?Reflect.set(e.data,t,s):!!Reflect.has(e,t)&&Reflect.set(e,t,s)}s.ESMEvent=z,s.ESMEvent=z=c=h([(0,_.server_event)("esm_event")],z);class j extends g.HTMLBoxView{constructor(){super(...arguments),this.accessed_properties=[],this.accessed_children=[],this.compiled_module=null,this._changing=!1,this._child_rendered=new Map,this._event_handlers=[],this._lifecycle_handlers=new Map([["update_layout",[]],["after_layout",[]],["after_render",[]],["resize",[]],["remove",[]],["mounted",[]]]),this._rendered=!1,this._stale_children=!1,this._mounted=new Map}initialize(){super.initialize(),this._module_cache=k,this._child_callbacks=new Map,this.model_proxy=new Proxy(this,{get:x,set:M})}async lazy_initialize(){await super.lazy_initialize(),this.compiled_module=await this.model.compiled_module}stylesheets(){const e=super.stylesheets();return e.push(b.default),this.model.css_bundle&&("url"===this.model.bundle?e.push(new m.ImportedStyleSheet(this.model.css_bundle)):e.push(this.model.css_bundle)),e}connect_signals(){super.connect_signals();const{esm:e,importmap:t,class_name:s}=this.model.properties;this.on_change([e,t],(async()=>{this.compiled_module=await this.model.compiled_module,this.invalidate_render()})),this.on_change(s,(()=>{this.container.className=this.model.class_name.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}));const i=this.model.children.map((e=>this.model.data.properties[e]));this.on_change(i,(()=>{this.update_children()})),this.model.on_event(z,(e=>{for(const t of this._event_handlers)t(e.data)}))}disconnect_signals(){super.disconnect_signals(),this._child_callbacks=new Map,this.model.disconnect_watchers(this)}_on_mounted(){}notify_mount(e,t,s){this._mounted.has(e)||this._mounted.set(e,new Set),s?this._mounted.get(e)?.delete(t):this._mounted.get(e)?.add(t);let i=this.model.data[e];if((0,f.isArray)(i)||(i=[i]),i.every((t=>this._mounted.get(e)?.has(t.id)))){this._on_mounted();for(const t of this._lifecycle_handlers.get("mounted")||[])t(e)}}on_event(e){this._event_handlers.push(e)}remove_on_event(e){return!!this._event_handlers.includes(e)&&(this._event_handlers=this._event_handlers.filter((t=>t!==e)),!0)}get_child_view(e){return this._child_views.get(e)}get render_fn(){return null===this.compiled_module?null:this.compiled_module.default?this.compiled_module.default.render:this.compiled_module.render}get child_models(){const e=[];for(const t of this.model.children){const s=this.model.data[t];if((0,f.isArray)(s))for(const t of s)e.push(t);else null!=s&&e.push(s)}return e}render_error(e){const t=(0,u.div)({class:"error"});t.innerHTML=(0,w.formatError)(e,this.model.esm),this.container.appendChild(t)}render(){this.empty(),this._update_stylesheets(),this._update_css_classes(),this._apply_styles(),this._update_css_variables(),this._apply_visible(),this._child_callbacks=new Map,this._child_rendered.clear(),this._rendered=!1,(0,g.set_size)(this.el,this.model),this.container=(0,u.div)(),this.container.className=this.model.class_name.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase(),(0,g.set_size)(this.container,this.model,!1),this.shadow_el.append(this.container),this.model.compile_error?this.render_error(this.model.compile_error):this.render_esm();for(const e of this.element_views){const t=e.rendering_target()??this.self_target??this.shadow_el;e.render_to(t)}}get is_managed(){return this.parent instanceof p.LayoutDOMView&&!(this.parent instanceof j)}compute_layout(){this.is_managed?super.compute_layout():(this.measure_layout(),this.update_bbox(),this._compute_layout(),this.after_layout(),this._layout_computed=!0)}_update_bbox(){const e=(()=>{if(this.el.isConnected){if(null!=this.el.offsetParent)return!0;{const{position:e,display:t}=getComputedStyle(this.el);return"fixed"==e&&"none"!=t}}return!1})();return this._is_displayed=e,!0}after_rendered(){const e=this._lifecycle_handlers.get("after_render")||[];for(const t of e)t();if(this.render_children(),this.model_proxy.on(this.accessed_children,(()=>{this._stale_children=!0})),!this._rendered)for(const e of this._lifecycle_handlers.get("after_layout")||[])e();this._rendered=!0}render_esm(){if(null!==this.model.compiled&&null!==this.model.render_module){this.accessed_properties=[];for(const e of this._lifecycle_handlers.keys())(this._lifecycle_handlers.get(e)||[]).splice(0);this.model.disconnect_watchers(this),this.model.render_module.then((e=>e.default.render(this.model.id)))}}render_children(){for(const e of this.model.children){const t=this.model.data[e],s=(0,f.isArray)(t)?t:[t];for(const e of s){const t=this._child_views.get(e);if(!t)continue;t.el.parentNode&&!this._child_rendered.has(t)&&(this.rerender_(t),this._child_rendered.set(t,!0))}}this.after_render()}invalidate_layout(){this.is_managed?super.invalidate_layout():(this.update_layout(),this.compute_layout())}remove(){super.remove();for(const e of this._lifecycle_handlers.get("remove")||[])e();this._child_callbacks.clear(),this._child_rendered.clear(),this._mounted.clear()}after_resize(){if(this._rendered&&!this._changing){super.after_resize();for(const e of this._lifecycle_handlers.get("resize")||[])e()}}after_layout(){if(super.after_layout(),this._rendered&&!this._changing)for(const e of this._lifecycle_handlers.get("after_layout")||[])e()}_lookup_child(e){for(const t of this.model.children){let s=this.model.data[t];s=(0,f.isArray)(s)?s:[s];for(const i of s)if(i===e.model)return t}return null}async update_children(){const e=new Set(await this.build_child_views()),t=this.child_views;for(const e of t)e.el.remove();const s=new Map;for(const t of this.child_views){if(!e.has(t))continue;const i=this._lookup_child(t);i&&(s.has(i)?s.get(i).push(t):s.set(i,[t]))}for(const e of this._child_rendered.keys())t.includes(e)||this._child_rendered.delete(e);for(const e of this.model.children){const t=this._child_callbacks.get(e)||[],i=s.get(e)||[];for(const e of t)e(i)}this._stale_children&&(this.render_esm(),this._stale_children=!1),this._update_children(),this.invalidate_layout()}on_child_render(e,t){this._child_callbacks.has(e)||this._child_callbacks.set(e,[]);(this._child_callbacks.get(e)||[]).push(t)}remove_on_child_render(e,t){if(this._child_callbacks.has(e))if(void 0===t)this._child_callbacks.delete(e);else{let s=this._child_callbacks.get(e)||[];s=s.filter((e=>e!==t)),this._child_callbacks.set(e,s)}}}s.ReactiveESMView=j,j.__name__="ReactiveESMView";class A extends g.HTMLBox{constructor(e){super(e),this.compiled=null,this.compiled_module=null,this.compile_error=null,this.render_module=null,this.sucrase_transforms=["typescript"],this._destroyer=null,this._esm_watchers={},this._event_callbacks=new Map}initialize(){super.initialize(),this.model_proxy=new Proxy(this,{get:E,set:S}),this.recompile()}connect_signals(){super.connect_signals(),this.connect(this.properties.esm.change,(()=>this.recompile())),this.connect(this.properties.importmap.change,(()=>this.recompile()))}watch(e,t,s,i=!1){t in this._esm_watchers?this._esm_watchers[t].push([e,s]):this._esm_watchers[t]=[[e,s]];const n=t.split(".");let r=this.data,l=null;for(let e=0;e<n.length-1;e++){if(!(r&&r.properties&&n[e]in r.properties)){r=null;break}r=r[n[e]]}if(r&&r.properties&&n[n.length-1]in r.properties&&(l=n[n.length-1]),!i&&r===this.data&&l&&this.events.includes(l)){const e=s;s=()=>{l&&this.data[l]&&(e(),this.data.setv({[l]:!1}))},this._event_callbacks.set(e,s)}l&&r?r.property(l).change.connect(s):t in this.properties&&this.property(t).change.connect(s)}unwatch(e,t,s){if(!(t in this._esm_watchers))return!1;const i=[];for(const[n,r]of this._esm_watchers[t])n===e&&r===s||i.push([n,r]);i.length>0?this._esm_watchers[t]=i:delete this._esm_watchers[t];const n=t.split(".");let r=this.data,l=null;for(let e=0;e<n.length-1;e++){if(!(r&&r.properties&&n[e]in r.properties)){r=null;break}r=r[n[e]]}return r&&r.properties&&n[n.length-1]in r.properties&&(l=n[n.length-1]),this._event_callbacks.has(s)&&(s=this._event_callbacks.get(s),this._event_callbacks.delete(s)),l&&r?r.property(l).change.disconnect(s):t in this.properties&&this.property(t).change.disconnect(s)}disconnect_watchers(e){for(const t in this._esm_watchers){const s=this.data.properties[t],i=[];for(const[n,r]of this._esm_watchers[t])n===e?s?.change.disconnect(r):i.push([n,r]);i.length>0?this._esm_watchers[t]=i:delete this._esm_watchers[t]}}_declare_importmap(){if(this.importmap){const e={...this.importmap};try{importShim.addImportMap(e)}catch(e){console.warn(`Failed to add import map: ${e}`)}}}_run_initializer(e){const t={model:this.model_proxy};this._destroyer=e(t)}destroy(){super.destroy(),this._destroyer&&this._destroyer(this.model_proxy)}init_module(){if(!this.compile_error)if(k.has(this._render_cache_key))this.render_module=k.get(this._render_cache_key);else{const e=this._render_code(),t=URL.createObjectURL(new Blob([e],{type:"text/javascript"}));this.render_module=importShim(t),k.set(this._render_cache_key,this.render_module)}}_render_code(){return"\nfunction render(id) {\n  const view = Bokeh.index.find_one_by_id(id)\n  if (view == null) {\n    return null\n  }\n\n  const output = view.render_fn({\n    view: view, model: view.model_proxy, data: view.model.data, el: view.container\n  })\n\n  Promise.resolve(output).then((out) => {\n    if (out instanceof Element) {\n      view.container.replaceChildren(out)\n    }\n    view.after_rendered()\n  })\n}\n\nexport default {render}"}get _render_cache_key(){return"reactive_esm"}compile(){if(null!=this.bundle)return this.esm;let e;try{e=(0,d.transform)(this.esm,{transforms:this.sucrase_transforms,filePath:"render.tsx"}).code}catch(e){if(e instanceof SyntaxError){if(this.dev)return this.compile_error=e,null;throw e.message=`${e.message}. See more information with '--dev' flag.`,e}throw e}return e}async recompile(){this.compile_error=null;const e=this.compile();if(null===e)return void(this.compiled_module=Promise.resolve(null));let t;this.compiled=e,this._declare_importmap();const s=!this.dev||this.bundle,i="url"===this.bundle?this.esm:this.bundle||`${this.class_name}-${this.esm.length}`;let n;if(s&&k.has(i))t=Promise.resolve(k.get(i));else{let e;s&&k.set(i,new Promise((e=>{n=e}))),e="url"===this.bundle?this.esm:URL.createObjectURL(new Blob([this.compiled],{type:"text/javascript"})),t=window.importShim(e)}this.compiled_module=t.then((e=>{n&&n(e);try{let t;if(null!=this.bundle&&(e.default||{}).hasOwnProperty(this.class_name)&&(e=e.default[this.class_name]),e.initialize)t=e.initialize;else if(e.default&&e.default.initialize)t=e.default.initialize;else if("function"==typeof e.default){const s=e.default();e={default:s},t=s.initialize}return t&&this._run_initializer(t),this.init_module(),e}catch(e){return this.dev&&(this.compile_error=e),console.error(`Could not initialize module due to error: ${e}`),null}}))}}s.ReactiveESM=A,o=A,A.__name__="ReactiveESM",A.__module__="panel.models.esm",o.prototype.default_view=j,o.define((({Any:e,Array:t,Bool:s,Nullable:i,Str:n})=>({css_bundle:[i(n),null],bundle:[i(n),null],children:[t(n),[]],class_name:[n,""],data:[e],dev:[s,!1],esm:[n,""],events:[t(n),[]],importmap:[e,{}]})))},
"48024289a4": function _(e,t,r,s,o){s(),r.getVersion=function(){return"3.35.0"},r.transform=function(e,t){(0,i.validateOptions)(t);try{const r=b(e,t),s=new m.default(r,t.transforms,Boolean(t.enableLegacyBabel5ModuleInterop),t).transform();let o={code:s.code};if(t.sourceMapOptions){if(!t.filePath)throw new Error("filePath must be specified when generating a source map.");o={...o,sourceMap:(0,f.default)(s,t.filePath,t.sourceMapOptions,e,r.tokenProcessor.tokens)}}return o}catch(e){throw t.filePath&&(e.message=`Error transforming ${t.filePath}: ${e.message}`),e}},r.getFormattedTokens=function(e,t){const r=b(e,t).tokenProcessor.tokens;return(0,_.default)(e,r)};const n=e("tslib"),a=n.__importDefault(e("add4298d4c")),f=n.__importDefault(e("03a5a23920")),l=e("40e1a4d3af"),c=n.__importDefault(e("5f4ada3fc1")),p=n.__importDefault(e("425f39b83e")),i=e("bb0c9c6022"),u=e("7a45c9fdec"),d=n.__importDefault(e("1c7cc5e988")),m=n.__importDefault(e("131f5202c7")),_=n.__importDefault(e("2e6a9a5b28")),g=n.__importDefault(e("4160f5108d"));function b(e,t){const r=t.transforms.includes("jsx"),s=t.transforms.includes("typescript"),o=t.transforms.includes("flow"),n=!0===t.disableESTransforms,f=(0,u.parse)(e,r,s,o),i=f.tokens,m=f.scopes,_=new p.default(e,i),b=new l.HelperManager(_),k=new d.default(e,i,o,n,b),h=Boolean(t.enableLegacyTypeScriptModuleInterop);let w=null;return t.transforms.includes("imports")?(w=new a.default(_,k,h,t,t.transforms.includes("typescript"),Boolean(t.keepUnusedImports),b),w.preprocessTokens(),(0,c.default)(k,m,w.getGlobalNames()),t.transforms.includes("typescript")&&!t.keepUnusedImports&&w.pruneTypeOnlyImports()):t.transforms.includes("typescript")&&!t.keepUnusedImports&&(0,c.default)(k,m,(0,g.default)(k)),{tokenProcessor:k,scopes:m,nameManager:_,importProcessor:w,helperManager:b}}},
"add4298d4c": function _(e,t,n,s,o){s();const r=e("tslib"),i=e("bfb18d0576"),a=e("99ff836c64"),p=e("f0c35cbd76"),h=r.__importDefault(e("14d4ae78a4")),m=e("1ff9c9004b");class d{__init(){this.nonTypeIdentifiers=new Set}__init2(){this.importInfoByPath=new Map}__init3(){this.importsToReplace=new Map}__init4(){this.identifierReplacements=new Map}__init5(){this.exportBindingsByLocalName=new Map}constructor(e,t,n,s,o,r,i){this.nameManager=e,this.tokens=t,this.enableLegacyTypeScriptModuleInterop=n,this.options=s,this.isTypeScriptTransformEnabled=o,this.keepUnusedImports=r,this.helperManager=i,d.prototype.__init.call(this),d.prototype.__init2.call(this),d.prototype.__init3.call(this),d.prototype.__init4.call(this),d.prototype.__init5.call(this)}preprocessTokens(){for(let e=0;e<this.tokens.tokens.length;e++)this.tokens.matches1AtIndex(e,p.TokenType._import)&&!this.tokens.matches3AtIndex(e,p.TokenType._import,p.TokenType.name,p.TokenType.eq)&&this.preprocessImportAtIndex(e),this.tokens.matches1AtIndex(e,p.TokenType._export)&&!this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType.eq)&&this.preprocessExportAtIndex(e);this.generateImportReplacements()}pruneTypeOnlyImports(){this.nonTypeIdentifiers=(0,m.getNonTypeIdentifiers)(this.tokens,this.options);for(const[e,t]of this.importInfoByPath.entries()){if(t.hasBareImport||t.hasStarExport||t.exportStarNames.length>0||t.namedExports.length>0)continue;[...t.defaultNames,...t.wildcardNames,...t.namedImports.map((({localName:e})=>e))].every((e=>this.shouldAutomaticallyElideImportedName(e)))&&this.importsToReplace.set(e,"")}}shouldAutomaticallyElideImportedName(e){return this.isTypeScriptTransformEnabled&&!this.keepUnusedImports&&!this.nonTypeIdentifiers.has(e)}generateImportReplacements(){for(const[e,t]of this.importInfoByPath.entries()){const{defaultNames:n,wildcardNames:s,namedImports:o,namedExports:r,exportStarNames:i,hasStarExport:a}=t;if(0===n.length&&0===s.length&&0===o.length&&0===r.length&&0===i.length&&!a){this.importsToReplace.set(e,`require('${e}');`);continue}const p=this.getFreeIdentifierForPath(e);let h;h=this.enableLegacyTypeScriptModuleInterop?p:s.length>0?s[0]:this.getFreeIdentifierForPath(e);let m=`var ${p} = require('${e}');`;if(s.length>0)for(const e of s){m+=` var ${e} = ${this.enableLegacyTypeScriptModuleInterop?p:`${this.helperManager.getHelperName("interopRequireWildcard")}(${p})`};`}else i.length>0&&h!==p?m+=` var ${h} = ${this.helperManager.getHelperName("interopRequireWildcard")}(${p});`:n.length>0&&h!==p&&(m+=` var ${h} = ${this.helperManager.getHelperName("interopRequireDefault")}(${p});`);for(const{importedName:e,localName:t}of r)m+=` ${this.helperManager.getHelperName("createNamedExportFrom")}(${p}, '${t}', '${e}');`;for(const e of i)m+=` exports.${e} = ${h};`;a&&(m+=` ${this.helperManager.getHelperName("createStarExport")}(${p});`),this.importsToReplace.set(e,m);for(const e of n)this.identifierReplacements.set(e,`${h}.default`);for(const{importedName:e,localName:t}of o)this.identifierReplacements.set(t,`${p}.${e}`)}}getFreeIdentifierForPath(e){const t=e.split("/"),n=t[t.length-1].replace(/\W/g,"");return this.nameManager.claimFreeName(`_${n}`)}preprocessImportAtIndex(e){const t=[],n=[],s=[];if(e++,(this.tokens.matchesContextualAtIndex(e,a.ContextualKeyword._type)||this.tokens.matches1AtIndex(e,p.TokenType._typeof))&&!this.tokens.matches1AtIndex(e+1,p.TokenType.comma)&&!this.tokens.matchesContextualAtIndex(e+1,a.ContextualKeyword._from))return;if(this.tokens.matches1AtIndex(e,p.TokenType.parenL))return;if(this.tokens.matches1AtIndex(e,p.TokenType.name)&&(t.push(this.tokens.identifierNameAtIndex(e)),e++,this.tokens.matches1AtIndex(e,p.TokenType.comma)&&e++),this.tokens.matches1AtIndex(e,p.TokenType.star)&&(e+=2,n.push(this.tokens.identifierNameAtIndex(e)),e++),this.tokens.matches1AtIndex(e,p.TokenType.braceL)){const n=this.getNamedImports(e+1);e=n.newIndex;for(const e of n.namedImports)"default"===e.importedName?t.push(e.localName):s.push(e)}if(this.tokens.matchesContextualAtIndex(e,a.ContextualKeyword._from)&&e++,!this.tokens.matches1AtIndex(e,p.TokenType.string))throw new Error("Expected string token at the end of import statement.");const o=this.tokens.stringValueAtIndex(e),r=this.getImportInfo(o);r.defaultNames.push(...t),r.wildcardNames.push(...n),r.namedImports.push(...s),0===t.length&&0===n.length&&0===s.length&&(r.hasBareImport=!0)}preprocessExportAtIndex(e){if(this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType._var)||this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType._let)||this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType._const))this.preprocessVarExportAtIndex(e);else if(this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType._function)||this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType._class)){const t=this.tokens.identifierNameAtIndex(e+2);this.addExportBinding(t,t)}else if(this.tokens.matches3AtIndex(e,p.TokenType._export,p.TokenType.name,p.TokenType._function)){const t=this.tokens.identifierNameAtIndex(e+3);this.addExportBinding(t,t)}else this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType.braceL)?this.preprocessNamedExportAtIndex(e):this.tokens.matches2AtIndex(e,p.TokenType._export,p.TokenType.star)&&this.preprocessExportStarAtIndex(e)}preprocessVarExportAtIndex(e){let t=0;for(let n=e+2;;n++)if(this.tokens.matches1AtIndex(n,p.TokenType.braceL)||this.tokens.matches1AtIndex(n,p.TokenType.dollarBraceL)||this.tokens.matches1AtIndex(n,p.TokenType.bracketL))t++;else if(this.tokens.matches1AtIndex(n,p.TokenType.braceR)||this.tokens.matches1AtIndex(n,p.TokenType.bracketR))t--;else{if(0===t&&!this.tokens.matches1AtIndex(n,p.TokenType.name))break;if(this.tokens.matches1AtIndex(1,p.TokenType.eq)){const e=this.tokens.currentToken().rhsEndIndex;if(null==e)throw new Error("Expected = token with an end index.");n=e-1}else{const e=this.tokens.tokens[n];if((0,i.isDeclaration)(e)){const e=this.tokens.identifierNameAtIndex(n);this.identifierReplacements.set(e,`exports.${e}`)}}}}preprocessNamedExportAtIndex(e){e+=2;const{newIndex:t,namedImports:n}=this.getNamedImports(e);if(e=t,!this.tokens.matchesContextualAtIndex(e,a.ContextualKeyword._from)){for(const{importedName:e,localName:t}of n)this.addExportBinding(e,t);return}if(e++,!this.tokens.matches1AtIndex(e,p.TokenType.string))throw new Error("Expected string token at the end of import statement.");const s=this.tokens.stringValueAtIndex(e);this.getImportInfo(s).namedExports.push(...n)}preprocessExportStarAtIndex(e){let t=null;if(this.tokens.matches3AtIndex(e,p.TokenType._export,p.TokenType.star,p.TokenType._as)?(e+=3,t=this.tokens.identifierNameAtIndex(e),e+=2):e+=3,!this.tokens.matches1AtIndex(e,p.TokenType.string))throw new Error("Expected string token at the end of star export statement.");const n=this.tokens.stringValueAtIndex(e),s=this.getImportInfo(n);null!==t?s.exportStarNames.push(t):s.hasStarExport=!0}getNamedImports(e){const t=[];for(;;){if(this.tokens.matches1AtIndex(e,p.TokenType.braceR)){e++;break}const n=(0,h.default)(this.tokens,e);if(e=n.endIndex,n.isType||t.push({importedName:n.leftName,localName:n.rightName}),this.tokens.matches2AtIndex(e,p.TokenType.comma,p.TokenType.braceR)){e+=2;break}if(this.tokens.matches1AtIndex(e,p.TokenType.braceR)){e++;break}if(!this.tokens.matches1AtIndex(e,p.TokenType.comma))throw new Error(`Unexpected token: ${JSON.stringify(this.tokens.tokens[e])}`);e++}return{newIndex:e,namedImports:t}}getImportInfo(e){const t=this.importInfoByPath.get(e);if(t)return t;const n={defaultNames:[],wildcardNames:[],namedImports:[],namedExports:[],hasBareImport:!1,exportStarNames:[],hasStarExport:!1};return this.importInfoByPath.set(e,n),n}addExportBinding(e,t){this.exportBindingsByLocalName.has(e)||this.exportBindingsByLocalName.set(e,[]),this.exportBindingsByLocalName.get(e).push(t)}claimImportCode(e){const t=this.importsToReplace.get(e);return this.importsToReplace.set(e,""),t||""}getIdentifierReplacement(e){return this.identifierReplacements.get(e)||null}resolveExportBinding(e){const t=this.exportBindingsByLocalName.get(e);return t&&0!==t.length?t.map((e=>`exports.${e}`)).join(" = "):null}getGlobalNames(){return new Set([...this.identifierReplacements.keys(),...this.exportBindingsByLocalName.keys()])}}n.default=d},
"bfb18d0576": function _(e,t,o,a,s){a(),o.isDeclaration=function(e){const t=e.identifierRole;return t===o.IdentifierRole.TopLevelDeclaration||t===o.IdentifierRole.FunctionScopedDeclaration||t===o.IdentifierRole.BlockScopedDeclaration||t===o.IdentifierRole.ObjectShorthandTopLevelDeclaration||t===o.IdentifierRole.ObjectShorthandFunctionScopedDeclaration||t===o.IdentifierRole.ObjectShorthandBlockScopedDeclaration},o.isNonTopLevelDeclaration=function(e){const t=e.identifierRole;return t===o.IdentifierRole.FunctionScopedDeclaration||t===o.IdentifierRole.BlockScopedDeclaration||t===o.IdentifierRole.ObjectShorthandFunctionScopedDeclaration||t===o.IdentifierRole.ObjectShorthandBlockScopedDeclaration},o.isTopLevelDeclaration=function(e){const t=e.identifierRole;return t===o.IdentifierRole.TopLevelDeclaration||t===o.IdentifierRole.ObjectShorthandTopLevelDeclaration||t===o.IdentifierRole.ImportDeclaration},o.isBlockScopedDeclaration=function(e){const t=e.identifierRole;return t===o.IdentifierRole.TopLevelDeclaration||t===o.IdentifierRole.BlockScopedDeclaration||t===o.IdentifierRole.ObjectShorthandTopLevelDeclaration||t===o.IdentifierRole.ObjectShorthandBlockScopedDeclaration},o.isFunctionScopedDeclaration=function(e){const t=e.identifierRole;return t===o.IdentifierRole.FunctionScopedDeclaration||t===o.IdentifierRole.ObjectShorthandFunctionScopedDeclaration},o.isObjectShorthandDeclaration=function(e){return e.identifierRole===o.IdentifierRole.ObjectShorthandTopLevelDeclaration||e.identifierRole===o.IdentifierRole.ObjectShorthandBlockScopedDeclaration||e.identifierRole===o.IdentifierRole.ObjectShorthandFunctionScopedDeclaration},o.next=C,o.nextTemplateToken=function(){r.state.tokens.push(new T),r.state.start=r.state.pos,function(){for(;;){if(r.state.pos>=r.input.length)return void(0,c.unexpected)("Unterminated template");const e=r.input.charCodeAt(r.state.pos);if(e===i.charCodes.graveAccent||e===i.charCodes.dollarSign&&r.input.charCodeAt(r.state.pos+1)===i.charCodes.leftCurlyBrace)return r.state.pos===r.state.start&&k(u.TokenType.template)?e===i.charCodes.dollarSign?(r.state.pos+=2,void R(u.TokenType.dollarBraceL)):(++r.state.pos,void R(u.TokenType.backQuote)):void R(u.TokenType.template);e===i.charCodes.backslash&&r.state.pos++,r.state.pos++}}()},o.retokenizeSlashAsRegex=function(){r.state.type===u.TokenType.assign&&--r.state.pos;!function(){const e=r.state.pos;let t=!1,o=!1;for(;;){if(r.state.pos>=r.input.length)return void(0,c.unexpected)("Unterminated regular expression",e);const a=r.input.charCodeAt(r.state.pos);if(t)t=!1;else{if(a===i.charCodes.leftSquareBracket)o=!0;else if(a===i.charCodes.rightSquareBracket&&o)o=!1;else if(a===i.charCodes.slash&&!o)break;t=a===i.charCodes.backslash}++r.state.pos}++r.state.pos,w(),R(u.TokenType.regexp)}()},o.pushTypeContext=function(e){for(let t=r.state.tokens.length-e;t<r.state.tokens.length;t++)r.state.tokens[t].isType=!0;const t=r.state.isType;return r.state.isType=!0,t},o.popTypeContext=function(e){r.state.isType=e},o.eat=f,o.eatTypeToken=function(e){const t=r.state.isType;r.state.isType=!0,f(e),r.state.isType=t},o.match=k,o.lookaheadType=function(){const e=r.state.snapshot();C();const t=r.state.type;return r.state.restoreFromSnapshot(e),t},o.lookaheadTypeAndKeyword=function(){const e=r.state.snapshot();C();const t=r.state.type,o=r.state.contextualKeyword;return r.state.restoreFromSnapshot(e),new y(t,o)},o.nextTokenStart=g,o.nextTokenStartSince=S,o.lookaheadCharCode=function(){return r.input.charCodeAt(g())},o.nextToken=b,o.skipLineComment=v,o.skipSpace=D,o.finishToken=R,o.rescan_gt=function(){r.state.type===u.TokenType.greaterThan&&(r.state.pos-=1,I())},o.getTokenFromCode=m,o.skipWord=w;const n=e("tslib"),r=e("540718e523"),c=e("bc94bbadc1"),i=e("22746c8ce8"),d=e("364148c9f0"),p=e("2a3176644a"),h=e("99ff836c64"),l=n.__importDefault(e("e6eb78033b")),u=e("f0c35cbd76");!function(e){e[e.Access=0]="Access";e[e.ExportAccess=1]="ExportAccess";e[e.TopLevelDeclaration=2]="TopLevelDeclaration";e[e.FunctionScopedDeclaration=3]="FunctionScopedDeclaration";e[e.BlockScopedDeclaration=4]="BlockScopedDeclaration";e[e.ObjectShorthandTopLevelDeclaration=5]="ObjectShorthandTopLevelDeclaration";e[e.ObjectShorthandFunctionScopedDeclaration=6]="ObjectShorthandFunctionScopedDeclaration";e[e.ObjectShorthandBlockScopedDeclaration=7]="ObjectShorthandBlockScopedDeclaration";e[e.ObjectShorthand=8]="ObjectShorthand";e[e.ImportDeclaration=9]="ImportDeclaration";e[e.ObjectKey=10]="ObjectKey";e[e.ImportAccess=11]="ImportAccess"}(o.IdentifierRole||(o.IdentifierRole={})),function(e){e[e.NoChildren=0]="NoChildren";e[e.OneChild=1]="OneChild";e[e.StaticChildren=2]="StaticChildren";e[e.KeyAfterPropSpread=3]="KeyAfterPropSpread"}(o.JSXRole||(o.JSXRole={}));class T{constructor(){this.type=r.state.type,this.contextualKeyword=r.state.contextualKeyword,this.start=r.state.start,this.end=r.state.end,this.scopeDepth=r.state.scopeDepth,this.isType=r.state.isType,this.identifierRole=null,this.jsxRole=null,this.shadowsGlobal=!1,this.isAsyncOperation=!1,this.contextId=null,this.rhsEndIndex=null,this.isExpression=!1,this.numNullishCoalesceStarts=0,this.numNullishCoalesceEnds=0,this.isOptionalChainStart=!1,this.isOptionalChainEnd=!1,this.subscriptStartIndex=null,this.nullishStartIndex=null}}function C(){r.state.tokens.push(new T),b()}function f(e){return!!k(e)&&(C(),!0)}function k(e){return r.state.type===e}o.Token=T;class y{constructor(e,t){this.type=e,this.contextualKeyword=t}}function g(){return S(r.state.pos)}function S(e){p.skipWhiteSpace.lastIndex=e;return e+p.skipWhiteSpace.exec(r.input)[0].length}function b(){if(D(),r.state.start=r.state.pos,r.state.pos>=r.input.length){const e=r.state.tokens;return e.length>=2&&e[e.length-1].start>=r.input.length&&e[e.length-2].start>=r.input.length&&(0,c.unexpected)("Unexpectedly reached the end of input."),void R(u.TokenType.eof)}var e;e=r.input.charCodeAt(r.state.pos),d.IS_IDENTIFIER_START[e]||e===i.charCodes.backslash||e===i.charCodes.atSign&&r.input.charCodeAt(r.state.pos+1)===i.charCodes.atSign?(0,l.default)():m(e)}function A(){for(;r.input.charCodeAt(r.state.pos)!==i.charCodes.asterisk||r.input.charCodeAt(r.state.pos+1)!==i.charCodes.slash;)if(r.state.pos++,r.state.pos>r.input.length)return void(0,c.unexpected)("Unterminated comment",r.state.pos-2);r.state.pos+=2}function v(e){let t=r.input.charCodeAt(r.state.pos+=e);if(r.state.pos<r.input.length)for(;t!==i.charCodes.lineFeed&&t!==i.charCodes.carriageReturn&&t!==i.charCodes.lineSeparator&&t!==i.charCodes.paragraphSeparator&&++r.state.pos<r.input.length;)t=r.input.charCodeAt(r.state.pos)}function D(){for(;r.state.pos<r.input.length;){const e=r.input.charCodeAt(r.state.pos);switch(e){case i.charCodes.carriageReturn:r.input.charCodeAt(r.state.pos+1)===i.charCodes.lineFeed&&++r.state.pos;case i.charCodes.lineFeed:case i.charCodes.lineSeparator:case i.charCodes.paragraphSeparator:++r.state.pos;break;case i.charCodes.slash:switch(r.input.charCodeAt(r.state.pos+1)){case i.charCodes.asterisk:r.state.pos+=2,A();break;case i.charCodes.slash:v(2);break;default:return}break;default:if(!p.IS_WHITESPACE[e])return;++r.state.pos}}}function R(e,t=h.ContextualKeyword.NONE){r.state.end=r.state.pos,r.state.type=e,r.state.contextualKeyword=t}function I(){if(r.state.isType)return void x(u.TokenType.greaterThan,1);const e=r.input.charCodeAt(r.state.pos+1);if(e===i.charCodes.greaterThan){const e=r.input.charCodeAt(r.state.pos+2)===i.charCodes.greaterThan?3:2;return r.input.charCodeAt(r.state.pos+e)===i.charCodes.equalsTo?void x(u.TokenType.assign,e+1):void x(u.TokenType.bitShiftR,e)}e===i.charCodes.equalsTo?x(u.TokenType.relationalOrEqual,2):x(u.TokenType.greaterThan,1)}function m(e){switch(e){case i.charCodes.numberSign:return++r.state.pos,void R(u.TokenType.hash);case i.charCodes.dot:return void function(){const e=r.input.charCodeAt(r.state.pos+1);e>=i.charCodes.digit0&&e<=i.charCodes.digit9?B(!0):e===i.charCodes.dot&&r.input.charCodeAt(r.state.pos+2)===i.charCodes.dot?(r.state.pos+=3,R(u.TokenType.ellipsis)):(++r.state.pos,R(u.TokenType.dot))}();case i.charCodes.leftParenthesis:return++r.state.pos,void R(u.TokenType.parenL);case i.charCodes.rightParenthesis:return++r.state.pos,void R(u.TokenType.parenR);case i.charCodes.semicolon:return++r.state.pos,void R(u.TokenType.semi);case i.charCodes.comma:return++r.state.pos,void R(u.TokenType.comma);case i.charCodes.leftSquareBracket:return++r.state.pos,void R(u.TokenType.bracketL);case i.charCodes.rightSquareBracket:return++r.state.pos,void R(u.TokenType.bracketR);case i.charCodes.leftCurlyBrace:return void(r.isFlowEnabled&&r.input.charCodeAt(r.state.pos+1)===i.charCodes.verticalBar?x(u.TokenType.braceBarL,2):(++r.state.pos,R(u.TokenType.braceL)));case i.charCodes.rightCurlyBrace:return++r.state.pos,void R(u.TokenType.braceR);case i.charCodes.colon:return void(r.input.charCodeAt(r.state.pos+1)===i.charCodes.colon?x(u.TokenType.doubleColon,2):(++r.state.pos,R(u.TokenType.colon)));case i.charCodes.questionMark:return void function(){const e=r.input.charCodeAt(r.state.pos+1),t=r.input.charCodeAt(r.state.pos+2);e!==i.charCodes.questionMark||r.isFlowEnabled&&r.state.isType?e!==i.charCodes.dot||t>=i.charCodes.digit0&&t<=i.charCodes.digit9?(++r.state.pos,R(u.TokenType.question)):(r.state.pos+=2,R(u.TokenType.questionDot)):t===i.charCodes.equalsTo?x(u.TokenType.assign,3):x(u.TokenType.nullishCoalescing,2)}();case i.charCodes.atSign:return++r.state.pos,void R(u.TokenType.at);case i.charCodes.graveAccent:return++r.state.pos,void R(u.TokenType.backQuote);case i.charCodes.digit0:{const e=r.input.charCodeAt(r.state.pos+1);if(e===i.charCodes.lowercaseX||e===i.charCodes.uppercaseX||e===i.charCodes.lowercaseO||e===i.charCodes.uppercaseO||e===i.charCodes.lowercaseB||e===i.charCodes.uppercaseB)return void function(){r.state.pos+=2;for(;;){const e=r.input.charCodeAt(r.state.pos);if(!(e>=i.charCodes.digit0&&e<=i.charCodes.digit9||e>=i.charCodes.lowercaseA&&e<=i.charCodes.lowercaseF||e>=i.charCodes.uppercaseA&&e<=i.charCodes.uppercaseF||e===i.charCodes.underscore))break;r.state.pos++}const e=r.input.charCodeAt(r.state.pos);e===i.charCodes.lowercaseN?(++r.state.pos,R(u.TokenType.bigint)):R(u.TokenType.num)}()}case i.charCodes.digit1:case i.charCodes.digit2:case i.charCodes.digit3:case i.charCodes.digit4:case i.charCodes.digit5:case i.charCodes.digit6:case i.charCodes.digit7:case i.charCodes.digit8:case i.charCodes.digit9:return void B(!1);case i.charCodes.quotationMark:case i.charCodes.apostrophe:return void function(e){for(r.state.pos++;;){if(r.state.pos>=r.input.length)return void(0,c.unexpected)("Unterminated string constant");const t=r.input.charCodeAt(r.state.pos);if(t===i.charCodes.backslash)r.state.pos++;else if(t===e)break;r.state.pos++}r.state.pos++,R(u.TokenType.string)}(e);case i.charCodes.slash:return void(r.input.charCodeAt(r.state.pos+1)===i.charCodes.equalsTo?x(u.TokenType.assign,2):x(u.TokenType.slash,1));case i.charCodes.percentSign:case i.charCodes.asterisk:return void function(e){let t=e===i.charCodes.asterisk?u.TokenType.star:u.TokenType.modulo,o=1,a=r.input.charCodeAt(r.state.pos+1);e===i.charCodes.asterisk&&a===i.charCodes.asterisk&&(o++,a=r.input.charCodeAt(r.state.pos+2),t=u.TokenType.exponent),a===i.charCodes.equalsTo&&r.input.charCodeAt(r.state.pos+2)!==i.charCodes.greaterThan&&(o++,t=u.TokenType.assign),x(t,o)}(e);case i.charCodes.verticalBar:case i.charCodes.ampersand:return void function(e){const t=r.input.charCodeAt(r.state.pos+1);if(t!==e){if(e===i.charCodes.verticalBar){if(t===i.charCodes.greaterThan)return void x(u.TokenType.pipeline,2);if(t===i.charCodes.rightCurlyBrace&&r.isFlowEnabled)return void x(u.TokenType.braceBarR,2)}t!==i.charCodes.equalsTo?x(e===i.charCodes.verticalBar?u.TokenType.bitwiseOR:u.TokenType.bitwiseAND,1):x(u.TokenType.assign,2)}else r.input.charCodeAt(r.state.pos+2)===i.charCodes.equalsTo?x(u.TokenType.assign,3):x(e===i.charCodes.verticalBar?u.TokenType.logicalOR:u.TokenType.logicalAND,2)}(e);case i.charCodes.caret:return void(r.input.charCodeAt(r.state.pos+1)===i.charCodes.equalsTo?x(u.TokenType.assign,2):x(u.TokenType.bitwiseXOR,1));case i.charCodes.plusSign:case i.charCodes.dash:return void function(e){const t=r.input.charCodeAt(r.state.pos+1);t!==e?t===i.charCodes.equalsTo?x(u.TokenType.assign,2):e===i.charCodes.plusSign?x(u.TokenType.plus,1):x(u.TokenType.minus,1):x(u.TokenType.preIncDec,2)}(e);case i.charCodes.lessThan:return void function(){const e=r.input.charCodeAt(r.state.pos+1);if(e===i.charCodes.lessThan)return r.input.charCodeAt(r.state.pos+2)===i.charCodes.equalsTo?void x(u.TokenType.assign,3):void(r.state.isType?x(u.TokenType.lessThan,1):x(u.TokenType.bitShiftL,2));e===i.charCodes.equalsTo?x(u.TokenType.relationalOrEqual,2):x(u.TokenType.lessThan,1)}();case i.charCodes.greaterThan:return void I();case i.charCodes.equalsTo:case i.charCodes.exclamationMark:return void function(e){const t=r.input.charCodeAt(r.state.pos+1);if(t!==i.charCodes.equalsTo)return e===i.charCodes.equalsTo&&t===i.charCodes.greaterThan?(r.state.pos+=2,void R(u.TokenType.arrow)):void x(e===i.charCodes.equalsTo?u.TokenType.eq:u.TokenType.bang,1);x(u.TokenType.equality,r.input.charCodeAt(r.state.pos+2)===i.charCodes.equalsTo?3:2)}(e);case i.charCodes.tilde:return void x(u.TokenType.tilde,1)}(0,c.unexpected)(`Unexpected character '${String.fromCharCode(e)}'`,r.state.pos)}function x(e,t){r.state.pos+=t,R(e)}function O(){for(;;){const e=r.input.charCodeAt(r.state.pos);if(!(e>=i.charCodes.digit0&&e<=i.charCodes.digit9||e===i.charCodes.underscore))break;r.state.pos++}}function B(e){let t=!1,o=!1;e||O();let a=r.input.charCodeAt(r.state.pos);a===i.charCodes.dot&&(++r.state.pos,O(),a=r.input.charCodeAt(r.state.pos)),a!==i.charCodes.uppercaseE&&a!==i.charCodes.lowercaseE||(a=r.input.charCodeAt(++r.state.pos),a!==i.charCodes.plusSign&&a!==i.charCodes.dash||++r.state.pos,O(),a=r.input.charCodeAt(r.state.pos)),a===i.charCodes.lowercaseN?(++r.state.pos,t=!0):a===i.charCodes.lowercaseM&&(++r.state.pos,o=!0),R(t?u.TokenType.bigint:o?u.TokenType.decimal:u.TokenType.num)}function w(){for(;r.state.pos<r.input.length;){const e=r.input.charCodeAt(r.state.pos);if(d.IS_IDENTIFIER_CHAR[e])r.state.pos++;else{if(e!==i.charCodes.backslash)break;if(r.state.pos+=2,r.input.charCodeAt(r.state.pos)===i.charCodes.leftCurlyBrace){for(;r.state.pos<r.input.length&&r.input.charCodeAt(r.state.pos)!==i.charCodes.rightCurlyBrace;)r.state.pos++;r.state.pos++}}}}o.TypeAndKeyword=y},
"540718e523": function _(t,n,e,o,i){o(),e.getNextContextId=function(){return e.nextContextId++},e.augmentError=function(t){if("pos"in t){const n=l(t.pos);t.message+=` (${n.line}:${n.column})`,t.loc=n}return t},e.locationForIndex=l,e.initParser=function(t,n,o,i){e.input=t,e.state=new c.default,e.nextContextId=1,e.isJSXEnabled=n,e.isTypeScriptEnabled=o,e.isFlowEnabled=i};const c=t("tslib").__importDefault(t("eda46439d5")),r=t("22746c8ce8");class s{constructor(t,n){this.line=t,this.column=n}}function l(t){let n=1,o=1;for(let i=0;i<t;i++)e.input.charCodeAt(i)===r.charCodes.lineFeed?(n++,o=1):o++;return new s(n,o)}e.Loc=s},
"eda46439d5": function _(t,i,s,o,n){o();const e=t("99ff836c64"),h=t("f0c35cbd76");s.Scope=class{constructor(t,i,s){this.startTokenIndex=t,this.endTokenIndex=i,this.isFunctionScope=s}};class p{constructor(t,i,s,o,n,e,h,p,l,r,_,c,a){this.potentialArrowAt=t,this.noAnonFunctionType=i,this.inDisallowConditionalTypesContext=s,this.tokensLength=o,this.scopesLength=n,this.pos=e,this.type=h,this.contextualKeyword=p,this.start=l,this.end=r,this.isType=_,this.scopeDepth=c,this.error=a}}s.StateSnapshot=p;class l{constructor(){l.prototype.__init.call(this),l.prototype.__init2.call(this),l.prototype.__init3.call(this),l.prototype.__init4.call(this),l.prototype.__init5.call(this),l.prototype.__init6.call(this),l.prototype.__init7.call(this),l.prototype.__init8.call(this),l.prototype.__init9.call(this),l.prototype.__init10.call(this),l.prototype.__init11.call(this),l.prototype.__init12.call(this),l.prototype.__init13.call(this)}__init(){this.potentialArrowAt=-1}__init2(){this.noAnonFunctionType=!1}__init3(){this.inDisallowConditionalTypesContext=!1}__init4(){this.tokens=[]}__init5(){this.scopes=[]}__init6(){this.pos=0}__init7(){this.type=h.TokenType.eof}__init8(){this.contextualKeyword=e.ContextualKeyword.NONE}__init9(){this.start=0}__init10(){this.end=0}__init11(){this.isType=!1}__init12(){this.scopeDepth=0}__init13(){this.error=null}snapshot(){return new p(this.potentialArrowAt,this.noAnonFunctionType,this.inDisallowConditionalTypesContext,this.tokens.length,this.scopes.length,this.pos,this.type,this.contextualKeyword,this.start,this.end,this.isType,this.scopeDepth,this.error)}restoreFromSnapshot(t){this.potentialArrowAt=t.potentialArrowAt,this.noAnonFunctionType=t.noAnonFunctionType,this.inDisallowConditionalTypesContext=t.inDisallowConditionalTypesContext,this.tokens.length=t.tokensLength,this.scopes.length=t.scopesLength,this.pos=t.pos,this.type=t.type,this.contextualKeyword=t.contextualKeyword,this.start=t.start,this.end=t.end,this.isType=t.isType,this.scopeDepth=t.scopeDepth,this.error=t.error}}s.default=l},
"99ff836c64": function _(_,e,s,t,a){t(),function(_){_[_.NONE=0]="NONE";_[_._abstract=1]="_abstract";_[_._accessor=2]="_accessor";_[_._as=3]="_as";_[_._assert=4]="_assert";_[_._asserts=5]="_asserts";_[_._async=6]="_async";_[_._await=7]="_await";_[_._checks=8]="_checks";_[_._constructor=9]="_constructor";_[_._declare=10]="_declare";_[_._enum=11]="_enum";_[_._exports=12]="_exports";_[_._from=13]="_from";_[_._get=14]="_get";_[_._global=15]="_global";_[_._implements=16]="_implements";_[_._infer=17]="_infer";_[_._interface=18]="_interface";_[_._is=19]="_is";_[_._keyof=20]="_keyof";_[_._mixins=21]="_mixins";_[_._module=22]="_module";_[_._namespace=23]="_namespace";_[_._of=24]="_of";_[_._opaque=25]="_opaque";_[_._out=26]="_out";_[_._override=27]="_override";_[_._private=28]="_private";_[_._protected=29]="_protected";_[_._proto=30]="_proto";_[_._public=31]="_public";_[_._readonly=32]="_readonly";_[_._require=33]="_require";_[_._satisfies=34]="_satisfies";_[_._set=35]="_set";_[_._static=36]="_static";_[_._symbol=37]="_symbol";_[_._type=38]="_type";_[_._unique=39]="_unique";_[_._using=40]="_using"}(s.ContextualKeyword||(s.ContextualKeyword={}))},
"f0c35cbd76": function _(e,n,r,t,a){t(),r.formatTokenType=function(e){switch(e){case r.TokenType.num:return"num";case r.TokenType.bigint:return"bigint";case r.TokenType.decimal:return"decimal";case r.TokenType.regexp:return"regexp";case r.TokenType.string:return"string";case r.TokenType.name:return"name";case r.TokenType.eof:return"eof";case r.TokenType.bracketL:return"[";case r.TokenType.bracketR:return"]";case r.TokenType.braceL:return"{";case r.TokenType.braceBarL:return"{|";case r.TokenType.braceR:return"}";case r.TokenType.braceBarR:return"|}";case r.TokenType.parenL:return"(";case r.TokenType.parenR:return")";case r.TokenType.comma:return",";case r.TokenType.semi:return";";case r.TokenType.colon:return":";case r.TokenType.doubleColon:return"::";case r.TokenType.dot:return".";case r.TokenType.question:return"?";case r.TokenType.questionDot:return"?.";case r.TokenType.arrow:return"=>";case r.TokenType.template:return"template";case r.TokenType.ellipsis:return"...";case r.TokenType.backQuote:return"`";case r.TokenType.dollarBraceL:return"${";case r.TokenType.at:return"@";case r.TokenType.hash:return"#";case r.TokenType.eq:return"=";case r.TokenType.assign:return"_=";case r.TokenType.preIncDec:case r.TokenType.postIncDec:return"++/--";case r.TokenType.bang:return"!";case r.TokenType.tilde:return"~";case r.TokenType.pipeline:return"|>";case r.TokenType.nullishCoalescing:return"??";case r.TokenType.logicalOR:return"||";case r.TokenType.logicalAND:return"&&";case r.TokenType.bitwiseOR:return"|";case r.TokenType.bitwiseXOR:return"^";case r.TokenType.bitwiseAND:return"&";case r.TokenType.equality:return"==/!=";case r.TokenType.lessThan:return"<";case r.TokenType.greaterThan:return">";case r.TokenType.relationalOrEqual:return"<=/>=";case r.TokenType.bitShiftL:return"<<";case r.TokenType.bitShiftR:return">>/>>>";case r.TokenType.plus:return"+";case r.TokenType.minus:return"-";case r.TokenType.modulo:return"%";case r.TokenType.star:return"*";case r.TokenType.slash:return"/";case r.TokenType.exponent:return"**";case r.TokenType.jsxName:return"jsxName";case r.TokenType.jsxText:return"jsxText";case r.TokenType.jsxEmptyText:return"jsxEmptyText";case r.TokenType.jsxTagStart:return"jsxTagStart";case r.TokenType.jsxTagEnd:return"jsxTagEnd";case r.TokenType.typeParameterStart:return"typeParameterStart";case r.TokenType.nonNullAssertion:return"nonNullAssertion";case r.TokenType._break:return"break";case r.TokenType._case:return"case";case r.TokenType._catch:return"catch";case r.TokenType._continue:return"continue";case r.TokenType._debugger:return"debugger";case r.TokenType._default:return"default";case r.TokenType._do:return"do";case r.TokenType._else:return"else";case r.TokenType._finally:return"finally";case r.TokenType._for:return"for";case r.TokenType._function:return"function";case r.TokenType._if:return"if";case r.TokenType._return:return"return";case r.TokenType._switch:return"switch";case r.TokenType._throw:return"throw";case r.TokenType._try:return"try";case r.TokenType._var:return"var";case r.TokenType._let:return"let";case r.TokenType._const:return"const";case r.TokenType._while:return"while";case r.TokenType._with:return"with";case r.TokenType._new:return"new";case r.TokenType._this:return"this";case r.TokenType._super:return"super";case r.TokenType._class:return"class";case r.TokenType._extends:return"extends";case r.TokenType._export:return"export";case r.TokenType._import:return"import";case r.TokenType._yield:return"yield";case r.TokenType._null:return"null";case r.TokenType._true:return"true";case r.TokenType._false:return"false";case r.TokenType._in:return"in";case r.TokenType._instanceof:return"instanceof";case r.TokenType._typeof:return"typeof";case r.TokenType._void:return"void";case r.TokenType._delete:return"delete";case r.TokenType._async:return"async";case r.TokenType._get:return"get";case r.TokenType._set:return"set";case r.TokenType._declare:return"declare";case r.TokenType._readonly:return"readonly";case r.TokenType._abstract:return"abstract";case r.TokenType._static:return"static";case r.TokenType._public:return"public";case r.TokenType._private:return"private";case r.TokenType._protected:return"protected";case r.TokenType._override:return"override";case r.TokenType._as:return"as";case r.TokenType._enum:return"enum";case r.TokenType._type:return"type";case r.TokenType._implements:return"implements";default:return""}},function(e){e[e.PRECEDENCE_MASK=15]="PRECEDENCE_MASK";e[e.IS_KEYWORD=16]="IS_KEYWORD";e[e.IS_ASSIGN=32]="IS_ASSIGN";e[e.IS_RIGHT_ASSOCIATIVE=64]="IS_RIGHT_ASSOCIATIVE";e[e.IS_PREFIX=128]="IS_PREFIX";e[e.IS_POSTFIX=256]="IS_POSTFIX";e[e.IS_EXPRESSION_START=512]="IS_EXPRESSION_START";e[e.num=512]="num";e[e.bigint=1536]="bigint";e[e.decimal=2560]="decimal";e[e.regexp=3584]="regexp";e[e.string=4608]="string";e[e.name=5632]="name";e[e.eof=6144]="eof";e[e.bracketL=7680]="bracketL";e[e.bracketR=8192]="bracketR";e[e.braceL=9728]="braceL";e[e.braceBarL=10752]="braceBarL";e[e.braceR=11264]="braceR";e[e.braceBarR=12288]="braceBarR";e[e.parenL=13824]="parenL";e[e.parenR=14336]="parenR";e[e.comma=15360]="comma";e[e.semi=16384]="semi";e[e.colon=17408]="colon";e[e.doubleColon=18432]="doubleColon";e[e.dot=19456]="dot";e[e.question=20480]="question";e[e.questionDot=21504]="questionDot";e[e.arrow=22528]="arrow";e[e.template=23552]="template";e[e.ellipsis=24576]="ellipsis";e[e.backQuote=25600]="backQuote";e[e.dollarBraceL=27136]="dollarBraceL";e[e.at=27648]="at";e[e.hash=29184]="hash";e[e.eq=29728]="eq";e[e.assign=30752]="assign";e[e.preIncDec=32640]="preIncDec";e[e.postIncDec=33664]="postIncDec";e[e.bang=34432]="bang";e[e.tilde=35456]="tilde";e[e.pipeline=35841]="pipeline";e[e.nullishCoalescing=36866]="nullishCoalescing";e[e.logicalOR=37890]="logicalOR";e[e.logicalAND=38915]="logicalAND";e[e.bitwiseOR=39940]="bitwiseOR";e[e.bitwiseXOR=40965]="bitwiseXOR";e[e.bitwiseAND=41990]="bitwiseAND";e[e.equality=43015]="equality";e[e.lessThan=44040]="lessThan";e[e.greaterThan=45064]="greaterThan";e[e.relationalOrEqual=46088]="relationalOrEqual";e[e.bitShiftL=47113]="bitShiftL";e[e.bitShiftR=48137]="bitShiftR";e[e.plus=49802]="plus";e[e.minus=50826]="minus";e[e.modulo=51723]="modulo";e[e.star=52235]="star";e[e.slash=53259]="slash";e[e.exponent=54348]="exponent";e[e.jsxName=55296]="jsxName";e[e.jsxText=56320]="jsxText";e[e.jsxEmptyText=57344]="jsxEmptyText";e[e.jsxTagStart=58880]="jsxTagStart";e[e.jsxTagEnd=59392]="jsxTagEnd";e[e.typeParameterStart=60928]="typeParameterStart";e[e.nonNullAssertion=61440]="nonNullAssertion";e[e._break=62480]="_break";e[e._case=63504]="_case";e[e._catch=64528]="_catch";e[e._continue=65552]="_continue";e[e._debugger=66576]="_debugger";e[e._default=67600]="_default";e[e._do=68624]="_do";e[e._else=69648]="_else";e[e._finally=70672]="_finally";e[e._for=71696]="_for";e[e._function=73232]="_function";e[e._if=73744]="_if";e[e._return=74768]="_return";e[e._switch=75792]="_switch";e[e._throw=77456]="_throw";e[e._try=77840]="_try";e[e._var=78864]="_var";e[e._let=79888]="_let";e[e._const=80912]="_const";e[e._while=81936]="_while";e[e._with=82960]="_with";e[e._new=84496]="_new";e[e._this=85520]="_this";e[e._super=86544]="_super";e[e._class=87568]="_class";e[e._extends=88080]="_extends";e[e._export=89104]="_export";e[e._import=90640]="_import";e[e._yield=91664]="_yield";e[e._null=92688]="_null";e[e._true=93712]="_true";e[e._false=94736]="_false";e[e._in=95256]="_in";e[e._instanceof=96280]="_instanceof";e[e._typeof=97936]="_typeof";e[e._void=98960]="_void";e[e._delete=99984]="_delete";e[e._async=100880]="_async";e[e._get=101904]="_get";e[e._set=102928]="_set";e[e._declare=103952]="_declare";e[e._readonly=104976]="_readonly";e[e._abstract=106e3]="_abstract";e[e._static=107024]="_static";e[e._public=107536]="_public";e[e._private=108560]="_private";e[e._protected=109584]="_protected";e[e._override=110608]="_override";e[e._as=112144]="_as";e[e._enum=113168]="_enum";e[e._type=114192]="_type";e[e._implements=115216]="_implements"}(r.TokenType||(r.TokenType={}))},
"22746c8ce8": function _(e,a,r,c,s){c(),r.isDigit=function(e){return e>=r.charCodes.digit0&&e<=r.charCodes.digit9||e>=r.charCodes.lowercaseA&&e<=r.charCodes.lowercaseF||e>=r.charCodes.uppercaseA&&e<=r.charCodes.uppercaseF},function(e){e[e.backSpace=8]="backSpace";e[e.lineFeed=10]="lineFeed";e[e.tab=9]="tab";e[e.carriageReturn=13]="carriageReturn";e[e.shiftOut=14]="shiftOut";e[e.space=32]="space";e[e.exclamationMark=33]="exclamationMark";e[e.quotationMark=34]="quotationMark";e[e.numberSign=35]="numberSign";e[e.dollarSign=36]="dollarSign";e[e.percentSign=37]="percentSign";e[e.ampersand=38]="ampersand";e[e.apostrophe=39]="apostrophe";e[e.leftParenthesis=40]="leftParenthesis";e[e.rightParenthesis=41]="rightParenthesis";e[e.asterisk=42]="asterisk";e[e.plusSign=43]="plusSign";e[e.comma=44]="comma";e[e.dash=45]="dash";e[e.dot=46]="dot";e[e.slash=47]="slash";e[e.digit0=48]="digit0";e[e.digit1=49]="digit1";e[e.digit2=50]="digit2";e[e.digit3=51]="digit3";e[e.digit4=52]="digit4";e[e.digit5=53]="digit5";e[e.digit6=54]="digit6";e[e.digit7=55]="digit7";e[e.digit8=56]="digit8";e[e.digit9=57]="digit9";e[e.colon=58]="colon";e[e.semicolon=59]="semicolon";e[e.lessThan=60]="lessThan";e[e.equalsTo=61]="equalsTo";e[e.greaterThan=62]="greaterThan";e[e.questionMark=63]="questionMark";e[e.atSign=64]="atSign";e[e.uppercaseA=65]="uppercaseA";e[e.uppercaseB=66]="uppercaseB";e[e.uppercaseC=67]="uppercaseC";e[e.uppercaseD=68]="uppercaseD";e[e.uppercaseE=69]="uppercaseE";e[e.uppercaseF=70]="uppercaseF";e[e.uppercaseG=71]="uppercaseG";e[e.uppercaseH=72]="uppercaseH";e[e.uppercaseI=73]="uppercaseI";e[e.uppercaseJ=74]="uppercaseJ";e[e.uppercaseK=75]="uppercaseK";e[e.uppercaseL=76]="uppercaseL";e[e.uppercaseM=77]="uppercaseM";e[e.uppercaseN=78]="uppercaseN";e[e.uppercaseO=79]="uppercaseO";e[e.uppercaseP=80]="uppercaseP";e[e.uppercaseQ=81]="uppercaseQ";e[e.uppercaseR=82]="uppercaseR";e[e.uppercaseS=83]="uppercaseS";e[e.uppercaseT=84]="uppercaseT";e[e.uppercaseU=85]="uppercaseU";e[e.uppercaseV=86]="uppercaseV";e[e.uppercaseW=87]="uppercaseW";e[e.uppercaseX=88]="uppercaseX";e[e.uppercaseY=89]="uppercaseY";e[e.uppercaseZ=90]="uppercaseZ";e[e.leftSquareBracket=91]="leftSquareBracket";e[e.backslash=92]="backslash";e[e.rightSquareBracket=93]="rightSquareBracket";e[e.caret=94]="caret";e[e.underscore=95]="underscore";e[e.graveAccent=96]="graveAccent";e[e.lowercaseA=97]="lowercaseA";e[e.lowercaseB=98]="lowercaseB";e[e.lowercaseC=99]="lowercaseC";e[e.lowercaseD=100]="lowercaseD";e[e.lowercaseE=101]="lowercaseE";e[e.lowercaseF=102]="lowercaseF";e[e.lowercaseG=103]="lowercaseG";e[e.lowercaseH=104]="lowercaseH";e[e.lowercaseI=105]="lowercaseI";e[e.lowercaseJ=106]="lowercaseJ";e[e.lowercaseK=107]="lowercaseK";e[e.lowercaseL=108]="lowercaseL";e[e.lowercaseM=109]="lowercaseM";e[e.lowercaseN=110]="lowercaseN";e[e.lowercaseO=111]="lowercaseO";e[e.lowercaseP=112]="lowercaseP";e[e.lowercaseQ=113]="lowercaseQ";e[e.lowercaseR=114]="lowercaseR";e[e.lowercaseS=115]="lowercaseS";e[e.lowercaseT=116]="lowercaseT";e[e.lowercaseU=117]="lowercaseU";e[e.lowercaseV=118]="lowercaseV";e[e.lowercaseW=119]="lowercaseW";e[e.lowercaseX=120]="lowercaseX";e[e.lowercaseY=121]="lowercaseY";e[e.lowercaseZ=122]="lowercaseZ";e[e.leftCurlyBrace=123]="leftCurlyBrace";e[e.verticalBar=124]="verticalBar";e[e.rightCurlyBrace=125]="rightCurlyBrace";e[e.tilde=126]="tilde";e[e.nonBreakingSpace=160]="nonBreakingSpace";e[e.oghamSpaceMark=5760]="oghamSpaceMark";e[e.lineSeparator=8232]="lineSeparator";e[e.paragraphSeparator=8233]="paragraphSeparator"}(r.charCodes||(r.charCodes={}))},
"bc94bbadc1": function _(e,t,n,o,r){o(),n.isContextual=function(e){return s.state.contextualKeyword===e},n.isLookaheadContextual=function(e){const t=(0,a.lookaheadTypeAndKeyword)();return t.type===c.TokenType.name&&t.contextualKeyword===e},n.eatContextual=u,n.expectContextual=function(e){u(e)||k()},n.canInsertSemicolon=d,n.hasPrecedingLineBreak=f,n.hasFollowingLineBreak=function(){const e=(0,a.nextTokenStart)();for(let t=s.state.end;t<e;t++){const e=s.input.charCodeAt(t);if(e===i.charCodes.lineFeed||e===i.charCodes.carriageReturn||8232===e||8233===e)return!0}return!1},n.isLineTerminator=p,n.semicolon=function(){p()||k('Unexpected token, expected ";"')},n.expect=function(e){(0,a.eat)(e)||k(`Unexpected token, expected "${(0,c.formatTokenType)(e)}"`)},n.unexpected=k;const a=e("bfb18d0576"),c=e("f0c35cbd76"),i=e("22746c8ce8"),s=e("540718e523");function u(e){return s.state.contextualKeyword===e&&(0,a.eat)(c.TokenType.name)}function d(){return(0,a.match)(c.TokenType.eof)||(0,a.match)(c.TokenType.braceR)||f()}function f(){const e=s.state.tokens[s.state.tokens.length-1];for(let t=e?e.end:0;t<s.state.start;t++){const e=s.input.charCodeAt(t);if(e===i.charCodes.lineFeed||e===i.charCodes.carriageReturn||8232===e||8233===e)return!0}return!1}function p(){return(0,a.eat)(c.TokenType.semi)||d()}function k(e="Unexpected token",t=s.state.start){if(s.state.error)return;const n=new SyntaxError(e);n.pos=t,s.state.error=n,s.state.pos=s.input.length,(0,a.finishToken)(c.TokenType.eof)}},
"364148c9f0": function _(I,r,E,t,_){t();const e=I("22746c8ce8"),n=I("2a3176644a");function R(I){if(I<48)return 36===I;if(I<58)return!0;if(I<65)return!1;if(I<91)return!0;if(I<97)return 95===I;if(I<123)return!0;if(I<128)return!1;throw new Error("Should not be called with non-ASCII char code.")}E.IS_IDENTIFIER_CHAR=new Uint8Array(65536);for(let I=0;I<128;I++)E.IS_IDENTIFIER_CHAR[I]=R(I)?1:0;for(let I=128;I<65536;I++)E.IS_IDENTIFIER_CHAR[I]=1;for(const I of n.WHITESPACE_CHARS)E.IS_IDENTIFIER_CHAR[I]=0;E.IS_IDENTIFIER_CHAR[8232]=0,E.IS_IDENTIFIER_CHAR[8233]=0,E.IS_IDENTIFIER_START=E.IS_IDENTIFIER_CHAR.slice();for(let I=e.charCodes.digit0;I<=e.charCodes.digit9;I++)E.IS_IDENTIFIER_START[I]=0},
"2a3176644a": function _(c,a,e,S,o){S();const n=c("22746c8ce8");e.WHITESPACE_CHARS=[9,11,12,n.charCodes.space,n.charCodes.nonBreakingSpace,n.charCodes.oghamSpaceMark,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8239,8287,12288,65279],e.skipWhiteSpace=/(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g,e.IS_WHITESPACE=new Uint8Array(65536);for(const c of e.WHITESPACE_CHARS)e.IS_WHITESPACE[c]=1},
"e6eb78033b": function _(e,t,o,n,c){n(),o.default=function(){let e=0,t=0,o=a.state.pos;for(;o<a.input.length&&(t=a.input.charCodeAt(o),!(t<r.charCodes.lowercaseA||t>r.charCodes.lowercaseZ));){const n=h.READ_WORD_TREE[e+(t-r.charCodes.lowercaseA)+1];if(-1===n)break;e=n,o++}const n=h.READ_WORD_TREE[e];if(n>-1&&!s.IS_IDENTIFIER_CHAR[t])return a.state.pos=o,void(1&n?(0,i.finishToken)(n>>>1):(0,i.finishToken)(f.TokenType.name,n>>>1));for(;o<a.input.length;){const e=a.input.charCodeAt(o);if(s.IS_IDENTIFIER_CHAR[e])o++;else if(e===r.charCodes.backslash){if(o+=2,a.input.charCodeAt(o)===r.charCodes.leftCurlyBrace){for(;o<a.input.length&&a.input.charCodeAt(o)!==r.charCodes.rightCurlyBrace;)o++;o++}}else{if(e!==r.charCodes.atSign||a.input.charCodeAt(o+1)!==r.charCodes.atSign)break;o+=2}}a.state.pos=o,(0,i.finishToken)(f.TokenType.name)};const a=e("540718e523"),r=e("22746c8ce8"),s=e("364148c9f0"),i=e("bfb18d0576"),h=e("3d4c06ef43"),f=e("f0c35cbd76")},
"3d4c06ef43": function _(e,o,t,n,y){n();const _=e("99ff836c64"),T=e("f0c35cbd76");t.READ_WORD_TREE=new Int32Array([-1,27,783,918,1755,2376,2862,3483,-1,3699,-1,4617,4752,4833,5130,5508,5940,-1,6480,6939,7749,8181,8451,8613,-1,8829,-1,-1,-1,54,243,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,432,-1,-1,-1,675,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,81,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,108,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,135,-1,-1,-1,-1,-1,-1,-1,-1,-1,162,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,189,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,216,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._abstract<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,270,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,297,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,324,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,351,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,378,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,405,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._accessor<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._as<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,459,-1,-1,-1,-1,-1,594,-1,-1,-1,-1,-1,-1,486,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,513,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,540,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._assert<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,567,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._asserts<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,621,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,648,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._async<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,702,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,729,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,756,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._await<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,810,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,837,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,864,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,891,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._break<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,945,-1,-1,-1,-1,-1,-1,1107,-1,-1,-1,1242,-1,-1,1350,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,972,1026,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,999,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._case<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1053,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1080,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._catch<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1134,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1161,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1188,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1215,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._checks<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1269,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1296,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1323,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._class<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1377,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1404,1620,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1431,-1,-1,-1,-1,-1,-1,1+(T.TokenType._const<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1458,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1485,-1,-1,-1,-1,-1,-1,-1,-1,1512,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1539,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1566,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1593,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._constructor<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1647,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1674,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1701,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1728,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._continue<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1782,-1,-1,-1,-1,-1,-1,-1,-1,-1,2349,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1809,1971,-1,-1,2106,-1,-1,-1,-1,-1,2241,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1836,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1863,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1890,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1917,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1944,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._debugger<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1998,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2025,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2052,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2079,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._declare<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2133,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2160,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2187,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2214,-1,-1,-1,-1,-1,-1,1+(T.TokenType._default<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2268,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2295,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2322,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._delete<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._do<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2403,-1,2484,-1,-1,-1,-1,-1,-1,-1,-1,-1,2565,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2430,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2457,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._else<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2511,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2538,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._enum<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2592,-1,-1,-1,2727,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2619,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2646,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2673,-1,-1,-1,-1,-1,-1,1+(T.TokenType._export<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2700,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._exports<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2754,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2781,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2808,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2835,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._extends<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2889,-1,-1,-1,-1,-1,-1,-1,2997,-1,-1,-1,-1,-1,3159,-1,-1,3213,-1,-1,3294,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2916,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2943,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2970,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._false<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3024,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3051,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3078,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3105,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3132,-1,1+(T.TokenType._finally<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3186,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._for<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3240,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3267,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._from<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3321,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3348,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3375,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3402,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3429,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3456,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._function<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3510,-1,-1,-1,-1,-1,-1,3564,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3537,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._get<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3591,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3618,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3645,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3672,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._global<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3726,-1,-1,-1,-1,-1,-1,3753,4077,-1,-1,-1,-1,4590,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._if<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3780,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3807,-1,-1,3996,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3834,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3861,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3888,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3915,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3942,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3969,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._implements<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4023,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4050,-1,-1,-1,-1,-1,-1,1+(T.TokenType._import<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._in<<1),-1,-1,-1,-1,-1,4104,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4185,4401,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4131,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4158,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._infer<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4212,-1,-1,-1,-1,-1,-1,-1,4239,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4266,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4293,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4320,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4347,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4374,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._instanceof<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4428,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4455,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4482,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4509,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4536,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4563,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._interface<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._is<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4644,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4671,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4698,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4725,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._keyof<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4779,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4806,-1,-1,-1,-1,-1,-1,1+(T.TokenType._let<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4860,-1,-1,-1,-1,-1,4995,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4887,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4914,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4941,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4968,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._mixins<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5022,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5049,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5076,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5103,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._module<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5157,-1,-1,-1,5373,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5427,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5184,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5211,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5238,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5265,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5292,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5319,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5346,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._namespace<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5400,-1,-1,-1,1+(T.TokenType._new<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5454,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5481,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._null<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5535,-1,-1,-1,-1,-1,-1,-1,-1,-1,5562,-1,-1,-1,-1,5697,5751,-1,-1,-1,-1,_.ContextualKeyword._of<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5589,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5616,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5643,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5670,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._opaque<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5724,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._out<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5778,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5805,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5832,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5859,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5886,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5913,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._override<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5967,-1,-1,6345,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5994,-1,-1,-1,-1,-1,6129,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6021,-1,-1,-1,-1,-1,6048,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6075,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6102,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._private<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6156,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6183,-1,-1,-1,-1,-1,-1,-1,-1,-1,6318,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6210,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6237,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6264,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6291,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._protected<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._proto<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6372,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6399,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6426,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6453,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._public<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6507,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6534,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6696,-1,-1,6831,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6561,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6588,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6615,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6642,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6669,-1,_.ContextualKeyword._readonly<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6723,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6750,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6777,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6804,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._require<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6858,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6885,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6912,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._return<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6966,-1,-1,-1,7182,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7236,7371,-1,7479,-1,7614,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,6993,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7020,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7047,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7074,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7101,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7128,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7155,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._satisfies<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7209,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._set<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7263,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7290,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7317,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7344,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._static<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7398,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7425,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7452,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._super<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7506,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7533,-1,-1,-1,-1,-1,-1,-1,-1,-1,7560,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7587,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._switch<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7641,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7668,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7695,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7722,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._symbol<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7776,-1,-1,-1,-1,-1,-1,-1,-1,-1,7938,-1,-1,-1,-1,-1,-1,8046,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7803,-1,-1,-1,-1,-1,-1,-1,-1,7857,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7830,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._this<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7884,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7911,-1,-1,-1,1+(T.TokenType._throw<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7965,-1,-1,-1,8019,-1,-1,-1,-1,-1,-1,7992,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._true<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._try<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8073,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8100,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._type<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8127,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8154,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._typeof<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8208,-1,-1,-1,-1,8343,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8235,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8262,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8289,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8316,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._unique<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8370,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8397,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8424,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,_.ContextualKeyword._using<<1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8478,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8532,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8505,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._var<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8559,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8586,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._void<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8640,8748,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8667,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8694,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8721,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._while<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8775,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8802,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._with<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8856,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8883,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8910,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8937,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1+(T.TokenType._yield<<1),-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])},
"14d4ae78a4": function _(e,n,t,i,r){i(),t.default=function(e,n=e.currentIndex()){let t=n+1;if(f(e,t)){const i=e.identifierNameAtIndex(n);return{isType:!1,leftName:i,rightName:i,endIndex:t}}if(t++,f(e,t))return{isType:!0,leftName:null,rightName:null,endIndex:t};if(t++,f(e,t))return{isType:!1,leftName:e.identifierNameAtIndex(n),rightName:e.identifierNameAtIndex(n+2),endIndex:t};if(t++,f(e,t))return{isType:!0,leftName:null,rightName:null,endIndex:t};throw new Error(`Unexpected import/export specifier at ${n}`)};const d=e("f0c35cbd76");function f(e,n){const t=e.tokens[n];return t.type===d.TokenType.braceR||t.type===d.TokenType.comma}},
"1ff9c9004b": function _(e,t,n,o,i){o(),n.getNonTypeIdentifiers=function(e,t){const n=(0,f.default)(t),o=new Set;for(let t=0;t<e.tokens.length;t++){const i=e.tokens[t];if(i.type!==a.TokenType.name||i.isType||i.identifierRole!==s.IdentifierRole.Access&&i.identifierRole!==s.IdentifierRole.ObjectShorthand&&i.identifierRole!==s.IdentifierRole.ExportAccess||i.shadowsGlobal||o.add(e.identifierNameForToken(i)),i.type===a.TokenType.jsxTagStart&&o.add(n.base),i.type===a.TokenType.jsxTagStart&&t+1<e.tokens.length&&e.tokens[t+1].type===a.TokenType.jsxTagEnd&&(o.add(n.base),o.add(n.fragmentBase)),i.type===a.TokenType.jsxName&&i.identifierRole===s.IdentifierRole.Access){const n=e.identifierNameForToken(i);(0,r.startsWithLowerCase)(n)&&e.tokens[t+1].type!==a.TokenType.dot||o.add(e.identifierNameForToken(i))}}return o};const d=e("tslib"),s=e("bfb18d0576"),a=e("f0c35cbd76"),r=e("a0e577c292"),f=d.__importDefault(e("d797c101ed"))},
"a0e577c292": function _(e,t,s,o,n){o(),s.startsWithLowerCase=d;const i=e("tslib"),r=i.__importDefault(e("c6b7812f89")),a=e("bfb18d0576"),h=e("f0c35cbd76"),c=e("22746c8ce8"),p=i.__importDefault(e("d797c101ed")),m=i.__importDefault(e("a46f119f74"));class l extends m.default{__init(){this.lastLineNumber=1}__init2(){this.lastIndex=0}__init3(){this.filenameVarName=null}__init4(){this.esmAutomaticImportNameResolutions={}}__init5(){this.cjsAutomaticModuleNameResolutions={}}constructor(e,t,s,o,n){super(),this.rootTransformer=e,this.tokens=t,this.importProcessor=s,this.nameManager=o,this.options=n,l.prototype.__init.call(this),l.prototype.__init2.call(this),l.prototype.__init3.call(this),l.prototype.__init4.call(this),l.prototype.__init5.call(this),this.jsxPragmaInfo=(0,p.default)(n),this.isAutomaticRuntime="automatic"===n.jsxRuntime,this.jsxImportSource=n.jsxImportSource||"react"}process(){return!!this.tokens.matches1(h.TokenType.jsxTagStart)&&(this.processJSXTag(),!0)}getPrefixCode(){let e="";if(this.filenameVarName&&(e+=`const ${this.filenameVarName} = ${JSON.stringify(this.options.filePath||"")};`),this.isAutomaticRuntime)if(this.importProcessor)for(const[t,s]of Object.entries(this.cjsAutomaticModuleNameResolutions))e+=`var ${s} = require("${t}");`;else{const{createElement:t,...s}=this.esmAutomaticImportNameResolutions;t&&(e+=`import {createElement as ${t}} from "${this.jsxImportSource}";`);const o=Object.entries(s).map((([e,t])=>`${e} as ${t}`)).join(", ");if(o){e+=`import {${o}} from "${this.jsxImportSource+(this.options.production?"/jsx-runtime":"/jsx-dev-runtime")}";`}}return e}processJSXTag(){const{jsxRole:e,start:t}=this.tokens.currentToken(),s=this.options.production?null:this.getElementLocationCode(t);this.isAutomaticRuntime&&e!==a.JSXRole.KeyAfterPropSpread?this.transformTagToJSXFunc(s,e):this.transformTagToCreateElement(s)}getElementLocationCode(e){return`lineNumber: ${this.getLineNumberForIndex(e)}`}getLineNumberForIndex(e){const t=this.tokens.code;for(;this.lastIndex<e&&this.lastIndex<t.length;)"\n"===t[this.lastIndex]&&this.lastLineNumber++,this.lastIndex++;return this.lastLineNumber}transformTagToJSXFunc(e,t){const s=t===a.JSXRole.StaticChildren;this.tokens.replaceToken(this.getJSXFuncInvocationCode(s));let o=null;if(this.tokens.matches1(h.TokenType.jsxTagEnd))this.tokens.replaceToken(`${this.getFragmentCode()}, {`),this.processAutomaticChildrenAndEndProps(t);else{if(this.processTagIntro(),this.tokens.appendCode(", {"),o=this.processProps(!0),this.tokens.matches2(h.TokenType.slash,h.TokenType.jsxTagEnd))this.tokens.appendCode("}");else{if(!this.tokens.matches1(h.TokenType.jsxTagEnd))throw new Error("Expected either /> or > at the end of the tag.");this.tokens.removeToken(),this.processAutomaticChildrenAndEndProps(t)}o&&this.tokens.appendCode(`, ${o}`)}for(this.options.production||(null===o&&this.tokens.appendCode(", void 0"),this.tokens.appendCode(`, ${s}, ${this.getDevSource(e)}, this`)),this.tokens.removeInitialToken();!this.tokens.matches1(h.TokenType.jsxTagEnd);)this.tokens.removeToken();this.tokens.replaceToken(")")}transformTagToCreateElement(e){if(this.tokens.replaceToken(this.getCreateElementInvocationCode()),this.tokens.matches1(h.TokenType.jsxTagEnd))this.tokens.replaceToken(`${this.getFragmentCode()}, null`),this.processChildren(!0);else if(this.processTagIntro(),this.processPropsObjectWithDevInfo(e),this.tokens.matches2(h.TokenType.slash,h.TokenType.jsxTagEnd));else{if(!this.tokens.matches1(h.TokenType.jsxTagEnd))throw new Error("Expected either /> or > at the end of the tag.");this.tokens.removeToken(),this.processChildren(!0)}for(this.tokens.removeInitialToken();!this.tokens.matches1(h.TokenType.jsxTagEnd);)this.tokens.removeToken();this.tokens.replaceToken(")")}getJSXFuncInvocationCode(e){return this.options.production?e?this.claimAutoImportedFuncInvocation("jsxs","/jsx-runtime"):this.claimAutoImportedFuncInvocation("jsx","/jsx-runtime"):this.claimAutoImportedFuncInvocation("jsxDEV","/jsx-dev-runtime")}getCreateElementInvocationCode(){if(this.isAutomaticRuntime)return this.claimAutoImportedFuncInvocation("createElement","");{const{jsxPragmaInfo:e}=this;return`${this.importProcessor&&this.importProcessor.getIdentifierReplacement(e.base)||e.base}${e.suffix}(`}}getFragmentCode(){if(this.isAutomaticRuntime)return this.claimAutoImportedName("Fragment",this.options.production?"/jsx-runtime":"/jsx-dev-runtime");{const{jsxPragmaInfo:e}=this;return(this.importProcessor&&this.importProcessor.getIdentifierReplacement(e.fragmentBase)||e.fragmentBase)+e.fragmentSuffix}}claimAutoImportedFuncInvocation(e,t){const s=this.claimAutoImportedName(e,t);return this.importProcessor?`${s}.call(void 0, `:`${s}(`}claimAutoImportedName(e,t){if(this.importProcessor){const s=this.jsxImportSource+t;return this.cjsAutomaticModuleNameResolutions[s]||(this.cjsAutomaticModuleNameResolutions[s]=this.importProcessor.getFreeIdentifierForPath(s)),`${this.cjsAutomaticModuleNameResolutions[s]}.${e}`}return this.esmAutomaticImportNameResolutions[e]||(this.esmAutomaticImportNameResolutions[e]=this.nameManager.claimFreeName(`_${e}`)),this.esmAutomaticImportNameResolutions[e]}processTagIntro(){let e=this.tokens.currentIndex()+1;for(;this.tokens.tokens[e].isType||!this.tokens.matches2AtIndex(e-1,h.TokenType.jsxName,h.TokenType.jsxName)&&!this.tokens.matches2AtIndex(e-1,h.TokenType.greaterThan,h.TokenType.jsxName)&&!this.tokens.matches1AtIndex(e,h.TokenType.braceL)&&!this.tokens.matches1AtIndex(e,h.TokenType.jsxTagEnd)&&!this.tokens.matches2AtIndex(e,h.TokenType.slash,h.TokenType.jsxTagEnd);)e++;if(e===this.tokens.currentIndex()+1){const e=this.tokens.identifierName();d(e)&&this.tokens.replaceToken(`'${e}'`)}for(;this.tokens.currentIndex()<e;)this.rootTransformer.processToken()}processPropsObjectWithDevInfo(e){const t=this.options.production?"":`__self: this, __source: ${this.getDevSource(e)}`;this.tokens.matches1(h.TokenType.jsxName)||this.tokens.matches1(h.TokenType.braceL)?(this.tokens.appendCode(", {"),this.processProps(!1),t?this.tokens.appendCode(` ${t}}`):this.tokens.appendCode("}")):t?this.tokens.appendCode(`, {${t}}`):this.tokens.appendCode(", null")}processProps(e){let t=null;for(;;){if(this.tokens.matches2(h.TokenType.jsxName,h.TokenType.eq)){const s=this.tokens.identifierName();if(e&&"key"===s){null!==t&&this.tokens.appendCode(t.replace(/[^\n]/g,"")),this.tokens.removeToken(),this.tokens.removeToken();const e=this.tokens.snapshot();this.processPropValue(),t=this.tokens.dangerouslyGetAndRemoveCodeSinceSnapshot(e);continue}this.processPropName(s),this.tokens.replaceToken(": "),this.processPropValue()}else if(this.tokens.matches1(h.TokenType.jsxName)){const e=this.tokens.identifierName();this.processPropName(e),this.tokens.appendCode(": true")}else{if(!this.tokens.matches1(h.TokenType.braceL))break;this.tokens.replaceToken(""),this.rootTransformer.processBalancedCode(),this.tokens.replaceToken("")}this.tokens.appendCode(",")}return t}processPropName(e){e.includes("-")?this.tokens.replaceToken(`'${e}'`):this.tokens.copyToken()}processPropValue(){this.tokens.matches1(h.TokenType.braceL)?(this.tokens.replaceToken(""),this.rootTransformer.processBalancedCode(),this.tokens.replaceToken("")):this.tokens.matches1(h.TokenType.jsxTagStart)?this.processJSXTag():this.processStringPropValue()}processStringPropValue(){const e=this.tokens.currentToken(),t=this.tokens.code.slice(e.start+1,e.end-1),s=k(t),o=function(e){let t="";for(let s=0;s<e.length;s++){const o=e[s];if("\n"===o)if(/\s/.test(e[s+1]))for(t+=" ";s<e.length&&/\s/.test(e[s+1]);)s++;else t+="\n";else if("&"===o){const{entity:o,newI:n}=u(e,s+1);t+=o,s=n-1}else t+=o}return JSON.stringify(t)}(t);this.tokens.replaceToken(o+s)}processAutomaticChildrenAndEndProps(e){e===a.JSXRole.StaticChildren?(this.tokens.appendCode(" children: ["),this.processChildren(!1),this.tokens.appendCode("]}")):(e===a.JSXRole.OneChild&&this.tokens.appendCode(" children: "),this.processChildren(!1),this.tokens.appendCode("}"))}processChildren(e){let t=e;for(;;){if(this.tokens.matches2(h.TokenType.jsxTagStart,h.TokenType.slash))return;let e=!1;if(this.tokens.matches1(h.TokenType.braceL))this.tokens.matches2(h.TokenType.braceL,h.TokenType.braceR)?(this.tokens.replaceToken(""),this.tokens.replaceToken("")):(this.tokens.replaceToken(t?", ":""),this.rootTransformer.processBalancedCode(),this.tokens.replaceToken(""),e=!0);else if(this.tokens.matches1(h.TokenType.jsxTagStart))this.tokens.appendCode(t?", ":""),this.processJSXTag(),e=!0;else{if(!this.tokens.matches1(h.TokenType.jsxText)&&!this.tokens.matches1(h.TokenType.jsxEmptyText))throw new Error("Unexpected token when processing JSX children.");e=this.processChildTextElement(t)}e&&(t=!0)}}processChildTextElement(e){const t=this.tokens.currentToken(),s=this.tokens.code.slice(t.start,t.end),o=k(s),n=function(e){let t="",s="",o=!1,n=!1;for(let i=0;i<e.length;i++){const r=e[i];if(" "===r||"\t"===r||"\r"===r)o||(s+=r);else if("\n"===r)s="",o=!0;else{if(n&&o&&(t+=" "),t+=s,s="","&"===r){const{entity:s,newI:o}=u(e,i+1);i=o-1,t+=s}else t+=r;n=!0,o=!1}}o||(t+=s);return JSON.stringify(t)}(s);return'""'===n?(this.tokens.replaceToken(o),!1):(this.tokens.replaceToken(`${e?", ":""}${n}${o}`),!0)}getDevSource(e){return`{fileName: ${this.getFilenameVarName()}, ${e}}`}getFilenameVarName(){return this.filenameVarName||(this.filenameVarName=this.nameManager.claimFreeName("_jsxFileName")),this.filenameVarName}}function d(e){const t=e.charCodeAt(0);return t>=c.charCodes.lowercaseA&&t<=c.charCodes.lowercaseZ}function k(e){let t=0,s=0;for(const o of e)"\n"===o?(t++,s=0):" "===o&&s++;return"\n".repeat(t)+" ".repeat(s)}function u(e,t){let s,o="",n=0,i=t;if("#"===e[i]){let t,o=10;if(i++,"x"===e[i])for(o=16,i++,t=i;i<e.length&&((a=e.charCodeAt(i))>=c.charCodes.digit0&&a<=c.charCodes.digit9||a>=c.charCodes.lowercaseA&&a<=c.charCodes.lowercaseF||a>=c.charCodes.uppercaseA&&a<=c.charCodes.uppercaseF);)i++;else for(t=i;i<e.length&&T(e.charCodeAt(i));)i++;if(";"===e[i]){const n=e.slice(t,i);n&&(i++,s=String.fromCodePoint(parseInt(n,o)))}}else for(;i<e.length&&n++<10;){const t=e[i];if(i++,";"===t){s=r.default.get(o);break}o+=t}var a;return s?{entity:s,newI:i}:{entity:"&",newI:t}}function T(e){return e>=c.charCodes.digit0&&e<=c.charCodes.digit9}s.default=l},
"c6b7812f89": function _(a,e,r,i,l){i(),r.default=new Map([["quot",'"'],["amp","&"],["apos","'"],["lt","<"],["gt",">"],["nbsp","\xa0"],["iexcl","\xa1"],["cent","\xa2"],["pound","\xa3"],["curren","\xa4"],["yen","\xa5"],["brvbar","\xa6"],["sect","\xa7"],["uml","\xa8"],["copy","\xa9"],["ordf","\xaa"],["laquo","\xab"],["not","\xac"],["shy","\xad"],["reg","\xae"],["macr","\xaf"],["deg","\xb0"],["plusmn","\xb1"],["sup2","\xb2"],["sup3","\xb3"],["acute","\xb4"],["micro","\xb5"],["para","\xb6"],["middot","\xb7"],["cedil","\xb8"],["sup1","\xb9"],["ordm","\xba"],["raquo","\xbb"],["frac14","\xbc"],["frac12","\xbd"],["frac34","\xbe"],["iquest","\xbf"],["Agrave","\xc0"],["Aacute","\xc1"],["Acirc","\xc2"],["Atilde","\xc3"],["Auml","\xc4"],["Aring","\xc5"],["AElig","\xc6"],["Ccedil","\xc7"],["Egrave","\xc8"],["Eacute","\xc9"],["Ecirc","\xca"],["Euml","\xcb"],["Igrave","\xcc"],["Iacute","\xcd"],["Icirc","\xce"],["Iuml","\xcf"],["ETH","\xd0"],["Ntilde","\xd1"],["Ograve","\xd2"],["Oacute","\xd3"],["Ocirc","\xd4"],["Otilde","\xd5"],["Ouml","\xd6"],["times","\xd7"],["Oslash","\xd8"],["Ugrave","\xd9"],["Uacute","\xda"],["Ucirc","\xdb"],["Uuml","\xdc"],["Yacute","\xdd"],["THORN","\xde"],["szlig","\xdf"],["agrave","\xe0"],["aacute","\xe1"],["acirc","\xe2"],["atilde","\xe3"],["auml","\xe4"],["aring","\xe5"],["aelig","\xe6"],["ccedil","\xe7"],["egrave","\xe8"],["eacute","\xe9"],["ecirc","\xea"],["euml","\xeb"],["igrave","\xec"],["iacute","\xed"],["icirc","\xee"],["iuml","\xef"],["eth","\xf0"],["ntilde","\xf1"],["ograve","\xf2"],["oacute","\xf3"],["ocirc","\xf4"],["otilde","\xf5"],["ouml","\xf6"],["divide","\xf7"],["oslash","\xf8"],["ugrave","\xf9"],["uacute","\xfa"],["ucirc","\xfb"],["uuml","\xfc"],["yacute","\xfd"],["thorn","\xfe"],["yuml","\xff"],["OElig","\u0152"],["oelig","\u0153"],["Scaron","\u0160"],["scaron","\u0161"],["Yuml","\u0178"],["fnof","\u0192"],["circ","\u02c6"],["tilde","\u02dc"],["Alpha","\u0391"],["Beta","\u0392"],["Gamma","\u0393"],["Delta","\u0394"],["Epsilon","\u0395"],["Zeta","\u0396"],["Eta","\u0397"],["Theta","\u0398"],["Iota","\u0399"],["Kappa","\u039a"],["Lambda","\u039b"],["Mu","\u039c"],["Nu","\u039d"],["Xi","\u039e"],["Omicron","\u039f"],["Pi","\u03a0"],["Rho","\u03a1"],["Sigma","\u03a3"],["Tau","\u03a4"],["Upsilon","\u03a5"],["Phi","\u03a6"],["Chi","\u03a7"],["Psi","\u03a8"],["Omega","\u03a9"],["alpha","\u03b1"],["beta","\u03b2"],["gamma","\u03b3"],["delta","\u03b4"],["epsilon","\u03b5"],["zeta","\u03b6"],["eta","\u03b7"],["theta","\u03b8"],["iota","\u03b9"],["kappa","\u03ba"],["lambda","\u03bb"],["mu","\u03bc"],["nu","\u03bd"],["xi","\u03be"],["omicron","\u03bf"],["pi","\u03c0"],["rho","\u03c1"],["sigmaf","\u03c2"],["sigma","\u03c3"],["tau","\u03c4"],["upsilon","\u03c5"],["phi","\u03c6"],["chi","\u03c7"],["psi","\u03c8"],["omega","\u03c9"],["thetasym","\u03d1"],["upsih","\u03d2"],["piv","\u03d6"],["ensp","\u2002"],["emsp","\u2003"],["thinsp","\u2009"],["zwnj","\u200c"],["zwj","\u200d"],["lrm","\u200e"],["rlm","\u200f"],["ndash","\u2013"],["mdash","\u2014"],["lsquo","\u2018"],["rsquo","\u2019"],["sbquo","\u201a"],["ldquo","\u201c"],["rdquo","\u201d"],["bdquo","\u201e"],["dagger","\u2020"],["Dagger","\u2021"],["bull","\u2022"],["hellip","\u2026"],["permil","\u2030"],["prime","\u2032"],["Prime","\u2033"],["lsaquo","\u2039"],["rsaquo","\u203a"],["oline","\u203e"],["frasl","\u2044"],["euro","\u20ac"],["image","\u2111"],["weierp","\u2118"],["real","\u211c"],["trade","\u2122"],["alefsym","\u2135"],["larr","\u2190"],["uarr","\u2191"],["rarr","\u2192"],["darr","\u2193"],["harr","\u2194"],["crarr","\u21b5"],["lArr","\u21d0"],["uArr","\u21d1"],["rArr","\u21d2"],["dArr","\u21d3"],["hArr","\u21d4"],["forall","\u2200"],["part","\u2202"],["exist","\u2203"],["empty","\u2205"],["nabla","\u2207"],["isin","\u2208"],["notin","\u2209"],["ni","\u220b"],["prod","\u220f"],["sum","\u2211"],["minus","\u2212"],["lowast","\u2217"],["radic","\u221a"],["prop","\u221d"],["infin","\u221e"],["ang","\u2220"],["and","\u2227"],["or","\u2228"],["cap","\u2229"],["cup","\u222a"],["int","\u222b"],["there4","\u2234"],["sim","\u223c"],["cong","\u2245"],["asymp","\u2248"],["ne","\u2260"],["equiv","\u2261"],["le","\u2264"],["ge","\u2265"],["sub","\u2282"],["sup","\u2283"],["nsub","\u2284"],["sube","\u2286"],["supe","\u2287"],["oplus","\u2295"],["otimes","\u2297"],["perp","\u22a5"],["sdot","\u22c5"],["lceil","\u2308"],["rceil","\u2309"],["lfloor","\u230a"],["rfloor","\u230b"],["lang","\u2329"],["rang","\u232a"],["loz","\u25ca"],["spades","\u2660"],["clubs","\u2663"],["hearts","\u2665"],["diams","\u2666"]])},
"d797c101ed": function _(e,t,n,a,f){function r(e){let t=e.indexOf(".");return-1===t&&(t=e.length),[e.slice(0,t),e.slice(t)]}a(),n.default=function(e){const[t,n]=r(e.jsxPragma||"React.createElement"),[a,f]=r(e.jsxFragmentPragma||"React.Fragment");return{base:t,suffix:n,fragmentBase:a,fragmentSuffix:f}}},
"a46f119f74": function _(e,t,r,u,d){u();r.default=class{getPrefixCode(){return""}getHoistedCode(){return""}getSuffixCode(){return""}}},
"03a5a23920": function _(e,t,n,o,d){o(),n.default=function({code:e,mappings:t},n,o,d,a){const l=function(e,t){const n=new Array(t.length);let o=0,d=t[o].start,c=0;for(let a=0;a<e.length;a++)a===d&&(n[o]=d-c,o++,d=t[o].start),e.charCodeAt(a)===r.charCodes.lineFeed&&(c=a+1);return n}(d,a),i=new c.GenMapping({file:o.compiledFilename});let s=0,f=t[0];for(;void 0===f&&s<t.length-1;)s++,f=t[s];let g=0,h=0;f!==h&&(0,c.maybeAddSegment)(i,g,0,n,g,0);for(let o=0;o<e.length;o++){if(o===f){const e=f-h,d=l[s];for((0,c.maybeAddSegment)(i,g,e,n,g,d);(f===o||void 0===f)&&s<t.length-1;)s++,f=t[s]}e.charCodeAt(o)===r.charCodes.lineFeed&&(g++,h=o+1,f!==h&&(0,c.maybeAddSegment)(i,g,0,n,g,0))}const{sourceRoot:m,sourcesContent:u,...p}=(0,c.toEncodedMap)(i);return p};const c=e("dba3894e29"),r=e("22746c8ce8")},
"dba3894e29": function _(n,e,t,o,r){o(),t.addMapping=function(n,e){return C(!1,n,e)},t.addSegment=function(n,e,t,o,r,s,u,i){return h(!1,n,e,t,o,r,s,u,i)},t.allMappings=function(n){const e=[],{_mappings:t,_sources:o,_names:r}=n;for(let n=0;n<t.length;n++){const s=t[n];for(let t=0;t<s.length;t++){const u=s[t],i={line:n+1,column:u[c]};let p,m,_;1!==u.length&&(p=o.array[u[l]],m={line:u[a]+1,column:u[g]},5===u.length&&(_=r.array[u[f]])),e.push({generated:i,source:p,original:m,name:_})}}return e},t.fromMap=function(n){const e=new i.TraceMap(n),t=new m({file:e.file,sourceRoot:e.sourceRoot});y(t._names,e.names),y(t._sources,e.sources),t._sourcesContent=e.sourcesContent||e.sources.map((()=>null)),t._mappings=(0,i.decodedMappings)(e),e.ignoreList&&y(t._ignoreList,e.ignoreList);return t},t.setIgnore=function(n,e,t=!0){const{_sources:o,_sourcesContent:r,_ignoreList:u}=n,i=(0,s.put)(o,e);i===r.length&&(r[i]=null);t?(0,s.put)(u,i):(0,s.remove)(u,i)},t.setSourceContent=function(n,e,t){const{_sources:o,_sourcesContent:r}=n,u=(0,s.put)(o,e);r[u]=t},t.toDecodedMap=_,t.toEncodedMap=function(n){const e=_(n);return Object.assign(Object.assign({},e),{mappings:(0,u.encode)(e.mappings)})};const s=n("39961f1de0"),u=n("4b3e7fe51a"),i=n("ed38200738"),c=0,l=1,a=2,g=3,f=4,p=-1;class m{constructor({file:n,sourceRoot:e}={}){this._names=new s.SetArray,this._sources=new s.SetArray,this._sourcesContent=[],this._mappings=[],this.file=n,this.sourceRoot=e,this._ignoreList=new s.SetArray}}t.GenMapping=m;t.maybeAddSegment=(n,e,t,o,r,s,u,i)=>h(!0,n,e,t,o,r,s,u,i);function _(n){const{_mappings:e,_sources:t,_sourcesContent:o,_names:r,_ignoreList:s}=n;return function(n){const{length:e}=n;let t=e;for(let e=t-1;e>=0&&!(n[e].length>0);t=e,e--);t<e&&(n.length=t)}(e),{version:3,file:n.file||void 0,names:r.array,sourceRoot:n.sourceRoot||void 0,sources:t.array,sourcesContent:o,mappings:e,ignoreList:s.array}}function h(n,e,t,o,r,u,i,m,_){const{_mappings:h,_sources:y,_sourcesContent:C,_names:M}=e,L=function(n,e){for(let t=n.length;t<=e;t++)n[t]=[];return n[e]}(h,t),b=function(n,e){let t=n.length;for(let o=t-1;o>=0;t=o--){if(e>=n[o][c])break}return t}(L,o);if(!r){if(n&&function(n,e){if(0===e)return!0;const t=n[e-1];return 1===t.length}(L,b))return;return d(L,b,[o])}const R=(0,s.put)(y,r),S=m?(0,s.put)(M,m):p;if(R===C.length&&(C[R]=null!=_?_:null),!n||!function(n,e,t,o,r,s){if(0===e)return!1;const u=n[e-1];return 1!==u.length&&(t===u[l]&&o===u[a]&&r===u[g]&&s===(5===u.length?u[f]:p))}(L,b,R,u,i,S))return d(L,b,m?[o,R,u,i,S]:[o,R,u,i])}function d(n,e,t){for(let t=n.length;t>e;t--)n[t]=n[t-1];n[e]=t}function y(n,e){for(let t=0;t<e.length;t++)(0,s.put)(n,e[t])}function C(n,e,t){const{generated:o,source:r,original:s,name:u,content:i}=t;return r?h(n,e,o.line-1,o.column,r,s.line-1,s.column,u,i):h(n,e,o.line-1,o.column,null,null,null,null,null)}t.maybeAddMapping=(n,e)=>C(!0,n,e)},
"39961f1de0": function _(n,t,o,r,e){r(),o.get=i,o.pop=function(n){const{array:t,_indexes:o}=n;if(0===t.length)return;const r=t.pop();o[r]=void 0},o.put=function(n,t){const o=i(n,t);if(void 0!==o)return o;const{array:r,_indexes:e}=n,s=r.push(t);return e[t]=s-1},o.remove=function(n,t){const o=i(n,t);if(void 0===o)return;const{array:r,_indexes:e}=n;for(let n=o+1;n<r.length;n++){const t=r[n];r[n-1]=t,e[t]--}e[t]=void 0,r.pop()};function i(n,t){return n._indexes[t]}o.SetArray=class{constructor(){this._indexes={__proto__:null},this.array=[]}}},
"4b3e7fe51a": function _(t,e,n,o,s){o(),n.decode=function(t){const{length:e}=t,n=new a(t),o=[];let s=0,r=0,c=0,i=0,f=0;do{const t=n.indexOf(";"),e=[];let l=!0,h=0;for(s=0;n.pos<t;){let o;s=u(n,s),s<h&&(l=!1),h=s,d(n,t)?(r=u(n,r),c=u(n,c),i=u(n,i),d(n,t)?(f=u(n,f),o=[s,r,c,i,f]):o=[s,r,c,i]):o=[s],e.push(o),n.pos++}l||A(e),o.push(e),n.pos=t+1}while(n.pos<=e);return o},n.decodeGeneratedRanges=function(t){const{length:e}=t,n=new a(t),o=[],s=[];let r=0,c=0,i=0,f=0,l=0,h=0,p=0,g=0;do{const t=n.indexOf(";");let e=0;for(;n.pos<t;n.pos++){if(e=u(n,e),!d(n,t)){const t=s.pop();t[2]=r,t[3]=e;continue}const a=u(n,0),b=2&a,x=4&a;let y,A=null,C=w;if(1&a){const t=u(n,c);i=u(n,c===t?i:0),c=t,y=[r,e,0,0,t,i]}else y=[r,e,0,0];if(y.isScope=!!x,b){const t=f,e=l;f=u(n,f);const o=t===f;l=u(n,o?l:0),h=u(n,o&&e===l?h:0),A=[f,l,h]}if(y.callsite=A,d(n,t)){C=[];do{p=r,g=e;const t=u(n,0);let o;if(t<-1){o=[[u(n,0)]];for(let e=-1;e>t;e--){const t=p;p=u(n,p),g=u(n,p===t?g:0);const e=u(n,0);o.push([e,p,g])}}else o=[[t]];C.push(o)}while(d(n,t))}y.bindings=C,o.push(y),s.push(y)}r++,n.pos=t+1}while(n.pos<e);return o},n.decodeOriginalScopes=function(t){const{length:e}=t,n=new a(t),o=[],s=[];let r=0;for(;n.pos<e;n.pos++){r=u(n,r);const t=u(n,0);if(!d(n,e)){const e=s.pop();e[2]=r,e[3]=t;continue}const c=u(n,0),i=1&u(n,0)?[r,t,0,0,c,u(n,0)]:[r,t,0,0,c];let f=w;if(d(n,e)){f=[];do{const t=u(n,0);f.push(t)}while(d(n,e))}i.vars=f,o.push(i),s.push(i)}return o},n.encode=function(t){const e=new g;let n=0,o=0,s=0,i=0;for(let f=0;f<t.length;f++){const l=t[f];if(f>0&&e.write(c),0===l.length)continue;let u=0;for(let t=0;t<l.length;t++){const c=l[t];t>0&&e.write(r),u=h(e,c[0],u),1!==c.length&&(n=h(e,c[1],n),o=h(e,c[2],o),s=h(e,c[3],s),4!==c.length&&(i=h(e,c[4],i)))}}return e.flush()},n.encodeGeneratedRanges=function(t){if(0===t.length)return"";const e=new g;for(let n=0;n<t.length;)n=x(t,n,e,[0,0,0,0,0,0,0]);return e.flush()},n.encodeOriginalScopes=function(t){const e=new g;for(let n=0;n<t.length;)n=b(t,n,e,[0]);return e.flush()};const r=",".charCodeAt(0),c=";".charCodeAt(0),i="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",f=new Uint8Array(64),l=new Uint8Array(128);for(let t=0;t<64;t++){const e=i.charCodeAt(t);f[t]=e,l[e]=t}function u(t,e){let n=0,o=0,s=0;do{const e=t.next();s=l[e],n|=(31&s)<<o,o+=5}while(32&s);const r=1&n;return n>>>=1,r&&(n=-2147483648|-n),e+n}function h(t,e,n){let o=e-n;o=o<0?-o<<1|1:o<<1;do{let e=31&o;o>>>=5,o>0&&(e|=32),t.write(f[e])}while(o>0);return e}function d(t,e){return!(t.pos>=e)&&t.peek()!==r}const p="undefined"!=typeof TextDecoder?new TextDecoder:"undefined"!=typeof Buffer?{decode:t=>Buffer.from(t.buffer,t.byteOffset,t.byteLength).toString()}:{decode(t){let e="";for(let n=0;n<t.length;n++)e+=String.fromCharCode(t[n]);return e}};class g{constructor(){this.pos=0,this.out="",this.buffer=new Uint8Array(16384)}write(t){const{buffer:e}=this;e[this.pos++]=t,16384===this.pos&&(this.out+=p.decode(e),this.pos=0)}flush(){const{buffer:t,out:e,pos:n}=this;return n>0?e+p.decode(t.subarray(0,n)):e}}class a{constructor(t){this.pos=0,this.buffer=t}next(){return this.buffer.charCodeAt(this.pos++)}peek(){return this.buffer.charCodeAt(this.pos)}indexOf(t){const{buffer:e,pos:n}=this,o=e.indexOf(t,n);return-1===o?e.length:o}}const w=[];function b(t,e,n,o){const s=t[e],{0:c,1:i,2:f,3:l,4:u,vars:d}=s;e>0&&n.write(r),o[0]=h(n,c,o[0]),h(n,i,0),h(n,u,0);h(n,6===s.length?1:0,0),6===s.length&&h(n,s[5],0);for(const t of d)h(n,t,0);for(e++;e<t.length;){const s=t[e],{0:r,1:c}=s;if(r>f||r===f&&c>=l)break;e=b(t,e,n,o)}return n.write(r),o[0]=h(n,f,o[0]),h(n,l,0),e}function x(t,e,n,o){const s=t[e],{0:c,1:i,2:f,3:l,isScope:u,callsite:d,bindings:p}=s;o[0]<c?(y(n,o[0],c),o[0]=c,o[1]=0):e>0&&n.write(r),o[1]=h(n,s[1],o[1]);if(h(n,(6===s.length?1:0)|(d?2:0)|(u?4:0),0),6===s.length){const{4:t,5:e}=s;t!==o[2]&&(o[3]=0),o[2]=h(n,t,o[2]),o[3]=h(n,e,o[3])}if(d){const{0:t,1:e,2:r}=s.callsite;t!==o[4]?(o[5]=0,o[6]=0):e!==o[5]&&(o[6]=0),o[4]=h(n,t,o[4]),o[5]=h(n,e,o[5]),o[6]=h(n,r,o[6])}if(p)for(const t of p){t.length>1&&h(n,-t.length,0);h(n,t[0][0],0);let e=c,o=i;for(let s=1;s<t.length;s++){const r=t[s];e=h(n,r[1],e),o=h(n,r[2],o),h(n,r[0],0)}}for(e++;e<t.length;){const s=t[e],{0:r,1:c}=s;if(r>f||r===f&&c>=l)break;e=x(t,e,n,o)}return o[0]<f?(y(n,o[0],f),o[0]=f,o[1]=0):n.write(r),o[1]=h(n,l,o[1]),e}function y(t,e,n){do{t.write(c)}while(++e<n)}function A(t){t.sort(C)}function C(t,e){return t[0]-e[0]}},
"ed38200738": function _(n,e,t,o,r){o(),t.allGeneratedPositionsFor=function(n,e){const{source:t,line:o,column:r,bias:s}=e;return k(n,t,o,r,s||F,!0)},t.decodedMap=function(n){return J(n,U(n))},t.decodedMappings=U,t.eachMapping=function(n,e){const t=U(n),{names:o,resolvedSources:r}=n;for(let n=0;n<t.length;n++){const s=t[n];for(let t=0;t<s.length;t++){const l=s[t],u=n+1,i=l[0];let c=null,f=null,d=null,a=null;1!==l.length&&(c=r[l[1]],f=l[2]+1,d=l[3]),5===l.length&&(a=o[l[4]]),e({generatedLine:u,generatedColumn:i,source:c,originalLine:f,originalColumn:d,name:a})}}},t.encodedMap=function(n){return J(n,A(n))},t.encodedMappings=A,t.generatedPositionFor=function(n,e){const{source:t,line:o,column:r,bias:s}=e;return k(n,t,o,r,s||K,!1)},t.isIgnored=function(n,e){const{ignoreList:t}=n;if(null==t)return!1;const o=B(n,e);return-1!==o&&t.includes(o)},t.originalPositionFor=function(n,e){let{line:t,column:o,bias:r}=e;if(t--,t<0)throw new Error(P);if(o<0)throw new Error(D);const s=U(n);if(t>=s.length)return W(null,null,null,null);const l=s[t],u=j(l,n._decodedMemo,t,o,r||K);if(-1===u)return W(null,null,null,null);const i=l[u];if(1===i.length)return W(null,null,null,null);const{names:c,resolvedSources:h}=n;return W(h[i[f]],i[d]+1,i[a],5===i.length?c[i[g]]:null)},t.presortedDecodedMap=G,t.sourceContentFor=function(n,e){const{sourcesContent:t}=n;if(null==t)return null;const o=B(n,e);return-1===o?null:t[o]},t.traceSegment=function(n,e,t){const o=U(n);if(e>=o.length)return null;const r=o[e],s=j(r,n._decodedMemo,e,t,K);return-1===s?null:r[s]};const s=n("tslib"),l=n("4b3e7fe51a"),u=s.__importDefault(n("92bc7d86f0"));function i(n,e){return e&&!e.endsWith("/")&&(e+="/"),(0,u.default)(n,e)}const c=0,f=1,d=2,a=3,g=4,h=1,m=2;function p(n,e){for(let t=e;t<n.length;t++)if(!_(n[t]))return t;return n.length}function _(n){for(let e=1;e<n.length;e++)if(n[e][c]<n[e-1][c])return!1;return!0}function v(n,e){return e||(n=n.slice()),n.sort(M)}function M(n,e){return n[c]-e[c]}let S=!1;function b(n,e,t){for(let o=t+1;o<n.length&&n[o][c]===e;t=o++);return t}function y(n,e,t){for(let o=t-1;o>=0&&n[o][c]===e;t=o--);return t}function L(){return{lastKey:-1,lastNeedle:-1,lastIndex:-1}}function x(n,e,t,o){const{lastKey:r,lastNeedle:s,lastIndex:l}=t;let u=0,i=n.length-1;if(o===r){if(e===s)return S=-1!==l&&n[l][c]===e,l;e>=s?u=-1===l?0:l:i=l}return t.lastKey=o,t.lastNeedle=e,t.lastIndex=function(n,e,t,o){for(;t<=o;){const r=t+(o-t>>1),s=n[r][c]-e;if(0===s)return S=!0,r;s<0?t=r+1:o=r-1}return S=!1,t-1}(n,e,u,i)}function w(n,e,t){for(let t=n.length;t>e;t--)n[t]=n[t-1];n[e]=t}function C(){return{__proto__:null}}function O(n){return"string"==typeof n?JSON.parse(n):n}function E(n,e,t,o,r,s,l,u,i,c,f){const{sections:d}=n;for(let n=0;n<d.length;n++){const{map:a,offset:g}=d[n];let h=c,m=f;if(n+1<d.length){const e=d[n+1].offset;h=Math.min(c,u+e.line),h===c?m=Math.min(f,i+e.column):h<c&&(m=i+e.column)}N(a,e,t,o,r,s,l,u+g.line,i+g.column,h,m)}}function N(n,e,t,o,r,s,l,u,i,h,m){const p=O(n);if("sections"in p)return E(...arguments);const _=new T(p,e),v=o.length,M=s.length,S=U(_),{resolvedSources:b,sourcesContent:y,ignoreList:L}=_;if(I(o,b),I(s,_.names),y)I(r,y);else for(let n=0;n<b.length;n++)r.push(null);if(L)for(let n=0;n<L.length;n++)l.push(L[n]+v);for(let n=0;n<S.length;n++){const e=u+n;if(e>h)return;const o=R(t,e),r=0===n?i:0,s=S[n];for(let n=0;n<s.length;n++){const t=s[n],l=r+t[c];if(e===h&&l>=m)return;if(1===t.length){o.push([l]);continue}const u=v+t[f],i=t[d],p=t[a];o.push(4===t.length?[l,u,i,p]:[l,u,i,p,M+t[g]])}}}function I(n,e){for(let t=0;t<e.length;t++)n.push(e[t])}function R(n,e){for(let t=n.length;t<=e;t++)n[t]=[];return n[e]}t.AnyMap=function(n,e){const t=O(n);if(!("sections"in t))return new T(t,e);const o=[],r=[],s=[],l=[],u=[];E(t,e,o,r,s,l,u,0,0,1/0,1/0);return G({version:3,file:t.file,names:l,sources:r,sourcesContent:s,mappings:o,ignoreList:u})};const P="`line` must be greater than 0 (lines start at line 1)",D="`column` must be greater than or equal to 0 (columns start at column 0)",F=-1;t.LEAST_UPPER_BOUND=F;const K=1;t.GREATEST_LOWER_BOUND=K;class T{constructor(n,e){const t="string"==typeof n;if(!t&&n._decodedMemo)return n;const o=t?JSON.parse(n):n,{version:r,file:s,names:l,sourceRoot:u,sources:c,sourcesContent:f}=o;this.version=r,this.file=s,this.names=l||[],this.sourceRoot=u,this.sources=c,this.sourcesContent=f,this.ignoreList=o.ignoreList||o.x_google_ignoreList||void 0;const d=i(u||"",function(n){if(!n)return"";const e=n.lastIndexOf("/");return n.slice(0,e+1)}(e));this.resolvedSources=c.map((n=>i(n||"",d)));const{mappings:a}=o;"string"==typeof a?(this._encoded=a,this._decoded=void 0):(this._encoded=void 0,this._decoded=function(n,e){const t=p(n,0);if(t===n.length)return n;e||(n=n.slice());for(let o=t;o<n.length;o=p(n,o+1))n[o]=v(n[o],e);return n}(a,t)),this._decodedMemo={lastKey:-1,lastNeedle:-1,lastIndex:-1},this._bySources=void 0,this._bySourceMemos=void 0}}function A(n){var e,t;return null!==(e=(t=n)._encoded)&&void 0!==e?e:t._encoded=(0,l.encode)(n._decoded)}function U(n){var e;return(e=n)._decoded||(e._decoded=(0,l.decode)(n._encoded))}function B(n,e){const{sources:t,resolvedSources:o}=n;let r=t.indexOf(e);return-1===r&&(r=o.indexOf(e)),r}function G(n,e){const t=new T(J(n,[]),e);return t._decoded=n.mappings,t}function J(n,e){return{version:n.version,file:n.file,names:n.names,sourceRoot:n.sourceRoot,sources:n.sources,sourcesContent:n.sourcesContent,mappings:e,ignoreList:n.ignoreList||n.x_google_ignoreList}}function W(n,e,t,o){return{source:n,line:e,column:t,name:o}}function q(n,e){return{line:n,column:e}}function j(n,e,t,o,r){let s=x(n,o,e,t);return S?s=(r===F?b:y)(n,o,s):r===F&&s++,-1===s||s===n.length?-1:s}function k(n,e,t,o,r,s){var l;if(--t<0)throw new Error(P);if(o<0)throw new Error(D);const{sources:u,resolvedSources:i}=n;let g=u.indexOf(e);if(-1===g&&(g=i.indexOf(e)),-1===g)return s?[]:q(null,null);const p=(l=n)._bySources||(l._bySources=function(n,e){const t=e.map(C);for(let o=0;o<n.length;o++){const r=n[o];for(let n=0;n<r.length;n++){const s=r[n];if(1===s.length)continue;const l=s[f],u=s[d],i=s[a],g=t[l],h=g[u]||(g[u]=[]),m=e[l];let p=b(h,i,x(h,i,m,u));m.lastIndex=++p,w(h,p,[i,o,s[c]])}}return t}(U(n),n._bySourceMemos=u.map(L))),_=p[g][t];if(null==_)return s?[]:q(null,null);const v=n._bySourceMemos[g];if(s)return function(n,e,t,o,r){let s=j(n,e,t,o,K);if(S||r!==F||s++,-1===s||s===n.length)return[];const l=S?o:n[s][c];S||(s=y(n,l,s));const u=b(n,l,s),i=[];for(;s<=u;s++){const e=n[s];i.push(q(e[h]+1,e[m]))}return i}(_,v,t,o,r);const M=j(_,v,t,o,r);if(-1===M)return q(null,null);const O=_[M];return q(O[h]+1,O[m])}t.TraceMap=T},
"92bc7d86f0": function _(t,e,n,s,r){s(),n.default=function(t,e){if(!t&&!e)return"";const n=p(t);let s=n.type;if(e&&7!==s){const t=p(e),r=t.type;switch(s){case 1:n.hash=t.hash;case 2:n.query=t.query;case 3:case 4:!function(t,e){l(e,e.type),"/"===t.path?t.path=e.path:t.path=function(t){if(t.endsWith("/.."))return t;const e=t.lastIndexOf("/");return t.slice(0,e+1)}(e.path)+t.path}(n,t);case 5:n.user=t.user,n.host=t.host,n.port=t.port;case 6:n.scheme=t.scheme}r>s&&(s=r)}l(n,s);const r=n.query+n.hash;switch(s){case 2:case 3:return r;case 4:{const s=n.path.slice(1);return s?i(e||t)&&!i(s)?"./"+s+r:s+r:r||"."}case 5:return n.path+r;default:return n.scheme+"//"+n.user+n.host+n.port+n.path+r}};const c=/^[\w+.-]+:\/\//,h=/^([\w+.-]+:)\/\/([^@/#?]*@)?([^:/#?]*)(:\d+)?(\/[^#?]*)?(\?[^#]*)?(#.*)?/,o=/^file:(?:\/\/((?![a-z]:)[^/#?]*)?)?(\/?[^#?]*)(\?[^#]*)?(#.*)?/i;function u(t){return t.startsWith("/")}function i(t){return/^[.?#]/.test(t)}function a(t){const e=h.exec(t);return f(e[1],e[2]||"",e[3],e[4]||"",e[5]||"/",e[6]||"",e[7]||"")}function f(t,e,n,s,r,c,h){return{scheme:t,user:e,host:n,port:s,path:r,query:c,hash:h,type:7}}function p(t){if(function(t){return t.startsWith("//")}(t)){const e=a("http:"+t);return e.scheme="",e.type=6,e}if(u(t)){const e=a("http://foo.com"+t);return e.scheme="",e.host="",e.type=5,e}if(function(t){return t.startsWith("file:")}(t))return function(t){const e=o.exec(t),n=e[2];return f("file:","",e[1]||"","",u(n)?n:"/"+n,e[3]||"",e[4]||"")}(t);if(function(t){return c.test(t)}(t))return a(t);const e=a("http://foo.com/"+t);return e.scheme="",e.host="",e.type=t?t.startsWith("?")?3:t.startsWith("#")?2:4:1,e}function l(t,e){const n=e<=4,s=t.path.split("/");let r=1,c=0,h=!1;for(let t=1;t<s.length;t++){const e=s[t];e?(h=!1,"."!==e&&(".."!==e?(s[r++]=e,c++):c?(h=!0,c--,r--):n&&(s[r++]=e))):h=!0}let o="";for(let t=1;t<r;t++)o+="/"+s[t];(!o||h&&!o.endsWith("/.."))&&(o+="/"),t.path=o}},
"40e1a4d3af": function _(e,n,t,a,l){a();const o={require:'\n    import {createRequire as CREATE_REQUIRE_NAME} from "module";\n    const require = CREATE_REQUIRE_NAME(import.meta.url);\n  ',interopRequireWildcard:"\n    function interopRequireWildcard(obj) {\n      if (obj && obj.__esModule) {\n        return obj;\n      } else {\n        var newObj = {};\n        if (obj != null) {\n          for (var key in obj) {\n            if (Object.prototype.hasOwnProperty.call(obj, key)) {\n              newObj[key] = obj[key];\n            }\n          }\n        }\n        newObj.default = obj;\n        return newObj;\n      }\n    }\n  ",interopRequireDefault:"\n    function interopRequireDefault(obj) {\n      return obj && obj.__esModule ? obj : { default: obj };\n    }\n  ",createNamedExportFrom:"\n    function createNamedExportFrom(obj, localName, importedName) {\n      Object.defineProperty(exports, localName, {enumerable: true, configurable: true, get: () => obj[importedName]});\n    }\n  ",createStarExport:'\n    function createStarExport(obj) {\n      Object.keys(obj)\n        .filter((key) => key !== "default" && key !== "__esModule")\n        .forEach((key) => {\n          if (exports.hasOwnProperty(key)) {\n            return;\n          }\n          Object.defineProperty(exports, key, {enumerable: true, configurable: true, get: () => obj[key]});\n        });\n    }\n  ',nullishCoalesce:"\n    function nullishCoalesce(lhs, rhsFn) {\n      if (lhs != null) {\n        return lhs;\n      } else {\n        return rhsFn();\n      }\n    }\n  ",asyncNullishCoalesce:"\n    async function asyncNullishCoalesce(lhs, rhsFn) {\n      if (lhs != null) {\n        return lhs;\n      } else {\n        return await rhsFn();\n      }\n    }\n  ",optionalChain:"\n    function optionalChain(ops) {\n      let lastAccessLHS = undefined;\n      let value = ops[0];\n      let i = 1;\n      while (i < ops.length) {\n        const op = ops[i];\n        const fn = ops[i + 1];\n        i += 2;\n        if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {\n          return undefined;\n        }\n        if (op === 'access' || op === 'optionalAccess') {\n          lastAccessLHS = value;\n          value = fn(value);\n        } else if (op === 'call' || op === 'optionalCall') {\n          value = fn((...args) => value.call(lastAccessLHS, ...args));\n          lastAccessLHS = undefined;\n        }\n      }\n      return value;\n    }\n  ",asyncOptionalChain:"\n    async function asyncOptionalChain(ops) {\n      let lastAccessLHS = undefined;\n      let value = ops[0];\n      let i = 1;\n      while (i < ops.length) {\n        const op = ops[i];\n        const fn = ops[i + 1];\n        i += 2;\n        if ((op === 'optionalAccess' || op === 'optionalCall') && value == null) {\n          return undefined;\n        }\n        if (op === 'access' || op === 'optionalAccess') {\n          lastAccessLHS = value;\n          value = await fn(value);\n        } else if (op === 'call' || op === 'optionalCall') {\n          value = await fn((...args) => value.call(lastAccessLHS, ...args));\n          lastAccessLHS = undefined;\n        }\n      }\n      return value;\n    }\n  ",optionalChainDelete:"\n    function optionalChainDelete(ops) {\n      const result = OPTIONAL_CHAIN_NAME(ops);\n      return result == null ? true : result;\n    }\n  ",asyncOptionalChainDelete:"\n    async function asyncOptionalChainDelete(ops) {\n      const result = await ASYNC_OPTIONAL_CHAIN_NAME(ops);\n      return result == null ? true : result;\n    }\n  "};class i{__init(){this.helperNames={}}__init2(){this.createRequireName=null}constructor(e){this.nameManager=e,i.prototype.__init.call(this),i.prototype.__init2.call(this)}getHelperName(e){let n=this.helperNames[e];return n||(n=this.nameManager.claimFreeName(`_${e}`),this.helperNames[e]=n,n)}emitHelpers(){let e="";this.helperNames.optionalChainDelete&&this.getHelperName("optionalChain"),this.helperNames.asyncOptionalChainDelete&&this.getHelperName("asyncOptionalChain");for(const[n,t]of Object.entries(o)){const a=this.helperNames[n];let l=t;"optionalChainDelete"===n?l=l.replace("OPTIONAL_CHAIN_NAME",this.helperNames.optionalChain):"asyncOptionalChainDelete"===n?l=l.replace("ASYNC_OPTIONAL_CHAIN_NAME",this.helperNames.asyncOptionalChain):"require"===n&&(null===this.createRequireName&&(this.createRequireName=this.nameManager.claimFreeName("_createRequire")),l=l.replace(/CREATE_REQUIRE_NAME/g,this.createRequireName)),a&&(e+=" ",e+=l.replace(n,a).replace(/\s+/g," ").trim())}return e}}t.HelperManager=i},
"5f4ada3fc1": function _(e,n,o,t,i){t(),o.default=function(e,n,o){if(!f(e,o))return;!function(e,n,o){const t=[];let i=n.length-1;for(let f=e.tokens.length-1;;f--){for(;t.length>0&&t[t.length-1].startTokenIndex===f+1;)t.pop();for(;i>=0&&n[i].endTokenIndex===f+1;)t.push(n[i]),i--;if(f<0)break;const c=e.tokens[f],l=e.identifierNameForToken(c);if(t.length>1&&!c.isType&&c.type===s.TokenType.name&&o.has(l))if((0,r.isBlockScopedDeclaration)(c))a(t[t.length-1],e,l);else if((0,r.isFunctionScopedDeclaration)(c)){let n=t.length-1;for(;n>0&&!t[n].isFunctionScope;)n--;if(n<0)throw new Error("Did not find parent function scope.");a(t[n],e,l)}}if(t.length>0)throw new Error("Expected empty scope stack after processing file.")}(e,n,o)},o.hasShadowedGlobals=f;const r=e("bfb18d0576"),s=e("f0c35cbd76");function f(e,n){for(const o of e.tokens)if(o.type===s.TokenType.name&&!o.isType&&(0,r.isNonTopLevelDeclaration)(o)&&n.has(e.identifierNameForToken(o)))return!0;return!1}function a(e,n,o){for(let t=e.startTokenIndex;t<e.endTokenIndex;t++){const e=n.tokens[t];e.type!==s.TokenType.name&&e.type!==s.TokenType.jsxName||n.identifierNameForToken(e)!==o||(e.shadowsGlobal=!0)}}},
"425f39b83e": function _(e,t,s,i,a){i();const n=e("tslib").__importDefault(e("981a8f5cdf"));class r{__init(){this.usedNames=new Set}constructor(e,t){r.prototype.__init.call(this),this.usedNames=new Set((0,n.default)(e,t))}claimFreeName(e){const t=this.findFreeName(e);return this.usedNames.add(t),t}findFreeName(e){if(!this.usedNames.has(e))return e;let t=2;for(;this.usedNames.has(e+String(t));)t++;return e+String(t)}}s.default=r},
"981a8f5cdf": function _(n,t,c,e,o){e(),c.default=function(n,t){const c=[];for(const e of t)e.type===f.TokenType.name&&c.push(n.slice(e.start,e.end));return c};const f=n("f0c35cbd76")},
"bb0c9c6022": function _(t,e,c,i,n){i(),c.validateOptions=function(t){f.strictCheck(t)};const a=t("tslib"),o=t("566f6e7d92"),s=a.__importDefault(t("26465ac544")),{Options:f}=(0,o.createCheckers)(s.default)},
"566f6e7d92": function _(t,e,r,n,o){var i=this&&this.__spreadArrays||function(){for(var t=0,e=0,r=arguments.length;e<r;e++)t+=arguments[e].length;var n=Array(t),o=0;for(e=0;e<r;e++)for(var i=arguments[e],a=0,p=i.length;a<p;a++,o++)n[o]=i[a];return n};n();var a=t("feda7bf54d"),p=t("cc5514a417"),s=t("feda7bf54d");o("TArray",s.TArray),o("TEnumType",s.TEnumType),o("TEnumLiteral",s.TEnumLiteral),o("TFunc",s.TFunc),o("TIface",s.TIface),o("TLiteral",s.TLiteral),o("TName",s.TName),o("TOptional",s.TOptional),o("TParam",s.TParam),o("TParamList",s.TParamList),o("TProp",s.TProp),o("TTuple",s.TTuple),o("TType",s.TType),o("TUnion",s.TUnion),o("TIntersection",s.TIntersection),o("array",s.array),o("enumlit",s.enumlit),o("enumtype",s.enumtype),o("func",s.func),o("iface",s.iface),o("lit",s.lit),o("name",s.name),o("opt",s.opt),o("param",s.param),o("tuple",s.tuple),o("union",s.union),o("intersection",s.intersection),o("BasicType",s.BasicType),o("VError",t("cc5514a417").VError),r.createCheckers=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];for(var r=Object.assign.apply(Object,i([{},a.basicTypes],t)),n={},o=0,p=t;o<p.length;o++)for(var s=p[o],h=0,u=Object.keys(s);h<u.length;h++){var f=u[h];n[f]=new c(r,s[f])}return n};var c=function(){function t(t,e,r){if(void 0===r&&(r="value"),this.suite=t,this.ttype=e,this._path=r,this.props=new Map,e instanceof a.TIface)for(var n=0,o=e.props;n<o.length;n++){var i=o[n];this.props.set(i.name,i.ttype)}this.checkerPlain=this.ttype.getChecker(t,!1),this.checkerStrict=this.ttype.getChecker(t,!0)}return t.prototype.setReportedPath=function(t){this._path=t},t.prototype.check=function(t){return this._doCheck(this.checkerPlain,t)},t.prototype.test=function(t){return this.checkerPlain(t,new p.NoopContext)},t.prototype.validate=function(t){return this._doValidate(this.checkerPlain,t)},t.prototype.strictCheck=function(t){return this._doCheck(this.checkerStrict,t)},t.prototype.strictTest=function(t){return this.checkerStrict(t,new p.NoopContext)},t.prototype.strictValidate=function(t){return this._doValidate(this.checkerStrict,t)},t.prototype.getProp=function(e){var r=this.props.get(e);if(!r)throw new Error("Type has no property "+e);return new t(this.suite,r,this._path+"."+e)},t.prototype.methodArgs=function(e){var r=this._getMethod(e);return new t(this.suite,r.paramList)},t.prototype.methodResult=function(e){var r=this._getMethod(e);return new t(this.suite,r.result)},t.prototype.getArgs=function(){if(!(this.ttype instanceof a.TFunc))throw new Error("getArgs() applied to non-function");return new t(this.suite,this.ttype.paramList)},t.prototype.getResult=function(){if(!(this.ttype instanceof a.TFunc))throw new Error("getResult() applied to non-function");return new t(this.suite,this.ttype.result)},t.prototype.getType=function(){return this.ttype},t.prototype._doCheck=function(t,e){if(!t(e,new p.NoopContext)){var r=new p.DetailContext;throw t(e,r),r.getError(this._path)}},t.prototype._doValidate=function(t,e){if(t(e,new p.NoopContext))return null;var r=new p.DetailContext;return t(e,r),r.getErrorDetail(this._path)},t.prototype._getMethod=function(t){var e=this.props.get(t);if(!e)throw new Error("Type has no property "+t);if(!(e instanceof a.TFunc))throw new Error("Property "+t+" is not a method");return e},t}();r.Checker=c},
"feda7bf54d": function _(n,t,r,e,i){var u,o=this&&this.__extends||(u=function(n,t){return u=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,t){n.__proto__=t}||function(n,t){for(var r in t)t.hasOwnProperty(r)&&(n[r]=t[r])},u(n,t)},function(n,t){function r(){this.constructor=n}u(n,t),n.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)});e();var a=n("cc5514a417"),f=function(){};function s(n){return"string"==typeof n?l(n):n}function c(n,t){var r=n[t];if(!r)throw new Error("Unknown type "+t);return r}function l(n){return new p(n)}r.TType=f,r.name=l;var p=function(n){function t(t){var r=n.call(this)||this;return r.name=t,r._failMsg="is not a "+t,r}return o(t,n),t.prototype.getChecker=function(n,r,e){var i=this,u=c(n,this.name),o=u.getChecker(n,r,e);return u instanceof O||u instanceof t?o:function(n,t){return!!o(n,t)||t.fail(null,i._failMsg,0)}},t}(f);r.TName=p,r.lit=function(n){return new h(n)};var h=function(n){function t(t){var r=n.call(this)||this;return r.value=t,r.name=JSON.stringify(t),r._failMsg="is not "+r.name,r}return o(t,n),t.prototype.getChecker=function(n,t){var r=this;return function(n,t){return n===r.value||t.fail(null,r._failMsg,-1)}},t}(f);r.TLiteral=h,r.array=function(n){return new y(s(n))};var y=function(n){function t(t){var r=n.call(this)||this;return r.ttype=t,r}return o(t,n),t.prototype.getChecker=function(n,t){var r=this.ttype.getChecker(n,t);return function(n,t){if(!Array.isArray(n))return t.fail(null,"is not an array",0);for(var e=0;e<n.length;e++){if(!r(n[e],t))return t.fail(e,null,1)}return!0}},t}(f);r.TArray=y,r.tuple=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new v(n.map((function(n){return s(n)})))};var v=function(n){function t(t){var r=n.call(this)||this;return r.ttypes=t,r}return o(t,n),t.prototype.getChecker=function(n,t){var r=this.ttypes.map((function(r){return r.getChecker(n,t)})),e=function(n,t){if(!Array.isArray(n))return t.fail(null,"is not an array",0);for(var e=0;e<r.length;e++){if(!r[e](n[e],t))return t.fail(e,null,1)}return!0};return t?function(n,t){return!!e(n,t)&&(n.length<=r.length||t.fail(r.length,"is extraneous",2))}:e},t}(f);r.TTuple=v,r.union=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new m(n.map((function(n){return s(n)})))};var m=function(n){function t(t){var r=n.call(this)||this;r.ttypes=t;var e=t.map((function(n){return n instanceof p||n instanceof h?n.name:null})).filter((function(n){return n})),i=t.length-e.length;return e.length?(i>0&&e.push(i+" more"),r._failMsg="is none of "+e.join(", ")):r._failMsg="is none of "+i+" types",r}return o(t,n),t.prototype.getChecker=function(n,t){var r=this,e=this.ttypes.map((function(r){return r.getChecker(n,t)}));return function(n,t){for(var i=t.unionResolver(),u=0;u<e.length;u++){if(e[u](n,i.createContext()))return!0}return t.resolveUnion(i),t.fail(null,r._failMsg,0)}},t}(f);r.TUnion=m,r.intersection=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new g(n.map((function(n){return s(n)})))};var g=function(n){function t(t){var r=n.call(this)||this;return r.ttypes=t,r}return o(t,n),t.prototype.getChecker=function(n,t){var r=new Set,e=this.ttypes.map((function(e){return e.getChecker(n,t,r)}));return function(n,t){return!!e.every((function(r){return r(n,t)}))||t.fail(null,null,0)}},t}(f);r.TIntersection=g,r.enumtype=function(n){return new w(n)};var w=function(n){function t(t){var r=n.call(this)||this;return r.members=t,r.validValues=new Set,r._failMsg="is not a valid enum value",r.validValues=new Set(Object.keys(t).map((function(n){return t[n]}))),r}return o(t,n),t.prototype.getChecker=function(n,t){var r=this;return function(n,t){return!!r.validValues.has(n)||t.fail(null,r._failMsg,0)}},t}(f);r.TEnumType=w,r.enumlit=function(n,t){return new b(n,t)};var b=function(n){function t(t,r){var e=n.call(this)||this;return e.enumName=t,e.prop=r,e._failMsg="is not "+t+"."+r,e}return o(t,n),t.prototype.getChecker=function(n,t){var r=this,e=c(n,this.enumName);if(!(e instanceof w))throw new Error("Type "+this.enumName+" used in enumlit is not an enum type");var i=e.members[this.prop];if(!e.members.hasOwnProperty(this.prop))throw new Error("Unknown value "+this.enumName+"."+this.prop+" used in enumlit");return function(n,t){return n===i||t.fail(null,r._failMsg,-1)}},t}(f);function d(n){return Object.keys(n).map((function(t){return function(n,t){return t instanceof C?new T(n,t.ttype,!0):new T(n,s(t),!1)}(t,n[t])}))}r.TEnumLiteral=b,r.iface=function(n,t){return new k(n,d(t))};var k=function(n){function t(t,r){var e=n.call(this)||this;return e.bases=t,e.props=r,e.propSet=new Set(r.map((function(n){return n.name}))),e}return o(t,n),t.prototype.getChecker=function(n,t,r){var e=this,i=this.bases.map((function(r){return c(n,r).getChecker(n,t)})),u=this.props.map((function(r){return r.ttype.getChecker(n,t)})),o=new a.NoopContext,f=this.props.map((function(n,t){return!n.isOpt&&!u[t](void 0,o)})),s=function(n,t){if("object"!=typeof n||null===n)return t.fail(null,"is not an object",0);for(var r=0;r<i.length;r++)if(!i[r](n,t))return!1;for(r=0;r<u.length;r++){var o=e.props[r].name,a=n[o];if(void 0===a){if(f[r])return t.fail(o,"is missing",1)}else if(!u[r](a,t))return t.fail(o,null,1)}return!0};if(!t)return s;var l=this.propSet;return r&&(this.propSet.forEach((function(n){return r.add(n)})),l=r),function(n,t){if(!s(n,t))return!1;for(var r in n)if(!l.has(r))return t.fail(r,"is extraneous",2);return!0}},t}(f);r.TIface=k,r.opt=function(n){return new C(s(n))};var C=function(n){function t(t){var r=n.call(this)||this;return r.ttype=t,r}return o(t,n),t.prototype.getChecker=function(n,t){var r=this.ttype.getChecker(n,t);return function(n,t){return void 0===n||r(n,t)}},t}(f);r.TOptional=C;var T=function(n,t,r){this.name=n,this.ttype=t,this.isOpt=r};r.TProp=T,r.func=function(n){for(var t=[],r=1;r<arguments.length;r++)t[r-1]=arguments[r];return new _(new j(t),s(n))};var _=function(n){function t(t,r){var e=n.call(this)||this;return e.paramList=t,e.result=r,e}return o(t,n),t.prototype.getChecker=function(n,t){return function(n,t){return"function"==typeof n||t.fail(null,"is not a function",0)}},t}(f);r.TFunc=_,r.param=function(n,t,r){return new A(n,s(t),Boolean(r))};var A=function(n,t,r){this.name=n,this.ttype=t,this.isOpt=r};r.TParam=A;var j=function(n){function t(t){var r=n.call(this)||this;return r.params=t,r}return o(t,n),t.prototype.getChecker=function(n,t){var r=this,e=this.params.map((function(r){return r.ttype.getChecker(n,t)})),i=new a.NoopContext,u=this.params.map((function(n,t){return!n.isOpt&&!e[t](void 0,i)})),o=function(n,t){if(!Array.isArray(n))return t.fail(null,"is not an array",0);for(var i=0;i<e.length;i++){var o=r.params[i];if(void 0===n[i]){if(u[i])return t.fail(o.name,"is missing",1)}else if(!e[i](n[i],t))return t.fail(o.name,null,1)}return!0};return t?function(n,t){return!!o(n,t)&&(n.length<=e.length||t.fail(e.length,"is extraneous",2))}:o},t}(f);r.TParamList=j;var O=function(n){function t(t,r){var e=n.call(this)||this;return e.validator=t,e.message=r,e}return o(t,n),t.prototype.getChecker=function(n,t){var r=this;return function(n,t){return!!r.validator(n)||t.fail(null,r.message,0)}},t}(f);r.BasicType=O,r.basicTypes={any:new O((function(n){return!0}),"is invalid"),number:new O((function(n){return"number"==typeof n}),"is not a number"),object:new O((function(n){return"object"==typeof n&&n}),"is not an object"),boolean:new O((function(n){return"boolean"==typeof n}),"is not a boolean"),string:new O((function(n){return"string"==typeof n}),"is not a string"),symbol:new O((function(n){return"symbol"==typeof n}),"is not a symbol"),void:new O((function(n){return null==n}),"is not void"),undefined:new O((function(n){return void 0===n}),"is not undefined"),null:new O((function(n){return null===n}),"is not null"),never:new O((function(n){return!1}),"is unexpected"),Date:new O(M("[object Date]"),"is not a Date"),RegExp:new O(M("[object RegExp]"),"is not a RegExp")};var x=Object.prototype.toString;function M(n){return function(t){return"object"==typeof t&&t&&x.call(t)===n}}"undefined"!=typeof Buffer&&(r.basicTypes.Buffer=new O((function(n){return Buffer.isBuffer(n)}),"is not a Buffer"));for(var E=function(n){r.basicTypes[n.name]=new O((function(t){return t instanceof n}),"is not a "+n.name)},S=0,B=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array,ArrayBuffer];S<B.length;S++){E(B[S])}},
"cc5514a417": function _(t,r,o,e,n){var s,p=this&&this.__extends||(s=function(t,r){return s=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,r){t.__proto__=r}||function(t,r){for(var o in r)r.hasOwnProperty(o)&&(t[o]=r[o])},s(t,r)},function(t,r){function o(){this.constructor=t}s(t,r),t.prototype=null===r?Object.create(r):(o.prototype=r.prototype,new o)});e();var i=function(t){function r(o,e){var n=t.call(this,e)||this;return n.path=o,Object.setPrototypeOf(n,r.prototype),n}return p(r,t),r}(Error);o.VError=i;var u=function(){function t(){}return t.prototype.fail=function(t,r,o){return!1},t.prototype.unionResolver=function(){return this},t.prototype.createContext=function(){return this},t.prototype.resolveUnion=function(t){},t}();o.NoopContext=u;var a=function(){function t(){this._propNames=[""],this._messages=[null],this._score=0}return t.prototype.fail=function(t,r,o){return this._propNames.push(t),this._messages.push(r),this._score+=o,!1},t.prototype.unionResolver=function(){return new c},t.prototype.resolveUnion=function(t){for(var r,o,e=null,n=0,s=t.contexts;n<s.length;n++){var p=s[n];(!e||p._score>=e._score)&&(e=p)}e&&e._score>0&&((r=this._propNames).push.apply(r,e._propNames),(o=this._messages).push.apply(o,e._messages))},t.prototype.getError=function(t){for(var r=[],o=this._propNames.length-1;o>=0;o--){var e=this._propNames[o];t+="number"==typeof e?"["+e+"]":e?"."+e:"";var n=this._messages[o];n&&r.push(t+" "+n)}return new i(t,r.join("; "))},t.prototype.getErrorDetail=function(t){for(var r=[],o=this._propNames.length-1;o>=0;o--){var e=this._propNames[o];t+="number"==typeof e?"["+e+"]":e?"."+e:"";var n=this._messages[o];n&&r.push({path:t,message:n})}var s=null;for(o=r.length-1;o>=0;o--)s&&(r[o].nested=[s]),s=r[o];return s},t}();o.DetailContext=a;var c=function(){function t(){this.contexts=[]}return t.prototype.createContext=function(){var t=new a;return this.contexts.push(t),t},t}()},
"26465ac544": function _(o,t,e,r,n){r();const a=o("tslib").__importStar(o("566f6e7d92"));e.Transform=a.union(a.lit("jsx"),a.lit("typescript"),a.lit("flow"),a.lit("imports"),a.lit("react-hot-loader"),a.lit("jest")),e.SourceMapOptions=a.iface([],{compiledFilename:"string"}),e.Options=a.iface([],{transforms:a.array("Transform"),disableESTransforms:a.opt("boolean"),jsxRuntime:a.opt(a.union(a.lit("classic"),a.lit("automatic"),a.lit("preserve"))),production:a.opt("boolean"),jsxImportSource:a.opt("string"),jsxPragma:a.opt("string"),jsxFragmentPragma:a.opt("string"),keepUnusedImports:a.opt("boolean"),preserveDynamicImport:a.opt("boolean"),injectCreateRequireForImportRequire:a.opt("boolean"),enableLegacyTypeScriptModuleInterop:a.opt("boolean"),enableLegacyBabel5ModuleInterop:a.opt("boolean"),sourceMapOptions:a.opt("SourceMapOptions"),filePath:a.opt("string")});const i={Transform:e.Transform,SourceMapOptions:e.SourceMapOptions,Options:e.Options};e.default=i},
"7a45c9fdec": function _(r,t,e,n,o){n(),e.parse=function(r,t,e,n){if(n&&e)throw new Error("Cannot combine flow and typescript plugins.");(0,s.initParser)(r,t,e,n);const o=(0,i.parseFile)();if(s.state.error)throw(0,s.augmentError)(s.state.error);return o};const s=r("540718e523"),i=r("5bde8156b9");e.File=class{constructor(r,t){this.tokens=r,this.scopes=t}}},
"5bde8156b9": function _(e,n,t,o,a){o(),t.parseFile=function(){0===i.state.pos&&i.input.charCodeAt(0)===r.charCodes.numberSign&&i.input.charCodeAt(1)===r.charCodes.exclamationMark&&(0,c.skipLineComment)(2);return(0,c.nextToken)(),(0,s.parseTopLevel)()};const c=e("bfb18d0576"),r=e("22746c8ce8"),i=e("540718e523"),s=e("e3b9989da1")},
"e3b9989da1": function _(e,t,n,o,a){o(),n.parseTopLevel=function(){if(E(l.TokenType.eof),u.state.scopes.push(new T.Scope(0,u.state.tokens.length,!0)),0!==u.state.scopeDepth)throw new Error(`Invalid scope depth at end of file: ${u.state.scopeDepth}`);return new s.File(u.state.tokens,u.state.scopes)},n.parseStatement=f,n.parseDecorators=m,n.baseParseMaybeDecoratorArguments=_,n.parseVarStatement=C,n.parseBlock=b,n.parseBlockBody=E,n.parseFunction=I,n.parseFunctionParams=v,n.parseClass=F,n.parseClassPropertyName=B,n.parsePostMemberNameModifiers=M,n.parseClassProperty=q,n.parseExport=N,n.parseExportFrom=H,n.baseParseExportStar=j,n.parseExportSpecifiers=O,n.parseImport=$;const s=e("7a45c9fdec"),r=e("9b8d43cd0a"),p=e("6a970c22b9"),i=e("bfb18d0576"),c=e("99ff836c64"),T=e("eda46439d5"),l=e("f0c35cbd76"),y=e("22746c8ce8"),u=e("540718e523"),d=e("8178e7c3c8"),k=e("4cefc59e67"),x=e("bc94bbadc1");function f(e){u.isFlowEnabled&&(0,r.flowTryParseStatement)()||((0,i.match)(l.TokenType.at)&&m(),function(e){if(u.isTypeScriptEnabled&&(0,p.tsTryParseStatementContent)())return;const t=u.state.type;switch(t){case l.TokenType._break:case l.TokenType._continue:return(0,i.next)(),void((0,x.isLineTerminator)()||((0,d.parseIdentifier)(),(0,x.semicolon)()));case l.TokenType._debugger:return(0,i.next)(),void(0,x.semicolon)();case l.TokenType._do:return(0,i.next)(),f(!1),(0,x.expect)(l.TokenType._while),(0,d.parseParenExpression)(),void(0,i.eat)(l.TokenType.semi);case l.TokenType._for:return void function(){u.state.scopeDepth++;const e=u.state.tokens.length;!function(){(0,i.next)();let e=!1;(0,x.isContextual)(c.ContextualKeyword._await)&&(e=!0,(0,i.next)());if((0,x.expect)(l.TokenType.parenL),(0,i.match)(l.TokenType.semi))return e&&(0,x.unexpected)(),void S();const t=h();if(t||(0,i.match)(l.TokenType._var)||(0,i.match)(l.TokenType._let)||(0,i.match)(l.TokenType._const)||function(){if(!(0,x.isContextual)(c.ContextualKeyword._using))return!1;if((0,x.isLookaheadContextual)(c.ContextualKeyword._of))return!1;return!0}())return t&&(0,x.expectContextual)(c.ContextualKeyword._await),(0,i.next)(),K(!0,u.state.type!==l.TokenType._var),(0,i.match)(l.TokenType._in)||(0,x.isContextual)(c.ContextualKeyword._of)?void g(e):void S();if((0,d.parseExpression)(!0),(0,i.match)(l.TokenType._in)||(0,x.isContextual)(c.ContextualKeyword._of))return void g(e);e&&(0,x.unexpected)();S()}();const t=u.state.tokens.length;u.state.scopes.push(new T.Scope(e,t,!1)),u.state.scopeDepth--}();case l.TokenType._function:if((0,i.lookaheadType)()===l.TokenType.dot)break;return e||(0,x.unexpected)(),void function(){const e=u.state.start;(0,i.next)(),I(e,!0)}();case l.TokenType._class:return e||(0,x.unexpected)(),void F(!0);case l.TokenType._if:return(0,i.next)(),(0,d.parseParenExpression)(),f(!1),void((0,i.eat)(l.TokenType._else)&&f(!1));case l.TokenType._return:return(0,i.next)(),void((0,x.isLineTerminator)()||((0,d.parseExpression)(),(0,x.semicolon)()));case l.TokenType._switch:return void function(){(0,i.next)(),(0,d.parseParenExpression)(),u.state.scopeDepth++;const e=u.state.tokens.length;(0,x.expect)(l.TokenType.braceL);for(;!(0,i.match)(l.TokenType.braceR)&&!u.state.error;)if((0,i.match)(l.TokenType._case)||(0,i.match)(l.TokenType._default)){const e=(0,i.match)(l.TokenType._case);(0,i.next)(),e&&(0,d.parseExpression)(),(0,x.expect)(l.TokenType.colon)}else f(!0);(0,i.next)();const t=u.state.tokens.length;u.state.scopes.push(new T.Scope(e,t,!1)),u.state.scopeDepth--}();case l.TokenType._throw:return(0,i.next)(),(0,d.parseExpression)(),void(0,x.semicolon)();case l.TokenType._try:return void function(){if((0,i.next)(),b(),(0,i.match)(l.TokenType._catch)){(0,i.next)();let e=null;if((0,i.match)(l.TokenType.parenL)&&(u.state.scopeDepth++,e=u.state.tokens.length,(0,x.expect)(l.TokenType.parenL),(0,k.parseBindingAtom)(!0),u.isTypeScriptEnabled&&(0,p.tsTryParseTypeAnnotation)(),(0,x.expect)(l.TokenType.parenR)),b(),null!=e){const t=u.state.tokens.length;u.state.scopes.push(new T.Scope(e,t,!1)),u.state.scopeDepth--}}(0,i.eat)(l.TokenType._finally)&&b()}();case l.TokenType._let:case l.TokenType._const:e||(0,x.unexpected)();case l.TokenType._var:return void C(t!==l.TokenType._var);case l.TokenType._while:return(0,i.next)(),(0,d.parseParenExpression)(),void f(!1);case l.TokenType.braceL:return void b();case l.TokenType.semi:return void(0,i.next)();case l.TokenType._export:case l.TokenType._import:{const e=(0,i.lookaheadType)();if(e===l.TokenType.parenL||e===l.TokenType.dot)break;return(0,i.next)(),void(t===l.TokenType._import?$():N())}case l.TokenType.name:if(u.state.contextualKeyword===c.ContextualKeyword._async){const e=u.state.start,t=u.state.snapshot();if((0,i.next)(),(0,i.match)(l.TokenType._function)&&!(0,x.canInsertSemicolon)())return(0,x.expect)(l.TokenType._function),void I(e,!0);u.state.restoreFromSnapshot(t)}else{if(u.state.contextualKeyword===c.ContextualKeyword._using&&!(0,x.hasFollowingLineBreak)()&&(0,i.lookaheadType)()===l.TokenType.name)return void C(!0);if(h())return(0,x.expectContextual)(c.ContextualKeyword._await),void C(!0)}}const n=u.state.tokens.length;(0,d.parseExpression)();let o=null;if(u.state.tokens.length===n+1){const e=u.state.tokens[u.state.tokens.length-1];e.type===l.TokenType.name&&(o=e.contextualKeyword)}if(null==o)return void(0,x.semicolon)();(0,i.eat)(l.TokenType.colon)?f(!0):(a=o,u.isTypeScriptEnabled?(0,p.tsParseIdentifierStatement)(a):u.isFlowEnabled?(0,r.flowParseIdentifierStatement)(a):(0,x.semicolon)());var a}(e))}function h(){if(!(0,x.isContextual)(c.ContextualKeyword._await))return!1;const e=u.state.snapshot();return(0,i.next)(),!(0,x.isContextual)(c.ContextualKeyword._using)||(0,x.hasPrecedingLineBreak)()?(u.state.restoreFromSnapshot(e),!1):((0,i.next)(),!(0,i.match)(l.TokenType.name)||(0,x.hasPrecedingLineBreak)()?(u.state.restoreFromSnapshot(e),!1):(u.state.restoreFromSnapshot(e),!0))}function m(){for(;(0,i.match)(l.TokenType.at);)w()}function w(){if((0,i.next)(),(0,i.eat)(l.TokenType.parenL))(0,d.parseExpression)(),(0,x.expect)(l.TokenType.parenR);else{for((0,d.parseIdentifier)();(0,i.eat)(l.TokenType.dot);)(0,d.parseIdentifier)();u.isTypeScriptEnabled?(0,p.tsParseMaybeDecoratorArguments)():_()}}function _(){(0,i.eat)(l.TokenType.parenL)&&(0,d.parseCallExpressionArguments)()}function C(e){(0,i.next)(),K(!1,e),(0,x.semicolon)()}function b(e=!1,t=0){const n=u.state.tokens.length;u.state.scopeDepth++,(0,x.expect)(l.TokenType.braceL),t&&(u.state.tokens[u.state.tokens.length-1].contextId=t),E(l.TokenType.braceR),t&&(u.state.tokens[u.state.tokens.length-1].contextId=t);const o=u.state.tokens.length;u.state.scopes.push(new T.Scope(n,o,e)),u.state.scopeDepth--}function E(e){for(;!(0,i.eat)(e)&&!u.state.error;)f(!0)}function S(){(0,x.expect)(l.TokenType.semi),(0,i.match)(l.TokenType.semi)||(0,d.parseExpression)(),(0,x.expect)(l.TokenType.semi),(0,i.match)(l.TokenType.parenR)||(0,d.parseExpression)(),(0,x.expect)(l.TokenType.parenR),f(!1)}function g(e){e?(0,x.eatContextual)(c.ContextualKeyword._of):(0,i.next)(),(0,d.parseExpression)(),(0,x.expect)(l.TokenType.parenR),f(!1)}function K(e,t){for(;;){if(P(t),(0,i.eat)(l.TokenType.eq)){const t=u.state.tokens.length-1;(0,d.parseMaybeAssign)(e),u.state.tokens[t].rhsEndIndex=u.state.tokens.length}if(!(0,i.eat)(l.TokenType.comma))break}}function P(e){(0,k.parseBindingAtom)(e),u.isTypeScriptEnabled?(0,p.tsAfterParseVarHead)():u.isFlowEnabled&&(0,r.flowAfterParseVarHead)()}function I(e,t,n=!1){(0,i.match)(l.TokenType.star)&&(0,i.next)(),!t||n||(0,i.match)(l.TokenType.name)||(0,i.match)(l.TokenType._yield)||(0,x.unexpected)();let o=null;(0,i.match)(l.TokenType.name)&&(t||(o=u.state.tokens.length,u.state.scopeDepth++),(0,k.parseBindingIdentifier)(!1));const a=u.state.tokens.length;u.state.scopeDepth++,v(),(0,d.parseFunctionBodyAndFinish)(e);const s=u.state.tokens.length;u.state.scopes.push(new T.Scope(a,s,!0)),u.state.scopeDepth--,null!==o&&(u.state.scopes.push(new T.Scope(o,s,!0)),u.state.scopeDepth--)}function v(e=!1,t=0){u.isTypeScriptEnabled?(0,p.tsStartParseFunctionParams)():u.isFlowEnabled&&(0,r.flowStartParseFunctionParams)(),(0,x.expect)(l.TokenType.parenL),t&&(u.state.tokens[u.state.tokens.length-1].contextId=t),(0,k.parseBindingList)(l.TokenType.parenR,!1,!1,e,t),t&&(u.state.tokens[u.state.tokens.length-1].contextId=t)}function F(e,t=!1){const n=(0,u.getNextContextId)();(0,i.next)(),u.state.tokens[u.state.tokens.length-1].contextId=n,u.state.tokens[u.state.tokens.length-1].isExpression=!e;let o=null;e||(o=u.state.tokens.length,u.state.scopeDepth++),function(e,t=!1){if(u.isTypeScriptEnabled&&(!e||t)&&(0,x.isContextual)(c.ContextualKeyword._implements))return;(0,i.match)(l.TokenType.name)&&(0,k.parseBindingIdentifier)(!0);u.isTypeScriptEnabled?(0,p.tsTryParseTypeParameters)():u.isFlowEnabled&&(0,i.match)(l.TokenType.lessThan)&&(0,r.flowParseTypeParameterDeclaration)()}(e,t),function(){let e=!1;(0,i.eat)(l.TokenType._extends)?((0,d.parseExprSubscripts)(),e=!0):e=!1;u.isTypeScriptEnabled?(0,p.tsAfterParseClassSuper)(e):u.isFlowEnabled&&(0,r.flowAfterParseClassSuper)(e)}();const a=u.state.tokens.length;if(function(e){(0,x.expect)(l.TokenType.braceL);for(;!(0,i.eat)(l.TokenType.braceR)&&!u.state.error;){if((0,i.eat)(l.TokenType.semi))continue;if((0,i.match)(l.TokenType.at)){w();continue}A(u.state.start,e)}}(n),!u.state.error&&(u.state.tokens[a].contextId=n,u.state.tokens[u.state.tokens.length-1].contextId=n,null!==o)){const e=u.state.tokens.length;u.state.scopes.push(new T.Scope(o,e,!1)),u.state.scopeDepth--}}function D(){return(0,i.match)(l.TokenType.eq)||(0,i.match)(l.TokenType.semi)||(0,i.match)(l.TokenType.braceR)||(0,i.match)(l.TokenType.bang)||(0,i.match)(l.TokenType.colon)}function L(){return(0,i.match)(l.TokenType.parenL)||(0,i.match)(l.TokenType.lessThan)}function A(e,t){u.isTypeScriptEnabled&&(0,p.tsParseModifiers)([c.ContextualKeyword._declare,c.ContextualKeyword._public,c.ContextualKeyword._protected,c.ContextualKeyword._private,c.ContextualKeyword._override]);let n=!1;if((0,i.match)(l.TokenType.name)&&u.state.contextualKeyword===c.ContextualKeyword._static){if((0,d.parseIdentifier)(),L())return void R(e,!1);if(D())return void q();if(u.state.tokens[u.state.tokens.length-1].type=l.TokenType._static,n=!0,(0,i.match)(l.TokenType.braceL))return u.state.tokens[u.state.tokens.length-1].contextId=t,void b()}!function(e,t,n){if(u.isTypeScriptEnabled&&(0,p.tsTryParseClassMemberWithIsStatic)(t))return;if((0,i.eat)(l.TokenType.star))return B(n),void R(e,!1);B(n);let o=!1;const a=u.state.tokens[u.state.tokens.length-1];a.contextualKeyword===c.ContextualKeyword._constructor&&(o=!0);if(M(),L())R(e,o);else if(D())q();else if(a.contextualKeyword!==c.ContextualKeyword._async||(0,x.isLineTerminator)())a.contextualKeyword!==c.ContextualKeyword._get&&a.contextualKeyword!==c.ContextualKeyword._set||(0,x.isLineTerminator)()&&(0,i.match)(l.TokenType.star)?a.contextualKeyword!==c.ContextualKeyword._accessor||(0,x.isLineTerminator)()?(0,x.isLineTerminator)()?q():(0,x.unexpected)():(B(n),q()):(a.contextualKeyword===c.ContextualKeyword._get?u.state.tokens[u.state.tokens.length-1].type=l.TokenType._get:u.state.tokens[u.state.tokens.length-1].type=l.TokenType._set,B(n),R(e,!1));else{u.state.tokens[u.state.tokens.length-1].type=l.TokenType._async;(0,i.match)(l.TokenType.star)&&(0,i.next)(),B(n),M(),R(e,!1)}}(e,n,t)}function R(e,t){u.isTypeScriptEnabled?(0,p.tsTryParseTypeParameters)():u.isFlowEnabled&&(0,i.match)(l.TokenType.lessThan)&&(0,r.flowParseTypeParameterDeclaration)(),(0,d.parseMethod)(e,t)}function B(e){(0,d.parsePropertyName)(e)}function M(){if(u.isTypeScriptEnabled){const e=(0,i.pushTypeContext)(0);(0,i.eat)(l.TokenType.question),(0,i.popTypeContext)(e)}}function q(){if(u.isTypeScriptEnabled?((0,i.eatTypeToken)(l.TokenType.bang),(0,p.tsTryParseTypeAnnotation)()):u.isFlowEnabled&&(0,i.match)(l.TokenType.colon)&&(0,r.flowParseTypeAnnotation)(),(0,i.match)(l.TokenType.eq)){const e=u.state.tokens.length;(0,i.next)(),(0,d.parseMaybeAssign)(),u.state.tokens[e].rhsEndIndex=u.state.tokens.length}(0,x.semicolon)()}function N(){const e=u.state.tokens.length-1;u.isTypeScriptEnabled&&(0,p.tsTryParseExport)()||((u.isFlowEnabled?(0,r.flowShouldParseExportStar)():(0,i.match)(l.TokenType.star))?u.isFlowEnabled?(0,r.flowParseExportStar)():j():function(){if(u.isTypeScriptEnabled&&(0,p.tsIsDeclarationStart)())return!1;if(u.isFlowEnabled&&(0,r.flowShouldDisallowExportDefaultSpecifier)())return!1;if((0,i.match)(l.TokenType.name))return u.state.contextualKeyword!==c.ContextualKeyword._async;if(!(0,i.match)(l.TokenType._default))return!1;const e=(0,i.nextTokenStart)(),t=(0,i.lookaheadTypeAndKeyword)(),n=t.type===l.TokenType.name&&t.contextualKeyword===c.ContextualKeyword._from;if(t.type===l.TokenType.comma)return!0;if(n){const t=u.input.charCodeAt((0,i.nextTokenStartSince)(e+4));return t===y.charCodes.quotationMark||t===y.charCodes.apostrophe}return!1}()?((0,d.parseIdentifier)(),(0,i.match)(l.TokenType.comma)&&(0,i.lookaheadType)()===l.TokenType.star?((0,x.expect)(l.TokenType.comma),(0,x.expect)(l.TokenType.star),(0,x.expectContextual)(c.ContextualKeyword._as),(0,d.parseIdentifier)()):V(),H()):(0,i.eat)(l.TokenType._default)?function(){if(u.isTypeScriptEnabled&&(0,p.tsTryParseExportDefaultExpression)())return;if(u.isFlowEnabled&&(0,r.flowTryParseExportDefaultExpression)())return;const e=u.state.start;(0,i.eat)(l.TokenType._function)?I(e,!0,!0):(0,x.isContextual)(c.ContextualKeyword._async)&&(0,i.lookaheadType)()===l.TokenType._function?((0,x.eatContextual)(c.ContextualKeyword._async),(0,i.eat)(l.TokenType._function),I(e,!0,!0)):(0,i.match)(l.TokenType._class)?F(!0,!0):(0,i.match)(l.TokenType.at)?(m(),F(!0,!0)):((0,d.parseMaybeAssign)(),(0,x.semicolon)())}():u.isTypeScriptEnabled&&(0,p.tsIsDeclarationStart)()||u.isFlowEnabled&&(0,r.flowShouldParseExportDeclaration)()||u.state.type===l.TokenType._var||u.state.type===l.TokenType._const||u.state.type===l.TokenType._let||u.state.type===l.TokenType._function||u.state.type===l.TokenType._class||(0,x.isContextual)(c.ContextualKeyword._async)||(0,i.match)(l.TokenType.at)?u.isTypeScriptEnabled?(0,p.tsParseExportDeclaration)():u.isFlowEnabled?(0,r.flowParseExportDeclaration)():f(!0):(O(),H()),u.state.tokens[e].rhsEndIndex=u.state.tokens.length)}function V(){(0,i.eat)(l.TokenType.comma)&&O()}function H(){(0,x.eatContextual)(c.ContextualKeyword._from)&&((0,d.parseExprAtom)(),J()),(0,x.semicolon)()}function j(){(0,x.expect)(l.TokenType.star),(0,x.isContextual)(c.ContextualKeyword._as)?((0,i.next)(),u.state.tokens[u.state.tokens.length-1].type=l.TokenType._as,(0,d.parseIdentifier)(),V(),H()):H()}function O(){let e=!0;for((0,x.expect)(l.TokenType.braceL);!(0,i.eat)(l.TokenType.braceR)&&!u.state.error;){if(e)e=!1;else if((0,x.expect)(l.TokenType.comma),(0,i.eat)(l.TokenType.braceR))break;U()}}function U(){u.isTypeScriptEnabled?(0,p.tsParseExportSpecifier)():((0,d.parseIdentifier)(),u.state.tokens[u.state.tokens.length-1].identifierRole=i.IdentifierRole.ExportAccess,(0,x.eatContextual)(c.ContextualKeyword._as)&&(0,d.parseIdentifier)())}function W(){(0,x.isContextual)(c.ContextualKeyword._module)&&function(){const e=u.state.snapshot();return(0,x.expectContextual)(c.ContextualKeyword._module),(0,x.eatContextual)(c.ContextualKeyword._from)?(0,x.isContextual)(c.ContextualKeyword._from)?(u.state.restoreFromSnapshot(e),!0):(u.state.restoreFromSnapshot(e),!1):(0,i.match)(l.TokenType.comma)?(u.state.restoreFromSnapshot(e),!1):(u.state.restoreFromSnapshot(e),!0)}()&&(0,i.next)()}function $(){if(u.isTypeScriptEnabled&&(0,i.match)(l.TokenType.name)&&(0,i.lookaheadType)()===l.TokenType.eq)(0,p.tsParseImportEqualsDeclaration)();else{if(u.isTypeScriptEnabled&&(0,x.isContextual)(c.ContextualKeyword._type)){const e=(0,i.lookaheadTypeAndKeyword)();if(e.type===l.TokenType.name&&e.contextualKeyword!==c.ContextualKeyword._from){if((0,x.expectContextual)(c.ContextualKeyword._type),(0,i.lookaheadType)()===l.TokenType.eq)return void(0,p.tsParseImportEqualsDeclaration)()}else e.type!==l.TokenType.star&&e.type!==l.TokenType.braceL||(0,x.expectContextual)(c.ContextualKeyword._type)}(0,i.match)(l.TokenType.string)||(W(),function(){u.isFlowEnabled&&(0,r.flowStartParseImportSpecifiers)();let e=!0;if((0,i.match)(l.TokenType.name)&&(z(),!(0,i.eat)(l.TokenType.comma)))return;if((0,i.match)(l.TokenType.star))return(0,i.next)(),(0,x.expectContextual)(c.ContextualKeyword._as),void z();(0,x.expect)(l.TokenType.braceL);for(;!(0,i.eat)(l.TokenType.braceR)&&!u.state.error;){if(e)e=!1;else if((0,i.eat)(l.TokenType.colon)&&(0,x.unexpected)("ES2015 named imports do not destructure. Use another statement for destructuring after the import."),(0,x.expect)(l.TokenType.comma),(0,i.eat)(l.TokenType.braceR))break;G()}}(),(0,x.expectContextual)(c.ContextualKeyword._from)),(0,d.parseExprAtom)(),J(),(0,x.semicolon)()}}function z(){(0,k.parseImportedIdentifier)()}function G(){u.isTypeScriptEnabled?(0,p.tsParseImportSpecifier)():u.isFlowEnabled?(0,r.flowParseImportSpecifier)():((0,k.parseImportedIdentifier)(),(0,x.isContextual)(c.ContextualKeyword._as)&&(u.state.tokens[u.state.tokens.length-1].identifierRole=i.IdentifierRole.ImportAccess,(0,i.next)(),(0,k.parseImportedIdentifier)()))}function J(){((0,i.match)(l.TokenType._with)||(0,x.isContextual)(c.ContextualKeyword._assert)&&!(0,x.hasPrecedingLineBreak)())&&((0,i.next)(),(0,d.parseObj)(!1,!1))}},
"9b8d43cd0a": function _(e,t,n,o,a){o(),n.flowParseTypeParameterDeclaration=_,n.flowParseTypeAnnotation=B,n.flowParseVariance=M,n.flowParseFunctionBodyAndFinish=function(e){(0,p.match)(r.TokenType.colon)&&k();(0,c.parseFunctionBody)(!1,e)},n.flowParseSubscript=function(e,t,n){if((0,p.match)(r.TokenType.questionDot)&&(0,p.lookaheadType)()===r.TokenType.lessThan)return t?void(n.stop=!0):((0,p.next)(),b(),(0,i.expect)(r.TokenType.parenL),void(0,c.parseCallExpressionArguments)());if(!t&&(0,p.match)(r.TokenType.lessThan)){const e=s.state.snapshot();if(b(),(0,i.expect)(r.TokenType.parenL),(0,c.parseCallExpressionArguments)(),!s.state.error)return;s.state.restoreFromSnapshot(e)}(0,c.baseParseSubscript)(e,t,n)},n.flowStartParseNewArguments=function(){if((0,p.match)(r.TokenType.lessThan)){const e=s.state.snapshot();b(),s.state.error&&s.state.restoreFromSnapshot(e)}},n.flowTryParseStatement=function(){if((0,p.match)(r.TokenType.name)&&s.state.contextualKeyword===T.ContextualKeyword._interface){const e=(0,p.pushTypeContext)(0);return(0,p.next)(),h(),(0,p.popTypeContext)(e),!0}if((0,i.isContextual)(T.ContextualKeyword._enum))return W(),!0;return!1},n.flowTryParseExportDefaultExpression=function(){if((0,i.isContextual)(T.ContextualKeyword._enum))return W(),!0;return!1},n.flowParseIdentifierStatement=function(e){if(e===T.ContextualKeyword._declare){if((0,p.match)(r.TokenType._class)||(0,p.match)(r.TokenType.name)||(0,p.match)(r.TokenType._function)||(0,p.match)(r.TokenType._var)||(0,p.match)(r.TokenType._export)){const e=(0,p.pushTypeContext)(1);x(),(0,p.popTypeContext)(e)}}else if((0,p.match)(r.TokenType.name))if(e===T.ContextualKeyword._interface){const e=(0,p.pushTypeContext)(1);h(),(0,p.popTypeContext)(e)}else if(e===T.ContextualKeyword._type){const e=(0,p.pushTypeContext)(1);C(),(0,p.popTypeContext)(e)}else if(e===T.ContextualKeyword._opaque){const e=(0,p.pushTypeContext)(1);w(!1),(0,p.popTypeContext)(e)}(0,i.semicolon)()},n.flowShouldParseExportDeclaration=function(){return(0,i.isContextual)(T.ContextualKeyword._type)||(0,i.isContextual)(T.ContextualKeyword._interface)||(0,i.isContextual)(T.ContextualKeyword._opaque)||(0,i.isContextual)(T.ContextualKeyword._enum)},n.flowShouldDisallowExportDefaultSpecifier=function(){return(0,p.match)(r.TokenType.name)&&(s.state.contextualKeyword===T.ContextualKeyword._type||s.state.contextualKeyword===T.ContextualKeyword._interface||s.state.contextualKeyword===T.ContextualKeyword._opaque||s.state.contextualKeyword===T.ContextualKeyword._enum)},n.flowParseExportDeclaration=function(){if((0,i.isContextual)(T.ContextualKeyword._type)){const e=(0,p.pushTypeContext)(1);(0,p.next)(),(0,p.match)(r.TokenType.braceL)?((0,y.parseExportSpecifiers)(),(0,y.parseExportFrom)()):C(),(0,p.popTypeContext)(e)}else if((0,i.isContextual)(T.ContextualKeyword._opaque)){const e=(0,p.pushTypeContext)(1);(0,p.next)(),w(!1),(0,p.popTypeContext)(e)}else if((0,i.isContextual)(T.ContextualKeyword._interface)){const e=(0,p.pushTypeContext)(1);(0,p.next)(),h(),(0,p.popTypeContext)(e)}else(0,y.parseStatement)(!0)},n.flowShouldParseExportStar=function(){return(0,p.match)(r.TokenType.star)||(0,i.isContextual)(T.ContextualKeyword._type)&&(0,p.lookaheadType)()===r.TokenType.star},n.flowParseExportStar=function(){if((0,i.eatContextual)(T.ContextualKeyword._type)){const e=(0,p.pushTypeContext)(2);(0,y.baseParseExportStar)(),(0,p.popTypeContext)(e)}else(0,y.baseParseExportStar)()},n.flowAfterParseClassSuper=function(e){e&&(0,p.match)(r.TokenType.lessThan)&&b();if((0,i.isContextual)(T.ContextualKeyword._implements)){const e=(0,p.pushTypeContext)(0);(0,p.next)(),s.state.tokens[s.state.tokens.length-1].type=r.TokenType._implements;do{d(),(0,p.match)(r.TokenType.lessThan)&&b()}while((0,p.eat)(r.TokenType.comma));(0,p.popTypeContext)(e)}},n.flowStartParseObjPropValue=function(){(0,p.match)(r.TokenType.lessThan)&&(_(),(0,p.match)(r.TokenType.parenL)||(0,i.unexpected)())},n.flowParseAssignableListItemTypes=function(){const e=(0,p.pushTypeContext)(0);(0,p.eat)(r.TokenType.question),(0,p.match)(r.TokenType.colon)&&B();(0,p.popTypeContext)(e)},n.flowStartParseImportSpecifiers=function(){if((0,p.match)(r.TokenType._typeof)||(0,i.isContextual)(T.ContextualKeyword._type)){const t=(0,p.lookaheadTypeAndKeyword)();(((e=t).type===r.TokenType.name||e.type&r.TokenType.IS_KEYWORD)&&e.contextualKeyword!==T.ContextualKeyword._from||t.type===r.TokenType.braceL||t.type===r.TokenType.star)&&(0,p.next)()}var e},n.flowParseImportSpecifier=function(){const e=s.state.contextualKeyword===T.ContextualKeyword._type||s.state.type===r.TokenType._typeof;e?(0,p.next)():(0,c.parseIdentifier)();(0,i.isContextual)(T.ContextualKeyword._as)&&!(0,i.isLookaheadContextual)(T.ContextualKeyword._as)?((0,c.parseIdentifier)(),(!e||(0,p.match)(r.TokenType.name)||s.state.type&r.TokenType.IS_KEYWORD)&&(0,c.parseIdentifier)()):(e&&((0,p.match)(r.TokenType.name)||s.state.type&r.TokenType.IS_KEYWORD)&&(0,c.parseIdentifier)(),(0,i.eatContextual)(T.ContextualKeyword._as)&&(0,c.parseIdentifier)())},n.flowStartParseFunctionParams=function(){if((0,p.match)(r.TokenType.lessThan)){const e=(0,p.pushTypeContext)(0);_(),(0,p.popTypeContext)(e)}},n.flowAfterParseVarHead=function(){(0,p.match)(r.TokenType.colon)&&B()},n.flowStartParseAsyncArrowFromCallExpression=function(){if((0,p.match)(r.TokenType.colon)){const e=s.state.noAnonFunctionType;s.state.noAnonFunctionType=!0,B(),s.state.noAnonFunctionType=e}},n.flowParseMaybeAssign=function(e,t){if((0,p.match)(r.TokenType.lessThan)){const n=s.state.snapshot();let o=(0,c.baseParseMaybeAssign)(e,t);if(!s.state.error)return o;s.state.restoreFromSnapshot(n),s.state.type=r.TokenType.typeParameterStart;const a=(0,p.pushTypeContext)(0);if(_(),(0,p.popTypeContext)(a),o=(0,c.baseParseMaybeAssign)(e,t),o)return!0;(0,i.unexpected)()}return(0,c.baseParseMaybeAssign)(e,t)},n.flowParseArrow=function(){if((0,p.match)(r.TokenType.colon)){const e=(0,p.pushTypeContext)(0),t=s.state.snapshot(),n=s.state.noAnonFunctionType;s.state.noAnonFunctionType=!0,k(),s.state.noAnonFunctionType=n,(0,i.canInsertSemicolon)()&&(0,i.unexpected)(),(0,p.match)(r.TokenType.arrow)||(0,i.unexpected)(),s.state.error&&s.state.restoreFromSnapshot(t),(0,p.popTypeContext)(e)}return(0,p.eat)(r.TokenType.arrow)},n.flowParseSubscripts=function(e,t=!1){if(s.state.tokens[s.state.tokens.length-1].contextualKeyword===T.ContextualKeyword._async&&(0,p.match)(r.TokenType.lessThan)){const e=s.state.snapshot(),t=function(){s.state.scopeDepth++;const e=s.state.tokens.length;if((0,y.parseFunctionParams)(),!(0,c.parseArrow)())return!1;return(0,c.parseArrowExpression)(e),!0}();if(t&&!s.state.error)return;s.state.restoreFromSnapshot(e)}(0,c.baseParseSubscripts)(e,t)};const p=e("bfb18d0576"),T=e("99ff836c64"),r=e("f0c35cbd76"),s=e("540718e523"),c=e("8178e7c3c8"),y=e("e3b9989da1"),i=e("bc94bbadc1");function u(e){const t=(0,p.pushTypeContext)(0);(0,i.expect)(e||r.TokenType.colon),D(),(0,p.popTypeContext)(t)}function l(){(0,i.expect)(r.TokenType.modulo),(0,i.expectContextual)(T.ContextualKeyword._checks),(0,p.eat)(r.TokenType.parenL)&&((0,c.parseExpression)(),(0,i.expect)(r.TokenType.parenR))}function k(){const e=(0,p.pushTypeContext)(0);(0,i.expect)(r.TokenType.colon),(0,p.match)(r.TokenType.modulo)?l():(D(),(0,p.match)(r.TokenType.modulo)&&l()),(0,p.popTypeContext)(e)}function x(){(0,p.match)(r.TokenType._class)?((0,p.next)(),f(!0)):(0,p.match)(r.TokenType._function)?((0,p.next)(),(0,c.parseIdentifier)(),(0,p.match)(r.TokenType.lessThan)&&_(),(0,i.expect)(r.TokenType.parenL),g(),(0,i.expect)(r.TokenType.parenR),k(),(0,i.semicolon)()):(0,p.match)(r.TokenType._var)?((0,p.next)(),O(),(0,i.semicolon)()):(0,i.eatContextual)(T.ContextualKeyword._module)?(0,p.eat)(r.TokenType.dot)?((0,i.expectContextual)(T.ContextualKeyword._exports),B(),(0,i.semicolon)()):function(){(0,p.match)(r.TokenType.string)?(0,c.parseExprAtom)():(0,c.parseIdentifier)();(0,i.expect)(r.TokenType.braceL);for(;!(0,p.match)(r.TokenType.braceR)&&!s.state.error;)(0,p.match)(r.TokenType._import)?((0,p.next)(),(0,y.parseImport)()):(0,i.unexpected)();(0,i.expect)(r.TokenType.braceR)}():(0,i.isContextual)(T.ContextualKeyword._type)?((0,p.next)(),C()):(0,i.isContextual)(T.ContextualKeyword._opaque)?((0,p.next)(),w(!0)):(0,i.isContextual)(T.ContextualKeyword._interface)?((0,p.next)(),f()):(0,p.match)(r.TokenType._export)?((0,i.expect)(r.TokenType._export),(0,p.eat)(r.TokenType._default)?(0,p.match)(r.TokenType._function)||(0,p.match)(r.TokenType._class)?x():(D(),(0,i.semicolon)()):(0,p.match)(r.TokenType._var)||(0,p.match)(r.TokenType._function)||(0,p.match)(r.TokenType._class)||(0,i.isContextual)(T.ContextualKeyword._opaque)?x():(0,p.match)(r.TokenType.star)||(0,p.match)(r.TokenType.braceL)||(0,i.isContextual)(T.ContextualKeyword._interface)||(0,i.isContextual)(T.ContextualKeyword._type)||(0,i.isContextual)(T.ContextualKeyword._opaque)?(0,y.parseExport)():(0,i.unexpected)()):(0,i.unexpected)()}function f(e=!1){if(d(),(0,p.match)(r.TokenType.lessThan)&&_(),(0,p.eat)(r.TokenType._extends))do{m()}while(!e&&(0,p.eat)(r.TokenType.comma));if((0,i.isContextual)(T.ContextualKeyword._mixins)){(0,p.next)();do{m()}while((0,p.eat)(r.TokenType.comma))}if((0,i.isContextual)(T.ContextualKeyword._implements)){(0,p.next)();do{m()}while((0,p.eat)(r.TokenType.comma))}S(e,!1,e)}function m(){L(!1),(0,p.match)(r.TokenType.lessThan)&&b()}function h(){f()}function d(){(0,c.parseIdentifier)()}function C(){d(),(0,p.match)(r.TokenType.lessThan)&&_(),u(r.TokenType.eq),(0,i.semicolon)()}function w(e){(0,i.expectContextual)(T.ContextualKeyword._type),d(),(0,p.match)(r.TokenType.lessThan)&&_(),(0,p.match)(r.TokenType.colon)&&u(r.TokenType.colon),e||u(r.TokenType.eq),(0,i.semicolon)()}function _(){const e=(0,p.pushTypeContext)(0);(0,p.match)(r.TokenType.lessThan)||(0,p.match)(r.TokenType.typeParameterStart)?(0,p.next)():(0,i.unexpected)();do{M(),O(),(0,p.eat)(r.TokenType.eq)&&D(),(0,p.match)(r.TokenType.greaterThan)||(0,i.expect)(r.TokenType.comma)}while(!(0,p.match)(r.TokenType.greaterThan)&&!s.state.error);(0,i.expect)(r.TokenType.greaterThan),(0,p.popTypeContext)(e)}function b(){const e=(0,p.pushTypeContext)(0);for((0,i.expect)(r.TokenType.lessThan);!(0,p.match)(r.TokenType.greaterThan)&&!s.state.error;)D(),(0,p.match)(r.TokenType.greaterThan)||(0,i.expect)(r.TokenType.comma);(0,i.expect)(r.TokenType.greaterThan),(0,p.popTypeContext)(e)}function K(){(0,p.match)(r.TokenType.num)||(0,p.match)(r.TokenType.string)?(0,c.parseExprAtom)():(0,c.parseIdentifier)()}function P(){for((0,p.match)(r.TokenType.lessThan)&&_(),(0,i.expect)(r.TokenType.parenL);!(0,p.match)(r.TokenType.parenR)&&!(0,p.match)(r.TokenType.ellipsis)&&!s.state.error;)I(),(0,p.match)(r.TokenType.parenR)||(0,i.expect)(r.TokenType.comma);(0,p.eat)(r.TokenType.ellipsis)&&I(),(0,i.expect)(r.TokenType.parenR),u()}function S(e,t,n){let o;for(t&&(0,p.match)(r.TokenType.braceBarL)?((0,i.expect)(r.TokenType.braceBarL),o=r.TokenType.braceBarR):((0,i.expect)(r.TokenType.braceL),o=r.TokenType.braceR);!(0,p.match)(o)&&!s.state.error;){if(n&&(0,i.isContextual)(T.ContextualKeyword._proto)){const t=(0,p.lookaheadType)();t!==r.TokenType.colon&&t!==r.TokenType.question&&((0,p.next)(),e=!1)}if(e&&(0,i.isContextual)(T.ContextualKeyword._static)){const e=(0,p.lookaheadType)();e!==r.TokenType.colon&&e!==r.TokenType.question&&(0,p.next)()}if(M(),(0,p.eat)(r.TokenType.bracketL))(0,p.eat)(r.TokenType.bracketL)?(K(),(0,i.expect)(r.TokenType.bracketR),(0,i.expect)(r.TokenType.bracketR),(0,p.match)(r.TokenType.lessThan)||(0,p.match)(r.TokenType.parenL)?P():((0,p.eat)(r.TokenType.question),u())):((0,p.lookaheadType)()===r.TokenType.colon?(K(),u()):D(),(0,i.expect)(r.TokenType.bracketR),u());else if((0,p.match)(r.TokenType.parenL)||(0,p.match)(r.TokenType.lessThan))P();else{if((0,i.isContextual)(T.ContextualKeyword._get)||(0,i.isContextual)(T.ContextualKeyword._set)){const e=(0,p.lookaheadType)();e!==r.TokenType.name&&e!==r.TokenType.string&&e!==r.TokenType.num||(0,p.next)()}R()}A()}(0,i.expect)(o)}function R(){if((0,p.match)(r.TokenType.ellipsis)){if((0,i.expect)(r.TokenType.ellipsis),(0,p.eat)(r.TokenType.comma)||(0,p.eat)(r.TokenType.semi),(0,p.match)(r.TokenType.braceR))return;D()}else K(),(0,p.match)(r.TokenType.lessThan)||(0,p.match)(r.TokenType.parenL)?P():((0,p.eat)(r.TokenType.question),u())}function A(){(0,p.eat)(r.TokenType.semi)||(0,p.eat)(r.TokenType.comma)||(0,p.match)(r.TokenType.braceR)||(0,p.match)(r.TokenType.braceBarR)||(0,i.unexpected)()}function L(e){for(e||(0,c.parseIdentifier)();(0,p.eat)(r.TokenType.dot);)(0,c.parseIdentifier)()}function I(){const e=(0,p.lookaheadType)();e===r.TokenType.colon||e===r.TokenType.question?((0,c.parseIdentifier)(),(0,p.eat)(r.TokenType.question),u()):D()}function g(){for(;!(0,p.match)(r.TokenType.parenR)&&!(0,p.match)(r.TokenType.ellipsis)&&!s.state.error;)I(),(0,p.match)(r.TokenType.parenR)||(0,i.expect)(r.TokenType.comma);(0,p.eat)(r.TokenType.ellipsis)&&I()}function q(){let e=!1;const t=s.state.noAnonFunctionType;switch(s.state.type){case r.TokenType.name:return(0,i.isContextual)(T.ContextualKeyword._interface)?void function(){if((0,i.expectContextual)(T.ContextualKeyword._interface),(0,p.eat)(r.TokenType._extends))do{m()}while((0,p.eat)(r.TokenType.comma));S(!1,!1,!1)}():((0,c.parseIdentifier)(),L(!0),void((0,p.match)(r.TokenType.lessThan)&&b()));case r.TokenType.braceL:return void S(!1,!1,!1);case r.TokenType.braceBarL:return void S(!1,!0,!1);case r.TokenType.bracketL:return void function(){for((0,i.expect)(r.TokenType.bracketL);s.state.pos<s.input.length&&!(0,p.match)(r.TokenType.bracketR)&&(D(),!(0,p.match)(r.TokenType.bracketR));)(0,i.expect)(r.TokenType.comma);(0,i.expect)(r.TokenType.bracketR)}();case r.TokenType.lessThan:return _(),(0,i.expect)(r.TokenType.parenL),g(),(0,i.expect)(r.TokenType.parenR),(0,i.expect)(r.TokenType.arrow),void D();case r.TokenType.parenL:if((0,p.next)(),!(0,p.match)(r.TokenType.parenR)&&!(0,p.match)(r.TokenType.ellipsis))if((0,p.match)(r.TokenType.name)){const t=(0,p.lookaheadType)();e=t!==r.TokenType.question&&t!==r.TokenType.colon}else e=!0;if(e){if(s.state.noAnonFunctionType=!1,D(),s.state.noAnonFunctionType=t,s.state.noAnonFunctionType||!((0,p.match)(r.TokenType.comma)||(0,p.match)(r.TokenType.parenR)&&(0,p.lookaheadType)()===r.TokenType.arrow))return void(0,i.expect)(r.TokenType.parenR);(0,p.eat)(r.TokenType.comma)}return g(),(0,i.expect)(r.TokenType.parenR),(0,i.expect)(r.TokenType.arrow),void D();case r.TokenType.minus:return(0,p.next)(),void(0,c.parseLiteral)();case r.TokenType.string:case r.TokenType.num:case r.TokenType._true:case r.TokenType._false:case r.TokenType._null:case r.TokenType._this:case r.TokenType._void:case r.TokenType.star:return void(0,p.next)();default:if(s.state.type===r.TokenType._typeof)return(0,i.expect)(r.TokenType._typeof),void q();if(s.state.type&r.TokenType.IS_KEYWORD)return(0,p.next)(),void(s.state.tokens[s.state.tokens.length-1].type=r.TokenType.name)}(0,i.unexpected)()}function E(){(0,p.eat)(r.TokenType.question)?E():function(){for(q();!(0,i.canInsertSemicolon)()&&((0,p.match)(r.TokenType.bracketL)||(0,p.match)(r.TokenType.questionDot));)(0,p.eat)(r.TokenType.questionDot),(0,i.expect)(r.TokenType.bracketL),(0,p.eat)(r.TokenType.bracketR)||(D(),(0,i.expect)(r.TokenType.bracketR))}()}function F(){E(),!s.state.noAnonFunctionType&&(0,p.eat)(r.TokenType.arrow)&&D()}function v(){for((0,p.eat)(r.TokenType.bitwiseAND),F();(0,p.eat)(r.TokenType.bitwiseAND);)F()}function D(){!function(){for((0,p.eat)(r.TokenType.bitwiseOR),v();(0,p.eat)(r.TokenType.bitwiseOR);)v()}()}function B(){u()}function O(){(0,c.parseIdentifier)(),(0,p.match)(r.TokenType.colon)&&B()}function M(){((0,p.match)(r.TokenType.plus)||(0,p.match)(r.TokenType.minus))&&((0,p.next)(),s.state.tokens[s.state.tokens.length-1].isType=!0)}function W(){(0,i.expectContextual)(T.ContextualKeyword._enum),s.state.tokens[s.state.tokens.length-1].type=r.TokenType._enum,(0,c.parseIdentifier)(),function(){(0,i.eatContextual)(T.ContextualKeyword._of)&&(0,p.next)();(0,i.expect)(r.TokenType.braceL),function(){for(;!(0,p.match)(r.TokenType.braceR)&&!s.state.error&&!(0,p.eat)(r.TokenType.ellipsis);)Y(),(0,p.match)(r.TokenType.braceR)||(0,i.expect)(r.TokenType.comma)}(),(0,i.expect)(r.TokenType.braceR)}()}function Y(){(0,c.parseIdentifier)(),(0,p.eat)(r.TokenType.eq)&&(0,p.next)()}},
"8178e7c3c8": function _(e,t,n,o,a){o(),n.parseExpression=b,n.parseMaybeAssign=S,n.baseParseMaybeAssign=g,n.baseParseConditional=w,n.parseMaybeUnary=E,n.parseExprSubscripts=C,n.baseParseSubscripts=_,n.baseParseSubscript=F,n.atPossibleAsync=A,n.parseCallExpressionArguments=L,n.parseExprAtom=B,n.parseLiteral=O,n.parseParenExpression=function(){(0,m.expect)(l.TokenType.parenL),b(),(0,m.expect)(l.TokenType.parenR)},n.parseArrow=N,n.parseTemplate=v,n.parseObj=q,n.parsePropertyName=Q,n.parseMethod=G,n.parseArrowExpression=J,n.parseFunctionBodyAndFinish=z,n.parseFunctionBody=H,n.parseIdentifier=Y;const s=e("9b8d43cd0a"),r=e("d7708a7d24"),c=e("85c51351f6"),p=e("6a970c22b9"),T=e("bfb18d0576"),i=e("99ff836c64"),k=e("eda46439d5"),l=e("f0c35cbd76"),y=e("22746c8ce8"),u=e("364148c9f0"),h=e("540718e523"),d=e("4cefc59e67"),f=e("e3b9989da1"),m=e("bc94bbadc1");class x{constructor(e){this.stop=e}}function b(e=!1){if(S(e),(0,T.match)(l.TokenType.comma))for(;(0,T.eat)(l.TokenType.comma);)S(e)}function S(e=!1,t=!1){return h.isTypeScriptEnabled?(0,p.tsParseMaybeAssign)(e,t):h.isFlowEnabled?(0,s.flowParseMaybeAssign)(e,t):g(e,t)}function g(e,t){if((0,T.match)(l.TokenType._yield))return(0,T.next)(),(0,T.match)(l.TokenType.semi)||(0,m.canInsertSemicolon)()||((0,T.eat)(l.TokenType.star),S()),!1;((0,T.match)(l.TokenType.parenL)||(0,T.match)(l.TokenType.name)||(0,T.match)(l.TokenType._yield))&&(h.state.potentialArrowAt=h.state.start);const n=function(e){const t=function(e){const t=h.state.tokens.length,n=E();if(n)return!0;return I(t,-1,e),!1}(e);if(t)return!0;return function(e){h.isTypeScriptEnabled||h.isFlowEnabled?(0,c.typedParseConditional)(e):w(e)}(e),!1}(e);return t&&M(),h.state.type&l.TokenType.IS_ASSIGN?((0,T.next)(),S(e),!1):n}function w(e){(0,T.eat)(l.TokenType.question)&&(S(),(0,m.expect)(l.TokenType.colon),S(e))}function I(e,t,n){if(h.isTypeScriptEnabled&&(l.TokenType._in&l.TokenType.PRECEDENCE_MASK)>t&&!(0,m.hasPrecedingLineBreak)()&&((0,m.eatContextual)(i.ContextualKeyword._as)||(0,m.eatContextual)(i.ContextualKeyword._satisfies))){const o=(0,T.pushTypeContext)(1);return(0,p.tsParseType)(),(0,T.popTypeContext)(o),(0,T.rescan_gt)(),void I(e,t,n)}const o=h.state.type&l.TokenType.PRECEDENCE_MASK;if(o>0&&(!n||!(0,T.match)(l.TokenType._in))&&o>t){const a=h.state.type;(0,T.next)(),a===l.TokenType.nullishCoalescing&&(h.state.tokens[h.state.tokens.length-1].nullishStartIndex=e);const s=h.state.tokens.length;E(),I(s,a&l.TokenType.IS_RIGHT_ASSOCIATIVE?o-1:o,n),a===l.TokenType.nullishCoalescing&&(h.state.tokens[e].numNullishCoalesceStarts++,h.state.tokens[h.state.tokens.length-1].numNullishCoalesceEnds++),I(e,t,n)}}function E(){if(h.isTypeScriptEnabled&&!h.isJSXEnabled&&(0,T.eat)(l.TokenType.lessThan))return(0,p.tsParseTypeAssertion)(),!1;if((0,m.isContextual)(i.ContextualKeyword._module)&&(0,T.lookaheadCharCode)()===y.charCodes.leftCurlyBrace&&!(0,m.hasFollowingLineBreak)())return(0,m.expectContextual)(i.ContextualKeyword._module),(0,m.expect)(l.TokenType.braceL),(0,f.parseBlockBody)(l.TokenType.braceR),!1;if(h.state.type&l.TokenType.IS_PREFIX)return(0,T.next)(),E(),!1;if(C())return!0;for(;h.state.type&l.TokenType.IS_POSTFIX&&!(0,m.canInsertSemicolon)();)h.state.type===l.TokenType.preIncDec&&(h.state.type=l.TokenType.postIncDec),(0,T.next)();return!1}function C(){const e=h.state.tokens.length;return!!B()||(P(e),h.state.tokens.length>e&&h.state.tokens[e].isOptionalChainStart&&(h.state.tokens[h.state.tokens.length-1].isOptionalChainEnd=!0),!1)}function P(e,t=!1){h.isFlowEnabled?(0,s.flowParseSubscripts)(e,t):_(e,t)}function _(e,t=!1){const n=new x(!1);do{R(e,t,n)}while(!n.stop&&!h.state.error)}function R(e,t,n){h.isTypeScriptEnabled?(0,p.tsParseSubscript)(e,t,n):h.isFlowEnabled?(0,s.flowParseSubscript)(e,t,n):F(e,t,n)}function F(e,t,n){if(!t&&(0,T.eat)(l.TokenType.doubleColon))D(),n.stop=!0,P(e,t);else if((0,T.match)(l.TokenType.questionDot)){if(h.state.tokens[e].isOptionalChainStart=!0,t&&(0,T.lookaheadType)()===l.TokenType.parenL)return void(n.stop=!0);(0,T.next)(),h.state.tokens[h.state.tokens.length-1].subscriptStartIndex=e,(0,T.eat)(l.TokenType.bracketL)?(b(),(0,m.expect)(l.TokenType.bracketR)):(0,T.eat)(l.TokenType.parenL)?L():K()}else if((0,T.eat)(l.TokenType.dot))h.state.tokens[h.state.tokens.length-1].subscriptStartIndex=e,K();else if((0,T.eat)(l.TokenType.bracketL))h.state.tokens[h.state.tokens.length-1].subscriptStartIndex=e,b(),(0,m.expect)(l.TokenType.bracketR);else if(!t&&(0,T.match)(l.TokenType.parenL))if(A()){const t=h.state.snapshot(),o=h.state.tokens.length;(0,T.next)(),h.state.tokens[h.state.tokens.length-1].subscriptStartIndex=e;const a=(0,h.getNextContextId)();h.state.tokens[h.state.tokens.length-1].contextId=a,L(),h.state.tokens[h.state.tokens.length-1].contextId=a,((0,T.match)(l.TokenType.colon)||(0,T.match)(l.TokenType.arrow))&&(h.state.restoreFromSnapshot(t),n.stop=!0,h.state.scopeDepth++,(0,f.parseFunctionParams)(),function(e){h.isTypeScriptEnabled?(0,p.tsStartParseAsyncArrowFromCallExpression)():h.isFlowEnabled&&(0,s.flowStartParseAsyncArrowFromCallExpression)();(0,m.expect)(l.TokenType.arrow),J(e)}(o))}else{(0,T.next)(),h.state.tokens[h.state.tokens.length-1].subscriptStartIndex=e;const t=(0,h.getNextContextId)();h.state.tokens[h.state.tokens.length-1].contextId=t,L(),h.state.tokens[h.state.tokens.length-1].contextId=t}else(0,T.match)(l.TokenType.backQuote)?v():n.stop=!0}function A(){return h.state.tokens[h.state.tokens.length-1].contextualKeyword===i.ContextualKeyword._async&&!(0,m.canInsertSemicolon)()}function L(){let e=!0;for(;!(0,T.eat)(l.TokenType.parenR)&&!h.state.error;){if(e)e=!1;else if((0,m.expect)(l.TokenType.comma),(0,T.eat)(l.TokenType.parenR))break;W(!1)}}function D(){const e=h.state.tokens.length;B(),P(e,!0)}function B(){if((0,T.eat)(l.TokenType.modulo))return Y(),!1;if((0,T.match)(l.TokenType.jsxText)||(0,T.match)(l.TokenType.jsxEmptyText))return O(),!1;if((0,T.match)(l.TokenType.lessThan)&&h.isJSXEnabled)return h.state.type=l.TokenType.jsxTagStart,(0,r.jsxParseElement)(),(0,T.next)(),!1;const e=h.state.potentialArrowAt===h.state.start;switch(h.state.type){case l.TokenType.slash:case l.TokenType.assign:(0,T.retokenizeSlashAsRegex)();case l.TokenType._super:case l.TokenType._this:case l.TokenType.regexp:case l.TokenType.num:case l.TokenType.bigint:case l.TokenType.decimal:case l.TokenType.string:case l.TokenType._null:case l.TokenType._true:case l.TokenType._false:return(0,T.next)(),!1;case l.TokenType._import:return(0,T.next)(),(0,T.match)(l.TokenType.dot)&&(h.state.tokens[h.state.tokens.length-1].type=l.TokenType.name,(0,T.next)(),Y()),!1;case l.TokenType.name:{const t=h.state.tokens.length,n=h.state.start,o=h.state.contextualKeyword;return Y(),o===i.ContextualKeyword._await?(E(),!1):o===i.ContextualKeyword._async&&(0,T.match)(l.TokenType._function)&&!(0,m.canInsertSemicolon)()?((0,T.next)(),(0,f.parseFunction)(n,!1),!1):e&&o===i.ContextualKeyword._async&&!(0,m.canInsertSemicolon)()&&(0,T.match)(l.TokenType.name)?(h.state.scopeDepth++,(0,d.parseBindingIdentifier)(!1),(0,m.expect)(l.TokenType.arrow),J(t),!0):(0,T.match)(l.TokenType._do)&&!(0,m.canInsertSemicolon)()?((0,T.next)(),(0,f.parseBlock)(),!1):e&&!(0,m.canInsertSemicolon)()&&(0,T.match)(l.TokenType.arrow)?(h.state.scopeDepth++,(0,d.markPriorBindingIdentifier)(!1),(0,m.expect)(l.TokenType.arrow),J(t),!0):(h.state.tokens[h.state.tokens.length-1].identifierRole=T.IdentifierRole.Access,!1)}case l.TokenType._do:return(0,T.next)(),(0,f.parseBlock)(),!1;case l.TokenType.parenL:return j(e);case l.TokenType.bracketL:return(0,T.next)(),U(l.TokenType.bracketR,!0),!1;case l.TokenType.braceL:return q(!1,!1),!1;case l.TokenType._function:return function(){const e=h.state.start;Y(),(0,T.eat)(l.TokenType.dot)&&Y();(0,f.parseFunction)(e,!1)}(),!1;case l.TokenType.at:(0,f.parseDecorators)();case l.TokenType._class:return(0,f.parseClass)(!1),!1;case l.TokenType._new:return function(){if((0,m.expect)(l.TokenType._new),(0,T.eat)(l.TokenType.dot))return void Y();D(),void(0,T.eat)(l.TokenType.questionDot),h.isFlowEnabled&&(0,s.flowStartParseNewArguments)();(0,T.eat)(l.TokenType.parenL)&&U(l.TokenType.parenR)}(),!1;case l.TokenType.backQuote:return v(),!1;case l.TokenType.doubleColon:return(0,T.next)(),D(),!1;case l.TokenType.hash:{const e=(0,T.lookaheadCharCode)();return u.IS_IDENTIFIER_START[e]||e===y.charCodes.backslash?K():(0,T.next)(),!1}default:return(0,m.unexpected)(),!1}}function K(){(0,T.eat)(l.TokenType.hash),Y()}function O(){(0,T.next)()}function j(e){const t=h.state.snapshot(),n=h.state.tokens.length;(0,m.expect)(l.TokenType.parenL);let o=!0;for(;!(0,T.match)(l.TokenType.parenR)&&!h.state.error;){if(o)o=!1;else if((0,m.expect)(l.TokenType.comma),(0,T.match)(l.TokenType.parenR))break;if((0,T.match)(l.TokenType.ellipsis)){(0,d.parseRest)(!1),M();break}S(!1,!0)}if((0,m.expect)(l.TokenType.parenR),e&&((0,T.match)(l.TokenType.colon)||!(0,m.canInsertSemicolon)())){if(N())return h.state.restoreFromSnapshot(t),h.state.scopeDepth++,(0,f.parseFunctionParams)(),N(),J(n),!h.state.error||(h.state.restoreFromSnapshot(t),j(!1),!1)}return!1}function N(){return h.isTypeScriptEnabled?(0,p.tsParseArrow)():h.isFlowEnabled?(0,s.flowParseArrow)():(0,T.eat)(l.TokenType.arrow)}function M(){(h.isTypeScriptEnabled||h.isFlowEnabled)&&(0,c.typedParseParenItem)()}function v(){for((0,T.nextTemplateToken)(),(0,T.nextTemplateToken)();!(0,T.match)(l.TokenType.backQuote)&&!h.state.error;)(0,m.expect)(l.TokenType.dollarBraceL),b(),(0,T.nextTemplateToken)(),(0,T.nextTemplateToken)();(0,T.next)()}function q(e,t){const n=(0,h.getNextContextId)();let o=!0;for((0,T.next)(),h.state.tokens[h.state.tokens.length-1].contextId=n;!(0,T.eat)(l.TokenType.braceR)&&!h.state.error;){if(o)o=!1;else if((0,m.expect)(l.TokenType.comma),(0,T.eat)(l.TokenType.braceR))break;let a=!1;if((0,T.match)(l.TokenType.ellipsis)){const n=h.state.tokens.length;if((0,d.parseSpread)(),e&&(h.state.tokens.length===n+2&&(0,d.markPriorBindingIdentifier)(t),(0,T.eat)(l.TokenType.braceR)))break}else e||(a=(0,T.eat)(l.TokenType.star)),!e&&(0,m.isContextual)(i.ContextualKeyword._async)?(a&&(0,m.unexpected)(),Y(),(0,T.match)(l.TokenType.colon)||(0,T.match)(l.TokenType.parenL)||(0,T.match)(l.TokenType.braceR)||(0,T.match)(l.TokenType.eq)||(0,T.match)(l.TokenType.comma)||((0,T.match)(l.TokenType.star)&&((0,T.next)(),a=!0),Q(n))):Q(n),X(e,t,n)}h.state.tokens[h.state.tokens.length-1].contextId=n}function V(e,t){const n=h.state.start;return(0,T.match)(l.TokenType.parenL)?(e&&(0,m.unexpected)(),G(n,!1),!0):!!function(e){return!e&&((0,T.match)(l.TokenType.string)||(0,T.match)(l.TokenType.num)||(0,T.match)(l.TokenType.bracketL)||(0,T.match)(l.TokenType.name)||!!(h.state.type&l.TokenType.IS_KEYWORD))}(e)&&(Q(t),G(n,!1),!0)}function X(e,t,n){h.isTypeScriptEnabled?(0,p.tsStartParseObjPropValue)():h.isFlowEnabled&&(0,s.flowStartParseObjPropValue)();V(e,n)||function(e,t){if((0,T.eat)(l.TokenType.colon))return void(e?(0,d.parseMaybeDefault)(t):S(!1));let n;n=e?0===h.state.scopeDepth?T.IdentifierRole.ObjectShorthandTopLevelDeclaration:t?T.IdentifierRole.ObjectShorthandBlockScopedDeclaration:T.IdentifierRole.ObjectShorthandFunctionScopedDeclaration:T.IdentifierRole.ObjectShorthand,h.state.tokens[h.state.tokens.length-1].identifierRole=n,(0,d.parseMaybeDefault)(t,!0)}(e,t)}function Q(e){h.isFlowEnabled&&(0,s.flowParseVariance)(),(0,T.eat)(l.TokenType.bracketL)?(h.state.tokens[h.state.tokens.length-1].contextId=e,S(),(0,m.expect)(l.TokenType.bracketR),h.state.tokens[h.state.tokens.length-1].contextId=e):((0,T.match)(l.TokenType.num)||(0,T.match)(l.TokenType.string)||(0,T.match)(l.TokenType.bigint)||(0,T.match)(l.TokenType.decimal)?B():K(),h.state.tokens[h.state.tokens.length-1].identifierRole=T.IdentifierRole.ObjectKey,h.state.tokens[h.state.tokens.length-1].contextId=e)}function G(e,t){const n=(0,h.getNextContextId)();h.state.scopeDepth++;const o=h.state.tokens.length,a=t;(0,f.parseFunctionParams)(a,n),z(e,n);const s=h.state.tokens.length;h.state.scopes.push(new k.Scope(o,s,!0)),h.state.scopeDepth--}function J(e){H(!0);const t=h.state.tokens.length;h.state.scopes.push(new k.Scope(e,t,!0)),h.state.scopeDepth--}function z(e,t=0){h.isTypeScriptEnabled?(0,p.tsParseFunctionBodyAndFinish)(e,t):h.isFlowEnabled?(0,s.flowParseFunctionBodyAndFinish)(t):H(!1,t)}function H(e,t=0){e&&!(0,T.match)(l.TokenType.braceL)?S():(0,f.parseBlock)(!0,t)}function U(e,t=!1){let n=!0;for(;!(0,T.eat)(e)&&!h.state.error;){if(n)n=!1;else if((0,m.expect)(l.TokenType.comma),(0,T.eat)(e))break;W(t)}}function W(e){e&&(0,T.match)(l.TokenType.comma)||((0,T.match)(l.TokenType.ellipsis)?((0,d.parseSpread)(),M()):(0,T.match)(l.TokenType.question)?(0,T.next)():S(!1,!0))}function Y(){(0,T.next)(),h.state.tokens[h.state.tokens.length-1].type=l.TokenType.name}n.StopState=x},
"d7708a7d24": function _(e,t,s,o,n){o(),s.jsxParseElement=x,s.nextJSXTagToken=C;const a=e("bfb18d0576"),r=e("f0c35cbd76"),c=e("540718e523"),i=e("8178e7c3c8"),T=e("bc94bbadc1"),p=e("22746c8ce8"),d=e("364148c9f0"),h=e("6a970c22b9");function k(){C()}function l(e){k(),(0,a.eat)(r.TokenType.colon)?k():c.state.tokens[c.state.tokens.length-1].identifierRole=e}function u(){const e=c.state.tokens.length;l(a.IdentifierRole.Access);let t=!1;for(;(0,a.match)(r.TokenType.dot);)t=!0,C(),k();if(!t){const t=c.state.tokens[e],s=c.input.charCodeAt(t.start);s>=p.charCodes.lowercaseA&&s<=p.charCodes.lowercaseZ&&(t.identifierRole=null)}}function f(){switch(c.state.type){case r.TokenType.braceL:return(0,a.next)(),(0,i.parseExpression)(),void C();case r.TokenType.jsxTagStart:return x(),void C();case r.TokenType.string:return void C();default:(0,T.unexpected)("JSX value should be either an expression or a quoted JSX text")}}function y(){const e=c.state.tokens.length-1;c.state.tokens[e].jsxRole=a.JSXRole.NoChildren;let t=0;const s=function(e){if((0,a.match)(r.TokenType.jsxTagEnd))return!1;u(),c.isTypeScriptEnabled&&(0,h.tsTryParseJSXTypeArgument)();let t=!1;for(;!(0,a.match)(r.TokenType.slash)&&!(0,a.match)(r.TokenType.jsxTagEnd)&&!c.state.error;)(0,a.eat)(r.TokenType.braceL)?(t=!0,(0,T.expect)(r.TokenType.ellipsis),(0,i.parseMaybeAssign)(),C()):(t&&c.state.end-c.state.start==3&&c.input.charCodeAt(c.state.start)===p.charCodes.lowercaseK&&c.input.charCodeAt(c.state.start+1)===p.charCodes.lowercaseE&&c.input.charCodeAt(c.state.start+2)===p.charCodes.lowercaseY&&(c.state.tokens[e].jsxRole=a.JSXRole.KeyAfterPropSpread),l(a.IdentifierRole.ObjectKey),(0,a.match)(r.TokenType.eq)&&(C(),f()));const s=(0,a.match)(r.TokenType.slash);return s&&C(),s}(e);if(!s)for(b();;)switch(c.state.type){case r.TokenType.jsxTagStart:if(C(),(0,a.match)(r.TokenType.slash))return C(),(0,a.match)(r.TokenType.jsxTagEnd)||u(),void(c.state.tokens[e].jsxRole!==a.JSXRole.KeyAfterPropSpread&&(1===t?c.state.tokens[e].jsxRole=a.JSXRole.OneChild:t>1&&(c.state.tokens[e].jsxRole=a.JSXRole.StaticChildren)));t++,y(),b();break;case r.TokenType.jsxText:t++,b();break;case r.TokenType.jsxEmptyText:b();break;case r.TokenType.braceL:(0,a.next)(),(0,a.match)(r.TokenType.ellipsis)?((0,T.expect)(r.TokenType.ellipsis),(0,i.parseExpression)(),b(),t+=2):((0,a.match)(r.TokenType.braceR)||(t++,(0,i.parseExpression)()),b());break;default:return void(0,T.unexpected)()}}function x(){C(),y()}function C(){c.state.tokens.push(new a.Token),(0,a.skipSpace)(),c.state.start=c.state.pos;const e=c.input.charCodeAt(c.state.pos);if(d.IS_IDENTIFIER_START[e])!function(){let e;do{if(c.state.pos>c.input.length)return void(0,T.unexpected)("Unexpectedly reached the end of input.");e=c.input.charCodeAt(++c.state.pos)}while(d.IS_IDENTIFIER_CHAR[e]||e===p.charCodes.dash);(0,a.finishToken)(r.TokenType.jsxName)}();else if(e===p.charCodes.quotationMark||e===p.charCodes.apostrophe)!function(e){for(c.state.pos++;;){if(c.state.pos>=c.input.length)return void(0,T.unexpected)("Unterminated string constant");if(c.input.charCodeAt(c.state.pos)===e){c.state.pos++;break}c.state.pos++}(0,a.finishToken)(r.TokenType.string)}(e);else switch(++c.state.pos,e){case p.charCodes.greaterThan:(0,a.finishToken)(r.TokenType.jsxTagEnd);break;case p.charCodes.lessThan:(0,a.finishToken)(r.TokenType.jsxTagStart);break;case p.charCodes.slash:(0,a.finishToken)(r.TokenType.slash);break;case p.charCodes.equalsTo:(0,a.finishToken)(r.TokenType.eq);break;case p.charCodes.leftCurlyBrace:(0,a.finishToken)(r.TokenType.braceL);break;case p.charCodes.dot:(0,a.finishToken)(r.TokenType.dot);break;case p.charCodes.colon:(0,a.finishToken)(r.TokenType.colon);break;default:(0,T.unexpected)()}}function b(){c.state.tokens.push(new a.Token),c.state.start=c.state.pos,function(){let e=!1,t=!1;for(;;){if(c.state.pos>=c.input.length)return void(0,T.unexpected)("Unterminated JSX contents");const s=c.input.charCodeAt(c.state.pos);if(s===p.charCodes.lessThan||s===p.charCodes.leftCurlyBrace)return c.state.pos===c.state.start?s===p.charCodes.lessThan?(c.state.pos++,void(0,a.finishToken)(r.TokenType.jsxTagStart)):void(0,a.getTokenFromCode)(s):void(e&&!t?(0,a.finishToken)(r.TokenType.jsxEmptyText):(0,a.finishToken)(r.TokenType.jsxText));s===p.charCodes.lineFeed?e=!0:s!==p.charCodes.space&&s!==p.charCodes.carriageReturn&&s!==p.charCodes.tab&&(t=!0),c.state.pos++}}()}},
"6a970c22b9": function _(e,t,n,o,a){o(),n.tsParseModifiers=h,n.tsParseModifier=d,n.tsTryParseTypeParameters=_,n.tsTryParseTypeAnnotation=N,n.tsParseTypeAnnotation=X,n.tsParseType=J,n.tsParseNonConditionalType=W,n.tsParseTypeAssertion=function(){const e=(0,s.pushTypeContext)(1);J(),(0,k.expect)(T.TokenType.greaterThan),(0,s.popTypeContext)(e),(0,i.parseMaybeUnary)()},n.tsTryParseJSXTypeArgument=function(){if((0,s.eat)(T.TokenType.jsxTagStart)){p.state.tokens[p.state.tokens.length-1].type=T.TokenType.typeParameterStart;const e=(0,s.pushTypeContext)(1);for(;!(0,s.match)(T.TokenType.greaterThan)&&!p.state.error;)J(),(0,s.eat)(T.TokenType.comma);(0,u.nextJSXTagToken)(),(0,s.popTypeContext)(e)}},n.tsParseImportEqualsDeclaration=G,n.tsIsDeclarationStart=function(){if((0,s.match)(T.TokenType.name))switch(p.state.contextualKeyword){case r.ContextualKeyword._abstract:case r.ContextualKeyword._declare:case r.ContextualKeyword._enum:case r.ContextualKeyword._interface:case r.ContextualKeyword._module:case r.ContextualKeyword._namespace:case r.ContextualKeyword._type:return!0}return!1},n.tsParseFunctionBodyAndFinish=function(e,t){(0,s.match)(T.TokenType.colon)&&O(T.TokenType.colon);if(!(0,s.match)(T.TokenType.braceL)&&(0,k.isLineTerminator)()){let t=p.state.tokens.length-1;for(;t>=0&&(p.state.tokens[t].start>=e||p.state.tokens[t].type===T.TokenType._default||p.state.tokens[t].type===T.TokenType._export);)p.state.tokens[t].isType=!0,t--;return}(0,i.parseFunctionBody)(!1,t)},n.tsParseSubscript=function(e,t,n){if(!(0,k.hasPrecedingLineBreak)()&&(0,s.eat)(T.TokenType.bang))return void(p.state.tokens[p.state.tokens.length-1].type=T.TokenType.nonNullAssertion);if((0,s.match)(T.TokenType.lessThan)||(0,s.match)(T.TokenType.bitShiftL)){const n=p.state.snapshot();if(!t&&(0,i.atPossibleAsync)()){const e=function(){const e=p.state.snapshot();if(b(),(0,y.parseFunctionParams)(),function(){(0,s.match)(T.TokenType.colon)&&O(T.TokenType.colon)}(),(0,k.expect)(T.TokenType.arrow),p.state.error)return p.state.restoreFromSnapshot(e),!1;return(0,i.parseFunctionBody)(!0),!0}();if(e)return}if(te(),!t&&(0,s.eat)(T.TokenType.parenL)?(p.state.tokens[p.state.tokens.length-1].subscriptStartIndex=e,(0,i.parseCallExpressionArguments)()):(0,s.match)(T.TokenType.backQuote)?(0,i.parseTemplate)():(p.state.type===T.TokenType.greaterThan||p.state.type!==T.TokenType.parenL&&Boolean(p.state.type&T.TokenType.IS_EXPRESSION_START)&&!(0,k.hasPrecedingLineBreak)())&&(0,k.unexpected)(),!p.state.error)return;p.state.restoreFromSnapshot(n)}else!t&&(0,s.match)(T.TokenType.questionDot)&&(0,s.lookaheadType)()===T.TokenType.lessThan&&((0,s.next)(),p.state.tokens[e].isOptionalChainStart=!0,p.state.tokens[p.state.tokens.length-1].subscriptStartIndex=e,ne(),(0,k.expect)(T.TokenType.parenL),(0,i.parseCallExpressionArguments)());(0,i.baseParseSubscript)(e,t,n)},n.tsTryParseExport=function(){if((0,s.eat)(T.TokenType._import))return(0,k.isContextual)(r.ContextualKeyword._type)&&(0,s.lookaheadType)()!==T.TokenType.eq&&(0,k.expectContextual)(r.ContextualKeyword._type),G(),!0;if((0,s.eat)(T.TokenType.eq))return(0,i.parseExpression)(),(0,k.semicolon)(),!0;if((0,k.eatContextual)(r.ContextualKeyword._as))return(0,k.expectContextual)(r.ContextualKeyword._namespace),(0,i.parseIdentifier)(),(0,k.semicolon)(),!0;if((0,k.isContextual)(r.ContextualKeyword._type)){const e=(0,s.lookaheadType)();e!==T.TokenType.braceL&&e!==T.TokenType.star||(0,s.next)()}return!1},n.tsParseImportSpecifier=function(){if((0,i.parseIdentifier)(),(0,s.match)(T.TokenType.comma)||(0,s.match)(T.TokenType.braceR))return void(p.state.tokens[p.state.tokens.length-1].identifierRole=s.IdentifierRole.ImportDeclaration);if((0,i.parseIdentifier)(),(0,s.match)(T.TokenType.comma)||(0,s.match)(T.TokenType.braceR))return p.state.tokens[p.state.tokens.length-1].identifierRole=s.IdentifierRole.ImportDeclaration,p.state.tokens[p.state.tokens.length-2].isType=!0,void(p.state.tokens[p.state.tokens.length-1].isType=!0);if((0,i.parseIdentifier)(),(0,s.match)(T.TokenType.comma)||(0,s.match)(T.TokenType.braceR))return p.state.tokens[p.state.tokens.length-3].identifierRole=s.IdentifierRole.ImportAccess,void(p.state.tokens[p.state.tokens.length-1].identifierRole=s.IdentifierRole.ImportDeclaration);(0,i.parseIdentifier)(),p.state.tokens[p.state.tokens.length-3].identifierRole=s.IdentifierRole.ImportAccess,p.state.tokens[p.state.tokens.length-1].identifierRole=s.IdentifierRole.ImportDeclaration,p.state.tokens[p.state.tokens.length-4].isType=!0,p.state.tokens[p.state.tokens.length-3].isType=!0,p.state.tokens[p.state.tokens.length-2].isType=!0,p.state.tokens[p.state.tokens.length-1].isType=!0},n.tsParseExportSpecifier=function(){if((0,i.parseIdentifier)(),(0,s.match)(T.TokenType.comma)||(0,s.match)(T.TokenType.braceR))return void(p.state.tokens[p.state.tokens.length-1].identifierRole=s.IdentifierRole.ExportAccess);if((0,i.parseIdentifier)(),(0,s.match)(T.TokenType.comma)||(0,s.match)(T.TokenType.braceR))return p.state.tokens[p.state.tokens.length-1].identifierRole=s.IdentifierRole.ExportAccess,p.state.tokens[p.state.tokens.length-2].isType=!0,void(p.state.tokens[p.state.tokens.length-1].isType=!0);if((0,i.parseIdentifier)(),(0,s.match)(T.TokenType.comma)||(0,s.match)(T.TokenType.braceR))return void(p.state.tokens[p.state.tokens.length-3].identifierRole=s.IdentifierRole.ExportAccess);(0,i.parseIdentifier)(),p.state.tokens[p.state.tokens.length-3].identifierRole=s.IdentifierRole.ExportAccess,p.state.tokens[p.state.tokens.length-4].isType=!0,p.state.tokens[p.state.tokens.length-3].isType=!0,p.state.tokens[p.state.tokens.length-2].isType=!0,p.state.tokens[p.state.tokens.length-1].isType=!0},n.tsTryParseExportDefaultExpression=function(){if((0,k.isContextual)(r.ContextualKeyword._abstract)&&(0,s.lookaheadType)()===T.TokenType._class)return p.state.type=T.TokenType._abstract,(0,s.next)(),(0,y.parseClass)(!0,!0),!0;if((0,k.isContextual)(r.ContextualKeyword._interface)){const e=(0,s.pushTypeContext)(2);return $(r.ContextualKeyword._interface,!0),(0,s.popTypeContext)(e),!0}return!1},n.tsTryParseStatementContent=function(){if(p.state.type===T.TokenType._const){const e=(0,s.lookaheadTypeAndKeyword)();if(e.type===T.TokenType.name&&e.contextualKeyword===r.ContextualKeyword._enum)return(0,k.expect)(T.TokenType._const),(0,k.expectContextual)(r.ContextualKeyword._enum),p.state.tokens[p.state.tokens.length-1].type=T.TokenType._enum,Y(),!0}return!1},n.tsTryParseClassMemberWithIsStatic=function(e){const t=p.state.tokens.length;h([r.ContextualKeyword._abstract,r.ContextualKeyword._readonly,r.ContextualKeyword._declare,r.ContextualKeyword._static,r.ContextualKeyword._override]);const n=p.state.tokens.length;if(S()){for(let o=e?t-1:t;o<n;o++)p.state.tokens[o].isType=!0;return!0}return!1},n.tsParseIdentifierStatement=function(e){(function(e){switch(e){case r.ContextualKeyword._declare:{const e=p.state.tokens.length-1,t=function(){if((0,k.isLineTerminator)())return!1;switch(p.state.type){case T.TokenType._function:{const e=(0,s.pushTypeContext)(1);(0,s.next)();const t=p.state.start;return(0,y.parseFunction)(t,!0),(0,s.popTypeContext)(e),!0}case T.TokenType._class:{const e=(0,s.pushTypeContext)(1);return(0,y.parseClass)(!0,!1),(0,s.popTypeContext)(e),!0}case T.TokenType._const:if((0,s.match)(T.TokenType._const)&&(0,k.isLookaheadContextual)(r.ContextualKeyword._enum)){const e=(0,s.pushTypeContext)(1);return(0,k.expect)(T.TokenType._const),(0,k.expectContextual)(r.ContextualKeyword._enum),p.state.tokens[p.state.tokens.length-1].type=T.TokenType._enum,Y(),(0,s.popTypeContext)(e),!0}case T.TokenType._var:case T.TokenType._let:{const e=(0,s.pushTypeContext)(1);return(0,y.parseVarStatement)(p.state.type!==T.TokenType._var),(0,s.popTypeContext)(e),!0}case T.TokenType.name:{const e=(0,s.pushTypeContext)(1),t=p.state.contextualKeyword;let n=!1;return t===r.ContextualKeyword._global?(z(),n=!0):n=$(t,!0),(0,s.popTypeContext)(e),n}default:return!1}}();if(t)return p.state.tokens[e].type=T.TokenType._declare,!0;break}case r.ContextualKeyword._global:if((0,s.match)(T.TokenType.braceL))return H(),!0;break;default:return $(e,!1)}return!1})(e)||(0,k.semicolon)()},n.tsParseExportDeclaration=function(){const e=(0,k.eatContextual)(r.ContextualKeyword._declare);e&&(p.state.tokens[p.state.tokens.length-1].type=T.TokenType._declare);let t=!1;if((0,s.match)(T.TokenType.name))if(e){const e=(0,s.pushTypeContext)(2);t=Z(),(0,s.popTypeContext)(e)}else t=Z();if(!t)if(e){const e=(0,s.pushTypeContext)(2);(0,y.parseStatement)(!0),(0,s.popTypeContext)(e)}else(0,y.parseStatement)(!0)},n.tsAfterParseClassSuper=function(e){e&&((0,s.match)(T.TokenType.lessThan)||(0,s.match)(T.TokenType.bitShiftL))&&te();if((0,k.eatContextual)(r.ContextualKeyword._implements)){p.state.tokens[p.state.tokens.length-1].type=T.TokenType._implements;const e=(0,s.pushTypeContext)(1);Q(),(0,s.popTypeContext)(e)}},n.tsStartParseObjPropValue=function(){_()},n.tsStartParseFunctionParams=function(){_()},n.tsAfterParseVarHead=function(){const e=(0,s.pushTypeContext)(0);(0,k.hasPrecedingLineBreak)()||(0,s.eat)(T.TokenType.bang);N(),(0,s.popTypeContext)(e)},n.tsStartParseAsyncArrowFromCallExpression=function(){(0,s.match)(T.TokenType.colon)&&X()},n.tsParseMaybeAssign=function(e,t){return p.isJSXEnabled?oe(e,t):ae(e,t)},n.tsParseMaybeAssignWithJSX=oe,n.tsParseMaybeAssignWithoutJSX=ae,n.tsParseArrow=function(){if((0,s.match)(T.TokenType.colon)){const e=p.state.snapshot();O(T.TokenType.colon),(0,k.canInsertSemicolon)()&&(0,k.unexpected)(),(0,s.match)(T.TokenType.arrow)||(0,k.unexpected)(),p.state.error&&p.state.restoreFromSnapshot(e)}return(0,s.eat)(T.TokenType.arrow)},n.tsParseAssignableListItemTypes=function(){const e=(0,s.pushTypeContext)(0);(0,s.eat)(T.TokenType.question),N(),(0,s.popTypeContext)(e)},n.tsParseMaybeDecoratorArguments=function(){((0,s.match)(T.TokenType.lessThan)||(0,s.match)(T.TokenType.bitShiftL))&&te();(0,y.baseParseMaybeDecoratorArguments)()};const s=e("bfb18d0576"),r=e("99ff836c64"),T=e("f0c35cbd76"),p=e("540718e523"),i=e("8178e7c3c8"),c=e("4cefc59e67"),y=e("e3b9989da1"),k=e("bc94bbadc1"),u=e("d7708a7d24");function l(){return(0,s.match)(T.TokenType.name)}function x(){const e=p.state.snapshot();(0,s.next)();return!!(((0,s.match)(T.TokenType.bracketL)||(0,s.match)(T.TokenType.braceL)||(0,s.match)(T.TokenType.star)||(0,s.match)(T.TokenType.ellipsis)||(0,s.match)(T.TokenType.hash)||(0,s.match)(T.TokenType.name)||Boolean(p.state.type&T.TokenType.IS_KEYWORD)||(0,s.match)(T.TokenType.string)||(0,s.match)(T.TokenType.num)||(0,s.match)(T.TokenType.bigint)||(0,s.match)(T.TokenType.decimal))&&!(0,k.hasPrecedingLineBreak)())||(p.state.restoreFromSnapshot(e),!1)}function h(e){for(;;){if(null===d(e))break}}function d(e){if(!(0,s.match)(T.TokenType.name))return null;const t=p.state.contextualKeyword;if(-1!==e.indexOf(t)&&x()){switch(t){case r.ContextualKeyword._readonly:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._readonly;break;case r.ContextualKeyword._abstract:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._abstract;break;case r.ContextualKeyword._static:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._static;break;case r.ContextualKeyword._public:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._public;break;case r.ContextualKeyword._private:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._private;break;case r.ContextualKeyword._protected:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._protected;break;case r.ContextualKeyword._override:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._override;break;case r.ContextualKeyword._declare:p.state.tokens[p.state.tokens.length-1].type=T.TokenType._declare}return t}return null}function m(){for((0,i.parseIdentifier)();(0,s.eat)(T.TokenType.dot);)(0,i.parseIdentifier)()}function f(){(0,k.expect)(T.TokenType._import),(0,k.expect)(T.TokenType.parenL),(0,k.expect)(T.TokenType.string),(0,k.expect)(T.TokenType.parenR),(0,s.eat)(T.TokenType.dot)&&m(),(0,s.match)(T.TokenType.lessThan)&&ne()}function C(){(0,s.eat)(T.TokenType._const);const e=(0,s.eat)(T.TokenType._in),t=(0,k.eatContextual)(r.ContextualKeyword._out);(0,s.eat)(T.TokenType._const),!e&&!t||(0,s.match)(T.TokenType.name)?(0,i.parseIdentifier)():p.state.tokens[p.state.tokens.length-1].type=T.TokenType.name,(0,s.eat)(T.TokenType._extends)&&J(),(0,s.eat)(T.TokenType.eq)&&J()}function _(){(0,s.match)(T.TokenType.lessThan)&&b()}function b(){const e=(0,s.pushTypeContext)(0);for((0,s.match)(T.TokenType.lessThan)||(0,s.match)(T.TokenType.typeParameterStart)?(0,s.next)():(0,k.unexpected)();!(0,s.eat)(T.TokenType.greaterThan)&&!p.state.error;)C(),(0,s.eat)(T.TokenType.comma);(0,s.popTypeContext)(e)}function w(e){const t=e===T.TokenType.arrow;var n;_(),(0,k.expect)(T.TokenType.parenL),p.state.scopeDepth++,n=!1,(0,c.parseBindingList)(T.TokenType.parenR,n),p.state.scopeDepth--,(t||(0,s.match)(e))&&O(e)}function g(){(0,s.eat)(T.TokenType.comma)||(0,k.semicolon)()}function K(){w(T.TokenType.colon),g()}function S(){if(!(0,s.match)(T.TokenType.bracketL)||!function(){const e=p.state.snapshot();(0,s.next)();const t=(0,s.eat)(T.TokenType.name)&&(0,s.match)(T.TokenType.colon);return p.state.restoreFromSnapshot(e),t}())return!1;const e=(0,s.pushTypeContext)(0);return(0,k.expect)(T.TokenType.bracketL),(0,i.parseIdentifier)(),X(),(0,k.expect)(T.TokenType.bracketR),N(),g(),(0,s.popTypeContext)(e),!0}function L(e){(0,s.eat)(T.TokenType.question),e||!(0,s.match)(T.TokenType.parenL)&&!(0,s.match)(T.TokenType.lessThan)?(N(),g()):(w(T.TokenType.colon),g())}function P(){if((0,s.match)(T.TokenType.parenL)||(0,s.match)(T.TokenType.lessThan))return void K();if((0,s.match)(T.TokenType._new))return(0,s.next)(),void((0,s.match)(T.TokenType.parenL)||(0,s.match)(T.TokenType.lessThan)?K():L(!1));const e=!!d([r.ContextualKeyword._readonly]);S()||(((0,k.isContextual)(r.ContextualKeyword._get)||(0,k.isContextual)(r.ContextualKeyword._set))&&x(),(0,i.parsePropertyName)(-1),L(e))}function I(){for((0,k.expect)(T.TokenType.braceL);!(0,s.eat)(T.TokenType.braceR)&&!p.state.error;)P()}function R(){const e=p.state.snapshot(),t=function(){if((0,s.next)(),(0,s.eat)(T.TokenType.plus)||(0,s.eat)(T.TokenType.minus))return(0,k.isContextual)(r.ContextualKeyword._readonly);(0,k.isContextual)(r.ContextualKeyword._readonly)&&(0,s.next)();if(!(0,s.match)(T.TokenType.bracketL))return!1;if((0,s.next)(),!l())return!1;return(0,s.next)(),(0,s.match)(T.TokenType._in)}();return p.state.restoreFromSnapshot(e),t}function A(){(0,k.expect)(T.TokenType.braceL),(0,s.match)(T.TokenType.plus)||(0,s.match)(T.TokenType.minus)?((0,s.next)(),(0,k.expectContextual)(r.ContextualKeyword._readonly)):(0,k.eatContextual)(r.ContextualKeyword._readonly),(0,k.expect)(T.TokenType.bracketL),(0,i.parseIdentifier)(),(0,k.expect)(T.TokenType._in),J(),(0,k.eatContextual)(r.ContextualKeyword._as)&&J(),(0,k.expect)(T.TokenType.bracketR),(0,s.match)(T.TokenType.plus)||(0,s.match)(T.TokenType.minus)?((0,s.next)(),(0,k.expect)(T.TokenType.question)):(0,s.eat)(T.TokenType.question),(0,s.eat)(T.TokenType.colon)&&J(),(0,k.semicolon)(),(0,k.expect)(T.TokenType.braceR)}function D(){(0,s.eat)(T.TokenType.ellipsis)?J():(J(),(0,s.eat)(T.TokenType.question)),(0,s.eat)(T.TokenType.colon)&&J()}var v;function B(e){e===v.TSAbstractConstructorType&&(0,k.expectContextual)(r.ContextualKeyword._abstract),e!==v.TSConstructorType&&e!==v.TSAbstractConstructorType||(0,k.expect)(T.TokenType._new);const t=p.state.inDisallowConditionalTypesContext;p.state.inDisallowConditionalTypesContext=!1,w(T.TokenType.arrow),p.state.inDisallowConditionalTypesContext=t}function F(){switch(p.state.type){case T.TokenType.name:return m(),void(!(0,k.hasPrecedingLineBreak)()&&(0,s.match)(T.TokenType.lessThan)&&ne());case T.TokenType._void:case T.TokenType._null:return void(0,s.next)();case T.TokenType.string:case T.TokenType.num:case T.TokenType.bigint:case T.TokenType.decimal:case T.TokenType._true:case T.TokenType._false:return void(0,i.parseLiteral)();case T.TokenType.minus:return(0,s.next)(),void(0,i.parseLiteral)();case T.TokenType._this:return(0,s.next)(),void((0,k.isContextual)(r.ContextualKeyword._is)&&!(0,k.hasPrecedingLineBreak)()&&((0,s.next)(),X()));case T.TokenType._typeof:return(0,k.expect)(T.TokenType._typeof),(0,s.match)(T.TokenType._import)?f():m(),void(!(0,k.hasPrecedingLineBreak)()&&(0,s.match)(T.TokenType.lessThan)&&ne());case T.TokenType._import:return void f();case T.TokenType.braceL:return void(R()?A():I());case T.TokenType.bracketL:return void function(){for((0,k.expect)(T.TokenType.bracketL);!(0,s.eat)(T.TokenType.bracketR)&&!p.state.error;)D(),(0,s.eat)(T.TokenType.comma)}();case T.TokenType.parenL:return(0,k.expect)(T.TokenType.parenL),J(),void(0,k.expect)(T.TokenType.parenR);case T.TokenType.backQuote:return void function(){for((0,s.nextTemplateToken)(),(0,s.nextTemplateToken)();!(0,s.match)(T.TokenType.backQuote)&&!p.state.error;)(0,k.expect)(T.TokenType.dollarBraceL),J(),(0,s.nextTemplateToken)(),(0,s.nextTemplateToken)();(0,s.next)()}();default:if(p.state.type&T.TokenType.IS_KEYWORD)return(0,s.next)(),void(p.state.tokens[p.state.tokens.length-1].type=T.TokenType.name)}(0,k.unexpected)()}function E(){if((0,k.isContextual)(r.ContextualKeyword._keyof)||(0,k.isContextual)(r.ContextualKeyword._unique)||(0,k.isContextual)(r.ContextualKeyword._readonly))(0,s.next)(),E();else if((0,k.isContextual)(r.ContextualKeyword._infer))!function(){if((0,k.expectContextual)(r.ContextualKeyword._infer),(0,i.parseIdentifier)(),(0,s.match)(T.TokenType._extends)){const e=p.state.snapshot();(0,k.expect)(T.TokenType._extends);const t=p.state.inDisallowConditionalTypesContext;p.state.inDisallowConditionalTypesContext=!0,J(),p.state.inDisallowConditionalTypesContext=t,(p.state.error||!p.state.inDisallowConditionalTypesContext&&(0,s.match)(T.TokenType.question))&&p.state.restoreFromSnapshot(e)}}();else{const e=p.state.inDisallowConditionalTypesContext;p.state.inDisallowConditionalTypesContext=!1,function(){for(F();!(0,k.hasPrecedingLineBreak)()&&(0,s.eat)(T.TokenType.bracketL);)(0,s.eat)(T.TokenType.bracketR)||(J(),(0,k.expect)(T.TokenType.bracketR))}(),p.state.inDisallowConditionalTypesContext=e}}function q(){if((0,s.eat)(T.TokenType.bitwiseAND),E(),(0,s.match)(T.TokenType.bitwiseAND))for(;(0,s.eat)(T.TokenType.bitwiseAND);)E()}function M(){return!!(0,s.match)(T.TokenType.lessThan)||(0,s.match)(T.TokenType.parenL)&&function(){const e=p.state.snapshot(),t=function(){if((0,s.next)(),(0,s.match)(T.TokenType.parenR)||(0,s.match)(T.TokenType.ellipsis))return!0;if(function(){if((0,s.match)(T.TokenType.name)||(0,s.match)(T.TokenType._this))return(0,s.next)(),!0;if((0,s.match)(T.TokenType.braceL)||(0,s.match)(T.TokenType.bracketL)){let e=1;for((0,s.next)();e>0&&!p.state.error;)(0,s.match)(T.TokenType.braceL)||(0,s.match)(T.TokenType.bracketL)?e++:((0,s.match)(T.TokenType.braceR)||(0,s.match)(T.TokenType.bracketR))&&e--,(0,s.next)();return!0}return!1}()){if((0,s.match)(T.TokenType.colon)||(0,s.match)(T.TokenType.comma)||(0,s.match)(T.TokenType.question)||(0,s.match)(T.TokenType.eq))return!0;if((0,s.match)(T.TokenType.parenR)&&((0,s.next)(),(0,s.match)(T.TokenType.arrow)))return!0}return!1}();return p.state.restoreFromSnapshot(e),t}()}function O(e){const t=(0,s.pushTypeContext)(0);(0,k.expect)(e);(function(){const e=p.state.snapshot();if((0,k.isContextual)(r.ContextualKeyword._asserts))return(0,s.next)(),(0,k.eatContextual)(r.ContextualKeyword._is)?(J(),!0):l()||(0,s.match)(T.TokenType._this)?((0,s.next)(),(0,k.eatContextual)(r.ContextualKeyword._is)&&J(),!0):(p.state.restoreFromSnapshot(e),!1);if(l()||(0,s.match)(T.TokenType._this))return(0,s.next)(),(0,k.isContextual)(r.ContextualKeyword._is)&&!(0,k.hasPrecedingLineBreak)()?((0,s.next)(),J(),!0):(p.state.restoreFromSnapshot(e),!1);return!1})()||J(),(0,s.popTypeContext)(t)}function N(){(0,s.match)(T.TokenType.colon)&&X()}function X(){const e=(0,s.pushTypeContext)(0);(0,k.expect)(T.TokenType.colon),J(),(0,s.popTypeContext)(e)}function J(){if(W(),p.state.inDisallowConditionalTypesContext||(0,k.hasPrecedingLineBreak)()||!(0,s.eat)(T.TokenType._extends))return;const e=p.state.inDisallowConditionalTypesContext;p.state.inDisallowConditionalTypesContext=!0,W(),p.state.inDisallowConditionalTypesContext=e,(0,k.expect)(T.TokenType.question),J(),(0,k.expect)(T.TokenType.colon),J()}function W(){M()?B(v.TSFunctionType):(0,s.match)(T.TokenType._new)?B(v.TSConstructorType):(0,k.isContextual)(r.ContextualKeyword._abstract)&&(0,s.lookaheadType)()===T.TokenType._new?B(v.TSAbstractConstructorType):function(){if((0,s.eat)(T.TokenType.bitwiseOR),q(),(0,s.match)(T.TokenType.bitwiseOR))for(;(0,s.eat)(T.TokenType.bitwiseOR);)q()}()}function Q(){for(;!(0,s.match)(T.TokenType.braceL)&&!p.state.error;)V(),(0,s.eat)(T.TokenType.comma)}function V(){m(),(0,s.match)(T.TokenType.lessThan)&&ne()}function j(){if((0,s.match)(T.TokenType.string)?(0,i.parseLiteral)():(0,i.parseIdentifier)(),(0,s.eat)(T.TokenType.eq)){const e=p.state.tokens.length-1;(0,i.parseMaybeAssign)(),p.state.tokens[e].rhsEndIndex=p.state.tokens.length}}function Y(){for((0,c.parseBindingIdentifier)(!1),(0,k.expect)(T.TokenType.braceL);!(0,s.eat)(T.TokenType.braceR)&&!p.state.error;)j(),(0,s.eat)(T.TokenType.comma)}function H(){(0,k.expect)(T.TokenType.braceL),(0,y.parseBlockBody)(T.TokenType.braceR)}function U(){(0,c.parseBindingIdentifier)(!1),(0,s.eat)(T.TokenType.dot)?U():H()}function z(){(0,k.isContextual)(r.ContextualKeyword._global)?(0,i.parseIdentifier)():(0,s.match)(T.TokenType.string)?(0,i.parseExprAtom)():(0,k.unexpected)(),(0,s.match)(T.TokenType.braceL)?H():(0,k.semicolon)()}function G(){(0,c.parseImportedIdentifier)(),(0,k.expect)(T.TokenType.eq),(0,k.isContextual)(r.ContextualKeyword._require)&&(0,s.lookaheadType)()===T.TokenType.parenL?((0,k.expectContextual)(r.ContextualKeyword._require),(0,k.expect)(T.TokenType.parenL),(0,s.match)(T.TokenType.string)||(0,k.unexpected)(),(0,i.parseLiteral)(),(0,k.expect)(T.TokenType.parenR)):m(),(0,k.semicolon)()}function Z(){return $(p.state.contextualKeyword,!0)}function $(e,t){switch(e){case r.ContextualKeyword._abstract:if(ee(t)&&(0,s.match)(T.TokenType._class))return p.state.tokens[p.state.tokens.length-1].type=T.TokenType._abstract,(0,y.parseClass)(!0,!1),!0;break;case r.ContextualKeyword._enum:if(ee(t)&&(0,s.match)(T.TokenType.name))return p.state.tokens[p.state.tokens.length-1].type=T.TokenType._enum,Y(),!0;break;case r.ContextualKeyword._interface:if(ee(t)&&(0,s.match)(T.TokenType.name)){const e=(0,s.pushTypeContext)(t?2:1);return(0,c.parseBindingIdentifier)(!1),_(),(0,s.eat)(T.TokenType._extends)&&Q(),I(),(0,s.popTypeContext)(e),!0}break;case r.ContextualKeyword._module:if(ee(t)){if((0,s.match)(T.TokenType.string)){const e=(0,s.pushTypeContext)(t?2:1);return z(),(0,s.popTypeContext)(e),!0}if((0,s.match)(T.TokenType.name)){const e=(0,s.pushTypeContext)(t?2:1);return U(),(0,s.popTypeContext)(e),!0}}break;case r.ContextualKeyword._namespace:if(ee(t)&&(0,s.match)(T.TokenType.name)){const e=(0,s.pushTypeContext)(t?2:1);return U(),(0,s.popTypeContext)(e),!0}break;case r.ContextualKeyword._type:if(ee(t)&&(0,s.match)(T.TokenType.name)){const e=(0,s.pushTypeContext)(t?2:1);return(0,c.parseBindingIdentifier)(!1),_(),(0,k.expect)(T.TokenType.eq),J(),(0,k.semicolon)(),(0,s.popTypeContext)(e),!0}}return!1}function ee(e){return e?((0,s.next)(),!0):!(0,k.isLineTerminator)()}function te(){p.state.type===T.TokenType.bitShiftL&&(p.state.pos-=1,(0,s.finishToken)(T.TokenType.lessThan)),ne()}function ne(){const e=(0,s.pushTypeContext)(0);for((0,k.expect)(T.TokenType.lessThan);!(0,s.match)(T.TokenType.greaterThan)&&!p.state.error;)J(),(0,s.eat)(T.TokenType.comma);e?((0,k.expect)(T.TokenType.greaterThan),(0,s.popTypeContext)(e)):((0,s.popTypeContext)(e),(0,s.rescan_gt)(),(0,k.expect)(T.TokenType.greaterThan),p.state.tokens[p.state.tokens.length-1].isType=!0)}function oe(e,t){if(!(0,s.match)(T.TokenType.lessThan))return(0,i.baseParseMaybeAssign)(e,t);const n=p.state.snapshot();let o=(0,i.baseParseMaybeAssign)(e,t);return p.state.error?(p.state.restoreFromSnapshot(n),p.state.type=T.TokenType.typeParameterStart,b(),o=(0,i.baseParseMaybeAssign)(e,t),o||(0,k.unexpected)(),o):o}function ae(e,t){if(!(0,s.match)(T.TokenType.lessThan))return(0,i.baseParseMaybeAssign)(e,t);const n=p.state.snapshot();b();const o=(0,i.baseParseMaybeAssign)(e,t);return o||(0,k.unexpected)(),p.state.error?(p.state.restoreFromSnapshot(n),(0,i.baseParseMaybeAssign)(e,t)):o}!function(e){e[e.TSFunctionType=0]="TSFunctionType";e[e.TSConstructorType=1]="TSConstructorType";e[e.TSAbstractConstructorType=2]="TSAbstractConstructorType"}(v||(v={}))},
"4cefc59e67": function _(e,t,n,o,s){o(),n.parseSpread=function(){(0,r.next)(),(0,l.parseMaybeAssign)(!1)},n.parseRest=T,n.parseBindingIdentifier=k,n.parseImportedIdentifier=function(){(0,l.parseIdentifier)(),d.state.tokens[d.state.tokens.length-1].identifierRole=r.IdentifierRole.ImportDeclaration},n.markPriorBindingIdentifier=y,n.parseBindingAtom=u,n.parseBindingList=b,n.parseMaybeDefault=g;const a=e("9b8d43cd0a"),i=e("6a970c22b9"),r=e("bfb18d0576"),c=e("99ff836c64"),p=e("f0c35cbd76"),d=e("540718e523"),l=e("8178e7c3c8"),f=e("bc94bbadc1");function T(e){(0,r.next)(),u(e)}function k(e){(0,l.parseIdentifier)(),y(e)}function y(e){let t;t=0===d.state.scopeDepth?r.IdentifierRole.TopLevelDeclaration:e?r.IdentifierRole.BlockScopedDeclaration:r.IdentifierRole.FunctionScopedDeclaration,d.state.tokens[d.state.tokens.length-1].identifierRole=t}function u(e){switch(d.state.type){case p.TokenType._this:{const e=(0,r.pushTypeContext)(0);return(0,r.next)(),void(0,r.popTypeContext)(e)}case p.TokenType._yield:case p.TokenType.name:return d.state.type=p.TokenType.name,void k(e);case p.TokenType.bracketL:return(0,r.next)(),void b(p.TokenType.bracketR,e,!0);case p.TokenType.braceL:return void(0,l.parseObj)(!0,e);default:(0,f.unexpected)()}}function b(e,t,n=!1,o=!1,s=0){let a=!0,i=!1;const c=d.state.tokens.length;for(;!(0,r.eat)(e)&&!d.state.error;)if(a?a=!1:((0,f.expect)(p.TokenType.comma),d.state.tokens[d.state.tokens.length-1].contextId=s,!i&&d.state.tokens[c].isType&&(d.state.tokens[d.state.tokens.length-1].isType=!0,i=!0)),n&&(0,r.match)(p.TokenType.comma));else{if((0,r.eat)(e))break;if((0,r.match)(p.TokenType.ellipsis)){T(t),x(),(0,r.eat)(p.TokenType.comma),(0,f.expect)(e);break}m(o,t)}}function m(e,t){e&&(0,i.tsParseModifiers)([c.ContextualKeyword._public,c.ContextualKeyword._protected,c.ContextualKeyword._private,c.ContextualKeyword._readonly,c.ContextualKeyword._override]),g(t),x(),g(t,!0)}function x(){d.isFlowEnabled?(0,a.flowParseAssignableListItemTypes)():d.isTypeScriptEnabled&&(0,i.tsParseAssignableListItemTypes)()}function g(e,t=!1){if(t||u(e),!(0,r.eat)(p.TokenType.eq))return;const n=d.state.tokens.length-1;(0,l.parseMaybeAssign)(),d.state.tokens[n].rhsEndIndex=d.state.tokens.length}},
"85c51351f6": function _(e,n,o,a,t){a(),o.typedParseConditional=function(e){if((0,T.match)(c.TokenType.question)){const e=(0,T.lookaheadType)();if(e===c.TokenType.colon||e===c.TokenType.comma||e===c.TokenType.parenR)return}(0,p.baseParseConditional)(e)},o.typedParseParenItem=function(){(0,T.eatTypeToken)(c.TokenType.question),(0,T.match)(c.TokenType.colon)&&(i.isTypeScriptEnabled?(0,y.tsParseTypeAnnotation)():i.isFlowEnabled&&(0,s.flowParseTypeAnnotation)())};const T=e("bfb18d0576"),c=e("f0c35cbd76"),i=e("540718e523"),p=e("8178e7c3c8"),s=e("9b8d43cd0a"),y=e("6a970c22b9")},
"1c7cc5e988": function _(e,t,s,n,i){n();const o=e("tslib"),h=e("f0c35cbd76"),r=o.__importDefault(e("3e31f9f9c3"));class d{__init(){this.resultCode=""}__init2(){this.resultMappings=new Array(this.tokens.length)}__init3(){this.tokenIndex=0}constructor(e,t,s,n,i){this.code=e,this.tokens=t,this.isFlowEnabled=s,this.disableESTransforms=n,this.helperManager=i,d.prototype.__init.call(this),d.prototype.__init2.call(this),d.prototype.__init3.call(this)}snapshot(){return{resultCode:this.resultCode,tokenIndex:this.tokenIndex}}restoreToSnapshot(e){this.resultCode=e.resultCode,this.tokenIndex=e.tokenIndex}dangerouslyGetAndRemoveCodeSinceSnapshot(e){const t=this.resultCode.slice(e.resultCode.length);return this.resultCode=e.resultCode,t}reset(){this.resultCode="",this.resultMappings=new Array(this.tokens.length),this.tokenIndex=0}matchesContextualAtIndex(e,t){return this.matches1AtIndex(e,h.TokenType.name)&&this.tokens[e].contextualKeyword===t}identifierNameAtIndex(e){return this.identifierNameForToken(this.tokens[e])}identifierNameAtRelativeIndex(e){return this.identifierNameForToken(this.tokenAtRelativeIndex(e))}identifierName(){return this.identifierNameForToken(this.currentToken())}identifierNameForToken(e){return this.code.slice(e.start,e.end)}rawCodeForToken(e){return this.code.slice(e.start,e.end)}stringValueAtIndex(e){return this.stringValueForToken(this.tokens[e])}stringValue(){return this.stringValueForToken(this.currentToken())}stringValueForToken(e){return this.code.slice(e.start+1,e.end-1)}matches1AtIndex(e,t){return this.tokens[e].type===t}matches2AtIndex(e,t,s){return this.tokens[e].type===t&&this.tokens[e+1].type===s}matches3AtIndex(e,t,s,n){return this.tokens[e].type===t&&this.tokens[e+1].type===s&&this.tokens[e+2].type===n}matches1(e){return this.tokens[this.tokenIndex].type===e}matches2(e,t){return this.tokens[this.tokenIndex].type===e&&this.tokens[this.tokenIndex+1].type===t}matches3(e,t,s){return this.tokens[this.tokenIndex].type===e&&this.tokens[this.tokenIndex+1].type===t&&this.tokens[this.tokenIndex+2].type===s}matches4(e,t,s,n){return this.tokens[this.tokenIndex].type===e&&this.tokens[this.tokenIndex+1].type===t&&this.tokens[this.tokenIndex+2].type===s&&this.tokens[this.tokenIndex+3].type===n}matches5(e,t,s,n,i){return this.tokens[this.tokenIndex].type===e&&this.tokens[this.tokenIndex+1].type===t&&this.tokens[this.tokenIndex+2].type===s&&this.tokens[this.tokenIndex+3].type===n&&this.tokens[this.tokenIndex+4].type===i}matchesContextual(e){return this.matchesContextualAtIndex(this.tokenIndex,e)}matchesContextIdAndLabel(e,t){return this.matches1(e)&&this.currentToken().contextId===t}previousWhitespaceAndComments(){let e=this.code.slice(this.tokenIndex>0?this.tokens[this.tokenIndex-1].end:0,this.tokenIndex<this.tokens.length?this.tokens[this.tokenIndex].start:this.code.length);return this.isFlowEnabled&&(e=e.replace(/@flow/g,"")),e}replaceToken(e){this.resultCode+=this.previousWhitespaceAndComments(),this.appendTokenPrefix(),this.resultMappings[this.tokenIndex]=this.resultCode.length,this.resultCode+=e,this.appendTokenSuffix(),this.tokenIndex++}replaceTokenTrimmingLeftWhitespace(e){this.resultCode+=this.previousWhitespaceAndComments().replace(/[^\r\n]/g,""),this.appendTokenPrefix(),this.resultMappings[this.tokenIndex]=this.resultCode.length,this.resultCode+=e,this.appendTokenSuffix(),this.tokenIndex++}removeInitialToken(){this.replaceToken("")}removeToken(){this.replaceTokenTrimmingLeftWhitespace("")}removeBalancedCode(){let e=0;for(;!this.isAtEnd();){if(this.matches1(h.TokenType.braceL))e++;else if(this.matches1(h.TokenType.braceR)){if(0===e)return;e--}this.removeToken()}}copyExpectedToken(e){if(this.tokens[this.tokenIndex].type!==e)throw new Error(`Expected token ${e}`);this.copyToken()}copyToken(){this.resultCode+=this.previousWhitespaceAndComments(),this.appendTokenPrefix(),this.resultMappings[this.tokenIndex]=this.resultCode.length,this.resultCode+=this.code.slice(this.tokens[this.tokenIndex].start,this.tokens[this.tokenIndex].end),this.appendTokenSuffix(),this.tokenIndex++}copyTokenWithPrefix(e){this.resultCode+=this.previousWhitespaceAndComments(),this.appendTokenPrefix(),this.resultCode+=e,this.resultMappings[this.tokenIndex]=this.resultCode.length,this.resultCode+=this.code.slice(this.tokens[this.tokenIndex].start,this.tokens[this.tokenIndex].end),this.appendTokenSuffix(),this.tokenIndex++}appendTokenPrefix(){const e=this.currentToken();if((e.numNullishCoalesceStarts||e.isOptionalChainStart)&&(e.isAsyncOperation=(0,r.default)(this)),!this.disableESTransforms){if(e.numNullishCoalesceStarts)for(let t=0;t<e.numNullishCoalesceStarts;t++)e.isAsyncOperation?(this.resultCode+="await ",this.resultCode+=this.helperManager.getHelperName("asyncNullishCoalesce")):this.resultCode+=this.helperManager.getHelperName("nullishCoalesce"),this.resultCode+="(";e.isOptionalChainStart&&(e.isAsyncOperation&&(this.resultCode+="await "),this.tokenIndex>0&&this.tokenAtRelativeIndex(-1).type===h.TokenType._delete?e.isAsyncOperation?this.resultCode+=this.helperManager.getHelperName("asyncOptionalChainDelete"):this.resultCode+=this.helperManager.getHelperName("optionalChainDelete"):e.isAsyncOperation?this.resultCode+=this.helperManager.getHelperName("asyncOptionalChain"):this.resultCode+=this.helperManager.getHelperName("optionalChain"),this.resultCode+="([")}}appendTokenSuffix(){const e=this.currentToken();if(e.isOptionalChainEnd&&!this.disableESTransforms&&(this.resultCode+="])"),e.numNullishCoalesceEnds&&!this.disableESTransforms)for(let t=0;t<e.numNullishCoalesceEnds;t++)this.resultCode+="))"}appendCode(e){this.resultCode+=e}currentToken(){return this.tokens[this.tokenIndex]}currentTokenCode(){const e=this.currentToken();return this.code.slice(e.start,e.end)}tokenAtRelativeIndex(e){return this.tokens[this.tokenIndex+e]}currentIndex(){return this.tokenIndex}nextToken(){if(this.tokenIndex===this.tokens.length)throw new Error("Unexpectedly reached end of input.");this.tokenIndex++}previousToken(){this.tokenIndex--}finish(){if(this.tokenIndex!==this.tokens.length)throw new Error("Tried to finish processing tokens before reaching the end.");return this.resultCode+=this.previousWhitespaceAndComments(),{code:this.resultCode,mappings:this.resultMappings}}isAtEnd(){return this.tokenIndex===this.tokens.length}}s.default=d},
"3e31f9f9c3": function _(n,t,e,o,l){o(),e.default=function(n){let t=n.currentIndex(),e=0;const o=n.currentToken();do{const l=n.tokens[t];if(l.isOptionalChainStart&&e++,l.isOptionalChainEnd&&e--,e+=l.numNullishCoalesceStarts,e-=l.numNullishCoalesceEnds,l.contextualKeyword===i.ContextualKeyword._await&&null==l.identifierRole&&l.scopeDepth===o.scopeDepth)return!0;t+=1}while(e>0&&t<n.tokens.length);return!1};const i=n("99ff836c64")},
"131f5202c7": function _(e,t,s,n,o){n();const r=e("tslib"),i=e("99ff836c64"),a=e("f0c35cbd76"),h=r.__importDefault(e("6aa22e0eb8")),c=r.__importDefault(e("268dc8808b")),l=r.__importDefault(e("8db2e4c5d7")),p=r.__importDefault(e("3913cc12b3")),d=r.__importDefault(e("3eb46b07e3")),k=r.__importDefault(e("a0e577c292")),f=r.__importDefault(e("09e20c28d7")),m=r.__importDefault(e("1dc037e3ca")),u=r.__importDefault(e("6995ead426")),T=r.__importDefault(e("9aad52e886")),y=r.__importDefault(e("c3f855a290")),g=r.__importDefault(e("581b1c506a"));class I{__init(){this.transformers=[]}__init2(){this.generatedVariables=[]}constructor(e,t,s,n){I.prototype.__init.call(this),I.prototype.__init2.call(this),this.nameManager=e.nameManager,this.helperManager=e.helperManager;const{tokenProcessor:o,importProcessor:r}=e;this.tokens=o,this.isImportsTransformEnabled=t.includes("imports"),this.isReactHotLoaderTransformEnabled=t.includes("react-hot-loader"),this.disableESTransforms=Boolean(n.disableESTransforms),n.disableESTransforms||(this.transformers.push(new u.default(o,this.nameManager)),this.transformers.push(new f.default(o)),this.transformers.push(new m.default(o,this.nameManager))),t.includes("jsx")&&("preserve"!==n.jsxRuntime&&this.transformers.push(new k.default(this,o,r,this.nameManager,n)),this.transformers.push(new T.default(this,o,r,n)));let i=null;if(t.includes("react-hot-loader")){if(!n.filePath)throw new Error("filePath is required when using the react-hot-loader transform.");i=new y.default(o,n.filePath),this.transformers.push(i)}if(t.includes("imports")){if(null===r)throw new Error("Expected non-null importProcessor with imports transform enabled.");this.transformers.push(new c.default(this,o,r,this.nameManager,this.helperManager,i,s,Boolean(n.enableLegacyTypeScriptModuleInterop),t.includes("typescript"),t.includes("flow"),Boolean(n.preserveDynamicImport),Boolean(n.keepUnusedImports)))}else this.transformers.push(new l.default(o,this.nameManager,this.helperManager,i,t.includes("typescript"),t.includes("flow"),Boolean(n.keepUnusedImports),n));t.includes("flow")&&this.transformers.push(new p.default(this,o,t.includes("imports"))),t.includes("typescript")&&this.transformers.push(new g.default(this,o,t.includes("imports"))),t.includes("jest")&&this.transformers.push(new d.default(this,o,this.nameManager,r))}transform(){this.tokens.reset(),this.processBalancedCode();let e=this.isImportsTransformEnabled?'"use strict";':"";for(const t of this.transformers)e+=t.getPrefixCode();e+=this.helperManager.emitHelpers(),e+=this.generatedVariables.map((e=>` var ${e};`)).join("");for(const t of this.transformers)e+=t.getHoistedCode();let t="";for(const e of this.transformers)t+=e.getSuffixCode();const s=this.tokens.finish();let{code:n}=s;if(n.startsWith("#!")){let o=n.indexOf("\n");return-1===o&&(o=n.length,n+="\n"),{code:n.slice(0,o+1)+e+n.slice(o+1)+t,mappings:this.shiftMappings(s.mappings,e.length)}}return{code:e+n+t,mappings:this.shiftMappings(s.mappings,e.length)}}processBalancedCode(){let e=0,t=0;for(;!this.tokens.isAtEnd();){if(this.tokens.matches1(a.TokenType.braceL)||this.tokens.matches1(a.TokenType.dollarBraceL))e++;else if(this.tokens.matches1(a.TokenType.braceR)){if(0===e)return;e--}if(this.tokens.matches1(a.TokenType.parenL))t++;else if(this.tokens.matches1(a.TokenType.parenR)){if(0===t)return;t--}this.processToken()}}processToken(){if(this.tokens.matches1(a.TokenType._class))this.processClass();else{for(const e of this.transformers){if(e.process())return}this.tokens.copyToken()}}processNamedClass(){if(!this.tokens.matches2(a.TokenType._class,a.TokenType.name))throw new Error("Expected identifier for exported class name.");const e=this.tokens.identifierNameAtIndex(this.tokens.currentIndex()+1);return this.processClass(),e}processClass(){const e=(0,h.default)(this,this.tokens,this.nameManager,this.disableESTransforms),t=(e.headerInfo.isExpression||!e.headerInfo.className)&&e.staticInitializerNames.length+e.instanceInitializerNames.length>0;let s=e.headerInfo.className;t&&(s=this.nameManager.claimFreeName("_class"),this.generatedVariables.push(s),this.tokens.appendCode(` (${s} =`));const n=this.tokens.currentToken().contextId;if(null==n)throw new Error("Expected class to have a context ID.");for(this.tokens.copyExpectedToken(a.TokenType._class);!this.tokens.matchesContextIdAndLabel(a.TokenType.braceL,n);)this.processToken();this.processClassBody(e,s);const o=e.staticInitializerNames.map((e=>`${s}.${e}()`));t?this.tokens.appendCode(`, ${o.map((e=>`${e}, `)).join("")}${s})`):e.staticInitializerNames.length>0&&this.tokens.appendCode(` ${o.map((e=>`${e};`)).join(" ")}`)}processClassBody(e,t){const{headerInfo:s,constructorInsertPos:n,constructorInitializerStatements:o,fields:r,instanceInitializerNames:i,rangesToRemove:h}=e;let c=0,l=0;const p=this.tokens.currentToken().contextId;if(null==p)throw new Error("Expected non-null context ID on class.");this.tokens.copyExpectedToken(a.TokenType.braceL),this.isReactHotLoaderTransformEnabled&&this.tokens.appendCode("__reactstandin__regenerateByEval(key, code) {this[key] = eval(code);}");const d=o.length+i.length>0;if(null===n&&d){const e=this.makeConstructorInitCode(o,i,t);if(s.hasSuperclass){const t=this.nameManager.claimFreeName("args");this.tokens.appendCode(`constructor(...${t}) { super(...${t}); ${e}; }`)}else this.tokens.appendCode(`constructor() { ${e}; }`)}for(;!this.tokens.matchesContextIdAndLabel(a.TokenType.braceR,p);)if(c<r.length&&this.tokens.currentIndex()===r[c].start){let e=!1;for(this.tokens.matches1(a.TokenType.bracketL)?this.tokens.copyTokenWithPrefix(`${r[c].initializerName}() {this`):this.tokens.matches1(a.TokenType.string)||this.tokens.matches1(a.TokenType.num)?(this.tokens.copyTokenWithPrefix(`${r[c].initializerName}() {this[`),e=!0):this.tokens.copyTokenWithPrefix(`${r[c].initializerName}() {this.`);this.tokens.currentIndex()<r[c].end;)e&&this.tokens.currentIndex()===r[c].equalsIndex&&this.tokens.appendCode("]"),this.processToken();this.tokens.appendCode("}"),c++}else if(l<h.length&&this.tokens.currentIndex()>=h[l].start){for(this.tokens.currentIndex()<h[l].end&&this.tokens.removeInitialToken();this.tokens.currentIndex()<h[l].end;)this.tokens.removeToken();l++}else this.tokens.currentIndex()===n?(this.tokens.copyToken(),d&&this.tokens.appendCode(`;${this.makeConstructorInitCode(o,i,t)};`),this.processToken()):this.processToken();this.tokens.copyExpectedToken(a.TokenType.braceR)}makeConstructorInitCode(e,t,s){return[...e,...t.map((e=>`${s}.prototype.${e}.call(this)`))].join(";")}processPossibleArrowParamEnd(){if(this.tokens.matches2(a.TokenType.parenR,a.TokenType.colon)&&this.tokens.tokenAtRelativeIndex(1).isType){let e=this.tokens.currentIndex()+1;for(;this.tokens.tokens[e].isType;)e++;if(this.tokens.matches1AtIndex(e,a.TokenType.arrow)){for(this.tokens.removeInitialToken();this.tokens.currentIndex()<e;)this.tokens.removeToken();return this.tokens.replaceTokenTrimmingLeftWhitespace(") =>"),!0}}return!1}processPossibleAsyncArrowWithTypeParams(){if(!this.tokens.matchesContextual(i.ContextualKeyword._async)&&!this.tokens.matches1(a.TokenType._async))return!1;const e=this.tokens.tokenAtRelativeIndex(1);if(e.type!==a.TokenType.lessThan||!e.isType)return!1;let t=this.tokens.currentIndex()+1;for(;this.tokens.tokens[t].isType;)t++;if(this.tokens.matches1AtIndex(t,a.TokenType.parenL)){for(this.tokens.replaceToken("async ("),this.tokens.removeInitialToken();this.tokens.currentIndex()<t;)this.tokens.removeToken();return this.tokens.removeToken(),this.processBalancedCode(),this.processToken(),!0}return!1}processPossibleTypeRange(){if(this.tokens.currentToken().isType){for(this.tokens.removeInitialToken();this.tokens.currentToken().isType;)this.tokens.removeToken();return!0}return!1}shiftMappings(e,t){for(let s=0;s<e.length;s++){const n=e[s];void 0!==n&&(e[s]=n+t)}return e}}s.default=I},
"6aa22e0eb8": function _(e,n,t,o,r){o(),t.default=function(e,n,t,o){const r=n.snapshot(),k=function(e){const n=e.currentToken(),t=n.contextId;if(null==t)throw new Error("Expected context ID on class token.");const o=n.isExpression;if(null==o)throw new Error("Expected isExpression on class token.");let r=null,c=!1;e.nextToken(),e.matches1(s.TokenType.name)&&(r=e.identifierName());for(;!e.matchesContextIdAndLabel(s.TokenType.braceL,t);)e.matches1(s.TokenType._extends)&&!e.currentToken().isType&&(c=!0),e.nextToken();return{isExpression:o,className:r,hasSuperclass:c}}(n);let p=[];const l=[],x=[];let d=null;const f=[],h=[],m=n.currentToken().contextId;if(null==m)throw new Error("Expected non-null class context ID on class open-brace.");n.nextToken();for(;!n.matchesContextIdAndLabel(s.TokenType.braceR,m);)if(n.matchesContextual(c.ContextualKeyword._constructor)&&!n.currentToken().isType)({constructorInitializerStatements:p,constructorInsertPos:d}=a(n));else if(n.matches1(s.TokenType.semi))o||h.push({start:n.currentIndex(),end:n.currentIndex()+1}),n.nextToken();else if(n.currentToken().isType)n.nextToken();else{const r=n.currentIndex();let k=!1,y=!1,I=!1;for(;i(n.currentToken());)n.matches1(s.TokenType._static)&&(k=!0),n.matches1(s.TokenType.hash)&&(y=!0),(n.matches1(s.TokenType._declare)||n.matches1(s.TokenType._abstract))&&(I=!0),n.nextToken();if(k&&n.matches1(s.TokenType.braceL)){T(n,m);continue}if(y){T(n,m);continue}if(n.matchesContextual(c.ContextualKeyword._constructor)&&!n.currentToken().isType){({constructorInitializerStatements:p,constructorInsertPos:d}=a(n));continue}const _=n.currentIndex();if(u(n),n.matches1(s.TokenType.lessThan)||n.matches1(s.TokenType.parenL)){T(n,m);continue}for(;n.currentToken().isType;)n.nextToken();if(n.matches1(s.TokenType.eq)){const o=n.currentIndex(),r=n.currentToken().rhsEndIndex;if(null==r)throw new Error("Expected rhsEndIndex on class field assignment.");for(n.nextToken();n.currentIndex()<r;)e.processToken();let c;k?(c=t.claimFreeName("__initStatic"),x.push(c)):(c=t.claimFreeName("__init"),l.push(c)),f.push({initializerName:c,equalsIndex:o,start:_,end:n.currentIndex()})}else o&&!I||h.push({start:r,end:n.currentIndex()})}return n.restoreToSnapshot(r),o?{headerInfo:k,constructorInitializerStatements:p,instanceInitializerNames:[],staticInitializerNames:[],constructorInsertPos:d,fields:[],rangesToRemove:h}:{headerInfo:k,constructorInitializerStatements:p,instanceInitializerNames:l,staticInitializerNames:x,constructorInsertPos:d,fields:f,rangesToRemove:h}};const c=e("99ff836c64"),s=e("f0c35cbd76");function T(e,n){for(e.nextToken();e.currentToken().contextId!==n;)e.nextToken();for(;i(e.tokenAtRelativeIndex(-1));)e.previousToken()}function a(e){const n=[];e.nextToken();const t=e.currentToken().contextId;if(null==t)throw new Error("Expected context ID on open-paren starting constructor params.");for(;!e.matchesContextIdAndLabel(s.TokenType.parenR,t);)if(e.currentToken().contextId===t){if(e.nextToken(),i(e.currentToken())){for(e.nextToken();i(e.currentToken());)e.nextToken();const t=e.currentToken();if(t.type!==s.TokenType.name)throw new Error("Expected identifier after access modifiers in constructor arg.");const o=e.identifierNameForToken(t);n.push(`this.${o} = ${o}`)}}else e.nextToken();for(e.nextToken();e.currentToken().isType;)e.nextToken();let o=e.currentIndex(),r=!1;for(;!e.matchesContextIdAndLabel(s.TokenType.braceR,t);){if(!r&&e.matches2(s.TokenType._super,s.TokenType.parenL)){e.nextToken();const n=e.currentToken().contextId;if(null==n)throw new Error("Expected a context ID on the super call");for(;!e.matchesContextIdAndLabel(s.TokenType.parenR,n);)e.nextToken();o=e.currentIndex(),r=!0}e.nextToken()}return e.nextToken(),{constructorInitializerStatements:n,constructorInsertPos:o}}function i(e){return[s.TokenType._async,s.TokenType._get,s.TokenType._set,s.TokenType.plus,s.TokenType.minus,s.TokenType._readonly,s.TokenType._static,s.TokenType._public,s.TokenType._private,s.TokenType._protected,s.TokenType._override,s.TokenType._abstract,s.TokenType.star,s.TokenType._declare,s.TokenType.hash].includes(e.type)}function u(e){if(e.matches1(s.TokenType.bracketL)){const n=e.currentToken().contextId;if(null==n)throw new Error("Expected class context ID on computed name open bracket.");for(;!e.matchesContextIdAndLabel(s.TokenType.bracketR,n);)e.nextToken();e.nextToken()}else e.nextToken()}},
"268dc8808b": function _(e,t,o,s,n){s();const r=e("tslib"),i=e("bfb18d0576"),k=e("99ff836c64"),p=e("f0c35cbd76"),h=r.__importDefault(e("a5f4e01d7b")),a=r.__importStar(e("f1b0dcccab")),T=r.__importDefault(e("14d4ae78a4")),c=r.__importDefault(e("c3c484c8b2")),m=e("f659e3ed39"),d=r.__importDefault(e("11afb90ac4")),y=r.__importDefault(e("a46f119f74"));class l extends y.default{__init(){this.hadExport=!1}__init2(){this.hadNamedExport=!1}__init3(){this.hadDefaultExport=!1}constructor(e,t,o,s,n,r,i,k,p,h,T,c){super(),this.rootTransformer=e,this.tokens=t,this.importProcessor=o,this.nameManager=s,this.helperManager=n,this.reactHotLoaderTransformer=r,this.enableLegacyBabel5ModuleInterop=i,this.enableLegacyTypeScriptModuleInterop=k,this.isTypeScriptTransformEnabled=p,this.isFlowTransformEnabled=h,this.preserveDynamicImport=T,this.keepUnusedImports=c,l.prototype.__init.call(this),l.prototype.__init2.call(this),l.prototype.__init3.call(this),this.declarationInfo=p?(0,a.default)(t):a.EMPTY_DECLARATION_INFO}getPrefixCode(){let e="";return this.hadExport&&(e+='Object.defineProperty(exports, "__esModule", {value: true});'),e}getSuffixCode(){return this.enableLegacyBabel5ModuleInterop&&this.hadDefaultExport&&!this.hadNamedExport?"\nmodule.exports = exports.default;\n":""}process(){return this.tokens.matches3(p.TokenType._import,p.TokenType.name,p.TokenType.eq)?this.processImportEquals():this.tokens.matches1(p.TokenType._import)?(this.processImport(),!0):this.tokens.matches2(p.TokenType._export,p.TokenType.eq)?(this.tokens.replaceToken("module.exports"),!0):this.tokens.matches1(p.TokenType._export)&&!this.tokens.currentToken().isType?(this.hadExport=!0,this.processExport()):!(!this.tokens.matches2(p.TokenType.name,p.TokenType.postIncDec)||!this.processPostIncDec())||(this.tokens.matches1(p.TokenType.name)||this.tokens.matches1(p.TokenType.jsxName)?this.processIdentifier():this.tokens.matches1(p.TokenType.eq)?this.processAssignment():this.tokens.matches1(p.TokenType.assign)?this.processComplexAssignment():!!this.tokens.matches1(p.TokenType.preIncDec)&&this.processPreIncDec())}processImportEquals(){const e=this.tokens.identifierNameAtIndex(this.tokens.currentIndex()+1);return this.importProcessor.shouldAutomaticallyElideImportedName(e)?(0,h.default)(this.tokens):this.tokens.replaceToken("const"),!0}processImport(){if(this.tokens.matches2(p.TokenType._import,p.TokenType.parenL)){if(this.preserveDynamicImport)return void this.tokens.copyToken();const e=this.enableLegacyTypeScriptModuleInterop?"":`${this.helperManager.getHelperName("interopRequireWildcard")}(`;this.tokens.replaceToken(`Promise.resolve().then(() => ${e}require`);const t=this.tokens.currentToken().contextId;if(null==t)throw new Error("Expected context ID on dynamic import invocation.");for(this.tokens.copyToken();!this.tokens.matchesContextIdAndLabel(p.TokenType.parenR,t);)this.rootTransformer.processToken();return void this.tokens.replaceToken(e?")))":"))")}if(this.removeImportAndDetectIfShouldElide())this.tokens.removeToken();else{const e=this.tokens.stringValue();this.tokens.replaceTokenTrimmingLeftWhitespace(this.importProcessor.claimImportCode(e)),this.tokens.appendCode(this.importProcessor.claimImportCode(e))}(0,m.removeMaybeImportAttributes)(this.tokens),this.tokens.matches1(p.TokenType.semi)&&this.tokens.removeToken()}removeImportAndDetectIfShouldElide(){if(this.tokens.removeInitialToken(),this.tokens.matchesContextual(k.ContextualKeyword._type)&&!this.tokens.matches1AtIndex(this.tokens.currentIndex()+1,p.TokenType.comma)&&!this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+1,k.ContextualKeyword._from))return this.removeRemainingImport(),!0;if(this.tokens.matches1(p.TokenType.name)||this.tokens.matches1(p.TokenType.star))return this.removeRemainingImport(),!1;if(this.tokens.matches1(p.TokenType.string))return!1;let e=!1,t=!1;for(;!this.tokens.matches1(p.TokenType.string);)(!e&&this.tokens.matches1(p.TokenType.braceL)||this.tokens.matches1(p.TokenType.comma))&&(this.tokens.removeToken(),this.tokens.matches1(p.TokenType.braceR)||(t=!0),(this.tokens.matches2(p.TokenType.name,p.TokenType.comma)||this.tokens.matches2(p.TokenType.name,p.TokenType.braceR)||this.tokens.matches4(p.TokenType.name,p.TokenType.name,p.TokenType.name,p.TokenType.comma)||this.tokens.matches4(p.TokenType.name,p.TokenType.name,p.TokenType.name,p.TokenType.braceR))&&(e=!0)),this.tokens.removeToken();return!this.keepUnusedImports&&(this.isTypeScriptTransformEnabled?!e:!!this.isFlowTransformEnabled&&(t&&!e))}removeRemainingImport(){for(;!this.tokens.matches1(p.TokenType.string);)this.tokens.removeToken()}processIdentifier(){const e=this.tokens.currentToken();if(e.shadowsGlobal)return!1;if(e.identifierRole===i.IdentifierRole.ObjectShorthand)return this.processObjectShorthand();if(e.identifierRole!==i.IdentifierRole.Access)return!1;const t=this.importProcessor.getIdentifierReplacement(this.tokens.identifierNameForToken(e));if(!t)return!1;let o=this.tokens.currentIndex()+1;for(;o<this.tokens.tokens.length&&this.tokens.tokens[o].type===p.TokenType.parenR;)o++;return this.tokens.tokens[o].type===p.TokenType.parenL?this.tokens.tokenAtRelativeIndex(1).type===p.TokenType.parenL&&this.tokens.tokenAtRelativeIndex(-1).type!==p.TokenType._new?(this.tokens.replaceToken(`${t}.call(void 0, `),this.tokens.removeToken(),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(p.TokenType.parenR)):this.tokens.replaceToken(`(0, ${t})`):this.tokens.replaceToken(t),!0}processObjectShorthand(){const e=this.tokens.identifierName(),t=this.importProcessor.getIdentifierReplacement(e);return!!t&&(this.tokens.replaceToken(`${e}: ${t}`),!0)}processExport(){if(this.tokens.matches2(p.TokenType._export,p.TokenType._enum)||this.tokens.matches3(p.TokenType._export,p.TokenType._const,p.TokenType._enum))return this.hadNamedExport=!0,!1;if(this.tokens.matches2(p.TokenType._export,p.TokenType._default))return this.tokens.matches3(p.TokenType._export,p.TokenType._default,p.TokenType._enum)?(this.hadDefaultExport=!0,!1):(this.processExportDefault(),!0);if(this.tokens.matches2(p.TokenType._export,p.TokenType.braceL))return this.processExportBindings(),!0;if(this.tokens.matches2(p.TokenType._export,p.TokenType.name)&&this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+1,k.ContextualKeyword._type)){if(this.tokens.removeInitialToken(),this.tokens.removeToken(),this.tokens.matches1(p.TokenType.braceL)){for(;!this.tokens.matches1(p.TokenType.braceR);)this.tokens.removeToken();this.tokens.removeToken()}else this.tokens.removeToken(),this.tokens.matches1(p.TokenType._as)&&(this.tokens.removeToken(),this.tokens.removeToken());return this.tokens.matchesContextual(k.ContextualKeyword._from)&&this.tokens.matches1AtIndex(this.tokens.currentIndex()+1,p.TokenType.string)&&(this.tokens.removeToken(),this.tokens.removeToken(),(0,m.removeMaybeImportAttributes)(this.tokens)),!0}if(this.hadNamedExport=!0,this.tokens.matches2(p.TokenType._export,p.TokenType._var)||this.tokens.matches2(p.TokenType._export,p.TokenType._let)||this.tokens.matches2(p.TokenType._export,p.TokenType._const))return this.processExportVar(),!0;if(this.tokens.matches2(p.TokenType._export,p.TokenType._function)||this.tokens.matches3(p.TokenType._export,p.TokenType.name,p.TokenType._function))return this.processExportFunction(),!0;if(this.tokens.matches2(p.TokenType._export,p.TokenType._class)||this.tokens.matches3(p.TokenType._export,p.TokenType._abstract,p.TokenType._class)||this.tokens.matches2(p.TokenType._export,p.TokenType.at))return this.processExportClass(),!0;if(this.tokens.matches2(p.TokenType._export,p.TokenType.star))return this.processExportStar(),!0;throw new Error("Unrecognized export syntax.")}processAssignment(){const e=this.tokens.currentIndex(),t=this.tokens.tokens[e-1];if(t.isType||t.type!==p.TokenType.name)return!1;if(t.shadowsGlobal)return!1;if(e>=2&&this.tokens.matches1AtIndex(e-2,p.TokenType.dot))return!1;if(e>=2&&[p.TokenType._var,p.TokenType._let,p.TokenType._const].includes(this.tokens.tokens[e-2].type))return!1;const o=this.importProcessor.resolveExportBinding(this.tokens.identifierNameForToken(t));return!!o&&(this.tokens.copyToken(),this.tokens.appendCode(` ${o} =`),!0)}processComplexAssignment(){const e=this.tokens.currentIndex(),t=this.tokens.tokens[e-1];if(t.type!==p.TokenType.name)return!1;if(t.shadowsGlobal)return!1;if(e>=2&&this.tokens.matches1AtIndex(e-2,p.TokenType.dot))return!1;const o=this.importProcessor.resolveExportBinding(this.tokens.identifierNameForToken(t));return!!o&&(this.tokens.appendCode(` = ${o}`),this.tokens.copyToken(),!0)}processPreIncDec(){const e=this.tokens.currentIndex(),t=this.tokens.tokens[e+1];if(t.type!==p.TokenType.name)return!1;if(t.shadowsGlobal)return!1;if(e+2<this.tokens.tokens.length&&(this.tokens.matches1AtIndex(e+2,p.TokenType.dot)||this.tokens.matches1AtIndex(e+2,p.TokenType.bracketL)||this.tokens.matches1AtIndex(e+2,p.TokenType.parenL)))return!1;const o=this.tokens.identifierNameForToken(t),s=this.importProcessor.resolveExportBinding(o);return!!s&&(this.tokens.appendCode(`${s} = `),this.tokens.copyToken(),!0)}processPostIncDec(){const e=this.tokens.currentIndex(),t=this.tokens.tokens[e],o=this.tokens.tokens[e+1];if(t.type!==p.TokenType.name)return!1;if(t.shadowsGlobal)return!1;if(e>=1&&this.tokens.matches1AtIndex(e-1,p.TokenType.dot))return!1;const s=this.tokens.identifierNameForToken(t),n=this.importProcessor.resolveExportBinding(s);if(!n)return!1;const r=this.tokens.rawCodeForToken(o),i=this.importProcessor.getIdentifierReplacement(s)||s;if("++"===r)this.tokens.replaceToken(`(${i} = ${n} = ${i} + 1, ${i} - 1)`);else{if("--"!==r)throw new Error(`Unexpected operator: ${r}`);this.tokens.replaceToken(`(${i} = ${n} = ${i} - 1, ${i} + 1)`)}return this.tokens.removeToken(),!0}processExportDefault(){let e=!0;if(this.tokens.matches4(p.TokenType._export,p.TokenType._default,p.TokenType._function,p.TokenType.name)||this.tokens.matches5(p.TokenType._export,p.TokenType._default,p.TokenType.name,p.TokenType._function,p.TokenType.name)&&this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+2,k.ContextualKeyword._async)){this.tokens.removeInitialToken(),this.tokens.removeToken();const e=this.processNamedFunction();this.tokens.appendCode(` exports.default = ${e};`)}else if(this.tokens.matches4(p.TokenType._export,p.TokenType._default,p.TokenType._class,p.TokenType.name)||this.tokens.matches5(p.TokenType._export,p.TokenType._default,p.TokenType._abstract,p.TokenType._class,p.TokenType.name)||this.tokens.matches3(p.TokenType._export,p.TokenType._default,p.TokenType.at)){this.tokens.removeInitialToken(),this.tokens.removeToken(),this.copyDecorators(),this.tokens.matches1(p.TokenType._abstract)&&this.tokens.removeToken();const e=this.rootTransformer.processNamedClass();this.tokens.appendCode(` exports.default = ${e};`)}else if((0,d.default)(this.isTypeScriptTransformEnabled,this.keepUnusedImports,this.tokens,this.declarationInfo))e=!1,this.tokens.removeInitialToken(),this.tokens.removeToken(),this.tokens.removeToken();else if(this.reactHotLoaderTransformer){const e=this.nameManager.claimFreeName("_default");this.tokens.replaceToken(`let ${e}; exports.`),this.tokens.copyToken(),this.tokens.appendCode(` = ${e} =`),this.reactHotLoaderTransformer.setExtractedDefaultExportName(e)}else this.tokens.replaceToken("exports."),this.tokens.copyToken(),this.tokens.appendCode(" =");e&&(this.hadDefaultExport=!0)}copyDecorators(){for(;this.tokens.matches1(p.TokenType.at);)if(this.tokens.copyToken(),this.tokens.matches1(p.TokenType.parenL))this.tokens.copyExpectedToken(p.TokenType.parenL),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(p.TokenType.parenR);else{for(this.tokens.copyExpectedToken(p.TokenType.name);this.tokens.matches1(p.TokenType.dot);)this.tokens.copyExpectedToken(p.TokenType.dot),this.tokens.copyExpectedToken(p.TokenType.name);this.tokens.matches1(p.TokenType.parenL)&&(this.tokens.copyExpectedToken(p.TokenType.parenL),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(p.TokenType.parenR))}}processExportVar(){this.isSimpleExportVar()?this.processSimpleExportVar():this.processComplexExportVar()}isSimpleExportVar(){let e=this.tokens.currentIndex();if(e++,e++,!this.tokens.matches1AtIndex(e,p.TokenType.name))return!1;for(e++;e<this.tokens.tokens.length&&this.tokens.tokens[e].isType;)e++;return!!this.tokens.matches1AtIndex(e,p.TokenType.eq)}processSimpleExportVar(){this.tokens.removeInitialToken(),this.tokens.copyToken();const e=this.tokens.identifierName();for(;!this.tokens.matches1(p.TokenType.eq);)this.rootTransformer.processToken();const t=this.tokens.currentToken().rhsEndIndex;if(null==t)throw new Error("Expected = token with an end index.");for(;this.tokens.currentIndex()<t;)this.rootTransformer.processToken();this.tokens.appendCode(`; exports.${e} = ${e}`)}processComplexExportVar(){this.tokens.removeInitialToken(),this.tokens.removeToken();const e=this.tokens.matches1(p.TokenType.braceL);e&&this.tokens.appendCode("(");let t=0;for(;;)if(this.tokens.matches1(p.TokenType.braceL)||this.tokens.matches1(p.TokenType.dollarBraceL)||this.tokens.matches1(p.TokenType.bracketL))t++,this.tokens.copyToken();else if(this.tokens.matches1(p.TokenType.braceR)||this.tokens.matches1(p.TokenType.bracketR))t--,this.tokens.copyToken();else{if(0===t&&!this.tokens.matches1(p.TokenType.name)&&!this.tokens.currentToken().isType)break;if(this.tokens.matches1(p.TokenType.eq)){const e=this.tokens.currentToken().rhsEndIndex;if(null==e)throw new Error("Expected = token with an end index.");for(;this.tokens.currentIndex()<e;)this.rootTransformer.processToken()}else{const e=this.tokens.currentToken();if((0,i.isDeclaration)(e)){const t=this.tokens.identifierName();let o=this.importProcessor.getIdentifierReplacement(t);if(null===o)throw new Error(`Expected a replacement for ${t} in \`export var\` syntax.`);(0,i.isObjectShorthandDeclaration)(e)&&(o=`${t}: ${o}`),this.tokens.replaceToken(o)}else this.rootTransformer.processToken()}}if(e){const e=this.tokens.currentToken().rhsEndIndex;if(null==e)throw new Error("Expected = token with an end index.");for(;this.tokens.currentIndex()<e;)this.rootTransformer.processToken();this.tokens.appendCode(")")}}processExportFunction(){this.tokens.replaceToken("");const e=this.processNamedFunction();this.tokens.appendCode(` exports.${e} = ${e};`)}processNamedFunction(){if(this.tokens.matches1(p.TokenType._function))this.tokens.copyToken();else if(this.tokens.matches2(p.TokenType.name,p.TokenType._function)){if(!this.tokens.matchesContextual(k.ContextualKeyword._async))throw new Error("Expected async keyword in function export.");this.tokens.copyToken(),this.tokens.copyToken()}if(this.tokens.matches1(p.TokenType.star)&&this.tokens.copyToken(),!this.tokens.matches1(p.TokenType.name))throw new Error("Expected identifier for exported function name.");const e=this.tokens.identifierName();if(this.tokens.copyToken(),this.tokens.currentToken().isType)for(this.tokens.removeInitialToken();this.tokens.currentToken().isType;)this.tokens.removeToken();return this.tokens.copyExpectedToken(p.TokenType.parenL),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(p.TokenType.parenR),this.rootTransformer.processPossibleTypeRange(),this.tokens.copyExpectedToken(p.TokenType.braceL),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(p.TokenType.braceR),e}processExportClass(){this.tokens.removeInitialToken(),this.copyDecorators(),this.tokens.matches1(p.TokenType._abstract)&&this.tokens.removeToken();const e=this.rootTransformer.processNamedClass();this.tokens.appendCode(` exports.${e} = ${e};`)}processExportBindings(){this.tokens.removeInitialToken(),this.tokens.removeToken();const e=(0,c.default)(this.tokens),t=[];for(;;){if(this.tokens.matches1(p.TokenType.braceR)){this.tokens.removeToken();break}const o=(0,T.default)(this.tokens);for(;this.tokens.currentIndex()<o.endIndex;)this.tokens.removeToken();if(!(o.isType||!e&&this.shouldElideExportedIdentifier(o.leftName))){const e=o.rightName;"default"===e?this.hadDefaultExport=!0:this.hadNamedExport=!0;const s=o.leftName,n=this.importProcessor.getIdentifierReplacement(s);t.push(`exports.${e} = ${n||s};`)}if(this.tokens.matches1(p.TokenType.braceR)){this.tokens.removeToken();break}if(this.tokens.matches2(p.TokenType.comma,p.TokenType.braceR)){this.tokens.removeToken(),this.tokens.removeToken();break}if(!this.tokens.matches1(p.TokenType.comma))throw new Error(`Unexpected token: ${JSON.stringify(this.tokens.currentToken())}`);this.tokens.removeToken()}if(this.tokens.matchesContextual(k.ContextualKeyword._from)){this.tokens.removeToken();const e=this.tokens.stringValue();this.tokens.replaceTokenTrimmingLeftWhitespace(this.importProcessor.claimImportCode(e)),(0,m.removeMaybeImportAttributes)(this.tokens)}else this.tokens.appendCode(t.join(" "));this.tokens.matches1(p.TokenType.semi)&&this.tokens.removeToken()}processExportStar(){for(this.tokens.removeInitialToken();!this.tokens.matches1(p.TokenType.string);)this.tokens.removeToken();const e=this.tokens.stringValue();this.tokens.replaceTokenTrimmingLeftWhitespace(this.importProcessor.claimImportCode(e)),(0,m.removeMaybeImportAttributes)(this.tokens),this.tokens.matches1(p.TokenType.semi)&&this.tokens.removeToken()}shouldElideExportedIdentifier(e){return this.isTypeScriptTransformEnabled&&!this.keepUnusedImports&&!this.declarationInfo.valueDeclarations.has(e)}}o.default=l},
"a5f4e01d7b": function _(e,o,n,T,k){T(),n.default=function(e){if(e.removeInitialToken(),e.removeToken(),e.removeToken(),e.removeToken(),e.matches1(m.TokenType.parenL))e.removeToken(),e.removeToken(),e.removeToken();else for(;e.matches1(m.TokenType.dot);)e.removeToken(),e.removeToken()};const m=e("f0c35cbd76")},
"f1b0dcccab": function _(e,n,t,o,a){o(),t.default=function(e){const n=new Set,t=new Set;for(let o=0;o<e.tokens.length;o++){const a=e.tokens[o];a.type===c.TokenType.name&&(0,i.isTopLevelDeclaration)(a)&&(a.isType?n.add(e.identifierNameForToken(a)):t.add(e.identifierNameForToken(a)))}return{typeDeclarations:n,valueDeclarations:t}};const i=e("bfb18d0576"),c=e("f0c35cbd76");t.EMPTY_DECLARATION_INFO={typeDeclarations:new Set,valueDeclarations:new Set}},
"c3c484c8b2": function _(e,t,n,c,o){c(),n.default=function(e){let t=e.currentIndex();for(;!e.matches1AtIndex(t,f.TokenType.braceR);)t++;return e.matchesContextualAtIndex(t+1,r.ContextualKeyword._from)&&e.matches1AtIndex(t+2,f.TokenType.string)};const r=e("99ff836c64"),f=e("f0c35cbd76")},
"f659e3ed39": function _(e,o,n,t,a){t(),n.removeMaybeImportAttributes=function(e){(e.matches2(r.TokenType._with,r.TokenType.braceL)||e.matches2(r.TokenType.name,r.TokenType.braceL)&&e.matchesContextual(c.ContextualKeyword._assert))&&(e.removeToken(),e.removeToken(),e.removeBalancedCode(),e.removeToken())};const c=e("99ff836c64"),r=e("f0c35cbd76")},
"11afb90ac4": function _(n,e,t,r,o){r(),t.default=function(n,e,t,r){if(!n||e)return!1;const o=t.currentToken();if(null==o.rhsEndIndex)throw new Error("Expected non-null rhsEndIndex on export token.");const d=o.rhsEndIndex-t.currentIndex();if(3!==d&&(4!==d||!t.matches1AtIndex(o.rhsEndIndex-1,c.TokenType.semi)))return!1;const s=t.tokenAtRelativeIndex(2);if(s.type!==c.TokenType.name)return!1;const i=t.identifierNameForToken(s);return r.typeDeclarations.has(i)&&!r.valueDeclarations.has(i)};const c=n("f0c35cbd76")},
"8db2e4c5d7": function _(e,t,o,s,n){s();const r=e("tslib"),i=e("99ff836c64"),k=e("f0c35cbd76"),a=r.__importDefault(e("a5f4e01d7b")),h=r.__importStar(e("f1b0dcccab")),T=r.__importDefault(e("14d4ae78a4")),p=e("1ff9c9004b"),m=r.__importDefault(e("c3c484c8b2")),c=e("f659e3ed39"),d=r.__importDefault(e("11afb90ac4")),y=r.__importDefault(e("a46f119f74"));class l extends y.default{constructor(e,t,o,s,n,r,i,k){super(),this.tokens=e,this.nameManager=t,this.helperManager=o,this.reactHotLoaderTransformer=s,this.isTypeScriptTransformEnabled=n,this.isFlowTransformEnabled=r,this.keepUnusedImports=i,this.nonTypeIdentifiers=n&&!i?(0,p.getNonTypeIdentifiers)(e,k):new Set,this.declarationInfo=n&&!i?(0,h.default)(e):h.EMPTY_DECLARATION_INFO,this.injectCreateRequireForImportRequire=Boolean(k.injectCreateRequireForImportRequire)}process(){if(this.tokens.matches3(k.TokenType._import,k.TokenType.name,k.TokenType.eq))return this.processImportEquals();if(this.tokens.matches4(k.TokenType._import,k.TokenType.name,k.TokenType.name,k.TokenType.eq)&&this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+1,i.ContextualKeyword._type)){this.tokens.removeInitialToken();for(let e=0;e<7;e++)this.tokens.removeToken();return!0}if(this.tokens.matches2(k.TokenType._export,k.TokenType.eq))return this.tokens.replaceToken("module.exports"),!0;if(this.tokens.matches5(k.TokenType._export,k.TokenType._import,k.TokenType.name,k.TokenType.name,k.TokenType.eq)&&this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+2,i.ContextualKeyword._type)){this.tokens.removeInitialToken();for(let e=0;e<8;e++)this.tokens.removeToken();return!0}if(this.tokens.matches1(k.TokenType._import))return this.processImport();if(this.tokens.matches2(k.TokenType._export,k.TokenType._default))return this.processExportDefault();if(this.tokens.matches2(k.TokenType._export,k.TokenType.braceL))return this.processNamedExports();if(this.tokens.matches2(k.TokenType._export,k.TokenType.name)&&this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+1,i.ContextualKeyword._type)){if(this.tokens.removeInitialToken(),this.tokens.removeToken(),this.tokens.matches1(k.TokenType.braceL)){for(;!this.tokens.matches1(k.TokenType.braceR);)this.tokens.removeToken();this.tokens.removeToken()}else this.tokens.removeToken(),this.tokens.matches1(k.TokenType._as)&&(this.tokens.removeToken(),this.tokens.removeToken());return this.tokens.matchesContextual(i.ContextualKeyword._from)&&this.tokens.matches1AtIndex(this.tokens.currentIndex()+1,k.TokenType.string)&&(this.tokens.removeToken(),this.tokens.removeToken(),(0,c.removeMaybeImportAttributes)(this.tokens)),!0}return!1}processImportEquals(){const e=this.tokens.identifierNameAtIndex(this.tokens.currentIndex()+1);return this.shouldAutomaticallyElideImportedName(e)?(0,a.default)(this.tokens):this.injectCreateRequireForImportRequire?(this.tokens.replaceToken("const"),this.tokens.copyToken(),this.tokens.copyToken(),this.tokens.replaceToken(this.helperManager.getHelperName("require"))):this.tokens.replaceToken("const"),!0}processImport(){if(this.tokens.matches2(k.TokenType._import,k.TokenType.parenL))return!1;const e=this.tokens.snapshot();if(this.removeImportTypeBindings()){for(this.tokens.restoreToSnapshot(e);!this.tokens.matches1(k.TokenType.string);)this.tokens.removeToken();this.tokens.removeToken(),(0,c.removeMaybeImportAttributes)(this.tokens),this.tokens.matches1(k.TokenType.semi)&&this.tokens.removeToken()}return!0}removeImportTypeBindings(){if(this.tokens.copyExpectedToken(k.TokenType._import),this.tokens.matchesContextual(i.ContextualKeyword._type)&&!this.tokens.matches1AtIndex(this.tokens.currentIndex()+1,k.TokenType.comma)&&!this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+1,i.ContextualKeyword._from))return!0;if(this.tokens.matches1(k.TokenType.string))return this.tokens.copyToken(),!1;this.tokens.matchesContextual(i.ContextualKeyword._module)&&this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+2,i.ContextualKeyword._from)&&this.tokens.copyToken();let e=!1,t=!1,o=!1;if(this.tokens.matches1(k.TokenType.name)&&(this.shouldAutomaticallyElideImportedName(this.tokens.identifierName())?(this.tokens.removeToken(),this.tokens.matches1(k.TokenType.comma)&&this.tokens.removeToken()):(e=!0,this.tokens.copyToken(),this.tokens.matches1(k.TokenType.comma)&&(o=!0,this.tokens.removeToken()))),this.tokens.matches1(k.TokenType.star))this.shouldAutomaticallyElideImportedName(this.tokens.identifierNameAtRelativeIndex(2))?(this.tokens.removeToken(),this.tokens.removeToken(),this.tokens.removeToken()):(o&&this.tokens.appendCode(","),e=!0,this.tokens.copyExpectedToken(k.TokenType.star),this.tokens.copyExpectedToken(k.TokenType.name),this.tokens.copyExpectedToken(k.TokenType.name));else if(this.tokens.matches1(k.TokenType.braceL)){for(o&&this.tokens.appendCode(","),this.tokens.copyToken();!this.tokens.matches1(k.TokenType.braceR);){t=!0;const o=(0,T.default)(this.tokens);if(o.isType||this.shouldAutomaticallyElideImportedName(o.rightName)){for(;this.tokens.currentIndex()<o.endIndex;)this.tokens.removeToken();this.tokens.matches1(k.TokenType.comma)&&this.tokens.removeToken()}else{for(e=!0;this.tokens.currentIndex()<o.endIndex;)this.tokens.copyToken();this.tokens.matches1(k.TokenType.comma)&&this.tokens.copyToken()}}this.tokens.copyExpectedToken(k.TokenType.braceR)}return!this.keepUnusedImports&&(this.isTypeScriptTransformEnabled?!e:!!this.isFlowTransformEnabled&&(t&&!e))}shouldAutomaticallyElideImportedName(e){return this.isTypeScriptTransformEnabled&&!this.keepUnusedImports&&!this.nonTypeIdentifiers.has(e)}processExportDefault(){if((0,d.default)(this.isTypeScriptTransformEnabled,this.keepUnusedImports,this.tokens,this.declarationInfo))return this.tokens.removeInitialToken(),this.tokens.removeToken(),this.tokens.removeToken(),!0;if(!(this.tokens.matches4(k.TokenType._export,k.TokenType._default,k.TokenType._function,k.TokenType.name)||this.tokens.matches5(k.TokenType._export,k.TokenType._default,k.TokenType.name,k.TokenType._function,k.TokenType.name)&&this.tokens.matchesContextualAtIndex(this.tokens.currentIndex()+2,i.ContextualKeyword._async)||this.tokens.matches4(k.TokenType._export,k.TokenType._default,k.TokenType._class,k.TokenType.name)||this.tokens.matches5(k.TokenType._export,k.TokenType._default,k.TokenType._abstract,k.TokenType._class,k.TokenType.name))&&this.reactHotLoaderTransformer){const e=this.nameManager.claimFreeName("_default");return this.tokens.replaceToken(`let ${e}; export`),this.tokens.copyToken(),this.tokens.appendCode(` ${e} =`),this.reactHotLoaderTransformer.setExtractedDefaultExportName(e),!0}return!1}processNamedExports(){if(!this.isTypeScriptTransformEnabled)return!1;this.tokens.copyExpectedToken(k.TokenType._export),this.tokens.copyExpectedToken(k.TokenType.braceL);const e=(0,m.default)(this.tokens);let t=!1;for(;!this.tokens.matches1(k.TokenType.braceR);){const o=(0,T.default)(this.tokens);if(o.isType||!e&&this.shouldElideExportedName(o.leftName)){for(;this.tokens.currentIndex()<o.endIndex;)this.tokens.removeToken();this.tokens.matches1(k.TokenType.comma)&&this.tokens.removeToken()}else{for(t=!0;this.tokens.currentIndex()<o.endIndex;)this.tokens.copyToken();this.tokens.matches1(k.TokenType.comma)&&this.tokens.copyToken()}}return this.tokens.copyExpectedToken(k.TokenType.braceR),this.keepUnusedImports||!e||t||(this.tokens.removeToken(),this.tokens.removeToken(),(0,c.removeMaybeImportAttributes)(this.tokens)),!0}shouldElideExportedName(e){return this.isTypeScriptTransformEnabled&&!this.keepUnusedImports&&this.declarationInfo.typeDeclarations.has(e)&&!this.declarationInfo.valueDeclarations.has(e)}}o.default=l},
"3913cc12b3": function _(e,s,t,o,n){o();const i=e("tslib"),r=e("99ff836c64"),p=e("f0c35cbd76"),k=i.__importDefault(e("a46f119f74"));class a extends k.default{constructor(e,s,t){super(),this.rootTransformer=e,this.tokens=s,this.isImportsTransformEnabled=t}process(){return!!(this.rootTransformer.processPossibleArrowParamEnd()||this.rootTransformer.processPossibleAsyncArrowWithTypeParams()||this.rootTransformer.processPossibleTypeRange())||(this.tokens.matches1(p.TokenType._enum)?(this.processEnum(),!0):this.tokens.matches2(p.TokenType._export,p.TokenType._enum)?(this.processNamedExportEnum(),!0):!!this.tokens.matches3(p.TokenType._export,p.TokenType._default,p.TokenType._enum)&&(this.processDefaultExportEnum(),!0))}processNamedExportEnum(){if(this.isImportsTransformEnabled){this.tokens.removeInitialToken();const e=this.tokens.identifierNameAtRelativeIndex(1);this.processEnum(),this.tokens.appendCode(` exports.${e} = ${e};`)}else this.tokens.copyToken(),this.processEnum()}processDefaultExportEnum(){this.tokens.removeInitialToken(),this.tokens.removeToken();const e=this.tokens.identifierNameAtRelativeIndex(1);this.processEnum(),this.isImportsTransformEnabled?this.tokens.appendCode(` exports.default = ${e};`):this.tokens.appendCode(` export default ${e};`)}processEnum(){this.tokens.replaceToken("const"),this.tokens.copyExpectedToken(p.TokenType.name);let e=!1;this.tokens.matchesContextual(r.ContextualKeyword._of)&&(this.tokens.removeToken(),e=this.tokens.matchesContextual(r.ContextualKeyword._symbol),this.tokens.removeToken());const s=this.tokens.matches3(p.TokenType.braceL,p.TokenType.name,p.TokenType.eq);this.tokens.appendCode(' = require("flow-enums-runtime")');const t=!e&&!s;for(this.tokens.replaceTokenTrimmingLeftWhitespace(t?".Mirrored([":"({");!this.tokens.matches1(p.TokenType.braceR);){if(this.tokens.matches1(p.TokenType.ellipsis)){this.tokens.removeToken();break}this.processEnumElement(e,s),this.tokens.matches1(p.TokenType.comma)&&this.tokens.copyToken()}this.tokens.replaceToken(t?"]);":"});")}processEnumElement(e,s){if(e){const e=this.tokens.identifierName();this.tokens.copyToken(),this.tokens.appendCode(`: Symbol("${e}")`)}else s?(this.tokens.copyToken(),this.tokens.replaceTokenTrimmingLeftWhitespace(":"),this.tokens.copyToken()):this.tokens.replaceToken(`"${this.tokens.identifierName()}"`)}}t.default=a},
"3eb46b07e3": function _(e,t,o,s,n){s();const i=e("tslib");const c=e("f0c35cbd76"),a=i.__importDefault(e("a46f119f74")),r="jest",l=["mock","unmock","enableAutomock","disableAutomock"];class p extends a.default{__init(){this.hoistedFunctionNames=[]}constructor(e,t,o,s){super(),this.rootTransformer=e,this.tokens=t,this.nameManager=o,this.importProcessor=s,p.prototype.__init.call(this)}process(){return!(0!==this.tokens.currentToken().scopeDepth||!this.tokens.matches4(c.TokenType.name,c.TokenType.dot,c.TokenType.name,c.TokenType.parenL)||this.tokens.identifierName()!==r)&&(!function(e){let t,o=e[0],s=1;for(;s<e.length;){const n=e[s],i=e[s+1];if(s+=2,("optionalAccess"===n||"optionalCall"===n)&&null==o)return;"access"===n||"optionalAccess"===n?(t=o,o=i(o)):"call"!==n&&"optionalCall"!==n||(o=i(((...e)=>o.call(t,...e))),t=void 0)}return o}([this,"access",e=>e.importProcessor,"optionalAccess",e=>e.getGlobalNames,"call",e=>e(),"optionalAccess",e=>e.has,"call",e=>e(r)])&&this.extractHoistedCalls())}getHoistedCode(){return this.hoistedFunctionNames.length>0?this.hoistedFunctionNames.map((e=>`${e}();`)).join(""):""}extractHoistedCalls(){this.tokens.removeToken();let e=!1;for(;this.tokens.matches3(c.TokenType.dot,c.TokenType.name,c.TokenType.parenL);){const t=this.tokens.identifierNameAtIndex(this.tokens.currentIndex()+1);if(l.includes(t)){const t=this.nameManager.claimFreeName("__jestHoist");this.hoistedFunctionNames.push(t),this.tokens.replaceToken(`function ${t}(){${r}.`),this.tokens.copyToken(),this.tokens.copyToken(),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(c.TokenType.parenR),this.tokens.appendCode(";}"),e=!1}else e?this.tokens.copyToken():this.tokens.replaceToken(`${r}.`),this.tokens.copyToken(),this.tokens.copyToken(),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(c.TokenType.parenR),e=!0}return!0}}o.default=p},
"09e20c28d7": function _(e,t,s,n,o){n();const c=e("tslib"),r=e("f0c35cbd76"),u=c.__importDefault(e("a46f119f74"));class i extends u.default{constructor(e){super(),this.tokens=e}process(){if(this.tokens.matches1(r.TokenType.num)){const e=this.tokens.currentTokenCode();if(e.includes("_"))return this.tokens.replaceToken(e.replace(/_/g,"")),!0}return!1}}s.default=i},
"1dc037e3ca": function _(e,t,s,n,a){n();const o=e("tslib"),c=e("f0c35cbd76"),r=o.__importDefault(e("a46f119f74"));class i extends r.default{constructor(e,t){super(),this.tokens=e,this.nameManager=t}process(){return!!this.tokens.matches2(c.TokenType._catch,c.TokenType.braceL)&&(this.tokens.copyToken(),this.tokens.appendCode(` (${this.nameManager.claimFreeName("e")})`),!0)}}s.default=i},
"6995ead426": function _(e,t,s,n,i){n();const o=e("tslib"),a=e("f0c35cbd76"),h=o.__importDefault(e("a46f119f74"));class r extends h.default{constructor(e,t){super(),this.tokens=e,this.nameManager=t}process(){if(this.tokens.matches1(a.TokenType.nullishCoalescing)){const e=this.tokens.currentToken();return this.tokens.tokens[e.nullishStartIndex].isAsyncOperation?this.tokens.replaceTokenTrimmingLeftWhitespace(", async () => ("):this.tokens.replaceTokenTrimmingLeftWhitespace(", () => ("),!0}if(this.tokens.matches1(a.TokenType._delete)){if(this.tokens.tokenAtRelativeIndex(1).isOptionalChainStart)return this.tokens.removeInitialToken(),!0}const e=this.tokens.currentToken().subscriptStartIndex;if(null!=e&&this.tokens.tokens[e].isOptionalChainStart&&this.tokens.tokenAtRelativeIndex(-1).type!==a.TokenType._super){const t=this.nameManager.claimFreeName("_");let s;if(s=e>0&&this.tokens.matches1AtIndex(e-1,a.TokenType._delete)&&this.isLastSubscriptInChain()?`${t} => delete ${t}`:`${t} => ${t}`,this.tokens.tokens[e].isAsyncOperation&&(s=`async ${s}`),this.tokens.matches2(a.TokenType.questionDot,a.TokenType.parenL)||this.tokens.matches2(a.TokenType.questionDot,a.TokenType.lessThan))this.justSkippedSuper()&&this.tokens.appendCode(".bind(this)"),this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'optionalCall', ${s}`);else if(this.tokens.matches2(a.TokenType.questionDot,a.TokenType.bracketL))this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'optionalAccess', ${s}`);else if(this.tokens.matches1(a.TokenType.questionDot))this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'optionalAccess', ${s}.`);else if(this.tokens.matches1(a.TokenType.dot))this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'access', ${s}.`);else if(this.tokens.matches1(a.TokenType.bracketL))this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'access', ${s}[`);else{if(!this.tokens.matches1(a.TokenType.parenL))throw new Error("Unexpected subscript operator in optional chain.");this.justSkippedSuper()&&this.tokens.appendCode(".bind(this)"),this.tokens.replaceTokenTrimmingLeftWhitespace(`, 'call', ${s}(`)}return!0}return!1}isLastSubscriptInChain(){let e=0;for(let t=this.tokens.currentIndex()+1;;t++){if(t>=this.tokens.tokens.length)throw new Error("Reached the end of the code while finding the end of the access chain.");if(this.tokens.tokens[t].isOptionalChainStart?e++:this.tokens.tokens[t].isOptionalChainEnd&&e--,e<0)return!0;if(0===e&&null!=this.tokens.tokens[t].subscriptStartIndex)return!1}}justSkippedSuper(){let e=0,t=this.tokens.currentIndex()-1;for(;;){if(t<0)throw new Error("Reached the start of the code while finding the start of the access chain.");if(this.tokens.tokens[t].isOptionalChainStart?e--:this.tokens.tokens[t].isOptionalChainEnd&&e++,e<0)return!1;if(0===e&&null!=this.tokens.tokens[t].subscriptStartIndex)return this.tokens.tokens[t-1].type===a.TokenType._super;t--}}}s.default=r},
"9aad52e886": function _(e,t,s,n,o){n();const i=e("tslib"),r=e("bfb18d0576"),a=e("f0c35cbd76"),c=i.__importDefault(e("a46f119f74"));class k extends c.default{constructor(e,t,s,n){super(),this.rootTransformer=e,this.tokens=t,this.importProcessor=s,this.options=n}process(){const e=this.tokens.currentIndex();if("createReactClass"===this.tokens.identifierName()){const t=this.importProcessor&&this.importProcessor.getIdentifierReplacement("createReactClass");return t?this.tokens.replaceToken(`(0, ${t})`):this.tokens.copyToken(),this.tryProcessCreateClassCall(e),!0}if(this.tokens.matches3(a.TokenType.name,a.TokenType.dot,a.TokenType.name)&&"React"===this.tokens.identifierName()&&"createClass"===this.tokens.identifierNameAtIndex(this.tokens.currentIndex()+2)){const t=this.importProcessor&&this.importProcessor.getIdentifierReplacement("React")||"React";return t?(this.tokens.replaceToken(t),this.tokens.copyToken(),this.tokens.copyToken()):(this.tokens.copyToken(),this.tokens.copyToken(),this.tokens.copyToken()),this.tryProcessCreateClassCall(e),!0}return!1}tryProcessCreateClassCall(e){const t=this.findDisplayName(e);t&&this.classNeedsDisplayName()&&(this.tokens.copyExpectedToken(a.TokenType.parenL),this.tokens.copyExpectedToken(a.TokenType.braceL),this.tokens.appendCode(`displayName: '${t}',`),this.rootTransformer.processBalancedCode(),this.tokens.copyExpectedToken(a.TokenType.braceR),this.tokens.copyExpectedToken(a.TokenType.parenR))}findDisplayName(e){return e<2?null:this.tokens.matches2AtIndex(e-2,a.TokenType.name,a.TokenType.eq)||e>=2&&this.tokens.tokens[e-2].identifierRole===r.IdentifierRole.ObjectKey?this.tokens.identifierNameAtIndex(e-2):this.tokens.matches2AtIndex(e-2,a.TokenType._export,a.TokenType._default)?this.getDisplayNameFromFilename():null}getDisplayNameFromFilename(){const e=(this.options.filePath||"unknown").split("/"),t=e[e.length-1],s=t.lastIndexOf("."),n=-1===s?t:t.slice(0,s);return"index"===n&&e[e.length-2]?e[e.length-2]:n}classNeedsDisplayName(){let e=this.tokens.currentIndex();if(!this.tokens.matches2(a.TokenType.parenL,a.TokenType.braceL))return!1;const t=e+1,s=this.tokens.tokens[t].contextId;if(null==s)throw new Error("Expected non-null context ID on object open-brace.");for(;e<this.tokens.tokens.length;e++){const t=this.tokens.tokens[e];if(t.type===a.TokenType.braceR&&t.contextId===s){e++;break}if("displayName"===this.tokens.identifierNameAtIndex(e)&&this.tokens.tokens[e].identifierRole===r.IdentifierRole.ObjectKey&&t.contextId===s)return!1}if(e===this.tokens.tokens.length)throw new Error("Unexpected end of input when processing React class.");return this.tokens.matches1AtIndex(e,a.TokenType.parenR)||this.tokens.matches2AtIndex(e,a.TokenType.comma,a.TokenType.parenR)}}s.default=k},
"c3f855a290": function _(e,t,r,a,o){a();const n=e("tslib"),i=e("bfb18d0576"),l=n.__importDefault(e("a46f119f74"));class u extends l.default{__init(){this.extractedDefaultExportName=null}constructor(e,t){super(),this.tokens=e,this.filePath=t,u.prototype.__init.call(this)}setExtractedDefaultExportName(e){this.extractedDefaultExportName=e}getPrefixCode(){return"\n      (function () {\n        var enterModule = require('react-hot-loader').enterModule;\n        enterModule && enterModule(module);\n      })();".replace(/\s+/g," ").trim()}getSuffixCode(){const e=new Set;for(const t of this.tokens.tokens)!t.isType&&(0,i.isTopLevelDeclaration)(t)&&t.identifierRole!==i.IdentifierRole.ImportDeclaration&&e.add(this.tokens.identifierNameForToken(t));const t=Array.from(e).map((e=>({variableName:e,uniqueLocalName:e})));return this.extractedDefaultExportName&&t.push({variableName:this.extractedDefaultExportName,uniqueLocalName:"default"}),`\n;(function () {\n  var reactHotLoader = require('react-hot-loader').default;\n  var leaveModule = require('react-hot-loader').leaveModule;\n  if (!reactHotLoader) {\n    return;\n  }\n${t.map((({variableName:e,uniqueLocalName:t})=>`  reactHotLoader.register(${e}, "${t}", ${JSON.stringify(this.filePath||"")});`)).join("\n")}\n  leaveModule(module);\n})();`}process(){return!1}}r.default=u},
"581b1c506a": function _(e,t,s,n,o){n();const r=e("tslib"),i=e("f0c35cbd76"),p=r.__importDefault(e("5e8df41f33")),k=r.__importDefault(e("a46f119f74"));class a extends k.default{constructor(e,t,s){super(),this.rootTransformer=e,this.tokens=t,this.isImportsTransformEnabled=s}process(){return!!(this.rootTransformer.processPossibleArrowParamEnd()||this.rootTransformer.processPossibleAsyncArrowWithTypeParams()||this.rootTransformer.processPossibleTypeRange())||(this.tokens.matches1(i.TokenType._public)||this.tokens.matches1(i.TokenType._protected)||this.tokens.matches1(i.TokenType._private)||this.tokens.matches1(i.TokenType._abstract)||this.tokens.matches1(i.TokenType._readonly)||this.tokens.matches1(i.TokenType._override)||this.tokens.matches1(i.TokenType.nonNullAssertion)?(this.tokens.removeInitialToken(),!0):this.tokens.matches1(i.TokenType._enum)||this.tokens.matches2(i.TokenType._const,i.TokenType._enum)?(this.processEnum(),!0):!(!this.tokens.matches2(i.TokenType._export,i.TokenType._enum)&&!this.tokens.matches3(i.TokenType._export,i.TokenType._const,i.TokenType._enum))&&(this.processEnum(!0),!0))}processEnum(e=!1){for(this.tokens.removeInitialToken();this.tokens.matches1(i.TokenType._const)||this.tokens.matches1(i.TokenType._enum);)this.tokens.removeToken();const t=this.tokens.identifierName();this.tokens.removeToken(),e&&!this.isImportsTransformEnabled&&this.tokens.appendCode("export "),this.tokens.appendCode(`var ${t}; (function (${t})`),this.tokens.copyExpectedToken(i.TokenType.braceL),this.processEnumBody(t),this.tokens.copyExpectedToken(i.TokenType.braceR),e&&this.isImportsTransformEnabled?this.tokens.appendCode(`)(${t} || (exports.${t} = ${t} = {}));`):this.tokens.appendCode(`)(${t} || (${t} = {}));`)}processEnumBody(e){let t=null;for(;!this.tokens.matches1(i.TokenType.braceR);){const{nameStringCode:s,variableName:n}=this.extractEnumKeyInfo(this.tokens.currentToken());this.tokens.removeInitialToken(),this.tokens.matches3(i.TokenType.eq,i.TokenType.string,i.TokenType.comma)||this.tokens.matches3(i.TokenType.eq,i.TokenType.string,i.TokenType.braceR)?this.processStringLiteralEnumMember(e,s,n):this.tokens.matches1(i.TokenType.eq)?this.processExplicitValueEnumMember(e,s,n):this.processImplicitValueEnumMember(e,s,n,t),this.tokens.matches1(i.TokenType.comma)&&this.tokens.removeToken(),t=null!=n?n:`${e}[${s}]`}}extractEnumKeyInfo(e){if(e.type===i.TokenType.name){const t=this.tokens.identifierNameForToken(e);return{nameStringCode:`"${t}"`,variableName:(0,p.default)(t)?t:null}}if(e.type===i.TokenType.string){const t=this.tokens.stringValueForToken(e);return{nameStringCode:this.tokens.code.slice(e.start,e.end),variableName:(0,p.default)(t)?t:null}}throw new Error("Expected name or string at beginning of enum element.")}processStringLiteralEnumMember(e,t,s){null!=s?(this.tokens.appendCode(`const ${s}`),this.tokens.copyToken(),this.tokens.copyToken(),this.tokens.appendCode(`; ${e}[${t}] = ${s};`)):(this.tokens.appendCode(`${e}[${t}]`),this.tokens.copyToken(),this.tokens.copyToken(),this.tokens.appendCode(";"))}processExplicitValueEnumMember(e,t,s){const n=this.tokens.currentToken().rhsEndIndex;if(null==n)throw new Error("Expected rhsEndIndex on enum assign.");if(null!=s){for(this.tokens.appendCode(`const ${s}`),this.tokens.copyToken();this.tokens.currentIndex()<n;)this.rootTransformer.processToken();this.tokens.appendCode(`; ${e}[${e}[${t}] = ${s}] = ${t};`)}else{for(this.tokens.appendCode(`${e}[${e}[${t}]`),this.tokens.copyToken();this.tokens.currentIndex()<n;)this.rootTransformer.processToken();this.tokens.appendCode(`] = ${t};`)}}processImplicitValueEnumMember(e,t,s,n){let o=null!=n?`${n} + 1`:"0";null!=s&&(this.tokens.appendCode(`const ${s} = ${o}; `),o=s),this.tokens.appendCode(`${e}[${e}[${t}] = ${o}] = ${t};`)}}s.default=a},
"5e8df41f33": function _(e,t,n,r,i){r(),n.default=function(e){if(0===e.length)return!1;if(!a.IS_IDENTIFIER_START[e.charCodeAt(0)])return!1;for(let t=1;t<e.length;t++)if(!a.IS_IDENTIFIER_CHAR[e.charCodeAt(t)])return!1;return!c.has(e)};const a=e("364148c9f0"),c=new Set(["break","case","catch","class","const","continue","debugger","default","delete","do","else","export","extends","finally","for","function","if","import","in","instanceof","new","return","super","switch","this","throw","try","typeof","var","void","while","with","yield","enum","implements","interface","let","package","private","protected","public","static","await","false","null","true"])},
"2e6a9a5b28": function _(n,t,e,o,r){o(),e.default=function(n,t){if(0===t.length)return"";const e=Object.keys(t[0]).filter((n=>"type"!==n&&"value"!==n&&"start"!==n&&"end"!==n&&"loc"!==n)),o=Object.keys(t[0].type).filter((n=>"label"!==n&&"keyword"!==n)),r=["Location","Label","Raw",...e,...o],i=new c.default(n),u=[r,...t.map((function(t){const r=n.slice(t.start,t.end);return[s(t.start,t.end),(0,l.formatTokenType)(t.type),a(String(r),14),...e.map((n=>p(t[n],n))),...o.map((n=>p(t.type[n],n)))]}))],f=r.map((()=>0));for(const n of u)for(let t=0;t<n.length;t++)f[t]=Math.max(f[t],n[t].length);return u.map((n=>n.map(((n,t)=>n.padEnd(f[t]))).join(" "))).join("\n");function p(n,t){return!0===n?t:!1===n||null===n?"":String(n)}function s(n,t){return`${d(n)}-${d(t)}`}function d(n){const t=i.locationForIndex(n);return t?`${t.line+1}:${t.column+1}`:"Unknown"}};const c=n("tslib").__importDefault(n("d2035ed1c8")),l=n("f0c35cbd76");function a(n,t){return n.length>t?`${n.slice(0,t-3)}...`:n}},
"d2035ed1c8": function _(t,n,e,s,o){e.__esModule=!0;var i="\n",r=function(){function t(t){this.string=t;for(var n=[0],e=0;e<t.length;)switch(t[e]){case i:e+=1,n.push(e);break;case"\r":t[e+=1]===i&&(e+=1),n.push(e);break;default:e++}this.offsets=n}return t.prototype.locationForIndex=function(t){if(t<0||t>this.string.length)return null;for(var n=0,e=this.offsets;e[n+1]<=t;)n++;return{line:n,column:t-e[n]}},t.prototype.indexForLocation=function(t){var n=t.line,e=t.column;return n<0||n>=this.offsets.length||e<0||e>this.lengthOfLine(n)?null:this.offsets[n]+e},t.prototype.lengthOfLine=function(t){var n=this.offsets[t];return(t===this.offsets.length-1?this.string.length:this.offsets[t+1])-n},t}();e.LinesAndColumns=r,e.default=r},
"4160f5108d": function _(e,n,t,o,a){o(),t.default=function(e){const n=new Set;for(let t=0;t<e.tokens.length;t++)e.matches1AtIndex(t,c.TokenType._import)&&!e.matches3AtIndex(t,c.TokenType._import,c.TokenType.name,c.TokenType.eq)&&r(e,t,n);return n};const T=e("tslib"),c=e("f0c35cbd76"),d=T.__importDefault(e("14d4ae78a4"));function r(e,n,t){n++,e.matches1AtIndex(n,c.TokenType.parenL)||(e.matches1AtIndex(n,c.TokenType.name)&&(t.add(e.identifierNameAtIndex(n)),n++,e.matches1AtIndex(n,c.TokenType.comma)&&n++),e.matches1AtIndex(n,c.TokenType.star)&&(n+=2,t.add(e.identifierNameAtIndex(n)),n++),e.matches1AtIndex(n,c.TokenType.braceL)&&function(e,n,t){for(;;){if(e.matches1AtIndex(n,c.TokenType.braceR))return;const o=(0,d.default)(e,n);if(n=o.endIndex,o.isType||t.add(o.rightName),e.matches2AtIndex(n,c.TokenType.comma,c.TokenType.braceR))return;if(e.matches1AtIndex(n,c.TokenType.braceR))return;if(!e.matches1AtIndex(n,c.TokenType.comma))throw new Error(`Unexpected token: ${JSON.stringify(e.tokens[n])}`);n++}}(e,++n,t))}},
"a572dba9cd": function _(e,t,a,r,n){function i(e){let t=null;return e&&(t=function(e){try{return{boundingClientRect:{...e.getBoundingClientRect()}}}catch{return{}}}(e),e.tagName in l&&l[e.tagName].forEach((a=>Object.assign(t,a(e))))),t}r(),a.serializeEvent=
/*
    The MIT License (MIT)
    
    Copyright (c) 2019 Ryan S. Morshead
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.
    */
function(e){const t={};void 0!==e.detail&&Object.assign(t,{detail:JSON.parse(JSON.stringify(e.detail))});e.type in d&&Object.assign(t,d[e.type](e));return t.target=i(e.target),t.currentTarget=e.target===e.currentTarget?t.target:i(e.currentTarget),t.relatedTarget=i(e.relatedTarget),t};const o={hasValue:e=>({value:e.value}),hasCurrentTime:e=>({currentTime:e.currentTime}),hasFiles:e=>"file"===e.type?{files:[...e.files??[]].map((e=>({lastModified:e.lastModified,name:e.name,size:e.size,type:e.type})))}:{}};const s={hasValue:["BUTTON","INPUT","OPTION","LI","METER","PROGRESS","PARAM","SELECT","TEXTAREA"],hasCurrentTime:["AUDIO","VIDEO"],hasFiles:["INPUT"]},l={};Object.keys(s).forEach((e=>{s[e].forEach((t=>{(l[t]||(l[t]=[])).push(o[e])}))}));class c{clipboard(e){return{clipboardData:e.clipboardData}}composition(e){return{data:e.data}}keyboard(e){return{altKey:e.altKey,charCode:e.charCode,ctrlKey:e.ctrlKey,key:e.key,keyCode:e.keyCode,locale:e.locale,location:e.location,metaKey:e.metaKey,repeat:e.repeat,shiftKey:e.shiftKey,which:e.which}}mouse(e){return{altKey:e.altKey,button:e.button,buttons:e.buttons,clientX:e.clientX,clientY:e.clientY,ctrlKey:e.ctrlKey,metaKey:e.metaKey,pageX:e.pageX,pageY:e.pageY,screenX:e.screenX,screenY:e.screenY,shiftKey:e.shiftKey}}pointer(e){return{...this.mouse(e),pointerId:e.pointerId,width:e.width,height:e.height,pressure:e.pressure,tiltX:e.tiltX,tiltY:e.tiltY,pointerType:e.pointerType,isPrimary:e.isPrimary}}selection(){return{selectedText:window.getSelection().toString()}}touch(e){return{altKey:e.altKey,ctrlKey:e.ctrlKey,metaKey:e.metaKey,shiftKey:e.shiftKey}}ui(e){return{detail:e.detail}}wheel(e){return{deltaMode:e.deltaMode,deltaX:e.deltaX,deltaY:e.deltaY,deltaZ:e.deltaZ}}animation(e){return{animationName:e.animationName,pseudoElement:e.pseudoElement,elapsedTime:e.elapsedTime}}transition(e){return{propertyName:e.propertyName,pseudoElement:e.pseudoElement,elapsedTime:e.elapsedTime}}}c.__name__="EventTransformCategories";const u={clipboard:["copy","cut","paste"],composition:["compositionend","compositionstart","compositionupdate"],keyboard:["keydown","keypress","keyup"],mouse:["click","contextmenu","doubleclick","drag","dragend","dragenter","dragexit","dragleave","dragover","dragstart","drop","mousedown","mouseenter","mouseleave","mousemove","mouseout","mouseover","mouseup"],pointer:["pointerdown","pointermove","pointerup","pointercancel","gotpointercapture","lostpointercapture","pointerenter","pointerleave","pointerover","pointerout"],selection:["select"],touch:["touchcancel","touchend","touchmove","touchstart"],ui:["scroll"],wheel:["wheel"],animation:["animationstart","animationend","animationiteration"],transition:["transitionend"]},d={},p=new c;Object.keys(u).forEach((e=>{u[e].forEach((t=>{d[t]=p[e].bind(p)}))}))},
"4c04683fdc": function _(e,t,s,n,o){var i,r,l;n(),s.html_decode=x,s.run_scripts=y;const c=e("tslib");var a,h=this&&this.__decorate||function(e,t,s,n){var o,i=arguments.length,r=i<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)r=Reflect.decorate(e,t,s,n);else for(var l=e.length-1;l>=0;l--)(o=e[l])&&(r=(i<3?o(r):i>3?o(t,s,r):o(t,s))||r);return i>3&&r&&Object.defineProperty(t,s,r),r};const d=e("@bokehjs/core/bokeh_events"),u=e("@bokehjs/core/util/object"),_=e("@bokehjs/models/widgets/markup"),v=e("9b11ce01a3"),m=e("a572dba9cd"),p=e("a3669a897a"),f=c.__importDefault(e("8694ed3f61")),b='<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"  fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-clipboard"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" /><path d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z"/></svg>';function w(e,t){let s=[];return e instanceof Element&&e.matches(t)&&s.push(e),e.children&&Array.from(e.children).forEach((e=>{s=s.concat(w(e,t))})),e instanceof Element&&e.shadowRoot&&(s=s.concat(w(e.shadowRoot,t))),s}let g=(i=class extends d.ModelEvent{constructor(e,t,s){super(),this.model=e,this.patch=t,this.start=s,this.patch=t,this.start=s,this.origin=e}get event_values(){return{model:this.origin,patch:this.patch,start:this.start}}static from_values(e){const{model:t,patch:s,start:n}=e;return new a(t,s,n)}},a=i,i.__name__="HTMLStreamEvent",i);s.HTMLStreamEvent=g,s.HTMLStreamEvent=g=a=h([(0,d.server_event)("html_stream")],g);class M extends d.ModelEvent{constructor(e,t){super(),this.node=e,this.data=t}get event_values(){return{model:this.origin,node:this.node,data:this.data}}}function x(e){return(new DOMParser).parseFromString(e,"text/html").documentElement.textContent}function y(e){for(const t of e.querySelectorAll("script")){const e=document.createElement("script");for(const s of t.attributes)e.setAttribute(s.name,s.value);e.append(document.createTextNode(t.innerHTML));const s=t.parentNode;null!=s&&s.replaceChild(e,t)}}s.DOMEvent=M,r=M,M.__name__="DOMEvent",r.prototype.event_name="dom_event";class k extends v.PanelMarkupView{constructor(){super(...arguments),this._buffer=null,this._event_listeners=new Map}connect_signals(){super.connect_signals();const{text:e,visible:t,events:s}=this.model.properties;this.on_change(e,(()=>{this._buffer=null;const e=this.process_tex();this.set_html(e)})),this.on_change(t,(()=>{this.model.visible&&(this.container.style.visibility="visible")})),this.on_change(s,(()=>{this._remove_event_listeners(),this._setup_event_listeners()}));const n=(0,p.throttle)((()=>{const e=this._buffer;this._buffer=null,this.model.setv({text:e},{silent:!0});const t=this.process_tex();this.set_html(t)}),10);this.model.on_event(g,(e=>{const t=null==this._buffer?this.model.text:this._buffer;this._buffer=t.slice(0,e.start)+e.patch,n()}))}stylesheets(){return[...super.stylesheets(),f.default]}set_html(e){if(null!==e&&null!=this.container){this.container.innerHTML=e,this.model.run_scripts&&y(this.container),this._setup_event_listeners();for(const e of this.container.querySelectorAll(".codehilite")){const t=document.createElement("button"),s=e.children[0];t.className="copybtn",t.innerHTML=b,t.addEventListener("click",(()=>{const e=s.innerText;navigator.clipboard.writeText(e).then((()=>{t.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"  fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-check"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l5 5l10 -10"/></svg>',setTimeout((()=>{t.innerHTML=b}),300)}))})),e.insertBefore(t,s)}for(const e of this.container.querySelectorAll("a")){const t=e.getAttribute("href");t&&t.startsWith("#")&&(e.addEventListener("click",(()=>{const e=w(document.body,t);e.length>0&&e[0]instanceof Element&&e[0].scrollIntoView()})),!this.root.has_finished()&&this.model.document&&window.location.hash===t&&this.model.document.on_event("document_ready",(()=>{e.scrollIntoView(),setTimeout((()=>e.scrollIntoView()),5)})))}}}render(){super.render(),this.container.style.visibility="hidden",this.shadow_el.appendChild(this.container),"failed"!=this.provider.status&&"loaded"!=this.provider.status||(this._has_finished=!0);const e=this.process_tex();this.watch_stylesheets(),this.set_html(e)}style_redraw(){this.model.visible&&(this.container.style.visibility="visible")}process_tex(){const e=x(this.model.text)??this.model.text;if(this.model.disable_math||!this.contains_tex(e))return e;const t=this.provider.MathJax.find_tex(e),s=[];let n=0;for(const o of t)s.push(e.slice(n,o.start.n)),s.push(this.provider.MathJax.tex2svg(o.math,{display:o.display}).outerHTML),n=o.end.n;return n<e.length&&s.push(e.slice(n)),s.join("")}contains_tex(e){return!!this.provider.MathJax&&this.provider.MathJax.find_tex(e).length>0}_remove_event_listeners(){for(const[e,t]of this._event_listeners){const s=document.getElementById(e);if(null!=s)for(const[e,n]of t)s.removeEventListener(e,n);else console.warn(`DOM node '${e}' could not be found. Cannot subscribe to DOM events.`)}this._event_listeners.clear()}_setup_event_listeners(){for(const[e,t]of(0,u.entries)(this.model.events)){const s=document.getElementById(e);if(null!=s)for(const n of t){const t=t=>{this.model.trigger_event(new M(e,(0,m.serializeEvent)(t)))};s.addEventListener(n,t);let o=this._event_listeners.get(e);void 0===o&&this._event_listeners.set(e,o=new Map),o.set(n,t)}else console.warn(`DOM node '${e}' could not be found. Cannot subscribe to DOM events.`)}}}s.HTMLView=k,k.__name__="HTMLView";class E extends _.Markup{constructor(e){super(e)}}s.HTML=E,l=E,E.__name__="HTML",E.__module__="panel.models.markup",l.prototype.default_view=k,l.define((({Bool:e,Str:t,List:s,Dict:n})=>({events:[n(s(t)),{}],run_scripts:[e,!0]})))},
"8694ed3f61": function _(o,e,r,t,i){t(),r.default=".copybtn{position:sticky;display:flex;top:0;left:100%;width:1.7em;height:1.7em;opacity:0;transition:opacity 0.3s, border 0.3s, background-color 0.3s;user-select:none;padding:0;border:none;outline:none;border-radius:0.4em;border:#1b1f2426 1px solid;background-color:#f6f8fa;color:#57606a;}.codehilite pre{margin-top:-1.7em;}.copybtn svg{stroke:currentColor;width:1.5em;height:1.5em;padding:0.1em;}.codehilite:hover .copybtn{opacity:1;cursor:pointer;}"},
"727a14f76b": function _(r,e,o,d,t){d(),o.default=".error-wrapper,.child-wrapper{display:contents;}.error{padding:0.75rem 1.25rem;border:1px solid transparent;border-radius:0.25rem;color:var(--danger-text-color);background-color:var(--danger-bg-subtle);border-color:var(--danger-border-subtle);}.error .msg{font-weight:bold;}.error pre.highlight{backdrop-filter:brightness(0.8);font-weight:900;}"},
"fd59c985b3": function _(e,t,i,o,s){var l;o();const u=e("9b11ce01a3");class d extends u.HTMLBoxView{initialize(){super.initialize(),this._blocked=!1,this._setting=!1,this._time=Date.now()}connect_signals(){super.connect_signals();const{loop:e,paused:t,time:i,value:o,volume:s,muted:l,autoplay:u}=this.model.properties;this.on_change(e,(()=>this.set_loop())),this.on_change(t,(()=>this.set_paused())),this.on_change(i,(()=>this.set_time())),this.on_change(o,(()=>this.set_value())),this.on_change(s,(()=>this.set_volume())),this.on_change(l,(()=>this.set_muted())),this.on_change(u,(()=>this.set_autoplay()))}render(){super.render(),this.audioEl=document.createElement("audio"),this.audioEl.controls=!0,this.audioEl.src=this.model.value,this.audioEl.currentTime=this.model.time,this.audioEl.loop=this.model.loop,this.audioEl.muted=this.model.muted,this.audioEl.autoplay=this.model.autoplay,null!=this.model.volume?this.audioEl.volume=this.model.volume/100:this.model.volume=100*this.audioEl.volume,this.audioEl.onpause=()=>this.model.paused=!0,this.audioEl.onplay=()=>this.model.paused=!1,this.audioEl.ontimeupdate=()=>this.update_time(this),this.audioEl.onvolumechange=()=>this.update_volume(this),(0,u.set_size)(this.audioEl,this.model,!1),this.shadow_el.appendChild(this.audioEl),this.model.paused||this.audioEl.play()}update_time(e){e._setting?e._setting=!1:Date.now()-e._time<e.model.throttle||(e._blocked=!0,e.model.time=e.audioEl.currentTime,e._time=Date.now())}update_volume(e){e._setting?e._setting=!1:(e._blocked=!0,e.model.volume=100*e.audioEl.volume)}set_loop(){this.audioEl.loop=this.model.loop}set_muted(){this.audioEl.muted=this.model.muted}set_autoplay(){this.audioEl.autoplay=this.model.autoplay}set_paused(){!this.audioEl.paused&&this.model.paused&&this.audioEl.pause(),this.audioEl.paused&&!this.model.paused&&this.audioEl.play()}set_volume(){this._blocked?this._blocked=!1:(this._setting=!0,null!=this.model.volume&&(this.audioEl.volume=this.model.volume/100))}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.audioEl.currentTime=this.model.time)}set_value(){this.audioEl.src=this.model.value}}i.AudioView=d,d.__name__="AudioView";class a extends u.HTMLBox{constructor(e){super(e)}}i.Audio=a,l=a,a.__name__="Audio",a.__module__="panel.models.widgets",l.prototype.default_view=d,l.define((({Any:e,Bool:t,Float:i,Nullable:o})=>({loop:[t,!1],paused:[t,!0],muted:[t,!1],autoplay:[t,!1],time:[i,0],throttle:[i,250],value:[e,""],volume:[o(i),null]})))},
"5a16cc23e6": function _(e,o,t,n,i){var l;n();const a=e("@bokehjs/core/view"),s=e("@bokehjs/model");class d extends a.View{initialize(){if(super.initialize(),null!=window.matchMedia){const e=window.matchMedia("(prefers-color-scheme: dark)");e.addEventListener("change",(e=>{this.model.dark_mode=e.matches})),this.model.dark_mode=e.matches}this.model.device_pixel_ratio=window.devicePixelRatio,null!=navigator&&(this.model.language=navigator.language,this.model.webdriver=navigator.webdriver);const e=Intl.DateTimeFormat().resolvedOptions().timeZone;null!=e&&(this.model.timezone=e);const o=(new Date).getTimezoneOffset();null!=o&&(this.model.timezone_offset=o);try{const e=document.createElement("canvas");this.model.webgl=!(!window.WebGLRenderingContext||!e.getContext("webgl")&&!e.getContext("experimental-webgl"))}catch(e){this.model.webgl=!1}this._has_finished=!0,this.notify_finished()}}t.BrowserInfoView=d,d.__name__="BrowserInfoView";class r extends s.Model{constructor(e){super(e)}}t.BrowserInfo=r,l=r,r.__name__="BrowserInfo",r.__module__="panel.models.browser",l.prototype.default_view=d,l.define((({Bool:e,Nullable:o,Float:t,Str:n})=>({dark_mode:[o(e),null],device_pixel_ratio:[o(t),null],language:[o(n),null],timezone:[o(n),null],timezone_offset:[o(t),null],webdriver:[o(e),null],webgl:[o(e),null]})))},
"1db93211cd": function _(t,e,o,i,l){var s;i();const n=t("@bokehjs/models/ui/tooltip"),a=t("@bokehjs/core/build_views"),p=t("@bokehjs/models/widgets/button");class u extends p.ButtonView{*children(){yield*super.children(),null!=this.tooltip&&(yield this.tooltip)}connect_signals(){super.connect_signals();const{tooltip:t}=this.model.properties;this.on_change(t,(()=>this.update_tooltip()))}async update_tooltip(){null!=this.tooltip&&this.tooltip.remove();const{tooltip:t}=this.model;null!=t&&(this.tooltip=await(0,a.build_view)(t,{parent:this}))}async lazy_initialize(){await super.lazy_initialize();const{tooltip:t}=this.model;null!=t&&(this.tooltip=await(0,a.build_view)(t,{parent:this}))}remove(){this.tooltip?.remove(),super.remove()}render(){super.render();const t=t=>{this.tooltip?.model.setv({visible:t})};let e;this.el.addEventListener("mouseenter",(()=>{e=setTimeout((()=>t(!0)),this.model.tooltip_delay)})),this.el.addEventListener("mouseleave",(()=>{clearTimeout(e),t(!1)}))}}o.ButtonView=u,u.__name__="ButtonView";class d extends p.Button{constructor(t){super(t)}}o.Button=d,s=d,d.__name__="Button",d.__module__="panel.models.widgets",s.prototype.default_view=u,s.define((({Nullable:t,Ref:e,Float:o})=>({tooltip:[t(e(n.Tooltip)),null],tooltip_delay:[o,500]})))},
"1738ddeb3a": function _(e,t,o,n,i){var l;n();const s=e("6c7fbea0ef");class c extends s.ClickableIconView{*controls(){}update_cursor(){this.icon_view.el.style.cursor=this.model.disabled?"default":"pointer"}click(){if(this.model.disabled)return;super.click();const e=(e,t)=>{this.model.value=e,this.model.disabled=t};e(!0,!0),new Promise((e=>setTimeout(e,this.model.toggle_duration))).then((()=>{e(!1,!1)}))}}o.ButtonIconView=c,c.__name__="ButtonIconView";class d extends s.ClickableIcon{constructor(e){super(e)}}o.ButtonIcon=d,l=d,d.__name__="ButtonIcon",d.__module__="panel.models.icon",l.prototype.default_view=c,l.define((({Int:e})=>({toggle_duration:[e,75]})))},
"6c7fbea0ef": function _(i,e,t,o,s){var l;o();const n=i("@bokehjs/models/ui/tooltip"),c=i("@bokehjs/models/ui/icons/tabler_icon"),a=i("@bokehjs/models/ui/icons/svg_icon"),h=i("@bokehjs/models/widgets/control"),_=i("@bokehjs/core/dom"),d=i("@bokehjs/core/build_views"),r=i("@bokehjs/core/bokeh_events");class u extends h.ControlView{*controls(){}remove(){this.tooltip?.remove(),this.icon_view.remove(),super.remove()}async lazy_initialize(){await super.lazy_initialize(),this.was_svg_icon=this.is_svg_icon(this.model.icon),this.label_el=(0,_.div)({class:"bk-IconLabel"},this.model.title),this.label_el.style.fontSize=this.calculate_size(.6),this.icon_view=await this.build_icon_model(this.model.icon,this.was_svg_icon);const{tooltip:i}=this.model;null!=i&&(this.tooltip=await(0,d.build_view)(i,{parent:this}))}*children(){yield*super.children(),yield this.icon_view,null!=this.tooltip&&(yield this.tooltip)}is_svg_icon(i){return i.trim().startsWith("<svg")}connect_signals(){super.connect_signals();const{icon:i,active_icon:e,disabled:t,value:o,size:s,tooltip:l}=this.model.properties;this.on_change([e,i,o],(()=>this.update_icon())),this.on_change(this.model.properties.title,(()=>this.update_label())),this.on_change(t,(()=>this.update_cursor())),this.on_change(s,(()=>this.update_size())),this.on_change(l,(()=>this.update_tooltip()))}async update_tooltip(){null!=this.tooltip&&this.tooltip.remove();const{tooltip:i}=this.model;null!=i&&(this.tooltip=await(0,d.build_view)(i,{parent:this}))}render(){super.render(),this.icon_view.render(),this.update_icon(),this.update_label(),this.update_cursor(),this.row_div=(0,_.div)({class:"bk-IconRow"},this.icon_view.el,this.label_el),this.shadow_el.appendChild(this.row_div);const i=i=>{this.tooltip?.model.setv({visible:i})};let e;this.el.addEventListener("mouseenter",(()=>{e&&clearTimeout(e),e=setTimeout((()=>i(!0)),this.model.tooltip_delay)})),this.el.addEventListener("pointerleave",(()=>{clearTimeout(e),e=void 0,i(!1)}))}update_label(){this.label_el.innerText=this.model.title}update_cursor(){this.icon_view.el.style.cursor=this.model.disabled?"not-allowed":"pointer"}update_size(){this.icon_view.model.size=this.calculate_size(),this.label_el.style.fontSize=this.calculate_size(.6)}async build_icon_model(i,e){const t=this.calculate_size(),o=e?new a.SVGIcon({svg:i,size:t}):new c.TablerIcon({icon_name:i,size:t}),s=await(0,d.build_view)(o,{parent:this});return s.el.addEventListener("click",(()=>this.click())),s}async update_icon(){const i=this.model.value?this.get_active_icon():this.model.icon;this.class_list.toggle("active",this.model.value);const e=this.is_svg_icon(i);if(this.was_svg_icon!==e){const t=await this.build_icon_model(i,e);t.render(),this.icon_view.remove(),this.icon_view=t,this.was_svg_icon=e,this.update_cursor(),this.row_div.insertBefore(this.icon_view.el,this.label_el)}else e?this.icon_view.model.svg=i:this.icon_view.model.icon_name=i;this.icon_view.el.style.lineHeight="0"}get_active_icon(){return""!==this.model.active_icon?this.model.active_icon:`${this.model.icon}-filled`}calculate_size(i=1){if(null!==this.model.size)return`calc(${this.model.size} * ${i})`;const e=this.model.width??15,t=this.model.height??15;return`${Math.max(e,t)*i}px`}click(){this.model.trigger_event(new r.ButtonClick)}}t.ClickableIconView=u,u.__name__="ClickableIconView";class v extends h.Control{constructor(i){super(i)}on_click(i){this.on_event(r.ButtonClick,i)}}t.ClickableIcon=v,l=v,v.__name__="ClickableIcon",v.__module__="panel.models.icon",l.prototype.default_view=u,l.define((({Nullable:i,Ref:e,Float:t,Str:o,Bool:s})=>({active_icon:[o,""],icon:[o,"heart"],size:[i(o),null],value:[s,!1],title:[o,""],tooltip:[i(e(n.Tooltip)),null],tooltip_delay:[t,500]})))},
"d7035097d8": function _(e,t,s,l,o){var i;l();const a=e("tslib"),n=a.__importStar(e("@bokehjs/core/dom")),d=e("@bokehjs/core/layout/grid"),h=e("@bokehjs/models/layouts/alignments"),r=e("@bokehjs/models/layouts/layout_dom"),c=e("b273e5b2fb"),_=a.__importDefault(e("6342ac8e26")),u='\n<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-chevron-right"><path stroke="none" d="M0 0h12v12H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>\n',p='\n<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="icon icon-tabler icons-tabler-outline icon-tabler-chevron-down"><path stroke="none" d="M0 0h12v12H0z" fill="none"/><path d="M6 9l6 6l6 -6" /></svg>\n';class g extends c.ColumnView{constructor(){super(...arguments),this.collapsed_style=new n.InlineStyleSheet}connect_signals(){super.connect_signals();const{active_header_background:e,collapsed:t,header_background:s,header_color:l,hide_header:o}=this.model.properties;this.on_change(t,(()=>this._collapse())),this.on_change([l,o],(()=>this.render())),this.on_change([e,t,s],(()=>{const e=this.header_background;null!=e&&(this.child_views[0].el.style.backgroundColor=e,this.header_el.style.backgroundColor=e)}))}stylesheets(){return[...super.stylesheets(),_.default]}*_stylesheets(){yield*super._stylesheets(),yield this.collapsed_style}get header_background(){let e=this.model.header_background;return!this.model.collapsed&&this.model.active_header_background&&(e=this.model.active_header_background),e}render(){this.empty(),this.model.collapsed&&this.collapsed_style.replace(":host",{height:"fit-content",flex:"none"}),this._update_stylesheets(),this._update_css_classes(),this._apply_styles(),this._apply_visible(),this.class_list.add(...this.css_classes());const{button_css_classes:e,header_color:t,header_tag:s,header_css_classes:l}=this.model,o=this.header_background,i=this.child_views[0];let a;if(this.model.collapsible){this.button_el=n.button({class:l});const t=n.div({class:e});t.innerHTML=this.model.collapsed?u:p,this.button_el.appendChild(t),this.button_el.style.backgroundColor=null!=o?o:"",i.el.style.backgroundColor=null!=o?o:"",this.button_el.appendChild(i.el),this.button_el.addEventListener("click",(e=>this._toggle_button(e))),a=this.button_el}else a=n.create_element(s,{class:l}),a.style.backgroundColor=null!=o?o:"",a.appendChild(i.el);if(this.header_el=a,this.model.hide_header||(a.style.color=null!=t?t:"",this.shadow_el.appendChild(a),i.render(),i.r_after_render()),!this.model.collapsed)for(const e of this.child_views.slice(1))this.shadow_el.appendChild(e.el),e.render(),e.r_after_render()}async update_children(){await this.build_child_views(),this.render(),this.invalidate_layout()}_update_layout(){super._update_layout(),this.style.append(":host",{flex_direction:this._direction,gap:n.px(this.model.spacing)});const e=new d.Container;let t=0,s=0;for(let l=0;l<this.child_views.length;l++){const o=this.child_views[l];if(!(o instanceof r.LayoutDOMView))continue;const i=0==l,a=o.box_sizing(),d=(()=>{const e=i?a.width_policy:a.height_policy,t=i?a.width:a.height,s=null!=t?n.px(t):"auto";switch(e){case"auto":case"fixed":return`0 0 ${s}`;case"fit":return"1 1 auto";case"min":return"0 1 auto";case"max":return"1 0 0px"}})(),h=(()=>{switch(i?a.height_policy:a.width_policy){case"auto":case"fixed":case"fit":case"min":return i?a.valign:a.halign;case"max":return"stretch"}})();o.parent_style.append(":host",{flex:d,align_self:h}),i?"max"==a.height_policy&&o.parent_style.append(":host",{height:"auto"}):"max"==a.width_policy&&o.parent_style.append(":host",{width:"auto"}),null!=o.layout&&(e.add({r0:t,c0:s,r1:t+1,c1:s+1},o),i?s+=1:t+=1)}0!=e.size?(this.layout=new h.GridAlignmentLayout(e),this.layout.set_sizing()):delete this.layout}_toggle_button(e){for(const t of e.composedPath())if(t instanceof HTMLInputElement)return;this.model.collapsed=!this.model.collapsed}_collapse(){for(const e of this.child_views.slice(1))this.model.collapsed?(this.shadow_el.removeChild(e.el),e.model.visible=!1):(e.render(),e.after_render(),this.shadow_el.appendChild(e.el),e.model.visible=!0);this.model.collapsed?this.collapsed_style.replace(":host",{height:"fit-content",flex:"none"}):this.collapsed_style.clear(),this.button_el.children[0].innerHTML=this.model.collapsed?u:p,this.invalidate_layout()}_create_element(){return n.create_element(this.model.tag,{class:this.css_classes()})}}s.CardView=g,g.__name__="CardView";class y extends c.Column{constructor(e){super(e)}}s.Card=y,i=y,y.__name__="Card",y.__module__="panel.models.layout",i.prototype.default_view=g,i.define((({List:e,Bool:t,Nullable:s,Str:l})=>({active_header_background:[s(l),null],button_css_classes:[e(l),[]],collapsed:[t,!0],collapsible:[t,!0],header_background:[s(l),null],header_color:[s(l),null],header_css_classes:[e(l),[]],header_tag:[l,"div"],hide_header:[t,!1],tag:[l,"div"]})))},
"b273e5b2fb": function _(t,e,o,l,s){var i,n,r;l();var _,c=this&&this.__decorate||function(t,e,o,l){var s,i=arguments.length,n=i<3?e:null===l?l=Object.getOwnPropertyDescriptor(e,o):l;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)n=Reflect.decorate(t,e,o,l);else for(var r=t.length-1;r>=0;r--)(s=t[r])&&(n=(i<3?s(n):i>3?s(e,o,n):s(e,o))||n);return i>3&&n&&Object.defineProperty(e,o,n),n};const h=t("@bokehjs/core/bokeh_events"),d=t("@bokehjs/core/dom"),a=t("@bokehjs/models/layouts/column"),u=t("@bokehjs/models/layouts/layout_dom");class p extends h.ModelEvent{}o.ScrollButtonClick=p,i=p,p.__name__="ScrollButtonClick",i.prototype.event_name="scroll_button_click";let m=(n=class extends h.ModelEvent{constructor(t,e){super(),this.model=t,this.index=e,this.index=e,this.origin=t}get event_values(){return{model:this.origin,index:this.index}}static from_values(t){const{model:e,index:o}=t;return new _(e,o)}},_=n,n.__name__="ScrollToEvent",n);o.ScrollToEvent=m,o.ScrollToEvent=m=_=c([(0,h.server_event)("scroll_to")],m);class g extends a.ColumnView{constructor(){super(...arguments),this._updating=!1}connect_signals(){super.connect_signals();const{children:t,scroll_position:e,scroll_button_threshold:o}=this.model.properties;this.on_change(t,(()=>this.trigger_auto_scroll())),this.on_change(e,(()=>this.scroll_to_position())),this.on_change(o,(()=>this.toggle_scroll_button())),this.model.on_event(m,(t=>this.scroll_to_index(t.index)))}get distance_from_latest(){return this.el.scrollHeight-this.el.scrollTop-this.el.clientHeight}scroll_to_index(t){if(null===t)return;if(t>=this.model.children.length)return void console.warn(`Invalid scroll index: ${t}`);const e=this.child_views[t];if(!e)return void console.warn(`Child view not found for index: ${t}`);const o=e.el.getBoundingClientRect(),l=this.el.getBoundingClientRect(),s=o.top-l.top+this.el.scrollTop;this.model.scroll_position=Math.round(s)}scroll_to_position(){this._updating||requestAnimationFrame((()=>{this.el.scrollTo({top:this.model.scroll_position,behavior:"instant"})}))}scroll_to_latest(t=null){if(null!==t){if(!(this.distance_from_latest<=t))return}requestAnimationFrame((()=>{this.model.scroll_position=Math.round(this.el.scrollHeight)}))}trigger_auto_scroll(){const t=this.model.auto_scroll_limit;if(0==t)return;this.distance_from_latest<=t&&this.scroll_to_latest()}record_scroll_position(){this._updating=!0,this.model.scroll_position=Math.round(this.el.scrollTop),this._updating=!1}toggle_scroll_button(){const t=this.model.scroll_button_threshold;if(!this.scroll_down_button_el||0===t)return;const e=this.distance_from_latest>=t;this.scroll_down_button_el.classList.toggle("visible",e)}_update_layout(){super._update_layout();const t=this.model.css_classes.some((t=>["scroll","scrollable","scrollable-vertical"].includes(t)));for(const e of this.child_views)e instanceof u.LayoutDOMView&&t&&e.parent_style.append(":host",{maxHeight:"none"})}render(){super.render(),this.scroll_down_button_el=(0,d.div)({class:"scroll-button"}),this.shadow_el.appendChild(this.scroll_down_button_el),this.el.addEventListener("scroll",(()=>{this.record_scroll_position(),this.toggle_scroll_button()})),this.scroll_down_button_el.addEventListener("click",(()=>{this.scroll_to_latest(),this.model.trigger_event(new p)}))}async update_children(){const t=await this.build_child_views(),e=new Set(t),o=Array.from(this.shadow_el.children).flatMap((t=>{const e=this.child_views.find((e=>e.el===t));return void 0===e?[]:[e]}));let l=null;for(let t=0;t<o.length&&o[t]===this.child_views[t];t++)l=t;for(let t=0;t<this.child_views.length;t++){const o=this.child_views[t],s=e.has(o),i=o.rendering_target()??this.self_target??this.shadow_el;s?o.render_to(i):(null===l||t>l)&&i.append(o.el)}this.r_after_render(),this._update_children(),this.invalidate_layout()}after_render(){super.after_render(),requestAnimationFrame((()=>{this.model.scroll_position&&this.scroll_to_position(),this.model.view_latest&&this.scroll_to_latest(),this.toggle_scroll_button()}))}}o.ColumnView=g,g.__name__="ColumnView";class v extends a.Column{constructor(t){super(t)}on_click(t){this.on_event(p,t)}}o.Column=v,r=v,v.__name__="Column",v.__module__="panel.models.layout",r.prototype.default_view=g,r.define((({Int:t,Bool:e,Nullable:o})=>({auto_scroll_limit:[t,0],scroll_button_threshold:[t,0],scroll_index:[o(t),null],scroll_position:[t,0],view_latest:[e,!1]})))},
"6342ac8e26": function _(r,e,o,t,a){t(),o.default=":host(.card){border-radius:0.25rem;box-shadow:rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;outline:1px solid rgba(0, 0, 0, 0.125);}:host(.accordion){box-shadow:rgba(50, 50, 93, 0.25) 0px 6px 12px -2px, rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;outline:1px solid rgba(0, 0, 0, 0.125);width:100%;}.card-header{align-items:center;background-color:rgba(0, 0, 0, 0.03);border:unset;border-radius:0.25rem;display:inline-flex;justify-content:start;outline:unset;position:sticky;width:100%;margin-right:0.5em;padding-inline:0.5em;cursor:pointer;}.card-header:hover{box-shadow:0 0 3px rgba(0, 0, 0, 0.3);}.card-header:not(:hover){box-shadow:0 0 3px rgba(0, 0, 0, 0);}.accordion-header{align-items:center;background-color:rgba(0, 0, 0, 0.03);border:unset;outline:1px solid;border-radius:0;display:flex;justify-content:start;position:sticky;width:100%;cursor:pointer;}.card-button{background-color:transparent;margin-left:0em;margin-right:0.25em;height:12px;width:12px;}.card-header-row{position:relative !important;}.card-title{align-items:center;font-size:1.4em;font-weight:bold;overflow-wrap:break-word;}.card-header-row > .bk{overflow-wrap:break-word;text-align:center;}"},
"51fbe9e2d0": function _(t,e,o,i,l){var s;i();const n=t("@bokehjs/models/ui/tooltip"),p=t("@bokehjs/core/build_views"),u=t("@bokehjs/models/widgets/checkbox_button_group");class r extends u.CheckboxButtonGroupView{*children(){yield*super.children(),null!=this.tooltip&&(yield this.tooltip)}connect_signals(){super.connect_signals();const{tooltip:t}=this.model.properties;this.on_change(t,(()=>this.update_tooltip()))}async update_tooltip(){null!=this.tooltip&&this.tooltip.remove();const{tooltip:t}=this.model;null!=t&&(this.tooltip=await(0,p.build_view)(t,{parent:this}))}async lazy_initialize(){await super.lazy_initialize();const{tooltip:t}=this.model;null!=t&&(this.tooltip=await(0,p.build_view)(t,{parent:this}))}remove(){this.tooltip?.remove(),super.remove()}render(){super.render();const t=t=>{this.tooltip?.model.setv({visible:t})};let e;this.el.addEventListener("mouseenter",(()=>{e=setTimeout((()=>t(!0)),this.model.tooltip_delay)})),this.el.addEventListener("mouseleave",(()=>{clearTimeout(e),t(!1)}))}}o.CheckboxButtonGroupView=r,r.__name__="CheckboxButtonGroupView";class a extends u.CheckboxButtonGroup{constructor(t){super(t)}}o.CheckboxButtonGroup=a,s=a,a.__name__="CheckboxButtonGroup",a.__module__="panel.models.widgets",s.prototype.default_view=r,s.define((({Nullable:t,Ref:e,Float:o})=>({tooltip:[t(e(n.Tooltip)),null],tooltip_delay:[o,500]})))},
"27a077673d": function _(e,t,n,s,a){var r,_;s();const i=e("b7d595d74a"),l=e("@bokehjs/core/bokeh_events");class o extends l.ModelEvent{constructor(e){super(),this.value=e}get event_values(){return{model:this.origin,value:this.value}}}n.ChatMessageEvent=o,r=o,o.__name__="ChatMessageEvent",r.prototype.event_name="chat_message_event";class d extends i.TextAreaInputView{connect_signals(){super.connect_signals();const{value_input:e}=this.model.properties;this.on_change(e,(()=>this.update_rows()))}render(){super.render(),this.el.addEventListener("keydown",(e=>{"Enter"===e.key&&(e.shiftKey||e.ctrlKey==this.model.enter_sends?e.ctrlKey&&this.model.enter_sends&&(this.model.value_input+="\n",e.preventDefault()):(this.model.disabled_enter||(this.model.trigger_event(new o(this.model.value_input)),this.model.value_input=""),e.preventDefault()))}))}}n.ChatAreaInputView=d,d.__name__="ChatAreaInputView";class u extends i.TextAreaInput{constructor(e){super(e)}}n.ChatAreaInput=u,_=u,u.__name__="ChatAreaInput",u.__module__="panel.models.chatarea_input",_.prototype.default_view=d,_.define((({Bool:e})=>({disabled_enter:[e,!1],enter_sends:[e,!0]})))},
"b7d595d74a": function _(e,t,s,n,o){var a;n();const r=e("@bokehjs/models/widgets/textarea_input");class i extends r.TextAreaInputView{connect_signals(){super.connect_signals();const{value:e,max_rows:t}=this.model.properties;this.on_change([t,e],(()=>this.update_rows()))}update_rows(){if(!this.model.auto_grow)return;const e=this.input_el,t=e.value.split("\n"),s=Math.max(t.length,this.model.rows,1);e.rows=Math.min(s,this.model.max_rows||1/0)}render(){super.render(),this.update_rows(),this.el.addEventListener("input",(()=>{this.update_rows()}))}}s.TextAreaInputView=i,i.__name__="TextAreaInputView";class _ extends r.TextAreaInput{constructor(e){super(e)}}s.TextAreaInput=_,a=_,_.__name__="TextAreaInput",_.__module__="panel.models.widgets",a.prototype.default_view=i,a.define((({Bool:e,Int:t,Nullable:s})=>({auto_grow:[e,!1],max_rows:[s(t),null]})))},
"1bec1b1fcc": function _(e,t,s,n,o){var i;n();const c=e("@bokehjs/document"),_=e("@bokehjs/core/view"),h=e("@bokehjs/model"),l=e("@bokehjs/protocol/message"),r=e("@bokehjs/protocol/receiver"),a=e("@bokehjs/core/serialization/buffer"),d=e("@bokehjs/core/util/types"),m=e("@bokehjs/core/util/object");s.comm_settings={debounce:!0};class u extends _.View{}s.CommManagerView=u,u.__name__="CommManagerView";class f extends h.Model{constructor(e){super(e),this._document_listener=e=>this._document_changed(e)}initialize(){super.initialize(),this._receiver=new r.Receiver,this._event_buffer=[],this._blocked=!1,this._reconnect=!1,this._timeout=Date.now(),null!=window.PyViz&&window.PyViz.comm_manager?(this.ns=window.PyViz,this.ns.comm_manager.register_target(this.plot_id,this.comm_id,(e=>{for(const t of this.ns.shared_views.get(this.plot_id))t!==this&&t.msg_handler(e);try{this.msg_handler(e)}catch(e){console.error(e)}})),this._client_comm=this.ns.comm_manager.get_client_comm(this.plot_id,this.client_comm_id,(e=>this.on_ack(e))),this._reconnect=!this._client_comm?.active||!1,null==this.ns.shared_views&&(this.ns.shared_views=new Map),this.ns.shared_views.has(this.plot_id)?this.ns.shared_views.get(this.plot_id).push(this):this.ns.shared_views.set(this.plot_id,[this])):console.warn("Could not find comm manager on window.PyViz, ensure the extension is loaded.")}_doc_attached(){super._doc_attached(),null!=this.document&&this.document.on_change(this._document_listener)}_document_changed(e){e instanceof c.ModelChangedEvent&&!e.model.properties[e.attr].syncable||(this._event_buffer.push(e),this._reconnect&&this._client_comm?.connected?this.on_ack({metadata:{msg_type:"Ready"}}):s.comm_settings.debounce?(!this._blocked||Date.now()>this._timeout)&&(setTimeout((()=>this.process_events()),this.debounce),this._blocked=!0,this._timeout=Date.now()+this.timeout):this.process_events())}_extract_buffers(e,t){if((0,d.isArray)(e))for(const s of e)this._extract_buffers(s,t);else if(e instanceof Map)for(const s of e.keys()){const n=e.get(s);this._extract_buffers(n,t)}else{if(e instanceof a.Buffer){const{buffer:s}=e,n=t.length;return t.push(s),{id:n}}if((0,d.isPlainObject)(e))for(const s of(0,m.keys)(e)){const n=this._extract_buffers(e[s],t);null!=n&&(e[s]=n)}}}process_events(){if(null==this.document||null==this._client_comm)return;const e=this.document.create_json_patch(this._event_buffer);this._event_buffer=[];const t={...l.Message.create("PATCH-DOC",{},e)},s=[];this._extract_buffers(t.content,s),this._client_comm.send(t,{},s);for(const t of this.ns.shared_views.get(this.plot_id))t!==this&&null!=t.document&&t.document.apply_json_patch(e,[],this.id)}disconnect_signals(){super.disconnect_signals(),this.ns.shared_views.shared_views.delete(this.plot_id)}on_ack(e){const t=e.metadata;this._event_buffer.length>0?(this._blocked=!0,this._timeout=Date.now()+this.timeout,this.process_events()):this._blocked=!1,"Ready"==t.msg_type&&t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.warn("Python failed with the following traceback:",t.traceback)}msg_handler(e){const t=e.metadata,s=e.buffers,n=e.content.data,o=this.plot_id;if("Ready"==t.msg_type)t.content?console.log("Python callback returned following output:",t.content):"Error"==t.msg_type&&console.warn("Python failed with the following traceback:",t.traceback);else if(null!=o){let e=null;if(o in this.ns.plot_index&&null!=this.ns.plot_index[o]?e=this.ns.plot_index[o]:void 0!==window.Bokeh&&o in window.Bokeh.index&&(e=window.Bokeh.index[o]),null==e)return;if(n.length)this._receiver.consume(n);else{if(!(null!=s&&s.length>0))return;this._receiver.consume(s[0].buffer)}const t=this._receiver.message;if(null!=t&&Object.keys(t.content).length>0&&null!=this.document){const e=t.content;this.document.apply_json_patch(e,t.buffers)}}}}s.CommManager=f,i=f,f.__name__="CommManager",f.__module__="panel.models.comm_manager",i.prototype.default_view=u,i.define((({Int:e,Str:t,Nullable:s})=>({plot_id:[s(t),null],comm_id:[s(t),null],client_comm_id:[s(t),null],timeout:[e,5e3],debounce:[e,50]})))},
"92bbd30bd1": function _(e,t,s,o,i){var n;o();const l=e("@bokehjs/models/widgets/select");class d extends l.SelectView{connect_signals(){super.connect_signals();const{disabled_options:e}=this.model.properties;this.on_change(e,(()=>this._update_disabled_options()))}options_el(){const e=super.options_el(),{disabled_options:t}=this.model;return e.forEach((e=>{e instanceof HTMLOptionElement&&t.includes(e.value)&&e.setAttribute("disabled","true")})),e}_update_disabled_options(){for(const e of this.input_el.options)this.model.disabled_options.includes(e.value)?e.setAttribute("disabled","true"):e.removeAttribute("disabled")}}s.CustomSelectView=d,d.__name__="CustomSelectView";class _ extends l.Select{constructor(e){super(e)}}s.CustomSelect=_,n=_,_.__name__="CustomSelect",_.__module__="panel.models.widgets",n.prototype.default_view=d,n.define((({List:e,Str:t})=>({disabled_options:[e(t),[]]})))},
"27b5580835": function _(e,t,l,o,s){var n,i;o();const c=e("@bokehjs/models/widgets/multiselect"),r=e("@bokehjs/core/bokeh_events");class u extends r.ModelEvent{constructor(e){super(),this.option=e}get event_values(){return{model:this.origin,option:this.option}}}l.DoubleClickEvent=u,n=u,u.__name__="DoubleClickEvent",n.prototype.event_name="dblclick_event";class _ extends c.MultiSelectView{render(){super.render();for(const e of this.input_el.children)e.addEventListener("dblclick",(e=>{e.target&&this.model.trigger_event(new u(e.target.value))}))}}l.CustomMultiSelectView=_,_.__name__="CustomMultiSelectView";class d extends c.MultiSelect{constructor(e){super(e)}}l.CustomMultiSelect=d,i=d,d.__name__="CustomMultiSelect",d.__module__="panel.models.widgets",i.prototype.default_view=_},
"53b5147b3d": function _(t,e,i,s,o){var l,n,a,r;s();const d=t("tslib"),h=t("@bokehjs/core/dom"),c=t("@bokehjs/core/util/arrayable"),u=t("@bokehjs/core/util/types"),_=t("@bokehjs/core/bokeh_events"),g=t("@bokehjs/core/dom"),m=t("@bokehjs/core/kinds"),p=t("@bokehjs/models/sources/column_data_source"),f=t("@bokehjs/models/widgets/tables"),b=t("99a25e6992"),w=t("1bec1b1fcc"),y=t("be689f0377"),x=t("9b11ce01a3"),v=t("a3669a897a"),z=d.__importDefault(t("cb7ce3ba00"));class S extends _.ModelEvent{constructor(t,e,i){super(),this.column=t,this.row=e,this.pre=i}get event_values(){return{model:this.origin,column:this.column,row:this.row,pre:this.pre}}}i.TableEditEvent=S,l=S,S.__name__="TableEditEvent",l.prototype.event_name="table-edit";class M extends _.ModelEvent{constructor(t,e){super(),this.column=t,this.row=e}get event_values(){return{model:this.origin,column:this.column,row:this.row}}}i.CellClickEvent=M,n=M,M.__name__="CellClickEvent",n.prototype.event_name="cell-click";class T extends _.ModelEvent{constructor(t,e,i=!1){super(),this.indices=t,this.selected=e,this.flush=i}get event_values(){return{model:this.origin,indices:this.indices,selected:this.selected,flush:this.flush}}}function C(t,e,i){for(const s of i)if(s[t]==e)return s;return null}function E(t,e,i,s=0){const o={};if(0==t.length)return o;let l="";s>0&&(l=i[s-1]);for(const n of t){const t=E(n._children,e,i,s+1);for(const e in t)(0,u.isArray)(t[e])?n[e]=(0,c.sum)(t[e])/t[e].length:n[e]=t[e];for(const t of e.slice(1)){let e="";"string"==typeof l?e=l:t.field in l&&(e=l[t.field]);const i=n[t.field];if(t.field in o){const s=o[t.field];"min"===e?o[t.field]=i<s?i:s:"max"===e?o[t.field]=i>s?i:s:"sum"===e?o[t.field]=i+s:"mean"===e&&((0,u.isArray)(o[t.field])?o[t.field].push(i):o[t.field]=[s,i])}else o[t.field]=i}}return o}function D(t,e,i,s){const o=[],l=e[0].field;for(const s of t){const t=s[i[0]];let n=C(l,t,o);null==n&&(n={_children:[]},n[l]=t,o.push(n));let a=n;for(const t of i.slice(1)){a=C(l,s[t],a._children),null==a&&(a={_children:[]},a[l]=s[t],n._children.push(a));for(const t of e.slice(1))a[t.field]=s[t];n=a}for(const t of e.slice(1))a[t.field]=s[t.field]}const n=[];for(const t of i)t in s?s[t]instanceof Map?n.push(Object.fromEntries(s[t])):n.push(s[t]):n.push("sum");return E(o,e,n),o}i.SelectionEvent=T,a=T,T.__name__="SelectionEvent",a.prototype.event_name="selection-change";const k=function(t,e,i,s,o,l,n){let a;a=0;const r={zone:new window.luxon.IANAZone("UTC")};if(t=Number.isNaN(t)?window.luxon.DateTime.fromISO("invalid"):window.luxon.DateTime.fromMillis(t,r),e=Number.isNaN(e)?window.luxon.DateTime.fromISO("invalid"):window.luxon.DateTime.fromMillis(e,r),t.isValid){if(e.isValid)return t-e;a=1}else a=e.isValid?-1:0;return a*=-1,a},P=function(t,e,i,s){const o=t.getValue(),l={zone:new window.luxon.IANAZone("UTC")};let n;n="NaN"===o||null===o?null:window.luxon.DateTime.fromMillis(o,l).toFormat("yyyy-MM-dd");const a=document.createElement("input");function r(){const t=window.luxon.DateTime.fromFormat(a.value,"yyyy-MM-dd",l).toMillis();t!=n?i(t):s()}return a.setAttribute("type","date"),a.style.padding="4px",a.style.width="100%",a.style.boxSizing="border-box",a.value=n,e((()=>{a.focus(),a.style.height="100%"})),a.addEventListener("blur",r),a.addEventListener("keydown",(t=>{"Enter"==t.key&&setTimeout(r,100),"Escape"==t.key&&setTimeout(s,100)})),a},L=function(t,e,i,s){const o=t.getValue(),l={zone:new window.luxon.IANAZone("UTC")};let n;n="NaN"===o||null===o?null:window.luxon.DateTime.fromMillis(o,l).toFormat("yyyy-MM-dd'T'T");const a=document.createElement("input");function r(){const t=window.luxon.DateTime.fromFormat(a.value,"yyyy-MM-dd'T'T",l).toMillis();t!=n?i(t):s()}return a.setAttribute("type","datetime-local"),a.style.padding="4px",a.style.width="100%",a.style.boxSizing="border-box",a.value=n,e((()=>{a.focus(),a.style.height="100%"})),a.addEventListener("blur",r),a.addEventListener("keydown",(t=>{"Enter"==t.key&&setTimeout(r,100),"Escape"==t.key&&setTimeout(s,100)})),a},R=function(t,e){const i=t.getRow().getData();let s=e.options;for(const t of e.lookup_order)if(s=i[t]in s?s[i[t]]:[],Array.isArray(s))break;return s||[]};function N(t,e){if(null==t.columns)return t.field===e?t:null;for(const i of t.columns){const t=N(i,e);if(t)return t}}function V(t){if(null==t.columns)return{...t};const e=[];for(const i of t.columns)e.push(V(i));return{...t,columns:e}}class F extends x.HTMLBoxView{constructor(){super(...arguments),this.columns=new Map,this.container=null,this._tabulator_cell_updating=!1,this._updating_page=!1,this._updating_expanded=!1,this._updating_sort=!1,this._updating_page_size=!1,this._selection_updating=!1,this._last_selected_row=null,this._lastVerticalScrollbarTopPosition=0,this._lastHorizontalScrollbarLeftPosition=0,this._applied_styles=!1,this._building=!1,this._redrawing=!1,this._debounced_redraw=null,this._restore_scroll=!1,this._updating_scroll=!1,this._is_scrolling=!1,this._automatic_page_size=!1}connect_signals(){super.connect_signals(),this._debounced_redraw=(0,b.debounce)((()=>this._resize_redraw()),20,!1);const{configuration:t,layout:e,columns:i,groupby:s,visible:o,download:l,children:n,expanded:a,cell_styles:r,hidden_columns:d,page_size:h,page:c,max_page:u,frozen_rows:_,sorters:g,theme_classes:m}=this.model.properties;this.on_change([t,e,s],(0,b.debounce)((()=>{this.invalidate_render()}),20,!1)),this.on_change(o,(()=>{this.model.visible&&(this.tabulator.element.style.visibility="visible")})),this.on_change(i,(()=>{this.tabulator.setColumns(this.getColumns()),this.setHidden()})),this.on_change(l,(()=>{const t=this.model.filename.endsWith(".json")?"json":"csv";this.tabulator.download(t,this.model.filename)})),this.on_change(n,(()=>this.renderChildren())),this.on_change(a,(()=>{for(const t of this.tabulator.rowManager.getRows())t.cells.length>0&&t.cells[0].layoutElement();for(const t of this.tabulator.rowManager.getRows())if(t.cells.length>0){const e=t.data._index,i=this.model.expanded.includes(e)?"\u25bc":"\u25ba";t.cells[1].element.innerText=i}this.model.embed_content&&!this._updating_expanded&&this.renderChildren()})),this.on_change(r,(()=>{this._applied_styles&&this.tabulator.redraw(!0),this.setStyles()})),this.on_change(d,(()=>{this.setHidden(),this.tabulator.redraw(!0)})),this.on_change(h,(()=>this.setPageSize())),this.on_change(c,(()=>{this._updating_page||this.setPage()})),this.on_change(o,(()=>this.setVisibility())),this.on_change(u,(()=>this.setMaxPage())),this.on_change(_,(()=>this.setFrozen())),this.on_change(g,(()=>this.setSorters())),this.on_change(m,(()=>this.setCSSClasses(this.tabulator.element))),this.on_change(this.model.source.properties.data,(()=>{void 0!==this.tabulator&&(this._restore_scroll="horizontal",this._selection_updating=!0,this._updating_scroll=!0,this.setData(),this._updating_scroll=!1,this._selection_updating=!1,this.postUpdate())})),this.connect(this.model.source.streaming,(()=>this.addData())),this.connect(this.model.source.patching,(()=>{const t=this.model.source.selected.indices;this._updating_scroll=!0,this.updateOrAddData(),this._updating_scroll=!1,this.model.source.selected.indices=t,this.restore_scroll()})),this.connect(this.model.source.selected.change,(()=>this.setSelection())),this.connect(this.model.source.selected.properties.indices.change,(()=>this.setSelection()))}get groupBy(){return this.model.groupby.length>0&&(t=>{const e=[];for(const i of this.model.groupby){const s=`${i}: ${t[i]}`;e.push(s)}return e.join(", ")})}get sorters(){const t=[];this.model.sorters.length>0&&t.push({column:"_index",dir:"asc"});for(const e of this.model.sorters.reverse())void 0===e.column&&(e.column=e.field),t.push(e);return t}invalidate_render(){this.tabulator.destroy(),this.tabulator=null,this.rerender_()}redraw(t=!0,e=!0){this._building||null==this.tabulator||this._redrawing||(this._redrawing=!0,t&&null!=this.tabulator.columnManager.element&&this.tabulator.columnManager.redraw(!0),e&&null!=this.tabulator.rowManager.renderer&&(this.tabulator.rowManager.redraw(!0),this.setStyles()),this._redrawing=!1,this._restore_scroll=!0)}get is_drawing(){return this._building||this._redrawing||!this.root.has_finished()}after_layout(){super.after_layout(),null!=this.tabulator&&this._initializing&&!this.is_drawing&&(this._initializing=!1,this._resize_redraw())}after_resize(){super.after_resize(),this._is_scrolling||this._initializing||this.is_drawing||this._debounced_redraw()}_resize_redraw(){if(this._initializing||!this.container||this._building)return;const t=this.container.clientWidth,e=this.container.clientHeight;t&&e&&(this.redraw(!0,!0),this.restore_scroll(),this.recompute_page_size())}stylesheets(){return[...super.stylesheets(),z.default]}setCSSClasses(t){t.className="pnx-tabulator tabulator";for(const e of this.model.theme_classes)t.classList.add(e)}render(){null!=this.tabulator&&this.tabulator.destroy(),super.render(),this._initializing=!0,this._building=!0;const t=(0,g.div)({style:{display:"contents"}}),e=(0,g.div)({style:{width:"100%",height:"100%",visibility:"hidden"}});this.container=e,this.setCSSClasses(e),t.appendChild(e),this.shadow_el.appendChild(t);const i=this.getConfiguration();this.tabulator=new Tabulator(e,i),this.watch_stylesheets(),this.init_callbacks()}style_redraw(){this.model.visible&&(this.tabulator.element.style.visibility="visible"),this._initializing||this._building||this.redraw()}tableInit(){this._building=!0;this.tabulator.modules.ajax.sendRequest=(t,e,i)=>this.requestPage(e.page,e.sort),this.tabulator.modules.page._parseRemoteData=()=>!1}init_callbacks(){this.tabulator.on("tableBuilding",(()=>this.tableInit())),this.tabulator.on("tableBuilt",(()=>this.tableBuilt())),this.tabulator.on("selectableRowsCheck",(t=>{const e=this.model.selectable_rows;return null==e||e.includes(t._row.data._index)})),this.tabulator.on("tooltips",(t=>`${t.getColumn().getField()}: ${t.getValue()}`)),this.tabulator.on("scrollVertical",(0,b.debounce)((()=>{this.setStyles()}),50,!1)),this.tabulator.on("rowSelectionChanged",((t,e,i,s)=>{this.rowSelectionChanged(t,e,i,s)})),this.tabulator.on("rowClick",((t,e)=>this.rowClicked(t,e))),this.tabulator.on("cellEdited",(t=>this.cellEdited(t))),this.tabulator.on("dataFiltering",(t=>{this.record_scroll(),this.model.filters=t})),this.tabulator.on("dataFiltered",((t,e)=>{this._building||(0===e.length&&this.tabulator.rowManager.renderEmptyScroll(),null!=this.model.pagination&&this.updatePage(this.tabulator.getPage()))})),this.tabulator.on("pageLoaded",(t=>{this.updatePage(t)})),this.tabulator.on("renderComplete",(()=>{this._building||this.postUpdate()})),this.tabulator.on("dataSorting",(t=>{const e=[];for(const i of t)"_index"!==i.field&&e.push({field:i.field,dir:i.dir});"remote"!==this.model.pagination&&(this._updating_sort=!0,this.model.sorters=e.reverse(),this._updating_sort=!1)}))}tableBuilt(){this.setSelection(),this.renderChildren(),this.setStyles();const t=this.shadow_el.querySelector(".tabulator-tableholder");let e;t&&t.addEventListener("scroll",(()=>{this.record_scroll(),this._is_scrolling=!0,clearTimeout(e),e=setTimeout((()=>{this._is_scrolling=!1}),200)})),this.model.pagination&&(this.setMaxPage(),this.tabulator.setPage(this.model.page)),this._building=!1,(0,v.schedule_when)((()=>{const t=this._initializing;this._initializing=!1,t&&this._resize_redraw()}),(()=>this.root.has_finished()&&[...this._initialized_stylesheets.values()].every((t=>t))))}recompute_page_size(){if(!this.model.pagination||null!==this.model.page_size||this._automatic_page_size)return;this._automatic_page_size=!0;const t=this.model.sizing_mode&&(this.model.sizing_mode.includes("height")||this.model.sizing_mode.includes("both")),e=this.shadow_el.querySelector(".tabulator-tableholder"),i=this.shadow_el.querySelector(".tabulator-table");if(null!=i&&null!=e){const s=e.clientHeight;let o=0,l=null;const n=[];for(let e=0;e<i.children.length;e++){const a=i.children[e].clientHeight;if(n.push(a),o+=a,o>s){l=e,t&&(l-=1);break}}if(o<s){l=i.children.length;const e=s-o;l+=Math.floor(e/Math.min(...n)),t&&(l-=2)}this._updating_page_size=!0;try{this.model.page_size=Math.max(l||1,1)}finally{this._updating_page_size=!1}}}requestPage(t,e){return new Promise(((i,s)=>{try{if(null!=t&&null!=e){this._updating_sort=!0;const i=[];for(const t of e)"_index"!==t.field&&i.push({field:t.field,dir:t.dir});this.model.sorters=i,this._updating_sort=!1,this._updating_page=!0;try{this.model.page=t||1}finally{this._updating_page=!1}}i([])}catch(t){s(t)}}))}getLayout(){switch(this.model.layout){case"fit_data":return"fitData";case"fit_data_fill":return"fitDataFill";case"fit_data_stretch":return"fitDataStretch";case"fit_data_table":return"fitDataTable";case"fit_columns":return"fitColumns"}}getConfiguration(){const t="toggle"===this.model.select_mode||NaN,e={...(0,v.transformJsPlaceholders)(this.model.configuration),index:"_index",nestedFieldSeparator:!1,movableColumns:!1,selectableRows:t,columns:this.getColumns(),initialSort:this.sorters,layout:this.getLayout(),pagination:null!=this.model.pagination,paginationMode:this.model.pagination,paginationSize:this.model.page_size||20,paginationInitialPage:1,popupContainer:this.container,groupBy:this.groupBy,frozenRows:t=>this.model.frozen_rows.length>0&&this.model.frozen_rows.includes(t._row.data._index),rowFormatter:t=>this._render_row(t,!1)};null!=this.model.max_height&&(e.maxHeight=this.model.max_height),"remote"===this.model.pagination&&(e.ajaxURL="http://panel.pyviz.org",e.sortMode="remote");const i=this.getData();return{...e,data:i}}get_child(t){return this.model.children instanceof Map&&this.model.children.get(t)||null}get child_models(){const t=[];for(const e of this.model.expanded){const i=this.get_child(e);null!=i&&t.push(i)}return t}get row_index(){const t=this.tabulator.getRows(),e=new Map;for(const i of t){const t=i._row?.data._index;null!=t&&e.set(t,i)}return e}renderChildren(){new Promise((async()=>{await this.build_child_views();const t=this.row_index,e=this.model.expanded;for(const i of e){const s=this.get_child(i),o=t.get(i);null!=(null==s?null:this._child_views.get(s))&&this._render_row(o,i===e[e.length-1])}}))}_render_row(t,e=!0){const i=t._row?.data._index;if(!this.model.expanded.includes(i))return;const s=this.get_child(i),o=null==s?null:this._child_views.get(s);null!=o&&(0,v.schedule_when)((()=>{const i=t.getElement(),s=getComputedStyle(this.tabulator.element.children[1].children[0]).backgroundColor,l=i.style.paddingLeft?`-${i.style.paddingLeft}`:"0",n=i.children[i.children.length-1];let a;if(null!=n&&"row-content"==n.className){if(a=n,a.children.length&&a.children[0]===o.el)return}else a=(0,g.div)({class:"row-content",style:{background_color:s,margin_left:l,max_width:"100%",overflow_x:"hidden"}}),i.appendChild(a);(0,h.display)(o.el),a.appendChild(o.el),0===o.shadow_el.children.length&&this.rerender_(o),e&&(this._update_children(),this.resize_table())}),(()=>this.root.has_finished()))}resize_table(){if(null!=this.tabulator.rowManager.renderer)try{this.tabulator.rowManager.adjustTableSize()}catch(t){}this.invalidate_layout()}_expand_render(t){const e=t._cell.row.data._index;return this.model.expanded.indexOf(e)<0?"\u25ba":"\u25bc"}_update_expand(t){const e=t._cell.row.data._index,i=[...this.model.expanded];if(i.includes(e)){const t=i.indexOf(e),s=i.splice(t,1)[0],o=this.get_child(s);if(null!=o){const t=this._child_views.get(o);void 0!==t&&null!=t.el&&(0,h.undisplay)(t.el)}}else i.push(e);if(this._updating_expanded=!0,this.model.expanded=i,this._updating_expanded=!1,!i.includes(e))return;let s=!0;for(const t of this.model.expanded)if(null==this.get_child(t)){s=!1;break}s&&this.renderChildren()}getData(){const t=this.model.source;let e;return e=null===t||0===t.columns().length?[]:(0,y.transform_cds_to_records)(t,!0),this.model.configuration.dataTree&&(e=D(e,this.model.columns,this.model.indexes,this.model.aggregators)),e}getColumns(){this.columns=new Map;const t=(0,v.transformJsPlaceholders)(this.model.configuration?.columns),e=[];if(e.push({field:"_index",frozen:!0,visible:!1}),null!=t)for(const i of t){const t=V(i);if("expand"===i.formatter){const t={hozAlign:"center",cellClick:(t,e)=>{this._update_expand(e)},formatter:t=>this._expand_render(t),width:40,frozen:!0};e.push(t)}else"rowSelection"===t.formatter&&(t.cellClick=(t,e)=>{e.getRow().toggleSelect()}),e.push(t)}for(const i of this.model.columns){let s=null;if(null!=t)for(const t of e)if(s=N(t,i.field),null!=s)break;if(null==s&&(s={field:i.field}),this.columns.set(i.field,s),null==s.title&&(s.title=i.title),void 0===s.headerTooltip&&(s.headerTooltip=!0),null==s.width&&null!=i.width&&0!=i.width&&(s.width=i.width),null==s.formatter&&null!=i.formatter){const t=i.formatter.type;s.formatter="BooleanFormatter"===t?"tickCross":t=>{const e=t.getRow(),s=i.formatter.doFormat(t.getRow(),t,t.getValue(),null,e.getData());if("HTMLTemplateFormatter"===i.formatter.type)return s;const o=(0,g.div)();o.innerHTML=s;const l=o.children[0];return"function(){return c.convert(arguments)}"===l.innerHTML?"":l}}"timestamp"==s.sorter&&(s.sorter=k),void 0===s.sorter&&(s.sorter="string");const o=i.editor,l=o.type;null!=s.editor?"date"===s.editor?s.editor=P:"datetime"===s.editor?s.editor=L:"nested"===s.editor&&(s.editorParams.valuesLookup=t=>R(t,s.editorParams),s.editor="list"):"StringEditor"===l?o.completions.length>0?(s.editor="list",s.editorParams={values:o.completions,autocomplete:!0,listOnEmpty:!0}):s.editor="input":"TextEditor"===l?s.editor="textarea":"IntEditor"===l||"NumberEditor"===l?(s.editor="number",s.editorParams={step:o.step},s.validator="IntEditor"===l?"integer":"numeric"):"CheckboxEditor"===l?s.editor="tickCross":"DateEditor"===l?s.editor=P:"SelectEditor"===l?(s.editor="list",s.editorParams={values:o.options}):null!=o&&null!=o.default_view&&(s.editor=(t,e,s,o)=>{this.renderEditor(i,t,e,s,o)}),s.visible=0!=s.visible&&!this.model.hidden_columns.includes(i.field),s.editable=()=>this.model.editable&&null!=o.default_view,s.headerFilter&&(0,u.isBoolean)(s.headerFilter)&&(0,u.isString)(s.editor)&&(s.headerFilter=s.editor,s.headerFilterParams=s.editorParams);for(const t of this.model.sorters)s.field===t.field&&(s.headerSortStartingDir=t.dir);s.cellClick=(t,e)=>{const s=e.getData()._index,o=new M(i.field,s);this.model.trigger_event(o)},null==t&&e.push(s)}for(const t in this.model.buttons){const i={formatter:()=>this.model.buttons[t],hozAlign:"center",cellClick:(e,i)=>{const s=i.getData()._index,o=new M(t,s);this.model.trigger_event(o)}};e.push(i)}return e.push({width:1,maxWidth:1,minWidth:1,resizable:!1,cssClass:"empty",sorter:null}),e}renderEditor(t,e,i,s,o){const l=t.editor,n=new l.default_view({column:t,model:l,parent:this,container:e._cell.element});return n.initialize(),n.connect_signals(),i((()=>{n.setValue(e.getValue())})),n.inputEl.addEventListener("input",(()=>{const t=n.serializeValue(),i=e.getValue(),l=n.validate();l.valid||o(l.msg),null!=i&&typeof t!=typeof i?o("Mismatching type"):s(n.serializeValue())})),n.inputEl}setData(){if(this._initializing||this._building||!this.tabulator.initialized)return Promise.resolve(void 0);const t=this.getData();return null!=this.model.pagination?this.tabulator.rowManager.setData(t,!0,!1):this.tabulator.setData(t)}addData(){const t=this.tabulator.rowManager.getRows(),e=t[t.length-1],i=e?.data._index||0;this._updating_page=!0;const s=this.setData();this.model.follow?s.then((()=>{this.model.pagination&&this.tabulator.setPage(Math.ceil(this.tabulator.rowManager.getDataCount()/(this.model.page_size||20))),e&&this.tabulator.scrollToRow(i,"top",!1),this._updating_page=!1})):this._updating_page=!0}postUpdate(){if(this.setSelection(),this.setStyles(),this._restore_scroll){const t="horizontal"!==this._restore_scroll,e="vertical"!==this._restore_scroll;this.restore_scroll(e,t),this._restore_scroll=!1}}updateOrAddData(){if(this._tabulator_cell_updating)return;const t=this.tabulator.element.style.minHeight;this.tabulator.element.style.minHeight=`${this.tabulator.element.offsetHeight}px`;const e=(0,y.transform_cds_to_records)(this.model.source,!0);this.tabulator.setData(e).then((()=>{this.tabulator.element.style.minHeight=t}))}setFrozen(){for(const t of this.model.frozen_rows)this.tabulator.getRow(t).freeze()}setVisibility(){null!=this.tabulator&&(this.tabulator.element.style.visibility=this.model.visible?"visible":"hidden")}updatePage(t){"local"!==this.model.pagination||this.model.page===t||this._updating_page||(this._updating_page=!0,this.model.page=t,this._updating_page=!1,this.setStyles())}setGroupBy(){this.tabulator.setGroupBy(this.groupBy)}setSorters(){this._updating_sort||this.tabulator.setSort(this.sorters)}setStyles(){const t=this.model.cell_styles.data;if(null!=this.tabulator&&0!=this.tabulator.getDataCount()&&null!=t&&t.size){this._applied_styles=!1;for(const e of t.keys()){const i=t.get(e),s=this.tabulator.getRow(e);if(!s)continue;const o=s._row.cells;for(const t of i.keys()){const e=i.get(t),s=o[t];if(null==s||!e.length)continue;const l=s.element;for(const t of e){let e,i;if((0,u.isArray)(t))[e,i]=t;else{if(!t.includes(":"))continue;[e,i]=t.split(":")}l.style.setProperty(e,i.trimLeft()),this._applied_styles=!0}}}}}setHidden(){for(const t of this.tabulator.getColumns()){const e=t._column;"_index"==e.field||this.model.hidden_columns.includes(e.field)?t.hide():t.show()}}setMaxPage(){this.tabulator.setMaxPage(this.model.max_page),this.tabulator.modules.page.pagesElement&&this.tabulator.modules.page._setPageButtons()}setPage(){this.tabulator.setPage(Math.min(this.model.max_page,this.model.page)),"local"===this.model.pagination&&this.setStyles()}setPageSize(){this._updating_page_size||(this._automatic_page_size=!1),this.tabulator.setPageSize(this.model.page_size),"local"===this.model.pagination&&this.setStyles()}setSelection(){if(null==this.tabulator||this._initializing||this._selection_updating||!this.tabulator.initialized)return;const t=this.model.source.selected.indices,e=this.tabulator.getSelectedData().map((t=>t._index));if(JSON.stringify(t)!=JSON.stringify(e)){this._selection_updating=!0,this.tabulator.deselectRow(),this.tabulator.selectRow(t);for(const e of t){this.tabulator.rowManager.findRow(e)&&this.tabulator.scrollToRow(e,"center",!1).catch((()=>{}))}this._selection_updating=!1}}restore_scroll(t=!0,e=!0){if(!t&&!e)return;const i={behavior:"instant"};e&&(i.top=this._lastVerticalScrollbarTopPosition),t&&(i.left=this._lastHorizontalScrollbarLeftPosition),setTimeout((()=>{this._updating_scroll=!0,this.tabulator.rowManager.element.scrollTo(i),this._updating_scroll=!1}),0)}record_scroll(){this._updating_scroll||(this._lastVerticalScrollbarTopPosition=this.tabulator.rowManager.element.scrollTop,this._lastHorizontalScrollbarLeftPosition=this.tabulator.rowManager.element.scrollLeft)}rowClicked(t,e){if(this._selection_updating||this._initializing||(0,u.isString)(this.model.select_mode)||!1===this.model.select_mode||this.model.configuration.dataTree||"\u25ba"===t.srcElement?.innerText)return;let i=[];const s=this.model.source.selected,o=e._row.data._index;if(t.ctrlKey||t.metaKey)i=[...s.indices];else if(t.shiftKey&&this._last_selected_row){const t=e._row.parent.getDisplayRows(),s=t.indexOf(this._last_selected_row);if(-1!==s){const o=t.indexOf(e._row),l=s>o,[n,a]=l?[o+1,s+1]:[s,o];i=t.slice(n,a).map((t=>t.data._index)),l&&(i=i.reverse())}}const l=!(t.ctrlKey||t.metaKey||t.shiftKey),n=i.includes(o),a="remote"===this.model.pagination;if(!n||a?i.push(o):i.splice(i.indexOf(o),1),(0,u.isNumber)(this.model.select_mode))for(;i.length>this.model.select_mode;)i.shift();const r=this._filter_selected(i);a||(this.tabulator.deselectRow(),this.tabulator.selectRow(r)),this._last_selected_row=e._row,this._selection_updating=!0,a||(s.indices=r),this.model.trigger_event(new T(i,!n,l)),this._selection_updating=!1}_filter_selected(t){const e=[];for(const i of t)(null==this.model.selectable_rows||this.model.selectable_rows.indexOf(i)>=0)&&e.push(i);return e}rowSelectionChanged(t,e,i,s){if(!(this._selection_updating||this._initializing||(0,u.isBoolean)(this.model.select_mode)||(0,u.isNumber)(this.model.select_mode)||this.model.configuration.dataTree)){if("remote"===this.model.pagination){const t=i.map((t=>t._row.data._index)),e=s.map((t=>t._row.data._index));t.length>0&&(this._selection_updating=!0,this.model.trigger_event(new T(t,!0,!1))),e.length>0&&(this._selection_updating=!0,this.model.trigger_event(new T(e,!1,!1)))}else{const e=t.map((t=>t._index)),i=this._filter_selected(e);this._selection_updating=e.length===i.length,this.model.source.selected.indices=i}this._selection_updating=!1}}cellEdited(t){const e=t._cell.column.field,i=this.columns.get(e),s=t.getData()._index,o=t._cell.value;if("numeric"!==i.validator||""!==o){this._tabulator_cell_updating=!0,w.comm_settings.debounce=!1,this.model.trigger_event(new S(e,s,!0));try{this.model.source.patch({[e]:[[s,o]]})}finally{w.comm_settings.debounce=!0,this._tabulator_cell_updating=!1}this.model.trigger_event(new S(e,s,!1)),this.tabulator.scrollToRow(s,"top",!1)}else t.setValue(NaN,!0)}}i.DataTabulatorView=F,F.__name__="DataTabulatorView",i.TableLayout=(0,m.Enum)("fit_data","fit_data_fill","fit_data_stretch","fit_data_table","fit_columns");class H extends x.HTMLBox{constructor(t){super(t)}}i.DataTabulator=H,r=H,H.__name__="DataTabulator",H.__module__="panel.models.tabulator",r.prototype.default_view=F,r.define((({Any:t,List:e,Bool:s,Nullable:o,Float:l,Ref:n,Str:a})=>({aggregators:[t,{}],buttons:[t,{}],children:[t,new Map],configuration:[t,{}],columns:[e(n(f.TableColumn)),[]],download:[s,!1],editable:[s,!0],embed_content:[s,!1],expanded:[e(l),[]],filename:[a,"table.csv"],filters:[e(t),[]],follow:[s,!0],frozen_rows:[e(l),[]],groupby:[e(a),[]],hidden_columns:[e(a),[]],indexes:[e(a),[]],layout:[i.TableLayout,"fit_data"],max_page:[l,0],pagination:[o(a),null],page:[l,0],page_size:[o(l),null],select_mode:[t,!0],selectable_rows:[o(e(l)),null],source:[n(p.ColumnDataSource)],sorters:[e(t),[]],cell_styles:[t,{}],theme_classes:[e(a),[]]})))},
"99a25e6992": function _(n,l,u,t,e){function o(n,l,u){var t,e,o,a,r;function i(){var c=Date.now()-a;c<l&&c>=0?t=setTimeout(i,l-c):(t=null,u||(r=n.apply(o,e),o=e=null))}null==l&&(l=100);var c=function(){o=this,e=arguments,a=Date.now();var c=u&&!t;return t||(t=setTimeout(i,l)),c&&(r=n.apply(o,e),o=e=null),r};return c.clear=function(){t&&(clearTimeout(t),t=null)},c.flush=function(){t&&(r=n.apply(o,e),o=e=null,clearTimeout(t),t=null)},c}o.debounce=o,l.exports=o},
"be689f0377": function _(n,e,t,l,o){l(),t.transform_cds_to_records=function(n,e=!1,t=0){const l=[],o=n.columns(),r=n.get_length();if(0===o.length||null===r)return[];for(let c=t;c<r;c++){const t={};for(const e of o){const l=n.get_array(e),o=null==l[0]||null==l[0].shape?null:l[0].shape;if(null!=o&&o.length>1&&(0,s.isNumber)(o[0]))t[e]=l.slice(c*o[1],c*o[1]+o[1]);else if(l.length!=r&&l.length%r==0){const n=l.length/r;t[e]=l.slice(c*n,c*n+n)}else t[e]=l[c]}e&&(t._index=c),l.push(t)}return l},t.dict_to_records=function(n,e=!0){for(let t=0;t<n.index.length;t++){const l={};for(const o of n)(e||"index"!==o)&&(l[o]=n[o][t])}return[]};const s=n("@bokehjs/core/util/types")},
"cb7ce3ba00": function _(t,a,o,r,l){r(),o.panel_models_markup_HTML="bk-panel-models-markup-HTML",o.default=".tabulator-table{max-width:max-content;}.tabulator-table .tabulator-row .row-content .bk-panel-models-markup-HTML{white-space:normal;}.tabulator-table .tabulator-cell.empty{width:0px !important;padding:0px !important;}.tabulator-header .tabulator-col.empty{min-width:0px !important;width:0px !important;border-right:unset !important;}.tabulator-header .tabulator-col.empty .tabulator-col-content{padding:0px !important;}"},
"100965d6f3": function _(e,t,i,s,n){var o;s();const l=e("tslib"),a=l.__importDefault(e("1156ddcec2")),r=e("@bokehjs/models/widgets/input_widget"),d=e("@bokehjs/core/dom"),c=e("@bokehjs/core/enums"),h=e("@bokehjs/core/util/types"),_=l.__importStar(e("@bokehjs/styles/widgets/inputs.css")),m=l.__importDefault(e("@bokehjs/styles/widgets/flatpickr.css"));function p(e){const t=[];for(const i of e)if((0,h.isString)(i))t.push(i);else{const[e,s]=i;t.push({from:e,to:s})}return t}class u extends r.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,min_date:t,max_date:i,disabled_dates:s,enabled_dates:n,inline:o,enable_time:l,enable_seconds:a,military_time:r,date_format:d,mode:c}=this.model.properties;this.on_change(e,(()=>this.model.value?this._picker?.setDate(this.model.value):this._clear())),this.on_change(t,(()=>this._picker?.set("minDate",this.model.min_date))),this.on_change(i,(()=>this._picker?.set("maxDate",this.model.max_date))),this.on_change(s,(()=>{const{disabled_dates:e}=this.model;this._picker?.set("disable",null!=e?p(e):[])})),this.on_change(n,(()=>{const{enabled_dates:e}=this.model;null!=e?this._picker?.set("enable",p(e)):this._picker&&(this._picker.config._enable=void 0,this._picker.redraw(),this._picker.updateValue(!0))})),this.on_change(o,(()=>this._picker?.set("inline",this.model.inline))),this.on_change(l,(()=>this._picker?.set("enableTime",this.model.enable_time))),this.on_change(a,(()=>this._picker?.set("enableSeconds",this.model.enable_seconds))),this.on_change(r,(()=>this._picker?.set("time_24hr",this.model.military_time))),this.on_change(c,(()=>this._picker?.set("mode",this.model.mode))),this.on_change(d,(()=>this._picker?.set("dateFormat",this.model.date_format)))}remove(){this._picker?.destroy(),super.remove()}stylesheets(){return[...super.stylesheets(),m.default]}_render_input(){return this.input_el=(0,d.input)({type:"text",class:_.input,disabled:this.model.disabled})}render(){if(null!=this._picker)return;super.render();const e={allowInput:this.model.allow_input,appendTo:this.group_el,positionElement:this.input_el,defaultDate:this.model.value,inline:this.model.inline,position:this._position.bind(this),enableTime:this.model.enable_time,enableSeconds:this.model.enable_seconds,time_24hr:this.model.military_time,dateFormat:this.model.date_format,mode:this.model.mode,onClose:(e,t,i)=>this._on_close(e,t,i)},{min_date:t,max_date:i,disabled_dates:s,enabled_dates:n}=this.model;null!=t&&(e.minDate=t),null!=i&&(e.maxDate=i),null!=s&&(e.disable=p(s)),null!=n&&(e.enable=p(n)),this._picker=(0,a.default)(this.input_el,e),this._picker.maxDateHasTime=!0,this._picker.minDateHasTime=!0}_clear(){this._picker?.clear(),this.model.value=null}_on_close(e,t,i){("range"!=this.model.mode||t.includes("to"))&&(this.model.value=t,this.change_input())}_position(e,t){const i=t??e._positionElement,s=[...e.calendarContainer.children].reduce(((e,t)=>e+(0,d.bounding_box)(t).height),0),n=e.calendarContainer.offsetWidth,o=this.model.position.split(" "),l=o[0],a=o.length>1?o[1]:null,r=i.offsetTop,c=i.offsetTop+i.offsetHeight,h=i.offsetLeft,_=i.offsetLeft+i.offsetWidth,m=i.offsetWidth,p=window.innerHeight-c,u="above"===l||"below"!==l&&p<s&&r>s,f=e.config.appendTo?r+(u?-s-2:i.offsetHeight+2):window.scrollY+r+(u?-s-2:i.offsetHeight+2);if(e.calendarContainer.classList.toggle("arrowTop",!u),e.calendarContainer.classList.toggle("arrowBottom",u),e.config.inline)return;let g=window.scrollX+h,b=!1,k=!1;"center"===a?(g-=(n-m)/2,b=!0):"right"===a&&(g-=n-m,k=!0),e.calendarContainer.classList.toggle("arrowLeft",!b&&!k),e.calendarContainer.classList.toggle("arrowCenter",b),e.calendarContainer.classList.toggle("arrowRight",k);const w=window.document.body.offsetWidth-(window.scrollX+_),y=g+n>window.document.body.offsetWidth,C=w+n>window.document.body.offsetWidth;if(e.calendarContainer.classList.toggle("rightMost",y),!e.config.static)if(e.calendarContainer.style.top=`${f}px`,y)if(C){const t=this.shadow_el.styleSheets[0],i=window.document.body.offsetWidth,s=Math.max(0,i/2-n/2),o=".flatpickr-calendar.centerMost:before",l=".flatpickr-calendar.centerMost:after",a=t.cssRules.length,r=`{left:${h}px;right:auto;}`;e.calendarContainer.classList.toggle("rightMost",!1),e.calendarContainer.classList.toggle("centerMost",!0),t.insertRule(`${o},${l}${r}`,a),e.calendarContainer.style.left=`${s}px`,e.calendarContainer.style.right="auto"}else e.calendarContainer.style.left="auto",e.calendarContainer.style.right=`${w}px`;else e.calendarContainer.style.left=`${g}px`,e.calendarContainer.style.right="auto"}}i.DatetimePickerView=u,u.__name__="DatetimePickerView";class f extends r.InputWidget{constructor(e){super(e)}}i.DatetimePicker=f,o=f,f.__name__="DatetimePicker",f.__module__="panel.models.datetime_picker",o.prototype.default_view=u,o.define((({Bool:e,Str:t,List:i,Tuple:s,Or:n,Nullable:o})=>{const l=i(n(t,s(t,t)));return{allow_input:[e,!1],value:[o(t),null],min_date:[o(t),null],max_date:[o(t),null],disabled_dates:[o(l),null],enabled_dates:[o(l),null],position:[c.CalendarPosition,"auto"],inline:[e,!1],enable_time:[e,!0],enable_seconds:[e,!0],military_time:[e,!0],date_format:[t,"Y-m-d H:i:S"],mode:[t,"single"]}}))},
"1156ddcec2": function _(e,t,n,a,i){a();const o=e("tslib");var r=this&&this.__assign||function(){return r=Object.assign||function(e){for(var t,n=1,a=arguments.length;n<a;n++)for(var i in t=arguments[n])Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i]);return e},r.apply(this,arguments)},l=this&&this.__spreadArrays||function(){for(var e=0,t=0,n=arguments.length;t<n;t++)e+=arguments[t].length;var a=Array(e),i=0;for(t=0;t<n;t++)for(var o=arguments[t],r=0,l=o.length;r<l;r++,i++)a[i]=o[r];return a};const c=e("651d495396"),s=o.__importDefault(e("3bfa124fda")),d=e("15458073ce"),u=e("6b6749c6cf"),f=e("1bb8c967d1"),m=e("3d14787c35");e("6f45019dc1");var g=300;function p(e,t){var n={config:r(r({},c.defaults),v.defaultConfig),l10n:s.default};function a(){var e;return(null===(e=n.calendarContainer)||void 0===e?void 0:e.getRootNode()).activeElement||document.activeElement}function i(e){return e.bind(n)}function o(){var e=n.config;!1===e.weekNumbers&&1===e.showMonths||!0!==e.noCalendar&&window.requestAnimationFrame((function(){if(void 0!==n.calendarContainer&&(n.calendarContainer.style.visibility="hidden",n.calendarContainer.style.display="block"),void 0!==n.daysContainer){var t=(n.days.offsetWidth+1)*e.showMonths;n.daysContainer.style.width=t+"px",n.calendarContainer.style.width=t+(void 0!==n.weekWrapper?n.weekWrapper.offsetWidth:0)+"px",n.calendarContainer.style.removeProperty("visibility"),n.calendarContainer.style.removeProperty("display")}}))}function p(e){if(0===n.selectedDates.length){var t=void 0===n.config.minDate||(0,f.compareDates)(new Date,n.config.minDate)>=0?new Date:new Date(n.config.minDate.getTime()),a=(0,f.getDefaultHours)(n.config);t.setHours(a.hours,a.minutes,a.seconds,t.getMilliseconds()),n.selectedDates=[t],n.latestSelectedDateObj=t}void 0!==e&&"blur"!==e.type&&function(e){e.preventDefault();var t="keydown"===e.type,a=(0,u.getEventTarget)(e),i=a;void 0!==n.amPM&&a===n.amPM&&(n.amPM.textContent=n.l10n.amPM[(0,d.int)(n.amPM.textContent===n.l10n.amPM[0])]);var o=parseFloat(i.getAttribute("min")),r=parseFloat(i.getAttribute("max")),l=parseFloat(i.getAttribute("step")),c=parseInt(i.value,10),s=e.delta||(t?38===e.which?1:-1:0),f=c+l*s;if(void 0!==i.value&&2===i.value.length){var m=i===n.hourElement,g=i===n.minuteElement;f<o?(f=r+f+(0,d.int)(!m)+((0,d.int)(m)&&(0,d.int)(!n.amPM)),g&&x(void 0,-1,n.hourElement)):f>r&&(f=i===n.hourElement?f-r-(0,d.int)(!n.amPM):o,g&&x(void 0,1,n.hourElement)),n.amPM&&m&&(1===l?f+c===23:Math.abs(f-c)>l)&&(n.amPM.textContent=n.l10n.amPM[(0,d.int)(n.amPM.textContent===n.l10n.amPM[0])]),i.value=(0,d.pad)(f)}}(e);var i=n._input.value;h(),se(),n._input.value!==i&&n._debouncedChange()}function h(){if(void 0!==n.hourElement&&void 0!==n.minuteElement){var e,t,a=(parseInt(n.hourElement.value.slice(-2),10)||0)%24,i=(parseInt(n.minuteElement.value,10)||0)%60,o=void 0!==n.secondElement?(parseInt(n.secondElement.value,10)||0)%60:0;void 0!==n.amPM&&(e=a,t=n.amPM.textContent,a=e%12+12*(0,d.int)(t===n.l10n.amPM[1]));var r=void 0!==n.config.minTime||n.config.minDate&&n.minDateHasTime&&n.latestSelectedDateObj&&0===(0,f.compareDates)(n.latestSelectedDateObj,n.config.minDate,!0),l=void 0!==n.config.maxTime||n.config.maxDate&&n.maxDateHasTime&&n.latestSelectedDateObj&&0===(0,f.compareDates)(n.latestSelectedDateObj,n.config.maxDate,!0);if(void 0!==n.config.maxTime&&void 0!==n.config.minTime&&n.config.minTime>n.config.maxTime){var c=(0,f.calculateSecondsSinceMidnight)(n.config.minTime.getHours(),n.config.minTime.getMinutes(),n.config.minTime.getSeconds()),s=(0,f.calculateSecondsSinceMidnight)(n.config.maxTime.getHours(),n.config.maxTime.getMinutes(),n.config.maxTime.getSeconds()),u=(0,f.calculateSecondsSinceMidnight)(a,i,o);if(u>s&&u<c){var m=(0,f.parseSeconds)(c);a=m[0],i=m[1],o=m[2]}}else{if(l){var g=void 0!==n.config.maxTime?n.config.maxTime:n.config.maxDate;(a=Math.min(a,g.getHours()))===g.getHours()&&(i=Math.min(i,g.getMinutes())),i===g.getMinutes()&&(o=Math.min(o,g.getSeconds()))}if(r){var p=void 0!==n.config.minTime?n.config.minTime:n.config.minDate;(a=Math.max(a,p.getHours()))===p.getHours()&&i<p.getMinutes()&&(i=p.getMinutes()),i===p.getMinutes()&&(o=Math.max(o,p.getSeconds()))}}C(a,i,o)}}function D(e){var t=e||n.latestSelectedDateObj;t&&t instanceof Date&&C(t.getHours(),t.getMinutes(),t.getSeconds())}function C(e,t,a){void 0!==n.latestSelectedDateObj&&n.latestSelectedDateObj.setHours(e%24,t,a||0,0),n.hourElement&&n.minuteElement&&!n.isMobile&&(n.hourElement.value=(0,d.pad)(n.config.time_24hr?e:(12+e)%12+12*(0,d.int)(e%12==0)),n.minuteElement.value=(0,d.pad)(t),void 0!==n.amPM&&(n.amPM.textContent=n.l10n.amPM[(0,d.int)(e>=12)]),void 0!==n.secondElement&&(n.secondElement.value=(0,d.pad)(a)))}function b(e){var t=(0,u.getEventTarget)(e),n=parseInt(t.value)+(e.delta||0);(n/1e3>1||"Enter"===e.key&&!/[^\d]/.test(n.toString()))&&R(n)}function M(e,t,a,i){return t instanceof Array?t.forEach((function(t){return M(e,t,a,i)})):e instanceof Array?e.forEach((function(e){return M(e,t,a,i)})):(e.addEventListener(t,a,i),void n._handlers.push({remove:function(){return e.removeEventListener(t,a,i)}}))}function y(){ie("onChange")}function w(e,t){var a=void 0!==e?n.parseDate(e):n.latestSelectedDateObj||(n.config.minDate&&n.config.minDate>n.now?n.config.minDate:n.config.maxDate&&n.config.maxDate<n.now?n.config.maxDate:n.now),i=n.currentYear,o=n.currentMonth;try{void 0!==a&&(n.currentYear=a.getFullYear(),n.currentMonth=a.getMonth())}catch(e){e.message="Invalid date supplied: "+a,n.config.errorHandler(e)}t&&n.currentYear!==i&&(ie("onYearChange"),N()),!t||n.currentYear===i&&n.currentMonth===o||ie("onMonthChange"),n.redraw()}function E(e){var t=(0,u.getEventTarget)(e);~t.className.indexOf("arrow")&&x(e,t.classList.contains("arrowUp")?1:-1)}function x(e,t,n){var a=e&&(0,u.getEventTarget)(e),i=n||a&&a.parentNode&&a.parentNode.firstChild,o=oe("increment");o.delta=t,i&&i.dispatchEvent(o)}function k(e,t,a,i){var o=W(t,!0),r=(0,u.createElement)("span",e,t.getDate().toString());return r.dateObj=t,r.$i=i,r.setAttribute("aria-label",n.formatDate(t,n.config.ariaDateFormat)),-1===e.indexOf("hidden")&&0===(0,f.compareDates)(t,n.now)&&(n.todayDateElem=r,r.classList.add("today"),r.setAttribute("aria-current","date")),o?(r.tabIndex=-1,re(t)&&(r.classList.add("selected"),n.selectedDateElem=r,"range"===n.config.mode&&((0,u.toggleClass)(r,"startRange",n.selectedDates[0]&&0===(0,f.compareDates)(t,n.selectedDates[0],!0)),(0,u.toggleClass)(r,"endRange",n.selectedDates[1]&&0===(0,f.compareDates)(t,n.selectedDates[1],!0)),"nextMonthDay"===e&&r.classList.add("inRange")))):r.classList.add("flatpickr-disabled"),"range"===n.config.mode&&function(e){return!("range"!==n.config.mode||n.selectedDates.length<2)&&((0,f.compareDates)(e,n.selectedDates[0])>=0&&(0,f.compareDates)(e,n.selectedDates[1])<=0)}(t)&&!re(t)&&r.classList.add("inRange"),n.weekNumbers&&1===n.config.showMonths&&"prevMonthDay"!==e&&i%7==6&&n.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+n.config.getWeek(t)+"</span>"),ie("onDayCreate",r),r}function T(e){e.focus(),"range"===n.config.mode&&J(e)}function _(e){for(var t=e>0?0:n.config.showMonths-1,a=e>0?n.config.showMonths:-1,i=t;i!=a;i+=e)for(var o=n.daysContainer.children[i],r=e>0?0:o.children.length-1,l=e>0?o.children.length:-1,c=r;c!=l;c+=e){var s=o.children[c];if(-1===s.className.indexOf("hidden")&&W(s.dateObj))return s}}function I(e,t){var i=a(),o=B(i||document.body),r=void 0!==e?e:o?i:void 0!==n.selectedDateElem&&B(n.selectedDateElem)?n.selectedDateElem:void 0!==n.todayDateElem&&B(n.todayDateElem)?n.todayDateElem:_(t>0?1:-1);void 0===r?n._input.focus():o?function(e,t){for(var a=-1===e.className.indexOf("Month")?e.dateObj.getMonth():n.currentMonth,i=t>0?n.config.showMonths:-1,o=t>0?1:-1,r=a-n.currentMonth;r!=i;r+=o)for(var l=n.daysContainer.children[r],c=a-n.currentMonth===r?e.$i+t:t<0?l.children.length-1:0,s=l.children.length,d=c;d>=0&&d<s&&d!=(t>0?s:-1);d+=o){var u=l.children[d];if(-1===u.className.indexOf("hidden")&&W(u.dateObj)&&Math.abs(e.$i-d)>=Math.abs(t))return T(u)}n.changeMonth(o),I(_(o),0)}(r,t):T(r)}function S(e,t){for(var a=(new Date(e,t,1).getDay()-n.l10n.firstDayOfWeek+7)%7,i=n.utils.getDaysInMonth((t-1+12)%12,e),o=n.utils.getDaysInMonth(t,e),r=window.document.createDocumentFragment(),l=n.config.showMonths>1,c=l?"prevMonthDay hidden":"prevMonthDay",s=l?"nextMonthDay hidden":"nextMonthDay",d=i+1-a,f=0;d<=i;d++,f++)r.appendChild(k("flatpickr-day "+c,new Date(e,t-1,d),0,f));for(d=1;d<=o;d++,f++)r.appendChild(k("flatpickr-day",new Date(e,t,d),0,f));for(var m=o+1;m<=42-a&&(1===n.config.showMonths||f%7!=0);m++,f++)r.appendChild(k("flatpickr-day "+s,new Date(e,t+1,m%o),0,f));var g=(0,u.createElement)("div","dayContainer");return g.appendChild(r),g}function O(){if(void 0!==n.daysContainer){(0,u.clearNode)(n.daysContainer),n.weekNumbers&&(0,u.clearNode)(n.weekNumbers);for(var e=document.createDocumentFragment(),t=0;t<n.config.showMonths;t++){var a=new Date(n.currentYear,n.currentMonth,1);a.setMonth(n.currentMonth+t),e.appendChild(S(a.getFullYear(),a.getMonth()))}n.daysContainer.appendChild(e),n.days=n.daysContainer.firstChild,"range"===n.config.mode&&1===n.selectedDates.length&&J()}}function N(){if(!(n.config.showMonths>1||"dropdown"!==n.config.monthSelectorType)){var e=function(e){return!(void 0!==n.config.minDate&&n.currentYear===n.config.minDate.getFullYear()&&e<n.config.minDate.getMonth())&&!(void 0!==n.config.maxDate&&n.currentYear===n.config.maxDate.getFullYear()&&e>n.config.maxDate.getMonth())};n.monthsDropdownContainer.tabIndex=-1,n.monthsDropdownContainer.innerHTML="";for(var t=0;t<12;t++)if(e(t)){var a=(0,u.createElement)("option","flatpickr-monthDropdown-month");a.value=new Date(n.currentYear,t).getMonth().toString(),a.textContent=(0,m.monthToStr)(t,n.config.shorthandCurrentMonth,n.l10n),a.tabIndex=-1,n.currentMonth===t&&(a.selected=!0),n.monthsDropdownContainer.appendChild(a)}}}function A(){var e,t=(0,u.createElement)("div","flatpickr-month"),a=window.document.createDocumentFragment();n.config.showMonths>1||"static"===n.config.monthSelectorType?e=(0,u.createElement)("span","cur-month"):(n.monthsDropdownContainer=(0,u.createElement)("select","flatpickr-monthDropdown-months"),n.monthsDropdownContainer.setAttribute("aria-label",n.l10n.monthAriaLabel),M(n.monthsDropdownContainer,"change",(function(e){var t=(0,u.getEventTarget)(e),a=parseInt(t.value,10);n.changeMonth(a-n.currentMonth),ie("onMonthChange")})),N(),e=n.monthsDropdownContainer);var i=(0,u.createNumberInput)("cur-year",{tabindex:"-1"}),o=i.getElementsByTagName("input")[0];o.setAttribute("aria-label",n.l10n.yearAriaLabel),n.config.minDate&&o.setAttribute("min",n.config.minDate.getFullYear().toString()),n.config.maxDate&&(o.setAttribute("max",n.config.maxDate.getFullYear().toString()),o.disabled=!!n.config.minDate&&n.config.minDate.getFullYear()===n.config.maxDate.getFullYear());var r=(0,u.createElement)("div","flatpickr-current-month");return r.appendChild(e),r.appendChild(i),a.appendChild(r),t.appendChild(a),{container:t,yearElement:o,monthElement:e}}function P(){(0,u.clearNode)(n.monthNav),n.monthNav.appendChild(n.prevMonthNav),n.config.showMonths&&(n.yearElements=[],n.monthElements=[]);for(var e=n.config.showMonths;e--;){var t=A();n.yearElements.push(t.yearElement),n.monthElements.push(t.monthElement),n.monthNav.appendChild(t.container)}n.monthNav.appendChild(n.nextMonthNav)}function Y(){n.weekdayContainer?(0,u.clearNode)(n.weekdayContainer):n.weekdayContainer=(0,u.createElement)("div","flatpickr-weekdays");for(var e=n.config.showMonths;e--;){var t=(0,u.createElement)("div","flatpickr-weekdaycontainer");n.weekdayContainer.appendChild(t)}return F(),n.weekdayContainer}function F(){if(n.weekdayContainer){var e=n.l10n.firstDayOfWeek,t=l(n.l10n.weekdays.shorthand);e>0&&e<t.length&&(t=l(t.splice(e,t.length),t.splice(0,e)));for(var a=n.config.showMonths;a--;)n.weekdayContainer.children[a].innerHTML="\n      <span class='flatpickr-weekday'>\n        "+t.join("</span><span class='flatpickr-weekday'>")+"\n      </span>\n      "}}function j(e,t){void 0===t&&(t=!0);var a=t?e:e-n.currentMonth;a<0&&!0===n._hidePrevMonthArrow||a>0&&!0===n._hideNextMonthArrow||(n.currentMonth+=a,(n.currentMonth<0||n.currentMonth>11)&&(n.currentYear+=n.currentMonth>11?1:-1,n.currentMonth=(n.currentMonth+12)%12,ie("onYearChange"),N()),O(),ie("onMonthChange"),le())}function L(e){return n.calendarContainer.contains(e)}function H(e){if(n.isOpen&&!n.config.inline){var t=(0,u.getEventTarget)(e),a=L(t),i=!(t===n.input||t===n.altInput||n.element.contains(t)||e.path&&e.path.indexOf&&(~e.path.indexOf(n.input)||~e.path.indexOf(n.altInput)))&&!a&&!L(e.relatedTarget),o=!n.config.ignoredFocusElements.some((function(e){return e.contains(t)}));i&&o&&(n.config.allowInput&&n.setDate(n._input.value,!1,n.config.altInput?n.config.altFormat:n.config.dateFormat),void 0!==n.timeContainer&&void 0!==n.minuteElement&&void 0!==n.hourElement&&""!==n.input.value&&void 0!==n.input.value&&p(),n.close(),n.config&&"range"===n.config.mode&&1===n.selectedDates.length&&n.clear(!1))}}function R(e){if(!(!e||n.config.minDate&&e<n.config.minDate.getFullYear()||n.config.maxDate&&e>n.config.maxDate.getFullYear())){var t=e,a=n.currentYear!==t;n.currentYear=t||n.currentYear,n.config.maxDate&&n.currentYear===n.config.maxDate.getFullYear()?n.currentMonth=Math.min(n.config.maxDate.getMonth(),n.currentMonth):n.config.minDate&&n.currentYear===n.config.minDate.getFullYear()&&(n.currentMonth=Math.max(n.config.minDate.getMonth(),n.currentMonth)),a&&(n.redraw(),ie("onYearChange"),N())}}function W(e,t){var a;void 0===t&&(t=!0);var i=n.parseDate(e,void 0,t);if(n.config.minDate&&i&&(0,f.compareDates)(i,n.config.minDate,void 0!==t?t:!n.minDateHasTime)<0||n.config.maxDate&&i&&(0,f.compareDates)(i,n.config.maxDate,void 0!==t?t:!n.maxDateHasTime)>0)return!1;if(!n.config.enable&&0===n.config.disable.length)return!0;if(void 0===i)return!1;for(var o=!!n.config.enable,r=null!==(a=n.config.enable)&&void 0!==a?a:n.config.disable,l=0,c=void 0;l<r.length;l++){if("function"==typeof(c=r[l])&&c(i))return o;if(c instanceof Date&&void 0!==i&&c.getTime()===i.getTime())return o;if("string"==typeof c){var s=n.parseDate(c,void 0,!0);return s&&s.getTime()===i.getTime()?o:!o}if("object"==typeof c&&void 0!==i&&c.from&&c.to&&i.getTime()>=c.from.getTime()&&i.getTime()<=c.to.getTime())return o}return!o}function B(e){return void 0!==n.daysContainer&&(-1===e.className.indexOf("hidden")&&-1===e.className.indexOf("flatpickr-disabled")&&n.daysContainer.contains(e))}function K(e){var t=e.target===n._input,a=n._input.value.trimEnd()!==ce();!t||!a||e.relatedTarget&&L(e.relatedTarget)||n.setDate(n._input.value,!0,e.target===n.altInput?n.config.altFormat:n.config.dateFormat)}function q(t){var i=(0,u.getEventTarget)(t),o=n.config.wrap?e.contains(i):i===n._input,r=n.config.allowInput,l=n.isOpen&&(!r||!o),c=n.config.inline&&o&&!r;if(13===t.keyCode&&o){if(r)return n.setDate(n._input.value,!0,i===n.altInput?n.config.altFormat:n.config.dateFormat),n.close(),i.blur();n.open()}else if(L(i)||l||c){var s=!!n.timeContainer&&n.timeContainer.contains(i);switch(t.keyCode){case 13:s?(t.preventDefault(),p(),G()):Z(t);break;case 27:t.preventDefault(),G();break;case 8:case 46:o&&!n.config.allowInput&&(t.preventDefault(),n.clear());break;case 37:case 39:if(s||o)n.hourElement&&n.hourElement.focus();else{t.preventDefault();var d=a();if(void 0!==n.daysContainer&&(!1===r||d&&B(d))){var f=39===t.keyCode?1:-1;t.ctrlKey?(t.stopPropagation(),j(f),I(_(1),0)):I(void 0,f)}}break;case 38:case 40:t.preventDefault();var m=40===t.keyCode?1:-1;n.daysContainer&&void 0!==i.$i||i===n.input||i===n.altInput?t.ctrlKey?(t.stopPropagation(),R(n.currentYear-m),I(_(1),0)):s||I(void 0,7*m):i===n.currentYearElement?R(n.currentYear-m):n.config.enableTime&&(!s&&n.hourElement&&n.hourElement.focus(),p(t),n._debouncedChange());break;case 9:if(s){var g=[n.hourElement,n.minuteElement,n.secondElement,n.amPM].concat(n.pluginElements).filter((function(e){return e})),v=g.indexOf(i);if(-1!==v){var D=g[v+(t.shiftKey?-1:1)];t.preventDefault(),(D||n._input).focus()}}else!n.config.noCalendar&&n.daysContainer&&n.daysContainer.contains(i)&&t.shiftKey&&(t.preventDefault(),n._input.focus())}}if(void 0!==n.amPM&&i===n.amPM)switch(t.key){case n.l10n.amPM[0].charAt(0):case n.l10n.amPM[0].charAt(0).toLowerCase():n.amPM.textContent=n.l10n.amPM[0],h(),se();break;case n.l10n.amPM[1].charAt(0):case n.l10n.amPM[1].charAt(0).toLowerCase():n.amPM.textContent=n.l10n.amPM[1],h(),se()}(o||L(i))&&ie("onKeyDown",t)}function J(e,t){if(void 0===t&&(t="flatpickr-day"),1===n.selectedDates.length&&(!e||e.classList.contains(t)&&!e.classList.contains("flatpickr-disabled"))){for(var a=e?e.dateObj.getTime():n.days.firstElementChild.dateObj.getTime(),i=n.parseDate(n.selectedDates[0],void 0,!0).getTime(),o=Math.min(a,n.selectedDates[0].getTime()),r=Math.max(a,n.selectedDates[0].getTime()),l=!1,c=0,s=0,d=o;d<r;d+=f.duration.DAY)W(new Date(d),!0)||(l=l||d>o&&d<r,d<i&&(!c||d>c)?c=d:d>i&&(!s||d<s)&&(s=d));Array.from(n.rContainer.querySelectorAll("*:nth-child(-n+"+n.config.showMonths+") > ."+t)).forEach((function(t){var o=t.dateObj.getTime(),r=c>0&&o<c||s>0&&o>s;if(r)return t.classList.add("notAllowed"),void["inRange","startRange","endRange"].forEach((function(e){t.classList.remove(e)}));l&&!r||(["startRange","inRange","endRange","notAllowed"].forEach((function(e){t.classList.remove(e)})),void 0!==e&&(e.classList.add(a<=n.selectedDates[0].getTime()?"startRange":"endRange"),i<a&&o===i?t.classList.add("startRange"):i>a&&o===i&&t.classList.add("endRange"),o>=c&&(0===s||o<=s)&&(0,f.isBetween)(o,i,a)&&t.classList.add("inRange")))}))}}function U(){!n.isOpen||n.config.static||n.config.inline||X()}function $(e){return function(t){var a=n.config["_"+e+"Date"]=n.parseDate(t,n.config.dateFormat),i=n.config["_"+("min"===e?"max":"min")+"Date"];void 0!==a&&(n["min"===e?"minDateHasTime":"maxDateHasTime"]=a.getHours()>0||a.getMinutes()>0||a.getSeconds()>0),n.selectedDates&&(n.selectedDates=n.selectedDates.filter((function(e){return W(e)})),n.selectedDates.length||"min"!==e||D(a),se()),n.daysContainer&&(z(),void 0!==a?n.currentYearElement[e]=a.getFullYear().toString():n.currentYearElement.removeAttribute(e),n.currentYearElement.disabled=!!i&&void 0!==a&&i.getFullYear()===a.getFullYear())}}function Q(){return n.config.wrap?e.querySelector("[data-input]"):e}function V(){"object"!=typeof n.config.locale&&void 0===v.l10ns[n.config.locale]&&n.config.errorHandler(new Error("flatpickr: invalid locale "+n.config.locale)),n.l10n=r(r({},v.l10ns.default),"object"==typeof n.config.locale?n.config.locale:"default"!==n.config.locale?v.l10ns[n.config.locale]:void 0),m.tokenRegex.D="("+n.l10n.weekdays.shorthand.join("|")+")",m.tokenRegex.l="("+n.l10n.weekdays.longhand.join("|")+")",m.tokenRegex.M="("+n.l10n.months.shorthand.join("|")+")",m.tokenRegex.F="("+n.l10n.months.longhand.join("|")+")",m.tokenRegex.K="("+n.l10n.amPM[0]+"|"+n.l10n.amPM[1]+"|"+n.l10n.amPM[0].toLowerCase()+"|"+n.l10n.amPM[1].toLowerCase()+")",void 0===r(r({},t),JSON.parse(JSON.stringify(e.dataset||{}))).time_24hr&&void 0===v.defaultConfig.time_24hr&&(n.config.time_24hr=n.l10n.time_24hr),n.formatDate=(0,f.createDateFormatter)(n),n.parseDate=(0,f.createDateParser)({config:n.config,l10n:n.l10n})}function X(e){if("function"!=typeof n.config.position){if(void 0!==n.calendarContainer){ie("onPreCalendarPosition");var t=e||n._positionElement,a=Array.prototype.reduce.call(n.calendarContainer.children,(function(e,t){return e+t.offsetHeight}),0),i=n.calendarContainer.offsetWidth,o=n.config.position.split(" "),r=o[0],l=o.length>1?o[1]:null,c=t.getBoundingClientRect(),s=window.innerHeight-c.bottom,d="above"===r||"below"!==r&&s<a&&c.top>a,f=window.pageYOffset+c.top+(d?-a-2:t.offsetHeight+2);if((0,u.toggleClass)(n.calendarContainer,"arrowTop",!d),(0,u.toggleClass)(n.calendarContainer,"arrowBottom",d),!n.config.inline){var m=window.pageXOffset+c.left,g=!1,p=!1;"center"===l?(m-=(i-c.width)/2,g=!0):"right"===l&&(m-=i-c.width,p=!0),(0,u.toggleClass)(n.calendarContainer,"arrowLeft",!g&&!p),(0,u.toggleClass)(n.calendarContainer,"arrowCenter",g),(0,u.toggleClass)(n.calendarContainer,"arrowRight",p);var h=window.document.body.offsetWidth-(window.pageXOffset+c.right),v=m+i>window.document.body.offsetWidth,D=h+i>window.document.body.offsetWidth;if((0,u.toggleClass)(n.calendarContainer,"rightMost",v),!n.config.static)if(n.calendarContainer.style.top=f+"px",v)if(D){var C=function(){for(var e=null,t=0;t<document.styleSheets.length;t++){var n=document.styleSheets[t];if(n.cssRules){try{n.cssRules}catch(e){continue}e=n;break}}return null!=e?e:(a=document.createElement("style"),document.head.appendChild(a),a.sheet);var a}();if(void 0===C)return;var b=window.document.body.offsetWidth,M=Math.max(0,b/2-i/2),y=C.cssRules.length,w="{left:"+c.left+"px;right:auto;}";(0,u.toggleClass)(n.calendarContainer,"rightMost",!1),(0,u.toggleClass)(n.calendarContainer,"centerMost",!0),C.insertRule(".flatpickr-calendar.centerMost:before,.flatpickr-calendar.centerMost:after"+w,y),n.calendarContainer.style.left=M+"px",n.calendarContainer.style.right="auto"}else n.calendarContainer.style.left="auto",n.calendarContainer.style.right=h+"px";else n.calendarContainer.style.left=m+"px",n.calendarContainer.style.right="auto"}}}else n.config.position(n,e)}function z(){n.config.noCalendar||n.isMobile||(N(),le(),O())}function G(){n._input.focus(),-1!==window.navigator.userAgent.indexOf("MSIE")||void 0!==navigator.msMaxTouchPoints?setTimeout(n.close,0):n.close()}function Z(e){e.preventDefault(),e.stopPropagation();var t=(0,u.findParent)((0,u.getEventTarget)(e),(function(e){return e.classList&&e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled")&&!e.classList.contains("notAllowed")}));if(void 0!==t){var a=t,i=n.latestSelectedDateObj=new Date(a.dateObj.getTime()),o=(i.getMonth()<n.currentMonth||i.getMonth()>n.currentMonth+n.config.showMonths-1)&&"range"!==n.config.mode;if(n.selectedDateElem=a,"single"===n.config.mode)n.selectedDates=[i];else if("multiple"===n.config.mode){var r=re(i);r?n.selectedDates.splice(parseInt(r),1):n.selectedDates.push(i)}else"range"===n.config.mode&&(2===n.selectedDates.length&&n.clear(!1,!1),n.latestSelectedDateObj=i,n.selectedDates.push(i),0!==(0,f.compareDates)(i,n.selectedDates[0],!0)&&n.selectedDates.sort((function(e,t){return e.getTime()-t.getTime()})));if(h(),o){var l=n.currentYear!==i.getFullYear();n.currentYear=i.getFullYear(),n.currentMonth=i.getMonth(),l&&(ie("onYearChange"),N()),ie("onMonthChange")}if(le(),O(),se(),o||"range"===n.config.mode||1!==n.config.showMonths?void 0!==n.selectedDateElem&&void 0===n.hourElement&&n.selectedDateElem&&n.selectedDateElem.focus():T(a),void 0!==n.hourElement&&void 0!==n.hourElement&&n.hourElement.focus(),n.config.closeOnSelect){var c="single"===n.config.mode&&!n.config.enableTime,s="range"===n.config.mode&&2===n.selectedDates.length&&!n.config.enableTime;(c||s)&&G()}y()}}n.parseDate=(0,f.createDateParser)({config:n.config,l10n:n.l10n}),n._handlers=[],n.pluginElements=[],n.loadedPlugins=[],n._bind=M,n._setHoursFromDate=D,n._positionCalendar=X,n.changeMonth=j,n.changeYear=R,n.clear=function(e,t){void 0===e&&(e=!0);void 0===t&&(t=!0);n.input.value="",void 0!==n.altInput&&(n.altInput.value="");void 0!==n.mobileInput&&(n.mobileInput.value="");n.selectedDates=[],n.latestSelectedDateObj=void 0,!0===t&&(n.currentYear=n._initialDate.getFullYear(),n.currentMonth=n._initialDate.getMonth());if(!0===n.config.enableTime){var a=(0,f.getDefaultHours)(n.config);C(a.hours,a.minutes,a.seconds)}n.redraw(),e&&ie("onChange")},n.close=function(){n.isOpen=!1,n.isMobile||(void 0!==n.calendarContainer&&n.calendarContainer.classList.remove("open"),void 0!==n._input&&n._input.classList.remove("active"));ie("onClose")},n.onMouseOver=J,n._createElement=u.createElement,n.createDay=k,n.destroy=function(){void 0!==n.config&&ie("onDestroy");for(var e=n._handlers.length;e--;)n._handlers[e].remove();if(n._handlers=[],n.mobileInput)n.mobileInput.parentNode&&n.mobileInput.parentNode.removeChild(n.mobileInput),n.mobileInput=void 0;else if(n.calendarContainer&&n.calendarContainer.parentNode)if(n.config.static&&n.calendarContainer.parentNode){var t=n.calendarContainer.parentNode;if(t.lastChild&&t.removeChild(t.lastChild),t.parentNode){for(;t.firstChild;)t.parentNode.insertBefore(t.firstChild,t);t.parentNode.removeChild(t)}}else n.calendarContainer.parentNode.removeChild(n.calendarContainer);n.altInput&&(n.input.type="text",n.altInput.parentNode&&n.altInput.parentNode.removeChild(n.altInput),delete n.altInput);n.input&&(n.input.type=n.input._type,n.input.classList.remove("flatpickr-input"),n.input.removeAttribute("readonly"));["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach((function(e){try{delete n[e]}catch(e){}}))},n.isEnabled=W,n.jumpToDate=w,n.updateValue=se,n.open=function(e,t){void 0===t&&(t=n._positionElement);if(!0===n.isMobile){if(e){e.preventDefault();var a=(0,u.getEventTarget)(e);a&&a.blur()}return void 0!==n.mobileInput&&(n.mobileInput.focus(),n.mobileInput.click()),void ie("onOpen")}if(n._input.disabled||n.config.inline)return;var i=n.isOpen;n.isOpen=!0,i||(n.calendarContainer.classList.add("open"),n._input.classList.add("active"),ie("onOpen"),X(t));!0===n.config.enableTime&&!0===n.config.noCalendar&&(!1!==n.config.allowInput||void 0!==e&&n.timeContainer.contains(e.relatedTarget)||setTimeout((function(){return n.hourElement.select()}),50))},n.redraw=z,n.set=function(e,t){if(null!==e&&"object"==typeof e)for(var a in Object.assign(n.config,e),e)void 0!==ee[a]&&ee[a].forEach((function(e){return e()}));else n.config[e]=t,void 0!==ee[e]?ee[e].forEach((function(e){return e()})):c.HOOKS.indexOf(e)>-1&&(n.config[e]=(0,d.arrayify)(t));n.redraw(),se(!0)},n.setDate=function(e,t,a){void 0===t&&(t=!1);void 0===a&&(a=n.config.dateFormat);if(0!==e&&!e||e instanceof Array&&0===e.length)return n.clear(t);te(e,a),n.latestSelectedDateObj=n.selectedDates[n.selectedDates.length-1],n.redraw(),w(void 0,t),D(),0===n.selectedDates.length&&n.clear(!1);se(t),t&&ie("onChange")},n.toggle=function(e){if(!0===n.isOpen)return n.close();n.open(e)};var ee={locale:[V,F],showMonths:[P,o,Y],minDate:[w],maxDate:[w],positionElement:[ae],clickOpens:[function(){!0===n.config.clickOpens?(M(n._input,"focus",n.open),M(n._input,"click",n.open)):(n._input.removeEventListener("focus",n.open),n._input.removeEventListener("click",n.open))}]};function te(e,t){var a=[];if(e instanceof Array)a=e.map((function(e){return n.parseDate(e,t)}));else if(e instanceof Date||"number"==typeof e)a=[n.parseDate(e,t)];else if("string"==typeof e)switch(n.config.mode){case"single":case"time":a=[n.parseDate(e,t)];break;case"multiple":a=e.split(n.config.conjunction).map((function(e){return n.parseDate(e,t)}));break;case"range":a=e.split(n.l10n.rangeSeparator).map((function(e){return n.parseDate(e,t)}))}else n.config.errorHandler(new Error("Invalid date supplied: "+JSON.stringify(e)));n.selectedDates=n.config.allowInvalidPreload?a:a.filter((function(e){return e instanceof Date&&W(e,!1)})),"range"===n.config.mode&&n.selectedDates.sort((function(e,t){return e.getTime()-t.getTime()}))}function ne(e){return e.slice().map((function(e){return"string"==typeof e||"number"==typeof e||e instanceof Date?n.parseDate(e,void 0,!0):e&&"object"==typeof e&&e.from&&e.to?{from:n.parseDate(e.from,void 0),to:n.parseDate(e.to,void 0)}:e})).filter((function(e){return e}))}function ae(){n._positionElement=n.config.positionElement||n._input}function ie(e,t){if(void 0!==n.config){var a=n.config[e];if(void 0!==a&&a.length>0)for(var i=0;a[i]&&i<a.length;i++)a[i](n.selectedDates,n.input.value,n,t);"onChange"===e&&(n.input.dispatchEvent(oe("change")),n.input.dispatchEvent(oe("input")))}}function oe(e){var t=document.createEvent("Event");return t.initEvent(e,!0,!0),t}function re(e){for(var t=0;t<n.selectedDates.length;t++){var a=n.selectedDates[t];if(a instanceof Date&&0===(0,f.compareDates)(a,e))return""+t}return!1}function le(){n.config.noCalendar||n.isMobile||!n.monthNav||(n.yearElements.forEach((function(e,t){var a=new Date(n.currentYear,n.currentMonth,1);a.setMonth(n.currentMonth+t),n.config.showMonths>1||"static"===n.config.monthSelectorType?n.monthElements[t].textContent=(0,m.monthToStr)(a.getMonth(),n.config.shorthandCurrentMonth,n.l10n)+" ":n.monthsDropdownContainer.value=a.getMonth().toString(),e.value=a.getFullYear().toString()})),n._hidePrevMonthArrow=void 0!==n.config.minDate&&(n.currentYear===n.config.minDate.getFullYear()?n.currentMonth<=n.config.minDate.getMonth():n.currentYear<n.config.minDate.getFullYear()),n._hideNextMonthArrow=void 0!==n.config.maxDate&&(n.currentYear===n.config.maxDate.getFullYear()?n.currentMonth+1>n.config.maxDate.getMonth():n.currentYear>n.config.maxDate.getFullYear()))}function ce(e){var t=e||(n.config.altInput?n.config.altFormat:n.config.dateFormat);return n.selectedDates.map((function(e){return n.formatDate(e,t)})).filter((function(e,t,a){return"range"!==n.config.mode||n.config.enableTime||a.indexOf(e)===t})).join("range"!==n.config.mode?n.config.conjunction:n.l10n.rangeSeparator)}function se(e){void 0===e&&(e=!0),void 0!==n.mobileInput&&n.mobileFormatStr&&(n.mobileInput.value=void 0!==n.latestSelectedDateObj?n.formatDate(n.latestSelectedDateObj,n.mobileFormatStr):""),n.input.value=ce(n.config.dateFormat),void 0!==n.altInput&&(n.altInput.value=ce(n.config.altFormat)),!1!==e&&ie("onValueUpdate")}function de(e){var t=(0,u.getEventTarget)(e),a=n.prevMonthNav.contains(t),i=n.nextMonthNav.contains(t);a||i?j(a?-1:1):n.yearElements.indexOf(t)>=0?t.select():t.classList.contains("arrowUp")?n.changeYear(n.currentYear+1):t.classList.contains("arrowDown")&&n.changeYear(n.currentYear-1)}return function(){n.element=n.input=e,n.isOpen=!1,function(){var a=["wrap","weekNumbers","allowInput","allowInvalidPreload","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"],o=r(r({},JSON.parse(JSON.stringify(e.dataset||{}))),t),l={};n.config.parseDate=o.parseDate,n.config.formatDate=o.formatDate,Object.defineProperty(n.config,"enable",{get:function(){return n.config._enable},set:function(e){n.config._enable=ne(e)}}),Object.defineProperty(n.config,"disable",{get:function(){return n.config._disable},set:function(e){n.config._disable=ne(e)}});var s="time"===o.mode;if(!o.dateFormat&&(o.enableTime||s)){var u=v.defaultConfig.dateFormat||c.defaults.dateFormat;l.dateFormat=o.noCalendar||s?"H:i"+(o.enableSeconds?":S":""):u+" H:i"+(o.enableSeconds?":S":"")}if(o.altInput&&(o.enableTime||s)&&!o.altFormat){var f=v.defaultConfig.altFormat||c.defaults.altFormat;l.altFormat=o.noCalendar||s?"h:i"+(o.enableSeconds?":S K":" K"):f+" h:i"+(o.enableSeconds?":S":"")+" K"}Object.defineProperty(n.config,"minDate",{get:function(){return n.config._minDate},set:$("min")}),Object.defineProperty(n.config,"maxDate",{get:function(){return n.config._maxDate},set:$("max")});var m=function(e){return function(t){n.config["min"===e?"_minTime":"_maxTime"]=n.parseDate(t,"H:i:S")}};Object.defineProperty(n.config,"minTime",{get:function(){return n.config._minTime},set:m("min")}),Object.defineProperty(n.config,"maxTime",{get:function(){return n.config._maxTime},set:m("max")}),"time"===o.mode&&(n.config.noCalendar=!0,n.config.enableTime=!0);Object.assign(n.config,l,o);for(var g=0;g<a.length;g++)n.config[a[g]]=!0===n.config[a[g]]||"true"===n.config[a[g]];c.HOOKS.filter((function(e){return void 0!==n.config[e]})).forEach((function(e){n.config[e]=(0,d.arrayify)(n.config[e]||[]).map(i)})),n.isMobile=!n.config.disableMobile&&!n.config.inline&&"single"===n.config.mode&&!n.config.disable.length&&!n.config.enable&&!n.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);for(g=0;g<n.config.plugins.length;g++){var p=n.config.plugins[g](n)||{};for(var h in p)c.HOOKS.indexOf(h)>-1?n.config[h]=(0,d.arrayify)(p[h]).map(i).concat(n.config[h]):void 0===o[h]&&(n.config[h]=p[h])}o.altInputClass||(n.config.altInputClass=Q().className+" "+n.config.altInputClass);ie("onParseConfig")}(),V(),function(){if(n.input=Q(),!n.input)return void n.config.errorHandler(new Error("Invalid input element specified"));n.input._type=n.input.type,n.input.type="text",n.input.classList.add("flatpickr-input"),n._input=n.input,n.config.altInput&&(n.altInput=(0,u.createElement)(n.input.nodeName,n.config.altInputClass),n._input=n.altInput,n.altInput.placeholder=n.input.placeholder,n.altInput.disabled=n.input.disabled,n.altInput.required=n.input.required,n.altInput.tabIndex=n.input.tabIndex,n.altInput.type="text",n.input.setAttribute("type","hidden"),!n.config.static&&n.input.parentNode&&n.input.parentNode.insertBefore(n.altInput,n.input.nextSibling));n.config.allowInput||n._input.setAttribute("readonly","readonly");ae()}(),function(){n.selectedDates=[],n.now=n.parseDate(n.config.now)||new Date;var e=n.config.defaultDate||("INPUT"!==n.input.nodeName&&"TEXTAREA"!==n.input.nodeName||!n.input.placeholder||n.input.value!==n.input.placeholder?n.input.value:null);e&&te(e,n.config.dateFormat);n._initialDate=n.selectedDates.length>0?n.selectedDates[0]:n.config.minDate&&n.config.minDate.getTime()>n.now.getTime()?n.config.minDate:n.config.maxDate&&n.config.maxDate.getTime()<n.now.getTime()?n.config.maxDate:n.now,n.currentYear=n._initialDate.getFullYear(),n.currentMonth=n._initialDate.getMonth(),n.selectedDates.length>0&&(n.latestSelectedDateObj=n.selectedDates[0]);void 0!==n.config.minTime&&(n.config.minTime=n.parseDate(n.config.minTime,"H:i"));void 0!==n.config.maxTime&&(n.config.maxTime=n.parseDate(n.config.maxTime,"H:i"));n.minDateHasTime=!!n.config.minDate&&(n.config.minDate.getHours()>0||n.config.minDate.getMinutes()>0||n.config.minDate.getSeconds()>0),n.maxDateHasTime=!!n.config.maxDate&&(n.config.maxDate.getHours()>0||n.config.maxDate.getMinutes()>0||n.config.maxDate.getSeconds()>0)}(),n.utils={getDaysInMonth:function(e,t){return void 0===e&&(e=n.currentMonth),void 0===t&&(t=n.currentYear),1===e&&(t%4==0&&t%100!=0||t%400==0)?29:n.l10n.daysInMonth[e]}},n.isMobile||function(){var e=window.document.createDocumentFragment();if(n.calendarContainer=(0,u.createElement)("div","flatpickr-calendar"),n.calendarContainer.tabIndex=-1,!n.config.noCalendar){if(e.appendChild((n.monthNav=(0,u.createElement)("div","flatpickr-months"),n.yearElements=[],n.monthElements=[],n.prevMonthNav=(0,u.createElement)("span","flatpickr-prev-month"),n.prevMonthNav.innerHTML=n.config.prevArrow,n.nextMonthNav=(0,u.createElement)("span","flatpickr-next-month"),n.nextMonthNav.innerHTML=n.config.nextArrow,P(),Object.defineProperty(n,"_hidePrevMonthArrow",{get:function(){return n.__hidePrevMonthArrow},set:function(e){n.__hidePrevMonthArrow!==e&&((0,u.toggleClass)(n.prevMonthNav,"flatpickr-disabled",e),n.__hidePrevMonthArrow=e)}}),Object.defineProperty(n,"_hideNextMonthArrow",{get:function(){return n.__hideNextMonthArrow},set:function(e){n.__hideNextMonthArrow!==e&&((0,u.toggleClass)(n.nextMonthNav,"flatpickr-disabled",e),n.__hideNextMonthArrow=e)}}),n.currentYearElement=n.yearElements[0],le(),n.monthNav)),n.innerContainer=(0,u.createElement)("div","flatpickr-innerContainer"),n.config.weekNumbers){var t=function(){n.calendarContainer.classList.add("hasWeeks");var e=(0,u.createElement)("div","flatpickr-weekwrapper");e.appendChild((0,u.createElement)("span","flatpickr-weekday",n.l10n.weekAbbreviation));var t=(0,u.createElement)("div","flatpickr-weeks");return e.appendChild(t),{weekWrapper:e,weekNumbers:t}}(),a=t.weekWrapper,i=t.weekNumbers;n.innerContainer.appendChild(a),n.weekNumbers=i,n.weekWrapper=a}n.rContainer=(0,u.createElement)("div","flatpickr-rContainer"),n.rContainer.appendChild(Y()),n.daysContainer||(n.daysContainer=(0,u.createElement)("div","flatpickr-days"),n.daysContainer.tabIndex=-1),O(),n.rContainer.appendChild(n.daysContainer),n.innerContainer.appendChild(n.rContainer),e.appendChild(n.innerContainer)}n.config.enableTime&&e.appendChild(function(){n.calendarContainer.classList.add("hasTime"),n.config.noCalendar&&n.calendarContainer.classList.add("noCalendar");var e=(0,f.getDefaultHours)(n.config);n.timeContainer=(0,u.createElement)("div","flatpickr-time"),n.timeContainer.tabIndex=-1;var t=(0,u.createElement)("span","flatpickr-time-separator",":"),a=(0,u.createNumberInput)("flatpickr-hour",{"aria-label":n.l10n.hourAriaLabel});n.hourElement=a.getElementsByTagName("input")[0];var i=(0,u.createNumberInput)("flatpickr-minute",{"aria-label":n.l10n.minuteAriaLabel});n.minuteElement=i.getElementsByTagName("input")[0],n.hourElement.tabIndex=n.minuteElement.tabIndex=-1,n.hourElement.value=(0,d.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getHours():n.config.time_24hr?e.hours:function(e){switch(e%24){case 0:case 12:return 12;default:return e%12}}(e.hours)),n.minuteElement.value=(0,d.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getMinutes():e.minutes),n.hourElement.setAttribute("step",n.config.hourIncrement.toString()),n.minuteElement.setAttribute("step",n.config.minuteIncrement.toString()),n.hourElement.setAttribute("min",n.config.time_24hr?"0":"1"),n.hourElement.setAttribute("max",n.config.time_24hr?"23":"12"),n.hourElement.setAttribute("maxlength","2"),n.minuteElement.setAttribute("min","0"),n.minuteElement.setAttribute("max","59"),n.minuteElement.setAttribute("maxlength","2"),n.timeContainer.appendChild(a),n.timeContainer.appendChild(t),n.timeContainer.appendChild(i),n.config.time_24hr&&n.timeContainer.classList.add("time24hr");if(n.config.enableSeconds){n.timeContainer.classList.add("hasSeconds");var o=(0,u.createNumberInput)("flatpickr-second");n.secondElement=o.getElementsByTagName("input")[0],n.secondElement.value=(0,d.pad)(n.latestSelectedDateObj?n.latestSelectedDateObj.getSeconds():e.seconds),n.secondElement.setAttribute("step",n.minuteElement.getAttribute("step")),n.secondElement.setAttribute("min","0"),n.secondElement.setAttribute("max","59"),n.secondElement.setAttribute("maxlength","2"),n.timeContainer.appendChild((0,u.createElement)("span","flatpickr-time-separator",":")),n.timeContainer.appendChild(o)}n.config.time_24hr||(n.amPM=(0,u.createElement)("span","flatpickr-am-pm",n.l10n.amPM[(0,d.int)((n.latestSelectedDateObj?n.hourElement.value:n.config.defaultHour)>11)]),n.amPM.title=n.l10n.toggleTitle,n.amPM.tabIndex=-1,n.timeContainer.appendChild(n.amPM));return n.timeContainer}());(0,u.toggleClass)(n.calendarContainer,"rangeMode","range"===n.config.mode),(0,u.toggleClass)(n.calendarContainer,"animate",!0===n.config.animate),(0,u.toggleClass)(n.calendarContainer,"multiMonth",n.config.showMonths>1),n.calendarContainer.appendChild(e);var o=void 0!==n.config.appendTo&&void 0!==n.config.appendTo.nodeType;if((n.config.inline||n.config.static)&&(n.calendarContainer.classList.add(n.config.inline?"inline":"static"),n.config.inline&&(!o&&n.element.parentNode?n.element.parentNode.insertBefore(n.calendarContainer,n._input.nextSibling):void 0!==n.config.appendTo&&n.config.appendTo.appendChild(n.calendarContainer)),n.config.static)){var r=(0,u.createElement)("div","flatpickr-wrapper");n.element.parentNode&&n.element.parentNode.insertBefore(r,n.element),r.appendChild(n.element),n.altInput&&r.appendChild(n.altInput),r.appendChild(n.calendarContainer)}n.config.static||n.config.inline||(void 0!==n.config.appendTo?n.config.appendTo:window.document.body).appendChild(n.calendarContainer)}(),function(){n.config.wrap&&["open","close","toggle","clear"].forEach((function(e){Array.prototype.forEach.call(n.element.querySelectorAll("[data-"+e+"]"),(function(t){return M(t,"click",n[e])}))}));if(n.isMobile)return void function(){var e=n.config.enableTime?n.config.noCalendar?"time":"datetime-local":"date";n.mobileInput=(0,u.createElement)("input",n.input.className+" flatpickr-mobile"),n.mobileInput.tabIndex=1,n.mobileInput.type=e,n.mobileInput.disabled=n.input.disabled,n.mobileInput.required=n.input.required,n.mobileInput.placeholder=n.input.placeholder,n.mobileFormatStr="datetime-local"===e?"Y-m-d\\TH:i:S":"date"===e?"Y-m-d":"H:i:S",n.selectedDates.length>0&&(n.mobileInput.defaultValue=n.mobileInput.value=n.formatDate(n.selectedDates[0],n.mobileFormatStr));n.config.minDate&&(n.mobileInput.min=n.formatDate(n.config.minDate,"Y-m-d"));n.config.maxDate&&(n.mobileInput.max=n.formatDate(n.config.maxDate,"Y-m-d"));n.input.getAttribute("step")&&(n.mobileInput.step=String(n.input.getAttribute("step")));n.input.type="hidden",void 0!==n.altInput&&(n.altInput.type="hidden");try{n.input.parentNode&&n.input.parentNode.insertBefore(n.mobileInput,n.input.nextSibling)}catch(e){}M(n.mobileInput,"change",(function(e){n.setDate((0,u.getEventTarget)(e).value,!1,n.mobileFormatStr),ie("onChange"),ie("onClose")}))}();var e=(0,d.debounce)(U,50);n._debouncedChange=(0,d.debounce)(y,g),n.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent)&&M(n.daysContainer,"mouseover",(function(e){"range"===n.config.mode&&J((0,u.getEventTarget)(e))}));M(n._input,"keydown",q),void 0!==n.calendarContainer&&M(n.calendarContainer,"keydown",q);n.config.inline||n.config.static||M(window,"resize",e);void 0!==window.ontouchstart?M(window.document,"touchstart",H):M(window.document,"mousedown",H);M(window.document,"focus",H,{capture:!0}),!0===n.config.clickOpens&&(M(n._input,"focus",n.open),M(n._input,"click",n.open));void 0!==n.daysContainer&&(M(n.monthNav,"click",de),M(n.monthNav,["keyup","increment"],b),M(n.daysContainer,"click",Z));if(void 0!==n.timeContainer&&void 0!==n.minuteElement&&void 0!==n.hourElement){var t=function(e){return(0,u.getEventTarget)(e).select()};M(n.timeContainer,["increment"],p),M(n.timeContainer,"blur",p,{capture:!0}),M(n.timeContainer,"click",E),M([n.hourElement,n.minuteElement],["focus","click"],t),void 0!==n.secondElement&&M(n.secondElement,"focus",(function(){return n.secondElement&&n.secondElement.select()})),void 0!==n.amPM&&M(n.amPM,"click",(function(e){p(e)}))}n.config.allowInput&&M(n._input,"blur",K)}(),(n.selectedDates.length||n.config.noCalendar)&&(n.config.enableTime&&D(n.config.noCalendar?n.latestSelectedDateObj:void 0),se(!1)),o();var a=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);!n.isMobile&&a&&X(),ie("onReady")}(),n}function h(e,t){for(var n=Array.prototype.slice.call(e).filter((function(e){return e instanceof HTMLElement})),a=[],i=0;i<n.length;i++){var o=n[i];try{if(null!==o.getAttribute("data-fp-omit"))continue;void 0!==o._flatpickr&&(o._flatpickr.destroy(),o._flatpickr=void 0),o._flatpickr=p(o,t||{}),a.push(o._flatpickr)}catch(e){console.error(e)}}return 1===a.length?a[0]:a}"undefined"!=typeof HTMLElement&&"undefined"!=typeof HTMLCollection&&"undefined"!=typeof NodeList&&(HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(e){return h(this,e)},HTMLElement.prototype.flatpickr=function(e){return h([this],e)});var v=function(e,t){return"string"==typeof e?h(window.document.querySelectorAll(e),t):e instanceof Node?h([e],t):h(e,t)};v.defaultConfig={},v.l10ns={en:r({},s.default),default:r({},s.default)},v.localize=function(e){v.l10ns.default=r(r({},v.l10ns.default),e)},v.setDefaults=function(e){v.defaultConfig=r(r({},v.defaultConfig),e)},v.parseDate=(0,f.createDateParser)({}),v.formatDate=(0,f.createDateFormatter)({}),v.compareDates=f.compareDates,"undefined"!=typeof jQuery&&void 0!==jQuery.fn&&(jQuery.fn.flatpickr=function(e){return h(this,e)}),Date.prototype.fp_incr=function(e){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+("string"==typeof e?parseInt(e,10):e))},"undefined"!=typeof window&&(window.flatpickr=v),n.default=v},
"651d495396": function _(e,n,o,t,a){t(),o.HOOKS=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"],o.defaults={_disable:[],allowInput:!1,allowInvalidPreload:!1,altFormat:"F j, Y",altInput:!1,altInputClass:"form-control input",animate:"object"==typeof window&&-1===window.navigator.userAgent.indexOf("MSIE"),ariaDateFormat:"F j, Y",autoFillDefaultTime:!0,clickOpens:!0,closeOnSelect:!0,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:!1,enableSeconds:!1,enableTime:!1,errorHandler:function(e){return"undefined"!=typeof console&&console.warn(e)},getWeek:function(e){var n=new Date(e.getTime());n.setHours(0,0,0,0),n.setDate(n.getDate()+3-(n.getDay()+6)%7);var o=new Date(n.getFullYear(),0,4);return 1+Math.round(((n.getTime()-o.getTime())/864e5-3+(o.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:!1,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:!1,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:void 0,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:!1,showMonths:1,static:!1,time_24hr:!1,weekNumbers:!1,wrap:!1}},
"3bfa124fda": function _(e,r,a,n,t){n(),a.english={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:function(e){var r=e%100;if(r>3&&r<21)return"th";switch(r%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",monthAriaLabel:"Month",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:!1},a.default=a.english},
"15458073ce": function _(n,t,r,i,u){i(),r.debounce=function(n,t){var r;return function(){var i=this,u=arguments;clearTimeout(r),r=setTimeout((function(){return n.apply(i,u)}),t)}};r.pad=function(n,t){return void 0===t&&(t=2),("000"+n).slice(-1*t)};r.int=function(n){return!0===n?1:0};r.arrayify=function(n){return n instanceof Array?n:[n]}},
"6b6749c6cf": function _(t,e,n,r,a){function i(t,e,n){var r=window.document.createElement(t);return e=e||"",n=n||"",r.className=e,void 0!==n&&(r.textContent=n),r}r(),n.toggleClass=function(t,e,n){if(!0===n)return t.classList.add(e);t.classList.remove(e)},n.createElement=i,n.clearNode=function(t){for(;t.firstChild;)t.removeChild(t.firstChild)},n.findParent=function t(e,n){if(n(e))return e;if(e.parentNode)return t(e.parentNode,n);return},n.createNumberInput=function(t,e){var n=i("div","numInputWrapper"),r=i("input","numInput "+t),a=i("span","arrowUp"),o=i("span","arrowDown");-1===navigator.userAgent.indexOf("MSIE 9.0")?r.type="number":(r.type="text",r.pattern="\\d*");if(void 0!==e)for(var u in e)r.setAttribute(u,e[u]);return n.appendChild(r),n.appendChild(a),n.appendChild(o),n},n.getEventTarget=function(t){try{return"function"==typeof t.composedPath?t.composedPath()[0]:t.target}catch(e){return t.target}}},
"1bb8c967d1": function _(e,t,n,a,r){a(),n.compareDates=function(e,t,n){void 0===n&&(n=!0);if(!1!==n)return new Date(e.getTime()).setHours(0,0,0,0)-new Date(t.getTime()).setHours(0,0,0,0);return e.getTime()-t.getTime()},n.compareTimes=function(e,t){return 3600*(e.getHours()-t.getHours())+60*(e.getMinutes()-t.getMinutes())+e.getSeconds()-t.getSeconds()},n.getDefaultHours=function(e){var t=e.defaultHour,n=e.defaultMinute,a=e.defaultSeconds;if(void 0!==e.minDate){var r=e.minDate.getHours(),i=e.minDate.getMinutes(),o=e.minDate.getSeconds();t<r&&(t=r),t===r&&n<i&&(n=i),t===r&&n===i&&a<o&&(a=e.minDate.getSeconds())}if(void 0!==e.maxDate){var s=e.maxDate.getHours(),u=e.maxDate.getMinutes();(t=Math.min(t,s))===s&&(n=Math.min(u,n)),t===s&&n===u&&(a=e.maxDate.getSeconds())}return{hours:t,minutes:n,seconds:a}};const i=e("3d14787c35"),o=e("651d495396"),s=e("3bfa124fda");n.createDateFormatter=function(e){var t=e.config,n=void 0===t?o.defaults:t,a=e.l10n,r=void 0===a?s.english:a,u=e.isMobile,f=void 0!==u&&u;return function(e,t,a){var o=a||r;return void 0===n.formatDate||f?t.split("").map((function(t,a,r){return i.formats[t]&&"\\"!==r[a-1]?i.formats[t](e,o,n):"\\"!==t?t:""})).join(""):n.formatDate(e,t,o)}};n.createDateParser=function(e){var t=e.config,n=void 0===t?o.defaults:t,a=e.l10n,r=void 0===a?s.english:a;return function(e,t,a,s){if(0===e||e){var u,f=s||r,d=e;if(e instanceof Date)u=new Date(e.getTime());else if("string"!=typeof e&&void 0!==e.toFixed)u=new Date(e);else if("string"==typeof e){var c=t||(n||o.defaults).dateFormat,g=String(e).trim();if("today"===g)u=new Date,a=!0;else if(n&&n.parseDate)u=n.parseDate(e,c);else if(/Z$/.test(g)||/GMT$/.test(g))u=new Date(e);else{for(var m=void 0,l=[],v=0,D=0,h="";v<c.length;v++){var w=c[v],M="\\"===w,p="\\"===c[v-1]||M;if(i.tokenRegex[w]&&!p){h+=i.tokenRegex[w];var H=new RegExp(h).exec(e);H&&(m=!0)&&l["Y"!==w?"push":"unshift"]({fn:i.revFormat[w],val:H[++D]})}else M||(h+=".")}u=n&&n.noCalendar?new Date((new Date).setHours(0,0,0,0)):new Date((new Date).getFullYear(),0,1,0,0,0,0),l.forEach((function(e){var t=e.fn,n=e.val;return u=t(u,n,f)||u})),u=m?u:void 0}}if(u instanceof Date&&!isNaN(u.getTime()))return!0===a&&u.setHours(0,0,0,0),u;n.errorHandler(new Error("Invalid date provided: "+d))}}};n.isBetween=function(e,t,n){return e>Math.min(t,n)&&e<Math.max(t,n)};n.calculateSecondsSinceMidnight=function(e,t,n){return 3600*e+60*t+n};n.parseSeconds=function(e){var t=Math.floor(e/3600),n=(e-3600*t)/60;return[t,n,e-3600*t-60*n]},n.duration={DAY:864e5}},
"3d14787c35": function _(t,n,e,o,r){o();const u=t("15458073ce");var a=function(){};e.monthToStr=function(t,n,e){return e.months[n?"shorthand":"longhand"][t]},e.revFormat={D:a,F:function(t,n,e){t.setMonth(e.months.longhand.indexOf(n))},G:function(t,n){t.setHours((t.getHours()>=12?12:0)+parseFloat(n))},H:function(t,n){t.setHours(parseFloat(n))},J:function(t,n){t.setDate(parseFloat(n))},K:function(t,n,e){t.setHours(t.getHours()%12+12*(0,u.int)(new RegExp(e.amPM[1],"i").test(n)))},M:function(t,n,e){t.setMonth(e.months.shorthand.indexOf(n))},S:function(t,n){t.setSeconds(parseFloat(n))},U:function(t,n){return new Date(1e3*parseFloat(n))},W:function(t,n,e){var o=parseInt(n),r=new Date(t.getFullYear(),0,2+7*(o-1),0,0,0,0);return r.setDate(r.getDate()-r.getDay()+e.firstDayOfWeek),r},Y:function(t,n){t.setFullYear(parseFloat(n))},Z:function(t,n){return new Date(n)},d:function(t,n){t.setDate(parseFloat(n))},h:function(t,n){t.setHours((t.getHours()>=12?12:0)+parseFloat(n))},i:function(t,n){t.setMinutes(parseFloat(n))},j:function(t,n){t.setDate(parseFloat(n))},l:a,m:function(t,n){t.setMonth(parseFloat(n)-1)},n:function(t,n){t.setMonth(parseFloat(n)-1)},s:function(t,n){t.setSeconds(parseFloat(n))},u:function(t,n){return new Date(parseFloat(n))},w:a,y:function(t,n){t.setFullYear(2e3+parseFloat(n))}},e.tokenRegex={D:"",F:"",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"},e.formats={Z:function(t){return t.toISOString()},D:function(t,n,o){return n.weekdays.shorthand[e.formats.w(t,n,o)]},F:function(t,n,o){return(0,e.monthToStr)(e.formats.n(t,n,o)-1,!1,n)},G:function(t,n,o){return(0,u.pad)(e.formats.h(t,n,o))},H:function(t){return(0,u.pad)(t.getHours())},J:function(t,n){return void 0!==n.ordinal?t.getDate()+n.ordinal(t.getDate()):t.getDate()},K:function(t,n){return n.amPM[(0,u.int)(t.getHours()>11)]},M:function(t,n){return(0,e.monthToStr)(t.getMonth(),!0,n)},S:function(t){return(0,u.pad)(t.getSeconds())},U:function(t){return t.getTime()/1e3},W:function(t,n,e){return e.getWeek(t)},Y:function(t){return(0,u.pad)(t.getFullYear(),4)},d:function(t){return(0,u.pad)(t.getDate())},h:function(t){return t.getHours()%12?t.getHours()%12:12},i:function(t){return(0,u.pad)(t.getMinutes())},j:function(t){return t.getDate()},l:function(t,n){return n.weekdays.longhand[t.getDay()]},m:function(t){return(0,u.pad)(t.getMonth()+1)},n:function(t){return t.getMonth()+1},s:function(t){return t.getSeconds()},u:function(t){return t.getTime()},w:function(t){return t.getDay()},y:function(t){return String(t.getFullYear()).substring(2)}}},
"6f45019dc1": function _(n,t,o,r,e){"function"!=typeof Object.assign&&(Object.assign=function(n){for(var t=[],o=1;o<arguments.length;o++)t[o-1]=arguments[o];if(!n)throw TypeError("Cannot convert undefined or null to object");for(var r=function(t){t&&Object.keys(t).forEach((function(o){return n[o]=t[o]}))},e=0,c=t;e<c.length;e++){r(c[e])}return n})},
"c97cc0eade": function _(e,t,r,i,s){var o;i();const l=e("@bokehjs/core/util/templating"),a=e("@bokehjs/models/widgets/sliders/numerical_slider"),_=e("@bokehjs/core/util/types");class c extends a.NumericalSliderView{constructor(){super(...arguments),this.behaviour="tap",this.connected=[!0,!1]}_calc_to(){const e=super._calc_to();return e.step*=1e3,e}_formatter(e,t){return(0,_.isString)(t)?l.DEFAULT_FORMATTERS.datetime(e,t,{}):t.compute(e)}}r.DatetimeSliderView=c,c.__name__="DatetimeSliderView";class d extends a.NumericalSlider{constructor(e){super(e)}}r.DatetimeSlider=d,o=d,d.__name__="DatetimeSlider",d.__module__="panel.models.datetime_slider",o.prototype.default_view=c,o.override({step:60,format:"%d %b %Y %H:%M:%S"})},
"01df2ec63b": function _(require,module,exports,__esModule,__esExport){var _a;__esModule();const dom_1=require("@bokehjs/core/dom"),types_1=require("@bokehjs/core/util/types"),layout_dom_1=require("@bokehjs/models/layouts/layout_dom"),column_data_source_1=require("@bokehjs/models/sources/column_data_source"),debounce_1=require("99a25e6992"),data_1=require("be689f0377"),layout_1=require("9b11ce01a3"),lumagl_1=require("a49afbffe9"),tooltips_1=require("f8f8ea4284");function extractClasses(){const e={},t=window.deck,o=Object.keys(t).filter((e=>e.charAt(0)===e.charAt(0).toUpperCase()));for(const i of o)e[i]=t[i];const i=window.CartoLibrary,s=Object.keys(i.CARTO_LAYERS).filter((e=>e.endsWith("Layer")));for(const t of s)e[t]=i.CARTO_LAYERS[t];return e}function extractFunctions(){const e=window.CartoLibrary,t=Object.keys(e.CARTO_SOURCES).filter((e=>e.toLowerCase().endsWith("source"))),o={};for(const i of t)o[i]=e.CARTO_SOURCES[i];return o}class DeckGLPlotView extends layout_dom_1.LayoutDOMView{constructor(){super(...arguments),this._initialized=!1}connect_signals(){super.connect_signals();const{data:e,mapbox_api_key:t,tooltip:o,configuration:i,layers:s,initialViewState:a,data_sources:r}=this.model.properties;this.on_change([t,o,i],(()=>this.rerender_())),this.on_change([e,a],(()=>this.updateDeck())),this.on_change([s],(()=>this._update_layers())),this.on_change([r],(()=>this._connect_sources(!0))),this._layer_map={},this._connected=[],this._connect_sources()}remove(){this.deckGL.finalize(),super.remove()}_update_layers(){this._layer_map={},this._update_data(!0)}_connect_sources(e=!1){for(const e of this.model.data_sources)this._connected.indexOf(e)<0&&(this.on_change(e.properties.data,(()=>this._update_data(!0))),this._connected.push(e));this._update_data(e)}initialize(){super.initialize();const e=this.model.throttle.view||200;if(this._view_cb=(0,debounce_1.debounce)((e=>this._on_viewState_event(e)),e,!1),window.deck.JSONConverter){const{CSVLoader:e,Tiles3DLoader:t}=window.loaders;window.loaders.registerLoaders([t,e]);const o={classes:extractClasses(),functions:extractFunctions(),enumerations:{COORDINATE_SYSTEM:window.deck.COORDINATE_SYSTEM,GL:lumagl_1.GL},constants:{Tiles3DLoader:t}};this.jsonConverter=new window.deck.JSONConverter({configuration:o})}}_update_data(e=!0){let t=0;for(const e of this.model.layers){let o;if(t+=1,t-1 in this._layer_map)o=this.model.data_sources[this._layer_map[t-1]];else{if(!(0,types_1.isNumber)(e.data))continue;this._layer_map[t-1]=e.data,o=this.model.data_sources[e.data]}e.data=(0,data_1.transform_cds_to_records)(o)}e&&this.updateDeck()}_on_click_event(e){const t={coordinate:e.coordinate,lngLat:e.coordinate,index:e.index};e.layer&&(t.layer=e.layer.id),this.model.clickState=t}_on_hover_event(e){if(null==e.coordinate)return;const t={coordinate:e.coordinate,lngLat:e.coordinate,index:e.index};e.layer&&(t.layer=e.layer.id),this.model.hoverState=t}_on_viewState_event(e){const t={...e.viewState};delete t.normalize;for(const e in t)e.startsWith("transition")&&delete t[e];const o=new window.deck.WebMercatorViewport(t);t.nw=o.unproject([0,0]),t.se=o.unproject([o.width,o.height]),this.model.viewState=t}get child_models(){return[]}getData(){const e=this.model.throttle.hover||100,t=(0,debounce_1.debounce)((e=>this._on_hover_event(e)),e,!1);return{...this.model.data,layers:this.model.layers,initialViewState:this.model.initialViewState,onViewStateChange:e=>this._sync_viewstate(e),onClick:e=>this._on_click_event(e),onHover:t}}_sync_viewstate(e){if(this._map){const{longitude:t,latitude:o,...i}=e.viewState;this._map.jumpTo({center:[t,o],...i})}this._view_cb(e)}rerender_(){this.rerender?this.rerender():(this.render(),this.r_after_render())}updateDeck(){if(!this.deckGL)return void this.rerender_();const e=this.getData();if(window.deck.updateDeck)window.deck.updateDeck(e,this.deckGL);else{const t=this.jsonConverter.convert(e);this.deckGL.setProps(t)}}createDeck({mapboxApiKey,container,jsonInput,tooltip}){let deckgl;try{let configuration;configuration=this.model.configuration?eval(`(${this.model.configuration})`):null,this.jsonConverter.mergeConfiguration(configuration);const props=this.jsonConverter.convert(jsonInput),getTooltip=(0,tooltips_1.makeTooltip)(tooltip,props.layers);null===props.mapStyle?props.map=null:props.mapStyle.includes("carto")?(this._map=new window.maplibregl.Map({container,style:props.mapStyle,interactive:!1}),props.controller=!0,props.map=null,delete props.mapStyle):(props.map=window.mapboxgl,props.mapboxApiAccessToken=mapboxApiKey),deckgl=new window.deck.DeckGL({...props,container,getTooltip,height:"100%",width:"100%"})}catch(e){console.error(e)}return deckgl}render(){super.render();const e=(0,dom_1.div)({class:"deckgl"});(0,layout_1.set_size)(e,this.model,!1);const t=this.model.mapbox_api_key,o=this.model.tooltip,i=this.getData();window.deck.createDeck?this.deckGL=window.deck.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}):this.deckGL=this.createDeck({mapboxApiKey:t,container:e,jsonInput:i,tooltip:o}),this.shadow_el.appendChild(e),this._initialized=!1}resize(){null!=this.deckGL&&(this.deckGL.redraw(!0),this._map&&this._map.resize())}after_layout(){super.after_layout(),this._initialized||this.resize(),this._initialized=!0}after_resize(){super.after_resize(),this.resize()}}exports.DeckGLPlotView=DeckGLPlotView,DeckGLPlotView.__name__="DeckGLPlotView";class DeckGLPlot extends layout_dom_1.LayoutDOM{constructor(e){super(e)}}exports.DeckGLPlot=DeckGLPlot,_a=DeckGLPlot,DeckGLPlot.__name__="DeckGLPlot",DeckGLPlot.__module__="panel.models.deckgl",_a.prototype.default_view=DeckGLPlotView,_a.define((({Any:e,List:t,Str:o,Ref:i})=>({data:[e],data_sources:[t(i(column_data_source_1.ColumnDataSource)),[]],clickState:[e,{}],hoverState:[e,{}],initialViewState:[e,{}],layers:[t(e),[]],mapbox_api_key:[o,""],throttle:[e,{}],tooltip:[e,!0],configuration:[o,""],viewState:[e,{}]}))),_a.override({height:400,width:600})},
"a49afbffe9": function _(_,E,R,T,A){
// SPDX-License-Identifier: MIT
// Copyright (c) vis.gl contributors
var S;T(),function(_){_[_.DEPTH_BUFFER_BIT=256]="DEPTH_BUFFER_BIT",_[_.STENCIL_BUFFER_BIT=1024]="STENCIL_BUFFER_BIT",_[_.COLOR_BUFFER_BIT=16384]="COLOR_BUFFER_BIT",_[_.POINTS=0]="POINTS",_[_.LINES=1]="LINES",_[_.LINE_LOOP=2]="LINE_LOOP",_[_.LINE_STRIP=3]="LINE_STRIP",_[_.TRIANGLES=4]="TRIANGLES",_[_.TRIANGLE_STRIP=5]="TRIANGLE_STRIP",_[_.TRIANGLE_FAN=6]="TRIANGLE_FAN",_[_.ZERO=0]="ZERO",_[_.ONE=1]="ONE",_[_.SRC_COLOR=768]="SRC_COLOR",_[_.ONE_MINUS_SRC_COLOR=769]="ONE_MINUS_SRC_COLOR",_[_.SRC_ALPHA=770]="SRC_ALPHA",_[_.ONE_MINUS_SRC_ALPHA=771]="ONE_MINUS_SRC_ALPHA",_[_.DST_ALPHA=772]="DST_ALPHA",_[_.ONE_MINUS_DST_ALPHA=773]="ONE_MINUS_DST_ALPHA",_[_.DST_COLOR=774]="DST_COLOR",_[_.ONE_MINUS_DST_COLOR=775]="ONE_MINUS_DST_COLOR",_[_.SRC_ALPHA_SATURATE=776]="SRC_ALPHA_SATURATE",_[_.CONSTANT_COLOR=32769]="CONSTANT_COLOR",_[_.ONE_MINUS_CONSTANT_COLOR=32770]="ONE_MINUS_CONSTANT_COLOR",_[_.CONSTANT_ALPHA=32771]="CONSTANT_ALPHA",_[_.ONE_MINUS_CONSTANT_ALPHA=32772]="ONE_MINUS_CONSTANT_ALPHA",_[_.FUNC_ADD=32774]="FUNC_ADD",_[_.FUNC_SUBTRACT=32778]="FUNC_SUBTRACT",_[_.FUNC_REVERSE_SUBTRACT=32779]="FUNC_REVERSE_SUBTRACT",_[_.BLEND_EQUATION=32777]="BLEND_EQUATION",_[_.BLEND_EQUATION_RGB=32777]="BLEND_EQUATION_RGB",_[_.BLEND_EQUATION_ALPHA=34877]="BLEND_EQUATION_ALPHA",_[_.BLEND_DST_RGB=32968]="BLEND_DST_RGB",_[_.BLEND_SRC_RGB=32969]="BLEND_SRC_RGB",_[_.BLEND_DST_ALPHA=32970]="BLEND_DST_ALPHA",_[_.BLEND_SRC_ALPHA=32971]="BLEND_SRC_ALPHA",_[_.BLEND_COLOR=32773]="BLEND_COLOR",_[_.ARRAY_BUFFER_BINDING=34964]="ARRAY_BUFFER_BINDING",_[_.ELEMENT_ARRAY_BUFFER_BINDING=34965]="ELEMENT_ARRAY_BUFFER_BINDING",_[_.LINE_WIDTH=2849]="LINE_WIDTH",_[_.ALIASED_POINT_SIZE_RANGE=33901]="ALIASED_POINT_SIZE_RANGE",_[_.ALIASED_LINE_WIDTH_RANGE=33902]="ALIASED_LINE_WIDTH_RANGE",_[_.CULL_FACE_MODE=2885]="CULL_FACE_MODE",_[_.FRONT_FACE=2886]="FRONT_FACE",_[_.DEPTH_RANGE=2928]="DEPTH_RANGE",_[_.DEPTH_WRITEMASK=2930]="DEPTH_WRITEMASK",_[_.DEPTH_CLEAR_VALUE=2931]="DEPTH_CLEAR_VALUE",_[_.DEPTH_FUNC=2932]="DEPTH_FUNC",_[_.STENCIL_CLEAR_VALUE=2961]="STENCIL_CLEAR_VALUE",_[_.STENCIL_FUNC=2962]="STENCIL_FUNC",_[_.STENCIL_FAIL=2964]="STENCIL_FAIL",_[_.STENCIL_PASS_DEPTH_FAIL=2965]="STENCIL_PASS_DEPTH_FAIL",_[_.STENCIL_PASS_DEPTH_PASS=2966]="STENCIL_PASS_DEPTH_PASS",_[_.STENCIL_REF=2967]="STENCIL_REF",_[_.STENCIL_VALUE_MASK=2963]="STENCIL_VALUE_MASK",_[_.STENCIL_WRITEMASK=2968]="STENCIL_WRITEMASK",_[_.STENCIL_BACK_FUNC=34816]="STENCIL_BACK_FUNC",_[_.STENCIL_BACK_FAIL=34817]="STENCIL_BACK_FAIL",_[_.STENCIL_BACK_PASS_DEPTH_FAIL=34818]="STENCIL_BACK_PASS_DEPTH_FAIL",_[_.STENCIL_BACK_PASS_DEPTH_PASS=34819]="STENCIL_BACK_PASS_DEPTH_PASS",_[_.STENCIL_BACK_REF=36003]="STENCIL_BACK_REF",_[_.STENCIL_BACK_VALUE_MASK=36004]="STENCIL_BACK_VALUE_MASK",_[_.STENCIL_BACK_WRITEMASK=36005]="STENCIL_BACK_WRITEMASK",_[_.VIEWPORT=2978]="VIEWPORT",_[_.SCISSOR_BOX=3088]="SCISSOR_BOX",_[_.COLOR_CLEAR_VALUE=3106]="COLOR_CLEAR_VALUE",_[_.COLOR_WRITEMASK=3107]="COLOR_WRITEMASK",_[_.UNPACK_ALIGNMENT=3317]="UNPACK_ALIGNMENT",_[_.PACK_ALIGNMENT=3333]="PACK_ALIGNMENT",_[_.MAX_TEXTURE_SIZE=3379]="MAX_TEXTURE_SIZE",_[_.MAX_VIEWPORT_DIMS=3386]="MAX_VIEWPORT_DIMS",_[_.SUBPIXEL_BITS=3408]="SUBPIXEL_BITS",_[_.RED_BITS=3410]="RED_BITS",_[_.GREEN_BITS=3411]="GREEN_BITS",_[_.BLUE_BITS=3412]="BLUE_BITS",_[_.ALPHA_BITS=3413]="ALPHA_BITS",_[_.DEPTH_BITS=3414]="DEPTH_BITS",_[_.STENCIL_BITS=3415]="STENCIL_BITS",_[_.POLYGON_OFFSET_UNITS=10752]="POLYGON_OFFSET_UNITS",_[_.POLYGON_OFFSET_FACTOR=32824]="POLYGON_OFFSET_FACTOR",_[_.TEXTURE_BINDING_2D=32873]="TEXTURE_BINDING_2D",_[_.SAMPLE_BUFFERS=32936]="SAMPLE_BUFFERS",_[_.SAMPLES=32937]="SAMPLES",_[_.SAMPLE_COVERAGE_VALUE=32938]="SAMPLE_COVERAGE_VALUE",_[_.SAMPLE_COVERAGE_INVERT=32939]="SAMPLE_COVERAGE_INVERT",_[_.COMPRESSED_TEXTURE_FORMATS=34467]="COMPRESSED_TEXTURE_FORMATS",_[_.VENDOR=7936]="VENDOR",_[_.RENDERER=7937]="RENDERER",_[_.VERSION=7938]="VERSION",_[_.IMPLEMENTATION_COLOR_READ_TYPE=35738]="IMPLEMENTATION_COLOR_READ_TYPE",_[_.IMPLEMENTATION_COLOR_READ_FORMAT=35739]="IMPLEMENTATION_COLOR_READ_FORMAT",_[_.BROWSER_DEFAULT_WEBGL=37444]="BROWSER_DEFAULT_WEBGL",_[_.STATIC_DRAW=35044]="STATIC_DRAW",_[_.STREAM_DRAW=35040]="STREAM_DRAW",_[_.DYNAMIC_DRAW=35048]="DYNAMIC_DRAW",_[_.ARRAY_BUFFER=34962]="ARRAY_BUFFER",_[_.ELEMENT_ARRAY_BUFFER=34963]="ELEMENT_ARRAY_BUFFER",_[_.BUFFER_SIZE=34660]="BUFFER_SIZE",_[_.BUFFER_USAGE=34661]="BUFFER_USAGE",_[_.CURRENT_VERTEX_ATTRIB=34342]="CURRENT_VERTEX_ATTRIB",_[_.VERTEX_ATTRIB_ARRAY_ENABLED=34338]="VERTEX_ATTRIB_ARRAY_ENABLED",_[_.VERTEX_ATTRIB_ARRAY_SIZE=34339]="VERTEX_ATTRIB_ARRAY_SIZE",_[_.VERTEX_ATTRIB_ARRAY_STRIDE=34340]="VERTEX_ATTRIB_ARRAY_STRIDE",_[_.VERTEX_ATTRIB_ARRAY_TYPE=34341]="VERTEX_ATTRIB_ARRAY_TYPE",_[_.VERTEX_ATTRIB_ARRAY_NORMALIZED=34922]="VERTEX_ATTRIB_ARRAY_NORMALIZED",_[_.VERTEX_ATTRIB_ARRAY_POINTER=34373]="VERTEX_ATTRIB_ARRAY_POINTER",_[_.VERTEX_ATTRIB_ARRAY_BUFFER_BINDING=34975]="VERTEX_ATTRIB_ARRAY_BUFFER_BINDING",_[_.CULL_FACE=2884]="CULL_FACE",_[_.FRONT=1028]="FRONT",_[_.BACK=1029]="BACK",_[_.FRONT_AND_BACK=1032]="FRONT_AND_BACK",_[_.BLEND=3042]="BLEND",_[_.DEPTH_TEST=2929]="DEPTH_TEST",_[_.DITHER=3024]="DITHER",_[_.POLYGON_OFFSET_FILL=32823]="POLYGON_OFFSET_FILL",_[_.SAMPLE_ALPHA_TO_COVERAGE=32926]="SAMPLE_ALPHA_TO_COVERAGE",_[_.SAMPLE_COVERAGE=32928]="SAMPLE_COVERAGE",_[_.SCISSOR_TEST=3089]="SCISSOR_TEST",_[_.STENCIL_TEST=2960]="STENCIL_TEST",_[_.NO_ERROR=0]="NO_ERROR",_[_.INVALID_ENUM=1280]="INVALID_ENUM",_[_.INVALID_VALUE=1281]="INVALID_VALUE",_[_.INVALID_OPERATION=1282]="INVALID_OPERATION",_[_.OUT_OF_MEMORY=1285]="OUT_OF_MEMORY",_[_.CONTEXT_LOST_WEBGL=37442]="CONTEXT_LOST_WEBGL",_[_.CW=2304]="CW",_[_.CCW=2305]="CCW",_[_.DONT_CARE=4352]="DONT_CARE",_[_.FASTEST=4353]="FASTEST",_[_.NICEST=4354]="NICEST",_[_.GENERATE_MIPMAP_HINT=33170]="GENERATE_MIPMAP_HINT",_[_.BYTE=5120]="BYTE",_[_.UNSIGNED_BYTE=5121]="UNSIGNED_BYTE",_[_.SHORT=5122]="SHORT",_[_.UNSIGNED_SHORT=5123]="UNSIGNED_SHORT",_[_.INT=5124]="INT",_[_.UNSIGNED_INT=5125]="UNSIGNED_INT",_[_.FLOAT=5126]="FLOAT",_[_.DOUBLE=5130]="DOUBLE",_[_.DEPTH_COMPONENT=6402]="DEPTH_COMPONENT",_[_.ALPHA=6406]="ALPHA",_[_.RGB=6407]="RGB",_[_.RGBA=6408]="RGBA",_[_.LUMINANCE=6409]="LUMINANCE",_[_.LUMINANCE_ALPHA=6410]="LUMINANCE_ALPHA",_[_.UNSIGNED_SHORT_4_4_4_4=32819]="UNSIGNED_SHORT_4_4_4_4",_[_.UNSIGNED_SHORT_5_5_5_1=32820]="UNSIGNED_SHORT_5_5_5_1",_[_.UNSIGNED_SHORT_5_6_5=33635]="UNSIGNED_SHORT_5_6_5",_[_.FRAGMENT_SHADER=35632]="FRAGMENT_SHADER",_[_.VERTEX_SHADER=35633]="VERTEX_SHADER",_[_.COMPILE_STATUS=35713]="COMPILE_STATUS",_[_.DELETE_STATUS=35712]="DELETE_STATUS",_[_.LINK_STATUS=35714]="LINK_STATUS",_[_.VALIDATE_STATUS=35715]="VALIDATE_STATUS",_[_.ATTACHED_SHADERS=35717]="ATTACHED_SHADERS",_[_.ACTIVE_ATTRIBUTES=35721]="ACTIVE_ATTRIBUTES",_[_.ACTIVE_UNIFORMS=35718]="ACTIVE_UNIFORMS",_[_.MAX_VERTEX_ATTRIBS=34921]="MAX_VERTEX_ATTRIBS",_[_.MAX_VERTEX_UNIFORM_VECTORS=36347]="MAX_VERTEX_UNIFORM_VECTORS",_[_.MAX_VARYING_VECTORS=36348]="MAX_VARYING_VECTORS",_[_.MAX_COMBINED_TEXTURE_IMAGE_UNITS=35661]="MAX_COMBINED_TEXTURE_IMAGE_UNITS",_[_.MAX_VERTEX_TEXTURE_IMAGE_UNITS=35660]="MAX_VERTEX_TEXTURE_IMAGE_UNITS",_[_.MAX_TEXTURE_IMAGE_UNITS=34930]="MAX_TEXTURE_IMAGE_UNITS",_[_.MAX_FRAGMENT_UNIFORM_VECTORS=36349]="MAX_FRAGMENT_UNIFORM_VECTORS",_[_.SHADER_TYPE=35663]="SHADER_TYPE",_[_.SHADING_LANGUAGE_VERSION=35724]="SHADING_LANGUAGE_VERSION",_[_.CURRENT_PROGRAM=35725]="CURRENT_PROGRAM",_[_.NEVER=512]="NEVER",_[_.LESS=513]="LESS",_[_.EQUAL=514]="EQUAL",_[_.LEQUAL=515]="LEQUAL",_[_.GREATER=516]="GREATER",_[_.NOTEQUAL=517]="NOTEQUAL",_[_.GEQUAL=518]="GEQUAL",_[_.ALWAYS=519]="ALWAYS",_[_.KEEP=7680]="KEEP",_[_.REPLACE=7681]="REPLACE",_[_.INCR=7682]="INCR",_[_.DECR=7683]="DECR",_[_.INVERT=5386]="INVERT",_[_.INCR_WRAP=34055]="INCR_WRAP",_[_.DECR_WRAP=34056]="DECR_WRAP",_[_.NEAREST=9728]="NEAREST",_[_.LINEAR=9729]="LINEAR",_[_.NEAREST_MIPMAP_NEAREST=9984]="NEAREST_MIPMAP_NEAREST",_[_.LINEAR_MIPMAP_NEAREST=9985]="LINEAR_MIPMAP_NEAREST",_[_.NEAREST_MIPMAP_LINEAR=9986]="NEAREST_MIPMAP_LINEAR",_[_.LINEAR_MIPMAP_LINEAR=9987]="LINEAR_MIPMAP_LINEAR",_[_.TEXTURE_MAG_FILTER=10240]="TEXTURE_MAG_FILTER",_[_.TEXTURE_MIN_FILTER=10241]="TEXTURE_MIN_FILTER",_[_.TEXTURE_WRAP_S=10242]="TEXTURE_WRAP_S",_[_.TEXTURE_WRAP_T=10243]="TEXTURE_WRAP_T",_[_.TEXTURE_2D=3553]="TEXTURE_2D",_[_.TEXTURE=5890]="TEXTURE",_[_.TEXTURE_CUBE_MAP=34067]="TEXTURE_CUBE_MAP",_[_.TEXTURE_BINDING_CUBE_MAP=34068]="TEXTURE_BINDING_CUBE_MAP",_[_.TEXTURE_CUBE_MAP_POSITIVE_X=34069]="TEXTURE_CUBE_MAP_POSITIVE_X",_[_.TEXTURE_CUBE_MAP_NEGATIVE_X=34070]="TEXTURE_CUBE_MAP_NEGATIVE_X",_[_.TEXTURE_CUBE_MAP_POSITIVE_Y=34071]="TEXTURE_CUBE_MAP_POSITIVE_Y",_[_.TEXTURE_CUBE_MAP_NEGATIVE_Y=34072]="TEXTURE_CUBE_MAP_NEGATIVE_Y",_[_.TEXTURE_CUBE_MAP_POSITIVE_Z=34073]="TEXTURE_CUBE_MAP_POSITIVE_Z",_[_.TEXTURE_CUBE_MAP_NEGATIVE_Z=34074]="TEXTURE_CUBE_MAP_NEGATIVE_Z",_[_.MAX_CUBE_MAP_TEXTURE_SIZE=34076]="MAX_CUBE_MAP_TEXTURE_SIZE",_[_.TEXTURE0=33984]="TEXTURE0",_[_.ACTIVE_TEXTURE=34016]="ACTIVE_TEXTURE",_[_.REPEAT=10497]="REPEAT",_[_.CLAMP_TO_EDGE=33071]="CLAMP_TO_EDGE",_[_.MIRRORED_REPEAT=33648]="MIRRORED_REPEAT",_[_.TEXTURE_WIDTH=4096]="TEXTURE_WIDTH",_[_.TEXTURE_HEIGHT=4097]="TEXTURE_HEIGHT",_[_.FLOAT_VEC2=35664]="FLOAT_VEC2",_[_.FLOAT_VEC3=35665]="FLOAT_VEC3",_[_.FLOAT_VEC4=35666]="FLOAT_VEC4",_[_.INT_VEC2=35667]="INT_VEC2",_[_.INT_VEC3=35668]="INT_VEC3",_[_.INT_VEC4=35669]="INT_VEC4",_[_.BOOL=35670]="BOOL",_[_.BOOL_VEC2=35671]="BOOL_VEC2",_[_.BOOL_VEC3=35672]="BOOL_VEC3",_[_.BOOL_VEC4=35673]="BOOL_VEC4",_[_.FLOAT_MAT2=35674]="FLOAT_MAT2",_[_.FLOAT_MAT3=35675]="FLOAT_MAT3",_[_.FLOAT_MAT4=35676]="FLOAT_MAT4",_[_.SAMPLER_2D=35678]="SAMPLER_2D",_[_.SAMPLER_CUBE=35680]="SAMPLER_CUBE",_[_.LOW_FLOAT=36336]="LOW_FLOAT",_[_.MEDIUM_FLOAT=36337]="MEDIUM_FLOAT",_[_.HIGH_FLOAT=36338]="HIGH_FLOAT",_[_.LOW_INT=36339]="LOW_INT",_[_.MEDIUM_INT=36340]="MEDIUM_INT",_[_.HIGH_INT=36341]="HIGH_INT",_[_.FRAMEBUFFER=36160]="FRAMEBUFFER",_[_.RENDERBUFFER=36161]="RENDERBUFFER",_[_.RGBA4=32854]="RGBA4",_[_.RGB5_A1=32855]="RGB5_A1",_[_.RGB565=36194]="RGB565",_[_.DEPTH_COMPONENT16=33189]="DEPTH_COMPONENT16",_[_.STENCIL_INDEX=6401]="STENCIL_INDEX",_[_.STENCIL_INDEX8=36168]="STENCIL_INDEX8",_[_.DEPTH_STENCIL=34041]="DEPTH_STENCIL",_[_.RENDERBUFFER_WIDTH=36162]="RENDERBUFFER_WIDTH",_[_.RENDERBUFFER_HEIGHT=36163]="RENDERBUFFER_HEIGHT",_[_.RENDERBUFFER_INTERNAL_FORMAT=36164]="RENDERBUFFER_INTERNAL_FORMAT",_[_.RENDERBUFFER_RED_SIZE=36176]="RENDERBUFFER_RED_SIZE",_[_.RENDERBUFFER_GREEN_SIZE=36177]="RENDERBUFFER_GREEN_SIZE",_[_.RENDERBUFFER_BLUE_SIZE=36178]="RENDERBUFFER_BLUE_SIZE",_[_.RENDERBUFFER_ALPHA_SIZE=36179]="RENDERBUFFER_ALPHA_SIZE",_[_.RENDERBUFFER_DEPTH_SIZE=36180]="RENDERBUFFER_DEPTH_SIZE",_[_.RENDERBUFFER_STENCIL_SIZE=36181]="RENDERBUFFER_STENCIL_SIZE",_[_.FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE=36048]="FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE",_[_.FRAMEBUFFER_ATTACHMENT_OBJECT_NAME=36049]="FRAMEBUFFER_ATTACHMENT_OBJECT_NAME",_[_.FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL=36050]="FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL",_[_.FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE=36051]="FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE",_[_.COLOR_ATTACHMENT0=36064]="COLOR_ATTACHMENT0",_[_.DEPTH_ATTACHMENT=36096]="DEPTH_ATTACHMENT",_[_.STENCIL_ATTACHMENT=36128]="STENCIL_ATTACHMENT",_[_.DEPTH_STENCIL_ATTACHMENT=33306]="DEPTH_STENCIL_ATTACHMENT",_[_.NONE=0]="NONE",_[_.FRAMEBUFFER_COMPLETE=36053]="FRAMEBUFFER_COMPLETE",_[_.FRAMEBUFFER_INCOMPLETE_ATTACHMENT=36054]="FRAMEBUFFER_INCOMPLETE_ATTACHMENT",_[_.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT=36055]="FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT",_[_.FRAMEBUFFER_INCOMPLETE_DIMENSIONS=36057]="FRAMEBUFFER_INCOMPLETE_DIMENSIONS",_[_.FRAMEBUFFER_UNSUPPORTED=36061]="FRAMEBUFFER_UNSUPPORTED",_[_.FRAMEBUFFER_BINDING=36006]="FRAMEBUFFER_BINDING",_[_.RENDERBUFFER_BINDING=36007]="RENDERBUFFER_BINDING",_[_.READ_FRAMEBUFFER=36008]="READ_FRAMEBUFFER",_[_.DRAW_FRAMEBUFFER=36009]="DRAW_FRAMEBUFFER",_[_.MAX_RENDERBUFFER_SIZE=34024]="MAX_RENDERBUFFER_SIZE",_[_.INVALID_FRAMEBUFFER_OPERATION=1286]="INVALID_FRAMEBUFFER_OPERATION",_[_.UNPACK_FLIP_Y_WEBGL=37440]="UNPACK_FLIP_Y_WEBGL",_[_.UNPACK_PREMULTIPLY_ALPHA_WEBGL=37441]="UNPACK_PREMULTIPLY_ALPHA_WEBGL",_[_.UNPACK_COLORSPACE_CONVERSION_WEBGL=37443]="UNPACK_COLORSPACE_CONVERSION_WEBGL",_[_.READ_BUFFER=3074]="READ_BUFFER",_[_.UNPACK_ROW_LENGTH=3314]="UNPACK_ROW_LENGTH",_[_.UNPACK_SKIP_ROWS=3315]="UNPACK_SKIP_ROWS",_[_.UNPACK_SKIP_PIXELS=3316]="UNPACK_SKIP_PIXELS",_[_.PACK_ROW_LENGTH=3330]="PACK_ROW_LENGTH",_[_.PACK_SKIP_ROWS=3331]="PACK_SKIP_ROWS",_[_.PACK_SKIP_PIXELS=3332]="PACK_SKIP_PIXELS",_[_.TEXTURE_BINDING_3D=32874]="TEXTURE_BINDING_3D",_[_.UNPACK_SKIP_IMAGES=32877]="UNPACK_SKIP_IMAGES",_[_.UNPACK_IMAGE_HEIGHT=32878]="UNPACK_IMAGE_HEIGHT",_[_.MAX_3D_TEXTURE_SIZE=32883]="MAX_3D_TEXTURE_SIZE",_[_.MAX_ELEMENTS_VERTICES=33e3]="MAX_ELEMENTS_VERTICES",_[_.MAX_ELEMENTS_INDICES=33001]="MAX_ELEMENTS_INDICES",_[_.MAX_TEXTURE_LOD_BIAS=34045]="MAX_TEXTURE_LOD_BIAS",_[_.MAX_FRAGMENT_UNIFORM_COMPONENTS=35657]="MAX_FRAGMENT_UNIFORM_COMPONENTS",_[_.MAX_VERTEX_UNIFORM_COMPONENTS=35658]="MAX_VERTEX_UNIFORM_COMPONENTS",_[_.MAX_ARRAY_TEXTURE_LAYERS=35071]="MAX_ARRAY_TEXTURE_LAYERS",_[_.MIN_PROGRAM_TEXEL_OFFSET=35076]="MIN_PROGRAM_TEXEL_OFFSET",_[_.MAX_PROGRAM_TEXEL_OFFSET=35077]="MAX_PROGRAM_TEXEL_OFFSET",_[_.MAX_VARYING_COMPONENTS=35659]="MAX_VARYING_COMPONENTS",_[_.FRAGMENT_SHADER_DERIVATIVE_HINT=35723]="FRAGMENT_SHADER_DERIVATIVE_HINT",_[_.RASTERIZER_DISCARD=35977]="RASTERIZER_DISCARD",_[_.VERTEX_ARRAY_BINDING=34229]="VERTEX_ARRAY_BINDING",_[_.MAX_VERTEX_OUTPUT_COMPONENTS=37154]="MAX_VERTEX_OUTPUT_COMPONENTS",_[_.MAX_FRAGMENT_INPUT_COMPONENTS=37157]="MAX_FRAGMENT_INPUT_COMPONENTS",_[_.MAX_SERVER_WAIT_TIMEOUT=37137]="MAX_SERVER_WAIT_TIMEOUT",_[_.MAX_ELEMENT_INDEX=36203]="MAX_ELEMENT_INDEX",_[_.RED=6403]="RED",_[_.RGB8=32849]="RGB8",_[_.RGBA8=32856]="RGBA8",_[_.RGB10_A2=32857]="RGB10_A2",_[_.TEXTURE_3D=32879]="TEXTURE_3D",_[_.TEXTURE_WRAP_R=32882]="TEXTURE_WRAP_R",_[_.TEXTURE_MIN_LOD=33082]="TEXTURE_MIN_LOD",_[_.TEXTURE_MAX_LOD=33083]="TEXTURE_MAX_LOD",_[_.TEXTURE_BASE_LEVEL=33084]="TEXTURE_BASE_LEVEL",_[_.TEXTURE_MAX_LEVEL=33085]="TEXTURE_MAX_LEVEL",_[_.TEXTURE_COMPARE_MODE=34892]="TEXTURE_COMPARE_MODE",_[_.TEXTURE_COMPARE_FUNC=34893]="TEXTURE_COMPARE_FUNC",_[_.SRGB=35904]="SRGB",_[_.SRGB8=35905]="SRGB8",_[_.SRGB8_ALPHA8=35907]="SRGB8_ALPHA8",_[_.COMPARE_REF_TO_TEXTURE=34894]="COMPARE_REF_TO_TEXTURE",_[_.RGBA32F=34836]="RGBA32F",_[_.RGB32F=34837]="RGB32F",_[_.RGBA16F=34842]="RGBA16F",_[_.RGB16F=34843]="RGB16F",_[_.TEXTURE_2D_ARRAY=35866]="TEXTURE_2D_ARRAY",_[_.TEXTURE_BINDING_2D_ARRAY=35869]="TEXTURE_BINDING_2D_ARRAY",_[_.R11F_G11F_B10F=35898]="R11F_G11F_B10F",_[_.RGB9_E5=35901]="RGB9_E5",_[_.RGBA32UI=36208]="RGBA32UI",_[_.RGB32UI=36209]="RGB32UI",_[_.RGBA16UI=36214]="RGBA16UI",_[_.RGB16UI=36215]="RGB16UI",_[_.RGBA8UI=36220]="RGBA8UI",_[_.RGB8UI=36221]="RGB8UI",_[_.RGBA32I=36226]="RGBA32I",_[_.RGB32I=36227]="RGB32I",_[_.RGBA16I=36232]="RGBA16I",_[_.RGB16I=36233]="RGB16I",_[_.RGBA8I=36238]="RGBA8I",_[_.RGB8I=36239]="RGB8I",_[_.RED_INTEGER=36244]="RED_INTEGER",_[_.RGB_INTEGER=36248]="RGB_INTEGER",_[_.RGBA_INTEGER=36249]="RGBA_INTEGER",_[_.R8=33321]="R8",_[_.RG8=33323]="RG8",_[_.R16F=33325]="R16F",_[_.R32F=33326]="R32F",_[_.RG16F=33327]="RG16F",_[_.RG32F=33328]="RG32F",_[_.R8I=33329]="R8I",_[_.R8UI=33330]="R8UI",_[_.R16I=33331]="R16I",_[_.R16UI=33332]="R16UI",_[_.R32I=33333]="R32I",_[_.R32UI=33334]="R32UI",_[_.RG8I=33335]="RG8I",_[_.RG8UI=33336]="RG8UI",_[_.RG16I=33337]="RG16I",_[_.RG16UI=33338]="RG16UI",_[_.RG32I=33339]="RG32I",_[_.RG32UI=33340]="RG32UI",_[_.R8_SNORM=36756]="R8_SNORM",_[_.RG8_SNORM=36757]="RG8_SNORM",_[_.RGB8_SNORM=36758]="RGB8_SNORM",_[_.RGBA8_SNORM=36759]="RGBA8_SNORM",_[_.RGB10_A2UI=36975]="RGB10_A2UI",_[_.TEXTURE_IMMUTABLE_FORMAT=37167]="TEXTURE_IMMUTABLE_FORMAT",_[_.TEXTURE_IMMUTABLE_LEVELS=33503]="TEXTURE_IMMUTABLE_LEVELS",_[_.UNSIGNED_INT_2_10_10_10_REV=33640]="UNSIGNED_INT_2_10_10_10_REV",_[_.UNSIGNED_INT_10F_11F_11F_REV=35899]="UNSIGNED_INT_10F_11F_11F_REV",_[_.UNSIGNED_INT_5_9_9_9_REV=35902]="UNSIGNED_INT_5_9_9_9_REV",_[_.FLOAT_32_UNSIGNED_INT_24_8_REV=36269]="FLOAT_32_UNSIGNED_INT_24_8_REV",_[_.UNSIGNED_INT_24_8=34042]="UNSIGNED_INT_24_8",_[_.HALF_FLOAT=5131]="HALF_FLOAT",_[_.RG=33319]="RG",_[_.RG_INTEGER=33320]="RG_INTEGER",_[_.INT_2_10_10_10_REV=36255]="INT_2_10_10_10_REV",_[_.CURRENT_QUERY=34917]="CURRENT_QUERY",_[_.QUERY_RESULT=34918]="QUERY_RESULT",_[_.QUERY_RESULT_AVAILABLE=34919]="QUERY_RESULT_AVAILABLE",_[_.ANY_SAMPLES_PASSED=35887]="ANY_SAMPLES_PASSED",_[_.ANY_SAMPLES_PASSED_CONSERVATIVE=36202]="ANY_SAMPLES_PASSED_CONSERVATIVE",_[_.MAX_DRAW_BUFFERS=34852]="MAX_DRAW_BUFFERS",_[_.DRAW_BUFFER0=34853]="DRAW_BUFFER0",_[_.DRAW_BUFFER1=34854]="DRAW_BUFFER1",_[_.DRAW_BUFFER2=34855]="DRAW_BUFFER2",_[_.DRAW_BUFFER3=34856]="DRAW_BUFFER3",_[_.DRAW_BUFFER4=34857]="DRAW_BUFFER4",_[_.DRAW_BUFFER5=34858]="DRAW_BUFFER5",_[_.DRAW_BUFFER6=34859]="DRAW_BUFFER6",_[_.DRAW_BUFFER7=34860]="DRAW_BUFFER7",_[_.DRAW_BUFFER8=34861]="DRAW_BUFFER8",_[_.DRAW_BUFFER9=34862]="DRAW_BUFFER9",_[_.DRAW_BUFFER10=34863]="DRAW_BUFFER10",_[_.DRAW_BUFFER11=34864]="DRAW_BUFFER11",_[_.DRAW_BUFFER12=34865]="DRAW_BUFFER12",_[_.DRAW_BUFFER13=34866]="DRAW_BUFFER13",_[_.DRAW_BUFFER14=34867]="DRAW_BUFFER14",_[_.DRAW_BUFFER15=34868]="DRAW_BUFFER15",_[_.MAX_COLOR_ATTACHMENTS=36063]="MAX_COLOR_ATTACHMENTS",_[_.COLOR_ATTACHMENT1=36065]="COLOR_ATTACHMENT1",_[_.COLOR_ATTACHMENT2=36066]="COLOR_ATTACHMENT2",_[_.COLOR_ATTACHMENT3=36067]="COLOR_ATTACHMENT3",_[_.COLOR_ATTACHMENT4=36068]="COLOR_ATTACHMENT4",_[_.COLOR_ATTACHMENT5=36069]="COLOR_ATTACHMENT5",_[_.COLOR_ATTACHMENT6=36070]="COLOR_ATTACHMENT6",_[_.COLOR_ATTACHMENT7=36071]="COLOR_ATTACHMENT7",_[_.COLOR_ATTACHMENT8=36072]="COLOR_ATTACHMENT8",_[_.COLOR_ATTACHMENT9=36073]="COLOR_ATTACHMENT9",_[_.COLOR_ATTACHMENT10=36074]="COLOR_ATTACHMENT10",_[_.COLOR_ATTACHMENT11=36075]="COLOR_ATTACHMENT11",_[_.COLOR_ATTACHMENT12=36076]="COLOR_ATTACHMENT12",_[_.COLOR_ATTACHMENT13=36077]="COLOR_ATTACHMENT13",_[_.COLOR_ATTACHMENT14=36078]="COLOR_ATTACHMENT14",_[_.COLOR_ATTACHMENT15=36079]="COLOR_ATTACHMENT15",_[_.SAMPLER_3D=35679]="SAMPLER_3D",_[_.SAMPLER_2D_SHADOW=35682]="SAMPLER_2D_SHADOW",_[_.SAMPLER_2D_ARRAY=36289]="SAMPLER_2D_ARRAY",_[_.SAMPLER_2D_ARRAY_SHADOW=36292]="SAMPLER_2D_ARRAY_SHADOW",_[_.SAMPLER_CUBE_SHADOW=36293]="SAMPLER_CUBE_SHADOW",_[_.INT_SAMPLER_2D=36298]="INT_SAMPLER_2D",_[_.INT_SAMPLER_3D=36299]="INT_SAMPLER_3D",_[_.INT_SAMPLER_CUBE=36300]="INT_SAMPLER_CUBE",_[_.INT_SAMPLER_2D_ARRAY=36303]="INT_SAMPLER_2D_ARRAY",_[_.UNSIGNED_INT_SAMPLER_2D=36306]="UNSIGNED_INT_SAMPLER_2D",_[_.UNSIGNED_INT_SAMPLER_3D=36307]="UNSIGNED_INT_SAMPLER_3D",_[_.UNSIGNED_INT_SAMPLER_CUBE=36308]="UNSIGNED_INT_SAMPLER_CUBE",_[_.UNSIGNED_INT_SAMPLER_2D_ARRAY=36311]="UNSIGNED_INT_SAMPLER_2D_ARRAY",_[_.MAX_SAMPLES=36183]="MAX_SAMPLES",_[_.SAMPLER_BINDING=35097]="SAMPLER_BINDING",_[_.PIXEL_PACK_BUFFER=35051]="PIXEL_PACK_BUFFER",_[_.PIXEL_UNPACK_BUFFER=35052]="PIXEL_UNPACK_BUFFER",_[_.PIXEL_PACK_BUFFER_BINDING=35053]="PIXEL_PACK_BUFFER_BINDING",_[_.PIXEL_UNPACK_BUFFER_BINDING=35055]="PIXEL_UNPACK_BUFFER_BINDING",_[_.COPY_READ_BUFFER=36662]="COPY_READ_BUFFER",_[_.COPY_WRITE_BUFFER=36663]="COPY_WRITE_BUFFER",_[_.COPY_READ_BUFFER_BINDING=36662]="COPY_READ_BUFFER_BINDING",_[_.COPY_WRITE_BUFFER_BINDING=36663]="COPY_WRITE_BUFFER_BINDING",_[_.FLOAT_MAT2x3=35685]="FLOAT_MAT2x3",_[_.FLOAT_MAT2x4=35686]="FLOAT_MAT2x4",_[_.FLOAT_MAT3x2=35687]="FLOAT_MAT3x2",_[_.FLOAT_MAT3x4=35688]="FLOAT_MAT3x4",_[_.FLOAT_MAT4x2=35689]="FLOAT_MAT4x2",_[_.FLOAT_MAT4x3=35690]="FLOAT_MAT4x3",_[_.UNSIGNED_INT_VEC2=36294]="UNSIGNED_INT_VEC2",_[_.UNSIGNED_INT_VEC3=36295]="UNSIGNED_INT_VEC3",_[_.UNSIGNED_INT_VEC4=36296]="UNSIGNED_INT_VEC4",_[_.UNSIGNED_NORMALIZED=35863]="UNSIGNED_NORMALIZED",_[_.SIGNED_NORMALIZED=36764]="SIGNED_NORMALIZED",_[_.VERTEX_ATTRIB_ARRAY_INTEGER=35069]="VERTEX_ATTRIB_ARRAY_INTEGER",_[_.VERTEX_ATTRIB_ARRAY_DIVISOR=35070]="VERTEX_ATTRIB_ARRAY_DIVISOR",_[_.TRANSFORM_FEEDBACK_BUFFER_MODE=35967]="TRANSFORM_FEEDBACK_BUFFER_MODE",_[_.MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS=35968]="MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS",_[_.TRANSFORM_FEEDBACK_VARYINGS=35971]="TRANSFORM_FEEDBACK_VARYINGS",_[_.TRANSFORM_FEEDBACK_BUFFER_START=35972]="TRANSFORM_FEEDBACK_BUFFER_START",_[_.TRANSFORM_FEEDBACK_BUFFER_SIZE=35973]="TRANSFORM_FEEDBACK_BUFFER_SIZE",_[_.TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN=35976]="TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN",_[_.MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS=35978]="MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS",_[_.MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS=35979]="MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS",_[_.INTERLEAVED_ATTRIBS=35980]="INTERLEAVED_ATTRIBS",_[_.SEPARATE_ATTRIBS=35981]="SEPARATE_ATTRIBS",_[_.TRANSFORM_FEEDBACK_BUFFER=35982]="TRANSFORM_FEEDBACK_BUFFER",_[_.TRANSFORM_FEEDBACK_BUFFER_BINDING=35983]="TRANSFORM_FEEDBACK_BUFFER_BINDING",_[_.TRANSFORM_FEEDBACK=36386]="TRANSFORM_FEEDBACK",_[_.TRANSFORM_FEEDBACK_PAUSED=36387]="TRANSFORM_FEEDBACK_PAUSED",_[_.TRANSFORM_FEEDBACK_ACTIVE=36388]="TRANSFORM_FEEDBACK_ACTIVE",_[_.TRANSFORM_FEEDBACK_BINDING=36389]="TRANSFORM_FEEDBACK_BINDING",_[_.FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING=33296]="FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING",_[_.FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE=33297]="FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE",_[_.FRAMEBUFFER_ATTACHMENT_RED_SIZE=33298]="FRAMEBUFFER_ATTACHMENT_RED_SIZE",_[_.FRAMEBUFFER_ATTACHMENT_GREEN_SIZE=33299]="FRAMEBUFFER_ATTACHMENT_GREEN_SIZE",_[_.FRAMEBUFFER_ATTACHMENT_BLUE_SIZE=33300]="FRAMEBUFFER_ATTACHMENT_BLUE_SIZE",_[_.FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE=33301]="FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE",_[_.FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE=33302]="FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE",_[_.FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE=33303]="FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE",_[_.FRAMEBUFFER_DEFAULT=33304]="FRAMEBUFFER_DEFAULT",_[_.DEPTH24_STENCIL8=35056]="DEPTH24_STENCIL8",_[_.DRAW_FRAMEBUFFER_BINDING=36006]="DRAW_FRAMEBUFFER_BINDING",_[_.READ_FRAMEBUFFER_BINDING=36010]="READ_FRAMEBUFFER_BINDING",_[_.RENDERBUFFER_SAMPLES=36011]="RENDERBUFFER_SAMPLES",_[_.FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER=36052]="FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER",_[_.FRAMEBUFFER_INCOMPLETE_MULTISAMPLE=36182]="FRAMEBUFFER_INCOMPLETE_MULTISAMPLE",_[_.UNIFORM_BUFFER=35345]="UNIFORM_BUFFER",_[_.UNIFORM_BUFFER_BINDING=35368]="UNIFORM_BUFFER_BINDING",_[_.UNIFORM_BUFFER_START=35369]="UNIFORM_BUFFER_START",_[_.UNIFORM_BUFFER_SIZE=35370]="UNIFORM_BUFFER_SIZE",_[_.MAX_VERTEX_UNIFORM_BLOCKS=35371]="MAX_VERTEX_UNIFORM_BLOCKS",_[_.MAX_FRAGMENT_UNIFORM_BLOCKS=35373]="MAX_FRAGMENT_UNIFORM_BLOCKS",_[_.MAX_COMBINED_UNIFORM_BLOCKS=35374]="MAX_COMBINED_UNIFORM_BLOCKS",_[_.MAX_UNIFORM_BUFFER_BINDINGS=35375]="MAX_UNIFORM_BUFFER_BINDINGS",_[_.MAX_UNIFORM_BLOCK_SIZE=35376]="MAX_UNIFORM_BLOCK_SIZE",_[_.MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS=35377]="MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS",_[_.MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS=35379]="MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS",_[_.UNIFORM_BUFFER_OFFSET_ALIGNMENT=35380]="UNIFORM_BUFFER_OFFSET_ALIGNMENT",_[_.ACTIVE_UNIFORM_BLOCKS=35382]="ACTIVE_UNIFORM_BLOCKS",_[_.UNIFORM_TYPE=35383]="UNIFORM_TYPE",_[_.UNIFORM_SIZE=35384]="UNIFORM_SIZE",_[_.UNIFORM_BLOCK_INDEX=35386]="UNIFORM_BLOCK_INDEX",_[_.UNIFORM_OFFSET=35387]="UNIFORM_OFFSET",_[_.UNIFORM_ARRAY_STRIDE=35388]="UNIFORM_ARRAY_STRIDE",_[_.UNIFORM_MATRIX_STRIDE=35389]="UNIFORM_MATRIX_STRIDE",_[_.UNIFORM_IS_ROW_MAJOR=35390]="UNIFORM_IS_ROW_MAJOR",_[_.UNIFORM_BLOCK_BINDING=35391]="UNIFORM_BLOCK_BINDING",_[_.UNIFORM_BLOCK_DATA_SIZE=35392]="UNIFORM_BLOCK_DATA_SIZE",_[_.UNIFORM_BLOCK_ACTIVE_UNIFORMS=35394]="UNIFORM_BLOCK_ACTIVE_UNIFORMS",_[_.UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES=35395]="UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES",_[_.UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER=35396]="UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER",_[_.UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER=35398]="UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER",_[_.OBJECT_TYPE=37138]="OBJECT_TYPE",_[_.SYNC_CONDITION=37139]="SYNC_CONDITION",_[_.SYNC_STATUS=37140]="SYNC_STATUS",_[_.SYNC_FLAGS=37141]="SYNC_FLAGS",_[_.SYNC_FENCE=37142]="SYNC_FENCE",_[_.SYNC_GPU_COMMANDS_COMPLETE=37143]="SYNC_GPU_COMMANDS_COMPLETE",_[_.UNSIGNALED=37144]="UNSIGNALED",_[_.SIGNALED=37145]="SIGNALED",_[_.ALREADY_SIGNALED=37146]="ALREADY_SIGNALED",_[_.TIMEOUT_EXPIRED=37147]="TIMEOUT_EXPIRED",_[_.CONDITION_SATISFIED=37148]="CONDITION_SATISFIED",_[_.WAIT_FAILED=37149]="WAIT_FAILED",_[_.SYNC_FLUSH_COMMANDS_BIT=1]="SYNC_FLUSH_COMMANDS_BIT",_[_.COLOR=6144]="COLOR",_[_.DEPTH=6145]="DEPTH",_[_.STENCIL=6146]="STENCIL",_[_.MIN=32775]="MIN",_[_.MAX=32776]="MAX",_[_.DEPTH_COMPONENT24=33190]="DEPTH_COMPONENT24",_[_.STREAM_READ=35041]="STREAM_READ",_[_.STREAM_COPY=35042]="STREAM_COPY",_[_.STATIC_READ=35045]="STATIC_READ",_[_.STATIC_COPY=35046]="STATIC_COPY",_[_.DYNAMIC_READ=35049]="DYNAMIC_READ",_[_.DYNAMIC_COPY=35050]="DYNAMIC_COPY",_[_.DEPTH_COMPONENT32F=36012]="DEPTH_COMPONENT32F",_[_.DEPTH32F_STENCIL8=36013]="DEPTH32F_STENCIL8",_[_.INVALID_INDEX=4294967295]="INVALID_INDEX",_[_.TIMEOUT_IGNORED=-1]="TIMEOUT_IGNORED",_[_.MAX_CLIENT_WAIT_TIMEOUT_WEBGL=37447]="MAX_CLIENT_WAIT_TIMEOUT_WEBGL",_[_.UNMASKED_VENDOR_WEBGL=37445]="UNMASKED_VENDOR_WEBGL",_[_.UNMASKED_RENDERER_WEBGL=37446]="UNMASKED_RENDERER_WEBGL",_[_.MAX_TEXTURE_MAX_ANISOTROPY_EXT=34047]="MAX_TEXTURE_MAX_ANISOTROPY_EXT",_[_.TEXTURE_MAX_ANISOTROPY_EXT=34046]="TEXTURE_MAX_ANISOTROPY_EXT",_[_.R16_EXT=33322]="R16_EXT",_[_.RG16_EXT=33324]="RG16_EXT",_[_.RGB16_EXT=32852]="RGB16_EXT",_[_.RGBA16_EXT=32859]="RGBA16_EXT",_[_.R16_SNORM_EXT=36760]="R16_SNORM_EXT",_[_.RG16_SNORM_EXT=36761]="RG16_SNORM_EXT",_[_.RGB16_SNORM_EXT=36762]="RGB16_SNORM_EXT",_[_.RGBA16_SNORM_EXT=36763]="RGBA16_SNORM_EXT",_[_.COMPRESSED_RGB_S3TC_DXT1_EXT=33776]="COMPRESSED_RGB_S3TC_DXT1_EXT",_[_.COMPRESSED_RGBA_S3TC_DXT1_EXT=33777]="COMPRESSED_RGBA_S3TC_DXT1_EXT",_[_.COMPRESSED_RGBA_S3TC_DXT3_EXT=33778]="COMPRESSED_RGBA_S3TC_DXT3_EXT",_[_.COMPRESSED_RGBA_S3TC_DXT5_EXT=33779]="COMPRESSED_RGBA_S3TC_DXT5_EXT",_[_.COMPRESSED_SRGB_S3TC_DXT1_EXT=35916]="COMPRESSED_SRGB_S3TC_DXT1_EXT",_[_.COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT=35917]="COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT",_[_.COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT=35918]="COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT",_[_.COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT=35919]="COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT",_[_.COMPRESSED_RED_RGTC1_EXT=36283]="COMPRESSED_RED_RGTC1_EXT",_[_.COMPRESSED_SIGNED_RED_RGTC1_EXT=36284]="COMPRESSED_SIGNED_RED_RGTC1_EXT",_[_.COMPRESSED_RED_GREEN_RGTC2_EXT=36285]="COMPRESSED_RED_GREEN_RGTC2_EXT",_[_.COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT=36286]="COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT",_[_.COMPRESSED_RGBA_BPTC_UNORM_EXT=36492]="COMPRESSED_RGBA_BPTC_UNORM_EXT",_[_.COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT=36493]="COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT",_[_.COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT=36494]="COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT",_[_.COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT=36495]="COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT",_[_.COMPRESSED_R11_EAC=37488]="COMPRESSED_R11_EAC",_[_.COMPRESSED_SIGNED_R11_EAC=37489]="COMPRESSED_SIGNED_R11_EAC",_[_.COMPRESSED_RG11_EAC=37490]="COMPRESSED_RG11_EAC",_[_.COMPRESSED_SIGNED_RG11_EAC=37491]="COMPRESSED_SIGNED_RG11_EAC",_[_.COMPRESSED_RGB8_ETC2=37492]="COMPRESSED_RGB8_ETC2",_[_.COMPRESSED_RGBA8_ETC2_EAC=37493]="COMPRESSED_RGBA8_ETC2_EAC",_[_.COMPRESSED_SRGB8_ETC2=37494]="COMPRESSED_SRGB8_ETC2",_[_.COMPRESSED_SRGB8_ALPHA8_ETC2_EAC=37495]="COMPRESSED_SRGB8_ALPHA8_ETC2_EAC",_[_.COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2=37496]="COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2",_[_.COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2=37497]="COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2",_[_.COMPRESSED_RGB_PVRTC_4BPPV1_IMG=35840]="COMPRESSED_RGB_PVRTC_4BPPV1_IMG",_[_.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG=35842]="COMPRESSED_RGBA_PVRTC_4BPPV1_IMG",_[_.COMPRESSED_RGB_PVRTC_2BPPV1_IMG=35841]="COMPRESSED_RGB_PVRTC_2BPPV1_IMG",_[_.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG=35843]="COMPRESSED_RGBA_PVRTC_2BPPV1_IMG",_[_.COMPRESSED_RGB_ETC1_WEBGL=36196]="COMPRESSED_RGB_ETC1_WEBGL",_[_.COMPRESSED_RGB_ATC_WEBGL=35986]="COMPRESSED_RGB_ATC_WEBGL",_[_.COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL=35986]="COMPRESSED_RGBA_ATC_EXPLICIT_ALPHA_WEBGL",_[_.COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL=34798]="COMPRESSED_RGBA_ATC_INTERPOLATED_ALPHA_WEBGL",_[_.COMPRESSED_RGBA_ASTC_4x4_KHR=37808]="COMPRESSED_RGBA_ASTC_4x4_KHR",_[_.COMPRESSED_RGBA_ASTC_5x4_KHR=37809]="COMPRESSED_RGBA_ASTC_5x4_KHR",_[_.COMPRESSED_RGBA_ASTC_5x5_KHR=37810]="COMPRESSED_RGBA_ASTC_5x5_KHR",_[_.COMPRESSED_RGBA_ASTC_6x5_KHR=37811]="COMPRESSED_RGBA_ASTC_6x5_KHR",_[_.COMPRESSED_RGBA_ASTC_6x6_KHR=37812]="COMPRESSED_RGBA_ASTC_6x6_KHR",_[_.COMPRESSED_RGBA_ASTC_8x5_KHR=37813]="COMPRESSED_RGBA_ASTC_8x5_KHR",_[_.COMPRESSED_RGBA_ASTC_8x6_KHR=37814]="COMPRESSED_RGBA_ASTC_8x6_KHR",_[_.COMPRESSED_RGBA_ASTC_8x8_KHR=37815]="COMPRESSED_RGBA_ASTC_8x8_KHR",_[_.COMPRESSED_RGBA_ASTC_10x5_KHR=37816]="COMPRESSED_RGBA_ASTC_10x5_KHR",_[_.COMPRESSED_RGBA_ASTC_10x6_KHR=37817]="COMPRESSED_RGBA_ASTC_10x6_KHR",_[_.COMPRESSED_RGBA_ASTC_10x8_KHR=37818]="COMPRESSED_RGBA_ASTC_10x8_KHR",_[_.COMPRESSED_RGBA_ASTC_10x10_KHR=37819]="COMPRESSED_RGBA_ASTC_10x10_KHR",_[_.COMPRESSED_RGBA_ASTC_12x10_KHR=37820]="COMPRESSED_RGBA_ASTC_12x10_KHR",_[_.COMPRESSED_RGBA_ASTC_12x12_KHR=37821]="COMPRESSED_RGBA_ASTC_12x12_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR=37840]="COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR=37841]="COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR=37842]="COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR=37843]="COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR=37844]="COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR=37845]="COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR=37846]="COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR=37847]="COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR=37848]="COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR=37849]="COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR=37850]="COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR=37851]="COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR=37852]="COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR",_[_.COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR=37853]="COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR",_[_.QUERY_COUNTER_BITS_EXT=34916]="QUERY_COUNTER_BITS_EXT",_[_.CURRENT_QUERY_EXT=34917]="CURRENT_QUERY_EXT",_[_.QUERY_RESULT_EXT=34918]="QUERY_RESULT_EXT",_[_.QUERY_RESULT_AVAILABLE_EXT=34919]="QUERY_RESULT_AVAILABLE_EXT",_[_.TIME_ELAPSED_EXT=35007]="TIME_ELAPSED_EXT",_[_.TIMESTAMP_EXT=36392]="TIMESTAMP_EXT",_[_.GPU_DISJOINT_EXT=36795]="GPU_DISJOINT_EXT",_[_.COMPLETION_STATUS_KHR=37297]="COMPLETION_STATUS_KHR",_[_.DEPTH_CLAMP_EXT=34383]="DEPTH_CLAMP_EXT",_[_.FIRST_VERTEX_CONVENTION_WEBGL=36429]="FIRST_VERTEX_CONVENTION_WEBGL",_[_.LAST_VERTEX_CONVENTION_WEBGL=36430]="LAST_VERTEX_CONVENTION_WEBGL",_[_.PROVOKING_VERTEX_WEBL=36431]="PROVOKING_VERTEX_WEBL",_[_.POLYGON_MODE_WEBGL=2880]="POLYGON_MODE_WEBGL",_[_.POLYGON_OFFSET_LINE_WEBGL=10754]="POLYGON_OFFSET_LINE_WEBGL",_[_.LINE_WEBGL=6913]="LINE_WEBGL",_[_.FILL_WEBGL=6914]="FILL_WEBGL",_[_.MAX_CLIP_DISTANCES_WEBGL=3378]="MAX_CLIP_DISTANCES_WEBGL",_[_.MAX_CULL_DISTANCES_WEBGL=33529]="MAX_CULL_DISTANCES_WEBGL",_[_.MAX_COMBINED_CLIP_AND_CULL_DISTANCES_WEBGL=33530]="MAX_COMBINED_CLIP_AND_CULL_DISTANCES_WEBGL",_[_.CLIP_DISTANCE0_WEBGL=12288]="CLIP_DISTANCE0_WEBGL",_[_.CLIP_DISTANCE1_WEBGL=12289]="CLIP_DISTANCE1_WEBGL",_[_.CLIP_DISTANCE2_WEBGL=12290]="CLIP_DISTANCE2_WEBGL",_[_.CLIP_DISTANCE3_WEBGL=12291]="CLIP_DISTANCE3_WEBGL",_[_.CLIP_DISTANCE4_WEBGL=12292]="CLIP_DISTANCE4_WEBGL",_[_.CLIP_DISTANCE5_WEBGL=12293]="CLIP_DISTANCE5_WEBGL",_[_.CLIP_DISTANCE6_WEBGL=12294]="CLIP_DISTANCE6_WEBGL",_[_.CLIP_DISTANCE7_WEBGL=12295]="CLIP_DISTANCE7_WEBGL",_[_.POLYGON_OFFSET_CLAMP_EXT=36379]="POLYGON_OFFSET_CLAMP_EXT",_[_.LOWER_LEFT_EXT=36001]="LOWER_LEFT_EXT",_[_.UPPER_LEFT_EXT=36002]="UPPER_LEFT_EXT",_[_.NEGATIVE_ONE_TO_ONE_EXT=37726]="NEGATIVE_ONE_TO_ONE_EXT",_[_.ZERO_TO_ONE_EXT=37727]="ZERO_TO_ONE_EXT",_[_.CLIP_ORIGIN_EXT=37724]="CLIP_ORIGIN_EXT",_[_.CLIP_DEPTH_MODE_EXT=37725]="CLIP_DEPTH_MODE_EXT",_[_.SRC1_COLOR_WEBGL=35065]="SRC1_COLOR_WEBGL",_[_.SRC1_ALPHA_WEBGL=34185]="SRC1_ALPHA_WEBGL",_[_.ONE_MINUS_SRC1_COLOR_WEBGL=35066]="ONE_MINUS_SRC1_COLOR_WEBGL",_[_.ONE_MINUS_SRC1_ALPHA_WEBGL=35067]="ONE_MINUS_SRC1_ALPHA_WEBGL",_[_.MAX_DUAL_SOURCE_DRAW_BUFFERS_WEBGL=35068]="MAX_DUAL_SOURCE_DRAW_BUFFERS_WEBGL",_[_.MIRROR_CLAMP_TO_EDGE_EXT=34627]="MIRROR_CLAMP_TO_EDGE_EXT"}(S||(R.GL=S={}))},
"f8f8ea4284": function _(t,e,n,i,l){i(),n.getTooltipDefault=f,n.tabularize=p,n.toText=d,n.substituteIn=x,n.makeTooltip=function(t,e){if(!t)return null;let n=!1;const i={};for(let l=0;l<e.length;l++){const o=e[l].id;(0,r.isBoolean)(t)||!(l.toString()in t)&&!(o in t)||(i[o]=o in t?t[o]:t[l.toString()],n=!0)}if(t.html||t.text||n)return e=>{if(!e.picked)return null;const l=n?i[e.layer.id]:t;if(null==l)return;if((0,r.isBoolean)(l))return l?f(e):null;const o={style:l.style||c};return l.html?o.html=x(l.html,e.object):o.text=x(l.text,e.object),o};return f};
/*
    This file was adapted from https://github.com/uber/deck.gl/ the LICENSE
    below is preserved to comply with the original license.
    
    Copyright (c) 2015 - 2017 Uber Technologies, Inc.
    
    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:
    
    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.
    
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    THE SOFTWARE.
    */
const r=t("@bokehjs/core/util/types");let o,s;const c={fontFamily:'"Helvetica Neue", Helvetica, Arial, sans-serif',display:"flex",flex:"wrap",maxWidth:"500px",flexDirection:"column",zIndex:2};function a(){return document.createElement("div")}function f(t){if(!t.picked)return null;if(t.object===o)return s;const e={html:p(t.object),style:c};return s=e,o=t.object,e}const u=new Set(["position","index"]);function p(t){const e=a();for(const n in t){if(u.has(n))continue;const i=a();i.className="header",i.textContent=n;const l=a();l.className="value",l.textContent=d(t[n]);const r=a();h(r,i,l),r.appendChild(i),r.appendChild(l),e.appendChild(r)}return e.innerHTML}function h(t,e,n){Object.assign(e.style,{fontWeight:700,marginRight:"10px",flex:"1 1 0%"}),Object.assign(n.style,{flex:"none",maxWidth:"250px",overflow:"hidden",whiteSpace:"nowrap",textOverflow:"ellipsis"}),Object.assign(t.style,{display:"flex",flexDirection:"row",justifyContent:"space-between",alignItems:"stretch"})}function d(t){let e;if(Array.isArray(t)&&t.length>4)e=`Array<${t.length}>`;else if((0,r.isString)(t))e=t;else if((0,r.isNumber)(t))e=String(t);else try{e=JSON.stringify(t)}catch(t){e="<Non-Serializable Object>"}return e.length>50&&(e=e.slice(0,50)),e}function x(t,e){let n=t;for(const t in e){if((0,r.isPlainObject)(e[t]))for(const i in e[t])n=n.replace(`{${t}.${i}}`,e[t][i]);n=n.replace(`{${t}}`,e[t])}return n}},
"0dca2cd4f6": function _(e,t,s,l,i){var o;l();const r=e("96e805ccb5"),a=e("@bokehjs/core/dom"),n=e("@bokehjs/core/util/pretty");class _ extends r.PlayerView{append_value_to_title_el(){let e=this.model.options[this.model.value];"string"!=typeof e&&(e=(0,n.to_string)(e)),this.titleEl.appendChild((0,a.span)({class:"pn-player-value"},e))}}s.DiscretePlayerView=_,_.__name__="DiscretePlayerView";class c extends r.Player{constructor(e){super(e)}}s.DiscretePlayer=c,o=c,c.__name__="DiscretePlayer",c.__module__="panel.models.widgets",o.prototype.default_view=_,o.define((({List:e,Any:t})=>({options:[e(t),[]]}))),o.override({width:400})},
"96e805ccb5": function _(t,e,s,i,l){var o;i();const n=t("@bokehjs/core/kinds"),a=t("@bokehjs/core/dom"),r=t("@bokehjs/models/widgets/widget"),h=t("@bokehjs/core/util/pretty"),d='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-minus" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M5 12l14 0" /></svg>',p='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-track-prev-filled" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M20.341 4.247l-8 7a1 1 0 0 0 0 1.506l8 7c.647 .565 1.659 .106 1.659 -.753v-14c0 -.86 -1.012 -1.318 -1.659 -.753z" stroke-width="0" fill="currentColor" /><path d="M9.341 4.247l-8 7a1 1 0 0 0 0 1.506l8 7c.647 .565 1.659 .106 1.659 -.753v-14c0 -.86 -1.012 -1.318 -1.659 -.753z" stroke-width="0" fill="currentColor" /></svg>',c='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-skip-back-filled" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M19.496 4.136l-12 7a1 1 0 0 0 0 1.728l12 7a1 1 0 0 0 1.504 -.864v-14a1 1 0 0 0 -1.504 -.864z" stroke-width="0" fill="currentColor" /><path d="M4 4a1 1 0 0 1 .993 .883l.007 .117v14a1 1 0 0 1 -1.993 .117l-.007 -.117v-14a1 1 0 0 1 1 -1z" stroke-width="0" fill="currentColor" /></svg>',u='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-play-filled" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round" style="transform: scaleX(-1);"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4v16a1 1 0 0 0 1.524 .852l13 -8a1 1 0 0 0 0 -1.704l-13 -8a1 1 0 0 0 -1.524 .852z" stroke-width="0" fill="currentColor" /></svg>',_='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-pause-filled" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 4h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h2a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2z" stroke-width="0" fill="currentColor" /><path d="M17 4h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h2a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2z" stroke-width="0" fill="currentColor" /></svg>',m='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-play-filled" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4v16a1 1 0 0 0 1.524 .852l13 -8a1 1 0 0 0 0 -1.704l-13 -8a1 1 0 0 0 -1.524 .852z" stroke-width="0" fill="currentColor" /></svg>',v='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-skip-forward-filled" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 5v14a1 1 0 0 0 1.504 .864l12 -7a1 1 0 0 0 0 -1.728l-12 -7a1 1 0 0 0 -1.504 .864z" stroke-width="0" fill="currentColor" /><path d="M20 4a1 1 0 0 1 .993 .883l.007 .117v14a1 1 0 0 1 -1.993 .117l-.007 -.117v-14a1 1 0 0 1 1 -1z" stroke-width="0" fill="currentColor" /></svg>',g='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-player-track-next-filled" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M2 5v14c0 .86 1.012 1.318 1.659 .753l8 -7a1 1 0 0 0 0 -1.506l-8 -7c-.647 -.565 -1.659 -.106 -1.659 .753z" stroke-width="0" fill="currentColor" /><path d="M13 5v14c0 .86 1.012 1.318 1.659 .753l8 -7a1 1 0 0 0 0 -1.506l-8 -7c-.647 -.565 -1.659 -.106 -1.659 .753z" stroke-width="0" fill="currentColor" /></svg>',f='<svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-plus" width="12" height="12" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 5l0 14" /><path d="M5 12l14 0" /></svg>';function w(t){t.forEach((t=>t.style.borderStyle="inset"))}function y(t){t.forEach((t=>t.style.borderStyle="outset"))}class b extends r.WidgetView{constructor(){super(...arguments),this._changing=!1}connect_signals(){super.connect_signals();const{title:t,value_align:e,direction:s,value:i,loop_policy:l,disabled:o,show_loop_controls:n,show_value:a,scale_buttons:r,visible_buttons:h,visible_loop_options:d}=this.model.properties;this.on_change(t,(()=>this.update_title_and_value())),this.on_change(e,(()=>this.set_value_align())),this.on_change(s,(()=>this.set_direction())),this.on_change(i,(()=>this.update_value())),this.on_change(l,(()=>this.set_loop_state(this.model.loop_policy))),this.on_change(o,(()=>this.toggle_disable())),this.on_change(n,(()=>{this.model.show_loop_controls&&this.loop_state.parentNode!=this.groupEl?this.groupEl.appendChild(this.loop_state):this.model.show_loop_controls||this.loop_state.parentNode!=this.groupEl||this.groupEl.removeChild(this.loop_state)})),this.on_change(a,(()=>this.update_title_and_value())),this.on_change(r,(()=>this.update_css())),this.on_change(h,(()=>this.update_css())),this.on_change(d,(()=>this.update_css()))}toggle_disable(){this.sliderEl.disabled=this.model.disabled;for(const t of this.buttonEl.children){t.disabled=this.model.disabled}for(const t of this.loop_state.children)if("input"==t.tagName){t.disabled=this.model.disabled}}get_height(){return 250}update_css(){const t=`text-align: center; flex-grow: 1; margin: 2px; transform: scale(${this.model.scale_buttons}); max-width: 50px;`,e=`text-align: center; flex-grow: 2; margin: 2px; transform: scale(${this.model.scale_buttons}); max-width: 50px;`,s={slower:this.slower,first:this.first,previous:this.previous,reverse:this.reverse,pause:this.pause,play:this.play,next:this.next,last:this.last,faster:this.faster};for(const[i,l]of Object.entries(s))l&&(this.model.visible_buttons.includes(i)?(l.style.display="",l.style.cssText+="slower"===i||"faster"===i?t:e):l.style.display="none");for(const t of this.loop_state.children)if("input"==t.tagName.toLowerCase()){const e=t;this.model.visible_loop_options.includes(e.value)?e.style.display="":e.style.display="none"}else if("label"==t.tagName.toLowerCase()){const e=t;this.model.visible_loop_options.includes(e.innerHTML.toLowerCase())?e.style.display="":e.style.display="none"}}update_value(){null!=this.sliderEl&&(this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),this.sliderEl.value=String(this.model.value))}render(){super.render(),this.groupEl=(0,a.div)(),this.groupEl.style.display="flex",this.groupEl.style.flexDirection="column",this.titleEl=(0,a.div)(),this.titleEl.classList.add("pn-player-title"),this.titleEl.style.padding="0 5px 0 5px",this.update_title_and_value(),this.set_value_align(),this.sliderEl=document.createElement("input"),this.sliderEl.style.width="100%",this.sliderEl.setAttribute("type","range"),this.sliderEl.value=String(this.model.value),this.sliderEl.min=String(this.model.start),this.sliderEl.max=String(this.model.end),this.sliderEl.addEventListener("input",(t=>{this.set_frame(parseInt(t.target.value),!1)})),this.sliderEl.addEventListener("change",(t=>{this.set_frame(parseInt(t.target.value))}));const t=(0,a.div)();this.buttonEl=t,t.style.cssText="margin: 0 auto; display: flex; padding: 5px; align-items: stretch; justify-content: center; width: 100%;",this.slower=document.createElement("button"),this.slower.classList.add("slower"),this.slower.innerHTML=d,this.slower.onclick=()=>this.slower_speed(),t.appendChild(this.slower),this.first=document.createElement("button"),this.first.classList.add("first"),this.first.innerHTML=p,this.first.onclick=()=>this.first_frame(),t.appendChild(this.first),this.previous=document.createElement("button"),this.previous.classList.add("previous"),this.previous.innerHTML=c,this.previous.onclick=()=>this.previous_frame(),t.appendChild(this.previous),this.reverse=document.createElement("button"),this.reverse.classList.add("reverse"),this.reverse.innerHTML=u,this.reverse.onclick=()=>this.reverse_animation(),t.appendChild(this.reverse),this.pause=document.createElement("button"),this.pause.classList.add("pause"),this.pause.innerHTML=_,this.pause.onclick=()=>this.pause_animation(),t.appendChild(this.pause),this.play=document.createElement("button"),this.play.classList.add("play"),this.play.innerHTML=m,this.play.onclick=()=>this.play_animation(),t.appendChild(this.play),this.next=document.createElement("button"),this.next.classList.add("next"),this.next.innerHTML=v,this.next.onclick=()=>this.next_frame(),t.appendChild(this.next),this.last=document.createElement("button"),this.last.classList.add("last"),this.last.innerHTML=g,this.last.onclick=()=>this.last_frame(),t.appendChild(this.last),this.faster=document.createElement("button"),this.faster.classList.add("faster"),this.faster.innerHTML=f,this.faster.onclick=()=>this.faster_speed(),t.appendChild(this.faster),this._toggle_reverse=()=>{y([this.pause,this.play]),w([this.reverse])},this._toogle_pause=()=>{y([this.reverse,this.play]),w([this.pause])},this._toggle_play=()=>{y([this.reverse,this.pause]),w([this.play])},this.loop_state=document.createElement("form"),this.loop_state.style.cssText="margin: 0 auto; display: table";const e=document.createElement("input");e.classList.add("once"),e.type="radio",e.value="once",e.name="state";const s=document.createElement("label");s.innerHTML="Once",s.classList.add("once-label"),s.style.cssText="padding: 0 10px 0 5px; user-select:none;";const i=document.createElement("input");i.classList.add("loop"),i.setAttribute("type","radio"),i.setAttribute("value","loop"),i.setAttribute("name","state");const l=document.createElement("label");l.classList.add("loop-label"),l.innerHTML="Loop",l.style.cssText="padding: 0 10px 0 5px; user-select:none;";const o=document.createElement("input");o.classList.add("reflect"),o.setAttribute("type","radio"),o.setAttribute("value","reflect"),o.setAttribute("name","state");const n=document.createElement("label");l.classList.add("reflect-label"),n.innerHTML="Reflect",n.style.cssText="padding: 0 10px 0 5px; user-select:none;","once"==this.model.loop_policy?e.checked=!0:"loop"==this.model.loop_policy?i.checked=!0:o.checked=!0,this.loop_state.appendChild(e),this.loop_state.appendChild(s),this.loop_state.appendChild(i),this.loop_state.appendChild(l),this.loop_state.appendChild(o),this.loop_state.appendChild(n),this.groupEl.appendChild(this.titleEl),this.groupEl.appendChild(this.sliderEl),this.groupEl.appendChild(t),this.model.show_loop_controls&&this.groupEl.appendChild(this.loop_state),this.toggle_disable(),this.update_css(),this.shadow_el.appendChild(this.groupEl),this.set_direction()}set_frame(t,e=!0){this.model.value=t,this.update_title_and_value(),e&&(this.model.value_throttled=t),this.sliderEl.value!=String(t)&&(this.sliderEl.value=String(t))}get_loop_state(){const t=this.loop_state.state;for(let e=0;e<t.length;e++){const s=t[e];if(s.checked)return s.value}return"once"}update_title_and_value(){(0,a.empty)(this.titleEl);const t=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.titleEl.style.display=t?"none":"",t)this.titleEl.style.visibility="hidden";else{this.titleEl.style.visibility="visible";const{title:t}=this.model;null!=t&&t.length>0&&(this.contains_tex_string(t)?(this.titleEl.innerHTML=`${this.process_tex(t)}`,this.model.show_value&&(this.titleEl.innerHTML+=": ")):(this.titleEl.textContent=`${t}`,this.model.show_value&&(this.titleEl.textContent+=": "))),this.model.show_value&&this.append_value_to_title_el()}}append_value_to_title_el(){this.titleEl.appendChild((0,a.span)({class:"pn-player-value"},(0,h.to_string)(this.model.value)))}set_value_align(){switch(this.model.value_align){case"start":this.titleEl.style.textAlign="left";break;case"center":this.titleEl.style.textAlign="center";break;case"end":this.titleEl.style.textAlign="right"}}set_loop_state(t){const e=this.loop_state.state;for(let s=0;s<e.length;s++){const i=e[s];i.value==t&&(i.checked=!0)}}next_frame(){this.set_frame(Math.min(this.model.end,this.model.value+this.model.step))}previous_frame(){this.set_frame(Math.max(this.model.start,this.model.value-this.model.step))}first_frame(){this.set_frame(this.model.start)}last_frame(){this.set_frame(this.model.end)}updateSpeedButton(t,e,s){const i=1e3/e;t.innerHTML=`${i.toFixed(1)}<br>fps`,setTimeout((()=>{t.innerHTML=s}),this.model.preview_duration)}slower_speed(){this.model.interval=Math.round(this.model.interval/.7),this.updateSpeedButton(this.slower,this.model.interval,d),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}faster_speed(){this.model.interval=Math.round(.7*this.model.interval),this.updateSpeedButton(this.faster,this.model.interval,f),this.model.direction>0?this.play_animation():this.model.direction<0&&this.reverse_animation()}anim_step_forward(){if(this.model.value<this.model.end)this.next_frame();else{const t=this.get_loop_state();"loop"==t?this.first_frame():"reflect"==t?(this.last_frame(),this.reverse_animation()):(this.pause_animation(),this.last_frame())}}anim_step_reverse(){if(this.model.value>this.model.start)this.previous_frame();else{const t=this.get_loop_state();"loop"==t?this.last_frame():"reflect"==t?(this.first_frame(),this.play_animation()):(this.pause_animation(),this.first_frame())}}set_direction(){this._changing||(0===this.model.direction?this.pause_animation():1===this.model.direction?this.play_animation():-1===this.model.direction&&this.reverse_animation())}pause_animation(){this._toogle_pause(),this._changing=!0,this.model.direction=0,this._changing=!1,this.timer&&(clearInterval(this.timer),this.timer=null)}play_animation(){this.pause_animation(),this._toggle_play(),this._changing=!0,this.model.direction=1,this._changing=!1,this.timer||(this.timer=setInterval((()=>this.anim_step_forward()),this.model.interval))}reverse_animation(){this.pause_animation(),this._toggle_reverse(),this._changing=!0,this.model.direction=-1,this._changing=!1,this.timer||(this.timer=setInterval((()=>this.anim_step_reverse()),this.model.interval))}}s.PlayerView=b,b.__name__="PlayerView",s.LoopPolicy=(0,n.Enum)("once","loop","reflect");class k extends r.Widget{constructor(t){super(t)}}s.Player=k,o=k,k.__name__="Player",k.__module__="panel.models.widgets",o.prototype.default_view=b,o.define((({Bool:t,Int:e,Float:i,List:l,Str:o})=>({direction:[e,0],interval:[e,500],start:[e,0],end:[e,10],step:[e,1],loop_policy:[s.LoopPolicy,"once"],title:[o,""],value:[e,0],value_align:[o,"start"],value_throttled:[e,0],preview_duration:[e,1500],show_loop_controls:[t,!0],show_value:[t,!0],button_scale:[i,1],scale_buttons:[i,1],visible_buttons:[l(o),["slower","first","previous","reverse","pause","play","next","last","faster"]],visible_loop_options:[l(o),["once","loop","reflect"]]}))),o.override({width:400})},
"1da56f3c52": function _(e,t,s,n,o){var i,h;n();const r=e("@bokehjs/core/bokeh_events"),c=e("@bokehjs/core/dom"),a=e("a572dba9cd"),l=e("9b11ce01a3"),d=e("a3669a897a"),_=["click","dblclick","mousedown","mousemove","mouseup","mouseover","mouseout","globalout","contextmenu"].concat(["highlight","downplay","selectchanged","legendselectchangedEvent","legendselected","legendunselected","legendselectall","legendinverseselect","legendscroll","datazoom","datarangeselected","timelineplaychanged","restore","dataviewchanged","magictypechanged","geoselectchanged","geoselected","geounselected","axisareaselected","brush","brushEnd","rushselected","globalcursortaken","rendered","finished"]);class u extends r.ModelEvent{constructor(e,t,s){super(),this.type=e,this.data=t,this.query=s}get event_values(){return{model:this.origin,type:this.type,data:this.data,query:this.query}}}s.EChartsEvent=u,i=u,u.__name__="EChartsEvent",i.prototype.event_name="echarts_event";class g extends l.HTMLBoxView{constructor(){super(...arguments),this._callbacks=[]}connect_signals(){super.connect_signals();const{width:e,height:t,renderer:s,theme:n,event_config:o,js_events:i,data:h}=this.model.properties;this.on_change(h,(()=>this._plot())),this.on_change([e,t],(()=>this._resize())),this.on_change([n,s],(()=>{this.render(),this._chart.resize()})),this.on_change([o,i],(()=>this._subscribe()))}render(){if(null!=this._chart)try{window.echarts.dispose(this._chart)}catch(e){}super.render(),this.container=(0,c.div)({style:{height:"100%",width:"100%"}});const e={width:this.model.width,height:this.model.height,renderer:this.model.renderer};this._chart=window.echarts.init(this.container,this.model.theme,e),this._plot(),this._subscribe(),this.shadow_el.append(this.container)}remove(){super.remove(),null!=this._chart&&window.echarts.dispose(this._chart)}after_layout(){super.after_layout(),null!=this._chart&&this._chart.resize()}_plot(){if(null==window.echarts)return;const e=(0,d.transformJsPlaceholders)(this.model.data);this._chart.setOption(e,this.model.options)}_resize(){this._chart.resize({width:this.model.width,height:this.model.height})}_subscribe(){if(null!=window.echarts){for(const[e,t]of this._callbacks)this._chart.off(e,t);this._callbacks=[];for(const e in this.model.event_config){if(!_.includes(e)){console.warn(`Could not subscribe to unknown Echarts event: ${e}.`);continue}const t=this.model.event_config[e];for(const s of t){const t=t=>{const n={...t};n.event=(0,a.serializeEvent)(t.event?.event);const o=JSON.parse(JSON.stringify(n));this.model.trigger_event(new u(e,o,s))};null==s?this._chart.on(e,s,t):this._chart.on(e,t),this._callbacks.push([e,t])}}for(const e in this.model.js_events){if(!_.includes(e)){console.warn(`Could not subscribe to unknown Echarts event: ${e}.`);continue}const t=this.model.js_events[e];for(const s of t){const t=e=>{s.callback.execute(this._chart,e)};"query"in s?this._chart.on(e,s.query,t):this._chart.on(e,t),this._callbacks.push([e,t])}}}}}s.EChartsView=g,g.__name__="EChartsView";class m extends l.HTMLBox{constructor(e){super(e)}}s.ECharts=m,h=m,m.__name__="ECharts",m.__module__="panel.models.echarts",h.prototype.default_view=g,h.define((({Any:e,Str:t})=>({data:[e,{}],options:[e,{}],event_config:[e,{}],js_events:[e,{}],theme:[t,"default"],renderer:[t,"canvas"]})))},
"4cfe0841a5": function _(e,t,s,i,r){var l,o;i();var n,_=this&&this.__decorate||function(e,t,s,i){var r,l=arguments.length,o=l<3?t:null===i?i=Object.getOwnPropertyDescriptor(t,s):i;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)o=Reflect.decorate(e,t,s,i);else for(var n=e.length-1;n>=0;n--)(r=e[n])&&(o=(l<3?r(o):l>3?r(t,s,o):r(t,s))||o);return l>3&&o&&Object.defineProperty(t,s,o),o};const c=e("b273e5b2fb"),h=e("@bokehjs/core/bokeh_events"),d=e("@bokehjs/core/build_views"),a=e("@bokehjs/models/layouts/column");let v=(l=class extends h.ModelEvent{constructor(e,t,s){super(),this.model=e,this.rerender=t,this.scroll_limit=s,this.origin=e,this.rerender=t,this.scroll_limit=s}get event_values(){return{model:this.origin,rerender:this.rerender,scroll_limit:this.scroll_limit}}static from_values(e){const{model:t,rerender:s,scroll_limit:i}=e;return new n(t,s,i)}},n=l,l.__name__="ScrollLatestEvent",l);s.ScrollLatestEvent=v,s.ScrollLatestEvent=v=n=_([(0,h.server_event)("scroll_latest_event")],v);class u extends c.ColumnView{constructor(){super(...arguments),this._rendered=!1,this._reference=null,this._reference_view=null}initialize(){super.initialize(),this._sync=!0,this._intersection_observer=new IntersectionObserver((e=>{const t=[...this.model.visible_children],s=this.node_map;for(const i of e){const e=s.get(i.target).id;i.isIntersecting?t.includes(e)||t.push(e):t.includes(e)&&t.splice(t.indexOf(e),1)}if(this._sync&&(this.model.visible_children=t),t.length>0){const e=this.child_models.map((e=>e.id)),s=t.map((t=>e.indexOf(t)));this._last_visible=this.child_views[Math.min(...s)]}else this._last_visible=null}),{root:this.el,threshold:.01})}connect_signals(){super.connect_signals(),this.model.on_event(v,(e=>{this.scroll_to_latest(e.scroll_limit),e.rerender&&(this._rendered=!1)}))}get node_map(){const e=new Map;for(const t of this.child_views)e.set(t.el,t.model);return e}async update_children(){const e=this._last_visible,t=this.el.scrollTop;this._reference_view=e,this._reference=e?.el.offsetTop||0,this._sync=!1;const s=await this.build_child_views(),i=new Set(s),r=s.length,l=this.child_views.length,o=s.every(((e,t)=>e===this.child_views[t])),n=s.every(((e,t)=>e===this.child_views[l-r+t])),_=!(o||n);if(_)for(const e of this.child_views)e.el.remove();const c=[];for(const e of this.child_views){const t=i.has(e),s=this.shadow_el;_?t?e.render_to(s):s.append(e.el):t&&(e.render(),e.r_after_render(),n?s.append(e.el):o&&c.push(e.el))}o&&this.shadow_el.prepend(...c),this.r_after_render(),this._update_children(),this.invalidate_layout(),this._sync=!0,o&&requestAnimationFrame((()=>{const e=(this._reference_view?.el.offsetTop||0)-(this._reference||0);this.el.scrollTo({top:t+e,behavior:"smooth"})}))}async build_child_views(){const{created:e,removed:t}=await(0,d.build_views)(this._child_views,this.child_models,{parent:this}),s=this.model.visible_children;for(const e of t)s.includes(e.model.id)&&s.splice(s.indexOf(e.model.id),1),this._resize_observer.unobserve(e.el),this._intersection_observer.unobserve(e.el);this.model.visible_children=[...s];for(const t of e)this._resize_observer.observe(t.el,{box:"border-box"}),this._intersection_observer.observe(t.el);return e}_update_layout(){super._update_layout(),this.style.append(":host > div",{max_height:"unset"})}render(){this._rendered=!1,super.render()}trigger_auto_scroll(){}after_render(){a.ColumnView.prototype.after_render.call(this),requestAnimationFrame((()=>{this.model.scroll_position&&this.scroll_to_position(),this.model.view_latest&&!this._rendered&&this.scroll_to_latest(),this.toggle_scroll_button(),this._rendered=!0}))}}s.FeedView=u,u.__name__="FeedView";class f extends c.Column{constructor(e){super(e)}}s.Feed=f,o=f,f.__name__="Feed",f.__module__="panel.models.feed",o.prototype.default_view=u,o.define((({List:e,Str:t})=>({visible_children:[e(t),[]]})))},
"84a13dddfb": function _(e,t,i,l,s){var o;l();const n=e("tslib"),a=e("@bokehjs/core/build_views"),h=e("@bokehjs/core/enums"),_=e("@bokehjs/models/widgets/input_widget"),d=e("@bokehjs/models/ui/icons/icon"),r=n.__importStar(e("@bokehjs/styles/buttons.css")),c=r,u=e("@bokehjs/core/dom");class b extends _.InputWidgetView{constructor(){super(...arguments),this._downloadable=!1,this._prev_href="",this._prev_download=""}*children(){yield*super.children(),null!=this.icon_view&&(yield this.icon_view)}*controls(){yield this.anchor_el,yield this.button_el}connect_signals(){super.connect_signals();const{button_type:e,filename:t,_transfers:i,label:l}=this.model.properties;this.on_change(e,(()=>this._update_button_style())),this.on_change(t,(()=>this._update_download())),this.on_change(i,(()=>this._handle_click())),this.on_change(l,(()=>this._update_label()))}remove(){null!=this.icon_view&&this.icon_view.remove(),super.remove()}async lazy_initialize(){await super.lazy_initialize();const{icon:e}=this.model;null!=e&&(this.icon_view=await(0,a.build_view)(e,{parent:this}))}_render_input(){if(this.anchor_el=document.createElement("a"),this.button_el=(0,u.button)({disabled:this.model.disabled}),null!=this.icon_view){const e=""!=this.model.label?(0,u.nbsp)():(0,u.text)("");this.anchor_el.appendChild(this.icon_view.el),this.anchor_el.appendChild(e),this.icon_view.render()}return this.label_el=document.createTextNode(this.model.label),this.anchor_el.appendChild(this.label_el),this._update_button_style(),this.model.disabled?(this.anchor_el.setAttribute("disabled",""),this._downloadable=!1):(this.anchor_el.removeAttribute("disabled"),this._prev_download&&(this.anchor_el.download=this._prev_download),this._prev_href&&(this.anchor_el.href=this._prev_href),this.anchor_el.download&&this.anchor_el.download&&(this._downloadable=!0)),this.model.embed?this._make_link_downloadable():(this._click_listener=this._increment_clicks.bind(this),this.anchor_el.addEventListener("click",this._click_listener)),this.button_el.appendChild(this.anchor_el),this.input_el=(0,u.input)(),this.button_el}render(){super.render(),this.group_el.style.display="flex",this.group_el.style.alignItems="stretch"}stylesheets(){return[...super.stylesheets(),r.default]}_increment_clicks(){this.model.clicks=this.model.clicks+1}_handle_click(){!this.model.auto&&this._downloadable||this.anchor_el.hasAttribute("disabled")||(this._make_link_downloadable(),!this.model.embed&&this.model.auto&&(this.anchor_el.removeEventListener("click",this._click_listener),this.anchor_el.click(),this.anchor_el.removeAttribute("href"),this.anchor_el.removeAttribute("download"),this.anchor_el.addEventListener("click",this._click_listener)),this._prev_href=this.anchor_el.getAttribute("href"),this._prev_download=this.anchor_el.getAttribute("download"))}_make_link_downloadable(){this._update_href(),this._update_download(),this.anchor_el.download&&this.anchor_el.href&&(this._downloadable=!0)}_update_href(){if(this.model.data){const e=function(e){const t=atob(e.split(",")[1]),i=e.split(",")[0].split(":")[1].split(";")[0],l=new ArrayBuffer(t.length),s=new Uint8Array(l);for(let e=0;e<t.length;e++)s[e]=t.charCodeAt(e);return new Blob([l],{type:i})}(this.model.data);this.anchor_el.href=URL.createObjectURL(e)}}_update_download(){this.model.filename&&(this.anchor_el.download=this.model.filename)}_update_label(){this.label_el.data=this.model.label}_update_button_style(){const e=c[`btn_${this.model.button_type}`];if(this.button_el.hasAttribute("class")){const t=this.anchor_el.classList.item(1);t&&this.button_el.classList.replace(t,e)}else this.button_el.classList.add(c.btn),this.button_el.classList.add(e)}}i.FileDownloadView=b,b.__name__="FileDownloadView";class p extends _.InputWidget{constructor(e){super(e)}}i.FileDownload=p,o=p,p.__name__="FileDownload",p.__module__="panel.models.widgets",o.prototype.default_view=b,o.define((({Bool:e,Int:t,Nullable:i,Ref:l,Str:s})=>({auto:[e,!1],clicks:[t,0],data:[i(s),null],embed:[e,!1],icon:[i(l(d.Icon)),null],label:[s,"Download"],filename:[i(s),null],button_type:[h.ButtonType,"default"],_transfers:[t,0]}))),o.override({title:""})},
"e8b7476f90": function _(e,i,t,l,s){var n,o,a;l();const d=e("tslib"),r=e("@bokehjs/core/bokeh_events"),_=e("@bokehjs/core/dom"),p=e("@bokehjs/core/kinds"),u=e("@bokehjs/models/widgets/input_widget"),m=d.__importStar(e("@bokehjs/styles/widgets/inputs.css")),c=d.__importDefault(e("c03dd3c931"));class h extends r.ModelEvent{constructor(e){super(),this.data=e}get event_values(){return{model:this.origin,data:this.data}}}t.UploadEvent=h,n=h,h.__name__="UploadEvent",n.prototype.event_name="upload_event";class f extends r.ModelEvent{constructor(e){super(),this.data=e}get event_values(){return{model:this.origin,data:this.data}}}t.DeleteEvent=f,o=f,f.__name__="DeleteEvent",o.prototype.event_name="delete_event";class w extends u.InputWidgetView{constructor(){super(...arguments),this._file_pond=null,this._transfer_in_process=null}initialize(){super.initialize();const{previews:e}=this.model;e.includes("image")&&window.FilePond.registerPlugin(window.FilePondPluginImagePreview),e.includes("pdf")&&window.FilePond.registerPlugin(window.FilePondPluginPdfPreview),window.FilePond.registerPlugin(window.FilePondPluginFileValidateType),window.FilePond.registerPlugin(window.FilePondPluginFileValidateSize)}connect_signals(){super.connect_signals();const{disabled:e,layout:i,max_file_size:t,max_files:l,max_total_file_size:s,multiple:n}=this.model.properties;this.on_change([e,t,l,s,n,i],(()=>{this._file_pond?.setOptions({acceptedFileTypes:this.model.accepted_filetypes,allowMultiple:this.model.multiple,disabled:this.model.disabled,maxFiles:this.model.max_files,maxFileSize:this.model.max_file_size,maxTotalFileSize:this.model.max_total_file_size,stylePanelLayout:this.model.layout})}))}remove(){this._file_pond&&this._file_pond.destroy(),super.remove()}stylesheets(){return[...super.stylesheets(),c.default]}_render_input(){const{multiple:e,disabled:i}=this.model;return this.input_el=(0,_.input)({type:"file",class:m.input,multiple:e,disabled:i})}render(){super.render(),this._file_pond=window.FilePond.create(this.input_el,{acceptedFileTypes:this.model.accepted_filetypes,allowMultiple:this.model.multiple,credits:!1,disabled:this.model.disabled,maxFiles:this.model.max_files,maxFileSize:this.model.max_file_size,maxTotalFileSize:this.model.max_total_file_size,server:{process:(e,i,t,l,s,n)=>{this._process_upload(i,l,s,n)},fetch:null,revert:(e,i)=>{this.model.trigger_event(new f({name:e})),i()}},stylePanelLayout:this.model.layout})}async _process_upload(e,i,t,l){const s=this.model.chunk_size,n=Math.ceil((e.size+1)/s);let o=!1;return new Promise((async(t,a)=>{for(let i=0;i<n;i++){if(o)return void a(e.name);const t=i*s,d=Math.min(t+s,e.size);this.model.trigger_event(new h({chunk:i+1,data:await e.slice(t,d).arrayBuffer(),name:e._relativePath||e.name,total_chunks:n,type:e.type})),l(!0,d,e.size)}i(e.name),t(e.name)})).catch((()=>t("Upload failed."))),{abort:()=>{o=!0}}}}t.FileDropperView=w,w.__name__="FileDropperView",t.DropperLayout=(0,p.Enum)("integrated","compact","circle");class g extends u.InputWidget{constructor(e){super(e)}}t.FileDropper=g,a=g,g.__name__="FileDropper",g.__module__="panel.models.file_dropper",a.prototype.default_view=w,a.define((({Any:e,List:i,Bool:l,Int:s,Nullable:n,Str:o})=>({accepted_filetypes:[i(o),[]],chunk_size:[s,1e7],max_file_size:[n(o),null],max_files:[n(s),null],max_total_file_size:[n(o),null],mime_type:[e,{}],multiple:[l,!0],layout:[n(t.DropperLayout),null],previews:[i(o),["image","pdf"]]})))},
"c03dd3c931": function _(o,r,n,l,f){l(),n.input="bk-input",n.default=".bk-input.filepond--root{background-color:var(--panel-surface-color, #f1f1f1);border:unset;}.bk-input.filepond--root .filepond--drop-label{color:var(--panel-on-surface-color, #000);background-color:var(--panel-surface-color, #f1f1f1);}"},
"8a8089cbf3": function _(e,i,t,n,s){var o;n();const l=e("@bokehjs/core/dom"),r=e("9b11ce01a3"),d=window.Jupyter;class a extends r.HTMLBoxView{initialize(){let e;if(super.initialize(),null!=d&&null!=d.notebook)e=d.notebook.kernel.widget_manager;else{if(null==window.PyViz.widget_manager)return void console.warn("Panel IPyWidget model could not find a WidgetManager");e=window.PyViz.widget_manager}this.manager=e,this.ipychildren=[]}remove(){this.ipyview.remove(),super.remove()}_ipy_stylesheets(){const e=[];for(const i of document.head.children)if(i instanceof HTMLStyleElement){const t=i.textContent;if(null!=t){const i=t.replace(/:root/g,":host");e.push(new l.InlineStyleSheet(i))}}return e}stylesheets(){return[...super.stylesheets(),...this._ipy_stylesheets()]}render(){super.render();const{spec:e,state:i}=this.model.bundle;this.manager.set_state(i).then((async i=>{const t=i.find((i=>i.model_id==e.model_id));if(null==t)return;const n=await this.manager.create_view(t,{el:this.el});if(this.ipyview=n,this.ipychildren=[],n.children_views)for(const e of n.children_views.views)this.ipychildren.push(await e);this.shadow_el.appendChild(this.ipyview.el),this.ipyview.trigger("displayed",this.ipyview);for(const e of this.ipychildren)e.trigger("displayed",e);this.invalidate_layout()}))}}t.IPyWidgetView=a,a.__name__="IPyWidgetView";class h extends r.HTMLBox{constructor(e){super(e)}}t.IPyWidget=h,o=h,h.__name__="IPyWidget",h.__module__="panel.models.ipywidget",o.prototype.default_view=a,o.define((({Any:e})=>({bundle:[e,{}]})))},
"245cd3cfde": function _(e,t,r,s,n){var o;s();const d=e("tslib"),i=e("@bokehjs/core/kinds"),h=e("@bokehjs/models/widgets/markup"),l=d.__importDefault(e("ec9d1ffc2e")),a=e("9b11ce01a3");class c extends a.PanelMarkupView{connect_signals(){super.connect_signals();const{depth:e,hover_preview:t,text:r,theme:s}=this.model.properties;this.on_change([e,t,r,s],(()=>this.rerender_()))}render(){super.render();const e=this.model.text.replace(/(\r\n|\n|\r)/gm,"");let t;try{t=window.JSON.parse(e)}catch(e){return void(this.container.innerHTML=`<b>Invalid JSON:</b> ${e}`)}const r={hoverPreviewEnabled:this.model.hover_preview,theme:this.model.theme},s=null==this.model.depth?1/0:this.model.depth,n=new l.default(t,s,r).render(),o="border-radius: 5px; padding: 10px; width: 100%; height: 100%;";"dark"==this.model.theme?n.style.cssText=`background-color: rgb(30, 30, 30);${o}`:n.style.cssText=o,this.container.append(n)}}r.JSONView=c,c.__name__="JSONView",r.JSONTheme=(0,i.Enum)("dark","light");class p extends h.Markup{constructor(e){super(e)}}r.JSON=p,o=p,p.__name__="JSON",p.__module__="panel.models.markup",o.prototype.default_view=c,o.define((({List:e,Bool:t,Int:s,Nullable:n,Str:o})=>({css:[e(o),[]],depth:[n(s),1],hover_preview:[t,!1],theme:[r.JSONTheme,"dark"]})))},
"ec9d1ffc2e": function _(t,r,e,n,o){function i(t){return null===t?"null":typeof t}function s(t){return!!t&&"object"==typeof t}function a(t){if(void 0===t)return"";if(null===t)return"Object";if("object"==typeof t&&!t.constructor)return"Object";var r=/function ([^(]*)/.exec(t.constructor.toString());return r&&r.length>1?r[1]:""}function f(t,r,e){return"null"===t||"undefined"===t?t:("string"!==t&&"stringifiable"!==t||(e='"'+e.replace(/"/g,'\\"')+'"'),"function"===t?r.toString().replace(/[\r\n]/g,"").replace(/\{.*\}/,"")+"{\u2026}":e)}function m(t){var r="";return s(t)?(r=a(t),Array.isArray(t)&&(r+="["+t.length+"]")):r=f(i(t),t,t),r}function c(t){return"json-formatter-".concat(t)}function l(t,r,e){var n=document.createElement(t);return r&&n.classList.add(c(r)),void 0!==e&&(e instanceof Node?n.appendChild(e):n.appendChild(document.createTextNode(String(e)))),n}n(),function(t){if(t&&"undefined"!=typeof window){var r=document.createElement("style");r.setAttribute("media","screen"),r.innerHTML=t,document.head.appendChild(r)}}('.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-row,\n.json-formatter-row a,\n.json-formatter-row a:hover {\n  color: black;\n  text-decoration: none;\n}\n.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-row .json-formatter-string,\n.json-formatter-row .json-formatter-stringifiable {\n  color: green;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-row .json-formatter-number {\n  color: blue;\n}\n.json-formatter-row .json-formatter-boolean {\n  color: red;\n}\n.json-formatter-row .json-formatter-null {\n  color: #855a00;\n}\n.json-formatter-row .json-formatter-undefined {\n  color: #ca0b69;\n}\n.json-formatter-row .json-formatter-function {\n  color: #FF20ED;\n}\n.json-formatter-row .json-formatter-date {\n  background-color: rgba(0, 0, 0, 0.05);\n}\n.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: blue;\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-bracket {\n  color: blue;\n}\n.json-formatter-row .json-formatter-key {\n  color: #00008b;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "\u25ba";\n}\n.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n.json-formatter-dark.json-formatter-row {\n  font-family: monospace;\n}\n.json-formatter-dark.json-formatter-row,\n.json-formatter-dark.json-formatter-row a,\n.json-formatter-dark.json-formatter-row a:hover {\n  color: white;\n  text-decoration: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-row {\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty {\n  opacity: 0.5;\n  margin-left: 1rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty:after {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-object:after {\n  content: "No properties";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-children.json-formatter-empty.json-formatter-array:after {\n  content: "[]";\n}\n.json-formatter-dark.json-formatter-row .json-formatter-string,\n.json-formatter-dark.json-formatter-row .json-formatter-stringifiable {\n  color: #31f031;\n  white-space: pre;\n  word-wrap: break-word;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-number {\n  color: #66c2ff;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-boolean {\n  color: #EC4242;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-null {\n  color: #EEC97D;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-undefined {\n  color: #ef8fbe;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-function {\n  color: #FD48CB;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-date {\n  background-color: rgba(255, 255, 255, 0.05);\n}\n.json-formatter-dark.json-formatter-row .json-formatter-url {\n  text-decoration: underline;\n  color: #027bff;\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-bracket {\n  color: #9494ff;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-key {\n  color: #23a0db;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler-link {\n  cursor: pointer;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler {\n  line-height: 1.2rem;\n  font-size: 0.7rem;\n  vertical-align: middle;\n  opacity: 0.6;\n  cursor: pointer;\n  padding-right: 0.2rem;\n}\n.json-formatter-dark.json-formatter-row .json-formatter-toggler:after {\n  display: inline-block;\n  transition: transform 100ms ease-in;\n  content: "\u25ba";\n}\n.json-formatter-dark.json-formatter-row > a > .json-formatter-preview-text {\n  opacity: 0;\n  transition: opacity 0.15s ease-in;\n  font-style: italic;\n}\n.json-formatter-dark.json-formatter-row:hover > a > .json-formatter-preview-text {\n  opacity: 0.6;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-toggler-link .json-formatter-toggler:after {\n  transform: rotate(90deg);\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > .json-formatter-children:after {\n  display: inline-block;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open > a > .json-formatter-preview-text {\n  display: none;\n}\n.json-formatter-dark.json-formatter-row.json-formatter-open.json-formatter-empty:after {\n  display: block;\n}\n');var h=/(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/,d=/\d{2}:\d{2}:\d{2} GMT-\d{4}/,p=/\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/,j=/^https?:\/\//,u=window.requestAnimationFrame||function(t){return t(),0},y={hoverPreviewEnabled:!1,hoverPreviewArrayCount:100,hoverPreviewFieldCount:5,animateOpen:!0,animateClose:!0,theme:null,useToJSON:!0,sortPropertiesBy:null,maxArrayItems:100,exposePath:!1},g=function(){function t(t,r,e,n,o,i,s){void 0===r&&(r=1),void 0===e&&(e=y),void 0===i&&(i=[]),this.json=t,this.open=r,this.config=e,this.key=n,this.displayKey=o,this.path=i,this.arrayRange=s,this._isOpen=null,void 0===this.config.hoverPreviewEnabled&&(this.config.hoverPreviewEnabled=y.hoverPreviewEnabled),void 0===this.config.hoverPreviewArrayCount&&(this.config.hoverPreviewArrayCount=y.hoverPreviewArrayCount),void 0===this.config.hoverPreviewFieldCount&&(this.config.hoverPreviewFieldCount=y.hoverPreviewFieldCount),void 0===this.config.useToJSON&&(this.config.useToJSON=y.useToJSON),void 0===this.config.maxArrayItems&&(this.config.maxArrayItems=y.maxArrayItems),""===this.key&&(this.key='""'),void 0===this.displayKey&&(this.displayKey=this.key)}return Object.defineProperty(t.prototype,"isOpen",{get:function(){return null!==this._isOpen?this._isOpen:this.open>0},set:function(t){this._isOpen=t},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isDate",{get:function(){return this.json instanceof Date||"string"===this.type&&(h.test(this.json)||p.test(this.json)||d.test(this.json))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isUrl",{get:function(){return"string"===this.type&&j.test(this.json)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isArray",{get:function(){return Array.isArray(this.json)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isLargeArray",{get:function(){return this.isArray&&this.json.length>this.config.maxArrayItems},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isArrayRange",{get:function(){return this.isArray&&void 0!==this.arrayRange&&2==this.arrayRange.length},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isObject",{get:function(){return s(this.json)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isEmptyObject",{get:function(){return!this.keys.length&&!this.isArray},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"isEmpty",{get:function(){return this.isEmptyObject||this.keys&&!this.keys.length&&this.isArray},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"useToJSON",{get:function(){return this.config.useToJSON&&"stringifiable"===this.type},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"hasKey",{get:function(){return void 0!==this.key},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"constructorName",{get:function(){return a(this.json)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"type",{get:function(){return this.config.useToJSON&&this.json&&this.json.toJSON?"stringifiable":i(this.json)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"keys",{get:function(){if(this.isObject){var t=Object.keys(this.json);if(this.isLargeArray){var r=Math.ceil(this.json.length/this.config.maxArrayItems);t=[];for(var e=0;e<r;e++){var n=e*this.config.maxArrayItems,o=Math.min(this.json.length-1,n+(this.config.maxArrayItems-1));t.push("".concat(n," \u2026 ").concat(o))}}return!this.isArray&&this.config.sortPropertiesBy?t.sort(this.config.sortPropertiesBy):t}return[]},enumerable:!1,configurable:!0}),t.prototype.toggleOpen=function(){this.isOpen=!this.isOpen,this.element&&(this.isOpen?this.appendChildren(this.config.animateOpen):this.removeChildren(this.config.animateClose),this.element.classList.toggle(c("open")))},t.prototype.openAtDepth=function(t){void 0===t&&(t=1),t<0||(this.open=t,this.isOpen=0!==t,this.element&&(this.removeChildren(!1),0===t?this.element.classList.remove(c("open")):(this.appendChildren(this.config.animateOpen),this.element.classList.add(c("open")))))},t.prototype.getInlinepreview=function(){var t=this;if(this.isArray)return this.json.length>this.config.hoverPreviewArrayCount?"Array[".concat(this.json.length,"]"):"[".concat(this.json.map(m).join(", "),"]");var r=this.keys,e=r.slice(0,this.config.hoverPreviewFieldCount).map((function(r){return"".concat(r,":").concat(m(t.json[r]))})),n=r.length>=this.config.hoverPreviewFieldCount?"\u2026":"";return"{".concat(e.join(", ")).concat(n,"}")},t.prototype.render=function(){this.element=l("div","row");var t=this.isObject?l("a","toggler-link"):l("span");if(this.isObject&&!this.useToJSON&&t.appendChild(l("span","toggler")),this.isArrayRange?t.appendChild(l("span","range","[".concat(this.displayKey,"]"))):this.hasKey&&(t.appendChild(l("span","key","".concat(this.displayKey,":"))),this.config.exposePath&&(this.element.dataset.path=JSON.stringify(this.path))),this.isObject&&!this.useToJSON){var r=l("span","value"),e=l("span");if(!this.isArrayRange){var n=l("span","constructor-name",this.constructorName);e.appendChild(n)}if(this.isArray&&!this.isArrayRange){var o=l("span");o.appendChild(l("span","bracket","[")),o.appendChild(l("span","number",this.json.length)),o.appendChild(l("span","bracket","]")),e.appendChild(o)}r.appendChild(e),t.appendChild(r)}else{(r=this.isUrl?l("a"):l("span")).classList.add(c(this.type)),this.isDate&&r.classList.add(c("date")),this.isUrl&&(r.classList.add(c("url")),r.setAttribute("href",this.json));var i=f(this.type,this.json,this.useToJSON?this.json.toJSON():this.json);r.appendChild(document.createTextNode(i)),t.appendChild(r)}if(this.isObject&&this.config.hoverPreviewEnabled){var s=l("span","preview-text");s.appendChild(document.createTextNode(this.getInlinepreview())),t.appendChild(s)}var a=l("div","children");return this.isObject&&a.classList.add(c("object")),this.isArray&&a.classList.add(c("array")),this.isEmpty&&a.classList.add(c("empty")),this.config&&this.config.theme&&this.element.classList.add(c(this.config.theme)),this.isOpen&&this.element.classList.add(c("open")),this.element.appendChild(t),this.element.appendChild(a),this.isObject&&this.isOpen&&this.appendChildren(),this.isObject&&!this.useToJSON&&t.addEventListener("click",this.toggleOpen.bind(this)),this.element},t.prototype.appendChildren=function(r){var e=this;void 0===r&&(r=!1);var n=this.element.querySelector("div.".concat(c("children")));if(n&&!this.isEmpty){var o=function(r,o){var i=e.isLargeArray?[o*e.config.maxArrayItems,Math.min(e.json.length-1,o*e.config.maxArrayItems+(e.config.maxArrayItems-1))]:void 0,s=e.isArrayRange?(e.arrayRange[0]+o).toString():r,a=new t(i?e.json.slice(i[0],i[1]+1):e.json[r],e.open-1,e.config,r,s,i?e.path:e.path.concat(s),i);n.appendChild(a.render())};if(r){var i=0,s=function(){var t=e.keys[i];o(t,i),(i+=1)<e.keys.length&&(i>10?s():u(s))};u(s)}else this.keys.forEach((function(t,r){return o(t,r)}))}},t.prototype.removeChildren=function(t){void 0===t&&(t=!1);var r=this.element.querySelector("div.".concat(c("children")));if(t){var e=0,n=function(){r&&r.children.length&&(r.removeChild(r.children[0]),(e+=1)>10?n():u(n))};u(n)}else r&&(r.innerHTML="")},t}();e.default=g},
"a123a88e31": function _(e,t,s,o,i){var n,d;o();const h=e("@bokehjs/core/dom"),a=e("@bokehjs/core/bokeh_events"),r=e("9b11ce01a3");class m extends a.ModelEvent{constructor(e){super(),this.data=e}get event_values(){return{model:this.origin,data:this.data}}}s.JSONEditEvent=m,n=m,m.__name__="JSONEditEvent",n.prototype.event_name="json_edit";class l extends r.HTMLBoxView{connect_signals(){super.connect_signals();const{data:e,disabled:t,templates:s,menu:o,mode:i,search:n,schema:d}=this.model.properties;this.on_change([e],(()=>this.editor.update(this.model.data))),this.on_change([s],(()=>{this.editor.options.templates=this.model.templates})),this.on_change([o],(()=>{this.editor.options.mainMenuBar=this.model.menu})),this.on_change([n],(()=>{this.editor.options.search=this.model.search})),this.on_change([d],(()=>{this.editor.options.schema=this.model.schema})),this.on_change([t,i],(()=>{const e=this.model.disabled?"view":this.model.mode;this.editor.setMode(e)}))}stylesheets(){const e=super.stylesheets();for(const t of this.model.css)e.push(new h.ImportedStyleSheet(t));return e}remove(){super.remove(),this.editor.destroy()}render(){super.render();const e=this.model.disabled?"view":this.model.mode;this.editor=new window.JSONEditor(this.shadow_el,{mainMenuBar:this.model.menu,mode:e,onChangeJSON:e=>{this.model.trigger_event(new m(e))},onChangeText:e=>{try{this.model.trigger_event(new m(JSON.parse(e)))}catch(e){console.warn(e)}},onSelectionChange:(e,t)=>{this.model.selection=[e,t]},search:this.model.search,schema:this.model.schema,templates:this.model.templates}),this.editor.set(this.model.data)}}s.JSONEditorView=l,l.__name__="JSONEditorView";class c extends r.HTMLBox{constructor(e){super(e)}}s.JSONEditor=c,d=c,c.__name__="JSONEditor",c.__module__="panel.models.jsoneditor",d.prototype.default_view=l,d.define((({Any:e,List:t,Bool:s,Str:o})=>({css:[t(o),[]],data:[e,{}],mode:[o,"tree"],menu:[s,!0],search:[s,!0],selection:[t(e),[]],schema:[e,null],templates:[t(e),[]]})))},
"f672d71a9f": function _(e,t,n,s,i){var r;s();const a=e("@bokehjs/models/widgets/markup"),l=e("9b11ce01a3");class d extends l.PanelMarkupView{connect_signals(){super.connect_signals();const{text:e}=this.model.properties;this.on_change(e,(()=>this.render()))}render(){super.render(),this.container.innerHTML=this.model.text,window.renderMathInElement&&window.renderMathInElement(this.shadow_el,{delimiters:[{left:"$$",right:"$$",display:!0},{left:"\\[",right:"\\]",display:!0},{left:"$",right:"$",display:!1},{left:"\\(",right:"\\)",display:!1}]})}}n.KaTeXView=d,d.__name__="KaTeXView";class o extends a.Markup{constructor(e){super(e)}}n.KaTeX=o,r=o,o.__name__="KaTeX",o.__module__="panel.models.katex",r.prototype.default_view=d},
"bd8e0fe48b": function _(o,e,h,t,a){var i;t();const s=o("@bokehjs/core/view"),n=o("@bokehjs/model");class d extends s.View{initialize(){super.initialize(),this.model.pathname=window.location.pathname,this.model.search=window.location.search,this.model.hash=window.location.hash,this.model.href=window.location.href,this.model.hostname=window.location.hostname,this.model.protocol=window.location.protocol,this.model.port=window.location.port,this._hash_listener=()=>{this.model.hash=window.location.hash},window.addEventListener("hashchange",this._hash_listener),this._has_finished=!0,this.notify_finished()}connect_signals(){super.connect_signals();const{pathname:o,search:e,hash:h,reload:t}=this.model.properties;this.on_change(o,(()=>this.update("pathname"))),this.on_change(e,(()=>this.update("search"))),this.on_change(h,(()=>this.update("hash"))),this.on_change(t,(()=>this.update("reload")))}remove(){super.remove(),window.removeEventListener("hashchange",this._hash_listener)}update(o){this.model.reload&&"reload"!==o?("pathname"==o&&(window.location.pathname=this.model.pathname),"search"==o&&(window.location.search=this.model.search),"hash"==o&&(window.location.hash=this.model.hash)):(window.history.pushState({},"",`${this.model.pathname}${this.model.search}${this.model.hash}`),this.model.href=window.location.href,"reload"===o&&window.location.reload())}}h.LocationView=d,d.__name__="LocationView";class l extends n.Model{constructor(o){super(o)}}h.Location=l,i=l,l.__name__="Location",l.__module__="panel.models.location",i.prototype.default_view=d,i.define((({Bool:o,Str:e})=>({href:[e,""],hostname:[e,""],pathname:[e,""],protocol:[e,""],port:[e,""],search:[e,""],hash:[e,""],reload:[o,!1]})))},
"d889a68424": function _(e,t,s,a,n){var r;a();const i=e("@bokehjs/models/widgets/markup"),o=e("9b11ce01a3");class h extends o.PanelMarkupView{connect_signals(){super.connect_signals();const{text:e}=this.model.properties;this.on_change(e,(()=>this.rerender_()))}render(){super.render();const e=this.model.text,t=this.provider.MathJax.find_tex(e),s=[];let a=0;for(const n of t)s.push(e.slice(a,n.start.n)),s.push(this.provider.MathJax.tex2svg(n.math,{display:n.display}).outerHTML),a=n.end.n;a<e.length&&s.push(e.slice(a)),this.container.innerHTML=s.join("")}}s.MathJaxView=h,h.__name__="MathJaxView";class _ extends i.Markup{constructor(e){super(e)}}s.MathJax=_,r=_,_.__name__="MathJax",_.__module__="panel.models.mathjax",r.prototype.default_view=h},
"8c62aa80d9": function _(e,t,o,s,i){var l,n;s();const a=e("tslib");var d,h=this&&this.__decorate||function(e,t,o,s){var i,l=arguments.length,n=l<3?t:null===s?s=Object.getOwnPropertyDescriptor(t,o):s;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)n=Reflect.decorate(e,t,o,s);else for(var a=e.length-1;a>=0;a--)(i=e[a])&&(n=(l<3?i(n):l>3?i(t,o,n):i(t,o))||n);return l>3&&n&&Object.defineProperty(t,o,n),n};const c=e("@bokehjs/models/layouts/column"),r=e("@bokehjs/core/dom"),_=e("@bokehjs/core/bokeh_events"),u=e("@bokehjs/models/ui/ui_element"),p=e("@bokehjs/core/util/types"),m=e("@bokehjs/models/layouts/layout_dom"),b=a.__importDefault(e("be4b4352c6"));let g=(l=class extends _.ModelEvent{constructor(e,t){super(),this.model=e,this.open=t,this.open=t,this.origin=e}get event_values(){return{open:this.open,origin:this.origin}}static from_values(e){const{open:t,model:o}=e;return new d(o,t)}},d=l,l.__name__="ModalDialogEvent",l);o.ModalDialogEvent=g,o.ModalDialogEvent=g=d=h([(0,_.server_event)("modal-dialog-event")],g);class y extends c.ColumnView{connect_signals(){super.connect_signals();const{show_close_button:e}=this.model.properties;this.on_change([e],this.update_close_button),this.model.on_event(g,(e=>{e.open?this.modal.show():this.modal.hide()}))}render(){u.UIElementView.prototype.render.call(this),this.class_list.add(...this.css_classes()),this.create_modal()}stylesheets(){return[...super.stylesheets(),b.default]}async update_children(){await m.LayoutDOMView.prototype.update_children.call(this)}create_modal(){const e=(0,r.div)({id:"pnx_dialog",class:"dialog-container bk-root",style:{display:"none"}}),t=(0,r.div)({class:"dialog-overlay"});this.model.background_close&&t.setAttribute("data-a11y-dialog-hide","");const{height:o,width:s,min_height:i,min_width:l,max_height:n,max_width:a}=this.model,d=(0,r.div)({id:"pnx_dialog_content",class:"dialog-content",role:"document",style:{height:(0,p.isNumber)(o)?`${o}px`:o,width:(0,p.isNumber)(s)?`${s}px`:s,min_height:(0,p.isNumber)(i)?`${i}px`:i,min_width:(0,p.isNumber)(l)?`${l}px`:l,max_height:(0,p.isNumber)(n)?`${n}px`:n,max_width:(0,p.isNumber)(a)?`${a}px`:a,overflow:"auto"}});for(const e of this.child_views){const t=e.rendering_target()??d;e.render_to(t)}this.close_button=(0,r.button)({id:"pnx_dialog_close","data-a11y-dialog-hide":"",class:"pnx-dialog-close",ariaLabel:"Close this dialog window"}),this.close_button.innerHTML="&#x2715",e.append(t),e.append(d),d.append(this.close_button),this.shadow_el.append(e);let h=!1;this.modal=new A11yDialog(e),this.update_close_button(),this.modal.on("show",(()=>{this.model.open=!0,e.style.display="",h||(requestAnimationFrame((()=>{this.invalidate_layout(),e.focus()})),h=!0)})),this.modal.on("hide",(()=>{this.model.open=!1,e.style.display="none"})),this.model.open&&this.modal.show()}update_close_button(){this.model.show_close_button?this.close_button.style.display="block":this.close_button.style.display="none"}}o.ModalView=y,y.__name__="ModalView";class w extends c.Column{constructor(e){super(e)}}o.Modal=w,n=w,w.__name__="Modal",w.__module__="panel.models.modal",n.prototype.default_view=y,n.define((({Bool:e})=>({open:[e,!1],show_close_button:[e,!0],background_close:[e,!0]})))},
"be4b4352c6": function _(o,a,e,i,d){i(),e.panel_models_modal_Modal="bk-panel-models-modal-Modal",e.default=":host(.bk-panel-models-modal-Modal){width:0;height:0;}.dialog-container,.dialog-overlay{position:fixed;top:0;right:0;bottom:0;left:0;}.dialog-container{z-index:100002;display:flex;}.dialog-overlay{z-index:100001;background-color:rgba(43, 46, 56, 0.9);}.dialog-content{margin:auto;z-index:100002;position:relative;background-color:white;border-radius:2px;padding:10px;padding-bottom:20px;}@keyframes fade-in{from{opacity:0;}}@keyframes slide-up{from{transform:translateY(10%);}}.dialog-overlay{animation:fade-in 200ms both;}.dialog-content{animation:fade-in 400ms 200ms both, slide-up 400ms 200ms both;}@media (prefers-reduced-motion: reduce){.dialog-overlay,.dialog-content{animation:none;}}.pnx-dialog-close{position:absolute;top:0;right:0;border:0;padding:0;background-color:transparent;font-size:1.5em;width:1.5em;height:1.5em;text-align:center;cursor:pointer;transition:0.15s;border-radius:50%;z-index:100003;}.pnx-dialog-close:hover{background-color:rgba(50, 50, 0, 0.15);}.lm-Widget.p-Widget.lm-TabBar.p-TabBar.lm-DockPanel-tabBar.jp-Activity{z-index:-1;}"},
"f87ad1873c": function _(e,t,n,s,o){var a;s();const i=e("@bokehjs/models/widgets/markup"),r=e("9b11ce01a3"),c=e("4c04683fdc");class d extends r.PanelMarkupView{connect_signals(){super.connect_signals();const{text:e,width:t,height:n,embed:s,start_page:o}=this.model.properties;this.on_change([e,t,n,s,o],(()=>{this.update()}))}render(){super.render(),this.update()}update(){if(this.model.embed){const e=this.convert_base64_to_blob(),t=URL.createObjectURL(e);this.container.innerHTML=`<embed src="${t}#page=${this.model.start_page}" type="application/pdf" width="100%" height="100%"></embed>`}else{const e=(0,c.html_decode)(this.model.text);this.container.innerHTML=e||""}}convert_base64_to_blob(){const e=atob(this.model.text),t=[];for(let n=0;n<e.length;n+=512){const s=e.slice(n,n+512),o=new Uint8Array(s.length);for(let e=0;e<s.length;e++)o[e]=s.charCodeAt(e);t.push(o)}return new Blob(t,{type:"application/pdf"})}}n.PDFView=d,d.__name__="PDFView";class l extends i.Markup{constructor(e){super(e)}}n.PDF=l,a=l,l.__name__="PDF",l.__module__="panel.models.markup",a.prototype.default_view=d,a.define((({Int:e,Bool:t})=>({embed:[t,!1],start_page:[e,1]})))},
"29a0b0da9a": function _(e,t,s,i,n){var r,o;i();const l=e("tslib"),c=e("@bokehjs/core/bokeh_events"),h=e("@bokehjs/core/dom"),a=e("@bokehjs/models/sources/column_data_source"),_=e("9b11ce01a3"),p=l.__importDefault(e("2e2913ea54")),d={"pro-dark":"Pro Dark",pro:"Pro Light",vaporwave:"Vaporwave",solarized:"Solarized","solarized-dark":"Solarized Dark",monokai:"Monokai"},m={datagrid:"Datagrid",d3_x_bar:"X Bar",d3_y_bar:"Y Bar",d3_xy_line:"X/Y Line",d3_y_line:"Y Line",d3_y_area:"Y Area",d3_y_scatter:"Y Scatter",d3_xy_scatter:"X/Y Scatter",d3_treemap:"Treemap",d3_candlestick:"Candlestick",d3_sunburst:"Sunburst",d3_heatmap:"Heatmap",d3_ohlc:"OHLC"};function g(e){const t={};return Object.keys(e).forEach((s=>{t[e[s]]=s})),t}const u=g(m),v=g(d);class f extends c.ModelEvent{constructor(e,t,s){super(),this.config=e,this.column_names=t,this.row=s}get event_values(){return{model:this.origin,config:this.config,column_names:this.column_names,row:this.row}}}s.PerspectiveClickEvent=f,r=f,f.__name__="PerspectiveClickEvent",r.prototype.event_name="perspective-click";class b extends _.HTMLBoxView{constructor(){super(...arguments),this._updating=!1,this._config_listener=null,this._current_config=null,this._current_plugin=null,this._loaded=!1,this._plugin_configs=new Map}connect_signals(){super.connect_signals(),this.connect(this.model.source.properties.data.change,(()=>this.setData())),this.connect(this.model.source.streaming,(()=>this.stream())),this.connect(this.model.source.patching,(()=>this.patch()));const{schema:e,columns:t,expressions:s,split_by:i,group_by:n,aggregates:r,filters:o,sort:l,plugin:c,selectable:h,editable:a,theme:_,title:p,settings:g}=this.model.properties,u=e=>()=>{this._updating||e()};this.on_change(e,(()=>{this.worker.table(this.model.schema).then((e=>{this.table=e,this.table.update(this.data),this.perspective_element.load(this.table)}))})),this.on_change(t,u((()=>{this.perspective_element.restore({columns:this.model.columns})}))),this.on_change(s,u((()=>{this.perspective_element.restore({expressions:this.model.expressions})}))),this.on_change(i,u((()=>{this.perspective_element.restore({split_by:this.model.split_by})}))),this.on_change(n,u((()=>{this.perspective_element.restore({group_by:this.model.group_by})}))),this.on_change(r,u((()=>{this.perspective_element.restore({aggregates:this.model.aggregates})}))),this.on_change(o,u((()=>{this.perspective_element.restore({filter:this.model.filters})}))),this.on_change(g,u((()=>{this.perspective_element.restore({settings:this.model.settings})}))),this.on_change(p,u((()=>{this.perspective_element.restore({title:this.model.title})}))),this.on_change(l,u((()=>{this.perspective_element.restore({sort:this.model.sort})}))),this.on_change(c,u((()=>{this.perspective_element.restore({plugin:m[this.model.plugin],...g})}))),this.on_change(h,u((()=>{this.perspective_element.restore({plugin_config:{...this._current_config,selectable:this.model.selectable}})}))),this.on_change(a,u((()=>{this.perspective_element.restore({plugin_config:{...this._current_config,editable:this.model.editable}})}))),this.on_change(_,u((()=>{this.perspective_element.restore({theme:d[this.model.theme]}).catch((()=>{}))})))}disconnect_signals(){null!=this._config_listener&&this.perspective_element.removeEventListener("perspective-config-update",this._config_listener),this._config_listener=null,super.disconnect_signals()}remove(){this.perspective_element&&this.perspective_element.delete((()=>this.worker.terminate())),super.remove()}stylesheets(){return[...super.stylesheets(),p.default]}render(){super.render();const e=(0,h.div)({class:"pnx-perspective-viewer",style:{zIndex:"0"}});this._current_plugin=this.model.plugin,(0,_.set_size)(e,this.model),this.shadow_el.appendChild(e),new Promise(((e,t)=>{const s=Date.now(),i=()=>{void 0!==window.perspective_viewer?e(null):Date.now()-s>5e3?t(new Error("Timed out waiting for window.perspective_viewer")):setTimeout(i,100)};i()})).then((()=>{window.perspective.worker().then((t=>{this.worker=t,t.table(this.model.schema).then((t=>{this.table=t,this.table.update(this.data),e.innerHTML="<perspective-viewer style='height:100%; width:100%;'></perspective-viewer>",this.perspective_element=e.children[0];const s=Object.values(d).filter((e=>e!==this.model.theme)),i=[this.model.theme,...s];this.perspective_element.resetThemes(i).catch((()=>{})),this.perspective_element.load(this.table);const n={...this.model.plugin_config,editable:this.model.editable,selectable:this.model.selectable};this.perspective_element.restore({aggregates:this.model.aggregates,columns:this.model.columns,columns_config:this.model.columns_config,expressions:this.model.expressions,filter:this.model.filters,split_by:this.model.split_by,group_by:this.model.group_by,plugin:m[this.model.plugin],plugin_config:n,settings:this.model.settings,sort:this.model.sort,theme:d[this.model.theme],title:this.model.title}).catch((()=>{})),this.perspective_element.save().then((e=>{this._current_config=e})),this._config_listener=()=>this.sync_config(),this.perspective_element.addEventListener("perspective-config-update",this._config_listener),this.perspective_element.addEventListener("perspective-click",(e=>{this.model.trigger_event(new f(e.detail.config,e.detail.column_names,e.detail.row))})),this._loaded=!0}))}))}))}sync_config(){return this._updating||this.perspective_element.save().then((e=>{if(e.plugin!==this._current_plugin&&(this._plugin_configs.set(this._current_plugin,{columns:this._current_config.columns,columns_config:this._current_config.columns_config,plugin_config:this._current_config.plugin_config}),this._plugin_configs.has(e.plugin))){const t=this._plugin_configs.get(e.plugin);this.perspective_element.restore(t),e={...e,...t}}this._current_config=e,this._current_plugin=e.plugin;const t={};for(let s in e){let i=e[s];void 0===i||"plugin"==s&&"debug"===i||"version"==s||void 0===this.model.properties.hasOwnProperty(s)||("filter"===s?s="filters":"plugin"===s?i=u[i]:"theme"===s&&(i=v[i]),t[s]=i)}this._updating=!0,this.model.setv(t),this._updating=!1})),!0}get data(){const e={};for(const t of this.model.source.columns()){let s=this.model.source.get_array(t);"datetime"==this.model.schema[t]&&s.includes(-9223372036854776)&&(s=s.map((e=>-9223372036854776===e?null:e))),e[t]=s}return e}setData(){if(this._loaded){for(const e of this.model.source.columns())if(!(e in this.model.schema))return;this.table.replace(this.data)}}stream(){this._loaded&&this.table.replace(this.data)}patch(){this._loaded&&this.table.replace(this.data)}}s.PerspectiveView=b,b.__name__="PerspectiveView";class w extends _.HTMLBox{constructor(e){super(e)}}s.Perspective=w,o=w,w.__name__="Perspective",w.__module__="panel.models.perspective",o.prototype.default_view=b,o.define((({Any:e,List:t,Bool:s,Ref:i,Nullable:n,Str:r})=>({aggregates:[e,{}],columns:[t(n(r)),[]],columns_config:[e,{}],expressions:[e,{}],split_by:[n(t(r)),null],editable:[s,!0],filters:[n(t(e)),null],group_by:[n(t(r)),null],plugin:[r],plugin_config:[e,{}],selectable:[s,!0],settings:[s,!0],schema:[e,{}],sort:[n(t(t(r))),null],source:[i(a.ColumnDataSource)],theme:[r,"pro"],title:[n(r),null]})))},
"2e2913ea54": function _(e,r,t,a,o){a(),t.default="regular-table{padding:0;margin:12px 0 0 12px;scrollbar-color:transparent transparent;scrollbar-width:thin;outline:none;}regular-table:hover{scrollbar-color:rgba(0, 0, 0, 0.3) transparent;}.sub-cell-scroll-enabled regular-table table tbody td,.sub-cell-scroll-enabled regular-table table thead th:not(.rt-group-corner){transform:translate(var(--regular-table--transform-x, 0px));}.sub-cell-scroll-enabled regular-table table tbody{transform:translate(0, var(--regular-table--transform-y, 0px));}.sub-cell-scroll-enabled regular-table table tbody tr:first-child td,.sub-cell-scroll-enabled regular-table table tbody tr:first-child th{clip-path:polygon(0 var(--regular-table--clip-y, 0), 0 200%, 200% 200%, 200% var(--regular-table--clip-y, 0));}.sub-cell-scroll-enabled regular-table table thead th.rt-group-corner{background:var(--plugin--background, white);z-index:1;}.sub-cell-scroll-enabled regular-table table tbody tr td:first-of-type{clip-path:polygon(var(--regular-table--clip-x, 0) 0, var(--regular-table--clip-x, 0) 200%, 200% 200%, 200% 0);}.sub-cell-scroll-enabled regular-table table tbody tr:first-child td:first-of-type{clip-path:polygon(var(--regular-table--clip-x, 0) var(--regular-table--clip-y, 0), var(--regular-table--clip-x, 0) 200%, 200% 200%, 200% var(--regular-table--clip-y, 0));}regular-table{font-family:inherit;}regular-table div[tabindex]{outline:none;}regular-table > div{position:absolute;top:0;left:0;right:0;bottom:0;overflow:hidden;}regular-table th{text-align:center;}regular-table thead tr:not(:last-child) th{overflow:hidden;max-width:0px;}regular-table thead tr:last-child .rt-float,regular-table tbody .rt-float{text-align:right;}regular-table thead .rt-integer,regular-table tbody .rt-integer{text-align:right;}regular-table tbody th{text-align:left;}regular-table span.rt-tree-container{display:flex;align-items:center;height:100%;}regular-table thead .rt-string,regular-table tbody .rt-string,regular-table thead .rt-date,regular-table tbody .rt-date,regular-table thead .rt-datetime,regular-table tbody .rt-datetime{text-align:left;}regular-table thead tr:last-child th{border-bottom:1px solid #eaedef;}regular-table tbody tr:first-child td,regular-table tbody tr:first-child th{border-top:1px solid transparent !important;}regular-table th{position:relative;}regular-table tr th span.rt-tree-group{margin-left:5px;margin-right:15px;border-left:1px solid #eee;height:100%;}regular-table td,regular-table th{white-space:nowrap;font-size:12px;padding-right:5px;padding-left:5px;padding-top:0px;padding-bottom:0px;height:19px;}regular-table tr:hover td{background:#eee;opacity:1;}regular-table tr:hover{color:#333;}regular-table table *{box-sizing:border-box;}regular-table table{position:absolute;overflow:hidden;color:#666;outline:none;}regular-table span.rt-row-header-icon{color:#aaa;padding-right:4px;font-family:var(--button--font-family, 'Material Icons');}regular-table span.rt-column-header-icon{font-size:10px;padding-left:3px;display:inline-block;width:10px;font-family:var(--button--font-family, 'Material Icons');}regular-table span.rt-row-header-icon:hover{color:#1a7da1;text-shadow:0px 0px 3px #1a7da1;}regular-table .rt-selected td{background-color:#eee;}regular-table .rt-cell-clip{overflow:hidden;text-overflow:ellipsis;}regular-table td span.rt-group-name,regular-table th span.rt-group-name{margin-right:-5px;padding-right:5px;padding-left:8px;flex:1;height:100%;}regular-table th span.rt-group-name{text-align:left;}regular-table td th span.rt-group-leaf,regular-table th span.rt-group-leaf{margin-left:16px;height:100%;}regular-table .rt-column-resize{height:100%;width:10px;position:absolute;top:0;right:0;cursor:col-resize;}regular-table a{color:var(--rt-pos-cell--color);}regular-table a:visited{color:var(--active--color);}regular-table::-webkit-scrollbar,regular-table::-webkit-scrollbar-corner{background-color:transparent;height:12px;width:12px;}regular-table::-webkit-scrollbar-thumb{background-clip:content-box;background-color:rgba(0, 0, 0, 0);border-radius:5px;}regular-table::-webkit-scrollbar-thumb:horizontal{border-bottom:2px solid transparent;border-top:2px solid transparent;}regular-table::-webkit-scrollbar-thumb:vertical{border-left:2px solid transparent;border-right:2px solid transparent;}regular-table:hover::-webkit-scrollbar-thumb{background-color:rgba(0, 0, 0, 0.15);}regular-table::-webkit-scrollbar-thumb:hover{background-color:rgba(0, 0, 0, 0.3);}.psp-header-border:not(.psp-is-top):not(.psp-header-leaf){box-shadow:1px 0px var(--inactive--color, #eaedef);}.psp-header-group{box-shadow:0px 10px 0 -9px var(--inactive--color, #eaedef);}.psp-is-top{box-shadow:5px 4px 0px -4px var(--inactive--color, #eaedef);}.psp-is-top.psp-header-group:not(.psp-header-group-corner){box-shadow:5px 4px 0px -4px var(--inactive--color, #eaedef), 0px 10px 0 -9px var(--inactive--color, #eaedef);}.psp-header-border.psp-header-group:not(.psp-is-top):not(\n    .psp-header-group-corner\n  ){box-shadow:1px 0px var(--inactive--color, #eaedef), 0px 10px 0 -9px var(--inactive--color, #eaedef);}.psp-header-leaf.psp-header-border{box-shadow:5px -4px 0px -4px var(--inactive--color, #eaedef);}tr:only-child th{box-shadow:none !important;}regular-table tbody tr:hover th.psp-tree-leaf:not(.psp-row-selected):not(.psp-row-subselected),regular-table tbody tr:hover th.psp-tree-label:not(.psp-row-selected):not(.psp-row-subselected),regular-table tbody tr:hover td:not(.psp-row-selected):not(.psp-row-subselected){border-color:var(--rt-hover--border-color, #c5c9d080) !important;background-color:transparent;box-shadow:0px 1px 0px var(--rt-hover--border-color, #c5c9d080), 0px 3px 0px rgba(0, 0, 0, 0.05), 0px 5px 0px rgba(0, 0, 0, 0.01);}regular-table tbody tr:hover + tr th.psp-tree-leaf:not(.psp-row-selected):not(.psp-row-subselected),regular-table tbody tr:hover + tr th.psp-tree-label:not(.psp-row-selected):not(.psp-row-subselected),regular-table tbody tr:hover + tr td:not(.psp-row-selected):not(.psp-row-subselected){border-top-color:transparent;}regular-table tbody tr th:first-child:not(:empty),regular-table tbody tr th:first-child:empty + th:not(:empty),regular-table tbody tr th:first-child:empty ~ th:empty + th:not(:empty),regular-table tbody tr td:first-child{border-left-width:1px;border-left-color:transparent;}regular-table tbody tr th:last-child,regular-table tbody tr td:last-child{border-right-width:1px;border-right-color:transparent;}regular-table tbody tr:hover{color:#161616;}regular-table tbody tr:hover th:first-child:not(:empty),regular-table tbody tr:hover th:first-child:empty + th:not(:empty),regular-table tbody tr:hover th:first-child:empty ~ th:empty + th:not(:empty),regular-table tbody tr:hover td:first-child{border-left-color:var(--rt-hover--border-color, #c5c9d080) !important;}regular-table tbody tr:hover th:last-child,regular-table tbody tr:hover td:last-child{border-right-color:var(--rt-hover--border-color, #c5c9d080) !important;}perspective-viewer[settings] regular-table .psp-header-leaf{height:36px;vertical-align:top;padding-top:2px;}perspective-viewer[settings] regular-table .psp-header-leaf:not(.psp-header-corner):before{font-family:var(--button--font-family, inherit);content:var(--column-style-open-button--content, var(--config-button-icon--content, '\u1f527'));position:absolute;width:calc(100% - 8px);left:5px;bottom:0px;color:var(--inactive--color, #b4b7be);}perspective-viewer[settings] regular-table .psp-header-leaf.psp-menu-enabled:not(.psp-header-corner):before{color:inherit;cursor:pointer;}perspective-viewer[settings] regular-table .psp-header-leaf.psp-menu-open:not(.psp-header-corner){pointer-events:none;}perspective-viewer[settings] regular-table .psp-header-leaf.psp-menu-open:not(.psp-header-corner):before{content:var(--column-style-close-button--content, 'X');}perspective-viewer[settings] regular-table .psp-header-leaf.psp-menu-enabled:hover:before{color:#338dcd;}perspective-viewer[settings] regular-table .psp-header-leaf .rt-column-resize{height:18px;}.psp-row-selected,:hover .psp-row-selected,:hover th.psp-tree-leaf.psp-row-selected,:hover th.psp-tree-label.psp-row-selected{color:white !important;background-color:#ea7319 !important;border-color:#ea7319 !important;}.psp-row-selected.psp-tree-label:not(:hover):before{color:white;}.psp-row-subselected,:hover .psp-row-subselected,:hover th.psp-tree-leaf.psp-row-subselected,:hover th.psp-tree-label.psp-row-subselected{background:rgba(234, 115, 25, 0.2) !important;}.psp-error{color:red;}td:focus{outline:#666;outline-style:dotted;outline-width:1px;}perspective-viewer.dragging regular-table{pointer-events:none;}.psp-header-border:last-child{border-right-width:0px;}.psp-header-sort-desc:after{font-family:var(--button--font-family, inherit);font-size:10px;content:var(--sort-order-desc--content, '\u2193');}.psp-header-sort-asc:after{font-family:var(--button--font-family, inherit);font-size:10px;content:var(--sort-order-asc--content, '\u2191');}.psp-header-sort-col-desc:after{font-family:var(--button--font-family, inherit);font-size:10px;content:var(--sort-order-col-desc--content, '\u2190');}.psp-header-sort-col-asc:after{font-family:var(--button--font-family, inherit);font-size:10px;content:var(--sort-order-col-asc--content, '\u2192');}tbody th:last-of-type{border-right:1px solid #eaedef;overflow:hidden;text-overflow:ellipsis;}tbody th:empty{background-image:linear-gradient(to right, transparent 9px, #eee 10px, transparent 11px);background-repeat:no-repeat;min-width:20px;max-width:20px;pointer-events:none;}.psp-tree-label{max-width:0px;min-width:0px;}.psp-tree-label:before{color:#ccc;font-family:var(--button--font-family, inherit);padding-right:11px;vertical-align:-1px;}.psp-tree-label-expand:before{content:var(--tree-label-expand--content, '+');}.psp-tree-label-collapse:before{content:var(--tree-label-collapse--content, '-');}.psp-tree-label:hover:before{color:#338dcd;text-shadow:0px 0px 5px #338dcd;}regular-table thead tr:last-child th{border-bottom-width:1px;border-bottom-color:var(--inactive--color, #eaedef);}.psp-tree-leaf{padding-left:24px;}.psp-align-right{text-align:right;}.psp-align-left{text-align:left;}.psp-positive:not(:focus){color:var(--rt-pos-cell--color, #338dcd);}.psp-negative:not(:focus){color:var(--rt-neg-cell--color, #ff5942);}regular-table table tbody td{min-width:52px !important;}.psp-is-width-override .rt-column-resize,.rt-column-resize:hover{border:1px dashed #999;border-bottom-width:0px;border-left-width:0px;}.psp-bool-type{font-family:var(--button--font-family, 'Material Icons');}.boolean-editable{cursor:pointer;}regular-table table{user-select:none;color:#161616;border-collapse:separate;}regular-table table th{font-weight:400;}regular-table table td,regular-table table th{border-color:#eaedef;height:23px;}regular-table table .psp-header-group{text-overflow:ellipsis;}regular-table table .psp-header-leaf{border-bottom-width:0px;}regular-table table td,regular-table table th.psp-tree-label,regular-table table th.psp-tree-label,regular-table table th.psp-tree-leaf,regular-table table tbody tr:first-child th{border-style:solid;border-width:0px;border-top-width:1px;}regular-table table tbody th:empty{background-position:0px -10px;}@keyframes pulse_pos{0%{background-color:var(--pulse--background-color-start, rgba(0, 128, 255, 0.5));}100%{background-color:var(--pulse--background-color-end, rgba(0, 128, 255, 0));}}@keyframes pulse_pos2{0%{background-color:var(--pulse--background-color-start, rgba(0, 128, 255, 0.5));}100%{background-color:var(--pulse--background-color-end, rgba(0, 128, 255, 0));}}@keyframes pulse_neg{0%{background-color:var(--pulse--background-color-start, rgba(255, 25, 0, 0.5));}100%{background-color:var(--pulse--background-color-end, rgba(255, 25, 0, 0));}}@keyframes pulse_neg2{0%{background-color:var(--pulse--background-color-start, rgba(255, 25, 0, 0.5));}100%{background-color:var(--pulse--background-color-end, rgba(255, 25, 0, 0));}}"},
"7d9124b744": function _(t,e,o,i,s){var n,r;i();const l=t("tslib"),a=t("@bokehjs/core/bokeh_events"),h=t("@bokehjs/core/dom"),c=t("@bokehjs/core/util/types"),d=t("@bokehjs/core/util/object"),_=t("@bokehjs/core/util/eq"),u=t("@bokehjs/models/sources/column_data_source"),p=t("99a25e6992"),y=t("9b11ce01a3"),w=t("a3669a897a"),m=l.__importDefault(t("3d56c75186"));class g extends a.ModelEvent{constructor(t){super(),this.data=t}get event_values(){return{model:this.origin,data:this.data}}}o.PlotlyEvent=g,n=g,g.__name__="PlotlyEvent",n.prototype.event_name="plotly_event";const v=(t,e,o)=>{const i=Array.isArray(e)?[]:{};if("click"===o||"hover"===o||"selected"===o){const o=[];if(null==e)return null;const s=e.event;let n;void 0!==s&&(i.device_state={alt:s.altKey,ctrl:s.ctrlKey,meta:s.metaKey,shift:s.shiftKey,button:s.button,buttons:s.buttons}),n=e.hasOwnProperty("range")?{type:"box",selector_state:{xrange:e.range.x,yrange:e.range.y}}:e.hasOwnProperty("lassoPoints")?{type:"lasso",selector_state:{xs:e.lassoPoints.x,ys:e.lassoPoints.y}}:null,i.selector=n;const r=t.data;for(let t=0;t<e.points.length;t++){const i=e.points[t],s={};for(const t in i){const e=i[t];!i.hasOwnProperty(t)||Array.isArray(e)||(0,c.isPlainObject)(e)||void 0===e||(s[t]=e)}null!=i&&(i.hasOwnProperty("curveNumber")&&i.hasOwnProperty("pointNumber")&&r[i.curveNumber].hasOwnProperty("customdata")&&(s.customdata=r[i.curveNumber].customdata[i.pointNumber]),i.hasOwnProperty("pointNumbers")&&(s.pointNumbers=i.pointNumbers)),o[t]=s}i.points=o}else if("relayout"===o||"restyle"===o)for(const t in e)e.hasOwnProperty(t)&&(i[t]=e[t]);return e.hasOwnProperty("range")&&(i.range=e.range),e.hasOwnProperty("lassoPoints")&&(i.lassoPoints=e.lassoPoints),(0,w.convertUndefined)(i)};class P extends y.HTMLBoxView{constructor(){super(...arguments),this._settingViewport=!1,this._plotInitialized=!1,this._rendered=!1,this._reacting=!1,this._relayouting=!1,this._hoverdata=null,this._end_relayouting=(0,p.debounce)((()=>{this._relayouting=!1}),2e3,!1)}initialize(){super.initialize(),this._throttled_resize=(0,w.throttle)((()=>this.resize_layout()),25)}connect_signals(){super.connect_signals();const{data:t,data_sources:e,layout:o,relayout:i,restyle:s,viewport_update_policy:n,viewport_update_throttle:r,_render_count:l,frames:a,viewport:h}=this.model.properties;this.on_change([t,e,o],(()=>{const t=this.model._render_count;setTimeout((()=>{this.model._render_count===t&&(this.model._render_count+=1)}),250)})),this.on_change(i,(()=>{null!=this.model.relayout&&(window.Plotly.relayout(this.container,this.model.relayout),this.model.relayout=null)})),this.on_change(s,(()=>{null!=this.model.restyle&&(window.Plotly.restyle(this.container,this.model.restyle.data,this.model.restyle.traces),this.model.restyle=null)})),this.on_change(n,(()=>{this._updateSetViewportFunction()})),this.on_change(r,(()=>{this._updateSetViewportFunction()})),this.on_change(l,(()=>{this.plot()})),this.on_change(a,(()=>{this.plot(!0)})),this.on_change(h,(()=>{this._updateViewportFromProperty()}))}stylesheets(){return[...super.stylesheets(),m.default]}remove(){null!=this.container&&window.Plotly.purge(this.container),super.remove()}render(){super.render(),this.container=(0,h.div)(),(0,y.set_size)(this.container,this.model),this._rendered=!1,this.watch_stylesheets(),this.plot(!0).then((()=>{this.shadow_el.appendChild(this.container),this._rendered=!0,this.resize_layout(),null!=this.model.relayout&&window.Plotly.relayout(this.container,this.model.relayout)}))}style_redraw(){this.resize_layout()}resize_layout(){if(!this._rendered||null==this.container)return;const t=Math.min(this.model.width||this.el.clientWidth,this.model.max_width||1/0),e=Math.min(this.model.height||this.el.clientHeight,this.model.max_height||1/0);window.Plotly.relayout(this.container,{width:t,height:e})}after_layout(){super.after_layout(),this._throttled_resize()}_trace_data(){const t=[];for(let e=0;e<this.model.data.length;e++)t.push(this._get_trace(e,!1));return t}_layout_data(){const t=(0,w.deepCopy)(this.model.layout);if(this._relayouting){const{layout:e}=this.container;Object.keys(e).reduce(((e,o)=>{"axis"===o.slice(1,5)&&"range"in e&&(t[o].range=e.range)}),{})}return t}_install_callbacks(){this.container.on("plotly_relayout",(t=>{!0!==t._update_from_property&&(this.model.relayout_data=v(this.container,t,"relayout"),this._updateViewportProperty(),this._end_relayouting())})),this.container.on("plotly_relayouting",(()=>{"mouseup"!==this.model.viewport_update_policy&&(this._relayouting=!0,this._updateViewportProperty())})),this.container.on("plotly_restyle",(t=>{this.model.restyle_data=v(this.container,t,"restyle"),this._updateViewportProperty()})),this.container.on("plotly_click",(t=>{const e=v(this.container,t,"click");this.model.trigger_event(new g({type:"click",data:e}))})),this.container.on("plotly_doubleclick",(t=>{const e=v(this.container,t,"click");this.model.trigger_event(new g({type:"doubleclick",data:e}))})),this.container.on("plotly_hover",(t=>{const e=v(this.container,t,"hover");this.model.trigger_event(new g({type:"hover",data:e})),this._hoverdata=this.container._hoverdata=t.points})),this.container.on("plotly_selected",(t=>{if(null==t)return;const e=v(this.container,t,"selected");this.model.trigger_event(new g({type:"selected",data:e}))})),this.container.on("plotly_clickannotation",(t=>{delete t.event,delete t.fullAnnotation,this.model.trigger_event(new g({type:"clickannotation",data:t}))})),this.container.on("plotly_deselect",(()=>{this.model.trigger_event(new g({type:"selected",data:null}))})),this.container.on("plotly_unhover",(()=>{this.container._hoverdata=this._hoverdata,this.model.trigger_event(new g({type:"hover",data:null})),setTimeout((()=>{delete this.container._hoverdata}),0)}))}async plot(t=!1){if(!window.Plotly||!this.container)return;const e=this._trace_data(),o=this._layout_data();if(this._reacting=!0,t){const t={data:e,layout:o,config:this.model.config,frames:this.model.frames};await window.Plotly.newPlot(this.container,t)}else await window.Plotly.react(this.container,e,o,this.model.config),null!=this.model.frames&&await window.Plotly.addFrames(this.container,this.model.frames);this._updateSetViewportFunction(),this._updateViewportProperty(),this._plotInitialized?(t=>{const e=window.getComputedStyle(t).display;return!e||"none"===e})(this.container)||window.Plotly.Plots.resize(this.container):this._install_callbacks(),this._reacting=!1,this._plotInitialized=!0}_get_trace(t,e){const o=(0,d.clone)(this.model.data[t]),i=this.model.data_sources[t];for(const t of i.columns()){let s=i.get_array(t)[0];null!=s.shape&&s.shape.length>1&&(s=(0,w.reshape)(s,s.shape));const n=t.split("."),r=n[n.length-1];let l=o;for(const t of n.slice(0,-1))l=l[t];e&&1==n.length?l[r]=[s]:l[r]=s}return o}_updateViewportFromProperty(){if(!window.Plotly||this._settingViewport||this._reacting||!this.model.viewport)return;const t=this.container._fullLayout;Object.keys(this.model.viewport).reduce(((e,o)=>{if((0,_.is_equal)((0,w.get)(t,o),e))return!0;{const t=(0,w.deepCopy)(this.model.viewport);return t._update_from_property=!0,this._settingViewport=!0,window.Plotly.relayout(this.el,t).then((()=>{this._settingViewport=!1})),!1}}),{})}_updateViewportProperty(){const t=this.container._fullLayout,e={};for(const o in t){if(!t.hasOwnProperty(o))continue;const i=o.slice(0,5);"xaxis"!==i&&"yaxis"!==i||(e[`${o}.range`]=(0,w.deepCopy)(t[o].range))}(0,_.is_equal)(e,this.model.viewport)||this._setViewport(e)}_updateSetViewportFunction(){"continuous"===this.model.viewport_update_policy||"mouseup"===this.model.viewport_update_policy?this._setViewport=t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)}:this._setViewport=(0,w.throttle)((t=>{this._settingViewport||(this._settingViewport=!0,this.model.viewport=t,this._settingViewport=!1)}),this.model.viewport_update_throttle)}}o.PlotlyPlotView=P,P.__name__="PlotlyPlotView";class f extends y.HTMLBox{constructor(t){super(t)}}o.PlotlyPlot=f,r=f,f.__name__="PlotlyPlot",f.__module__="panel.models.plotly",r.prototype.default_view=P,r.define((({List:t,Any:e,Nullable:o,Float:i,Ref:s,Str:n})=>({data:[t(e),[]],layout:[e,{}],config:[e,{}],frames:[o(t(e)),null],data_sources:[t(s(u.ColumnDataSource)),[]],relayout:[o(e),{}],restyle:[o(e),{}],relayout_data:[e,{}],restyle_data:[t(e),[]],viewport:[e,{}],viewport_update_policy:[n,"mouseup"],viewport_update_throttle:[i,200],_render_count:[i,0]})))},
"3d56c75186": function _(o,t,l,r,e){r(),l.default=".js-plotly-plot .plotly,.js-plotly-plot .plotly div{direction:ltr;font-family:'Open Sans', verdana, arial, sans-serif;margin:0;padding:0;}.js-plotly-plot .plotly input,.js-plotly-plot .plotly button{font-family:'Open Sans', verdana, arial, sans-serif;}.js-plotly-plot .plotly input:focus,.js-plotly-plot .plotly button:focus{outline:none;}.js-plotly-plot .plotly a{text-decoration:none;}.js-plotly-plot .plotly a:hover{text-decoration:none;}.js-plotly-plot .plotly .crisp{shape-rendering:crispEdges;}.js-plotly-plot .plotly .user-select-none{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;-o-user-select:none;user-select:none;}.js-plotly-plot .plotly svg{overflow:hidden;}.js-plotly-plot .plotly svg a{fill:#447adb;}.js-plotly-plot .plotly svg a:hover{fill:#3c6dc5;}.js-plotly-plot .plotly .main-svg{position:absolute;top:0;left:0;pointer-events:none;}.js-plotly-plot .plotly .main-svg .draglayer{pointer-events:all;}.js-plotly-plot .plotly .cursor-default{cursor:default;}.js-plotly-plot .plotly .cursor-pointer{cursor:pointer;}.js-plotly-plot .plotly .cursor-crosshair{cursor:crosshair;}.js-plotly-plot .plotly .cursor-move{cursor:move;}.js-plotly-plot .plotly .cursor-col-resize{cursor:col-resize;}.js-plotly-plot .plotly .cursor-row-resize{cursor:row-resize;}.js-plotly-plot .plotly .cursor-ns-resize{cursor:ns-resize;}.js-plotly-plot .plotly .cursor-ew-resize{cursor:ew-resize;}.js-plotly-plot .plotly .cursor-sw-resize{cursor:sw-resize;}.js-plotly-plot .plotly .cursor-s-resize{cursor:s-resize;}.js-plotly-plot .plotly .cursor-se-resize{cursor:se-resize;}.js-plotly-plot .plotly .cursor-w-resize{cursor:w-resize;}.js-plotly-plot .plotly .cursor-e-resize{cursor:e-resize;}.js-plotly-plot .plotly .cursor-nw-resize{cursor:nw-resize;}.js-plotly-plot .plotly .cursor-n-resize{cursor:n-resize;}.js-plotly-plot .plotly .cursor-ne-resize{cursor:ne-resize;}.js-plotly-plot .plotly .cursor-grab{cursor:-webkit-grab;cursor:grab;}.js-plotly-plot .plotly .modebar{position:absolute;top:2px;right:2px;}.js-plotly-plot .plotly .ease-bg{-webkit-transition:background-color 0.3s ease 0s;-moz-transition:background-color 0.3s ease 0s;-ms-transition:background-color 0.3s ease 0s;-o-transition:background-color 0.3s ease 0s;transition:background-color 0.3s ease 0s;}.js-plotly-plot .plotly .modebar--hover > :not(.watermark){opacity:0;-webkit-transition:opacity 0.3s ease 0s;-moz-transition:opacity 0.3s ease 0s;-ms-transition:opacity 0.3s ease 0s;-o-transition:opacity 0.3s ease 0s;transition:opacity 0.3s ease 0s;}.js-plotly-plot .plotly:hover .modebar--hover .modebar-group{opacity:1;}.js-plotly-plot .plotly .modebar-group{float:left;display:inline-block;box-sizing:border-box;padding-left:8px;position:relative;vertical-align:middle;white-space:nowrap;}.js-plotly-plot .plotly .modebar-btn{fill:var(--plotly-icon-color);background-color:unset;border:none;position:relative;font-size:16px;padding:3px 4px;height:22px;cursor:pointer;line-height:normal;box-sizing:border-box;}.js-plotly-plot .plotly .modebar-btn.active{fill:var(--plotly-active-icon-color);}.js-plotly-plot .plotly .modebar-btn svg{position:relative;top:2px;}.js-plotly-plot .plotly .modebar.vertical{display:flex;flex-direction:column;flex-wrap:wrap;align-content:flex-end;max-height:100%;}.js-plotly-plot .plotly .modebar.vertical svg{top:-1px;}.js-plotly-plot .plotly .modebar.vertical .modebar-group{display:block;float:none;padding-left:0px;padding-bottom:8px;}.js-plotly-plot .plotly .modebar.vertical .modebar-group .modebar-btn{display:block;text-align:center;}.js-plotly-plot .plotly [data-title]{}.js-plotly-plot .plotly [data-title]:before,.js-plotly-plot .plotly [data-title]:after{position:absolute;-webkit-transform:translate3d(0, 0, 0);-moz-transform:translate3d(0, 0, 0);-ms-transform:translate3d(0, 0, 0);-o-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);display:none;opacity:0;z-index:1001;pointer-events:none;top:110%;right:50%;}.js-plotly-plot .plotly [data-title]:hover:before,.js-plotly-plot .plotly [data-title]:hover:after{display:block;opacity:1;}.js-plotly-plot .plotly [data-title]:before{content:'';position:absolute;background:transparent;border:6px solid transparent;z-index:1002;margin-top:-12px;border-bottom-color:#69738a;margin-right:-6px;}.js-plotly-plot .plotly [data-title]:after{content:attr(data-title);background:#69738a;color:white;padding:8px 10px;font-size:12px;line-height:12px;white-space:nowrap;margin-right:-18px;border-radius:2px;}.js-plotly-plot .plotly .vertical [data-title]:before,.js-plotly-plot .plotly .vertical [data-title]:after{top:0%;right:200%;}.js-plotly-plot .plotly .vertical [data-title]:before{border:6px solid transparent;border-left-color:#69738a;margin-top:8px;margin-right:-30px;}.plotly-notifier{font-family:'Open Sans', verdana, arial, sans-serif;position:fixed;top:50px;right:20px;z-index:10000;font-size:10pt;max-width:180px;}.plotly-notifier p{margin:0;}.plotly-notifier .notifier-note{min-width:180px;max-width:250px;border:1px solid #fff;z-index:3000;margin:0;background-color:#8c97af;background-color:rgba(140, 151, 175, 0.9);color:#fff;padding:10px;overflow-wrap:break-word;word-wrap:break-word;-ms-hyphens:auto;-webkit-hyphens:auto;hyphens:auto;}.plotly-notifier .notifier-close{color:#fff;opacity:0.8;float:right;padding:0 5px;background:none;border:none;font-size:20px;font-weight:bold;line-height:20px;}.plotly-notifier .notifier-close:hover{color:#444;text-decoration:none;cursor:pointer;}"},
"b1f4d68596": function _(e,s,t,o,l){var i;o();const r=e("@bokehjs/core/dom"),a=e("9b11ce01a3");class h extends a.HTMLBoxView{connect_signals(){super.connect_signals();const{width:e,height:s,height_policy:t,width_policy:o,sizing_mode:l,active:i,bar_color:r,css_classes:a,value:h,max:n}=this.model.properties;this.on_change([e,s,t,o,l],(()=>this.rerender_())),this.on_change([i,r,a],(()=>this.setCSS())),this.on_change(h,(()=>this.setValue())),this.on_change(n,(()=>this.setMax()))}render(){super.render();const e={...this.model.styles,display:"inline-block"};this.progressEl=document.createElement("progress"),this.setValue(),this.setMax(),this.setCSS();for(const s in e)this.progressEl.style.setProperty(s,e[s]);this.shadow_el.appendChild(this.progressEl)}stylesheets(){const e=super.stylesheets();for(const s of this.model.css)e.push(new r.ImportedStyleSheet(s));return e}setCSS(){let e=`${this.model.css_classes.join(" ")} ${this.model.bar_color}`;this.model.active&&(e=`${e} active`),this.progressEl.className=e}setValue(){null==this.model.value?this.progressEl.value=0:this.model.value>=0?this.progressEl.value=this.model.value:this.model.value<0&&this.progressEl.removeAttribute("value")}setMax(){null!=this.model.max&&(this.progressEl.max=this.model.max)}}t.ProgressView=h,h.__name__="ProgressView";class n extends a.HTMLBox{constructor(e){super(e)}}t.Progress=n,i=n,n.__name__="Progress",n.__module__="panel.models.widgets",i.prototype.default_view=h,i.define((({Any:e,List:s,Bool:t,Float:o,Str:l})=>({active:[t,!0],bar_color:[l,"primary"],css:[s(l),[]],max:[o,100],value:[e,null]})))},
"f6d86c7342": function _(e,t,i,l,o){var s;l();const n=e("@bokehjs/core/dom"),a=e("9b11ce01a3");class d extends a.HTMLBoxView{connect_signals(){super.connect_signals();const{disabled:e,visible:t,text:i,mode:l,toolbar:o,placeholder:s}=this.model.properties;this.on_change(e,(()=>{this.quill.enable(!this.model.disabled)})),this.on_change(t,(()=>{this.model.visible&&(this.container.style.visibility="visible")})),this.on_change(i,(()=>{this._editing||(this._editing=!0,this.quill.enable(!1),this.quill.setContents([]),this.quill.clipboard.dangerouslyPasteHTML(this.model.text),this.quill.enable(!this.model.disabled),this._editing=!1)})),this.on_change(s,(()=>{this.quill.root.setAttribute("data-placeholder",this.model.placeholder)})),this.on_change([l,o],(()=>{this.render(),this._layout_toolbar()}))}_layout_toolbar(){if(null==this._toolbar)this.el.style.removeProperty("padding-top");else{const e=this._toolbar.getBoundingClientRect().height+1;this.el.style.paddingTop=`${e}px`,this._toolbar.style.marginTop=-e+"px"}}render(){super.render(),this.container=(0,n.div)({style:{visibility:"hidden"}}),this.shadow_el.appendChild(this.container);const e="bubble"===this.model.mode?"bubble":"snow";this.watch_stylesheets(),this.quill=new window.Quill(this.container,{modules:{toolbar:this.model.toolbar},readOnly:!0,placeholder:this.model.placeholder,theme:e});const t=!!document.createElement("div").attachShadow({mode:"open"}).getSelection;this.quill.selection.hasFocus=()=>this.quill.root.getRootNode().activeElement===this.quill.root,this.quill.selection.getNativeRange=()=>{const e=(e=>{try{if(t)return e.getSelection().getRangeAt(0);{const t=window.getSelection();return t.getComposedRanges?t.getComposedRanges(e)[0]:t.getRangeAt(0)}}catch{return null}})(this.quill.root.getRootNode());return e?this.quill.selection.normalizeNative(e):null},this.quill.selection.setNativeRange=(e,t,i=void 0,l=void 0,o=!1)=>{if(i=void 0===i?e:i,l=void 0===l?t:l,o=o||!1,null!=e&&(null==this.quill.selection.root.parentNode||null==e.parentNode||null==i.parentNode))return;const s=document.getSelection();if(null!=s)if(null!=e){this.quill.selection.hasFocus()||this.quill.selection.root.focus();const n=(this.quill.selection.getNativeRange()||{}).native;(null==n||o||e!==n.startContainer||t!==n.startOffset||i!==n.endContainer||l!==n.endOffset)&&("BR"==e.tagName&&(t=Array.prototype.indexOf.call(e.parentNode?.childNodes??[],e),e=e.parentNode),"BR"==i.tagName&&(l=Array.prototype.indexOf(i.parentNode?.childNodes??[],i),i=i.parentNode),s.setBaseAndExtent(e,t,i,l))}else s.removeAllRanges(),this.quill.selection.root.blur(),document.body.focus()},this._editor=this.shadow_el.querySelector(".ql-editor"),this._toolbar=this.shadow_el.querySelector(".ql-toolbar");const i=this.quill.clipboard.convert({html:this.model.text});this.quill.setContents(i),this.quill.on("text-change",(()=>{this._editing||(this._editing=!0,this.model.text=this.quill.getSemanticHTML(),this._editing=!1)})),this.model.disabled||this.quill.enable(!this.model.disabled),document.addEventListener("selectionchange",((...e)=>{this.quill.selection.update()}))}style_redraw(){this.model.visible&&(this.container.style.visibility="visible");const e=this.quill.clipboard.convert({html:this.model.text});this.quill.setContents(e),this.invalidate_layout()}after_layout(){super.after_layout(),this._layout_toolbar()}}i.QuillInputView=d,d.__name__="QuillInputView";class h extends a.HTMLBox{constructor(e){super(e)}}i.QuillInput=h,s=h,h.__name__="QuillInput",h.__module__="panel.models.quill",s.prototype.default_view=d,s.define((({Any:e,Str:t})=>({mode:[t,"toolbar"],placeholder:[t,""],text:[t,""],toolbar:[e,null]}))),s.override({height:300})},
"25e2d7c208": function _(t,o,e,i,l){var s;i();const n=t("@bokehjs/models/ui/tooltip"),a=t("@bokehjs/core/build_views"),p=t("@bokehjs/models/widgets/radio_button_group");class u extends p.RadioButtonGroupView{*children(){yield*super.children(),null!=this.tooltip&&(yield this.tooltip)}connect_signals(){super.connect_signals();const{tooltip:t}=this.model.properties;this.on_change(t,(()=>this.update_tooltip()))}async update_tooltip(){null!=this.tooltip&&this.tooltip.remove();const{tooltip:t}=this.model;null!=t&&(this.tooltip=await(0,a.build_view)(t,{parent:this}))}async lazy_initialize(){await super.lazy_initialize();const{tooltip:t}=this.model;null!=t&&(this.tooltip=await(0,a.build_view)(t,{parent:this}))}remove(){this.tooltip?.remove(),super.remove()}render(){super.render();const t=t=>{this.tooltip?.model.setv({visible:t})};let o;this.el.addEventListener("mouseenter",(()=>{o=setTimeout((()=>t(!0)),this.model.tooltip_delay)})),this.el.addEventListener("mouseleave",(()=>{clearTimeout(o),t(!1)}))}}e.RadioButtonGroupView=u,u.__name__="RadioButtonGroupView";class d extends p.RadioButtonGroup{constructor(t){super(t)}}e.RadioButtonGroup=d,s=d,d.__name__="RadioButtonGroup",d.__module__="panel.models.widgets",s.prototype.default_view=u,s.define((({Nullable:t,Ref:o,Float:e})=>({tooltip:[t(o(n.Tooltip)),null],tooltip_delay:[e,500]})))},
"ace9331ee1": function _(e,t,n,r,s){var o;r();const i=e("@bokehjs/core/dom"),a=e("@bokehjs/core/util/types"),d=e("50fda3c782");class l extends i.InlineStyleSheet{constructor(e,t,n=!1,r=""){super(e,t,n),this.persistent=n,this.host_id=r}replace(e,t){e=e.replace(/:host\b/g,`#${this.host_id}`),super.replace(e,t)}prepend(e,t){e=e.replace(/:host\b/g,`#${this.host_id}`),super.prepend(e,t)}append(e,t){e=e.replace(/:host\b/g,`#${this.host_id}`),super.append(e,t)}}n.HostedStyleSheet=l,l.__name__="HostedStyleSheet";class c extends d.ReactiveESMView{constructor(){super(...arguments),this.model_getter=d.model_getter,this.model_setter=d.model_setter,this.react_root=null,this._force_update_callbacks=[]}initialize(){super.initialize(),this.use_shadow_dom||(this.display=new l("","display",!1,this.model.id),this.style=new l("","style",!1,this.model.id),this.parent_style=new l("","parent",!0,this.model.id))}get use_shadow_dom(){return this.model.use_shadow_dom||!(this.parent instanceof c)}render_esm(){if(null!==this.model.compiled&&null!==this.model.render_module){this.model.usesMui&&(this.model.root_node?this.style_cache=document.head:(this.style_cache=document.createElement("head"),this.shadow_el.insertBefore(this.style_cache,this.container))),this.accessed_properties=[];for(const e of this._lifecycle_handlers.keys())(this._lifecycle_handlers.get(e)||[]).splice(0);this.model.disconnect_watchers(this),this.model.render_module.then((e=>{this.react_root=e.default.render(this.model.id)}))}}on_force_update(e){this._force_update_callbacks.push(e)}force_update(){for(const e of this._force_update_callbacks)e()}remove(){if(this._force_update_callbacks=[],this.react_root&&this.use_shadow_dom)super.remove(),this.react_root.then((e=>e.unmount()));else{this._applied_stylesheets.forEach((e=>e.uninstall()));for(const e of this._lifecycle_handlers.get("remove")||[])e();this._child_callbacks.clear(),this._child_rendered.clear(),this._mounted.clear()}}get root_view(){let e=this;if(this.use_shadow_dom)return e;for(;e.parent instanceof c;)e=e.parent;return e}_apply_stylesheets(e){const t=e.map((e=>(0,a.isString)(e)?new i.InlineStyleSheet(e):e)),n=this.root_view.shadow_el.querySelectorAll("style"),r=this.root_view.shadow_el.querySelectorAll("link");t.forEach((e=>{if(!this.use_shadow_dom){if(e instanceof i.InlineStyleSheet&&Array.from(n).some((t=>t.innerHTML===e.css)))return;if(e instanceof i.ImportedStyleSheet&&Array.from(r).some((t=>t.href===e.el.href)))return}this._applied_stylesheets.push(e),e.install(this.root_view.shadow_el)}))}render(){this.react_root&&this.react_root.then((e=>e.unmount())),this._force_update_callbacks=[],super.render()}r_after_render(){super.r_after_render(),this.use_shadow_dom&&this.force_update()}_update_layout(){super._update_layout();const e=this._lifecycle_handlers.get("update_layout")||[];for(const t of e)t()}async update_children(){const e=new Set(await this.build_child_views()),t=this.child_views,n=new Map;for(const t of this.child_views){if(!e.has(t))continue;const r=this._lookup_child(t);r&&(n.has(r)?n.get(r).push(t):n.set(r,[t]))}if(this.use_shadow_dom)for(const e of this._child_rendered.keys())t.includes(e)||(this._child_rendered.delete(e),e.el.remove());for(const e of this.model.children){const t=this._child_callbacks.get(e)||[],r=n.get(e)||[];for(const e of t)e(r)}this._update_children()}_on_mounted(){this.invalidate_layout()}patch_container(e){this.el=this.container=e,this._update_stylesheets(),this.class_list=new i.ClassList(this.container.classList),this._apply_html_attributes()}after_rendered(){const e=this._lifecycle_handlers.get("after_render")||[];for(const t of e)t();if(!this._rendered)for(const e of this._lifecycle_handlers.get("after_layout")||[])e();this._rendered=!0}}n.ReactComponentView=c,c.__name__="ReactComponentView";class h extends d.ReactiveESM{constructor(e){super(e),this.sucrase_transforms=["typescript","jsx"]}get usesMui(){return!!this.importmap?.imports&&Object.keys(this.importmap?.imports).some((e=>e.startsWith("@mui")))}_render_code(){let[e,t]=["",""];const n="url"===this.bundle?this.esm:this.bundle||`${this.class_name}-${this.esm.length}`;this.bundle?t=`\n  const ns = await view._module_cache.get("${n}")\n  const {React, createRoot} = ns.default`:e='\nimport * as React from "react"\nimport { createRoot } from "react-dom/client"';let r="",s="";return this.usesMui&&(this.bundle?t=`\n  const ns = await view._module_cache.get("${n}")\n  const {CacheProvider, React, createCache, createRoot} = ns.default`:e=`\n${e}\nimport createCache from "@emotion/cache"\nimport { CacheProvider } from "@emotion/react"`,r='\n  if (view.use_shadow_dom) {\n    const css_key = id.replace("-", "").replace(/d/g, (digit) => String.fromCharCode(digit.charCodeAt(0) + 49)).toLowerCase()\n    view.mui_cache = createCache({\n      key: \'css-\'+css_key,\n      prepend: true,\n      container: view.style_cache,\n    })\n  }',s="\n  if (rendered && ((view.parent?.react_root === undefined) || view.model.use_shadow_dom)) {\n    rendered = React.createElement(CacheProvider, {value: view.mui_cache}, rendered)\n  }"),`\n${e}\n\nasync function render(id) {\n  const view = Bokeh.index.find_one_by_id(id)\n  if (view == null) {\n    return null\n  }\n\n  ${t}\n\n  class Child extends React.PureComponent {\n\n    state = {rendered: null}\n\n    constructor(props) {\n      super(props)\n      this.render_callback = null\n      this.containerRef = React.createRef()\n    }\n\n    updateElement() {\n      const childView = this.view\n      const el = childView?.el\n      if (el && this.containerRef.current && !this.containerRef.current.contains(el)) {\n        this.containerRef.current.innerHTML = ""\n        this.containerRef.current.appendChild(el)\n      }\n    }\n\n    get view() {\n      const child = this.props.parent.model.data[this.props.name]\n      const model = this.props.id == null ? child : child.find(item => item.id === this.props.id)\n      return this.props.parent.get_child_view(model)\n    }\n\n    get element() {\n      const view = this.view\n      return view == null ? null : view.el\n    }\n\n    get use_shadow_dom() {\n      return this.view?.model.use_shadow_dom || (this.view?.react_root === undefined)\n    }\n\n    componentDidMount() {\n      const view = this.view\n      if (view == null) { return }\n      else if (!this.use_shadow_dom) {\n        view.patch_container(this.containerRef.current)\n        view.model.render_module.then(async (mod) => {\n          this.setState(\n            {rendered: await mod.default.render(view.model.id)},\n            () => {\n              this.props.parent.notify_mount(this.props.name, view.model.id)\n              this.view.r_after_render()\n              this.view.after_rendered()\n            }\n          )\n        })\n        return\n      }\n      this.updateElement()\n      this.props.parent.rerender_(view)\n      this.render_callback = (new_views) => {\n        const view = this.view\n        if (!view) {\n          return\n        }\n        this.updateElement()\n        if (new_views.includes(view)) {\n          this.props.parent.rerender_(view)\n        }\n      }\n      this.props.parent.on_child_render(this.props.name, this.render_callback)\n      this.props.parent.notify_mount(this.props.name, view.model.id)\n    }\n\n    componentWillUnmount() {\n      if (this.render_callback) {\n        this.props.parent.remove_on_child_render(this.props.name, this.render_callback)\n      }\n      if (!this.use_shadow_dom && this.view._mounted.has(this.props.name)) {\n        this.view._mounted.get(this.props.name).delete(this.props.id)\n      }\n    }\n\n    componentDidUpdate() {\n      if (this.use_shadow_dom) {\n        this.updateElement()\n      }\n    }\n\n    render() {\n      const child = this.state.rendered\n      const class_name = (this.use_shadow_dom ?\n        "child-wrapper" : this.view.model.class_name.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase()\n      )\n      return React.createElement('div', {id: this.view?.model.id, className: class_name, ref: this.containerRef}, child)\n    }\n  }\n\n  function react_getter(target, name) {\n    if (name === "useMount") {\n      return (callback) => React.useEffect(() => {\n        target.model_proxy.on('lifecycle:mounted', callback)\n        return () => target.model_proxy.off('lifecycle:mounted', callback)\n      }, [])\n    } if (name == "useState") {\n      return (prop) => {\n        const data_model = target.model.data\n        const propPath = prop.split(".")\n        let targetModel = data_model\n        let resolvedProp = null\n\n        for (let i = 0; i < propPath.length - 1; i++) {\n          if (targetModel && targetModel.properties && propPath[i] in targetModel.properties) {\n            targetModel = targetModel[propPath[i]]\n          } else {\n            // Stop if any part of the path is missing\n            targetModel = null\n            break\n          }\n        }\n        if (targetModel && targetModel.attributes && propPath[propPath.length - 1] in targetModel.attributes) {\n          resolvedProp = propPath[propPath.length - 1]\n        }\n        if (resolvedProp && targetModel) {\n          const [value, setValue] = React.useState(targetModel.attributes[resolvedProp])\n\n          React.useEffect(() => {\n            const cb = () => {\n              if (target.model.events.includes(resolvedProp)) {\n                targetModel.attributes[resolvedProp] && (setValue((v) => v+1) || targetModel.setv({[resolvedProp]: false}))\n              } else {\n                setValue(targetModel.attributes[resolvedProp])\n              }\n            }\n            react_proxy.on(prop, cb, true)\n            return () => react_proxy.off(prop, cb)\n          }, [])\n\n          React.useEffect(() => {\n            if (!target.model.events.includes(resolvedProp)) {\n              targetModel.setv({ [resolvedProp]: value })\n            }\n          }, [value])\n\n          return [value, setValue]\n        }\n        throw ReferenceError("Could not resolve " + prop + " on " + target.model.class_name)\n      }\n    } else if (name === "get_child") {\n      return (child) => {\n        const data_model = target.model.data\n        const value = data_model.attributes[child]\n        if (Array.isArray(value)) {\n          const [children_state, set_children] = React.useState(value.map((model) =>\n            React.createElement(Child, { parent: target, name: child, key: model.id, id: model.id })\n          ))\n          React.useEffect(() => {\n            target.on_child_render(child, () => {\n              const current_models = data_model.attributes[child]\n              const previous_models = children_state.map(child => child.props.index)\n              if (current_models.some((model, i) => model.id !== previous_models[i])) {\n                set_children(current_models.map((model, i) => (\n                  React.createElement(Child, { parent: target, name: child, key: model.id, id: model.id })\n                )))\n              }\n            })\n          }, [])\n          return children_state\n        } else {\n          return React.createElement(Child, {parent: target, name: child})\n        }\n      }\n    }\n    return target.model_getter(target, name)\n  }\n\n  const react_proxy = new Proxy(view, {\n    get: react_getter,\n    set: view.model_setter\n  })\n\n  class ErrorBoundary extends React.Component {\n  constructor(props) {\n    super(props)\n    // initialize the error state\n    this.state = { hasError: false }\n  }\n\n  // if an error happened, set the state to true\n  static getDerivedStateFromError(error) {\n    return { hasError: true }\n  }\n\n  componentDidCatch(error) {\n    this.props.view.render_error(error)\n  }\n\n  render() {\n    if (this.state.hasError) {\n      return React.createElement('div')\n    }\n    return React.createElement('div', {className: "error-wrapper"}, this.props.children)\n  }\n  }\n\n  class Component extends React.Component {\n\n    constructor(props) {\n      super(props)\n      ${r}\n    }\n\n    componentDidMount() {\n      if (!this.props.view.use_shadow_dom) { return }\n      this.props.view.on_force_update(() => {\n        ${r}\n        this.forceUpdate()\n      })\n      this.props.view._changing = false\n      this.props.view.after_rendered()\n    }\n\n    render() {\n      let rendered = React.createElement(this.props.view.render_fn, this.props)\n      if (this.props.view.model.dev) {\n        rendered = React.createElement(ErrorBoundary, {view}, rendered)\n      }\n      ${s}\n      return rendered\n    }\n  }\n\n  const props = {view, model: react_proxy, data: view.model.data, el: view.container}\n  const rendered = React.createElement(Component, props)\n  if (!view.model.use_shadow_dom && (view.parent?.react_root !== undefined)) {\n    return rendered\n  }\n  if (rendered) {\n    view._changing = true\n    let container\n    if (view.model.root_node) {\n      container = document.querySelector(view.model.root_node)\n      if (container == null) {\n        container = document.createElement("div")\n        container.id = view.model.root_node.replace("#", "")\n        document.body.append(container)\n      }\n    } else {\n      container = view.container\n    }\n    const root = createRoot(container)\n    try {\n      root.render(rendered)\n    } catch(e) {\n      view.render_error(e)\n    }\n    return root\n  }\n}\n\nexport default {render}`}compile(){const e=super.compile();return this.bundle?e:null!==e&&e.includes("React")?`\nimport * as React from "react"\n\n${e}`:e}get _render_cache_key(){const e="url"===this.bundle?this.esm:this.bundle||`${this.class_name}-${this.esm.length}`;return`react-${this.usesMui}-${e}`}}n.ReactComponent=h,o=h,h.__name__="ReactComponent",h.__module__="panel.models.esm",o.prototype.default_view=c,o.define((({Bool:e,Nullable:t,Str:n})=>({root_node:[t(n),null],use_shadow_dom:[e,!0]})))},
"d5752cda5a": function _(e,t,n,s,i){var o;s();const r=e("bb986b9dd6"),l=e("0e62f95470"),c=e("b3f51db71c"),a=e("@bokehjs/core/dom"),d=e("@bokehjs/core/util/assert"),_=e("@bokehjs/core/util/iterator"),h=e("@bokehjs/core/util/types"),u=e("@bokehjs/core/util/object"),f=e("@bokehjs/model"),p=e("@bokehjs/models/ui/ui_element"),m=e("be689f0377"),v=e("a572dba9cd"),$=e("4c04683fdc"),g=e("9b11ce01a3"),b=e("a3669a897a");function w(e,t,n){const s=new Map;for(const e of n)s.set(`{${e}}`,"(.*)");const i=[];let o=`^${r=e,r.replace(/[-\/\\^$*+?.()|[\]]/g,"\\$&")}$`;var r;let l,c,a;for(const[t,n]of s)if(c=e.indexOf(t),c>-1){for(o=o.replace(t,n),a={index:c,token:t},l=0;l<i.length&&i[l].index<c;l++);l<i.length?i.splice(l,0,a):i.push(a)}o=o.replace(/\{[^{}]+\}/g,".*");const d=new RegExp(o).exec(t);if(null!=d){const e={};for(l=0;l<i.length;l++)e[i[l].token.slice(1,-1)]=d[l+1];return e}return null}function y(e,t){let n=e.getElementById(t);return null==n&&(n=document.getElementById(t)),n}class M extends g.HTMLBoxView{constructor(){super(...arguments),this._changing=!1,this._event_listeners=new Map,this._mutation_observers=[],this._script_fns=new Map,this._state={}}initialize(){super.initialize(),this.html=(0,$.html_decode)(this.model.html)??this.model.html}_recursive_connect(e,t,n){for(const s of e){const e=0!=n.length?`${n}.${s.attr}`:s.attr,i=s.get_value();null!=i&&(i instanceof f.Model&&this._recursive_connect(i,!0,e),this.on_change(s,(()=>{if(t)for(const[e,t]of(0,u.entries)(this.model.children))if(t==s.attr){let t=s.get_value();return(0,h.isArray)(t)||(t=[t]),void this._render_node(e,t)}this._changing||this._update(e)})))}}connect_signals(){super.connect_signals();const{children:e,events:t}=this.model.properties;this.on_change(e,(async()=>{this.html=(0,$.html_decode)(this.model.html)??this.model.html,await this.build_child_views(),this.invalidate_render()})),this._recursive_connect(this.model.data,!0,""),this.on_change(t,(()=>{this._remove_event_listeners(),this._setup_event_listeners()})),this.connect_scripts()}connect_scripts(){const{id:e}=this.model.data;for(const[t,n]of(0,u.entries)(this.model.scripts)){let s,i=this.model.data;if(t.includes(".")){const e=t.split(".");s=e[e.length-1];for(const t of e.slice(0,-1)){const e=i.property(t).get_value();(0,d.assert)(e instanceof f.Model),i=e}}else s=t;for(const o of n){const n=(0,$.html_decode)(o)??o,r=this._render_script(n,e);if(this._script_fns.set(t,r),!(s in i.properties))continue;const l=i.property(s),c=this.model.event_params.includes(t);this.on_change(l,(()=>{this._changing||c&&!i.property(t).get_value()||(this.run_script(t),c&&i.setv({[t]:!1}))}))}}}run_script(e,t=!1){const n=this._script_fns.get(e);if(void 0===n)return void(t||console.warn(`Script '${e}' could not be found.`));const s={get_records(e,t){return this.get_records(e,t)}};for(const e of this._script_fns.keys())s[e]=()=>this.run_script(e);return n(this.model,this.model.data,this._state,this,(e=>this.run_script(e)),s)}get_records(e,t=!0){return(0,m.dict_to_records)(this.model.data.property(e),t)}disconnect_signals(){super.disconnect_signals(),this._remove_event_listeners(),this._remove_mutation_observers()}remove(){this.run_script("remove",!0),super.remove()}get child_models(){const e=[];for(const[t,n]of(0,u.entries)(this.model.children))for(const t of n)(0,h.isString)(t)||e.push(t);return e}_after_layout(){this.run_script("after_layout",!0)}render(){this.empty(),this._update_stylesheets(),this._update_css_classes(),this._apply_styles(),this._apply_visible(),this.container=(0,a.div)({style:{display:"contents"}}),this.shadow_el.append(this.container),this._update(),this._render_children(),this._setup_mutation_observers(),this._setup_event_listeners(),this.run_script("render",!0)}_send_event(e,t,n){const s=(0,b.convertUndefined)((0,v.serializeEvent)(n));s.type=t,this.model.trigger_event(new $.DOMEvent(e,s))}_render_child(e,t){if((0,h.isString)(e))t.innerHTML=(0,$.html_decode)(e)??e;else{const n=this._child_views.get(e);null==n?t.innerHTML="":(t.appendChild(n.el),n.render(),n.r_after_render())}}_render_node(e,t){const{id:n}=this.model.data;if(this.model.looped.includes(e))for(const[s,i]of(0,_.enumerate)(t)){const t=`${e}-${i}-${n}`,o=y(this.shadow_el,t);null!=o?this._render_child(s,o):console.warn(`DOM node '${t}' could not be found. Cannot render children.`)}else{const s=`${e}-${n}`,i=y(this.shadow_el,s);if(null==i)return void console.warn(`DOM node '${s}' could not be found. Cannot render children.`);for(const e of t)this._render_child(e,i)}}_render_children(){for(const[e,t]of(0,u.entries)(this.model.children)){const n=(()=>{if(!(0,h.isString)(t))return t;{const e=this.model.data.property(t).get_value();if((0,h.isString)(e))return[e];if((0,h.isArray)(e))return e;(0,d.unreachable)()}})();this._render_node(e,n)}}_render_html(e,t={}){let n=e.replace(/[`]/g,"\\$&"),s="";const i=[];for(const[e,t]of(0,u.entries)(this.model.callbacks))for(const[o,r]of t){let t;if(n=n.replaceAll(`\${${r}}`,`$--{${r}}`),r.startsWith("script(")){const e=r.replace("('","_").replace("')","").replace('("',"_").replace('")',"").replace("-","_"),s=e.replaceAll("script_","");n=n.replaceAll(r,e),t=`\n          const ${e} = (event) => {\n            view._state.event = event\n            view.run_script("${s}")\n            delete view._state.event\n          }\n          `}else t=`\n          const ${r} = (event) => {\n            let elname = "${e}"\n            if (RegExp("{{.*loop.index.*}}").test(elname)) {\n              const pattern = RegExp(elname.replace(/{{(.+?)}}/g, String.fromCharCode(92) + "d+"))\n              for (const p of event.path) {\n                if (pattern.exec(p.id) != null) {\n                  elname = p.id.split("-").slice(null, -1).join("-")\n                  break\n                }\n              }\n            }\n            view._send_event(elname, "${o}", event)\n          }\n          `;i.indexOf(r)>-1||(i.push(r),s+=t)}return n=n.replaceAll("${model.","$-{model.").replaceAll("${","${data.").replaceAll("$-{model.","${model.").replaceAll("$--{","${"),new Function("view, model, data, state, html, useCallback",`${s}return html\`${n}\`;`)(this,this.model,this.model.data,t,c.html,l.useCallback)}_render_script(e,t){const n=[];for(const s of this.model.nodes){const i=s.replace("-","_");if(!e.includes(i))continue;const o=`\n      let ${i} = view.shadow_el.getElementById('${s}-${t}')\n      if (${i} == null) {\n        ${i} = document.getElementById('${s}-${t}')\n      }\n      if (${i} == null) {\n        console.warn("DOM node '${s}' could not be found. Cannot execute callback.")\n        return\n      }\n      `;n.push(o)}return n.push("\n    let event = null\n    if (state.event !== undefined) {\n      event = state.event\n    }\n    "),n.push(e),new Function("model, data, state, view, script, self",n.join("\n"))}_remove_mutation_observers(){for(const e of this._mutation_observers)e.disconnect();this._mutation_observers=[]}_setup_mutation_observers(){const{id:e}=this.model.data;for(const t of(0,u.keys)(this.model.attrs)){const n=y(this.shadow_el,`${t}-${e}`);if(null==n){console.warn(`DOM node '${t}-${e}' could not be found. Cannot set up MutationObserver.`);continue}const s=new MutationObserver((()=>{this._update_model(n,t)}));s.observe(n,{attributes:!0}),this._mutation_observers.push(s)}}_remove_event_listeners(){const{id:e}=this.model.data;for(const[t,n]of this._event_listeners){const s=y(this.shadow_el,`${t}-${e}`);if(null!=s)for(const[e,t]of n)s.removeEventListener(e,t)}this._event_listeners.clear()}_setup_event_listeners(){const{id:e}=this.model.data,t=(0,u.dict)(this.model.attrs);for(const[n,s]of(0,u.entries)(this.model.events)){const i=y(this.shadow_el,`${n}-${e}`);if(null!=i)for(const[e,o]of(0,u.entries)(s)){const s=s=>{this._send_event(n,e,s),t.has(n)&&o&&this._update_model(i,n)};i.addEventListener(e,s);let r=this._event_listeners.get(n);void 0===r&&this._event_listeners.set(n,r=new Map),r.set(e,s)}else console.warn(`DOM node '${n}-${e}' could not be found. Cannot subscribe to DOM events.`)}}_update(e=null){if(null==e||this.html.includes(`\${${e}}`)){const e=this._render_html(this.html);if(null==e)return;try{this._changing=!0,(0,r.render)(e,this.container)}finally{this._changing=!1}}}_update_model(e,t){if(this._changing)return;const n=(0,u.dict)(this.model.attrs).get(t)??[],s={};for(const i of n){const[n,o,r]=i;let l="children"==n?e.innerHTML:e[n];if(1===o.length&&`{${o[0]}}`===r)s[o[0]]=l;else if((0,h.isString)(l))if(l=w(r,l,o),null==l)console.warn(`Could not resolve parameters in ${t} element ${n} attribute value ${l}.`);else for(const[e,i]of(0,u.entries)(l))void 0===i?console.warn(`Could not resolve ${e} in ${t} element ${n} attribute value ${l}.`):s[e]=i}try{this._changing=!0,this.model.data.setv(function(e){const t={};for(const[n,s]of(0,u.entries)(e)){const e=(()=>{if((0,h.isString)(s)){if(!(""===s||"NaN"!==s&&isNaN(Number(s))))return Number(s);if("false"===s||"true"===s)return"true"===s}return s})();t[n]=e}return t}(s))}catch{console.error("Could not serialize",s)}finally{this._changing=!1}}}n.ReactiveHTMLView=M,M.__name__="ReactiveHTMLView";class k extends g.HTMLBox{constructor(e){super(e)}}n.ReactiveHTML=k,o=k,k.__name__="ReactiveHTML",k.__module__="panel.models.reactive_html",o.prototype.default_view=M,o.define((({Bool:e,Str:t,List:n,Dict:s,Tuple:i,Or:o,Ref:r})=>({attrs:[s(n(i(t,n(t),t))),{}],callbacks:[s(n(i(t,t))),{}],children:[s(o(n(o(r(p.UIElement),t)),t)),{}],data:[r(f.Model)],event_params:[n(t),[]],events:[s(s(e)),{}],html:[t,""],looped:[n(t),[]],nodes:[n(t),[]],scripts:[s(n(t)),{}]})))},
"bb986b9dd6": function _(e,n,t,_,l){_(),t.Component=S,t.Fragment=P,t.cloneElement=function(e,n,t){var _,l,r,u,i=k({},e.props);for(r in e.type&&e.type.defaultProps&&(u=e.type.defaultProps),n)"key"==r?_=n[r]:"ref"==r?l=n[r]:i[r]=null==n[r]&&null!=u?u[r]:n[r];return arguments.length>2&&(i.children=arguments.length>3?o.call(arguments,2):t),C(e.type,i,_||e.key,l||e.ref,null)},t.createContext=function(e){function n(e){var t,_;return this.getChildContext||(t=new Set,(_={})[n.__c]=this,this.getChildContext=function(){return _},this.componentWillUnmount=function(){t=null},this.shouldComponentUpdate=function(e){this.props.value!=e.value&&t.forEach((function(e){e.__e=!0,E(e)}))},this.sub=function(e){t.add(e);var n=e.componentWillUnmount;e.componentWillUnmount=function(){t&&t.delete(e),n&&n.call(e)}}),e.children}return n.__c="__cC"+y++,n.__=e,n.Provider=n.__l=(n.Consumer=function(e,n){return e.children(n)}).contextType=n,n},t.createElement=x,t.h=x,t.createRef=function(){return{current:null}},t.hydrate=function e(n,t){z(n,t,e)},t.render=z,t.toChildArray=function e(n,t){return t=t||[],null==n||"boolean"==typeof n||(b(n)?n.some((function(n){e(n,t)})):t.push(n)),t};var o,r,u,i,c,s,f,p,a,h,d,y,v={},m=[],g=/acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i,b=Array.isArray;function k(e,n){for(var t in n)e[t]=n[t];return e}function w(e){e&&e.parentNode&&e.parentNode.removeChild(e)}function x(e,n,t){var _,l,r,u={};for(r in n)"key"==r?_=n[r]:"ref"==r?l=n[r]:u[r]=n[r];if(arguments.length>2&&(u.children=arguments.length>3?o.call(arguments,2):t),"function"==typeof e&&null!=e.defaultProps)for(r in e.defaultProps)null==u[r]&&(u[r]=e.defaultProps[r]);return C(e,u,_,l,null)}function C(e,n,t,_,l){var o={type:e,props:n,key:t,ref:_,__k:null,__:null,__b:0,__e:null,__c:null,constructor:void 0,__v:l??++u,__i:-1,__u:0};return null==l&&null!=r.vnode&&r.vnode(o),o}function P(e){return e.children}function S(e,n){this.props=e,this.context=n}function U(e,n){if(null==n)return e.__?U(e.__,e.__i+1):null;for(var t;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e)return t.__e;return"function"==typeof e.type?U(e):null}function T(e){var n,t;if(null!=(e=e.__)&&null!=e.__c){for(e.__e=e.__c.base=null,n=0;n<e.__k.length;n++)if(null!=(t=e.__k[n])&&null!=t.__e){e.__e=e.__c.base=t.__e;break}return T(e)}}function E(e){(!e.__d&&(e.__d=!0)&&i.push(e)&&!D.__r++||c!=r.debounceRendering)&&((c=r.debounceRendering)||s)(D)}function D(){for(var e,n,t,_,l,o,u,c=1;i.length;)i.length>c&&i.sort(f),e=i.shift(),c=i.length,e.__d&&(t=void 0,l=(_=(n=e).__v).__e,o=[],u=[],n.__P&&((t=k({},_)).__v=_.__v+1,r.vnode&&r.vnode(t),H(n.__P,t,_,n.__n,n.__P.namespaceURI,32&_.__u?[l]:null,o,l??U(_),!!(32&_.__u),u),t.__v=_.__v,t.__.__k[t.__i]=t,I(o,t,u),t.__e!=l&&T(t)));D.__r=0}function M(e,n,t,_,l,o,r,u,i,c,s){var f,p,a,h,d,y,g=_&&_.__k||m,b=n.length;for(i=W(t,n,g,i,b),f=0;f<b;f++)null!=(a=t.__k[f])&&(p=-1==a.__i?v:g[a.__i]||v,a.__i=f,y=H(e,a,p,l,o,r,u,i,c,s),h=a.__e,a.ref&&p.ref!=a.ref&&(p.ref&&O(p.ref,null,a),s.push(a.ref,a.__c||h,a)),null==d&&null!=h&&(d=h),4&a.__u||p.__k===a.__k?i=L(a,i,e):"function"==typeof a.type&&void 0!==y?i=y:h&&(i=h.nextSibling),a.__u&=-7);return t.__e=d,i}function W(e,n,t,_,l){var o,r,u,i,c,s=t.length,f=s,p=0;for(e.__k=new Array(l),o=0;o<l;o++)null!=(r=n[o])&&"boolean"!=typeof r&&"function"!=typeof r?(i=o+p,(r=e.__k[o]="string"==typeof r||"number"==typeof r||"bigint"==typeof r||r.constructor==String?C(null,r,null,null,null):b(r)?C(P,{children:r},null,null,null):null==r.constructor&&r.__b>0?C(r.type,r.props,r.key,r.ref?r.ref:null,r.__v):r).__=e,r.__b=e.__b+1,u=null,-1!=(c=r.__i=F(r,t,i,f))&&(f--,(u=t[c])&&(u.__u|=2)),null==u||null==u.__v?(-1==c&&(l>s?p--:l<s&&p++),"function"!=typeof r.type&&(r.__u|=4)):c!=i&&(c==i-1?p--:c==i+1?p++:(c>i?p--:p++,r.__u|=4))):e.__k[o]=null;if(f)for(o=0;o<s;o++)null!=(u=t[o])&&!(2&u.__u)&&(u.__e==_&&(_=U(u)),j(u,u));return _}function L(e,n,t){var _,l;if("function"==typeof e.type){for(_=e.__k,l=0;_&&l<_.length;l++)_[l]&&(_[l].__=e,n=L(_[l],n,t));return n}e.__e!=n&&(n&&e.type&&!t.contains(n)&&(n=U(e)),t.insertBefore(e.__e,n||null),n=e.__e);do{n=n&&n.nextSibling}while(null!=n&&8==n.nodeType);return n}function F(e,n,t,_){var l,o,r=e.key,u=e.type,i=n[t];if(null===i&&null==e.key||i&&r==i.key&&u==i.type&&!(2&i.__u))return t;if(_>(null==i||2&i.__u?0:1))for(l=t-1,o=t+1;l>=0||o<n.length;){if(l>=0){if((i=n[l])&&!(2&i.__u)&&r==i.key&&u==i.type)return l;l--}if(o<n.length){if((i=n[o])&&!(2&i.__u)&&r==i.key&&u==i.type)return o;o++}}return-1}function A(e,n,t){"-"==n[0]?e.setProperty(n,t??""):e[n]=null==t?"":"number"!=typeof t||g.test(n)?t:t+"px"}function N(e,n,t,_,l){var o;e:if("style"==n)if("string"==typeof t)e.style.cssText=t;else{if("string"==typeof _&&(e.style.cssText=_=""),_)for(n in _)t&&n in t||A(e.style,n,"");if(t)for(n in t)_&&t[n]==_[n]||A(e.style,n,t[n])}else if("o"==n[0]&&"n"==n[1])o=n!=(n=n.replace(p,"$1")),n=n.toLowerCase()in e||"onFocusOut"==n||"onFocusIn"==n?n.toLowerCase().slice(2):n.slice(2),e.l||(e.l={}),e.l[n+o]=t,t?_?t.u=_.u:(t.u=a,e.addEventListener(n,o?d:h,o)):e.removeEventListener(n,o?d:h,o);else{if("http://www.w3.org/2000/svg"==l)n=n.replace(/xlink(H|:h)/,"h").replace(/sName$/,"s");else if("width"!=n&&"height"!=n&&"href"!=n&&"list"!=n&&"form"!=n&&"tabIndex"!=n&&"download"!=n&&"rowSpan"!=n&&"colSpan"!=n&&"role"!=n&&"popover"!=n&&n in e)try{e[n]=t??"";break e}catch(e){}"function"==typeof t||(null==t||!1===t&&"-"!=n[4]?e.removeAttribute(n):e.setAttribute(n,"popover"==n&&1==t?"":t))}}function R(e){return function(n){if(this.l){var t=this.l[n.type+e];if(null==n.t)n.t=a++;else if(n.t<t.u)return;return t(r.event?r.event(n):n)}}}function H(e,n,t,_,l,o,u,i,c,s){var f,p,a,h,d,y,v,m,g,x,C,U,T,E,D,W,L,F=n.type;if(null!=n.constructor)return null;128&t.__u&&(c=!!(32&t.__u),o=[i=n.__e=t.__e]),(f=r.__b)&&f(n);e:if("function"==typeof F)try{if(m=n.props,g="prototype"in F&&F.prototype.render,x=(f=F.contextType)&&_[f.__c],C=f?x?x.props.value:f.__:_,t.__c?v=(p=n.__c=t.__c).__=p.__E:(g?n.__c=p=new F(m,C):(n.__c=p=new S(m,C),p.constructor=F,p.render=V),x&&x.sub(p),p.props=m,p.state||(p.state={}),p.context=C,p.__n=_,a=p.__d=!0,p.__h=[],p._sb=[]),g&&null==p.__s&&(p.__s=p.state),g&&null!=F.getDerivedStateFromProps&&(p.__s==p.state&&(p.__s=k({},p.__s)),k(p.__s,F.getDerivedStateFromProps(m,p.__s))),h=p.props,d=p.state,p.__v=n,a)g&&null==F.getDerivedStateFromProps&&null!=p.componentWillMount&&p.componentWillMount(),g&&null!=p.componentDidMount&&p.__h.push(p.componentDidMount);else{if(g&&null==F.getDerivedStateFromProps&&m!==h&&null!=p.componentWillReceiveProps&&p.componentWillReceiveProps(m,C),!p.__e&&null!=p.shouldComponentUpdate&&!1===p.shouldComponentUpdate(m,p.__s,C)||n.__v==t.__v){for(n.__v!=t.__v&&(p.props=m,p.state=p.__s,p.__d=!1),n.__e=t.__e,n.__k=t.__k,n.__k.some((function(e){e&&(e.__=n)})),U=0;U<p._sb.length;U++)p.__h.push(p._sb[U]);p._sb=[],p.__h.length&&u.push(p);break e}null!=p.componentWillUpdate&&p.componentWillUpdate(m,p.__s,C),g&&null!=p.componentDidUpdate&&p.__h.push((function(){p.componentDidUpdate(h,d,y)}))}if(p.context=C,p.props=m,p.__P=e,p.__e=!1,T=r.__r,E=0,g){for(p.state=p.__s,p.__d=!1,T&&T(n),f=p.render(p.props,p.state,p.context),D=0;D<p._sb.length;D++)p.__h.push(p._sb[D]);p._sb=[]}else do{p.__d=!1,T&&T(n),f=p.render(p.props,p.state,p.context),p.state=p.__s}while(p.__d&&++E<25);p.state=p.__s,null!=p.getChildContext&&(_=k(k({},_),p.getChildContext())),g&&!a&&null!=p.getSnapshotBeforeUpdate&&(y=p.getSnapshotBeforeUpdate(h,d)),W=f,null!=f&&f.type===P&&null==f.key&&(W=$(f.props.children)),i=M(e,b(W)?W:[W],n,t,_,l,o,u,i,c,s),p.base=n.__e,n.__u&=-161,p.__h.length&&u.push(p),v&&(p.__E=p.__=null)}catch(e){if(n.__v=null,c||null!=o)if(e.then){for(n.__u|=c?160:128;i&&8==i.nodeType&&i.nextSibling;)i=i.nextSibling;o[o.indexOf(i)]=null,n.__e=i}else for(L=o.length;L--;)w(o[L]);else n.__e=t.__e,n.__k=t.__k;r.__e(e,n,t)}else null==o&&n.__v==t.__v?(n.__k=t.__k,n.__e=t.__e):i=n.__e=B(t.__e,n,t,_,l,o,u,c,s);return(f=r.diffed)&&f(n),128&n.__u?void 0:i}function I(e,n,t){for(var _=0;_<t.length;_++)O(t[_],t[++_],t[++_]);r.__c&&r.__c(n,e),e.some((function(n){try{e=n.__h,n.__h=[],e.some((function(e){e.call(n)}))}catch(e){r.__e(e,n.__v)}}))}function $(e){return"object"!=typeof e||null==e||e.__b&&e.__b>0?e:b(e)?e.map($):k({},e)}function B(e,n,t,_,l,u,i,c,s){var f,p,a,h,d,y,m,g=t.props,k=n.props,x=n.type;if("svg"==x?l="http://www.w3.org/2000/svg":"math"==x?l="http://www.w3.org/1998/Math/MathML":l||(l="http://www.w3.org/1999/xhtml"),null!=u)for(f=0;f<u.length;f++)if((d=u[f])&&"setAttribute"in d==!!x&&(x?d.localName==x:3==d.nodeType)){e=d,u[f]=null;break}if(null==e){if(null==x)return document.createTextNode(k);e=document.createElementNS(l,x,k.is&&k),c&&(r.__m&&r.__m(n,u),c=!1),u=null}if(null==x)g===k||c&&e.data==k||(e.data=k);else{if(u=u&&o.call(e.childNodes),g=t.props||v,!c&&null!=u)for(g={},f=0;f<e.attributes.length;f++)g[(d=e.attributes[f]).name]=d.value;for(f in g)if(d=g[f],"children"==f);else if("dangerouslySetInnerHTML"==f)a=d;else if(!(f in k)){if("value"==f&&"defaultValue"in k||"checked"==f&&"defaultChecked"in k)continue;N(e,f,null,d,l)}for(f in k)d=k[f],"children"==f?h=d:"dangerouslySetInnerHTML"==f?p=d:"value"==f?y=d:"checked"==f?m=d:c&&"function"!=typeof d||g[f]===d||N(e,f,d,g[f],l);if(p)c||a&&(p.__html==a.__html||p.__html==e.innerHTML)||(e.innerHTML=p.__html),n.__k=[];else if(a&&(e.innerHTML=""),M("template"==n.type?e.content:e,b(h)?h:[h],n,t,_,"foreignObject"==x?"http://www.w3.org/1999/xhtml":l,u,i,u?u[0]:t.__k&&U(t,0),c,s),null!=u)for(f=u.length;f--;)w(u[f]);c||(f="value","progress"==x&&null==y?e.removeAttribute("value"):null!=y&&(y!==e[f]||"progress"==x&&!y||"option"==x&&y!=g[f])&&N(e,f,y,g[f],l),f="checked",null!=m&&m!=e[f]&&N(e,f,m,g[f],l))}return e}function O(e,n,t){try{if("function"==typeof e){var _="function"==typeof e.__u;_&&e.__u(),_&&null==n||(e.__u=e(n))}else e.current=n}catch(e){r.__e(e,t)}}function j(e,n,t){var _,l;if(r.unmount&&r.unmount(e),(_=e.ref)&&(_.current&&_.current!=e.__e||O(_,null,n)),null!=(_=e.__c)){if(_.componentWillUnmount)try{_.componentWillUnmount()}catch(e){r.__e(e,n)}_.base=_.__P=null}if(_=e.__k)for(l=0;l<_.length;l++)_[l]&&j(_[l],n,t||"function"!=typeof e.type);t||w(e.__e),e.__c=e.__=e.__e=void 0}function V(e,n,t){return this.constructor(e,t)}function z(e,n,t){var _,l,u,i;n==document&&(n=document.documentElement),r.__&&r.__(e,n),l=(_="function"==typeof t)?null:t&&t.__k||n.__k,u=[],i=[],H(n,e=(!_&&t||n).__k=x(P,null,[e]),l||v,v,n.namespaceURI,!_&&t?[t]:l?null:n.firstChild?o.call(n.childNodes):null,u,!_&&t?t:l?l.__e:n.firstChild,_,i),I(u,e,i)}o=m.slice,t.options=r={__e:function(e,n,t,_){for(var l,o,r;n=n.__;)if((l=n.__c)&&!l.__)try{if((o=l.constructor)&&null!=o.getDerivedStateFromError&&(l.setState(o.getDerivedStateFromError(e)),r=l.__d),null!=l.componentDidCatch&&(l.componentDidCatch(e,_||{}),r=l.__d),r)return l.__E=l}catch(n){e=n}throw e}},u=0,t.isValidElement=function(e){return null!=e&&null==e.constructor},S.prototype.setState=function(e,n){var t;t=null!=this.__s&&this.__s!=this.state?this.__s:this.__s=k({},this.state),"function"==typeof e&&(e=e(k({},t),this.props)),e&&k(t,e),null!=e&&this.__v&&(n&&this._sb.push(n),E(this))},S.prototype.forceUpdate=function(e){this.__v&&(this.__e=!0,e&&this.__h.push(e),E(this))},S.prototype.render=P,i=[],s="function"==typeof Promise?Promise.prototype.then.bind(Promise.resolve()):setTimeout,f=function(e,n){return e.__v.__b-n.__v.__b},D.__r=0,p=/(PointerCapture)$|Capture$/i,a=0,h=R(!1),d=R(!0),y=0},
"0e62f95470": function _(_,n,t,u,r){u(),t.useCallback=function(_,n){return a=8,g((function(){return _}),n)},t.useContext=function(_){var n=c.context[_.__c],t=E(e++,9);return t.c=_,n?(null==t.__&&(t.__=!0,n.sub(c)),n.props.value):_.__},t.useDebugValue=function(_,n){l.useDebugValue&&l.useDebugValue(n?n(_):_)},t.useEffect=function(_,n){var t=E(e++,3);!l.__s&&q(t.__H,n)&&(t.__=_,t.u=n,c.__H.__h.push(t))},t.useErrorBoundary=function(_){var n=E(e++,10),t=y();return n.__=_,c.componentDidCatch||(c.componentDidCatch=function(_,u){n.__&&n.__(_,u),t[1](_)}),[t[0],function(){t[1](void 0)}]},t.useId=function(){var _=E(e++,11);if(!_.__){for(var n=c.__v;null!==n&&!n.__m&&null!==n.__;)n=n.__;var t=n.__m||(n.__m=[0,0]);_.__="P"+t[0]+"-"+t[1]++}return _.__},t.useImperativeHandle=function(_,n,t){a=6,b((function(){if("function"==typeof _){var t=_(n());return function(){_(null),t&&"function"==typeof t&&t()}}if(_)return _.current=n(),function(){return _.current=null}}),null==t?t:t.concat(_))},t.useLayoutEffect=b,t.useMemo=g,t.useReducer=N,t.useRef=function(_){return a=5,g((function(){return{current:_}}),[])},t.useState=y;const o=_("bb986b9dd6");var e,c,i,f,a=0,h=[],l=o.options,s=l.__b,v=l.__r,m=l.diffed,d=l.__c,p=l.unmount,H=l.__;function E(_,n){l.__h&&l.__h(c,_,a||n),a=0;var t=c.__H||(c.__H={__:[],__h:[]});return _>=t.__.length&&t.__.push({}),t.__[_]}function y(_){return a=1,N(U,_)}function N(_,n,t){var u=E(e++,2);if(u.t=_,!u.__c&&(u.__=[t?t(n):U(void 0,n),function(_){var n=u.__N?u.__N[0]:u.__[0],t=u.t(n,_);n!==t&&(u.__N=[t,u.__[1]],u.__c.setState({}))}],u.__c=c,!c.__f)){var r=function(_,n,t){if(!u.__c.__H)return!0;var r=u.__c.__H.__.filter((function(_){return!!_.__c}));if(r.every((function(_){return!_.__N})))return!o||o.call(this,_,n,t);var e=u.__c.props!==_;return r.forEach((function(_){if(_.__N){var n=_.__[0];_.__=_.__N,_.__N=void 0,n!==_.__[0]&&(e=!0)}})),o&&o.call(this,_,n,t)||e};c.__f=!0;var o=c.shouldComponentUpdate,i=c.componentWillUpdate;c.componentWillUpdate=function(_,n,t){if(this.__e){var u=o;o=void 0,r(_,n,t),o=u}i&&i.call(this,_,n,t)},c.shouldComponentUpdate=r}return u.__N||u.__}function b(_,n){var t=E(e++,4);!l.__s&&q(t.__H,n)&&(t.__=_,t.u=n,c.__h.push(t))}function g(_,n){var t=E(e++,7);return q(t.__H,n)&&(t.__=_(),t.__H=n,t.__h=_),t.__}function C(){for(var _;_=h.shift();)if(_.__P&&_.__H)try{_.__H.__h.forEach(F),_.__H.__h.forEach(k),_.__H.__h=[]}catch(n){_.__H.__h=[],l.__e(n,_.__v)}}l.__b=function(_){c=null,s&&s(_)},l.__=function(_,n){_&&n.__k&&n.__k.__m&&(_.__m=n.__k.__m),H&&H(_,n)},l.__r=function(_){v&&v(_),e=0;var n=(c=_.__c).__H;n&&(i===c?(n.__h=[],c.__h=[],n.__.forEach((function(_){_.__N&&(_.__=_.__N),_.u=_.__N=void 0}))):(n.__h.forEach(F),n.__h.forEach(k),n.__h=[],e=0)),i=c},l.diffed=function(_){m&&m(_);var n=_.__c;n&&n.__H&&(n.__H.__h.length&&(1!==h.push(n)&&f===l.requestAnimationFrame||((f=l.requestAnimationFrame)||D)(C)),n.__H.__.forEach((function(_){_.u&&(_.__H=_.u),_.u=void 0}))),i=c=null},l.__c=function(_,n){n.some((function(_){try{_.__h.forEach(F),_.__h=_.__h.filter((function(_){return!_.__||k(_)}))}catch(t){n.some((function(_){_.__h&&(_.__h=[])})),n=[],l.__e(t,_.__v)}})),d&&d(_,n)},l.unmount=function(_){p&&p(_);var n,t=_.__c;t&&t.__H&&(t.__H.__.forEach((function(_){try{F(_)}catch(_){n=_}})),t.__H=void 0,n&&l.__e(n,t.__v))};var A="function"==typeof requestAnimationFrame;function D(_){var n,t=function(){clearTimeout(u),A&&cancelAnimationFrame(n),setTimeout(_)},u=setTimeout(t,100);A&&(n=requestAnimationFrame(t))}function F(_){var n=c,t=_.__c;"function"==typeof t&&(_.__c=void 0,t()),c=n}function k(_){var n=c;_.__c=_.__(),c=n}function q(_,n){return!_||_.length!==n.length||n.some((function(n,t){return n!==_[t]}))}function U(_,n){return"function"==typeof n?n(_):n}},
"b3f51db71c": function _(d,n,b,t,e){t();const o=d("tslib"),r=d("bb986b9dd6");var a=d("bb986b9dd6");e("h",a.h),e("render",a.render),e("Component",a.Component);var f=o.__importDefault(d("ab33dd3f38")).default.bind(r.h);b.html=f},
"ab33dd3f38": function _(n,t,s,u,r){u(),s.default=function(n){var t=h.get(this);return t||(t=new Map,h.set(this,t)),(t=e(this,t.get(n)||(t.set(n,t=function(n){for(var t,s,u=1,r="",e="",h=[0],p=function(n){1===u&&(n||(r=r.replace(/^\s*\n\s*|\s*\n\s*$/g,"")))?h.push(0,n,r):3===u&&(n||r)?(h.push(3,n,r),u=2):2===u&&"..."===r&&n?h.push(4,n,0):2===u&&r&&!n?h.push(5,0,!0,r):u>=5&&((r||!n&&5===u)&&(h.push(u,0,r,s),u=6),n&&(h.push(u,n,0,s),u=6)),r=""},a=0;a<n.length;a++){a&&(1===u&&p(),p(a));for(var f=0;f<n[a].length;f++)t=n[a][f],1===u?"<"===t?(p(),h=[h],u=3):r+=t:4===u?"--"===r&&">"===t?(u=1,r=""):r=t+r[0]:e?t===e?e="":r+=t:'"'===t||"'"===t?e=t:">"===t?(p(),u=1):u&&("="===t?(u=5,s=r,r=""):"/"===t&&(u<5||">"===n[a][f+1])?(p(),3===u&&(h=h[0]),u=h,(h=h[0]).push(2,0,u),u=0):" "===t||"\t"===t||"\n"===t||"\r"===t?(p(),u=2):r+=t),3===u&&"!--"===r&&(u=4,h=h[0])}return p(),h}(n)),t),arguments,[])).length>1?t:t[0]};var e=function(n,t,s,u){var r;t[0]=0;for(var h=1;h<t.length;h++){var p=t[h++],a=t[h]?(t[0]|=p?1:2,s[t[h++]]):t[++h];3===p?u[0]=a:4===p?u[1]=Object.assign(u[1]||{},a):5===p?(u[1]=u[1]||{})[t[++h]]=a:6===p?u[1][t[++h]]+=a+"":p?(r=n.apply(a,e(n,a,s,["",null])),u.push(r),a[0]?t[0]|=2:(t[h-2]=0,t[h]=r)):u.push(a)}return u},h=new Map},
"4155401209": function _(e,t,s,n,i){var l;n();const o=e("tslib"),r=e("@bokehjs/core/dom"),d=e("@bokehjs/core/util/types"),_=e("@bokehjs/models/widgets/input_widget"),c=o.__importStar(e("@bokehjs/styles/widgets/inputs.css"));class h extends _.InputWidgetView{connect_signals(){super.connect_signals();const{value:e,options:t,disabled_options:s,size:n,disabled:i}=this.model.properties;this.on_change(e,(()=>this.render_selection())),this.on_change(t,(()=>this.rerender_())),this.on_change(s,(()=>this.rerender_())),this.on_change(n,(()=>this.rerender_())),this.on_change(i,(()=>this.rerender_()))}render(){super.render(),this.render_selection()}rerender_(){this.rerender?this.rerender():(this.render(),this.r_after_render())}_render_input(){const e=this.model.options.map((e=>{let t,s;(0,d.isString)(e)?t=s=e:[t,s]=e;const n=this.model.disabled_options.includes(t);return(0,r.option)({value:t,disabled:n},s)}));return this.input_el=(0,r.select)({multiple:!1,class:c.input,name:this.model.name,disabled:this.model.disabled},e),this.input_el.style.backgroundImage="none",this.input_el.addEventListener("change",(()=>this.change_input())),this.input_el}render_selection(){const e=this.model.value;for(const t of this.input_el.querySelectorAll("option"))t.value===e&&(t.selected=!0);this.input_el.size=this.model.size}change_input(){const e=null!=this.el.querySelector("select:focus");let t=null;for(const e of this.shadow_el.querySelectorAll("option"))if(e.selected){t=e.value;break}this.model.value=t,super.change_input(),e&&this.input_el.focus()}}s.SingleSelectView=h,h.__name__="SingleSelectView";class u extends _.InputWidget{constructor(e){super(e)}}s.SingleSelect=u,l=u,u.__name__="SingleSelect",u.__module__="panel.models.widgets",l.prototype.default_view=h,l.define((({Any:e,List:t,Int:s,Nullable:n,Str:i})=>({disabled_options:[t(i),[]],options:[t(e),[]],size:[s,4],value:[n(i),null]})))},
"5ac2cab0ab": function _(t,e,i,n,o){var s;n();const r=t("9b11ce01a3"),a="Click to START the speech recognition.",{webkitSpeechRecognition:h}=window,{webkitSpeechGrammarList:l}=window;class c extends r.HTMLBoxView{initialize(){super.initialize(),this.recognition=new h,this.recognition.lang=this.model.lang,this.recognition.continuous=this.model.continuous,this.recognition.interimResults=this.model.interim_results,this.recognition.maxAlternatives=this.model.max_alternatives,this.recognition.serviceURI=this.model.service_uri,this.setGrammars(),this.recognition.onresult=t=>{this.model.results=function(t){const e=[];for(const n of t){const t=[],o={is_final:n.isFinal,alternatives:t};for(let e=0;e<n.length;e++){const o={confidence:(i=n[e].confidence,Math.round(100*(i+Number.EPSILON))/100),transcript:n[e].transcript};t.push(o)}o.alternatives=t,e.push(o)}var i;return e}(t.results)},this.recognition.onerror=t=>{console.error(`SpeechToText Error: ${t}`)},this.recognition.onnomatch=t=>{console.warn(`SpeechToText No Match: ${t}`)},this.recognition.onaudiostart=()=>this.model.audio_started=!0,this.recognition.onaudioend=()=>this.model.audio_started=!1,this.recognition.onsoundstart=()=>this.model.sound_started=!0,this.recognition.onsoundend=()=>this.model.sound_started=!1,this.recognition.onspeechstart=()=>this.model.speech_started=!0,this.recognition.onspeechend=()=>this.model.speech_started=!1,this.recognition.onstart=()=>{this.buttonEl.onclick=()=>{this.recognition.stop()},this.buttonEl.innerHTML=this.iconStarted(),this.buttonEl.setAttribute("title","Click to STOP the speech recognition."),this.model.started=!0},this.recognition.onend=()=>{this.buttonEl.onclick=()=>{this.recognition.start()},this.buttonEl.innerHTML=this.iconNotStarted(),this.buttonEl.setAttribute("title",a),this.model.started=!1},this.buttonEl=function(t){const e=document.createElement("template");return t=t.trim(),e.innerHTML=t,e.content.firstChild}(`<button class="bk bk-btn bk-btn-${this.model.button_type}" type="button" title="${a}"></button>`),this.buttonEl.innerHTML=this.iconNotStarted(),this.buttonEl.onclick=()=>this.recognition.start()}iconStarted(){return""!==this.model.button_started?this.model.button_started:'<svg xmlns="http://www.w3.org/2000/svg" height="22px" style="vertical-align: middle;" fill="currentColor" class="bi bi-mic" viewBox="0 0 16 16">\n  <path fill-rule="evenodd" d="M3.5 6.5A.5.5 0 0 1 4 7v1a4 4 0 0 0 8 0V7a.5.5 0 0 1 1 0v1a5 5 0 0 1-4.5 4.975V15h3a.5.5 0 0 1 0 1h-7a.5.5 0 0 1 0-1h3v-2.025A5 5 0 0 1 3 8V7a.5.5 0 0 1 .5-.5z"/>\n  <path fill-rule="evenodd" d="M10 8V3a2 2 0 1 0-4 0v5a2 2 0 1 0 4 0zM8 0a3 3 0 0 0-3 3v5a3 3 0 0 0 6 0V3a3 3 0 0 0-3-3z"/>\n</svg>'}iconNotStarted(){return""!==this.model.button_not_started?this.model.button_not_started:'<svg xmlns="http://www.w3.org/2000/svg" height="22px" style="vertical-align: middle;" fill="currentColor" class="bi bi-mic-mute" viewBox="0 0 16 16">\n<path fill-rule="evenodd" d="M12.734 9.613A4.995 4.995 0 0 0 13 8V7a.5.5 0 0 0-1 0v1c0 .274-.027.54-.08.799l.814.814zm-2.522 1.72A4 4 0 0 1 4 8V7a.5.5 0 0 0-1 0v1a5 5 0 0 0 4.5 4.975V15h-3a.5.5 0 0 0 0 1h7a.5.5 0 0 0 0-1h-3v-2.025a4.973 4.973 0 0 0 2.43-.923l-.718-.719zM11 7.88V3a3 3 0 0 0-5.842-.963l.845.845A2 2 0 0 1 10 3v3.879l1 1zM8.738 9.86l.748.748A3 3 0 0 1 5 8V6.121l1 1V8a2 2 0 0 0 2.738 1.86zm4.908 3.494l-12-12 .708-.708 12 12-.708.707z"/>\n</svg>'}setIcon(){this.model.started?this.buttonEl.innerHTML=this.iconStarted():this.buttonEl.innerHTML=this.iconNotStarted()}connect_signals(){super.connect_signals();const{start:t,stop:e,abort:i,grammars:n,lang:o,continuous:s,interim_results:r,max_alternatives:a,service_uri:h,button_type:l,button_hide:c,button_not_started:d,button_started:u}=this.model.properties;this.on_change(t,(()=>{this.model.start=!1,this.recognition.start()})),this.on_change(e,(()=>{this.model.stop=!1,this.recognition.stop()})),this.on_change(i,(()=>{this.model.abort=!1,this.recognition.abort()})),this.on_change(n,(()=>this.setGrammars())),this.on_change(o,(()=>this.recognition.lang=this.model.lang)),this.on_change(s,(()=>this.recognition.continuous=this.model.continuous)),this.on_change(r,(()=>this.recognition.interimResults=this.model.interim_results)),this.on_change(a,(()=>this.recognition.maxAlternatives=this.model.max_alternatives)),this.on_change(h,(()=>this.recognition.serviceURI=this.model.service_uri)),this.on_change(l,(()=>this.buttonEl.className=`bk bk-btn bk-btn-${this.model.button_type}`)),this.on_change(c,(()=>this.render())),this.on_change([d,u],(()=>this.setIcon()))}setGrammars(){this.recognition.grammars=function(t){if(t){const e=new l;for(const i of t)i.src?e.addFromString(i.src,i.weight):i.uri&&e.addFromURI(i.uri,i.weight);return e}return null}(this.model.grammars)}render(){super.render(),this.model.button_hide||this.shadow_el.appendChild(this.buttonEl)}}i.SpeechToTextView=c,c.__name__="SpeechToTextView";class d extends r.HTMLBox{constructor(t){super(t)}}i.SpeechToText=d,s=d,d.__name__="SpeechToText",d.__module__="panel.models.speech_to_text",s.prototype.default_view=c,s.define((({Any:t,List:e,Bool:i,Float:n,Str:o})=>({start:[i,!1],stop:[i,!1],abort:[i,!1],grammars:[e(t),[]],lang:[o,""],continuous:[i,!1],interim_results:[i,!1],max_alternatives:[n,1],service_uri:[o,""],started:[i,!1],audio_started:[i,!1],sound_started:[i,!1],speech_started:[i,!1],button_type:[o,"light"],button_hide:[i,!1],button_not_started:[o,""],button_started:[o,""],results:[e(t),[]]})))},
"92822cb73a": function _(e,t,s,a,i){var o;a();const c=e("@bokehjs/core/view"),n=e("@bokehjs/core/util/array"),h=e("@bokehjs/model"),_=e("@bokehjs/protocol/receiver");class r extends c.View{}s.StateView=r,r.__name__="StateView";class p extends h.Model{constructor(e){super(e),this._receiver=new _.Receiver,this._cache={}}apply_state(e){this._receiver.consume(e.header),this._receiver.consume(e.metadata),this._receiver.consume(e.content),this._receiver.message&&this.document&&this.document.apply_json_patch(this._receiver.message.content)}_receive_json(e,t){const s=JSON.parse(e);this._cache[t]=s;let a=this.state;for(const e of this.values)a=a instanceof Map?a.get(e):a[e];a===t?this.apply_state(s):this._cache[a]&&this.apply_state(this._cache[a])}set_state(e,t){const s=(0,n.copy)(this.values);s[this.widgets[e.id]]=t;let a=this.state;for(const e of s)a=a instanceof Map?a.get(e):a[e];this.values=s,this.json?this._cache[a]?this.apply_state(this._cache[a]):function(e,t){const s=new XMLHttpRequest;s.overrideMimeType("application/json"),s.open("GET",e,!0),s.onreadystatechange=function(){4==s.readyState&&200==s.status&&t(s.responseText)},s.send(null)}(a,(e=>this._receive_json(e,a))):this.apply_state(a)}}s.State=p,o=p,p.__name__="State",p.__module__="panel.models.state",o.prototype.default_view=r,o.define((({Any:e,Bool:t})=>({json:[t,!1],state:[e,{}],widgets:[e,{}],values:[e,[]]})))},
"2231cdc549": function _(e,t,s,i,l){var o;i();const a=e("tslib").__importStar(e("@bokehjs/styles/tabs.css")),n=e("@bokehjs/core/layout/grid"),c=e("@bokehjs/core/enums"),d=e("@bokehjs/models/layouts/alignments"),r=e("@bokehjs/models/layouts/tabs"),_=e("@bokehjs/models/layouts/layout_dom");function u(e){e.style.visibility="",e.style.opacity=""}function h(e){e.style.visibility="hidden",e.style.opacity="0"}class y extends r.TabsView{connect_signals(){super.connect_signals();let e=this;for(;null!=e;)e.model.type.endsWith("Tabs")&&e.connect(e.model.properties.active.change,(()=>this.update_zindex())),e=e.parent||e._parent}get is_visible(){let e=this.parent,t=this;for(;null!=e;){if(e.model.type.endsWith("Tabs")&&e.child_views.indexOf(t)!==e.model.active)return!1;t=e,e=e.parent||e._parent}return!0}render(){super.render(),this.update_zindex()}update_zindex(){const{child_views:e}=this;for(const t of e)null!=t&&null!=t.el&&(t.el.style.zIndex="");if(this.is_visible){const t=e[this.model.active];null!=t&&null!=t.el&&(t.el.style.zIndex="1")}}_after_layout(){_.LayoutDOMView.prototype._after_layout.call(this);const{child_views:e}=this;for(const t of e)void 0!==t&&h(t.el);const{active:t}=this.model;if(t in e){const s=e[t];void 0!==s&&u(s.el)}}_update_layout(){_.LayoutDOMView.prototype._update_layout.call(this);const e=this.model.tabs_location;this.class_list.remove([...c.Location].map((e=>a[e]))),this.class_list.add(a[e]);const t=new n.Container;for(const e of this.child_views)null!=e&&(e.style.append(":host",{grid_area:"stack"}),e instanceof _.LayoutDOMView&&null!=e.layout&&t.add({r0:0,c0:0,r1:1,c1:1},e));0!=t.size?(this.layout=new d.GridAlignmentLayout(t),this.layout.set_sizing()):delete this.layout}update_active(){const e=this.model.active,{header_els:t}=this;for(const e of t)e.classList.remove(a.active);e in t&&t[e].classList.add(a.active);const{child_views:s}=this;for(const e of s)h(e.el);if(e in s){const t=s[e];u(t.el),null==t.invalidate_render&&t.invalidate_render()}}}s.TabsView=y,y.__name__="TabsView";class p extends r.Tabs{}s.Tabs=p,o=p,p.__name__="Tabs",p.__module__="panel.models.tabs",o.prototype.default_view=y},
"a961b5ae5e": function _(e,t,n,i,s){var r,o;i();const h=e("@bokehjs/core/dom"),a=e("@bokehjs/core/bokeh_events"),l=e("9b11ce01a3");class d extends a.ModelEvent{constructor(e){super(),this.key=e}get event_values(){return{model:this.origin,key:this.key}}}n.KeystrokeEvent=d,r=d,d.__name__="KeystrokeEvent",r.prototype.event_name="keystroke";class m extends l.HTMLBoxView{connect_signals(){super.connect_signals();const{width:e,height:t,min_height:n,max_height:i,margin:s,sizing_mode:r,output:o,_clears:h}=this.model.properties;this.on_change(o,this.write),this.on_change(h,this.clear),this.on_change([e,t,n,i,s,r],(()=>{(0,l.set_size)(this.el,this.model),(0,l.set_size)(this.container,this.model,!1)}))}render(){super.render(),this.container=(0,h.div)({class:"terminal-container"}),(0,l.set_size)(this.container,this.model,!1),this.term=this.getNewTerminal(),this.term.onData((e=>{this.handleOnData(e)})),this.webLinksAddon=this.getNewWebLinksAddon(),this.term.loadAddon(this.webLinksAddon),this.term.open(this.container),this.term.onRender((()=>{this._rendered||this.fit()})),this.write(),this.shadow_el.appendChild(this.container)}getNewTerminal(){const e=window;return e.Terminal?new e.Terminal(this.model.options):new e.xtermjs.Terminal(this.model.options)}getNewWebLinksAddon(){return new window.WebLinksAddon.WebLinksAddon}handleOnData(e){this.model.trigger_event(new d(e))}write(){const e=this.model.output;if(null==e||!e.length)return;const t=e.replace(/\r?\n/g,"\r\n");this.term.write(t)}clear(){this.term.clear()}fit(){const e=this.container.offsetWidth,t=this.container.offsetHeight,n=this.term._core._renderService,i=n.dimensions.actualCellWidth||9,s=n.dimensions.actualCellHeight||18;if(null==e||null==t||e<=0||t<=0)return;const r=Math.max(2,Math.floor(e/i)),o=Math.max(1,Math.floor(t/s));this.term.rows===o&&this.term.cols===r||this.term.resize(r,o),this.model.ncols=r,this.model.nrows=o,this._rendered=!0}after_layout(){super.after_layout(),null!=this.container&&this.fit()}}n.TerminalView=m,m.__name__="TerminalView";class c extends l.HTMLBox{constructor(e){super(e)}}n.Terminal=c,o=c,c.__name__="Terminal",c.__module__="panel.models.terminal",o.prototype.default_view=m,o.define((({Any:e,Int:t,Str:n})=>({_clears:[t,0],options:[e,{}],output:[n,""],ncols:[t,0],nrows:[t,0]})))},
"8be416b160": function _(e,t,n,s,_){var u,o;s();const i=e("@bokehjs/models/widgets/text_input"),p=e("@bokehjs/core/bokeh_events");class r extends p.ModelEvent{constructor(e){super(),this.value_input=e}get event_values(){return{model:this.origin,value_input:this.value_input}}}n.EnterEvent=r,u=r,r.__name__="EnterEvent",u.prototype.event_name="enter-pressed";class l extends i.TextInputView{_keyup(e){if(super._keyup(e),"Enter"==e.key){const{value_input:e}=this.model;this.model.trigger_event(new r(e))}}}n.TextInputView=l,l.__name__="TextInputView";class a extends i.TextInput{constructor(e){super(e)}}n.TextInput=a,o=a,a.__name__="TextInput",a.__module__="panel.models.widgets",o.prototype.default_view=l,o.define((({})=>({})))},
"a04eb51988": function _(e,s,i,n,t){var o;n();const h=e("9b11ce01a3");function c(e){const s=[];for(const i of e){const e={default:i.default,lang:i.lang,local_service:i.localService,name:i.name,voice_uri:i.voiceURI};s.push(e)}return s}class p extends h.HTMLBoxView{initialize(){super.initialize(),this.model.paused=speechSynthesis.paused,this.model.pending=speechSynthesis.pending,this.model.speaking=speechSynthesis.speaking,this._callback=window.setInterval((function(){!speechSynthesis.paused&&speechSynthesis.speaking&&window.speechSynthesis.resume()}),1e4);const e=()=>{"undefined"!=typeof speechSynthesis&&(this.voices=speechSynthesis.getVoices(),this.voices&&(this.model.voices=c(this.voices)))};e(),"undefined"!=typeof speechSynthesis&&void 0!==speechSynthesis.onvoiceschanged&&(speechSynthesis.onvoiceschanged=e)}remove(){null!=this._callback&&clearInterval(this._callback),speechSynthesis.cancel(),super.remove()}connect_signals(){super.connect_signals();const{speak:e,pause:s,resume:i,cancel:n}=this.model.properties;this.on_change(e,(()=>{this.speak()})),this.on_change(s,(()=>{this.model.pause=!1,speechSynthesis.pause()})),this.on_change(i,(()=>{this.model.resume=!1,speechSynthesis.resume()})),this.on_change(n,(()=>{this.model.cancel=!1,speechSynthesis.cancel()}))}speak(){const e=new SpeechSynthesisUtterance(this.model.speak.text);if(e.pitch=this.model.speak.pitch,e.volume=this.model.speak.volume,e.rate=this.model.speak.rate,this.model.voices)for(const s of this.voices)s.name===this.model.speak.voice&&(e.voice=s);e.onpause=()=>this.model.paused=!0,e.onstart=()=>{this.model.speaking=!0,this.model.paused=!1,this.model.pending=speechSynthesis.pending},e.onresume=()=>this.model.paused=!1,e.onend=()=>{this.model.speaking=!1,this.model.paused=!1,this.model.pending=speechSynthesis.pending},speechSynthesis.speak(e),this.model.paused=speechSynthesis.paused,this.model.pending=speechSynthesis.pending}render(){super.render(),this.model.voices||(this.model.voices=c(this.voices)),null!=this.model.speak&&this.model.speak.text&&this.speak()}}i.TextToSpeechView=p,p.__name__="TextToSpeechView";class a extends h.HTMLBox{constructor(e){super(e)}}i.TextToSpeech=a,o=a,a.__name__="TextToSpeech",a.__module__="panel.models.text_to_speech",o.prototype.default_view=p,o.define((({Any:e,List:s,Bool:i})=>({paused:[i,!1],pending:[i,!1],speaking:[i,!1],voices:[s(e),[]],cancel:[i,!1],pause:[i,!1],resume:[i,!1],speak:[e,{}]})))},
"1afcab4e45": function _(e,t,i,s,n){var o;s();const c=e("@bokehjs/models/widgets/time_picker");class _ extends c.TimePickerView{_offset_time(e){const t=new Date(e),i=60*t.getTimezoneOffset()*1e3;return t.getTime()+i}_setDate(e){e=this._offset_time(e),this.picker.setDate(e)}get flatpickr_options(){const e=super.flatpickr_options;return null!=e.defaultDate&&(e.defaultDate=this._offset_time(e.defaultDate)),e}connect_signals(){super.connect_signals();const{value:e}=this.model.properties;this.connect(e.change,(()=>{const{value:e}=this.model;null!=e&&"number"==typeof e&&this._setDate(e)}))}}i.TimePickerView=_,_.__name__="TimePickerView";class r extends c.TimePicker{constructor(e){super(e)}}i.TimePicker=r,o=r,r.__name__="TimePicker",r.__module__="panel.models.time_picker",o.prototype.default_view=_,o.define((({})=>({})))},
"ad985f285e": function _(e,o,l,c,n){var s;c();const i=e("6c7fbea0ef");class _ extends i.ClickableIconView{*controls(){}click(){this.model.disabled||(super.click(),this.model.value=!this.model.value)}}l.ToggleIconView=_,_.__name__="ToggleIconView";class a extends i.ClickableIcon{constructor(e){super(e)}}l.ToggleIcon=a,s=a,a.__name__="ToggleIcon",a.__module__="panel.models.icon",s.prototype.default_view=_,s.define((({})=>({})))},
"ae3a172647": function _(e,s,t,i,o){var l;i();const d=e("tslib"),n=e("@bokehjs/models/ui/tooltip"),c=e("@bokehjs/models/layouts/layout_dom"),r=e("@bokehjs/core/dom"),p=d.__importStar(e("@bokehjs/styles/widgets/inputs.css")),a=p,h=d.__importDefault(e("@bokehjs/styles/icons.css"));class _ extends c.LayoutDOMView{get child_models(){return null==this.model.description?[]:[this.model.description]}connect_signals(){super.connect_signals();const{description:e}=this.model.properties;this.on_change(e,(()=>this.update_children()))}stylesheets(){return[...super.stylesheets(),p.default,h.default]}render(){super.render();const e=(0,r.div)({class:a.icon});this.desc_el=(0,r.div)({class:a.description},e),this.model.description.target=this.desc_el;let s=!1;const t=t=>{this.model.description.setv({visible:t,closable:s}),e.classList.toggle(a.opaque,t&&s)};this.on_change(this.model.description.properties.visible,(()=>{const{visible:e}=this.model.description;e||(s=!1),t(e)})),this.desc_el.addEventListener("mouseenter",(()=>{t(!0)})),this.desc_el.addEventListener("mouseleave",(()=>{s||t(!1)})),document.addEventListener("mousedown",(e=>{const i=e.composedPath(),o=this._child_views.get(this.model.description);void 0!==o&&i.includes(o.el)||(i.includes(this.desc_el)?(s=!s,t(s)):(s=!1,t(!1)))})),window.addEventListener("blur",(()=>{s=!1,t(!1)})),this.shadow_el.appendChild((0,r.label)(this.desc_el))}}t.TooltipIconView=_,_.__name__="TooltipIconView";class u extends c.LayoutDOM{constructor(e){super(e)}}t.TooltipIcon=u,l=u,u.__name__="TooltipIcon",u.__module__="panel.models.widgets",l.prototype.default_view=_,l.define((({Ref:e})=>({description:[e(n.Tooltip),new n.Tooltip]})))},
"29d55a28a9": function _(t,e,i,l,o){var s;l();const h=t("9b11ce01a3"),a=t("@bokehjs/core/build_views"),n=t("@bokehjs/models/plots"),d=t("@bokehjs/models/glyphs"),r=t("@bokehjs/core/dom"),_=t("@bokehjs/models/sources/column_data_source"),c=t("@bokehjs/models/formatters");class p extends h.HTMLBoxView{initialize(){super.initialize(),this.containerDiv=(0,r.div)({style:{height:"100%",width:"100%"}}),this.titleDiv=(0,r.div)({style:{font_size:"1em",word_wrap:"break-word"}}),this.valueDiv=(0,r.div)({style:{font_size:"2em"}}),this.value2Div=(0,r.div)({style:{font_size:"1em",opacity:"0.5",display:"inline"}}),this.changeDiv=(0,r.div)({style:{font_size:"1em",opacity:"0.5",display:"inline"}}),this.textDiv=(0,r.div)({},this.titleDiv,this.valueDiv,(0,r.div)({},this.changeDiv,this.value2Div)),this.updateTitle(),this.updateValue(),this.updateValue2(),this.updateValueChange(),this.updateTextFontSize(),this.plotDiv=(0,r.div)({}),this.containerDiv=(0,r.div)({style:{height:"100%",width:"100%"}},this.textDiv,this.plotDiv),this.updateLayout()}connect_signals(){super.connect_signals();const{pos_color:t,neg_color:e,plot_color:i,plot_type:l,width:o,height:s,sizing_mode:h,title:a,value:n,value_change:d,layout:r}=this.model.properties;this.on_change([t,e],(()=>this.updateValueChange())),this.on_change([i,l,o,s,h],(()=>this.rerender_())),this.on_change(a,(()=>this.updateTitle(!0))),this.on_change(n,(()=>this.updateValue(!0))),this.on_change(d,(()=>this.updateValue2(!0))),this.on_change(r,(()=>this.updateLayout()))}async render(){super.render(),this.shadow_el.appendChild(this.containerDiv),await this.setPlot()}async setPlot(){this.plot=new n.Plot({background_fill_color:null,border_fill_color:null,outline_line_color:null,min_border:0,sizing_mode:"stretch_both",toolbar_location:null});const t=this.model.source;if("line"===this.model.plot_type){const e=new d.Line({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:4,line_color:this.model.plot_color});this.plot.add_glyph(e,t)}else if("step"===this.model.plot_type){const e=new d.Step({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:3,line_color:this.model.plot_color});this.plot.add_glyph(e,t)}else if("area"===this.model.plot_type){const e=new d.VArea({x:{field:this.model.plot_x},y1:{field:this.model.plot_y},y2:0,fill_color:this.model.plot_color,fill_alpha:.5});this.plot.add_glyph(e,t);const i=new d.Line({x:{field:this.model.plot_x},y:{field:this.model.plot_y},line_width:3,line_color:this.model.plot_color});this.plot.add_glyph(i,t)}else{const e=new d.VBar({x:{field:this.model.plot_x},top:{field:this.model.plot_y},width:.9,line_color:null,fill_color:this.model.plot_color});this.plot.add_glyph(e,t)}const e=await(0,a.build_view)(this.plot);this.plotDiv.innerHTML="",e.render_to(this.plotDiv)}after_layout(){super.after_layout(),this.updateTextFontSize()}updateTextFontSize(){this.updateTextFontSizeColumn()}updateTextFontSizeColumn(){let t=this.containerDiv.clientWidth,e=this.containerDiv.clientHeight;"column"===this.model.layout?e=Math.round(e/2):t=Math.round(t/2);const i=t/this.model.title.length*2,l=t/(2*this._value_format.length)*1.8,o=t/(this._value_change_format.length+1)*2,s=e/6,h=Math.min(i,l,o,s);this.textDiv.style.fontSize=`${Math.trunc(h)}px`,this.textDiv.style.lineHeight="1.3"}updateTitle(t=!1){this.titleDiv.innerText=this.model.title,t&&this.updateTextFontSize()}updateValue(t=!1){this._value_format=this.model.formatter.doFormat([this.model.value],{loc:0})[0],this.valueDiv.innerText=this._value_format,t&&this.updateTextFontSize()}updateValue2(t=!1){this._value_change_format=this.model.change_formatter.doFormat([this.model.value_change],{loc:0})[0],this.value2Div.innerText=this._value_change_format,this.updateValueChange(),t&&this.updateTextFontSize()}updateValueChange(){this.model.value_change>0?(this.changeDiv.innerHTML="&#9650;",this.changeDiv.style.color=this.model.pos_color):this.model.value_change<0?(this.changeDiv.innerHTML="&#9660;",this.changeDiv.style.color=this.model.neg_color):(this.changeDiv.innerHTML="&nbsp;",this.changeDiv.style.color="inherit")}updateLayout(){"column"===this.model.layout?(this.containerDiv.style.display="block",this.textDiv.style.height="50%",this.textDiv.style.width="100%",this.plotDiv.style.height="50%",this.plotDiv.style.width="100%"):(this.containerDiv.style.display="flex",this.textDiv.style.height="100%",this.textDiv.style.width="",this.plotDiv.style.height="100%",this.plotDiv.style.width="",this.textDiv.style.flex="1",this.plotDiv.style.flex="1"),this._has_finished&&this.invalidate_layout()}}i.TrendIndicatorView=p,p.__name__="TrendIndicatorView";class u extends h.HTMLBox{constructor(t){super(t)}}i.TrendIndicator=u,s=u,u.__name__="TrendIndicator",u.__module__="panel.models.trend",s.prototype.default_view=p,s.define((({Float:t,Str:e,Ref:i})=>({description:[e,""],formatter:[i(c.TickFormatter),()=>new c.BasicTickFormatter],change_formatter:[i(c.TickFormatter),()=>new c.NumeralTickFormatter],layout:[e,"column"],source:[i(_.ColumnDataSource)],plot_x:[e,"x"],plot_y:[e,"y"],plot_color:[e,"#428bca"],plot_type:[e,"bar"],pos_color:[e,"#5cb85c"],neg_color:[e,"#d9534f"],title:[e,""],value:[t,0],value_change:[t,0]})))},
"119dc23765": function _(e,t,s,o,n){var a,i;o();const c=e("@bokehjs/core/dom"),d=e("@bokehjs/core/bokeh_events"),r=e("@bokehjs/core/util/types"),h=e("@bokehjs/models/layouts/layout_dom"),_=e("9b11ce01a3"),l=e("99a25e6992");class u extends d.ModelEvent{constructor(e){super(),this.data=e}get event_values(){return{model:this.origin,data:this.data}}}s.VegaEvent=u,a=u,u.__name__="VegaEvent",a.prototype.event_name="vega_event";class v extends h.LayoutDOMView{constructor(){super(...arguments),this._rendered=!1}connect_signals(){super.connect_signals();const{data:e,show_actions:t,theme:s,data_sources:o,events:n}=this.model.properties;this._replot=(0,l.debounce)((()=>this._plot()),20),this.on_change([e,t,s],(()=>{this._replot()})),this.on_change(o,(()=>this._connect_sources())),this.on_change(n,(()=>{for(const e of this.model.events){if(this._callbacks.indexOf(e)>-1)continue;this._callbacks.push(e);const t=(e,t)=>this._dispatch_event(e,t),s=this.model.throttle[e]||20;this.vega_view.addSignalListener(e,(0,l.debounce)(t,s,!1))}})),this._connected=[],this._connect_sources()}_connect_sources(){for(const e in this.model.data_sources){const t=this.model.data_sources[e];this._connected.indexOf(e)<0&&(this.connect(t.properties.data.change,(()=>this._replot())),this._connected.push(e))}}remove(){this.vega_view&&this.vega_view.finalize(),super.remove()}_dispatch_event(e,t){if("vlPoint"in t&&null!=t.vlPoint.or){const e=[];for(const s of t.vlPoint.or)if(void 0!==s._vgsid_)e.push(s._vgsid_);else for(const t in s)s.hasOwnProperty(t)&&e.push({[t]:s[t]});t=e}this.model.trigger_event(new u({type:e,value:t}))}_fetch_datasets(){const e={};for(const t in this.model.data_sources){const s=this.model.data_sources[t],o=[],n=s.columns();for(let e=0;e<s.get_length();e++){const t={};for(const o of n)t[o]=s.data[o][e];o.push(t)}e[t]=o}return e}get child_models(){return[]}render(){super.render(),this._rendered=!1,this.container=(0,c.div)(),(0,_.set_size)(this.container,this.model),this._callbacks=[],this._plot(),this.shadow_el.append(this.container)}_plot(){const e=this.model.data;if(null==e||!window.vegaEmbed)return;if(this.model.data_sources&&Object.keys(this.model.data_sources).length>0){const t=this._fetch_datasets();if("data"in t&&(e.data.values=t.data,delete t.data),null!=e.data){const s=(0,r.isArray)(e.data)?e.data:[e.data];for(const e of s)e.name in t&&(e.values=t[e.name],delete t[e.name])}this.model.data.datasets=t}const t={actions:this.model.show_actions,theme:this.model.theme};window.vegaEmbed(this.container,this.model.data,t).then((e=>{this.vega_view=e.view,this._resize=(0,l.debounce)((()=>this.resize_view(e.view)),50);const t=(e,t)=>this._dispatch_event(e,t);for(const e of this.model.events){this._callbacks.push(e);const s=this.model.throttle[e]||20;this.vega_view.addSignalListener(e,(0,l.debounce)(t,s,!1))}}))}after_layout(){super.after_layout(),null!=this.vega_view&&this._resize()}resize_view(e){const t=e._renderer.canvas();if(!this._rendered&&null!==t){for(const t of e._eventListeners)"resize"===t.type&&t.handler(new Event("resize"));this._rendered=!0}}}s.VegaPlotView=v,v.__name__="VegaPlotView";class m extends h.LayoutDOM{constructor(e){super(e)}}s.VegaPlot=m,i=m,m.__name__="VegaPlot",m.__module__="panel.models.vega",i.prototype.default_view=v,i.define((({Any:e,List:t,Bool:s,Nullable:o,Str:n})=>({data:[e,{}],data_sources:[e,{}],events:[t(n),[]],show_actions:[s,!1],theme:[o(n),null],throttle:[e,{}]})))},
"79dc37b888": function _(e,t,i,s,o){var l;s();const d=e("tslib"),h=e("@bokehjs/core/dom"),_=e("9b11ce01a3"),u=d.__importDefault(e("dfe21e6f1b"));class n extends _.HTMLBoxView{constructor(){super(...arguments),this._blocked=!1,this._setting=!1}initialize(){super.initialize(),this._time=Date.now()}connect_signals(){super.connect_signals();const{loop:e,paused:t,muted:i,autoplay:s,time:o,value:l,volume:d}=this.model.properties;this.on_change(e,(()=>this.set_loop())),this.on_change(t,(()=>this.set_paused())),this.on_change(i,(()=>this.set_muted())),this.on_change(s,(()=>this.set_autoplay())),this.on_change(o,(()=>this.set_time())),this.on_change(l,(()=>this.set_value())),this.on_change(d,(()=>this.set_volume()))}stylesheets(){return[...super.stylesheets(),u.default]}render(){super.render(),this.video_el=document.createElement("video");const e=document.createElement("div");e.className="pn-video-container",e.style.height="100%",e.style.width="100%";const{sizing_mode:t}=this.model;if(null==t||"fixed"===t){const{width:e,height:t}=this.model;null!=e&&(this.video_el.width=e),null!=t&&(this.video_el.height=t)}const{max_width:i,max_height:s}=this.model;null!=i&&(this.video_el.style.maxWidth=(0,h.px)(i)),null!=s&&(this.video_el.style.maxHeight=(0,h.px)(s)),this.video_el.controls=!0,this.video_el.src=this.model.value,this.video_el.currentTime=this.model.time,this.video_el.loop=this.model.loop,this.video_el.muted=this.model.muted,this.video_el.autoplay=this.model.autoplay,null!=this.model.volume?this.video_el.volume=this.model.volume/100:this.model.volume=100*this.video_el.volume,this.video_el.onpause=()=>this.model.paused=!0,this.video_el.onplay=()=>this.model.paused=!1,this.video_el.ontimeupdate=()=>this.update_time(),this.video_el.onvolumechange=()=>this.update_volume(),e.append(this.video_el),this.shadow_el.append(e),this.model.paused||this.video_el.play()}update_time(){this._setting?this._setting=!1:Date.now()-this._time<this.model.throttle||(this._blocked=!0,this.model.time=this.video_el.currentTime,this._time=Date.now())}update_volume(){this._setting?this._setting=!1:(this._blocked=!0,this.model.volume=100*this.video_el.volume)}set_loop(){this.video_el.loop=this.model.loop}set_muted(){this.video_el.muted=this.model.muted}set_autoplay(){this.video_el.autoplay=this.model.autoplay}set_paused(){const{paused:e}=this.model;!this.video_el.paused&&e&&this.video_el.pause(),this.video_el.paused&&!e&&this.video_el.play()}set_volume(){if(this._blocked)return void(this._blocked=!1);this._setting=!0;const{volume:e}=this.model;null!=e&&(this.video_el.volume=e/100)}set_time(){this._blocked?this._blocked=!1:(this._setting=!0,this.video_el.currentTime=this.model.time)}set_value(){this.video_el.src=this.model.value}}i.VideoView=n,n.__name__="VideoView";class a extends _.HTMLBox{constructor(e){super(e)}}i.Video=a,l=a,a.__name__="Video",a.__module__="panel.models.widgets",l.prototype.default_view=n,l.define((({Bool:e,Int:t,Float:i,Str:s,Nullable:o})=>({loop:[e,!1],paused:[e,!0],muted:[e,!1],autoplay:[e,!1],time:[i,0],throttle:[t,250],value:[s,""],volume:[o(t),null]})))},
"dfe21e6f1b": function _(i,t,e,f,d){f(),e.default="video{object-fit:fill;width:100%;height:100%;}"},
"f8afc4e661": function _(e,t,i,s,o){var h;s();const l=e("9b11ce01a3");class a extends l.HTMLBoxView{constructor(){super(...arguments),this.constraints={audio:!1,video:!0}}initialize(){super.initialize(),null!==this.model.timeout&&this.set_timeout()}connect_signals(){super.connect_signals();const{timeout:e,snapshot:t,paused:i}=this.model.properties;this.on_change(e,(()=>this.set_timeout())),this.on_change(t,(()=>this.snapshot())),this.on_change(i,(()=>this.pause()))}pause(){this.model.paused?(null!=this.timer&&(clearInterval(this.timer),this.timer=null),this.videoEl.pause()):this.videoEl.play(),this.set_timeout()}set_timeout(){this.timer&&(clearInterval(this.timer),this.timer=null),null!=this.model.timeout&&this.model.timeout>0&&(this.timer=setInterval((()=>this.snapshot()),this.model.timeout))}snapshot(){this.canvasEl.width=this.videoEl.videoWidth,this.canvasEl.height=this.videoEl.videoHeight;const e=this.canvasEl.getContext("2d");e&&e.drawImage(this.videoEl,0,0,this.canvasEl.width,this.canvasEl.height),this.model.value=this.canvasEl.toDataURL(`image/${this.model.format}`,.95)}remove(){super.remove(),this.timer&&(clearInterval(this.timer),this.timer=null)}render(){super.render(),this.videoEl||(this.videoEl=document.createElement("video"),this.model.sizing_mode&&"fixed"!==this.model.sizing_mode||(this.model.height&&(this.videoEl.height=this.model.height),this.model.width&&(this.videoEl.width=this.model.width)),this.videoEl.style.objectFit="fill",this.videoEl.style.minWidth="100%",this.videoEl.style.minHeight="100%",this.canvasEl=document.createElement("canvas"),this.shadow_el.appendChild(this.videoEl),navigator.mediaDevices.getUserMedia&&navigator.mediaDevices.getUserMedia(this.constraints).then((e=>{this.videoEl.srcObject=e,this.model.paused||this.videoEl.play()})).catch(console.error))}}i.VideoStreamView=a,a.__name__="VideoStreamView";class d extends l.HTMLBox{constructor(e){super(e)}}i.VideoStream=d,h=d,d.__name__="VideoStream",d.__module__="panel.models.widgets",h.prototype.default_view=a,h.define((({Any:e,Bool:t,Int:i,Nullable:s,Str:o})=>({format:[o,"png"],paused:[t,!1],snapshot:[t,!1],timeout:[s(i),null],value:[e]}))),h.override({height:240,width:320})},
"1f7bc1f95b": function _(e,t,i,s,n){var o;s();const a=e("@bokehjs/core/dom"),l=e("@bokehjs/core/util/types"),c=e("@bokehjs/models/sources/column_data_source"),r=e("@bokehjs/core/bokeh_events"),h=e("99a25e6992"),d=e("9b11ce01a3");class u extends r.ModelEvent{constructor(e){super(),this.event_name="vizzu_event",this.publish=!0,this.data=e}get event_values(){return{model:this.origin,data:this.data}}}i.VizzuEvent=u,u.__name__="VizzuEvent";const m=["x","y","color","label","lightness","size","splittedBy","dividedBy"];class _ extends d.HTMLBoxView{constructor(){super(...arguments),this.update=[],this._animating=!1}connect_signals(){super.connect_signals();const e=(0,h.debounce)((()=>{if(this.valid_config){if(0!==this.update.length&&!this._animating){let t={};for(const e of this.update)t="config"===e?{...t,config:this.config()}:"data"===e?{...t,data:this.data()}:{...t,style:this.model.style};this._animating=!0,this.vizzu_view.animate(t,`${this.model.duration}ms`).then((()=>{this._animating=!1,this.update.length>0&&e()})),this.update=[]}}else console.warn("Vizzu config not valid given current data.")}),20),t=t=>{this.update.includes(t)||this.update.push(t),e()},{config:i,tooltip:s,style:n}=this.model.properties;this.on_change(i,(()=>t("config"))),this.on_change(this.model.source.properties.data,(()=>t("data"))),this.connect(this.model.source.streaming,(()=>t("data"))),this.connect(this.model.source.patching,(()=>t("data"))),this.on_change(s,(()=>{this.vizzu_view.feature("tooltip",this.model.tooltip)})),this.on_change(n,(()=>t("style")))}get valid_config(){const e=this.model.source.columns();if("channels"in this.model.config){for(const t of Object.values(this.model.config.channels))if((0,l.isArray)(t)){for(const i of t)if(null!=t&&!e.includes(i))return!1}else if((0,l.isObject)(t)){for(const i of Object.keys(t))for(const s of t[i])if(null!=t&&!e.includes(s))return!1}else if(null!=t&&!e.includes(t))return!1}else for(const t of m)if(t in this.model.config&&!e.includes(this.model.config[t]))return!1;return!0}config(){let e={...this.model.config};return"channels"in e&&(e.channels={...e.channels}),null!=e.preset&&(e=window.Vizzu.presets[e.preset](e)),e}data(){const e=[];for(const t of this.model.columns){let i=[...this.model.source.get_array(t.name)];"datetime"!==t.type&&"date"!=t.type||(t.type="dimension"),"dimension"===t.type&&(i=i.map(String)),e.push({...t,values:i})}return{series:e}}render(){super.render(),this.container=(0,a.div)({style:{display:"contents"}}),this.shadow_el.append(this.container);const e={config:this.config(),data:this.data(),style:this.model.style};this.vizzu_view=new window.Vizzu(this.container,e),this._animating=!0,this.vizzu_view.initializing.then((e=>{e.on("click",(e=>{this.model.trigger_event(new u({...e.target,...e.detail}))})),e.feature("tooltip",this.model.tooltip),this._animating=!1}))}remove(){this.vizzu_view&&this.vizzu_view.detach(),super.remove()}}i.VizzuChartView=_,_.__name__="VizzuChartView";class f extends d.HTMLBox{constructor(e){super(e)}}i.VizzuChart=f,o=f,f.__name__="VizzuChart",f.__module__="panel.models.vizzu",o.prototype.default_view=_,o.define((({Any:e,List:t,Bool:i,Float:s,Ref:n})=>({animation:[e,{}],config:[e,{}],columns:[t(e),[]],source:[n(c.ColumnDataSource)],duration:[s,500],style:[e,{}],tooltip:[i,!1]})))},
"c51f25e2a7": function _(o,e,V,c,l){c(),l("VTKJSPlot",o("ac55912dc1").VTKJSPlot),l("VTKVolumePlot",o("18592eecef").VTKVolumePlot),l("VTKAxes",o("0379dcf1cd").VTKAxes),l("VTKSynchronizedPlot",o("a4e5946204").VTKSynchronizedPlot)},
"ac55912dc1": function _(e,t,n,s,a){var i;s();const r=e("b06d05fa3e"),l=e("df9946ff52");class _ extends r.AbstractVTKView{connect_signals(){super.connect_signals();const{data:e}=this.model.properties;this.on_change(e,(()=>{this.invalidate_render()}))}render(){super.render(),this._create_orientation_widget(),this._set_axes()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=l.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this._vtk_container,container:this._vtk_container})}plot(){if(null==this.model.data&&null==this.model.data_url)return void this._vtk_renwin.getRenderWindow().render();let e;e=this.model.data_url?l.vtkns.DataAccessHelper.get("http").fetchBinary(this.model.data_url):async()=>{this.model.data},e.then((e=>{const t=l.vtkns.DataAccessHelper.get("zip",{zipContent:e,callback:e=>{const n=l.vtkns.HttpSceneLoader.newInstance({renderer:this._vtk_renwin.getRenderer(),dataAccessHelper:t}),s=window.vtk.macro.debounce((()=>{setTimeout((()=>{null==this._axes&&this.model.axes&&this._set_axes(),this._set_camera_state(),this._get_camera_state(),this._vtk_renwin.getRenderWindow().render()}),100)}),100);n.setUrl("index.json"),n.onReady(s)}})}))}}n.VTKJSPlotView=_,_.__name__="VTKJSPlotView";class d extends r.AbstractVTKPlot{}n.VTKJSPlot=d,i=d,d.__name__="VTKJSPlot",i.prototype.default_view=_,i.define((({Boolean:e,Bytes:t,Nullable:n,String:s})=>({data:[n(t),null],data_url:[n(s),null],enable_keybindings:[e,!1]})))},
"b06d05fa3e": function _(e,t,i,n,s){var a;n();const r=e("@bokehjs/core/dom"),o=e("@bokehjs/core/util/object"),_=e("@bokehjs/models/mappers/color_mapper"),d=e("@bokehjs/core/kinds"),h=e("9b11ce01a3"),c=e("df9946ff52"),l=e("b1d68776a9"),g=e("0379dcf1cd"),m={padding:"0px 2px 0px 2px",maxHeight:"150px",height:"auto",backgroundColor:"rgba(255, 255, 255, 0.4)",borderRadius:"10px",margin:"2px",boxSizing:"border-box",overflow:"hidden",overflowY:"auto",transition:"width 0.1s linear",bottom:"0px",position:"absolute"},p=(0,d.Enum)("LowerLeft","LowerRight","UpperLeft","UpperRight","LowerEdge","RightEdge","LeftEdge","UpperEdge");class v extends h.HTMLBoxView{initialize(){super.initialize(),this._camera_callbacks=[],this._renderable=!0,this._setting_camera=!1,this._rendered=!1}_add_colorbars(){const e=this.shadow_el.querySelector(".vtk_info");if(e&&this.shadow_el.removeChild(e),this.model.color_mappers.length<1)return;const t=document.createElement("div"),i="350px",n="30px";t.classList.add("vtk_info"),(0,c.applyStyle)(t,m),(0,c.applyStyle)(t,{width:i}),this.shadow_el.appendChild(t);const s=[];this.model.color_mappers.forEach((e=>{const i=new l.VTKColorBar(t,e);s.push(i)}));const a=document.createElement("div");(0,c.applyStyle)(a,{textAlign:"center",fontSize:"20px"}),a.innerText="...",t.addEventListener("click",(()=>{t.style.width===n?(t.removeChild(a),(0,c.applyStyle)(t,{height:"auto",width:i}),s.forEach((e=>t.appendChild(e.canvas)))):(s.forEach((e=>t.removeChild(e.canvas))),(0,c.applyStyle)(t,{height:n,width:n}),t.appendChild(a))})),t.click()}_init_annotations_container(){this._annotations_container||(this._annotations_container=document.createElement("div"),this._annotations_container.style.position="absolute",this._annotations_container.style.width="100%",this._annotations_container.style.height="100%",this._annotations_container.style.top="0",this._annotations_container.style.left="0",this._annotations_container.style.pointerEvents="none")}_clean_annotations(){if(this._annotations_container)for(;this._annotations_container.firstElementChild;)this._annotations_container.firstElementChild.remove()}_add_annotations(){this._clean_annotations();const{annotations:e}=this.model;if(null!=e)for(const t of e){const{viewport:e,color:i,fontSize:n,fontFamily:s}=t;p.values.forEach((a=>{const r=t[a];if(r){const t=document.createElement("div");t.textContent=r;const{style:o}=t;o.position="absolute",o.color=`rgb(${i.map((e=>255*e)).join(",")})`,o.fontSize=`${n}px`,o.padding="5px",o.fontFamily=s,o.width="fit-content","UpperLeft"==a&&(o.top=100*(1-e[3])+"%",o.left=100*e[0]+"%"),"UpperRight"==a&&(o.top=100*(1-e[3])+"%",o.right=100*(1-e[2])+"%"),"LowerLeft"==a&&(o.bottom=100*e[1]+"%",o.left=100*e[0]+"%"),"LowerRight"==a&&(o.bottom=100*e[1]+"%",o.right=100*(1-e[2])+"%"),"UpperEdge"==a&&(o.top=100*(1-e[3])+"%",o.left=100*(e[0]+(e[2]-e[0])/2)+"%",o.transform="translateX(-50%)"),"LowerEdge"==a&&(o.bottom=100*e[1]+"%",o.left=100*(e[0]+(e[2]-e[0])/2)+"%",o.transform="translateX(-50%)"),"LeftEdge"==a&&(o.left=100*e[0]+"%",o.top=100*(1-e[3]+(e[3]-e[1])/2)+"%",o.transform="translateY(-50%)"),"RightEdge"==a&&(o.right=100*(1-e[2])+"%",o.top=100*(1-e[3]+(e[3]-e[1])/2)+"%",o.transform="translateY(-50%)"),this._annotations_container.appendChild(t)}}))}}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.orientation_widget,(()=>{this._orientation_widget_visibility(this.model.orientation_widget)})),this.on_change(this.model.properties.camera,(()=>this._set_camera_state())),this.on_change(this.model.properties.axes,(()=>{this._delete_axes(),this.model.axes&&this._set_axes(),this._vtk_render()})),this.on_change(this.model.properties.color_mappers,(()=>this._add_colorbars())),this.on_change(this.model.properties.annotations,(()=>this._add_annotations()))}render(){super.render(),this._rendered=!1,this._orientationWidget=null,this._axes=null,this._vtk_container=(0,r.div)(),this.init_vtk_renwin(),this._init_annotations_container(),(0,h.set_size)(this._vtk_container,this.model),this.shadow_el.appendChild(this._vtk_container),this._vtk_renwin.getInteractor().onEndAnimation((()=>this._get_camera_state())),this._remove_default_key_binding(),this._bind_key_events(),this.plot(),this.model.renderer_el=this._vtk_renwin,this.shadow_el.appendChild(this._annotations_container)}after_layout(){super.after_layout(),this._renderable&&this._vtk_renwin.resize(),this._vtk_render(),this._rendered||(this._add_colorbars(),this._add_annotations(),this._rendered=!0)}invalidate_render(){this._unsubscribe_camera_cb(),super.invalidate_render()}remove(){this._unsubscribe_camera_cb(),window.removeEventListener("resize",this._vtk_renwin.resize),null!=this._orientationWidget&&this._orientationWidget.delete(),this._vtk_renwin.getRenderWindow().getInteractor().delete(),this._vtk_renwin.delete(),super.remove()}get _vtk_camera_state(){const e=this._vtk_renwin.getRenderer().getActiveCamera();let t;return e&&(t=(0,o.clone)(e.get()),delete t.cameraLightTransform,delete t.classHierarchy,delete t.vtkObject,delete t.vtkCamera,delete t.viewPlaneNormal,delete t.flattenedDepIds,delete t.managedInstanceId,delete t.directionOfProjection),t}get _axes_canvas(){let e=this._vtk_container.querySelector(".axes-canvas");return e||(e=(0,r.canvas)({style:{position:"absolute",top:"0",left:"0",width:"100%",height:"100%"}}),e.classList.add("axes-canvas"),this._vtk_container.appendChild(e),this._vtk_renwin.setResizeCallback((()=>{if(this._axes_canvas){const e=this._vtk_container.getBoundingClientRect(),t=Math.floor(e.width*window.devicePixelRatio),i=Math.floor(e.height*window.devicePixelRatio);this._axes_canvas.setAttribute("width",t.toFixed()),this._axes_canvas.setAttribute("height",i.toFixed())}}))),e}_bind_key_events(){this.el.addEventListener("mouseenter",(()=>{const e=this._vtk_renwin.getInteractor();this.model.enable_keybindings&&(document.querySelector("body").addEventListener("keypress",e.handleKeyPress),document.querySelector("body").addEventListener("keydown",e.handleKeyDown),document.querySelector("body").addEventListener("keyup",e.handleKeyUp))})),this.el.addEventListener("mouseleave",(()=>{const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)}))}_create_orientation_widget(){const e=c.vtkns.AxesActor.newInstance();this._orientationWidget=c.vtkns.OrientationMarkerWidget.newInstance({actor:e,interactor:this._vtk_renwin.getInteractor()}),this._orientationWidget.setEnabled(!0),this._orientationWidget.setViewportCorner(c.vtkns.OrientationMarkerWidget.Corners.BOTTOM_RIGHT),this._orientationWidget.setViewportSize(.15),this._orientationWidget.setMinPixelSize(75),this._orientationWidget.setMaxPixelSize(300),this.model.interactive_orientation_widget&&this._make_orientation_widget_interactive(),this._orientation_widget_visibility(this.model.orientation_widget)}_make_orientation_widget_interactive(){this._widgetManager=c.vtkns.WidgetManager.newInstance(),this._widgetManager.setRenderer(this._orientationWidget.getRenderer());const e=this._orientationWidget.getActor(),t=c.vtkns.InteractiveOrientationWidget.newInstance();t.placeWidget(e.getBounds()),t.setBounds(e.getBounds()),t.setPlaceFactor(1);this._widgetManager.addWidget(t).onOrientationChange((({direction:e})=>{const t=this._vtk_renwin.getRenderer().getActiveCamera(),i=t.getFocalPoint(),n=t.getPosition(),s=t.getViewUp(),a=Math.sqrt((n[0]-i[0])**2+(n[1]-i[1])**2+(n[2]-i[2])**2);t.setPosition(i[0]+e[0]*a,i[1]+e[1]*a,i[2]+e[2]*a),e[0]&&t.setViewUp((0,c.majorAxis)(s,1,2)),e[1]&&t.setViewUp((0,c.majorAxis)(s,0,2)),e[2]&&t.setViewUp((0,c.majorAxis)(s,0,1)),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._vtk_render(),this._get_camera_state()}))}_delete_axes(){if(this._axes){Object.keys(this._axes).forEach((e=>{this._vtk_renwin.getRenderer().removeActor(this._axes[e])})),this._axes=null;const e=this._axes_canvas.getContext("2d");e&&e.clearRect(0,0,this._axes_canvas.clientWidth*window.devicePixelRatio,this._axes_canvas.clientHeight*window.devicePixelRatio)}}_get_camera_state(){this._setting_camera||(this._setting_camera=!0,this.model.camera=this._vtk_camera_state,this._setting_camera=!1)}_orientation_widget_visibility(e){this._orientationWidget.setEnabled(e),null!=this._widgetManager&&(e?this._widgetManager.enablePicking():this._widgetManager.disablePicking()),this._vtk_render()}_remove_default_key_binding(){const e=this._vtk_renwin.getInteractor();document.querySelector("body").removeEventListener("keypress",e.handleKeyPress),document.querySelector("body").removeEventListener("keydown",e.handleKeyDown),document.querySelector("body").removeEventListener("keyup",e.handleKeyUp)}_set_axes(){if(this.model.axes&&this._vtk_renwin.getRenderer()){const{psActor:e,axesActor:t,gridActor:i}=this.model.axes.create_axes(this._axes_canvas);this._axes={psActor:e,axesActor:t,gridActor:i},e&&this._vtk_renwin.getRenderer().addActor(e),t&&this._vtk_renwin.getRenderer().addActor(t),i&&this._vtk_renwin.getRenderer().addActor(i)}}_set_camera_state(){this._setting_camera||void 0===this._vtk_renwin.getRenderer()||(this._setting_camera=!0,this.model.camera&&JSON.stringify(this.model.camera)!=JSON.stringify(this._vtk_camera_state)&&this._vtk_renwin.getRenderer().getActiveCamera().set(this.model.camera),this._vtk_renwin.getRenderer().resetCameraClippingRange(),this._setting_camera=!1)}_unsubscribe_camera_cb(){this._camera_callbacks.splice(0,this._camera_callbacks.length).map((e=>e.unsubscribe()))}_vtk_render(){this._renderable&&(this._orientationWidget&&this._orientationWidget.updateMarkerOrientation(),this._vtk_renwin.getRenderWindow().render())}}i.AbstractVTKView=v,v.__name__="AbstractVTKView";class w extends h.HTMLBox{constructor(e){(0,c.setup_vtkns)(),super(e)}getActors(){return this.renderer_el.getRenderer().getActors()}}i.AbstractVTKPlot=w,a=w,w.__name__="AbstractVTKPlot",w.__module__="panel.models.vtk",a.define((({Any:e,Ref:t,Array:i,Boolean:n,Nullable:s})=>({axes:[s(t(g.VTKAxes)),null],camera:[e,{}],color_mappers:[i(t(_.ColorMapper)),[]],orientation_widget:[n,!1],interactive_orientation_widget:[n,!1],annotations:[s(i(e)),null]}))),a.override({height:300,width:300})},
"df9946ff52": function _(e,n,r,t,o){t(),r.setup_vtkns=c,r.applyStyle=function(e,n){Object.keys(n).forEach((r=>{e.style[r]=n[r]}))},r.hexToRGB=function(e){return[parseInt(e.slice(1,3),16)/255,parseInt(e.slice(3,5),16)/255,parseInt(e.slice(5,7),16)/255]},r.rgbToHex=s,r.vtkLutToMapper=function(e){const{scale:n,nodes:t}=e.get("scale","nodes");if(n!==r.vtkns.ColorTransferFunction.Scale.LINEAR)throw new Error("Error transfer function scale not handle");const o=t.map((e=>e.x)),i=Math.min(...o),c=Math.max(...o),l=(0,a.linspace)(i,c,255),p=[0,0,0],d=l.map((n=>(e.getColor(n,p),s(255*p[0],255*p[1],255*p[2]))));return{low:i,high:c,palette:d}},r.data2VTKImageData=function(e){const n=r.vtkns.ImageData.newInstance({spacing:e.spacing});n.setDimensions(e.dims),n.setOrigin(null!=e.origin?e.origin:e.dims.map((e=>e/2)));const t=r.vtkns.DataArray.newInstance({name:"scalars",numberOfComponents:1,values:new r.ARRAY_TYPES[e.dtype](p(atob(e.buffer)))});return n.getPointData().setScalars(t),n},r.majorAxis=function(e,n,r){const t=[0,0,0],o=Math.abs(e[n])>Math.abs(e[r])?n:r,a=e[o]>0?1:-1;return t[o]=a,t},r.cartesian_product=function(...e){return e.reduce(((e,n)=>[...e].flatMap((e=>n.map((n=>[].concat(e,n)))))))};const a=e("@bokehjs/core/util/array"),i=e("@bokehjs/core/kinds");function c(){if(null!=r.vtkns.Actor)return;const e=window.vtk;Object.assign(r.vtkns,{Actor:e.Rendering.Core.vtkActor,AxesActor:e.Rendering.Core.vtkAxesActor,Base64:e.Common.Core.vtkBase64,BoundingBox:e.Common.DataModel.vtkBoundingBox,Camera:e.Rendering.Core.vtkCamera,ColorTransferFunction:e.Rendering.Core.vtkColorTransferFunction,CubeSource:e.Filters.Sources.vtkCubeSource,DataAccessHelper:e.IO.Core.DataAccessHelper,DataArray:e.Common.Core.vtkDataArray,Follower:e.Rendering.Core.vtkFollower,FullScreenRenderWindow:e.Rendering.Misc.vtkFullScreenRenderWindow,Glyph3DMapper:e.Rendering.Core.vtkGlyph3DMapper,HttpSceneLoader:e.IO.Core.vtkHttpSceneLoader,ImageData:e.Common.DataModel.vtkImageData,ImageMapper:e.Rendering.Core.vtkImageMapper,ImageProperty:e.Rendering.Core.vtkImageProperty,ImageSlice:e.Rendering.Core.vtkImageSlice,InteractiveOrientationWidget:e.Widgets.Widgets3D.vtkInteractiveOrientationWidget,InteractorStyleTrackballCamera:e.Interaction.Style.vtkInteractorStyleTrackballCamera,Light:e.Rendering.Core.vtkLight,LineSource:e.Filters.Sources.vtkLineSource,LookupTable:e.Common.Core.vtkLookupTable,macro:e.macro,Mapper:e.Rendering.Core.vtkMapper,OpenGLRenderWindow:e.Rendering.OpenGL.vtkRenderWindow,OrientationMarkerWidget:e.Interaction.Widgets.vtkOrientationMarkerWidget,OutlineFilter:e.Filters.General.vtkOutlineFilter,PiecewiseFunction:e.Common.DataModel.vtkPiecewiseFunction,PixelSpaceCallbackMapper:e.Rendering.Core.vtkPixelSpaceCallbackMapper,PlaneSource:e.Filters.Sources.vtkPlaneSource,PointSource:e.Filters.Sources.vtkPointSource,PolyData:e.Common.DataModel.vtkPolyData,Property:e.Rendering.Core.vtkProperty,Renderer:e.Rendering.Core.vtkRenderer,RenderWindow:e.Rendering.Core.vtkRenderWindow,RenderWindowInteractor:e.Rendering.Core.vtkRenderWindowInteractor,SphereMapper:e.Rendering.Core.vtkSphereMapper,SynchronizableRenderWindow:e.Rendering.Misc.vtkSynchronizableRenderWindow,Texture:e.Rendering.Core.vtkTexture,Volume:e.Rendering.Core.vtkVolume,VolumeController:e.Interaction.UI.vtkVolumeController,VolumeMapper:e.Rendering.Core.vtkVolumeMapper,VolumeProperty:e.Rendering.Core.vtkVolumeProperty,WidgetManager:e.Widgets.Core.vtkWidgetManager});const{vtkObjectManager:n}=r.vtkns.SynchronizableRenderWindow;n.setTypeMapping("vtkVolumeMapper",r.vtkns.VolumeMapper.newInstance,n.oneTimeGenericUpdater),n.setTypeMapping("vtkSmartVolumeMapper",r.vtkns.VolumeMapper.newInstance,n.oneTimeGenericUpdater),n.setTypeMapping("vtkFollower",r.vtkns.Follower.newInstance,n.genericUpdater),n.setTypeMapping("vtkOpenGLGlyph3DMapper",r.vtkns.Glyph3DMapper.newInstance,n.genericUpdater)}function l(e){const n=Math.min(Math.max(Math.round(e),0),255).toString(16);return 2==n.length?n:`0${n}`}function s(e,n,r){return`#${l(e)}${l(n)}${l(r)}`}function p(e){const n=new ArrayBuffer(e.length),r=new Uint8Array(n);for(let n=0,t=e.length;n<t;n++)r[n]=e.charCodeAt(n);return n}r.ARRAY_TYPES={uint8:Uint8Array,int8:Int8Array,uint16:Uint16Array,int16:Int16Array,uint32:Uint32Array,int32:Int32Array,float32:Float32Array,float64:Float64Array},r.vtkns={},window.vtk&&c(),r.Interpolation=(0,i.Enum)("fast_linear","linear","nearest")},
"b1d68776a9": function _(t,i,e,s,h){s();const a=t("@bokehjs/models/mappers"),n=t("@bokehjs/core/util/array");class c{constructor(t,i,e={}){this.parent=t,this.mapper=i,this.options=e,e.ticksNum||(e.ticksNum=5),e.fontFamily||(e.fontFamily="Arial"),e.fontSize||(e.fontSize="12px"),e.ticksSize||(e.ticksSize=2),this.canvas=document.createElement("canvas"),this.canvas.style.width="100%",this.parent.appendChild(this.canvas),this.ctx=this.canvas.getContext("2d"),this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`,this.ctx.lineWidth=e.ticksSize,e.height||(e.height=4*(this.font_height+1)+"px"),this.canvas.style.height=e.height,this.draw_colorbar()}get values(){const{min:t,max:i}=this.mapper.metrics;return(0,n.linspace)(t,i,this.options.ticksNum)}get ticks(){return this.values.map((t=>t.toExponential(3)))}get title(){return this.mapper.name??"scalars"}get font_height(){let t=0;return this.values.forEach((i=>{const{actualBoundingBoxAscent:e,actualBoundingBoxDescent:s}=this.ctx.measureText(`${i}`),h=e+s;t<h&&(t=h)})),t}draw_colorbar(){this.canvas.width=this.canvas.clientWidth,this.canvas.height=this.canvas.clientHeight;const{palette:t}=this.mapper;this.ctx.font=`${this.options.fontSize} ${this.options.fontFamily}`;const i=this.font_height;this.ctx.save();const e=document.createElement("canvas"),s=t.length;e.width=s,e.height=1;const h=e.getContext("2d"),c=h.getImageData(0,0,s,1),o=new a.LinearColorMapper({palette:t}).rgba_mapper.v_compute((0,n.range)(0,t.length));c.data.set(o),h.putImageData(c,0,0),this.ctx.drawImage(e,0,2*(this.font_height+1)+1,this.canvas.width,this.canvas.height),this.ctx.restore(),this.ctx.save(),this.ctx.textAlign="center",this.ctx.fillText(this.title,this.canvas.width/2,i+1),this.ctx.restore(),this.ctx.save();const r=(0,n.linspace)(0,this.canvas.width,5);r.forEach(((t,e)=>{let s=t;0==e?(s=t+Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="left"):e==r.length-1?(s=t-Math.ceil(this.ctx.lineWidth/2),this.ctx.textAlign="right"):this.ctx.textAlign="center",this.ctx.moveTo(s,2*(i+1)),this.ctx.lineTo(s,2*(i+1)+5),this.ctx.stroke(),this.ctx.fillText(`${this.ticks[e]}`,t,2*(i+1))})),this.ctx.restore()}}e.VTKColorBar=c,c.__name__="VTKColorBar"},
"0379dcf1cd": function _(t,i,s,e,n){var a;e();const r=t("@bokehjs/model"),c=t("2f3fd5db07"),l=t("df9946ff52");class h extends r.Model{constructor(t){super(t)}get xticks(){return this.xticker?this.xticker.ticks:[]}get yticks(){return this.yticker?this.yticker.ticks:[]}get zticks(){return this.zticker?this.zticker.ticks:[]}get xlabels(){return this.xticker?.labels?this.xticker.labels:this.xticks.map((t=>t.toFixed(this.digits)))}get ylabels(){return this.yticker?.labels?this.yticker.labels:this.yticks.map((t=>t.toFixed(this.digits)))}get zlabels(){return this.zticker?.labels?this.zticker.labels:this.zticks.map((t=>t.toFixed(this.digits)))}_make_grid_lines(t,i,s){const e=[];for(let n=0;n<t-1;n++)for(let t=0;t<i-1;t++){const a=n*i+t+s,r=[5,a,n*i+t+1+s,(n+1)*i+t+1+s,(n+1)*i+t+s,a];e.push(r)}return e}_create_grid_axes(){const t=[];t.push((0,l.cartesian_product)(this.xticks,this.yticks,[this.origin[2]])),t.push((0,l.cartesian_product)([this.origin[0]],this.yticks,this.zticks)),t.push((0,l.cartesian_product)(this.xticks,[this.origin[1]],this.zticks));const i=[];let s=0;i.push(this._make_grid_lines(this.xticks.length,this.yticks.length,s)),s+=this.xticks.length*this.yticks.length,i.push(this._make_grid_lines(this.yticks.length,this.zticks.length,s)),s+=this.yticks.length*this.zticks.length,i.push(this._make_grid_lines(this.xticks.length,this.zticks.length,s));const e=window.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:t.flat(2)},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:i.flat(2)}}),n=l.vtkns.Mapper.newInstance(),a=l.vtkns.Actor.newInstance();return n.setInputData(e),a.setMapper(n),a.getProperty().setOpacity(this.grid_opacity),a.setVisibility(this.show_grid),a}create_axes(t){if(null==this.origin)return{psActor:null,axesActor:null,gridActor:null};const i=[this.xticks,this.yticks,this.zticks].map(((t,i)=>{let s=null;switch(i){case 0:s=(0,l.cartesian_product)(t,[this.origin[1]],[this.origin[2]]);break;case 1:s=(0,l.cartesian_product)([this.origin[0]],t,[this.origin[2]]);break;case 2:s=(0,l.cartesian_product)([this.origin[0]],[this.origin[1]],t)}return s})).flat(2),s=window.vtk({vtkClass:"vtkPolyData",points:{vtkClass:"vtkPoints",dataType:"Float32Array",numberOfComponents:3,values:i},lines:{vtkClass:"vtkCellArray",dataType:"Uint32Array",values:[2,0,this.xticks.length-1,2,this.xticks.length,this.xticks.length+this.yticks.length-1,2,this.xticks.length+this.yticks.length,this.xticks.length+this.yticks.length+this.zticks.length-1]}}),e=l.vtkns.PixelSpaceCallbackMapper.newInstance();e.setInputData(s),e.setUseZValues(!0),e.setCallback(((i,s,n)=>{const a=t.getContext("2d");if(a){const r={height:t.clientHeight*window.devicePixelRatio,width:t.clientWidth*window.devicePixelRatio},l=e.getInputData().getPoints(),h=s.getViewMatrix();c.mat4.transpose(h,h);const o=s.getProjectionMatrix(n,-1,1);c.mat4.transpose(o,o),a.clearRect(0,0,r.width,r.height),i.forEach(((t,i)=>{const s=l.getPoint(i),e=c.vec3.fromValues(s[0],s[1],s[2]);if(c.vec3.transformMat4(e,e,h),e[2]+=.05,c.vec3.transformMat4(e,e,o),e[2]-.001<t[3]){let s;a.font="30px serif",a.textAlign="center",a.textBaseline="alphabetic",a.fillText(".",t[0],r.height-t[1]+2),a.font=this.fontsize*window.devicePixelRatio+"px serif",a.textAlign="right",a.textBaseline="top",s=i<this.xticks.length?this.xlabels[i]:i>=this.xticks.length&&i<this.xticks.length+this.yticks.length?this.ylabels[i-this.xticks.length]:this.zlabels[i-(this.xticks.length+this.yticks.length)],a.fillText(`${s}`,t[0],r.height-t[1])}}))}}));const n=l.vtkns.Actor.newInstance();n.setMapper(e);const a=l.vtkns.Mapper.newInstance();a.setInputData(s);const r=l.vtkns.Actor.newInstance();r.setMapper(a),r.getProperty().setOpacity(this.axes_opacity);return{psActor:n,axesActor:r,gridActor:this._create_grid_axes()}}}s.VTKAxes=h,a=h,h.__name__="VTKAxes",h.__module__="panel.models.vtk",a.define((({Any:t,Array:i,Boolean:s,Number:e})=>({origin:[i(e),[0,0,0]],xticker:[t,null],yticker:[t,null],zticker:[t,null],digits:[e,1],show_grid:[s,!0],grid_opacity:[e,.1],axes_opacity:[e,1],fontsize:[e,12]})))},
"2f3fd5db07": function _(t,a,c,o,r){o();const _=t("tslib"),m=_.__importStar(t("7d825b979e"));c.glMatrix=m;const i=_.__importStar(t("d77e165b60"));c.mat2=i;const n=_.__importStar(t("33a5f6cb7a"));c.mat2d=n;const s=_.__importStar(t("a025ef02dc"));c.mat3=s;const p=_.__importStar(t("83bad9e639"));c.mat4=p;const S=_.__importStar(t("f83fe7c413"));c.quat=S;const b=_.__importStar(t("fb9294db61"));c.quat2=b;const d=_.__importStar(t("58c71a9bd3"));c.vec2=d;const e=_.__importStar(t("63eddc5433"));c.vec3=e;const f=_.__importStar(t("11562bccc5"));c.vec4=f},
"7d825b979e": function _(t,a,r,n,o){n(),r.setMatrixArrayType=function(t){r.ARRAY_TYPE=t},r.toRadian=function(t){return t*h},r.equals=function(t,a){return Math.abs(t-a)<=r.EPSILON*Math.max(1,Math.abs(t),Math.abs(a))},r.EPSILON=1e-6,r.ARRAY_TYPE="undefined"!=typeof Float32Array?Float32Array:Array,r.RANDOM=Math.random;var h=Math.PI/180;Math.hypot||(Math.hypot=function(){for(var t=0,a=arguments.length;a--;)t+=arguments[a]*arguments[a];return Math.sqrt(t)})},
"d77e165b60": function _(t,n,r,a,u){a(),r.create=function(){var t=new e.ARRAY_TYPE(4);e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0);return t[0]=1,t[3]=1,t},r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.transpose=function(t,n){if(t===n){var r=n[1];t[1]=n[2],t[2]=r}else t[0]=n[0],t[1]=n[2],t[2]=n[1],t[3]=n[3];return t},r.invert=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*e-u*a;if(!o)return null;return o=1/o,t[0]=e*o,t[1]=-a*o,t[2]=-u*o,t[3]=r*o,t},r.adjoint=function(t,n){var r=n[0];return t[0]=n[3],t[1]=-n[1],t[2]=-n[2],t[3]=r,t},r.determinant=function(t){return t[0]*t[3]-t[2]*t[1]},r.multiply=o,r.rotate=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],i=Math.sin(r),c=Math.cos(r);return t[0]=a*c+e*i,t[1]=u*c+o*i,t[2]=a*-i+e*c,t[3]=u*-i+o*c,t},r.scale=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],i=r[0],c=r[1];return t[0]=a*i,t[1]=u*i,t[2]=e*c,t[3]=o*c,t},r.fromRotation=function(t,n){var r=Math.sin(n),a=Math.cos(n);return t[0]=a,t[1]=r,t[2]=-r,t[3]=a,t},r.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t},r.str=function(t){return"mat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},r.LDU=function(t,n,r,a){return t[2]=a[2]/a[0],r[0]=a[0],r[1]=a[1],r[3]=a[3]-t[2]*r[1],[t,n,r]},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=i,r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],i=n[0],c=n[1],f=n[2],s=n[3];return Math.abs(r-i)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(i))&&Math.abs(a-c)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(c))&&Math.abs(u-f)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(f))&&Math.abs(o-s)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(s))},r.multiplyScalar=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.multiplyScalarAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t};const e=t("tslib").__importStar(t("7d825b979e"));function o(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3],i=r[0],c=r[1],f=r[2],s=r[3];return t[0]=a*i+e*c,t[1]=u*i+o*c,t[2]=a*f+e*s,t[3]=u*f+o*s,t}function i(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}r.mul=o,r.sub=i},
"33a5f6cb7a": function _(t,n,a,r,u){r(),a.create=function(){var t=new e.ARRAY_TYPE(6);e.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[4]=0,t[5]=0);return t[0]=1,t[3]=1,t},a.clone=function(t){var n=new e.ARRAY_TYPE(6);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n[4]=t[4],n[5]=t[5],n},a.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t[4]=n[4],t[5]=n[5],t},a.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t},a.fromValues=function(t,n,a,r,u,o){var i=new e.ARRAY_TYPE(6);return i[0]=t,i[1]=n,i[2]=a,i[3]=r,i[4]=u,i[5]=o,i},a.set=function(t,n,a,r,u,e,o){return t[0]=n,t[1]=a,t[2]=r,t[3]=u,t[4]=e,t[5]=o,t},a.invert=function(t,n){var a=n[0],r=n[1],u=n[2],e=n[3],o=n[4],i=n[5],c=a*e-r*u;if(!c)return null;return c=1/c,t[0]=e*c,t[1]=-r*c,t[2]=-u*c,t[3]=a*c,t[4]=(u*i-e*o)*c,t[5]=(r*o-a*i)*c,t},a.determinant=function(t){return t[0]*t[3]-t[1]*t[2]},a.multiply=o,a.rotate=function(t,n,a){var r=n[0],u=n[1],e=n[2],o=n[3],i=n[4],c=n[5],s=Math.sin(a),f=Math.cos(a);return t[0]=r*f+e*s,t[1]=u*f+o*s,t[2]=r*-s+e*f,t[3]=u*-s+o*f,t[4]=i,t[5]=c,t},a.scale=function(t,n,a){var r=n[0],u=n[1],e=n[2],o=n[3],i=n[4],c=n[5],s=a[0],f=a[1];return t[0]=r*s,t[1]=u*s,t[2]=e*f,t[3]=o*f,t[4]=i,t[5]=c,t},a.translate=function(t,n,a){var r=n[0],u=n[1],e=n[2],o=n[3],i=n[4],c=n[5],s=a[0],f=a[1];return t[0]=r,t[1]=u,t[2]=e,t[3]=o,t[4]=r*s+e*f+i,t[5]=u*s+o*f+c,t},a.fromRotation=function(t,n){var a=Math.sin(n),r=Math.cos(n);return t[0]=r,t[1]=a,t[2]=-a,t[3]=r,t[4]=0,t[5]=0,t},a.fromScaling=function(t,n){return t[0]=n[0],t[1]=0,t[2]=0,t[3]=n[1],t[4]=0,t[5]=0,t},a.fromTranslation=function(t,n){return t[0]=1,t[1]=0,t[2]=0,t[3]=1,t[4]=n[0],t[5]=n[1],t},a.str=function(t){return"mat2d("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+")"},a.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],1)},a.add=function(t,n,a){return t[0]=n[0]+a[0],t[1]=n[1]+a[1],t[2]=n[2]+a[2],t[3]=n[3]+a[3],t[4]=n[4]+a[4],t[5]=n[5]+a[5],t},a.subtract=i,a.multiplyScalar=function(t,n,a){return t[0]=n[0]*a,t[1]=n[1]*a,t[2]=n[2]*a,t[3]=n[3]*a,t[4]=n[4]*a,t[5]=n[5]*a,t},a.multiplyScalarAndAdd=function(t,n,a,r){return t[0]=n[0]+a[0]*r,t[1]=n[1]+a[1]*r,t[2]=n[2]+a[2]*r,t[3]=n[3]+a[3]*r,t[4]=n[4]+a[4]*r,t[5]=n[5]+a[5]*r,t},a.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]&&t[4]===n[4]&&t[5]===n[5]},a.equals=function(t,n){var a=t[0],r=t[1],u=t[2],o=t[3],i=t[4],c=t[5],s=n[0],f=n[1],h=n[2],M=n[3],b=n[4],l=n[5];return Math.abs(a-s)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(s))&&Math.abs(r-f)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(f))&&Math.abs(u-h)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(h))&&Math.abs(o-M)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))&&Math.abs(i-b)<=e.EPSILON*Math.max(1,Math.abs(i),Math.abs(b))&&Math.abs(c-l)<=e.EPSILON*Math.max(1,Math.abs(c),Math.abs(l))};const e=t("tslib").__importStar(t("7d825b979e"));function o(t,n,a){var r=n[0],u=n[1],e=n[2],o=n[3],i=n[4],c=n[5],s=a[0],f=a[1],h=a[2],M=a[3],b=a[4],l=a[5];return t[0]=r*s+e*f,t[1]=u*s+o*f,t[2]=r*h+e*M,t[3]=u*h+o*M,t[4]=r*b+e*l+i,t[5]=u*b+o*l+c,t}function i(t,n,a){return t[0]=n[0]-a[0],t[1]=n[1]-a[1],t[2]=n[2]-a[2],t[3]=n[3]-a[3],t[4]=n[4]-a[4],t[5]=n[5]-a[5],t}a.mul=o,a.sub=i},
"a025ef02dc": function _(t,a,n,r,u){r(),n.create=function(){var t=new o.ARRAY_TYPE(9);o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0);return t[0]=1,t[4]=1,t[8]=1,t},n.fromMat4=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[4],t[4]=a[5],t[5]=a[6],t[6]=a[8],t[7]=a[9],t[8]=a[10],t},n.clone=function(t){var a=new o.ARRAY_TYPE(9);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromValues=function(t,a,n,r,u,e,i,s,c){var M=new o.ARRAY_TYPE(9);return M[0]=t,M[1]=a,M[2]=n,M[3]=r,M[4]=u,M[5]=e,M[6]=i,M[7]=s,M[8]=c,M},n.set=function(t,a,n,r,u,o,e,i,s,c){return t[0]=a,t[1]=n,t[2]=r,t[3]=u,t[4]=o,t[5]=e,t[6]=i,t[7]=s,t[8]=c,t},n.identity=function(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],u=a[5];t[1]=a[3],t[2]=a[6],t[3]=n,t[5]=a[7],t[6]=r,t[7]=u}else t[0]=a[0],t[1]=a[3],t[2]=a[6],t[3]=a[1],t[4]=a[4],t[5]=a[7],t[6]=a[2],t[7]=a[5],t[8]=a[8];return t},n.invert=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],s=a[6],c=a[7],M=a[8],f=M*e-i*c,h=-M*o+i*s,b=c*o-e*s,l=n*f+r*h+u*b;if(!l)return null;return l=1/l,t[0]=f*l,t[1]=(-M*r+u*c)*l,t[2]=(i*r-u*e)*l,t[3]=h*l,t[4]=(M*n-u*s)*l,t[5]=(-i*n+u*o)*l,t[6]=b*l,t[7]=(-c*n+r*s)*l,t[8]=(e*n-r*o)*l,t},n.adjoint=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],s=a[6],c=a[7],M=a[8];return t[0]=e*M-i*c,t[1]=u*c-r*M,t[2]=r*i-u*e,t[3]=i*s-o*M,t[4]=n*M-u*s,t[5]=u*o-n*i,t[6]=o*c-e*s,t[7]=r*s-n*c,t[8]=n*e-r*o,t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],u=t[3],o=t[4],e=t[5],i=t[6],s=t[7],c=t[8];return a*(c*o-e*s)+n*(-c*u+e*i)+r*(s*u-o*i)},n.multiply=e,n.translate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],s=a[5],c=a[6],M=a[7],f=a[8],h=n[0],b=n[1];return t[0]=r,t[1]=u,t[2]=o,t[3]=e,t[4]=i,t[5]=s,t[6]=h*r+b*e+c,t[7]=h*u+b*i+M,t[8]=h*o+b*s+f,t},n.rotate=function(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],s=a[5],c=a[6],M=a[7],f=a[8],h=Math.sin(n),b=Math.cos(n);return t[0]=b*r+h*e,t[1]=b*u+h*i,t[2]=b*o+h*s,t[3]=b*e-h*r,t[4]=b*i-h*u,t[5]=b*s-h*o,t[6]=c,t[7]=M,t[8]=f,t},n.scale=function(t,a,n){var r=n[0],u=n[1];return t[0]=r*a[0],t[1]=r*a[1],t[2]=r*a[2],t[3]=u*a[3],t[4]=u*a[4],t[5]=u*a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=1,t[5]=0,t[6]=a[0],t[7]=a[1],t[8]=1,t},n.fromRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=-n,t[4]=r,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=a[1],t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},n.fromMat2d=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=0,t[3]=a[2],t[4]=a[3],t[5]=0,t[6]=a[4],t[7]=a[5],t[8]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=n+n,i=r+r,s=u+u,c=n*e,M=r*e,f=r*i,h=u*e,b=u*i,l=u*s,m=o*e,v=o*i,E=o*s;return t[0]=1-f-l,t[3]=M-E,t[6]=h+v,t[1]=M+E,t[4]=1-c-l,t[7]=b-m,t[2]=h-v,t[5]=b+m,t[8]=1-c-f,t},n.normalFromMat4=function(t,a){var n=a[0],r=a[1],u=a[2],o=a[3],e=a[4],i=a[5],s=a[6],c=a[7],M=a[8],f=a[9],h=a[10],b=a[11],l=a[12],m=a[13],v=a[14],E=a[15],P=n*i-r*e,S=n*s-u*e,A=n*c-o*e,d=r*s-u*i,x=r*c-o*i,I=u*c-o*s,L=M*m-f*l,N=M*v-h*l,O=M*E-b*l,R=f*v-h*m,p=f*E-b*m,Y=h*E-b*v,y=P*Y-S*p+A*R+d*O-x*N+I*L;if(!y)return null;return y=1/y,t[0]=(i*Y-s*p+c*R)*y,t[1]=(s*O-e*Y-c*N)*y,t[2]=(e*p-i*O+c*L)*y,t[3]=(u*p-r*Y-o*R)*y,t[4]=(n*Y-u*O+o*N)*y,t[5]=(r*O-n*p-o*L)*y,t[6]=(m*I-v*x+E*d)*y,t[7]=(v*A-l*I-E*S)*y,t[8]=(l*x-m*A+E*P)*y,t},n.projection=function(t,a,n){return t[0]=2/a,t[1]=0,t[2]=0,t[3]=0,t[4]=-2/n,t[5]=0,t[6]=-1,t[7]=1,t[8]=1,t},n.str=function(t){return"mat3("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t},n.subtract=i,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]},n.equals=function(t,a){var n=t[0],r=t[1],u=t[2],e=t[3],i=t[4],s=t[5],c=t[6],M=t[7],f=t[8],h=a[0],b=a[1],l=a[2],m=a[3],v=a[4],E=a[5],P=a[6],S=a[7],A=a[8];return Math.abs(n-h)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(h))&&Math.abs(r-b)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(e-m)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(m))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(s-E)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(E))&&Math.abs(c-P)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(P))&&Math.abs(M-S)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(S))&&Math.abs(f-A)<=o.EPSILON*Math.max(1,Math.abs(f),Math.abs(A))};const o=t("tslib").__importStar(t("7d825b979e"));function e(t,a,n){var r=a[0],u=a[1],o=a[2],e=a[3],i=a[4],s=a[5],c=a[6],M=a[7],f=a[8],h=n[0],b=n[1],l=n[2],m=n[3],v=n[4],E=n[5],P=n[6],S=n[7],A=n[8];return t[0]=h*r+b*e+l*c,t[1]=h*u+b*i+l*M,t[2]=h*o+b*s+l*f,t[3]=m*r+v*e+E*c,t[4]=m*u+v*i+E*M,t[5]=m*o+v*s+E*f,t[6]=P*r+S*e+A*c,t[7]=P*u+S*i+A*M,t[8]=P*o+S*s+A*f,t}function i(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t}n.mul=e,n.sub=i},
"83bad9e639": function _(t,a,n,r,h){r(),n.create=function(){var t=new o.ARRAY_TYPE(16);o.ARRAY_TYPE!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0);return t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(16);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a[8]=t[8],a[9]=t[9],a[10]=t[10],a[11]=t[11],a[12]=t[12],a[13]=t[13],a[14]=t[14],a[15]=t[15],a},n.copy=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.fromValues=function(t,a,n,r,h,u,e,M,s,i,c,f,b,v,l,m){var P=new o.ARRAY_TYPE(16);return P[0]=t,P[1]=a,P[2]=n,P[3]=r,P[4]=h,P[5]=u,P[6]=e,P[7]=M,P[8]=s,P[9]=i,P[10]=c,P[11]=f,P[12]=b,P[13]=v,P[14]=l,P[15]=m,P},n.set=function(t,a,n,r,h,o,u,e,M,s,i,c,f,b,v,l,m){return t[0]=a,t[1]=n,t[2]=r,t[3]=h,t[4]=o,t[5]=u,t[6]=e,t[7]=M,t[8]=s,t[9]=i,t[10]=c,t[11]=f,t[12]=b,t[13]=v,t[14]=l,t[15]=m,t},n.identity=u,n.transpose=function(t,a){if(t===a){var n=a[1],r=a[2],h=a[3],o=a[6],u=a[7],e=a[11];t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=n,t[6]=a[9],t[7]=a[13],t[8]=r,t[9]=o,t[11]=a[14],t[12]=h,t[13]=u,t[14]=e}else t[0]=a[0],t[1]=a[4],t[2]=a[8],t[3]=a[12],t[4]=a[1],t[5]=a[5],t[6]=a[9],t[7]=a[13],t[8]=a[2],t[9]=a[6],t[10]=a[10],t[11]=a[14],t[12]=a[3],t[13]=a[7],t[14]=a[11],t[15]=a[15];return t},n.invert=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],e=a[5],M=a[6],s=a[7],i=a[8],c=a[9],f=a[10],b=a[11],v=a[12],l=a[13],m=a[14],P=a[15],E=n*e-r*u,S=n*M-h*u,O=n*s-o*u,I=r*M-h*e,p=r*s-o*e,N=h*s-o*M,L=i*l-c*v,R=i*m-f*v,x=i*P-b*v,A=c*m-f*l,y=c*P-b*l,Y=f*P-b*m,g=E*Y-S*y+O*A+I*x-p*R+N*L;if(!g)return null;return g=1/g,t[0]=(e*Y-M*y+s*A)*g,t[1]=(h*y-r*Y-o*A)*g,t[2]=(l*N-m*p+P*I)*g,t[3]=(f*p-c*N-b*I)*g,t[4]=(M*x-u*Y-s*R)*g,t[5]=(n*Y-h*x+o*R)*g,t[6]=(m*O-v*N-P*S)*g,t[7]=(i*N-f*O+b*S)*g,t[8]=(u*y-e*x+s*L)*g,t[9]=(r*x-n*y-o*L)*g,t[10]=(v*p-l*O+P*E)*g,t[11]=(c*O-i*p-b*E)*g,t[12]=(e*R-u*A-M*L)*g,t[13]=(n*A-r*R+h*L)*g,t[14]=(l*S-v*I-m*E)*g,t[15]=(i*I-c*S+f*E)*g,t},n.adjoint=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=a[4],e=a[5],M=a[6],s=a[7],i=a[8],c=a[9],f=a[10],b=a[11],v=a[12],l=a[13],m=a[14],P=a[15];return t[0]=e*(f*P-b*m)-c*(M*P-s*m)+l*(M*b-s*f),t[1]=-(r*(f*P-b*m)-c*(h*P-o*m)+l*(h*b-o*f)),t[2]=r*(M*P-s*m)-e*(h*P-o*m)+l*(h*s-o*M),t[3]=-(r*(M*b-s*f)-e*(h*b-o*f)+c*(h*s-o*M)),t[4]=-(u*(f*P-b*m)-i*(M*P-s*m)+v*(M*b-s*f)),t[5]=n*(f*P-b*m)-i*(h*P-o*m)+v*(h*b-o*f),t[6]=-(n*(M*P-s*m)-u*(h*P-o*m)+v*(h*s-o*M)),t[7]=n*(M*b-s*f)-u*(h*b-o*f)+i*(h*s-o*M),t[8]=u*(c*P-b*l)-i*(e*P-s*l)+v*(e*b-s*c),t[9]=-(n*(c*P-b*l)-i*(r*P-o*l)+v*(r*b-o*c)),t[10]=n*(e*P-s*l)-u*(r*P-o*l)+v*(r*s-o*e),t[11]=-(n*(e*b-s*c)-u*(r*b-o*c)+i*(r*s-o*e)),t[12]=-(u*(c*m-f*l)-i*(e*m-M*l)+v*(e*f-M*c)),t[13]=n*(c*m-f*l)-i*(r*m-h*l)+v*(r*f-h*c),t[14]=-(n*(e*m-M*l)-u*(r*m-h*l)+v*(r*M-h*e)),t[15]=n*(e*f-M*c)-u*(r*f-h*c)+i*(r*M-h*e),t},n.determinant=function(t){var a=t[0],n=t[1],r=t[2],h=t[3],o=t[4],u=t[5],e=t[6],M=t[7],s=t[8],i=t[9],c=t[10],f=t[11],b=t[12],v=t[13],l=t[14],m=t[15];return(a*u-n*o)*(c*m-f*l)-(a*e-r*o)*(i*m-f*v)+(a*M-h*o)*(i*l-c*v)+(n*e-r*u)*(s*m-f*b)-(n*M-h*u)*(s*l-c*b)+(r*M-h*e)*(s*v-i*b)},n.multiply=e,n.translate=function(t,a,n){var r,h,o,u,e,M,s,i,c,f,b,v,l=n[0],m=n[1],P=n[2];a===t?(t[12]=a[0]*l+a[4]*m+a[8]*P+a[12],t[13]=a[1]*l+a[5]*m+a[9]*P+a[13],t[14]=a[2]*l+a[6]*m+a[10]*P+a[14],t[15]=a[3]*l+a[7]*m+a[11]*P+a[15]):(r=a[0],h=a[1],o=a[2],u=a[3],e=a[4],M=a[5],s=a[6],i=a[7],c=a[8],f=a[9],b=a[10],v=a[11],t[0]=r,t[1]=h,t[2]=o,t[3]=u,t[4]=e,t[5]=M,t[6]=s,t[7]=i,t[8]=c,t[9]=f,t[10]=b,t[11]=v,t[12]=r*l+e*m+c*P+a[12],t[13]=h*l+M*m+f*P+a[13],t[14]=o*l+s*m+b*P+a[14],t[15]=u*l+i*m+v*P+a[15]);return t},n.scale=function(t,a,n){var r=n[0],h=n[1],o=n[2];return t[0]=a[0]*r,t[1]=a[1]*r,t[2]=a[2]*r,t[3]=a[3]*r,t[4]=a[4]*h,t[5]=a[5]*h,t[6]=a[6]*h,t[7]=a[7]*h,t[8]=a[8]*o,t[9]=a[9]*o,t[10]=a[10]*o,t[11]=a[11]*o,t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15],t},n.rotate=function(t,a,n,r){var h,u,e,M,s,i,c,f,b,v,l,m,P,E,S,O,I,p,N,L,R,x,A,y,Y=r[0],g=r[1],T=r[2],d=Math.hypot(Y,g,T);if(d<o.EPSILON)return null;Y*=d=1/d,g*=d,T*=d,h=Math.sin(n),u=Math.cos(n),e=1-u,M=a[0],s=a[1],i=a[2],c=a[3],f=a[4],b=a[5],v=a[6],l=a[7],m=a[8],P=a[9],E=a[10],S=a[11],O=Y*Y*e+u,I=g*Y*e+T*h,p=T*Y*e-g*h,N=Y*g*e-T*h,L=g*g*e+u,R=T*g*e+Y*h,x=Y*T*e+g*h,A=g*T*e-Y*h,y=T*T*e+u,t[0]=M*O+f*I+m*p,t[1]=s*O+b*I+P*p,t[2]=i*O+v*I+E*p,t[3]=c*O+l*I+S*p,t[4]=M*N+f*L+m*R,t[5]=s*N+b*L+P*R,t[6]=i*N+v*L+E*R,t[7]=c*N+l*L+S*R,t[8]=M*x+f*A+m*y,t[9]=s*x+b*A+P*y,t[10]=i*x+v*A+E*y,t[11]=c*x+l*A+S*y,a!==t&&(t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]);return t},n.rotateX=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[4],u=a[5],e=a[6],M=a[7],s=a[8],i=a[9],c=a[10],f=a[11];a!==t&&(t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]);return t[4]=o*h+s*r,t[5]=u*h+i*r,t[6]=e*h+c*r,t[7]=M*h+f*r,t[8]=s*h-o*r,t[9]=i*h-u*r,t[10]=c*h-e*r,t[11]=f*h-M*r,t},n.rotateY=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],e=a[2],M=a[3],s=a[8],i=a[9],c=a[10],f=a[11];a!==t&&(t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]);return t[0]=o*h-s*r,t[1]=u*h-i*r,t[2]=e*h-c*r,t[3]=M*h-f*r,t[8]=o*r+s*h,t[9]=u*r+i*h,t[10]=e*r+c*h,t[11]=M*r+f*h,t},n.rotateZ=function(t,a,n){var r=Math.sin(n),h=Math.cos(n),o=a[0],u=a[1],e=a[2],M=a[3],s=a[4],i=a[5],c=a[6],f=a[7];a!==t&&(t[8]=a[8],t[9]=a[9],t[10]=a[10],t[11]=a[11],t[12]=a[12],t[13]=a[13],t[14]=a[14],t[15]=a[15]);return t[0]=o*h+s*r,t[1]=u*h+i*r,t[2]=e*h+c*r,t[3]=M*h+f*r,t[4]=s*h-o*r,t[5]=i*h-u*r,t[6]=c*h-e*r,t[7]=f*h-M*r,t},n.fromTranslation=function(t,a){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=a[0],t[13]=a[1],t[14]=a[2],t[15]=1,t},n.fromScaling=function(t,a){return t[0]=a[0],t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a[1],t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=a[2],t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotation=function(t,a,n){var r,h,u,e=n[0],M=n[1],s=n[2],i=Math.hypot(e,M,s);if(i<o.EPSILON)return null;return e*=i=1/i,M*=i,s*=i,r=Math.sin(a),h=Math.cos(a),u=1-h,t[0]=e*e*u+h,t[1]=M*e*u+s*r,t[2]=s*e*u-M*r,t[3]=0,t[4]=e*M*u-s*r,t[5]=M*M*u+h,t[6]=s*M*u+e*r,t[7]=0,t[8]=e*s*u+M*r,t[9]=M*s*u-e*r,t[10]=s*s*u+h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromXRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=r,t[6]=n,t[7]=0,t[8]=0,t[9]=-n,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromYRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=0,t[2]=-n,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=n,t[9]=0,t[10]=r,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromZRotation=function(t,a){var n=Math.sin(a),r=Math.cos(a);return t[0]=r,t[1]=n,t[2]=0,t[3]=0,t[4]=-n,t[5]=r,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.fromRotationTranslation=M,n.fromQuat2=function(t,a){var n=new o.ARRAY_TYPE(3),r=-a[0],h=-a[1],u=-a[2],e=a[3],s=a[4],i=a[5],c=a[6],f=a[7],b=r*r+h*h+u*u+e*e;b>0?(n[0]=2*(s*e+f*r+i*u-c*h)/b,n[1]=2*(i*e+f*h+c*r-s*u)/b,n[2]=2*(c*e+f*u+s*h-i*r)/b):(n[0]=2*(s*e+f*r+i*u-c*h),n[1]=2*(i*e+f*h+c*r-s*u),n[2]=2*(c*e+f*u+s*h-i*r));return M(t,a,n),t},n.getTranslation=function(t,a){return t[0]=a[12],t[1]=a[13],t[2]=a[14],t},n.getScaling=s,n.getRotation=function(t,a){var n=new o.ARRAY_TYPE(3);s(n,a);var r=1/n[0],h=1/n[1],u=1/n[2],e=a[0]*r,M=a[1]*h,i=a[2]*u,c=a[4]*r,f=a[5]*h,b=a[6]*u,v=a[8]*r,l=a[9]*h,m=a[10]*u,P=e+f+m,E=0;P>0?(E=2*Math.sqrt(P+1),t[3]=.25*E,t[0]=(b-l)/E,t[1]=(v-i)/E,t[2]=(M-c)/E):e>f&&e>m?(E=2*Math.sqrt(1+e-f-m),t[3]=(b-l)/E,t[0]=.25*E,t[1]=(M+c)/E,t[2]=(v+i)/E):f>m?(E=2*Math.sqrt(1+f-e-m),t[3]=(v-i)/E,t[0]=(M+c)/E,t[1]=.25*E,t[2]=(b+l)/E):(E=2*Math.sqrt(1+m-e-f),t[3]=(M-c)/E,t[0]=(v+i)/E,t[1]=(b+l)/E,t[2]=.25*E);return t},n.fromRotationTranslationScale=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],e=a[3],M=h+h,s=o+o,i=u+u,c=h*M,f=h*s,b=h*i,v=o*s,l=o*i,m=u*i,P=e*M,E=e*s,S=e*i,O=r[0],I=r[1],p=r[2];return t[0]=(1-(v+m))*O,t[1]=(f+S)*O,t[2]=(b-E)*O,t[3]=0,t[4]=(f-S)*I,t[5]=(1-(c+m))*I,t[6]=(l+P)*I,t[7]=0,t[8]=(b+E)*p,t[9]=(l-P)*p,t[10]=(1-(c+v))*p,t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t},n.fromRotationTranslationScaleOrigin=function(t,a,n,r,h){var o=a[0],u=a[1],e=a[2],M=a[3],s=o+o,i=u+u,c=e+e,f=o*s,b=o*i,v=o*c,l=u*i,m=u*c,P=e*c,E=M*s,S=M*i,O=M*c,I=r[0],p=r[1],N=r[2],L=h[0],R=h[1],x=h[2],A=(1-(l+P))*I,y=(b+O)*I,Y=(v-S)*I,g=(b-O)*p,T=(1-(f+P))*p,d=(m+E)*p,_=(v+S)*N,q=(m-E)*N,w=(1-(f+l))*N;return t[0]=A,t[1]=y,t[2]=Y,t[3]=0,t[4]=g,t[5]=T,t[6]=d,t[7]=0,t[8]=_,t[9]=q,t[10]=w,t[11]=0,t[12]=n[0]+L-(A*L+g*R+_*x),t[13]=n[1]+R-(y*L+T*R+q*x),t[14]=n[2]+x-(Y*L+d*R+w*x),t[15]=1,t},n.fromQuat=function(t,a){var n=a[0],r=a[1],h=a[2],o=a[3],u=n+n,e=r+r,M=h+h,s=n*u,i=r*u,c=r*e,f=h*u,b=h*e,v=h*M,l=o*u,m=o*e,P=o*M;return t[0]=1-c-v,t[1]=i+P,t[2]=f-m,t[3]=0,t[4]=i-P,t[5]=1-s-v,t[6]=b+l,t[7]=0,t[8]=f+m,t[9]=b-l,t[10]=1-s-c,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},n.frustum=function(t,a,n,r,h,o,u){var e=1/(n-a),M=1/(h-r),s=1/(o-u);return t[0]=2*o*e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=2*o*M,t[6]=0,t[7]=0,t[8]=(n+a)*e,t[9]=(h+r)*M,t[10]=(u+o)*s,t[11]=-1,t[12]=0,t[13]=0,t[14]=u*o*2*s,t[15]=0,t},n.perspectiveNO=i,n.perspectiveZO=function(t,a,n,r,h){var o,u=1/Math.tan(a/2);t[0]=u/n,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=h&&h!==1/0?(o=1/(r-h),t[10]=h*o,t[14]=h*r*o):(t[10]=-1,t[14]=-r);return t},n.perspectiveFromFieldOfView=function(t,a,n,r){var h=Math.tan(a.upDegrees*Math.PI/180),o=Math.tan(a.downDegrees*Math.PI/180),u=Math.tan(a.leftDegrees*Math.PI/180),e=Math.tan(a.rightDegrees*Math.PI/180),M=2/(u+e),s=2/(h+o);return t[0]=M,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=s,t[6]=0,t[7]=0,t[8]=-(u-e)*M*.5,t[9]=(h-o)*s*.5,t[10]=r/(n-r),t[11]=-1,t[12]=0,t[13]=0,t[14]=r*n/(n-r),t[15]=0,t},n.orthoNO=c,n.orthoZO=function(t,a,n,r,h,o,u){var e=1/(a-n),M=1/(r-h),s=1/(o-u);return t[0]=-2*e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*M,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=s,t[11]=0,t[12]=(a+n)*e,t[13]=(h+r)*M,t[14]=o*s,t[15]=1,t},n.lookAt=function(t,a,n,r){var h,e,M,s,i,c,f,b,v,l,m=a[0],P=a[1],E=a[2],S=r[0],O=r[1],I=r[2],p=n[0],N=n[1],L=n[2];if(Math.abs(m-p)<o.EPSILON&&Math.abs(P-N)<o.EPSILON&&Math.abs(E-L)<o.EPSILON)return u(t);f=m-p,b=P-N,v=E-L,l=1/Math.hypot(f,b,v),h=O*(v*=l)-I*(b*=l),e=I*(f*=l)-S*v,M=S*b-O*f,(l=Math.hypot(h,e,M))?(h*=l=1/l,e*=l,M*=l):(h=0,e=0,M=0);s=b*M-v*e,i=v*h-f*M,c=f*e-b*h,(l=Math.hypot(s,i,c))?(s*=l=1/l,i*=l,c*=l):(s=0,i=0,c=0);return t[0]=h,t[1]=s,t[2]=f,t[3]=0,t[4]=e,t[5]=i,t[6]=b,t[7]=0,t[8]=M,t[9]=c,t[10]=v,t[11]=0,t[12]=-(h*m+e*P+M*E),t[13]=-(s*m+i*P+c*E),t[14]=-(f*m+b*P+v*E),t[15]=1,t},n.targetTo=function(t,a,n,r){var h=a[0],o=a[1],u=a[2],e=r[0],M=r[1],s=r[2],i=h-n[0],c=o-n[1],f=u-n[2],b=i*i+c*c+f*f;b>0&&(i*=b=1/Math.sqrt(b),c*=b,f*=b);var v=M*f-s*c,l=s*i-e*f,m=e*c-M*i;(b=v*v+l*l+m*m)>0&&(v*=b=1/Math.sqrt(b),l*=b,m*=b);return t[0]=v,t[1]=l,t[2]=m,t[3]=0,t[4]=c*m-f*l,t[5]=f*v-i*m,t[6]=i*l-c*v,t[7]=0,t[8]=i,t[9]=c,t[10]=f,t[11]=0,t[12]=h,t[13]=o,t[14]=u,t[15]=1,t},n.str=function(t){return"mat4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+", "+t[8]+", "+t[9]+", "+t[10]+", "+t[11]+", "+t[12]+", "+t[13]+", "+t[14]+", "+t[15]+")"},n.frob=function(t){return Math.hypot(t[0],t[1],t[2],t[3],t[4],t[5],t[6],t[7],t[8],t[9],t[10],t[11],t[12],t[13],t[14],t[15])},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t[8]=a[8]+n[8],t[9]=a[9]+n[9],t[10]=a[10]+n[10],t[11]=a[11]+n[11],t[12]=a[12]+n[12],t[13]=a[13]+n[13],t[14]=a[14]+n[14],t[15]=a[15]+n[15],t},n.subtract=f,n.multiplyScalar=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t[8]=a[8]*n,t[9]=a[9]*n,t[10]=a[10]*n,t[11]=a[11]*n,t[12]=a[12]*n,t[13]=a[13]*n,t[14]=a[14]*n,t[15]=a[15]*n,t},n.multiplyScalarAndAdd=function(t,a,n,r){return t[0]=a[0]+n[0]*r,t[1]=a[1]+n[1]*r,t[2]=a[2]+n[2]*r,t[3]=a[3]+n[3]*r,t[4]=a[4]+n[4]*r,t[5]=a[5]+n[5]*r,t[6]=a[6]+n[6]*r,t[7]=a[7]+n[7]*r,t[8]=a[8]+n[8]*r,t[9]=a[9]+n[9]*r,t[10]=a[10]+n[10]*r,t[11]=a[11]+n[11]*r,t[12]=a[12]+n[12]*r,t[13]=a[13]+n[13]*r,t[14]=a[14]+n[14]*r,t[15]=a[15]+n[15]*r,t},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]&&t[8]===a[8]&&t[9]===a[9]&&t[10]===a[10]&&t[11]===a[11]&&t[12]===a[12]&&t[13]===a[13]&&t[14]===a[14]&&t[15]===a[15]},n.equals=function(t,a){var n=t[0],r=t[1],h=t[2],u=t[3],e=t[4],M=t[5],s=t[6],i=t[7],c=t[8],f=t[9],b=t[10],v=t[11],l=t[12],m=t[13],P=t[14],E=t[15],S=a[0],O=a[1],I=a[2],p=a[3],N=a[4],L=a[5],R=a[6],x=a[7],A=a[8],y=a[9],Y=a[10],g=a[11],T=a[12],d=a[13],_=a[14],q=a[15];return Math.abs(n-S)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(S))&&Math.abs(r-O)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(O))&&Math.abs(h-I)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(I))&&Math.abs(u-p)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(p))&&Math.abs(e-N)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(N))&&Math.abs(M-L)<=o.EPSILON*Math.max(1,Math.abs(M),Math.abs(L))&&Math.abs(s-R)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(R))&&Math.abs(i-x)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(x))&&Math.abs(c-A)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(A))&&Math.abs(f-y)<=o.EPSILON*Math.max(1,Math.abs(f),Math.abs(y))&&Math.abs(b-Y)<=o.EPSILON*Math.max(1,Math.abs(b),Math.abs(Y))&&Math.abs(v-g)<=o.EPSILON*Math.max(1,Math.abs(v),Math.abs(g))&&Math.abs(l-T)<=o.EPSILON*Math.max(1,Math.abs(l),Math.abs(T))&&Math.abs(m-d)<=o.EPSILON*Math.max(1,Math.abs(m),Math.abs(d))&&Math.abs(P-_)<=o.EPSILON*Math.max(1,Math.abs(P),Math.abs(_))&&Math.abs(E-q)<=o.EPSILON*Math.max(1,Math.abs(E),Math.abs(q))};const o=t("tslib").__importStar(t("7d825b979e"));function u(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function e(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],e=a[4],M=a[5],s=a[6],i=a[7],c=a[8],f=a[9],b=a[10],v=a[11],l=a[12],m=a[13],P=a[14],E=a[15],S=n[0],O=n[1],I=n[2],p=n[3];return t[0]=S*r+O*e+I*c+p*l,t[1]=S*h+O*M+I*f+p*m,t[2]=S*o+O*s+I*b+p*P,t[3]=S*u+O*i+I*v+p*E,S=n[4],O=n[5],I=n[6],p=n[7],t[4]=S*r+O*e+I*c+p*l,t[5]=S*h+O*M+I*f+p*m,t[6]=S*o+O*s+I*b+p*P,t[7]=S*u+O*i+I*v+p*E,S=n[8],O=n[9],I=n[10],p=n[11],t[8]=S*r+O*e+I*c+p*l,t[9]=S*h+O*M+I*f+p*m,t[10]=S*o+O*s+I*b+p*P,t[11]=S*u+O*i+I*v+p*E,S=n[12],O=n[13],I=n[14],p=n[15],t[12]=S*r+O*e+I*c+p*l,t[13]=S*h+O*M+I*f+p*m,t[14]=S*o+O*s+I*b+p*P,t[15]=S*u+O*i+I*v+p*E,t}function M(t,a,n){var r=a[0],h=a[1],o=a[2],u=a[3],e=r+r,M=h+h,s=o+o,i=r*e,c=r*M,f=r*s,b=h*M,v=h*s,l=o*s,m=u*e,P=u*M,E=u*s;return t[0]=1-(b+l),t[1]=c+E,t[2]=f-P,t[3]=0,t[4]=c-E,t[5]=1-(i+l),t[6]=v+m,t[7]=0,t[8]=f+P,t[9]=v-m,t[10]=1-(i+b),t[11]=0,t[12]=n[0],t[13]=n[1],t[14]=n[2],t[15]=1,t}function s(t,a){var n=a[0],r=a[1],h=a[2],o=a[4],u=a[5],e=a[6],M=a[8],s=a[9],i=a[10];return t[0]=Math.hypot(n,r,h),t[1]=Math.hypot(o,u,e),t[2]=Math.hypot(M,s,i),t}function i(t,a,n,r,h){var o,u=1/Math.tan(a/2);return t[0]=u/n,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=u,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=h&&h!==1/0?(o=1/(r-h),t[10]=(h+r)*o,t[14]=2*h*r*o):(t[10]=-1,t[14]=-2*r),t}function c(t,a,n,r,h,o,u){var e=1/(a-n),M=1/(r-h),s=1/(o-u);return t[0]=-2*e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*M,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*s,t[11]=0,t[12]=(a+n)*e,t[13]=(h+r)*M,t[14]=(u+o)*s,t[15]=1,t}function f(t,a,n){return t[0]=a[0]-n[0],t[1]=a[1]-n[1],t[2]=a[2]-n[2],t[3]=a[3]-n[3],t[4]=a[4]-n[4],t[5]=a[5]-n[5],t[6]=a[6]-n[6],t[7]=a[7]-n[7],t[8]=a[8]-n[8],t[9]=a[9]-n[9],t[10]=a[10]-n[10],t[11]=a[11]-n[11],t[12]=a[12]-n[12],t[13]=a[13]-n[13],t[14]=a[14]-n[14],t[15]=a[15]-n[15],t}n.perspective=i,n.ortho=c,n.mul=e,n.sub=f},
"f83fe7c413": function _(t,r,a,n,e){n(),a.create=h,a.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t},a.setAxisAngle=M,a.getAxisAngle=function(t,r){var a=2*Math.acos(r[3]),n=Math.sin(a/2);n>s.EPSILON?(t[0]=r[0]/n,t[1]=r[1]/n,t[2]=r[2]/n):(t[0]=1,t[1]=0,t[2]=0);return a},a.getAngle=function(t,r){var n=(0,a.dot)(t,r);return Math.acos(2*n*n-1)},a.multiply=l,a.rotateX=function(t,r,a){a*=.5;var n=r[0],e=r[1],o=r[2],s=r[3],u=Math.sin(a),c=Math.cos(a);return t[0]=n*c+s*u,t[1]=e*c+o*u,t[2]=o*c-e*u,t[3]=s*c-n*u,t},a.rotateY=function(t,r,a){a*=.5;var n=r[0],e=r[1],o=r[2],s=r[3],u=Math.sin(a),c=Math.cos(a);return t[0]=n*c-o*u,t[1]=e*c+s*u,t[2]=o*c+n*u,t[3]=s*c-e*u,t},a.rotateZ=function(t,r,a){a*=.5;var n=r[0],e=r[1],o=r[2],s=r[3],u=Math.sin(a),c=Math.cos(a);return t[0]=n*c+e*u,t[1]=e*c-n*u,t[2]=o*c+s*u,t[3]=s*c-o*u,t},a.calculateW=function(t,r){var a=r[0],n=r[1],e=r[2];return t[0]=a,t[1]=n,t[2]=e,t[3]=Math.sqrt(Math.abs(1-a*a-n*n-e*e)),t},a.exp=f,a.ln=v,a.pow=function(t,r,n){return v(t,r),(0,a.scale)(t,t,n),f(t,t),t},a.slerp=m,a.random=function(t){var r=s.RANDOM(),a=s.RANDOM(),n=s.RANDOM(),e=Math.sqrt(1-r),o=Math.sqrt(r);return t[0]=e*Math.sin(2*Math.PI*a),t[1]=e*Math.cos(2*Math.PI*a),t[2]=o*Math.sin(2*Math.PI*n),t[3]=o*Math.cos(2*Math.PI*n),t},a.invert=function(t,r){var a=r[0],n=r[1],e=r[2],o=r[3],s=a*a+n*n+e*e+o*o,u=s?1/s:0;return t[0]=-a*u,t[1]=-n*u,t[2]=-e*u,t[3]=o*u,t},a.conjugate=function(t,r){return t[0]=-r[0],t[1]=-r[1],t[2]=-r[2],t[3]=r[3],t},a.fromMat3=d,a.fromEuler=function(t,r,a,n){var e=.5*Math.PI/180;r*=e,a*=e,n*=e;var o=Math.sin(r),s=Math.cos(r),u=Math.sin(a),c=Math.cos(a),i=Math.sin(n),h=Math.cos(n);return t[0]=o*c*h-s*u*i,t[1]=s*u*h+o*c*i,t[2]=s*c*i-o*u*h,t[3]=s*c*h+o*u*i,t},a.str=function(t){return"quat("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"};const o=t("tslib"),s=o.__importStar(t("7d825b979e")),u=o.__importStar(t("a025ef02dc")),c=o.__importStar(t("63eddc5433")),i=o.__importStar(t("11562bccc5"));function h(){var t=new s.ARRAY_TYPE(4);return s.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function M(t,r,a){a*=.5;var n=Math.sin(a);return t[0]=n*r[0],t[1]=n*r[1],t[2]=n*r[2],t[3]=Math.cos(a),t}function l(t,r,a){var n=r[0],e=r[1],o=r[2],s=r[3],u=a[0],c=a[1],i=a[2],h=a[3];return t[0]=n*h+s*u+e*i-o*c,t[1]=e*h+s*c+o*u-n*i,t[2]=o*h+s*i+n*c-e*u,t[3]=s*h-n*u-e*c-o*i,t}function f(t,r){var a=r[0],n=r[1],e=r[2],o=r[3],s=Math.sqrt(a*a+n*n+e*e),u=Math.exp(o),c=s>0?u*Math.sin(s)/s:0;return t[0]=a*c,t[1]=n*c,t[2]=e*c,t[3]=u*Math.cos(s),t}function v(t,r){var a=r[0],n=r[1],e=r[2],o=r[3],s=Math.sqrt(a*a+n*n+e*e),u=s>0?Math.atan2(s,o)/s:0;return t[0]=a*u,t[1]=n*u,t[2]=e*u,t[3]=.5*Math.log(a*a+n*n+e*e+o*o),t}function m(t,r,a,n){var e,o,u,c,i,h=r[0],M=r[1],l=r[2],f=r[3],v=a[0],m=a[1],d=a[2],q=a[3];return(o=h*v+M*m+l*d+f*q)<0&&(o=-o,v=-v,m=-m,d=-d,q=-q),1-o>s.EPSILON?(e=Math.acos(o),u=Math.sin(e),c=Math.sin((1-n)*e)/u,i=Math.sin(n*e)/u):(c=1-n,i=n),t[0]=c*h+i*v,t[1]=c*M+i*m,t[2]=c*l+i*d,t[3]=c*f+i*q,t}function d(t,r){var a,n=r[0]+r[4]+r[8];if(n>0)a=Math.sqrt(n+1),t[3]=.5*a,a=.5/a,t[0]=(r[5]-r[7])*a,t[1]=(r[6]-r[2])*a,t[2]=(r[1]-r[3])*a;else{var e=0;r[4]>r[0]&&(e=1),r[8]>r[3*e+e]&&(e=2);var o=(e+1)%3,s=(e+2)%3;a=Math.sqrt(r[3*e+e]-r[3*o+o]-r[3*s+s]+1),t[e]=.5*a,a=.5/a,t[3]=(r[3*o+s]-r[3*s+o])*a,t[o]=(r[3*o+e]+r[3*e+o])*a,t[s]=(r[3*s+e]+r[3*e+s])*a}return t}var q,p,A,g,_,P;a.clone=i.clone,a.fromValues=i.fromValues,a.copy=i.copy,a.set=i.set,a.add=i.add,a.mul=l,a.scale=i.scale,a.dot=i.dot,a.lerp=i.lerp,a.length=i.length,a.len=a.length,a.squaredLength=i.squaredLength,a.sqrLen=a.squaredLength,a.normalize=i.normalize,a.exactEquals=i.exactEquals,a.equals=i.equals,a.rotationTo=(q=c.create(),p=c.fromValues(1,0,0),A=c.fromValues(0,1,0),function(t,r,n){var e=c.dot(r,n);return e<-.999999?(c.cross(q,p,r),c.len(q)<1e-6&&c.cross(q,A,r),c.normalize(q,q),M(t,q,Math.PI),t):e>.999999?(t[0]=0,t[1]=0,t[2]=0,t[3]=1,t):(c.cross(q,r,n),t[0]=q[0],t[1]=q[1],t[2]=q[2],t[3]=1+e,(0,a.normalize)(t,t))}),a.sqlerp=(g=h(),_=h(),function(t,r,a,n,e,o){return m(g,r,e,o),m(_,a,n,o),m(t,g,_,2*o*(1-o)),t}),a.setAxes=(P=u.create(),function(t,r,n,e){return P[0]=n[0],P[3]=n[1],P[6]=n[2],P[1]=e[0],P[4]=e[1],P[7]=e[2],P[2]=-r[0],P[5]=-r[1],P[8]=-r[2],(0,a.normalize)(t,d(t,P))})},
"63eddc5433": function _(t,n,r,a,u){a(),r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(3);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n},r.length=i,r.fromValues=function(t,n,r){var a=new e.ARRAY_TYPE(3);return a[0]=t,a[1]=n,a[2]=r,a},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t},r.set=function(t,n,r,a){return t[0]=n,t[1]=r,t[2]=a,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t},r.subtract=c,r.multiply=h,r.divide=M,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t},r.distance=s,r.squaredDistance=f,r.squaredLength=v,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=r*r+a*a+u*u;e>0&&(e=1/Math.sqrt(e));return t[0]=n[0]*e,t[1]=n[1]*e,t[2]=n[2]*e,t},r.dot=l,r.cross=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2];return t[0]=u*c-e*i,t[1]=e*o-a*c,t[2]=a*i-u*o,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t},r.hermite=function(t,n,r,a,u,e){var o=e*e,i=o*(2*e-3)+1,c=o*(e-2)+e,h=o*(e-1),M=o*(3-2*e);return t[0]=n[0]*i+r[0]*c+a[0]*h+u[0]*M,t[1]=n[1]*i+r[1]*c+a[1]*h+u[1]*M,t[2]=n[2]*i+r[2]*c+a[2]*h+u[2]*M,t},r.bezier=function(t,n,r,a,u,e){var o=1-e,i=o*o,c=e*e,h=i*o,M=3*e*i,s=3*c*o,f=c*e;return t[0]=n[0]*h+r[0]*M+a[0]*s+u[0]*f,t[1]=n[1]*h+r[1]*M+a[1]*s+u[1]*f,t[2]=n[2]*h+r[2]*M+a[2]*s+u[2]*f,t},r.random=function(t,n){n=n||1;var r=2*e.RANDOM()*Math.PI,a=2*e.RANDOM()-1,u=Math.sqrt(1-a*a)*n;return t[0]=Math.cos(r)*u,t[1]=Math.sin(r)*u,t[2]=a*n,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[3]*a+r[7]*u+r[11]*e+r[15];return o=o||1,t[0]=(r[0]*a+r[4]*u+r[8]*e+r[12])/o,t[1]=(r[1]*a+r[5]*u+r[9]*e+r[13])/o,t[2]=(r[2]*a+r[6]*u+r[10]*e+r[14])/o,t},r.transformMat3=function(t,n,r){var a=n[0],u=n[1],e=n[2];return t[0]=a*r[0]+u*r[3]+e*r[6],t[1]=a*r[1]+u*r[4]+e*r[7],t[2]=a*r[2]+u*r[5]+e*r[8],t},r.transformQuat=function(t,n,r){var a=r[0],u=r[1],e=r[2],o=r[3],i=n[0],c=n[1],h=n[2],M=u*h-e*c,s=e*i-a*h,f=a*c-u*i,v=u*f-e*s,l=e*M-a*f,m=a*s-u*M,d=2*o;return M*=d,s*=d,f*=d,v*=2,l*=2,m*=2,t[0]=i+M+v,t[1]=c+s+l,t[2]=h+f+m,t},r.rotateX=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0],e[1]=u[1]*Math.cos(a)-u[2]*Math.sin(a),e[2]=u[1]*Math.sin(a)+u[2]*Math.cos(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateY=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[2]*Math.sin(a)+u[0]*Math.cos(a),e[1]=u[1],e[2]=u[2]*Math.cos(a)-u[0]*Math.sin(a),t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.rotateZ=function(t,n,r,a){var u=[],e=[];return u[0]=n[0]-r[0],u[1]=n[1]-r[1],u[2]=n[2]-r[2],e[0]=u[0]*Math.cos(a)-u[1]*Math.sin(a),e[1]=u[0]*Math.sin(a)+u[1]*Math.cos(a),e[2]=u[2],t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t},r.angle=function(t,n){var r=t[0],a=t[1],u=t[2],e=n[0],o=n[1],i=n[2],c=Math.sqrt(r*r+a*a+u*u),h=Math.sqrt(e*e+o*o+i*i),M=c*h,s=M&&l(t,n)/M;return Math.acos(Math.min(Math.max(s,-1),1))},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t},r.str=function(t){return"vec3("+t[0]+", "+t[1]+", "+t[2]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=n[0],i=n[1],c=n[2];return Math.abs(r-o)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(o))&&Math.abs(a-i)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(i))&&Math.abs(u-c)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(c))};const e=t("tslib").__importStar(t("7d825b979e"));function o(){var t=new e.ARRAY_TYPE(3);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function i(t){var n=t[0],r=t[1],a=t[2];return Math.hypot(n,r,a)}function c(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t}function h(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t}function M(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t}function s(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return Math.hypot(r,a,u)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2];return r*r+a*a+u*u}function v(t){var n=t[0],r=t[1],a=t[2];return n*n+r*r+a*a}function l(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]}var m;r.sub=c,r.mul=h,r.div=M,r.dist=s,r.sqrDist=f,r.len=i,r.sqrLen=v,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=3),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2];return t})},
"11562bccc5": function _(t,n,r,a,u){a(),r.create=o,r.clone=function(t){var n=new e.ARRAY_TYPE(4);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n[3]=t[3],n},r.fromValues=function(t,n,r,a){var u=new e.ARRAY_TYPE(4);return u[0]=t,u[1]=n,u[2]=r,u[3]=a,u},r.copy=function(t,n){return t[0]=n[0],t[1]=n[1],t[2]=n[2],t[3]=n[3],t},r.set=function(t,n,r,a,u){return t[0]=n,t[1]=r,t[2]=a,t[3]=u,t},r.add=function(t,n,r){return t[0]=n[0]+r[0],t[1]=n[1]+r[1],t[2]=n[2]+r[2],t[3]=n[3]+r[3],t},r.subtract=i,r.multiply=c,r.divide=h,r.ceil=function(t,n){return t[0]=Math.ceil(n[0]),t[1]=Math.ceil(n[1]),t[2]=Math.ceil(n[2]),t[3]=Math.ceil(n[3]),t},r.floor=function(t,n){return t[0]=Math.floor(n[0]),t[1]=Math.floor(n[1]),t[2]=Math.floor(n[2]),t[3]=Math.floor(n[3]),t},r.min=function(t,n,r){return t[0]=Math.min(n[0],r[0]),t[1]=Math.min(n[1],r[1]),t[2]=Math.min(n[2],r[2]),t[3]=Math.min(n[3],r[3]),t},r.max=function(t,n,r){return t[0]=Math.max(n[0],r[0]),t[1]=Math.max(n[1],r[1]),t[2]=Math.max(n[2],r[2]),t[3]=Math.max(n[3],r[3]),t},r.round=function(t,n){return t[0]=Math.round(n[0]),t[1]=Math.round(n[1]),t[2]=Math.round(n[2]),t[3]=Math.round(n[3]),t},r.scale=function(t,n,r){return t[0]=n[0]*r,t[1]=n[1]*r,t[2]=n[2]*r,t[3]=n[3]*r,t},r.scaleAndAdd=function(t,n,r,a){return t[0]=n[0]+r[0]*a,t[1]=n[1]+r[1]*a,t[2]=n[2]+r[2]*a,t[3]=n[3]+r[3]*a,t},r.distance=M,r.squaredDistance=f,r.length=s,r.squaredLength=l,r.negate=function(t,n){return t[0]=-n[0],t[1]=-n[1],t[2]=-n[2],t[3]=-n[3],t},r.inverse=function(t,n){return t[0]=1/n[0],t[1]=1/n[1],t[2]=1/n[2],t[3]=1/n[3],t},r.normalize=function(t,n){var r=n[0],a=n[1],u=n[2],e=n[3],o=r*r+a*a+u*u+e*e;o>0&&(o=1/Math.sqrt(o));return t[0]=r*o,t[1]=a*o,t[2]=u*o,t[3]=e*o,t},r.dot=function(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]+t[3]*n[3]},r.cross=function(t,n,r,a){var u=r[0]*a[1]-r[1]*a[0],e=r[0]*a[2]-r[2]*a[0],o=r[0]*a[3]-r[3]*a[0],i=r[1]*a[2]-r[2]*a[1],c=r[1]*a[3]-r[3]*a[1],h=r[2]*a[3]-r[3]*a[2],M=n[0],f=n[1],s=n[2],l=n[3];return t[0]=f*h-s*c+l*i,t[1]=-M*h+s*o-l*e,t[2]=M*c-f*o+l*u,t[3]=-M*i+f*e-s*u,t},r.lerp=function(t,n,r,a){var u=n[0],e=n[1],o=n[2],i=n[3];return t[0]=u+a*(r[0]-u),t[1]=e+a*(r[1]-e),t[2]=o+a*(r[2]-o),t[3]=i+a*(r[3]-i),t},r.random=function(t,n){var r,a,u,o,i,c;n=n||1;do{i=(r=2*e.RANDOM()-1)*r+(a=2*e.RANDOM()-1)*a}while(i>=1);do{c=(u=2*e.RANDOM()-1)*u+(o=2*e.RANDOM()-1)*o}while(c>=1);var h=Math.sqrt((1-i)/c);return t[0]=n*r,t[1]=n*a,t[2]=n*u*h,t[3]=n*o*h,t},r.transformMat4=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=n[3];return t[0]=r[0]*a+r[4]*u+r[8]*e+r[12]*o,t[1]=r[1]*a+r[5]*u+r[9]*e+r[13]*o,t[2]=r[2]*a+r[6]*u+r[10]*e+r[14]*o,t[3]=r[3]*a+r[7]*u+r[11]*e+r[15]*o,t},r.transformQuat=function(t,n,r){var a=n[0],u=n[1],e=n[2],o=r[0],i=r[1],c=r[2],h=r[3],M=h*a+i*e-c*u,f=h*u+c*a-o*e,s=h*e+o*u-i*a,l=-o*a-i*u-c*e;return t[0]=M*h+l*-o+f*-c-s*-i,t[1]=f*h+l*-i+s*-o-M*-c,t[2]=s*h+l*-c+M*-i-f*-o,t[3]=n[3],t},r.zero=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t},r.str=function(t){return"vec4("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+")"},r.exactEquals=function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]&&t[3]===n[3]},r.equals=function(t,n){var r=t[0],a=t[1],u=t[2],o=t[3],i=n[0],c=n[1],h=n[2],M=n[3];return Math.abs(r-i)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(i))&&Math.abs(a-c)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(c))&&Math.abs(u-h)<=e.EPSILON*Math.max(1,Math.abs(u),Math.abs(h))&&Math.abs(o-M)<=e.EPSILON*Math.max(1,Math.abs(o),Math.abs(M))};const e=t("tslib").__importStar(t("7d825b979e"));function o(){var t=new e.ARRAY_TYPE(4);return e.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[3]=0),t}function i(t,n,r){return t[0]=n[0]-r[0],t[1]=n[1]-r[1],t[2]=n[2]-r[2],t[3]=n[3]-r[3],t}function c(t,n,r){return t[0]=n[0]*r[0],t[1]=n[1]*r[1],t[2]=n[2]*r[2],t[3]=n[3]*r[3],t}function h(t,n,r){return t[0]=n[0]/r[0],t[1]=n[1]/r[1],t[2]=n[2]/r[2],t[3]=n[3]/r[3],t}function M(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return Math.hypot(r,a,u,e)}function f(t,n){var r=n[0]-t[0],a=n[1]-t[1],u=n[2]-t[2],e=n[3]-t[3];return r*r+a*a+u*u+e*e}function s(t){var n=t[0],r=t[1],a=t[2],u=t[3];return Math.hypot(n,r,a,u)}function l(t){var n=t[0],r=t[1],a=t[2],u=t[3];return n*n+r*r+a*a+u*u}var m;r.sub=i,r.mul=c,r.div=h,r.dist=M,r.sqrDist=f,r.len=s,r.sqrLen=l,r.forEach=(m=o(),function(t,n,r,a,u,e){var o,i;for(n||(n=4),r||(r=0),i=a?Math.min(a*n+r,t.length):t.length,o=r;o<i;o+=n)m[0]=t[o],m[1]=t[o+1],m[2]=t[o+2],m[3]=t[o+3],u(m,m,e),t[o]=m[0],t[o+1]=m[1],t[o+2]=m[2],t[o+3]=m[3];return t})},
"fb9294db61": function _(t,a,n,r,e){r(),n.create=function(){var t=new o.ARRAY_TYPE(8);o.ARRAY_TYPE!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0);return t[3]=1,t},n.clone=function(t){var a=new o.ARRAY_TYPE(8);return a[0]=t[0],a[1]=t[1],a[2]=t[2],a[3]=t[3],a[4]=t[4],a[5]=t[5],a[6]=t[6],a[7]=t[7],a},n.fromValues=function(t,a,n,r,e,u,i,s){var h=new o.ARRAY_TYPE(8);return h[0]=t,h[1]=a,h[2]=n,h[3]=r,h[4]=e,h[5]=u,h[6]=i,h[7]=s,h},n.fromRotationTranslationValues=function(t,a,n,r,e,u,i){var s=new o.ARRAY_TYPE(8);s[0]=t,s[1]=a,s[2]=n,s[3]=r;var h=.5*e,c=.5*u,f=.5*i;return s[4]=h*r+c*n-f*a,s[5]=c*r+f*t-h*n,s[6]=f*r+h*a-c*t,s[7]=-h*t-c*a-f*n,s},n.fromRotationTranslation=h,n.fromTranslation=function(t,a){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=.5*a[0],t[5]=.5*a[1],t[6]=.5*a[2],t[7]=0,t},n.fromRotation=function(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.fromMat4=function(t,a){var n=i.create();s.getRotation(n,a);var r=new o.ARRAY_TYPE(3);return s.getTranslation(r,a),h(t,n,r),t},n.copy=c,n.identity=function(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t},n.set=function(t,a,n,r,e,u,o,i,s){return t[0]=a,t[1]=n,t[2]=r,t[3]=e,t[4]=u,t[5]=o,t[6]=i,t[7]=s,t},n.getDual=function(t,a){return t[0]=a[4],t[1]=a[5],t[2]=a[6],t[3]=a[7],t},n.setDual=function(t,a){return t[4]=a[0],t[5]=a[1],t[6]=a[2],t[7]=a[3],t},n.getTranslation=function(t,a){var n=a[4],r=a[5],e=a[6],u=a[7],o=-a[0],i=-a[1],s=-a[2],h=a[3];return t[0]=2*(n*h+u*o+r*s-e*i),t[1]=2*(r*h+u*i+e*o-n*s),t[2]=2*(e*h+u*s+n*i-r*o),t},n.translate=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=.5*n[0],s=.5*n[1],h=.5*n[2],c=a[4],f=a[5],M=a[6],b=a[7];return t[0]=r,t[1]=e,t[2]=u,t[3]=o,t[4]=o*i+e*h-u*s+c,t[5]=o*s+u*i-r*h+f,t[6]=o*h+r*s-e*i+M,t[7]=-r*i-e*s-u*h+b,t},n.rotateX=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],h=a[5],c=a[6],f=a[7],M=s*o+f*r+h*u-c*e,b=h*o+f*e+c*r-s*u,l=c*o+f*u+s*e-h*r,v=f*o-s*r-h*e-c*u;return i.rotateX(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateY=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],h=a[5],c=a[6],f=a[7],M=s*o+f*r+h*u-c*e,b=h*o+f*e+c*r-s*u,l=c*o+f*u+s*e-h*r,v=f*o-s*r-h*e-c*u;return i.rotateY(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateZ=function(t,a,n){var r=-a[0],e=-a[1],u=-a[2],o=a[3],s=a[4],h=a[5],c=a[6],f=a[7],M=s*o+f*r+h*u-c*e,b=h*o+f*e+c*r-s*u,l=c*o+f*u+s*e-h*r,v=f*o-s*r-h*e-c*u;return i.rotateZ(t,a,n),r=t[0],e=t[1],u=t[2],o=t[3],t[4]=M*o+v*r+b*u-l*e,t[5]=b*o+v*e+l*r-M*u,t[6]=l*o+v*u+M*e-b*r,t[7]=v*o-M*r-b*e-l*u,t},n.rotateByQuatAppend=function(t,a,n){var r=n[0],e=n[1],u=n[2],o=n[3],i=a[0],s=a[1],h=a[2],c=a[3];return t[0]=i*o+c*r+s*u-h*e,t[1]=s*o+c*e+h*r-i*u,t[2]=h*o+c*u+i*e-s*r,t[3]=c*o-i*r-s*e-h*u,i=a[4],s=a[5],h=a[6],c=a[7],t[4]=i*o+c*r+s*u-h*e,t[5]=s*o+c*e+h*r-i*u,t[6]=h*o+c*u+i*e-s*r,t[7]=c*o-i*r-s*e-h*u,t},n.rotateByQuatPrepend=function(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[0],s=n[1],h=n[2],c=n[3];return t[0]=r*c+o*i+e*h-u*s,t[1]=e*c+o*s+u*i-r*h,t[2]=u*c+o*h+r*s-e*i,t[3]=o*c-r*i-e*s-u*h,i=n[4],s=n[5],h=n[6],c=n[7],t[4]=r*c+o*i+e*h-u*s,t[5]=e*c+o*s+u*i-r*h,t[6]=u*c+o*h+r*s-e*i,t[7]=o*c-r*i-e*s-u*h,t},n.rotateAroundAxis=function(t,a,n,r){if(Math.abs(r)<o.EPSILON)return c(t,a);var e=Math.hypot(n[0],n[1],n[2]);r*=.5;var u=Math.sin(r),i=u*n[0]/e,s=u*n[1]/e,h=u*n[2]/e,f=Math.cos(r),M=a[0],b=a[1],l=a[2],v=a[3];t[0]=M*f+v*i+b*h-l*s,t[1]=b*f+v*s+l*i-M*h,t[2]=l*f+v*h+M*s-b*i,t[3]=v*f-M*i-b*s-l*h;var m=a[4],R=a[5],d=a[6],A=a[7];return t[4]=m*f+A*i+R*h-d*s,t[5]=R*f+A*s+d*i-m*h,t[6]=d*f+A*h+m*s-R*i,t[7]=A*f-m*i-R*s-d*h,t},n.add=function(t,a,n){return t[0]=a[0]+n[0],t[1]=a[1]+n[1],t[2]=a[2]+n[2],t[3]=a[3]+n[3],t[4]=a[4]+n[4],t[5]=a[5]+n[5],t[6]=a[6]+n[6],t[7]=a[7]+n[7],t},n.multiply=f,n.scale=function(t,a,n){return t[0]=a[0]*n,t[1]=a[1]*n,t[2]=a[2]*n,t[3]=a[3]*n,t[4]=a[4]*n,t[5]=a[5]*n,t[6]=a[6]*n,t[7]=a[7]*n,t},n.lerp=function(t,a,r,e){var u=1-e;(0,n.dot)(a,r)<0&&(e=-e);return t[0]=a[0]*u+r[0]*e,t[1]=a[1]*u+r[1]*e,t[2]=a[2]*u+r[2]*e,t[3]=a[3]*u+r[3]*e,t[4]=a[4]*u+r[4]*e,t[5]=a[5]*u+r[5]*e,t[6]=a[6]*u+r[6]*e,t[7]=a[7]*u+r[7]*e,t},n.invert=function(t,a){var r=(0,n.squaredLength)(a);return t[0]=-a[0]/r,t[1]=-a[1]/r,t[2]=-a[2]/r,t[3]=a[3]/r,t[4]=-a[4]/r,t[5]=-a[5]/r,t[6]=-a[6]/r,t[7]=a[7]/r,t},n.conjugate=function(t,a){return t[0]=-a[0],t[1]=-a[1],t[2]=-a[2],t[3]=a[3],t[4]=-a[4],t[5]=-a[5],t[6]=-a[6],t[7]=a[7],t},n.normalize=function(t,a){var r=(0,n.squaredLength)(a);if(r>0){r=Math.sqrt(r);var e=a[0]/r,u=a[1]/r,o=a[2]/r,i=a[3]/r,s=a[4],h=a[5],c=a[6],f=a[7],M=e*s+u*h+o*c+i*f;t[0]=e,t[1]=u,t[2]=o,t[3]=i,t[4]=(s-e*M)/r,t[5]=(h-u*M)/r,t[6]=(c-o*M)/r,t[7]=(f-i*M)/r}return t},n.str=function(t){return"quat2("+t[0]+", "+t[1]+", "+t[2]+", "+t[3]+", "+t[4]+", "+t[5]+", "+t[6]+", "+t[7]+")"},n.exactEquals=function(t,a){return t[0]===a[0]&&t[1]===a[1]&&t[2]===a[2]&&t[3]===a[3]&&t[4]===a[4]&&t[5]===a[5]&&t[6]===a[6]&&t[7]===a[7]},n.equals=function(t,a){var n=t[0],r=t[1],e=t[2],u=t[3],i=t[4],s=t[5],h=t[6],c=t[7],f=a[0],M=a[1],b=a[2],l=a[3],v=a[4],m=a[5],R=a[6],d=a[7];return Math.abs(n-f)<=o.EPSILON*Math.max(1,Math.abs(n),Math.abs(f))&&Math.abs(r-M)<=o.EPSILON*Math.max(1,Math.abs(r),Math.abs(M))&&Math.abs(e-b)<=o.EPSILON*Math.max(1,Math.abs(e),Math.abs(b))&&Math.abs(u-l)<=o.EPSILON*Math.max(1,Math.abs(u),Math.abs(l))&&Math.abs(i-v)<=o.EPSILON*Math.max(1,Math.abs(i),Math.abs(v))&&Math.abs(s-m)<=o.EPSILON*Math.max(1,Math.abs(s),Math.abs(m))&&Math.abs(h-R)<=o.EPSILON*Math.max(1,Math.abs(h),Math.abs(R))&&Math.abs(c-d)<=o.EPSILON*Math.max(1,Math.abs(c),Math.abs(d))};const u=t("tslib"),o=u.__importStar(t("7d825b979e")),i=u.__importStar(t("f83fe7c413")),s=u.__importStar(t("83bad9e639"));function h(t,a,n){var r=.5*n[0],e=.5*n[1],u=.5*n[2],o=a[0],i=a[1],s=a[2],h=a[3];return t[0]=o,t[1]=i,t[2]=s,t[3]=h,t[4]=r*h+e*s-u*i,t[5]=e*h+u*o-r*s,t[6]=u*h+r*i-e*o,t[7]=-r*o-e*i-u*s,t}function c(t,a){return t[0]=a[0],t[1]=a[1],t[2]=a[2],t[3]=a[3],t[4]=a[4],t[5]=a[5],t[6]=a[6],t[7]=a[7],t}function f(t,a,n){var r=a[0],e=a[1],u=a[2],o=a[3],i=n[4],s=n[5],h=n[6],c=n[7],f=a[4],M=a[5],b=a[6],l=a[7],v=n[0],m=n[1],R=n[2],d=n[3];return t[0]=r*d+o*v+e*R-u*m,t[1]=e*d+o*m+u*v-r*R,t[2]=u*d+o*R+r*m-e*v,t[3]=o*d-r*v-e*m-u*R,t[4]=r*c+o*i+e*h-u*s+f*d+l*v+M*R-b*m,t[5]=e*c+o*s+u*i-r*h+M*d+l*m+b*v-f*R,t[6]=u*c+o*h+r*s-e*i+b*d+l*R+f*m-M*v,t[7]=o*c-r*i-e*s-u*h+l*d-f*v-M*m-b*R,t}n.getReal=i.copy,n.setReal=i.copy,n.mul=f,n.dot=i.dot,n.length=i.length,n.len=n.length,n.squaredLength=i.squaredLength,n.sqrLen=n.squaredLength},
"58c71a9bd3": function _(n,t,r,a,u){a(),r.create=o,r.clone=function(n){var t=new e.ARRAY_TYPE(2);return t[0]=n[0],t[1]=n[1],t},r.fromValues=function(n,t){var r=new e.ARRAY_TYPE(2);return r[0]=n,r[1]=t,r},r.copy=function(n,t){return n[0]=t[0],n[1]=t[1],n},r.set=function(n,t,r){return n[0]=t,n[1]=r,n},r.add=function(n,t,r){return n[0]=t[0]+r[0],n[1]=t[1]+r[1],n},r.subtract=i,r.multiply=c,r.divide=f,r.ceil=function(n,t){return n[0]=Math.ceil(t[0]),n[1]=Math.ceil(t[1]),n},r.floor=function(n,t){return n[0]=Math.floor(t[0]),n[1]=Math.floor(t[1]),n},r.min=function(n,t,r){return n[0]=Math.min(t[0],r[0]),n[1]=Math.min(t[1],r[1]),n},r.max=function(n,t,r){return n[0]=Math.max(t[0],r[0]),n[1]=Math.max(t[1],r[1]),n},r.round=function(n,t){return n[0]=Math.round(t[0]),n[1]=Math.round(t[1]),n},r.scale=function(n,t,r){return n[0]=t[0]*r,n[1]=t[1]*r,n},r.scaleAndAdd=function(n,t,r,a){return n[0]=t[0]+r[0]*a,n[1]=t[1]+r[1]*a,n},r.distance=s,r.squaredDistance=h,r.length=M,r.squaredLength=l,r.negate=function(n,t){return n[0]=-t[0],n[1]=-t[1],n},r.inverse=function(n,t){return n[0]=1/t[0],n[1]=1/t[1],n},r.normalize=function(n,t){var r=t[0],a=t[1],u=r*r+a*a;u>0&&(u=1/Math.sqrt(u));return n[0]=t[0]*u,n[1]=t[1]*u,n},r.dot=function(n,t){return n[0]*t[0]+n[1]*t[1]},r.cross=function(n,t,r){var a=t[0]*r[1]-t[1]*r[0];return n[0]=n[1]=0,n[2]=a,n},r.lerp=function(n,t,r,a){var u=t[0],e=t[1];return n[0]=u+a*(r[0]-u),n[1]=e+a*(r[1]-e),n},r.random=function(n,t){t=t||1;var r=2*e.RANDOM()*Math.PI;return n[0]=Math.cos(r)*t,n[1]=Math.sin(r)*t,n},r.transformMat2=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u,n[1]=r[1]*a+r[3]*u,n},r.transformMat2d=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[2]*u+r[4],n[1]=r[1]*a+r[3]*u+r[5],n},r.transformMat3=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[3]*u+r[6],n[1]=r[1]*a+r[4]*u+r[7],n},r.transformMat4=function(n,t,r){var a=t[0],u=t[1];return n[0]=r[0]*a+r[4]*u+r[12],n[1]=r[1]*a+r[5]*u+r[13],n},r.rotate=function(n,t,r,a){var u=t[0]-r[0],e=t[1]-r[1],o=Math.sin(a),i=Math.cos(a);return n[0]=u*i-e*o+r[0],n[1]=u*o+e*i+r[1],n},r.angle=function(n,t){var r=n[0],a=n[1],u=t[0],e=t[1],o=Math.sqrt(r*r+a*a)*Math.sqrt(u*u+e*e),i=o&&(r*u+a*e)/o;return Math.acos(Math.min(Math.max(i,-1),1))},r.zero=function(n){return n[0]=0,n[1]=0,n},r.str=function(n){return"vec2("+n[0]+", "+n[1]+")"},r.exactEquals=function(n,t){return n[0]===t[0]&&n[1]===t[1]},r.equals=function(n,t){var r=n[0],a=n[1],u=t[0],o=t[1];return Math.abs(r-u)<=e.EPSILON*Math.max(1,Math.abs(r),Math.abs(u))&&Math.abs(a-o)<=e.EPSILON*Math.max(1,Math.abs(a),Math.abs(o))};const e=n("tslib").__importStar(n("7d825b979e"));function o(){var n=new e.ARRAY_TYPE(2);return e.ARRAY_TYPE!=Float32Array&&(n[0]=0,n[1]=0),n}function i(n,t,r){return n[0]=t[0]-r[0],n[1]=t[1]-r[1],n}function c(n,t,r){return n[0]=t[0]*r[0],n[1]=t[1]*r[1],n}function f(n,t,r){return n[0]=t[0]/r[0],n[1]=t[1]/r[1],n}function s(n,t){var r=t[0]-n[0],a=t[1]-n[1];return Math.hypot(r,a)}function h(n,t){var r=t[0]-n[0],a=t[1]-n[1];return r*r+a*a}function M(n){var t=n[0],r=n[1];return Math.hypot(t,r)}function l(n){var t=n[0],r=n[1];return t*t+r*r}var v;r.len=M,r.sub=i,r.mul=c,r.div=f,r.dist=s,r.sqrDist=h,r.sqrLen=l,r.forEach=(v=o(),function(n,t,r,a,u,e){var o,i;for(t||(t=2),r||(r=0),i=a?Math.min(a*t+r,n.length):n.length,o=r;o<i;o+=t)v[0]=n[o],v[1]=n[o+1],u(v,v,e),n[o]=v[0],n[o+1]=v[1];return n})},
"18592eecef": function _(e,t,i,s,n){var r;s();const o=e("b06d05fa3e"),a=e("df9946ff52");class l extends o.AbstractVTKView{connect_signals(){super.connect_signals();const{data:e,colormap:t,shadow:i,sampling:s,edge_gradient:n,rescale:r,ambient:o,diffuse:l,camera:d,specular:_,specular_power:c,display_volume:h,display_slices:g,slice_i:p,slice_j:m,slice_k:u,render_background:v,interpolation:w,controller_expanded:y,nan_opacity:k}=this.model.properties;this.on_change(e,(()=>{this._vtk_image_data=(0,a.data2VTKImageData)(this.model.data),this.invalidate_render()})),this.on_change(t,(()=>{this.colormap_selector.value=this.model.colormap;const e=new Event("change");this.colormap_selector.dispatchEvent(e)})),this.on_change(i,(()=>{this.shadow_selector.value=this.model.shadow?"1":"0";const e=new Event("change");this.shadow_selector.dispatchEvent(e)})),this.on_change(s,(()=>{this.sampling_slider.value=this.model.sampling.toFixed(2);const e=new Event("input");this.sampling_slider.dispatchEvent(e)})),this.on_change(n,(()=>{this.edge_gradient_slider.value=this.model.edge_gradient.toFixed(2);const e=new Event("input");this.edge_gradient_slider.dispatchEvent(e)})),this.on_change(r,(()=>{this._controllerWidget.setRescaleColorMap(this.model.rescale),this._vtk_renwin.getRenderWindow().render()})),this.on_change(o,(()=>{this.volume.getProperty().setAmbient(this.model.ambient),this._vtk_renwin.getRenderWindow().render()})),this.on_change(l,(()=>{this.volume.getProperty().setDiffuse(this.model.diffuse),this._vtk_renwin.getRenderWindow().render()})),this.on_change(d,(()=>{this._setting_camera||(this._set_camera_state(),this._vtk_renwin.getRenderWindow().render())})),this.on_change(_,(()=>{this.volume.getProperty().setSpecular(this.model.specular),this._vtk_renwin.getRenderWindow().render()})),this.on_change(c,(()=>{this.volume.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderWindow().render()})),this.on_change(h,(()=>{this._set_volume_visibility(this.model.display_volume),this._vtk_renwin.getRenderWindow().render()})),this.on_change(g,(()=>{this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderWindow().render()})),this.on_change(p,(()=>{void 0!==this.image_actor_i&&(this.image_actor_i.getMapper().setISlice(this.model.slice_i),this._vtk_renwin.getRenderWindow().render())})),this.on_change(m,(()=>{void 0!==this.image_actor_j&&(this.image_actor_j.getMapper().setJSlice(this.model.slice_j),this._vtk_renwin.getRenderWindow().render())})),this.on_change(u,(()=>{void 0!==this.image_actor_k&&(this.image_actor_k.getMapper().setKSlice(this.model.slice_k),this._vtk_renwin.getRenderWindow().render())})),this.on_change(v,(()=>{this._vtk_renwin.getRenderer().setBackground(...(0,a.hexToRGB)(this.model.render_background)),this._vtk_renwin.getRenderWindow().render()})),this.on_change(w,(()=>{this._set_interpolation(this.model.interpolation),this._vtk_renwin.getRenderWindow().render()})),this.on_change(y,(()=>{null!=this._controllerWidget&&this._controllerWidget.setExpanded(this.model.controller_expanded)})),this.on_change(k,(()=>{const e=this.image_actor_i.getProperty().getScalarOpacity();e.get(["nodes"]).nodes[0].y=this.model.nan_opacity,e.modified(),this._vtk_renwin.getRenderWindow().render()}))}render(){this._vtk_renwin=null,this._orientationWidget=null,this._axes=null,super.render(),this._create_orientation_widget(),this._set_axes(),this._vtk_renwin.getRenderer().resetCamera(),Object.keys(this.model.camera).length>0&&this._set_camera_state(),this._get_camera_state()}invalidate_render(){this._vtk_renwin=null,super.invalidate_render()}init_vtk_renwin(){this._vtk_renwin=a.vtkns.FullScreenRenderWindow.newInstance({rootContainer:this.shadow_el,container:this._vtk_container})}plot(){this._controllerWidget=a.vtkns.VolumeController.newInstance({size:[400,150],rescaleColorMap:this.model.rescale}),this._plot_volume(),this._plot_slices(),this._controllerWidget.setupContent(this._vtk_renwin.getRenderWindow(),this.volume,!0),this._controllerWidget.setContainer(this.el),this._controllerWidget.setExpanded(this.model.controller_expanded),this._connect_js_controls(),this._vtk_renwin.getRenderWindow().getInteractor(),this._vtk_renwin.getRenderWindow().getInteractor().setDesiredUpdateRate(45),this._set_volume_visibility(this.model.display_volume),this._set_slices_visibility(this.model.display_slices),this._vtk_renwin.getRenderer().setBackground(...(0,a.hexToRGB)(this.model.render_background)),this._set_interpolation(this.model.interpolation),this._set_camera_state()}get vtk_image_data(){return this._vtk_image_data||(this._vtk_image_data=(0,a.data2VTKImageData)(this.model.data)),this._vtk_image_data}get volume(){return this._vtk_renwin.getRenderer().getVolumes()[0]}get image_actor_i(){return this._vtk_renwin.getRenderer().getActors()[0]}get image_actor_j(){return this._vtk_renwin.getRenderer().getActors()[1]}get image_actor_k(){return this._vtk_renwin.getRenderer().getActors()[2]}get shadow_selector(){return this.el.querySelector(".js-shadow")}get edge_gradient_slider(){return this.el.querySelector(".js-edge")}get sampling_slider(){return this.el.querySelector(".js-spacing")}get colormap_selector(){return this.el.querySelector(".js-color-preset")}_connect_js_controls(){const{el:e}=this._controllerWidget.get("el");if(void 0!==e){e.querySelector(".js-button").addEventListener("click",(()=>this.model.controller_expanded=this._controllerWidget.getExpanded()))}this.colormap_selector.addEventListener("change",(()=>{this.model.colormap=this.colormap_selector.value})),this.model.colormap?this.model.properties.colormap.change.emit():this.model.colormap=this.colormap_selector.value,this.shadow_selector.addEventListener("change",(()=>{this.model.shadow=!!Number(this.shadow_selector.value)})),(this.model.shadow=!!Number(this.shadow_selector.value))&&this.model.properties.shadow.change.emit(),this.sampling_slider.addEventListener("input",(()=>{const e=Number(this.sampling_slider.value);Math.abs(this.model.sampling-e)>=.005&&(this.model.sampling=e)})),Math.abs(this.model.sampling-Number(this.shadow_selector.value))>=.005&&this.model.properties.sampling.change.emit(),this.edge_gradient_slider.addEventListener("input",(()=>{const e=Number(this.edge_gradient_slider.value);Math.abs(this.model.edge_gradient-e)>=.005&&(this.model.edge_gradient=e)})),Math.abs(this.model.edge_gradient-Number(this.edge_gradient_slider.value))>=.005&&this.model.properties.edge_gradient.change.emit()}_plot_slices(){const e=this._vtk_image_data,t=a.vtkns.ImageSlice.newInstance(),i=a.vtkns.ImageSlice.newInstance(),s=a.vtkns.ImageSlice.newInstance(),n=a.vtkns.ImageMapper.newInstance(),r=a.vtkns.ImageMapper.newInstance(),o=a.vtkns.ImageMapper.newInstance();n.setInputData(e),n.setISlice(this.model.slice_i),t.setMapper(n),r.setInputData(e),r.setJSlice(this.model.slice_j),i.setMapper(r),o.setInputData(e),o.setKSlice(this.model.slice_k),s.setMapper(o);const l=a.vtkns.PiecewiseFunction.newInstance(),d=this.volume.getProperty().getRGBTransferFunction(0),_=this.volume.getMapper().getInputData().getPointData().getScalars().getRange();l.removeAllPoints(),l.addPoint(_[0]-1,this.model.nan_opacity),l.addPoint(_[0],1),l.addPoint(_[1],1);const c=t.getProperty();i.setProperty(c),s.setProperty(c),c.setRGBTransferFunction(d),c.setScalarOpacity(l);const h=this._vtk_renwin.getRenderer();h.addActor(t),h.addActor(i),h.addActor(s)}_plot_volume(){const e=this.vtk_image_data,t=a.vtkns.Volume.newInstance(),i=a.vtkns.VolumeMapper.newInstance();t.setMapper(i),i.setInputData(e);const s=(e.getPointData().getScalars()||e.getPointData().getArrays()[0]).getRange(),n=a.vtkns.ColorTransferFunction.newInstance();if(null!=this.model.colormap){const e=a.vtkns.ColorTransferFunction.vtkColorMaps.getPresetByName(this.model.colormap);n.applyColorMap(e)}n.onModified((()=>this.model.mapper=(0,a.vtkLutToMapper)(n)));const r=a.vtkns.PiecewiseFunction.newInstance(),o=.7*Math.sqrt(e.getSpacing().map((e=>e*e)).reduce(((e,t)=>e+t),0));i.setSampleDistance(o),t.getProperty().setRGBTransferFunction(0,n),t.getProperty().setScalarOpacity(0,r),t.getProperty().setInterpolationTypeToFastLinear(),t.getProperty().setScalarOpacityUnitDistance(0,a.vtkns.BoundingBox.getDiagonalLength(e.getBounds())/Math.max(...e.getDimensions())),t.getProperty().setGradientOpacityMinimumValue(0,0),t.getProperty().setGradientOpacityMaximumValue(0,.05*(s[1]-s[0])),t.getProperty().setShade(this.model.shadow),t.getProperty().setUseGradientOpacity(0,!0),t.getProperty().setGradientOpacityMinimumOpacity(0,0),t.getProperty().setGradientOpacityMaximumOpacity(0,1),t.getProperty().setAmbient(this.model.ambient),t.getProperty().setDiffuse(this.model.diffuse),t.getProperty().setSpecular(this.model.specular),t.getProperty().setSpecularPower(this.model.specular_power),this._vtk_renwin.getRenderer().addVolume(t)}_set_interpolation(e){"fast_linear"==e?(this.volume.getProperty().setInterpolationTypeToFastLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):"linear"==e?(this.volume.getProperty().setInterpolationTypeToLinear(),this.image_actor_i.getProperty().setInterpolationTypeToLinear()):(this.volume.getProperty().setInterpolationTypeToNearest(),this.image_actor_i.getProperty().setInterpolationTypeToNearest())}_set_slices_visibility(e){this.image_actor_i.setVisibility(e),this.image_actor_j.setVisibility(e),this.image_actor_k.setVisibility(e)}_set_volume_visibility(e){this.volume.setVisibility(e)}}i.VTKVolumePlotView=l,l.__name__="VTKVolumePlotView";class d extends o.AbstractVTKPlot{constructor(e){super(e)}}i.VTKVolumePlot=d,r=d,d.__name__="VTKVolumePlot",r.prototype.default_view=l,r.define((({Any:e,Array:t,Boolean:i,Int:s,Number:n,String:r,Struct:o})=>({ambient:[n,.2],colormap:[r],data:[e],diffuse:[n,.7],display_slices:[i,!1],display_volume:[i,!0],edge_gradient:[n,.2],interpolation:[a.Interpolation,"fast_linear"],mapper:[o({palette:t(r),low:n,high:n}),{palette:[],low:0,high:0}],nan_opacity:[n,1],render_background:[r,"#52576e"],rescale:[i,!1],sampling:[n,.4],shadow:[i,!0],slice_i:[s,0],slice_j:[s,0],slice_k:[s,0],specular:[n,.3],specular_power:[n,8],controller_expanded:[i,!0]}))),r.override({height:300,width:300})},
"a4e5946204": function _(e,t,n,i,r){var s;i();const _=e("@bokehjs/core/util/object"),o=e("99a25e6992"),c=e("b06d05fa3e"),a=e("5e89c7b3eb"),h=e("df9946ff52"),d="panel";class l extends c.AbstractVTKView{initialize(){super.initialize(),this._renderable=!1,this._synchronizer_context=h.vtkns.SynchronizableRenderWindow.getSynchronizerContext(`${d}-{this.model.id}`)}connect_signals(){super.connect_signals();const{arrays:e,scene:t,one_time_reset:n}=this.model.properties;this.on_change([e,t],(0,o.debounce)((()=>{this._vtk_renwin.delete(),this._vtk_renwin=null,this.invalidate_render()}),20)),this.on_change(n,(()=>{this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters()}))}init_vtk_renwin(){this._vtk_renwin=h.vtkns.FullScreenRenderWindowSynchronized.newInstance({rootContainer:this.el,container:this._vtk_container,synchronizerContext:this._synchronizer_context})}remove(){this._vtk_renwin&&this._vtk_renwin.delete(),super.remove()}plot(){this._vtk_renwin.getRenderWindow().clearOneTimeUpdaters();const e=(0,_.clone)(this.model.scene);this._sync_plot(e,(()=>this._on_scene_ready())).then((()=>{this._set_camera_state(),this._get_camera_state()}))}_on_scene_ready(){this._renderable=!0,this._camera_callbacks.push(this._vtk_renwin.getRenderer().getActiveCamera().onModified((()=>this._vtk_render()))),this._orientationWidget||this._create_orientation_widget(),this._axes||this._set_axes(),this._vtk_renwin.resize(),this._vtk_render()}_sync_plot(e,t){this._renderable=!1,this._unsubscribe_camera_cb(),this._synchronizer_context.setFetchArrayFunction((e=>Promise.resolve(this.model.arrays[e])));const n=this._synchronizer_context.getInstance(this.model.scene.dependencies[0].id);return n&&!this._vtk_renwin.getRenderer()&&this._vtk_renwin.getRenderWindow().addRenderer(n),this._vtk_renwin.getRenderWindow().synchronize(e).then(t)}}n.VTKSynchronizedPlotView=l,l.__name__="VTKSynchronizedPlotView";class v extends c.AbstractVTKPlot{constructor(e){super(e),(0,a.initialize_fullscreen_render)(),this.outline=h.vtkns.OutlineFilter.newInstance();const t=h.vtkns.Mapper.newInstance();t.setInputConnection(this.outline.getOutputPort()),this.outline_actor=h.vtkns.Actor.newInstance(),this.outline_actor.setMapper(t)}getActors(e){let t=this.renderer_el.getRenderer().getActors();if(e){const n=this.renderer_el.getSynchronizerContext(d);t=t.filter((t=>{const i=n.getInstanceId(t);return!!i&&i.slice(-16)==e.slice(1,17)}))}return t}}n.VTKSynchronizedPlot=v,s=v,v.__name__="VTKSynchronizedPlot",v.__module__="panel.models.vtk",s.prototype.default_view=l,s.define((({Any:e,Array:t,Boolean:n,Bytes:i,Dict:r,String:s})=>({arrays:[r(i),{}],arrays_processed:[t(s),[]],enable_keybindings:[n,!1],one_time_reset:[n,!1],rebuild:[n,!1],scene:[e,{}]}))),s.override({height:300,width:300})},
"5e89c7b3eb": function _(e,n,o,t,r){t(),o.initialize_fullscreen_render=function(){const e={newInstance:window.vtk.macro.newInstance(((e,n,o={})=>{Object.assign(n,l,o),window.vtk.macro.obj(e,n),window.vtk.macro.get(e,n,["renderWindow","openGLRenderWindow","interactor","rootContainer","container","controlContainer","synchronizerContext"]),function(e,n){n.renderWindow=i.vtkns.SynchronizableRenderWindow.newInstance({synchronizerContext:n.synchronizerContext}),n.openGLRenderWindow=i.vtkns.OpenGLRenderWindow.newInstance(),n.openGLRenderWindow.setContainer(n.container),n.renderWindow.addView(n.openGLRenderWindow),n.interactor=i.vtkns.RenderWindowInteractor.newInstance(),n.interactor.setInteractorStyle(i.vtkns.InteractorStyleTrackballCamera.newInstance()),n.interactor.setView(n.openGLRenderWindow),n.interactor.initialize(),n.interactor.bindEvents(n.container),e.getRenderer=()=>n.renderWindow.getRenderers()[0],e.removeController=()=>{const e=n.controlContainer;e&&e.parentNode.removeChild(e)},e.setControllerVisibility=e=>{n.controllerVisibility=e,n.controlContainer&&(n.controlContainer.style.display=e?"block":"none")},e.toggleControllerVisibility=()=>{e.setControllerVisibility(!n.controllerVisibility)},e.addController=o=>{n.controlContainer=document.createElement("div"),(0,i.applyStyle)(n.controlContainer,n.controlPanelStyle||a),n.rootContainer.appendChild(n.controlContainer),n.controlContainer.innerHTML=o,e.setControllerVisibility(n.controllerVisibility),n.rootContainer.addEventListener("keypress",(n=>{"c"===String.fromCharCode(n.charCode)&&e.toggleControllerVisibility()}))},e.delete=window.vtk.macro.chain(e.setContainer,n.openGLRenderWindow.delete,e.delete),e.resize=()=>{const e=n.container.getBoundingClientRect(),o=window.devicePixelRatio||1;n.openGLRenderWindow.setSize(Math.floor(e.width*o),Math.floor(e.height*o)),n.resizeCallback&&n.resizeCallback(e),n.renderWindow.render()},e.setResizeCallback=o=>{n.resizeCallback=o,e.resize()},n.listenWindowResize&&window.addEventListener("resize",e.resize);e.resize()}(e,n)}))};i.vtkns.FullScreenRenderWindowSynchronized=e};const i=e("df9946ff52"),l={containerStyle:null,controlPanelStyle:null,listenWindowResize:!0,resizeCallback:null,controllerVisibility:!0,synchronizerContextName:"default"},a={position:"absolute",left:"25px",top:"25px",backgroundColor:"white",borderRadius:"5px",listStyle:"none",padding:"5px 10px",margin:"0",display:"block",border:"solid 1px black",maxWidth:"calc(100vw - 70px)",maxHeight:"calc(100vh - 60px)",overflow:"auto"}},
}, "4e90918c0a", {"index":"4e90918c0a","models/index":"2fe1822b2b","models/ace":"6227c89639","models/layout":"9b11ce01a3","models/util":"a3669a897a","models/anywidget_component":"1f663ffe94","models/reactive_esm":"50fda3c782","models/event-to-object":"a572dba9cd","models/html":"4c04683fdc","styles/models/html.css":"8694ed3f61","styles/models/esm.css":"727a14f76b","models/audio":"fd59c985b3","models/browser":"5a16cc23e6","models/button":"1db93211cd","models/button_icon":"1738ddeb3a","models/icon":"6c7fbea0ef","models/card":"d7035097d8","models/column":"b273e5b2fb","styles/models/card.css":"6342ac8e26","models/checkbox_button_group":"51fbe9e2d0","models/chatarea_input":"27a077673d","models/textarea_input":"b7d595d74a","models/comm_manager":"1bec1b1fcc","models/customselect":"92bbd30bd1","models/multiselect":"27b5580835","models/tabulator":"53b5147b3d","models/data":"be689f0377","styles/models/tabulator.css":"cb7ce3ba00","models/datetime_picker":"100965d6f3","models/datetime_slider":"c97cc0eade","models/deckgl":"01df2ec63b","models/lumagl":"a49afbffe9","models/tooltips":"f8f8ea4284","models/discrete_player":"0dca2cd4f6","models/player":"96e805ccb5","models/echarts":"1da56f3c52","models/feed":"4cfe0841a5","models/file_download":"84a13dddfb","models/file_dropper":"e8b7476f90","styles/models/filedropper.css":"c03dd3c931","models/ipywidget":"8a8089cbf3","models/json":"245cd3cfde","models/jsoneditor":"a123a88e31","models/katex":"f672d71a9f","models/location":"bd8e0fe48b","models/mathjax":"d889a68424","models/modal":"8c62aa80d9","styles/models/modal.css":"be4b4352c6","models/pdf":"f87ad1873c","models/perspective":"29a0b0da9a","styles/models/perspective.css":"2e2913ea54","models/plotly":"7d9124b744","styles/models/plotly.css":"3d56c75186","models/progress":"b1f4d68596","models/quill":"f6d86c7342","models/radio_button_group":"25e2d7c208","models/react_component":"ace9331ee1","models/reactive_html":"d5752cda5a","models/singleselect":"4155401209","models/speech_to_text":"5ac2cab0ab","models/state":"92822cb73a","models/tabs":"2231cdc549","models/terminal":"a961b5ae5e","models/text_input":"8be416b160","models/text_to_speech":"a04eb51988","models/time_picker":"1afcab4e45","models/toggle_icon":"ad985f285e","models/tooltip_icon":"ae3a172647","models/trend":"29d55a28a9","models/vega":"119dc23765","models/video":"79dc37b888","styles/models/video.css":"dfe21e6f1b","models/videostream":"f8afc4e661","models/vizzu":"1f7bc1f95b","models/vtk/index":"c51f25e2a7","models/vtk/vtkjs":"ac55912dc1","models/vtk/vtklayout":"b06d05fa3e","models/vtk/util":"df9946ff52","models/vtk/vtkcolorbar":"b1d68776a9","models/vtk/vtkaxes":"0379dcf1cd","models/vtk/vtkvolume":"18592eecef","models/vtk/vtksynchronized":"a4e5946204","models/vtk/panel_fullscreen_renwin_sync":"5e89c7b3eb"}, {});});
