@page CHANGES-2-5 Version 2.5

## Version 2.5 (Dec 19, 2018)

This page contains changes that will end up in 2.5

Changes from version 2.4 which are relevant for users:
- Changes leading to incompatible behavior:
  - \ref RMSD, \ref MULTI-RMSD, \ref PATHMSD, \ref PROPERTYMAP, \ref PCAVARS, \ref PCARMSD, \ref FIT_TO_TEMPLATE,
    \ref DIPOLE, \ref ALPHARMSD, \ref ANTIBETARMSD, and \ref PARABETARMSD now automatically make molecules whole.
    In case you do not want them to do it, use NOPBC flag,
  - There is some subtle change in the installation layout (see below). There should be no visible effect, however it is now compulsory
    to set correctly the `LD_LIBRARY_PATH` variable for the linux executable to work correctly. The procedure has been tested well on OSX and Linux,
    but could give problems on other platform. Please report possible problems on the mailing list.
  - \ref driver now stops correctly when using \ref COMMITTOR. If you want to continue the analysis, use the `NOSTOP` flag in \ref COMMITTOR.
  - \ref METAD the calculation of the reweighting factor is now activated by CALC_RCT instead of REWEIGHTING_NGRID and REWEIGHTING_NHILLS, the frequency of update can be set 
    by RCT_USTRIDE, the default value is 1 and should be OK for most of the cases
  - Fixed sign in Cartesian components of \ref PUCKERING with 6 membered rings (thanks to Carol Simoes and Javi Iglesias).

- New actions:
  - \ref COLLECT_FRAMES
  - \ref EUCLIDEAN_DISSIMILARITIES
  - \ref HBPAMM_MATRIX
  - \ref HBPAMM_SH
  - \ref LANDMARK_SELECT_FPS
  - \ref LANDMARK_SELECT_RANDOM
  - \ref LANDMARK_SELECT_STAGED
  - \ref LANDMARK_SELECT_STRIDE
  - \ref OUTPUT_ANALYSIS_DATA_TO_COLVAR
  - \ref OUTPUT_ANALYSIS_DATA_TO_PDB
  - \ref OUTPUT_PCA_PROJECTION
  - \ref PAMM
  - \ref PLUMED
  - \ref PRINT_DISSIMILARITY_MATRIX
  - \ref PROJECT_ALL_ANALYSIS_DATA
  - \ref READ_DISSIMILARITY_MATRIX
  - \ref RESELECT_LANDMARKS
  - \ref REWEIGHT_WHAM
  - \ref SKETCHMAP_CONJGRAD
  - \ref SKETCHMAP_POINTWISE
  - \ref SKETCHMAP_READ
  - \ref SKETCHMAP_SMACOF
  - \ref SKETCH_MAP
  - \ref SMACOF_MDS
  - \ref WHAM_HISTOGRAM
  - \ref WHAM_WEIGHTS

- New command line tools:
  - \ref completion (used to generate command line completion scripts).
  - \ref pdbrenumber (see \issue{371}).

- New modules:
  - A new PIV module has been included, contributed by Silvio Pipolo and Fabio Pietrucci.
    This module implements the following collective variable:
    - \ref PIV
  - A new LOGMFD module has been included, contributed by Tetsuya Morishita.
    This module implements the following bias:
    - \ref LOGMFD

- Changes in the ISDB module
  - \ref CS2BACKBONE is now mpi parallelized in particular with DOSCORE and CAMSHIFT
  - \ref SAXS has an additional implementation based on Bessel functions that can be faster for large systems (new keyword BESSEL)
  - \ref SAXS keyword SCEXP has been renamed into SCALEINT
  - \ref SAXS includes the MARTINI bead structure factors for Proteins and Nucleic Acids
  - \ref SAXS includes a GPU implementation based on ArrayFire (need to be linked at compile time) that can be activated with GPU
  - \ref METAINFERENCE and all related methods has a new keyword REGRES_ZERO to scale data using a linear scale fit
  - \ref CALIBER new bias to perform Maximum Caliber replica-averaged restrained simulations 

- Changes in the eABF/DRR module (contributed by Haochuan Chen and Haohao Fu):
  - \ref DRR now supports the extended generalized ABF(egABF) method.
  - \ref DRR accepts different GRID options for CVs and extended variables.
  - The MAXFACTOR option is added in \ref DRR to control the factor of biasing force.
  - \ref drr_tool can calculate the divergence of gradients now. (Maybe useful for future pABF)
  - Fixed conflicts of output files in multiple replicas.

- Changes in the EDS module:
  - \ref EDS implements Levenberg-Marquardt optimization in addition to previous gradient descent. 
  - \ref EDS no longer automatically increases prefactor for bias parameter updates. This results in more stable optimization for the cases tested.
  - \ref EDS now has a larger default RANGE parameter to go with these other changes.

- Other changes:
  - \ref METAD there is a new FLYING_GAUSSIAN keyword to activate the flying gaussian methods by Spiwok (contributed by Spiwok and Hozzova)
  - \ref EXTERNAL can now SCALE the input grid. This allows for more flexibility without modifying the grid file.
  - \ref ALPHABETA can now combine dihedral angles with different coefficients
  - \ref INCLUDE can now be used also before setup actions.
  - \ref CENTER can now be computed using trigonometric functions (PHASES) to simplify its calculation with periodic boundary conditions.
  - Libmatheval is not used anymore. \ref MATHEVAL (and \ref CUSTOM) are still available
    but employ an internal implementation of the lepton library.
    Functions available in libmatheval and absent in the original lepton library have been added so as to have backward compatibility.
    `atan2(y,x)` function has also been added.
    Notice that MATHEVAL (and CUSTOM) \ref switchingfunction "switching functions"
    using the lepton library have been further optimized with respect to PLUMED 2.4.
    Finally, notice that it is possible to use asmjit to optimize performance (see \ref Lepton).
  - Implemented bash autocompletion, see \ref BashAutocompletion.
  - \ref MOLINFO now allows selecting atoms from chains with a numeric ID (see \issue{320}).
  - Removed the patch for GMX 5.1.4
  - LAMMPS patch has been finally removed. Notice that LAMMPS has native support for PLUMED now.
  - AMBER patch has been finally removed. Notice that AMBER (sander module) has native support for PLUMED starting from version 15.
  - \ref RMSD calculation has been optimized. This should positively affect the performances of CVs where
     many RMSD values are computed on small groups of atoms, such as secondary structure variables.
  - In \ref METAD, when using a bias factor equal to one (no bias) the `rct` component is set to zero rather than to one.
  - New shortcuts are available for selecting atoms: `@allatoms` and `@mdatoms` (see \ref atomSpecs).
  - When using \ref MOLINFO, also the following shortcuts are available for selecting atoms: `@nucleic`, `@protein`, `@water`, `@ions`, `@hydrogens`, `@nonhydrogens`.
  - When using \ref MOLINFO, individual atoms can be chosen also from water molecules (e.g. `@OW-100`).
  - Additional switching function COSINUS contributed by Michael King
  - added API to set the number of used openMP threads from the linked code, updated gromacs 2018.3 patch to use it

Changes from version 2.4 which are relevant for developers:
- Code has been cleanup up replacing a number of pointers with `std::unique_ptr`. All `delete` statements
  in the core parts of the code have been eliminated.
- Exceptions cannot be disabled (`--disable-cxx-exceptions` option has been removed from `./configure`).
- Every exception thrown in PLUMED now also writes its message on PLUMED log.
- Runtime loader in `Plumed.c` now works also when linked without `-rdynamic` (that is, 
  its names are not exported). Notice that all the combinations are expected to
  work, that is: `Plumed.c` from <=2.4 or >=2.5 combined with libplumedKernel
  from <=2.4 or >=2.5. In order to achieve this the following changes are implemented:
  - libplumedKernel does not depend anymore on `Plumed.c`. This allows loading it even
    in cases where names in the loader are not visible. The relevant function needed
    to be compatible with `Plumed.c` <=2.4 are found using `dlsym`.
  - `Plumed.c` does not need anymore libplumedKernel to register itself, but rather
    searches the relevant functions using `dlsym`. In addition, if it is not able to
    load `libplumedKernel` since the latter is <=2.4 and needs `Plumed.c` to be visible,
    it just uses as a fallback `libplumed`, which should load properly.
- In addition to the capability mentioned above, the MD-code interface has been significantly
  improved and allows for:
  - Translation of exception (allowing to mix PLUMED and an MD-code linked against a different C++ library).
  - Possibility to choose the path to the PLUMED kernel while instantiating a Plumed object.
  See the developer documentation for more information.
- The installation layout of shared libraries has been modified. In particular,
  both `libplumed.so` and `plumed` links to `libplumedKernel.so`.
  This reduces considerably the size of the installed package. In addition, it allows
  using two-level namespace on OSX. Notice that this implies that on Linux one should
  always set the `LD_LIBRARY_PATH` flag to have a working executable.
- A smaller number of header files is installed. In particular, all the files that were historically generated in subdirectories
  (such as `plumed/core/tools/Vector.h', just including `plumed/tools/Vector.h`) are not installed and the related include
  statements are fixed. This makes the installed package smaller.
- List of preferred compilers (used when `CXX` or `CC` are not set) has been changed. On OSX, `./configure` will try `clang++/clang` as first choices.
- Added `--enable-static-archive` to `./configure` to build a `libplumed.a` static library (yes by default).
- Stop setting `DYLD_LIBRARY_PATH` in `sourceme.sh` and in modulefile. Notice that as of PLUMED v2.3.3
  it should not be needed.
- Coverage scan is not anymore contained in developer manual. It can be found in a separate repository
  `github.com/coverage-branch` (see \issue{348}). In addition, coverage for third-party libraries included in PLUMED
  is reported as well.
- It is not possible anymore to use `make install prefix=/path`. Prefix can only be changed during `./configure` (see \issue{332}).
- Exception class has been rewritten to allow more extensive messages. Now also function name is shown.
- On linux, library is linked with `-Bsymbolic`.
- When launching `plumed`, flags `--no-mpi` and `--mpi` can appear multiple times. The last appearence is the effective one.
- Internal BLAS and LAPACK libraries updated to gromacs 2018.
- Choosing `./configure --prefix=$PWD` does not lead anymore to deletion of all header files.
- A copy of `plumed-runtime` is installed in `prefix/lib/plumed` and can be used for testing.
- Absolute/relative soname/install_name can be configured on linux/OSX. This feature is only
  for testing, the default choice is the typical one used on the respective operating system.
- On OSX, `plumed` and `libplumed.dylib` will find `libplumedKernel.dylib` using `@loader_path`.
- Using CXX compiler to link the main program.
- plumed can be compiled with ArrayFire to enable for gpu code. \ref SAXS collective variable is available as part of the isdb module to provide an example of a gpu implementation for a CV


## Version 2.5.1 (Apr 1, 2019)

For users:
- in \ref SAXS the keyword ADDEXP is removed. Furthemore, SAXS intensities are automatically normalised for I(0)=1, in case experimental data are provided, the intensity is rescaled with the intensity of the lowest q provided. As a consequence SCALEINT is only needed for additional adjustments.
- gromacs patch updated to gromacs 2018.5
- Fixed a bug in gromacs patch that was resulting in incorrect number of threads (0) set when not explicitly using `-ntomp` on the 
  command line or setting `OMP_NUM_THREADS` (see \issue{446}). To apply this fix you need to re-patch gromacs.
  Notice that setting the number of threads to zero might lead to inconsistent results when using secondary structure variables
  or other multicolvars.
- Fixed PLUMED so that when zero threads are selected from gromacs (see previous fix) the number of used threads is set to 1.
  This fix allows to use a GROMACS executable patched with PLUMED 2.5.0 and linked at runtime with PLUMED 2.5.1 without introducing
  errors. However, re-patching is preferred since it selectes the correct number of threads.
- Python wrappers:
  - Fixed building of python interface on MacOS Mojave (see \issue{445}, thanks to Omar Valsson).
  - Numpy is not required anymore at build time (though it is required at runtime for our tests).
  - Raw python arrays can be passed as an alternative to Numpy ndarrays.

## Version 2.5.2 (Jul 19, 2019)

For users:
- New shortcuts are available for selecting protein atoms: `@chi2-#`, `@chi3-#`,`@chi4-#` and `@chi5-#`
- Fixed performance of \ref CUSTOM when having zero derivatives with respect to some arguments.
- New --parse-only option in \ref driver to check the validity of a plumed input file
- New patch for GROMACS 2019.2
- Module VES: Fixed performance of \ref BF_CUSTOM for basis functions with linear terms (e.g. having zero derivatives). 
- Python wrappers:
  - Python module is now always named `plumed` irrespectively of program prefix and suffix. Notice 
    that python module is installed inside the `lib/program_name` directory and thus it is not necessary to
    use `program_name` in order to install multiple modules side by side.
  - Python module can be compiled without compiling PLUMED first.
  - `Plumed` object can be explicitly finalized using `finalize()`. Can be used to make sure all files are closed,
    but it is not necessary if the `Plumed` object gets correctly collected by Python.
  - `Plumed` object can be used in context managers (e.g. `with plumed.Plumed() as p:`).
- Precompiled binaries are available on Anaconda cloud on the [conda-forge channel](https://anaconda.org/conda-forge/plumed).

## Version 2.5.3 (Oct 11, 2019)

For users:
- Fixed a bug with \ref CONVERT_TO_FES and periodic variables, see \issue{441}
- Fixed a bug with \ref FOURIER_TRANSFORM 
- Updated patch for GROMACS 2019.4
- Updated patch for GROMACS 2018.8
- Python module:
  - Fixed building with clang-8.
  - Set `language_level` for cython to the actually used language level.
  - Force using cython when compiling from source. Still using the pre-generated cpp file
    when installing from PyPI, to avoid cython dependency.
  - Using python 2 to create the cpp file uploaded on PyPI (this will change to python 3 in 2.6, see \issue{502}).
- Module VES: Fixed a bug in updating of bias potential in \ref VES_LINEAR_EXPANSION that is present for certain integrators that call the calculation of the bias multiple times (see [here](https://groups.google.com/d/msg/plumed-users/kPZu_tNZtgk/LrkS0EqrCQAJ)) and replica exchange.

## Version 2.5.4 (Jan 27, 2020)

For users:
- Includes all fixes up to 2.4.7

## Version 2.5.5 (Jul 8, 2020)

For users:
- Includes all fixes up to 2.4.8

For developers:
- Small fix to avoid unique global symbols (see \issue{549})

