#    For help with setup type: python setup.py --help
#
#    pytiff -- a library for using TIFF files and advanced imaging in Python
#    Copyright (C) 2005 by Oliver M. Haynold
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#    $Id: setup.py,v 1.8 2004/09/03 01:26:38 oliverh Exp oliverh $
    
from distutils.core import setup, Extension;

setup( name = "pytiff",
       version = "0.1.6",
       author = "Oliver M. Haynold",
       author_email = "pytiff_maintainer@haynold.com",
       url = "http://www.haynold.com/software_projects/2004/pytiff/",
       license = "GNU Public License",
       ext_modules = [ Extension( "pytiff",
                                  sources = ["pytiff.c"],
                                  libraries = ["tiff"]) ],
       headers = ["pytiff-constants.h"],
       data_files = \
       [ ("local/share/doc/pytiff/testimages", ["testimages/cramps.tif",
                                                "testimages/fax2d.tif",
                                                "testimages/g3test.tif",
                                                "testimages/caspian.tif",
                                                "testimages/horse.tif",
                                                "testimages/horse-tiled.tif",
                                                "testimages/horse-16bit-col-bigendian.tif",
                                                "testimages/horse-16bit-col-littleendian.tif",
                                                "testimages/horse-separate-planes.tif",
                                                ] ),
         ("local/share/doc/pytiff", ["test_pytiff.py", "pytiff.html", "README", "CHANGES"])
         ]
       )
