/***************************************************************************
 *  qgsgeometrycheckerplugin.cpp                                           *
 *  -------------------                                                    *
 *  copyright            : (C) 2014 by Sandro Mani / Sourcepole AG         *
 *  email                : smani@sourcepole.ch                             *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "qgsgeometrycheckerplugin.h"
#include "qgisinterface.h"
#include "qgsgeometrycheckerdialog.h"

QgsGeometryCheckerPlugin::QgsGeometryCheckerPlugin( QgisInterface *iface )
  : QgisPlugin( sName, sDescription, sCategory, sPluginVersion, sPluginType )
  , mIface( iface )
{
}

void QgsGeometryCheckerPlugin::initGui()
{
  mDialog = new QgsGeometryCheckerDialog( mIface, mIface->mainWindow() );
  mDialog->setWindowModality( Qt::NonModal );
  mMenuAction = new QAction( QIcon( ":/geometrychecker/icons/geometrychecker.png" ), QApplication::translate( "QgsGeometryCheckerPlugin", "Check Geometries" ), this );
  connect( mMenuAction, &QAction::triggered, mDialog, &QWidget::show );
  connect( mMenuAction, &QAction::triggered, mDialog, &QWidget::raise );
  mIface->addPluginToVectorMenu( QApplication::translate( "QgsGeometryCheckerPlugin", "G&eometry Tools" ), mMenuAction );
}

void QgsGeometryCheckerPlugin::unload()
{
  delete mDialog;
  mDialog = nullptr;
  delete mMenuAction;
  mMenuAction = nullptr;
  mIface->removePluginVectorMenu( QApplication::translate( "QgsGeometryCheckerPlugin", "G&eometry Tools" ), mMenuAction );
}


//////////////////////////////////////////////////////////////////////////
//
//
//  THE FOLLOWING CODE IS AUTOGENERATED BY THE PLUGIN BUILDER SCRIPT
//    YOU WOULD NORMALLY NOT NEED TO MODIFY THIS, AND YOUR PLUGIN
//      MAY NOT WORK PROPERLY IF YOU MODIFY THIS INCORRECTLY
//
//
//////////////////////////////////////////////////////////////////////////


/**
 * Required extern functions needed  for every plugin
 * These functions can be called prior to creating an instance
 * of the plugin class
 */
// Class factory to return a new instance of the plugin class
QGISEXTERN QgisPlugin *classFactory( QgisInterface *qgisInterfacePointer )
{
  return new QgsGeometryCheckerPlugin( qgisInterfacePointer );
}
// Return the name of the plugin - note that we do not user class members as
// the class may not yet be insantiated when this method is called.
QGISEXTERN QString name()
{
  return sName;
}

// Return the description
QGISEXTERN QString description()
{
  return sDescription;
}

// Return the category
QGISEXTERN QString category()
{
  return sCategory;
}

// Return the type (either UI or MapLayer plugin)
QGISEXTERN int type()
{
  return sPluginType;
}

// Return the version number for the plugin
QGISEXTERN QString version()
{
  return sPluginVersion;
}

QGISEXTERN QString icon()
{
  return sPluginIcon;
}

// Delete ourself
QGISEXTERN void unload( QgisPlugin *pluginPointer )
{
  delete pluginPointer;
}
