//! Qore namespace
namespace Qore {
//! Xml namespace
namespace Xml {
//! The InputStreamSaxIterator class provides a SAX iterator for input streams based on <a href="http://xmlsoft.org">libxml2</a>
/***/
class InputStreamSaxIterator : public SaxIterator {

public:
//! creates a new InputStreamSaxIterator object from the input stream and the element name passed
/** @par Restrictions:
    @ref Qore::PO_NO_FILESYSTEM

    @param is the input stream
    @param element_name the name of the element to iterate through
    @param encoding an optional encoding of the input stream; if not given, then any encoding given in the file's XML preamble is used

    @par Example:
    @code
    InputStreamSaxIterator i(is, "DetailRecord");
    map printf("record %d: %y\n", $#, $1), i;
    @endcode

    @throw XMLDOC-CONSTRUCTOR-ERROR error parsing XML string
 */
 constructor(Qore::InputStream is, string element_name, __7_ string encoding);

public:
//! creates a new InputStreamSaxIterator object from the input stream and the element name passed
/** @par Restrictions:
    @ref Qore::PO_NO_FILESYSTEM

    @param is the input stream
    @param element_name the name of the element to iterate through
    @param opts the following options are accepted:
    - \c encoding: (string) the file's character encoding
    - \c xml_input_io: (AbstractXmlIoInputCallback) an AbstractXmlIoInputCallback object to resolve external XSD schema references
    - \c xml_parse_options: (int bitfield) XML parsing flags; see @ref xml_parsing_constants for more information
    - \c xsd: (string) an XSD string for schema validation while parsing

    @par Example:
    @code
    InputStreamSaxIterator i(is, "DetailRecord");
    map printf("record %d: %y\n", $#, $1), i;
    @endcode

    @throw INPUTSTREAMSAXITERATOR-OPTION-ERROR error in option hash
    @throw XMLDOC-CONSTRUCTOR-ERROR error parsing XML string

    @since xml 1.4
*/
 constructor(Qore::InputStream is, string element_name, hash opts);

public:
//! Throws an exception; objects of this class cannot be copied
/**@throw INPUTSTREAMSAXITERATOR-COPY-ERROR objects of this class cannot be copied
 */
 copy();
};
}
}
