/*
 *  RSGISApplySubtractOffsets.h
 *  RSGIS_LIB
 *
 *  Created by Pete Bunting on 27/01/2014.
 *  Copyright 2014 RSGISLib. All rights reserved.
 *  This file is part of RSGISLib.
 *
 *  RSGISLib is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  RSGISLib is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with RSGISLib.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef RSGISApplySubtractOffsets_H
#define RSGISApplySubtractOffsets_H

#include <iostream>
#include <string>

#include "gdal_priv.h"

#include "common/RSGISException.h"
#include "img/RSGISImageCalcException.h"
#include "img/RSGISCalcImageValue.h"
#include "img/RSGISCalcImage.h"

// mark all exported classes/functions with DllExport to have
// them exported by Visual Studio
#undef DllExport
#ifdef _MSC_VER
    #ifdef rsgis_calib_EXPORTS
        #define DllExport   __declspec( dllexport )
    #else
        #define DllExport   __declspec( dllimport )
    #endif
#else
    #define DllExport
#endif

namespace rsgis{namespace calib{
    
    
	class DllExport RSGISApplyDarkObjSubtractOffsets : public rsgis::img::RSGISCalcImageValue
    {
    public:
        RSGISApplyDarkObjSubtractOffsets(unsigned int numImageBands, bool nonNegative, float noDataVal = 0.0, bool useNoDataVal = false, float darkObjReflVal = 0.0);
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISApplyDarkObjSubtractOffsets();
    protected:
        unsigned int numImageBands;
        bool nonNegative;
        float noDataVal;
        bool useNoDataVal;
        float darkObjReflVal;
    };
    
    
    class DllExport RSGISApplyDarkObjSubtractSingleOffsets : public rsgis::img::RSGISCalcImageValue
    {
    public:
        RSGISApplyDarkObjSubtractSingleOffsets(unsigned int numImageBands, std::vector<double> offsetValues, bool nonNegative, float noDataVal = 0.0, bool useNoDataVal = false, float darkObjReflVal = 0.0);
        void calcImageValue(float *bandValues, int numBands, double *output);
        ~RSGISApplyDarkObjSubtractSingleOffsets();
    protected:
        unsigned int numImageBands;
        bool nonNegative;
        float noDataVal;
        bool useNoDataVal;
        float darkObjReflVal;
        std::vector<double> offsetValues;
    };
    
    
    
}}

#endif
