#
#  Read docs/INSTALL first to compile binary
#
#
# This a is quick script to get
# Sancp up and running as a non-root user
# Note: pcap chroot not yet supported 
#  to run, type:   ./install.sh
#
#

if [ ! -x sancp ]; then

	echo
	echo "Please, read docs/INSTALL first to compile the sancp binary, first"
	echo

else

adduser sancp
groupadd sancp

install -D -C sancp /usr/local/bin/sancp

install -D -C etc/sancp/sancp.conf /etc/sancp/sancp.conf

if [ -d /etc/init.d ]; then
	install -D -C etc/init.d/sancpd /etc/init.d/sancpd
fi

if [ ! -d /var/log/sancp ]; then
	mkdir -p /var/log/sancp
fi

chown -R sancp:sancp /var/log/sancp/
chown -R sancp:sancp /etc/sancp/

echo
echo Please edit: /etc/sancp/sancp.conf 
echo

if [ -e /etc/init.d/sancpd ]; then
	echo To start sancp run: /etc/init.d/sancpd start
	echo	
else
	echo Copy etc/init.d/sancpd to proper start-up directory
	echo  and run 'sancpd start' from there
fi
fi
