# gfortran

> Fortran 소스 파일을 전처리하고 컴파일한 다음 함께 어셈블하고 링크.
> 더 많은 정보: <https://gcc.gnu.org/onlinedocs/gfortran/Invoking-GNU-Fortran.html>.

- 여러 소스 파일을 실행 파일로 컴파일:

`gfortran {{경로/대상/소스1.f90 경로/대상/소스2.f90 ...}} -o {{경로/대상/출력_실행파일}}`

- 일반적인 경고를 표시하고, 출력에서 기호를 디버그하고, 디버깅에 영향을 주지 않고 최적화:

`gfortran {{경로/대상/소스.f90}} -Wall -g -Og -o {{경로/대상/출력_실행파일}}`

- 다른 경로의 라이브러리를 포함:

`gfortran {{경로/대상/소스.f90}} -o {{경로/대상/출력_실행파일}} -I{{경로/대상/수정_또는_포함}} -L{{경로/대상/라이브러리}} -l{{라이브러리_이름}}`

- 소스 코드를 어셈블러 명령어로 컴파일:

`gfortran -S {{경로/대상/소스.f90}}`

- 링크 없이 소스 코드를 객체 파일로 컴파일:

`gfortran -c {{경로/대상/소스.f90}}`
