# rg

> Ripgrep은 재귀적 라인 지향 검색 도구입니다.
> `grep`의 더 빠른 대안이 되는 것을 목표로 합니다.
> 더 많은 정보: <https://github.com/BurntSushi/ripgrep/blob/master/GUIDE.md>.

- 현재 디렉토리에서 정규 표현식을 재귀적으로 검색:

`rg {{정규_표현식}}`

- `.gitignore`에 나열된 파일 및 숨김 파일을 포함하여 현재 디렉토리에서 정규 표현식을 재귀적으로 검색:

`rg --no-ignore --hidden {{정규_표현식}}`

- 일부 하위 디렉토리에서만 정규 표현식을 검색:

`rg {{정규_표현식}} {{일부_하위_디렉토리}}`

- glob 패턴 (예: `README.*`)에 일치하는 파일에서 정규 표현식 검색:

`rg {{정규_표현식}} --glob {{글롭}}`

- 정규 표현식과 일치하는 파일 이름 검색:

`rg --files | rg {{정규_표현식}}`

- 일치하는 파일만 나열 (다른 명령에 파이핑할 때 유용):

`rg --files-with-matches {{정규_표현식}}`

- 주어진 정규 표현식과 일치하지 않는 줄 표시:

`rg --invert-match {{정규_표현식}}`

- 리터럴 문자열 패턴 검색:

`rg --fixed-strings -- {{문자열}}`
