# d2

> A modern diagram scripting language that turns text to diagrams.
> Note: The output file supports SVG and PNG file formats.
> More information: <https://d2lang.com/tour/man>.

- Compile and render a D2 source file into an output file:

`d2 {{path/to/input_file.d2}} {{path/to/output_file.ext}}`

- Watch live changes made to a D2 source file in the default web browser:

`d2 {{[-w|--watch]}} {{path/to/input_file.d2}} {{path/to/output_file.ext}}`

- Format a D2 source file:

`d2 fmt {{path/to/input_file.d2}}`

- List available themes:

`d2 themes`

- Use a different theme for the output file (list available themes first to get the desired `theme_id`):

`d2 {{[-t|--theme]}} {{theme_id}} {{path/to/input_file.d2}} {{path/to/output_file.ext}}`

- Make rendered diagrams look like hand sketches:

`d2 {{[-s|--sketch]}} true {{path/to/input_file.d2}} {{path/to/output_file.ext}}`
