import { CSSProperties } from 'react'

import { useIsDarkMode } from 'hooks/use-theme'

type LogoProps = {
  width?: number
  height?: number
  style?: CSSProperties
  isSmallScreen?: boolean
}

const ProxyLogo = ({ textColor = '#000', ...props }) => {
  return (
    <svg viewBox="0 0 280 108" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
      <g clipPath="url(#clip0_2122_9)">
        <path
          d="M120.058 104.73C119.711 104.73 119.434 104.626 119.226 104.418C119.018 104.21 118.914 103.933 118.914 103.586V68.9543C118.914 68.6076 119.018 68.3303 119.226 68.1223C119.434 67.9143 119.711 67.8103 120.058 67.8103H120.942C121.289 67.8103 121.566 67.9143 121.774 68.1223C121.982 68.3303 122.086 68.6076 122.086 68.9543V71.3983C122.953 70.2196 124.079 69.2489 125.466 68.4863C126.887 67.6889 128.673 67.2903 130.822 67.2903C132.867 67.2903 134.583 67.6543 135.97 68.3823C137.357 69.0756 138.483 70.0116 139.35 71.1903C140.217 72.3689 140.858 73.6863 141.274 75.1423C141.69 76.5983 141.915 78.0889 141.95 79.6143C141.985 80.1343 142.002 80.7063 142.002 81.3303C142.002 81.9543 141.985 82.5263 141.95 83.0463C141.915 84.5716 141.69 86.0623 141.274 87.5183C140.858 88.9743 140.217 90.2916 139.35 91.4703C138.483 92.6489 137.357 93.6023 135.97 94.3303C134.583 95.0236 132.867 95.3703 130.822 95.3703C128.673 95.3703 126.887 94.9716 125.466 94.1743C124.079 93.3769 122.953 92.4063 122.086 91.2623V103.586C122.086 103.933 121.982 104.21 121.774 104.418C121.566 104.626 121.289 104.73 120.942 104.73H120.058ZM130.51 92.3543C132.555 92.3543 134.167 91.9036 135.346 91.0023C136.525 90.1009 137.374 88.9223 137.894 87.4663C138.414 86.0103 138.709 84.4503 138.778 82.7863C138.813 81.8156 138.813 80.8449 138.778 79.8743C138.709 78.2103 138.414 76.6503 137.894 75.1943C137.374 73.7383 136.525 72.5596 135.346 71.6583C134.167 70.7569 132.555 70.3063 130.51 70.3063C128.534 70.3063 126.939 70.7743 125.726 71.7103C124.513 72.6463 123.611 73.8249 123.022 75.2463C122.467 76.6329 122.155 78.0369 122.086 79.4583C122.051 79.9783 122.034 80.6543 122.034 81.4863C122.034 82.3183 122.051 82.9943 122.086 83.5143C122.121 84.9009 122.433 86.2703 123.022 87.6223C123.646 88.9743 124.565 90.1009 125.778 91.0023C127.026 91.9036 128.603 92.3543 130.51 92.3543ZM148.921 94.8503C148.574 94.8503 148.297 94.7463 148.089 94.5383C147.881 94.3303 147.777 94.0529 147.777 93.7063V69.0063C147.777 68.6596 147.881 68.3823 148.089 68.1743C148.297 67.9316 148.574 67.8103 148.921 67.8103H149.753C150.1 67.8103 150.377 67.9316 150.585 68.1743C150.828 68.3823 150.949 68.6596 150.949 69.0063V71.3983C151.573 70.1849 152.474 69.2836 153.653 68.6943C154.832 68.1049 156.288 67.8103 158.021 67.8103H159.945C160.292 67.8103 160.569 67.9143 160.777 68.1223C160.985 68.3303 161.089 68.6076 161.089 68.9543V69.6823C161.089 70.0289 160.985 70.3063 160.777 70.5143C160.569 70.7223 160.292 70.8263 159.945 70.8263H157.709C155.629 70.8263 153.982 71.4329 152.769 72.6463C151.556 73.8596 150.949 75.5063 150.949 77.5863V93.7063C150.949 94.0529 150.828 94.3303 150.585 94.5383C150.377 94.7463 150.1 94.8503 149.753 94.8503H148.921ZM174.242 95.3703C171.746 95.3703 169.648 94.8503 167.95 93.8103C166.286 92.7703 165.003 91.3489 164.102 89.5463C163.235 87.7436 162.767 85.7329 162.698 83.5143C162.663 82.9943 162.646 82.2663 162.646 81.3303C162.646 80.3943 162.663 79.6663 162.698 79.1463C162.767 76.8929 163.235 74.8823 164.102 73.1143C165.003 71.3116 166.286 69.8903 167.95 68.8503C169.648 67.8103 171.746 67.2903 174.242 67.2903C176.738 67.2903 178.818 67.8103 180.482 68.8503C182.18 69.8903 183.463 71.3116 184.33 73.1143C185.231 74.8823 185.716 76.8929 185.786 79.1463C185.82 79.6663 185.838 80.3943 185.838 81.3303C185.838 82.2663 185.82 82.9943 185.786 83.5143C185.716 85.7329 185.231 87.7436 184.33 89.5463C183.463 91.3489 182.18 92.7703 180.482 93.8103C178.818 94.8503 176.738 95.3703 174.242 95.3703ZM174.242 92.3543C176.668 92.3543 178.644 91.5743 180.17 90.0143C181.695 88.4543 182.51 86.2009 182.614 83.2543C182.648 82.7343 182.666 82.0929 182.666 81.3303C182.666 80.5676 182.648 79.9263 182.614 79.4063C182.51 76.4249 181.695 74.1716 180.17 72.6463C178.644 71.0863 176.668 70.3063 174.242 70.3063C171.815 70.3063 169.839 71.0863 168.314 72.6463C166.788 74.1716 165.974 76.4249 165.87 79.4063C165.835 79.9263 165.818 80.5676 165.818 81.3303C165.818 82.0929 165.835 82.7343 165.87 83.2543C165.974 86.2009 166.788 88.4543 168.314 90.0143C169.839 91.5743 171.815 92.3543 174.242 92.3543ZM189.731 94.8503C189.454 94.8503 189.211 94.7463 189.003 94.5383C188.795 94.3303 188.691 94.0876 188.691 93.8103C188.691 93.6716 188.708 93.5329 188.743 93.3943C188.812 93.2209 188.934 93.0129 189.107 92.7703L198.259 81.0183L189.575 69.8903C189.402 69.6476 189.28 69.4569 189.211 69.3183C189.176 69.1449 189.159 68.9889 189.159 68.8503C189.159 68.5729 189.263 68.3303 189.471 68.1223C189.679 67.9143 189.922 67.8103 190.199 67.8103H191.291C191.638 67.8103 191.898 67.8969 192.071 68.0703C192.279 68.2436 192.452 68.4169 192.591 68.5903L200.391 78.6263L208.191 68.6423C208.364 68.4689 208.538 68.2956 208.711 68.1223C208.884 67.9143 209.144 67.8103 209.491 67.8103H210.531C210.808 67.8103 211.051 67.9143 211.259 68.1223C211.467 68.3303 211.571 68.5729 211.571 68.8503C211.571 68.9889 211.536 69.1449 211.467 69.3183C211.432 69.4569 211.328 69.6476 211.155 69.8903L202.367 81.1743L211.519 92.7703C211.692 93.0129 211.796 93.2209 211.831 93.3943C211.9 93.5329 211.935 93.6716 211.935 93.8103C211.935 94.0876 211.831 94.3303 211.623 94.5383C211.415 94.7463 211.172 94.8503 210.895 94.8503H209.803C209.456 94.8503 209.179 94.7636 208.971 94.5903C208.798 94.4169 208.642 94.2436 208.503 94.0703L200.287 83.5663L192.071 94.0703C191.932 94.2436 191.759 94.4169 191.551 94.5903C191.378 94.7636 191.118 94.8503 190.771 94.8503H189.731ZM221.273 104.73C220.996 104.73 220.753 104.626 220.545 104.418C220.337 104.21 220.233 103.968 220.233 103.69C220.233 103.552 220.25 103.396 220.285 103.222C220.354 103.084 220.441 102.893 220.545 102.65L224.549 93.2903L214.617 69.8903C214.409 69.3703 214.305 69.0236 214.305 68.8503C214.305 68.5729 214.409 68.3303 214.617 68.1223C214.825 67.9143 215.068 67.8103 215.345 67.8103H216.437C216.784 67.8103 217.044 67.8969 217.217 68.0703C217.425 68.2089 217.564 68.3823 217.633 68.5903L226.369 89.1823L235.313 68.5903C235.417 68.3823 235.556 68.2089 235.729 68.0703C235.902 67.8969 236.162 67.8103 236.509 67.8103H237.549C237.826 67.8103 238.069 67.9143 238.277 68.1223C238.485 68.3303 238.589 68.5729 238.589 68.8503C238.589 69.0236 238.485 69.3703 238.277 69.8903L223.509 103.95C223.405 104.158 223.266 104.332 223.093 104.47C222.92 104.644 222.66 104.73 222.313 104.73H221.273Z"
          fill={textColor}
        />
        <path
          d="M255.043 0.000263578C255.893 0.000263578 256.625 0.283264 257.239 0.850264C257.828 1.37426 258.145 2.07926 258.19 2.96526L258.196 3.19026V31.2063L274.318 16.6793C274.839 16.2373 275.395 16.0153 275.988 16.0153C276.745 16.0153 277.408 16.3063 277.976 16.8883C278.568 17.4703 278.864 18.1223 278.864 18.8443C278.864 19.4373 278.629 19.9813 278.159 20.4773L278.011 20.6253L265.121 31.9743L279.219 46.5713C279.739 47.1063 280 47.7113 280 48.3863C280 49.1313 279.692 49.7953 279.077 50.3763C278.485 50.9593 277.798 51.2503 277.017 51.2503C276.257 51.2503 275.597 50.9763 275.037 50.4283L274.887 50.2723L258.196 32.8123V48.0243C258.196 49.0173 257.866 49.8083 257.204 50.3993C256.566 50.9663 255.81 51.2493 254.936 51.2493C254.062 51.2493 253.318 50.9793 252.704 50.4353C252.137 49.9113 251.832 49.1863 251.788 48.2603L251.783 48.0243V3.19026C251.783 2.19826 252.102 1.41826 252.74 0.850264C253.377 0.292516 254.197 -0.0102228 255.043 0.000263578ZM242.217 15.3753C243.067 15.3753 243.799 15.6693 244.413 16.2573C245.002 16.8003 245.319 17.5313 245.364 18.4503L245.37 18.6833V47.9053C245.37 48.9343 245.04 49.7553 244.378 50.3683C243.766 50.9464 242.952 51.2629 242.11 51.2503C241.236 51.2503 240.492 50.9683 239.878 50.4043C239.311 49.8613 239.006 49.1103 238.962 48.1493L238.957 47.9053V18.6833C238.957 17.6543 239.276 16.8453 239.914 16.2573C240.542 15.682 241.365 15.3667 242.217 15.3753ZM233.6 0.000263578V0.0032636L233.66 0.00526357C234.235 0.0446547 234.773 0.303937 235.162 0.72929C235.55 1.15464 235.76 1.7134 235.748 2.28957C235.736 2.86575 235.502 3.41509 235.096 3.82357C234.689 4.23205 234.141 4.46829 233.565 4.48326L230.238 4.48426C229.244 4.48426 228.47 4.57826 227.915 4.76426C227.361 4.92826 226.864 5.37426 226.425 5.98126C226.009 6.56526 225.859 7.67526 225.697 8.79626C225.569 9.81026 225.5 11.1623 225.49 12.8523L225.489 13.2823V15.3753H231.262C231.772 15.3753 232.261 15.5778 232.621 15.9382C232.982 16.2986 233.184 16.7875 233.184 17.2973C233.184 17.807 232.982 18.2959 232.621 18.6563C232.261 19.0168 231.772 19.2193 231.262 19.2193L225.489 19.2183V48.0243C225.489 48.9403 225.207 49.6853 224.643 50.2593L224.497 50.3993C223.859 50.9663 223.103 51.2493 222.229 51.2493C221.355 51.2493 220.611 50.9793 219.997 50.4353C219.43 49.9113 219.125 49.1863 219.081 48.2603L219.076 48.0243V19.2183H213.943C213.441 19.2068 212.963 18.9993 212.612 18.6402C212.261 18.2811 212.065 17.7989 212.065 17.2968C212.065 16.7946 212.261 16.3124 212.612 15.9533C212.963 15.5942 213.441 15.3867 213.943 15.3753H219.076V11.5653C219.076 7.38326 219.954 4.41526 221.71 2.66326C223.393 0.962264 225.692 0.0752636 228.606 0.00426359L228.99 0.000263578H233.6ZM155.57 15.3753C156.37 15.3753 156.993 15.6623 157.443 16.2353C157.917 16.8103 158.155 17.4793 158.155 18.2453C158.155 18.9623 157.942 19.5843 157.518 20.1103C157.093 20.6123 156.482 20.8633 155.683 20.8633C152.312 20.8633 150.01 21.7003 148.138 23.3743C146.328 25.0143 145.366 27.1943 145.328 29.9123V47.9053C145.328 48.9343 144.998 49.7553 144.337 50.3683C143.725 50.9464 142.911 51.2629 142.069 51.2503C141.195 51.2503 140.451 50.9683 139.837 50.4043C139.247 49.8393 138.94 49.0473 138.917 48.0283L138.916 47.9053V18.6833C138.916 17.6543 139.235 16.8453 139.872 16.2573C140.5 15.682 141.323 15.3667 142.175 15.3753C143.025 15.3753 143.758 15.6693 144.372 16.2573C144.984 16.8223 145.302 17.5903 145.327 18.5613L145.329 18.6833V23.1953C145.953 20.9713 147.201 19.1183 149.074 17.6353C150.972 16.1283 152.924 15.3753 155.57 15.3753ZM122.515 5.12526C123.301 5.12526 123.982 5.37926 124.555 5.88826C125.151 6.41826 125.448 7.12826 125.448 8.02026V15.3753H132.505C133.515 15.3753 134.345 16.1553 134.421 17.1473L134.427 17.2973C134.427 18.3073 133.647 19.1373 132.655 19.2133L132.505 19.2193L125.447 19.2183L125.448 37.9683L125.45 38.3983C125.46 40.0883 125.528 41.4403 125.656 42.4543C125.818 43.5743 125.968 44.6843 126.384 45.2683C126.824 45.8763 127.32 46.3223 127.875 46.4853C128.368 46.6513 129.035 46.7443 129.875 46.7623L130.197 46.7653H133.525C134.087 46.7807 134.623 47.0066 135.026 47.3984C135.43 47.7901 135.671 48.3191 135.703 48.8805C135.735 49.4419 135.555 49.9947 135.198 50.4295C134.842 50.8644 134.335 51.1494 133.778 51.2283L133.621 51.2453L133.559 51.2473L133.56 51.2503H128.95L128.566 51.2453C125.652 51.1753 123.353 50.2883 121.67 48.5863C119.974 46.8953 119.097 44.0703 119.039 40.1133L119.035 39.6853V19.2183H114.545C113.533 19.2183 112.705 18.4383 112.628 17.4473L112.622 17.2973C112.622 16.2863 113.403 15.4573 114.394 15.3813L114.544 15.3753H119.167L119.677 8.02026C119.677 7.08726 119.953 6.36526 120.506 5.85626C121.059 5.36926 121.728 5.12526 122.515 5.12526ZM195.723 15.3753C199.063 15.3753 202.17 16.2353 204.485 17.7973C206.321 19.0353 207.812 20.9433 208.415 22.8243C208.761 23.9043 208.814 24.3043 208.817 25.8723C208.819 26.8483 208.792 27.5073 208.739 27.8123C208.197 30.8953 206.906 33.0313 204.666 34.5523C202.864 35.7753 200.601 36.4923 197.641 36.7743C196.151 36.9163 193.426 36.9033 191.661 36.7443C190.162 36.6103 188.323 36.3743 187.538 36.2143C186.881 36.0813 184.631 35.7003 184.612 35.7183C184.525 36.2233 184.446 36.7297 184.375 37.2373C184.179 38.5573 184.151 38.8873 184.147 39.9413C184.143 41.0133 184.157 41.2013 184.285 41.6963C184.695 43.2863 185.597 44.3513 187.235 45.1743C188.845 45.9833 190.534 46.3343 193.085 46.3873C194.215 46.4113 194.794 46.3953 195.5 46.3193C197.214 46.1343 197.994 45.9323 200.27 45.0823C200.838 44.8703 201.416 44.6783 201.556 44.6543C201.856 44.6043 202.417 44.7083 202.744 44.8773C203.334 45.1813 203.829 45.9923 203.826 46.6473C203.822 47.4143 203.568 47.8783 202.821 48.4823C201.034 49.9253 198.753 50.8113 196.03 51.1173C195.059 51.2273 192.842 51.2433 191.771 51.1483C188.756 50.8823 186.662 50.3583 184.749 49.3913C183.256 48.6373 182.117 47.7013 181.266 46.5293C181.056 46.2423 180.879 45.9993 180.871 45.9903C180.863 45.9813 180.724 46.1473 180.562 46.3603C179.847 47.2973 178.752 48.3043 177.684 49.0103C176.14 50.0293 173.924 50.8073 171.682 51.1163C171.014 51.2083 168.795 51.2843 168.226 51.2343C164.296 50.8903 161.294 49.6863 159.11 47.5803C156.888 45.4363 155.934 42.6423 156.31 39.3753C156.744 35.6173 158.503 32.9623 161.587 31.4133C163.964 30.2203 166.335 29.7663 170.197 29.7653C172.94 29.7643 175.239 29.9923 178.746 30.6113C179.613 30.7653 180.364 30.8903 180.414 30.8913C180.487 30.8913 180.546 30.6103 180.704 29.4903C180.993 27.4623 181.044 26.7633 180.966 25.9513C180.874 25.0063 180.756 24.5563 180.403 23.8233C179.493 21.9333 177.333 20.7773 173.865 20.3233C172.873 20.1933 170.584 20.1753 169.59 20.2893C167.926 20.4803 166.997 20.7243 164.925 21.5123C163.713 21.9733 163.707 21.9743 163.224 21.9463C162.393 21.8963 161.825 21.5143 161.461 20.7593C161.311 20.4483 161.285 20.3193 161.285 19.9003C161.285 19.2703 161.447 18.9373 162.008 18.4033C163.268 17.2063 165.388 16.1873 167.528 15.7493C168.899 15.4693 169.574 15.4103 171.379 15.4133C173.247 15.4183 174.442 15.5233 176.102 15.8363C178.863 16.3583 180.96 17.2763 182.541 18.6583C183.01 19.0683 183.717 19.8753 184.021 20.3463C184.113 20.4903 184.208 20.6083 184.232 20.6083C184.256 20.6083 184.41 20.4353 184.572 20.2243C186.967 17.1263 190.999 15.3723 195.722 15.3743L195.723 15.3753ZM170.709 34.4583C168.321 34.5953 167.349 34.8083 165.915 35.5083C165.18 35.8683 164.673 36.2583 164.272 36.7703C163.697 37.5073 163.35 38.2393 163.108 39.2253C162.931 39.9433 162.914 41.8223 163.077 42.4283C163.352 43.4483 163.679 44.0253 164.415 44.7893C165.421 45.8363 166.748 46.5343 168.395 46.8833C169.236 47.0623 169.211 47.0603 170.621 47.0383C171.643 47.0223 172.026 46.9933 172.444 46.8983C174.22 46.4963 175.804 45.5883 176.952 44.3133C178 43.1503 178.86 41.4083 179.333 39.4893C179.6 38.4073 180.043 35.3953 179.945 35.3333C179.905 35.3083 179.672 35.2703 179.425 35.2473C178.901 35.191 178.378 35.1276 177.856 35.0573C174.205 34.5743 171.965 34.3873 170.709 34.4583ZM192.979 20.0083C191.679 20.2523 190.579 20.6963 189.61 21.3703C187.82 22.6163 186.583 24.4943 185.895 27.0153C185.625 28.0053 185.552 28.3853 185.311 30.0923L185.089 31.6663L185.387 31.7003C186.287 31.8033 188.315 32.0553 189.493 32.2113C190.234 32.3103 191.143 32.4143 191.514 32.4443C192.586 32.5313 194.507 32.5233 195.557 32.4273C197.037 32.2943 197.947 32.0573 199.064 31.5173C199.994 31.0683 200.534 30.6093 201.044 29.8343C201.798 28.6943 202.091 27.6143 202.084 26.0093C202.078 24.8663 201.984 24.3903 201.6 23.5693C200.742 21.7353 198.727 20.4213 196.084 19.9733C195.425 19.8613 193.655 19.8813 192.979 20.0083ZM242.196 0.000263578C243.336 0.000263578 244.257 0.314264 244.959 0.943264C245.66 1.55326 246.011 2.36326 246.011 3.37826C246.011 4.37326 245.661 5.18426 244.959 5.81326C244.257 6.42226 243.325 6.72626 242.163 6.72626C241.001 6.72626 240.07 6.42226 239.368 5.81326C238.666 5.18426 238.316 4.37326 238.316 3.37826C238.316 2.38426 238.666 1.57226 239.368 0.943264C240.092 0.314264 241.034 0.000263578 242.196 0.000263578Z"
          fill={textColor}
        />
        <g clipPath="url(#clip1_2122_9)">
          <mask id="mask0_2122_9" maskUnits="userSpaceOnUse" x="-3" y="-1" width="104" height="104">
            <path d="M-3 -1H101V103H-3V-1Z" fill="white" />
          </mask>
          <g mask="url(#mask0_2122_9)">
            <path
              d="M49.4056 10.375C53.4954 10.375 57.1328 13.261 57.1328 16.8178C57.1328 20.3746 53.6696 23.2632 49.4056 23.2632C48.7632 23.2439 48.1241 23.1629 47.4972 23.0214C46.8868 22.8975 46.2522 22.9991 45.711 23.3074L18.008 39.0738C17.8098 39.1867 17.6451 39.3502 17.5308 39.5476C17.4164 39.7449 17.3564 39.9691 17.3569 40.1972C17.3575 40.4253 17.4185 40.6492 17.5338 40.846C17.6491 41.0429 17.8145 41.2056 18.0132 41.3176L48.0432 58.189C48.8206 58.6258 49.7722 58.6284 50.5522 58.1942L80.7434 41.3982C80.943 41.2868 81.1094 41.1244 81.2256 40.9276C81.3417 40.7308 81.4035 40.5066 81.4046 40.278C81.4056 40.0495 81.3459 39.8248 81.2316 39.6269C81.1172 39.429 80.9523 39.265 80.7538 39.1518L71.334 33.801C70.9501 33.5826 70.5164 33.4667 70.0747 33.4645C69.633 33.4622 69.1982 33.5736 68.812 33.788L58.8696 39.3078C58.7466 39.3761 58.6418 39.4728 58.564 39.59C58.4862 39.7072 58.4376 39.8414 58.4224 39.9812L58.4172 40.0748C58.4172 43.6316 54.9566 46.5202 50.6926 46.5202C46.4286 46.5202 42.9654 43.6342 42.9654 40.0748C42.9654 36.5206 46.426 33.632 50.6926 33.632C50.8486 33.632 51.0306 33.6398 51.2386 33.658L51.5636 33.6892L51.9224 33.736C52.4731 33.8104 53.0332 33.7046 53.5188 33.4344L68.2244 25.273C69.3528 24.649 70.71 24.6282 71.8514 25.2106L72.0074 25.2912L92.5422 36.9574C93.1267 37.2902 93.6143 37.7696 93.957 38.3483C94.2997 38.927 94.4856 39.5851 94.4963 40.2576C94.5071 40.9301 94.3424 41.5938 94.0184 42.1831C93.6944 42.7725 93.2223 43.2673 92.6488 43.6186L92.511 43.6992L78.7752 51.3432C78.573 51.4564 78.405 51.6221 78.289 51.8227C78.1729 52.0233 78.1131 52.2515 78.1157 52.4832C78.1184 52.715 78.1835 52.9417 78.3041 53.1396C78.4247 53.3375 78.5964 53.4992 78.8012 53.6078L92.407 60.7708C95.1084 62.193 95.1734 66.0384 92.5214 67.5516L51.2022 91.118C50.014 91.794 48.5606 91.794 47.375 91.118L6.2872 67.6452C3.6326 66.1294 3.7054 62.2736 6.4172 60.8592L20.1712 53.678C20.377 53.5704 20.5499 53.4092 20.6717 53.2114C20.7935 53.0136 20.8596 52.7867 20.863 52.5545C20.8665 52.3222 20.8072 52.0934 20.6914 51.8921C20.5755 51.6908 20.4075 51.5245 20.205 51.4108L6.282 43.5952C5.6972 43.2662 5.20804 42.7907 4.86255 42.2154C4.51706 41.6402 4.32712 40.985 4.31138 40.3142C4.29565 39.6434 4.45466 38.98 4.7728 38.3892C5.09094 37.7984 5.55727 37.3005 6.126 36.9444L6.2638 36.8612L40.4538 17.4054C40.9935 17.097 41.4035 16.6039 41.6082 16.017L41.6524 15.8818C42.851 12.3042 45.5862 10.375 49.4056 10.375ZM68.4818 57.8406L51.6 67.5568L51.444 67.64C50.2974 68.2328 48.9246 68.212 47.7936 67.5724L30.9638 58.0772C30.5916 57.8671 30.1728 57.7534 29.7455 57.7466C29.3181 57.7398 28.8959 57.84 28.5172 58.0382L18.814 63.116C18.6096 63.2237 18.4378 63.3842 18.3166 63.5808C18.1953 63.7774 18.1289 64.003 18.1244 64.234C18.1199 64.4649 18.1774 64.6929 18.2909 64.8941C18.4044 65.0953 18.5698 65.2624 18.7698 65.378L48.4098 82.3482C48.7973 82.5701 49.236 82.6868 49.6825 82.6868C50.129 82.6868 50.5677 82.5701 50.9552 82.3482L80.8474 65.2584C81.0478 65.1435 81.2137 64.977 81.3279 64.7762C81.442 64.5754 81.5003 64.3476 81.4966 64.1167C81.4929 63.8857 81.4273 63.66 81.3067 63.4629C81.1862 63.2659 81.015 63.1048 80.811 62.9964L70.957 57.7964C70.574 57.5935 70.1458 57.4911 69.7124 57.4988C69.279 57.5066 68.8573 57.6242 68.4818 57.8406Z"
              fill="#2AA2C1"
            />
          </g>
        </g>
      </g>
      <defs>
        <clipPath id="clip0_2122_9">
          <rect width="280" height="108" fill={textColor} />
        </clipPath>
        <clipPath id="clip1_2122_9">
          <rect width="104" height="104" fill={textColor} transform="translate(-3 -1)" />
        </clipPath>
      </defs>
    </svg>
  )
}
const Logo = ({ isSmallScreen, ...props }: LogoProps) => {
  const isDarkMode = useIsDarkMode()

  if (isSmallScreen) {
    return (
      <svg width="36" viewBox="0 0 101 103" fill="none" xmlns="http://www.w3.org/2000/svg" {...props}>
        <g clipPath="url(#clip0_2122_26)">
          <mask id="mask0_2122_26" maskUnits="userSpaceOnUse" x="-3" y="-1" width="104" height="104">
            <path d="M-3 -1H101V103H-3V-1Z" fill="white" />
          </mask>
          <g mask="url(#mask0_2122_26)">
            <path
              d="M49.4056 10.375C53.4954 10.375 57.1328 13.261 57.1328 16.8178C57.1328 20.3746 53.6696 23.2632 49.4056 23.2632C48.7632 23.2439 48.1241 23.1629 47.4972 23.0214C46.8868 22.8975 46.2522 22.9991 45.711 23.3074L18.008 39.0738C17.8098 39.1867 17.6452 39.3502 17.5308 39.5476C17.4164 39.7449 17.3564 39.9691 17.3569 40.1972C17.3575 40.4253 17.4185 40.6492 17.5338 40.846C17.6491 41.0429 17.8145 41.2056 18.0132 41.3176L48.0432 58.189C48.8206 58.6258 49.7722 58.6284 50.5522 58.1942L80.7434 41.3982C80.943 41.2868 81.1094 41.1244 81.2256 40.9276C81.3418 40.7308 81.4035 40.5066 81.4046 40.278C81.4057 40.0495 81.3459 39.8248 81.2316 39.6269C81.1172 39.429 80.9524 39.265 80.7538 39.1518L71.334 33.801C70.9501 33.5826 70.5164 33.4667 70.0747 33.4645C69.633 33.4622 69.1982 33.5736 68.812 33.788L58.8696 39.3078C58.7466 39.3761 58.6418 39.4728 58.564 39.59C58.4862 39.7072 58.4376 39.8414 58.4224 39.9812L58.4172 40.0748C58.4172 43.6316 54.9566 46.5202 50.6926 46.5202C46.4286 46.5202 42.9654 43.6342 42.9654 40.0748C42.9654 36.5206 46.426 33.632 50.6926 33.632C50.8486 33.632 51.0306 33.6398 51.2386 33.658L51.5636 33.6892L51.9224 33.736C52.4732 33.8104 53.0332 33.7046 53.5188 33.4344L68.2244 25.273C69.3528 24.649 70.71 24.6282 71.8514 25.2106L72.0074 25.2912L92.5422 36.9574C93.1267 37.2902 93.6143 37.7696 93.957 38.3483C94.2997 38.927 94.4856 39.5851 94.4964 40.2576C94.5071 40.9301 94.3424 41.5938 94.0184 42.1831C93.6944 42.7725 93.2223 43.2673 92.6488 43.6186L92.511 43.6992L78.7752 51.3432C78.573 51.4564 78.405 51.6221 78.289 51.8227C78.1729 52.0233 78.1131 52.2515 78.1157 52.4832C78.1184 52.715 78.1835 52.9417 78.3041 53.1396C78.4247 53.3375 78.5964 53.4992 78.8012 53.6078L92.407 60.7708C95.1084 62.193 95.1734 66.0384 92.5214 67.5516L51.2022 91.118C50.014 91.794 48.5606 91.794 47.375 91.118L6.28721 67.6452C3.63261 66.1294 3.70541 62.2736 6.41721 60.8592L20.1712 53.678C20.377 53.5704 20.5499 53.4092 20.6717 53.2114C20.7935 53.0136 20.8596 52.7867 20.863 52.5545C20.8665 52.3222 20.8072 52.0934 20.6914 51.8921C20.5755 51.6908 20.4075 51.5245 20.205 51.4108L6.28201 43.5952C5.69722 43.2662 5.20805 42.7907 4.86256 42.2154C4.51707 41.6402 4.32713 40.985 4.3114 40.3142C4.29566 39.6434 4.45467 38.98 4.77281 38.3892C5.09096 37.7984 5.55729 37.3005 6.12601 36.9444L6.26381 36.8612L40.4538 17.4054C40.9935 17.097 41.4035 16.6039 41.6082 16.017L41.6524 15.8818C42.851 12.3042 45.5862 10.375 49.4056 10.375ZM68.4818 57.8406L51.6 67.5568L51.444 67.64C50.2974 68.2328 48.9246 68.212 47.7936 67.5724L30.9638 58.0772C30.5916 57.8671 30.1728 57.7534 29.7455 57.7466C29.3181 57.7398 28.8959 57.84 28.5172 58.0382L18.814 63.116C18.6096 63.2237 18.4379 63.3842 18.3166 63.5808C18.1953 63.7774 18.129 64.003 18.1244 64.234C18.1199 64.4649 18.1774 64.6929 18.2909 64.8941C18.4044 65.0953 18.5698 65.2624 18.7698 65.378L48.4098 82.3482C48.7973 82.5701 49.236 82.6868 49.6825 82.6868C50.129 82.6868 50.5678 82.5701 50.9552 82.3482L80.8474 65.2584C81.0478 65.1435 81.2137 64.977 81.3279 64.7762C81.442 64.5754 81.5003 64.3476 81.4966 64.1167C81.4929 63.8857 81.4273 63.66 81.3067 63.4629C81.1862 63.2659 81.015 63.1048 80.811 62.9964L70.957 57.7964C70.574 57.5935 70.1458 57.4911 69.7124 57.4988C69.279 57.5066 68.8573 57.6242 68.4818 57.8406Z"
              fill="#2AA2C1"
            />
          </g>
        </g>
        <defs>
          <clipPath id="clip0_2122_26">
            <rect width="104" height="104" fill="white" transform="translate(-3 -1)" />
          </clipPath>
        </defs>
      </svg>
    )
  }

  if (isDarkMode) return <ProxyLogo textColor="#fff" {...props} />

  return <ProxyLogo {...props} />
}

export default Logo
