#
#  File: resources.tcl
#  
#  This file is part of XSCHEM,
#  a schematic capture and Spice/Vhdl/Verilog netlisting tool for circuit 
#  simulation.
#  Copyright (C) 1998-2024 Stefan Frederik Schippers
# 
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
# 
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA




##
## Tcl Resources for XSchem toolbars
##


## Toolbar images are 24x24,
## Context menu images are 16x16
##
## NOTE: if a svg image is created (with transparent white) it needs to be converted to gif,
## however inkscape does not convert from svg to gif, so the steps are:
##
## # this creates paste.png
## inkscape --export-type="png" -w 24 -h 24 paste.svg
## # generate gif and base64 encode.
## # we need to lose transparency in gif otherwise all antialiasing in png image is lost
## # so we set white background and eliminate alpha channel (unsupported in gif).
## convert  -background white -alpha remove -alpha off  paste.png -transparent white gif:-|base64
##
## Following shell function (and call) converts a png base64 encoded to proper 
## gif89a base64 encoded format:
##   to_gif () {
##     echo "image create photo $1 -data \""
##     echo -n "$2" | base64 -d |convert -background white -alpha remove -alpha off - -transparent white gif:- |base64
##     echo '"'
##   }
## 
##   to_gif imgFileOpen "...."

##
## Toolbar buttons
##
## Original artwork derived from http://www.entypo.com/
## Colours inverted, and then converted from SVG to base64-encoded GIF
## Author: Neil Johnson
## Released under the license CC BY-SA 4.0.
## https://creativecommons.org/licenses/by-sa/4.0/
##
##


# #
# # context menu steps.
# # open xschem and draw a 0,0, 100,100 polygon border. The image should be drawn inside it
# # set light colorscheme, set transparent svg background
# # draw image inside the border in green color
# # set line with 40 disable change line width, redraw
# # move away the border, full zoom the image 
# # export svg:
#  xschem print svg 1.svg 400 400 0 0 100 100
# # edit svg, change .l4 layer from green to black (#000000)
# # you need imagemagick and graphicsmagick packages
# gm convert -size 16x16 1.svg 1.png
# convert -background white -alpha remove -alpha off 1.png -transparent white 1.gif
# base64 1.gif
# # the output is the 16x16 image with transparent background, antialiasing 
# # and base64 encoded
# #
# #
# #



## FILE


if { $dark_gui_colorscheme == 0 } {

image create photo imgFileOpen
imgFileOpen put "
R0lGODlhGAAYAPYAAAAAAAEBAQMDAwQEBAUFBQcHBwgICAkJCQsLCw0NDRISEhMTExcXFxkZGRwc
HB0dHR4eHiEhISYmJisrKywsLDAwMDExMTIyMjY2Njc3Nzk5OUREREVFRUZGRk5OTlRUVFlZWVpa
Wl1dXV5eXmBgYGhoaGlpaW1tbW5ubm9vb3BwcHl5eXp6en19fYGBgYKCgouLi5OTk5SUlJWVlZ2d
naenp6ioqKmpqbW1tbq6ury8vL29vcDAwMHBwcLCwsTExMbGxsfHx8nJydDQ0NHR0dLS0tnZ2dra
2uDg4Ojo6Ovr6+zs7PDw8Pf39/j4+Pn5+fz8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAFMALAAAAAAYABgAAAfLgFOCg4SFhoeIiYU8LSaOKDBCioVSKwgAmAANIjhLUpNSTCKZmQga
Mjk8QDysrEBGTVNSSB+kpAQEALi7BAgkRlJSRB66vLi6mMfIGDafTUZAQELR0dNC1tLXQESeKygo
KuHi4+Ti3ysLubbr7LoLEOrt8gAIEBcJ8/MIFx0L+fILOoBg8K8dAxAoIBRkBwFFiwgL10V4IUNC
RFsSZNigcJEUBRs6OHbEdEEHEQwjMWEgkqRDSgAdkjihgcKRzZs4b6Kg4WSSz58+AwEAOw==
"

image create photo imgFileSave
imgFileSave put "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgMDAwQEBAUFBQcHBzExMT4+Pj8/P0FBQUNDQ0REREVFRUdH
R0hISElJSV9fX2BgYGFhYWJiYmVlZWdnZ2hoaGlpaW1tbW5ubm9vb3BwcHNzc3R0dJOTk6Ghoaam
pqqqqq2trbGxsbKysrOzs7a2trq6usHBwcLCwsPDw8TExMbGxsfHx8rKytXV1ebm5urq6uzs7O3t
7e7u7vX19fr6+vz8/P7+/gAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADoALAAAAAAYABgAAAa3QJ1w
SCwaj8hkcUbqYDCUiHQqpXRAMiNpYQAAINGpZdwwHEKzosfrTRFzsFQs1UWMbEQM2+Ae3hYAHS9s
ECh5e31CNwiBL11eHodefESLABotjwAYkgCUQzmMHS1sm50GJDl+HxYiJ5qcQ3qTGiQpKSgpLS8n
GrCdkwbCwp6lprLGycqxQrPKz8fN0NDMOs7TxtXX2Gza3Mne36XVa+JskUMkZeIGDSdETE5P8/T0
HiRpSvr7/ENBADs=
"

image create photo imgFileReload
imgFileReload put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgQEBAUFBQcHBwgICAsLCw0NDQ4ODg8PDxMTExQUFBoaGhsb
GxwcHB8fHyAgICEhIScnJysrKywsLDg4OD4+Pj8/P0BAQEFBQUJCQkZGRk9PT1VVVVZWVmFhYWdn
Z2hoaGlpaWtra2xsbHNzc4yMjJaWlpqamqSkpKWlpaqqqq2trbOzs7a2tri4uL6+vsHBwcPDw8TE
xMXFxcbGxsfHx8jIyMzMzM7OztPT09XV1dvb297e3uTk5OXl5evr6+3t7e/v7/Hx8fLy8vb29vf3
9/n5+fv7+/39/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEsALAAAAAAYABgAAAe+gEuCg4SFhoeIiYqLjIRFOkiNiDsgN0eKR0E/m5w/QS0JHDGXSJ2e
SC8eEQ0PrA2sDAAGFixLN62tER4wGAsAv8DBAAQYLjcEwQsaBsLNAAkkPDfNzL8UJNjYJR0EDSQ5
Sz0l2BTNJIY3EyY+hiTmhj4nQofuwueFSEVK9O+SS/XB7kkCCAxDChQIEypUmAIDMGTOIjYjQCGB
xIvPKqhYRqCjx48gPRrQsELIjhsyUqpcyXLljiL+YsqcSXNRIAA7
"

## EDIT

image create photo imgEditUndo
imgEditUndo put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgMDAwUFBQcHBw0NDQ4ODg8PDxAQEBERERMTExQUFBUVFRcX
FxgYGBkZGRsbGxwcHB0dHR4eHiAgICIiIioqKiwsLENDQ0REREtLS1NTU1RUVFxcXGFhYWdnZ2ho
aGlpaWpqamxsbHJycnR0dHV1dXd3d3h4eHx8fICAgISEhIWFhYaGhoqKipCQkJGRkZSUlJWVlZqa
mpubm52dnZ6enqWlpa6urrW1tba2tr29vcLCwsbGxszMzNHR0dPT09TU1NbW1tfX19ra2tzc3N3d
3d7e3t/f3+Dg4OHh4eTk5OXl5ebm5ufn5+rq6u3t7fT09PX19ff39/n5+fr6+vv7+/z8/P39/f7+
/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAFsALAAAAAAYABgAAAfDgFuCg4SFhoeIiYqLjIJGRo2HWVAtM5GFkysQIZeETyUSAyCdjiSh
A5ydQCENA64XISgwO0+KWT+srrquEhooOUpZhllCHwa7yK8tRlaYLafJyA0fQs2DWUohCdHJBhxC
mEIox7oFBgXJCShFhkIpra4ZODc0MyskGxUFEjTWhEYlILgaNWiKER4wPEDg0OMQlBIVREl60iJD
C3/XoqTYhChLlhsrhAjDFEXFC0VTfOwYaUiJkkVRgpEilAXjzJs4GQUCADs=
"

image create photo imgEditRedo
imgEditRedo put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgUFBQcHBw0NDQ4ODhAQEBERERISEhUVFRcXFxgYGBoaGhwc
HB0dHR4eHiAgICEhISMjIyoqKkNDQ0REREtLS1NTU1ZWVl1dXWBgYGdnZ2hoaGlpaWpqamtra2xs
bG1tbXJycnNzc3R0dHV1dXZ2dnd3d3h4eHt7e3x8fH9/f4KCgoODg4SEhIWFhYeHh4qKipCQkJGR
kZKSkpSUlJqamp6enqWlpaysrLW1tb29vcHBwcbGxsvLy9DQ0NLS0tPT09XV1dbW1tra2tvb29zc
3N3d3d/f3+Dg4OTk5OXl5ejo6O3t7fX19ff39/n5+fr6+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAFcALAAAAAAYABgAAAfDgFeCg4SFhoeIiYqLjIhGRo2JNCxKVpGGHAspTpaXgx0AECFMnZ6g
oR1IjFZMOzQlIRQAsw0hQolWSDolFRAEs8AABx0/pYNSRC2ywcwABhpCxlJCGQfN1xMtUoRE1dfN
BhxIpUYlBs0EBr+z6SNEpU83vhMXITE2Nzg5FsCaRIU9MkDQQIOHkieETjUooYqQlBYVYpA6xAHA
hBFOClkREgOHFWMJF5TgpHGHD4SJZLAgqRFJRkVKlCSSAtKTzZs4bwYCADs=
"

image create photo imgEditCopy
imgEditCopy put "
R0lGODlhGAAYAPYAAAAAAAcHBwoKCg4ODhAQEBERESUlJSsrKywsLC0tLS4uLi8vLzAwMDExMTMz
Mzg4ODk5OTo6OkBAQEFBQURERFJSUlNTU1RUVFVVVVpaWmFhYWRkZGVlZXd3d35+foGBgYODg4SE
hIWFhYaGhoiIiJWVlZaWlpmZmZ+fn6urq66urq+vr7S0tLW1tbm5ubu7u76+vr+/v8DAwMTExMzM
zNbW1tfX1+Xl5efn5+zs7O3t7e7u7vDw8PLy8vf39/v7+/7+/gAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEEALAAAAAAYABgAAAfRgD8BAISFhoUwQYqLijiHj4UjjIw5hBknmJmYH4Qpk4uVACafijad
pEGho6SmABo/ijMkMoqqqK0AnkENAA21hKufuC6KDwAPv6K3hB9AjTA4ycGTrbqftqyniiYUq9jC
2kELAAvJJ8u5ixcAFtLo1qmgwO+o39ThHAQcyQIFBQQAAw4Id4BcMkiHJCka4UBhEA0GLkicSLHB
Ax+oUPWg0WORDRugaOTIGIQCgAiKZBBKVBIABZLjygVhoS0myRYdWCjq4eEDxiA4W5AcSrQoo0AA
Ow==
"

image create photo imgEditCut
imgEditCut put "
R0lGODlhGAAYAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQsLCwwMDA0NDQ4ODhAQ
EBERERISEhMTExUVFRYWFhcXFxoaGhsbGx0dHR4eHh8fHyIiIiMjIyQkJCUlJScnJysrKywsLC0t
LS8vLzExMTMzMzU1NTY2Njg4ODk5OTo6Ojs7Ozw8PD4+Pj8/P0JCQkNDQ0REREVFRUhISExMTE5O
Tk9PT1JSUlZWVldXV1hYWFlZWVtbW1xcXF1dXV9fX2FhYWRkZGVlZWdnZ2hoaGlpaWpqamtra2xs
bG1tbW9vb3BwcHFxcXJycnNzc3R0dHd3d3h4eH9/f4GBgYWFhYmJiYqKioyMjI2NjZOTk5WVlZeX
l5qampubm52dnZ6enp+fn6KioqOjo6Wlpaqqqqurq7KysrOzs7S0tLa2tre3t7m5ubu7u8HBwcLC
wsPDw8XFxcbGxsfHx8jIyMrKysvLy8zMzM3Nzc7Ozs/Pz9HR0dPT09XV1djY2NnZ2dra2t3d3d7e
3uDg4OHh4eLi4uPj4+Xl5ebm5urq6uvr6+zs7O/v7/Dw8PHx8fT09PX19fb29vf39/j4+Pn5+fr6
+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAJgALAAAAAAYABgA
AAj+ADEJHEiwoMGDly4dXFjwkBkoQJZ0CcTQ4CVFXVQgAADgwxQ/FQleQqPRhI4XDzBcobQw4UBK
RBbEeEPJEI4CNv4oHHiJkqI6dQw1wkSJBgAkCildwfDCzU6Bjer06CDBBpqeOgD0OER0yYMRZJ4G
wqLiAUcVVylh6YABCRcpHwA8oAFmEaY6TjpwfKBjTKCEfpZYKKBhQcoHBUxU2eOGiIQCI5zMeXoX
igkQJoBM6WF2AZE1a5bI4MK14KVGf9z4GTrnJkcTWQIFYmmRUqA3qzG9cQ2ggIUedWgXxKsCs+Ye
EgAssLBA7gvSIvcskYCgcMrHI6qIAYKhNwjJtC9qrdWApIsUEHLpKsKUR8qIvX0NYS2wtevXsAMP
gWFhFgALMz0ZRURSS7HwBmWUSNWBBTSkFVMMczRiE046iUTJIXnkEchQI5WkQwwLqESZSE9dlBFH
AIDwUUgNmeHED+VRxGJtI85oI0MBAQA7
"

image create photo imgEditPaste
imgEditPaste put "
R0lGODlhGAAYAPYAAAAAAAEBAQUFBQoKCgsLCw4ODg8PDxAQEBkZGRsbGx0dHR8fHyAgICEhISMj
IyYmJicnJy0tLS4uLi8vLzAwMDIyMjMzMzU1NTg4ODk5OUFBQUJCQkREREVFRUZGRkxMTE1NTVBQ
UFFRUVRUVFdXV1paWl1dXWpqanR0dHd3d3h4eHx8fH19fX5+foODg4iIiI2NjY+Pj5ycnJ6enqCg
oKOjo6qqqqysrK2trbW1tbu7u8vLy87Ozs/Pz9PT09vb29zc3N3d3eDg4Onp6erq6uvr6+7u7vDw
8PLy8vX19f39/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEsALAAAAAAYABgAAAfUgEsmAAlLSz8AADOGgwqGj5BLIQAFhjyJMIaTlZGQPCo3hkowLUWW
oJ2pkEYqNTavsLA0LUmGPi85kA+JvL29GZqUkAq+xYkShiWEkBsAFDrQ0dEMACSGRjpBzAAbqksS
1d7N3arg1ks3HC3b5KnmhiDCj+Pe70sozuz14YZHSvrl+KWiF/CciwMcDBVhIIDbvnPxCBjawatd
J3szKJwwlIRDAYcFxYF0J7ATBwAZgqhcuXLXuVTUjPm64C2mTF7IVPkI0eKFz58/VZAQ4q2o0aOp
AgEAOw==
"

image create photo imgEditDelete
imgEditDelete put "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgMDAwYGBgcHBw0NDRAQEBQUFBUVFRkZGRoaGi4uLjAwMDEx
MTw8PD09PUBAQEZGRklJSVNTU1RUVFhYWICAgIGBgYuLi4+Pj5KSkpOTk5ubm6ioqKmpqaqqqra2
tre3t8PDw8bGxsfHx8zMzM3Nzdra2vHx8fLy8vPz8/T09Pb29vn5+fr6+vz8/P39/f7+/gAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADMALAAAAAAYABgAAAajwJlw
SCwaj8ikcslsMl8yo+zFlKVMKBaRhTKloskUhxH5ED+RBielTGEUg4lIJhNNBgoMO/kiTQoGFSMk
FQYFEiRUSjIfDwMHFBYJAw8eYEsyHQwDnAMMHZdMYgecBhl7TiwaBqWnTjOZDZ2eoE2MjgkVFqQP
H6FHfX8GFIMUhoiKSG4Kh3N1d3moR2JkZkNoDGuLV1lbXV9Pv7DJr+Xm5+ivQQA7
"

image create photo imgEditDuplicate
imgEditDuplicate put "
R0lGODlhGAAYAPcAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgcHBwgICAkJCQsLCwwMDA0NDRERERIS
EhMTExQUFBkZGRoaGhwcHB0dHR4eHh8fHyIiIiQkJCcnJygoKCkpKSsrKywsLC4uLi8vLzMzMzQ0
NDY2Njk5OTs7Oz09PT4+Pj8/P0BAQEFBQUREREdHR0lJSUpKSktLS09PT1JSUlRUVFVVVVdXV1pa
WlxcXF1dXWBgYGJiYmNjY2RkZGdnZ2lpaWpqamtra2xsbG1tbW5ubnJycnR0dHV1dXp6ent7e39/
f4GBgYKCgoiIiIqKio2NjZGRkZOTk5SUlJWVlZaWlpeXl5iYmJmZmZqampubm5ycnJ2dnaKioqSk
pKmpqaurq62tra6urra2tri4uLu7u7y8vL6+vsDAwMHBwcLCwsPDw8TExMXFxcbGxsfHx8nJycrK
ys3Nzc/Pz9DQ0NTU1NXV1dbW1tnZ2dra2tvb297e3t/f3+Dg4OLi4uTk5Ofn5+np6evr6+zs7O3t
7e7u7vHx8fLy8vPz8/b29vf39/n5+fr6+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAI0ALAAAAAAYABgA
AAj+ABsJHEiwESNGg8YMCRFCDqOCEAcWgvNkRggKCyJgCRSR4CA3VYC4wKAAgEkFMOp0HATHixIa
GgyYNKABg0kKYwoOwqMGyw0MMk0CcFCiiRINAAw08TMwjxceHoIKNRDBRhtGfp44MACjzUASFBTI
HGvAgIcqexIJxGPEAYUtAz0sAEBBR5MqVZ5kIePnocBEeLJgkTMQSIQIQ+QMSsTYL0RGjAeC8eBC
TaAtePPmfcJ5M17OWLYEciFkTxsKQlOrTm2AQqIjT/yQKbl6tVihjMB88aNGam0AChxcxB2oTiAy
QSmgICHVAYokX9zQECqwEKPeJmF4qUJBZgQdZPJ2PHxywSRB5AAWMCm0p60DIG4IqplhfuBsACvI
GMRjA77OJPUJhJxSHO03iGMDPRFgI+jlNFAiCA5UxYID6tcRQQoCcJ5MMADBw4cghsgDECUsqIYD
v6W4AEF13LBCCTDCiAIKMs5IYwku6EAQZIz16GOPhfwYEAA7
"

image create photo imgEditMove
imgEditMove put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgYGBgcHBwkJCQsLCxQUFBkZGRoaGhsbGx8fHyEhISIiIiMj
IyUlJTc3Nzs7Oz4+Pj8/P0VFRUdHR0lJSUtLS05OTlJSUmRkZGdnZ2lpaWpqanNzc3h4eH19fYqK
io2NjZCQkJiYmJmZmZycnJ+fn6GhoaampqqqqrS0tLi4uMLCwsPDw9TU1NbW1uDg4OPj4+Tk5OXl
5efn5+jo6Ovr6+zs7O7u7vPz8/X19fj4+Pn5+fr6+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEMALAAAAAAYABgAAAergEOCg4SFhoeIiYqLiTYwQYyIOSYgkJGEQTkjDxEwM5+goTaWhDYf
DgAFCqusrQcZpIMdqAC1tre2Ej2GKBIFuMC1uoY9KheqGh3Ky8saIrGELBcYu5eGLiXQiDrVhD06
kUElLtbEGBUriEEiyczMGgoFFSk7xBLBwAMSJvb4wA4dDAXJcKCVQQUDADjwIEOgjVAQZ8iA4CDE
qHKCgnwgkQPjoCCePIoc6TEQADs=
"

image create photo imgEditPushSch
imgEditPushSch put "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgYGBhAQEBMTExUVFRYWFhgYGBoaGhsbGxwcHB0dHSAgIC4u
LjExMTc3Nz4+PnR0dHh4eHx8fIODg4SEhIeHh4iIiIuLi5KSkpOTk5aWlpycnKCgoLCwsNzc3N7e
3t/f3+Dg4OLi4uTk5OXl5ebm5ufn5+np6ezs7PPz8/T09Pb29vr6+vz8/P39/f7+/gAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADIALAAAAAAYABgAAAabQJlw
SCwaj8ikcsmEfTacqHTzgTFdEYB2q424rlnu1gsWj79LrLmLVqrX5HTYHHfPxfUibIVCkSBrABAh
fStWQy0eDwsJA4EDCQsOHS1EMCEYBYFcBRUhh0QkGAubAAkXIUgwKBQNgQsTJKBGMCoTrmILEimz
R7UUCVwJu72qKRcHWgcVKMVKogkHGKlMRiEbG9TVeiuG29/g1UEAOw==
"

image create photo imgEditPushSym
imgEditPushSym put "
R0lGODlhGAAYAPUAAAAAAAUFBQoKCgwMDBISEhcXFxsbGx8fHyAgICcnJygoKCwsLDIyMjQ0NDg4
OD09PUNDQ01NTVJSUlVVVVtbW15eXmVlZWpqam1tbXJycoaGho+Pj5mZmZ2dnaqqqq+vr7e3t7i4
uLy8vMLCwsrKys/Pz9PT09jY2N3d3eLi4ujo6O7u7vLy8vf39/v7+wAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAC8ALAAAAAAYABgAAAbGwJdw
KJQkFEiEiMhsCiGAaPTjrD6lU2sViqVqhZiFw4HAAsSOBMnakgzMWATn+9IU4GcTXRhKYAMQK3tD
KQ1RBBaDTC0RBx2KJyiSkyQoJyp0EXhYBRcoVgybZgJeQx0cHIYVk6wnJR1+AUtDZg5aLA5nLkMJ
CAlvE18oAQAhTRQAGXS5DRYWF0PIGHQKZtEA01+GzRYYvghvEl8nxLMvZg9aK6ELRB8eHw8Aq6yS
JiMbBgABa00LolgIgKgyASAABBkwMQkCADs=
"

image create photo imgEditPop
imgEditPop put "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgYGBhAQEBMTExUVFRYWFhgYGBoaGhsbGxwcHB0dHSAgIC4u
LjExMTc3Nz4+PnR0dHh4eHx8fIODg4SEhIeHh4iIiIuLi5KSkpOTk5aWlpycnKCgoLCwsNzc3N7e
3t/f3+Dg4OLi4uTk5OXl5ebm5ufn5+np6ezs7PPz8/T09Pb29vr6+vz8/P39/f7+/gAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADIALAAAAAAYABgAAAaaQJlw
SCwaj8ikcghbrWDL5GizCUWPowzCcLFehbAUBgEAFColaBSmopDLAMQkpU6yJw04nCGh21MUeXpw
DRNpSCMYDIODCF1GMCEYBoyMBF11Mi0eDwwIA5UAAwgIDx0rRDAtJSUjEKEQI6wtmakRoREua7eV
uVEuvIy+S8C4usTBg8NKxb3HzMl6y3YfGxzX2BsftV/d3t9LQQA7
"

## OPTION


## VIEW

image create photo imgViewZoomIn
imgViewZoomIn put "
R0lGODlhGAAYAPUAAAAAAAEBAQYGBggICBERERISEhMTExQUFBoaGjc3Nzg4OD4+PkFBQUJCQklJ
SUpKSktLS0xMTF5eXl9fX2BgYGxsbHd3d3l5eXp6enx8fIODg4SEhIWFhZGRkZKSkpOTk5SUlLu7
u7y8vL29vcDAwMHBwcLCws/Pz9DQ0NHR0dbW1tfX19ra2tvb29zc3N3d3eDg4O7u7u/v7/X19fb2
9vf39/r6+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAAAAAAACH5BAEAADsALAAAAAAYABgAAAb+wJ1w
ONQZj8SkchhDlUSo2HKpm4k0E0ej4aBsRDPddHd7dRwEgHpNcHRYt+VtlTms72zMKp5kWQZ3AggI
AncDGCxJMx1pdwkvMAp4BCAzRCEOeAALNzoLmhEiRBuNd5w3n5MbQlUUmps3qK8TMUYnmQACCQsL
CRU6NxUKvAmFABEoRiINaggwRrGssTowCGoNJUYlzADOwNFk09XXJZ23arq8Cr86FbsLCsbIRjGu
mqepeBMzfKT3sfnWHFg1RAQuUwBBiRqyqJSaBDBgJJhUqQ8GQGsEETKE4YUSHSsw2HmlhkAGFmKU
3GDRIcLIOwcivOFDxcqGCRG2dPnSaUwOkiYlSqCw5JPKESNjggAAOw==
"

image create photo imgViewZoomOut
imgViewZoomOut put "
R0lGODlhGAAYAPUAAAAAAAEBAQYGBggICBERERISEhMTExQUFBoaGjc3Nz4+PkFBQUJCQklJSUpK
SktLS0xMTF5eXl9fX2BgYHd3d3l5eXp6enx8fIODg4SEhIWFhZGRkZKSkpOTk5SUlLu7u7y8vL29
vcDAwMHBwcLCws/Pz9DQ0NHR0dbW1tfX19ra2tvb29zc3N3d3eDg4O7u7u/v7/X19fb29vf39/r6
+vv7+/39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADgALAAAAAAYABgAAAbiQJxw
OLQZj8SkcggzjUYm2HJpi4EwkgaD0ZBkQDHbFGdrbRoEgHpNaGxUtWUtdTms72xLSpxUUQZ4gQAD
FipJMRtpgoEEG3FDHw2Liw0fRBl2k4wZQjYwE5qLEjBGJpIAAgkKq6ysDAkCahAmRiMMagguRjW8
vTU2LghqDCO1twC5Nr6+wMIAxKWnqa3UCrBqDbRVEqGCE2FCGYrdagecQyCn5AAQIESImd0EHjF9
FoChhC1KcxbxggQuqOCTpIaKDRDGrTkAwUOLR1SsZJAAYUuDCV/AjXnnBEq9jVSOGBkTBAA7
"

image create photo imgViewZoomBox
imgViewZoomBox put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgQEBAUFBQYGBgcHBwgICAoKCgsLCwwMDBYWFhcXFxoaGhsb
Gx0dHSMjIysrKzQ0NDY2NkBAQEFBQUJCQkNDQ0lJSUpKSk1NTVFRUVJSUlZWVldXV1tbW1xcXF5e
XmJiYmNjY2RkZGlpaWpqamtra3t7e4aGho+Pj5aWlpeXl5ubm6ampqurq66urq+vr7i4uLq6uru7
u76+vsfHx8jIyM7OztXV1dzc3OHh4eLi4uTk5Ofn5+rq6uzs7O3t7e7u7u/v7/Pz8/T09Pn5+fr6
+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAEwALAAAAAAYABgAAAf1gEyCg4SFTEtGiUZLho2FPSshGyg2jpY8KxEDAQsjNktLQTUtK6Wm
pjNBMxMBrQEOKIswFJuutgEaOC4KtxuIHQMIDsPEww8kOTALtggfiRQBIT891DzU1EFLNhu1AREt
zwElloJFMxsLCBIqPaAX4uSCRDcvLjM8gkas4/FMRjk4ggwyAo1fvCAjMMgYWLAfkx4PAqxgCK9f
DwcBWlA0SO6ixEFL3nG05HFivn0OeWA06a+hxZUbHZaM+fJjPpfxZubD4K2Ez59Af4bgpTFfCgi3
ktoaQKEGSB0pMFCgMOHC1KlVr1L4AEMgSESKwIZVlAjUoEAAOw==
"

image create photo imgViewToggleColors
imgViewToggleColors put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAg8PDxERERISEhMTExQUFBUVFRYWFhkZGRsbGx4eHiUlJSYm
JicnJykpKSoqKj4+PkJCQkNDQ0RERE5OTk9PT1FRUVJSUlRUVFdXV1hYWFlZWVpaWltbW2JiYmNj
Y2RkZGdnZ2hoaGpqamtra2xsbG9vb3BwcHFxcXJycnNzc3R0dICAgIGBgYKCgo6Ojo+Pj5CQkJGR
kZKSkpycnJ2dnZ6enqCgoKGhoa2tra6urrCwsLGxsbKysrS0tLq6ur29vb6+vr+/v8LCwsPDw8rK
ysvLy8zMzM3NzdHR0dTU1NXV1dbW1tfX19ra2tvb29zc3N7e3uLi4uTk5Onp6evr6+zs7O3t7e7u
7u/v7/Hx8fLy8vn5+fr6+vv7+/39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAGMALAAAAAAYABgAAAf+gGOCg4RQJShThIqLiksUFUuMilNDR2GETBYWTIRhR0OJg0MjI0le
g1c7O1eDXkekQ4RJIBEwXIJeWldXWqdjXDARIEmKRzA1XGFaRzYwMDZJWmFcNTDEil5cyUwrDggG
AwYOK0zTXL6LXkwcChI1NgYBAQYc5ZKCWisKG0FaVQvyAiBooeWeKwcSggj6FzCAgySXBkFZskQL
FxsIYrAaU0VBQwQ2tGhhsmRKCQoWVsEwAGRQx48tUmWocAilSpYuAQYcAONKjw0USkxZwkQkxhgF
OeqUZyDkyJKdjkSoEIujx4AP0S3Kt4BDv5fyBt66F2ZduxgYw36AopVQtm1NLbwhCDeOydu2Y4wh
m5ak2bMkybpUuzZoVq2xuXb1EgQsQilCQ0oMQ5eqR9IxXmaVKEKIEkRMFjJwGhQmSREq9wY5ohAp
9T1DJaCkDgQAOw==
"

image create photo imgViewRedraw
imgViewRedraw put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgMDAwQEBAUFBQYGBgkJCQoKCgsLCwwMDA8PDxAQEBERERMT
ExQUFBUVFRsbGxwcHB8fHyQkJCkpKSsrKy0tLS4uLjExMTQ0NDg4ODo6Ojs7Ozw8PD09PUREREVF
RUZGRkdHR0lJSUpKSkxMTE5OTk9PT1JSUlNTU1VVVVdXV1hYWF5eXl9fX2BgYGFhYWJiYmNjY2Rk
ZGdnZ2hoaHBwcHt7e39/f4GBgYeHh4iIiJCQkJGRkZiYmJ6enp+fn6CgoKKioqOjo6SkpKWlpamp
qaqqqq6urrCwsLGxsbOzs7S0tLa2trm5ubu7u729vcDAwMLCwsPDw8jIyMrKys3Nzc7Ozs/Pz9HR
0dLS0tTU1NfX19jY2Nra2uDg4OHh4eLi4uTk5Ofn5+jo6Ozs7O3t7fDw8PHx8fLy8vPz8/T09PX1
9fb29vj4+Pn5+fr6+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAHYALAAAAAAYABgAAAfmgHaCg4SFhXRqXVWGjIxVNytHjZN0Z0ApESJdk4xtWTsXAhdAcZyF
alEwCwIQOGp0poKIRhsCtjBbsbJlOhS2AhtNunZxWTQRvxRGarptUi0MvxA8ZbpqTSkHvww0YbCm
akkkvwIHKV2lpnFCteQkUd+ccUftvyBJ8ZNxVSIE5BtH2uiK82XFKgEENBipJm+LESBPjrRYcOAD
kDOxjFEU0YSJCxEBdeU4KOBDky9Z0nGi0wYGOQE+4uSjtMXESx/D7NAxEuqXCSk5w6hCeAHGE2bD
pKSo8MHFjzEzTXVhwgQdnaimAgEAOw==
"

## PROPERTIES


## LAYERS


## TOOLS

image create photo imgToolInsertSymbol
imgToolInsertSymbol put "
R0lGODlhGAAYAPUAAAAAAAYGBgkJCRcXFxoaGh0dHSAgICYmJiwsLDMzMzg4OEdHR0hISFFRUWtr
a2xsbHd3d3l5eYKCgoWFhYiIiJGRkZmZmZ6enqOjo6enp6qqqqysrLu7u7+/v8vLy83Nzdra2t3d
3enp6fPz8/f39wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACUALAAAAAAYABgAAAaTwJJw
SCwaj8ikcslsJkeekHQq/YiWowBgy+0CFh4j6fPJeM9cSVHhPUDecAgDwaUQCd5FciMACEBDIBQU
EFsQShdbDkYhWxFLBgADGhobQ40Aj0oJXpeOS3RdIRYWE59KkZOVBXmIWw9DnF0Ne31/QyQdHBhb
CnFwc1wVRx9oZwFqR1nGXGBKUFRUVk7U1dbX2EVBADs=
"

image create photo imgToolInsertText
imgToolInsertText put "
R0lGODlhGAAYAPUAAAAAAAMDAwQEBAgICBERERMTExUVFRYWFh8fHyAgICIiIjQ0NERERFVVVVZW
VlhYWGZmZnd3d3h4eH19fY2NjZSUlKCgoKqqqqurq7u7u729vcvLy83NzdDQ0NHR0dLS0t3d3eHh
4eLi4u3t7e7u7vLy8vX19fb29vz8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACsALAAAAAAYABgAAAZ2wJVQ
qCIZSSXTcMlckhSAqLTSrAo/0uzDarVEvt+JiEsum8/cz2XNbrPHVZAgS88aVFXRvF5H4PMZgYKD
GoUkaIiJZhQQjY6NEiVmHHxTZiULBJqbmgofiqChomQmDJynnAYSVZSVdQRVKhMNtLW2thejurtc
QQA7
"

image create photo imgToolInsertWire
imgToolInsertWire put "
R0lGODlhGAAYAPUAAAQEBA8PDzs7Ozw8PD09PUREREVFRU5OTk9PT1BQUGJiYmNjY2RkZGVlZWho
aGlpaXd3d3h4eHx8fH19fX5+foaGhoeHh5OTk5SUlJubm6WlpaampsHBwcnJycrKysvLy8/Pz9DQ
0NTU1NXV1dnZ2dra2ujo6O7u7u/v7/Hx8fLy8vz8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAC4ALAAAAAAYABgAAAaDQJdw
SHS1WsWkcpjqdFLLqBAkYTAkIakydSlYLAUMVEscRRjHR2REJpaqJtO11B62NoPDYbBB1oUnGQEB
GWN/QhwAAByHRImLjUOPjJEuk5WWipSRl5WdnJqVgYOFjXcCCQl8fnUlEQpxc4dmD0cMa4cpGF5g
Yo0hVVdZkU0ghpFHWkEAOw==
"

image create photo imgToolInsertLine
imgToolInsertLine put "
R0lGODlhGAAYAPMAAAQEBAcHByAgICEhIcHBwcLCwsjIyMnJyfLy8gAAAAAAAAAAAAAAAAAAAAAA
AAAAACH5BAEAAAkALAAAAAAYABgAAAQ1MMlJq7046827/2AojmTZIQahrmxRGAhmDAFg33gwGDKN
/wAd74JiGVWvmGnJbDqf0Kg0EwEAOw==
"

image create photo imgToolInsertRect
imgToolInsertRect put "
R0lGODlhGAAYAPQAAAAAAAgICAkJCQsLCxsbG0BAQEFBQV5eXl9fX2BgYGFhYWlpaWpqapaWlp6e
np+fn8TExMXFxeTk5Pn5+fr6+v39/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABYALAAAAAAYABgAAAWPoCVWVFlO56SaVCW+FnQUdG3bBwSLzgD8wGBw4NhZGoDBgcFsOg++hhFJ
kBhhEgJAuqNar6LsdgqogsNaLsx7tojVL/b5TTbP0/UvmN4t6698a35tgXGDd2N9dnt4in9GhSJy
jImCi4CNlo87kUeHlHCSSUtOpVCVLz1Cq0BERjI3sTUKOjskJiorLCYuIiEAOw==
"

image create photo imgToolInsertPolygon
imgToolInsertPolygon put "
R0lGODlhGAAYAPUAAAEBAQUFBQoKCg8PDxMTExcXFxoaGh4eHiYmJiwsLDExMTY2Njk5OUBAQEpK
SlRUVFdXV1lZWV5eXmRkZGdnZ3d3d39/f4KCgoqKio6OjpCQkJmZmaampqqqqq6urrCwsLu7u76+
vsTExMnJyc7OztPT09nZ2eHh4ebm5ujo6Ozs7PPz8/j4+Pv7+wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAC4ALAAAAAAYABgAAAa9QJdw
SBS2LJNWccl0pRoAgKhJdYkMUUCoyswEsloucQWJBjbRrdhlSkQPI1d6/RlEHSrhvNqqZCtEe00o
DFEEakOCTBFRCydLUQxxTRMACCxMClkTKEwcAAErTCl+UQMZSkQqUR9EIiCwIBoEWQggRYUTQxlg
vVmILhcAB0YHvr6tQyNRJS4dURgb0tPTyUQFABguhQ1rRBIADSRRHt5DnwJlxOZCKWDa7EKFAAOd
8cFRuvcu4wDN+8HgeQsCADs=
"

image create photo imgToolInsertArc
imgToolInsertArc put "
R0lGODlhGAAYAPUAAAMDAwQEBAwMDA8PDxYWFh8fHyEhISwsLDExMTk5OUREREVFRU9PT1dXV15e
XmBgYGZmZm5ubnR0dHd3d4GBgYSEhIqKio+Pj5ycnKKioqenp6qqqrm5ucnJydbW1tjY2Nzc3OHh
4ebm5ujo6Orq6vLy8vX19fn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACgALAAAAAAYABgAAAaHQJQQ
NQqBRKehcslcAJ6AwOGxMTGvJaj2OZiMrksNZDKJMArawSUJBoMoBKhC1G6fLIOnIVRvexB6dH1X
Jk4ACWyDSyYJTxOKVyFxAR6QTBlPDZZMgAAgm0obTxWgQyd5CKVDDE9WqhNPHaooogAbsxxPGLi6
sxpPt6oUsbMPTyWzGwEOs0tBADs=
"

image create photo imgToolInsertCircle
imgToolInsertCircle put "
R0lGODlhGAAYAPYAAAAAAAEBAQICAgYGBgcHBwgICAkJCQoKCgsLCwwMDBMTExQUFBUVFRkZGRoa
GhsbGxwcHB0dHR4eHh8fHykpKSoqKjQ0NDU1NTY2Njc3Nzw8PD09PT4+Pj8/P0pKSktLS0xMTFBQ
UFFRUVJSUlNTU2BgYGFhYWNjY2dnZ2hoaGlpaWpqam1tbW9vb3BwcHFxcXJycn19fX5+fn9/f4CA
gIGBgYKCgoODg5KSkpOTk5SUlKenp6ioqKmpqaqqqq2tra6urq+vr7CwsLGxsbKysrOzs7S0tLa2
tre3t7i4uL+/v8DAwMHBwdDQ0NHR0djY2NnZ2dra2tvb29zc3N3d3d7e3t/f3+zs7O3t7e7u7u/v
7/Dw8PHx8fb29vf39/j4+Pr6+vv7+/z8/P39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAGUALAAAAAAYABgAAAf+gGWCgmRkYFA7NSwuNT1QYGSDkpJdRSgaFBEPDxEUGitGYJODZFAx
GgYBDxogIBoPAQYaMVCRkmRNLAoGGSs6RUxMRTorGQYLLE2TUCwGCiRFWKNYPyQLBixQhF0xCgsn
VbajZFUn3jVdZWRFGgQkVaKjg2BVJLJGhii8RfHy8z+oVpTSEGAFF3H+1HFZEUADlB6ZdCSUl+MB
hR41ImgwMnEUuwiKHoBg0nGSkg8PXLgQSbLkICYfIjDSWMTloI83dmTKYVNQxYtQCBpE6I8MFhQN
H+nLUISoPDI/jK2AZAQViUcT6YEgoCFJJG4LFIBzSqjcuX5QXBB49kPaJGo7IHa50CYp1wICvXIU
UaKkSI5ix5KNM6UhgSoNHz68iqWhRjh/XZKs0FBBEydPK5L0K3qox41FjR45DQQAOw==
"

image create photo imgToolSearch
imgToolSearch put "
R0lGODlhGAAYAPUAAAAAAAoKChISEhYWFhkZGSIiIicnJysrKy0tLTMzMzc3Nzg4OEBAQFFRUVdX
V1tbW11dXWNjY2RkZGpqamxsbHFxcXR0dLm5ub+/v8HBwcbGxsnJyc7Ozs/Pz+/v7/Hx8fj4+AAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACEALAAAAAAYABgAAAakwJBw
SCwajyHNZFFYUDbIo6cBqFoBjk906DlYB4mBNaHdUgGIzPBiqD62miqizG0DOFFKVW28VC1RCgAE
UQIADFFtCVFeB1ELg4WHeVUYR34AgEhxAAd0Ql1VeFEOVQeWQmxVBlshHghfYVcBE60fpVerAQAB
Eq0hGxQLBgsVUBK7ARG/SBHJvsxGEM/R0tTVRNO80NhC2gkg3UMPCR7iROHnR0EAOw==
"

image create photo imgToolJoinTrim
imgToolJoinTrim put "
R0lGODlhGAAYAPUAAAAAAAEBAQMDAwQEBAUFBQsLCw0NDQ4ODhAQEBERERMTExQUFBkZGRoaGh8f
HycnJykpKSoqKi4uLlRUVFdXV1hYWF9fX2NjY2RkZGVlZWhoaGlpaW9vb3BwcHJycnNzc3l5eXx8
fIqKio2NjZCQkJiYmJubm5+fn6amprm5ub6+vr+/v8TExMbGxsjIyMnJycvLy87Ozs/Pz9HR0dLS
0tPT09TU1NbW1tjY2Nvb2/r6+vz8/P39/QAAAAAAAAAAACH5BAEAAD0ALAAAAAAYABgAAAagwJ5w
SCwSeTqecbnkrU4sJlMm6+lklYeFpZQSRZ7bbbMAQEpdrzDDyHgMAAMllVZvAARC/AJTF+8AeBwz
dX6AgRkzfn+BgQweiotCKBcblhkikZKbnJ2enjckFhmWFyicOCEPjQAbnTgceoGumzwzHqy0kjAX
BXizkjwsFAhxHh4OGZI6JxIACBczOCAjwbwQFTI6PTeaizAnK4W1POOLQQA7
"

image create photo imgToolBreak
imgToolBreak put "
R0lGODlhGAAYAPUAAAAAAAEBAQICAgMDAwoKCgsLCw8PDxAQEBERERMTExUVFRYWFicnJywsLDEx
MVFRUVJSUlNTU1RUVFZWVldXV1hYWFpaWlxcXF1dXWFhYWJiYmNjY2VlZWZmZmlpaXR0dHZ2dnl5
eZqamqKioqamprS0tLa2tre3t7q6uru7u7+/v8DAwMTExMXFxcbGxsfHx8jIyMnJycrKysvLy8zM
zM3Nzfj4+Pn5+fr6+vv7+/z8/P39/f7+/gAAAAAAAAAAACH5BAEAAD0ALAAAAAAYABgAAAafwJ5w
SCwaj8ik0phDhTxQT4e0JOpQlwVgC/BUi7MKt/sd6midAddb7s0yhTG7qlNRDoBChaLolHUkDnkV
LWEgf2gMESs5PScnbW4iKDpCOY1tOjmVXzqekZdCVyIzkSUlPTktEQwZLZxVHxSFF3gNIrBLHQcU
F3G8KrlKHmMFFy2RxFsDHTOYZcpbFKXJYwoVKM9VJBlRHSAn2pHj5EZBADs=
"

## SYMBOL

## HIGHLIGHT

## SIMULATE

## HELP

## ACTION BUTTONS

image create photo imgSimulate
imgSimulate put "
R0lGODlhGAAYAPUAAAAAAAEBAQQEBAkJCQ8PDxoaGhsbGx4eHi8vLzY2Njw8PD09PUVFRUxMTE1N
TVVVVV5eXnZ2dnp6ep2dnaCgoKGhoaioqL6+vsHBwcLCwtDQ0NHR0dbW1tfX19ra2tzc3OPj4+Tk
5OXl5ejo6Onp6e/v7/Hx8fj4+Pn5+fr6+vv7+/7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACwALAAAAAAYABgAAAZ5QJZw
SCwaj8ikcslsKlMajslpHCkallGKOgwdBAbIJbXiegEAQkLi2TpDBjQA/JiA3nE5eo2ZLuF6cgMM
FG1KgIFyBhF+SIiJAIslh3mBgxQfbo4HiQgSGJNLIJUAB3V3TWdpa4ZvXwdiZGZXWZpUUB6NXLu8
vb68QQA7
"

image create photo imgNetlist
imgNetlist put "
R0lGODlhGAAYAPUAAAAAAAUFBQcHBxERERISEiIiIiUlJSsrKzMzMzo6Oj8/P0tLS1JSUl5eXmBg
YHNzc3d3d3x8fIKCgoaGhoiIiI6OjpGRkZaWlpmZmZ6enqOjo6enp6ioqK6urrGxsbq6usHBwcXF
xcvLy9TU1NnZ2d3d3eXl5enp6e/v7/b29vn5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACsALAAAAAAYABgAAAa8wJVw
SCwaj8ikcsk0pjocjieqiXI6zA6AwO12AUwOGBkgqhihojhZHp4AAQ5Ra/ESFsK28A0ATIZiJBiD
gx95HlAcGX19DiorWmyMk30BCihiIxSbnCArAZSUAQYaABcFqKkPn6GTAQQXY0egAQICAaCVBiVr
ZBWcEZOXkH6UCXlEfAANjytiJldWIshufX+AskZ6KykHcnMAIRDj5B6fYQAaCOvsEudLkWRZW3Zf
TCkZF4T6hBlN/wCNBAEAOw==
"

image create photo imgWaves
imgWaves put "
R0lGODlhGAAYAPUAAAEBAQUFBQsLCwwMDBISEhcXFxwcHCUlJTIyMj4+PktLS1FRUV1dXWNjY2Vl
ZXV1dXp6eoeHh4uLi5OTk5iYmJmZmaOjo6ioqKqqqru7u729vcPDw8fHx8nJyc/Pz9DQ0NXV1dvb
29zc3OLi4uXl5enp6e3t7fHx8fX19QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACkALAAAAAAYABgAAAbMwJRw
SCwaj8gk8YBROlOEytAkCBACgtMBQKhqFIABoQCVCjeAdLqjTkMM7fIQlMakQQOABG5JABoZG1AT
JoUcaSRrAgAaWxV+EUOLbWkjlBiTaQ6SlGkoAW0bcGoQQwQRIqkiHyUpJB4iICEpKB0iIR5EUUUP
YQS/BGJiwGNyRAidyWnGQw0AChnR0tPRggSEhYUMAJtPKZmUCd7fygvjpyGqqR3jzO26Zu9DHgMQ
Hh33+fj6/PghygCTiRiASp3Bg+pIpHjwQZ5DJUEAADs=
"


} else {


image create photo imgWaves
imgWaves put "
R0lGODlhGAAYAPUAAAAAAAoKCg4ODhISEhYWFhoaGh0dHSMjIyQkJCoqKi8vLzAwMDY2Njg4ODw8
PEJCQkRERFVVVVxcXGZmZmxsbHR0dHh4eIWFhYqKipqampycnKKioq6urrS0tMHBwc3Nzdra2uPj
4+jo6O3t7fPz8/T09Pr6+v7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAbMQIBwSCwaj8gkERRROgGjyXBQMo1MJQHoNKo+OifS
SASVCh2ndJqhTl9C7fIwkY6kE6RTBS7xnDQQDlAUA4UNaQVrJScPWxN+FkOLbWkGlBGTaRmSlGkB
Jm0OcGoXQyMWB6kHCgQABQsHCQgAAQwHCAtEUUUYYSO/I2JiwGNyRB+dyWnGQxonHRDR0tPRgiOE
hYUbJ5tPAJmUHt7fyhzjpwiqqQzjzO26Zu9DCyQXCwz3+fj6/PgIygCTHSCBSp3Bg+oKAMCgQJ5D
JUEAADs=
"
image create photo imgViewZoomIn
imgViewZoomIn put "
R0lGODlhGAAYAPUAAAAAAAEBAQQEBAoKChERER8fHyIiIiUlJSgoKC8vLzAwMD4+PkNDQ0RERGtr
a25ubnt7e3x8fIODg4WFhYiIiJOTk5+fn6CgoLOzs7a2tr29vcHBwcfHx8jIyOXl5evr6+7u7vf3
9/n5+f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAb7QIBwSCwaj0VCYsFIEJDHASNyyWg0GQuEMYACBIZH
BjQqm0GZx0FwFCAkH7P8PEGwiwdKSC7yeERyIRMHRQMPZHIdBgUccyAOXUMNGXMjG2wblRgMRBCI
cpcCmY4QQwMWlZYCoqkXTwAKlCMiHRsbHRVfFRy2HYAjGAlCDBplHgVCq0PKBR5lGgtCC8Ujx1/K
12zNzwtssWW0thy5ABW1Gxy/wUIEqJWho3MXA3ee76vxZh+lQwyyoPg0cTJ1aE6HAgU6OIKEZ8Ie
M33+BJpg4AiCCXFSlQEhgVCbAw8wZJTzAYOaO0ikQLiA4UqWLSi9sFuyIEEkmTiRBAEAOw==
"
image create photo imgToolInsertArc
imgToolInsertArc put "
R0lGODlhGAAYAPUAAAAAAAYGBgoKCg0NDRcXFxkZGR4eHiMjIykpKTY2NkZGRlVVVVhYWF1dXWNj
Y3BwcHV1dXt7e35+foiIiJGRkZmZmZ+fn6GhoaioqLCwsLq6uru7u8bGxs7OztPT097e3uDg4Onp
6fDw8Pv7+/z8/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAaHQIAQQDAcCoGhcsnUkJ6kkceyEDCvA6j2KZoQrktG
ZTKhZEBa0SMJBh8kIaim0G4HIKLnx1BvIzp6dH1XAk4kHGyDSwIcTxOKVwZxIwiQTA1PGJZMgCQH
m0oLTxGgQwF5HaVDGU9WqhNPCaoAoiQLswpPDri6swxPt6oSsbMWTwOzCyMXs0tBADs=
"
image create photo imgSimulate
imgSimulate put "
R0lGODlhGAAYAPQAAAAAAAEBAQUFBQ4ODhAQEBcXFxsbGxwcHCMjIyUlJSkpKS8vLz4+PkFBQVdX
V19fX2JiYoWFhYmJiaGhoaqqqrOzs7q6usPDw8nJydDQ0OHh4eTk5PDw8Pb29vv7+////yH5BAAA
AAAAIf8LSW1hZ2VNYWdpY2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAVxICCOZGmeaKqubKsK
izK4ZnFVTiHQo6F5m0ljx/N9PhxMJEFsGTbHD5ACObie0aiSMVths8eO5cFUfcHHjaSLOqPVBDMU
LX4gmicjOBNhxFcHc0caVFZOGkdJS3hePxpCjCwGNzmRLDAJbDybnJ2enCEAOw==
"
image create photo imgToolSearch
imgToolSearch put "
R0lGODlhGAAYAPUAAAAAAAcHBw4ODhAQEDExMTY2Njk5OT4+PkBAQEZGRouLi46OjpOTk5WVlZub
m5ycnKKioqSkpKioqK6urr+/v8fHx8jIyMzMzNLS0tTU1NjY2N3d3ebm5unp6e3t7fX19f///wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAakQIBwSCwajwBDo7KpMArI42ACqlpBEkF0OMhYO5eO
9aLdUkGYwzChqUa2hiqmzG2DCFFGVW1MVBVRFiAcUR4gFFFtF1FeGVEVg4WHeVUIR34ggEhxIBl0
Ql1VeFESVRmWQmxVGlsAAxhfYVcfDa0CpVerHyAfDq0ABQwVGhULUA67Hw+/SA/JvsxGEM/R0tTV
RNO80NhC2hcB3UMRFwPiROHnR0EAOw==
"
image create photo imgEditUndo
imgEditUndo put "
R0lGODlhGAAYAPUAAAAAAAICAgUFBQoKChISEhUVFRgYGB8fHyMjIyUlJSsrKy4uLjMzMzk5OT09
PUJCQklJSVFRUVpaWmFhYWVlZWpqam9vb3V1dXp6en9/f4ODg4eHh4iIiI2NjZOTk5eXl5iYmJ6e
nqOjo6ysrLS0tLu7u7y8vNXV1d/f3+Pj4+bm5urq6u/v7/Ly8vj4+Pz8/AAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAaoQIBwSCwaj8ikcskUIhBNZAFTiRoLGdXHSjR0Ui8Q
1+kBv7bcxWf1ap8+HAvEsGSs2/h2qsSJHJAKIS15hG4YCAJGGGaFhCshColEBx8sjYUtIwpGChyD
eC4tLoUsHAmcG2xtJhITFBUZHiQoLikUkkQIHSptYkMDCA8WIiojDkcFHShhSAYYJhi4RAQbWkoT
GZtHBBoXSgMNEEkHf0oE5WNE0uns7UxBADs=
"
image create photo imgEditPop
imgEditPop put "
R0lGODlhGAAYAPUAAAAAAAICAgUFBQkJCQwMDBMTExYWFhsbGx8fHyEhIU9PT19fX2NjY2lpaWxs
bHR0dHd3d3h4eHx8fIODg4eHh4uLi8HBwcjIyM7Ozt/f3+Li4ufn5+rq6uzs7O/v7/n5+f///wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAaNQIBwSCwaj8ikkkggLJUIhyPxPCIeG06EWh0asCBQ
R3LoAgqTTTi8oRiqBUpmvdZU3krDZE5fZyhlSFcafX0bW0cJDxyFhR2IRAMLGBobH40gHxsbGAxO
kQcHCBeYFwihA0oWmBYCVauNrU8CsIWyS7Ssrri1fbdKubG7wL10v0oKDg3LzA4KZtDR0lVBADs=
"
image create photo imgFileSave
imgFileSave put "
R0lGODlhGAAYAPUAAAAAAAEBAQUFBQoKChMTExUVFRkZGSoqKjU1NTk5OT4+PkVFRUlJSU5OTlJS
UlVVVVlZWV5eXmxsbIuLi4yMjJGRkZaWlpiYmJ2dnaCgoLa2trq6ury8vMHBwc7Ozvj4+P///wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAa0QIBwSCwaj8hkkdCgWCyYjHQqxVAiBWOD8wGBNNHp
Zbz5eCCE4sTrVRQPCoOi23EMiBb2xz0UcEAUCGwaC3h6fEICHYAIXV4Thl57RIogFQmOIBaRIJNE
ixQJbJqcHw2UEhcPDJmbQ3mSFQ0KCgsKCQgMFa2ckh+/v52jpK/DxseuQrDHzMTKzc3JAMvQw9LU
1WzX2cbb3KPSa99skEMNZd8fGwxETE5P8PHxEw1pSvf4+UNBADs=
"
image create photo imgEditCopy
imgEditCopy put "
R0lGODlhGAAYAPUAAAAAAAEBAQQEBAgICA0NDRMTExgYGCgoKDMzMzs7Oz8/P0FBQUZGRkpKSktL
S1RUVGZmZmlpaXd3d3l5eX5+foGBgYiIiJqamp6enqWlpaurq6ysrLu7u8XFxcfHx8zMzM7OztDQ
0NTU1Nra2u7u7u/v7/Hx8fX19fj4+P///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAa+QAEqRSwaiwuAcqk0HJ/FCZNZIGYg2CyWQnxMl9VU
5Ks8dMmA8JhsTmEEyoREoVSj2ykvAJQC1YlrX3gMSh0pHX9id0QUSwYLBomBU216X3ZsZ0oRHGuY
gpoAISkhiRCLeUsaKRuSqJZpYICvaJ+UoRclF4knJb6/viahIqSJUEdSShMgyQAYIxrR0tMgHQNo
aAQIBEsHB2AIBdgAHIdKCkRJ5Ckc46OlAA6a7+MOFg5KBBUU1/H34wADCmQSBAA7
"
image create photo imgEditDelete
imgEditDelete put "
R0lGODlhGAAYAPQAAAAAAAEBAQUFBQsLCw4ODiUlJTMzMzk5OTw8PEhISFZWVldXV2RkZGxsbHBw
cHR0dH5+fqenp6urq6ysrLa2trm5ub+/v8PDw8/Pz9HR0ebm5urq6u/v7/Ly8vj4+Pz8/CH5BAAA
AAAAIf8LSW1hZ2VNYWdpY2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAWPICCOZGmeaKqubMsK
KMwSRjGQQ2EQK9FkFgVJYcE0eCkCRPOhJEQJykcDQcYOFE9HgjhIOp7KQaZSXD6cSWTzuQhdjMxn
/skwXCIfZ955WFsDDh18fngADBh0dXcuZh8bEhF7bi9YWhNdE2BiZCdKGmFPAFFTVSo+QG8iRBlH
PTU3Izk7LZ0ktoa5uru8KCEAOw==
"
image create photo imgToolInsertPolygon
imgToolInsertPolygon put "
R0lGODlhGAAYAPUAAAAAAAQEBAcHBwwMDBMTExcXFxkZGR4eHiYmJiwsLDExMTY2Njs7O0FBQURE
RE9PT1FRUVVVVVlZWWZmZm9vb3FxcXV1dX19fYCAgIiIiJubm6GhoaampqioqLW1tb+/v8bGxsnJ
yc7OztPT09nZ2eHh4eXl5ejo6Ozs7PDw8PX19fr6+v7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAa9QIBwSBQGMJpAcckEFD4sFqNJBTBMUVajyqysslou
cdCJribRrRiAGEVLC0B6/UhFPQThvBrIZDNEe00GIFEoakOCTBxRIQdLUSBxTRosJEpLIlkaBkwS
LCsDTAV+USkVmEMEUQ9EDA6wDhQoWSQORYUaQxVgvVmIABcsJUYlvr6tQwtRCQARURYT0tPTyUQn
LBYAhR9rRBssHwpREN5DnyplxOZCBWDa7EKFLCmd8cFRuvcA4yzN+8HgeQsCADs=
"
image create photo imgViewRedraw
imgViewRedraw put "
R0lGODlhGAAYAPUAAAAAAAICAgUFBQoKCg0NDRISEhcXFxsbGx4eHiUlJSgoKC0tLTAwMDc3Nz8/
P0JCQkZGRktLS0xMTFFRUVZWVlpaWl9fX2FhYWdnZ25ubnd3d3h4eH5+foCAgISEhI+Pj5ubm5+f
n6Ghoaenp6qqqq2trbOzs7a2trm5ubu7u8LCwsfHx8vLy9LS0tbW1tvb2+Tk5Orq6u/v7/Dw8Pb2
9vv7+/39/QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAbIQIBwSCwaCYqGcblsfEgUphRQuJRgKcXUOGBsWrbW
RbAlEh6hmS3mIZSHhMrKRg8t3kID50W3rSJ4AgwgMH0vFW5lAw4jMn0xGgZvBBElNH0yIAiTEyd9
NjQlCmRbAhZznycPbwIUqH0pE6wNKTWfKxQDrAkkajY1LBWSUwILFRcQFCMzNCoXBWWDzCkREiIp
uW8dvjYqEQkMpFsDIZ82GeJlCybmGXhCFWB9Jg7vCGm/LSEQiW8OJS5UiMBw4J0QBRIkjDI4JAgA
Ow==
"
image create photo imgFileOpen
imgFileOpen put "
R0lGODlhGAAYAPUAAAAAAAEBAQcHBwgICA8PDxMTExcXFx8fHyYmJi4uLjY2Njk5OT8/P0NDQ0VF
RUpKSldXV2JiYmtra3R0dH19fYKCgoaGho+Pj5GRkZaWlp+fn6Kioqampqurq7Gxsbm5ucbGxsnJ
yc3NzdPT09nZ2d7e3uHh4ebm5ujo6Ozs7PLy8vT09Pr6+v///wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAa2QIBwSCwaj8hkkVHJODEThdJoWbWurdPmUZgKCRss
dgWSOBgLhlq9QAyEh45YzGK16njWSoMQJjx3eXV3V4OEIRBCAwgLCwqNjY8Kko6TCwldFhgYF52e
n6CemxYpdnOnqHcpJqapri0rJiIqr68rIh8pta4pHxwou6koHBgmwagmGBUlx6clFBIkzXMkEhAj
02IjEA3Y2VciDQkh31chCQYf5S0fBgIRGE7y8/TzGBECXvr7SUEAOw==
"
image create photo imgToolJoinTrim
imgToolJoinTrim put "
R0lGODlhGAAYAPUAAAAAAAICAgUFBScnJykpKS4uLjAwMDQ0NDs7O0BAQEZGRllZWWBgYGdnZ29v
b3JycnV1dYODg4aGho2NjZCQkJaWlpqampycnKCgoKenp6ioqNHR0dbW1tjY2ODg4Obm5uvr6+/v
7/Ly8vT09Pr6+v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAaVQIBwSCwWBcakEpBgIJZJgwEgMGQ6mCeUCJkQCBVQ
idPYEi0fy0RUEmkU5mGlRCK1L4e4vMQnUQp6e3wlFoCBAHODHxOGegsXFZEWEI2HlpeYmUkEDhgW
kRcLhwMRHYMlFZYDFHZ8qYcFE6evegcXI3SugQgaIW0TEx4WegIMGyUhFwUDEg+BthwZBkgElWYH
DAma20EAOw==
"
image create photo imgViewToggleColors
imgViewToggleColors put "
R0lGODlhGAAYAPUAAAAAAAICAgYGBg0NDQ4ODhERERQUFBsbGx0dHSEhISUlJSsrKy4uLjMzMzU1
NT09PUFBQUVFRUtLS09PT1JSUmNjY21tbXFxcX19fYuLi42NjZCQkJWVlZiYmJ2dnaSkpKenp6io
qK2trbGxsbu7u7y8vMHBwdXV1dnZ2eTk5Obm5urq6uzs7PDw8P7+/gAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAb/QIBwSFRwNgmicqlklEgMpjIBcSgXo9FC6YAkh5BO
pyEYGigUw1DgEEOIDc8JQxAKCgZDoQwgYE4eDVwYFnUFDhUYGBUNBX0WGIJKAgR1CxooKywtLCga
W5V8SwILIComFhUsLi4sIFtSQgUaKiERBQcqrC4rGY5SbCgmEUK5uy4okkMKDAwFBBUrF2oAxrsr
FQUFCwwJHCUjaRgsEkPWrL1nIiRH4OLk5rq7LRgGEyElHAkMC9rRF7/Otcq2rRuXEyTeVJPHKpmo
JbNUgLh1rledWABKnboQDR0IBQ+JULKUIdMKTp4WjAwJwAGhOgQaJFrUACYkZULizLl4J88eLSF+
TowhAoFDIFFnJvwCICAOhwdEqODMOEIErCENHiDAKMRJiShcpRjhoABjEAA7
"
image create photo imgEditDuplicate
imgEditDuplicate put "
R0lGODlhGAAYAPUAAAAAAAEBAQQEBAkJCQ0NDRERERQUFBsbGx8fHyAgICUlJSoqKi8vLzIyMjU1
NTk5OT8/P0FBQUdHR0lJSVFRUVZWVl1dXWJiYmVlZWtra25ubnJycnd3d319fYCAgISEhIuLi42N
jZKSkpaWlpubm5+fn6KioqWlpaioqK2trbS0tLi4uL+/v8LCwsTExMvLy9HR0dfX19vb293d3eLi
4ubm5u3t7fPz8/T09Pn5+f///wAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAb/QIBwSBwSIqDXa1FsEgeMDOpFu9UuBSeR0MCIVDKc
boxLKbQEBoVziuXGuZhsTIsUCYnHpSR7j3U2LRocMTo5GgZDCBQjMH5/OTUmDgAGGTY5KZRCLjQ4
b6A5OTAYBwJCCR82NBVDMDc6NCQaGBgZFhCJQwIJFhdMQiI1NSALBALIWkLJQhIwKg8FFbW2thnX
1rXXFxUFKiEHDjR/5OXkOTQCHhkGEGLm5p9/ABITBg+P8Do4NlTzBQoKQPBDg4WLRzZYdJjQ4MQ8
AAMA4BuTggIGGm9qkICAQEiGGWOIDNRxY8OAA6psiGhA5AGKkEPc6VgBAZWJlXc6wBQy8FAWQlQE
nGTYCWCknV1aMBDtWVPZkKE6RL5JIWKE1atYR4hoQfSBDX1gbxBRUGJFi7NnWbBIq3ZtCxUkiiCb
S5fugLpBAAA7
"
image create photo imgToolBreak
imgToolBreak put "
R0lGODlhGAAYAPQAAAAAAAMDAwQEBDMzMzQ0NDo6Oj8/P0BAQEVFRUhISEtLS1lZWWVlZYaGhomJ
iYuLi5aWlpmZmZ6enqOjo6enp6ioqKysrM7OztPT09jY2Onp6erq6u/v7/T09Pz8/P///yH5BAAA
AAAAIf8LSW1hZ2VNYWdpY2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAWGICCOZGmeaKqaAtJA
MBQta4lM26d/UF0SlB3PRxpEhD0igCDpIJWHCufToVQ2EeXiQqUUgA+lMWMxCAAKhXLJQIwE53V8
LZ8jGIR1GiAoWDISBUoPFV8TUxgMShEcFRNOjQdKEEIdE4KTQhEEcz6UOxV5a586GxQInSsLEjER
DwqpdLKzIiEAOw==
"
image create photo imgNetlist
imgNetlist put "
R0lGODlhGAAYAPUAAAAAAAYGBgkJCRAQEBYWFhoaGiIiIiYmJisrKzQ0NDo6Oj4+PkVFRU5OTlFR
UVdXV1xcXGFhYWZmZmlpaW5ubnFxcXd3d3l5eX19fYODg4iIiIyMjJ+fn6Ghoa2trbS0tMDAwMXF
xczMzNTU1Nra2t3d3e3t7fj4+Pr6+v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAa6QIBwSCwaj8ikcsk0ChyPRyMKiT4cTEfKxO12U8wH
GIkiBjyKojhZHhJSqAdRS/GaPsK28J1KXYZiBxKDgwx5DVAPEX19HAEAWmyMk30oIANiCBabnAsA
KJSUKCQQKRMlqKkbn6GTKCYTY0egKLW1jKMGa2QVnBmTl5B+lCF5RHwpHY8AYgVXVgnGbn1/gLJG
egACI3JzKQoa4eINn2EpECLp6hjlS5FkWVt2X0wCEROE+IQRTf3+RkEAADs=
"
image create photo imgFileReload
imgFileReload put "
R0lGODlhGAAYAPUAAAAAAAICAgYGBggICA0NDRISEhQUFBsbGyEhISQkJCoqKiwsLDExMTMzMzg4
OD4+PkFBQUdHR0lJSUxMTFJSUlVVVVpaWltbW2VlZWlpaXNzc4yMjJOTk5SUlJ6enqqqqrCwsLm5
ub6+vsDAwMfHx9PT09TU1NjY2N/f3+Pj4+Xl5evr6+zs7PHx8ff39/r6+v///wAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAavQIBwSCwaj8ikcskkEhiCJnLhcQyUA8Nhyz0YKK0Q
5CroegWSD0qVYqvYK5iLVAE42m3UJzJiwf6AgTAvIxMOL4EsIi6CjTAtHQoOjYx/Jh2YmBwgLyod
DAAJHJgmjR1GDicbCEYdpkYIGgVHroKnRQIESLWBt1K8gL5NwH8jGBnIycrKGCOAiI7RjS8mLdLX
jyUXiy/d3t/g3i4iFwULDg/p6uvs6wu6UvHy8/TxQQA7
"
image create photo imgEditRedo
imgEditRedo put "
R0lGODlhGAAYAPUAAAAAAAEBAQUFBQoKChISEhoaGh8fHyIiIiQkJCkpKSwsLDQ0NDk5OT4+PkJC
QkpKSlNTU1paWmFhYWVlZWtra25ubnV1dXh4eH19fYCAgIeHh4uLi42NjZOTk5eXl5iYmKKioqmp
qbS0tLu7u7y8vNXV1dzc3OHh4eXl5ejo6O/v7/Hx8fj4+P///wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAaqQIBwSCwaj8ikcslEIhDNZCVjiB4/KQ3BWvS0Tp0C
d+j9eg7NwqOy6ZRacFRHoTxANqQTC85vqTwLRwIJGG99hy0rIHREAgohKoiSJhgCRAmQkogrH2hD
CBsriCwre3CkHAlEAxN6JiIdFxQTEhEjfFmqRA0hJyAVDgYDRGUoG55DAhgkF2JXLSYcW0UKFxJK
Hikb00UPDMNJFhncRQfkRwZVSJZj7e7v7kEAOw==
"
image create photo imgToolInsertText
imgToolInsertText put "
R0lGODlhGAAYAPQAAAAAAAEBAQoKCg0NDRERER0dHSIiIi0tLTIyMkJCQkRERFVVVV9fX2tra3Jy
coKCgoeHh4iIiJmZmaenp6qqqru7u8vLy93d3eDg4Orq6u7u7vv7+////wAAAAAAAAAAACH5BAAA
AAAAIf8LSW1hZ2VNYWdpY2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAVrICCOREkMwqiuKnFx
cNywtHjE+FTXTOT7j8JuSCwad4eFcslcCmmGDW6Ky9QKUioVsysovuBwYkw4ms9Fh2TNXkMGRYRW
VhxYNPg8/nJA+/+AQwIVeoV6GRA0cnNUGjUPFJGSk5MLgZeYOyEAOw==
"
image create photo imgEditCut
imgEditCut put "
R0lGODlhGAAYAPUAAAAAAAEBAQQEBAsLCw8PDxAQEBUVFRkZGR8fHyIiIiUlJSoqKi4uLjMzMzU1
NTo6Ojw8PERERElJSUxMTFRUVFVVVVpaWl1dXWJiYmRkZGpqamxsbHJycnV1dXp6en5+foeHh4uL
i46OjpKSkpaWlpubm56enqKioqampqioqK2trbGxsbe3t7q6ury8vMHBwcTExMnJyc7OztPT09TU
1Nra2t3d3eHh4eTk5Orq6u7u7vPz8/f39/r6+v///wAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAb/QIBwSCwaj8hk0TABlUQYhNJYwMB4Ph/No5gSJdcY
yqW7cQRegIC0az0Eh1RPlTAKCo3GYaBe+UZCAhw3LhBFAw0nNTkqEmooPicGaiI6MhRECBswOlkw
jgIbNTcjGR80PjorFwQADSE1WTooFFIACiI4PTY7ZTo9MR0LECQ5PTIhDkUNIDEzMSUeJ507JBER
IiwZk0YDCRAKfA5yWTEaCAhoRwIID+EAD+Q+PTgnDerLITDP0Sc5Pjtw7EjlYluRBSJy8OBVxpiM
DhZK3Jg3Ixk+UTZGYPgwI9WqAgAYfJAhi9aBRz0kUbKEaYiBCy86+XgxoY8PEoEGvXhQRECiNBo4
VoBi08LBgDhz6vQ0wIABAj4AwPAQ02KHmTRCqsDI4mMGF6xCmIQwodEW2CH4zqo1EgQAOw==
"
image create photo imgEditMove
imgEditMove put "
R0lGODlhGAAYAPUAAAAAAAICAgYGBgoKCgwMDBERERcXFxsbGxwcHCkpKTw8PEdHR0tLS1VVVVlZ
WV5eXmNjY2ZmZmdnZ29vb3JycnV1dYKCgoeHh4yMjJWVlZubm62trbGxsbS0tLi4uMHBwcTExMjI
yNra2tzc3OTk5Ovr6/b29vn5+f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAaRQIBwSCwaj8ikcpk0JJjJAsQCPRYmIlDiwO16DUfD
ZYQykc7odGlzzJBR8Lg8/hEYHx/TfA+vGwUNHWYaGYWGhhoUSQsdHHZVRgoRVQSPRAIEVREKkH8c
HgxJFISHhxokJh4OA38ffHsnHxCtr3sjGUcbJWm8JCcoIxgIYV7FBwghIxVgnUMXEQXNRFvS1dbS
QQA7
"
image create photo imgViewZoomBox
imgViewZoomBox put "
R0lGODlhGAAYAPUAAAAAAAEBAQYGBgsLCwwMDBISEhUVFRsbGx0dHSMjIyoqKjExMTc3Nzg4OEFB
QUVFRUdHR1FRUVRUVFlZWWRkZGlpaXBwcHl5eYSEhJaWlpubm5ycnKGhoaSkpKmpqa6urrKysra2
try8vL+/v8nJycvLy9TU1Nzc3OLi4uTk5Onp6fPz8/X19fv7+/7+/gAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAbcQIBwSCwKBUiBcWk8VDgfTINJRVRMLZdqMwUUHJSK
eDx+FB4kl9qVwigjo+x67gItJiv6ByDwtFgpgYKBKBoKESpzLB1IIy4cBgeSCJKSBQANH3IuJhSN
LhlUQgMPHyosJBYHQo6hogAEDBITDwhHaa6vAgoLl0etr0IFGyEPQwLAwQcoLhXHya8HKS4Uz6DB
ANLNRNCi2s6318EI0+B83VTf1rne5evY6r/i0e5HIZwZ+fr7+hx51UcunKBDcE6LEQ6IJLgQYsQI
Eg4jQow4okMEX0SSKNG4UWORIAA7
"
image create photo imgToolInsertSymbol
imgToolInsertSymbol put "
R0lGODlhGAAYAPUAAAAAAAgICAwMDBYWFiIiIiUlJTIyMjQ0NEBAQERERFNTU1VVVVhYWFxcXGFh
YWZmZm5ubnd3d3p6en19fYaGhoiIiJOTk5SUlK6urre3t7i4uMfHx8zMzNPT09nZ2d/f3+Li4uXl
5ejo6Pb29vn5+f///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAaTQIBwSCwaj8ikcslsJgUHgnQqNQyWAlJpy+2WNAdj
wGBgeM/cSXHj9VTe8Eqmw40QQ15NUjEqjQpDBRERFVsVSg5bF0YEWxRLHyUiCwsKQ40lj0ocXpeO
S3RdBA8PEp9KkZOVIHmIWxZDnF0Ye31/QwEICQ1bG3Fwc1wQRwZoZyRqR1nGXGBKUFRUVk7U1dbX
2EVBADs=
"
image create photo imgToolInsertWire
imgToolInsertWire put "
R0lGODlhGAAYAPQAAAAAAAEBAQ4ODhERERcXFyUlJSoqKi8vLzAwMDY2Nj4+PllZWWRkZGtra2xs
bHh4eIODg4eHh5aWlpubm52dna+vr7Gxsbu7u8PDw8TExPDw8Pv7+wAAAAAAAAAAAAAAACH5BAAA
AAAAIf8LSW1hZ2VNYWdpY2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAV0ICCOZGmeppAkAuqK
CDRN0PGegnM9z9W0N5IhMhFJIoYgqSAjEGgFJWmBsVgwCylpwNBoGECtSLHZKMQkshk9Up/ZADc8
Xn6z5XD8vQ7nesFsCxkVFVhoBREUTlBiQxIiE0hiAg07PT9oBzI0NmwqCGFzNyEAOw==
"
image create photo imgEditPushSch
imgEditPushSch put "
R0lGODlhGAAYAPQAAAAAAAICAgUFBQkJCQwMDBMTExYWFhgYGB0dHSEhIU9PT19fX2NjY2lpaWxs
bHd3d3h4eHx8fIODg4eHh4uLi8HBwcjIyM7OztHR0d/f3+Pj4+Xl5enp6ezs7Pn5+f///yH5BAAA
AAAAIf8LSW1hZ2VNYWdpY2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAWLICCOZGmeaKquLKA4
TSw7SitUX67nlcDeu13vhwvyfCug8TNMFo1NlRKKlD6DURPhcEBYlh9LgksoDRYXzcYD9mw0GMag
lHh0wLtOJHFCPDR4HxsQfCgHEhlgGhMIKwUTiUEaFAYtBRIbOxuULSIGEBw5HBEHnSN+GxwPhaYi
CQ4OrK0iBGWzt7gkIQA7
"
image create photo imgToolInsertRect
imgToolInsertRect put "
R0lGODlhGAAYAPMAAAAAAAICAgUFBQYGBhsbGzs7O2FhYWlpaZWVlZ6enqGhob+/v+Tk5PT09P//
/wAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAASAEEgg
qr1YzF3U+mAYKsUmGY2jrizbGCZwOI2C3HiupEc8M4TYhsBw9Ey/oFBCNPocwCWzeNwkpYBmdXKV
ap9RLxWsXH6R0LLwbE1j2Vy32IkOm8d1dQwu6d7pbXZreIF6Jnwycn9bfTQ2OZA7gBMoLZYrLzEd
IpwgCSUxGaIWGxEAOw==
"
image create photo imgEditPaste
imgEditPaste put "
R0lGODlhGAAYAPUAAAAAAAICAgoKCg8PDxERERQUFB8fHyIiIiQkJCwsLDExMTQ0NEREREpKSlNT
U1VVVVxcXF9fX2FhYXJycnd3d3x8fIGBgYeHh4uLi5WVlaKioqWlpaioqK+vr7Kysru7u729vcbG
xsrKys/Pz9HR0dnZ2d/f3+Li4uTk5O/v7/Hx8fT09Pr6+v///wAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAbEQICmhQIAEK2WxDg8GZ9QQKelMiqSE+O0GoUqLo7n
xFKwgrtoKOECebjfb4hFYExQGtBScs/nh7RUUCd9hEkkRhtEUCAtIwyPkJAmLRxGBAwHiy0gaQAk
lJ2MnGmflQAOHxaao2ilRh6BT6KdrgAYjau0oEYDUbOku2i/rbsVKR9GBSYsm7qmsCtGC3usXbUS
IxlGAh8qzcCmwt/E4V0fLSEH6uvreuVRk4V9Ip3x8nuHaQkdFhT+//8ucDDQqaDBg2iCAAA7
"
image create photo imgToolInsertLine
imgToolInsertLine put "
R0lGODlhGAAYAPIAAAAAAA0NDTc3Nz09PT4+Pt7e3vj4+Pv7+yH5BAAAAAAAIf8LSW1hZ2VNYWdp
Y2sOZ2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAMtCLrc/jDKSau9OOvNew0CIY6kKASQUBxs67KF
kK5vHUNgqROn5//AoHBILEoSADs=
"
image create photo imgToolInsertCircle
imgToolInsertCircle put "
R0lGODlhGAAYAPUAAAAAAAEBAQUFBQkJCQ4ODhISEiEhISYmJi8vLz4+PkBAQEdHR0tLS0xMTFJS
UlZWVlhYWGtra2xsbHx8fH5+foKCgo+Pj5KSkpWVlZiYmJycnKysrLOzs7S0tMPDw8jIyNXV1dbW
1uLi4uTk5Ovr6+zs7PPz8/b29vj4+P7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAb/QIBwCBAcIJSLhfI4CIjQ4aCR8YREo5Eo5MEwnlHh
oeI5pUYeDsczSp08lUMYcSmdPphII5FoRDAfJyQXCFAHFyclGw0FUQUOGyQnF3JCAxUlJBoGYUMG
GpkUA0INHigbBmCdAgYbbwxFGXcNqp1FDmUYAAceKRgEtlAEGCkeBw9XEcFREiMhDxQiHrDLRKUi
SSMcCdVECh0jFhba3N1CCR0iS9IN5qQe2BBXEu4Azc+8vsDdBRnFTrI+tOvmIBCGJwzKbHASjBUH
FB4WWKpAosSmYJ9CqTpgAYUiB42gPOJgx0KlIXRIoMAjoYECBQ0kABJEKMwYDybOeOjQgY0bGQ8U
OHUasACDFSxauGBYUGvVsSRLmjQVEgQAOw==
"
image create photo imgEditPushSym
imgEditPushSym put "
R0lGODlhGAAYAPUAAAAAAAQEBAgICA0NDRERERcXFx0dHSIiIicnJywsLDAwMDU1NT09PUNDQ0dH
R0hISFBQUFVVVWJiYmZmZnBwcHl5eY2NjZKSkpWVlZqamqGhoaSkpKqqqq2trbKysry8vMLCwsfH
x8vLy83NzdPT09fX19jY2N/f3+Dg4OTk5Ojo6O3t7fPz8/X19fr6+v///wAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAbGQIBwKOyYSshTg8hsCj+vaBTirD6lU2sViqVqhRdS
KHTCvsQh08Iq6LDM2NPkC6io4OcEXegwYV0fBHtDBiJRKxmDTAIeKBKKCAeSkwsHCAV0HnhYKhgH
ViObZi1eQxITE4Yak6wIChJ+LktDZiFaAyFnAUMmJyZvHF8HLi8OTRsvFnS5IhkZGEPIF3QlZtEv
01+GzRkXvidvHV8IxLMAZiBaBKEkRBARECAvq6ySCQwUKS8ua00kolhWPKjCAeCLExYwMQkCADs=
"
image create photo imgViewZoomOut
imgViewZoomOut put "
R0lGODlhGAAYAPUAAAAAAAICAgQEBAoKChAQEB8fHyIiIiUlJSgoKC8vLz4+PkNDQ0RERGtra25u
bnt7e3x8fIODg4WFhYiIiJ+fn6CgoLOzs7a2tr29vcHBwcjIyOXl5evr6+7u7vf39/n5+f///wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAAIf8LSW1hZ2VNYWdpY2sO
Z2FtbWE9MC40NTQ1NDUALAAAAAAYABgAAAbXQIBwSCwaj0VCQqFIEJDHwQJSuWAwl8pjMYAKDY5L
B0Qudy6Og+AoQEQ45bhZgjgeJh65HuSRHIoDDmN7eh0Oa0MMF4SEFwxED3CMhQ9DBBSThBVPAAmL
IB8aGaOkpBgaH2QWCUIKGGQbBUICtLVrBRtkGAqtryCxALa2ALi6vJ2foaXLGahkF6wAAxWZexRd
Qg+D1WQclUMLn9wgFgtEgZLVHQ3YQwcSeZl9BkZtEul7HRF/bAcOFtvKcLDQwAAiJFIeVLBw5QKF
Le28CBmwpElEiRiNBAEAOw==
"










}



## Context menu

image create photo CtxmenuBlank
CtxmenuBlank put "
R0lGODlhEAAQAPAAAAAAAAAAACH5BAEAAAAALAAAAAAQABAAAAIOhI+py+0Po5y02ouzPgUAOw==
"

image create photo CtxmenuRotate
CtxmenuRotate put "
R0lGODlhEAAQAPQAAAAAACoqKisrKzo6Oj8/P15eXmBgYHZ2doKCgq+vr9fX19jY2OLi4uTk5Ofn
5+/v7/7+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABIALAAAAAAQABAAAAVCoCSOZGmeqBg5ixOlUgLMc4Iec2AE83ESAMVIUYMNZy+jhOdQSgyAhZMJ
eziIgKTpgaABbKeu14fyfmGMAs2ZHpRCADs=
"

image create photo CtxmenuSave
CtxmenuSave put "
R0lGODlhEAAQAPEAAAAAAI2Njejo6AAAACH5BAEAAAMALAAAAAAQABAAAAImhI8nM+naDJv0RECv
tlVaPn2eRAXm9jxXiqzs+IoxPLuvzeLpUAAAOw==
"

image create photo CtxmenuTerm
CtxmenuTerm put "
R0lGODlhEAAQAPMAAAAAACIiIjAwMHR0dHh4eHx8fOXl5ejo6O/v7/f39wAAAAAAAAAAAAAAAAAA
AAAAACH5BAEAAAoALAAAAAAQABAAAAQ+UMlJq731mM07PwcgjmRpAEWqriqgoNhUAOcwItd8EkIg
JDkaLKbQDWPGArEoVBKTrOgsVKqOFBqP1nBYViIAOw==
"

image create photo CtxmenuSymbol
CtxmenuSymbol put "
R0lGODlhEAAQAPUAAAAAACgoKCkpKTQ0NDc3N1FRUVxcXGZmZnR0dHp6eouLi4yMjJSUlJubm6Ki
oqioqKqqqrW1tba2tre3t7+/v8DAwMbGxsfHx8jIyMnJycrKyszMzM3Nzc/Pz9DQ0NHR0dPT09TU
1NXV1dbW1tfX19jY2OXl5fPz8/r6+v39/f7+/gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACsALAAAAAAQABAAAAaDQIhw
SCwKJZhQEsPBMJehCYSzqlqvVgwEs0o1LuCK43T1bFcNgHoNUKSq2sRAAFiEGQMAolqCFNYQVykG
ACUrWiGHABdYJgAHGBVnF4tYKWsCEImUjFeOkBJ+gIKEhnFzdXcEenBnaWxqC28rZlxeGGFjV1pU
WL60EBJKThgexcdOEkEAOw==
"

image create photo CtxmenuSchematic
CtxmenuSchematic put "
R0lGODlhEAAQAPQAAAAAAAQEBBwcHB4eHkJCQkxMTGpqanNzc319fZGRkaioqKqqqq+vr7m5ucLC
wsrKytjY2Nra2t/f3+Li4ubm5u7u7vDw8PPz8/n5+fz8/P///wAAAAAAAAAAAAAAAAAAACH5BAEA
ABsALAAAAAAQABAAAAVO4CaOZGmKDqACyTkuK2C4Y6VK2tkU16apFRcB8IgIVBMh4KAKMEyOROKo
QmBOMdWCFp2urLTNkAlw0oZFalLH8wHDo1ulF85GwlQVZRMCADs=
"
image create photo CtxmenuOpendir
CtxmenuOpendir put "
R0lGODlhEAAQAPMAAAAAAAICAg0NDTMzMzc3N0dHR3R0dHp6eoGBgY6Ojrm5ucjIyObm5vDw8Pr6
+gAAACH5BAEAAA8ALAAAAAAQABAAAARB8MlJ6zQgi2Zv/sIijuLznej3DGzrvg8iz3Rtpjhw5+hD
8CfC4wD8HB6KYkbxYCgBjIfj6ZAIioJJoViYJIqJRwQAOw==
"

image create photo CtxmenuFlip
CtxmenuFlip put "
R0lGODlhEAAQAPMAAAAAAAQEBDc3N42NjaamptDQ0NHR0eTk5AAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAACH5BAEAAAgALAAAAAAQABAAAAQvEMlJq7046807NgJwTAcgGBMIrAPhDquJBnFtAwGisi4B
r6dUaCQpBT3IpHKJiAAAOw==
"

image create photo CtxmenuAbort
CtxmenuAbort put "
R0lGODlhEAAQAPUAAAAAAAQEBAkJCQ0NDRISEhcXFx4eHicnJygoKC4uLjIyMjg4ODw8PE5OTlFR
UVdXV1paWl1dXWZmZnBwcHt7e35+foKCgoODg4iIiI2NjZeXl56enqKioqioqLW1tcPDw8XFxcfH
x9DQ0Onp6e3t7fDw8PX19fj4+AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACgALAAAAAAQABAAAAaNQJQQ
BVoICIRBwjNsSgaAqHTgODUfAgCh4HAUoAKGFbWBDjpNDgEgmAgNgAGoKRStCSTQ2kEfVgQCGxRx
EhiGh4YUUBENUQGPkJFRCxCOkZdRChkBAhGIiBNQDSFrC31ClQEaKAVaaHQfdyMoGmYTJUInFmAW
QxBZA0oIAmAJY0JPUlMMJn1FR0kHr0JBADs=
"

image create photo CtxmenuRecent
CtxmenuRecent put "
R0lGODlhEAAQAPUAAAAAAA4ODikpKS8vLzg4OENDQ0dHR0xMTFZWVm9vb3Z2dnp6enx8fIKCgoeH
h4mJiYyMjJmZmaGhoaampqmpqbCwsLe3t7q6ur+/v8XFxcjIyM7OztHR0dXV1dvb2+Dg4OXl5efn
5+3t7fPz8/T09Pr6+gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACYALAAAAAAQABAAAAZtQJNw
aNJQiMTShDhZmEgl0wU0LDyGoI6poKgIRMORA3kBZCIfpJpwULsrgI1bPUCoR5QMsQF4cKIdFCAg
ChJECQEAAAEgFgoccyYiGBNRkZeYbhdzGCRECnZCJGBCEAaWJAmWJhQMex5zFxBuQQA7
"

image create photo CtxmenuSymbol
CtxmenuSymbol put "
R0lGODlhEAAQAPUAAAAAAAYGBgkJCRsbGxwcHCQkJCsrKy0tLTAwMDY2Nj09PUREREtLS1BQUFhY
WGhoaG1tbXFxcXp6en5+foKCgoeHh4qKio+Pj5mZmaGhoaysrLW1tbq6ur29vcPDw9PT09nZ2d3d
3eLi4uTk5O7u7vPz8/n5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACcALAAAAAAQABAAAAZmwJNw
SCwaj8fRILFYIAiRUFEkaQCuWICAQ6xgFaHw5xIomIYlDQUgKUoAGRLRA5gUNVjGkG4n4gkIdiAP
DAAQRVYdQxZYBhgYFxGFCkQmHW9ZVwciRiYOEhUVEQ4bZ0inqKmqq0RBADs=
"

image create photo CtxmenuUp
CtxmenuUp put "
R0lGODlhEAAQAPQAAAAAAAUFBQoKCgwMDBMTExYWFhsbGyAgICcnJy4uLjAwMDw8PE9PT1JSUm9v
b4WFhZKSkpOTk7y8vMLCwsPDw83NzdXV1eHh4evr6/Pz8/j4+AAAAAAAAAAAAAAAAAAAACH5BAEA
ABsALAAAAAAQABAAAAVI4CaOG0WepzMsF0pqTAAAR+Ru2DLvQ5OdFsVuCEhIRpWCwSAgLgm2E4Jo
uk2HVdd1l0VtZ10p9bb5AsIkM3oUebjdGLJ8jgoBADs=
"

image create photo CtxmenuDown
CtxmenuDown put "
R0lGODlhEAAQAPQAAAAAAAsLCxISEhYWFiAgICcnJygoKC0tLTc3Nz8/P0dHR1NTU1paWnFxcXZ2
dpCQkJeXl7u7u8LCwtHR0d3d3eLi4vHx8fr6+gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABgALAAAAAAQABAAAAVOICaOZGlWVJpe5kgEMCy1YgHc90zbOKC3PNzPFMzRMEXfMTnETBAKxaAH
SCgSj1HkQMUFGKyRZRGgCho0CAFHgBwxlATA0GxdHJW3HhMCADs=
"

image create photo CtxmenuDownSym
CtxmenuDownSym put "
R0lGODlhEAAQAPUAAAAAAAcHBwoKCg0NDRAQEBQUFBoaGiMjIyYmJi4uLjQ0NDs7Oz4+PkREREtL
S1NTU1ZWVlpaWmJiYmZmZmtra3p6en5+foGBgYmJiZGRkZiYmJ2dnaampqmpqa2trbm5uby8vMHB
wcTExMnJydPT093d3eHh4erq6u7u7vPz8/n5+QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACsALAAAAAAQABAAAAZywJVw
SCwaKYqkQmMkQgBQgKW5ylQUUQCj4jFiCFmoAdS8DLKGDnVFCUALzPVKEiBg5MPHBa86MBoJDB9N
JxgWWhALBwBqRSIFYI1zCB8hRigAlkIVUSNDIFEceQolJkQpGxgACAoGBAJkVAsSEw4RJEVBADs=
"

image create photo CtxmenuPaste
CtxmenuPaste put "
R0lGODlhEAAQAPUAAAAAAAEBAQUFBQkJCQ0NDScnJy0tLTQ0NEBAQEZGRk1NTU9PT1BQUFNTU1lZ
WWBgYGFhYWNjY2VlZWlpaWxsbG5ubnNzc3R0dHZ2dnd3d3h4eICAgIGBgYmJiYqKio6OjpCQkJGR
kZmZmaKioqenp6qqqq6urrm5ubq6usHBwcXFxcnJydXV1dvb293d3d7e3uDg4OPj4+Tk5Onp6erq
6u3t7e/v7/Dw8PX19fb29vf39/39/QAAAAAAAAAAAAAAACH5BAEAADwALAAAAAAQABAAAAaAQFkg
wgMFTrwDgcds4hwknqrx4nUqzWw2dcB4vxLFjjawMBuCgHqtbtkKHebm+KrXJYGYds7SWvI3ByBy
AX1ZGHk0Alg8fH55e4WPMTgRJjwrBpKHeTFDPB9qhk2Ieiw2PDgTAS2TWhoBGiKzswmQWQpsulVZ
Nh0lwMEjI1rFxUEAOw==
"

image create photo CtxmenuDelete
CtxmenuDelete put "
R0lGODlhEAAQAPUAAAAAAAMDAwgICA0NDRYWFh8fHyEhISkpKS8vLzMzMzU1NT8/P0BAQEVFRUxM
TGlpaXp6eoaGhomJiZCQkJSUlJeXl5ycnK2tra6urrGxsbW1tbu7u729vc3NzdfX19vb2+Pj4+Xl
5evr6+7u7vHx8fb29vv7+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACcALAAAAAAQABAAAAZxwJNw
SCwOTSbjyVQiggiFT1GUGHSGGgCgABqSElrKkaE9iE6lRXlEJCm0CJFDyzWKDlpCXqoMGbQAVkpD
D4ANg0ITgFoPgxaAEQNaEEYZgBYnHAJaEkQegBNDF4AbQxyTRCajAJhDFRdKGRJJR7SIJ0EAOw==
"

image create photo CtxmenuDuplicate
CtxmenuDuplicate put "
R0lGODlhEAAQAPQAAAAAAAcHBwgICA8PDxAQEBUVFSsrKzMzMzU1NT4+PlRUVFdXV2JiYn9/f4iI
iJqamqGhoaampqqqqq2trba2tsPDw8TExO7u7vb29gAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABkALAAAAAAQABAAAAVTYJZhk2SekiWuWQS88CuwIjRceA7NNERklIaj0VAAHA+WL2OMvQ7KX9OJ
iDKdr+pqOY1pa1Is4Jvhisk7B+LMqhQIAjbtiiWvGIa83pCY+/+ALCEAOw==
"

image create photo CtxmenuCut
CtxmenuCut put "
R0lGODlhEAAQAPUAAAEBAQUFBQkJCQwMDBAQEB4eHiIiIiYmJicnJzc3Nzw8PEJCQkVFRUtLS0xM
TFZWVllZWV1dXWNjY2lpaXFxcX5+foSEhImJiZGRkZWVlZqamp2dnaGhoaampqmpqa6urrKysri4
uL29vcHBwcbGxsrKys/Pz9HR0dbW1tnZ2d/f3+Li4ufn5+jo6O3t7fPz8/b29vn5+QAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAADIALAAAAAAQABAAAAaLQJns
0niEhMik8AFoAjbK5KgJSQAIsagrdAEsZK8A4JSMYQiADODwIjVVSNChKVAJAAMnxYVqOB8rMhx3
TgBiTQkkSSUTFSl+ThNKHoSHh15kMit3hAASLCUKThEtGgAGW02BQh0FTQMWAAwyMWImSTAWeSJN
Egt4MFEsHzIOhRlRZRYKDcTJz9AyQQA7
"

image create photo CtxmenuMove
CtxmenuMove put "
R0lGODlhEAAQAPUAAAMDAwQEBAkJCQ4ODhISEhsbGx0dHSMjIyUlJSgoKC8vLzMzMzk5OUZGRkxM
TFBQUGdnZ29vb3BwcHl5eX9/f5GRkZOTk5WVlZiYmJ+fn6SkpLCwsLy8vMHBwcXFxdHR0dXV1djY
2Ovr6+/v7/Ly8vT09Pz8/AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACcALAAAAAAQABAAAAZmwJNw
SCwaj8iOUWncJIyNSTGEWBgdBM2QtAAMDIXQCWEgAAwfoQPABgRA4zZAMaLIAQI44v4QKeR5cW0F
HCceBW2BB4kWQxgDCBYXJScZFgwAEEUST0UODSZFJhFGEyNIqKmqqydBADs=
"

image create photo CtxmenuCopy
CtxmenuCopy put "
R0lGODlhEAAQAPUAAAAAAAICAgUFBQoKCgwMDBERERMTExcXFxkZGRoaGiIiIiQkJCkpKS4uLjAw
MDMzMzk5OTw8PEpKSlxcXGZmZnV1dXh4eHx8fIWFhYaGhoqKio2NjY6Ojo+Pj52dnaCgoKGhoaOj
o6urq6ysrLOzs7e3t7m5uby8vL29vcHBwcfHx8nJycrKys7OztHR0dPT09fX19ra2t/f3+Dg4OHh
4ePj4+3t7fPz8/X19fb29vn5+fr6+gAAAAAAAAAAAAAAACH5BAEAADwALAAAAAAQABAAAAaGwAxg
SCSmeEgkByChOJ0QwDHJ8wBMVN5ylbViqR2AghcTaKrX7DLCoyk86G8yrOqmwYB6zRGKZ+lkABl+
eHVUXn95PDYTJzwXAAQGk5MDACQ8LQAWPCUGDQ8ODqEMCDRILjdZPC4cOTwjIzw5HC6rFQBcCAg8
KwAVqzIgOzwnjjsgp6vLSUEAOw==
"

image create photo CtxmenuEdit
CtxmenuEdit put "
R0lGODlhEAAQAPQAAAAAACMjIzMzMzQ0NEREREVFRUtLS1VVVVlZWWRkZGpqamxsbHNzc4iIiIyM
jJaWlpiYmJ+fn6Ghoampqbm5ub+/v9XV1d3d3eDg4Ojo6O/v7/j4+AAAAAAAAAAAAAAAACH5BAEA
ABwALAAAAAAQABAAAAVqIMdtEWSeZpSJ4gS8cMywnAQcTa4zwELbD12DwrH0fgCIQ1cpHlm2CE1k
9EEBjoBWi6giJVOnVQRUKBKLjRgJmbgn1CcZIMFc7heN9+oYCAZ+CXtzDXh4FHI1MYuJGAYFBAQF
k5RNYZc0IQA7
"

image create photo CtxmenuWire
CtxmenuWire put "
R0lGODlhEAAQAPQAAAAAACAgICUlJTMzMzk5OUBAQEZGRlVVVVpaWmZmZnh4eIiIiI2NjZubm6Cg
oLu7u729vdXV1djY2PPz8/b29gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABUALAAAAAAQABAAAAU3YCWOZGmeaKqurBgtCzOdDQwhQK48fO/kAMEBSCzmAsNcIcFsJgEBx2BA
kJgohqmixe16v+BRCAA7
"

image create photo CtxmenuLine
CtxmenuLine put "
R0lGODlhEAAQAPQAAAICAgcHBwsLCw8PD1RUVGFhYZmZmZ2dnaCgoKSkpKqqqq6urrKysra2trq6
ur29vcLCwsXFxczMzNra2vb29gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABUALAAAAAAQABAAAAVBYCWO5OhMZSoaAKGWBzBI74gAAlSLCq7vC9xjV1kEAsNd48ggOpjOAKC5
cwgACiJkAEgQI1fvjsJFEEUF8XktCgEAOw==
"

image create photo CtxmenuBox
CtxmenuBox put "
R0lGODlhEAAQAPQAAAAAAA0NDRERERcXF0ZGRklJSWZmZmtra3t7e35+foiIiJGRkbW1tbu7u8LC
wsbGxt3d3fv7+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEA
ABIALAAAAAAQABAAAAVCoCSOZGmeJXQYbOsajpgAdG3ThYgAS+P/PwBBB3igIkKi8YQcSnZLU1N5
TD6LVSc0SwwIvmCwlTEIm78KlHrNZocAADs=
"

image create photo CtxmenuPoly
CtxmenuPoly put "
R0lGODlhEAAQAPUAAAAAAAUFBQsLCw0NDRERERUVFRsbGxwcHCMjIyUlJSgoKCwsLD09PUdHR09P
T1JSUlRUVF1dXWhoaG1tbXV1dXl5eX5+foCAgIiIiJWVlZ2dnaioqKysrLW1tbi4uMLCwsfHx8rK
ytPT09fX19ra2uDg4Orq6uzs7PLy8vb29vv7+wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACsALAAAAAAQABAAAAaVwJVQ
6CkNj8hVCOBIOhmAgcp55ACuoWOqciAJVQnABYAZehBXkRADmJgAjZUpcgUkhCcCwbRaCDIDdhIA
FmtkQhNXAhYqEABqK4MjQh0ADF4oAndCDwAnKkZeQhuEQwwBKQwCKEedkCsJBQ5XIEMmAgpHBFeB
GiYZDQGlX1cLlQV1BhMnQyh2JifCCBS1SR98Kx+vSUEAOw==
"

image create photo CtxmenuArc
CtxmenuArc put "
R0lGODlhEAAQAPUAAAAAAAQEBAsLCwwMDBAQECsrKywsLDAwMDw8PEFBQUdHR0tLS1lZWW1tbX5+
foWFhYmJiZGRkZ6enqOjo6ysrLe3t76+vsrKytDQ0NTU1NnZ2ejo6Ovr6+3t7fPz8/T09Pv7+wAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACEALAAAAAAQABAAAAZTwFDn
sTAcFA5MaMlcQgDQKGChaS45EszHk4kUAAKKdbyMCABistUiGFTVTQlAAbcmAJc6swJo6JcgBAV/
SwgAIIQMAByJi4QIAYQhAgaSDROSTEEAOw==
"

image create photo CtxmenuCircle
CtxmenuCircle put "
R0lGODlhEAAQAPUAAAAAAAQEBA4ODhERERUVFRsbGykpKS4uLjQ0NDo6Oj4+Pk9PT1BQUFpaWl9f
X2NjY2lpaW5ubnBwcH5+foGBgYeHh46OjpCQkJeXl5mZmZ+fn6KiorCwsLm5ucHBwdLS0tXV1djY
2OHh4eTk5O/v7/T09Pr6+gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAACcALAAAAAAQABAAAAZ+wJNw
+NloPMPksHMAOAEEjVKYcSomFEYAAFF6AoNOEmQAXJIIAFIpGgxIwg9gMRVSANITBrCpn0AAD3Zq
fiVzQhYAHH4jAA1CHQASfhsAFUImBAIjUyZNIUMXAAlwQyYOAA5KCwAFFx8gG00GpaYRW09ztUog
EwsLEmt+w0JBADs=
"

image create photo CtxmenuText
CtxmenuText put "
R0lGODlhEAAQAPQAAAAAAB4eHjMzMzU1NURERElJSVRUVFVVVXt7e4aGhoqKipOTk5mZmZ6enqCg
oLKyssLCwszMzM/Pz9LS0tjY2N3d3eDg4Obm5unp6e7u7vLy8gAAAAAAAAAAAAAAAAAAACH5BAEA
ABsALAAAAAAQABAAAAVN4CaOZDlGaIqZ4gK8cMBu02HfyqyzmKIkwJ8wYRkpYEgkYqRxMJ5QaCOz
00EGgqwgoXMkDztNZkzdWSroNHpFYiSTD1KEQK/XC5TqLAQAOw==
"

