set(program_name go)
set(program_version 1.21.1)
set(brew_package_name "go")
set(apt_package_name "golang-go")
if(CMAKE_HOST_WIN32)
    if(DEFINED ENV{PROCESSOR_ARCHITEW6432})
        set(build_arch $ENV{PROCESSOR_ARCHITEW6432})
    else()
        set(build_arch $ENV{PROCESSOR_ARCHITECTURE})
    endif()
    if(build_arch MATCHES "^(ARM|arm)64$")
        set(tool_subdirectory ${program_version}.windows-arm64)
        set(download_sha512 cb4bdb042cc773df049e63ba2ef1f93f4da23671e3b233af0a8e5898090659ba9ec6a2d98765e586716e52746288c8723f4eb5b8ed8d49e8c9110b32fe6e7ec7)
    elseif(build_arch MATCHES "^(AMD|amd)64$")
        set(tool_subdirectory ${program_version}.windows-amd64)
        set(download_sha512 c2bf18a8018fab79fbc1dde904d1f7341ab360aec4cd1256bdd3913e5b83cbaf664101b1768e21f17d0fad859cad53a62d37074e0e458f02ee76f4bf4d6810b9)
    else()
        # Default to x86 for 32-bit systems
        set(tool_subdirectory ${program_version}.windows-386)
        set(download_sha512 417a4bd95a10f21c2166badd2303e1956d91d0e783e334c99ea0176a323e815729c8c3af3f7ec68f057b757d06bcc75be82584031c4069c89a2db62bbfa902e8)
    endif()
    set(paths_to_search "${DOWNLOADS}/tools/go/${tool_subdirectory}/go/bin")
    set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.zip")
    set(download_filename "go${tool_subdirectory}.zip")
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Darwin")
    vcpkg_execute_in_download_mode(COMMAND "uname" "-m" OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH MATCHES "x86_64|amd64|AMD64")
        set(tool_subdirectory ${program_version}.darwin-amd64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 101f5b3682cb18fea222387427937784447f5f0b748749707e5158ea15e4c3e66d94a7af20470e405e804d46b19a981dcdeaa210881cbe7845b308e806a8b3f9)
    elseif(HOST_ARCH MATCHES "arm64|aarch64|ARM64|AARCH64")
        set(tool_subdirectory ${program_version}.darwin-arm64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 a7ee818bc2853a4d385620823a4dd6d9ca44f3ad1d111783648817e82a3ef4b65edc9f06aeba893ae7d6b44773234ba78eb975f0222eed5eae4d10b029cec78a)
    endif()
    set(paths_to_search "${DOWNLOADS}/tools/go/${tool_subdirectory}/go/bin")
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux")
    vcpkg_execute_in_download_mode(COMMAND "uname" "-m" OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH MATCHES "x86_64|amd64|AMD64")
        set(tool_subdirectory ${program_version}.linux-amd64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 4567eefb6c5c524c37543c2d9813d792c2f71c8c2feeda51728a7d8dcf630cc1c6a8932df7d50df53d8f923db46cea3db386caba40e9b3401554a3734a94c9b6)
    elseif(HOST_ARCH MATCHES "arm64|aarch64|ARM64|AARCH64")
        set(tool_subdirectory ${program_version}.linux-arm64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 3dec6cbd87253a7fbd5fd8b533f53a7f5a6f1e92a77c5ca270cd3e790b4b45dbdb1512945c521c927f36c5198e2cb4726b29ef94fffe4714918526790efee570)
    endif()
    set(paths_to_search "${DOWNLOADS}/tools/go/${tool_subdirectory}/go/bin")
else()
    message(WARNING "Unsupported host system for prebuilt Go binaries. Skipping...")
endif()
