vcpkg_from_sourceforge(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO half/half
    REF ${VERSION}
    FILENAME "half-${VERSION}.zip"
    NO_REMOVE_ONE_LEVEL
    SHA512 946b1663a736eb486f670ba9dfcc56b43b9e7fb195988174b7dd004bdd2e23aba7a395b8867b4f58c97e73a50edf845b703b8cfc35708a562e6a9d7e1b4f4204
)

file(GLOB HEADER_FILES "${SOURCE_PATH}/include/*.hpp")
file(COPY ${HEADER_FILES} DESTINATION "${CURRENT_PACKAGES_DIR}/include")

file(INSTALL "${CMAKE_CURRENT_LIST_DIR}/usage" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}")
vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE.txt")
